///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef X2P_PDFCANVAS
#define X2P_PDFCANVAS
// See canvas.hh for discussion
#include <iostream>
#include "canvas.hh"
#include <ps/pdf.h>

namespace xml2ps {
class PDFCanvas : public Canvas {
public:
  PDFCanvas(std::streambuf* buf, 
	    const PageVec& pages,
	   bool allow_extra_pages);
  virtual ~PDFCanvas();
  
  virtual void newPage();

  void setgray(float gray);
  void setfont(const font::FontInfo& font);
  void moveto(float hpos, float vpos);
  void moverel(float dx, float dy);
  
  void show(const Glib::ustring& text);
  void whitespace(const float& space);
  
  void underlineFrom(const float& below);
  void underlineTo(const float& below, const float& thickness);
  
  void line(float x1, float y1, float x2, float y2);
  
private:
  std::ostream out;
  PDF::Document document;
};
};
#endif
