/* rygel-media-export-root-container.c generated by valac, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER (rygel_media_export_dynamic_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER, RygelMediaExportDynamicContainer))
#define RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER, RygelMediaExportDynamicContainerClass))
#define RYGEL_IS_MEDIA_EXPORT_DYNAMIC_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER))
#define RYGEL_IS_MEDIA_EXPORT_DYNAMIC_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER, RygelMediaExportDynamicContainerClass))

typedef struct _RygelMediaExportDynamicContainer RygelMediaExportDynamicContainer;
typedef struct _RygelMediaExportDynamicContainerClass RygelMediaExportDynamicContainerClass;
typedef struct _RygelMediaExportDynamicContainerPrivate RygelMediaExportDynamicContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_IS_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER))
#define RYGEL_IS_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_TYPE_MEDIA_EXPORT_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_IS_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_HARVESTER))
#define RYGEL_IS_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;

#define RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_IS_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR))
#define RYGEL_IS_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;

#define RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_IS_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE))
#define RYGEL_IS_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

struct _RygelMediaExportDynamicContainer {
	RygelMediaDBContainer parent_instance;
	RygelMediaExportDynamicContainerPrivate * priv;
};

struct _RygelMediaExportDynamicContainerClass {
	RygelMediaDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainer {
	RygelMediaDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMetadataExtractor* extractor;
	GeeHashMap* harvester;
	RygelMediaExportRecursiveFileMonitor* monitor;
	RygelMediaExportDBusService* service;
	RygelMediaExportDynamicContainer* dynamic_elements;
};


static gpointer rygel_media_export_dynamic_container_parent_class = NULL;
static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static gpointer rygel_media_export_root_container_parent_class = NULL;

GType rygel_media_export_dynamic_container_get_type (void);
enum  {
	RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_ID "DynamicContainerId"
RygelMediaExportDynamicContainer* rygel_media_export_dynamic_container_new (RygelMediaDB* media_db, RygelMediaContainer* parent);
RygelMediaExportDynamicContainer* rygel_media_export_dynamic_container_construct (GType object_type, RygelMediaDB* media_db, RygelMediaContainer* parent);
GeeList* rygel_media_export_dynamic_container_get_uris (RygelMediaExportDynamicContainer* self);
GType rygel_media_export_root_container_get_type (void);
GType rygel_media_export_harvester_get_type (void);
GType rygel_media_export_recursive_file_monitor_get_type (void);
GType rygel_media_export_dbus_service_get_type (void);
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (RygelMediaDB* db);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, RygelMediaDB* db);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void);
RygelMediaContainer* rygel_media_export_root_container_get_instance (void);
static void rygel_media_export_root_container_harvest (RygelMediaExportRootContainer* self, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_root_container_on_file_changed (RygelMediaExportRootContainer* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
static void rygel_media_export_root_container_on_file_harvested (RygelMediaExportRootContainer* self, GFile* file);
RygelMediaExportHarvester* rygel_media_export_harvester_new (RygelMediaContainer* parent, RygelMediaDB* media_db, RygelMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, RygelMediaContainer* parent, RygelMediaDB* media_db, RygelMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor);
static void _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self);
void rygel_media_export_harvester_harvest (RygelMediaExportHarvester* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_harvester_harvest_finish (RygelMediaExportHarvester* self, GAsyncResult* _res_);
static void rygel_media_export_root_container_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 26 "rygel-media-export-root-container.vala"
RygelMediaExportDynamicContainer* rygel_media_export_dynamic_container_construct (GType object_type, RygelMediaDB* media_db, RygelMediaContainer* parent) {
#line 180 "rygel-media-export-root-container.c"
	RygelMediaExportDynamicContainer * self;
#line 26 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 26 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 28 "rygel-media-export-root-container.vala"
	self = (RygelMediaExportDynamicContainer*) rygel_media_db_container_construct (object_type, media_db, RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_ID, "Dynamic");
#line 29 "rygel-media-export-root-container.vala"
	((RygelMediaObject*) self)->parent = parent;
#line 190 "rygel-media-export-root-container.c"
	return self;
}


#line 26 "rygel-media-export-root-container.vala"
RygelMediaExportDynamicContainer* rygel_media_export_dynamic_container_new (RygelMediaDB* media_db, RygelMediaContainer* parent) {
#line 26 "rygel-media-export-root-container.vala"
	return rygel_media_export_dynamic_container_construct (RYGEL_TYPE_MEDIA_EXPORT_DYNAMIC_CONTAINER, media_db, parent);
#line 199 "rygel-media-export-root-container.c"
}


#line 32 "rygel-media-export-root-container.vala"
GeeList* rygel_media_export_dynamic_container_get_uris (RygelMediaExportDynamicContainer* self) {
#line 205 "rygel-media-export-root-container.c"
	GeeList* result;
	GError * _inner_error_;
	GeeArrayList* _result_;
#line 32 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 211 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 33 "rygel-media-export-root-container.vala"
	_result_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 215 "rygel-media-export-root-container.c"
	{
		GeeArrayList* children;
#line 36 "rygel-media-export-root-container.vala"
		children = rygel_media_db_get_children (((RygelMediaDBContainer*) self)->media_db, ((RygelMediaObject*) self)->id, (glong) (-1), (glong) (-1), &_inner_error_);
#line 220 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 37 "rygel-media-export-root-container.vala"
		if (children != NULL) {
#line 230 "rygel-media-export-root-container.c"
			{
				GeeIterator* _child_it;
				_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) children);
#line 38 "rygel-media-export-root-container.vala"
				while (TRUE) {
#line 236 "rygel-media-export-root-container.c"
					RygelMediaObject* child;
#line 38 "rygel-media-export-root-container.vala"
					if (!gee_iterator_next (_child_it)) {
#line 38 "rygel-media-export-root-container.vala"
						break;
#line 242 "rygel-media-export-root-container.c"
					}
#line 38 "rygel-media-export-root-container.vala"
					child = (RygelMediaObject*) gee_iterator_get (_child_it);
#line 39 "rygel-media-export-root-container.vala"
					gee_abstract_collection_add_all ((GeeAbstractCollection*) _result_, (GeeCollection*) child->uris);
#line 248 "rygel-media-export-root-container.c"
					_g_object_unref0 (child);
				}
				_g_object_unref0 (_child_it);
			}
		}
		_g_object_unref0 (children);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (GeeList*) _result_;
#line 44 "rygel-media-export-root-container.vala"
	return result;
#line 276 "rygel-media-export-root-container.c"
}


static void rygel_media_export_dynamic_container_class_init (RygelMediaExportDynamicContainerClass * klass) {
	rygel_media_export_dynamic_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_export_dynamic_container_instance_init (RygelMediaExportDynamicContainer * self) {
}


GType rygel_media_export_dynamic_container_get_type (void) {
	static GType rygel_media_export_dynamic_container_type_id = 0;
	if (rygel_media_export_dynamic_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDynamicContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_dynamic_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDynamicContainer), 0, (GInstanceInitFunc) rygel_media_export_dynamic_container_instance_init, NULL };
		rygel_media_export_dynamic_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_DB_CONTAINER, "RygelMediaExportDynamicContainer", &g_define_type_info, 0);
	}
	return rygel_media_export_dynamic_container_type_id;
}


#line 60 "rygel-media-export-root-container.vala"
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self) {
#line 301 "rygel-media-export-root-container.c"
	GeeArrayList* result;
	GError * _inner_error_;
	GeeArrayList* uris;
	RygelMetaConfig* config;
	GeeList* dbus_uris;
#line 60 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 309 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	uris = NULL;
#line 63 "rygel-media-export-root-container.vala"
	config = rygel_meta_config_get_default ();
#line 314 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
#line 66 "rygel-media-export-root-container.vala"
		_tmp0_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
#line 320 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			_g_object_unref0 (uris);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 66 "rygel-media-export-root-container.vala"
		uris = (_tmp1_ = _tmp0_, _g_object_unref0 (uris), _tmp1_);
#line 331 "rygel-media-export-root-container.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp2_;
#line 68 "rygel-media-export-root-container.vala"
			uris = (_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (uris), _tmp2_);
#line 343 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (uris);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 72 "rygel-media-export-root-container.vala"
	if (gee_collection_get_size ((GeeCollection*) uris) == 0) {
#line 357 "rygel-media-export-root-container.c"
		char* uri;
		char* _tmp3_;
		char* _tmp4_;
#line 73 "rygel-media-export-root-container.vala"
		g_debug ("rygel-media-export-root-container.vala:73: Nothing configured, using XDG special directories");
#line 74 "rygel-media-export-root-container.vala"
		uri = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_MUSIC));
#line 75 "rygel-media-export-root-container.vala"
		if (uri != NULL) {
#line 76 "rygel-media-export-root-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) uris, uri);
#line 369 "rygel-media-export-root-container.c"
		}
#line 78 "rygel-media-export-root-container.vala"
		uri = (_tmp3_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_PICTURES)), _g_free0 (uri), _tmp3_);
#line 79 "rygel-media-export-root-container.vala"
		if (uri != NULL) {
#line 80 "rygel-media-export-root-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) uris, uri);
#line 377 "rygel-media-export-root-container.c"
		}
#line 82 "rygel-media-export-root-container.vala"
		uri = (_tmp4_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS)), _g_free0 (uri), _tmp4_);
#line 83 "rygel-media-export-root-container.vala"
		if (uri != NULL) {
#line 84 "rygel-media-export-root-container.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) uris, uri);
#line 385 "rygel-media-export-root-container.c"
		}
		_g_free0 (uri);
	}
#line 87 "rygel-media-export-root-container.vala"
	dbus_uris = rygel_media_export_dynamic_container_get_uris (self->priv->dynamic_elements);
#line 88 "rygel-media-export-root-container.vala"
	if (dbus_uris != NULL) {
#line 89 "rygel-media-export-root-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) uris, (GeeCollection*) dbus_uris);
#line 395 "rygel-media-export-root-container.c"
	}
	result = uris;
	_g_object_unref0 (config);
	_g_object_unref0 (dbus_uris);
#line 92 "rygel-media-export-root-container.vala"
	return result;
#line 402 "rygel-media-export-root-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 95 "rygel-media-export-root-container.vala"
RygelMediaContainer* rygel_media_export_root_container_get_instance (void) {
#line 413 "rygel-media-export-root-container.c"
	RygelMediaContainer* result;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 96 "rygel-media-export-root-container.vala"
	if (rygel_media_export_root_container_instance == NULL) {
#line 419 "rygel-media-export-root-container.c"
		{
			RygelMediaDB* db;
			RygelMediaContainer* _tmp0_;
#line 98 "rygel-media-export-root-container.vala"
			db = rygel_media_db_create ("media-export", &_inner_error_);
#line 425 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR) {
					goto __catch2_rygel_media_db_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
#line 99 "rygel-media-export-root-container.vala"
			rygel_media_export_root_container_instance = (_tmp0_ = (RygelMediaContainer*) rygel_media_export_root_container_new (db), _g_object_unref0 (rygel_media_export_root_container_instance), _tmp0_);
#line 436 "rygel-media-export-root-container.c"
			_g_object_unref0 (db);
		}
		goto __finally2;
		__catch2_rygel_media_db_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				RygelMediaContainer* _tmp1_;
#line 102 "rygel-media-export-root-container.vala"
				g_warning ("rygel-media-export-root-container.vala:102: Failed to create instance of database");
#line 103 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_instance = (_tmp1_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (rygel_media_export_root_container_instance), _tmp1_);
#line 451 "rygel-media-export-root-container.c"
				_g_error_free0 (err);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (rygel_media_export_root_container_instance);
#line 107 "rygel-media-export-root-container.vala"
	return result;
#line 465 "rygel-media-export-root-container.c"
}


#line 110 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 471 "rygel-media-export-root-container.c"
	GFile* file;
#line 110 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 110 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 111 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 112 "rygel-media-export-root-container.vala"
	rygel_media_export_root_container_harvest (self, file, (RygelMediaContainer*) self->priv->dynamic_elements);
#line 481 "rygel-media-export-root-container.c"
	_g_object_unref0 (file);
}


#line 115 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 488 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	GFile* file;
	char* _tmp0_;
	char* _tmp1_;
	char* id;
#line 115 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 115 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 498 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 116 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 117 "rygel-media-export-root-container.vala"
	id = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (file), -1), _g_free0 (_tmp0_), _tmp1_);
#line 504 "rygel-media-export-root-container.c"
	{
#line 121 "rygel-media-export-root-container.vala"
		rygel_media_db_remove_by_id (((RygelMediaDBContainer*) self)->media_db, id, &_inner_error_);
#line 508 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			_g_object_unref0 (file);
			_g_free0 (id);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 123 "rygel-media-export-root-container.vala"
			g_warning ("rygel-media-export-root-container.vala:123: Failed to remove uri: %s", e->message);
#line 527 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (id);
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


#line 127 "rygel-media-export-root-container.vala"
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
#line 556 "rygel-media-export-root-container.c"
	char** result;
	char** _tmp0_;
	gint _result__size;
	gint _result__length1;
	char** _result_;
	GeeList* dynamic_uris;
	char** _tmp1_;
#line 127 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 566 "rygel-media-export-root-container.c"
	_result_ = (_tmp0_ = g_new0 (char*, 0 + 1), _result__length1 = 0, _result__size = _result__length1, _tmp0_);
#line 129 "rygel-media-export-root-container.vala"
	dynamic_uris = rygel_media_export_dynamic_container_get_uris (self->priv->dynamic_elements);
#line 570 "rygel-media-export-root-container.c"
	{
		GeeIterator* _uri_it;
		_uri_it = gee_iterable_iterator ((GeeIterable*) dynamic_uris);
#line 133 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 576 "rygel-media-export-root-container.c"
			char* uri;
#line 133 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 133 "rygel-media-export-root-container.vala"
				break;
#line 582 "rygel-media-export-root-container.c"
			}
#line 133 "rygel-media-export-root-container.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 134 "rygel-media-export-root-container.vala"
			_vala_array_add1 (&_result_, &_result__length1, &_result__size, g_strdup (uri));
#line 588 "rygel-media-export-root-container.c"
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	result = (_tmp1_ = _result_, *result_length1 = _result__length1, _tmp1_);
	_g_object_unref0 (dynamic_uris);
#line 137 "rygel-media-export-root-container.vala"
	return result;
#line 597 "rygel-media-export-root-container.c"
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dynamic_uris);
}


#line 236 "rygel-media-export-root-container.vala"
static void _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 605 "rygel-media-export-root-container.c"
	rygel_media_export_root_container_on_file_changed (self, file, other_file, event_type);
}


#line 144 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, RygelMediaDB* db) {
#line 612 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	RygelMediaExportRootContainer * self;
	RygelMetadataExtractor* _tmp0_;
	GeeHashMap* _tmp1_;
	RygelMediaExportRecursiveFileMonitor* _tmp2_;
	RygelMediaExportDynamicContainer* _tmp5_;
	GeeArrayList* ids;
	GeeArrayList* uris;
#line 144 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (db != NULL, NULL);
#line 623 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 145 "rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) rygel_media_db_container_construct (object_type, db, "0", "MediaExportRoot");
#line 147 "rygel-media-export-root-container.vala"
	self->priv->extractor = (_tmp0_ = rygel_metadata_extractor_create (), _g_object_unref0 (self->priv->extractor), _tmp0_);
#line 149 "rygel-media-export-root-container.vala"
	self->priv->harvester = (_tmp1_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_TYPE_MEDIA_EXPORT_HARVESTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_hash, g_file_equal, NULL), _g_object_unref0 (self->priv->harvester), _tmp1_);
#line 152 "rygel-media-export-root-container.vala"
	self->priv->monitor = (_tmp2_ = rygel_media_export_recursive_file_monitor_new (NULL), _g_object_unref0 (self->priv->monitor), _tmp2_);
#line 153 "rygel-media-export-root-container.vala"
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _rygel_media_export_root_container_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 635 "rygel-media-export-root-container.c"
	{
		RygelMediaExportDBusService* _tmp3_;
		RygelMediaExportDBusService* _tmp4_;
#line 156 "rygel-media-export-root-container.vala"
		_tmp3_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
#line 641 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 156 "rygel-media-export-root-container.vala"
		self->priv->service = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->service), _tmp4_);
#line 650 "rygel-media-export-root-container.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 158 "rygel-media-export-root-container.vala"
			g_warning ("rygel-media-export-root-container.vala:158: Failed to create MediaExport DBus service: %s", err->message);
#line 661 "rygel-media-export-root-container.c"
			_g_error_free0 (err);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 161 "rygel-media-export-root-container.vala"
	self->priv->dynamic_elements = (_tmp5_ = rygel_media_export_dynamic_container_new (db, (RygelMediaContainer*) self), _g_object_unref0 (self->priv->dynamic_elements), _tmp5_);
#line 673 "rygel-media-export-root-container.c"
	{
		gint64 timestamp = 0LL;
		gboolean _tmp6_;
		gboolean _tmp7_;
#line 165 "rygel-media-export-root-container.vala"
		_tmp6_ = rygel_media_db_exists (((RygelMediaDBContainer*) self)->media_db, "0", &timestamp, &_inner_error_);
#line 680 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 165 "rygel-media-export-root-container.vala"
		if (!_tmp6_) {
#line 166 "rygel-media-export-root-container.vala"
			rygel_media_db_save_object (((RygelMediaDBContainer*) self)->media_db, (RygelMediaObject*) self, &_inner_error_);
#line 691 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
#line 169 "rygel-media-export-root-container.vala"
		_tmp7_ = rygel_media_db_exists (((RygelMediaDBContainer*) self)->media_db, "DynamicContainerId", &timestamp, &_inner_error_);
#line 701 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 169 "rygel-media-export-root-container.vala"
		if (!_tmp7_) {
#line 170 "rygel-media-export-root-container.vala"
			rygel_media_db_save_object (((RygelMediaDBContainer*) self)->media_db, (RygelMediaObject*) self->priv->dynamic_elements, &_inner_error_);
#line 712 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	ids = NULL;
	{
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
#line 178 "rygel-media-export-root-container.vala"
		_tmp8_ = rygel_media_db_get_child_ids (((RygelMediaDBContainer*) self)->media_db, "0", &_inner_error_);
#line 743 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch6_rygel_database_error;
			}
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 178 "rygel-media-export-root-container.vala"
		ids = (_tmp9_ = _tmp8_, _g_object_unref0 (ids), _tmp9_);
#line 755 "rygel-media-export-root-container.c"
	}
	goto __finally6;
	__catch6_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp10_;
#line 180 "rygel-media-export-root-container.vala"
			ids = (_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (ids), _tmp10_);
#line 767 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ids);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 183 "rygel-media-export-root-container.vala"
	uris = rygel_media_export_root_container_get_uris (self);
#line 780 "rygel-media-export-root-container.c"
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) uris);
#line 184 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 786 "rygel-media-export-root-container.c"
			char* uri;
			GFile* file;
#line 184 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 184 "rygel-media-export-root-container.vala"
				break;
#line 793 "rygel-media-export-root-container.c"
			}
#line 184 "rygel-media-export-root-container.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 185 "rygel-media-export-root-container.vala"
			file = g_file_new_for_commandline_arg (uri);
#line 186 "rygel-media-export-root-container.vala"
			if (g_file_query_exists (file, NULL)) {
#line 801 "rygel-media-export-root-container.c"
				char* _tmp11_;
				char* _tmp12_;
				char* id;
#line 187 "rygel-media-export-root-container.vala"
				id = (_tmp12_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp11_ = g_file_get_uri (file), -1), _g_free0 (_tmp11_), _tmp12_);
#line 189 "rygel-media-export-root-container.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) ids, id);
#line 190 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_harvest (self, file, self);
#line 811 "rygel-media-export-root-container.c"
				_g_free0 (id);
			}
			_g_free0 (uri);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_uri_it);
	}
	{
		GeeIterator* _id_it;
		_id_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ids);
#line 194 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 824 "rygel-media-export-root-container.c"
			char* id;
#line 194 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_id_it)) {
#line 194 "rygel-media-export-root-container.vala"
				break;
#line 830 "rygel-media-export-root-container.c"
			}
#line 194 "rygel-media-export-root-container.vala"
			id = (char*) gee_iterator_get (_id_it);
#line 195 "rygel-media-export-root-container.vala"
			if (_vala_strcmp0 (id, RYGEL_MEDIA_EXPORT_DYNAMIC_CONTAINER_ID) == 0) {
#line 836 "rygel-media-export-root-container.c"
				_g_free0 (id);
#line 196 "rygel-media-export-root-container.vala"
				continue;
#line 840 "rygel-media-export-root-container.c"
			}
#line 198 "rygel-media-export-root-container.vala"
			g_debug ("rygel-media-export-root-container.vala:198: Id %s no longer in config, deleting...", id);
#line 844 "rygel-media-export-root-container.c"
			{
#line 201 "rygel-media-export-root-container.vala"
				rygel_media_db_remove_by_id (((RygelMediaDBContainer*) self)->media_db, id, &_inner_error_);
#line 848 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch7_rygel_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_it);
					_g_object_unref0 (ids);
					_g_object_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally7;
			__catch7_rygel_database_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
#line 203 "rygel-media-export-root-container.vala"
					g_warning ("rygel-media-export-root-container.vala:203: Failed to remove entry: %s", e->message);
#line 871 "rygel-media-export-root-container.c"
					_g_error_free0 (e);
				}
			}
			__finally7:
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				_g_object_unref0 (_id_it);
				_g_object_unref0 (ids);
				_g_object_unref0 (uris);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
#line 207 "rygel-media-export-root-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 891 "rygel-media-export-root-container.c"
	_g_object_unref0 (ids);
	_g_object_unref0 (uris);
	return self;
}


#line 144 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (RygelMediaDB* db) {
#line 144 "rygel-media-export-root-container.vala"
	return rygel_media_export_root_container_construct (RYGEL_TYPE_MEDIA_EXPORT_ROOT_CONTAINER, db);
#line 902 "rygel-media-export-root-container.c"
}


#line 210 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_on_file_harvested (RygelMediaExportRootContainer* self, GFile* file) {
#line 210 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 210 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 211 "rygel-media-export-root-container.vala"
	gee_map_remove ((GeeMap*) self->priv->harvester, file, NULL);
#line 914 "rygel-media-export-root-container.c"
}


#line 210 "rygel-media-export-root-container.vala"
static void _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested (RygelMediaExportHarvester* _sender, GFile* file, gpointer self) {
#line 920 "rygel-media-export-root-container.c"
	rygel_media_export_root_container_on_file_harvested (self, file);
}


#line 214 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_harvest (RygelMediaExportRootContainer* self, GFile* file, RygelMediaContainer* parent) {
#line 927 "rygel-media-export-root-container.c"
	gboolean _tmp0_ = FALSE;
#line 214 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 214 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 214 "rygel-media-export-root-container.vala"
	g_return_if_fail (parent != NULL);
#line 215 "rygel-media-export-root-container.vala"
	if (self->priv->extractor == NULL) {
#line 216 "rygel-media-export-root-container.vala"
		g_warning ("rygel-media-export-root-container.vala:216: No Metadata extractor available. Will not crawl");
#line 217 "rygel-media-export-root-container.vala"
		return;
#line 941 "rygel-media-export-root-container.c"
	}
#line 220 "rygel-media-export-root-container.vala"
	if (self->priv->extractor != NULL) {
#line 221 "rygel-media-export-root-container.vala"
		_tmp0_ = !gee_map_contains ((GeeMap*) self->priv->harvester, file);
#line 947 "rygel-media-export-root-container.c"
	} else {
#line 220 "rygel-media-export-root-container.vala"
		_tmp0_ = FALSE;
#line 951 "rygel-media-export-root-container.c"
	}
#line 220 "rygel-media-export-root-container.vala"
	if (_tmp0_) {
#line 955 "rygel-media-export-root-container.c"
		RygelMediaExportHarvester* harvester;
#line 222 "rygel-media-export-root-container.vala"
		harvester = rygel_media_export_harvester_new (parent, ((RygelMediaDBContainer*) self)->media_db, self->priv->extractor, self->priv->monitor);
#line 226 "rygel-media-export-root-container.vala"
		g_signal_connect_object (harvester, "harvested", (GCallback) _rygel_media_export_root_container_on_file_harvested_rygel_media_export_harvester_harvested, self, 0);
#line 227 "rygel-media-export-root-container.vala"
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->harvester, file, harvester);
#line 228 "rygel-media-export-root-container.vala"
		rygel_media_export_harvester_harvest (harvester, file, NULL, NULL);
#line 965 "rygel-media-export-root-container.c"
		_g_object_unref0 (harvester);
	} else {
		char* _tmp1_;
#line 230 "rygel-media-export-root-container.vala"
		g_warning ("%s already scheduled for harvesting. Check config " "for duplicates.", _tmp1_ = g_file_get_uri (file));
#line 971 "rygel-media-export-root-container.c"
		_g_free0 (_tmp1_);
	}
}


#line 236 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_on_file_changed (RygelMediaExportRootContainer* self, GFile* file, GFile* other, GFileMonitorEvent event) {
#line 979 "rygel-media-export-root-container.c"
	GError * _inner_error_;
#line 236 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 236 "rygel-media-export-root-container.vala"
	g_return_if_fail (file != NULL);
#line 985 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 239 "rygel-media-export-root-container.vala"
	switch (event) {
#line 989 "rygel-media-export-root-container.c"
		case G_FILE_MONITOR_EVENT_CREATED:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			GFile* parent;
			char* _tmp0_;
			char* _tmp1_;
			char* id;
			RygelMediaObject* parent_container;
#line 242 "rygel-media-export-root-container.vala"
			parent = g_file_get_parent (file);
#line 243 "rygel-media-export-root-container.vala"
			id = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_ = g_file_get_uri (parent), -1), _g_free0 (_tmp0_), _tmp1_);
#line 245 "rygel-media-export-root-container.vala"
			parent_container = rygel_media_db_get_object (((RygelMediaDBContainer*) self)->media_db, id, &_inner_error_);
#line 1004 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 246 "rygel-media-export-root-container.vala"
			if (parent_container != NULL) {
#line 247 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_harvest (self, file, RYGEL_MEDIA_CONTAINER (parent_container));
#line 1016 "rygel-media-export-root-container.c"
			} else {
#line 249 "rygel-media-export-root-container.vala"
				g_assert_not_reached ();
#line 1020 "rygel-media-export-root-container.c"
			}
			_g_object_unref0 (parent);
			_g_free0 (id);
			_g_object_unref0 (parent_container);
#line 251 "rygel-media-export-root-container.vala"
			break;
#line 1027 "rygel-media-export-root-container.c"
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			char* _tmp2_;
			char* _tmp3_;
			char* id;
			RygelMediaObject* obj;
#line 253 "rygel-media-export-root-container.vala"
			id = (_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_ = g_file_get_uri (file), -1), _g_free0 (_tmp2_), _tmp3_);
#line 258 "rygel-media-export-root-container.vala"
			obj = rygel_media_db_get_object (((RygelMediaDBContainer*) self)->media_db, id, &_inner_error_);
#line 1039 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				_g_free0 (id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 262 "rygel-media-export-root-container.vala"
			if (obj != NULL) {
#line 263 "rygel-media-export-root-container.vala"
				rygel_media_db_remove_object (((RygelMediaDBContainer*) self)->media_db, obj, &_inner_error_);
#line 1050 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					_g_free0 (id);
					_g_object_unref0 (obj);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 264 "rygel-media-export-root-container.vala"
				if (obj->parent != NULL) {
#line 265 "rygel-media-export-root-container.vala"
					rygel_media_container_updated (obj->parent);
#line 1062 "rygel-media-export-root-container.c"
				}
			}
			_g_free0 (id);
			_g_object_unref0 (obj);
#line 268 "rygel-media-export-root-container.vala"
			break;
#line 1069 "rygel-media-export-root-container.c"
		}
		default:
		{
#line 270 "rygel-media-export-root-container.vala"
			break;
#line 1075 "rygel-media-export-root-container.c"
		}
	}
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER (obj);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->dynamic_elements);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


GType rygel_media_export_root_container_get_type (void) {
	static GType rygel_media_export_root_container_type_id = 0;
	if (rygel_media_export_root_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
	}
	return rygel_media_export_root_container_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




