/* DataSource.c generated by valac 0.32.1, the Vala compiler
 * generated from DataSource.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* DataSource*/
/* */
/* A DataSource is an object that is unique throughout the system.  DataSources*/
/* commonly have external and/or persistent representations, hence they have a notion of being*/
/* destroyed (versus removed or freed).  Several DataViews may exist that reference a single*/
/* DataSource.  Note that DataSources MUST be destroyed (rather than simply removed) from their*/
/* SourceCollection, and that they MUST be destroyed via their SourceCollection (rather than*/
/* calling DataSource.destroy() directly.)*/
/**/
/* Destroying a DataSource indicates it should remove all secondary and tertiary structures (such*/
/* as thumbnails) and any records pointing to its backing store.  SourceCollection.destroy_marked()*/
/* has a parameter indicating if the backing should be destroyed as well; that is when*/
/* internal_delete_backing() is called.*/
/**/
/* There are no provisions (currently) for a DataSource to be removed from its SourceCollection*/
/* without destroying its backing and/or secondary and tertiary structures.  DataSources are intended*/
/* to go to the grave with their SourceCollection otherwise.  If a need arises for a DataSource to*/
/* be peaceably removed from its SourceCollection, code will need to be written.  SourceSnapshots*/
/* may be one solution to this problem.*/
/**/
/* Some DataSources cannot be reconstituted (for example, if its backing file is deleted).  In*/
/* that case, dehydrate() should return null.  When reconstituted, it is the responsibility of the*/
/* implementation to ensure an exact clone is produced, minus any details that are not relevant or*/
/* exposed (such as a database ID).*/
/**/
/* If other DataSources refer to this DataSource, their state will *not* be */
/* saved/restored.  This must be achieved via other means.  However, implementations *should**/
/* track when changes to external state would break the proxy and call notify_broken();*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SourceSnapshotPrivate SourceSnapshotPrivate;
typedef struct _ParamSpecSourceSnapshot ParamSpecSourceSnapshot;
typedef struct _SourceBacklinkPrivate SourceBacklinkPrivate;
typedef struct _ParamSpecSourceBacklink ParamSpecSourceBacklink;

#define TYPE_SOURCE_PROXY (source_proxy_get_type ())
#define SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_PROXY, SourceProxy))
#define SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_PROXY, SourceProxyClass))
#define IS_SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_PROXY))
#define IS_SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_PROXY))
#define SOURCE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_PROXY, SourceProxyClass))

typedef struct _SourceProxy SourceProxy;
typedef struct _SourceProxyClass SourceProxyClass;
typedef struct _SourceProxyPrivate SourceProxyPrivate;
#define _source_snapshot_unref0(var) ((var == NULL) ? NULL : (var = (source_snapshot_unref (var), NULL)))
typedef struct _ParamSpecSourceProxy ParamSpecSourceProxy;

#define TYPE_PROXYABLE (proxyable_get_type ())
#define PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROXYABLE, Proxyable))
#define IS_PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROXYABLE))
#define PROXYABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROXYABLE, ProxyableIface))

typedef struct _Proxyable Proxyable;
typedef struct _ProxyableIface ProxyableIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _DataSourcePrivate {
	DataView** subscribers;
	gint subscribers_length1;
	gint _subscribers_size_;
	SourceHoldingTank* holding_tank;
	SourceCollection* unlinked_from_collection;
	GeeHashMap* backlinks;
	gboolean in_contact;
	gboolean marked_for_destroy;
	gboolean is_destroyed;
};

typedef void (*DataSourceContactSubscriber) (DataView* view, void* user_data);
typedef void (*DataSourceContactSubscriberAlteration) (DataView* view, Alteration* alteration, void* user_data);
struct _SourceSnapshot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceSnapshotPrivate * priv;
};

struct _SourceSnapshotClass {
	GTypeClass parent_class;
	void (*finalize) (SourceSnapshot *self);
	void (*notify_broken) (SourceSnapshot* self);
	void (*broken) (SourceSnapshot* self);
};

struct _SourceSnapshotPrivate {
	gboolean snapshot_broken;
};

struct _ParamSpecSourceSnapshot {
	GParamSpec parent_instance;
};

struct _SourceBacklink {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceBacklinkPrivate * priv;
};

struct _SourceBacklinkClass {
	GTypeClass parent_class;
	void (*finalize) (SourceBacklink *self);
};

struct _SourceBacklinkPrivate {
	gchar* _name;
	gchar* _value;
};

struct _ParamSpecSourceBacklink {
	GParamSpec parent_instance;
};

struct _SourceProxy {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceProxyPrivate * priv;
};

struct _SourceProxyClass {
	GTypeClass parent_class;
	void (*finalize) (SourceProxy *self);
	DataSource* (*reconstitute) (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
	void (*notify_reconstituted) (SourceProxy* self, DataSource* source);
	void (*notify_dehydrated) (SourceProxy* self);
	void (*notify_broken) (SourceProxy* self);
	void (*reconstituted) (SourceProxy* self, DataSource* source);
	void (*dehydrated) (SourceProxy* self);
	void (*broken) (SourceProxy* self);
};

struct _SourceProxyPrivate {
	gint64 object_id;
	gchar* source_string;
	DataSource* source;
	SourceSnapshot* snapshot;
	SourceCollection* membership;
};

struct _ParamSpecSourceProxy {
	GParamSpec parent_instance;
};

struct _ProxyableIface {
	GTypeInterface parent_iface;
	SourceProxy* (*get_proxy) (Proxyable* self);
};


static gpointer data_source_parent_class = NULL;
static gpointer source_snapshot_parent_class = NULL;
static gpointer source_backlink_parent_class = NULL;
static gpointer source_proxy_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
#define DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_SOURCE, DataSourcePrivate))
enum  {
	DATA_SOURCE_DUMMY_PROPERTY
};
DataSource* data_source_construct (GType object_type, gint64 object_id);
DataObject* data_object_construct (GType object_type, gint64 object_id);
static void data_source_real_notify_membership_changed (DataObject* base, DataCollection* collection);
void data_source_notify_unlinked (DataSource* self);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
void data_source_notify_held_in_tank (DataSource* self, SourceHoldingTank* holding_tank);
static void data_source_real_notify_held_in_tank (DataSource* self, SourceHoldingTank* holding_tank);
DataCollection* data_object_get_membership (DataObject* self);
static void data_source_real_notify_altered (DataObject* base, Alteration* alteration);
void source_holding_tank_internal_notify_altered (SourceHoldingTank* self, DataSource* source, Alteration* alteration);
void data_source_contact_subscribers_alteration (DataSource* self, Alteration* alteration);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
void data_source_notify_unlinking (DataSource* self, SourceCollection* collection);
static void data_source_real_notify_unlinking (DataSource* self, SourceCollection* collection);
static void data_source_real_notify_unlinked (DataSource* self);
void data_source_commit_backlinks (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
static gchar* data_source_dehydrate_backlinks (DataSource* self);
void data_source_notify_relinking (DataSource* self, SourceCollection* collection);
static void data_source_real_notify_relinking (DataSource* self, SourceCollection* collection);
void data_source_notify_relinked (DataSource* self);
static void data_source_real_notify_relinked (DataSource* self);
gchar* data_source_get_typename (DataSource* self);
static gchar* data_source_real_get_typename (DataSource* self);
gint64 data_source_get_instance_id (DataSource* self);
static gint64 data_source_real_get_instance_id (DataSource* self);
gchar* data_source_get_source_id (DataSource* self);
static gchar* data_source_real_get_source_id (DataSource* self);
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
gboolean data_source_has_backlink (DataSource* self, SourceBacklink* backlink);
const gchar* source_backlink_get_name (SourceBacklink* self);
const gchar* source_backlink_get_value (SourceBacklink* self);
GeeList* data_source_get_backlinks (DataSource* self, const gchar* name);
SourceBacklink* source_backlink_new (const gchar* name, const gchar* value);
SourceBacklink* source_backlink_construct (GType object_type, const gchar* name, const gchar* value);
void data_source_set_backlink (DataSource* self, SourceBacklink* backlink);
void source_collection_internal_backlink_set (SourceCollection* self, DataSource* source, SourceBacklink* backlink);
gboolean data_source_remove_backlink (DataSource* self, SourceBacklink* backlink);
void source_collection_internal_backlink_removed (SourceCollection* self, DataSource* source, SourceBacklink* backlink);
static void data_source_real_commit_backlinks (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
gchar* data_object_to_string (DataObject* self);
gboolean is_string_empty (const gchar* s);
void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated);
SourceSnapshot* data_source_save_snapshot (DataSource* self);
static SourceSnapshot* data_source_real_save_snapshot (DataSource* self);
void data_source_internal_mark_for_destroy (DataSource* self);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
static gboolean data_source_real_internal_delete_backing (DataSource* self, GError** error);
gboolean data_source_equals (DataSource* self, DataSource* source);
static gboolean data_source_real_equals (DataSource* self, DataSource* source);
void data_source_destroy (DataSource* self);
static void data_source_real_destroy (DataSource* self);
void data_view_notify_unsubscribed (DataView* self, DataSource* source);
gboolean data_source_destroy_orphan (DataSource* self, gboolean delete_backing);
void source_collection_notify_unlinked_destroyed (SourceCollection* self, DataSource* unlinked);
void data_source_internal_subscribe (DataSource* self, DataView* view);
static void _vala_array_add121 (DataView*** array, int* length, int* size, DataView* value);
void data_source_internal_unsubscribe (DataSource* self, DataView* view);
void data_source_contact_subscribers (DataSource* self, DataSourceContactSubscriber contact_subscriber, void* contact_subscriber_target);
static void data_source_real_unlinked (DataSource* self, SourceCollection* sources);
static void g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void data_source_real_relinked (DataSource* self, SourceCollection* sources);
static void data_source_real_destroyed (DataSource* self);
static void data_source_finalize (GObject* obj);
#define SOURCE_SNAPSHOT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_SNAPSHOT, SourceSnapshotPrivate))
enum  {
	SOURCE_SNAPSHOT_DUMMY_PROPERTY
};
void source_snapshot_notify_broken (SourceSnapshot* self);
static void source_snapshot_real_notify_broken (SourceSnapshot* self);
gboolean source_snapshot_is_broken (SourceSnapshot* self);
SourceSnapshot* source_snapshot_construct (GType object_type);
static void source_snapshot_real_broken (SourceSnapshot* self);
static void source_snapshot_finalize (SourceSnapshot* obj);
#define SOURCE_BACKLINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_BACKLINK, SourceBacklinkPrivate))
enum  {
	SOURCE_BACKLINK_DUMMY_PROPERTY
};
static gboolean source_backlink_validate_name_value (const gchar* name, const gchar* value);
SourceBacklink* source_backlink_new_from_source (DataSource* source);
SourceBacklink* source_backlink_construct_from_source (GType object_type, DataSource* source);
gchar* source_backlink_to_string (SourceBacklink* self);
guint source_backlink_hash_func (SourceBacklink* backlink);
gboolean source_backlink_equal_func (SourceBacklink* alink, SourceBacklink* blink);
const gchar* source_backlink_get_typename (SourceBacklink* self);
gint64 source_backlink_get_instance_id (SourceBacklink* self);
static void source_backlink_finalize (SourceBacklink* obj);
gpointer source_proxy_ref (gpointer instance);
void source_proxy_unref (gpointer instance);
GParamSpec* param_spec_source_proxy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_proxy (GValue* value, gpointer v_object);
void value_take_source_proxy (GValue* value, gpointer v_object);
gpointer value_get_source_proxy (const GValue* value);
GType source_proxy_get_type (void) G_GNUC_CONST;
#define SOURCE_PROXY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_PROXY, SourceProxyPrivate))
enum  {
	SOURCE_PROXY_DUMMY_PROPERTY
};
static void source_proxy_drop_source (SourceProxy* self);
static void source_proxy_on_source_added (SourceProxy* self, GeeIterable* added);
static void _source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self);
SourceProxy* source_proxy_construct (GType object_type, DataSource* source);
gint64 data_object_get_object_id (DataObject* self);
static void source_proxy_on_snapshot_broken (SourceProxy* self);
static void _source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender, gpointer self);
static void source_proxy_set_source (SourceProxy* self, DataSource* source);
DataSource* source_proxy_reconstitute (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
static DataSource* source_proxy_real_reconstitute (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
void source_proxy_notify_reconstituted (SourceProxy* self, DataSource* source);
static void source_proxy_real_notify_reconstituted (SourceProxy* self, DataSource* source);
void source_proxy_notify_dehydrated (SourceProxy* self);
static void source_proxy_real_notify_dehydrated (SourceProxy* self);
void source_proxy_notify_broken (SourceProxy* self);
static void source_proxy_real_notify_broken (SourceProxy* self);
static void source_proxy_on_destroyed (SourceProxy* self);
static void _source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender, gpointer self);
DataSource* source_proxy_get_source (SourceProxy* self);
gboolean data_collection_contains (DataCollection* self, DataObject* object);
static void source_proxy_real_reconstituted (SourceProxy* self, DataSource* source);
static void source_proxy_real_dehydrated (SourceProxy* self);
static void source_proxy_real_broken (SourceProxy* self);
static void source_proxy_finalize (SourceProxy* obj);
GType proxyable_get_type (void) G_GNUC_CONST;
SourceProxy* proxyable_get_proxy (Proxyable* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DataSource* data_source_construct (GType object_type, gint64 object_id) {
	DataSource * self = NULL;
	gint64 _tmp0_ = 0LL;
#line 64 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = object_id;
#line 64 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (DataSource*) data_object_construct (object_type, _tmp0_);
#line 63 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 492 "DataSource.c"
}


static void data_source_real_notify_membership_changed (DataObject* base, DataCollection* collection) {
	DataSource * self;
	DataCollection* _tmp0_ = NULL;
	gboolean _tmp5_ = FALSE;
	DataCollection* _tmp6_ = NULL;
	DataCollection* _tmp8_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_SOURCE, DataSource);
#line 73 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 75 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = collection;
#line 75 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 510 "DataSource.c"
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->is_destroyed;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (_tmp2_) {
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 519 "DataSource.c"
		} else {
			GeeHashMap* _tmp3_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp3_ = self->priv->backlinks;
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = _tmp3_ != NULL;
#line 526 "DataSource.c"
		}
#line 76 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp1_, "is_destroyed || backlinks != null");
#line 530 "DataSource.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 78 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = self->priv->is_destroyed;
#line 78 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (!_tmp4_, "!is_destroyed");
#line 537 "DataSource.c"
	}
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = collection;
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ == NULL) {
#line 543 "DataSource.c"
		GeeHashMap* _tmp7_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = self->priv->backlinks;
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = _tmp7_ != NULL;
#line 549 "DataSource.c"
	} else {
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = FALSE;
#line 553 "DataSource.c"
	}
#line 82 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp5_) {
#line 83 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_notify_unlinked (self);
#line 559 "DataSource.c"
	}
#line 85 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = collection;
#line 85 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_OBJECT_CLASS (data_source_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp8_);
#line 565 "DataSource.c"
}


static gpointer _source_holding_tank_ref0 (gpointer self) {
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? source_holding_tank_ref (self) : NULL;
#line 572 "DataSource.c"
}


static void data_source_real_notify_held_in_tank (DataSource* self, SourceHoldingTank* holding_tank) {
	DataCollection* _tmp0_ = NULL;
	DataCollection* _tmp1_ = NULL;
	SourceHoldingTank* _tmp2_ = NULL;
	SourceHoldingTank* _tmp5_ = NULL;
	SourceHoldingTank* _tmp6_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((holding_tank == NULL) || IS_SOURCE_HOLDING_TANK (holding_tank));
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp1_ == NULL, "get_membership() == null");
#line 90 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (_tmp1_);
#line 94 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = holding_tank;
#line 94 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp2_ != NULL) {
#line 596 "DataSource.c"
		SourceHoldingTank* _tmp3_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = self->priv->holding_tank;
#line 95 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp3_ == NULL, "this.holding_tank == null");
#line 602 "DataSource.c"
	} else {
		SourceHoldingTank* _tmp4_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = self->priv->holding_tank;
#line 97 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_vala_assert (_tmp4_ != NULL, "this.holding_tank != null");
#line 609 "DataSource.c"
	}
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = holding_tank;
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = _source_holding_tank_ref0 (_tmp5_);
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_holding_tank_unref0 (self->priv->holding_tank);
#line 100 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->holding_tank = _tmp6_;
#line 619 "DataSource.c"
}


void data_source_notify_held_in_tank (DataSource* self, SourceHoldingTank* holding_tank) {
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 88 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_held_in_tank (self, holding_tank);
#line 628 "DataSource.c"
}


static void data_source_real_notify_altered (DataObject* base, Alteration* alteration) {
	DataSource * self;
	SourceHoldingTank* _tmp0_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DATA_SOURCE, DataSource);
#line 103 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 105 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->holding_tank;
#line 105 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ != NULL) {
#line 643 "DataSource.c"
		SourceHoldingTank* _tmp1_ = NULL;
		Alteration* _tmp2_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = self->priv->holding_tank;
#line 106 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = alteration;
#line 106 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_holding_tank_internal_notify_altered (_tmp1_, self, _tmp2_);
#line 652 "DataSource.c"
	} else {
		Alteration* _tmp3_ = NULL;
		Alteration* _tmp4_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = alteration;
#line 108 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_contact_subscribers_alteration (self, _tmp3_);
#line 110 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = alteration;
#line 110 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		DATA_OBJECT_CLASS (data_source_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp4_);
#line 664 "DataSource.c"
	}
}


static void data_source_real_notify_unlinking (DataSource* self, SourceCollection* collection) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	SourceCollection* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ == NULL) {
#line 680 "DataSource.c"
		SourceCollection* _tmp2_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 686 "DataSource.c"
	} else {
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 690 "DataSource.c"
	}
#line 116 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "backlinks == null && unlinked_from_collection == null");
#line 118 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = collection;
#line 118 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = _tmp3_;
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 119 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = _tmp4_;
#line 704 "DataSource.c"
}


void data_source_notify_unlinking (DataSource* self, SourceCollection* collection) {
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 115 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_unlinking (self, collection);
#line 713 "DataSource.c"
}


static void data_source_real_notify_unlinked (DataSource* self) {
	gboolean _tmp0_ = FALSE;
	SourceCollection* _tmp1_ = NULL;
	SourceCollection* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->unlinked_from_collection;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 728 "DataSource.c"
		GeeHashMap* _tmp2_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->backlinks;
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 734 "DataSource.c"
	} else {
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 738 "DataSource.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "unlinked_from_collection != null && backlinks != null");
#line 126 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = self->priv->unlinked_from_collection;
#line 126 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "unlinked", _tmp3_);
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = self->priv->backlinks;
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MAP, GeeMap));
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = _tmp5_;
#line 129 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ > 0) {
#line 754 "DataSource.c"
		SourceCollection* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = self->priv->unlinked_from_collection;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = data_source_dehydrate_backlinks (self);
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data_source_commit_backlinks (self, _tmp7_, _tmp9_);
#line 130 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp9_);
#line 768 "DataSource.c"
	}
}


void data_source_notify_unlinked (DataSource* self) {
#line 123 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 123 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_unlinked (self);
#line 778 "DataSource.c"
}


static void data_source_real_notify_relinking (DataSource* self, SourceCollection* collection) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 791 "DataSource.c"
		SourceCollection* _tmp2_ = NULL;
		SourceCollection* _tmp3_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = collection;
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ == _tmp3_;
#line 800 "DataSource.c"
	} else {
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 804 "DataSource.c"
	}
#line 135 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "(backlinks != null) && (unlinked_from_collection == collection)");
#line 808 "DataSource.c"
}


void data_source_notify_relinking (DataSource* self, SourceCollection* collection) {
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 134 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_relinking (self, collection);
#line 817 "DataSource.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? data_collection_ref (self) : NULL;
#line 824 "DataSource.c"
}


static void data_source_real_notify_relinked (DataSource* self) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	SourceCollection* relinked_to = NULL;
	SourceCollection* _tmp3_ = NULL;
	SourceCollection* _tmp4_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 838 "DataSource.c"
		SourceCollection* _tmp2_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->unlinked_from_collection;
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 844 "DataSource.c"
	} else {
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 848 "DataSource.c"
	}
#line 140 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "backlinks != null && unlinked_from_collection != null");
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = self->priv->unlinked_from_collection;
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _data_collection_ref0 (_tmp3_);
#line 142 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	relinked_to = _tmp4_;
#line 143 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 143 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = NULL;
#line 144 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = NULL;
#line 145 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "relinked", relinked_to);
#line 148 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_commit_backlinks (self, NULL, NULL);
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (relinked_to);
#line 870 "DataSource.c"
}


void data_source_notify_relinked (DataSource* self) {
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 139 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->notify_relinked (self);
#line 879 "DataSource.c"
}


static gchar* data_source_real_get_typename (DataSource* self) {
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `data_source_get_typename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 888 "DataSource.c"
}


gchar* data_source_get_typename (DataSource* self) {
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 156 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_typename (self);
#line 897 "DataSource.c"
}


static gint64 data_source_real_get_instance_id (DataSource* self) {
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `data_source_get_instance_id'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return 0LL;
#line 906 "DataSource.c"
}


gint64 data_source_get_instance_id (DataSource* self) {
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), 0LL);
#line 162 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_instance_id (self);
#line 915 "DataSource.c"
}


static gchar* data_source_real_get_source_id (DataSource* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = data_source_get_typename (self);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = data_source_get_instance_id (self);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", _tmp1_, _tmp2_);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _tmp3_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp1_);
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp4_;
#line 167 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 942 "DataSource.c"
}


gchar* data_source_get_source_id (DataSource* self) {
#line 166 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 166 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->get_source_id (self);
#line 951 "DataSource.c"
}


gboolean data_source_has_backlink (DataSource* self, SourceBacklink* backlink) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_ = NULL;
	SourceBacklink* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp7_ = NULL;
#line 170 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 170 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 171 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 171 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 172 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 172 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 978 "DataSource.c"
	}
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = backlink;
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = source_backlink_get_name (_tmp2_);
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _tmp3_;
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 174 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp5_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = values;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp7_ != NULL) {
#line 996 "DataSource.c"
		GeeList* _tmp8_ = NULL;
		SourceBacklink* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = values;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = backlink;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = source_backlink_get_value (_tmp9_);
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _tmp10_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = _tmp12_;
#line 1014 "DataSource.c"
	} else {
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = FALSE;
#line 1018 "DataSource.c"
	}
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp6_;
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 176 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1026 "DataSource.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self ? g_object_ref (self) : NULL;
#line 1033 "DataSource.c"
}


GeeList* data_source_get_backlinks (DataSource* self, const gchar* name) {
	GeeList* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp5_ = NULL;
	GeeList* backlinks = NULL;
	GeeArrayList* _tmp9_ = NULL;
#line 179 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 179 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 180 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 180 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 181 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 181 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1060 "DataSource.c"
	}
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = name;
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
#line 183 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp3_;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = values;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp5_ == NULL) {
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = TRUE;
#line 1076 "DataSource.c"
	} else {
		GeeList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = values;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = _tmp7_;
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _tmp8_ == 0;
#line 1089 "DataSource.c"
	}
#line 184 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp4_) {
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 185 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1099 "DataSource.c"
	}
#line 187 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = gee_array_list_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, source_backlink_unref, NULL, NULL, NULL);
#line 187 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	backlinks = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_LIST, GeeList);
#line 1105 "DataSource.c"
	{
		GeeList* _value_list = NULL;
		GeeList* _tmp10_ = NULL;
		GeeList* _tmp11_ = NULL;
		gint _value_size = 0;
		GeeList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _value_index = 0;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = values;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_list = _tmp11_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = _value_list;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp14_ = _tmp13_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_size = _tmp14_;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_value_index = -1;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 1133 "DataSource.c"
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gchar* value = NULL;
			GeeList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gpointer _tmp20_ = NULL;
			GeeList* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			SourceBacklink* _tmp24_ = NULL;
			SourceBacklink* _tmp25_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp15_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_value_index = _tmp15_ + 1;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp16_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp17_ = _value_size;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!(_tmp16_ < _tmp17_)) {
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 1158 "DataSource.c"
			}
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp18_ = _value_list;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp19_ = _value_index;
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp20_ = gee_list_get (_tmp18_, _tmp19_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			value = (gchar*) _tmp20_;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp21_ = backlinks;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp22_ = name;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp23_ = value;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp24_ = source_backlink_new (_tmp22_, _tmp23_);
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp25_ = _tmp24_;
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), _tmp25_);
#line 189 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_source_backlink_unref0 (_tmp25_);
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (value);
#line 1184 "DataSource.c"
		}
#line 188 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_value_list);
#line 1188 "DataSource.c"
	}
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = backlinks;
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 191 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1196 "DataSource.c"
}


void data_source_set_backlink (DataSource* self, SourceBacklink* backlink) {
	GeeHashMap* _tmp0_ = NULL;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_ = NULL;
	SourceBacklink* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GeeList* _tmp6_ = NULL;
	GeeList* _tmp13_ = NULL;
	SourceBacklink* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	SourceCollection* sources = NULL;
	DataCollection* _tmp17_ = NULL;
	SourceCollection* _tmp18_ = NULL;
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 196 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 196 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = backlink;
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = source_backlink_get_name (_tmp2_);
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _tmp3_;
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 198 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp5_;
#line 199 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = values;
#line 199 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ == NULL) {
#line 1240 "DataSource.c"
		GeeArrayList* _tmp7_ = NULL;
		GeeHashMap* _tmp8_ = NULL;
		SourceBacklink* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GeeList* _tmp12_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 200 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		values = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_LIST, GeeList);
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = self->priv->backlinks;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = backlink;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = source_backlink_get_name (_tmp9_);
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _tmp10_;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = values;
#line 201 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, _tmp12_);
#line 1265 "DataSource.c"
	}
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13_ = values;
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp14_ = backlink;
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp15_ = source_backlink_get_value (_tmp14_);
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp16_ = _tmp15_;
#line 204 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
#line 206 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp17_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 206 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 207 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp18_ = sources;
#line 207 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp18_ != NULL) {
#line 1285 "DataSource.c"
		SourceCollection* _tmp19_ = NULL;
		SourceBacklink* _tmp20_ = NULL;
#line 208 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp19_ = sources;
#line 208 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp20_ = backlink;
#line 208 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_internal_backlink_set (_tmp19_, self, _tmp20_);
#line 1294 "DataSource.c"
	}
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (sources);
#line 194 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 1300 "DataSource.c"
}


gboolean data_source_remove_backlink (DataSource* self, SourceBacklink* backlink) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GeeList* values = NULL;
	GeeHashMap* _tmp1_ = NULL;
	SourceBacklink* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GeeList* _tmp6_ = NULL;
	gint original_size = 0;
	GeeList* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GeeIterator* iter = NULL;
	GeeList* _tmp11_ = NULL;
	GeeIterator* _tmp12_ = NULL;
	GeeList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	SourceCollection* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	SourceCollection* sources = NULL;
	DataCollection* _tmp33_ = NULL;
	SourceCollection* _tmp34_ = NULL;
	GeeList* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
#line 211 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 211 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 212 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->backlinks;
#line 212 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 213 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 213 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1347 "DataSource.c"
	}
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = backlink;
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = source_backlink_get_name (_tmp2_);
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = _tmp3_;
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 215 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	values = (GeeList*) _tmp5_;
#line 216 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = values;
#line 216 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_ == NULL) {
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = FALSE;
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (values);
#line 217 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1371 "DataSource.c"
	}
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = values;
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = _tmp8_;
#line 219 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	original_size = _tmp9_;
#line 220 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp10_ = original_size;
#line 220 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp10_ > 0, "original_size > 0");
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = values;
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 222 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	iter = _tmp12_;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	while (TRUE) {
#line 1393 "DataSource.c"
		GeeIterator* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GeeIterator* _tmp15_ = NULL;
		gpointer _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		SourceBacklink* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp13_ = iter;
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp14_ = gee_iterator_next (_tmp13_);
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (!_tmp14_) {
#line 223 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			break;
#line 1411 "DataSource.c"
		}
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp15_ = iter;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp16_ = gee_iterator_get (_tmp15_);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp17_ = (gchar*) _tmp16_;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp18_ = backlink;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp19_ = source_backlink_get_value (_tmp18_);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp20_ = _tmp19_;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp21_ = g_strcmp0 (_tmp17_, _tmp20_) == 0;
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp17_);
#line 224 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (_tmp21_) {
#line 1431 "DataSource.c"
			GeeIterator* _tmp22_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp22_ = iter;
#line 225 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			gee_iterator_remove (_tmp22_);
#line 1437 "DataSource.c"
		}
	}
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp23_ = values;
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp25_ = _tmp24_;
#line 228 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp25_ == 0) {
#line 1448 "DataSource.c"
		GeeHashMap* _tmp26_ = NULL;
		SourceBacklink* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp26_ = self->priv->backlinks;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp27_ = backlink;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp28_ = source_backlink_get_name (_tmp27_);
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp29_ = _tmp28_;
#line 229 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp29_, NULL);
#line 1463 "DataSource.c"
	}
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp30_ = self->priv->unlinked_from_collection;
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp31_ = data_source_dehydrate_backlinks (self);
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp32_ = _tmp31_;
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_commit_backlinks (self, _tmp30_, _tmp32_);
#line 233 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp32_);
#line 235 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp33_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 235 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	sources = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 236 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp34_ = sources;
#line 236 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp34_ != NULL) {
#line 1483 "DataSource.c"
		SourceCollection* _tmp35_ = NULL;
		SourceBacklink* _tmp36_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp35_ = sources;
#line 237 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp36_ = backlink;
#line 237 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_internal_backlink_removed (_tmp35_, self, _tmp36_);
#line 1492 "DataSource.c"
	}
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp37_ = values;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp38_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection));
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp39_ = _tmp38_;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp40_ = original_size;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp39_ != _tmp40_;
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (sources);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (iter);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (values);
#line 239 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1512 "DataSource.c"
}


static void data_source_real_commit_backlinks (DataSource* self, SourceCollection* sources, const gchar* dehydrated) {
	gboolean _tmp0_ = FALSE;
	SourceCollection* _tmp1_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = sources;
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ != NULL) {
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = TRUE;
#line 1527 "DataSource.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = dehydrated;
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 1534 "DataSource.c"
	}
#line 249 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_) {
#line 1538 "DataSource.c"
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _tmp3_;
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_warning ("DataSource.vala:250: No implementation to commit link state for %s", _tmp4_);
#line 250 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_free0 (_tmp4_);
#line 1549 "DataSource.c"
	}
}


void data_source_commit_backlinks (DataSource* self, SourceCollection* sources, const gchar* dehydrated) {
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 248 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->commit_backlinks (self, sources, dehydrated);
#line 1559 "DataSource.c"
}


static gchar* data_source_dehydrate_backlinks (DataSource* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	const gchar* _tmp51_ = NULL;
	GString* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gchar* _tmp58_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->backlinks;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_ == NULL) {
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = TRUE;
#line 1583 "DataSource.c"
	} else {
		GeeHashMap* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = self->priv->backlinks;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MAP, GeeMap));
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp4_ == 0;
#line 1596 "DataSource.c"
	}
#line 254 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_) {
#line 255 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 255 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 1604 "DataSource.c"
	}
#line 257 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = g_string_new ("");
#line 257 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	builder = _tmp5_;
#line 1610 "DataSource.c"
	{
		GeeIterator* _name_it = NULL;
		GeeHashMap* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = self->priv->backlinks;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_MAP, GeeMap));
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = _tmp7_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _tmp10_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_tmp9_);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_name_it = _tmp11_;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 1637 "DataSource.c"
			GeeIterator* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gchar* name = NULL;
			GeeIterator* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			GeeList* values = NULL;
			GeeHashMap* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			GeeList* _tmp20_ = NULL;
			gchar* value_field = NULL;
			gchar* _tmp24_ = NULL;
			const gchar* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp12_ = _name_it;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp13_ = gee_iterator_next (_tmp12_);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!_tmp13_) {
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 1662 "DataSource.c"
			}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp14_ = _name_it;
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp15_ = gee_iterator_get (_tmp14_);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			name = (gchar*) _tmp15_;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp16_ = self->priv->backlinks;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp17_ = name;
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp18_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_);
#line 259 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			values = (GeeList*) _tmp18_;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp20_ = values;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp20_ == NULL) {
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp19_ = TRUE;
#line 1684 "DataSource.c"
			} else {
				GeeList* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp21_ = values;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp23_ = _tmp22_;
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp19_ = _tmp23_ == 0;
#line 1697 "DataSource.c"
			}
#line 260 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp19_) {
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (values);
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (name);
#line 261 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				continue;
#line 1707 "DataSource.c"
			}
#line 263 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp24_ = g_strdup ("");
#line 263 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			value_field = _tmp24_;
#line 1713 "DataSource.c"
			{
				GeeList* _value_list = NULL;
				GeeList* _tmp25_ = NULL;
				GeeList* _tmp26_ = NULL;
				gint _value_size = 0;
				GeeList* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _value_index = 0;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp25_ = values;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp26_ = _g_object_ref0 (_tmp25_);
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_list = _tmp26_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp27_ = _value_list;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp29_ = _tmp28_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_size = _tmp29_;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_value_index = -1;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				while (TRUE) {
#line 1741 "DataSource.c"
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					gchar* value = NULL;
					GeeList* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					gpointer _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gboolean _tmp37_ = FALSE;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp30_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_value_index = _tmp30_ + 1;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp31_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp32_ = _value_size;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					if (!(_tmp31_ < _tmp32_)) {
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						break;
#line 1763 "DataSource.c"
					}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp33_ = _value_list;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp34_ = _value_index;
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value = (gchar*) _tmp35_;
#line 265 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp36_ = value;
#line 265 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp37_ = is_string_empty (_tmp36_);
#line 265 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					if (!_tmp37_) {
#line 1779 "DataSource.c"
						const gchar* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp38_ = value_field;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp39_ = value;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp40_ = g_strconcat (_tmp39_, "|", NULL);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp41_ = _tmp40_;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_g_free0 (value_field);
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						value_field = _tmp42_;
#line 266 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_g_free0 (_tmp41_);
#line 1801 "DataSource.c"
					}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (value);
#line 1805 "DataSource.c"
				}
#line 264 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (_value_list);
#line 1809 "DataSource.c"
			}
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp43_ = value_field;
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp44_ = strlen (_tmp43_);
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp45_ = _tmp44_;
#line 269 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp45_ > 0) {
#line 1819 "DataSource.c"
				GString* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp46_ = builder;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp47_ = name;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp48_ = value_field;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp49_ = g_strdup_printf ("%s=%s\n", _tmp47_, _tmp48_);
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp50_ = _tmp49_;
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				g_string_append (_tmp46_, _tmp50_);
#line 270 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (_tmp50_);
#line 1839 "DataSource.c"
			}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (value_field);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_object_unref0 (values);
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (name);
#line 1847 "DataSource.c"
		}
#line 258 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_name_it);
#line 1851 "DataSource.c"
	}
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp52_ = builder;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp53_ = _tmp52_->str;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp54_ = strlen (_tmp53_);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp55_ = _tmp54_;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp55_ > 0) {
#line 1863 "DataSource.c"
		GString* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp56_ = builder;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp57_ = _tmp56_->str;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp51_ = _tmp57_;
#line 1872 "DataSource.c"
	} else {
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp51_ = NULL;
#line 1876 "DataSource.c"
	}
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp58_ = g_strdup (_tmp51_);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp58_;
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_string_free0 (builder);
#line 273 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 1886 "DataSource.c"
}


void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated) {
	SourceCollection* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** lines = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (unlinked_from));
#line 279 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = unlinked_from;
#line 279 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = _tmp0_;
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 280 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = _tmp1_;
#line 282 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = dehydrated;
#line 282 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp2_ == NULL) {
#line 283 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 1922 "DataSource.c"
	}
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = dehydrated;
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines = _tmp5_;
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines_length1 = _vala_array_length (_tmp4_);
#line 285 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_lines_size_ = lines_length1;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = lines;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6__length1 = lines_length1;
#line 1938 "DataSource.c"
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		line_collection = _tmp6_;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		line_collection_length1 = _tmp6__length1;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		for (line_it = 0; line_it < _tmp6__length1; line_it = line_it + 1) {
#line 1950 "DataSource.c"
			gchar* _tmp7_ = NULL;
			gchar* line = NULL;
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp7_ = g_strdup (line_collection[line_it]);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			line = _tmp7_;
#line 1957 "DataSource.c"
			{
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gchar** tokens = NULL;
				const gchar* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gchar** _tmp13_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gchar** decoded_values = NULL;
				gchar** _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				const gchar* _tmp19_ = NULL;
				gchar** _tmp20_ = NULL;
				gchar** _tmp21_ = NULL;
				gint decoded_values_length1 = 0;
				gint _decoded_values_size_ = 0;
				GeeList* values = NULL;
				GeeArrayList* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				GeeList* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp8_ = line;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp9_ = strlen (_tmp8_);
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp10_ = _tmp9_;
#line 287 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp10_ == 0) {
#line 288 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (line);
#line 288 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					continue;
#line 1997 "DataSource.c"
				}
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp11_ = line;
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "=", 2);
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens = _tmp13_;
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens_length1 = _vala_array_length (_tmp12_);
#line 290 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tokens_size_ = tokens_length1;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp14_ = tokens;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp14__length1 = tokens_length1;
#line 291 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp14__length1 < 2) {
#line 2015 "DataSource.c"
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp15_ = line;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp17_ = _tmp16_;
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					g_warning ("DataSource.vala:292: Unable to rehydrate \"%s\" for %s: name and value" \
" not present", _tmp15_, _tmp17_);
#line 292 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (_tmp17_);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_free0 (line);
#line 295 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					continue;
#line 2035 "DataSource.c"
				}
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp18_ = tokens;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp18__length1 = tokens_length1;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp19_ = _tmp18_[1];
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "|", 0);
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values = _tmp21_;
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values_length1 = _vala_array_length (_tmp20_);
#line 298 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_decoded_values_size_ = decoded_values_length1;
#line 299 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp22_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 299 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_LIST, GeeList);
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp23_ = decoded_values;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp23__length1 = decoded_values_length1;
#line 2059 "DataSource.c"
				{
					gchar** value_collection = NULL;
					gint value_collection_length1 = 0;
					gint _value_collection_size_ = 0;
					gint value_it = 0;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value_collection = _tmp23_;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					value_collection_length1 = _tmp23__length1;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					for (value_it = 0; value_it < _tmp23__length1; value_it = value_it + 1) {
#line 2071 "DataSource.c"
						gchar* _tmp24_ = NULL;
						gchar* value = NULL;
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						_tmp24_ = g_strdup (value_collection[value_it]);
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
						value = _tmp24_;
#line 2078 "DataSource.c"
						{
							gboolean _tmp25_ = FALSE;
							const gchar* _tmp26_ = NULL;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							_tmp26_ = value;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							if (_tmp26_ != NULL) {
#line 2086 "DataSource.c"
								const gchar* _tmp27_ = NULL;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp27_ = value;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp28_ = strlen (_tmp27_);
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp29_ = _tmp28_;
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp25_ = _tmp29_ > 0;
#line 2098 "DataSource.c"
							} else {
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp25_ = FALSE;
#line 2102 "DataSource.c"
							}
#line 301 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							if (_tmp25_) {
#line 2106 "DataSource.c"
								GeeList* _tmp30_ = NULL;
								const gchar* _tmp31_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp30_ = values;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								_tmp31_ = value;
#line 302 "/home/jens/Source/shotwell/src/core/DataSource.vala"
								gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp31_);
#line 2115 "DataSource.c"
							}
#line 300 "/home/jens/Source/shotwell/src/core/DataSource.vala"
							_g_free0 (value);
#line 2119 "DataSource.c"
						}
					}
				}
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp32_ = values;
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp33_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection));
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp34_ = _tmp33_;
#line 305 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp34_ > 0) {
#line 2131 "DataSource.c"
					GeeHashMap* _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gint _tmp36__length1 = 0;
					const gchar* _tmp37_ = NULL;
					GeeList* _tmp38_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp35_ = self->priv->backlinks;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp36_ = tokens;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp36__length1 = tokens_length1;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp37_ = _tmp36_[0];
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp38_ = values;
#line 306 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp37_, _tmp38_);
#line 2149 "DataSource.c"
				}
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (values);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				decoded_values = (_vala_array_free (decoded_values, decoded_values_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 286 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (line);
#line 2159 "DataSource.c"
			}
		}
	}
#line 278 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 2165 "DataSource.c"
}


static SourceSnapshot* data_source_real_save_snapshot (DataSource* self) {
	SourceSnapshot* result = NULL;
#line 312 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = NULL;
#line 312 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2175 "DataSource.c"
}


SourceSnapshot* data_source_save_snapshot (DataSource* self) {
#line 311 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), NULL);
#line 311 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->save_snapshot (self);
#line 2184 "DataSource.c"
}


void data_source_internal_mark_for_destroy (DataSource* self) {
#line 316 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 317 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->marked_for_destroy = TRUE;
#line 2193 "DataSource.c"
}


static gboolean data_source_real_internal_delete_backing (DataSource* self, GError** error) {
	gboolean result = FALSE;
#line 325 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = TRUE;
#line 325 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2203 "DataSource.c"
}


gboolean data_source_internal_delete_backing (DataSource* self, GError** error) {
#line 324 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 324 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->internal_delete_backing (self, error);
#line 2212 "DataSource.c"
}


static gboolean data_source_real_equals (DataSource* self, DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 331 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source;
#line 331 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = self == _tmp0_;
#line 331 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2227 "DataSource.c"
}


gboolean data_source_equals (DataSource* self, DataSource* source) {
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 330 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return DATA_SOURCE_GET_CLASS (self)->equals (self, source);
#line 2236 "DataSource.c"
}


static void data_source_real_destroy (DataSource* self) {
	gboolean _tmp0_ = FALSE;
#line 341 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->marked_for_destroy;
#line 341 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_, "marked_for_destroy");
#line 344 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->is_destroyed = TRUE;
#line 2248 "DataSource.c"
	{
		gint ctr = 0;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2253 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2260 "DataSource.c"
				gint _tmp3_ = 0;
				DataView** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				DataView** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				DataView* _tmp7_ = NULL;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2270 "DataSource.c"
					gint _tmp2_ = 0;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2276 "DataSource.c"
				}
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 347 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2290 "DataSource.c"
				}
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2302 "DataSource.c"
					DataView* view = NULL;
					DataView** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					DataView* _tmp10_ = NULL;
					DataView* _tmp11_ = NULL;
					DataView** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
					DataView* _tmp14_ = NULL;
					DataView* _tmp15_ = NULL;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 349 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					view = _tmp11_;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_ = self->priv->subscribers;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12__length1 = self->priv->subscribers_length1;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp13_ = ctr;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp12_[_tmp13_]);
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_[_tmp13_] = NULL;
#line 350 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 352 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp15_ = view;
#line 352 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					data_view_notify_unsubscribed (_tmp15_, self);
#line 348 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (view);
#line 2344 "DataSource.c"
				}
			}
		}
	}
#line 357 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "destroyed");
#line 2351 "DataSource.c"
}


void data_source_destroy (DataSource* self) {
#line 340 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 340 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	DATA_SOURCE_GET_CLASS (self)->destroy (self);
#line 2360 "DataSource.c"
}


gboolean data_source_destroy_orphan (DataSource* self, gboolean delete_backing) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SourceCollection* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 366 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (self), FALSE);
#line 367 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	ret = TRUE;
#line 368 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = delete_backing;
#line 368 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_) {
#line 2378 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp2_ = data_source_internal_delete_backing (self, &_inner_error_);
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = _tmp2_;
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2389 "DataSource.c"
				goto __catch47_g_error;
			}
#line 370 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			ret = _tmp1_;
#line 371 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp3_ = ret;
#line 371 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!_tmp3_) {
#line 2398 "DataSource.c"
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = _tmp4_;
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				g_warning ("DataSource.vala:372: Unable to delete backing for %s", _tmp5_);
#line 372 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_free0 (_tmp5_);
#line 2409 "DataSource.c"
			}
		}
		goto __finally47;
		__catch47_g_error:
		{
			GError* err = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			GError* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			err = _inner_error_;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_inner_error_ = NULL;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp6_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp7_ = _tmp6_;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp8_ = err;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp9_ = _tmp8_->message;
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_warning ("DataSource.vala:375: Unable to delete backing for %s: %s", _tmp7_, _tmp9_);
#line 375 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_free0 (_tmp7_);
#line 376 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			ret = FALSE;
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_error_free0 (err);
#line 2440 "DataSource.c"
		}
		__finally47:
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			g_clear_error (&_inner_error_);
#line 369 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return FALSE;
#line 2451 "DataSource.c"
		}
	}
#line 380 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_internal_mark_for_destroy (self);
#line 381 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_destroy (self);
#line 383 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp10_ = self->priv->unlinked_from_collection;
#line 383 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp10_ != NULL) {
#line 2462 "DataSource.c"
		SourceCollection* _tmp11_ = NULL;
#line 384 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = self->priv->unlinked_from_collection;
#line 384 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_collection_notify_unlinked_destroyed (_tmp11_, self);
#line 2468 "DataSource.c"
	}
#line 386 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = ret;
#line 386 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 2474 "DataSource.c"
}


static void _vala_array_add121 (DataView*** array, int* length, int* size, DataView* value) {
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if ((*length) == (*size)) {
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*array = g_renew (DataView*, *array, (*size) + 1);
#line 2485 "DataSource.c"
	}
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	(*array)[(*length)++] = value;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	(*array)[*length] = NULL;
#line 2491 "DataSource.c"
}


void data_source_internal_subscribe (DataSource* self, DataView* view) {
	gboolean _tmp0_ = FALSE;
	DataView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	DataView* _tmp14_ = NULL;
	DataView* _tmp15_ = NULL;
#line 395 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 395 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 396 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 396 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 2509 "DataSource.c"
	{
		gint ctr = 0;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2514 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2521 "DataSource.c"
				gint _tmp3_ = 0;
				DataView** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				DataView** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				DataView* _tmp7_ = NULL;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2531 "DataSource.c"
					gint _tmp2_ = 0;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2537 "DataSource.c"
				}
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 398 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2551 "DataSource.c"
				}
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 399 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ == NULL) {
#line 2563 "DataSource.c"
					DataView** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					DataView* _tmp10_ = NULL;
					DataView* _tmp11_ = NULL;
					DataView* _tmp12_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = view;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp8_[_tmp9_]);
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_[_tmp9_] = _tmp11_;
#line 400 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp12_ = _tmp8_[_tmp9_];
#line 402 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					return;
#line 2588 "DataSource.c"
				}
			}
		}
	}
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13_ = self->priv->subscribers;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13__length1 = self->priv->subscribers_length1;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp14_ = view;
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 406 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_array_add121 (&self->priv->subscribers, &self->priv->subscribers_length1, &self->priv->_subscribers_size_, _tmp15_);
#line 2603 "DataSource.c"
}


void data_source_internal_unsubscribe (DataSource* self, DataView* view) {
	gboolean _tmp0_ = FALSE;
#line 411 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 411 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 412 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 412 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 2617 "DataSource.c"
	{
		gint ctr = 0;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2622 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2629 "DataSource.c"
				gint _tmp3_ = 0;
				DataView** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				DataView** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				DataView* _tmp7_ = NULL;
				DataView* _tmp8_ = NULL;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2640 "DataSource.c"
					gint _tmp2_ = 0;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2646 "DataSource.c"
				}
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 414 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2660 "DataSource.c"
				}
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp8_ = view;
#line 415 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ == _tmp8_) {
#line 2674 "DataSource.c"
					DataView** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					DataView* _tmp11_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = self->priv->subscribers;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9__length1 = self->priv->subscribers_length1;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = ctr;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_g_object_unref0 (_tmp9_[_tmp10_]);
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_[_tmp10_] = NULL;
#line 416 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _tmp9_[_tmp10_];
#line 418 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					return;
#line 2693 "DataSource.c"
				}
			}
		}
	}
}


void data_source_contact_subscribers (DataSource* self, DataSourceContactSubscriber contact_subscriber, void* contact_subscriber_target) {
	gboolean _tmp0_ = FALSE;
#line 423 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 424 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 424 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 426 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = TRUE;
#line 2711 "DataSource.c"
	{
		gint ctr = 0;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2716 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2723 "DataSource.c"
				gint _tmp3_ = 0;
				DataView** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				DataView** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				DataView* _tmp7_ = NULL;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2733 "DataSource.c"
					gint _tmp2_ = 0;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2739 "DataSource.c"
				}
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 427 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2753 "DataSource.c"
				}
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 428 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2765 "DataSource.c"
					DataSourceContactSubscriber _tmp8_ = NULL;
					void* _tmp8__target = NULL;
					DataView** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					DataView* _tmp11_ = NULL;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = contact_subscriber;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__target = contact_subscriber_target;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = self->priv->subscribers;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9__length1 = self->priv->subscribers_length1;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = ctr;
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = _tmp9_[_tmp10_];
#line 429 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ (_tmp11_, _tmp8__target);
#line 2786 "DataSource.c"
				}
			}
		}
	}
#line 431 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 2793 "DataSource.c"
}


void data_source_contact_subscribers_alteration (DataSource* self, Alteration* alteration) {
	gboolean _tmp0_ = FALSE;
#line 434 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (self));
#line 434 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 435 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->in_contact;
#line 435 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (!_tmp0_, "!in_contact");
#line 437 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = TRUE;
#line 2809 "DataSource.c"
	{
		gint ctr = 0;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		ctr = 0;
#line 2814 "DataSource.c"
		{
			gboolean _tmp1_ = FALSE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp1_ = TRUE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			while (TRUE) {
#line 2821 "DataSource.c"
				gint _tmp3_ = 0;
				DataView** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				DataView** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				DataView* _tmp7_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!_tmp1_) {
#line 2831 "DataSource.c"
					gint _tmp2_ = 0;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp2_ = ctr;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					ctr = _tmp2_ + 1;
#line 2837 "DataSource.c"
				}
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp1_ = FALSE;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp3_ = ctr;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4_ = self->priv->subscribers;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp4__length1 = self->priv->subscribers_length1;
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 438 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					break;
#line 2851 "DataSource.c"
				}
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5_ = self->priv->subscribers;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp5__length1 = self->priv->subscribers_length1;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp6_ = ctr;
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 439 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				if (_tmp7_ != NULL) {
#line 2863 "DataSource.c"
					DataView** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					DataView* _tmp10_ = NULL;
					Alteration* _tmp11_ = NULL;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8_ = self->priv->subscribers;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp8__length1 = self->priv->subscribers_length1;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp9_ = ctr;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					_tmp11_ = alteration;
#line 440 "/home/jens/Source/shotwell/src/core/DataSource.vala"
					data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject), _tmp11_);
#line 2881 "DataSource.c"
				}
			}
		}
	}
#line 442 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 2888 "DataSource.c"
}


static void data_source_real_unlinked (DataSource* self, SourceCollection* sources) {
#line 51 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
#line 2895 "DataSource.c"
}


static void g_cclosure_user_marshal_VOID__DATA_COLLECTION (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DATA_COLLECTION) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DATA_COLLECTION callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (n_param_values == 2);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data1 = closure->data;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data2 = param_values->data[0].v_pointer;
#line 2914 "DataSource.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data1 = param_values->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		data2 = closure->data;
#line 2920 "DataSource.c"
	}
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	callback = (GMarshalFunc_VOID__DATA_COLLECTION) (marshal_data ? marshal_data : cc->callback);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	callback (data1, value_get_data_collection (param_values + 1), data2);
#line 2926 "DataSource.c"
}


static void data_source_real_relinked (DataSource* self, SourceCollection* sources) {
#line 55 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (sources));
#line 2933 "DataSource.c"
}


static void data_source_real_destroyed (DataSource* self) {
}


static void data_source_class_init (DataSourceClass * klass) {
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	data_source_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (DataSourcePrivate));
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataObjectClass *) klass)->notify_membership_changed = data_source_real_notify_membership_changed;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_held_in_tank = data_source_real_notify_held_in_tank;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataObjectClass *) klass)->notify_altered = data_source_real_notify_altered;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_unlinking = data_source_real_notify_unlinking;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_unlinked = data_source_real_notify_unlinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_relinking = data_source_real_notify_relinking;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->notify_relinked = data_source_real_notify_relinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_typename = data_source_real_get_typename;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_instance_id = data_source_real_get_instance_id;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->get_source_id = data_source_real_get_source_id;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->commit_backlinks = data_source_real_commit_backlinks;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->save_snapshot = data_source_real_save_snapshot;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->internal_delete_backing = data_source_real_internal_delete_backing;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->equals = data_source_real_equals;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->destroy = data_source_real_destroy;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->unlinked = data_source_real_unlinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->relinked = data_source_real_relinked;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((DataSourceClass *) klass)->destroyed = data_source_real_destroyed;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_OBJECT_CLASS (klass)->finalize = data_source_finalize;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("unlinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, unlinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("relinked", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, relinked), NULL, NULL, g_cclosure_user_marshal_VOID__DATA_COLLECTION, G_TYPE_NONE, 1, TYPE_SOURCE_COLLECTION);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("destroyed", TYPE_DATA_SOURCE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataSourceClass, destroyed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2990 "DataSource.c"
}


static void data_source_instance_init (DataSource * self) {
	DataView** _tmp0_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = DATA_SOURCE_GET_PRIVATE (self);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = g_new0 (DataView*, 4 + 1);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers = _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers_length1 = 4;
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_subscribers_size_ = self->priv->subscribers_length1;
#line 43 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->holding_tank = NULL;
#line 44 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->unlinked_from_collection = NULL;
#line 45 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->backlinks = NULL;
#line 46 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->in_contact = FALSE;
#line 47 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->marked_for_destroy = FALSE;
#line 48 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->is_destroyed = FALSE;
#line 3018 "DataSource.c"
}


static void data_source_finalize (GObject* obj) {
	DataSource * self;
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_SOURCE, DataSource);
#line 42 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->subscribers = (_vala_array_free (self->priv->subscribers, self->priv->subscribers_length1, (GDestroyNotify) g_object_unref), NULL);
#line 43 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_holding_tank_unref0 (self->priv->holding_tank);
#line 45 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 38 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_OBJECT_CLASS (data_source_parent_class)->finalize (obj);
#line 3034 "DataSource.c"
}


GType data_source_get_type (void) {
	static volatile gsize data_source_type_id__volatile = 0;
	if (g_once_init_enter (&data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataSource), 0, (GInstanceInitFunc) data_source_instance_init, NULL };
		GType data_source_type_id;
		data_source_type_id = g_type_register_static (TYPE_DATA_OBJECT, "DataSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&data_source_type_id__volatile, data_source_type_id);
	}
	return data_source_type_id__volatile;
}


static void source_snapshot_real_notify_broken (SourceSnapshot* self) {
#line 455 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot_broken = TRUE;
#line 457 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "broken");
#line 3055 "DataSource.c"
}


void source_snapshot_notify_broken (SourceSnapshot* self) {
#line 454 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_SNAPSHOT (self));
#line 454 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_SNAPSHOT_GET_CLASS (self)->notify_broken (self);
#line 3064 "DataSource.c"
}


gboolean source_snapshot_is_broken (SourceSnapshot* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 460 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_SNAPSHOT (self), FALSE);
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->snapshot_broken;
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 461 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3079 "DataSource.c"
}


SourceSnapshot* source_snapshot_construct (GType object_type) {
	SourceSnapshot* self = NULL;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceSnapshot*) g_type_create_instance (object_type);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3089 "DataSource.c"
}


static void source_snapshot_real_broken (SourceSnapshot* self) {
}


static void value_source_snapshot_init (GValue* value) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 3100 "DataSource.c"
}


static void value_source_snapshot_free_value (GValue* value) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (value->data[0].v_pointer);
#line 3109 "DataSource.c"
	}
}


static void value_source_snapshot_copy_value (const GValue* src_value, GValue* dest_value) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_snapshot_ref (src_value->data[0].v_pointer);
#line 3119 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3123 "DataSource.c"
	}
}


static gpointer value_source_snapshot_peek_pointer (const GValue* value) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3131 "DataSource.c"
}


static gchar* value_source_snapshot_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 3138 "DataSource.c"
		SourceSnapshot* object;
		object = collect_values[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3145 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3149 "DataSource.c"
		}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_snapshot_ref (object);
#line 3153 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3157 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3161 "DataSource.c"
}


static gchar* value_source_snapshot_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SourceSnapshot** object_p;
	object_p = collect_values[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3172 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 3178 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 3182 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_snapshot_ref (value->data[0].v_pointer);
#line 3186 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3190 "DataSource.c"
}


GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSourceSnapshot* spec;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_SNAPSHOT), NULL);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 3204 "DataSource.c"
}


gpointer value_get_source_snapshot (const GValue* value) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT), NULL);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3213 "DataSource.c"
}


void value_set_source_snapshot (GValue* value, gpointer v_object) {
	SourceSnapshot* old;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_ref (value->data[0].v_pointer);
#line 3233 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3237 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (old);
#line 3243 "DataSource.c"
	}
}


void value_take_source_snapshot (GValue* value, gpointer v_object) {
	SourceSnapshot* old;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_SNAPSHOT));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 3262 "DataSource.c"
	} else {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3266 "DataSource.c"
	}
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_snapshot_unref (old);
#line 3272 "DataSource.c"
	}
}


static void source_snapshot_class_init (SourceSnapshotClass * klass) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_snapshot_parent_class = g_type_class_peek_parent (klass);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->finalize = source_snapshot_finalize;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceSnapshotPrivate));
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->notify_broken = source_snapshot_real_notify_broken;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceSnapshotClass *) klass)->broken = source_snapshot_real_broken;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("broken", TYPE_SOURCE_SNAPSHOT, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceSnapshotClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3290 "DataSource.c"
}


static void source_snapshot_instance_init (SourceSnapshot * self) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_SNAPSHOT_GET_PRIVATE (self);
#line 447 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot_broken = FALSE;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 3301 "DataSource.c"
}


static void source_snapshot_finalize (SourceSnapshot* obj) {
	SourceSnapshot * self;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_SNAPSHOT, SourceSnapshot);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 3311 "DataSource.c"
}


GType source_snapshot_get_type (void) {
	static volatile gsize source_snapshot_type_id__volatile = 0;
	if (g_once_init_enter (&source_snapshot_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_snapshot_init, value_source_snapshot_free_value, value_source_snapshot_copy_value, value_source_snapshot_peek_pointer, "p", value_source_snapshot_collect_value, "p", value_source_snapshot_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceSnapshot), 0, (GInstanceInitFunc) source_snapshot_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_snapshot_type_id;
		source_snapshot_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceSnapshot", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_snapshot_type_id__volatile, source_snapshot_type_id);
	}
	return source_snapshot_type_id__volatile;
}


gpointer source_snapshot_ref (gpointer instance) {
	SourceSnapshot* self;
	self = instance;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 3336 "DataSource.c"
}


void source_snapshot_unref (gpointer instance) {
	SourceSnapshot* self;
	self = instance;
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_SNAPSHOT_GET_CLASS (self)->finalize (self);
#line 446 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3349 "DataSource.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1207 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1208 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1208 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1209 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1209 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1210 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _result_;
#line 1210 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 3373 "DataSource.c"
}


SourceBacklink* source_backlink_construct (GType object_type, const gchar* name, const gchar* value) {
	SourceBacklink* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceBacklink*) g_type_create_instance (object_type);
#line 499 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = name;
#line 499 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = value;
#line 499 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_validate_name_value (_tmp0_, _tmp1_);
#line 499 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp2_, "validate_name_value(name, value)");
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = name;
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 501 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_name = _tmp4_;
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = value;
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = string_strip (_tmp5_);
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 502 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_value = _tmp6_;
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3418 "DataSource.c"
}


SourceBacklink* source_backlink_new (const gchar* name, const gchar* value) {
#line 498 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return source_backlink_construct (TYPE_SOURCE_BACKLINK, name, value);
#line 3425 "DataSource.c"
}


SourceBacklink* source_backlink_construct_from_source (GType object_type, DataSource* source) {
	SourceBacklink* self = NULL;
	DataSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	DataSource* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceBacklink*) g_type_create_instance (object_type);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source;
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = data_source_get_typename (_tmp0_);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = _tmp1_;
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = string_strip (_tmp2_);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_name = _tmp3_;
#line 506 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp2_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = source;
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = data_source_get_instance_id (_tmp4_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = _tmp6_;
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = string_strip (_tmp7_);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->_value = _tmp8_;
#line 507 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (_tmp7_);
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = self->priv->_name;
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp10_ = self->priv->_value;
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = source_backlink_validate_name_value (_tmp9_, _tmp10_);
#line 509 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp11_, "validate_name_value(_name, _value)");
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 3487 "DataSource.c"
}


SourceBacklink* source_backlink_new_from_source (DataSource* source) {
#line 505 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return source_backlink_construct_from_source (TYPE_SOURCE_BACKLINK, source);
#line 3494 "DataSource.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 3514 "DataSource.c"
}


static gboolean source_backlink_validate_name_value (const gchar* name, const gchar* value) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 512 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 512 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = name;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = string_contains (_tmp2_, "=");
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!_tmp3_) {
#line 3534 "DataSource.c"
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = name;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp5_ = string_contains (_tmp4_, "|");
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = !_tmp5_;
#line 3543 "DataSource.c"
	} else {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = FALSE;
#line 3547 "DataSource.c"
	}
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_) {
#line 3551 "DataSource.c"
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp6_ = value;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = string_contains (_tmp6_, "|");
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = !_tmp7_;
#line 3560 "DataSource.c"
	} else {
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 3564 "DataSource.c"
	}
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 513 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3570 "DataSource.c"
}


gchar* source_backlink_to_string (SourceBacklink* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 516 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source_backlink_get_name (self);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _tmp0_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source_backlink_get_value (self);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = g_strdup_printf ("Backlink %s=%s", _tmp1_, _tmp3_);
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp4_;
#line 517 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3597 "DataSource.c"
}


guint source_backlink_hash_func (SourceBacklink* backlink) {
	guint result = 0U;
	GHashFunc _tmp0_ = NULL;
	SourceBacklink* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GHashFunc _tmp4_ = NULL;
	SourceBacklink* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
#line 520 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((backlink == NULL) || IS_SOURCE_BACKLINK (backlink), 0U);
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = g_str_hash;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = backlink;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = _tmp1_->priv->_name;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp0_ (_tmp2_);
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = g_str_hash;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = backlink;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = _tmp5_->priv->_value;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = _tmp4_ (_tmp6_);
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp3_ ^ _tmp7_;
#line 521 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3633 "DataSource.c"
}


gboolean source_backlink_equal_func (SourceBacklink* alink, SourceBacklink* blink) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GEqualFunc _tmp1_ = NULL;
	SourceBacklink* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	SourceBacklink* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 524 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((alink == NULL) || IS_SOURCE_BACKLINK (alink), FALSE);
#line 524 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail ((blink == NULL) || IS_SOURCE_BACKLINK (blink), FALSE);
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = g_str_equal;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = alink;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = _tmp2_->priv->_name;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = blink;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = _tmp4_->priv->_name;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = _tmp1_ (_tmp3_, _tmp5_);
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp6_) {
#line 3664 "DataSource.c"
		GEqualFunc _tmp7_ = NULL;
		SourceBacklink* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		SourceBacklink* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp7_ = g_str_equal;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp8_ = alink;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp9_ = _tmp8_->priv->_value;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = blink;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _tmp10_->priv->_value;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp12_ = _tmp7_ (_tmp9_, _tmp11_);
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = _tmp12_;
#line 3685 "DataSource.c"
	} else {
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp0_ = FALSE;
#line 3689 "DataSource.c"
	}
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 525 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3695 "DataSource.c"
}


const gchar* source_backlink_get_name (SourceBacklink* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 473 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_name;
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 474 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3710 "DataSource.c"
}


const gchar* source_backlink_get_value (SourceBacklink* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 479 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_value;
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 480 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3725 "DataSource.c"
}


const gchar* source_backlink_get_typename (SourceBacklink* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 486 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), NULL);
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_name;
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp0_;
#line 487 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3740 "DataSource.c"
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 679 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 680 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 680 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
#line 680 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 680 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 3758 "DataSource.c"
}


gint64 source_backlink_get_instance_id (SourceBacklink* self) {
	gint64 result;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 493 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (self), 0LL);
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->_value;
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = int64_parse (_tmp0_);
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp1_;
#line 494 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 3776 "DataSource.c"
}


static void value_source_backlink_init (GValue* value) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 3783 "DataSource.c"
}


static void value_source_backlink_free_value (GValue* value) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (value->data[0].v_pointer);
#line 3792 "DataSource.c"
	}
}


static void value_source_backlink_copy_value (const GValue* src_value, GValue* dest_value) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_backlink_ref (src_value->data[0].v_pointer);
#line 3802 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3806 "DataSource.c"
	}
}


static gpointer value_source_backlink_peek_pointer (const GValue* value) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3814 "DataSource.c"
}


static gchar* value_source_backlink_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 3821 "DataSource.c"
		SourceBacklink* object;
		object = collect_values[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3828 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3832 "DataSource.c"
		}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_backlink_ref (object);
#line 3836 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3840 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3844 "DataSource.c"
}


static gchar* value_source_backlink_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SourceBacklink** object_p;
	object_p = collect_values[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3855 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 3861 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 3865 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_backlink_ref (value->data[0].v_pointer);
#line 3869 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 3873 "DataSource.c"
}


GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSourceBacklink* spec;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_BACKLINK), NULL);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 3887 "DataSource.c"
}


gpointer value_get_source_backlink (const GValue* value) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK), NULL);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 3896 "DataSource.c"
}


void value_set_source_backlink (GValue* value, gpointer v_object) {
	SourceBacklink* old;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_ref (value->data[0].v_pointer);
#line 3916 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3920 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (old);
#line 3926 "DataSource.c"
	}
}


void value_take_source_backlink (GValue* value, gpointer v_object) {
	SourceBacklink* old;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_BACKLINK));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 3945 "DataSource.c"
	} else {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 3949 "DataSource.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_backlink_unref (old);
#line 3955 "DataSource.c"
	}
}


static void source_backlink_class_init (SourceBacklinkClass * klass) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_backlink_parent_class = g_type_class_peek_parent (klass);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceBacklinkClass *) klass)->finalize = source_backlink_finalize;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceBacklinkPrivate));
#line 3967 "DataSource.c"
}


static void source_backlink_instance_init (SourceBacklink * self) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_BACKLINK_GET_PRIVATE (self);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 3976 "DataSource.c"
}


static void source_backlink_finalize (SourceBacklink* obj) {
	SourceBacklink * self;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_BACKLINK, SourceBacklink);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 469 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_name);
#line 470 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->_value);
#line 3990 "DataSource.c"
}


GType source_backlink_get_type (void) {
	static volatile gsize source_backlink_type_id__volatile = 0;
	if (g_once_init_enter (&source_backlink_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_backlink_init, value_source_backlink_free_value, value_source_backlink_copy_value, value_source_backlink_peek_pointer, "p", value_source_backlink_collect_value, "p", value_source_backlink_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceBacklinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_backlink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceBacklink), 0, (GInstanceInitFunc) source_backlink_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_backlink_type_id;
		source_backlink_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceBacklink", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&source_backlink_type_id__volatile, source_backlink_type_id);
	}
	return source_backlink_type_id__volatile;
}


gpointer source_backlink_ref (gpointer instance) {
	SourceBacklink* self;
	self = instance;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 4015 "DataSource.c"
}


void source_backlink_unref (gpointer instance) {
	SourceBacklink* self;
	self = instance;
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_BACKLINK_GET_CLASS (self)->finalize (self);
#line 468 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4028 "DataSource.c"
	}
}


static void _source_proxy_on_source_added_data_collection_items_added (DataCollection* _sender, GeeIterable* added, gpointer self) {
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_source_added ((SourceProxy*) self, added);
#line 4036 "DataSource.c"
}


static void _source_proxy_on_snapshot_broken_source_snapshot_broken (SourceSnapshot* _sender, gpointer self) {
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_snapshot_broken ((SourceProxy*) self);
#line 4043 "DataSource.c"
}


SourceProxy* source_proxy_construct (GType object_type, DataSource* source) {
	SourceProxy* self = NULL;
	DataSource* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	DataSource* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	DataSource* _tmp4_ = NULL;
	SourceSnapshot* _tmp5_ = NULL;
	SourceSnapshot* _tmp6_ = NULL;
	SourceSnapshot* _tmp7_ = NULL;
	DataSource* _tmp8_ = NULL;
	DataSource* _tmp9_ = NULL;
	DataCollection* _tmp10_ = NULL;
	SourceCollection* _tmp11_ = NULL;
	SourceCollection* _tmp12_ = NULL;
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = (SourceProxy*) g_type_create_instance (object_type);
#line 572 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source;
#line 572 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 572 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->object_id = _tmp1_;
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source;
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp3_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->source_string);
#line 573 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source_string = _tmp3_;
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp4_ = source;
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = data_source_save_snapshot (_tmp4_);
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_snapshot_unref0 (self->priv->snapshot);
#line 575 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->snapshot = _tmp5_;
#line 576 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = self->priv->snapshot;
#line 576 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp6_ != NULL, "snapshot != null");
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = self->priv->snapshot;
#line 577 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (_tmp7_, "broken", (GCallback) _source_proxy_on_snapshot_broken_source_snapshot_broken, self);
#line 579 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = source;
#line 579 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_set_source (self, _tmp8_);
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = source;
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp10_ = data_object_get_membership (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (self->priv->membership);
#line 581 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->membership = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 582 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp11_ = self->priv->membership;
#line 582 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp11_ != NULL, "membership != null");
#line 583 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = self->priv->membership;
#line 583 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_COLLECTION, DataCollection), "items-added", (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
#line 571 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return self;
#line 4118 "DataSource.c"
}


static DataSource* source_proxy_real_reconstitute (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot) {
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_critical ("Type `%s' does not implement abstract method `source_proxy_reconstitute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4127 "DataSource.c"
}


DataSource* source_proxy_reconstitute (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot) {
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_PROXY (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return SOURCE_PROXY_GET_CLASS (self)->reconstitute (self, object_id, snapshot);
#line 4136 "DataSource.c"
}


static void source_proxy_real_notify_reconstituted (SourceProxy* self, DataSource* source) {
	DataSource* _tmp0_ = NULL;
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 594 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source;
#line 594 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "reconstituted", _tmp0_);
#line 4148 "DataSource.c"
}


void source_proxy_notify_reconstituted (SourceProxy* self, DataSource* source) {
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 593 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_reconstituted (self, source);
#line 4157 "DataSource.c"
}


static void source_proxy_real_notify_dehydrated (SourceProxy* self) {
#line 598 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "dehydrated");
#line 4164 "DataSource.c"
}


void source_proxy_notify_dehydrated (SourceProxy* self) {
#line 597 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 597 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_dehydrated (self);
#line 4173 "DataSource.c"
}


static void source_proxy_real_notify_broken (SourceProxy* self) {
#line 602 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_emit_by_name (self, "broken");
#line 4180 "DataSource.c"
}


void source_proxy_notify_broken (SourceProxy* self) {
#line 601 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 601 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	SOURCE_PROXY_GET_CLASS (self)->notify_broken (self);
#line 4189 "DataSource.c"
}


static void source_proxy_on_snapshot_broken (SourceProxy* self) {
#line 605 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 606 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 608 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_notify_broken (self);
#line 4200 "DataSource.c"
}


static void _source_proxy_on_destroyed_data_source_destroyed (DataSource* _sender, gpointer self) {
#line 615 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_on_destroyed ((SourceProxy*) self);
#line 4207 "DataSource.c"
}


static void source_proxy_set_source (SourceProxy* self, DataSource* source) {
	DataSource* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
#line 611 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 611 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 612 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = source;
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 614 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source = _tmp1_;
#line 615 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = source;
#line 615 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_connect (_tmp2_, "destroyed", (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
#line 4233 "DataSource.c"
}


static void source_proxy_drop_source (SourceProxy* self) {
	DataSource* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 618 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 619 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 619 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ == NULL) {
#line 620 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 4249 "DataSource.c"
	}
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = self->priv->source;
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_parse_name ("destroyed", TYPE_DATA_SOURCE, &_tmp2_, NULL, FALSE);
#line 622 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _source_proxy_on_destroyed_data_source_destroyed, self);
#line 623 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 623 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv->source = NULL;
#line 4261 "DataSource.c"
}


DataSource* source_proxy_get_source (SourceProxy* self) {
	DataSource* result = NULL;
	SourceSnapshot* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	DataSource* _tmp2_ = NULL;
	DataSource* new_source = NULL;
	gint64 _tmp5_ = 0LL;
	SourceSnapshot* _tmp6_ = NULL;
	DataSource* _tmp7_ = NULL;
	DataSource* _tmp8_ = NULL;
	DataSource* _tmp9_ = NULL;
	gint64 _tmp12_ = 0LL;
	DataSource* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	DataSource* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	gint64 _tmp19_ = 0LL;
	SourceCollection* _tmp20_ = NULL;
	DataSource* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	DataSource* _tmp23_ = NULL;
	DataSource* _tmp24_ = NULL;
#line 626 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_SOURCE_PROXY (self), NULL);
#line 627 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->snapshot;
#line 627 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp1_ = source_snapshot_is_broken (_tmp0_);
#line 627 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp1_) {
#line 628 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = NULL;
#line 628 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 4299 "DataSource.c"
	}
#line 630 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp2_ = self->priv->source;
#line 630 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp2_ != NULL) {
#line 4305 "DataSource.c"
		DataSource* _tmp3_ = NULL;
		DataSource* _tmp4_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp3_ = self->priv->source;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		result = _tmp4_;
#line 631 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return result;
#line 4316 "DataSource.c"
	}
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp5_ = self->priv->object_id;
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp6_ = self->priv->snapshot;
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp7_ = source_proxy_reconstitute (self, _tmp5_, _tmp6_);
#line 636 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	new_source = _tmp7_;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp8_ = self->priv->source;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp9_ = new_source;
#line 637 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp8_ != _tmp9_) {
#line 4332 "DataSource.c"
		DataSource* _tmp10_ = NULL;
		DataSource* _tmp11_ = NULL;
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp10_ = new_source;
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (self->priv->source);
#line 638 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		self->priv->source = _tmp11_;
#line 4343 "DataSource.c"
	}
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp12_ = self->priv->object_id;
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp13_ = self->priv->source;
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp14_ = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject));
#line 639 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp12_ != _tmp14_) {
#line 4353 "DataSource.c"
		DataSource* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 640 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp15_ = new_source;
#line 640 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp16_ = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_OBJECT, DataObject));
#line 640 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		self->priv->object_id = _tmp16_;
#line 4362 "DataSource.c"
	}
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp17_ = self->priv->source;
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp18_ = data_object_get_object_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject));
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp19_ = self->priv->object_id;
#line 641 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp18_ == _tmp19_, "source.get_object_id() == object_id");
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp20_ = self->priv->membership;
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp21_ = self->priv->source;
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp22_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
#line 642 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp22_, "membership.contains(source)");
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp23_ = self->priv->source;
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	result = _tmp24_;
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (new_source);
#line 644 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return result;
#line 4390 "DataSource.c"
}


static void source_proxy_on_destroyed (SourceProxy* self) {
	DataSource* _tmp0_ = NULL;
#line 647 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 648 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 648 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_vala_assert (_tmp0_ != NULL, "source != null");
#line 651 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 653 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_notify_dehydrated (self);
#line 4406 "DataSource.c"
}


static void source_proxy_on_source_added (SourceProxy* self, GeeIterable* added) {
	DataSource* _tmp0_ = NULL;
#line 656 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_SOURCE_PROXY (self));
#line 656 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 658 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->source;
#line 658 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (_tmp0_ != NULL) {
#line 659 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return;
#line 4422 "DataSource.c"
	}
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp1_ = added;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_object_it = _tmp2_;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		while (TRUE) {
#line 4436 "DataSource.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DataObject* _tmp7_ = NULL;
			gint64 _tmp8_ = 0LL;
			gint64 _tmp9_ = 0LL;
			DataObject* _tmp10_ = NULL;
			DataObject* _tmp11_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp3_ = _object_it;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (!_tmp4_) {
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				break;
#line 4455 "DataSource.c"
			}
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp5_ = _object_it;
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			object = (DataObject*) _tmp6_;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp7_ = object;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp8_ = data_object_get_object_id (_tmp7_);
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp9_ = self->priv->object_id;
#line 663 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			if (_tmp8_ != _tmp9_) {
#line 664 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				_g_object_unref0 (object);
#line 664 "/home/jens/Source/shotwell/src/core/DataSource.vala"
				continue;
#line 4475 "DataSource.c"
			}
#line 667 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp10_ = object;
#line 667 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			source_proxy_set_source (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource));
#line 669 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_tmp11_ = object;
#line 669 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			source_proxy_notify_reconstituted (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_SOURCE, DataSource));
#line 671 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			_g_object_unref0 (object);
#line 671 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			break;
#line 4489 "DataSource.c"
		}
#line 661 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		_g_object_unref0 (_object_it);
#line 4493 "DataSource.c"
	}
}


static void source_proxy_real_reconstituted (SourceProxy* self, DataSource* source) {
#line 558 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 4501 "DataSource.c"
}


static void source_proxy_real_dehydrated (SourceProxy* self) {
}


static void source_proxy_real_broken (SourceProxy* self) {
}


static void value_source_proxy_init (GValue* value) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	value->data[0].v_pointer = NULL;
#line 4516 "DataSource.c"
}


static void value_source_proxy_free_value (GValue* value) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (value->data[0].v_pointer);
#line 4525 "DataSource.c"
	}
}


static void value_source_proxy_copy_value (const GValue* src_value, GValue* dest_value) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (src_value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = source_proxy_ref (src_value->data[0].v_pointer);
#line 4535 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4539 "DataSource.c"
	}
}


static gpointer value_source_proxy_peek_pointer (const GValue* value) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 4547 "DataSource.c"
}


static gchar* value_source_proxy_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (collect_values[0].v_pointer) {
#line 4554 "DataSource.c"
		SourceProxy* object;
		object = collect_values[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		if (object->parent_instance.g_class == NULL) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4561 "DataSource.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4565 "DataSource.c"
		}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = source_proxy_ref (object);
#line 4569 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4573 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4577 "DataSource.c"
}


static gchar* value_source_proxy_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SourceProxy** object_p;
	object_p = collect_values[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!object_p) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4588 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!value->data[0].v_pointer) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = NULL;
#line 4594 "DataSource.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = value->data[0].v_pointer;
#line 4598 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		*object_p = source_proxy_ref (value->data[0].v_pointer);
#line 4602 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return NULL;
#line 4606 "DataSource.c"
}


GParamSpec* param_spec_source_proxy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSourceProxy* spec;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_PROXY), NULL);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return G_PARAM_SPEC (spec);
#line 4620 "DataSource.c"
}


gpointer value_get_source_proxy (const GValue* value) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY), NULL);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return value->data[0].v_pointer;
#line 4629 "DataSource.c"
}


void value_set_source_proxy (GValue* value, gpointer v_object) {
	SourceProxy* old;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_ref (value->data[0].v_pointer);
#line 4649 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4653 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (old);
#line 4659 "DataSource.c"
	}
}


void value_take_source_proxy (GValue* value, gpointer v_object) {
	SourceProxy* old;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	old = value->data[0].v_pointer;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (v_object) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_PROXY));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = v_object;
#line 4678 "DataSource.c"
	} else {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		value->data[0].v_pointer = NULL;
#line 4682 "DataSource.c"
	}
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (old) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		source_proxy_unref (old);
#line 4688 "DataSource.c"
	}
}


static void source_proxy_class_init (SourceProxyClass * klass) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_parent_class = g_type_class_peek_parent (klass);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->finalize = source_proxy_finalize;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_type_class_add_private (klass, sizeof (SourceProxyPrivate));
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->reconstitute = source_proxy_real_reconstitute;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_reconstituted = source_proxy_real_notify_reconstituted;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_dehydrated = source_proxy_real_notify_dehydrated;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->notify_broken = source_proxy_real_notify_broken;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->reconstituted = source_proxy_real_reconstituted;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->dehydrated = source_proxy_real_dehydrated;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	((SourceProxyClass *) klass)->broken = source_proxy_real_broken;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("reconstituted", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, reconstituted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("dehydrated", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, dehydrated), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_new ("broken", TYPE_SOURCE_PROXY, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceProxyClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4720 "DataSource.c"
}


static void source_proxy_instance_init (SourceProxy * self) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->priv = SOURCE_PROXY_GET_PRIVATE (self);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self->ref_count = 1;
#line 4729 "DataSource.c"
}


static void source_proxy_finalize (SourceProxy* obj) {
	SourceProxy * self;
	SourceCollection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_PROXY, SourceProxy);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_destroy (self);
#line 587 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	source_proxy_drop_source (self);
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_tmp0_ = self->priv->membership;
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 588 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _source_proxy_on_source_added_data_collection_items_added, self);
#line 551 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_free0 (self->priv->source_string);
#line 552 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_g_object_unref0 (self->priv->source);
#line 553 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_source_snapshot_unref0 (self->priv->snapshot);
#line 554 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	_data_collection_unref0 (self->priv->membership);
#line 4757 "DataSource.c"
}


GType source_proxy_get_type (void) {
	static volatile gsize source_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&source_proxy_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_source_proxy_init, value_source_proxy_free_value, value_source_proxy_copy_value, value_source_proxy_peek_pointer, "p", value_source_proxy_collect_value, "p", value_source_proxy_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SourceProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceProxy), 0, (GInstanceInitFunc) source_proxy_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType source_proxy_type_id;
		source_proxy_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceProxy", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_proxy_type_id__volatile, source_proxy_type_id);
	}
	return source_proxy_type_id__volatile;
}


gpointer source_proxy_ref (gpointer instance) {
	SourceProxy* self;
	self = instance;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_atomic_int_inc (&self->ref_count);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return instance;
#line 4782 "DataSource.c"
}


void source_proxy_unref (gpointer instance) {
	SourceProxy* self;
	self = instance;
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		SOURCE_PROXY_GET_CLASS (self)->finalize (self);
#line 549 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4795 "DataSource.c"
	}
}


SourceProxy* proxyable_get_proxy (Proxyable* self) {
#line 677 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	g_return_val_if_fail (IS_PROXYABLE (self), NULL);
#line 677 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	return PROXYABLE_GET_INTERFACE (self)->get_proxy (self);
#line 4805 "DataSource.c"
}


static void proxyable_base_init (ProxyableIface * iface) {
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	static gboolean initialized = FALSE;
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
	if (!initialized) {
#line 676 "/home/jens/Source/shotwell/src/core/DataSource.vala"
		initialized = TRUE;
#line 4816 "DataSource.c"
	}
}


GType proxyable_get_type (void) {
	static volatile gsize proxyable_type_id__volatile = 0;
	if (g_once_init_enter (&proxyable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProxyableIface), (GBaseInitFunc) proxyable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType proxyable_type_id;
		proxyable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Proxyable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (proxyable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&proxyable_type_id__volatile, proxyable_type_id);
	}
	return proxyable_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



