/* Alteration.c generated by valac 0.34.7, the Vala compiler
 * generated from Alteration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* Alteration represents a description of what has changed in the DataObject (reported via the*/
/* "altered" signal).  Since the descriptions can vary wildly depending on the semantics of each*/
/* DataObject, no assumptions or requirements are placed on Alteration other than it must have*/
/* one or more "subjects", each with a "detail".  Subscribers to the "altered" signal can query*/
/* the Alteration object to determine if the change is important to them.*/
/**/
/* Alteration is an immutable type.  This means it's possible to store const Alterations of oft-used*/
/* values for reuse.*/
/**/
/* Alterations may be compressed, merging their subjects and details into a new aggregated*/
/* Alteration.  Generally this is handled automatically by DataObject and DataCollection, when*/
/* necessary.*/
/**/
/* NOTE: subjects and details should be ASCII labels (as in, plain-old ASCII, no code pages).*/
/* They are treated as case-sensitive strings.*/
/**/
/* Recommended subjects include: image, thumbnail, metadata.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _AlterationPrivate AlterationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecAlteration ParamSpecAlteration;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Alteration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlterationPrivate * priv;
};

struct _AlterationClass {
	GTypeClass parent_class;
	void (*finalize) (Alteration *self);
};

struct _AlterationPrivate {
	gchar* subject;
	gchar* detail;
	GeeMultiMap* map;
};

struct _ParamSpecAlteration {
	GParamSpec parent_instance;
};


static gpointer alteration_parent_class = NULL;

gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
#define ALTERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ALTERATION, AlterationPrivate))
enum  {
	ALTERATION_DUMMY_PROPERTY
};
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
static void alteration_add_detail (Alteration* self, const gchar* sub, const gchar* det);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type, const gchar* list);
Alteration* alteration_new_from_array (gchar** array, int array_length1);
Alteration* alteration_construct_from_array (GType object_type, gchar** array, int array_length1);
static Alteration* alteration_new_from_map (GeeMultiMap* map);
static Alteration* alteration_construct_from_map (GType object_type, GeeMultiMap* map);
static GeeMultiMap* alteration_create_map (Alteration* self);
static guint alteration_case_hash (const gchar* a);
static guint _alteration_case_hash_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean alteration_case_equal (const gchar* a, const gchar* b);
static gboolean _alteration_case_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static inline gboolean alteration_equal_values (const gchar* str1, const gchar* str2);
static inline guint alteration_hash_value (const gchar* str);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
GeeCollection* alteration_get_details (Alteration* self, const gchar* subject);
gchar* alteration_to_string (Alteration* self);
gboolean alteration_contains_any (Alteration* self, Alteration* other);
gboolean alteration_equals (Alteration* self, Alteration* other);
static void alteration_multimap_add_all (GeeMultiMap* dest, GeeMultiMap* src);
Alteration* alteration_compress (Alteration* self, Alteration* other);
static void alteration_finalize (Alteration* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail) {
	Alteration* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (detail != NULL, NULL);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 33 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = subject;
#line 33 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = detail;
#line 33 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	alteration_add_detail (self, _tmp0_, _tmp1_);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 139 "Alteration.c"
}


Alteration* alteration_new (const gchar* subject, const gchar* detail) {
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct (TYPE_ALTERATION, subject, detail);
#line 146 "Alteration.c"
}


Alteration* alteration_construct_from_list (GType object_type, const gchar* list) {
	Alteration* self = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar** pairs = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint pairs_length1 = 0;
	gint _pairs_size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = list;
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = strlen (_tmp0_);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = _tmp1_;
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_return_val_if_fail (_tmp2_ > 0, "list.length > 0", NULL);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = list;
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ",", 0);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs = _tmp5_;
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs_length1 = _vala_array_length (_tmp4_);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_pairs_size_ = pairs_length1;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = pairs;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6__length1 = pairs_length1;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp6__length1 >= 1, "pairs.length >= 1");
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7_ = pairs;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7__length1 = pairs_length1;
#line 197 "Alteration.c"
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection = _tmp7_;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection_length1 = _tmp7__length1;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		for (pair_it = 0; pair_it < _tmp7__length1; pair_it = pair_it + 1) {
#line 209 "Alteration.c"
			gchar* _tmp8_ = NULL;
			gchar* pair = NULL;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp8_ = g_strdup (pair_collection[pair_it]);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			pair = _tmp8_;
#line 216 "Alteration.c"
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint subject_detail_length1 = 0;
				gint _subject_detail_size_ = 0;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				const gchar* _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				const gchar* _tmp16_ = NULL;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9_ = pair;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ":", 2);
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = _tmp11_;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail_length1 = _vala_array_length (_tmp10_);
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_subject_detail_size_ = subject_detail_length1;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12_ = subject_detail;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12__length1 = subject_detail_length1;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_vala_assert (_tmp12__length1 == 2, "subject_detail.length == 2");
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13_ = subject_detail;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13__length1 = subject_detail_length1;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp14_ = _tmp13_[0];
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp15_ = subject_detail;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp15__length1 = subject_detail_length1;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp16_ = _tmp15_[1];
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				alteration_add_detail (self, _tmp14_, _tmp16_);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (pair);
#line 266 "Alteration.c"
			}
		}
	}
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs = (_vala_array_free (pairs, pairs_length1, (GDestroyNotify) g_free), NULL);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 274 "Alteration.c"
}


Alteration* alteration_new_from_list (const gchar* list) {
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_list (TYPE_ALTERATION, list);
#line 281 "Alteration.c"
}


Alteration* alteration_construct_from_array (GType object_type, gchar** array, int array_length1) {
	Alteration* self = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = array;
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0__length1 = array_length1;
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_return_val_if_fail (_tmp0__length1 > 0, "array.length > 0", NULL);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = array;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1__length1 = array_length1;
#line 303 "Alteration.c"
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection_length1 = _tmp1__length1;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		for (pair_it = 0; pair_it < _tmp1__length1; pair_it = pair_it + 1) {
#line 315 "Alteration.c"
			gchar* _tmp2_ = NULL;
			gchar* pair = NULL;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp2_ = g_strdup (pair_collection[pair_it]);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			pair = _tmp2_;
#line 322 "Alteration.c"
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gchar** _tmp5_ = NULL;
				gint subject_detail_length1 = 0;
				gint _subject_detail_size_ = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				const gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp3_ = pair;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 2);
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = _tmp5_;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail_length1 = _vala_array_length (_tmp4_);
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_subject_detail_size_ = subject_detail_length1;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp6_ = subject_detail;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp6__length1 = subject_detail_length1;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_vala_assert (_tmp6__length1 == 2, "subject_detail.length == 2");
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp7_ = subject_detail;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp7__length1 = subject_detail_length1;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp8_ = _tmp7_[0];
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9_ = subject_detail;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9__length1 = subject_detail_length1;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp10_ = _tmp9_[1];
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				alteration_add_detail (self, _tmp8_, _tmp10_);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (pair);
#line 372 "Alteration.c"
			}
		}
	}
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 378 "Alteration.c"
}


Alteration* alteration_new_from_array (gchar** array, int array_length1) {
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_array (TYPE_ALTERATION, array, array_length1);
#line 385 "Alteration.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self ? g_object_ref (self) : NULL;
#line 392 "Alteration.c"
}


static Alteration* alteration_construct_from_map (GType object_type, GeeMultiMap* map) {
	Alteration* self = NULL;
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp1_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (GEE_IS_MULTI_MAP (map), NULL);
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = map;
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (self->priv->map);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->map = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 414 "Alteration.c"
}


static Alteration* alteration_new_from_map (GeeMultiMap* map) {
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_map (TYPE_ALTERATION, map);
#line 421 "Alteration.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1207 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 444 "Alteration.c"
}


static void alteration_add_detail (Alteration* self, const gchar* sub, const gchar* det) {
	gchar* subject = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* detail = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	GeeMultiMap* _tmp18_ = NULL;
	const gchar* _tmp20_ = NULL;
	GeeMultiMap* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (IS_ALTERATION (self));
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (sub != NULL);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (det != NULL);
#line 68 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = sub;
#line 68 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 68 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	subject = _tmp1_;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = subject;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = strlen (_tmp2_);
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = _tmp3_;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp4_ > 0, "subject.length > 0");
#line 71 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = det;
#line 71 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = string_strip (_tmp5_);
#line 71 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	detail = _tmp6_;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7_ = detail;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp8_ = strlen (_tmp7_);
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp9_ = _tmp8_;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp9_ > 0, "detail.length > 0");
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp11_ = self->priv->subject;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp11_ == NULL) {
#line 506 "Alteration.c"
		GeeMultiMap* _tmp12_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = self->priv->map;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = _tmp12_ == NULL;
#line 512 "Alteration.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = FALSE;
#line 516 "Alteration.c"
	}
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp10_) {
#line 520 "Alteration.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = self->priv->detail;
#line 76 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp13_ == NULL, "this.detail == null");
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = subject;
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->subject);
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->subject = _tmp15_;
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp16_ = detail;
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->detail);
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->detail = _tmp17_;
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (detail);
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (subject);
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return;
#line 552 "Alteration.c"
	}
#line 85 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp18_ = self->priv->map;
#line 85 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp18_ == NULL) {
#line 558 "Alteration.c"
		GeeMultiMap* _tmp19_ = NULL;
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = alteration_create_map (self);
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (self->priv->map);
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->map = _tmp19_;
#line 566 "Alteration.c"
	}
#line 89 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp20_ = self->priv->subject;
#line 89 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp20_ != NULL) {
#line 572 "Alteration.c"
		const gchar* _tmp21_ = NULL;
		GeeMultiMap* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 90 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp21_ = self->priv->detail;
#line 90 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp21_ != NULL, "this.detail != null");
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = self->priv->map;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = self->priv->subject;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp24_ = self->priv->detail;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp22_, _tmp23_, _tmp24_);
#line 93 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->subject);
#line 93 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->subject = NULL;
#line 94 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->detail);
#line 94 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->detail = NULL;
#line 597 "Alteration.c"
	}
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp25_ = self->priv->map;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp26_ = subject;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp27_ = detail;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	gee_multi_map_set (_tmp25_, _tmp26_, _tmp27_);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (detail);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (subject);
#line 611 "Alteration.c"
}


static guint _alteration_case_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = alteration_case_hash ((const gchar*) v);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 620 "Alteration.c"
}


static gboolean _alteration_case_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = alteration_case_equal ((const gchar*) a, (const gchar*) b);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 629 "Alteration.c"
}


static GeeMultiMap* alteration_create_map (Alteration* self) {
	GeeMultiMap* result = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 644 "Alteration.c"
}


static gboolean alteration_case_equal (const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = a;
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = b;
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = alteration_equal_values (_tmp0_, _tmp1_);
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp2_;
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 663 "Alteration.c"
}


static guint alteration_case_hash (const gchar* a) {
	guint result = 0U;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = a;
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = alteration_hash_value (_tmp0_);
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp1_;
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 679 "Alteration.c"
}


static inline gboolean alteration_equal_values (const gchar* str1, const gchar* str2) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 113 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str1 != NULL, FALSE);
#line 113 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str2 != NULL, FALSE);
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = str1;
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = str2;
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = g_ascii_strcasecmp (_tmp0_, _tmp1_);
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp2_ == 0;
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 702 "Alteration.c"
}


static inline guint alteration_hash_value (const gchar* str) {
	guint result = 0U;
	GHashFunc _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 117 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str != NULL, 0U);
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = g_str_hash;
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = str;
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = _tmp0_ (_tmp1_);
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp2_;
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 723 "Alteration.c"
}


gboolean alteration_has_subject (Alteration* self, const gchar* subject) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GeeMultiMap* _tmp4_ = NULL;
	GeeSet* keys = NULL;
	GeeMultiMap* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 121 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, FALSE);
#line 122 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = self->priv->subject;
#line 122 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_ != NULL) {
#line 743 "Alteration.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = self->priv->subject;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = subject;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = alteration_equal_values (_tmp1_, _tmp2_);
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp3_;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 757 "Alteration.c"
	}
#line 125 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = self->priv->map;
#line 125 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp4_ != NULL, "map != null");
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = self->priv->map;
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = gee_multi_map_get_keys (_tmp5_);
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	keys = _tmp6_;
#line 127 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7_ = keys;
#line 127 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp7_ != NULL) {
#line 773 "Alteration.c"
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp8_ = NULL;
			GeeIterator* _tmp9_ = NULL;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp8_ = keys;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_key_it = _tmp9_;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 786 "Alteration.c"
				GeeIterator* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gchar* key = NULL;
				GeeIterator* _tmp12_ = NULL;
				gpointer _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp10_ = _key_it;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11_ = gee_iterator_next (_tmp10_);
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp11_) {
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 803 "Alteration.c"
				}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12_ = _key_it;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13_ = gee_iterator_get (_tmp12_);
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				key = (gchar*) _tmp13_;
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp14_ = key;
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp15_ = subject;
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp16_ = alteration_equal_values (_tmp14_, _tmp15_);
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp16_) {
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = TRUE;
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 829 "Alteration.c"
				}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (key);
#line 833 "Alteration.c"
			}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_key_it);
#line 837 "Alteration.c"
		}
	}
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (keys);
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 846 "Alteration.c"
}


gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GeeMultiMap* _tmp10_ = NULL;
	GeeCollection* values = NULL;
	GeeMultiMap* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GeeCollection* _tmp13_ = NULL;
	GeeCollection* _tmp14_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, FALSE);
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (detail != NULL, FALSE);
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = self->priv->subject;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_ != NULL) {
#line 870 "Alteration.c"
		const gchar* _tmp2_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = self->priv->detail;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 876 "Alteration.c"
	} else {
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 880 "Alteration.c"
	}
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 884 "Alteration.c"
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = self->priv->subject;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = subject;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = alteration_equal_values (_tmp4_, _tmp5_);
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp6_) {
#line 897 "Alteration.c"
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = self->priv->detail;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp8_ = detail;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp9_ = alteration_equal_values (_tmp7_, _tmp8_);
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp3_ = _tmp9_;
#line 909 "Alteration.c"
		} else {
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp3_ = FALSE;
#line 913 "Alteration.c"
		}
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp3_;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 919 "Alteration.c"
	}
#line 141 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp10_ = self->priv->map;
#line 141 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp10_ != NULL, "map != null");
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp11_ = self->priv->map;
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp12_ = subject;
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp13_ = gee_multi_map_get (_tmp11_, _tmp12_);
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	values = _tmp13_;
#line 143 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp14_ = values;
#line 143 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp14_ != NULL) {
#line 937 "Alteration.c"
		{
			GeeIterator* _value_it = NULL;
			GeeCollection* _tmp15_ = NULL;
			GeeIterator* _tmp16_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp15_ = values;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_value_it = _tmp16_;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 950 "Alteration.c"
				GeeIterator* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				gchar* value = NULL;
				GeeIterator* _tmp19_ = NULL;
				gpointer _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp17_ = _value_it;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp18_ = gee_iterator_next (_tmp17_);
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp18_) {
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 967 "Alteration.c"
				}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp19_ = _value_it;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp20_ = gee_iterator_get (_tmp19_);
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				value = (gchar*) _tmp20_;
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp21_ = value;
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp22_ = detail;
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp23_ = alteration_equal_values (_tmp21_, _tmp22_);
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp23_) {
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = TRUE;
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_value_it);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 993 "Alteration.c"
				}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (value);
#line 997 "Alteration.c"
			}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_value_it);
#line 1001 "Alteration.c"
		}
	}
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (values);
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1010 "Alteration.c"
}


GeeCollection* alteration_get_details (Alteration* self, const gchar* subject) {
	GeeCollection* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GeeCollection* _tmp10_ = NULL;
	GeeMultiMap* _tmp11_ = NULL;
#line 153 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 153 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = self->priv->subject;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_ != NULL) {
#line 1029 "Alteration.c"
		const gchar* _tmp3_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = self->priv->detail;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 1035 "Alteration.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1039 "Alteration.c"
	}
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1043 "Alteration.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = self->priv->subject;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = subject;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = alteration_equal_values (_tmp4_, _tmp5_);
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _tmp6_;
#line 1055 "Alteration.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 1059 "Alteration.c"
	}
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 1063 "Alteration.c"
		GeeArrayList* details = NULL;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 155 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		details = _tmp7_;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = details;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = self->priv->detail;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 158 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (details, GEE_TYPE_COLLECTION, GeeCollection);
#line 158 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1082 "Alteration.c"
	}
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp11_ = self->priv->map;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp11_ != NULL) {
#line 1088 "Alteration.c"
		GeeMultiMap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GeeCollection* _tmp14_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = self->priv->map;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = subject;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = gee_multi_map_get (_tmp12_, _tmp13_);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp10_);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = _tmp14_;
#line 1102 "Alteration.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp10_);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = NULL;
#line 1108 "Alteration.c"
	}
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp10_;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1114 "Alteration.c"
}


gchar* alteration_to_string (Alteration* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GeeMultiMap* _tmp5_ = NULL;
	gchar* str = NULL;
	gchar* _tmp6_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 165 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = self->priv->subject;
#line 165 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_ != NULL) {
#line 1130 "Alteration.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = self->priv->detail;
#line 166 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp1_ != NULL, "detail != null");
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = self->priv->subject;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = self->priv->detail;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = g_strdup_printf ("%s:%s", _tmp2_, _tmp3_);
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp4_;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1149 "Alteration.c"
	}
#line 171 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = self->priv->map;
#line 171 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp5_ != NULL, "map != null");
#line 173 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = g_strdup ("");
#line 173 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	str = _tmp6_;
#line 1159 "Alteration.c"
	{
		GeeIterator* _key_it = NULL;
		GeeMultiMap* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->map;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = gee_multi_map_get_keys (_tmp7_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = _tmp8_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = _tmp10_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp9_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_key_it = _tmp11_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		while (TRUE) {
#line 1183 "Alteration.c"
			GeeIterator* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gchar* key = NULL;
			GeeIterator* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp12_ = _key_it;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp13_ = gee_iterator_next (_tmp12_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			if (!_tmp13_) {
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				break;
#line 1197 "Alteration.c"
			}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp14_ = _key_it;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp15_ = gee_iterator_get (_tmp14_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			key = (gchar*) _tmp15_;
#line 1205 "Alteration.c"
			{
				GeeIterator* _value_it = NULL;
				GeeMultiMap* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				GeeIterator* _tmp20_ = NULL;
				GeeIterator* _tmp21_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp16_ = self->priv->map;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp17_ = key;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp18_ = gee_multi_map_get (_tmp16_, _tmp17_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp19_ = _tmp18_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable));
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp21_ = _tmp20_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_tmp19_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_value_it = _tmp21_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				while (TRUE) {
#line 1232 "Alteration.c"
					GeeIterator* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					gchar* value = NULL;
					GeeIterator* _tmp24_ = NULL;
					gpointer _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp22_ = _value_it;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp23_ = gee_iterator_next (_tmp22_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (!_tmp23_) {
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						break;
#line 1255 "Alteration.c"
					}
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp24_ = _value_it;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp25_ = gee_iterator_get (_tmp24_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					value = (gchar*) _tmp25_;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp26_ = str;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp27_ = strlen (_tmp26_);
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp28_ = _tmp27_;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (_tmp28_ != 0) {
#line 1271 "Alteration.c"
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp29_ = str;
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp30_ = g_strconcat (_tmp29_, ", ", NULL);
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_g_free0 (str);
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						str = _tmp30_;
#line 1282 "Alteration.c"
					}
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp31_ = str;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp32_ = key;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp33_ = value;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp34_ = g_strdup_printf ("%s:%s", _tmp32_, _tmp33_);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp35_ = _tmp34_;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp36_ = g_strconcat (_tmp31_, _tmp35_, NULL);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (str);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					str = _tmp36_;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (_tmp35_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 1304 "Alteration.c"
				}
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_value_it);
#line 1308 "Alteration.c"
			}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_free0 (key);
#line 1312 "Alteration.c"
		}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_key_it);
#line 1316 "Alteration.c"
	}
#line 183 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = str;
#line 183 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1322 "Alteration.c"
}


gboolean alteration_contains_any (Alteration* self, Alteration* other) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GeeMultiMap* _tmp21_ = NULL;
	gboolean _tmp56_ = FALSE;
	GeeMultiMap* _tmp57_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 187 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
#line 189 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = other;
#line 189 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (self == _tmp0_) {
#line 190 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1350 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = self->priv->subject;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp4_ != NULL) {
#line 1356 "Alteration.c"
		Alteration* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = other;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = _tmp5_->priv->subject;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 1365 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = FALSE;
#line 1369 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp3_) {
#line 1373 "Alteration.c"
		const gchar* _tmp7_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->detail;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _tmp7_ != NULL;
#line 1379 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = FALSE;
#line 1383 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_) {
#line 1387 "Alteration.c"
		Alteration* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = other;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = _tmp8_->priv->detail;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp9_ != NULL;
#line 1396 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1400 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1404 "Alteration.c"
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		Alteration* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = self->priv->subject;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = other;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = _tmp12_->priv->subject;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = alteration_equal_values (_tmp11_, _tmp13_);
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp14_) {
#line 1420 "Alteration.c"
			const gchar* _tmp15_ = NULL;
			Alteration* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp15_ = self->priv->detail;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp16_ = other;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp17_ = _tmp16_->priv->detail;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp18_ = alteration_equal_values (_tmp15_, _tmp17_);
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = _tmp18_;
#line 1435 "Alteration.c"
		} else {
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = FALSE;
#line 1439 "Alteration.c"
		}
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp10_;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1445 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp21_ = self->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp21_ != NULL) {
#line 1451 "Alteration.c"
		Alteration* _tmp22_ = NULL;
		GeeMultiMap* _tmp23_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = other;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = _tmp22_->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = _tmp23_ == NULL;
#line 1460 "Alteration.c"
	} else {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = FALSE;
#line 1464 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp20_) {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = TRUE;
#line 1470 "Alteration.c"
	} else {
		gboolean _tmp24_ = FALSE;
		GeeMultiMap* _tmp25_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp25_ = self->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp25_ == NULL) {
#line 1478 "Alteration.c"
			Alteration* _tmp26_ = NULL;
			GeeMultiMap* _tmp27_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp26_ = other;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp27_ = _tmp26_->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp24_ = _tmp27_ != NULL;
#line 1487 "Alteration.c"
		} else {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp24_ = FALSE;
#line 1491 "Alteration.c"
		}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = _tmp24_;
#line 1495 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp19_) {
#line 1499 "Alteration.c"
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* single_subject = NULL;
		gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* single_detail = NULL;
		gchar* _tmp39_ = NULL;
		GeeMultiMap* _tmp40_ = NULL;
		GeeMultiMap* _tmp41_ = NULL;
		GeeMultiMap* multimap = NULL;
		GeeMultiMap* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		GeeMultiMap* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp29_ = self->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp29_ != NULL) {
#line 1520 "Alteration.c"
			const gchar* _tmp30_ = NULL;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp30_ = self->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp28_ = _tmp30_;
#line 1526 "Alteration.c"
		} else {
			Alteration* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp31_ = other;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp32_ = _tmp31_->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp28_ = _tmp32_;
#line 1536 "Alteration.c"
		}
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp33_ = g_strdup (_tmp28_);
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		single_subject = _tmp33_;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp35_ = self->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp35_ != NULL) {
#line 1546 "Alteration.c"
			const gchar* _tmp36_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp36_ = self->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp34_ = _tmp36_;
#line 1552 "Alteration.c"
		} else {
			Alteration* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp37_ = other;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp38_ = _tmp37_->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp34_ = _tmp38_;
#line 1562 "Alteration.c"
		}
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp39_ = g_strdup (_tmp34_);
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		single_detail = _tmp39_;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp41_ = self->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp41_ != NULL) {
#line 1572 "Alteration.c"
			GeeMultiMap* _tmp42_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp42_ = self->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp40_ = _tmp42_;
#line 1578 "Alteration.c"
		} else {
			Alteration* _tmp43_ = NULL;
			GeeMultiMap* _tmp44_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp43_ = other;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp44_ = _tmp43_->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp40_ = _tmp44_;
#line 1588 "Alteration.c"
		}
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp45_ = _g_object_ref0 (_tmp40_);
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		multimap = _tmp45_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp47_ = multimap;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp48_ = single_subject;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp49_ = gee_multi_map_contains (_tmp47_, _tmp48_);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp49_) {
#line 1602 "Alteration.c"
			GeeMultiMap* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			GeeCollection* _tmp52_ = NULL;
			GeeCollection* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp50_ = self->priv->map;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp51_ = single_subject;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp52_ = gee_multi_map_get (_tmp50_, _tmp51_);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp53_ = _tmp52_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp54_ = single_detail;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp46_ = _tmp55_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_tmp53_);
#line 1625 "Alteration.c"
		} else {
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp46_ = FALSE;
#line 1629 "Alteration.c"
		}
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp46_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (multimap);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (single_detail);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (single_subject);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1641 "Alteration.c"
	}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp57_ = self->priv->map;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp57_ != NULL) {
#line 1647 "Alteration.c"
		Alteration* _tmp58_ = NULL;
		GeeMultiMap* _tmp59_ = NULL;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp58_ = other;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp59_ = _tmp58_->priv->map;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp56_ = _tmp59_ != NULL;
#line 1656 "Alteration.c"
	} else {
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp56_ = FALSE;
#line 1660 "Alteration.c"
	}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp56_) {
#line 1664 "Alteration.c"
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp60_ = NULL;
		GeeSet* _tmp61_ = NULL;
		GeeSet* _tmp62_ = NULL;
		GeeSet* other_keys = NULL;
		Alteration* _tmp63_ = NULL;
		GeeMultiMap* _tmp64_ = NULL;
		GeeSet* _tmp65_ = NULL;
		GeeSet* _tmp66_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp60_ = self->priv->map;
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp61_ = gee_multi_map_get_keys (_tmp60_);
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		keys = _tmp61_;
#line 208 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp62_ = keys;
#line 208 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp62_ != NULL, "keys != null");
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp63_ = other;
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp64_ = _tmp63_->priv->map;
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp65_ = gee_multi_map_get_keys (_tmp64_);
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		other_keys = _tmp65_;
#line 210 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp66_ = other_keys;
#line 210 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp66_ != NULL, "other_keys != null");
#line 1696 "Alteration.c"
		{
			GeeIterator* _subject_it = NULL;
			GeeSet* _tmp67_ = NULL;
			GeeIterator* _tmp68_ = NULL;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp67_ = other_keys;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp68_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_ITERABLE, GeeIterable));
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_subject_it = _tmp68_;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 1709 "Alteration.c"
				GeeIterator* _tmp69_ = NULL;
				gboolean _tmp70_ = FALSE;
				gchar* subject = NULL;
				GeeIterator* _tmp71_ = NULL;
				gpointer _tmp72_ = NULL;
				GeeSet* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				gboolean _tmp75_ = FALSE;
				GeeCollection* details = NULL;
				GeeMultiMap* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				GeeCollection* _tmp78_ = NULL;
				GeeCollection* other_details = NULL;
				Alteration* _tmp79_ = NULL;
				GeeMultiMap* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				GeeCollection* _tmp82_ = NULL;
				gboolean _tmp83_ = FALSE;
				GeeCollection* _tmp84_ = NULL;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp69_ = _subject_it;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp70_ = gee_iterator_next (_tmp69_);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp70_) {
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 1737 "Alteration.c"
				}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp71_ = _subject_it;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp72_ = gee_iterator_get (_tmp71_);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject = (gchar*) _tmp72_;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp73_ = keys;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp74_ = subject;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp75_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEE_TYPE_COLLECTION, GeeCollection), _tmp74_);
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp75_) {
#line 214 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (subject);
#line 214 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					continue;
#line 1757 "Alteration.c"
				}
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp76_ = self->priv->map;
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp77_ = subject;
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp78_ = gee_multi_map_get (_tmp76_, _tmp77_);
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				details = _tmp78_;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp79_ = other;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp80_ = _tmp79_->priv->map;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp81_ = subject;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp82_ = gee_multi_map_get (_tmp80_, _tmp81_);
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				other_details = _tmp82_;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp84_ = details;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp84_ != NULL) {
#line 1781 "Alteration.c"
					GeeCollection* _tmp85_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp85_ = other_details;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp83_ = _tmp85_ != NULL;
#line 1787 "Alteration.c"
				} else {
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp83_ = FALSE;
#line 1791 "Alteration.c"
				}
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp83_) {
#line 1795 "Alteration.c"
					{
						GeeIterator* _detail_it = NULL;
						GeeCollection* _tmp86_ = NULL;
						GeeIterator* _tmp87_ = NULL;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp86_ = other_details;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp87_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GEE_TYPE_ITERABLE, GeeIterable));
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_detail_it = _tmp87_;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						while (TRUE) {
#line 1808 "Alteration.c"
							GeeIterator* _tmp88_ = NULL;
							gboolean _tmp89_ = FALSE;
							gchar* detail = NULL;
							GeeIterator* _tmp90_ = NULL;
							gpointer _tmp91_ = NULL;
							GeeCollection* _tmp92_ = NULL;
							const gchar* _tmp93_ = NULL;
							gboolean _tmp94_ = FALSE;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp88_ = _detail_it;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp89_ = gee_iterator_next (_tmp88_);
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							if (!_tmp89_) {
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								break;
#line 1825 "Alteration.c"
							}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp90_ = _detail_it;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp91_ = gee_iterator_get (_tmp90_);
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							detail = (gchar*) _tmp91_;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp92_ = details;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp93_ = detail;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp94_ = gee_collection_contains (_tmp92_, _tmp93_);
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							if (_tmp94_) {
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								result = TRUE;
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_free0 (detail);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (_detail_it);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (other_details);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (details);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_free0 (subject);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (_subject_it);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (other_keys);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (keys);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								return result;
#line 1861 "Alteration.c"
							}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_g_free0 (detail);
#line 1865 "Alteration.c"
						}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_g_object_unref0 (_detail_it);
#line 1869 "Alteration.c"
					}
				}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (other_details);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (details);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (subject);
#line 1878 "Alteration.c"
			}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_subject_it);
#line 1882 "Alteration.c"
		}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (other_keys);
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (keys);
#line 1888 "Alteration.c"
	}
#line 228 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 228 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1894 "Alteration.c"
}


gboolean alteration_equals (Alteration* self, Alteration* other) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeMultiMap* _tmp20_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 231 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
#line 233 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = other;
#line 233 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (self == _tmp0_) {
#line 234 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 234 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1919 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = self->priv->subject;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp4_ != NULL) {
#line 1925 "Alteration.c"
		Alteration* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = other;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = _tmp5_->priv->subject;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 1934 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = FALSE;
#line 1938 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp3_) {
#line 1942 "Alteration.c"
		const gchar* _tmp7_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->detail;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _tmp7_ != NULL;
#line 1948 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = FALSE;
#line 1952 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_) {
#line 1956 "Alteration.c"
		Alteration* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = other;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = _tmp8_->priv->detail;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp9_ != NULL;
#line 1965 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1969 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1973 "Alteration.c"
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		Alteration* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = self->priv->subject;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = other;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = _tmp12_->priv->subject;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = alteration_equal_values (_tmp11_, _tmp13_);
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp14_) {
#line 1989 "Alteration.c"
			const gchar* _tmp15_ = NULL;
			Alteration* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp15_ = self->priv->detail;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp16_ = other;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp17_ = _tmp16_->priv->detail;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp18_ = alteration_equal_values (_tmp15_, _tmp17_);
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = _tmp18_;
#line 2004 "Alteration.c"
		} else {
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = FALSE;
#line 2008 "Alteration.c"
		}
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp10_;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 2014 "Alteration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp20_ = self->priv->map;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp20_ != NULL) {
#line 2020 "Alteration.c"
		Alteration* _tmp21_ = NULL;
		GeeMultiMap* _tmp22_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp21_ = other;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = _tmp21_->priv->map;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = _tmp22_ != NULL;
#line 2029 "Alteration.c"
	} else {
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = FALSE;
#line 2033 "Alteration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp19_) {
#line 2037 "Alteration.c"
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp23_ = NULL;
		GeeSet* _tmp24_ = NULL;
		GeeSet* _tmp25_ = NULL;
		GeeSet* other_keys = NULL;
		Alteration* _tmp26_ = NULL;
		GeeMultiMap* _tmp27_ = NULL;
		GeeSet* _tmp28_ = NULL;
		GeeSet* _tmp29_ = NULL;
		GeeSet* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		GeeSet* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		GeeSet* _tmp36_ = NULL;
		GeeSet* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		GeeSet* _tmp39_ = NULL;
		GeeSet* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = self->priv->map;
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp24_ = gee_multi_map_get_keys (_tmp23_);
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		keys = _tmp24_;
#line 244 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp25_ = keys;
#line 244 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp25_ != NULL, "keys != null");
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp26_ = other;
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp27_ = _tmp26_->priv->map;
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp28_ = gee_multi_map_get_keys (_tmp27_);
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		other_keys = _tmp28_;
#line 246 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp29_ = other_keys;
#line 246 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp29_ != NULL, "other_keys != null");
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp30_ = keys;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp31_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp32_ = _tmp31_;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp33_ = other_keys;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp34_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection));
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp35_ = _tmp34_;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp32_ != _tmp35_) {
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 2103 "Alteration.c"
		}
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp36_ = keys;
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp37_ = other_keys;
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp38_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection));
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (!_tmp38_) {
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 2121 "Alteration.c"
		}
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp39_ = other_keys;
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp40_ = keys;
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp41_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_COLLECTION, GeeCollection));
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (!_tmp41_) {
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 2139 "Alteration.c"
		}
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp42_ = NULL;
			GeeIterator* _tmp43_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp42_ = keys;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp43_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ITERABLE, GeeIterable));
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_key_it = _tmp43_;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 2153 "Alteration.c"
				GeeIterator* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				gchar* key = NULL;
				GeeIterator* _tmp46_ = NULL;
				gpointer _tmp47_ = NULL;
				GeeCollection* values = NULL;
				GeeMultiMap* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				GeeCollection* _tmp50_ = NULL;
				GeeCollection* other_values = NULL;
				Alteration* _tmp51_ = NULL;
				GeeMultiMap* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				GeeCollection* _tmp54_ = NULL;
				GeeCollection* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				GeeCollection* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				GeeCollection* _tmp61_ = NULL;
				GeeCollection* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
				GeeCollection* _tmp64_ = NULL;
				GeeCollection* _tmp65_ = NULL;
				gboolean _tmp66_ = FALSE;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp44_ = _key_it;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp45_ = gee_iterator_next (_tmp44_);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp45_) {
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 2188 "Alteration.c"
				}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp46_ = _key_it;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp47_ = gee_iterator_get (_tmp46_);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				key = (gchar*) _tmp47_;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp48_ = self->priv->map;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp49_ = key;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp50_ = gee_multi_map_get (_tmp48_, _tmp49_);
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				values = _tmp50_;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp51_ = other;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp52_ = _tmp51_->priv->map;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp53_ = key;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp54_ = gee_multi_map_get (_tmp52_, _tmp53_);
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				other_values = _tmp54_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp55_ = values;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp56_ = gee_collection_get_size (_tmp55_);
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp57_ = _tmp56_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp58_ = other_values;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp59_ = gee_collection_get_size (_tmp58_);
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp60_ = _tmp59_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp57_ != _tmp60_) {
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2244 "Alteration.c"
				}
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp61_ = values;
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp62_ = other_values;
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp63_ = gee_collection_contains_all (_tmp61_, _tmp62_);
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp63_) {
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2270 "Alteration.c"
				}
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp64_ = other_values;
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp65_ = values;
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp66_ = gee_collection_contains_all (_tmp64_, _tmp65_);
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!_tmp66_) {
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2296 "Alteration.c"
				}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (other_values);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (values);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (key);
#line 2304 "Alteration.c"
			}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_key_it);
#line 2308 "Alteration.c"
		}
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (other_keys);
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (keys);
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 2318 "Alteration.c"
	}
#line 276 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 276 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 2324 "Alteration.c"
}


static void alteration_multimap_add_all (GeeMultiMap* dest, GeeMultiMap* src) {
	GeeSet* keys = NULL;
	GeeMultiMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (GEE_IS_MULTI_MAP (dest));
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (GEE_IS_MULTI_MAP (src));
#line 281 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = src;
#line 281 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = gee_multi_map_get_keys (_tmp0_);
#line 281 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	keys = _tmp1_;
#line 2342 "Alteration.c"
	{
		GeeIterator* _key_it = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = keys;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_key_it = _tmp3_;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		while (TRUE) {
#line 2355 "Alteration.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gchar* key = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			GeeCollection* values = NULL;
			GeeMultiMap* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GeeCollection* _tmp10_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp4_ = _key_it;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			if (!_tmp5_) {
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				break;
#line 2373 "Alteration.c"
			}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp6_ = _key_it;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			key = (gchar*) _tmp7_;
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp8_ = src;
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp9_ = key;
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = gee_multi_map_get (_tmp8_, _tmp9_);
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			values = _tmp10_;
#line 2389 "Alteration.c"
			{
				GeeIterator* _value_it = NULL;
				GeeCollection* _tmp11_ = NULL;
				GeeIterator* _tmp12_ = NULL;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11_ = values;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_value_it = _tmp12_;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				while (TRUE) {
#line 2402 "Alteration.c"
					GeeIterator* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gchar* value = NULL;
					GeeIterator* _tmp15_ = NULL;
					gpointer _tmp16_ = NULL;
					GeeMultiMap* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp13_ = _value_it;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp14_ = gee_iterator_next (_tmp13_);
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (!_tmp14_) {
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						break;
#line 2419 "Alteration.c"
					}
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp15_ = _value_it;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp16_ = gee_iterator_get (_tmp15_);
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					value = (gchar*) _tmp16_;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp17_ = dest;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp18_ = key;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp19_ = value;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					gee_multi_map_set (_tmp17_, _tmp18_, _tmp19_);
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 2437 "Alteration.c"
				}
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_value_it);
#line 2441 "Alteration.c"
			}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (values);
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_free0 (key);
#line 2447 "Alteration.c"
		}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_key_it);
#line 2451 "Alteration.c"
	}
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (keys);
#line 2455 "Alteration.c"
}


static gpointer _alteration_ref0 (gpointer self) {
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self ? alteration_ref (self) : NULL;
#line 2462 "Alteration.c"
}


Alteration* alteration_compress (Alteration* self, Alteration* other) {
	Alteration* result = NULL;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeMultiMap* compressed = NULL;
	GeeMultiMap* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp13_ = FALSE;
	Alteration* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GeeMultiMap* _tmp28_ = NULL;
	Alteration* _tmp29_ = NULL;
#line 291 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 291 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), NULL);
#line 292 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = other;
#line 292 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = alteration_equals (self, _tmp0_);
#line 292 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 2489 "Alteration.c"
		Alteration* _tmp2_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _alteration_ref0 (self);
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp2_;
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 2497 "Alteration.c"
	}
#line 297 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = alteration_create_map (self);
#line 297 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	compressed = _tmp3_;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = self->priv->subject;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp5_ != NULL) {
#line 2507 "Alteration.c"
		const gchar* _tmp6_ = NULL;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = self->priv->detail;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = _tmp6_ != NULL;
#line 2513 "Alteration.c"
	} else {
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = FALSE;
#line 2517 "Alteration.c"
	}
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp4_) {
#line 2521 "Alteration.c"
		GeeMultiMap* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = compressed;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = self->priv->subject;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = self->priv->detail;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp7_, _tmp8_, _tmp9_);
#line 2533 "Alteration.c"
	} else {
		GeeMultiMap* _tmp10_ = NULL;
		GeeMultiMap* _tmp11_ = NULL;
		GeeMultiMap* _tmp12_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = self->priv->map;
#line 302 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp10_ != NULL, "map != null");
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = compressed;
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = self->priv->map;
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_multimap_add_all (_tmp11_, _tmp12_);
#line 2548 "Alteration.c"
	}
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp14_ = other;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp15_ = _tmp14_->priv->subject;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp15_ != NULL) {
#line 2556 "Alteration.c"
		Alteration* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp16_ = other;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = _tmp16_->priv->detail;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = _tmp17_ != NULL;
#line 2565 "Alteration.c"
	} else {
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = FALSE;
#line 2569 "Alteration.c"
	}
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp13_) {
#line 2573 "Alteration.c"
		GeeMultiMap* _tmp18_ = NULL;
		Alteration* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		Alteration* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp18_ = compressed;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = other;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = _tmp19_->priv->subject;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp21_ = other;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = _tmp21_->priv->detail;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp18_, _tmp20_, _tmp22_);
#line 2591 "Alteration.c"
	} else {
		Alteration* _tmp23_ = NULL;
		GeeMultiMap* _tmp24_ = NULL;
		GeeMultiMap* _tmp25_ = NULL;
		Alteration* _tmp26_ = NULL;
		GeeMultiMap* _tmp27_ = NULL;
#line 309 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = other;
#line 309 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp24_ = _tmp23_->priv->map;
#line 309 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp24_ != NULL, "other.map != null");
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp25_ = compressed;
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp26_ = other;
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp27_ = _tmp26_->priv->map;
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_multimap_add_all (_tmp25_, _tmp27_);
#line 2612 "Alteration.c"
	}
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp28_ = compressed;
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp29_ = alteration_new_from_map (_tmp28_);
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp29_;
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (compressed);
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 2624 "Alteration.c"
}


static void value_alteration_init (GValue* value) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	value->data[0].v_pointer = NULL;
#line 2631 "Alteration.c"
}


static void value_alteration_free_value (GValue* value) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (value->data[0].v_pointer);
#line 2640 "Alteration.c"
	}
}


static void value_alteration_copy_value (const GValue* src_value, GValue* dest_value) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (src_value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		dest_value->data[0].v_pointer = alteration_ref (src_value->data[0].v_pointer);
#line 2650 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2654 "Alteration.c"
	}
}


static gpointer value_alteration_peek_pointer (const GValue* value) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return value->data[0].v_pointer;
#line 2662 "Alteration.c"
}


static gchar* value_alteration_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (collect_values[0].v_pointer) {
#line 2669 "Alteration.c"
		Alteration* object;
		object = collect_values[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (object->parent_instance.g_class == NULL) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2676 "Alteration.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2680 "Alteration.c"
		}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = alteration_ref (object);
#line 2684 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2688 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return NULL;
#line 2692 "Alteration.c"
}


static gchar* value_alteration_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Alteration** object_p;
	object_p = collect_values[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (!object_p) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2703 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (!value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = NULL;
#line 2709 "Alteration.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = value->data[0].v_pointer;
#line 2713 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = alteration_ref (value->data[0].v_pointer);
#line 2717 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return NULL;
#line 2721 "Alteration.c"
}


GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAlteration* spec;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ALTERATION), NULL);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return G_PARAM_SPEC (spec);
#line 2735 "Alteration.c"
}


gpointer value_get_alteration (const GValue* value) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION), NULL);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return value->data[0].v_pointer;
#line 2744 "Alteration.c"
}


void value_set_alteration (GValue* value, gpointer v_object) {
	Alteration* old;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	old = value->data[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (v_object) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = v_object;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_ref (value->data[0].v_pointer);
#line 2764 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2768 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (old) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (old);
#line 2774 "Alteration.c"
	}
}


void value_take_alteration (GValue* value, gpointer v_object) {
	Alteration* old;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	old = value->data[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (v_object) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = v_object;
#line 2793 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2797 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (old) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (old);
#line 2803 "Alteration.c"
	}
}


static void alteration_class_init (AlterationClass * klass) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	alteration_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	((AlterationClass *) klass)->finalize = alteration_finalize;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_type_class_add_private (klass, sizeof (AlterationPrivate));
#line 2815 "Alteration.c"
}


static void alteration_instance_init (Alteration * self) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv = ALTERATION_GET_PRIVATE (self);
#line 28 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->subject = NULL;
#line 29 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->detail = NULL;
#line 30 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->map = NULL;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->ref_count = 1;
#line 2830 "Alteration.c"
}


static void alteration_finalize (Alteration* obj) {
	Alteration * self;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ALTERATION, Alteration);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (self->priv->subject);
#line 29 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (self->priv->detail);
#line 30 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (self->priv->map);
#line 2846 "Alteration.c"
}


GType alteration_get_type (void) {
	static volatile gsize alteration_type_id__volatile = 0;
	if (g_once_init_enter (&alteration_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_alteration_init, value_alteration_free_value, value_alteration_copy_value, value_alteration_peek_pointer, "p", value_alteration_collect_value, "p", value_alteration_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlterationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alteration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Alteration), 0, (GInstanceInitFunc) alteration_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alteration_type_id;
		alteration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Alteration", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alteration_type_id__volatile, alteration_type_id);
	}
	return alteration_type_id__volatile;
}


gpointer alteration_ref (gpointer instance) {
	Alteration* self;
	self = instance;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_atomic_int_inc (&self->ref_count);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return instance;
#line 2871 "Alteration.c"
}


void alteration_unref (gpointer instance) {
	Alteration* self;
	self = instance;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		ALTERATION_GET_CLASS (self)->finalize (self);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2884 "Alteration.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



