/* PhotoMetadata.c generated by valac 0.34.7, the Vala compiler
 * generated from PhotoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* PhotoMetadata*/
/**/
/* PhotoMetadata is a wrapper class around gexiv2.  The reasoning for this is (a) to facilitiate*/
/* interface changes to meet Shotwell's requirements without needing modifications of the library*/
/* itself, and (b) some requirements for this class (i.e. obtaining raw metadata) is not available*/
/* in gexiv2, and so must be done by hand.*/
/**/
/* Although it's perceived that Exiv2 will remain Shotwell's metadata library of choice, this*/
/* may change in the future, and so this wrapper helps with that as well.*/
/**/
/* There is no expectation of thread-safety in this class (yet).*/
/**/
/* Tags come from Exiv2's naming scheme:*/
/* http://www.exiv2.org/metadata.html*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gexiv2/gexiv2.h>
#include <libexif/exif-data.h>
#include <gee.h>
#include <libexif/exif-mem.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_METADATA_DOMAIN (metadata_domain_get_type ())

#define TYPE_HIERARCHICAL_KEYWORD_FIELD (hierarchical_keyword_field_get_type ())
#define HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField))
#define HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))
#define IS_HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define IS_HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define HIERARCHICAL_KEYWORD_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))

typedef struct _HierarchicalKeywordField HierarchicalKeywordField;
typedef struct _HierarchicalKeywordFieldClass HierarchicalKeywordFieldClass;
typedef struct _HierarchicalKeywordFieldPrivate HierarchicalKeywordFieldPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecHierarchicalKeywordField ParamSpecHierarchicalKeywordField;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
typedef struct _PhotoPreviewPrivate PhotoPreviewPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPhotoPreview ParamSpecPhotoPreview;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
typedef struct _PhotoMetadataPrivate PhotoMetadataPrivate;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())
#define _exif_data_unref0(var) ((var == NULL) ? NULL : (var = (exif_data_unref (var), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
typedef struct _Block1Data Block1Data;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_METADATA_RATIONAL (metadata_rational_get_type ())
typedef struct _MetadataRational MetadataRational;
typedef struct _Block4Data Block4Data;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _exif_mem_unref0(var) ((var == NULL) ? NULL : (var = (exif_mem_unref (var), NULL)))

#define PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW (photo_metadata_internal_photo_preview_get_type ())
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))

typedef struct _PhotoMetadataInternalPhotoPreview PhotoMetadataInternalPhotoPreview;
typedef struct _PhotoMetadataInternalPhotoPreviewClass PhotoMetadataInternalPhotoPreviewClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_keyword_field_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_keyword_field_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_RATING (rating_get_type ())
typedef struct _PhotoMetadataInternalPhotoPreviewPrivate PhotoMetadataInternalPhotoPreviewPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	METADATA_DOMAIN_UNKNOWN,
	METADATA_DOMAIN_EXIF,
	METADATA_DOMAIN_XMP,
	METADATA_DOMAIN_IPTC
} MetadataDomain;

struct _HierarchicalKeywordField {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalKeywordFieldPrivate * priv;
	gchar* field_name;
	gchar* path_separator;
	gboolean wants_leading_separator;
	gboolean is_writeable;
};

struct _HierarchicalKeywordFieldClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalKeywordField *self);
};

struct _ParamSpecHierarchicalKeywordField {
	GParamSpec parent_instance;
};

struct _PhotoPreview {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoPreviewPrivate * priv;
};

struct _PhotoPreviewClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoPreview *self);
	guint8* (*flatten) (PhotoPreview* self, int* result_length1, GError** error);
	GdkPixbuf* (*get_pixbuf) (PhotoPreview* self, GError** error);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoPreviewPrivate {
	gchar* name;
	Dimensions dimensions;
	guint32 size;
	gchar* mime_type;
	gchar* extension;
};

struct _ParamSpecPhotoPreview {
	GParamSpec parent_instance;
};

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _PhotoMetadata {
	MediaMetadata parent_instance;
	PhotoMetadataPrivate * priv;
};

struct _PhotoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _PhotoMetadataPrivate {
	GExiv2Metadata* exiv2;
	ExifData* exif;
	gchar* source_name;
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

typedef void (*PhotoMetadataSetGenericValue) (const gchar* tag, void* user_data);
struct _Block1Data {
	int _ref_count_;
	PhotoMetadata* self;
	gchar* value;
};

struct _Block2Data {
	int _ref_count_;
	PhotoMetadata* self;
	GeeCollection* values;
};

struct _Block3Data {
	int _ref_count_;
	PhotoMetadata* self;
	glong value;
};

struct _MetadataRational {
	gint numerator;
	gint denominator;
};

struct _Block4Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataRational rational;
};

typedef enum  {
	METADATA_DATE_TIME_ERROR_INVALID_FORMAT,
	METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT
} MetadataDateTimeError;
#define METADATA_DATE_TIME_ERROR metadata_date_time_error_quark ()
struct _Block5Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataDateTime* date_time;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _PhotoMetadataInternalPhotoPreview {
	PhotoPreview parent_instance;
	PhotoMetadataInternalPhotoPreviewPrivate * priv;
	PhotoMetadata* owner;
	guint number;
};

struct _PhotoMetadataInternalPhotoPreviewClass {
	PhotoPreviewClass parent_class;
};


static gpointer hierarchical_keyword_field_parent_class = NULL;
static gpointer photo_preview_parent_class = NULL;
static gpointer photo_metadata_parent_class = NULL;
static gchar** photo_metadata_DATE_TIME_TAGS;
static gint photo_metadata_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS = NULL;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_EXPOSURE_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DIGITIZED_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_WIDTH_TAGS;
static gint photo_metadata_WIDTH_TAGS_length1;
static gchar** photo_metadata_WIDTH_TAGS = NULL;
static gint photo_metadata_WIDTH_TAGS_length1 = 0;
static gint _photo_metadata_WIDTH_TAGS_size_ = 0;
extern gchar** photo_metadata_HEIGHT_TAGS;
extern gint photo_metadata_HEIGHT_TAGS_length1;
gchar** photo_metadata_HEIGHT_TAGS = NULL;
gint photo_metadata_HEIGHT_TAGS_length1 = 0;
static gchar** photo_metadata_STANDARD_TITLE_TAGS;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1;
static gchar** photo_metadata_STANDARD_TITLE_TAGS = NULL;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1 = 0;
static gint _photo_metadata_STANDARD_TITLE_TAGS_size_ = 0;
static gchar** photo_metadata_KEYWORD_TAGS;
static gint photo_metadata_KEYWORD_TAGS_length1;
static gchar** photo_metadata_KEYWORD_TAGS = NULL;
static gint photo_metadata_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_KEYWORD_TAGS_size_ = 0;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS = NULL;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_HIERARCHICAL_KEYWORD_TAGS_size_ = 0;
static gchar** photo_metadata_ARTIST_TAGS;
static gint photo_metadata_ARTIST_TAGS_length1;
static gchar** photo_metadata_ARTIST_TAGS = NULL;
static gint photo_metadata_ARTIST_TAGS_length1 = 0;
static gint _photo_metadata_ARTIST_TAGS_size_ = 0;
static gchar** photo_metadata_RATING_TAGS;
static gint photo_metadata_RATING_TAGS_length1;
static gchar** photo_metadata_RATING_TAGS = NULL;
static gint photo_metadata_RATING_TAGS_length1 = 0;
static gint _photo_metadata_RATING_TAGS_size_ = 0;
static gpointer photo_metadata_internal_photo_preview_parent_class = NULL;

GType metadata_domain_get_type (void) G_GNUC_CONST;
gpointer hierarchical_keyword_field_ref (gpointer instance);
void hierarchical_keyword_field_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_keyword_field (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_keyword_field (GValue* value, gpointer v_object);
void value_take_hierarchical_keyword_field (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_keyword_field (const GValue* value);
GType hierarchical_keyword_field_get_type (void) G_GNUC_CONST;
enum  {
	HIERARCHICAL_KEYWORD_FIELD_DUMMY_PROPERTY
};
HierarchicalKeywordField* hierarchical_keyword_field_new (const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable);
HierarchicalKeywordField* hierarchical_keyword_field_construct (GType object_type, const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable);
static void hierarchical_keyword_field_finalize (HierarchicalKeywordField* obj);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define PHOTO_PREVIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_PREVIEW, PhotoPreviewPrivate))
enum  {
	PHOTO_PREVIEW_DUMMY_PROPERTY
};
PhotoPreview* photo_preview_construct (GType object_type, const gchar* name, Dimensions* dimensions, guint32 size, const gchar* mime_type, const gchar* extension);
gchar* photo_preview_get_name (PhotoPreview* self);
void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result);
guint32 photo_preview_get_size (PhotoPreview* self);
gchar* photo_preview_get_mime_type (PhotoPreview* self);
gchar* photo_preview_get_extension (PhotoPreview* self);
guint8* photo_preview_flatten (PhotoPreview* self, int* result_length1, GError** error);
static guint8* photo_preview_real_flatten (PhotoPreview* self, int* result_length1, GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error);
static GdkPixbuf* photo_preview_real_get_pixbuf (PhotoPreview* self, GError** error);
static guint8* _vala_array_dup4 (guint8* self, int length);
static void photo_preview_finalize (PhotoPreview* obj);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_METADATA, PhotoMetadataPrivate))
enum  {
	PHOTO_METADATA_DUMMY_PROPERTY
};
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_PREPARE_STRING_OPTIONS (((((PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE)
#define PHOTO_METADATA_IPHOTO_TITLE_TAG "Iptc.Application2.ObjectName"
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
MediaMetadata* media_metadata_construct (GType object_type);
static void photo_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error);
void photo_metadata_write_to_file (PhotoMetadata* self, GFile* file, GError** error);
void photo_metadata_read_from_buffer (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error);
MetadataDomain photo_metadata_get_tag_domain (const gchar* tag);
gboolean photo_metadata_has_domain (PhotoMetadata* self, MetadataDomain domain);
gboolean photo_metadata_has_exif (PhotoMetadata* self);
gboolean photo_metadata_has_xmp (PhotoMetadata* self);
gboolean photo_metadata_has_iptc (PhotoMetadata* self);
gboolean photo_metadata_can_write_to_domain (PhotoMetadata* self, MetadataDomain domain);
gboolean photo_metadata_can_write_exif (PhotoMetadata* self);
gboolean photo_metadata_can_write_xmp (PhotoMetadata* self);
gboolean photo_metadata_can_write_iptc (PhotoMetadata* self);
gboolean photo_metadata_has_tag (PhotoMetadata* self, const gchar* tag);
static GeeSet* photo_metadata_create_string_set (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_tags (PhotoMetadata* self, MetadataDomain domain, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_all_tags (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
gchar* photo_metadata_get_tag_label (PhotoMetadata* self, const gchar* tag);
gchar* photo_metadata_get_tag_description (PhotoMetadata* self, const gchar* tag);
gchar* photo_metadata_get_string (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options);
gchar* prepare_input_text (const gchar* text, PrepareInputTextOptions options, gint dest_length);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gchar* photo_metadata_get_string_interpreted (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options);
gchar* photo_metadata_get_first_string (PhotoMetadata* self, gchar** tags, int tags_length1);
gchar* photo_metadata_get_first_string_interpreted (PhotoMetadata* self, gchar** tags, int tags_length1);
GeeList* photo_metadata_get_string_multiple (PhotoMetadata* self, const gchar* tag);
GeeList* photo_metadata_get_first_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_set_string (PhotoMetadata* self, const gchar* tag, const gchar* value, PrepareInputTextOptions options);
static void photo_metadata_set_all_generic (PhotoMetadata* self, gchar** tags, int tags_length1, PhotoMetadataSetOption option, PhotoMetadataSetGenericValue setter, void* setter_target);
void photo_metadata_set_all_string (PhotoMetadata* self, gchar** tags, int tags_length1, const gchar* value, PhotoMetadataSetOption option);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, const gchar* tag);
static void ___lambda5__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
void photo_metadata_set_string_multiple (PhotoMetadata* self, const gchar* tag, GeeCollection* collection);
static void _vala_array_add45 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add46 (gchar*** array, int* length, int* size, gchar* value);
void photo_metadata_set_all_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1, GeeCollection* values, PhotoMetadataSetOption option);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_, const gchar* tag);
static void ___lambda6__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
gboolean photo_metadata_get_long (PhotoMetadata* self, const gchar* tag, glong* value);
gboolean photo_metadata_get_first_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong* value);
void photo_metadata_set_long (PhotoMetadata* self, const gchar* tag, glong value);
void photo_metadata_set_all_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong value, PhotoMetadataSetOption option);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_, const gchar* tag);
static void ___lambda7__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
GType metadata_rational_get_type (void) G_GNUC_CONST;
MetadataRational* metadata_rational_dup (const MetadataRational* self);
void metadata_rational_free (MetadataRational* self);
gboolean photo_metadata_get_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational);
void metadata_rational_init (MetadataRational *self, gint numerator, gint denominator);
gboolean photo_metadata_get_first_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational);
void photo_metadata_set_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational);
gchar* metadata_rational_to_string (MetadataRational *self);
void photo_metadata_set_all_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational, PhotoMetadataSetOption option);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_, const gchar* tag);
static void ___lambda8__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
MetadataDateTime* photo_metadata_get_date_time (PhotoMetadata* self, const gchar* tag);
GQuark metadata_date_time_error_quark (void);
MetadataDateTime* metadata_date_time_new_from_xmp (const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_construct_from_xmp (GType object_type, const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_new_from_exif (const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_construct_from_exif (GType object_type, const gchar* label, GError** error);
MetadataDateTime* photo_metadata_get_first_date_time (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_set_date_time (PhotoMetadata* self, const gchar* tag, MetadataDateTime* date_time);
gchar* metadata_date_time_get_exif_label (MetadataDateTime* self);
gchar* metadata_date_time_get_xmp_label (MetadataDateTime* self);
const gchar* metadata_domain_to_string (MetadataDomain self);
void photo_metadata_set_all_date_time (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataDateTime* date_time, PhotoMetadataSetOption option);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_, const gchar* tag);
static void ___lambda9__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1);
guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1);
static guint8* _vala_array_dup5 (guint8* self, int length);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_new (PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_construct (GType object_type, PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props);
static GType photo_metadata_internal_photo_preview_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag);
void photo_metadata_remove_tags (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_clear_domain (PhotoMetadata* self, MetadataDomain domain);
void photo_metadata_clear (PhotoMetadata* self);
MetadataDateTime* photo_metadata_get_modification_date_time (PhotoMetadata* self);
void photo_metadata_set_modification_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_digitized_date_time (PhotoMetadata* self);
void photo_metadata_set_digitized_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
static MetadataDateTime* photo_metadata_real_get_creation_date_time (MediaMetadata* base);
Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
void dimensions_init (Dimensions *self, gint width, gint height);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_title (MediaMetadata* base);
gboolean is_string_empty (const gchar* s);
void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_comment (MediaMetadata* base);
void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
static void photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self, HierarchicalTagIndex* index);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
#define TAG_PATH_SEPARATOR_STRING "/"
void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option);
HierarchicalTagIndex* hierarchical_tag_index_new (void);
HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
void hierarchical_tag_index_add_path (HierarchicalTagIndex* self, const gchar* tag, const gchar* path);
GeeCollection* hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag, const gchar* foreign_separator);
gboolean photo_metadata_has_orientation (PhotoMetadata* self);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation);
gboolean photo_metadata_get_gps (PhotoMetadata* self, gdouble* longitude, gchar** long_ref, gdouble* latitude, gchar** lat_ref, gdouble* altitude);
gboolean photo_metadata_get_exposure (PhotoMetadata* self, MetadataRational* exposure);
gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
gboolean metadata_rational_is_valid (MetadataRational *self);
gboolean photo_metadata_get_iso (PhotoMetadata* self, glong* iso);
gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
gboolean photo_metadata_get_aperture (PhotoMetadata* self, MetadataRational* aperture);
gchar* photo_metadata_get_aperture_string (PhotoMetadata* self, gboolean pango_formatted);
gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
gboolean photo_metadata_get_flash (PhotoMetadata* self, glong* flash);
gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
gboolean photo_metadata_get_focal_length (PhotoMetadata* self, MetadataRational* focal_length);
gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
gchar* photo_metadata_get_artist (PhotoMetadata* self);
gchar* photo_metadata_get_copyright (PhotoMetadata* self);
gchar* photo_metadata_get_software (PhotoMetadata* self);
void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version);
void photo_metadata_remove_software (PhotoMetadata* self);
gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
GType rating_get_type (void) G_GNUC_CONST;
Rating photo_metadata_get_rating (PhotoMetadata* self);
Rating rating_unserialize (gint value);
void photo_metadata_set_rating (PhotoMetadata* self, Rating rating);
gint rating_serialize (Rating self);
enum  {
	PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_DUMMY_PROPERTY
};
static guint8* photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base, int* result_length1, GError** error);
static guint8* _vala_array_dup6 (guint8* self, int length);
static void photo_metadata_internal_photo_preview_finalize (PhotoPreview* obj);
static void photo_metadata_finalize (MediaMetadata* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint RESOURCES_rating_thresholds[6];

GType metadata_domain_get_type (void) {
	static volatile gsize metadata_domain_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_domain_type_id__volatile)) {
		static const GEnumValue values[] = {{METADATA_DOMAIN_UNKNOWN, "METADATA_DOMAIN_UNKNOWN", "unknown"}, {METADATA_DOMAIN_EXIF, "METADATA_DOMAIN_EXIF", "exif"}, {METADATA_DOMAIN_XMP, "METADATA_DOMAIN_XMP", "xmp"}, {METADATA_DOMAIN_IPTC, "METADATA_DOMAIN_IPTC", "iptc"}, {0, NULL, NULL}};
		GType metadata_domain_type_id;
		metadata_domain_type_id = g_enum_register_static ("MetadataDomain", values);
		g_once_init_leave (&metadata_domain_type_id__volatile, metadata_domain_type_id);
	}
	return metadata_domain_type_id__volatile;
}


HierarchicalKeywordField* hierarchical_keyword_field_construct (GType object_type, const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable) {
	HierarchicalKeywordField* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (field_name != NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (path_separator != NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (HierarchicalKeywordField*) g_type_create_instance (object_type);
#line 39 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = field_name;
#line 39 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 39 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 39 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->field_name = _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = path_separator;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->path_separator = _tmp3_;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = wants_leading_separator;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->wants_leading_separator = _tmp4_;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = is_writeable;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->is_writeable = _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 674 "PhotoMetadata.c"
}


HierarchicalKeywordField* hierarchical_keyword_field_new (const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable) {
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return hierarchical_keyword_field_construct (TYPE_HIERARCHICAL_KEYWORD_FIELD, field_name, path_separator, wants_leading_separator, is_writeable);
#line 681 "PhotoMetadata.c"
}


static void value_hierarchical_keyword_field_init (GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 688 "PhotoMetadata.c"
}


static void value_hierarchical_keyword_field_free_value (GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (value->data[0].v_pointer);
#line 697 "PhotoMetadata.c"
	}
}


static void value_hierarchical_keyword_field_copy_value (const GValue* src_value, GValue* dest_value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = hierarchical_keyword_field_ref (src_value->data[0].v_pointer);
#line 707 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 711 "PhotoMetadata.c"
	}
}


static gpointer value_hierarchical_keyword_field_peek_pointer (const GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 719 "PhotoMetadata.c"
}


static gchar* value_hierarchical_keyword_field_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 726 "PhotoMetadata.c"
		HierarchicalKeywordField* object;
		object = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 733 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 737 "PhotoMetadata.c"
		}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = hierarchical_keyword_field_ref (object);
#line 741 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 745 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 749 "PhotoMetadata.c"
}


static gchar* value_hierarchical_keyword_field_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HierarchicalKeywordField** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 760 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 766 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 770 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 774 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 778 "PhotoMetadata.c"
}


GParamSpec* param_spec_hierarchical_keyword_field (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHierarchicalKeywordField* spec;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 792 "PhotoMetadata.c"
}


gpointer value_get_hierarchical_keyword_field (const GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 801 "PhotoMetadata.c"
}


void value_set_hierarchical_keyword_field (GValue* value, gpointer v_object) {
	HierarchicalKeywordField* old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 821 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 825 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 831 "PhotoMetadata.c"
	}
}


void value_take_hierarchical_keyword_field (GValue* value, gpointer v_object) {
	HierarchicalKeywordField* old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 850 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 854 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 860 "PhotoMetadata.c"
	}
}


static void hierarchical_keyword_field_class_init (HierarchicalKeywordFieldClass * klass) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	hierarchical_keyword_field_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((HierarchicalKeywordFieldClass *) klass)->finalize = hierarchical_keyword_field_finalize;
#line 870 "PhotoMetadata.c"
}


static void hierarchical_keyword_field_instance_init (HierarchicalKeywordField * self) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 877 "PhotoMetadata.c"
}


static void hierarchical_keyword_field_finalize (HierarchicalKeywordField* obj) {
	HierarchicalKeywordField * self;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 33 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 891 "PhotoMetadata.c"
}


GType hierarchical_keyword_field_get_type (void) {
	static volatile gsize hierarchical_keyword_field_type_id__volatile = 0;
	if (g_once_init_enter (&hierarchical_keyword_field_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hierarchical_keyword_field_init, value_hierarchical_keyword_field_free_value, value_hierarchical_keyword_field_copy_value, value_hierarchical_keyword_field_peek_pointer, "p", value_hierarchical_keyword_field_collect_value, "p", value_hierarchical_keyword_field_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HierarchicalKeywordFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_keyword_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalKeywordField), 0, (GInstanceInitFunc) hierarchical_keyword_field_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hierarchical_keyword_field_type_id;
		hierarchical_keyword_field_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalKeywordField", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hierarchical_keyword_field_type_id__volatile, hierarchical_keyword_field_type_id);
	}
	return hierarchical_keyword_field_type_id__volatile;
}


gpointer hierarchical_keyword_field_ref (gpointer instance) {
	HierarchicalKeywordField* self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 916 "PhotoMetadata.c"
}


void hierarchical_keyword_field_unref (gpointer instance) {
	HierarchicalKeywordField* self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		HIERARCHICAL_KEYWORD_FIELD_GET_CLASS (self)->finalize (self);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 929 "PhotoMetadata.c"
	}
}


PhotoPreview* photo_preview_construct (GType object_type, const gchar* name, Dimensions* dimensions, guint32 size, const gchar* mime_type, const gchar* extension) {
	PhotoPreview* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	guint32 _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (dimensions != NULL, NULL);
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoPreview*) g_type_create_instance (object_type);
#line 54 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 54 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 54 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 54 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->name = _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = *dimensions;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->dimensions = _tmp2_;
#line 56 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = size;
#line 56 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->size = _tmp3_;
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = mime_type;
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->mime_type = _tmp5_;
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = extension;
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->extension = _tmp7_;
#line 53 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 988 "PhotoMetadata.c"
}


gchar* photo_preview_get_name (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->name;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1006 "PhotoMetadata.c"
}


void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result) {
	Dimensions _tmp0_ = {0};
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_PREVIEW (self));
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->dimensions;
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	*result = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return;
#line 1020 "PhotoMetadata.c"
}


guint32 photo_preview_get_size (PhotoPreview* self) {
	guint32 result = 0U;
	guint32 _tmp0_ = 0U;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), 0U);
#line 70 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->size;
#line 70 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 70 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1035 "PhotoMetadata.c"
}


gchar* photo_preview_get_mime_type (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 74 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->mime_type;
#line 74 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 74 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1053 "PhotoMetadata.c"
}


gchar* photo_preview_get_extension (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 78 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->extension;
#line 78 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 78 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1071 "PhotoMetadata.c"
}


static guint8* photo_preview_real_flatten (PhotoPreview* self, int* result_length1, GError** error) {
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_preview_flatten'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1080 "PhotoMetadata.c"
}


guint8* photo_preview_flatten (PhotoPreview* self, int* result_length1, GError** error) {
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->flatten (self, result_length1, error);
#line 1089 "PhotoMetadata.c"
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1096 "PhotoMetadata.c"
}


static GdkPixbuf* photo_preview_real_get_pixbuf (PhotoPreview* self, GError** error) {
	GdkPixbuf* result = NULL;
	guint8* flattened = NULL;
	gint _tmp0_ = 0;
	guint8* _tmp1_ = NULL;
	gint flattened_length1 = 0;
	gint _flattened_size_ = 0;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_preview_flatten (self, &_tmp0_, &_inner_error_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened_length1 = _tmp0_;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_flattened_size_ = flattened_length1;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return NULL;
#line 1122 "PhotoMetadata.c"
	}
	{
		GdkPixbuf* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		GMemoryInputStream* _tmp4_ = NULL;
		GMemoryInputStream* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (flattened != NULL) ? _vala_array_dup4 (flattened, flattened_length1) : ((gpointer) flattened);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3__length1 = flattened_length1;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp5_);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = _tmp7_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1151 "PhotoMetadata.c"
			goto __catch25_g_error;
		}
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = _tmp2_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp8_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp2_);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 1166 "PhotoMetadata.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = self->priv->name;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = err;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp10_->message;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:92: Unable to decode thumbnail for %s: %s", _tmp9_, _tmp11_);
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 1195 "PhotoMetadata.c"
	}
	__finally25:
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = (g_free (flattened), NULL);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1204 "PhotoMetadata.c"
}


GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error) {
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 83 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->get_pixbuf (self, error);
#line 1213 "PhotoMetadata.c"
}


static void value_photo_preview_init (GValue* value) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1220 "PhotoMetadata.c"
}


static void value_photo_preview_free_value (GValue* value) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (value->data[0].v_pointer);
#line 1229 "PhotoMetadata.c"
	}
}


static void value_photo_preview_copy_value (const GValue* src_value, GValue* dest_value) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = photo_preview_ref (src_value->data[0].v_pointer);
#line 1239 "PhotoMetadata.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1243 "PhotoMetadata.c"
	}
}


static gpointer value_photo_preview_peek_pointer (const GValue* value) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1251 "PhotoMetadata.c"
}


static gchar* value_photo_preview_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1258 "PhotoMetadata.c"
		PhotoPreview* object;
		object = collect_values[0].v_pointer;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1265 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1269 "PhotoMetadata.c"
		}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = photo_preview_ref (object);
#line 1273 "PhotoMetadata.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1277 "PhotoMetadata.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1281 "PhotoMetadata.c"
}


static gchar* value_photo_preview_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoPreview** object_p;
	object_p = collect_values[0].v_pointer;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1292 "PhotoMetadata.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 1298 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1302 "PhotoMetadata.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = photo_preview_ref (value->data[0].v_pointer);
#line 1306 "PhotoMetadata.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1310 "PhotoMetadata.c"
}


GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoPreview* spec;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_PREVIEW), NULL);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1324 "PhotoMetadata.c"
}


gpointer value_get_photo_preview (const GValue* value) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW), NULL);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1333 "PhotoMetadata.c"
}


void value_set_photo_preview (GValue* value, gpointer v_object) {
	PhotoPreview* old;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_ref (value->data[0].v_pointer);
#line 1353 "PhotoMetadata.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1357 "PhotoMetadata.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 1363 "PhotoMetadata.c"
	}
}


void value_take_photo_preview (GValue* value, gpointer v_object) {
	PhotoPreview* old;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1382 "PhotoMetadata.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1386 "PhotoMetadata.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 1392 "PhotoMetadata.c"
	}
}


static void photo_preview_class_init (PhotoPreviewClass * klass) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_preview_finalize;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoPreviewPrivate));
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = (guint8* (*)(PhotoPreview*, int*, GError**)) photo_preview_real_flatten;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->get_pixbuf = (GdkPixbuf* (*)(PhotoPreview*, GError**)) photo_preview_real_get_pixbuf;
#line 1408 "PhotoMetadata.c"
}


static void photo_preview_instance_init (PhotoPreview * self) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_PREVIEW_GET_PRIVATE (self);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 1417 "PhotoMetadata.c"
}


static void photo_preview_finalize (PhotoPreview* obj) {
	PhotoPreview * self;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 51 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 1433 "PhotoMetadata.c"
}


GType photo_preview_get_type (void) {
	static volatile gsize photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_preview_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_preview_init, value_photo_preview_free_value, value_photo_preview_copy_value, value_photo_preview_peek_pointer, "p", value_photo_preview_collect_value, "p", value_photo_preview_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoPreview), 0, (GInstanceInitFunc) photo_preview_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_preview_type_id;
		photo_preview_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoPreview", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_preview_type_id__volatile, photo_preview_type_id);
	}
	return photo_preview_type_id__volatile;
}


gpointer photo_preview_ref (gpointer instance) {
	PhotoPreview* self;
	self = instance;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 1458 "PhotoMetadata.c"
}


void photo_preview_unref (gpointer instance) {
	PhotoPreview* self;
	self = instance;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		PHOTO_PREVIEW_GET_CLASS (self)->finalize (self);
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1471 "PhotoMetadata.c"
	}
}


GType photo_metadata_set_option_get_type (void) {
	static volatile gsize photo_metadata_set_option_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_set_option_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_METADATA_SET_OPTION_ALL_DOMAINS, "PHOTO_METADATA_SET_OPTION_ALL_DOMAINS", "all-domains"}, {PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT, "PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT", "only-if-domain-present"}, {PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN, "PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN", "at-least-default-domain"}, {0, NULL, NULL}};
		GType photo_metadata_set_option_type_id;
		photo_metadata_set_option_type_id = g_enum_register_static ("PhotoMetadataSetOption", values);
		g_once_init_leave (&photo_metadata_set_option_type_id__volatile, photo_metadata_set_option_type_id);
	}
	return photo_metadata_set_option_type_id__volatile;
}


PhotoMetadata* photo_metadata_construct (GType object_type) {
	PhotoMetadata* self = NULL;
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadata*) media_metadata_construct (object_type);
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1494 "PhotoMetadata.c"
}


PhotoMetadata* photo_metadata_new (void) {
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_construct (TYPE_PHOTO_METADATA);
#line 1501 "PhotoMetadata.c"
}


static void photo_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error) {
	PhotoMetadata * self;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Metadata* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	ExifData* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = file;
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_file_get_path (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_path (_tmp1_, _tmp4_, &_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp4_);
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1551 "PhotoMetadata.c"
	}
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = file;
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = exif_data_new_from_file (_tmp7_);
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp8_;
#line 147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp7_);
#line 148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = file;
#line 148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = g_file_get_basename (_tmp9_);
#line 148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp10_;
#line 1575 "PhotoMetadata.c"
}


void photo_metadata_write_to_file (PhotoMetadata* self, GFile* file, GError** error) {
	GExiv2Metadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = file;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_save_file (_tmp0_, _tmp3_, &_inner_error_);
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1607 "PhotoMetadata.c"
	}
}


void photo_metadata_read_from_buffer (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error) {
	gint _tmp0_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	GExiv2Metadata* _tmp4_ = NULL;
	GExiv2Metadata* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	guint8* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	ExifData* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = length;
#line 156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ <= 0) {
#line 1635 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 157 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = buffer;
#line 157 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = buffer_length1;
#line 157 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		length = _tmp1__length1;
#line 1644 "PhotoMetadata.c"
	}
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = buffer;
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = buffer_length1;
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = length;
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp2__length1 >= _tmp3_, "buffer.length >= length");
#line 161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_new ();
#line 161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp4_;
#line 162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = self->priv->exiv2;
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = buffer;
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = buffer_length1;
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = length;
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_buf (_tmp5_, _tmp6_, (glong) _tmp7_, &_inner_error_);
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1680 "PhotoMetadata.c"
	}
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = buffer;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8__length1 = buffer_length1;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = length;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = exif_data_new_from_data (_tmp8_, (gsize) _tmp9_);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp10_;
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = length;
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf ("<memory buffer %d bytes>", _tmp11_);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp12_;
#line 1702 "PhotoMetadata.c"
}


void photo_metadata_read_from_app1_segment (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error) {
	gint _tmp0_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	GExiv2Metadata* _tmp4_ = NULL;
	GExiv2Metadata* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	guint8* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	ExifData* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = length;
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ <= 0) {
#line 1729 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = buffer;
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = buffer_length1;
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		length = _tmp1__length1;
#line 1738 "PhotoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = buffer;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = buffer_length1;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = length;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp2__length1 >= _tmp3_, "buffer.length >= length");
#line 175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_new ();
#line 175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp4_;
#line 176 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 176 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = self->priv->exiv2;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = buffer;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = buffer_length1;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = length;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_from_app1_segment (_tmp5_, _tmp6_, (glong) _tmp7_, &_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1774 "PhotoMetadata.c"
	}
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = buffer;
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8__length1 = buffer_length1;
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = length;
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = exif_data_new_from_data (_tmp8_, (gsize) _tmp9_);
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 179 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp10_;
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = length;
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf ("<app1 segment %d bytes>", _tmp11_);
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp12_;
#line 1796 "PhotoMetadata.c"
}


MetadataDomain photo_metadata_get_tag_domain (const gchar* tag) {
	MetadataDomain result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 183 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_is_exif_tag (_tmp0_);
#line 184 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 185 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_EXIF;
#line 185 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 1820 "PhotoMetadata.c"
	}
#line 187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tag;
#line 187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = gexiv2_metadata_is_xmp_tag (_tmp2_);
#line 187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 188 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_XMP;
#line 188 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 1832 "PhotoMetadata.c"
	}
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = tag;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = gexiv2_metadata_is_iptc_tag (_tmp4_);
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_) {
#line 191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_IPTC;
#line 191 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 1844 "PhotoMetadata.c"
	}
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = METADATA_DOMAIN_UNKNOWN;
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1850 "PhotoMetadata.c"
}


gboolean photo_metadata_has_domain (PhotoMetadata* self, MetadataDomain domain) {
	gboolean result = FALSE;
	MetadataDomain _tmp0_ = 0;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 1865 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = gexiv2_metadata_has_exif (_tmp1_);
#line 199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 1877 "PhotoMetadata.c"
		}
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 1881 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gexiv2_metadata_has_xmp (_tmp3_);
#line 202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp4_;
#line 202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 1893 "PhotoMetadata.c"
		}
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 1897 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 205 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = self->priv->exiv2;
#line 205 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gexiv2_metadata_has_iptc (_tmp5_);
#line 205 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp6_;
#line 205 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 1909 "PhotoMetadata.c"
		}
		default:
#line 197 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 1914 "PhotoMetadata.c"
		{
#line 209 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 209 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 1920 "PhotoMetadata.c"
		}
	}
}


gboolean photo_metadata_has_exif (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 213 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_EXIF);
#line 214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 214 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1937 "PhotoMetadata.c"
}


gboolean photo_metadata_has_xmp (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_XMP);
#line 218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 218 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1952 "PhotoMetadata.c"
}


gboolean photo_metadata_has_iptc (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_IPTC);
#line 222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 222 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1967 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_to_domain (PhotoMetadata* self, MetadataDomain domain) {
	gboolean result = FALSE;
	MetadataDomain _tmp0_ = 0;
#line 225 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 1982 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = gexiv2_metadata_get_supports_exif (_tmp1_);
#line 228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp2_;
#line 228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 1994 "PhotoMetadata.c"
		}
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 1998 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gexiv2_metadata_get_supports_xmp (_tmp3_);
#line 231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp4_;
#line 231 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2010 "PhotoMetadata.c"
		}
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 2014 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = self->priv->exiv2;
#line 234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gexiv2_metadata_get_supports_iptc (_tmp5_);
#line 234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp6_;
#line 234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2026 "PhotoMetadata.c"
		}
		default:
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 2031 "PhotoMetadata.c"
		{
#line 238 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 238 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2037 "PhotoMetadata.c"
		}
	}
}


gboolean photo_metadata_can_write_exif (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_EXIF);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2054 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_xmp (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 246 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_XMP);
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2069 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_iptc (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_IPTC);
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2084 "PhotoMetadata.c"
}


gboolean photo_metadata_has_tag (PhotoMetadata* self, const gchar* tag) {
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_has_tag (_tmp0_, _tmp1_);
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2107 "PhotoMetadata.c"
}


static GeeSet* photo_metadata_create_string_set (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeSet* result = NULL;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = compare_func;
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target = compare_func_target;
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ == NULL) {
#line 2123 "PhotoMetadata.c"
		GeeHashSet* _tmp1_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 261 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2139 "PhotoMetadata.c"
	} else {
		GCompareDataFunc _tmp2_ = NULL;
		void* _tmp2__target = NULL;
		GDestroyNotify _tmp2__target_destroy_notify = NULL;
		GeeTreeSet* _tmp3_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = compare_func;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__target = compare_func_target;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__target_destroy_notify = compare_func_target_destroy_notify;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2171 "PhotoMetadata.c"
	}
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 2181 "PhotoMetadata.c"
}


GeeCollection* photo_metadata_get_tags (PhotoMetadata* self, MetadataDomain domain, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeCollection* result = NULL;
	gchar** tags = NULL;
	gint tags_length1 = 0;
	gint _tags_size_ = 0;
	MetadataDomain _tmp0_ = 0;
	gboolean _tmp10_ = FALSE;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GeeCollection* collection = NULL;
	GCompareDataFunc _tmp13_ = NULL;
	void* _tmp13__target = NULL;
	GDestroyNotify _tmp13__target_destroy_notify = NULL;
	GeeSet* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = NULL;
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags_length1 = 0;
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tags_size_ = tags_length1;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 2215 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gchar** _tmp2_ = NULL;
			gchar** _tmp3_ = NULL;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _tmp2_ = gexiv2_metadata_get_exif_tags (_tmp1_);
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp3_;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp2_);
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 272 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 2234 "PhotoMetadata.c"
		}
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 2238 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp4_ = NULL;
			gchar** _tmp5_ = NULL;
			gchar** _tmp6_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = self->priv->exiv2;
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = _tmp5_ = gexiv2_metadata_get_xmp_tags (_tmp4_);
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp6_;
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp5_);
#line 275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 2257 "PhotoMetadata.c"
		}
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 2261 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp7_ = NULL;
			gchar** _tmp8_ = NULL;
			gchar** _tmp9_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = self->priv->exiv2;
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = _tmp8_ = gexiv2_metadata_get_iptc_tags (_tmp7_);
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp9_;
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp8_);
#line 279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 2280 "PhotoMetadata.c"
		}
		default:
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 2285 "PhotoMetadata.c"
	}
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = tags;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11__length1 = tags_length1;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ == NULL) {
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = TRUE;
#line 2295 "PhotoMetadata.c"
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = tags;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12__length1 = tags_length1;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp12__length1 == 0;
#line 2305 "PhotoMetadata.c"
	}
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2323 "PhotoMetadata.c"
	}
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = compare_func;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13__target = compare_func_target;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13__target_destroy_notify = compare_func_target_destroy_notify;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = photo_metadata_create_string_set (self, _tmp13_, _tmp13__target, _tmp13__target_destroy_notify);
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection);
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = tags;
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15__length1 = tags_length1;
#line 2345 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp15_;
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp15__length1;
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp15__length1; tag_it = tag_it + 1) {
#line 2357 "PhotoMetadata.c"
			gchar* _tmp16_ = NULL;
			gchar* tag = NULL;
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp16_ = g_strdup (tag_collection[tag_it]);
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp16_;
#line 2364 "PhotoMetadata.c"
			{
				GeeCollection* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = collection;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp18_ = tag;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				gee_collection_add (_tmp17_, _tmp18_);
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 2376 "PhotoMetadata.c"
			}
		}
	}
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = collection;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2394 "PhotoMetadata.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? g_object_ref (self) : NULL;
#line 2401 "PhotoMetadata.c"
}


GeeCollection* photo_metadata_get_all_tags (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeCollection* result = NULL;
	GeeCollection* all_tags = NULL;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeCollection* exif_tags = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	GeeCollection* xmp_tags = NULL;
	GeeCollection* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_ = NULL;
	GeeCollection* iptc_tags = NULL;
	GeeCollection* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_ = NULL;
	GeeCollection* _tmp26_ = NULL;
	GeeCollection* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GeeCollection* _tmp31_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = compare_func;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target = compare_func_target;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target_destroy_notify = compare_func_target_destroy_notify;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_create_string_set (self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	all_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_tags (self, METADATA_DOMAIN_EXIF, NULL, NULL, NULL);
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_tags = _tmp2_;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = exif_tags;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 2455 "PhotoMetadata.c"
		GeeCollection* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = exif_tags;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp7_ > 0;
#line 2467 "PhotoMetadata.c"
	} else {
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = FALSE;
#line 2471 "PhotoMetadata.c"
	}
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 2475 "PhotoMetadata.c"
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = all_tags;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = exif_tags;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp8_, _tmp9_);
#line 2484 "PhotoMetadata.c"
	}
#line 301 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = photo_metadata_get_tags (self, METADATA_DOMAIN_XMP, NULL, NULL, NULL);
#line 301 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	xmp_tags = _tmp10_;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = xmp_tags;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp12_ != NULL) {
#line 2494 "PhotoMetadata.c"
		GeeCollection* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = xmp_tags;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = gee_collection_get_size (_tmp13_);
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp15_ > 0;
#line 2506 "PhotoMetadata.c"
	} else {
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = FALSE;
#line 2510 "PhotoMetadata.c"
	}
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_) {
#line 2514 "PhotoMetadata.c"
		GeeCollection* _tmp16_ = NULL;
		GeeCollection* _tmp17_ = NULL;
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = all_tags;
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = xmp_tags;
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp16_, _tmp17_);
#line 2523 "PhotoMetadata.c"
	}
#line 305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = photo_metadata_get_tags (self, METADATA_DOMAIN_IPTC, NULL, NULL, NULL);
#line 305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iptc_tags = _tmp18_;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = iptc_tags;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp20_ != NULL) {
#line 2533 "PhotoMetadata.c"
		GeeCollection* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = iptc_tags;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = gee_collection_get_size (_tmp21_);
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp22_;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp23_ > 0;
#line 2545 "PhotoMetadata.c"
	} else {
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 2549 "PhotoMetadata.c"
	}
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 2553 "PhotoMetadata.c"
		GeeCollection* _tmp24_ = NULL;
		GeeCollection* _tmp25_ = NULL;
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = all_tags;
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = iptc_tags;
#line 307 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp24_, _tmp25_);
#line 2562 "PhotoMetadata.c"
	}
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = all_tags;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = gee_collection_get_size (_tmp27_);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = _tmp28_;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp29_ > 0) {
#line 2572 "PhotoMetadata.c"
		GeeCollection* _tmp30_ = NULL;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp30_ = all_tags;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = _tmp30_;
#line 2578 "PhotoMetadata.c"
	} else {
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = NULL;
#line 2582 "PhotoMetadata.c"
	}
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = _g_object_ref0 (_tmp26_);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp31_;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (iptc_tags);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (xmp_tags);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (exif_tags);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (all_tags);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2606 "PhotoMetadata.c"
}


gchar* photo_metadata_get_tag_label (PhotoMetadata* self, const gchar* tag) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 312 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 312 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 313 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 313 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_label (_tmp0_);
#line 313 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 313 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 313 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2629 "PhotoMetadata.c"
}


gchar* photo_metadata_get_tag_description (PhotoMetadata* self, const gchar* tag) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 316 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 316 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_description (_tmp0_);
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2652 "PhotoMetadata.c"
}


gchar* photo_metadata_get_string (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options) {
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	PrepareInputTextOptions _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 320 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 320 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_get_tag_string (_tmp0_, _tmp1_);
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = options;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = prepare_input_text (_tmp3_, _tmp4_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = _tmp5_;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp6_;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2689 "PhotoMetadata.c"
}


gchar* photo_metadata_get_string_interpreted (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options) {
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	PrepareInputTextOptions _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_get_tag_interpreted_string (_tmp0_, _tmp1_);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = options;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = prepare_input_text (_tmp3_, _tmp4_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = _tmp5_;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp6_;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2726 "PhotoMetadata.c"
}


gchar* photo_metadata_get_first_string (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 328 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 2740 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 2752 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 2759 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string (self, _tmp2_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp3_;
#line 331 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = value;
#line 331 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 332 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 332 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 332 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 2781 "PhotoMetadata.c"
				}
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 2787 "PhotoMetadata.c"
			}
		}
	}
#line 335 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 335 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2795 "PhotoMetadata.c"
}


gchar* photo_metadata_get_first_string_interpreted (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 2809 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 2821 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 2828 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_interpreted (self, _tmp2_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp3_;
#line 341 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = value;
#line 341 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 342 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 342 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 342 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 2850 "PhotoMetadata.c"
				}
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 339 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 2856 "PhotoMetadata.c"
			}
		}
	}
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2864 "PhotoMetadata.c"
}


GeeList* photo_metadata_get_string_multiple (PhotoMetadata* self, const gchar* tag) {
	GeeList* result = NULL;
	gchar** values = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GeeList* list = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GeeList* _tmp22_ = NULL;
	GeeList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GeeList* _tmp27_ = NULL;
#line 354 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 354 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_ = gexiv2_metadata_get_tag_multiple (_tmp0_, _tmp1_);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp3_;
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = _vala_array_length (_tmp2_);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = values;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = values_length1;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ == NULL) {
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = TRUE;
#line 2915 "PhotoMetadata.c"
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = values;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6__length1 = values_length1;
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = _tmp6__length1 == 0;
#line 2925 "PhotoMetadata.c"
	}
#line 356 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2935 "PhotoMetadata.c"
	}
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_LIST, GeeList);
#line 361 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 361 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = _tmp8_;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = values;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9__length1 = values_length1;
#line 2949 "PhotoMetadata.c"
	{
		gchar** value_collection = NULL;
		gint value_collection_length1 = 0;
		gint _value_collection_size_ = 0;
		gint value_it = 0;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection = _tmp9_;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection_length1 = _tmp9__length1;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (value_it = 0; value_it < _tmp9__length1; value_it = value_it + 1) {
#line 2961 "PhotoMetadata.c"
			gchar* _tmp10_ = NULL;
			gchar* value = NULL;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = g_strdup (value_collection[value_it]);
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = _tmp10_;
#line 2968 "PhotoMetadata.c"
			{
				gchar* prepped = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_ = NULL;
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = value;
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = prepare_input_text (_tmp11_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				prepped = _tmp12_;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = prepped;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp14_ != NULL) {
#line 2985 "PhotoMetadata.c"
					GeeHashSet* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp15_ = collection;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp16_ = prepped;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = !_tmp17_;
#line 2997 "PhotoMetadata.c"
				} else {
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = FALSE;
#line 3001 "PhotoMetadata.c"
				}
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp13_) {
#line 3005 "PhotoMetadata.c"
					GeeList* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GeeHashSet* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp18_ = list;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp19_ = prepped;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp19_);
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp20_ = collection;
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp21_ = prepped;
#line 368 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 3022 "PhotoMetadata.c"
				}
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (prepped);
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 3028 "PhotoMetadata.c"
			}
		}
	}
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = list;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = _tmp24_;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp25_ > 0) {
#line 3040 "PhotoMetadata.c"
		GeeList* _tmp26_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = list;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp26_;
#line 3046 "PhotoMetadata.c"
	} else {
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = NULL;
#line 3050 "PhotoMetadata.c"
	}
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = _g_object_ref0 (_tmp22_);
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp27_;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (collection);
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (list);
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3064 "PhotoMetadata.c"
}


GeeList* photo_metadata_get_first_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1) {
	GeeList* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3078 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3090 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3097 "PhotoMetadata.c"
			{
				GeeList* values = NULL;
				const gchar* _tmp2_ = NULL;
				GeeList* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GeeList* _tmp5_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_multiple (self, _tmp2_);
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = _tmp3_;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = values;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_ != NULL) {
#line 3114 "PhotoMetadata.c"
					GeeList* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = values;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = _tmp7_;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = _tmp8_ > 0;
#line 3126 "PhotoMetadata.c"
				} else {
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = FALSE;
#line 3130 "PhotoMetadata.c"
				}
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = values;
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 385 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 3140 "PhotoMetadata.c"
				}
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 382 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3146 "PhotoMetadata.c"
			}
		}
	}
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3154 "PhotoMetadata.c"
}


void photo_metadata_set_string (PhotoMetadata* self, const gchar* tag, const gchar* value, PrepareInputTextOptions options) {
	gchar* prepped = NULL;
	const gchar* _tmp0_ = NULL;
	PrepareInputTextOptions _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GExiv2Metadata* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 392 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 392 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = options;
#line 392 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = prepare_input_text (_tmp0_, _tmp1_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 392 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	prepped = _tmp2_;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = prepped;
#line 393 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_ == NULL) {
#line 3186 "PhotoMetadata.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = tag;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = value;
#line 394 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:394: Not setting tag %s to string %s: invalid UTF-8", _tmp4_, _tmp5_);
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (prepped);
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 3199 "PhotoMetadata.c"
	}
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = self->priv->exiv2;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = tag;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = prepped;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = gexiv2_metadata_set_tag_string (_tmp6_, _tmp7_, _tmp8_);
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp9_) {
#line 3211 "PhotoMetadata.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = tag;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = value;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = self->priv->source_name;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:400: Unable to set tag %s to string %s from source " \
"%s", _tmp10_, _tmp11_, _tmp12_);
#line 3223 "PhotoMetadata.c"
	}
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (prepped);
#line 3227 "PhotoMetadata.c"
}


static void photo_metadata_set_all_generic (PhotoMetadata* self, gchar** tags, int tags_length1, PhotoMetadataSetOption option, PhotoMetadataSetGenericValue setter, void* setter_target) {
	gboolean written = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	PhotoMetadataSetOption _tmp11_ = 0;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 406 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	written = FALSE;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3246 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3258 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3265 "PhotoMetadata.c"
			{
				gboolean _tmp2_ = FALSE;
				PhotoMetadataSetOption _tmp3_ = 0;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = option;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_ == PHOTO_METADATA_SET_OPTION_ALL_DOMAINS) {
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp2_ = TRUE;
#line 3275 "PhotoMetadata.c"
				} else {
					const gchar* _tmp4_ = NULL;
					MetadataDomain _tmp5_ = 0;
					gboolean _tmp6_ = FALSE;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = tag;
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = photo_metadata_get_tag_domain (_tmp4_);
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = photo_metadata_has_domain (self, _tmp5_);
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp2_ = _tmp6_;
#line 3288 "PhotoMetadata.c"
				}
#line 408 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp2_) {
#line 3292 "PhotoMetadata.c"
					PhotoMetadataSetGenericValue _tmp7_ = NULL;
					void* _tmp7__target = NULL;
					const gchar* _tmp8_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = setter;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7__target = setter_target;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = tag;
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ (_tmp8_, _tmp7__target);
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					written = TRUE;
#line 3306 "PhotoMetadata.c"
				}
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3310 "PhotoMetadata.c"
			}
		}
	}
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = option;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ == PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN) {
#line 3318 "PhotoMetadata.c"
		gboolean _tmp12_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = written;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = !_tmp12_;
#line 3324 "PhotoMetadata.c"
	} else {
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = FALSE;
#line 3328 "PhotoMetadata.c"
	}
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 3332 "PhotoMetadata.c"
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = tags;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13__length1 = tags_length1;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp13__length1 > 0;
#line 3341 "PhotoMetadata.c"
	} else {
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = FALSE;
#line 3345 "PhotoMetadata.c"
	}
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp9_) {
#line 3349 "PhotoMetadata.c"
		MetadataDomain default_domain = 0;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		MetadataDomain _tmp16_ = 0;
		PhotoMetadataSetGenericValue _tmp17_ = NULL;
		void* _tmp17__target = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		const gchar* _tmp19_ = NULL;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = tags;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14__length1 = tags_length1;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_[0];
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = photo_metadata_get_tag_domain (_tmp15_);
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		default_domain = _tmp16_;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = setter;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17__target = setter_target;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = tags;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18__length1 = tags_length1;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp18_[0];
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ (_tmp19_, _tmp17__target);
#line 3382 "PhotoMetadata.c"
		{
			gint ctr = 0;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			ctr = 1;
#line 3387 "PhotoMetadata.c"
			{
				gboolean _tmp20_ = FALSE;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp20_ = TRUE;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				while (TRUE) {
#line 3394 "PhotoMetadata.c"
					gint _tmp22_ = 0;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gint _tmp25_ = 0;
					const gchar* _tmp26_ = NULL;
					MetadataDomain _tmp27_ = 0;
					MetadataDomain _tmp28_ = 0;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!_tmp20_) {
#line 3406 "PhotoMetadata.c"
						gint _tmp21_ = 0;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = ctr;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						ctr = _tmp21_ + 1;
#line 3412 "PhotoMetadata.c"
					}
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp20_ = FALSE;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp22_ = ctr;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23_ = tags;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23__length1 = tags_length1;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!(_tmp22_ < _tmp23__length1)) {
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						break;
#line 3426 "PhotoMetadata.c"
					}
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp24_ = tags;
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp24__length1 = tags_length1;
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp25_ = ctr;
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp26_ = _tmp24_[_tmp25_];
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp27_ = photo_metadata_get_tag_domain (_tmp26_);
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp28_ = default_domain;
#line 422 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (_tmp27_ == _tmp28_) {
#line 3442 "PhotoMetadata.c"
						PhotoMetadataSetGenericValue _tmp29_ = NULL;
						void* _tmp29__target = NULL;
						gchar** _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						gint _tmp31_ = 0;
						const gchar* _tmp32_ = NULL;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29_ = setter;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29__target = setter_target;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp30_ = tags;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp30__length1 = tags_length1;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp31_ = ctr;
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp32_ = _tmp30_[_tmp31_];
#line 423 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29_ (_tmp32_, _tmp29__target);
#line 3463 "PhotoMetadata.c"
					}
				}
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data1_;
#line 3477 "PhotoMetadata.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 3486 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data1_->self;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_data1_->value);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block1Data, _data1_);
#line 3496 "PhotoMetadata.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data1_->self;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data1_->value;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, _tmp0_, _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 3515 "PhotoMetadata.c"
}


static void ___lambda5__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda5_ (self, tag);
#line 3522 "PhotoMetadata.c"
}


void photo_metadata_set_all_string (PhotoMetadata* self, gchar** tags, int tags_length1, const gchar* value, PhotoMetadataSetOption option) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->_ref_count_ = 1;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->self = media_metadata_ref (self);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_data1_->value);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->value = _tmp1_;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda5__photo_metadata_set_generic_value, _data1_);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block1_data_unref (_data1_);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = NULL;
#line 3563 "PhotoMetadata.c"
}


static void _vala_array_add45 (gchar*** array, int* length, int* size, gchar* value) {
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3574 "PhotoMetadata.c"
	}
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 3580 "PhotoMetadata.c"
}


static void _vala_array_add46 (gchar*** array, int* length, int* size, gchar* value) {
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3591 "PhotoMetadata.c"
	}
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 3597 "PhotoMetadata.c"
}


void photo_metadata_set_string_multiple (PhotoMetadata* self, const gchar* tag, GeeCollection* collection) {
	gchar** values = NULL;
	gchar** _tmp0_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GExiv2Metadata* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gboolean _tmp20_ = FALSE;
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (collection));
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = 0;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 3629 "PhotoMetadata.c"
	{
		GeeIterator* _value_it = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = collection;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_value_it = _tmp2_;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		while (TRUE) {
#line 3642 "PhotoMetadata.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			gchar* value = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			gchar* prepped = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _value_it;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (!_tmp4_) {
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				break;
#line 3660 "PhotoMetadata.c"
			}
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _value_it;
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = (gchar*) _tmp6_;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = value;
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp8_ = prepare_input_text (_tmp7_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, -1);
#line 435 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			prepped = _tmp8_;
#line 436 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = prepped;
#line 436 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (_tmp9_ != NULL) {
#line 3678 "PhotoMetadata.c"
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = values;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10__length1 = values_length1;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = prepped;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_array_add45 (&values, &values_length1, &_values_size_, _tmp12_);
#line 3693 "PhotoMetadata.c"
			} else {
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = value;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = tag;
#line 439 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				g_warning ("PhotoMetadata.vala:439: Unable to set string %s to %s: invalid UTF-8", _tmp13_, _tmp14_);
#line 3703 "PhotoMetadata.c"
			}
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (prepped);
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (value);
#line 3709 "PhotoMetadata.c"
		}
#line 434 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_value_it);
#line 3713 "PhotoMetadata.c"
	}
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = values;
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15__length1 = values_length1;
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp15__length1 == 0) {
#line 443 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 443 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 3725 "PhotoMetadata.c"
	}
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = values;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16__length1 = values_length1;
#line 449 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_array_add46 (&values, &values_length1, &_values_size_, NULL);
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = self->priv->exiv2;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = tag;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = values;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19__length1 = values_length1;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = gexiv2_metadata_set_tag_multiple (_tmp17_, _tmp18_, _tmp19_);
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp20_) {
#line 3745 "PhotoMetadata.c"
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = values;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21__length1 = values_length1;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = tag;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = self->priv->source_name;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:452: Unable to set %d strings to tag %s from source" \
" %s", _tmp21__length1, _tmp22_, _tmp23_);
#line 3760 "PhotoMetadata.c"
	}
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 3764 "PhotoMetadata.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data2_;
#line 3773 "PhotoMetadata.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3782 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data2_->self;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_data2_->values);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block2Data, _data2_);
#line 3792 "PhotoMetadata.c"
	}
}


static void __lambda6_ (Block2Data* _data2_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data2_->self;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data2_->values;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string_multiple (self, _tmp0_, _tmp1_);
#line 3811 "PhotoMetadata.c"
}


static void ___lambda6__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda6_ (self, tag);
#line 3818 "PhotoMetadata.c"
}


void photo_metadata_set_all_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1, GeeCollection* values, PhotoMetadataSetOption option) {
	Block2Data* _data2_;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (values));
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->_ref_count_ = 1;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->self = media_metadata_ref (self);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = values;
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_data2_->values);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->values = _tmp1_;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 456 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda6__photo_metadata_set_generic_value, _data2_);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block2_data_unref (_data2_);
#line 455 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = NULL;
#line 3859 "PhotoMetadata.c"
}


gboolean photo_metadata_get_long (PhotoMetadata* self, const gchar* tag, glong* value) {
	glong _vala_value = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GExiv2Metadata* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	glong _tmp4_ = 0L;
#line 459 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 459 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 460 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 460 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_has_tag (self, _tmp0_);
#line 460 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 461 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_value = (glong) 0;
#line 463 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 463 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (value) {
#line 463 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*value = _vala_value;
#line 3889 "PhotoMetadata.c"
		}
#line 463 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3893 "PhotoMetadata.c"
	}
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = self->priv->exiv2;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = tag;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_tag_long (_tmp2_, _tmp3_);
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = _tmp4_;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 3909 "PhotoMetadata.c"
	}
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3913 "PhotoMetadata.c"
}


gboolean photo_metadata_get_first_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong* value) {
	glong _vala_value = 0L;
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 471 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3928 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3940 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3947 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
				glong _tmp3_ = 0L;
				gboolean _tmp4_ = FALSE;
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_long (self, _tmp2_, &_tmp3_);
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_value = _tmp3_;
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (value) {
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*value = _vala_value;
#line 3968 "PhotoMetadata.c"
					}
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 3972 "PhotoMetadata.c"
				}
#line 472 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3976 "PhotoMetadata.c"
			}
		}
	}
#line 477 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = (glong) 0;
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 3988 "PhotoMetadata.c"
	}
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3992 "PhotoMetadata.c"
}


void photo_metadata_set_long (PhotoMetadata* self, const gchar* tag, glong value) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	glong _tmp2_ = 0L;
	gboolean _tmp3_ = FALSE;
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 482 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 483 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 483 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 483 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = value;
#line 483 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = gexiv2_metadata_set_tag_long (_tmp0_, _tmp1_, _tmp2_);
#line 483 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp3_) {
#line 4015 "PhotoMetadata.c"
		const gchar* _tmp4_ = NULL;
		glong _tmp5_ = 0L;
		const gchar* _tmp6_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = tag;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = value;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = self->priv->source_name;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:484: Unable to set tag %s to long %ld from source %" \
"s", _tmp4_, _tmp5_, _tmp6_);
#line 4027 "PhotoMetadata.c"
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data3_;
#line 4037 "PhotoMetadata.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 4046 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data3_->self;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block3Data, _data3_);
#line 4054 "PhotoMetadata.c"
	}
}


static void __lambda7_ (Block3Data* _data3_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data3_->self;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data3_->value;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_long (self, _tmp0_, _tmp1_);
#line 4073 "PhotoMetadata.c"
}


static void ___lambda7__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda7_ (self, tag);
#line 4080 "PhotoMetadata.c"
}


void photo_metadata_set_all_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong value, PhotoMetadataSetOption option) {
	Block3Data* _data3_;
	glong _tmp0_ = 0L;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PhotoMetadataSetOption _tmp2_ = 0;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->_ref_count_ = 1;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->self = media_metadata_ref (self);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->value = _tmp0_;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tags;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = tags_length1;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = option;
#line 488 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp1_, _tmp1__length1, _tmp2_, ___lambda7__photo_metadata_set_generic_value, _data3_);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block3_data_unref (_data3_);
#line 487 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = NULL;
#line 4114 "PhotoMetadata.c"
}


gboolean photo_metadata_get_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational) {
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
	gint numerator = 0;
	gint denominator = 0;
	gboolean _result_ = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 491 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 491 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_exif_tag_rational (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	numerator = _tmp2_;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	denominator = _tmp3_;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_result_ = _tmp4_;
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, numerator, denominator);
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _result_;
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 4153 "PhotoMetadata.c"
	}
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4157 "PhotoMetadata.c"
}


gboolean photo_metadata_get_first_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational) {
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 500 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 4172 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 4184 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 4191 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
				MetadataRational _tmp3_ = {0};
				gboolean _tmp4_ = FALSE;
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_rational (self, _tmp2_, &_tmp3_);
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_rational = _tmp3_;
#line 502 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (rational) {
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*rational = _vala_rational;
#line 4212 "PhotoMetadata.c"
					}
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4216 "PhotoMetadata.c"
				}
#line 501 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4220 "PhotoMetadata.c"
			}
		}
	}
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, 0, 0);
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 4232 "PhotoMetadata.c"
	}
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4236 "PhotoMetadata.c"
}


void photo_metadata_set_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	MetadataRational _tmp2_ = {0};
	gint _tmp3_ = 0;
	MetadataRational _tmp4_ = {0};
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = *rational;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_.numerator;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = *rational;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_.denominator;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = gexiv2_metadata_set_exif_tag_rational (_tmp0_, _tmp1_, _tmp3_, _tmp5_);
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp6_) {
#line 4270 "PhotoMetadata.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = tag;
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = metadata_rational_to_string (rational);
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp8_;
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = self->priv->source_name;
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:513: Unable to set tag %s to rational %s from sourc" \
"e %s", _tmp7_, _tmp9_, _tmp10_);
#line 513 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp9_);
#line 4287 "PhotoMetadata.c"
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data4_;
#line 4297 "PhotoMetadata.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 4306 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data4_->self;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block4Data, _data4_);
#line 4314 "PhotoMetadata.c"
	}
}


static void __lambda8_ (Block4Data* _data4_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	MetadataRational _tmp1_ = {0};
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data4_->self;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data4_->rational;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_rational (self, _tmp0_, &_tmp1_);
#line 4333 "PhotoMetadata.c"
}


static void ___lambda8__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda8_ (self, tag);
#line 4340 "PhotoMetadata.c"
}


void photo_metadata_set_all_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational, PhotoMetadataSetOption option) {
	Block4Data* _data4_;
	MetadataRational _tmp0_ = {0};
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PhotoMetadataSetOption _tmp2_ = 0;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->_ref_count_ = 1;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->self = media_metadata_ref (self);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = *rational;
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->rational = _tmp0_;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tags;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = tags_length1;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = option;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp1_, _tmp1__length1, _tmp2_, ___lambda8__photo_metadata_set_generic_value, _data4_);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block4_data_unref (_data4_);
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = NULL;
#line 4376 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_date_time (PhotoMetadata* self, const gchar* tag) {
	MetadataDateTime* result = NULL;
	gchar* value = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 522 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 522 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 523 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 523 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_string (self, _tmp0_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 523 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value = _tmp1_;
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = value;
#line 524 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ == NULL) {
#line 525 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 525 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 525 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 4407 "PhotoMetadata.c"
	}
	{
		const gchar* _tmp3_ = NULL;
		MetadataDomain _tmp4_ = 0;
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = tag;
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_get_tag_domain (_tmp3_);
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		switch (_tmp4_) {
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_XMP:
#line 4420 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				MetadataDateTime* _tmp7_ = NULL;
				MetadataDateTime* _tmp8_ = NULL;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = value;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = metadata_date_time_new_from_xmp (_tmp6_, &_inner_error_);
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _tmp7_;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4434 "PhotoMetadata.c"
					goto __catch26_g_error;
				}
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp5_;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = NULL;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp8_;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp5_);
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 4449 "PhotoMetadata.c"
			}
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_IPTC:
#line 4453 "PhotoMetadata.c"
			{
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = NULL;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 4461 "PhotoMetadata.c"
			}
			default:
#line 528 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_EXIF:
#line 4466 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				MetadataDateTime* _tmp11_ = NULL;
				MetadataDateTime* _tmp12_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = value;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = metadata_date_time_new_from_exif (_tmp10_, &_inner_error_);
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = _tmp11_;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4480 "PhotoMetadata.c"
					goto __catch26_g_error;
				}
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = _tmp9_;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp12_;
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp9_);
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 539 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 4495 "PhotoMetadata.c"
			}
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = tag;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = self->priv->source_name;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = err;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = _tmp15_->message;
#line 542 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:542: Unable to read date/time %s from source %s: %s", _tmp13_, _tmp14_, _tmp16_);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 4529 "PhotoMetadata.c"
	}
	__finally26:
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (value);
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_clear_error (&_inner_error_);
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 4540 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_first_date_time (PhotoMetadata* self, gchar** tags, int tags_length1) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 548 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 4554 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 4566 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 4573 "PhotoMetadata.c"
			{
				MetadataDateTime* date_time = NULL;
				const gchar* _tmp2_ = NULL;
				MetadataDateTime* _tmp3_ = NULL;
				MetadataDateTime* _tmp4_ = NULL;
#line 550 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 550 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_date_time (self, _tmp2_);
#line 550 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				date_time = _tmp3_;
#line 551 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = date_time;
#line 551 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = date_time;
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 552 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4595 "PhotoMetadata.c"
				}
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (date_time);
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4601 "PhotoMetadata.c"
			}
		}
	}
#line 555 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 555 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4609 "PhotoMetadata.c"
}


void photo_metadata_set_date_time (PhotoMetadata* self, const gchar* tag, MetadataDateTime* date_time) {
	const gchar* _tmp0_ = NULL;
	MetadataDomain _tmp1_ = 0;
#line 558 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 558 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 558 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_tag_domain (_tmp0_);
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp1_) {
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 4630 "PhotoMetadata.c"
		{
			const gchar* _tmp2_ = NULL;
			MetadataDateTime* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = tag;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = date_time;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = metadata_date_time_get_exif_label (_tmp3_);
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _tmp4_;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, _tmp2_, _tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp5_);
#line 562 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 4650 "PhotoMetadata.c"
		}
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 4654 "PhotoMetadata.c"
		{
			const gchar* _tmp6_ = NULL;
			MetadataDateTime* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = tag;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = date_time;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp8_ = metadata_date_time_get_xmp_label (_tmp7_);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = _tmp8_;
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, _tmp6_, _tmp9_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 565 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp9_);
#line 566 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 4674 "PhotoMetadata.c"
		}
		default:
#line 559 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 4679 "PhotoMetadata.c"
		{
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			MetadataDomain _tmp13_ = 0;
			GEnumValue* _tmp14_;
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = tag;
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp11_ = self->priv->source_name;
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp12_ = tag;
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp13_ = photo_metadata_get_tag_domain (_tmp12_);
#line 572 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp14_ = g_enum_get_value (g_type_class_ref (TYPE_METADATA_DOMAIN), _tmp13_);
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_warning ("PhotoMetadata.vala:571: Cannot set date/time for %s from source %s: un" \
"supported metadata domain %s", _tmp10_, _tmp11_, (_tmp14_ != NULL) ? _tmp14_->value_name : NULL);
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 4700 "PhotoMetadata.c"
		}
	}
}


static gpointer _metadata_date_time_ref0 (gpointer self) {
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? metadata_date_time_ref (self) : NULL;
#line 4709 "PhotoMetadata.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data5_;
#line 4718 "PhotoMetadata.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 4727 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data5_->self;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (_data5_->date_time);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block5Data, _data5_);
#line 4737 "PhotoMetadata.c"
	}
}


static void __lambda9_ (Block5Data* _data5_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data5_->self;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data5_->date_time;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_date_time (self, _tmp0_, _tmp1_);
#line 4756 "PhotoMetadata.c"
}


static void ___lambda9__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda9_ (self, tag);
#line 4763 "PhotoMetadata.c"
}


void photo_metadata_set_all_date_time (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	Block5Data* _data5_;
	MetadataDateTime* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->_ref_count_ = 1;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->self = media_metadata_ref (self);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_metadata_date_time_unref0 (_data5_->date_time);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->date_time = _tmp1_;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda9__photo_metadata_set_generic_value, _data5_);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block5_data_unref (_data5_);
#line 577 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = NULL;
#line 4804 "PhotoMetadata.c"
}


guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1) {
	guint8* result = NULL;
	ExifData* _tmp0_ = NULL;
	guchar* thumbnail = NULL;
	ExifData* _tmp2_ = NULL;
	guchar* _tmp3_ = NULL;
	guint thumbnail_size = 0U;
	ExifData* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	guint8* flattened = NULL;
	gint flattened_length1 = 0;
	gint _flattened_size_ = 0;
	guchar* saved_data = NULL;
	guint saved_size = 0U;
	ExifData* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	guint _tmp11_ = 0U;
	ExifData* _tmp21_ = NULL;
	guchar* _tmp22_ = NULL;
	ExifData* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	guint8* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
#line 582 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exif;
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ == NULL) {
#line 4838 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = 0;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (result_length1) {
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*result_length1 = _tmp1__length1;
#line 4849 "PhotoMetadata.c"
		}
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp1_;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 4855 "PhotoMetadata.c"
	}
#line 588 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = self->priv->exif;
#line 588 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_->data;
#line 588 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumbnail = _tmp3_;
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = self->priv->exif;
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_->size;
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumbnail_size = _tmp5_;
#line 590 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = include_preview;
#line 590 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp6_) {
#line 4873 "PhotoMetadata.c"
		ExifData* _tmp7_ = NULL;
		ExifData* _tmp8_ = NULL;
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->exif;
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_->data = NULL;
#line 592 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = self->priv->exif;
#line 592 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_->size = (guint) 0;
#line 4884 "PhotoMetadata.c"
	}
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = NULL;
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened_length1 = 0;
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_flattened_size_ = flattened_length1;
#line 598 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_data = NULL;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_size = (guint) 0;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = self->priv->exif;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_data_save_data (_tmp9_, &saved_data, &saved_size);
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = saved_size;
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ > ((guint) 0)) {
#line 4904 "PhotoMetadata.c"
		guchar* _tmp12_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = saved_data;
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp12_ != NULL;
#line 4910 "PhotoMetadata.c"
	} else {
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = FALSE;
#line 4914 "PhotoMetadata.c"
	}
#line 601 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 4918 "PhotoMetadata.c"
		guint _tmp13_ = 0U;
		guint8* _tmp14_ = NULL;
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		guchar* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		ExifMem* _tmp18_ = NULL;
		ExifMem* _tmp19_ = NULL;
		guchar* _tmp20_ = NULL;
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = saved_size;
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = g_new0 (guint8, _tmp13_);
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = _tmp14_;
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened_length1 = _tmp13_;
#line 602 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_flattened_size_ = flattened_length1;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = flattened;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15__length1 = flattened_length1;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = saved_data;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = saved_size;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		memcpy (_tmp15_, _tmp16_, (gsize) _tmp17_);
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = exif_mem_new_default ();
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp18_;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = saved_data;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp19_, _tmp20_);
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp19_);
#line 4960 "PhotoMetadata.c"
	}
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = self->priv->exif;
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = thumbnail;
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_->data = _tmp22_;
#line 610 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = self->priv->exif;
#line 610 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = thumbnail_size;
#line 610 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_->size = _tmp24_;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = flattened;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25__length1 = flattened_length1;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp25__length1;
#line 4982 "PhotoMetadata.c"
	}
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp25_;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4988 "PhotoMetadata.c"
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 4995 "PhotoMetadata.c"
}


guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1) {
	guint8* result = NULL;
	guchar* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	GExiv2Metadata* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint8* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 616 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_exif_thumbnail (_tmp1_, &_tmp2_, &_tmp3_);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = _tmp2_;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer_length1 = _tmp3_;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_buffer_size_ = buffer_length1;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 5031 "PhotoMetadata.c"
		guchar* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = buffer;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = buffer_length1;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp5_;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = _tmp5__length1;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		__tmp0__size_ = _tmp0__length1;
#line 5044 "PhotoMetadata.c"
	} else {
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = 0;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		__tmp0__size_ = _tmp0__length1;
#line 5052 "PhotoMetadata.c"
	}
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = _tmp0__length1;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7__length1 = _tmp6__length1;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp7__length1;
#line 5066 "PhotoMetadata.c"
	}
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp7_;
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5074 "PhotoMetadata.c"
}


guint photo_metadata_get_preview_count (PhotoMetadata* self) {
	guint result = 0U;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2PreviewProperties** _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gint _tmp3_ = 0;
	GExiv2PreviewProperties** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 621 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0U);
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 622 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 5107 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5__length1;
#line 5116 "PhotoMetadata.c"
	} else {
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = 0;
#line 5120 "PhotoMetadata.c"
	}
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = (guint) _tmp3_;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5126 "PhotoMetadata.c"
}


PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number) {
	PhotoPreview* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2PreviewProperties** _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gboolean _tmp3_ = FALSE;
	GExiv2PreviewProperties** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	GExiv2PreviewProperties** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	GExiv2PreviewProperties* _tmp11_ = NULL;
	PhotoMetadataInternalPhotoPreview* _tmp12_ = NULL;
#line 628 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 629 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 5168 "PhotoMetadata.c"
	} else {
		GExiv2PreviewProperties** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		guint _tmp6_ = 0U;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = number;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = ((guint) _tmp5__length1) <= _tmp6_;
#line 5181 "PhotoMetadata.c"
	}
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5189 "PhotoMetadata.c"
	}
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = self->priv->source_name;
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = number;
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = props;
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9__length1 = props_length1;
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = number;
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = _tmp9_[_tmp10_];
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = photo_metadata_internal_photo_preview_new (self, _tmp7_, _tmp8_, _tmp11_);
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 633 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5209 "PhotoMetadata.c"
}


void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self) {
	GExiv2Metadata* _tmp0_ = NULL;
	ExifData* _tmp1_ = NULL;
#line 636 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_erase_exif_thumbnail (_tmp0_);
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exif;
#line 638 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ != NULL) {
#line 5226 "PhotoMetadata.c"
		ExifMem* _tmp2_ = NULL;
		ExifMem* _tmp3_ = NULL;
		ExifData* _tmp4_ = NULL;
		guchar* _tmp5_ = NULL;
		ExifData* _tmp6_ = NULL;
		ExifData* _tmp7_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = exif_mem_new_default ();
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp2_;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = self->priv->exif;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_->data;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp3_, _tmp5_);
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp3_);
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = self->priv->exif;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_->data = NULL;
#line 641 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->exif;
#line 641 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_->size = (guint) 0;
#line 5253 "PhotoMetadata.c"
	}
}


void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 645 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 646 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 646 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 646 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear_tag (_tmp0_, _tmp1_);
#line 5271 "PhotoMetadata.c"
}


void photo_metadata_remove_tags (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 649 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 5284 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 5296 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 5303 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp2_);
#line 650 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5312 "PhotoMetadata.c"
			}
		}
	}
}


void photo_metadata_clear_domain (PhotoMetadata* self, MetadataDomain domain) {
	MetadataDomain _tmp0_ = 0;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 5329 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
#line 657 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 657 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_exif (_tmp1_);
#line 658 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5338 "PhotoMetadata.c"
		}
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 5342 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp2_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = self->priv->exiv2;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_xmp (_tmp2_);
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5351 "PhotoMetadata.c"
		}
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 5355 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
#line 665 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 665 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_iptc (_tmp3_);
#line 666 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5364 "PhotoMetadata.c"
		}
		default:
#line 655 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 5369 "PhotoMetadata.c"
	}
}


void photo_metadata_clear (PhotoMetadata* self) {
	GExiv2Metadata* _tmp0_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear (_tmp0_);
#line 5382 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_modification_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DATE_TIME_TAGS;
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 681 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5403 "PhotoMetadata.c"
}


void photo_metadata_set_modification_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 684 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 684 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 686 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 686 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 5417 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DATE_TIME_TAGS;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 687 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 5432 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_DATE_TIME_TAGS;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 5442 "PhotoMetadata.c"
	}
}


MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 701 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5464 "PhotoMetadata.c"
}


void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 705 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 5478 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 708 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 708 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 708 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 708 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 708 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 5493 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 710 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 710 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 710 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 5503 "PhotoMetadata.c"
	}
}


MetadataDateTime* photo_metadata_get_digitized_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 718 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 719 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5525 "PhotoMetadata.c"
}


void photo_metadata_set_digitized_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 5539 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 725 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 5554 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 727 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 727 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 727 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 5564 "PhotoMetadata.c"
	}
}


static MetadataDateTime* photo_metadata_real_get_creation_date_time (MediaMetadata* base) {
	PhotoMetadata * self;
	MetadataDateTime* result = NULL;
	MetadataDateTime* creation = NULL;
	MetadataDateTime* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_exposure_date_time (self);
#line 731 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	creation = _tmp0_;
#line 732 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = creation;
#line 732 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ == NULL) {
#line 5585 "PhotoMetadata.c"
		MetadataDateTime* _tmp2_ = NULL;
#line 733 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_get_digitized_date_time (self);
#line 733 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (creation);
#line 733 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		creation = _tmp2_;
#line 5593 "PhotoMetadata.c"
	}
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = creation;
#line 735 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5599 "PhotoMetadata.c"
}


static gpointer _dimensions_dup0 (gpointer self) {
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? dimensions_dup (self) : NULL;
#line 5606 "PhotoMetadata.c"
}


Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self) {
	Dimensions* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 752 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_WIDTH_TAGS;
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_HEIGHT_TAGS;
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 754 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp0__length1 == _tmp1__length1, "WIDTH_TAGS.length == HEIGHT_TAGS.length");
#line 5628 "PhotoMetadata.c"
	{
		gint ctr = 0;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		ctr = 0;
#line 5633 "PhotoMetadata.c"
		{
			gboolean _tmp2_ = FALSE;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = TRUE;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 5640 "PhotoMetadata.c"
				gint _tmp4_ = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				glong width = 0L;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				glong _tmp9_ = 0L;
				gboolean _tmp10_ = FALSE;
				glong height = 0L;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				glong _tmp14_ = 0L;
				gboolean _tmp15_ = FALSE;
				glong _tmp16_ = 0L;
				glong _tmp17_ = 0L;
				Dimensions _tmp18_ = {0};
				Dimensions* _tmp19_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp2_) {
#line 5664 "PhotoMetadata.c"
					gint _tmp3_ = 0;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = ctr;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					ctr = _tmp3_ + 1;
#line 5670 "PhotoMetadata.c"
				}
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = FALSE;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = ctr;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = photo_metadata_WIDTH_TAGS;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 755 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 5684 "PhotoMetadata.c"
				}
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = photo_metadata_WIDTH_TAGS;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = ctr;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = photo_metadata_get_long (self, _tmp8_, &_tmp9_);
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				width = _tmp9_;
#line 759 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp10_) {
#line 760 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 5702 "PhotoMetadata.c"
				}
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = photo_metadata_HEIGHT_TAGS;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = ctr;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp15_ = photo_metadata_get_long (self, _tmp13_, &_tmp14_);
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				height = _tmp14_;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp15_) {
#line 764 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 5720 "PhotoMetadata.c"
				}
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp16_ = width;
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = height;
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				dimensions_init (&_tmp18_, (gint) _tmp16_, (gint) _tmp17_);
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp19_ = _dimensions_dup0 (&_tmp18_);
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp19_;
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5734 "PhotoMetadata.c"
			}
		}
	}
#line 769 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 769 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5742 "PhotoMetadata.c"
}


void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option) {
	Dimensions* _tmp0_ = NULL;
#line 772 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 773 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = dim;
#line 773 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 5754 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		Dimensions* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		PhotoMetadataSetOption _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		Dimensions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		PhotoMetadataSetOption _tmp8_ = 0;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_WIDTH_TAGS;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = dim;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (*_tmp2_).width;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = option;
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp1_, _tmp1__length1, (glong) _tmp3_, _tmp4_);
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = photo_metadata_HEIGHT_TAGS;
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = dim;
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = (*_tmp6_).height;
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = option;
#line 775 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp5_, _tmp5__length1, (glong) _tmp7_, _tmp8_);
#line 5789 "PhotoMetadata.c"
	} else {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = photo_metadata_WIDTH_TAGS;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp9_, _tmp9__length1);
#line 778 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = photo_metadata_HEIGHT_TAGS;
#line 778 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 778 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp10_, _tmp10__length1);
#line 5807 "PhotoMetadata.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1207 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 5831 "PhotoMetadata.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 5851 "PhotoMetadata.c"
}


static gchar* photo_metadata_real_get_title (MediaMetadata* base) {
	PhotoMetadata * self;
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeList* titles = NULL;
	GeeList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp8_ = NULL;
	gchar* title = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gchar* _tmp28_ = NULL;
#line 811 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 5880 "PhotoMetadata.c"
		GeeList* _tmp2_ = NULL;
#line 820 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_get_string_multiple (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 820 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 820 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp2_;
#line 5888 "PhotoMetadata.c"
	} else {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		GeeList* _tmp4_ = NULL;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_get_first_string_multiple (self, _tmp3_, _tmp3__length1);
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp4_;
#line 5903 "PhotoMetadata.c"
	}
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 819 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	titles = _tmp5_;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = titles;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp8_ != NULL) {
#line 5913 "PhotoMetadata.c"
		GeeList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = titles;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp10_;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp11_ > 0;
#line 5925 "PhotoMetadata.c"
	} else {
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = FALSE;
#line 5929 "PhotoMetadata.c"
	}
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp7_) {
#line 5933 "PhotoMetadata.c"
		GeeList* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = titles;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = gee_list_get (_tmp12_, 0);
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp6_);
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = (gchar*) _tmp13_;
#line 5944 "PhotoMetadata.c"
	} else {
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp6_);
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = NULL;
#line 5950 "PhotoMetadata.c"
	}
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_strdup (_tmp6_);
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	title = _tmp14_;
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = title;
#line 829 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp15_ != NULL) {
#line 5960 "PhotoMetadata.c"
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 830 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = title;
#line 830 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = string_strip (_tmp16_);
#line 830 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (title);
#line 830 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		title = _tmp17_;
#line 5971 "PhotoMetadata.c"
	}
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = title;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = is_string_empty (_tmp21_);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp22_) {
#line 5979 "PhotoMetadata.c"
		const gchar* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = title;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = string_contains (_tmp23_, "\n");
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = !_tmp24_;
#line 5988 "PhotoMetadata.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = FALSE;
#line 5992 "PhotoMetadata.c"
	}
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp20_) {
#line 5996 "PhotoMetadata.c"
		const gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = title;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = string_contains (_tmp25_, "\r");
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = !_tmp26_;
#line 6005 "PhotoMetadata.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 6009 "PhotoMetadata.c"
	}
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 6013 "PhotoMetadata.c"
		const gchar* _tmp27_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = title;
#line 834 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = _tmp27_;
#line 6019 "PhotoMetadata.c"
	} else {
#line 834 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = NULL;
#line 6023 "PhotoMetadata.c"
	}
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = g_strdup (_tmp18_);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp28_;
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (title);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp6_);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (titles);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 833 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6039 "PhotoMetadata.c"
}


void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = title;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 6054 "PhotoMetadata.c"
		gboolean _tmp2_ = FALSE;
#line 839 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 839 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_tmp2_) {
#line 6060 "PhotoMetadata.c"
			const gchar* _tmp3_ = NULL;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = title;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, PHOTO_METADATA_IPHOTO_TITLE_TAG, _tmp3_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 6066 "PhotoMetadata.c"
		} else {
			gchar** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			const gchar* _tmp5_ = NULL;
			PhotoMetadataSetOption _tmp6_ = 0;
#line 842 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 842 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 842 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = title;
#line 842 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = option;
#line 842 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_all_string (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp6_);
#line 6082 "PhotoMetadata.c"
		}
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 844 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 844 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 844 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp7_, _tmp7__length1);
#line 6093 "PhotoMetadata.c"
	}
}


static gchar* photo_metadata_real_get_comment (MediaMetadata* base) {
	PhotoMetadata * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 848 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 849 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.UserComment", PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF));
#line 849 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 849 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6110 "PhotoMetadata.c"
}


void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 852 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 853 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = comment;
#line 853 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 853 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 6125 "PhotoMetadata.c"
		const gchar* _tmp2_ = NULL;
#line 854 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = comment;
#line 854 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Photo.UserComment", _tmp2_, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT & (~PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF));
#line 6131 "PhotoMetadata.c"
	} else {
#line 856 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tag (self, "Exif.Photo.UserComment");
#line 6135 "PhotoMetadata.c"
	}
}


GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeSet* result = NULL;
	GeeSet* keywords = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeSet* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GeeSet* _tmp24_ = NULL;
	GeeSet* _tmp29_ = NULL;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 873 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	keywords = NULL;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_KEYWORD_TAGS;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 6157 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 6169 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 6176 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				const gchar* _tmp2_ = NULL;
				GeeList* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GeeCollection* _tmp5_ = NULL;
#line 875 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 875 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_multiple (self, _tmp2_);
#line 875 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = values;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_ != NULL) {
#line 6193 "PhotoMetadata.c"
					GeeCollection* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = values;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = gee_collection_get_size (_tmp6_);
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = _tmp7_;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = _tmp8_ > 0;
#line 6205 "PhotoMetadata.c"
				} else {
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = FALSE;
#line 6209 "PhotoMetadata.c"
				}
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 6213 "PhotoMetadata.c"
					GeeSet* _tmp9_ = NULL;
#line 877 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = keywords;
#line 877 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (_tmp9_ == NULL) {
#line 6219 "PhotoMetadata.c"
						GCompareDataFunc _tmp10_ = NULL;
						void* _tmp10__target = NULL;
						GDestroyNotify _tmp10__target_destroy_notify = NULL;
						GeeSet* _tmp11_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10_ = compare_func;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target = compare_func_target;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target_destroy_notify = compare_func_target_destroy_notify;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func = NULL;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func_target = NULL;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func_target_destroy_notify = NULL;
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp11_ = photo_metadata_create_string_set (self, _tmp10_, _tmp10__target, _tmp10__target_destroy_notify);
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (keywords);
#line 878 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						keywords = _tmp11_;
#line 6242 "PhotoMetadata.c"
					}
					{
						GeeIterator* _current_value_it = NULL;
						GeeCollection* _tmp12_ = NULL;
						GeeIterator* _tmp13_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp12_ = values;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_current_value_it = _tmp13_;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 6256 "PhotoMetadata.c"
							GeeIterator* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							gchar* current_value = NULL;
							GeeIterator* _tmp16_ = NULL;
							gpointer _tmp17_ = NULL;
							GeeSet* _tmp18_ = NULL;
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp14_ = _current_value_it;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = gee_iterator_next (_tmp14_);
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!_tmp15_) {
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 6274 "PhotoMetadata.c"
							}
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = _current_value_it;
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = gee_iterator_get (_tmp16_);
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							current_value = (gchar*) _tmp17_;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = keywords;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = current_value;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = hierarchical_tag_utilities_make_flat_tag_safe (_tmp19_);
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = _tmp20_;
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
#line 881 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (_tmp21_);
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (current_value);
#line 6296 "PhotoMetadata.c"
						}
#line 880 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_current_value_it);
#line 6300 "PhotoMetadata.c"
					}
				}
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 874 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 6307 "PhotoMetadata.c"
			}
		}
	}
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = keywords;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp24_ != NULL) {
#line 6315 "PhotoMetadata.c"
		GeeSet* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = keywords;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = _tmp26_;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp27_ > 0;
#line 6327 "PhotoMetadata.c"
	} else {
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = FALSE;
#line 6331 "PhotoMetadata.c"
	}
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp23_) {
#line 6335 "PhotoMetadata.c"
		GeeSet* _tmp28_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp28_ = keywords;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp28_;
#line 6341 "PhotoMetadata.c"
	} else {
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = NULL;
#line 6345 "PhotoMetadata.c"
	}
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = _g_object_ref0 (_tmp22_);
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp29_;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (keywords);
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6363 "PhotoMetadata.c"
}


static gpointer _hierarchical_keyword_field_ref0 (gpointer self) {
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? hierarchical_keyword_field_ref (self) : NULL;
#line 6370 "PhotoMetadata.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 6383 "PhotoMetadata.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 6414 "PhotoMetadata.c"
				goto __catch27_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 6423 "PhotoMetadata.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 6439 "PhotoMetadata.c"
				goto __catch27_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 6450 "PhotoMetadata.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 6464 "PhotoMetadata.c"
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 6478 "PhotoMetadata.c"
	}
	__finally27:
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 6489 "PhotoMetadata.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 6513 "PhotoMetadata.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 6521 "PhotoMetadata.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 6533 "PhotoMetadata.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 6557 "PhotoMetadata.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 6563 "PhotoMetadata.c"
	} else {
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 6567 "PhotoMetadata.c"
	}
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 6571 "PhotoMetadata.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 6583 "PhotoMetadata.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 6593 "PhotoMetadata.c"
	}
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 6599 "PhotoMetadata.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 6613 "PhotoMetadata.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 6623 "PhotoMetadata.c"
	}
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 6629 "PhotoMetadata.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 6638 "PhotoMetadata.c"
	}
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 6658 "PhotoMetadata.c"
}


static void photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self, HierarchicalTagIndex* index) {
	HierarchicalKeywordField** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	HierarchicalTagIndex* _tmp4_ = NULL;
	HierarchicalKeywordField** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((index == NULL) || IS_HIERARCHICAL_TAG_INDEX (index));
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 6676 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp0_;
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp0__length1;
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp0__length1; current_field_it = current_field_it + 1) {
#line 6688 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_ = NULL;
			HierarchicalKeywordField* current_field = NULL;
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp1_;
#line 6695 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = current_field;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp3_);
#line 889 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 6707 "PhotoMetadata.c"
			}
		}
	}
#line 892 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = index;
#line 892 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 893 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 6717 "PhotoMetadata.c"
	}
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 6723 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp5_;
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp5__length1;
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp5__length1; current_field_it = current_field_it + 1) {
#line 6735 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp6_ = NULL;
			HierarchicalKeywordField* current_field = NULL;
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp6_;
#line 6742 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GeeSet* writeable_set = NULL;
				GeeTreeSet* _tmp9_ = NULL;
				HierarchicalKeywordField* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				GeeSet* _tmp31_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = current_field;
#line 896 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp7_->is_writeable;
#line 896 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp8_) {
#line 897 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (current_field);
#line 897 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 6761 "PhotoMetadata.c"
				}
#line 899 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 899 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				writeable_set = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_SET, GeeSet);
#line 6767 "PhotoMetadata.c"
				{
					GeeIterator* _current_path_it = NULL;
					HierarchicalTagIndex* _tmp10_ = NULL;
					GeeCollection* _tmp11_ = NULL;
					GeeCollection* _tmp12_ = NULL;
					GeeIterator* _tmp13_ = NULL;
					GeeIterator* _tmp14_ = NULL;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = index;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = hierarchical_tag_index_get_all_paths (_tmp10_);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = _tmp11_;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp14_ = _tmp13_;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_tmp12_);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_path_it = _tmp14_;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 6791 "PhotoMetadata.c"
						GeeIterator* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						gchar* current_path = NULL;
						GeeIterator* _tmp17_ = NULL;
						gpointer _tmp18_ = NULL;
						gchar* writeable_path = NULL;
						const gchar* _tmp19_ = NULL;
						HierarchicalKeywordField* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						HierarchicalKeywordField* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						GeeSet* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = _current_path_it;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = gee_iterator_next (_tmp15_);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp16_) {
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 6814 "PhotoMetadata.c"
						}
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp17_ = _current_path_it;
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp18_ = gee_iterator_get (_tmp17_);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_path = (gchar*) _tmp18_;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp19_ = current_path;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp20_ = current_field;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = _tmp20_->path_separator;
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp22_ = string_replace (_tmp19_, TAG_PATH_SEPARATOR_STRING, _tmp21_);
#line 902 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						writeable_path = _tmp22_;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp23_ = current_field;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp24_ = _tmp23_->wants_leading_separator;
#line 904 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp24_) {
#line 6838 "PhotoMetadata.c"
							const gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp25_ = writeable_path;
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (writeable_path);
#line 905 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							writeable_path = _tmp26_;
#line 6849 "PhotoMetadata.c"
						}
#line 907 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp27_ = writeable_set;
#line 907 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp28_ = writeable_path;
#line 907 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (writeable_path);
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_path);
#line 6861 "PhotoMetadata.c"
					}
#line 901 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_path_it);
#line 6865 "PhotoMetadata.c"
				}
#line 910 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp29_ = current_field;
#line 910 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp30_ = _tmp29_->field_name;
#line 910 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp31_ = writeable_set;
#line 910 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_set_string_multiple (self, _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (writeable_set);
#line 895 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 6879 "PhotoMetadata.c"
			}
		}
	}
}


void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option) {
	HierarchicalTagIndex* htag_index = NULL;
	HierarchicalTagIndex* _tmp0_ = NULL;
	GeeSet* flat_keywords = NULL;
	GeeTreeSet* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp28_ = NULL;
#line 914 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 914 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((keywords == NULL) || GEE_IS_COLLECTION (keywords));
#line 915 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = hierarchical_tag_index_new ();
#line 915 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	htag_index = _tmp0_;
#line 916 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 916 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flat_keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 918 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = keywords;
#line 918 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ != NULL) {
#line 6909 "PhotoMetadata.c"
		GeeSet* _tmp24_ = NULL;
		HierarchicalTagIndex* _tmp25_ = NULL;
		GeeCollection* _tmp26_ = NULL;
		GeeCollection* _tmp27_ = NULL;
		{
			GeeIterator* _keyword_it = NULL;
			GeeCollection* _tmp3_ = NULL;
			GeeIterator* _tmp4_ = NULL;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = keywords;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_keyword_it = _tmp4_;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 6926 "PhotoMetadata.c"
				GeeIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gchar* keyword = NULL;
				GeeIterator* _tmp7_ = NULL;
				gpointer _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _keyword_it;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = gee_iterator_next (_tmp5_);
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp6_) {
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 6942 "PhotoMetadata.c"
				}
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = _keyword_it;
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				keyword = (gchar*) _tmp8_;
#line 920 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = keyword;
#line 920 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = g_str_has_prefix (_tmp9_, TAG_PATH_SEPARATOR_STRING);
#line 920 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp10_) {
#line 6956 "PhotoMetadata.c"
					GeeCollection* path_components = NULL;
					const gchar* _tmp11_ = NULL;
					GeeList* _tmp12_ = NULL;
#line 921 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = keyword;
#line 921 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = hierarchical_tag_utilities_enumerate_path_components (_tmp11_);
#line 921 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					path_components = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection);
#line 6966 "PhotoMetadata.c"
					{
						GeeIterator* _component_it = NULL;
						GeeCollection* _tmp13_ = NULL;
						GeeIterator* _tmp14_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = path_components;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_component_it = _tmp14_;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 6979 "PhotoMetadata.c"
							GeeIterator* _tmp15_ = NULL;
							gboolean _tmp16_ = FALSE;
							gchar* component = NULL;
							GeeIterator* _tmp17_ = NULL;
							gpointer _tmp18_ = NULL;
							HierarchicalTagIndex* _tmp19_ = NULL;
							const gchar* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = _component_it;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = gee_iterator_next (_tmp15_);
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!_tmp16_) {
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 6996 "PhotoMetadata.c"
							}
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = _component_it;
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = gee_iterator_get (_tmp17_);
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							component = (gchar*) _tmp18_;
#line 924 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = htag_index;
#line 924 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = component;
#line 924 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = keyword;
#line 924 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							hierarchical_tag_index_add_path (_tmp19_, _tmp20_, _tmp21_);
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (component);
#line 7014 "PhotoMetadata.c"
						}
#line 923 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_component_it);
#line 7018 "PhotoMetadata.c"
					}
#line 920 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (path_components);
#line 7022 "PhotoMetadata.c"
				} else {
					GeeSet* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp22_ = flat_keywords;
#line 926 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23_ = keyword;
#line 926 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
#line 7032 "PhotoMetadata.c"
				}
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (keyword);
#line 7036 "PhotoMetadata.c"
			}
#line 919 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_object_unref0 (_keyword_it);
#line 7040 "PhotoMetadata.c"
		}
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = flat_keywords;
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = htag_index;
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = hierarchical_tag_index_get_all_tags (_tmp25_);
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = _tmp26_;
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 930 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp27_);
#line 7054 "PhotoMetadata.c"
	}
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = keywords;
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp28_ != NULL) {
#line 7060 "PhotoMetadata.c"
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		GeeSet* _tmp30_ = NULL;
		PhotoMetadataSetOption _tmp31_ = 0;
		HierarchicalTagIndex* _tmp32_ = NULL;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp29_ = photo_metadata_KEYWORD_TAGS;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp29__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp30_ = flat_keywords;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp31_ = option;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_string_multiple (self, _tmp29_, _tmp29__length1, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp31_);
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp32_ = htag_index;
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, _tmp32_);
#line 7080 "PhotoMetadata.c"
	} else {
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
#line 937 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp33_ = photo_metadata_KEYWORD_TAGS;
#line 937 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp33__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 937 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp33_, _tmp33__length1);
#line 938 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, NULL);
#line 7092 "PhotoMetadata.c"
	}
#line 914 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (flat_keywords);
#line 914 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_hierarchical_tag_index_unref0 (htag_index);
#line 7098 "PhotoMetadata.c"
}


gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self) {
	gboolean result = FALSE;
	HierarchicalKeywordField** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 942 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7112 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp0_;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp0__length1;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp0__length1; field_it = field_it + 1) {
#line 7124 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_ = NULL;
			HierarchicalKeywordField* field = NULL;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp1_;
#line 7131 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				GeeList* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GeeCollection* _tmp6_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = field;
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_string_multiple (self, _tmp3_);
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection);
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = values;
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp6_ != NULL) {
#line 7151 "PhotoMetadata.c"
					GeeCollection* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = values;
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = gee_collection_get_size (_tmp7_);
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = _tmp8_;
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = _tmp9_ > 0;
#line 7163 "PhotoMetadata.c"
				} else {
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = FALSE;
#line 7167 "PhotoMetadata.c"
				}
#line 946 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_) {
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 7179 "PhotoMetadata.c"
				}
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 7185 "PhotoMetadata.c"
			}
		}
	}
#line 950 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 950 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7193 "PhotoMetadata.c"
}


GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self) {
	GeeSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeSet* h_keywords = NULL;
	GeeSet* _tmp1_ = NULL;
	HierarchicalKeywordField** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 953 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_hierarchical_keywords (self);
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp0_, "has_hierarchical_keywords()");
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_create_string_set (self, NULL, NULL, NULL);
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	h_keywords = _tmp1_;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7218 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp2_;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp2__length1;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp2__length1; field_it = field_it + 1) {
#line 7230 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp3_ = NULL;
			HierarchicalKeywordField* field = NULL;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp3_;
#line 7237 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				GeeList* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				GeeCollection* _tmp8_ = NULL;
#line 959 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = field;
#line 959 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _tmp4_->field_name;
#line 959 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = photo_metadata_get_string_multiple (self, _tmp5_);
#line 959 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = values;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp8_ == NULL) {
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = TRUE;
#line 7259 "PhotoMetadata.c"
				} else {
					GeeCollection* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = values;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = gee_collection_get_size (_tmp9_);
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = _tmp10_;
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = _tmp11_ < 1;
#line 7272 "PhotoMetadata.c"
				}
#line 961 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp7_) {
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 7282 "PhotoMetadata.c"
				}
				{
					GeeIterator* _current_value_it = NULL;
					GeeCollection* _tmp12_ = NULL;
					GeeIterator* _tmp13_ = NULL;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = values;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_it = _tmp13_;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 7296 "PhotoMetadata.c"
						GeeIterator* _tmp14_ = NULL;
						gboolean _tmp15_ = FALSE;
						gchar* current_value = NULL;
						GeeIterator* _tmp16_ = NULL;
						gpointer _tmp17_ = NULL;
						gchar* canonicalized = NULL;
						const gchar* _tmp18_ = NULL;
						HierarchicalKeywordField* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp14_ = _current_value_it;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = gee_iterator_next (_tmp14_);
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp15_) {
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 7316 "PhotoMetadata.c"
						}
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = _current_value_it;
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp17_ = gee_iterator_get (_tmp16_);
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_value = (gchar*) _tmp17_;
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp18_ = current_value;
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp19_ = field;
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp20_ = _tmp19_->path_separator;
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = hierarchical_tag_utilities_canonicalize (_tmp18_, _tmp20_);
#line 965 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						canonicalized = _tmp21_;
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp22_ = canonicalized;
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (_tmp22_ != NULL) {
#line 7338 "PhotoMetadata.c"
							GeeSet* _tmp23_ = NULL;
							const gchar* _tmp24_ = NULL;
#line 969 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp23_ = h_keywords;
#line 969 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp24_ = canonicalized;
#line 969 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_);
#line 7347 "PhotoMetadata.c"
						}
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (canonicalized);
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_value);
#line 7353 "PhotoMetadata.c"
					}
#line 964 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_value_it);
#line 7357 "PhotoMetadata.c"
				}
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 7363 "PhotoMetadata.c"
			}
		}
	}
#line 973 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = h_keywords;
#line 973 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7371 "PhotoMetadata.c"
}


gboolean photo_metadata_has_orientation (PhotoMetadata* self) {
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Orientation _tmp1_ = 0;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 977 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 977 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_orientation (_tmp0_);
#line 977 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_ == GEXIV2_ORIENTATION_UNSPECIFIED;
#line 977 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7389 "PhotoMetadata.c"
}


Orientation photo_metadata_get_orientation (PhotoMetadata* self) {
	Orientation result = 0;
	GExiv2Orientation orientation = 0;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Orientation _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GExiv2Orientation _tmp4_ = 0;
#line 981 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 984 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 984 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_orientation (_tmp0_);
#line 984 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	orientation = _tmp1_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = orientation;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == GEXIV2_ORIENTATION_UNSPECIFIED) {
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 7415 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp5_ = 0;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = orientation;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5_ < ORIENTATION_MIN;
#line 7422 "PhotoMetadata.c"
	}
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = TRUE;
#line 7428 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp6_ = 0;
#line 986 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = orientation;
#line 986 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = _tmp6_ > ORIENTATION_MAX;
#line 7435 "PhotoMetadata.c"
	}
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_) {
#line 987 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = ORIENTATION_TOP_LEFT;
#line 987 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7443 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp7_ = 0;
#line 989 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = orientation;
#line 989 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = (Orientation) _tmp7_;
#line 989 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7452 "PhotoMetadata.c"
	}
}


void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation) {
	GExiv2Metadata* _tmp0_ = NULL;
	Orientation _tmp1_ = 0;
#line 992 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 994 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 994 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = orientation;
#line 994 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_set_orientation (_tmp0_, (GExiv2Orientation) _tmp1_);
#line 7468 "PhotoMetadata.c"
}


gboolean photo_metadata_get_gps (PhotoMetadata* self, gdouble* longitude, gchar** long_ref, gdouble* latitude, gchar** lat_ref, gdouble* altitude) {
	gdouble _vala_longitude = 0.0;
	gchar* _vala_long_ref = NULL;
	gdouble _vala_latitude = 0.0;
	gchar* _vala_lat_ref = NULL;
	gdouble _vala_altitude = 0.0;
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 997 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_gps_info (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_longitude = _tmp1_;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_latitude = _tmp2_;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_altitude = _tmp3_;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp4_) {
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_long_ref = NULL;
#line 1001 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 1001 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_lat_ref = NULL;
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (longitude) {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*longitude = _vala_longitude;
#line 7514 "PhotoMetadata.c"
		}
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (long_ref) {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*long_ref = _vala_long_ref;
#line 7520 "PhotoMetadata.c"
		} else {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_long_ref);
#line 7524 "PhotoMetadata.c"
		}
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (latitude) {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*latitude = _vala_latitude;
#line 7530 "PhotoMetadata.c"
		}
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (lat_ref) {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*lat_ref = _vala_lat_ref;
#line 7536 "PhotoMetadata.c"
		} else {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_lat_ref);
#line 7540 "PhotoMetadata.c"
		}
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (altitude) {
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*altitude = _vala_altitude;
#line 7546 "PhotoMetadata.c"
		}
#line 1003 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7550 "PhotoMetadata.c"
	}
#line 1006 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLongitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1006 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_long_ref);
#line 1006 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_long_ref = _tmp5_;
#line 1007 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLatitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1007 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_lat_ref);
#line 1007 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_lat_ref = _tmp6_;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (longitude) {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*longitude = _vala_longitude;
#line 7570 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (long_ref) {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*long_ref = _vala_long_ref;
#line 7576 "PhotoMetadata.c"
	} else {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 7580 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (latitude) {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*latitude = _vala_latitude;
#line 7586 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (lat_ref) {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*lat_ref = _vala_lat_ref;
#line 7592 "PhotoMetadata.c"
	} else {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 7596 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (altitude) {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*altitude = _vala_altitude;
#line 7602 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7606 "PhotoMetadata.c"
}


gboolean photo_metadata_get_exposure (PhotoMetadata* self, MetadataRational* exposure) {
	MetadataRational _vala_exposure = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1012 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_exposure = _tmp0_;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (exposure) {
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*exposure = _vala_exposure;
#line 7627 "PhotoMetadata.c"
	}
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7631 "PhotoMetadata.c"
}


gchar* photo_metadata_get_exposure_string (PhotoMetadata* self) {
	gchar* result = NULL;
	MetadataRational exposure_time = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
#line 1016 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exposure_time = _tmp0_;
#line 1018 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7654 "PhotoMetadata.c"
	}
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = metadata_rational_is_valid (&exposure_time);
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp2_) {
#line 1022 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1022 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7664 "PhotoMetadata.c"
	}
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureTime", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp3_;
#line 1024 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7672 "PhotoMetadata.c"
}


gboolean photo_metadata_get_iso (PhotoMetadata* self, glong* iso) {
	glong _vala_iso = 0L;
	gboolean result = FALSE;
	gboolean fetched_ok = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	glong _tmp4_ = 0L;
#line 1027 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.ISOSpeedRatings", &_tmp0_);
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_iso = _tmp0_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	fetched_ok = _tmp1_;
#line 1030 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = fetched_ok;
#line 1030 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ == FALSE) {
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 7703 "PhotoMetadata.c"
		}
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7707 "PhotoMetadata.c"
	}
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _vala_iso;
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ < ((glong) 6)) {
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 7715 "PhotoMetadata.c"
	} else {
		glong _tmp5_ = 0L;
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _vala_iso;
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5_ > ((glong) 409600);
#line 7722 "PhotoMetadata.c"
	}
#line 1035 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 1036 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1036 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1036 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 7732 "PhotoMetadata.c"
		}
#line 1036 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7736 "PhotoMetadata.c"
	}
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (iso) {
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*iso = _vala_iso;
#line 7744 "PhotoMetadata.c"
	}
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7748 "PhotoMetadata.c"
}


gchar* photo_metadata_get_iso_string (PhotoMetadata* self) {
	gchar* result = NULL;
	glong iso = 0L;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_iso (self, &_tmp0_);
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iso = _tmp0_;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7770 "PhotoMetadata.c"
	}
#line 1046 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ISOSpeedRatings", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1046 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 1046 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7778 "PhotoMetadata.c"
}


gboolean photo_metadata_get_aperture (PhotoMetadata* self, MetadataRational* aperture) {
	MetadataRational _vala_aperture = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1049 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FNumber", &_tmp0_);
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_aperture = _tmp0_;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (aperture) {
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*aperture = _vala_aperture;
#line 7799 "PhotoMetadata.c"
	}
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7803 "PhotoMetadata.c"
}


gchar* photo_metadata_get_aperture_string (PhotoMetadata* self, gboolean pango_formatted) {
	gchar* result = NULL;
	MetadataRational aperture = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gdouble aperture_value = 0.0;
	MetadataRational _tmp2_ = {0};
	gint _tmp3_ = 0;
	MetadataRational _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1055 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_aperture (self, &_tmp0_);
#line 1055 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture = _tmp0_;
#line 1055 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1056 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1056 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 7839 "PhotoMetadata.c"
	}
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = aperture;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_.numerator;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = aperture;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_.denominator;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gdouble) _tmp3_) / ((gdouble) _tmp5_);
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = aperture_value;
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gint) (_tmp6_ * 10.0)) / 10.0;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = pango_formatted;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp8_) {
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "<i>f</i>/";
#line 7861 "PhotoMetadata.c"
	} else {
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "f/";
#line 7865 "PhotoMetadata.c"
	}
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = aperture_value;
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (fmod (_tmp10_, 1) == ((gdouble) 0)) {
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = "%.0f";
#line 7873 "PhotoMetadata.c"
	} else {
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = "%.1f";
#line 7877 "PhotoMetadata.c"
	}
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = aperture_value;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf (_tmp9_, _tmp11_);
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = _tmp12_;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = _tmp14_;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp13_);
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp15_;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7895 "PhotoMetadata.c"
}


gchar* photo_metadata_get_camera_make (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1065 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Make", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7910 "PhotoMetadata.c"
}


gchar* photo_metadata_get_camera_model (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1069 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Model", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7925 "PhotoMetadata.c"
}


gboolean photo_metadata_get_flash (PhotoMetadata* self, glong* flash) {
	glong _vala_flash = 0L;
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
#line 1073 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.Flash", &_tmp0_);
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_flash = _tmp0_;
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (flash) {
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*flash = _vala_flash;
#line 7946 "PhotoMetadata.c"
	}
#line 1075 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7950 "PhotoMetadata.c"
}


gchar* photo_metadata_get_flash_string (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1078 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.Flash", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7965 "PhotoMetadata.c"
}


gboolean photo_metadata_get_focal_length (PhotoMetadata* self, MetadataRational* focal_length) {
	MetadataRational _vala_focal_length = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1083 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FocalLength", &_tmp0_);
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_focal_length = _tmp0_;
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (focal_length) {
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*focal_length = _vala_focal_length;
#line 7986 "PhotoMetadata.c"
	}
#line 1084 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7990 "PhotoMetadata.c"
}


gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1087 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1088 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.FocalLength", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1088 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1088 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8005 "PhotoMetadata.c"
}


gchar* photo_metadata_get_artist (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
#line 1096 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_ARTIST_TAGS;
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_ARTIST_TAGS_length1;
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string_interpreted (self, _tmp0_, _tmp0__length1);
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1097 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8026 "PhotoMetadata.c"
}


gchar* photo_metadata_get_copyright (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Copyright", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8041 "PhotoMetadata.c"
}


gchar* photo_metadata_get_software (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Software", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8056 "PhotoMetadata.c"
}


void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (software != NULL);
#line 1108 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (version != NULL);
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = software;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = version;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup_printf ("%s %s", _tmp0_, _tmp1_);
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Software", _tmp3_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 1112 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = photo_metadata_has_iptc (self);
#line 1112 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 8088 "PhotoMetadata.c"
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = software;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.Program", _tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = version;
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.ProgramVersion", _tmp6_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 8099 "PhotoMetadata.c"
	}
}


void photo_metadata_remove_software (PhotoMetadata* self) {
#line 1118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Exif.Image.Software");
#line 1120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.Program");
#line 1121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.ProgramVersion");
#line 8113 "PhotoMetadata.c"
}


gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureBiasValue", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1125 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8128 "PhotoMetadata.c"
}


Rating photo_metadata_get_rating (PhotoMetadata* self) {
	Rating result = 0;
	gchar* rating_string = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint int_percent_rating = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Rating _tmp18_ = 0;
#line 1135 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_RATING_TAGS;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_RATING_TAGS_length1;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string (self, _tmp0_, _tmp0__length1);
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp1_;
#line 1137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = rating_string;
#line 1137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ != NULL) {
#line 8159 "PhotoMetadata.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		Rating _tmp5_ = 0;
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = rating_string;
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = atoi (_tmp3_);
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = rating_unserialize (_tmp4_);
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp5_;
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8175 "PhotoMetadata.c"
	}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = photo_metadata_get_string (self, "Exif.Image.RatingPercent", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp6_;
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = rating_string;
#line 1141 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp7_ == NULL) {
#line 1142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = RATING_UNRATED;
#line 1142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8193 "PhotoMetadata.c"
	}
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = rating_string;
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = atoi (_tmp8_);
#line 1145 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_percent_rating = _tmp9_;
#line 8201 "PhotoMetadata.c"
	{
		gint i = 0;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		i = 5;
#line 8206 "PhotoMetadata.c"
		{
			gboolean _tmp10_ = FALSE;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = TRUE;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 8213 "PhotoMetadata.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp10_) {
#line 8220 "PhotoMetadata.c"
					gint _tmp11_ = 0;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = i;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					i = _tmp11_ - 1;
#line 8226 "PhotoMetadata.c"
				}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = FALSE;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = i;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp12_ >= 0)) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 8236 "PhotoMetadata.c"
				}
#line 1147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = int_percent_rating;
#line 1147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = i;
#line 1147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp15_ = RESOURCES_rating_thresholds[_tmp14_];
#line 1147 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp13_ >= _tmp15_) {
#line 8246 "PhotoMetadata.c"
					gint _tmp16_ = 0;
					Rating _tmp17_ = 0;
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp16_ = i;
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = rating_unserialize (_tmp16_);
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = _tmp17_;
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (rating_string);
#line 1148 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 8259 "PhotoMetadata.c"
				}
			}
		}
	}
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = rating_unserialize (-1);
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp18_;
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8272 "PhotoMetadata.c"
}


void photo_metadata_set_rating (PhotoMetadata* self, Rating rating) {
	gint int_rating = 0;
	Rating _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 1158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = rating;
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = rating_serialize (_tmp0_);
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_rating = _tmp1_;
#line 1160 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = int_rating;
#line 1160 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 1160 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 1160 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Xmp.xmp.Rating", _tmp4_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1160 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp4_);
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = int_rating;
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Rating", _tmp7_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp7_);
#line 1163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = int_rating;
#line 1163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (0 <= _tmp8_) {
#line 8319 "PhotoMetadata.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = int_rating;
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = RESOURCES_rating_thresholds[_tmp9_];
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = _tmp11_;
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp12_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp12_);
#line 8336 "PhotoMetadata.c"
	} else {
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 1166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = int_rating;
#line 1166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
#line 1166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_;
#line 1166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp15_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp15_);
#line 8351 "PhotoMetadata.c"
	}
}


static gpointer _media_metadata_ref0 (gpointer self) {
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 8359 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_construct (GType object_type, PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props) {
	PhotoMetadataInternalPhotoPreview* self = NULL;
	const gchar* _tmp0_ = NULL;
	GExiv2PreviewProperties* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	GExiv2PreviewProperties* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	Dimensions _tmp5_ = {0};
	GExiv2PreviewProperties* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	GExiv2PreviewProperties* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GExiv2PreviewProperties* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoMetadata* _tmp12_ = NULL;
	PhotoMetadata* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (owner), NULL);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (GEXIV2_IS_PREVIEW_PROPERTIES (props), NULL);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = props;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_preview_properties_get_width (_tmp1_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = props;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_preview_properties_get_height (_tmp3_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	dimensions_init (&_tmp5_, (gint) _tmp2_, (gint) _tmp4_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = props;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = gexiv2_preview_properties_get_size (_tmp6_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = props;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = gexiv2_preview_properties_get_mime_type (_tmp8_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = props;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = gexiv2_preview_properties_get_extension (_tmp10_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadataInternalPhotoPreview*) photo_preview_construct (object_type, _tmp0_, &_tmp5_, _tmp7_, _tmp9_, _tmp11_);
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = owner;
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = _media_metadata_ref0 (_tmp12_);
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->owner = _tmp13_;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = number;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->number = _tmp14_;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 8426 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_new (PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props) {
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_internal_photo_preview_construct (PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, owner, name, number, props);
#line 8433 "PhotoMetadata.c"
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 8440 "PhotoMetadata.c"
}


static guint8* photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base, int* result_length1, GError** error) {
	PhotoMetadataInternalPhotoPreview * self;
	guint8* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	GExiv2Metadata* _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	GExiv2PreviewProperties** _tmp3_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gboolean _tmp4_ = FALSE;
	GExiv2PreviewProperties** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	PhotoMetadata* _tmp8_ = NULL;
	GExiv2Metadata* _tmp9_ = NULL;
	GExiv2PreviewProperties** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint _tmp11_ = 0U;
	GExiv2PreviewProperties* _tmp12_ = NULL;
	GExiv2PreviewImage* _tmp13_ = NULL;
	GExiv2PreviewImage* _tmp14_ = NULL;
	guint32 _tmp15_;
	guint8* _tmp16_ = NULL;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	guint8* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	guint8* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
#line 127 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->owner;
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _tmp0_->priv->exiv2;
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_ = gexiv2_metadata_get_preview_properties (_tmp1_);
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp3_;
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp2_);
#line 128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = props;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = props_length1;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ != NULL) {
#line 8493 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		guint _tmp7_ = 0U;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = props;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6__length1 = props_length1;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->number;
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = ((guint) _tmp6__length1) > _tmp7_;
#line 8505 "PhotoMetadata.c"
	} else {
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = FALSE;
#line 8509 "PhotoMetadata.c"
	}
#line 129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp4_, "props != null && props.length > number");
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = self->owner;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = _tmp8_->priv->exiv2;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = props;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10__length1 = props_length1;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = self->number;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = _tmp10_[_tmp11_];
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = gexiv2_metadata_get_preview_image (_tmp9_, _tmp12_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = _tmp13_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = gexiv2_preview_image_get_data (_tmp14_, &_tmp15_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup6 (_tmp16_, _tmp15_) : ((gpointer) _tmp16_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17__length1 = _tmp15_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = _tmp17_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18__length1 = _tmp17__length1;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp14_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = _tmp18_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19__length1 = _tmp18__length1;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp19__length1;
#line 8549 "PhotoMetadata.c"
	}
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp19_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8555 "PhotoMetadata.c"
}


static void photo_metadata_internal_photo_preview_class_init (PhotoMetadataInternalPhotoPreviewClass * klass) {
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_internal_photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_metadata_internal_photo_preview_finalize;
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = (guint8* (*)(PhotoPreview*, int*, GError**)) photo_metadata_internal_photo_preview_real_flatten;
#line 8566 "PhotoMetadata.c"
}


static void photo_metadata_internal_photo_preview_instance_init (PhotoMetadataInternalPhotoPreview * self) {
}


static void photo_metadata_internal_photo_preview_finalize (PhotoPreview* obj) {
	PhotoMetadataInternalPhotoPreview * self;
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 115 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	PHOTO_PREVIEW_CLASS (photo_metadata_internal_photo_preview_parent_class)->finalize (obj);
#line 8582 "PhotoMetadata.c"
}


static GType photo_metadata_internal_photo_preview_get_type (void) {
	static volatile gsize photo_metadata_internal_photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_internal_photo_preview_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataInternalPhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_internal_photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadataInternalPhotoPreview), 0, (GInstanceInitFunc) photo_metadata_internal_photo_preview_instance_init, NULL };
		GType photo_metadata_internal_photo_preview_type_id;
		photo_metadata_internal_photo_preview_type_id = g_type_register_static (TYPE_PHOTO_PREVIEW, "PhotoMetadataInternalPhotoPreview", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_internal_photo_preview_type_id__volatile, photo_metadata_internal_photo_preview_type_id);
	}
	return photo_metadata_internal_photo_preview_type_id__volatile;
}


static void photo_metadata_class_init (PhotoMetadataClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	HierarchicalKeywordField* _tmp32_ = NULL;
	HierarchicalKeywordField* _tmp33_ = NULL;
	HierarchicalKeywordField* _tmp34_ = NULL;
	HierarchicalKeywordField** _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_parent_class = g_type_class_peek_parent (klass);
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = photo_metadata_finalize;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoMetadataPrivate));
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = (void (*)(MediaMetadata*, GFile*, GError**)) photo_metadata_real_read_from_file;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*)(MediaMetadata*)) photo_metadata_real_get_creation_date_time;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = (gchar* (*)(MediaMetadata*)) photo_metadata_real_get_title;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*)(MediaMetadata*)) photo_metadata_real_get_comment;
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup ("Exif.Image.DateTime");
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("Xmp.tiff.DateTime");
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup ("Xmp.xmp.ModifyDate");
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_[0] = _tmp0_;
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_[1] = _tmp1_;
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_[2] = _tmp2_;
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS = _tmp3_;
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS_length1 = 3;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = g_strdup ("Exif.Photo.DateTimeOriginal");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_strdup ("Xmp.exif.DateTimeOriginal");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_strdup ("Xmp.xmp.CreateDate");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = g_strdup ("Exif.Image.DateTime");
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = g_new0 (gchar*, 6 + 1);
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[0] = _tmp4_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[1] = _tmp5_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[2] = _tmp6_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[3] = _tmp7_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[4] = _tmp8_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_[5] = _tmp9_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS = _tmp10_;
#line 692 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 6;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = g_new0 (gchar*, 2 + 1);
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_[0] = _tmp11_;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_[1] = _tmp12_;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS = _tmp13_;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 2;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_strdup ("Exif.Photo.PixelXDimension");
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = g_strdup ("Xmp.tiff.ImageWidth");
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = g_new0 (gchar*, 4 + 1);
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_[0] = _tmp14_;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_[1] = _tmp15_;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_[2] = _tmp16_;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_[3] = _tmp17_;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS = _tmp18_;
#line 738 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS_length1 = 4;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = g_strdup ("Exif.Photo.PixelYDimension");
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = g_strdup ("Xmp.tiff.ImageHeight");
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = g_new0 (gchar*, 4 + 1);
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_[0] = _tmp19_;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_[1] = _tmp20_;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_[2] = _tmp21_;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_[3] = _tmp22_;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS = _tmp23_;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS_length1 = 4;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = g_strdup ("Iptc.Application2.Caption");
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = g_strdup ("Xmp.dc.title");
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp26_ = g_strdup ("Iptc.Application2.Headline");
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = g_strdup ("Xmp.photoshop.Headline");
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = g_new0 (gchar*, 4 + 1);
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_[0] = _tmp24_;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_[1] = _tmp25_;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_[2] = _tmp26_;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_[3] = _tmp27_;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS = _tmp28_;
#line 804 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS_length1 = 4;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = g_strdup ("Xmp.dc.subject");
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_ = g_strdup ("Iptc.Application2.Keywords");
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = g_new0 (gchar*, 2 + 1);
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_[0] = _tmp29_;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_[1] = _tmp30_;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS = _tmp31_;
#line 859 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS_length1 = 2;
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp32_ = hierarchical_keyword_field_new ("Xmp.lr.hierarchicalSubject", "|", FALSE, FALSE);
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_ = hierarchical_keyword_field_new ("Xmp.digiKam.TagsList", "/", FALSE, TRUE);
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp34_ = hierarchical_keyword_field_new ("Xmp.MicrosoftPhoto.LastKeywordXMP", "/", FALSE, TRUE);
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_ = g_new0 (HierarchicalKeywordField*, 3 + 1);
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_[0] = _tmp32_;
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_[1] = _tmp33_;
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_[2] = _tmp34_;
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS = _tmp35_;
#line 864 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 3;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp36_ = g_strdup ("Exif.Image.Artist");
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_ = g_strdup ("Exif.Canon.OwnerName");
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp38_ = g_new0 (gchar*, 2 + 1);
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp38_[0] = _tmp36_;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp38_[1] = _tmp37_;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS = _tmp38_;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS_length1 = 2;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp39_ = g_strdup ("Xmp.xmp.Rating");
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp40_ = g_strdup ("Iptc.Application2.Urgency");
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp41_ = g_strdup ("Xmp.photoshop.Urgency");
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp42_ = g_strdup ("Exif.Image.Rating");
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_ = g_new0 (gchar*, 4 + 1);
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_[0] = _tmp39_;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_[1] = _tmp40_;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_[2] = _tmp41_;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_[3] = _tmp42_;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS = _tmp43_;
#line 1128 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS_length1 = 4;
#line 8853 "PhotoMetadata.c"
}


static void photo_metadata_instance_init (PhotoMetadata * self) {
	GExiv2Metadata* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_METADATA_GET_PRIVATE (self);
#line 135 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 135 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("<uninitialized>");
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp1_;
#line 8872 "PhotoMetadata.c"
}


static void photo_metadata_finalize (MediaMetadata* obj) {
	PhotoMetadata * self;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 135 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	MEDIA_METADATA_CLASS (photo_metadata_parent_class)->finalize (obj);
#line 8888 "PhotoMetadata.c"
}


GType photo_metadata_get_type (void) {
	static volatile gsize photo_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadata), 0, (GInstanceInitFunc) photo_metadata_instance_init, NULL };
		GType photo_metadata_type_id;
		photo_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "PhotoMetadata", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_type_id__volatile, photo_metadata_type_id);
	}
	return photo_metadata_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



