/* tracker-backend.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>


#define TRACKER_BACKEND_TYPE_STATUS (tracker_backend_status_get_type ())
#define TRACKER_BACKEND_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatus))
#define TRACKER_BACKEND_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BACKEND_TYPE_STATUS))
#define TRACKER_BACKEND_STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TRACKER_BACKEND_TYPE_STATUS, TrackerBackendStatusIface))

typedef struct _TrackerBackendStatus TrackerBackendStatus;
typedef struct _TrackerBackendStatusIface TrackerBackendStatusIface;

#define TRACKER_BACKEND_TYPE_STATUS_PROXY (tracker_backend_status_proxy_get_type ())
typedef GDBusProxy TrackerBackendStatusProxy;
typedef GDBusProxyClass TrackerBackendStatusProxyClass;

#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;

#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlBackendInitAsyncData TrackerSparqlBackendInitAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _TrackerBackendStatusIface {
	GTypeInterface parent_iface;
	void (*wait) (TrackerBackendStatus* self, GError** error);
	void (*wait_async) (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*wait_finish) (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	void (*init) (TrackerSparqlConnection* self, GError** error);
	void (*init_async) (TrackerSparqlConnection* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*init_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update_array_async) (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GPtrArray* (*update_array_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean direct_only;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendInitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	TrackerBackendStatus* _tmp0_;
	TrackerBackendStatus* status;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * e;
	GError* _tmp4_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* uri;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_;
};

typedef TrackerSparqlConnection* (*TrackerSparqlBackendModuleInitFunc) (GError** error);

static gpointer tracker_sparql_backend_parent_class = NULL;

GType tracker_backend_status_proxy_get_type (void) G_GNUC_CONST;
guint tracker_backend_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType tracker_backend_status_get_type (void) G_GNUC_CONST;
void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error);
void tracker_backend_status_wait_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_backend_status_wait_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
static void tracker_backend_status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void tracker_backend_status_proxy_wait (TrackerBackendStatus* self, GError** error);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void tracker_backend_status_proxy_wait_async_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_backend_status_proxy_wait_async_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error);
static void tracker_backend_status_proxy_tracker_backend_status_interface_init (TrackerBackendStatusIface* iface);
static void _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_backend_status_wait_async (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_tracker_backend_status_wait_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void tracker_backend_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_backend_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_backend_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _tracker_backend_status_unregister_object (gpointer user_data);
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendPrivate))
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (gboolean direct_only, GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, gboolean direct_only, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);
static void tracker_sparql_backend_real_init (TrackerSparqlConnection* base, GError** error);
#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_DBUS_OBJECT_STATUS "/org/freedesktop/Tracker1/Status"
static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error);
void tracker_sparql_connection_init (TrackerSparqlConnection* self, GError** error);
static void tracker_sparql_backend_real_init_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_init_async (TrackerSparqlConnection* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_init_async_co (TrackerSparqlBackendInitAsyncData* data);
static void tracker_sparql_backend_init_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_init_async (TrackerSparqlConnection* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_init_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data);
void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlConnection* tracker_sparql_backend_load_plugins_from_path (TrackerSparqlBackend* self, const gchar* path, gboolean required, GError** error);
static void tracker_sparql_backend_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_in[] = {NULL};
static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_out[] = {NULL};
static const GDBusMethodInfo _tracker_backend_status_dbus_method_info_wait = {-1, "Wait", (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_in), (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_out)};
static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_async_in[] = {NULL};
static const GDBusArgInfo * const _tracker_backend_status_dbus_arg_info_wait_async_out[] = {NULL};
static const GDBusMethodInfo _tracker_backend_status_dbus_method_info_wait_async = {-1, "Wait", (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_async_in), (GDBusArgInfo **) (&_tracker_backend_status_dbus_arg_info_wait_async_out)};
static const GDBusMethodInfo * const _tracker_backend_status_dbus_method_info[] = {&_tracker_backend_status_dbus_method_info_wait, &_tracker_backend_status_dbus_method_info_wait_async, NULL};
static const GDBusSignalInfo * const _tracker_backend_status_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _tracker_backend_status_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_backend_status_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Status", (GDBusMethodInfo **) (&_tracker_backend_status_dbus_method_info), (GDBusSignalInfo **) (&_tracker_backend_status_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_backend_status_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_backend_status_dbus_interface_vtable = {tracker_backend_status_dbus_interface_method_call, tracker_backend_status_dbus_interface_get_property, tracker_backend_status_dbus_interface_set_property};

void tracker_backend_status_wait (TrackerBackendStatus* self, GError** error) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait (self, error);
}


void tracker_backend_status_wait_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait_async (self, _callback_, _user_data_);
}


void tracker_backend_status_wait_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error) {
	TRACKER_BACKEND_STATUS_GET_INTERFACE (self)->wait_finish (self, _res_, error);
}


static void tracker_backend_status_base_init (TrackerBackendStatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType tracker_backend_status_get_type (void) {
	static volatile gsize tracker_backend_status_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_backend_status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerBackendStatusIface), (GBaseInitFunc) tracker_backend_status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tracker_backend_status_type_id;
		tracker_backend_status_type_id = g_type_register_static (G_TYPE_INTERFACE, "TrackerBackendStatus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tracker_backend_status_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) tracker_backend_status_proxy_get_type);
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Status");
		g_type_set_qdata (tracker_backend_status_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_backend_status_register_object);
		g_once_init_leave (&tracker_backend_status_type_id__volatile, tracker_backend_status_type_id);
	}
	return tracker_backend_status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TrackerBackendStatusProxy, tracker_backend_status_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TRACKER_BACKEND_TYPE_STATUS, tracker_backend_status_proxy_tracker_backend_status_interface_init) );
static void tracker_backend_status_proxy_class_init (TrackerBackendStatusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = tracker_backend_status_proxy_g_signal;
}


static void tracker_backend_status_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void tracker_backend_status_proxy_init (TrackerBackendStatusProxy* self) {
}


static void tracker_backend_status_proxy_wait (TrackerBackendStatus* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "Wait");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void tracker_backend_status_proxy_wait_async_async (TrackerBackendStatus* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Status", "Wait");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void tracker_backend_status_proxy_wait_async_finish (TrackerBackendStatus* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void tracker_backend_status_proxy_tracker_backend_status_interface_init (TrackerBackendStatusIface* iface) {
	iface->wait = tracker_backend_status_proxy_wait;
	iface->wait_async = tracker_backend_status_proxy_wait_async_async;
	iface->wait_finish = tracker_backend_status_proxy_wait_async_finish;
}


static void _dbus_tracker_backend_status_wait (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_backend_status_wait (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_backend_status_wait_async (TrackerBackendStatus* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	tracker_backend_status_wait_async (self, (GAsyncReadyCallback) _dbus_tracker_backend_status_wait_async_ready, invocation);
}


static void _dbus_tracker_backend_status_wait_async_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_backend_status_wait_finish ((TrackerBackendStatus*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_backend_status_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Wait") == 0) {
		_dbus_tracker_backend_status_wait (object, parameters, invocation);
	} else if (strcmp (method_name, "Wait") == 0) {
		_dbus_tracker_backend_status_wait_async (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_backend_status_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_backend_status_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint tracker_backend_status_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_backend_status_dbus_interface_info), &_tracker_backend_status_dbus_interface_vtable, data, _tracker_backend_status_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _tracker_backend_status_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, gboolean direct_only, GError** error) {
	TrackerSparqlBackend * self = NULL;
	gboolean _tmp0_;
	_tmp0_ = g_module_supported ();
	g_return_val_if_fail (_tmp0_, NULL);
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
	self->priv->direct_only = direct_only;
	return self;
}


TrackerSparqlBackend* tracker_sparql_backend_new (gboolean direct_only, GError** error) {
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, direct_only, error);
}


static void tracker_sparql_backend_real_init (TrackerSparqlConnection* base, GError** error) {
	TrackerSparqlBackend * self;
	TrackerBackendStatus* _tmp0_ = NULL;
	TrackerBackendStatus* status;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	_tmp0_ = g_initable_new (TRACKER_BACKEND_TYPE_STATUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", TRACKER_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", TRACKER_DBUS_OBJECT_STATUS, "g-interface-name", "org.freedesktop.Tracker1.Status", NULL);
	status = (TrackerBackendStatus*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_dbus_proxy_set_default_timeout ((GDBusProxy*) status, G_MAXINT);
	g_debug ("tracker-backend.vala:54: Waiting for service to become available synch" \
"ronously...");
	tracker_backend_status_wait (status, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (status);
			return;
		} else {
			_g_object_unref0 (status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("tracker-backend.vala:56: Service is ready");
	_tmp1_ = NULL;
	if (self->priv->direct_only) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	g_debug ("tracker-backend.vala:59: Constructing connection, direct_only=%s", _tmp1_);
	_tmp2_ = tracker_sparql_backend_load_plugins (self, self->priv->direct_only, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	if (_tmp3_) {
		g_debug ("tracker-backend.vala:61: Waiting for backend to become available synch" \
"ronously...");
		if (self->priv->direct != NULL) {
			tracker_sparql_connection_init (self->priv->direct, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		} else {
			tracker_sparql_connection_init (self->priv->bus, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
		g_debug ("tracker-backend.vala:67: Backend is ready");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GError* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (status);
			return;
		} else {
			_g_object_unref0 (status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (status);
}


static void tracker_sparql_backend_real_init_async_data_free (gpointer _data) {
	TrackerSparqlBackendInitAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendInitAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_sparql_backend_real_init_async (TrackerSparqlConnection* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendInitAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendInitAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_init_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_init_async_data_free);
	_data_->self = _g_object_ref0 (self);
	tracker_sparql_backend_real_init_async_co (_data_);
}


static void tracker_sparql_backend_real_init_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendInitAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_init_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendInitAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_init_async_co (data);
}


static gboolean tracker_sparql_backend_real_init_async_co (TrackerSparqlBackendInitAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_initable_new (TRACKER_BACKEND_TYPE_STATUS_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", TRACKER_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", TRACKER_DBUS_OBJECT_STATUS, "g-interface-name", "org.freedesktop.Tracker1.Status", NULL);
	data->status = (TrackerBackendStatus*) data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_dbus_proxy_set_default_timeout ((GDBusProxy*) data->status, G_MAXINT);
	g_debug ("tracker-backend.vala:82: Waiting for service to become available async" \
"hronously...");
	data->_state_ = 1;
	tracker_backend_status_wait_async (data->status, tracker_sparql_backend_init_async_ready, data);
	return FALSE;
	_state_1:
	tracker_backend_status_wait_finish (data->status, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->status);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_debug ("tracker-backend.vala:84: Service is ready");
	if (data->self->priv->direct_only) {
		data->_tmp1_ = "true";
	} else {
		data->_tmp1_ = "false";
	}
	g_debug ("tracker-backend.vala:87: Constructing connection, direct_only=%s", data->_tmp1_);
	data->_tmp2_ = tracker_sparql_backend_load_plugins (data->self, data->self->priv->direct_only, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	if (data->_tmp3_) {
		g_debug ("tracker-backend.vala:89: Waiting for backend to become available async" \
"hronously...");
		if (data->self->priv->direct != NULL) {
			data->_state_ = 2;
			tracker_sparql_connection_init_async (data->self->priv->direct, tracker_sparql_backend_init_async_ready, data);
			return FALSE;
			_state_2:
			tracker_sparql_connection_init_finish (data->self->priv->direct, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		} else {
			data->_state_ = 3;
			tracker_sparql_connection_init_async (data->self->priv->bus, tracker_sparql_backend_init_async_ready, data);
			return FALSE;
			_state_3:
			tracker_sparql_connection_init_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		g_debug ("tracker-backend.vala:95: Backend is ready");
	}
	goto __finally1;
	__catch1_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, data->e->message);
		data->_inner_error_ = data->_tmp4_;
		_g_error_free0 (data->e);
		goto __finally1;
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->status);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->status);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (data->status);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail ((self->priv->bus != NULL) || (self->priv->direct != NULL), NULL);
	g_debug ("tracker-backend.vala:104: %s(): '%s'", "Tracker.Sparql.Backend.query", sparql);
	if (self->priv->direct != NULL) {
		TrackerSparqlCursor* _tmp0_ = NULL;
		TrackerSparqlCursor* _tmp1_;
		_tmp0_ = tracker_sparql_connection_query (self->priv->direct, sparql, cancellable, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp1_;
		return result;
	} else {
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlCursor* _tmp3_;
		_tmp2_ = tracker_sparql_connection_query (self->priv->bus, sparql, cancellable, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp3_;
		return result;
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendQueryAsyncData, data);
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_query_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_query_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_query_async_co (data);
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail ((data->self->priv->bus != NULL) || (data->self->priv->direct != NULL), FALSE);
	g_debug ("tracker-backend.vala:114: %s(): '%s'", "Tracker.Sparql.Backend.query_async", data->sparql);
	if (data->self->priv->direct != NULL) {
		data->_state_ = 1;
		tracker_sparql_connection_query_async (data->self->priv->direct, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = tracker_sparql_connection_query_finish (data->self->priv->direct, data->_res_, &data->_inner_error_);
		data->_tmp1_ = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_state_ = 2;
		tracker_sparql_connection_query_async (data->self->priv->bus, data->sparql, data->cancellable, tracker_sparql_backend_query_async_ready, data);
		return FALSE;
		_state_2:
		data->_tmp2_ = NULL;
		data->_tmp2_ = tracker_sparql_connection_query_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
		data->_tmp3_ = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		data->result = data->_tmp3_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (self->priv->bus != NULL);
	g_debug ("tracker-backend.vala:124: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", priority, sparql);
	tracker_sparql_connection_update (self->priv->bus, sparql, priority, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (sparql != NULL, NULL);
	g_return_val_if_fail (self->priv->bus != NULL, NULL);
	g_debug ("tracker-backend.vala:130: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", priority, sparql);
	_tmp0_ = tracker_sparql_connection_update_blank (self->priv->bus, sparql, priority, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, data);
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_async_co (_data_);
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:136: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_async (data->self->priv->bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _data;
	data->sparql = (_vala_array_free (data->sparql, data->sparql_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->cancellable);
	_g_ptr_array_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, data);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	gchar** _tmp0_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_array_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = (_tmp0_ = sparql, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, sparql_length1));
	_data_->sparql_length1 = sparql_length1;
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_array_async_co (_data_);
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_array_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	data->_state_ = 1;
	tracker_sparql_connection_update_array_async (data->self->priv->bus, data->sparql, data->sparql_length1, data->priority, data->cancellable, tracker_sparql_backend_update_array_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_array_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, data);
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_update_blank_async_co (data);
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:147: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", data->priority, data->sparql);
	data->_state_ = 1;
	tracker_sparql_connection_update_blank_async (data->self->priv->bus, data->sparql, data->priority, data->cancellable, tracker_sparql_backend_update_blank_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_update_blank_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* _tmp0_ = NULL;
	gchar* uri;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (self->priv->bus != NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	g_debug ("tracker-backend.vala:154: %s(): '%s'", "Tracker.Sparql.Backend.load", uri);
	tracker_sparql_connection_load (self->priv->bus, file, cancellable, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (uri);
			return;
		} else {
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (uri);
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendLoadAsyncData, data);
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_load_async_co (_data_);
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_load_async_co (data);
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_uri (data->file);
	data->uri = data->_tmp0_;
	g_debug ("tracker-backend.vala:161: %s(): '%s'", "Tracker.Sparql.Backend.load_async", data->uri);
	data->_state_ = 1;
	tracker_sparql_connection_load_async (data->self->priv->bus, data->file, data->cancellable, tracker_sparql_backend_load_async_ready, data);
	return FALSE;
	_state_1:
	tracker_sparql_connection_load_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->uri);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_free0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlCursor* _tmp0_ = NULL;
	TrackerSparqlCursor* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (TrackerSparqlBackend*) base;
	g_return_val_if_fail (self->priv->bus != NULL, NULL);
	g_debug ("tracker-backend.vala:167: %s()", "Tracker.Sparql.Backend.statistics");
	_tmp0_ = tracker_sparql_connection_statistics (self->priv->bus, cancellable, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, data);
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	self = (TrackerSparqlBackend*) base;
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_backend_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_sparql_backend_real_statistics_async_co (data);
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_val_if_fail (data->self->priv->bus != NULL, FALSE);
	g_debug ("tracker-backend.vala:173: %s()", "Tracker.Sparql.Backend.statistics_async");
	data->_state_ = 1;
	tracker_sparql_connection_statistics_async (data->self->priv->bus, data->cancellable, tracker_sparql_backend_statistics_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_sparql_connection_statistics_finish (data->self->priv->bus, data->_res_, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (((data->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (data->_inner_error_->domain == G_IO_ERROR)) || (data->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = data->_tmp1_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, gboolean direct_only, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* env_path;
	gchar* path;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp8_ = NULL;
	GFile* dir;
	gchar* _tmp9_ = NULL;
	gchar* dir_path;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* env_backend;
	TrackerSparqlBackendBackend backend;
	gboolean _tmp15_ = FALSE;
	TrackerSparqlConnection* connection;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("TRACKER_SPARQL_MODULE_PATH");
	_tmp1_ = g_strdup (_tmp0_);
	env_path = _tmp1_;
	path = NULL;
	if (env_path != NULL) {
		gint _tmp3_;
		_tmp3_ = strlen (env_path);
		_tmp2_ = _tmp3_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (env_path);
		_tmp5_ = _tmp4_;
		_g_free0 (path);
		path = _tmp5_;
	} else {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup (SPARQL_MODULES_DIR);
		_tmp7_ = _tmp6_;
		_g_free0 (path);
		path = _tmp7_;
	}
	_tmp8_ = g_file_new_for_path (path);
	dir = _tmp8_;
	_tmp9_ = g_file_get_path (dir);
	dir_path = _tmp9_;
	_tmp10_ = g_getenv ("TRACKER_SPARQL_BACKEND");
	_tmp11_ = g_strdup (_tmp10_);
	env_backend = _tmp11_;
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
	if (env_backend != NULL) {
		gint _tmp12_;
		_tmp12_ = g_ascii_strcasecmp (env_backend, "direct");
		if (_tmp12_ == 0) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:197: Using backend = 'DIRECT'");
		} else {
			gint _tmp13_;
			_tmp13_ = g_ascii_strcasecmp (env_backend, "bus");
			if (_tmp13_ == 0) {
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
				g_debug ("tracker-backend.vala:200: Using backend = 'BUS'");
			} else {
				g_warning ("tracker-backend.vala:202: Environment variable TRACKER_SPARQL_BACKEND " \
"set to unknown value '%s'", env_backend);
			}
		}
	}
	if (backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
		gboolean _tmp14_ = FALSE;
		if (direct_only) {
			_tmp14_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
			g_debug ("tracker-backend.vala:209: Using backend = 'DIRECT'");
		} else {
			g_debug ("tracker-backend.vala:211: Using backend = 'AUTO'");
		}
	}
	if (direct_only) {
		_tmp15_ = backend == TRACKER_SPARQL_BACKEND_BACKEND_BUS;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		g_debug ("tracker-backend.vala:216: Backend set in environment contradicts reque" \
"sted connection type, using environment to override");
	}
	g_debug ("tracker-backend.vala:219: Searching for modules in folder '%s' ..", dir_path);
	connection = NULL;
	switch (backend) {
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
		{
			gchar* _tmp16_ = NULL;
			gchar* direct_path;
			TrackerSparqlConnection* _tmp17_ = NULL;
			TrackerSparqlConnection* _tmp18_;
			TrackerSparqlConnection* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* bus_path;
			TrackerSparqlConnection* _tmp21_ = NULL;
			TrackerSparqlConnection* _tmp22_;
			TrackerSparqlConnection* _tmp23_;
			TrackerSparqlConnection* _tmp24_;
			TrackerSparqlConnection* _tmp25_;
			_tmp16_ = g_module_build_path (dir_path, "tracker-direct");
			direct_path = _tmp16_;
			_tmp17_ = tracker_sparql_backend_load_plugins_from_path (self, direct_path, FALSE, &_inner_error_);
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp19_ = _tmp18_;
			_g_object_unref0 (self->priv->direct);
			self->priv->direct = _tmp19_;
			_tmp20_ = g_module_build_path (dir_path, "tracker-bus");
			bus_path = _tmp20_;
			_tmp21_ = tracker_sparql_backend_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp23_ = _tmp22_;
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = _tmp23_;
			_tmp24_ = _g_object_ref0 (self->priv->bus);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (connection);
			connection = _tmp25_;
			_g_free0 (bus_path);
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
		{
			gchar* _tmp26_ = NULL;
			gchar* direct_path;
			TrackerSparqlConnection* _tmp27_ = NULL;
			TrackerSparqlConnection* _tmp28_;
			TrackerSparqlConnection* _tmp29_;
			TrackerSparqlConnection* _tmp30_;
			TrackerSparqlConnection* _tmp31_;
			_tmp26_ = g_module_build_path (dir_path, "tracker-direct");
			direct_path = _tmp26_;
			_tmp27_ = tracker_sparql_backend_load_plugins_from_path (self, direct_path, TRUE, &_inner_error_);
			_tmp28_ = _tmp27_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (direct_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp29_ = _tmp28_;
			_g_object_unref0 (self->priv->direct);
			self->priv->direct = _tmp29_;
			_tmp30_ = _g_object_ref0 (self->priv->direct);
			_tmp31_ = _tmp30_;
			_g_object_unref0 (connection);
			connection = _tmp31_;
			_g_free0 (direct_path);
			break;
		}
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
		{
			gchar* _tmp32_ = NULL;
			gchar* bus_path;
			TrackerSparqlConnection* _tmp33_ = NULL;
			TrackerSparqlConnection* _tmp34_;
			TrackerSparqlConnection* _tmp35_;
			TrackerSparqlConnection* _tmp36_;
			TrackerSparqlConnection* _tmp37_;
			_tmp32_ = g_module_build_path (dir_path, "tracker-bus");
			bus_path = _tmp32_;
			_tmp33_ = tracker_sparql_backend_load_plugins_from_path (self, bus_path, TRUE, &_inner_error_);
			_tmp34_ = _tmp33_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (bus_path);
				_g_object_unref0 (connection);
				_g_free0 (env_backend);
				_g_free0 (dir_path);
				_g_object_unref0 (dir);
				_g_free0 (path);
				_g_free0 (env_path);
				return FALSE;
			}
			_tmp35_ = _tmp34_;
			_g_object_unref0 (self->priv->bus);
			self->priv->bus = _tmp35_;
			_tmp36_ = _g_object_ref0 (self->priv->bus);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (connection);
			connection = _tmp37_;
			_g_free0 (bus_path);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	g_debug ("tracker-backend.vala:248: Finished searching for modules");
	result = connection != NULL;
	_g_object_unref0 (connection);
	_g_free0 (env_backend);
	_g_free0 (dir_path);
	_g_object_unref0 (dir);
	_g_free0 (path);
	_g_free0 (env_path);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static TrackerSparqlConnection* tracker_sparql_backend_load_plugins_from_path (TrackerSparqlBackend* self, const gchar* path, gboolean required, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GModule* _tmp0_ = NULL;
	GModule* module;
	void* function = NULL;
	void* _tmp3_ = NULL;
	gboolean _tmp4_;
	TrackerSparqlBackendModuleInitFunc module_init;
	TrackerSparqlConnection* _tmp7_ = NULL;
	TrackerSparqlConnection* c;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_module_open (path, G_MODULE_BIND_LOCAL | G_MODULE_BIND_LAZY);
	module = _tmp0_;
	if (module == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = g_module_error ();
		_tmp2_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to load module from path '%s': %s", path, _tmp1_);
		_inner_error_ = _tmp2_;
		_g_module_close0 (module);
		goto __catch2_g_error;
	}
	_tmp4_ = g_module_symbol (module, "module_init", &_tmp3_);
	function = _tmp3_;
	if (!_tmp4_) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = g_module_error ();
		_tmp6_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to find entry point function '%s' in '%s': %s", "module_init", path, _tmp5_);
		_inner_error_ = _tmp6_;
		_g_module_close0 (module);
		goto __catch2_g_error;
	}
	module_init = (TrackerSparqlBackendModuleInitFunc) function;
	g_assert (module_init != NULL);
	g_module_make_resident (module);
	_tmp7_ = module_init (&_inner_error_);
	c = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_module_close0 (module);
		goto __catch2_g_error;
	}
	_tmp8_ = g_module_name (module);
	g_debug ("tracker-backend.vala:282: Loaded module source: '%s'", _tmp8_);
	result = c;
	_g_module_close0 (module);
	return result;
	_g_object_unref0 (c);
	_g_module_close0 (module);
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (required) {
			GError* _tmp9_;
			_tmp9_ = _g_error_copy0 (e);
			_inner_error_ = _tmp9_;
			_g_error_free0 (e);
			goto __finally2;
		} else {
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		_g_error_free0 (e);
	}
	__finally2:
	g_propagate_error (error, _inner_error_);
	return NULL;
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlBackendPrivate));
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init = tracker_sparql_backend_real_init;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init_async = tracker_sparql_backend_real_init_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->init_finish = tracker_sparql_backend_real_init_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_backend_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_sparql_backend_real_query_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_sparql_backend_real_query_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_backend_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_backend_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_backend_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_backend_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_async = tracker_sparql_backend_real_update_array_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_finish = tracker_sparql_backend_real_update_array_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_backend_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_backend_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_backend_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_backend_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_backend_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_backend_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_backend_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_backend_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
	self->priv = TRACKER_SPARQL_BACKEND_GET_PRIVATE (self);
	self->priv->direct = NULL;
	self->priv->bus = NULL;
}


static void tracker_sparql_backend_finalize (GObject* obj) {
	TrackerSparqlBackend * self;
	self = TRACKER_SPARQL_BACKEND (obj);
	_g_object_unref0 (self->priv->direct);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



