/* tracker-needle.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-needle.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_NEEDLE (tracker_needle_get_type ())
#define TRACKER_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedle))
#define TRACKER_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))
#define TRACKER_IS_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_NEEDLE))
#define TRACKER_IS_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_NEEDLE))
#define TRACKER_NEEDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))

typedef struct _TrackerNeedle TrackerNeedle;
typedef struct _TrackerNeedleClass TrackerNeedleClass;
typedef struct _TrackerNeedlePrivate TrackerNeedlePrivate;

#define TRACKER_TYPE_HISTORY (tracker_history_get_type ())
#define TRACKER_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_HISTORY, TrackerHistory))
#define TRACKER_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_HISTORY, TrackerHistoryClass))
#define TRACKER_IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_HISTORY))
#define TRACKER_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_HISTORY))
#define TRACKER_HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_HISTORY, TrackerHistoryClass))

typedef struct _TrackerHistory TrackerHistory;
typedef struct _TrackerHistoryClass TrackerHistoryClass;

#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;

#define TRACKER_TYPE_TAG_LIST (tracker_tag_list_get_type ())
#define TRACKER_TAG_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TAG_LIST, TrackerTagList))
#define TRACKER_TAG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TAG_LIST, TrackerTagListClass))
#define TRACKER_IS_TAG_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TAG_LIST))
#define TRACKER_IS_TAG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TAG_LIST))
#define TRACKER_TAG_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TAG_LIST, TrackerTagListClass))

typedef struct _TrackerTagList TrackerTagList;
typedef struct _TrackerTagListClass TrackerTagListClass;

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _tracker_history_unref0(var) ((var == NULL) ? NULL : (var = (tracker_history_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerParamSpecNeedle TrackerParamSpecNeedle;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _tracker_needle_unref0(var) ((var == NULL) ? NULL : (var = (tracker_needle_unref (var), NULL)))

struct _TrackerNeedle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerNeedlePrivate * priv;
};

struct _TrackerNeedleClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerNeedle *self);
};

struct _TrackerNeedlePrivate {
	TrackerHistory* history;
	GtkWindow* window;
	GtkToggleToolButton* view_categories;
	GtkToggleToolButton* view_filelist;
	GtkToggleToolButton* view_icons;
	GtkSeparatorToolItem* separator_secondary;
	GtkToggleToolButton* find_in_contents;
	GtkToggleToolButton* find_in_titles;
	GtkComboBoxEntry* search_list;
	GtkEntry* search;
	GtkSpinner* spinner;
	GtkToolItem* spinner_shell;
	GtkToggleToolButton* show_tags;
	GtkToolButton* show_stats;
	GtkHBox* view;
	TrackerView* sw_noresults;
	TrackerView* sw_categories;
	TrackerView* sw_filelist;
	TrackerView* sw_icons;
	TrackerTagList* taglist;
	guint last_search_id;
	gint size_small;
	gint size_medium;
	gint size_big;
	TrackerResultStore* categories_model;
	TrackerResultStore* files_model;
	TrackerResultStore* files_in_title_model;
	TrackerResultStore* images_model;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_ALL_ONLY_IN_TITLES,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS
} TrackerQueryType;

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _TrackerParamSpecNeedle {
	GParamSpec parent_instance;
};


static gpointer tracker_needle_parent_class = NULL;
static gboolean tracker_needle_current_find_in;
static gboolean tracker_needle_current_find_in = TRUE;
extern gboolean print_version;
gboolean print_version = FALSE;
extern gchar** search_criteria;
gchar** search_criteria = NULL;

gpointer tracker_needle_ref (gpointer instance);
void tracker_needle_unref (gpointer instance);
GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_needle (GValue* value, gpointer v_object);
void tracker_value_take_needle (GValue* value, gpointer v_object);
gpointer tracker_value_get_needle (const GValue* value);
GType tracker_needle_get_type (void) G_GNUC_CONST;
gpointer tracker_history_ref (gpointer instance);
void tracker_history_unref (gpointer instance);
GParamSpec* tracker_param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_history (GValue* value, gpointer v_object);
void tracker_value_take_history (GValue* value, gpointer v_object);
gpointer tracker_value_get_history (const GValue* value);
GType tracker_history_get_type (void) G_GNUC_CONST;
GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_tag_list_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_NEEDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_NEEDLE, TrackerNeedlePrivate))
enum  {
	TRACKER_NEEDLE_DUMMY_PROPERTY
};
#define TRACKER_NEEDLE_UI_FILE "tracker-needle.ui"
static void tracker_needle_create_models (TrackerNeedle* self);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, ...);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
TrackerNeedle* tracker_needle_new (void);
TrackerNeedle* tracker_needle_construct (GType object_type);
TrackerHistory* tracker_history_new (void);
TrackerHistory* tracker_history_construct (GType object_type);
void tracker_needle_show (TrackerNeedle* self);
static void tracker_needle_setup_ui (TrackerNeedle* self);
void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1);
static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_view_toggled (TrackerNeedle* self);
static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_find_in_toggled (TrackerNeedle* self);
static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable);
static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry);
static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1);
gchar** tracker_history_get (TrackerHistory* self, int* result_length1);
static void tracker_needle_show_tags_clicked (TrackerNeedle* self);
static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void tracker_needle_show_stats_clicked (TrackerNeedle* self);
static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GType tracker_view_display_get_type (void) G_GNUC_CONST;
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _tracker_needle_view_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tracker_needle_icon_item_selected (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path);
static void _tracker_needle_icon_item_selected_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
TrackerTagList* tracker_tag_list_new (void);
TrackerTagList* tracker_tag_list_construct (GType object_type);
static gboolean tracker_needle_search_run (TrackerNeedle* self);
static gboolean _tracker_needle_search_run_gsource_func (gpointer self);
static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
void tracker_history_add (TrackerHistory* self, const gchar* criteria);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
static void tracker_needle_launch_selected (TrackerNeedle* self, GtkTreeModel* model, GtkTreePath* path, gint col);
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
GType tracker_stats_get_type (void) G_GNUC_CONST;
static void tracker_needle_finalize (TrackerNeedle* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[3] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &print_version, "Print version", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &search_criteria, "[SEARCH-CRITERIA]", "[SEARCH-CRITERIA]"}, {NULL}};

static void tracker_needle_create_models (TrackerNeedle* self) {
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_;
	TrackerResultStore* _tmp2_ = NULL;
	TrackerResultStore* _tmp3_;
	TrackerResultStore* _tmp4_ = NULL;
	TrackerResultStore* _tmp5_;
	TrackerResultStore* _tmp6_ = NULL;
	TrackerResultStore* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_result_store_new (6);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->categories_model);
	self->priv->categories_model = _tmp1_;
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_APPLICATIONS, "?urn", "tracker:coalesce(nfo:softwareCmdLine(?urn), ?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:comment(?urn)", "\"\"", "\"\"", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_IMAGES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((nfo:height(?urn), nfo:width(?urn)), \" x \")", "nfo:fileSize(?urn)", "nie:url(?urn)", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_MUSIC, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((?performer, ?album), \" - \")", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_VIDEOS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "\"\"", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_DOCUMENTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "tracker:coalesce(nco:fullname(?creator), nco:fullname(?publisher))", "nfo:pageCount(?urn)", "nie:url(?urn)", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_MAIL, "?urn", "nie:url(?urn)", "tracker:coalesce(nco:fullname(?sender), nco:nickname(?sender), nco:ema" \
"ilAddress(?sender))", "tracker:coalesce(nmo:messageSubject(?urn))", "nmo:receivedDate(?urn)", "fn:concat(\"To: \", tracker:coalesce(nco:fullname(?to), nco:nickname(?" \
"to), nco:emailAddress(?to)))", NULL);
	tracker_result_store_add_query (self->priv->categories_model, TRACKER_QUERY_TYPE_FOLDERS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?parent)", "nfo:fileLastModified(?urn)", "?tooltip", NULL);
	_tmp2_ = tracker_result_store_new (7);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->files_model);
	self->priv->files_model = _tmp3_;
	tracker_result_store_add_query (self->priv->files_model, TRACKER_QUERY_TYPE_ALL, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
	_tmp4_ = tracker_result_store_new (7);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->files_in_title_model);
	self->priv->files_in_title_model = _tmp5_;
	tracker_result_store_add_query (self->priv->files_in_title_model, TRACKER_QUERY_TYPE_ALL_ONLY_IN_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
	_tmp6_ = tracker_result_store_new (6);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->images_model);
	self->priv->images_model = _tmp7_;
	tracker_result_store_set_icon_size (self->priv->images_model, 48);
	tracker_result_store_add_query (self->priv->images_model, TRACKER_QUERY_TYPE_IMAGES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
}


TrackerNeedle* tracker_needle_construct (GType object_type) {
	TrackerNeedle* self = NULL;
	TrackerHistory* _tmp0_ = NULL;
	TrackerHistory* _tmp1_;
	self = (TrackerNeedle*) g_type_create_instance (object_type);
	tracker_needle_create_models (self);
	_tmp0_ = tracker_history_new ();
	_tmp1_ = _tmp0_;
	_tracker_history_unref0 (self->priv->history);
	self->priv->history = _tmp1_;
	return self;
}


TrackerNeedle* tracker_needle_new (void) {
	return tracker_needle_construct (TRACKER_TYPE_NEEDLE);
}


void tracker_needle_show (TrackerNeedle* self) {
	g_return_if_fail (self != NULL);
	tracker_needle_setup_ui (self);
	gtk_widget_show ((GtkWidget*) self->priv->window);
}


void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1) {
	g_return_if_fail (self != NULL);
	if (args != NULL) {
		gchar* _tmp0_;
		gchar* text;
		_tmp0_ = g_strdup ("");
		text = _tmp0_;
		{
			gchar** s_collection;
			int s_collection_length1;
			int s_it;
			s_collection = args;
			s_collection_length1 = args_length1;
			for (s_it = 0; s_it < args_length1; s_it = s_it + 1) {
				gchar* _tmp1_;
				gchar* s;
				_tmp1_ = g_strdup (s_collection[s_it]);
				s = _tmp1_;
				{
					gint _tmp2_;
					gchar* _tmp4_;
					_tmp2_ = strlen (text);
					if (_tmp2_ > 1) {
						gchar* _tmp3_;
						_tmp3_ = g_strconcat (text, " ", NULL);
						_g_free0 (text);
						text = _tmp3_;
					}
					_tmp4_ = g_strconcat (text, s, NULL);
					_g_free0 (text);
					text = _tmp4_;
					_g_free0 (s);
				}
			}
		}
		g_debug ("tracker-needle.vala:171: Setting search criteria to: '%s'\n", text);
		gtk_entry_set_text (self->priv->search, text);
		_g_free0 (text);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p) {
	TrackerResultStore* _tmp0_;
	TrackerResultStore* store;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = _g_object_ref0 (TRACKER_RESULT_STORE (object));
	store = _tmp0_;
	_tmp1_ = tracker_result_store_get_active (store);
	if (_tmp1_) {
		gtk_widget_show_all ((GtkWidget*) self->priv->spinner_shell);
		gtk_spinner_start (self->priv->spinner);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->spinner_shell);
		gtk_spinner_stop (self->priv->spinner);
	}
	_g_object_unref0 (store);
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
	gtk_main_quit ();
}


static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_window_key_press_event (self, _sender, event);
	return result;
}


static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	tracker_needle_view_toggled (self);
}


static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	tracker_needle_find_in_toggled (self);
}


static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	tracker_needle_search_changed (self, _sender);
}


static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	tracker_needle_search_activated (self, _sender);
}


static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	tracker_needle_show_tags_clicked (self);
}


static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	tracker_needle_show_stats_clicked (self);
}


static void _tracker_needle_view_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	tracker_needle_view_row_selected (self, _sender, path, column);
}


static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tracker_needle_store_state_changed (self, _sender, pspec);
}


static void _tracker_needle_icon_item_selected_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	tracker_needle_icon_item_selected (self, _sender, path);
}


static void tracker_needle_setup_ui (TrackerNeedle* self) {
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* builder;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GtkToggleToolButton* _tmp11_;
	GtkToggleToolButton* _tmp12_;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GtkToggleToolButton* _tmp15_;
	GtkToggleToolButton* _tmp16_;
	GObject* _tmp17_ = NULL;
	GObject* _tmp18_;
	GtkToggleToolButton* _tmp19_;
	GtkToggleToolButton* _tmp20_;
	GObject* _tmp21_ = NULL;
	GObject* _tmp22_;
	GtkSeparatorToolItem* _tmp23_;
	GtkSeparatorToolItem* _tmp24_;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GtkToggleToolButton* _tmp27_;
	GtkToggleToolButton* _tmp28_;
	GObject* _tmp29_ = NULL;
	GObject* _tmp30_;
	GtkToggleToolButton* _tmp31_;
	GtkToggleToolButton* _tmp32_;
	GObject* _tmp33_ = NULL;
	GObject* _tmp34_;
	GtkComboBoxEntry* _tmp35_;
	GtkComboBoxEntry* _tmp36_;
	GtkWidget* _tmp37_ = NULL;
	GtkWidget* _tmp38_;
	GtkEntry* _tmp39_;
	GtkEntry* _tmp40_;
	gint _tmp41_;
	gchar** _tmp42_ = NULL;
	gchar** _tmp43_;
	gint _tmp43__length1;
	GtkSpinner* _tmp44_ = NULL;
	GtkSpinner* _tmp45_;
	GObject* _tmp46_ = NULL;
	GObject* _tmp47_;
	GtkToolItem* _tmp48_;
	GtkToolItem* _tmp49_;
	GObject* _tmp50_ = NULL;
	GObject* _tmp51_;
	GtkToggleToolButton* _tmp52_;
	GtkToggleToolButton* _tmp53_;
	GObject* _tmp54_ = NULL;
	GObject* _tmp55_;
	GtkToolButton* _tmp56_;
	GtkToolButton* _tmp57_;
	GObject* _tmp58_ = NULL;
	GObject* _tmp59_;
	GtkHBox* _tmp60_;
	GtkHBox* _tmp61_;
	GtkTreeView* treeview;
	GtkIconView* iconview;
	TrackerViewDisplay _tmp62_;
	TrackerView* _tmp63_ = NULL;
	TrackerView* _tmp64_;
	TrackerViewDisplay _tmp65_;
	TrackerView* _tmp66_ = NULL;
	TrackerView* _tmp67_;
	GtkWidget* _tmp68_ = NULL;
	GtkTreeView* _tmp69_;
	GtkTreeView* _tmp70_;
	TrackerResultStore* _tmp71_ = NULL;
	TrackerViewDisplay _tmp72_;
	TrackerView* _tmp73_ = NULL;
	TrackerView* _tmp74_;
	GtkWidget* _tmp75_ = NULL;
	GtkTreeView* _tmp76_;
	GtkTreeView* _tmp77_;
	TrackerViewDisplay _tmp78_;
	TrackerView* _tmp79_ = NULL;
	TrackerView* _tmp80_;
	GtkWidget* _tmp81_ = NULL;
	GtkIconView* _tmp82_;
	GtkIconView* _tmp83_;
	TrackerTagList* _tmp84_ = NULL;
	TrackerTagList* _tmp85_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	gtk_builder_add_from_file (builder, SRCDIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError * e;
			GtkMessageDialog* _tmp1_ = NULL;
			GtkMessageDialog* msg;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", e->message);
			msg = g_object_ref_sink (_tmp1_);
			gtk_dialog_run ((GtkDialog*) msg);
			gtk_main_quit ();
			_g_object_unref0 (msg);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp2_, NULL);
	self->priv->size_small = _tmp2_;
	gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp3_, NULL);
	self->priv->size_medium = _tmp3_;
	gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp4_, NULL);
	self->priv->size_big = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "window_needle");
	_tmp7_ = _g_object_ref0 ((_tmp6_ = _tmp5_, GTK_IS_WINDOW (_tmp6_) ? ((GtkWindow*) _tmp6_) : NULL));
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp8_;
	g_signal_connect ((GtkObject*) self->priv->window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	g_signal_connect ((GtkWidget*) self->priv->window, "key-press-event", (GCallback) _tracker_needle_window_key_press_event_gtk_widget_key_press_event, self);
	_tmp9_ = gtk_builder_get_object (builder, "toolbutton_view_filelist");
	_tmp11_ = _g_object_ref0 ((_tmp10_ = _tmp9_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp10_) ? ((GtkToggleToolButton*) _tmp10_) : NULL));
	_tmp12_ = _tmp11_;
	_g_object_unref0 (self->priv->view_filelist);
	self->priv->view_filelist = _tmp12_;
	g_signal_connect (self->priv->view_filelist, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp13_ = gtk_builder_get_object (builder, "toolbutton_view_icons");
	_tmp15_ = _g_object_ref0 ((_tmp14_ = _tmp13_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp14_) ? ((GtkToggleToolButton*) _tmp14_) : NULL));
	_tmp16_ = _tmp15_;
	_g_object_unref0 (self->priv->view_icons);
	self->priv->view_icons = _tmp16_;
	g_signal_connect (self->priv->view_icons, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp17_ = gtk_builder_get_object (builder, "toolbutton_view_categories");
	_tmp19_ = _g_object_ref0 ((_tmp18_ = _tmp17_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp18_) ? ((GtkToggleToolButton*) _tmp18_) : NULL));
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->view_categories);
	self->priv->view_categories = _tmp20_;
	g_signal_connect (self->priv->view_categories, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp21_ = gtk_builder_get_object (builder, "separator_secondary");
	_tmp23_ = _g_object_ref0 ((_tmp22_ = _tmp21_, GTK_IS_SEPARATOR_TOOL_ITEM (_tmp22_) ? ((GtkSeparatorToolItem*) _tmp22_) : NULL));
	_tmp24_ = _tmp23_;
	_g_object_unref0 (self->priv->separator_secondary);
	self->priv->separator_secondary = _tmp24_;
	_tmp25_ = gtk_builder_get_object (builder, "toolbutton_find_in_contents");
	_tmp27_ = _g_object_ref0 ((_tmp26_ = _tmp25_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp26_) ? ((GtkToggleToolButton*) _tmp26_) : NULL));
	_tmp28_ = _tmp27_;
	_g_object_unref0 (self->priv->find_in_contents);
	self->priv->find_in_contents = _tmp28_;
	g_signal_connect (self->priv->find_in_contents, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp29_ = gtk_builder_get_object (builder, "toolbutton_find_in_titles");
	_tmp31_ = _g_object_ref0 ((_tmp30_ = _tmp29_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp30_) ? ((GtkToggleToolButton*) _tmp30_) : NULL));
	_tmp32_ = _tmp31_;
	_g_object_unref0 (self->priv->find_in_titles);
	self->priv->find_in_titles = _tmp32_;
	g_signal_connect (self->priv->find_in_titles, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp33_ = gtk_builder_get_object (builder, "comboboxentry_search");
	_tmp35_ = _g_object_ref0 ((_tmp34_ = _tmp33_, GTK_IS_COMBO_BOX_ENTRY (_tmp34_) ? ((GtkComboBoxEntry*) _tmp34_) : NULL));
	_tmp36_ = _tmp35_;
	_g_object_unref0 (self->priv->search_list);
	self->priv->search_list = _tmp36_;
	_tmp37_ = gtk_bin_get_child ((GtkBin*) self->priv->search_list);
	_tmp39_ = _g_object_ref0 ((_tmp38_ = _tmp37_, GTK_IS_ENTRY (_tmp38_) ? ((GtkEntry*) _tmp38_) : NULL));
	_tmp40_ = _tmp39_;
	_g_object_unref0 (self->priv->search);
	self->priv->search = _tmp40_;
	g_signal_connect ((GtkEditable*) self->priv->search, "changed", (GCallback) _tracker_needle_search_changed_gtk_editable_changed, self);
	g_signal_connect (self->priv->search, "activate", (GCallback) _tracker_needle_search_activated_gtk_entry_activate, self);
	_tmp42_ = tracker_history_get (self->priv->history, &_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp43__length1 = _tmp41_;
	tracker_needle_search_history_insert (self, _tmp43_, _tmp41_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = (GtkSpinner*) gtk_spinner_new ();
	_tmp45_ = g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp45_;
	_tmp46_ = gtk_builder_get_object (builder, "toolcustom_spinner");
	_tmp48_ = _g_object_ref0 ((_tmp47_ = _tmp46_, GTK_IS_TOOL_ITEM (_tmp47_) ? ((GtkToolItem*) _tmp47_) : NULL));
	_tmp49_ = _tmp48_;
	_g_object_unref0 (self->priv->spinner_shell);
	self->priv->spinner_shell = _tmp49_;
	gtk_container_add ((GtkContainer*) self->priv->spinner_shell, (GtkWidget*) self->priv->spinner);
	_tmp50_ = gtk_builder_get_object (builder, "toolbutton_show_tags");
	_tmp52_ = _g_object_ref0 ((_tmp51_ = _tmp50_, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp51_) ? ((GtkToggleToolButton*) _tmp51_) : NULL));
	_tmp53_ = _tmp52_;
	_g_object_unref0 (self->priv->show_tags);
	self->priv->show_tags = _tmp53_;
	g_signal_connect ((GtkToolButton*) self->priv->show_tags, "clicked", (GCallback) _tracker_needle_show_tags_clicked_gtk_tool_button_clicked, self);
	_tmp54_ = gtk_builder_get_object (builder, "toolbutton_show_stats");
	_tmp56_ = _g_object_ref0 ((_tmp55_ = _tmp54_, GTK_IS_TOOL_BUTTON (_tmp55_) ? ((GtkToolButton*) _tmp55_) : NULL));
	_tmp57_ = _tmp56_;
	_g_object_unref0 (self->priv->show_stats);
	self->priv->show_stats = _tmp57_;
	g_signal_connect (self->priv->show_stats, "clicked", (GCallback) _tracker_needle_show_stats_clicked_gtk_tool_button_clicked, self);
	_tmp58_ = gtk_builder_get_object (builder, "hbox_view");
	_tmp60_ = _g_object_ref0 ((_tmp59_ = _tmp58_, GTK_IS_HBOX (_tmp59_) ? ((GtkHBox*) _tmp59_) : NULL));
	_tmp61_ = _tmp60_;
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp61_;
	treeview = NULL;
	iconview = NULL;
	_tmp63_ = tracker_view_new ((_tmp62_ = TRACKER_VIEW_DISPLAY_NO_RESULTS, &_tmp62_), NULL);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->sw_noresults);
	self->priv->sw_noresults = _tmp64_;
	gtk_box_pack_start ((GtkBox*) self->priv->view, (GtkWidget*) self->priv->sw_noresults, TRUE, TRUE, (guint) 0);
	_tmp66_ = tracker_view_new ((_tmp65_ = TRACKER_VIEW_DISPLAY_CATEGORIES, &_tmp65_), self->priv->categories_model);
	_tmp67_ = g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->sw_categories);
	self->priv->sw_categories = _tmp67_;
	_tmp68_ = gtk_bin_get_child ((GtkBin*) self->priv->sw_categories);
	_tmp69_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp68_));
	_tmp70_ = _tmp69_;
	_g_object_unref0 (treeview);
	treeview = _tmp70_;
	g_signal_connect (treeview, "row-activated", (GCallback) _tracker_needle_view_row_selected_gtk_tree_view_row_activated, self);
	_tmp71_ = tracker_view_get_store (self->priv->sw_categories);
	g_signal_connect ((GObject*) _tmp71_, "notify::active", (GCallback) _tracker_needle_store_state_changed_g_object_notify, self);
	gtk_box_pack_start ((GtkBox*) self->priv->view, (GtkWidget*) self->priv->sw_categories, TRUE, TRUE, (guint) 0);
	_tmp73_ = tracker_view_new ((_tmp72_ = TRACKER_VIEW_DISPLAY_FILE_LIST, &_tmp72_), NULL);
	_tmp74_ = g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->sw_filelist);
	self->priv->sw_filelist = _tmp74_;
	_tmp75_ = gtk_bin_get_child ((GtkBin*) self->priv->sw_filelist);
	_tmp76_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp75_));
	_tmp77_ = _tmp76_;
	_g_object_unref0 (treeview);
	treeview = _tmp77_;
	g_signal_connect (treeview, "row-activated", (GCallback) _tracker_needle_view_row_selected_gtk_tree_view_row_activated, self);
	gtk_box_pack_start ((GtkBox*) self->priv->view, (GtkWidget*) self->priv->sw_filelist, TRUE, TRUE, (guint) 0);
	_tmp79_ = tracker_view_new ((_tmp78_ = TRACKER_VIEW_DISPLAY_FILE_ICONS, &_tmp78_), self->priv->images_model);
	_tmp80_ = g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->sw_icons);
	self->priv->sw_icons = _tmp80_;
	_tmp81_ = gtk_bin_get_child ((GtkBin*) self->priv->sw_icons);
	_tmp82_ = _g_object_ref0 (GTK_ICON_VIEW (_tmp81_));
	_tmp83_ = _tmp82_;
	_g_object_unref0 (iconview);
	iconview = _tmp83_;
	g_signal_connect (iconview, "item-activated", (GCallback) _tracker_needle_icon_item_selected_gtk_icon_view_item_activated, self);
	gtk_box_pack_start ((GtkBox*) self->priv->view, (GtkWidget*) self->priv->sw_icons, TRUE, TRUE, (guint) 0);
	_tmp84_ = tracker_tag_list_new ();
	_tmp85_ = g_object_ref_sink (_tmp84_);
	_g_object_unref0 (self->priv->taglist);
	self->priv->taglist = _tmp85_;
	gtk_widget_hide ((GtkWidget*) self->priv->taglist);
	gtk_box_pack_end ((GtkBox*) self->priv->view, (GtkWidget*) self->priv->taglist, FALSE, TRUE, (guint) 0);
	gtk_toggle_tool_button_set_active (self->priv->view_categories, TRUE);
	_g_object_unref0 (iconview);
	_g_object_unref0 (treeview);
	_g_object_unref0 (builder);
}


static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (((*event).state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = gdk_keyval_name ((*event).keyval);
		_tmp0_ = g_strcmp0 (_tmp1_, "w") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_object_destroy ((GtkObject*) widget);
	}
	result = FALSE;
	return result;
}


static gboolean _tracker_needle_search_run_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_needle_search_run (self);
	return result;
}


static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	if (self->priv->last_search_id != 0) {
		g_source_remove (self->priv->last_search_id);
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _tracker_needle_search_run_gsource_func, tracker_needle_ref (self), tracker_needle_unref);
	self->priv->last_search_id = _tmp0_;
}


static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	if (self->priv->last_search_id != 0) {
		g_source_remove (self->priv->last_search_id);
		self->priv->last_search_id = (guint) 0;
	}
	tracker_needle_search_run (self);
}


static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (store == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_result_store_has_results (store);
		_tmp0_ = !_tmp1_;
	}
	if (_tmp0_) {
		gtk_widget_show ((GtkWidget*) self->priv->sw_noresults);
		gtk_widget_hide ((GtkWidget*) self->priv->sw_icons);
		gtk_widget_hide ((GtkWidget*) self->priv->sw_categories);
		gtk_widget_hide ((GtkWidget*) self->priv->sw_filelist);
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model) {
	GtkTreeIter* result = NULL;
	gint _tmp0_;
	GtkComboBoxEntry* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* combo;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	gchar* _tmp5_ = NULL;
	gchar* criteria_folded;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	gboolean valid;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (criteria != NULL, NULL);
	_tmp0_ = strlen (criteria);
	if (_tmp0_ < 1) {
		result = NULL;
		return result;
	}
	_tmp2_ = _g_object_ref0 ((_tmp1_ = self->priv->search_list, GTK_IS_COMBO_BOX (_tmp1_) ? ((GtkComboBox*) _tmp1_) : NULL));
	combo = _tmp2_;
	_tmp3_ = gtk_combo_box_get_model (combo);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	_tmp5_ = g_utf8_casefold (criteria, (gssize) (-1));
	criteria_folded = _tmp5_;
	_tmp7_ = gtk_tree_model_iter_children (model, &_tmp6_, NULL);
	iter = _tmp6_;
	valid = _tmp7_;
	while (TRUE) {
		gchar* text;
		gchar* _tmp8_ = NULL;
		gchar* text_folded;
		gboolean _tmp10_;
		if (!valid) {
			break;
		}
		text = NULL;
		gtk_tree_model_get (model, &iter, 0, &text, -1, -1);
		_tmp8_ = g_utf8_casefold (text, (gssize) (-1));
		text_folded = _tmp8_;
		if (g_strcmp0 (text_folded, criteria_folded) == 0) {
			GtkTreeIter* _tmp9_;
			_tmp9_ = __gtk_tree_iter_dup0 (&iter);
			result = _tmp9_;
			_g_free0 (text_folded);
			_g_free0 (text);
			_g_free0 (criteria_folded);
			_g_object_unref0 (model);
			_g_object_unref0 (combo);
			return result;
		}
		_tmp10_ = gtk_tree_model_iter_next (model, &iter);
		valid = _tmp10_;
		_g_free0 (text_folded);
		_g_free0 (text);
	}
	if (*add_to_model) {
		GtkTreeIter new_iter = {0};
		GtkListStore* _tmp11_;
		GtkListStore* store;
		GtkTreeIter _tmp12_ = {0};
		_tmp11_ = _g_object_ref0 (GTK_LIST_STORE (model));
		store = _tmp11_;
		gtk_list_store_prepend (store, &_tmp12_);
		new_iter = _tmp12_;
		gtk_list_store_set (store, &new_iter, 0, criteria, -1, -1);
		tracker_history_add (self->priv->history, criteria);
		_g_object_unref0 (store);
	}
	result = NULL;
	_g_free0 (criteria_folded);
	_g_object_unref0 (model);
	_g_object_unref0 (combo);
	return result;
}


static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1) {
	g_return_if_fail (self != NULL);
	{
		gchar** criteria_collection;
		int criteria_collection_length1;
		int criteria_it;
		criteria_collection = history;
		criteria_collection_length1 = history_length1;
		for (criteria_it = 0; criteria_it < history_length1; criteria_it = criteria_it + 1) {
			gchar* _tmp0_;
			gchar* criteria;
			_tmp0_ = g_strdup (criteria_collection[criteria_it]);
			criteria = _tmp0_;
			{
				gboolean _tmp1_;
				GtkTreeIter* _tmp2_ = NULL;
				GtkTreeIter* _tmp3_;
				_tmp2_ = tracker_needle_search_history_find_or_insert (self, criteria, (_tmp1_ = TRUE, &_tmp1_));
				_tmp3_ = _tmp2_;
				_g_free0 (_tmp3_);
				_g_free0 (criteria);
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean tracker_needle_search_run (TrackerNeedle* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	gchar* _tmp2_ = NULL;
	gchar* criteria;
	TrackerResultStore* store;
	gint _tmp3_;
	gboolean _tmp4_;
	GtkTreeIter* _tmp5_ = NULL;
	GtkTreeIter* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->last_search_id = (guint) 0;
	_tmp0_ = gtk_entry_get_text (self->priv->search);
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = string_strip (str);
	criteria = _tmp2_;
	store = NULL;
	_tmp3_ = strlen (criteria);
	if (_tmp3_ < 3) {
		tracker_needle_search_finished (self, store);
		result = FALSE;
		_g_object_unref0 (store);
		_g_free0 (criteria);
		_g_free0 (str);
		return result;
	}
	_tmp5_ = tracker_needle_search_history_find_or_insert (self, criteria, (_tmp4_ = TRUE, &_tmp4_));
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp6_);
	gtk_widget_hide ((GtkWidget*) self->priv->sw_noresults);
	_tmp7_ = gtk_toggle_tool_button_get_active (self->priv->view_icons);
	if (_tmp7_) {
		TrackerResultStore* _tmp8_;
		TrackerResultStore* _tmp9_;
		gtk_widget_show ((GtkWidget*) self->priv->sw_icons);
		_tmp8_ = _g_object_ref0 (self->priv->images_model);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (store);
		store = _tmp9_;
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->sw_icons);
	}
	_tmp10_ = gtk_toggle_tool_button_get_active (self->priv->view_categories);
	if (_tmp10_) {
		TrackerResultStore* _tmp11_;
		TrackerResultStore* _tmp12_;
		gtk_widget_show ((GtkWidget*) self->priv->sw_categories);
		_tmp11_ = _g_object_ref0 (self->priv->categories_model);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (store);
		store = _tmp12_;
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->sw_categories);
	}
	_tmp13_ = gtk_toggle_tool_button_get_active (self->priv->view_filelist);
	if (_tmp13_) {
		gboolean _tmp14_;
		gtk_widget_show ((GtkWidget*) self->priv->sw_filelist);
		_tmp14_ = gtk_toggle_tool_button_get_active (self->priv->find_in_contents);
		if (_tmp14_) {
			TrackerResultStore* _tmp15_;
			TrackerResultStore* _tmp16_;
			_tmp15_ = _g_object_ref0 (self->priv->files_model);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (store);
			store = _tmp16_;
		} else {
			TrackerResultStore* _tmp17_;
			TrackerResultStore* _tmp18_;
			_tmp17_ = _g_object_ref0 (self->priv->files_in_title_model);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (store);
			store = _tmp18_;
		}
		tracker_view_set_store (self->priv->sw_filelist, store);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->sw_filelist);
	}
	if (store != NULL) {
		const gchar* _tmp19_ = NULL;
		_tmp19_ = gtk_entry_get_text (self->priv->search);
		tracker_result_store_set_search_term (store, _tmp19_);
	}
	result = FALSE;
	_g_object_unref0 (store);
	_g_free0 (criteria);
	_g_free0 (str);
	return result;
}


static void tracker_needle_view_toggled (TrackerNeedle* self) {
	gboolean show_find_in = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp2_ = gtk_toggle_tool_button_get_active (self->priv->view_icons);
	if (!_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = gtk_toggle_tool_button_get_active (self->priv->view_filelist);
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_;
		_tmp4_ = gtk_toggle_tool_button_get_active (self->priv->view_categories);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = gtk_toggle_tool_button_get_active (self->priv->view_filelist);
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_;
		_tmp7_ = gtk_toggle_tool_button_get_active (self->priv->view_icons);
		_tmp5_ = _tmp7_;
	}
	show_find_in = _tmp5_;
	gtk_widget_show ((GtkWidget*) self->priv->sw_noresults);
	gtk_widget_hide ((GtkWidget*) self->priv->sw_icons);
	gtk_widget_hide ((GtkWidget*) self->priv->sw_filelist);
	gtk_widget_hide ((GtkWidget*) self->priv->sw_categories);
	gtk_widget_set_visible ((GtkWidget*) self->priv->separator_secondary, show_find_in);
	gtk_widget_set_visible ((GtkWidget*) self->priv->find_in_contents, show_find_in);
	gtk_widget_set_visible ((GtkWidget*) self->priv->find_in_titles, show_find_in);
	tracker_needle_search_run (self);
}


static void tracker_needle_find_in_toggled (TrackerNeedle* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_toggle_tool_button_get_active (self->priv->find_in_contents);
	if (tracker_needle_current_find_in == _tmp0_) {
		return;
	}
	_tmp1_ = gtk_toggle_tool_button_get_active (self->priv->find_in_contents);
	if (_tmp1_) {
		g_debug ("tracker-needle.vala:451: Find in toggled to 'contents'");
		tracker_needle_search_run (self);
	} else {
		g_debug ("tracker-needle.vala:454: Find in toggled to 'titles'");
		tracker_needle_search_run (self);
	}
	_tmp2_ = gtk_toggle_tool_button_get_active (self->priv->find_in_contents);
	tracker_needle_current_find_in = _tmp2_;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void tracker_needle_launch_selected (TrackerNeedle* self, GtkTreeModel* model, GtkTreePath* path, gint col) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	const gchar* uri;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	gtk_tree_model_get_iter (model, &_tmp0_, path);
	iter = _tmp0_;
	uri = NULL;
	gtk_tree_model_get (model, &iter, col, &uri, -1);
	if (uri == NULL) {
		return;
	}
	g_debug ("tracker-needle.vala:472: Selected uri:'%s'", uri);
	_tmp1_ = string_index_of (uri, "://", 0);
	if (_tmp1_ < 1) {
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gint command_length1;
		gint _command_size_;
		gchar** _tmp4_;
		gchar** command;
		GPid child_pid = 0;
		gchar** _tmp5_ = NULL;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp6_;
		gchar** argv;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GPid _tmp9_;
		_tmp3_ = _tmp2_ = g_strsplit (uri, " ", 0);
		_tmp4_ = _tmp3_;
		command_length1 = _vala_array_length (_tmp2_);
		_command_size_ = command_length1;
		command = _tmp4_;
		g_debug ("tracker-needle.vala:478: Attempting to spawn_async() '%s'", command[0]);
		_tmp5_ = g_new0 (gchar*, 1 + 1);
		_tmp6_ = _tmp5_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
		argv = _tmp6_;
		_tmp7_ = g_strdup (command[0]);
		_tmp8_ = _tmp7_;
		_g_free0 (argv[0]);
		argv[0] = _tmp8_;
		g_spawn_async ("/usr/bin", argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_inner_error_);
		child_pid = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		goto __finally21;
		__catch21_g_error:
		{
			GError * e;
			const gchar* _tmp10_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = g_strerror (e->code);
			g_warning ("tracker-needle.vala:492: Could not launch '%s', %d->%s", command[0], e->code, _tmp10_);
			_g_error_free0 (e);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		__finally21:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_debug ("tracker-needle.vala:496: Launched application with PID:%d", (gint) child_pid);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	g_debug ("tracker-needle.vala:501: Attempting to launch application for uri:'%s'", uri);
	g_app_info_launch_default_for_uri (uri, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = g_strconcat ("Could not launch application: ", e->message, NULL);
		g_warning ("tracker-needle.vala:504: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = gtk_tree_view_get_model (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	tracker_needle_launch_selected (self, model, path, 1);
	_g_object_unref0 (model);
}


static void tracker_needle_icon_item_selected (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gtk_icon_view_get_model (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	tracker_needle_launch_selected (self, model, path, 1);
	_g_object_unref0 (model);
}


static void tracker_needle_show_tags_clicked (TrackerNeedle* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_toggle_tool_button_get_active (self->priv->show_tags);
	if (_tmp0_) {
		g_debug ("tracker-needle.vala:520: Showing tags");
		gtk_widget_show ((GtkWidget*) self->priv->taglist);
	} else {
		g_debug ("tracker-needle.vala:523: Hiding tags");
		gtk_widget_hide ((GtkWidget*) self->priv->taglist);
	}
}


static void tracker_needle_show_stats_clicked (TrackerNeedle* self) {
	TrackerStats* _tmp0_ = NULL;
	TrackerStats* s;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-needle.vala:529: Showing stats dialog");
	_tmp0_ = tracker_stats_new ();
	s = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) s);
	_g_object_unref0 (s);
}


static void tracker_value_needle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_needle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_needle_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_needle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_needle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_needle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_needle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerNeedle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_needle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_needle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerNeedle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_needle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecNeedle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_NEEDLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_needle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_needle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_needle_unref (old);
	}
}


void tracker_value_take_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_needle_unref (old);
	}
}


static void tracker_needle_class_init (TrackerNeedleClass * klass) {
	tracker_needle_parent_class = g_type_class_peek_parent (klass);
	TRACKER_NEEDLE_CLASS (klass)->finalize = tracker_needle_finalize;
	g_type_class_add_private (klass, sizeof (TrackerNeedlePrivate));
}


static void tracker_needle_instance_init (TrackerNeedle * self) {
	self->priv = TRACKER_NEEDLE_GET_PRIVATE (self);
	self->priv->last_search_id = (guint) 0;
	self->priv->size_small = 0;
	self->priv->size_medium = 0;
	self->priv->size_big = 0;
	self->ref_count = 1;
}


static void tracker_needle_finalize (TrackerNeedle* obj) {
	TrackerNeedle * self;
	self = TRACKER_NEEDLE (obj);
	_tracker_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view_categories);
	_g_object_unref0 (self->priv->view_filelist);
	_g_object_unref0 (self->priv->view_icons);
	_g_object_unref0 (self->priv->separator_secondary);
	_g_object_unref0 (self->priv->find_in_contents);
	_g_object_unref0 (self->priv->find_in_titles);
	_g_object_unref0 (self->priv->search_list);
	_g_object_unref0 (self->priv->search);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->spinner_shell);
	_g_object_unref0 (self->priv->show_tags);
	_g_object_unref0 (self->priv->show_stats);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->sw_noresults);
	_g_object_unref0 (self->priv->sw_categories);
	_g_object_unref0 (self->priv->sw_filelist);
	_g_object_unref0 (self->priv->sw_icons);
	_g_object_unref0 (self->priv->taglist);
	_g_object_unref0 (self->priv->categories_model);
	_g_object_unref0 (self->priv->files_model);
	_g_object_unref0 (self->priv->files_in_title_model);
	_g_object_unref0 (self->priv->images_model);
}


GType tracker_needle_get_type (void) {
	static volatile gsize tracker_needle_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_needle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_needle_init, tracker_value_needle_free_value, tracker_value_needle_copy_value, tracker_value_needle_peek_pointer, "p", tracker_value_needle_collect_value, "p", tracker_value_needle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerNeedleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_needle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerNeedle), 0, (GInstanceInitFunc) tracker_needle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_needle_type_id;
		tracker_needle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerNeedle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_needle_type_id__volatile, tracker_needle_type_id);
	}
	return tracker_needle_type_id__volatile;
}


gpointer tracker_needle_ref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_needle_unref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_NEEDLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp2_ = NULL;
	TrackerNeedle* _tmp18_ = NULL;
	TrackerNeedle* n;
	GError * _inner_error_ = NULL;
	_tmp0_ = _ ("Desktop Search user interface using Tracker");
	_tmp1_ = g_option_context_new (_tmp0_);
	context = _tmp1_;
	g_option_context_set_help_enabled (context, TRUE);
	g_option_context_add_main_entries (context, options, NULL);
	_tmp2_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (context, _tmp2_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch23_g_error;
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_strconcat (e->message, "\n\n", NULL);
		g_printerr ("%s", _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp5_ = _tmp4_;
		g_printerr ("%s", _tmp5_);
		_g_free0 (_tmp5_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (print_version) {
		gchar* _tmp6_;
		gchar* about;
		gchar* _tmp7_;
		gchar* license;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp6_ = g_strdup ("");
		about = _tmp6_;
		_tmp7_ = g_strdup ("");
		license = _tmp7_;
		_tmp8_ = g_strconcat (about, "Tracker " PACKAGE_VERSION "\n", NULL);
		_g_free0 (about);
		about = _tmp8_;
		_tmp9_ = g_strconcat (license, "This program is free software and comes without any warranty.\n", NULL);
		_g_free0 (license);
		license = _tmp9_;
		_tmp10_ = g_strconcat (license, "It is licensed under version 2 or later of the General Public ", NULL);
		_g_free0 (license);
		license = _tmp10_;
		_tmp11_ = g_strconcat (license, "License which can be viewed at:\n", NULL);
		_g_free0 (license);
		license = _tmp11_;
		_tmp12_ = g_strconcat (license, "\n", NULL);
		_g_free0 (license);
		license = _tmp12_;
		_tmp13_ = g_strconcat (license, "  http://www.gnu.org/licenses/gpl.txt\n", NULL);
		_g_free0 (license);
		license = _tmp13_;
		_tmp14_ = g_strconcat ("\n", about, NULL);
		_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
		_tmp16_ = g_strconcat (_tmp15_, license, NULL);
		_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
		g_print ("%s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp14_);
		result = 0;
		_g_free0 (license);
		_g_free0 (about);
		_g_option_context_free0 (context);
		return result;
	}
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp18_ = tracker_needle_new ();
	n = _tmp18_;
	tracker_needle_show (n);
	tracker_needle_set_search (n, search_criteria, _vala_array_length (search_criteria));
	gtk_main ();
	result = 0;
	_tracker_needle_unref0 (n);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



