/* tracker-explorer.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-explorer.vala, do not modify */

/**/
/* Copyright 2009, Rob Taylor <rob.taylor@codethink.co.uk>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;

#define TYPE_RESOURCES_PROXY (resources_proxy_get_type ())
typedef GDBusProxy ResourcesProxy;
typedef GDBusProxyClass ResourcesProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HISTORY_ITEM (history_item_get_type ())
#define HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ITEM, HistoryItem))
#define HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ITEM, HistoryItemClass))
#define IS_HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ITEM))
#define IS_HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ITEM))
#define HISTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ITEM, HistoryItemClass))

typedef struct _HistoryItem HistoryItem;
typedef struct _HistoryItemClass HistoryItemClass;
typedef struct _HistoryItemPrivate HistoryItemPrivate;
#define _history_item_unref0(var) ((var == NULL) ? NULL : (var = (history_item_unref (var), NULL)))
typedef struct _ParamSpecHistoryItem ParamSpecHistoryItem;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _ParamSpecHistory ParamSpecHistory;

#define TYPE_EXPLORER (explorer_get_type ())
#define EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPLORER, Explorer))
#define EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPLORER, ExplorerClass))
#define IS_EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPLORER))
#define IS_EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPLORER))
#define EXPLORER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPLORER, ExplorerClass))

typedef struct _Explorer Explorer;
typedef struct _ExplorerClass ExplorerClass;
typedef struct _ExplorerPrivate ExplorerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecExplorer ParamSpecExplorer;
#define _explorer_unref0(var) ((var == NULL) ? NULL : (var = (explorer_unref (var), NULL)))

struct _ResourcesIface {
	GTypeInterface parent_iface;
	gchar** (*SparqlQuery) (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
};

struct _HistoryItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryItemPrivate * priv;
	gchar* uri;
	HistoryItem* next;
	HistoryItem* prev;
};

struct _HistoryItemClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryItem *self);
};

struct _ParamSpecHistoryItem {
	GParamSpec parent_instance;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	HistoryItem* items;
	HistoryItem* current;
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

struct _Explorer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExplorerPrivate * priv;
};

struct _ExplorerClass {
	GTypeClass parent_class;
	void (*finalize) (Explorer *self);
};

struct _ExplorerPrivate {
	Resources* tracker;
	History* history;
	GtkListStore* uris;
	GtkListStore* relationships;
	GtkLabel* current_uri_label;
	GeeHashMap* namespaces;
	GtkNotebook* types;
	GtkButton* forward;
	GtkButton* back;
};

struct _ParamSpecExplorer {
	GParamSpec parent_instance;
};


static gpointer history_item_parent_class = NULL;
static gpointer history_parent_class = NULL;
static gpointer explorer_parent_class = NULL;

GType resources_proxy_get_type (void) G_GNUC_CONST;
guint resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType resources_get_type (void) G_GNUC_CONST;
gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** resources_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void resources_proxy_resources_interface_init (ResourcesIface* iface);
static void _dbus_resources_SparqlQuery (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _resources_unregister_object (gpointer user_data);
gpointer history_item_ref (gpointer instance);
void history_item_unref (gpointer instance);
GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_item (GValue* value, gpointer v_object);
void value_take_history_item (GValue* value, gpointer v_object);
gpointer value_get_history_item (const GValue* value);
GType history_item_get_type (void) G_GNUC_CONST;
enum  {
	HISTORY_ITEM_DUMMY_PROPERTY
};
HistoryItem* history_item_new (const gchar* uri);
HistoryItem* history_item_construct (GType object_type, const gchar* uri);
static void history_item_finalize (HistoryItem* obj);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
gchar* history_current_uri (History* self);
gboolean history_can_go_forward (History* self);
gboolean history_can_go_back (History* self);
gboolean history_forward (History* self);
gboolean history_back (History* self);
void history_add (History* self, const gchar* uri);
History* history_new (void);
History* history_construct (GType object_type);
static void history_finalize (History* obj);
gpointer explorer_ref (gpointer instance);
void explorer_unref (gpointer instance);
GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_explorer (GValue* value, gpointer v_object);
void value_take_explorer (GValue* value, gpointer v_object);
gpointer value_get_explorer (const GValue* value);
GType explorer_get_type (void) G_GNUC_CONST;
#define EXPLORER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPLORER, ExplorerPrivate))
enum  {
	EXPLORER_DUMMY_PROPERTY
};
#define EXPLORER_UI_FILE "tracker-explorer.ui"
void explorer_show (Explorer* self);
static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void explorer_entry_changed (Explorer* self, GtkEditable* editable);
static void _explorer_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview);
static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview);
static void explorer_update_types_page (Explorer* self, GtkWidget* w);
static void _explorer_update_types_page_gtk_container_set_focus_child (GtkContainer* _sender, GtkWidget* child, gpointer self);
static void explorer_forward_clicked (Explorer* self);
static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_back_clicked (Explorer* self);
static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_fetch_prefixes (Explorer* self);
static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static GtkTreeView* explorer_setup_reverserelationships (Explorer* self);
static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri);
static void explorer_clear_types (Explorer* self);
static void explorer_add_type (Explorer* self, const gchar* type);
static void explorer_set_current_uri (Explorer* self, const gchar* uri);
static void explorer_update_pane (Explorer* self);
Explorer* explorer_new (void);
Explorer* explorer_construct (GType object_type);
static void explorer_finalize (Explorer* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _resources_dbus_arg_info_SparqlQuery_query = {-1, "query", "s"};
static const GDBusArgInfo _resources_dbus_arg_info_SparqlQuery_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _resources_dbus_arg_info_SparqlQuery_in[] = {&_resources_dbus_arg_info_SparqlQuery_query, NULL};
static const GDBusArgInfo * const _resources_dbus_arg_info_SparqlQuery_out[] = {&_resources_dbus_arg_info_SparqlQuery_result, NULL};
static const GDBusMethodInfo _resources_dbus_method_info_SparqlQuery = {-1, "SparqlQuery", (GDBusArgInfo **) (&_resources_dbus_arg_info_SparqlQuery_in), (GDBusArgInfo **) (&_resources_dbus_arg_info_SparqlQuery_out)};
static const GDBusMethodInfo * const _resources_dbus_method_info[] = {&_resources_dbus_method_info_SparqlQuery, NULL};
static const GDBusSignalInfo * const _resources_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_resources_dbus_method_info), (GDBusSignalInfo **) (&_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_resources_dbus_property_info)};
static const GDBusInterfaceVTable _resources_dbus_interface_vtable = {resources_dbus_interface_method_call, resources_dbus_interface_get_property, resources_dbus_interface_set_property};

gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
#line 30 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return RESOURCES_GET_INTERFACE (self)->SparqlQuery (self, query, result_length1, result_length2, error);
#line 265 "tracker-explorer.c"
}


static void resources_base_init (ResourcesIface * iface) {
#line 29 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	static gboolean initialized = FALSE;
#line 29 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!initialized) {
#line 29 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		initialized = TRUE;
#line 276 "tracker-explorer.c"
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_DBUS_PROXY);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) resources_proxy_get_type);
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Tracker1.Resources");
		g_type_set_qdata (resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) resources_register_object);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesProxy, resources_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_proxy_resources_interface_init) )
static void resources_proxy_class_init (ResourcesProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = resources_proxy_g_signal;
}


static void resources_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void resources_proxy_init (ResourcesProxy* self) {
}


static gchar** resources_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		int _tmp1__length2;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		_tmp1__length2 = 0;
		g_variant_iter_init (&_tmp4_, _tmp3_);
		for (; (_tmp5_ = g_variant_iter_next_value (&_tmp4_)) != NULL; _tmp1__length2++) {
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp5_, NULL);
			g_variant_unref (_tmp5_);
		}
		_result_length2 = _tmp1__length2;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	g_object_unref (_reply_message);
	return _result;
}


static void resources_proxy_resources_interface_init (ResourcesIface* iface) {
	iface->SparqlQuery = resources_proxy_SparqlQuery;
}


static void _dbus_resources_SparqlQuery (Resources* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	int result_length2 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	result = resources_SparqlQuery (self, query, &result_length1, &result_length2, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("aas"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		GVariantBuilder _tmp10_;
		int _tmp11_;
		g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("aas"));
		for (_tmp11_ = 0; _tmp11_ < result_length2; _tmp11_++) {
			g_variant_builder_add_value (&_tmp10_, g_variant_new_string (*_tmp7_));
			_tmp7_++;
		}
		g_variant_builder_add_value (&_tmp8_, g_variant_builder_end (&_tmp10_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result, result_length1 * result_length2, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_resources_SparqlQuery (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_resources_dbus_interface_info), &_resources_dbus_interface_vtable, data, _resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


HistoryItem* history_item_construct (GType object_type, const gchar* uri) {
	HistoryItem* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 34 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = (HistoryItem*) g_type_create_instance (object_type);
#line 35 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = uri;
#line 35 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 35 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (self->uri);
#line 35 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->uri = _tmp1_;
#line 34 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return self;
#line 507 "tracker-explorer.c"
}


HistoryItem* history_item_new (const gchar* uri) {
#line 34 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return history_item_construct (TYPE_HISTORY_ITEM, uri);
#line 514 "tracker-explorer.c"
}


static void value_history_item_init (GValue* value) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	value->data[0].v_pointer = NULL;
#line 521 "tracker-explorer.c"
}


static void value_history_item_free_value (GValue* value) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (value->data[0].v_pointer) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_item_unref (value->data[0].v_pointer);
#line 530 "tracker-explorer.c"
	}
}


static void value_history_item_copy_value (const GValue* src_value, GValue* dest_value) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (src_value->data[0].v_pointer) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = history_item_ref (src_value->data[0].v_pointer);
#line 540 "tracker-explorer.c"
	} else {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 544 "tracker-explorer.c"
	}
}


static gpointer value_history_item_peek_pointer (const GValue* value) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 552 "tracker-explorer.c"
}


static gchar* value_history_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (collect_values[0].v_pointer) {
#line 559 "tracker-explorer.c"
		HistoryItem* object;
		object = collect_values[0].v_pointer;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 566 "tracker-explorer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 570 "tracker-explorer.c"
		}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = history_item_ref (object);
#line 574 "tracker-explorer.c"
	} else {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 578 "tracker-explorer.c"
	}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 582 "tracker-explorer.c"
}


static gchar* value_history_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HistoryItem** object_p;
	object_p = collect_values[0].v_pointer;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!object_p) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 593 "tracker-explorer.c"
	}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!value->data[0].v_pointer) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = NULL;
#line 599 "tracker-explorer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = value->data[0].v_pointer;
#line 603 "tracker-explorer.c"
	} else {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = history_item_ref (value->data[0].v_pointer);
#line 607 "tracker-explorer.c"
	}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 611 "tracker-explorer.c"
}


GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistoryItem* spec;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY_ITEM), NULL);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return G_PARAM_SPEC (spec);
#line 625 "tracker-explorer.c"
}


gpointer value_get_history_item (const GValue* value) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM), NULL);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 634 "tracker-explorer.c"
}


void value_set_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_item_ref (value->data[0].v_pointer);
#line 654 "tracker-explorer.c"
	} else {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 658 "tracker-explorer.c"
	}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_item_unref (old);
#line 664 "tracker-explorer.c"
	}
}


void value_take_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 683 "tracker-explorer.c"
	} else {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 687 "tracker-explorer.c"
	}
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_item_unref (old);
#line 693 "tracker-explorer.c"
	}
}


static void history_item_class_init (HistoryItemClass * klass) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	history_item_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	HISTORY_ITEM_CLASS (klass)->finalize = history_item_finalize;
#line 703 "tracker-explorer.c"
}


static void history_item_instance_init (HistoryItem * self) {
#line 38 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->next = NULL;
#line 39 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->prev = NULL;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->ref_count = 1;
#line 714 "tracker-explorer.c"
}


static void history_item_finalize (HistoryItem* obj) {
	HistoryItem * self;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = HISTORY_ITEM (obj);
#line 37 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (self->uri);
#line 38 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (self->next);
#line 39 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (self->prev);
#line 728 "tracker-explorer.c"
}


GType history_item_get_type (void) {
	static volatile gsize history_item_type_id__volatile = 0;
	if (g_once_init_enter (&history_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_item_init, value_history_item_free_value, value_history_item_copy_value, value_history_item_peek_pointer, "p", value_history_item_collect_value, "p", value_history_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryItem), 0, (GInstanceInitFunc) history_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_item_type_id;
		history_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_item_type_id__volatile, history_item_type_id);
	}
	return history_item_type_id__volatile;
}


gpointer history_item_ref (gpointer instance) {
	HistoryItem* self;
	self = instance;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return instance;
#line 753 "tracker-explorer.c"
}


void history_item_unref (gpointer instance) {
	HistoryItem* self;
	self = instance;
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		HISTORY_ITEM_GET_CLASS (self)->finalize (self);
#line 33 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 766 "tracker-explorer.c"
	}
}


gchar* history_current_uri (History* self) {
	gchar* result = NULL;
	HistoryItem* _tmp0_;
#line 46 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->current;
#line 47 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp0_ != NULL) {
#line 780 "tracker-explorer.c"
		HistoryItem* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 48 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp1_ = self->priv->current;
#line 48 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = _tmp1_->uri;
#line 48 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 48 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		result = _tmp3_;
#line 48 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return result;
#line 794 "tracker-explorer.c"
	} else {
#line 50 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		result = NULL;
#line 50 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return result;
#line 800 "tracker-explorer.c"
	}
}


gboolean history_can_go_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	HistoryItem* _tmp1_;
	gboolean _tmp4_;
#line 54 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = self->priv->current;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp1_ != NULL) {
#line 816 "tracker-explorer.c"
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = self->priv->current;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = _tmp2_->next;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 825 "tracker-explorer.c"
	} else {
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp0_ = FALSE;
#line 829 "tracker-explorer.c"
	}
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = _tmp0_;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = _tmp4_;
#line 55 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 837 "tracker-explorer.c"
}


gboolean history_can_go_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	HistoryItem* _tmp1_;
	gboolean _tmp4_;
#line 58 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = self->priv->current;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp1_ != NULL) {
#line 852 "tracker-explorer.c"
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = self->priv->current;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = _tmp2_->prev;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 861 "tracker-explorer.c"
	} else {
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp0_ = FALSE;
#line 865 "tracker-explorer.c"
	}
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = _tmp0_;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = _tmp4_;
#line 59 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 873 "tracker-explorer.c"
}


static gpointer _history_item_ref0 (gpointer self) {
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return self ? history_item_ref (self) : NULL;
#line 880 "tracker-explorer.c"
}


gboolean history_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 62 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 63 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = history_can_go_forward (self);
#line 63 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp0_) {
#line 893 "tracker-explorer.c"
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp1_ = self->priv->current;
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = _tmp1_->next;
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = _history_item_ref0 (_tmp2_);
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (self->priv->current);
#line 64 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		self->priv->current = _tmp3_;
#line 65 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		result = TRUE;
#line 65 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return result;
#line 911 "tracker-explorer.c"
	}
#line 67 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = FALSE;
#line 67 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 917 "tracker-explorer.c"
}


gboolean history_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 70 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 71 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = history_can_go_back (self);
#line 71 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp0_) {
#line 930 "tracker-explorer.c"
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
#line 72 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp1_ = self->priv->current;
#line 72 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = _tmp1_->prev;
#line 72 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = _history_item_ref0 (_tmp2_);
#line 72 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (self->priv->current);
#line 72 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		self->priv->current = _tmp3_;
#line 73 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		result = TRUE;
#line 73 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return result;
#line 948 "tracker-explorer.c"
	}
#line 75 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = FALSE;
#line 75 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 954 "tracker-explorer.c"
}


void history_add (History* self, const gchar* uri) {
	const gchar* _tmp0_;
	HistoryItem* _tmp1_;
	HistoryItem* hi;
	HistoryItem* _tmp2_;
	HistoryItem* _tmp13_;
	HistoryItem* _tmp14_;
#line 78 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (uri != NULL);
#line 79 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = uri;
#line 79 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = history_item_new (_tmp0_);
#line 79 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	hi = _tmp1_;
#line 80 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = self->priv->current;
#line 80 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp2_ == NULL) {
#line 979 "tracker-explorer.c"
		HistoryItem* _tmp3_;
		HistoryItem* _tmp4_;
		HistoryItem* _tmp5_;
		HistoryItem* _tmp6_;
#line 81 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = hi;
#line 81 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp4_ = _history_item_ref0 (_tmp3_);
#line 81 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (self->priv->items);
#line 81 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		self->priv->items = _tmp4_;
#line 82 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp5_ = self->priv->items;
#line 82 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp6_ = _history_item_ref0 (_tmp5_);
#line 82 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (self->priv->current);
#line 82 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		self->priv->current = _tmp6_;
#line 1000 "tracker-explorer.c"
	} else {
		HistoryItem* _tmp7_;
		HistoryItem* _tmp8_;
		HistoryItem* _tmp9_;
		HistoryItem* _tmp10_;
		HistoryItem* _tmp11_;
		HistoryItem* _tmp12_;
#line 84 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp7_ = self->priv->current;
#line 84 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp8_ = hi;
#line 84 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp9_ = _history_item_ref0 (_tmp8_);
#line 84 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (_tmp7_->next);
#line 84 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp7_->next = _tmp9_;
#line 85 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp10_ = hi;
#line 85 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp11_ = self->priv->current;
#line 85 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp12_ = _history_item_ref0 (_tmp11_);
#line 85 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_history_item_unref0 (_tmp10_->prev);
#line 85 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp10_->prev = _tmp12_;
#line 1028 "tracker-explorer.c"
	}
#line 87 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp13_ = hi;
#line 87 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp14_ = _history_item_ref0 (_tmp13_);
#line 87 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (self->priv->current);
#line 87 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->current = _tmp14_;
#line 78 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (hi);
#line 1040 "tracker-explorer.c"
}


History* history_construct (GType object_type) {
	History* self = NULL;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = (History*) g_type_create_instance (object_type);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return self;
#line 1050 "tracker-explorer.c"
}


History* history_new (void) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return history_construct (TYPE_HISTORY);
#line 1057 "tracker-explorer.c"
}


static void value_history_init (GValue* value) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	value->data[0].v_pointer = NULL;
#line 1064 "tracker-explorer.c"
}


static void value_history_free_value (GValue* value) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (value->data[0].v_pointer) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_unref (value->data[0].v_pointer);
#line 1073 "tracker-explorer.c"
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (src_value->data[0].v_pointer) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
#line 1083 "tracker-explorer.c"
	} else {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1087 "tracker-explorer.c"
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 1095 "tracker-explorer.c"
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (collect_values[0].v_pointer) {
#line 1102 "tracker-explorer.c"
		History* object;
		object = collect_values[0].v_pointer;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1109 "tracker-explorer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1113 "tracker-explorer.c"
		}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = history_ref (object);
#line 1117 "tracker-explorer.c"
	} else {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 1121 "tracker-explorer.c"
	}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 1125 "tracker-explorer.c"
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!object_p) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1136 "tracker-explorer.c"
	}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!value->data[0].v_pointer) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = NULL;
#line 1142 "tracker-explorer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = value->data[0].v_pointer;
#line 1146 "tracker-explorer.c"
	} else {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = history_ref (value->data[0].v_pointer);
#line 1150 "tracker-explorer.c"
	}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 1154 "tracker-explorer.c"
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return G_PARAM_SPEC (spec);
#line 1168 "tracker-explorer.c"
}


gpointer value_get_history (const GValue* value) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 1177 "tracker-explorer.c"
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_ref (value->data[0].v_pointer);
#line 1197 "tracker-explorer.c"
	} else {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 1201 "tracker-explorer.c"
	}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_unref (old);
#line 1207 "tracker-explorer.c"
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 1226 "tracker-explorer.c"
	} else {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 1230 "tracker-explorer.c"
	}
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		history_unref (old);
#line 1236 "tracker-explorer.c"
	}
}


static void history_class_init (HistoryClass * klass) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	history_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	HISTORY_CLASS (klass)->finalize = history_finalize;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
#line 1248 "tracker-explorer.c"
}


static void history_instance_init (History * self) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv = HISTORY_GET_PRIVATE (self);
#line 43 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->items = NULL;
#line 44 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->current = NULL;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->ref_count = 1;
#line 1261 "tracker-explorer.c"
}


static void history_finalize (History* obj) {
	History * self;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = HISTORY (obj);
#line 43 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (self->priv->items);
#line 44 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_item_unref0 (self->priv->current);
#line 1273 "tracker-explorer.c"
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return instance;
#line 1298 "tracker-explorer.c"
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		HISTORY_GET_CLASS (self)->finalize (self);
#line 42 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1311 "tracker-explorer.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 141 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return self ? g_object_ref (self) : NULL;
#line 1319 "tracker-explorer.c"
}


static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 142 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_main_quit ();
#line 1326 "tracker-explorer.c"
}


static void _explorer_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 145 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_entry_changed (self, _sender);
#line 1333 "tracker-explorer.c"
}


static void _explorer_update_types_page_gtk_container_set_focus_child (GtkContainer* _sender, GtkWidget* child, gpointer self) {
#line 157 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_update_types_page (self, child);
#line 1340 "tracker-explorer.c"
}


static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 160 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_forward_clicked (self);
#line 1347 "tracker-explorer.c"
}


static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 164 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_back_clicked (self);
#line 1354 "tracker-explorer.c"
}


void explorer_show (Explorer* self) {
	GtkBuilder* _tmp7_;
	GtkBuilder* builder;
	GObject* _tmp13_ = NULL;
	GtkWindow* _tmp14_;
	GtkWindow* window;
	GObject* _tmp15_ = NULL;
	GtkEntry* _tmp16_;
	GtkEntry* entry;
	GObject* _tmp17_ = NULL;
	GtkTreeView* _tmp18_;
	GtkTreeView* urisview;
	GObject* _tmp19_ = NULL;
	GtkTreeView* _tmp20_;
	GtkTreeView* relationshipsview;
	GObject* _tmp21_ = NULL;
	GtkLabel* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkNotebook* _tmp24_;
	GtkNotebook* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GError * _inner_error_ = NULL;
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 1389 "tracker-explorer.c"
	{
		Resources* _tmp0_ = NULL;
		Resources* _tmp1_;
#line 110 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp0_ = g_initable_new (TYPE_RESOURCES_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Tracker1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Tracker1/Resources", "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
#line 110 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp1_ = (Resources*) _tmp0_;
#line 110 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 1399 "tracker-explorer.c"
			goto __catch0_g_error;
		}
#line 110 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_object_unref0 (self->priv->tracker);
#line 110 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		self->priv->tracker = _tmp1_;
#line 1406 "tracker-explorer.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* msg;
		GtkMessageDialog* _tmp6_;
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 115 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = e;
#line 115 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp3_ = _tmp2_->message;
#line 115 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus\n%s", _tmp3_);
#line 115 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp5_ = g_object_ref_sink (_tmp4_);
#line 115 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		msg = _tmp5_;
#line 118 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp6_ = msg;
#line 118 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_dialog_run ((GtkDialog*) _tmp6_);
#line 119 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_main_quit ();
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_object_unref0 (msg);
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 1442 "tracker-explorer.c"
	}
	__finally0:
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 109 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 1453 "tracker-explorer.c"
	}
#line 123 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp7_ = gtk_builder_new ();
#line 123 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	builder = _tmp7_;
#line 1459 "tracker-explorer.c"
	{
#line 127 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_builder_add_from_file (builder, SRCDIR EXPLORER_UI_FILE, &_inner_error_);
#line 127 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 1465 "tracker-explorer.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 1477 "tracker-explorer.c"
		{
#line 131 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			gtk_builder_add_from_file (builder, TRACKER_UI_DIR EXPLORER_UI_FILE, &_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			if (_inner_error_ != NULL) {
#line 1483 "tracker-explorer.c"
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			GtkMessageDialog* _tmp10_;
			GtkMessageDialog* _tmp11_;
			GtkMessageDialog* msg;
			GtkMessageDialog* _tmp12_;
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			e = _inner_error_;
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_inner_error_ = NULL;
#line 133 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp8_ = e;
#line 133 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp9_ = _tmp8_->message;
#line 133 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI\n%s", _tmp9_);
#line 133 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp11_ = g_object_ref_sink (_tmp10_);
#line 133 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			msg = _tmp11_;
#line 136 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp12_ = msg;
#line 136 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			gtk_dialog_run ((GtkDialog*) _tmp12_);
#line 137 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			gtk_main_quit ();
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_object_unref0 (msg);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_error_free0 (e);
#line 1521 "tracker-explorer.c"
		}
		__finally2:
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_error_free0 (e);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_error_free0 (e);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_object_unref0 (builder);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			g_clear_error (&_inner_error_);
#line 130 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return;
#line 1538 "tracker-explorer.c"
		}
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 1542 "tracker-explorer.c"
	}
	__finally1:
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_object_unref0 (builder);
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 125 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 1555 "tracker-explorer.c"
	}
#line 141 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp13_ = gtk_builder_get_object (builder, "explorer");
#line 141 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp14_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp13_) ? ((GtkWindow*) _tmp13_) : NULL);
#line 141 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	window = _tmp14_;
#line 142 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect ((GtkWidget*) window, "destroy", (GCallback) _gtk_main_quit_gtk_widget_destroy, NULL);
#line 144 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp15_ = gtk_builder_get_object (builder, "text-search");
#line 144 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp16_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp15_) ? ((GtkEntry*) _tmp15_) : NULL);
#line 144 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	entry = _tmp16_;
#line 145 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect ((GtkEditable*) entry, "changed", (GCallback) _explorer_entry_changed_gtk_editable_changed, self);
#line 147 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp17_ = gtk_builder_get_object (builder, "uris");
#line 147 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp18_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp17_) ? ((GtkTreeView*) _tmp17_) : NULL);
#line 147 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	urisview = _tmp18_;
#line 148 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_setup_uris (self, urisview);
#line 150 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp19_ = gtk_builder_get_object (builder, "relationshipsview");
#line 150 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp20_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp19_) ? ((GtkTreeView*) _tmp19_) : NULL);
#line 150 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	relationshipsview = _tmp20_;
#line 151 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_setup_relationships (self, relationshipsview);
#line 153 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp21_ = gtk_builder_get_object (builder, "current-object");
#line 153 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp22_ = _g_object_ref0 (GTK_IS_LABEL (_tmp21_) ? ((GtkLabel*) _tmp21_) : NULL);
#line 153 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->current_uri_label);
#line 153 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->current_uri_label = _tmp22_;
#line 155 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp23_ = gtk_builder_get_object (builder, "types");
#line 155 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp24_ = _g_object_ref0 (GTK_IS_NOTEBOOK (_tmp23_) ? ((GtkNotebook*) _tmp23_) : NULL);
#line 155 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->types);
#line 155 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->types = _tmp24_;
#line 157 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp25_ = self->priv->types;
#line 157 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect ((GtkContainer*) _tmp25_, "set-focus-child", (GCallback) _explorer_update_types_page_gtk_container_set_focus_child, self);
#line 159 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp26_ = gtk_builder_get_object (builder, "forward");
#line 159 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp27_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp26_) ? ((GtkButton*) _tmp26_) : NULL);
#line 159 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->forward);
#line 159 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->forward = _tmp27_;
#line 160 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp28_ = self->priv->forward;
#line 160 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect (_tmp28_, "clicked", (GCallback) _explorer_forward_clicked_gtk_button_clicked, self);
#line 161 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp29_ = self->priv->forward;
#line 161 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp29_, FALSE);
#line 163 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp30_ = gtk_builder_get_object (builder, "back");
#line 163 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp31_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp30_) ? ((GtkButton*) _tmp30_) : NULL);
#line 163 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->back);
#line 163 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->back = _tmp31_;
#line 164 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp32_ = self->priv->back;
#line 164 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect (_tmp32_, "clicked", (GCallback) _explorer_back_clicked_gtk_button_clicked, self);
#line 165 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp33_ = self->priv->back;
#line 165 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, FALSE);
#line 167 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_fetch_prefixes (self);
#line 169 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_show_all ((GtkWidget*) window);
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (relationshipsview);
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (urisview);
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (entry);
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (window);
#line 107 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (builder);
#line 1655 "tracker-explorer.c"
}


static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 177 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_row_selected (self, _sender, path, column);
#line 1662 "tracker-explorer.c"
}


static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview) {
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkTreeView* _tmp6_;
#line 172 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (urisview != NULL);
#line 173 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
#line 173 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->uris);
#line 173 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->uris = _tmp0_;
#line 174 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = urisview;
#line 174 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = self->priv->uris;
#line 174 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
#line 176 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = urisview;
#line 176 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 176 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = g_object_ref_sink (_tmp4_);
#line 176 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp3_, -1, "URI", (GtkCellRenderer*) _tmp5_, "text", 0, NULL, NULL);
#line 176 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (_tmp5_);
#line 177 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = urisview;
#line 177 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect (_tmp6_, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 1704 "tracker-explorer.c"
}


static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview) {
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkTreeView* _tmp9_;
#line 180 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (relationshipsview != NULL);
#line 181 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 181 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->relationships);
#line 181 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->relationships = _tmp0_;
#line 182 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = relationshipsview;
#line 182 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = self->priv->relationships;
#line 182 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
#line 184 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = relationshipsview;
#line 184 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 184 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = g_object_ref_sink (_tmp4_);
#line 184 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp3_, -1, "Relationship", (GtkCellRenderer*) _tmp5_, "text", 1, NULL, NULL);
#line 184 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (_tmp5_);
#line 185 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = relationshipsview;
#line 185 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 185 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp8_ = g_object_ref_sink (_tmp7_);
#line 185 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp6_, -1, "Object", (GtkCellRenderer*) _tmp8_, "text", 2, NULL, NULL);
#line 185 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (_tmp8_);
#line 186 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp9_ = relationshipsview;
#line 186 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect (_tmp9_, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 1759 "tracker-explorer.c"
}


static GtkTreeView* explorer_setup_reverserelationships (Explorer* self) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* reverserelationships;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeView* reverserelationshipsview;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkCellRendererText* _tmp6_;
#line 189 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 191 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	reverserelationships = _tmp0_;
#line 193 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) reverserelationships);
#line 193 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = g_object_ref_sink (_tmp1_);
#line 193 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	reverserelationshipsview = _tmp2_;
#line 194 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_set_model (reverserelationshipsview, (GtkTreeModel*) reverserelationships);
#line 196 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 196 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = g_object_ref_sink (_tmp3_);
#line 196 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Subject", (GtkCellRenderer*) _tmp4_, "text", 1, NULL, NULL);
#line 196 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (_tmp4_);
#line 197 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 197 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = g_object_ref_sink (_tmp5_);
#line 197 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Relationship", (GtkCellRenderer*) _tmp6_, "text", 2, NULL, NULL);
#line 197 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (_tmp6_);
#line 198 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_signal_connect (reverserelationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 200 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = reverserelationshipsview;
#line 200 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (reverserelationships);
#line 200 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 1812 "tracker-explorer.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1301 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1302 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1835 "tracker-explorer.c"
		glong _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1303 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1843 "tracker-explorer.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1305 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1855 "tracker-explorer.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1312 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1880 "tracker-explorer.c"
		glong _tmp2_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1886 "tracker-explorer.c"
	} else {
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1890 "tracker-explorer.c"
	}
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1314 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1896 "tracker-explorer.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1316 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1908 "tracker-explorer.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1318 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1918 "tracker-explorer.c"
	}
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1321 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1924 "tracker-explorer.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1322 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1323 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1938 "tracker-explorer.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1325 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1948 "tracker-explorer.c"
	}
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1327 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1954 "tracker-explorer.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1328 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1963 "tracker-explorer.c"
	}
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1330 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1331 "/usr/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1983 "tracker-explorer.c"
}


static void explorer_fetch_prefixes (Explorer* self) {
	gchar* _tmp0_;
	gchar* query;
	GError * _inner_error_ = NULL;
#line 204 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = g_strdup ("SELECT ?s ?prefix WHERE { ?s a tracker:Namespace ; tracker:prefix ?pre" \
"fix }");
#line 205 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	query = _tmp0_;
#line 1997 "tracker-explorer.c"
	{
		Resources* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		gchar** _result_;
		gint _result__length1;
		gint _result__length2;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp1_ = self->priv->tracker;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp2_ = query;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp5_ = resources_SparqlQuery (_tmp1_, _tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = _tmp5_;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length1 = _tmp3_;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length2 = _tmp4_;
#line 207 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 2021 "tracker-explorer.c"
			goto __catch3_g_error;
		}
		{
			gint i;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			i = 0;
#line 2028 "tracker-explorer.c"
			{
				gboolean _tmp6_;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp6_ = TRUE;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				while (TRUE) {
#line 2035 "tracker-explorer.c"
					gboolean _tmp7_;
					gint _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					gint _tmp10__length2;
					gint _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					gint _tmp12__length2;
					gint _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _namespace;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gchar* _tmp20_ = NULL;
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gint _tmp23__length1;
					gint _tmp23__length2;
					gint _tmp24_;
					const gchar* _tmp25_;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp7_ = _tmp6_;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!_tmp7_) {
#line 2065 "tracker-explorer.c"
						gint _tmp8_;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp8_ = i;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						i = _tmp8_ + 1;
#line 2071 "tracker-explorer.c"
					}
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp6_ = FALSE;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp9_ = i;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp10_ = _result_;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp10__length1 = _result__length1;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp10__length2 = _result__length2;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp11_ = _tmp10__length1;
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!(_tmp9_ < _tmp11_)) {
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						break;
#line 2089 "tracker-explorer.c"
					}
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp12_ = _result_;
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp12__length1 = _result__length1;
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp12__length2 = _result__length2;
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp13_ = i;
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp14_ = _tmp12_[(_tmp13_ * _tmp12__length2) + 0];
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp15_ = g_strdup (_tmp14_);
#line 209 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_namespace = _tmp15_;
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp16_ = _namespace;
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp17_ = _namespace;
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp18_ = strlen (_tmp17_);
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp19_ = _tmp18_;
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp20_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp19_ - 1));
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (_namespace);
#line 210 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_namespace = _tmp20_;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp21_ = self->priv->namespaces;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp22_ = _namespace;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp23_ = _result_;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp23__length1 = _result__length1;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp23__length2 = _result__length2;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp24_ = i;
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp25_ = _tmp23_[(_tmp24_ * _tmp23__length2) + 1];
#line 211 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp22_, _tmp25_);
#line 208 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (_namespace);
#line 2137 "tracker-explorer.c"
				}
			}
		}
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
#line 2143 "tracker-explorer.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 2155 "tracker-explorer.c"
	}
	__finally3:
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (query);
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 206 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 2168 "tracker-explorer.c"
	}
#line 204 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (query);
#line 2172 "tracker-explorer.c"
}


static void explorer_entry_changed (Explorer* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* query;
	GError * _inner_error_ = NULL;
#line 217 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (editable != NULL);
#line 218 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = editable;
#line 218 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = gtk_entry_get_text (GTK_ENTRY (_tmp0_));
#line 218 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = _tmp1_;
#line 218 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = g_strdup_printf ("SELECT ?s WHERE { ?s fts:match \"%s*\" }", _tmp2_);
#line 218 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	query = _tmp3_;
#line 2197 "tracker-explorer.c"
	{
		Resources* _tmp4_;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gchar** _result_;
		gint _result__length1;
		gint _result__length2;
		GtkListStore* _tmp8_;
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp4_ = self->priv->tracker;
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp7_ = resources_SparqlQuery (_tmp4_, query, &_tmp5_, &_tmp6_, &_inner_error_);
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = _tmp7_;
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length1 = _tmp5_;
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length2 = _tmp6_;
#line 222 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 2219 "tracker-explorer.c"
			goto __catch4_g_error;
		}
#line 223 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp8_ = self->priv->uris;
#line 223 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_list_store_clear (_tmp8_);
#line 2226 "tracker-explorer.c"
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint s_collection_length2 = 0;
			gint s_it = 0;
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			s_collection = _result_;
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			s_collection_length1 = _result__length1 * _result__length2;
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			for (s_it = 0; s_it < (_result__length1 * _result__length2); s_it = s_it + 1) {
#line 2238 "tracker-explorer.c"
				gchar* _tmp9_;
				gchar* s = NULL;
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp9_ = g_strdup (s_collection[s_it]);
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				s = _tmp9_;
#line 2245 "tracker-explorer.c"
				{
					GtkTreeIter iter = {0};
					GtkListStore* _tmp10_;
					GtkTreeIter _tmp11_ = {0};
					GtkListStore* _tmp12_;
					GtkTreeIter _tmp13_;
					const gchar* _tmp14_;
#line 227 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp10_ = self->priv->uris;
#line 227 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_append (_tmp10_, &_tmp11_);
#line 227 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					iter = _tmp11_;
#line 228 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp12_ = self->priv->uris;
#line 228 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp13_ = iter;
#line 228 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp14_ = s;
#line 228 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_set (_tmp12_, &_tmp13_, 0, _tmp14_, -1, -1);
#line 224 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (s);
#line 2269 "tracker-explorer.c"
				}
			}
		}
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
#line 2275 "tracker-explorer.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 2287 "tracker-explorer.c"
	}
	__finally4:
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (query);
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 221 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 2300 "tracker-explorer.c"
	}
#line 217 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (query);
#line 2304 "tracker-explorer.c"
}


static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	GeeHashMap* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gpointer _tmp6_ = NULL;
	gchar* prefix;
	gchar* relationship = NULL;
	const gchar* _tmp7_;
#line 237 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 238 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = uri;
#line 238 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "#", 0);
#line 238 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	parts = _tmp2_;
#line 238 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	parts_length1 = _vala_array_length (_tmp1_);
#line 238 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_parts_size_ = parts_length1;
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = self->priv->namespaces;
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = parts;
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4__length1 = parts_length1;
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = _tmp4_[0];
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
#line 239 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	prefix = (gchar*) _tmp6_;
#line 242 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp7_ = prefix;
#line 242 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp7_ != NULL) {
#line 2354 "tracker-explorer.c"
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp8_ = prefix;
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp9_ = parts;
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp9__length1 = parts_length1;
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp10_ = _tmp9_[1];
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp11_ = g_strjoin (":", _tmp8_, _tmp10_, NULL);
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (relationship);
#line 243 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		relationship = _tmp11_;
#line 2374 "tracker-explorer.c"
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
#line 245 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp12_ = uri;
#line 245 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 245 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (relationship);
#line 245 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		relationship = _tmp13_;
#line 2386 "tracker-explorer.c"
	}
#line 246 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = relationship;
#line 246 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (prefix);
#line 246 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 246 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 2396 "tracker-explorer.c"
}


static void explorer_clear_types (Explorer* self) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint npages;
#line 249 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 250 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->types;
#line 250 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = gtk_notebook_get_n_pages (_tmp0_);
#line 250 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	npages = _tmp1_;
#line 2412 "tracker-explorer.c"
	{
		gint i;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		i = 0;
#line 2417 "tracker-explorer.c"
		{
			gboolean _tmp2_;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_tmp2_ = TRUE;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			while (TRUE) {
#line 2424 "tracker-explorer.c"
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				GtkNotebook* _tmp7_;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp3_ = _tmp2_;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				if (!_tmp3_) {
#line 2433 "tracker-explorer.c"
					gint _tmp4_;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp4_ = i;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					i = _tmp4_ + 1;
#line 2439 "tracker-explorer.c"
				}
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp2_ = FALSE;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp5_ = i;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp6_ = npages;
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 251 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					break;
#line 2451 "tracker-explorer.c"
				}
#line 253 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp7_ = self->priv->types;
#line 253 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				gtk_notebook_remove_page (_tmp7_, 0);
#line 2457 "tracker-explorer.c"
			}
		}
	}
}


static void explorer_update_types_page (Explorer* self, GtkWidget* w) {
	GtkNotebook* _tmp0_;
	gint _tmp1_ = 0;
	gint page_num;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* sw;
	GtkNotebook* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* type;
	GtkScrolledWindow* _tmp12_;
	GtkWidget* _tmp13_ = NULL;
	GtkTreeModel* _tmp14_ = NULL;
	GtkListStore* _tmp15_;
	GtkListStore* model;
	GError * _inner_error_ = NULL;
#line 258 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->types;
#line 259 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = gtk_notebook_get_current_page (_tmp0_);
#line 259 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	page_num = _tmp1_;
#line 260 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = page_num;
#line 260 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp2_ < 0) {
#line 261 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 2500 "tracker-explorer.c"
	}
#line 264 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = self->priv->types;
#line 264 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = page_num;
#line 264 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = gtk_notebook_get_nth_page (_tmp3_, _tmp4_);
#line 264 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp5_) ? ((GtkScrolledWindow*) _tmp5_) : NULL);
#line 264 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	sw = _tmp6_;
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp7_ = self->priv->types;
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp8_ = sw;
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp9_ = gtk_notebook_get_tab_label (_tmp7_, (GtkWidget*) _tmp8_);
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp10_ = gtk_label_get_text (GTK_IS_LABEL (_tmp9_) ? ((GtkLabel*) _tmp9_) : NULL);
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 265 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	type = _tmp11_;
#line 267 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp12_ = sw;
#line 267 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp13_ = gtk_bin_get_child ((GtkBin*) _tmp12_);
#line 267 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp14_ = gtk_tree_view_get_model (GTK_IS_TREE_VIEW (_tmp13_) ? ((GtkTreeView*) _tmp13_) : NULL);
#line 267 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp15_ = _g_object_ref0 (GTK_IS_LIST_STORE (_tmp14_) ? ((GtkListStore*) _tmp14_) : NULL);
#line 267 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	model = _tmp15_;
#line 2534 "tracker-explorer.c"
	{
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* query;
		Resources* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gchar** _tmp22_ = NULL;
		gchar** _result_;
		gint _result__length1;
		gint _result__length2;
		GtkListStore* _tmp23_;
		GtkTreeIter iter = {0};
#line 269 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp16_ = type;
#line 269 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp17_ = g_strdup_printf ("SELECT ?r WHERE { ?r rdfs:range %s }", _tmp16_);
#line 269 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		query = _tmp17_;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp18_ = self->priv->tracker;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp19_ = query;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp22_ = resources_SparqlQuery (_tmp18_, _tmp19_, &_tmp20_, &_tmp21_, &_inner_error_);
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = _tmp22_;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length1 = _tmp20_;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length2 = _tmp21_;
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 270 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_free0 (query);
#line 2571 "tracker-explorer.c"
			goto __catch5_g_error;
		}
#line 272 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp23_ = model;
#line 272 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_list_store_clear (_tmp23_);
#line 2578 "tracker-explorer.c"
		{
			gint i;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			i = 0;
#line 2583 "tracker-explorer.c"
			{
				gboolean _tmp24_;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp24_ = TRUE;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				while (TRUE) {
#line 2590 "tracker-explorer.c"
					gboolean _tmp25_;
					gint _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					gint _tmp28__length2;
					gint _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					gint _tmp30__length2;
					gint _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_ = NULL;
					gchar* relation;
					const gchar* _tmp34_;
					History* _tmp35_;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					gchar* query2;
					Resources* _tmp40_;
					const gchar* _tmp41_;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					gchar** _tmp44_ = NULL;
					gchar** result2;
					gint result2_length1;
					gint result2_length2;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp25_ = _tmp24_;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!_tmp25_) {
#line 2623 "tracker-explorer.c"
						gint _tmp26_;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp26_ = i;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						i = _tmp26_ + 1;
#line 2629 "tracker-explorer.c"
					}
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp24_ = FALSE;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp27_ = i;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp28_ = _result_;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp28__length1 = _result__length1;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp28__length2 = _result__length2;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp29_ = _tmp28__length1;
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!(_tmp27_ < _tmp29_)) {
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						break;
#line 2647 "tracker-explorer.c"
					}
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp30_ = _result_;
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp30__length1 = _result__length1;
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp30__length2 = _result__length2;
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp31_ = i;
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp32_ = _tmp30_[(_tmp31_ * _tmp30__length2) + 0];
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp33_ = explorer_subst_prefix (self, _tmp32_);
#line 276 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					relation = _tmp33_;
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp34_ = relation;
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp35_ = self->priv->history;
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp36_ = history_current_uri (_tmp35_);
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp37_ = _tmp36_;
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp38_ = g_strdup_printf ("SELECT ?s WHERE { ?s %s <%s>}", _tmp34_, _tmp37_);
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp39_ = _tmp38_;
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (_tmp37_);
#line 277 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					query2 = _tmp39_;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp40_ = self->priv->tracker;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp41_ = query2;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp44_ = resources_SparqlQuery (_tmp40_, _tmp41_, &_tmp42_, &_tmp43_, &_inner_error_);
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					result2 = _tmp44_;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					result2_length1 = _tmp42_;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					result2_length2 = _tmp43_;
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (_inner_error_ != NULL) {
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_g_free0 (query2);
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_g_free0 (relation);
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
#line 278 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_g_free0 (query);
#line 2701 "tracker-explorer.c"
						goto __catch5_g_error;
					}
					{
						gint j;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						j = 0;
#line 2708 "tracker-explorer.c"
						{
							gboolean _tmp45_;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
							_tmp45_ = TRUE;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
							while (TRUE) {
#line 2715 "tracker-explorer.c"
								gboolean _tmp46_;
								gint _tmp48_;
								gchar** _tmp49_;
								gint _tmp49__length1;
								gint _tmp49__length2;
								gint _tmp50_;
								gchar** _tmp51_;
								gint _tmp51__length1;
								gint _tmp51__length2;
								gint _tmp52_;
								const gchar* _tmp53_;
								gchar* _tmp54_ = NULL;
								gchar* subject;
								GtkListStore* _tmp55_;
								GtkTreeIter _tmp56_ = {0};
								GtkListStore* _tmp57_;
								GtkTreeIter _tmp58_;
								gchar** _tmp59_;
								gint _tmp59__length1;
								gint _tmp59__length2;
								gint _tmp60_;
								const gchar* _tmp61_;
								GtkListStore* _tmp62_;
								GtkTreeIter _tmp63_;
								const gchar* _tmp64_;
								GtkListStore* _tmp65_;
								GtkTreeIter _tmp66_;
								const gchar* _tmp67_;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp46_ = _tmp45_;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								if (!_tmp46_) {
#line 2748 "tracker-explorer.c"
									gint _tmp47_;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
									_tmp47_ = j;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
									j = _tmp47_ + 1;
#line 2754 "tracker-explorer.c"
								}
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp45_ = FALSE;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp48_ = j;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp49_ = result2;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp49__length1 = result2_length1;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp49__length2 = result2_length2;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp50_ = _tmp49__length1;
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								if (!(_tmp48_ < _tmp50_)) {
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
									break;
#line 2772 "tracker-explorer.c"
								}
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp51_ = result2;
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp51__length1 = result2_length1;
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp51__length2 = result2_length2;
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp52_ = j;
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp53_ = _tmp51_[(_tmp52_ * _tmp51__length2) + 0];
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp54_ = explorer_subst_prefix (self, _tmp53_);
#line 281 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								subject = _tmp54_;
#line 282 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp55_ = model;
#line 282 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								gtk_list_store_append (_tmp55_, &_tmp56_);
#line 282 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								iter = _tmp56_;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp57_ = model;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp58_ = iter;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp59_ = result2;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp59__length1 = result2_length1;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp59__length2 = result2_length2;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp60_ = j;
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp61_ = _tmp59_[(_tmp60_ * _tmp59__length2) + 0];
#line 283 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								gtk_list_store_set (_tmp57_, &_tmp58_, 0, _tmp61_, -1, -1);
#line 284 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp62_ = model;
#line 284 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp63_ = iter;
#line 284 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp64_ = subject;
#line 284 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								gtk_list_store_set (_tmp62_, &_tmp63_, 1, _tmp64_, -1, -1);
#line 285 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp65_ = model;
#line 285 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp66_ = iter;
#line 285 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_tmp67_ = relation;
#line 285 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								gtk_list_store_set (_tmp65_, &_tmp66_, 2, _tmp67_, -1, -1);
#line 280 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
								_g_free0 (subject);
#line 2828 "tracker-explorer.c"
							}
						}
					}
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					result2 = (_vala_array_free (result2, result2_length1 * result2_length2, (GDestroyNotify) g_free), NULL);
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (query2);
#line 275 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (relation);
#line 2838 "tracker-explorer.c"
				}
			}
		}
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (query);
#line 2846 "tracker-explorer.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 2858 "tracker-explorer.c"
	}
	__finally5:
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_object_unref0 (model);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (type);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_object_unref0 (sw);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 268 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 2875 "tracker-explorer.c"
	}
#line 258 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (model);
#line 258 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (type);
#line 258 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (sw);
#line 2883 "tracker-explorer.c"
}


static void explorer_add_type (Explorer* self, const gchar* type) {
	const gchar* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* tab_label;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* child;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeView* tv;
	GtkNotebook* _tmp6_;
#line 293 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 293 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (type != NULL);
#line 294 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = type;
#line 294 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 294 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = g_object_ref_sink (_tmp1_);
#line 294 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	tab_label = _tmp2_;
#line 295 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 295 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = g_object_ref_sink (_tmp3_);
#line 295 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	child = _tmp4_;
#line 296 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = explorer_setup_reverserelationships (self);
#line 296 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	tv = _tmp5_;
#line 297 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_container_add ((GtkContainer*) child, (GtkWidget*) tv);
#line 298 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = self->priv->types;
#line 298 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_notebook_append_page (_tmp6_, (GtkWidget*) child, (GtkWidget*) tab_label);
#line 299 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_show_all ((GtkWidget*) child);
#line 293 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (tv);
#line 293 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (child);
#line 293 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (tab_label);
#line 2934 "tracker-explorer.c"
}


static void explorer_set_current_uri (Explorer* self, const gchar* uri) {
	History* _tmp0_;
	const gchar* _tmp1_;
#line 302 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (uri != NULL);
#line 303 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->history;
#line 303 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = uri;
#line 303 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	history_add (_tmp0_, _tmp1_);
#line 304 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_update_pane (self);
#line 2953 "tracker-explorer.c"
}


static void explorer_forward_clicked (Explorer* self) {
	History* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 307 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->history;
#line 308 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = history_forward (_tmp0_);
#line 308 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp1_) {
#line 309 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_update_pane (self);
#line 2970 "tracker-explorer.c"
	}
}


static void explorer_back_clicked (Explorer* self) {
	History* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 313 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->history;
#line 314 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = history_back (_tmp0_);
#line 314 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_tmp1_) {
#line 315 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_update_pane (self);
#line 2988 "tracker-explorer.c"
	}
}


static void explorer_update_pane (Explorer* self) {
	GtkButton* _tmp0_;
	History* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkButton* _tmp3_;
	History* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkLabel* _tmp6_;
	History* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
#line 319 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = self->priv->forward;
#line 320 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = self->priv->history;
#line 320 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = history_can_go_forward (_tmp1_);
#line 320 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
#line 321 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = self->priv->back;
#line 321 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = self->priv->history;
#line 321 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = history_can_go_back (_tmp4_);
#line 321 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp6_ = self->priv->current_uri_label;
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp7_ = self->priv->history;
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp8_ = history_current_uri (_tmp7_);
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp9_ = _tmp8_;
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp10_ = explorer_subst_prefix (self, _tmp9_);
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp11_ = _tmp10_;
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_label_set_text (_tmp6_, _tmp11_);
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (_tmp11_);
#line 322 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_free0 (_tmp9_);
#line 3043 "tracker-explorer.c"
	{
		History* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* query;
		GtkTreeIter iter = {0};
		Resources* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gchar** _tmp21_ = NULL;
		gchar** _result_;
		gint _result__length1;
		gint _result__length2;
		GtkListStore* _tmp22_;
		GtkNotebook* _tmp55_;
		GtkNotebook* _tmp56_;
		gint _tmp57_ = 0;
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp12_ = self->priv->history;
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp13_ = history_current_uri (_tmp12_);
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp14_ = _tmp13_;
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp15_ = g_strdup_printf ("SELECT ?r ?o  WHERE { <%s> ?r ?o }", _tmp14_);
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp16_ = _tmp15_;
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (_tmp14_);
#line 324 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		query = _tmp16_;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp17_ = self->priv->tracker;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp18_ = query;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp21_ = resources_SparqlQuery (_tmp17_, _tmp18_, &_tmp19_, &_tmp20_, &_inner_error_);
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = _tmp21_;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length1 = _tmp19_;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result__length2 = _tmp20_;
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (_inner_error_ != NULL) {
#line 326 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			_g_free0 (query);
#line 3094 "tracker-explorer.c"
			goto __catch6_g_error;
		}
#line 327 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp22_ = self->priv->relationships;
#line 327 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_list_store_clear (_tmp22_);
#line 328 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_clear_types (self);
#line 3103 "tracker-explorer.c"
		{
			gint i;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			i = 0;
#line 3108 "tracker-explorer.c"
			{
				gboolean _tmp23_;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				_tmp23_ = TRUE;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
				while (TRUE) {
#line 3115 "tracker-explorer.c"
					gboolean _tmp24_;
					gint _tmp26_;
					gchar** _tmp27_;
					gint _tmp27__length1;
					gint _tmp27__length2;
					gint _tmp28_;
					gchar** _tmp29_;
					gint _tmp29__length1;
					gint _tmp29__length2;
					gint _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* relationship;
					gchar** _tmp33_;
					gint _tmp33__length1;
					gint _tmp33__length2;
					gint _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_ = NULL;
					gchar* obj;
					GtkListStore* _tmp37_;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_;
					GtkTreeIter _tmp40_;
					gchar** _tmp41_;
					gint _tmp41__length1;
					gint _tmp41__length2;
					gint _tmp42_;
					const gchar* _tmp43_;
					GtkListStore* _tmp44_;
					GtkTreeIter _tmp45_;
					const gchar* _tmp46_;
					GtkListStore* _tmp47_;
					GtkTreeIter _tmp48_;
					const gchar* _tmp49_;
					gboolean _tmp50_ = FALSE;
					const gchar* _tmp51_;
					gboolean _tmp53_;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp24_ = _tmp23_;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!_tmp24_) {
#line 3158 "tracker-explorer.c"
						gint _tmp25_;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp25_ = i;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						i = _tmp25_ + 1;
#line 3164 "tracker-explorer.c"
					}
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp23_ = FALSE;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp26_ = i;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp27_ = _result_;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp27__length1 = _result__length1;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp27__length2 = _result__length2;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp28_ = _tmp27__length1;
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (!(_tmp26_ < _tmp28_)) {
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						break;
#line 3182 "tracker-explorer.c"
					}
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp29_ = _result_;
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp29__length1 = _result__length1;
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp29__length2 = _result__length2;
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp30_ = i;
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp31_ = _tmp29_[(_tmp30_ * _tmp29__length2) + 0];
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp32_ = explorer_subst_prefix (self, _tmp31_);
#line 331 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					relationship = _tmp32_;
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp33_ = _result_;
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp33__length1 = _result__length1;
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp33__length2 = _result__length2;
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp34_ = i;
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp35_ = _tmp33_[(_tmp34_ * _tmp33__length2) + 1];
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp36_ = explorer_subst_prefix (self, _tmp35_);
#line 332 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					obj = _tmp36_;
#line 333 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp37_ = self->priv->relationships;
#line 333 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_append (_tmp37_, &_tmp38_);
#line 333 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					iter = _tmp38_;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp39_ = self->priv->relationships;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp40_ = iter;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp41_ = _result_;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp41__length1 = _result__length1;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp41__length2 = _result__length2;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp42_ = i;
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp43_ = _tmp41_[(_tmp42_ * _tmp41__length2) + 1];
#line 334 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp43_, -1, -1);
#line 335 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp44_ = self->priv->relationships;
#line 335 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp45_ = iter;
#line 335 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp46_ = relationship;
#line 335 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_set (_tmp44_, &_tmp45_, 1, _tmp46_, -1, -1);
#line 336 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp47_ = self->priv->relationships;
#line 336 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp48_ = iter;
#line 336 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp49_ = obj;
#line 336 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					gtk_list_store_set (_tmp47_, &_tmp48_, 2, _tmp49_, -1, -1);
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp51_ = relationship;
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (g_strcmp0 (_tmp51_, "rdf:type") == 0) {
#line 3254 "tracker-explorer.c"
						const gchar* _tmp52_;
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp52_ = obj;
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp50_ = g_strcmp0 (_tmp52_, "rdfs:Resource") != 0;
#line 3260 "tracker-explorer.c"
					} else {
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp50_ = FALSE;
#line 3264 "tracker-explorer.c"
					}
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_tmp53_ = _tmp50_;
#line 338 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					if (_tmp53_) {
#line 3270 "tracker-explorer.c"
						const gchar* _tmp54_;
#line 339 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						_tmp54_ = obj;
#line 339 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
						explorer_add_type (self, _tmp54_);
#line 3276 "tracker-explorer.c"
					}
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (obj);
#line 330 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
					_g_free0 (relationship);
#line 3282 "tracker-explorer.c"
				}
			}
		}
#line 342 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp55_ = self->priv->types;
#line 342 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp56_ = self->priv->types;
#line 342 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_tmp57_ = gtk_notebook_get_n_pages (_tmp56_);
#line 342 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		gtk_notebook_set_current_page (_tmp55_, _tmp57_ - 1);
#line 343 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_update_types_page (self, NULL);
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_free0 (query);
#line 3300 "tracker-explorer.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		e = _inner_error_;
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_inner_error_ = NULL;
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		_g_error_free0 (e);
#line 3312 "tracker-explorer.c"
	}
	__finally6:
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (_inner_error_ != NULL) {
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_clear_error (&_inner_error_);
#line 323 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return;
#line 3323 "tracker-explorer.c"
	}
}


static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	const gchar* uri = NULL;
	GtkTreeIter _tmp5_;
#line 349 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 349 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (view != NULL);
#line 349 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (path != NULL);
#line 349 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (column != NULL);
#line 351 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = view;
#line 351 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
#line 351 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 351 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	model = _tmp2_;
#line 352 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = path;
#line 352 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
#line 352 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	iter = _tmp4_;
#line 354 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp5_ = iter;
#line 354 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_tree_model_get (model, &_tmp5_, 0, &uri, -1);
#line 355 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_set_current_uri (self, uri);
#line 349 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (model);
#line 3368 "tracker-explorer.c"
}


Explorer* explorer_construct (GType object_type) {
	Explorer* self = NULL;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = (Explorer*) g_type_create_instance (object_type);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return self;
#line 3378 "tracker-explorer.c"
}


Explorer* explorer_new (void) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return explorer_construct (TYPE_EXPLORER);
#line 3385 "tracker-explorer.c"
}


static void value_explorer_init (GValue* value) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	value->data[0].v_pointer = NULL;
#line 3392 "tracker-explorer.c"
}


static void value_explorer_free_value (GValue* value) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (value->data[0].v_pointer) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_unref (value->data[0].v_pointer);
#line 3401 "tracker-explorer.c"
	}
}


static void value_explorer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (src_value->data[0].v_pointer) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = explorer_ref (src_value->data[0].v_pointer);
#line 3411 "tracker-explorer.c"
	} else {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3415 "tracker-explorer.c"
	}
}


static gpointer value_explorer_peek_pointer (const GValue* value) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 3423 "tracker-explorer.c"
}


static gchar* value_explorer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (collect_values[0].v_pointer) {
#line 3430 "tracker-explorer.c"
		Explorer* object;
		object = collect_values[0].v_pointer;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3437 "tracker-explorer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3441 "tracker-explorer.c"
		}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = explorer_ref (object);
#line 3445 "tracker-explorer.c"
	} else {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 3449 "tracker-explorer.c"
	}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 3453 "tracker-explorer.c"
}


static gchar* value_explorer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Explorer** object_p;
	object_p = collect_values[0].v_pointer;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!object_p) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3464 "tracker-explorer.c"
	}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (!value->data[0].v_pointer) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = NULL;
#line 3470 "tracker-explorer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = value->data[0].v_pointer;
#line 3474 "tracker-explorer.c"
	} else {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		*object_p = explorer_ref (value->data[0].v_pointer);
#line 3478 "tracker-explorer.c"
	}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return NULL;
#line 3482 "tracker-explorer.c"
}


GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExplorer* spec;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPLORER), NULL);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return G_PARAM_SPEC (spec);
#line 3496 "tracker-explorer.c"
}


gpointer value_get_explorer (const GValue* value) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER), NULL);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return value->data[0].v_pointer;
#line 3505 "tracker-explorer.c"
}


void value_set_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_ref (value->data[0].v_pointer);
#line 3525 "tracker-explorer.c"
	} else {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 3529 "tracker-explorer.c"
	}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_unref (old);
#line 3535 "tracker-explorer.c"
	}
}


void value_take_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	old = value->data[0].v_pointer;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (v_object) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = v_object;
#line 3554 "tracker-explorer.c"
	} else {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		value->data[0].v_pointer = NULL;
#line 3558 "tracker-explorer.c"
	}
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (old) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		explorer_unref (old);
#line 3564 "tracker-explorer.c"
	}
}


static void explorer_class_init (ExplorerClass * klass) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_parent_class = g_type_class_peek_parent (klass);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	EXPLORER_CLASS (klass)->finalize = explorer_finalize;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_type_class_add_private (klass, sizeof (ExplorerPrivate));
#line 3576 "tracker-explorer.c"
}


static void explorer_instance_init (Explorer * self) {
	History* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	GeeHashMap* _tmp4_;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv = EXPLORER_GET_PRIVATE (self);
#line 97 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = history_new ();
#line 97 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->history = _tmp0_;
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp1_ = g_str_hash;
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp2_ = g_str_equal;
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp3_ = g_str_equal;
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp1_, _tmp2_, _tmp3_);
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->priv->namespaces = _tmp4_;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self->ref_count = 1;
#line 3604 "tracker-explorer.c"
}


static void explorer_finalize (Explorer* obj) {
	Explorer * self;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	self = EXPLORER (obj);
#line 96 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->tracker);
#line 97 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_history_unref0 (self->priv->history);
#line 98 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->uris);
#line 99 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->relationships);
#line 100 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->current_uri_label);
#line 101 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->namespaces);
#line 102 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->types);
#line 103 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->forward);
#line 104 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_g_object_unref0 (self->priv->back);
#line 3630 "tracker-explorer.c"
}


GType explorer_get_type (void) {
	static volatile gsize explorer_type_id__volatile = 0;
	if (g_once_init_enter (&explorer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_explorer_init, value_explorer_free_value, value_explorer_copy_value, value_explorer_peek_pointer, "p", value_explorer_collect_value, "p", value_explorer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExplorerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) explorer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Explorer), 0, (GInstanceInitFunc) explorer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType explorer_type_id;
		explorer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Explorer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&explorer_type_id__volatile, explorer_type_id);
	}
	return explorer_type_id__volatile;
}


gpointer explorer_ref (gpointer instance) {
	Explorer* self;
	self = instance;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return instance;
#line 3655 "tracker-explorer.c"
}


void explorer_unref (gpointer instance) {
	Explorer* self;
	self = instance;
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		EXPLORER_GET_CLASS (self)->finalize (self);
#line 93 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3668 "tracker-explorer.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Explorer* _tmp0_;
	Explorer* s;
#line 364 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_init (&args_length1, &args);
#line 366 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_tmp0_ = explorer_new ();
#line 366 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	s = _tmp0_;
#line 367 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	explorer_show (s);
#line 368 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	gtk_main ();
#line 369 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	result = 0;
#line 369 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	_explorer_unref0 (s);
#line 369 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return result;
#line 3693 "tracker-explorer.c"
}


int main (int argc, char ** argv) {
#line 363 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	g_type_init ();
#line 363 "/home/martyn/Source/tracker/src/tracker-explorer/tracker-explorer.vala"
	return _vala_main (argv, argc);
#line 3702 "tracker-explorer.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



