/* tracker-sparql-pattern.c generated by valac 0.20.1, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-class.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-ontologies.h"
#include "libtracker-data/tracker-property.h"


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	gchar* subject;
	gchar* object;
	gboolean return_graph;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	gboolean current_graph_is_var;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type);
static void tracker_sparql_predicate_variable_finalize (GObject* obj);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
static void _vala_array_add7 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void _vala_array_add8 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add9 (glong** array, int* length, int* size, glong value);
static void _vala_array_add10 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add11 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj);
static void tracker_sparql_pattern_finalize (GObject* obj);
static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_object_ref (self) : NULL;
#line 621 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 632 "tracker-sparql-pattern.c"
	{
		GString* _tmp0_;
		GString* sql;
		const gchar* _tmp1_;
		GString* _tmp153_;
		const gchar* _tmp154_;
		gchar* _tmp155_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = g_string_new ("");
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		sql = _tmp0_;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->subject;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp1_ != NULL) {
#line 648 "tracker-sparql-pattern.c"
			const gchar* _tmp2_;
			gint _tmp3_ = 0;
			gint subject_id;
			TrackerDBCursor* cursor;
			gint _tmp4_;
			gboolean first;
			TrackerDBCursor* _tmp14_;
			gboolean _tmp63_;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = self->subject;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = tracker_data_query_resource_id (_tmp2_);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_id = _tmp3_;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cursor = NULL;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = subject_id;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp4_ > 0) {
#line 669 "tracker-sparql-pattern.c"
				TrackerDBInterface* _tmp5_ = NULL;
				TrackerDBInterface* _tmp6_;
				TrackerDBInterface* iface;
				TrackerDBInterface* _tmp7_;
				TrackerDBStatement* _tmp8_ = NULL;
				TrackerDBStatement* stmt;
				TrackerDBStatement* _tmp9_;
				gint _tmp10_;
				TrackerDBStatement* _tmp11_;
				TrackerDBCursor* _tmp12_ = NULL;
				TrackerDBCursor* _tmp13_;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp5_ = tracker_db_manager_get_db_interface ();
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = _g_object_ref0 (_tmp5_);
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				iface = _tmp6_;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = iface;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_db_interface_create_statement (_tmp7_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp8_;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 701 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = stmt;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = subject_id;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp9_, 0, _tmp10_);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp11_ = stmt;
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp12_ = tracker_db_statement_start_cursor (_tmp11_, &_inner_error_);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = _tmp12_;
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 726 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp13_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (iface);
#line 737 "tracker-sparql-pattern.c"
			}
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = TRUE;
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = cursor;
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp14_ != NULL) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 747 "tracker-sparql-pattern.c"
					TrackerDBCursor* _tmp15_;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_;
					TrackerDBCursor* _tmp18_;
					const gchar* _tmp19_ = NULL;
					TrackerClass* _tmp20_ = NULL;
					TrackerClass* _tmp21_;
					TrackerClass* domain;
					gint _tmp22_ = 0;
					TrackerProperty** _tmp23_ = NULL;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = cursor;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp15_, NULL, &_inner_error_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = _tmp16_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (cursor);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (sql);
#line 770 "tracker-sparql-pattern.c"
						goto __catch0_g_error;
					}
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp17_) {
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 777 "tracker-sparql-pattern.c"
					}
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = cursor;
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp18_, 0, NULL);
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = tracker_ontologies_get_class_by_uri (_tmp19_);
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = _g_object_ref0 (_tmp20_);
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp21_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = tracker_ontologies_get_properties (&_tmp22_);
#line 791 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp23_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp22_;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp22_; prop_it = prop_it + 1) {
#line 803 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp24_;
							TrackerProperty* prop = NULL;
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp24_ = _g_object_ref0 (prop_collection[prop_it]);
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp24_;
#line 810 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp25_;
								TrackerClass* _tmp26_;
								TrackerClass* _tmp27_;
								TrackerClass* _tmp28_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp25_ = prop;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp26_ = tracker_property_get_domain (_tmp25_);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp27_ = _tmp26_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp28_ = domain;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp27_ == _tmp28_) {
#line 826 "tracker-sparql-pattern.c"
									gboolean _tmp29_;
									GString* _tmp31_;
									TrackerProperty* _tmp32_;
									const gchar* _tmp33_;
									const gchar* _tmp34_;
									GString* _tmp35_;
									TrackerProperty* _tmp36_;
									const gchar* _tmp37_;
									const gchar* _tmp38_;
									gchar* _tmp39_ = NULL;
									gchar* _tmp40_;
									TrackerProperty* _tmp41_;
									TrackerPropertyType _tmp42_;
									TrackerPropertyType _tmp43_;
									GString* _tmp44_;
									gboolean _tmp45_;
									GString* _tmp50_;
									TrackerProperty* _tmp51_;
									const gchar* _tmp52_;
									const gchar* _tmp53_;
									GString* _tmp54_;
									TrackerSparqlLiteralBinding* _tmp55_;
									TrackerSparqlLiteralBinding* binding;
									TrackerSparqlLiteralBinding* _tmp56_;
									gint _tmp57_;
									gchar* _tmp58_ = NULL;
									TrackerSparqlLiteralBinding* _tmp59_;
									TrackerSparqlQuery* _tmp60_;
									TrackerSparqlLiteralBinding* _tmp61_;
									TrackerSparqlLiteralBinding* _tmp62_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp29_ = first;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp29_) {
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 863 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp30_;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp30_ = sql;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp30_, " UNION ALL ");
#line 870 "tracker-sparql-pattern.c"
									}
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp31_ = sql;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp32_ = prop;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp33_ = tracker_property_get_uri (_tmp32_);
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp34_ = _tmp33_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp31_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp34_);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp35_ = sql;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp36_ = prop;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp37_ = tracker_property_get_name (_tmp36_);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp38_ = _tmp37_;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp39_ = g_strdup_printf ("\"%s\"", _tmp38_);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp40_ = _tmp39_;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp41_ = prop;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp42_ = tracker_property_get_data_type (_tmp41_);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp43_ = _tmp42_;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp35_, _tmp40_, _tmp43_);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp40_);
#line 63 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp44_ = sql;
#line 63 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp44_, " AS \"object\"");
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp45_ = self->return_graph;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp45_) {
#line 912 "tracker-sparql-pattern.c"
										GString* _tmp46_;
										TrackerProperty* _tmp47_;
										const gchar* _tmp48_;
										const gchar* _tmp49_;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp46_ = sql;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp47_ = prop;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp48_ = tracker_property_get_name (_tmp47_);
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp49_ = _tmp48_;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp46_, ", \"%s:graph\" AS \"graph\"", _tmp49_);
#line 927 "tracker-sparql-pattern.c"
									}
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = sql;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = prop;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = tracker_property_get_table_name (_tmp51_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = _tmp52_;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp50_, " FROM \"%s\"", _tmp53_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp54_ = sql;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp54_, " WHERE ID = ?");
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp55_ = tracker_sparql_literal_binding_new ();
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									binding = _tmp55_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = binding;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp57_ = subject_id;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = g_strdup_printf ("%i", _tmp57_);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp56_->literal);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_->literal = _tmp58_;
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp59_ = binding;
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									((TrackerSparqlDataBinding*) _tmp59_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = query;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp61_ = binding;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = _g_object_ref0 (_tmp61_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_->bindings = g_list_append (_tmp60_->bindings, _tmp62_);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (binding);
#line 971 "tracker-sparql-pattern.c"
								}
#line 52 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 975 "tracker-sparql-pattern.c"
							}
						}
					}
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 981 "tracker-sparql-pattern.c"
				}
			}
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp63_ = first;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp63_) {
#line 988 "tracker-sparql-pattern.c"
				GString* _tmp64_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp64_ = sql;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp64_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 994 "tracker-sparql-pattern.c"
			}
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cursor);
#line 998 "tracker-sparql-pattern.c"
		} else {
			const gchar* _tmp65_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp65_ = self->object;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp65_ != NULL) {
#line 1005 "tracker-sparql-pattern.c"
				const gchar* _tmp66_;
				gint _tmp67_ = 0;
				gint object_id;
				TrackerDBInterface* _tmp68_ = NULL;
				TrackerDBInterface* _tmp69_;
				TrackerDBInterface* iface;
				TrackerDBInterface* _tmp70_;
				TrackerDBStatement* _tmp71_ = NULL;
				TrackerDBStatement* stmt;
				TrackerDBStatement* _tmp72_;
				gint _tmp73_;
				TrackerDBStatement* _tmp74_;
				TrackerDBCursor* _tmp75_ = NULL;
				TrackerDBCursor* cursor;
				gboolean first;
				TrackerDBCursor* _tmp76_;
				gboolean _tmp116_;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp66_ = self->object;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp67_ = tracker_data_query_resource_id (_tmp66_);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				object_id = _tmp67_;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp68_ = tracker_db_manager_get_db_interface ();
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp69_ = _g_object_ref0 (_tmp68_);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				iface = _tmp69_;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp70_ = iface;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp71_ = tracker_db_interface_create_statement (_tmp70_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp71_;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1047 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp72_ = stmt;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp73_ = object_id;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp72_, 0, _tmp73_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp74_ = stmt;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = tracker_db_statement_start_cursor (_tmp74_, &_inner_error_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp75_;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1070 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp76_ = cursor;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp76_ != NULL) {
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					while (TRUE) {
#line 1081 "tracker-sparql-pattern.c"
						TrackerDBCursor* _tmp77_;
						gboolean _tmp78_ = FALSE;
						gboolean _tmp79_;
						TrackerDBCursor* _tmp80_;
						const gchar* _tmp81_ = NULL;
						TrackerClass* _tmp82_ = NULL;
						TrackerClass* _tmp83_;
						TrackerClass* range;
						gint _tmp84_ = 0;
						TrackerProperty** _tmp85_ = NULL;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp77_ = cursor;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp78_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp77_, NULL, &_inner_error_);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp79_ = _tmp78_;
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (cursor);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (stmt);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (iface);
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (sql);
#line 1108 "tracker-sparql-pattern.c"
							goto __catch0_g_error;
						}
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp79_) {
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 1115 "tracker-sparql-pattern.c"
						}
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp80_ = cursor;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp81_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp80_, 0, NULL);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp82_ = tracker_ontologies_get_class_by_uri (_tmp81_);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp83_ = _g_object_ref0 (_tmp82_);
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						range = _tmp83_;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp85_ = tracker_ontologies_get_properties (&_tmp84_);
#line 1129 "tracker-sparql-pattern.c"
						{
							TrackerProperty** prop_collection = NULL;
							gint prop_collection_length1 = 0;
							gint _prop_collection_size_ = 0;
							gint prop_it = 0;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection = _tmp85_;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection_length1 = _tmp84_;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (prop_it = 0; prop_it < _tmp84_; prop_it = prop_it + 1) {
#line 1141 "tracker-sparql-pattern.c"
								TrackerProperty* _tmp86_;
								TrackerProperty* prop = NULL;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp86_ = _g_object_ref0 (prop_collection[prop_it]);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								prop = _tmp86_;
#line 1148 "tracker-sparql-pattern.c"
								{
									TrackerProperty* _tmp87_;
									TrackerClass* _tmp88_;
									TrackerClass* _tmp89_;
									TrackerClass* _tmp90_;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp87_ = prop;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp88_ = tracker_property_get_range (_tmp87_);
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp89_ = _tmp88_;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp90_ = range;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp89_ == _tmp90_) {
#line 1164 "tracker-sparql-pattern.c"
										gboolean _tmp91_;
										GString* _tmp93_;
										TrackerProperty* _tmp94_;
										const gchar* _tmp95_;
										const gchar* _tmp96_;
										GString* _tmp97_;
										TrackerProperty* _tmp98_;
										const gchar* _tmp99_;
										const gchar* _tmp100_;
										gchar* _tmp101_ = NULL;
										gchar* _tmp102_;
										TrackerProperty* _tmp103_;
										TrackerPropertyType _tmp104_;
										TrackerPropertyType _tmp105_;
										GString* _tmp106_;
										gboolean _tmp107_;
										GString* _tmp112_;
										TrackerProperty* _tmp113_;
										const gchar* _tmp114_;
										const gchar* _tmp115_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp91_ = first;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp91_) {
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											first = FALSE;
#line 1191 "tracker-sparql-pattern.c"
										} else {
											GString* _tmp92_;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp92_ = sql;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append (_tmp92_, " UNION ALL ");
#line 1198 "tracker-sparql-pattern.c"
										}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp93_ = sql;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp94_ = prop;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp95_ = tracker_property_get_uri (_tmp94_);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp96_ = _tmp95_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp93_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp96_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp97_ = sql;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp98_ = prop;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp99_ = tracker_property_get_name (_tmp98_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp100_ = _tmp99_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp101_ = g_strdup_printf ("\"%s\"", _tmp100_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp102_ = _tmp101_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp103_ = prop;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp104_ = tracker_property_get_data_type (_tmp103_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp105_ = _tmp104_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										tracker_sparql_expression_append_expression_as_string (_tmp97_, _tmp102_, _tmp105_);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp102_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp106_ = sql;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp106_, " AS \"object\"");
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp107_ = self->return_graph;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp107_) {
#line 1240 "tracker-sparql-pattern.c"
											GString* _tmp108_;
											TrackerProperty* _tmp109_;
											const gchar* _tmp110_;
											const gchar* _tmp111_;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp108_ = sql;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp109_ = prop;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp110_ = tracker_property_get_name (_tmp109_);
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp111_ = _tmp110_;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp108_, ", \"%s:graph\" AS \"graph\"", _tmp111_);
#line 1255 "tracker-sparql-pattern.c"
										}
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp112_ = sql;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp113_ = prop;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp114_ = tracker_property_get_table_name (_tmp113_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp115_ = _tmp114_;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp112_, " FROM \"%s\"", _tmp115_);
#line 1267 "tracker-sparql-pattern.c"
									}
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (prop);
#line 1271 "tracker-sparql-pattern.c"
								}
							}
						}
#line 97 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (range);
#line 1277 "tracker-sparql-pattern.c"
					}
				}
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp116_ = first;
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp116_) {
#line 1284 "tracker-sparql-pattern.c"
					GString* _tmp117_;
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp117_ = sql;
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp117_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 1290 "tracker-sparql-pattern.c"
				}
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (iface);
#line 1298 "tracker-sparql-pattern.c"
			} else {
				TrackerClass* _tmp118_;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp118_ = self->domain;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp118_ != NULL) {
#line 1305 "tracker-sparql-pattern.c"
					gboolean first;
					gint _tmp119_ = 0;
					TrackerProperty** _tmp120_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = TRUE;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp120_ = tracker_ontologies_get_properties (&_tmp119_);
#line 1313 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp120_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp119_;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp119_; prop_it = prop_it + 1) {
#line 1325 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp121_;
							TrackerProperty* prop = NULL;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp121_ = _g_object_ref0 (prop_collection[prop_it]);
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp121_;
#line 1332 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp122_;
								TrackerClass* _tmp123_;
								TrackerClass* _tmp124_;
								TrackerClass* _tmp125_;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp122_ = prop;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp123_ = tracker_property_get_domain (_tmp122_);
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp124_ = _tmp123_;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp125_ = self->domain;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp124_ == _tmp125_) {
#line 1348 "tracker-sparql-pattern.c"
									gboolean _tmp126_;
									GString* _tmp128_;
									TrackerProperty* _tmp129_;
									const gchar* _tmp130_;
									const gchar* _tmp131_;
									GString* _tmp132_;
									TrackerProperty* _tmp133_;
									const gchar* _tmp134_;
									const gchar* _tmp135_;
									gchar* _tmp136_ = NULL;
									gchar* _tmp137_;
									TrackerProperty* _tmp138_;
									TrackerPropertyType _tmp139_;
									TrackerPropertyType _tmp140_;
									GString* _tmp141_;
									gboolean _tmp142_;
									GString* _tmp147_;
									TrackerProperty* _tmp148_;
									const gchar* _tmp149_;
									const gchar* _tmp150_;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp126_ = first;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp126_) {
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 1375 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp127_;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp127_ = sql;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp127_, " UNION ALL ");
#line 1382 "tracker-sparql-pattern.c"
									}
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp128_ = sql;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp129_ = prop;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp130_ = tracker_property_get_uri (_tmp129_);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp131_ = _tmp130_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp128_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp131_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp132_ = sql;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp133_ = prop;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp134_ = tracker_property_get_name (_tmp133_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp135_ = _tmp134_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp136_ = g_strdup_printf ("\"%s\"", _tmp135_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp137_ = _tmp136_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp138_ = prop;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp139_ = tracker_property_get_data_type (_tmp138_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp140_ = _tmp139_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp132_, _tmp137_, _tmp140_);
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp137_);
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp141_ = sql;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp141_, " AS \"object\"");
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp142_ = self->return_graph;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp142_) {
#line 1424 "tracker-sparql-pattern.c"
										GString* _tmp143_;
										TrackerProperty* _tmp144_;
										const gchar* _tmp145_;
										const gchar* _tmp146_;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp143_ = sql;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp144_ = prop;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp145_ = tracker_property_get_name (_tmp144_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp146_ = _tmp145_;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp143_, ", \"%s:graph\" AS \"graph\"", _tmp146_);
#line 1439 "tracker-sparql-pattern.c"
									}
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp147_ = sql;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp148_ = prop;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp149_ = tracker_property_get_table_name (_tmp148_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp150_ = _tmp149_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp147_, " FROM \"%s\"", _tmp150_);
#line 1451 "tracker-sparql-pattern.c"
								}
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 1455 "tracker-sparql-pattern.c"
							}
						}
					}
				} else {
					TrackerSparqlQuery* _tmp151_;
					GError* _tmp152_ = NULL;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_ = query;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_ = tracker_sparql_query_get_internal_error (_tmp151_, "Unrestricted predicate variables not supported");
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp152_;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1470 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
			}
		}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp153_ = sql;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp154_ = _tmp153_->str;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp155_ = g_strdup (_tmp154_);
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = _tmp155_;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (sql);
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 1487 "tracker-sparql-pattern.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp156_;
		const gchar* _tmp157_;
		GError* _tmp158_;
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp156_ = e;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp157_ = _tmp156_->message;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp158_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp157_);
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = _tmp158_;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 1510 "tracker-sparql-pattern.c"
		goto __finally0;
	}
	__finally0:
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_propagate_error (error, _inner_error_);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1520 "tracker-sparql-pattern.c"
	} else {
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_clear_error (&_inner_error_);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1528 "tracker-sparql-pattern.c"
	}
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type) {
	TrackerSparqlPredicateVariable * self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 1539 "tracker-sparql-pattern.c"
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE);
#line 1546 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
#line 1555 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
}


static void tracker_sparql_predicate_variable_finalize (GObject* obj) {
	TrackerSparqlPredicateVariable * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->subject);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->object);
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->domain);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
#line 1575 "tracker-sparql-pattern.c"
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlExpression* _tmp2_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->query = _tmp0_;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = query;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->expression;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->expression = _tmp2_;
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 1612 "tracker-sparql-pattern.c"
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
#line 1619 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_query_next (_tmp0_, &_inner_error_);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1645 "tracker-sparql-pattern.c"
		} else {
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1653 "tracker-sparql-pattern.c"
		}
	}
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1660 "tracker-sparql-pattern.c"
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1678 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = type;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_accept (_tmp0_, _tmp1_, &_inner_error_);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _tmp2_;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1707 "tracker-sparql-pattern.c"
		} else {
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1715 "tracker-sparql-pattern.c"
		}
	}
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp3_;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1722 "tracker-sparql-pattern.c"
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_ = NULL;
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = msg;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1745 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = type;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_expect (_tmp0_, _tmp1_, &_inner_error_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _tmp2_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1774 "tracker-sparql-pattern.c"
		} else {
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 1782 "tracker-sparql-pattern.c"
		}
	}
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp3_;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1789 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_ = {0};
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_get_location (_tmp0_, &_tmp1_);
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	*result = _tmp1_;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return;
#line 1806 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_;
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (location != NULL);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = *location;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_set_location (_tmp0_, &_tmp1_);
#line 1823 "tracker-sparql-pattern.c"
}


static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
#line 215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = strip;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1844 "tracker-sparql-pattern.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1851 "tracker-sparql-pattern.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_free (self);
#line 1860 "tracker-sparql-pattern.c"
}


static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 1871 "tracker-sparql-pattern.c"
	}
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1875 "tracker-sparql-pattern.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1886 "tracker-sparql-pattern.c"
	}
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 1892 "tracker-sparql-pattern.c"
}


static void _vala_array_add7 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 1903 "tracker-sparql-pattern.c"
	}
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1907 "tracker-sparql-pattern.c"
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	TrackerSparqlSelectContext* _result_ = NULL;
	gboolean _tmp0_;
	TrackerSparqlSelectContext* _tmp9_;
	TrackerPropertyType type;
	GString* _tmp10_;
	GString* pattern_sql;
	TrackerSparqlQuery* _tmp11_;
	GList* _tmp12_;
	GList* old_bindings;
	GString* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	TrackerSourceLocation _tmp19_ = {0};
	TrackerSourceLocation select_variables_location;
	TrackerSparqlExpression* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_;
	GString* _tmp23_;
	TrackerSparqlContext* _tmp24_ = NULL;
	TrackerSparqlContext* pattern;
	TrackerSparqlContext* _tmp25_;
	GHashTable* _tmp26_;
	GList* _tmp27_ = NULL;
	TrackerSourceLocation _tmp33_ = {0};
	TrackerSourceLocation after_where;
	TrackerSourceLocation _tmp34_;
	TrackerSparqlContext* _tmp35_;
	TrackerSparqlContext* _tmp36_;
	GHashTable* _tmp37_;
	GList* _tmp38_ = NULL;
	TrackerSparqlQuery* _tmp48_;
	GList* _tmp49_;
	GList* where_bindings;
	TrackerSparqlQuery* _tmp50_;
	GList* _tmp51_;
	gboolean first;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_;
	gboolean _tmp108_;
	GList* _tmp117_;
	gboolean _tmp122_;
	GString* _tmp124_;
	GString* _tmp125_;
	GString* _tmp126_;
	const gchar* _tmp127_;
	GString* _tmp128_;
	TrackerSourceLocation _tmp129_;
	gboolean _tmp130_ = FALSE;
	gboolean _tmp131_;
	gboolean _tmp163_ = FALSE;
	gboolean _tmp164_;
	gint limit;
	gint offset;
	gboolean _tmp185_ = FALSE;
	gboolean _tmp186_;
	gint _tmp205_;
	gboolean _tmp235_ = FALSE;
	gboolean _tmp236_ = FALSE;
	gboolean _tmp237_;
	gboolean _tmp239_;
	gboolean _tmp241_;
	TrackerSparqlContext* _tmp258_;
	TrackerSparqlContext* _tmp259_;
	TrackerSparqlContext* _tmp260_;
	TrackerSparqlSelectContext* _tmp261_;
	TrackerPropertyType _tmp262_;
	GError * _inner_error_ = NULL;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = scalar_subquery;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_) {
#line 1990 "tracker-sparql-pattern.c"
		TrackerSparqlQuery* _tmp1_;
		TrackerSparqlContext* _tmp2_;
		TrackerSparqlContext* _tmp3_;
		TrackerSparqlSelectContext* _tmp4_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->query;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 2007 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlQuery* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		TrackerSparqlSelectContext* _tmp8_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->query;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_select_context_new (_tmp5_, _tmp7_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp8_;
#line 2025 "tracker-sparql-pattern.c"
	}
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = _result_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp9_);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = g_string_new ("");
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern_sql = _tmp10_;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = self->priv->query;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->bindings;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_->bindings = NULL;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = _tmp12_;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = sql;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp13_, "SELECT ");
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2065 "tracker-sparql-pattern.c"
		} else {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2079 "tracker-sparql-pattern.c"
		}
	}
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp15_ = _tmp14_;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2100 "tracker-sparql-pattern.c"
		} else {
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2114 "tracker-sparql-pattern.c"
		}
	}
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp15_) {
#line 2119 "tracker-sparql-pattern.c"
		GString* _tmp16_;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = sql;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp16_, "DISTINCT ");
#line 2125 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = _tmp17_;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2147 "tracker-sparql-pattern.c"
			} else {
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2161 "tracker-sparql-pattern.c"
			}
		}
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp18_) {
#line 2166 "tracker-sparql-pattern.c"
		}
	}
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp19_);
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	select_variables_location = _tmp19_;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = self->priv->expression;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_skip_select_variables (_tmp20_, &_inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2191 "tracker-sparql-pattern.c"
		} else {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2205 "tracker-sparql-pattern.c"
		}
	}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = _tmp21_;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2226 "tracker-sparql-pattern.c"
		} else {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2240 "tracker-sparql-pattern.c"
		}
	}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp22_) {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2261 "tracker-sparql-pattern.c"
			} else {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2275 "tracker-sparql-pattern.c"
			}
		}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2294 "tracker-sparql-pattern.c"
			} else {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2308 "tracker-sparql-pattern.c"
			}
		}
	}
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2328 "tracker-sparql-pattern.c"
		} else {
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2342 "tracker-sparql-pattern.c"
		}
	}
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = pattern_sql;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp23_, &_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp24_;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2365 "tracker-sparql-pattern.c"
		} else {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2379 "tracker-sparql-pattern.c"
		}
	}
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = pattern;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = _tmp25_->var_set;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = g_hash_table_get_keys (_tmp26_);
#line 2388 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp27_;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2396 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 2400 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp28_;
				TrackerSparqlContext* _tmp29_;
				GHashTable* _tmp30_;
				TrackerSparqlVariable* _tmp31_;
				TrackerSparqlVariable* _tmp32_;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = tracker_sparql_pattern_get_context (self);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = _tmp28_;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp29_->var_set;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = key;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _g_object_ref0 (_tmp31_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp30_, _tmp32_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 2419 "tracker-sparql-pattern.c"
			}
		}
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 2424 "tracker-sparql-pattern.c"
	}
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp33_);
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	after_where = _tmp33_;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = select_variables_location;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp34_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = tracker_sparql_pattern_get_context (self);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp36_ = _tmp35_;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp37_ = _tmp36_->var_set;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp38_ = g_hash_table_get_keys (_tmp37_);
#line 2442 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp38_;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2450 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 2454 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp39_;
				TrackerSparqlVariableBinding* _tmp40_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = variable;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_->binding;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp40_ == NULL) {
#line 2464 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_;
					GError* _tmp46_ = NULL;
					GError* _tmp47_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = variable;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = tracker_sparql_variable_get_name (_tmp41_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = _tmp42_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = g_strdup_printf ("use of undefined variable `%s'", _tmp43_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = _tmp44_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = tracker_sparql_pattern_get_error (self, _tmp45_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = _tmp46_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp45_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp47_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2506 "tracker-sparql-pattern.c"
					} else {
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2524 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 2531 "tracker-sparql-pattern.c"
	}
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_ = self->priv->query;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp49_ = _tmp48_->bindings;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_->bindings = NULL;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	where_bindings = _tmp49_;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = self->priv->query;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = old_bindings;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = NULL;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (_tmp50_->bindings);
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->bindings = _tmp51_;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = _tmp52_;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2575 "tracker-sparql-pattern.c"
		} else {
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2593 "tracker-sparql-pattern.c"
		}
	}
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp53_) {
#line 2598 "tracker-sparql-pattern.c"
		TrackerSparqlContext* _tmp54_;
		TrackerSparqlContext* _tmp55_;
		GHashTable* _tmp56_;
		GList* _tmp57_ = NULL;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp54_ = tracker_sparql_pattern_get_context (self);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp55_ = _tmp54_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = _tmp55_->var_set;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = g_hash_table_get_keys (_tmp56_);
#line 2611 "tracker-sparql-pattern.c"
		{
			GList* variable_collection = NULL;
			GList* variable_it = NULL;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable_collection = _tmp57_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2619 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* variable = NULL;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				variable = (TrackerSparqlVariable*) variable_it->data;
#line 2623 "tracker-sparql-pattern.c"
				{
					gboolean _tmp58_;
					gboolean _tmp60_;
					TrackerSparqlSelectContext* _tmp76_;
					TrackerSparqlSelectContext* _tmp77_;
					TrackerPropertyType* _tmp78_;
					gint _tmp78__length1;
					TrackerSparqlVariable* _tmp79_;
					TrackerSparqlVariableBinding* _tmp80_;
					TrackerPropertyType _tmp81_;
					TrackerSparqlSelectContext* _tmp82_;
					TrackerSparqlSelectContext* _tmp83_;
					gchar** _tmp84_;
					gint _tmp84__length1;
					TrackerSparqlVariable* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = first;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp58_) {
#line 2646 "tracker-sparql-pattern.c"
						GString* _tmp59_;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = sql;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp59_, ", ");
#line 2652 "tracker-sparql-pattern.c"
					} else {
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 2656 "tracker-sparql-pattern.c"
					}
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = subquery;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp60_) {
#line 2662 "tracker-sparql-pattern.c"
						GString* _tmp61_;
						TrackerSparqlVariable* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = sql;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp62_ = variable;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp63_ = tracker_sparql_variable_get_sql_expression (_tmp62_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp64_ = _tmp63_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp61_, _tmp64_);
#line 2677 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp65_;
						TrackerSparqlVariable* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						TrackerSparqlVariable* _tmp69_;
						TrackerSparqlVariableBinding* _tmp70_;
						TrackerPropertyType _tmp71_;
						GString* _tmp72_;
						TrackerSparqlVariable* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp65_ = sql;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp66_ = variable;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp67_ = tracker_sparql_variable_get_sql_expression (_tmp66_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp68_ = _tmp67_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp69_ = variable;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp70_ = _tmp69_->binding;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp71_ = ((TrackerSparqlDataBinding*) _tmp70_)->data_type;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_expression_append_expression_as_string (_tmp65_, _tmp68_, _tmp71_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = sql;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = variable;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_variable_get_name (_tmp73_);
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp72_, " AS \"%s\"", _tmp75_);
#line 2716 "tracker-sparql-pattern.c"
					}
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = _result_;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = _result_;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_->types;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78__length1 = _tmp77_->types_length1;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = variable;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = _tmp79_->binding;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = ((TrackerSparqlDataBinding*) _tmp80_)->data_type;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add5 (&_tmp76_->types, &_tmp76_->types_length1, &_tmp76_->_types_size_, _tmp81_);
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp82_ = _result_;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp83_ = _result_;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = _tmp83_->variable_names;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84__length1 = _tmp83_->variable_names_length1;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = variable;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = tracker_sparql_variable_get_name (_tmp85_);
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp87_ = _tmp86_;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = g_strdup (_tmp87_);
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add6 (&_tmp82_->variable_names, &_tmp82_->variable_names_length1, &_tmp82_->_variable_names_size_, _tmp88_);
#line 2752 "tracker-sparql-pattern.c"
				}
			}
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (variable_collection);
#line 2757 "tracker-sparql-pattern.c"
		}
	} else {
		{
			gint i;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 2764 "tracker-sparql-pattern.c"
			{
				gboolean _tmp89_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp89_ = TRUE;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 2771 "tracker-sparql-pattern.c"
					gboolean _tmp90_;
					gint _tmp92_;
					TrackerSparqlExpression* _tmp94_;
					GString* _tmp95_;
					gboolean _tmp96_;
					gint _tmp97_;
					TrackerPropertyType _tmp98_ = 0;
					TrackerPropertyType _tmp99_;
					TrackerSparqlSelectContext* _tmp100_;
					TrackerSparqlSelectContext* _tmp101_;
					TrackerPropertyType* _tmp102_;
					gint _tmp102__length1;
					TrackerPropertyType _tmp103_;
					TrackerSparqlTokenType _tmp104_ = 0;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp90_ = _tmp89_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp90_) {
#line 2790 "tracker-sparql-pattern.c"
						gint _tmp91_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp91_ = i;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp91_ + 1;
#line 2796 "tracker-sparql-pattern.c"
					}
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = FALSE;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = i;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp92_ > 0) {
#line 2806 "tracker-sparql-pattern.c"
						GString* _tmp93_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp93_ = sql;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp93_, ", ");
#line 2812 "tracker-sparql-pattern.c"
					}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = self->priv->expression;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = sql;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = subquery;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = i;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp98_ = tracker_sparql_expression_translate_select_expression (_tmp94_, _tmp95_, _tmp96_, _tmp97_, &_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = _tmp98_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2844 "tracker-sparql-pattern.c"
						} else {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2862 "tracker-sparql-pattern.c"
						}
					}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					type = _tmp99_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = _result_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = _result_;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp102_ = _tmp101_->types;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp102__length1 = _tmp101_->types_length1;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp103_ = type;
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add7 (&_tmp100_->types, &_tmp100_->types_length1, &_tmp100_->_types_size_, _tmp103_);
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp104_ = tracker_sparql_pattern_current (self);
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					switch (_tmp104_) {
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 2899 "tracker-sparql-pattern.c"
						{
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 2903 "tracker-sparql-pattern.c"
						}
						default:
						{
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							continue;
#line 2909 "tracker-sparql-pattern.c"
						}
					}
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 2914 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp106_ = self->queries_fts_data;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp106_) {
#line 2923 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp107_;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp107_ = self->fts_subject;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp105_ = _tmp107_ != NULL;
#line 2929 "tracker-sparql-pattern.c"
	} else {
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp105_ = FALSE;
#line 2933 "tracker-sparql-pattern.c"
	}
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp108_ = _tmp105_;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp108_) {
#line 2939 "tracker-sparql-pattern.c"
		gboolean _tmp109_;
		GString* _tmp111_;
		TrackerSparqlVariable* _tmp112_;
		const gchar* _tmp113_;
		const gchar* _tmp114_;
		gchar* _tmp115_ = NULL;
		gchar* _tmp116_;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp109_ = first;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp109_) {
#line 2951 "tracker-sparql-pattern.c"
			GString* _tmp110_;
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp110_ = sql;
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp110_, ", ");
#line 2957 "tracker-sparql-pattern.c"
		} else {
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = FALSE;
#line 2961 "tracker-sparql-pattern.c"
		}
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp111_ = sql;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp112_ = self->fts_subject;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp113_ = tracker_sparql_variable_get_sql_expression (_tmp112_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp114_ = _tmp113_;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp115_ = g_strdup_printf ("%s AS docid ", _tmp114_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp116_ = _tmp115_;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp111_, _tmp116_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp116_);
#line 2979 "tracker-sparql-pattern.c"
	}
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp117_ = where_bindings;
#line 2983 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp117_;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 2991 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp118_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp118_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp118_;
#line 2998 "tracker-sparql-pattern.c"
			{
				TrackerSparqlQuery* _tmp119_;
				TrackerSparqlLiteralBinding* _tmp120_;
				TrackerSparqlLiteralBinding* _tmp121_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_ = self->priv->query;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp120_ = binding;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = _g_object_ref0 (_tmp120_);
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_->bindings = g_list_append (_tmp119_->bindings, _tmp121_);
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 3013 "tracker-sparql-pattern.c"
			}
		}
	}
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp122_ = first;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp122_) {
#line 3021 "tracker-sparql-pattern.c"
		GString* _tmp123_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp123_ = sql;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp123_, "NULL");
#line 3027 "tracker-sparql-pattern.c"
	}
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp124_ = sql;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp124_, " FROM (");
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp125_ = sql;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp126_ = pattern_sql;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp127_ = _tmp126_->str;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp125_, _tmp127_);
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp128_ = sql;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp128_, ")");
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp129_ = after_where;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp129_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp130_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp131_ = _tmp130_;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3071 "tracker-sparql-pattern.c"
		} else {
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3089 "tracker-sparql-pattern.c"
		}
	}
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp131_) {
#line 3094 "tracker-sparql-pattern.c"
		GString* _tmp132_;
		gboolean first_group;
		gboolean _tmp158_ = FALSE;
		gboolean _tmp159_;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3119 "tracker-sparql-pattern.c"
			} else {
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3137 "tracker-sparql-pattern.c"
			}
		}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp132_ = sql;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp132_, " GROUP BY ");
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_group = TRUE;
#line 3146 "tracker-sparql-pattern.c"
		{
			gboolean _tmp133_;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp133_ = TRUE;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3153 "tracker-sparql-pattern.c"
				gboolean _tmp134_;
				gboolean _tmp154_;
				TrackerSparqlExpression* _tmp156_;
				GString* _tmp157_;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp134_ = _tmp133_;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp134_) {
#line 3162 "tracker-sparql-pattern.c"
					gboolean _tmp135_ = FALSE;
					gboolean _tmp136_ = FALSE;
					gboolean _tmp137_ = FALSE;
					gboolean _tmp138_ = FALSE;
					gboolean _tmp139_ = FALSE;
					gboolean _tmp140_ = FALSE;
					TrackerSparqlTokenType _tmp141_ = 0;
					gboolean _tmp143_;
					gboolean _tmp145_;
					gboolean _tmp147_;
					gboolean _tmp149_;
					gboolean _tmp151_;
					gboolean _tmp153_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp141_ != TRACKER_SPARQL_TOKEN_TYPE_HAVING) {
#line 3180 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp142_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp142_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp140_ = _tmp142_ != TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 3186 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp140_ = FALSE;
#line 3190 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp143_ = _tmp140_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp143_) {
#line 3196 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp144_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp144_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp139_ = _tmp144_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 3202 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp139_ = FALSE;
#line 3206 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp145_ = _tmp139_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp145_) {
#line 3212 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp146_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp146_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp138_ = _tmp146_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3218 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp138_ = FALSE;
#line 3222 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp147_ = _tmp138_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp147_) {
#line 3228 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp148_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp148_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = _tmp148_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3234 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = FALSE;
#line 3238 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp149_ = _tmp137_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp149_) {
#line 3244 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp150_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp150_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = _tmp150_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3250 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = FALSE;
#line 3254 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_ = _tmp136_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp151_) {
#line 3260 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp152_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp152_ = tracker_sparql_pattern_current (self);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = _tmp152_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3266 "tracker-sparql-pattern.c"
					} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = FALSE;
#line 3270 "tracker-sparql-pattern.c"
					}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp153_ = _tmp135_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp153_) {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3278 "tracker-sparql-pattern.c"
					}
				}
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp133_ = FALSE;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp154_ = first_group;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp154_) {
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_group = FALSE;
#line 3289 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp155_;
#line 378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp155_ = sql;
#line 378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp155_, ", ");
#line 3296 "tracker-sparql-pattern.c"
				}
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp156_ = self->priv->expression;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp157_ = sql;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_expression (_tmp156_, _tmp157_, &_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3322 "tracker-sparql-pattern.c"
					} else {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3340 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp158_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_HAVING, &_inner_error_);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp159_ = _tmp158_;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3367 "tracker-sparql-pattern.c"
			} else {
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3385 "tracker-sparql-pattern.c"
			}
		}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp159_) {
#line 3390 "tracker-sparql-pattern.c"
			GString* _tmp160_;
			TrackerSparqlExpression* _tmp161_;
			GString* _tmp162_;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp160_ = sql;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp160_, " HAVING ");
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp161_ = self->priv->expression;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp162_ = sql;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_expression_translate_constraint (_tmp161_, _tmp162_, &_inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3422 "tracker-sparql-pattern.c"
				} else {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3440 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp163_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp164_ = _tmp163_;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3467 "tracker-sparql-pattern.c"
		} else {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3485 "tracker-sparql-pattern.c"
		}
	}
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp164_) {
#line 3490 "tracker-sparql-pattern.c"
		GString* _tmp165_;
		gboolean first_order;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3513 "tracker-sparql-pattern.c"
			} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3531 "tracker-sparql-pattern.c"
			}
		}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp165_ = sql;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp165_, " ORDER BY ");
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_order = TRUE;
#line 3540 "tracker-sparql-pattern.c"
		{
			gboolean _tmp166_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp166_ = TRUE;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3547 "tracker-sparql-pattern.c"
				gboolean _tmp167_;
				gboolean _tmp181_;
				TrackerSparqlExpression* _tmp183_;
				GString* _tmp184_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp167_ = _tmp166_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp167_) {
#line 3556 "tracker-sparql-pattern.c"
					gboolean _tmp168_ = FALSE;
					gboolean _tmp169_ = FALSE;
					gboolean _tmp170_ = FALSE;
					gboolean _tmp171_ = FALSE;
					TrackerSparqlTokenType _tmp172_ = 0;
					gboolean _tmp174_;
					gboolean _tmp176_;
					gboolean _tmp178_;
					gboolean _tmp180_;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp172_ = tracker_sparql_pattern_current (self);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp172_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
#line 3570 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp173_ = 0;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp173_ = tracker_sparql_pattern_current (self);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp171_ = _tmp173_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3576 "tracker-sparql-pattern.c"
					} else {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp171_ = FALSE;
#line 3580 "tracker-sparql-pattern.c"
					}
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp174_ = _tmp171_;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp174_) {
#line 3586 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp175_ = 0;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp175_ = tracker_sparql_pattern_current (self);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp170_ = _tmp175_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3592 "tracker-sparql-pattern.c"
					} else {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp170_ = FALSE;
#line 3596 "tracker-sparql-pattern.c"
					}
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp176_ = _tmp170_;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp176_) {
#line 3602 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp177_ = 0;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp177_ = tracker_sparql_pattern_current (self);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp169_ = _tmp177_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3608 "tracker-sparql-pattern.c"
					} else {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp169_ = FALSE;
#line 3612 "tracker-sparql-pattern.c"
					}
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp178_ = _tmp169_;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp178_) {
#line 3618 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp179_ = 0;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp179_ = tracker_sparql_pattern_current (self);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp168_ = _tmp179_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3624 "tracker-sparql-pattern.c"
					} else {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp168_ = FALSE;
#line 3628 "tracker-sparql-pattern.c"
					}
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp180_ = _tmp168_;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp180_) {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3636 "tracker-sparql-pattern.c"
					}
				}
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp166_ = FALSE;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp181_ = first_order;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp181_) {
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_order = FALSE;
#line 3647 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp182_;
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp182_ = sql;
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp182_, ", ");
#line 3654 "tracker-sparql-pattern.c"
				}
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp183_ = self->priv->expression;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp184_ = sql;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_order_condition (_tmp183_, _tmp184_, &_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3680 "tracker-sparql-pattern.c"
					} else {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3698 "tracker-sparql-pattern.c"
					}
				}
			}
		}
	}
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	limit = -1;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offset = -1;
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp185_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp186_ = _tmp185_;
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3730 "tracker-sparql-pattern.c"
		} else {
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3748 "tracker-sparql-pattern.c"
		}
	}
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp186_) {
#line 3753 "tracker-sparql-pattern.c"
		gchar* _tmp187_ = NULL;
		gchar* _tmp188_;
		gint _tmp189_ = 0;
		gboolean _tmp190_ = FALSE;
		gboolean _tmp191_;
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3779 "tracker-sparql-pattern.c"
			} else {
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3797 "tracker-sparql-pattern.c"
			}
		}
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp187_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp188_ = _tmp187_;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp189_ = atoi (_tmp188_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		limit = _tmp189_;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp188_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp190_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp191_ = _tmp190_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3832 "tracker-sparql-pattern.c"
			} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3850 "tracker-sparql-pattern.c"
			}
		}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp191_) {
#line 3855 "tracker-sparql-pattern.c"
			gchar* _tmp192_ = NULL;
			gchar* _tmp193_;
			gint _tmp194_ = 0;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3879 "tracker-sparql-pattern.c"
				} else {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3897 "tracker-sparql-pattern.c"
				}
			}
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp192_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp193_ = _tmp192_;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp194_ = atoi (_tmp193_);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp194_;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp193_);
#line 3910 "tracker-sparql-pattern.c"
		}
	} else {
		gboolean _tmp195_ = FALSE;
		gboolean _tmp196_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp195_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp196_ = _tmp195_;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3937 "tracker-sparql-pattern.c"
			} else {
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3955 "tracker-sparql-pattern.c"
			}
		}
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp196_) {
#line 3960 "tracker-sparql-pattern.c"
			gchar* _tmp197_ = NULL;
			gchar* _tmp198_;
			gint _tmp199_ = 0;
			gboolean _tmp200_ = FALSE;
			gboolean _tmp201_;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3986 "tracker-sparql-pattern.c"
				} else {
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4004 "tracker-sparql-pattern.c"
				}
			}
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp197_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp198_ = _tmp197_;
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp199_ = atoi (_tmp198_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp199_;
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp198_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp200_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp201_ = _tmp200_;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4039 "tracker-sparql-pattern.c"
				} else {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4057 "tracker-sparql-pattern.c"
				}
			}
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp201_) {
#line 4062 "tracker-sparql-pattern.c"
				gchar* _tmp202_ = NULL;
				gchar* _tmp203_;
				gint _tmp204_ = 0;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4086 "tracker-sparql-pattern.c"
					} else {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4104 "tracker-sparql-pattern.c"
					}
				}
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp202_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp203_ = _tmp202_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp204_ = atoi (_tmp203_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				limit = _tmp204_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp203_);
#line 4117 "tracker-sparql-pattern.c"
			}
		}
	}
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp205_ = limit;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp205_ >= 0) {
#line 4125 "tracker-sparql-pattern.c"
		GString* _tmp206_;
		TrackerSparqlLiteralBinding* _tmp207_;
		TrackerSparqlLiteralBinding* binding;
		TrackerSparqlLiteralBinding* _tmp208_;
		gint _tmp209_;
		gchar* _tmp210_ = NULL;
		TrackerSparqlLiteralBinding* _tmp211_;
		TrackerSparqlQuery* _tmp212_;
		TrackerSparqlLiteralBinding* _tmp213_;
		TrackerSparqlLiteralBinding* _tmp214_;
		gint _tmp215_;
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp206_ = sql;
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp206_, " LIMIT ?");
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_ = tracker_sparql_literal_binding_new ();
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp207_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp208_ = binding;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp209_ = limit;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp210_ = g_strdup_printf ("%i", _tmp209_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp208_->literal);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp208_->literal = _tmp210_;
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = binding;
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp211_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp212_ = self->priv->query;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp213_ = binding;
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp214_ = _g_object_ref0 (_tmp213_);
#line 429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp212_->bindings = g_list_append (_tmp212_->bindings, _tmp214_);
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp215_ = offset;
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp215_ >= 0) {
#line 4171 "tracker-sparql-pattern.c"
			GString* _tmp216_;
			TrackerSparqlLiteralBinding* _tmp217_;
			TrackerSparqlLiteralBinding* _tmp218_;
			gint _tmp219_;
			gchar* _tmp220_ = NULL;
			TrackerSparqlLiteralBinding* _tmp221_;
			TrackerSparqlQuery* _tmp222_;
			TrackerSparqlLiteralBinding* _tmp223_;
			TrackerSparqlLiteralBinding* _tmp224_;
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp216_ = sql;
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp216_, " OFFSET ?");
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp217_ = tracker_sparql_literal_binding_new ();
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp217_;
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_ = binding;
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = offset;
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = g_strdup_printf ("%i", _tmp219_);
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp218_->literal);
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_->literal = _tmp220_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp221_ = binding;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp221_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp222_ = self->priv->query;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = binding;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = _g_object_ref0 (_tmp223_);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp222_->bindings = g_list_append (_tmp222_->bindings, _tmp224_);
#line 4213 "tracker-sparql-pattern.c"
		}
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 4217 "tracker-sparql-pattern.c"
	} else {
		gint _tmp225_;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp225_ = offset;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp225_ >= 0) {
#line 4224 "tracker-sparql-pattern.c"
			GString* _tmp226_;
			TrackerSparqlLiteralBinding* _tmp227_;
			TrackerSparqlLiteralBinding* binding;
			TrackerSparqlLiteralBinding* _tmp228_;
			gint _tmp229_;
			gchar* _tmp230_ = NULL;
			TrackerSparqlLiteralBinding* _tmp231_;
			TrackerSparqlQuery* _tmp232_;
			TrackerSparqlLiteralBinding* _tmp233_;
			TrackerSparqlLiteralBinding* _tmp234_;
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp226_ = sql;
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp226_, " LIMIT -1 OFFSET ?");
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp227_ = tracker_sparql_literal_binding_new ();
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp227_;
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp228_ = binding;
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp229_ = offset;
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp230_ = g_strdup_printf ("%i", _tmp229_);
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp228_->literal);
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp228_->literal = _tmp230_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp231_ = binding;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp231_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp232_ = self->priv->query;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp233_ = binding;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp234_ = _g_object_ref0 (_tmp233_);
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp232_->bindings = g_list_append (_tmp232_->bindings, _tmp234_);
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 4267 "tracker-sparql-pattern.c"
		}
	}
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp237_ = self->queries_fts_data;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp237_) {
#line 4274 "tracker-sparql-pattern.c"
		GString* _tmp238_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp238_ = self->match_str;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp236_ = _tmp238_ != NULL;
#line 4280 "tracker-sparql-pattern.c"
	} else {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp236_ = FALSE;
#line 4284 "tracker-sparql-pattern.c"
	}
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp239_ = _tmp236_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp239_) {
#line 4290 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp240_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp240_ = self->fts_subject;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp235_ = _tmp240_ != NULL;
#line 4296 "tracker-sparql-pattern.c"
	} else {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp235_ = FALSE;
#line 4300 "tracker-sparql-pattern.c"
	}
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp241_ = _tmp235_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp241_) {
#line 4306 "tracker-sparql-pattern.c"
		GString* _tmp242_;
		GString* str;
		gchar** _tmp243_;
		gint _tmp243__length1;
		GString* _tmp249_;
		GString* _tmp250_;
		GString* _tmp251_;
		const gchar* _tmp252_;
		GString* _tmp253_;
		GString* _tmp254_;
		const gchar* _tmp255_;
		gchar* _tmp256_ = NULL;
		gchar* _tmp257_;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp242_ = g_string_new ("SELECT ");
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		str = _tmp242_;
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first = TRUE;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp243_ = self->fts_variables;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp243__length1 = self->fts_variables_length1;
#line 4330 "tracker-sparql-pattern.c"
		{
			gchar** fts_var_collection = NULL;
			gint fts_var_collection_length1 = 0;
			gint _fts_var_collection_size_ = 0;
			gint fts_var_it = 0;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection = _tmp243_;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection_length1 = _tmp243__length1;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (fts_var_it = 0; fts_var_it < _tmp243__length1; fts_var_it = fts_var_it + 1) {
#line 4342 "tracker-sparql-pattern.c"
				gchar* _tmp244_;
				gchar* fts_var = NULL;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp244_ = g_strdup (fts_var_collection[fts_var_it]);
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				fts_var = _tmp244_;
#line 4349 "tracker-sparql-pattern.c"
				{
					gboolean _tmp245_;
					GString* _tmp247_;
					const gchar* _tmp248_;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp245_ = first;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp245_) {
#line 4358 "tracker-sparql-pattern.c"
						GString* _tmp246_;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp246_ = str;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp246_, ", ");
#line 4364 "tracker-sparql-pattern.c"
					} else {
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 4368 "tracker-sparql-pattern.c"
					}
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp247_ = str;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp248_ = fts_var;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp247_, _tmp248_);
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (fts_var);
#line 4378 "tracker-sparql-pattern.c"
				}
			}
		}
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp249_ = str;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp249_, " FROM fts JOIN (");
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp250_ = sql;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp251_ = str;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp252_ = _tmp251_->str;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_prepend (_tmp250_, _tmp252_);
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_ = sql;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp254_ = self->match_str;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp255_ = _tmp254_->str;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp256_ = g_strdup_printf (") AS ranks USING (docid) WHERE fts %s", _tmp255_);
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp257_ = _tmp256_;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp253_, "%s", _tmp257_);
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp257_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (str);
#line 4410 "tracker-sparql-pattern.c"
	}
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp258_ = tracker_sparql_pattern_get_context (self);
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp259_ = _tmp258_;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp260_ = _tmp259_->parent_context;
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp260_);
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp261_ = _result_;
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp262_ = type;
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp261_->type = _tmp262_;
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->match_str = NULL;
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_subject = NULL;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (where_bindings);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (old_bindings);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (pattern_sql);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 4446 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean not;
	TrackerSparqlSelectContext* _result_ = NULL;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlContext* _tmp3_;
	TrackerSparqlSelectContext* _tmp4_;
	TrackerSparqlSelectContext* _tmp5_;
	gboolean _tmp6_;
	GString* _tmp9_;
	TrackerSparqlContext* _tmp10_ = NULL;
	TrackerSparqlContext* pattern;
	TrackerSparqlContext* _tmp11_;
	GHashTable* _tmp12_;
	GList* _tmp13_ = NULL;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	GHashTable* _tmp21_;
	GList* _tmp22_ = NULL;
	GString* _tmp32_;
	TrackerSparqlContext* _tmp33_;
	TrackerSparqlContext* _tmp34_;
	TrackerSparqlContext* _tmp35_;
	GError * _inner_error_ = NULL;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	not = _tmp0_;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4491 "tracker-sparql-pattern.c"
		} else {
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4499 "tracker-sparql-pattern.c"
		}
	}
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EXISTS, &_inner_error_);
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4512 "tracker-sparql-pattern.c"
		} else {
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4520 "tracker-sparql-pattern.c"
		}
	}
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _tmp2_;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp4_;
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _result_;
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp5_);
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = not;
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp6_) {
#line 4543 "tracker-sparql-pattern.c"
		GString* _tmp7_;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = sql;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp7_, "NOT EXISTS (");
#line 4549 "tracker-sparql-pattern.c"
	} else {
		GString* _tmp8_;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = sql;
#line 489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp8_, "EXISTS (");
#line 4556 "tracker-sparql-pattern.c"
	}
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = sql;
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp9_, &_inner_error_);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp10_;
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4574 "tracker-sparql-pattern.c"
		} else {
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4584 "tracker-sparql-pattern.c"
		}
	}
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = pattern;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->var_set;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = g_hash_table_get_keys (_tmp12_);
#line 4593 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp13_;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 4601 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 4605 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp14_;
				TrackerSparqlContext* _tmp15_;
				GHashTable* _tmp16_;
				TrackerSparqlVariable* _tmp17_;
				TrackerSparqlVariable* _tmp18_;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = _tmp14_;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = _tmp15_->var_set;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = key;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp16_, _tmp18_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 4624 "tracker-sparql-pattern.c"
			}
		}
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 4629 "tracker-sparql-pattern.c"
	}
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = tracker_sparql_pattern_get_context (self);
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = _tmp19_;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _tmp20_->var_set;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_hash_table_get_keys (_tmp21_);
#line 4639 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp22_;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 4647 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 4651 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp23_;
				TrackerSparqlVariableBinding* _tmp24_;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = variable;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = _tmp23_->binding;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp24_ == NULL) {
#line 4661 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					GError* _tmp30_ = NULL;
					GError* _tmp31_;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = variable;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_variable_get_name (_tmp25_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = _tmp26_;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = g_strdup_printf ("use of undefined variable `%s'", _tmp27_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _tmp28_;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = tracker_sparql_pattern_get_error (self, _tmp29_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp31_ = _tmp30_;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp29_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp31_;
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4699 "tracker-sparql-pattern.c"
					} else {
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4713 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 4720 "tracker-sparql-pattern.c"
	}
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp32_ = sql;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp32_, ")");
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp33_ = tracker_sparql_pattern_get_context (self);
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = _tmp33_;
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = _tmp34_->parent_context;
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp35_);
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 4738 "tracker-sparql-pattern.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4761 "tracker-sparql-pattern.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 4769 "tracker-sparql-pattern.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 4781 "tracker-sparql-pattern.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 4806 "tracker-sparql-pattern.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 4812 "tracker-sparql-pattern.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 4816 "tracker-sparql-pattern.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 4822 "tracker-sparql-pattern.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 4834 "tracker-sparql-pattern.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 4844 "tracker-sparql-pattern.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 4850 "tracker-sparql-pattern.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 4864 "tracker-sparql-pattern.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 4874 "tracker-sparql-pattern.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 4880 "tracker-sparql-pattern.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 4889 "tracker-sparql-pattern.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4909 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	gboolean _vala_is_var = FALSE;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	TrackerSparqlTokenType _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_strdup ("");
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp0_;
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_is_var = FALSE;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_current (self);
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 4932 "tracker-sparql-pattern.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_is_var = TRUE;
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_next (self, &_inner_error_);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4950 "tracker-sparql-pattern.c"
			} else {
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4960 "tracker-sparql-pattern.c"
			}
		}
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_result_);
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp3_);
#line 4975 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlTokenType _tmp5_ = 0;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = tracker_sparql_pattern_current (self);
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 4982 "tracker-sparql-pattern.c"
			gchar* _tmp6_ = NULL;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4996 "tracker-sparql-pattern.c"
				} else {
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 5006 "tracker-sparql-pattern.c"
				}
			}
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_result_);
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_result_ = _tmp6_;
#line 5015 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_ = 0;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 5022 "tracker-sparql-pattern.c"
				gchar* _tmp8_ = NULL;
				gchar* ns;
				TrackerSparqlQuery* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5046 "tracker-sparql-pattern.c"
					} else {
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5056 "tracker-sparql-pattern.c"
					}
				}
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp8_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5077 "tracker-sparql-pattern.c"
					} else {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5089 "tracker-sparql-pattern.c"
					}
				}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = self->priv->query;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = ns;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp11_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp12_ = _tmp11_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = string_substring (_tmp12_, (glong) 1, (glong) (-1));
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = _tmp13_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = tracker_sparql_query_resolve_prefixed_name (_tmp9_, _tmp10_, _tmp14_, &_inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = _tmp15_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp14_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp12_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = _tmp16_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5126 "tracker-sparql-pattern.c"
					} else {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5138 "tracker-sparql-pattern.c"
					}
				}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_result_ = _tmp17_;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 5147 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp18_ = 0;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = tracker_sparql_pattern_current (self);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp18_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 5154 "tracker-sparql-pattern.c"
					TrackerSparqlQuery* _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gchar* _tmp26_;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5175 "tracker-sparql-pattern.c"
						} else {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5185 "tracker-sparql-pattern.c"
						}
					}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = self->priv->query;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = _tmp20_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp22_ = string_substring (_tmp21_, (glong) 1, (glong) (-1));
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = _tmp22_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp24_ = tracker_sparql_query_resolve_prefixed_name (_tmp19_, "", _tmp23_, &_inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = _tmp24_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp23_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp21_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = _tmp25_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5218 "tracker-sparql-pattern.c"
						} else {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5228 "tracker-sparql-pattern.c"
						}
					}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_result_ = _tmp26_;
#line 5235 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = _tmp27_;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5253 "tracker-sparql-pattern.c"
						} else {
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5263 "tracker-sparql-pattern.c"
						}
					}
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp28_) {
#line 5268 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp29_;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						gchar* _tmp34_ = NULL;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5287 "tracker-sparql-pattern.c"
							} else {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5297 "tracker-sparql-pattern.c"
							}
						}
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp29_ = self->priv->query;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp30_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = _tmp30_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = string_substring (_tmp31_, (glong) 1, (glong) (-1));
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp33_ = _tmp32_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp34_ = tracker_sparql_query_generate_bnodeid (_tmp29_, _tmp33_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_result_ = _tmp34_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp31_);
#line 5320 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp35_ = 0;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp35_ = tracker_sparql_pattern_current (self);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp35_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
#line 5327 "tracker-sparql-pattern.c"
							TrackerSparqlExpression* _tmp36_;
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp36_ = self->priv->expression;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp37_ = tracker_sparql_expression_parse_string_literal (_tmp36_, NULL, &_inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp38_ = _tmp37_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_ != NULL) {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5347 "tracker-sparql-pattern.c"
								} else {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5357 "tracker-sparql-pattern.c"
								}
							}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_result_ = _tmp38_;
#line 5364 "tracker-sparql-pattern.c"
						} else {
							TrackerSparqlTokenType _tmp39_ = 0;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp39_ = tracker_sparql_pattern_current (self);
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp39_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
#line 5371 "tracker-sparql-pattern.c"
								TrackerSparqlExpression* _tmp40_;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_;
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp40_ = self->priv->expression;
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp41_ = tracker_sparql_expression_parse_string_literal (_tmp40_, NULL, &_inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp42_ = _tmp41_;
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_ != NULL) {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_propagate_error (error, _inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5391 "tracker-sparql-pattern.c"
									} else {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_clear_error (&_inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5401 "tracker-sparql-pattern.c"
									}
								}
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_result_ = _tmp42_;
#line 5408 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlTokenType _tmp43_ = 0;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp43_ = tracker_sparql_pattern_current (self);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp43_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
#line 5415 "tracker-sparql-pattern.c"
									TrackerSparqlExpression* _tmp44_;
									gchar* _tmp45_ = NULL;
									gchar* _tmp46_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp44_ = self->priv->expression;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp45_ = tracker_sparql_expression_parse_string_literal (_tmp44_, NULL, &_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp46_ = _tmp45_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_ != NULL) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_propagate_error (error, _inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5435 "tracker-sparql-pattern.c"
										} else {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_clear_error (&_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5445 "tracker-sparql-pattern.c"
										}
									}
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_result_ = _tmp46_;
#line 5452 "tracker-sparql-pattern.c"
								} else {
									TrackerSparqlTokenType _tmp47_ = 0;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = tracker_sparql_pattern_current (self);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
#line 5459 "tracker-sparql-pattern.c"
										TrackerSparqlExpression* _tmp48_;
										gchar* _tmp49_ = NULL;
										gchar* _tmp50_;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp48_ = self->priv->expression;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp49_ = tracker_sparql_expression_parse_string_literal (_tmp48_, NULL, &_inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp50_ = _tmp49_;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_inner_error_ != NULL) {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_propagate_error (error, _inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5479 "tracker-sparql-pattern.c"
											} else {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_clear_error (&_inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5489 "tracker-sparql-pattern.c"
											}
										}
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_result_ = _tmp50_;
#line 5496 "tracker-sparql-pattern.c"
									} else {
										TrackerSparqlTokenType _tmp51_ = 0;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp51_ = tracker_sparql_pattern_current (self);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp51_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 5503 "tracker-sparql-pattern.c"
											gchar* _tmp52_ = NULL;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											tracker_sparql_pattern_next (self, &_inner_error_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_inner_error_ != NULL) {
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_propagate_error (error, _inner_error_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5517 "tracker-sparql-pattern.c"
												} else {
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_clear_error (&_inner_error_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5527 "tracker-sparql-pattern.c"
												}
											}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp52_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_result_ = _tmp52_;
#line 5536 "tracker-sparql-pattern.c"
										} else {
											TrackerSparqlTokenType _tmp53_ = 0;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp53_ = tracker_sparql_pattern_current (self);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_tmp53_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
#line 5543 "tracker-sparql-pattern.c"
												gchar* _tmp54_ = NULL;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												tracker_sparql_pattern_next (self, &_inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_inner_error_ != NULL) {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_propagate_error (error, _inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5557 "tracker-sparql-pattern.c"
													} else {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_clear_error (&_inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5567 "tracker-sparql-pattern.c"
													}
												}
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp54_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_result_ = _tmp54_;
#line 5576 "tracker-sparql-pattern.c"
											} else {
												TrackerSparqlTokenType _tmp55_ = 0;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp55_ = tracker_sparql_pattern_current (self);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
#line 5583 "tracker-sparql-pattern.c"
													gchar* _tmp56_ = NULL;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													tracker_sparql_pattern_next (self, &_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_inner_error_ != NULL) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_propagate_error (error, _inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5597 "tracker-sparql-pattern.c"
														} else {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_clear_error (&_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5607 "tracker-sparql-pattern.c"
														}
													}
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp56_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_result_ = _tmp56_;
#line 5616 "tracker-sparql-pattern.c"
												} else {
													TrackerSparqlTokenType _tmp57_ = 0;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp57_ = tracker_sparql_pattern_current (self);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_tmp57_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
#line 5623 "tracker-sparql-pattern.c"
														gchar* _tmp58_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														tracker_sparql_pattern_next (self, &_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_inner_error_ != NULL) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_propagate_error (error, _inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5637 "tracker-sparql-pattern.c"
															} else {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_clear_error (&_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5647 "tracker-sparql-pattern.c"
															}
														}
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp58_ = g_strdup ("true");
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_result_ = _tmp58_;
#line 5656 "tracker-sparql-pattern.c"
													} else {
														TrackerSparqlTokenType _tmp59_ = 0;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp59_ = tracker_sparql_pattern_current (self);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
#line 5663 "tracker-sparql-pattern.c"
															gchar* _tmp60_;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															tracker_sparql_pattern_next (self, &_inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_inner_error_ != NULL) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5677 "tracker-sparql-pattern.c"
																} else {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5687 "tracker-sparql-pattern.c"
																}
															}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp60_ = g_strdup ("false");
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_result_ = _tmp60_;
#line 5696 "tracker-sparql-pattern.c"
														} else {
															TrackerSparqlTokenType _tmp61_ = 0;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp61_ = tracker_sparql_pattern_current (self);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
#line 5703 "tracker-sparql-pattern.c"
																TrackerSparqlQuery* _tmp62_;
																gchar* _tmp63_ = NULL;
																const gchar* _tmp64_;
																gchar* _tmp65_;
																gchar* old_subject;
																gboolean _tmp66_;
																gboolean old_subject_is_var;
																const gchar* _tmp67_;
																gchar* _tmp68_;
																GString* _tmp69_;
																const gchar* _tmp70_;
																gchar* _tmp71_;
																gboolean _tmp72_;
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_next (self, &_inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_ != NULL) {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5729 "tracker-sparql-pattern.c"
																	} else {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5739 "tracker-sparql-pattern.c"
																	}
																}
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp62_ = self->priv->query;
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp63_ = tracker_sparql_query_generate_bnodeid (_tmp62_, NULL);
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_result_ = _tmp63_;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp64_ = self->priv->current_subject;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp65_ = g_strdup (_tmp64_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject = _tmp65_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp66_ = self->priv->current_subject_is_var;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject_is_var = _tmp66_;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp67_ = _result_;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp68_ = g_strdup (_tmp67_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp68_;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = TRUE;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp69_ = sql;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp69_, FALSE, &_inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_ != NULL) {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5786 "tracker-sparql-pattern.c"
																	} else {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5798 "tracker-sparql-pattern.c"
																	}
																}
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_ != NULL) {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5815 "tracker-sparql-pattern.c"
																	} else {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5827 "tracker-sparql-pattern.c"
																	}
																}
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp70_ = old_subject;
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp71_ = g_strdup (_tmp70_);
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp71_;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp72_ = old_subject_is_var;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = _tmp72_;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_vala_is_var = TRUE;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (old_subject);
#line 5846 "tracker-sparql-pattern.c"
															} else {
																GError* _tmp73_ = NULL;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp73_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_inner_error_ = _tmp73_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5861 "tracker-sparql-pattern.c"
																} else {
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5871 "tracker-sparql-pattern.c"
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (is_var) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*is_var = _vala_is_var;
#line 5894 "tracker-sparql-pattern.c"
	}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 5898 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 5910 "tracker-sparql-pattern.c"
		GString* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = sql;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = in_simple_optional;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object (self, _tmp0_, _tmp1_, &_inner_error_);
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 5929 "tracker-sparql-pattern.c"
			} else {
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 5937 "tracker-sparql-pattern.c"
			}
		}
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 5952 "tracker-sparql-pattern.c"
			} else {
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 5960 "tracker-sparql-pattern.c"
			}
		}
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_) {
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 5967 "tracker-sparql-pattern.c"
		}
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 5971 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 5984 "tracker-sparql-pattern.c"
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* old_predicate;
		gboolean _tmp2_;
		gboolean old_predicate_is_var;
		TrackerSparqlTokenType _tmp3_ = 0;
		GString* _tmp32_;
		gboolean _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = self->priv->current_predicate;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate = _tmp1_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = self->priv->current_predicate_is_var;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate_is_var = _tmp2_;
#line 594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = NULL;
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = FALSE;
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_current (self);
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 6018 "tracker-sparql-pattern.c"
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate_is_var = TRUE;
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6036 "tracker-sparql-pattern.c"
				} else {
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6046 "tracker-sparql-pattern.c"
				}
			}
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _tmp4_;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) (-1));
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (self->priv->current_predicate);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate = _tmp6_;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp5_);
#line 6061 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_ = 0;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 6068 "tracker-sparql-pattern.c"
				gchar* _tmp8_ = NULL;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6082 "tracker-sparql-pattern.c"
					} else {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6092 "tracker-sparql-pattern.c"
					}
				}
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_predicate);
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_predicate = _tmp8_;
#line 6101 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp9_ = 0;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = tracker_sparql_pattern_current (self);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 6108 "tracker-sparql-pattern.c"
					gchar* _tmp10_ = NULL;
					gchar* ns;
					TrackerSparqlQuery* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					gchar* _tmp19_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6132 "tracker-sparql-pattern.c"
						} else {
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6142 "tracker-sparql-pattern.c"
						}
					}
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					ns = _tmp10_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6163 "tracker-sparql-pattern.c"
						} else {
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6175 "tracker-sparql-pattern.c"
						}
					}
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = self->priv->query;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = ns;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = _tmp13_;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = string_substring (_tmp14_, (glong) 1, (glong) (-1));
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = _tmp15_;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = tracker_sparql_query_resolve_prefixed_name (_tmp11_, _tmp12_, _tmp16_, &_inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = _tmp17_;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp16_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp14_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = _tmp18_;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6212 "tracker-sparql-pattern.c"
						} else {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6224 "tracker-sparql-pattern.c"
						}
					}
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (self->priv->current_predicate);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->priv->current_predicate = _tmp19_;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 6233 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlTokenType _tmp20_ = 0;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = tracker_sparql_pattern_current (self);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp20_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 6240 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp21_;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						gchar* _tmp28_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_next (self, &_inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6261 "tracker-sparql-pattern.c"
							} else {
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6271 "tracker-sparql-pattern.c"
							}
						}
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp21_ = self->priv->query;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp22_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp23_ = _tmp22_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) (-1));
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp25_ = _tmp24_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp26_ = tracker_sparql_query_resolve_prefixed_name (_tmp21_, "", _tmp25_, &_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp27_ = _tmp26_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp25_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp23_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp28_ = _tmp27_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6304 "tracker-sparql-pattern.c"
							} else {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6314 "tracker-sparql-pattern.c"
							}
						}
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (self->priv->current_predicate);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->priv->current_predicate = _tmp28_;
#line 6321 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp29_ = 0;
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp29_ = tracker_sparql_pattern_current (self);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp29_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
#line 6328 "tracker-sparql-pattern.c"
							gchar* _tmp30_;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_next (self, &_inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_ != NULL) {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6342 "tracker-sparql-pattern.c"
								} else {
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6352 "tracker-sparql-pattern.c"
								}
							}
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp30_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (self->priv->current_predicate);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							self->priv->current_predicate = _tmp30_;
#line 6361 "tracker-sparql-pattern.c"
						} else {
							GError* _tmp31_ = NULL;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp31_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_inner_error_ = _tmp31_;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6376 "tracker-sparql-pattern.c"
							} else {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6386 "tracker-sparql-pattern.c"
							}
						}
					}
				}
			}
		}
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp32_ = sql;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp33_ = in_simple_optional;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object_list (self, _tmp32_, _tmp33_, &_inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6409 "tracker-sparql-pattern.c"
			} else {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6419 "tracker-sparql-pattern.c"
			}
		}
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp34_ = old_predicate;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp35_ = g_strdup (_tmp34_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = _tmp35_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp36_ = old_predicate_is_var;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = _tmp36_;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp37_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp38_ = _tmp37_;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6448 "tracker-sparql-pattern.c"
			} else {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6458 "tracker-sparql-pattern.c"
			}
		}
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp38_) {
#line 6463 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp39_ = 0;
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp39_ = tracker_sparql_pattern_current (self);
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp39_ == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 6473 "tracker-sparql-pattern.c"
			}
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (old_predicate);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 6479 "tracker-sparql-pattern.c"
		}
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (old_predicate);
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 6485 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlExpression* _tmp0_;
	GString* _tmp1_;
	GError * _inner_error_ = NULL;
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6508 "tracker-sparql-pattern.c"
		} else {
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6516 "tracker-sparql-pattern.c"
		}
	}
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->expression;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_translate_constraint (_tmp0_, _tmp1_, &_inner_error_);
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6533 "tracker-sparql-pattern.c"
		} else {
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6541 "tracker-sparql-pattern.c"
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	TrackerSparqlTokenType _tmp0_ = 0;
	gint n_parens;
	GError * _inner_error_ = NULL;
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6563 "tracker-sparql-pattern.c"
		} else {
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6571 "tracker-sparql-pattern.c"
		}
	}
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (_tmp0_) {
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6600 "tracker-sparql-pattern.c"
		{
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6612 "tracker-sparql-pattern.c"
				} else {
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6620 "tracker-sparql-pattern.c"
				}
			}
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6625 "tracker-sparql-pattern.c"
		}
		default:
		{
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6631 "tracker-sparql-pattern.c"
		}
	}
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6644 "tracker-sparql-pattern.c"
		} else {
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6652 "tracker-sparql-pattern.c"
		}
	}
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	n_parens = 1;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6659 "tracker-sparql-pattern.c"
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = n_parens;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!(_tmp1_ > 0)) {
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6669 "tracker-sparql-pattern.c"
		}
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6683 "tracker-sparql-pattern.c"
			} else {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6691 "tracker-sparql-pattern.c"
			}
		}
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_) {
#line 6696 "tracker-sparql-pattern.c"
			gint _tmp4_;
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = n_parens;
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			n_parens = _tmp4_ + 1;
#line 6702 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = _tmp5_;
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6718 "tracker-sparql-pattern.c"
				} else {
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6726 "tracker-sparql-pattern.c"
				}
			}
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp6_) {
#line 6731 "tracker-sparql-pattern.c"
				gint _tmp7_;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = n_parens;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				n_parens = _tmp7_ - 1;
#line 6737 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp8_ = 0;
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_current (self);
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 6744 "tracker-sparql-pattern.c"
					GError* _tmp9_ = NULL;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp9_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp9_;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6756 "tracker-sparql-pattern.c"
					} else {
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6764 "tracker-sparql-pattern.c"
					}
				} else {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6777 "tracker-sparql-pattern.c"
						} else {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6785 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlPatternTripleContext* _tmp3_;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GString* _tmp5_;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_get_context (self);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_pattern_triple_context_new (_tmp0_, _tmp2_);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = _tmp3_;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp4_);
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = sql;
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp5_, "SELECT ");
#line 6826 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	gssize _tmp2_;
	GString* _tmp3_;
	gboolean first;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GList* _tmp5_;
	TrackerSparqlPatternTripleContext* _tmp24_;
	GList* _tmp25_;
	TrackerSparqlPatternTripleContext* _tmp84_;
	GList* _tmp85_;
	gboolean _tmp117_;
	TrackerSparqlContext* _tmp119_;
	TrackerSparqlContext* _tmp120_;
	GHashTable* _tmp121_;
	GList* _tmp122_ = NULL;
	TrackerSparqlContext* _tmp129_;
	TrackerSparqlContext* _tmp130_;
	TrackerSparqlContext* _tmp131_;
	GError * _inner_error_ = NULL;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->len;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_truncate (_tmp0_, (gsize) (_tmp2_ - 2));
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = sql;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp3_, " FROM ");
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _tmp4_->tables;
#line 6873 "tracker-sparql-pattern.c"
	{
		GList* table_collection = NULL;
		GList* table_it = NULL;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table_collection = _tmp5_;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
#line 6881 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp6_;
			TrackerSparqlDataTable* table = NULL;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			table = _tmp6_;
#line 6888 "tracker-sparql-pattern.c"
			{
				gboolean _tmp7_;
				TrackerSparqlDataTable* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp21_;
				TrackerSparqlDataTable* _tmp22_;
				const gchar* _tmp23_;
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = first;
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp7_) {
#line 6900 "tracker-sparql-pattern.c"
					GString* _tmp8_;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp8_ = sql;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp8_, ", ");
#line 6906 "tracker-sparql-pattern.c"
				} else {
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 6910 "tracker-sparql-pattern.c"
				}
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = table;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = _tmp9_->sql_db_tablename;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp10_ != NULL) {
#line 6918 "tracker-sparql-pattern.c"
					GString* _tmp11_;
					TrackerSparqlDataTable* _tmp12_;
					const gchar* _tmp13_;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = sql;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = table;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = _tmp12_->sql_db_tablename;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp11_, "\"%s\"", _tmp13_);
#line 6930 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlDataTable* _tmp14_;
					TrackerSparqlPredicateVariable* _tmp15_;
					TrackerSparqlQuery* _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					GString* _tmp19_;
					gchar* _tmp20_;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = table;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = _tmp14_->predicate_variable;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = self->priv->query;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = tracker_sparql_predicate_variable_get_sql_query (_tmp15_, _tmp16_, &_inner_error_);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = _tmp17_;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6959 "tracker-sparql-pattern.c"
						} else {
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6969 "tracker-sparql-pattern.c"
						}
					}
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sql;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp18_;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp19_, "(%s)", _tmp20_);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp20_);
#line 6980 "tracker-sparql-pattern.c"
				}
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = sql;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = table;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = _tmp22_->sql_query_tablename;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp21_, " AS \"%s\"", _tmp23_);
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (table);
#line 6992 "tracker-sparql-pattern.c"
			}
		}
	}
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = self->priv->triple_context;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = _tmp24_->variables;
#line 7000 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp25_;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 7008 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* _tmp26_;
			TrackerSparqlVariable* variable = NULL;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp26_ = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = _tmp26_;
#line 7015 "tracker-sparql-pattern.c"
			{
				gboolean maybe_null;
				gboolean in_simple_optional;
				TrackerPropertyType last_type;
				gchar* last_name;
				TrackerSparqlPatternTripleContext* _tmp27_;
				GHashTable* _tmp28_;
				TrackerSparqlVariable* _tmp29_;
				gconstpointer _tmp30_ = NULL;
				GList* _tmp31_;
				gboolean _tmp73_ = FALSE;
				gboolean _tmp74_;
				gboolean _tmp76_;
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				maybe_null = TRUE;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				in_simple_optional = FALSE;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_name = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = self->priv->triple_context;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = _tmp27_->var_bindings;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = variable;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = ((TrackerSparqlVariableBindingList*) _tmp30_)->list;
#line 7047 "tracker-sparql-pattern.c"
				{
					GList* binding_collection = NULL;
					GList* binding_it = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_collection = _tmp31_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7055 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBinding* _tmp32_;
						TrackerSparqlVariableBinding* binding = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						binding = _tmp32_;
#line 7062 "tracker-sparql-pattern.c"
						{
							gchar* name = NULL;
							TrackerSparqlVariableBinding* _tmp33_;
							TrackerSparqlDataTable* _tmp34_;
							TrackerSparqlVariableBinding* _tmp43_;
							TrackerPropertyType _tmp44_;
							TrackerPropertyType type;
							const gchar* _tmp45_;
							const gchar* _tmp66_;
							gchar* _tmp67_;
							TrackerPropertyType _tmp68_;
							TrackerSparqlVariableBinding* _tmp69_;
							gboolean _tmp70_;
							TrackerSparqlVariableBinding* _tmp71_;
							gboolean _tmp72_;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = binding;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp34_ = ((TrackerSparqlDataBinding*) _tmp33_)->table;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp34_ != NULL) {
#line 7084 "tracker-sparql-pattern.c"
								TrackerSparqlVariableBinding* _tmp35_;
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								gchar* _tmp38_;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp35_ = binding;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp36_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp35_);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp37_ = _tmp36_;
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp38_ = g_strdup (_tmp37_);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp38_;
#line 7101 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlVariable* _tmp39_;
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								gchar* _tmp42_;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp39_ = variable;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp40_ = tracker_sparql_variable_get_sql_expression (_tmp39_);
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp41_ = _tmp40_;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp42_ = g_strdup (_tmp41_);
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp42_;
#line 7119 "tracker-sparql-pattern.c"
							}
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp43_ = binding;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp44_ = ((TrackerSparqlDataBinding*) _tmp43_)->data_type;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							type = _tmp44_;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp45_ = last_name;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp45_ != NULL) {
#line 7131 "tracker-sparql-pattern.c"
								gboolean _tmp46_;
								gboolean _tmp49_ = FALSE;
								TrackerPropertyType _tmp50_;
								gboolean _tmp52_;
								GString* _tmp57_;
								gboolean _tmp58_ = FALSE;
								TrackerPropertyType _tmp59_;
								gboolean _tmp61_;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46_ = *first_where;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (!_tmp46_) {
#line 7144 "tracker-sparql-pattern.c"
									GString* _tmp47_;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = sql;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp47_, " AND ");
#line 7150 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp48_;
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = sql;
#line 720 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp48_, " WHERE ");
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									*first_where = FALSE;
#line 7159 "tracker-sparql-pattern.c"
								}
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp50_ = last_type;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp50_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 7165 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp51_;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = type;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = _tmp51_ == TRACKER_PROPERTY_TYPE_RESOURCE;
#line 7171 "tracker-sparql-pattern.c"
								} else {
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = FALSE;
#line 7175 "tracker-sparql-pattern.c"
								}
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp52_ = _tmp49_;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp52_) {
#line 7181 "tracker-sparql-pattern.c"
									GString* _tmp53_;
									const gchar* _tmp54_;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = sql;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp54_ = last_name;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp53_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp54_);
#line 7190 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp55_;
									const gchar* _tmp56_;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp55_ = sql;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = last_name;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp55_, _tmp56_);
#line 7200 "tracker-sparql-pattern.c"
								}
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp57_ = sql;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp57_, " = ");
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp59_ = last_type;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp59_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 7210 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp60_;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = type;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = _tmp60_ == TRACKER_PROPERTY_TYPE_STRING;
#line 7216 "tracker-sparql-pattern.c"
								} else {
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = FALSE;
#line 7220 "tracker-sparql-pattern.c"
								}
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp61_ = _tmp58_;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp61_) {
#line 7226 "tracker-sparql-pattern.c"
									GString* _tmp62_;
									const gchar* _tmp63_;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = sql;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp63_ = name;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp62_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp63_);
#line 7235 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp64_;
									const gchar* _tmp65_;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp64_ = sql;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp65_ = name;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp64_, _tmp65_);
#line 7245 "tracker-sparql-pattern.c"
								}
							}
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp66_ = name;
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = g_strdup (_tmp66_);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (last_name);
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_name = _tmp67_;
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = type;
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_type = _tmp68_;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = binding;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp70_ = _tmp69_->maybe_null;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (!_tmp70_) {
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								maybe_null = FALSE;
#line 7268 "tracker-sparql-pattern.c"
							}
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp71_ = binding;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp72_ = _tmp71_->in_simple_optional;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_simple_optional = _tmp72_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (name);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 7280 "tracker-sparql-pattern.c"
						}
					}
				}
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp74_ = maybe_null;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp74_) {
#line 7288 "tracker-sparql-pattern.c"
					gboolean _tmp75_;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp75_ = in_simple_optional;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp73_ = !_tmp75_;
#line 7294 "tracker-sparql-pattern.c"
				} else {
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp73_ = FALSE;
#line 7298 "tracker-sparql-pattern.c"
				}
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp76_ = _tmp73_;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp76_) {
#line 7304 "tracker-sparql-pattern.c"
					gboolean _tmp77_;
					GString* _tmp80_;
					TrackerSparqlVariable* _tmp81_;
					const gchar* _tmp82_;
					const gchar* _tmp83_;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = *first_where;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp77_) {
#line 7314 "tracker-sparql-pattern.c"
						GString* _tmp78_;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp78_ = sql;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp78_, " AND ");
#line 7320 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp79_;
#line 752 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp79_ = sql;
#line 752 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp79_, " WHERE ");
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						*first_where = FALSE;
#line 7329 "tracker-sparql-pattern.c"
					}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = sql;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = variable;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp82_ = tracker_sparql_variable_get_sql_expression (_tmp81_);
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp83_ = _tmp82_;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp80_, "%s IS NOT NULL", _tmp83_);
#line 7341 "tracker-sparql-pattern.c"
				}
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (last_name);
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (variable);
#line 7347 "tracker-sparql-pattern.c"
			}
		}
	}
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp84_ = self->priv->triple_context;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp85_ = _tmp84_->bindings;
#line 7355 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp85_;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7363 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp86_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp86_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp86_;
#line 7370 "tracker-sparql-pattern.c"
			{
				gboolean _tmp87_;
				GString* _tmp90_;
				TrackerSparqlLiteralBinding* _tmp91_;
				const gchar* _tmp92_;
				const gchar* _tmp93_;
				TrackerSparqlLiteralBinding* _tmp94_;
				gboolean _tmp95_;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp87_ = *first_where;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp87_) {
#line 7383 "tracker-sparql-pattern.c"
					GString* _tmp88_;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = sql;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp88_, " AND ");
#line 7389 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp89_;
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = sql;
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp89_, " WHERE ");
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					*first_where = FALSE;
#line 7398 "tracker-sparql-pattern.c"
				}
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp90_ = sql;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp91_ = binding;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp92_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp91_);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp93_ = _tmp92_;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp90_, _tmp93_);
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp94_ = binding;
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp95_ = _tmp94_->is_fts_match;
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp95_) {
#line 7416 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp96_;
					const gchar* _tmp97_;
					gchar** _tmp98_;
					gchar** _tmp99_ = NULL;
					gchar** _tmp100_;
					gint _tmp100__length1;
					gchar* _tmp101_ = NULL;
					gchar* _tmp102_;
					gchar* escaped_literal;
					GString* _tmp103_;
					const gchar* _tmp104_;
					GString* _tmp105_;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = binding;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = _tmp96_->literal;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = _tmp98_ = g_strsplit (_tmp97_, "'", 0);
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = _tmp99_;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100__length1 = _vala_array_length (_tmp98_);
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = g_strjoinv ("''", _tmp100_);
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp102_ = _tmp101_;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = (_vala_array_free (_tmp100_, _tmp100__length1, (GDestroyNotify) g_free), NULL);
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					escaped_literal = _tmp102_;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp103_ = sql;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp104_ = escaped_literal;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp103_, " MATCH '%s'", _tmp104_);
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp105_ = self->match_str;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp105_ == NULL) {
#line 7457 "tracker-sparql-pattern.c"
						GString* _tmp106_;
						GString* _tmp107_;
						const gchar* _tmp108_;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp106_ = g_string_new ("");
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (self->match_str);
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->match_str = _tmp106_;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp107_ = self->match_str;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp108_ = escaped_literal;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp107_, " MATCH '%s'", _tmp108_);
#line 7473 "tracker-sparql-pattern.c"
					}
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (escaped_literal);
#line 7477 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp109_;
					TrackerSparqlLiteralBinding* _tmp110_;
					TrackerPropertyType _tmp111_;
					TrackerSparqlQuery* _tmp114_;
					TrackerSparqlLiteralBinding* _tmp115_;
					TrackerSparqlLiteralBinding* _tmp116_;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp109_ = sql;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp109_, " = ");
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp110_ = binding;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp111_ = ((TrackerSparqlDataBinding*) _tmp110_)->data_type;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp111_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 7495 "tracker-sparql-pattern.c"
						GString* _tmp112_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp112_ = sql;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp112_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 7501 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp113_;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp113_ = sql;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp113_, "?");
#line 7508 "tracker-sparql-pattern.c"
					}
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp114_ = self->priv->query;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp115_ = binding;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp116_ = _g_object_ref0 (_tmp115_);
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp114_->bindings = g_list_append (_tmp114_->bindings, _tmp116_);
#line 7518 "tracker-sparql-pattern.c"
				}
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 7522 "tracker-sparql-pattern.c"
			}
		}
	}
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp117_ = in_group_graph_pattern;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp117_) {
#line 7530 "tracker-sparql-pattern.c"
		GString* _tmp118_;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp118_ = sql;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp118_, ")");
#line 7536 "tracker-sparql-pattern.c"
	}
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp119_ = tracker_sparql_pattern_get_context (self);
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp120_ = _tmp119_;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp121_ = _tmp120_->var_set;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp122_ = g_hash_table_get_keys (_tmp121_);
#line 7546 "tracker-sparql-pattern.c"
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		v_collection = _tmp122_;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 7554 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* v = NULL;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			v = (TrackerSparqlVariable*) v_it->data;
#line 7558 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp123_;
				TrackerSparqlContext* _tmp124_;
				TrackerSparqlContext* _tmp125_;
				GHashTable* _tmp126_;
				TrackerSparqlVariable* _tmp127_;
				TrackerSparqlVariable* _tmp128_;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = tracker_sparql_pattern_get_context (self);
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = _tmp123_;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = _tmp124_->parent_context;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = _tmp125_->var_set;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = v;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp128_ = _g_object_ref0 (_tmp127_);
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp126_, _tmp128_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 7580 "tracker-sparql-pattern.c"
			}
		}
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (v_collection);
#line 7585 "tracker-sparql-pattern.c"
	}
#line 794 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 794 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = NULL;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp129_ = tracker_sparql_pattern_get_context (self);
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp130_ = _tmp129_;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp131_ = _tmp130_->parent_context;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp131_);
#line 7599 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 798 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 798 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 7611 "tracker-sparql-pattern.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		TrackerSparqlTokenType _tmp4_ = 0;
		gboolean _tmp6_;
		gboolean _tmp8_;
		gboolean _tmp10_;
		gboolean _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		gboolean _tmp19_;
		gboolean _tmp22_;
		GString* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		GString* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_current (self);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp4_ != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 7638 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp5_ = 0;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = tracker_sparql_pattern_current (self);
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = _tmp5_ != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 7644 "tracker-sparql-pattern.c"
		} else {
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = FALSE;
#line 7648 "tracker-sparql-pattern.c"
		}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = _tmp3_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp6_) {
#line 7654 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp7_ = 0;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = _tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 7660 "tracker-sparql-pattern.c"
		} else {
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = FALSE;
#line 7664 "tracker-sparql-pattern.c"
		}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _tmp2_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp8_) {
#line 7670 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp9_ = 0;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = tracker_sparql_pattern_current (self);
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = _tmp9_ != TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 7676 "tracker-sparql-pattern.c"
		} else {
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = FALSE;
#line 7680 "tracker-sparql-pattern.c"
		}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = _tmp1_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp10_) {
#line 7686 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp11_ = 0;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = tracker_sparql_pattern_current (self);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = _tmp11_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 7692 "tracker-sparql-pattern.c"
		} else {
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = FALSE;
#line 7696 "tracker-sparql-pattern.c"
		}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _tmp0_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp12_) {
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 7704 "tracker-sparql-pattern.c"
		}
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = *in_triples_block;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp15_) {
#line 7710 "tracker-sparql-pattern.c"
			gboolean _tmp16_;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = *in_group_graph_pattern;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = !_tmp16_;
#line 7716 "tracker-sparql-pattern.c"
		} else {
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = FALSE;
#line 7720 "tracker-sparql-pattern.c"
		}
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = _tmp14_;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp17_) {
#line 7726 "tracker-sparql-pattern.c"
			gboolean _tmp18_;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp18_ = found_simple_optional;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp18_;
#line 7732 "tracker-sparql-pattern.c"
		} else {
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = FALSE;
#line 7736 "tracker-sparql-pattern.c"
		}
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp13_;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp19_) {
#line 7742 "tracker-sparql-pattern.c"
			GString* _tmp20_;
			gboolean _tmp21_;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp20_ = sql;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = *in_group_graph_pattern;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp20_, first_where, _tmp21_, &_inner_error_);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 7759 "tracker-sparql-pattern.c"
				} else {
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 7767 "tracker-sparql-pattern.c"
				}
			}
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = FALSE;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_group_graph_pattern = TRUE;
#line 7774 "tracker-sparql-pattern.c"
		}
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = *in_triples_block;
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp22_) {
#line 7780 "tracker-sparql-pattern.c"
			gboolean _tmp23_;
			GString* _tmp27_;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp23_ = *in_group_graph_pattern;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp23_) {
#line 7787 "tracker-sparql-pattern.c"
				GString* _tmp24_;
				glong _tmp25_;
				GString* _tmp26_;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = sql;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = group_graph_pattern_start;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp24_, (gssize) _tmp25_, "SELECT * FROM (");
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = sql;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp26_, ") NATURAL INNER JOIN (");
#line 7801 "tracker-sparql-pattern.c"
			}
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = TRUE;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*first_where = TRUE;
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = sql;
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_start_triples_block (self, _tmp27_, &_inner_error_);
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 7819 "tracker-sparql-pattern.c"
				} else {
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 7827 "tracker-sparql-pattern.c"
				}
			}
		}
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = sql;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp30_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp28_, &_tmp29_, &_inner_error_);
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject_is_var = _tmp29_;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp31_ = _tmp30_;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7847 "tracker-sparql-pattern.c"
			} else {
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7855 "tracker-sparql-pattern.c"
			}
		}
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_subject);
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject = _tmp31_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp32_ = sql;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp32_, FALSE, &_inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7874 "tracker-sparql-pattern.c"
			} else {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7882 "tracker-sparql-pattern.c"
			}
		}
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp33_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp34_ = _tmp33_;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7897 "tracker-sparql-pattern.c"
			} else {
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 7905 "tracker-sparql-pattern.c"
			}
		}
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp34_) {
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 7912 "tracker-sparql-pattern.c"
		}
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	TrackerClass* _tmp0_;
	TrackerClass* _tmp1_;
	TrackerClass* _tmp2_;
	TrackerClass** _tmp3_;
	TrackerClass** _tmp4_ = NULL;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class1 != NULL, FALSE);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class2 != NULL, FALSE);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = class1;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = class2;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == _tmp1_) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = TRUE;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 7941 "tracker-sparql-pattern.c"
	}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = class1;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = _tmp3_ = tracker_class_get_super_classes (_tmp2_);
#line 7947 "tracker-sparql-pattern.c"
	{
		TrackerClass** superclass_collection = NULL;
		gint superclass_collection_length1 = 0;
		gint _superclass_collection_size_ = 0;
		gint superclass_it = 0;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection = _tmp4_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection_length1 = _vala_array_length (_tmp3_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp3_); superclass_it = superclass_it + 1) {
#line 7959 "tracker-sparql-pattern.c"
			TrackerClass* _tmp5_;
			TrackerClass* superclass = NULL;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _g_object_ref0 (superclass_collection[superclass_it]);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			superclass = _tmp5_;
#line 7966 "tracker-sparql-pattern.c"
			{
				TrackerClass* _tmp6_;
				TrackerClass* _tmp7_;
				gboolean _tmp8_ = FALSE;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = superclass;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = class2;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_is_subclass (self, _tmp6_, _tmp7_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_) {
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = TRUE;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (superclass);
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 7985 "tracker-sparql-pattern.c"
				}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (superclass);
#line 7989 "tracker-sparql-pattern.c"
			}
		}
	}
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = FALSE;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 7997 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation optional_start;
	GError * _inner_error_ = NULL;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp0_);
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	optional_start = _tmp0_;
#line 8012 "tracker-sparql-pattern.c"
	{
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		TrackerSparqlVariable* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariable* left_variable;
		TrackerSparqlContext* _tmp15_;
		TrackerSparqlContext* _tmp16_;
		GHashTable* _tmp17_;
		TrackerSparqlVariable* _tmp18_;
		gconstpointer _tmp19_ = NULL;
		gint left_variable_state;
		gchar* predicate = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
		const gchar* _tmp52_;
		TrackerProperty* _tmp53_ = NULL;
		TrackerProperty* _tmp54_;
		TrackerProperty* prop;
		TrackerProperty* _tmp55_;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_;
		TrackerSparqlContext* _tmp61_;
		TrackerSparqlContext* _tmp62_;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_;
		TrackerSparqlVariable* _tmp67_ = NULL;
		TrackerSparqlVariable* _tmp68_;
		TrackerSparqlVariable* _tmp69_;
		TrackerSparqlVariable* right_variable;
		TrackerSparqlContext* _tmp70_;
		TrackerSparqlContext* _tmp71_;
		GHashTable* _tmp72_;
		TrackerSparqlVariable* _tmp73_;
		gconstpointer _tmp74_ = NULL;
		gint right_variable_state;
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_ = FALSE;
		gint _tmp82_;
		gboolean _tmp86_;
		gboolean _tmp88_;
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8071 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp1_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp1_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp1_);
#line 8080 "tracker-sparql-pattern.c"
			}
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8088 "tracker-sparql-pattern.c"
		}
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8098 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp4_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp4_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp4_);
#line 8107 "tracker-sparql-pattern.c"
			}
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8115 "tracker-sparql-pattern.c"
		}
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp3_) {
#line 863 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 8121 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp5_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp5_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp5_);
#line 8128 "tracker-sparql-pattern.c"
			}
#line 863 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8132 "tracker-sparql-pattern.c"
		}
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = tracker_sparql_context_get_variable (_tmp7_, _tmp11_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = _tmp13_;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp9_);
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable = _tmp14_;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = tracker_sparql_pattern_get_context (self);
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = _tmp16_->var_set;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = left_variable;
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable_state = (gint) ((gintptr) _tmp19_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = _tmp20_;
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8182 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8189 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp22_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp22_);
#line 8196 "tracker-sparql-pattern.c"
			}
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8204 "tracker-sparql-pattern.c"
		}
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp21_) {
#line 8208 "tracker-sparql-pattern.c"
			gchar* _tmp23_ = NULL;
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp23_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			predicate = _tmp23_;
#line 8216 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp24_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp25_ = _tmp24_;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8232 "tracker-sparql-pattern.c"
					goto __catch1_tracker_sparql_error;
				}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 8239 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp26_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp26_);
#line 8246 "tracker-sparql-pattern.c"
				}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return FALSE;
#line 8254 "tracker-sparql-pattern.c"
			}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp25_) {
#line 8258 "tracker-sparql-pattern.c"
				gchar* _tmp27_ = NULL;
				gchar* ns;
				TrackerSparqlQuery* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				gchar* _tmp37_;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp27_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8286 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8295 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp28_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp28_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp28_);
#line 8302 "tracker-sparql-pattern.c"
					}
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return FALSE;
#line 8310 "tracker-sparql-pattern.c"
				}
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = self->priv->query;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = ns;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _tmp31_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = string_substring (_tmp32_, (glong) 1, (glong) (-1));
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = _tmp33_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = tracker_sparql_query_resolve_prefixed_name (_tmp29_, _tmp30_, _tmp34_, &_inner_error_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = _tmp35_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp34_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp32_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp36_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8344 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8353 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp38_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp38_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp38_);
#line 8360 "tracker-sparql-pattern.c"
					}
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return FALSE;
#line 8368 "tracker-sparql-pattern.c"
				}
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				predicate = _tmp37_;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 8376 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8392 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8399 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp41_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp41_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp41_);
#line 8406 "tracker-sparql-pattern.c"
					}
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return FALSE;
#line 8414 "tracker-sparql-pattern.c"
				}
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp40_) {
#line 8418 "tracker-sparql-pattern.c"
					TrackerSparqlQuery* _tmp42_;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_;
					gchar* _tmp49_;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = self->priv->query;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = _tmp43_;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = string_substring (_tmp44_, (glong) 1, (glong) (-1));
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = _tmp45_;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = tracker_sparql_query_resolve_prefixed_name (_tmp42_, "", _tmp46_, &_inner_error_);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = _tmp47_;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp46_);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp44_);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp49_ = _tmp48_;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8455 "tracker-sparql-pattern.c"
							goto __catch1_tracker_sparql_error;
						}
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 8462 "tracker-sparql-pattern.c"
						{
							TrackerSourceLocation _tmp50_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp50_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_set_location (self, &_tmp50_);
#line 8469 "tracker-sparql-pattern.c"
						}
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return FALSE;
#line 8477 "tracker-sparql-pattern.c"
					}
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					predicate = _tmp49_;
#line 8483 "tracker-sparql-pattern.c"
				} else {
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = FALSE;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8491 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp51_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp51_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp51_);
#line 8498 "tracker-sparql-pattern.c"
					}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 8502 "tracker-sparql-pattern.c"
				}
			}
		}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp52_ = predicate;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp53_ = tracker_ontologies_get_property_by_uri (_tmp52_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp54_ = _g_object_ref0 (_tmp53_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp54_;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp55_ = prop;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp55_ == NULL) {
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8526 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp56_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp56_);
#line 8533 "tracker-sparql-pattern.c"
			}
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8537 "tracker-sparql-pattern.c"
		}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp58_ = _tmp57_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8553 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8562 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp59_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp59_);
#line 8569 "tracker-sparql-pattern.c"
			}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8577 "tracker-sparql-pattern.c"
		}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp58_) {
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8589 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp60_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp60_);
#line 8596 "tracker-sparql-pattern.c"
			}
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8600 "tracker-sparql-pattern.c"
		}
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp61_ = tracker_sparql_pattern_get_context (self);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp62_ = _tmp61_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp63_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp64_ = _tmp63_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp65_ = string_substring (_tmp64_, (glong) 1, (glong) (-1));
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp66_ = _tmp65_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp67_ = tracker_sparql_context_get_variable (_tmp62_, _tmp66_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp68_ = _g_object_ref0 (_tmp67_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp69_ = _tmp68_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp66_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp64_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable = _tmp69_;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp70_ = tracker_sparql_pattern_get_context (self);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp71_ = _tmp70_;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = _tmp71_->var_set;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp73_ = right_variable;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp74_ = g_hash_table_lookup (_tmp72_, _tmp73_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable_state = (gint) ((gintptr) _tmp74_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8652 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8663 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp75_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp75_);
#line 8670 "tracker-sparql-pattern.c"
			}
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8678 "tracker-sparql-pattern.c"
		}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp76_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp77_ = _tmp76_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8696 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8707 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp78_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp78_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp78_);
#line 8714 "tracker-sparql-pattern.c"
			}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return FALSE;
#line 8722 "tracker-sparql-pattern.c"
		}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp77_) {
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8736 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp79_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp79_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp79_);
#line 8743 "tracker-sparql-pattern.c"
			}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8747 "tracker-sparql-pattern.c"
		}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp82_ = left_variable_state;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp82_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 8753 "tracker-sparql-pattern.c"
			TrackerProperty* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp83_ = prop;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp84_ = tracker_property_get_multiple_values (_tmp83_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp85_ = _tmp84_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp81_ = !_tmp85_;
#line 8765 "tracker-sparql-pattern.c"
		} else {
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp81_ = FALSE;
#line 8769 "tracker-sparql-pattern.c"
		}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp86_ = _tmp81_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp86_) {
#line 8775 "tracker-sparql-pattern.c"
			gint _tmp87_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp87_ = right_variable_state;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp80_ = _tmp87_ == 0;
#line 8781 "tracker-sparql-pattern.c"
		} else {
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp80_ = FALSE;
#line 8785 "tracker-sparql-pattern.c"
		}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp88_ = _tmp80_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp88_) {
#line 8791 "tracker-sparql-pattern.c"
			gboolean in_domain;
			TrackerSparqlPatternTripleContext* _tmp89_;
			GHashTable* _tmp90_;
			TrackerSparqlVariable* _tmp91_;
			gconstpointer _tmp92_ = NULL;
			GList* _tmp93_;
			gboolean _tmp105_;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_domain = FALSE;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp89_ = self->priv->triple_context;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp90_ = _tmp89_->var_bindings;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp91_ = left_variable;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp92_ = g_hash_table_lookup (_tmp90_, _tmp91_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp93_ = ((TrackerSparqlVariableBindingList*) _tmp92_)->list;
#line 8811 "tracker-sparql-pattern.c"
			{
				GList* binding_collection = NULL;
				GList* binding_it = NULL;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_collection = _tmp93_;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 8819 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp94_;
					TrackerSparqlVariableBinding* binding = NULL;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp94_;
#line 8826 "tracker-sparql-pattern.c"
					{
						gboolean _tmp95_ = FALSE;
						TrackerSparqlVariableBinding* _tmp96_;
						TrackerClass* _tmp97_;
						gboolean _tmp104_;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp96_ = binding;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp97_ = _tmp96_->type;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp97_ != NULL) {
#line 8838 "tracker-sparql-pattern.c"
							TrackerSparqlVariableBinding* _tmp98_;
							TrackerClass* _tmp99_;
							TrackerProperty* _tmp100_;
							TrackerClass* _tmp101_;
							TrackerClass* _tmp102_;
							gboolean _tmp103_ = FALSE;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp98_ = binding;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp99_ = _tmp98_->type;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp100_ = prop;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp101_ = tracker_property_get_domain (_tmp100_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp102_ = _tmp101_;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp103_ = tracker_sparql_pattern_is_subclass (self, _tmp99_, _tmp102_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp95_ = _tmp103_;
#line 8859 "tracker-sparql-pattern.c"
						} else {
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp95_ = FALSE;
#line 8863 "tracker-sparql-pattern.c"
						}
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp104_ = _tmp95_;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp104_) {
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_domain = TRUE;
#line 906 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 906 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 8875 "tracker-sparql-pattern.c"
						}
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (binding);
#line 8879 "tracker-sparql-pattern.c"
					}
				}
			}
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp105_ = in_domain;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp105_) {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 8897 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp106_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp106_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp106_);
#line 8904 "tracker-sparql-pattern.c"
				}
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 8908 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp107_ = FALSE;
			gboolean _tmp108_ = FALSE;
			gint _tmp109_;
			gboolean _tmp113_;
			gboolean _tmp115_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp109_ = left_variable_state;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp109_ == 0) {
#line 8920 "tracker-sparql-pattern.c"
				TrackerProperty* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp110_ = prop;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp111_ = tracker_property_get_is_inverse_functional_property (_tmp110_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp112_ = _tmp111_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp108_ = _tmp112_;
#line 8932 "tracker-sparql-pattern.c"
			} else {
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp108_ = FALSE;
#line 8936 "tracker-sparql-pattern.c"
			}
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp113_ = _tmp108_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp113_) {
#line 8942 "tracker-sparql-pattern.c"
				gint _tmp114_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp114_ = right_variable_state;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp107_ = _tmp114_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 8948 "tracker-sparql-pattern.c"
			} else {
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp107_ = FALSE;
#line 8952 "tracker-sparql-pattern.c"
			}
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp115_ = _tmp107_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp115_) {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 8968 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp116_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp116_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp116_);
#line 8975 "tracker-sparql-pattern.c"
				}
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 8979 "tracker-sparql-pattern.c"
			}
		}
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (right_variable);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (predicate);
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (left_variable);
#line 8992 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp117_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp117_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp117_);
#line 8999 "tracker-sparql-pattern.c"
		}
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9003 "tracker-sparql-pattern.c"
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e = NULL;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 9017 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp118_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp118_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp118_);
#line 9024 "tracker-sparql-pattern.c"
		}
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9028 "tracker-sparql-pattern.c"
	}
	__finally1:
	{
		TrackerSourceLocation _tmp119_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp119_ = optional_start;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp119_);
#line 9037 "tracker-sparql-pattern.c"
	}
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_clear_error (&_inner_error_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return FALSE;
#line 9045 "tracker-sparql-pattern.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 9052 "tracker-sparql-pattern.c"
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash (key);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9061 "tracker-sparql-pattern.c"
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal (a, b);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9070 "tracker-sparql-pattern.c"
}


static void _vala_array_add8 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value) {
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSourceLocation, *array, *size);
#line 9081 "tracker-sparql-pattern.c"
	}
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = *value;
#line 9085 "tracker-sparql-pattern.c"
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlContext* _tmp18_;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	TrackerSparqlContext* _result_;
	TrackerSparqlContext* _tmp21_;
	TrackerSourceLocation* _tmp22_ = NULL;
	TrackerSourceLocation* filters;
	gint filters_length1;
	gint _filters_size_;
	gboolean in_triples_block;
	gboolean in_group_graph_pattern;
	gboolean first_where;
	gboolean found_simple_optional;
	GString* _tmp23_;
	gssize _tmp24_;
	glong group_graph_pattern_start;
	GString* _tmp25_;
	glong _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp278_ = FALSE;
	gboolean _tmp279_;
	gboolean _tmp281_;
	gboolean _tmp286_;
	TrackerSourceLocation* _tmp287_;
	gint _tmp287__length1;
	TrackerSparqlContext* _tmp296_;
	TrackerSparqlContext* _tmp297_;
	TrackerSparqlContext* _tmp298_;
	GError * _inner_error_ = NULL;
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9136 "tracker-sparql-pattern.c"
		} else {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9144 "tracker-sparql-pattern.c"
		}
	}
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 9151 "tracker-sparql-pattern.c"
		GString* _tmp1_;
		TrackerSparqlSelectContext* _tmp2_ = NULL;
		TrackerSparqlSelectContext* _result_;
		TrackerSparqlSelectContext* _tmp3_;
		TrackerSparqlContext* _tmp4_;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		GDestroyNotify _tmp12_;
		GHashTable* _tmp13_;
		TrackerSparqlContext* _tmp14_;
		TrackerSparqlContext* _tmp15_;
		TrackerSparqlContext* _tmp16_;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = sql;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_translate_select (self, _tmp1_, TRUE, FALSE, &_inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp2_;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9183 "tracker-sparql-pattern.c"
			} else {
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9191 "tracker-sparql-pattern.c"
			}
		}
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _result_;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp3_);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_get_context (self);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _tmp7_->select_var_set;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _g_hash_table_ref0 (_tmp8_);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp5_->var_set);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_->var_set = _tmp9_;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_context (self);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = g_object_unref;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp12_, NULL);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp11_->select_var_set);
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->select_var_set = _tmp13_;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9238 "tracker-sparql-pattern.c"
			} else {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9248 "tracker-sparql-pattern.c"
			}
		}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _tmp14_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_->parent_context;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, _tmp16_);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = (TrackerSparqlContext*) _result_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9263 "tracker-sparql-pattern.c"
	}
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp17_ = self->priv->query;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp18_ = tracker_sparql_pattern_get_context (self);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = _tmp18_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = tracker_sparql_context_new (_tmp17_, _tmp19_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp20_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _result_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp21_);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_new0 (TrackerSourceLocation, 0);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = _tmp22_;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters_length1 = 0;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_filters_size_ = filters_length1;
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_triples_block = FALSE;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_group_graph_pattern = FALSE;
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first_where = TRUE;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	found_simple_optional = FALSE;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = sql;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = _tmp23_->len;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	group_graph_pattern_start = (glong) _tmp24_;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = sql;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = group_graph_pattern_start;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = found_simple_optional;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parse_triples (self, _tmp25_, _tmp26_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp27_, &_inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9321 "tracker-sparql-pattern.c"
		} else {
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9333 "tracker-sparql-pattern.c"
		}
	}
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 9338 "tracker-sparql-pattern.c"
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		GString* _tmp275_;
		glong _tmp276_;
		gboolean _tmp277_;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = _tmp28_;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9360 "tracker-sparql-pattern.c"
			} else {
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9372 "tracker-sparql-pattern.c"
			}
		}
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp29_) {
#line 9377 "tracker-sparql-pattern.c"
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_;
			gboolean _tmp33_;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = in_group_graph_pattern;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp31_) {
#line 9385 "tracker-sparql-pattern.c"
				gboolean _tmp32_ = FALSE;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = tracker_sparql_pattern_is_simple_optional (self);
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp32_;
#line 9391 "tracker-sparql-pattern.c"
			} else {
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = FALSE;
#line 9395 "tracker-sparql-pattern.c"
			}
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = _tmp30_;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp33_) {
#line 9401 "tracker-sparql-pattern.c"
				GString* _tmp34_;
				gboolean _tmp35_ = FALSE;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_;
				GString* _tmp38_;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				found_simple_optional = TRUE;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9423 "tracker-sparql-pattern.c"
					} else {
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9435 "tracker-sparql-pattern.c"
					}
				}
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = sql;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp34_, &_tmp35_, &_inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject_is_var = _tmp35_;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp36_;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9458 "tracker-sparql-pattern.c"
					} else {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9470 "tracker-sparql-pattern.c"
					}
				}
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_subject);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject = _tmp37_;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = sql;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp38_, TRUE, &_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9493 "tracker-sparql-pattern.c"
					} else {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9505 "tracker-sparql-pattern.c"
					}
				}
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9522 "tracker-sparql-pattern.c"
					} else {
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9534 "tracker-sparql-pattern.c"
					}
				}
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9551 "tracker-sparql-pattern.c"
					} else {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9563 "tracker-sparql-pattern.c"
					}
				}
			} else {
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
				gboolean _tmp42_;
				gboolean _tmp47_;
				GString* _tmp48_;
				GString* select;
				gint _tmp49_;
				gint _tmp50_;
				gint left_index;
				gint _tmp51_;
				gint _tmp52_;
				gint right_index;
				GString* _tmp53_;
				gint _tmp54_;
				GString* _tmp55_;
				TrackerSparqlContext* _tmp56_ = NULL;
				TrackerSparqlContext* _tmp57_;
				TrackerSparqlContext* _tmp58_;
				GString* _tmp59_;
				gint _tmp60_;
				gboolean first;
				gboolean first_common;
				TrackerSparqlContext* _tmp61_;
				TrackerSparqlContext* _tmp62_;
				GHashTable* _tmp63_;
				GList* _tmp64_ = NULL;
				TrackerSparqlContext* _tmp182_;
				TrackerSparqlContext* _tmp183_;
				TrackerSparqlContext* _tmp184_;
				GHashTable* _tmp185_;
				GList* _tmp186_ = NULL;
				gboolean _tmp212_;
				TrackerSparqlContext* _tmp214_;
				TrackerSparqlContext* _tmp215_;
				TrackerSparqlContext* _tmp216_;
				GString* _tmp217_;
				GString* _tmp218_;
				glong _tmp219_;
				GString* _tmp220_;
				const gchar* _tmp221_;
				GString* _tmp222_;
				glong _tmp223_;
				GString* _tmp224_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = in_triples_block;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp40_) {
#line 9614 "tracker-sparql-pattern.c"
					gboolean _tmp41_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = in_group_graph_pattern;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = !_tmp41_;
#line 9620 "tracker-sparql-pattern.c"
				} else {
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = FALSE;
#line 9624 "tracker-sparql-pattern.c"
				}
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = _tmp39_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp42_) {
#line 9630 "tracker-sparql-pattern.c"
					GString* _tmp43_;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = sql;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp43_, "SELECT 1");
#line 9636 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp44_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = in_triples_block;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp44_) {
#line 9643 "tracker-sparql-pattern.c"
						GString* _tmp45_;
						gboolean _tmp46_;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp45_ = sql;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp46_ = in_group_graph_pattern;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp45_, &first_where, _tmp46_, &_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 9664 "tracker-sparql-pattern.c"
							} else {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 9676 "tracker-sparql-pattern.c"
							}
						}
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 9681 "tracker-sparql-pattern.c"
					}
				}
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp47_ = in_group_graph_pattern;
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp47_) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 9690 "tracker-sparql-pattern.c"
				}
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp48_ = g_string_new ("SELECT ");
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				select = _tmp48_;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp49_ = self->priv->next_table_index;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp49_ + 1;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp50_ = self->priv->next_table_index;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				left_index = _tmp50_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp51_ = self->priv->next_table_index;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp51_ + 1;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp52_ = self->priv->next_table_index;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				right_index = _tmp52_;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp53_ = sql;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp54_ = left_index;
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp53_, ") AS t%d_g LEFT JOIN (", _tmp54_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp55_ = sql;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp55_, &_inner_error_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = _tmp56_;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9738 "tracker-sparql-pattern.c"
					} else {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 9752 "tracker-sparql-pattern.c"
					}
				}
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = _tmp57_;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp58_);
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_tmp58_);
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = sql;
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = right_index;
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp59_, ") AS t%d_g", _tmp60_);
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first_common = TRUE;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = tracker_sparql_pattern_get_context (self);
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp62_ = _tmp61_;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp63_ = _tmp62_->var_set;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp64_ = g_hash_table_get_keys (_tmp63_);
#line 9779 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp64_;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 9787 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 9791 "tracker-sparql-pattern.c"
						{
							gboolean _tmp65_;
							TrackerSparqlContext* _tmp67_;
							TrackerSparqlContext* _tmp68_;
							TrackerSparqlContext* _tmp69_;
							GHashTable* _tmp70_;
							TrackerSparqlVariable* _tmp71_;
							gconstpointer _tmp72_ = NULL;
							gint old_state;
							gint _tmp73_;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp65_ = first;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp65_) {
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								first = FALSE;
#line 9808 "tracker-sparql-pattern.c"
							} else {
								GString* _tmp66_;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp66_ = select;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp66_, ", ");
#line 9815 "tracker-sparql-pattern.c"
							}
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = tracker_sparql_pattern_get_context (self);
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = _tmp67_;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = _tmp68_->parent_context;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp70_ = _tmp69_->var_set;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp71_ = v;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp72_ = g_hash_table_lookup (_tmp70_, _tmp71_);
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							old_state = (gint) ((gintptr) _tmp72_);
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp73_ = old_state;
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp73_ == 0) {
#line 9835 "tracker-sparql-pattern.c"
								TrackerSparqlContext* _tmp74_;
								TrackerSparqlContext* _tmp75_;
								TrackerSparqlContext* _tmp76_;
								GHashTable* _tmp77_;
								TrackerSparqlVariable* _tmp78_;
								TrackerSparqlVariable* _tmp79_;
								GString* _tmp80_;
								gint _tmp81_;
								TrackerSparqlVariable* _tmp82_;
								const gchar* _tmp83_;
								const gchar* _tmp84_;
								TrackerSparqlVariable* _tmp85_;
								TrackerSparqlVariableBinding* _tmp86_;
								TrackerPropertyType _tmp87_;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp74_ = tracker_sparql_pattern_get_context (self);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp75_ = _tmp74_;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp76_ = _tmp75_->parent_context;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp77_ = _tmp76_->var_set;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp78_ = v;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp79_ = _g_object_ref0 (_tmp78_);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_hash_table_insert (_tmp77_, _tmp79_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp80_ = select;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp81_ = right_index;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp82_ = v;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp83_ = tracker_sparql_variable_get_sql_expression (_tmp82_);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp84_ = _tmp83_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp80_, "t%d_g.%s", _tmp81_, _tmp84_);
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp85_ = v;
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp86_ = _tmp85_->binding;
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp87_ = ((TrackerSparqlDataBinding*) _tmp86_)->data_type;
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp87_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 9884 "tracker-sparql-pattern.c"
									GString* _tmp88_;
									gint _tmp89_;
									TrackerSparqlVariable* _tmp90_;
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_;
									GString* _tmp93_;
									gint _tmp94_;
									TrackerSparqlVariable* _tmp95_;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp88_ = select;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp89_ = right_index;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp90_ = v;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp91_ = tracker_sparql_variable_get_extra_sql_expression (_tmp90_, "localDate");
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp92_ = _tmp91_;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp88_, ", t%d_g.%s", _tmp89_, _tmp92_);
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp92_);
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp93_ = select;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp94_ = right_index;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp95_ = v;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp96_ = tracker_sparql_variable_get_extra_sql_expression (_tmp95_, "localTime");
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp97_ = _tmp96_;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp93_, ", t%d_g.%s", _tmp94_, _tmp97_);
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp97_);
#line 9923 "tracker-sparql-pattern.c"
								}
							} else {
								gboolean _tmp98_;
								gint _tmp101_;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp98_ = first_common;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp98_) {
#line 9932 "tracker-sparql-pattern.c"
									GString* _tmp99_;
#line 1018 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp99_ = sql;
#line 1018 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp99_, " ON ");
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first_common = FALSE;
#line 9940 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp100_;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp100_ = sql;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp100_, " AND ");
#line 9947 "tracker-sparql-pattern.c"
								}
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp101_ = old_state;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp101_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 9953 "tracker-sparql-pattern.c"
									GString* _tmp102_;
									gint _tmp103_;
									TrackerSparqlVariable* _tmp104_;
									const gchar* _tmp105_;
									const gchar* _tmp106_;
									gint _tmp107_;
									TrackerSparqlVariable* _tmp108_;
									const gchar* _tmp109_;
									const gchar* _tmp110_;
									GString* _tmp111_;
									gint _tmp112_;
									TrackerSparqlVariable* _tmp113_;
									const gchar* _tmp114_;
									const gchar* _tmp115_;
									TrackerSparqlVariable* _tmp116_;
									TrackerSparqlVariableBinding* _tmp117_;
									TrackerPropertyType _tmp118_;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp102_ = sql;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp103_ = left_index;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp104_ = v;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp105_ = tracker_sparql_variable_get_sql_expression (_tmp104_);
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp106_ = _tmp105_;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp107_ = right_index;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp108_ = v;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp109_ = tracker_sparql_variable_get_sql_expression (_tmp108_);
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp110_ = _tmp109_;
#line 1026 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp102_, "t%d_g.%s = t%d_g.%s", _tmp103_, _tmp106_, _tmp107_, _tmp110_);
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp111_ = select;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp112_ = left_index;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp113_ = v;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp114_ = tracker_sparql_variable_get_sql_expression (_tmp113_);
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp115_ = _tmp114_;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp111_, "t%d_g.%s", _tmp112_, _tmp115_);
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp116_ = v;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp117_ = _tmp116_->binding;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp118_ = ((TrackerSparqlDataBinding*) _tmp117_)->data_type;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp118_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10011 "tracker-sparql-pattern.c"
										GString* _tmp119_;
										gint _tmp120_;
										TrackerSparqlVariable* _tmp121_;
										gchar* _tmp122_ = NULL;
										gchar* _tmp123_;
										GString* _tmp124_;
										gint _tmp125_;
										TrackerSparqlVariable* _tmp126_;
										gchar* _tmp127_ = NULL;
										gchar* _tmp128_;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp119_ = select;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp120_ = left_index;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp121_ = v;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp122_ = tracker_sparql_variable_get_extra_sql_expression (_tmp121_, "localDate");
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp123_ = _tmp122_;
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp119_, ", t%d_g.%s", _tmp120_, _tmp123_);
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp123_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp124_ = select;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp125_ = left_index;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp126_ = v;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp127_ = tracker_sparql_variable_get_extra_sql_expression (_tmp126_, "localTime");
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp128_ = _tmp127_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp124_, ", t%d_g.%s", _tmp125_, _tmp128_);
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp128_);
#line 10050 "tracker-sparql-pattern.c"
									}
								} else {
									gint _tmp129_;
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp129_ = old_state;
#line 1033 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp129_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)) {
#line 10058 "tracker-sparql-pattern.c"
										GString* _tmp130_;
										gint _tmp131_;
										TrackerSparqlVariable* _tmp132_;
										const gchar* _tmp133_;
										const gchar* _tmp134_;
										gint _tmp135_;
										TrackerSparqlVariable* _tmp136_;
										const gchar* _tmp137_;
										const gchar* _tmp138_;
										gint _tmp139_;
										TrackerSparqlVariable* _tmp140_;
										const gchar* _tmp141_;
										const gchar* _tmp142_;
										GString* _tmp143_;
										gint _tmp144_;
										TrackerSparqlVariable* _tmp145_;
										const gchar* _tmp146_;
										const gchar* _tmp147_;
										gint _tmp148_;
										TrackerSparqlVariable* _tmp149_;
										const gchar* _tmp150_;
										const gchar* _tmp151_;
										TrackerSparqlVariable* _tmp152_;
										const gchar* _tmp153_;
										const gchar* _tmp154_;
										TrackerSparqlVariable* _tmp155_;
										TrackerSparqlVariableBinding* _tmp156_;
										TrackerPropertyType _tmp157_;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp130_ = sql;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp131_ = left_index;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp132_ = v;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp133_ = tracker_sparql_variable_get_sql_expression (_tmp132_);
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp134_ = _tmp133_;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp135_ = left_index;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp136_ = v;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp137_ = tracker_sparql_variable_get_sql_expression (_tmp136_);
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp138_ = _tmp137_;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp139_ = right_index;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp140_ = v;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp141_ = tracker_sparql_variable_get_sql_expression (_tmp140_);
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp142_ = _tmp141_;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp130_, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", _tmp131_, _tmp134_, _tmp135_, _tmp138_, _tmp139_, _tmp142_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp143_ = select;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp144_ = left_index;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp145_ = v;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp146_ = tracker_sparql_variable_get_sql_expression (_tmp145_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp147_ = _tmp146_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp148_ = right_index;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp149_ = v;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp150_ = tracker_sparql_variable_get_sql_expression (_tmp149_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp151_ = _tmp150_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp152_ = v;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp153_ = tracker_sparql_variable_get_sql_expression (_tmp152_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp154_ = _tmp153_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp143_, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp144_, _tmp147_, _tmp148_, _tmp151_, _tmp154_);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp155_ = v;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp156_ = _tmp155_->binding;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp157_ = ((TrackerSparqlDataBinding*) _tmp156_)->data_type;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp157_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10149 "tracker-sparql-pattern.c"
											GString* _tmp158_;
											gint _tmp159_;
											TrackerSparqlVariable* _tmp160_;
											gchar* _tmp161_ = NULL;
											gchar* _tmp162_;
											gint _tmp163_;
											TrackerSparqlVariable* _tmp164_;
											gchar* _tmp165_ = NULL;
											gchar* _tmp166_;
											TrackerSparqlVariable* _tmp167_;
											gchar* _tmp168_ = NULL;
											gchar* _tmp169_;
											GString* _tmp170_;
											gint _tmp171_;
											TrackerSparqlVariable* _tmp172_;
											gchar* _tmp173_ = NULL;
											gchar* _tmp174_;
											gint _tmp175_;
											TrackerSparqlVariable* _tmp176_;
											gchar* _tmp177_ = NULL;
											gchar* _tmp178_;
											TrackerSparqlVariable* _tmp179_;
											gchar* _tmp180_ = NULL;
											gchar* _tmp181_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp158_ = select;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp159_ = left_index;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp160_ = v;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp161_ = tracker_sparql_variable_get_extra_sql_expression (_tmp160_, "localDate");
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp162_ = _tmp161_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp163_ = right_index;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp164_ = v;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp165_ = tracker_sparql_variable_get_extra_sql_expression (_tmp164_, "localDate");
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp166_ = _tmp165_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp167_ = v;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp168_ = tracker_sparql_variable_get_extra_sql_expression (_tmp167_, "localDate");
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp169_ = _tmp168_;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp158_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp159_, _tmp162_, _tmp163_, _tmp166_, _tmp169_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp169_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp166_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp162_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp170_ = select;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp171_ = left_index;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp172_ = v;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp173_ = tracker_sparql_variable_get_extra_sql_expression (_tmp172_, "localTime");
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp174_ = _tmp173_;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp175_ = right_index;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp176_ = v;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp177_ = tracker_sparql_variable_get_extra_sql_expression (_tmp176_, "localTime");
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp178_ = _tmp177_;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp179_ = v;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp180_ = tracker_sparql_variable_get_extra_sql_expression (_tmp179_, "localTime");
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp181_ = _tmp180_;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp170_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp171_, _tmp174_, _tmp175_, _tmp178_, _tmp181_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp181_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp178_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp174_);
#line 10238 "tracker-sparql-pattern.c"
										}
									}
								}
							}
						}
					}
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10247 "tracker-sparql-pattern.c"
				}
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp182_ = tracker_sparql_pattern_get_context (self);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp183_ = _tmp182_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp184_ = _tmp183_->parent_context;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp185_ = _tmp184_->var_set;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp186_ = g_hash_table_get_keys (_tmp185_);
#line 10259 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp186_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 10267 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 10271 "tracker-sparql-pattern.c"
						{
							TrackerSparqlContext* _tmp187_;
							TrackerSparqlContext* _tmp188_;
							GHashTable* _tmp189_;
							TrackerSparqlVariable* _tmp190_;
							gconstpointer _tmp191_ = NULL;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp187_ = tracker_sparql_pattern_get_context (self);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp188_ = _tmp187_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp189_ = _tmp188_->var_set;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp190_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp191_ = g_hash_table_lookup (_tmp189_, _tmp190_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (((gint) ((gintptr) _tmp191_)) == 0) {
#line 10290 "tracker-sparql-pattern.c"
								gboolean _tmp192_;
								GString* _tmp194_;
								gint _tmp195_;
								TrackerSparqlVariable* _tmp196_;
								const gchar* _tmp197_;
								const gchar* _tmp198_;
								TrackerSparqlVariable* _tmp199_;
								TrackerSparqlVariableBinding* _tmp200_;
								TrackerPropertyType _tmp201_;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp192_ = first;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp192_) {
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first = FALSE;
#line 10306 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp193_;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp193_ = select;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp193_, ", ");
#line 10313 "tracker-sparql-pattern.c"
								}
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp194_ = select;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp195_ = left_index;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp196_ = v;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp197_ = tracker_sparql_variable_get_sql_expression (_tmp196_);
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp198_ = _tmp197_;
#line 1054 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp194_, "t%d_g.%s", _tmp195_, _tmp198_);
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp199_ = v;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp200_ = _tmp199_->binding;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp201_ = ((TrackerSparqlDataBinding*) _tmp200_)->data_type;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp201_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10335 "tracker-sparql-pattern.c"
									GString* _tmp202_;
									gint _tmp203_;
									TrackerSparqlVariable* _tmp204_;
									gchar* _tmp205_ = NULL;
									gchar* _tmp206_;
									GString* _tmp207_;
									gint _tmp208_;
									TrackerSparqlVariable* _tmp209_;
									gchar* _tmp210_ = NULL;
									gchar* _tmp211_;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp202_ = select;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp203_ = left_index;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp204_ = v;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp205_ = tracker_sparql_variable_get_extra_sql_expression (_tmp204_, "localDate");
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp206_ = _tmp205_;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp202_, ", t%d_g.%s", _tmp203_, _tmp206_);
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp206_);
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp207_ = select;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp208_ = left_index;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp209_ = v;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp210_ = tracker_sparql_variable_get_extra_sql_expression (_tmp209_, "localTime");
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp211_ = _tmp210_;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp207_, ", t%d_g.%s", _tmp208_, _tmp211_);
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp211_);
#line 10374 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10381 "tracker-sparql-pattern.c"
				}
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp212_ = first;
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp212_) {
#line 10387 "tracker-sparql-pattern.c"
					GString* _tmp213_;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp213_ = select;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp213_, "1");
#line 10393 "tracker-sparql-pattern.c"
				}
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp214_ = tracker_sparql_pattern_get_context (self);
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp215_ = _tmp214_;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp216_ = _tmp215_->parent_context;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp216_);
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp217_ = select;
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp217_, " FROM (");
#line 1070 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp218_ = sql;
#line 1070 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp219_ = group_graph_pattern_start;
#line 1070 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp220_ = select;
#line 1070 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp221_ = _tmp220_->str;
#line 1070 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp218_, (gssize) _tmp219_, _tmp221_);
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp222_ = sql;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp223_ = group_graph_pattern_start;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp222_, (gssize) _tmp223_, "SELECT * FROM (");
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp224_ = sql;
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp224_, ")");
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (select);
#line 10429 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp225_ = FALSE;
			gboolean _tmp226_;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp225_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp226_ = _tmp225_;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 10450 "tracker-sparql-pattern.c"
				} else {
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 10462 "tracker-sparql-pattern.c"
				}
			}
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp226_) {
#line 10467 "tracker-sparql-pattern.c"
				const gchar* _tmp227_;
				gchar* _tmp228_;
				gchar* old_graph;
				gboolean _tmp229_;
				gboolean old_graph_is_var;
				GString* _tmp230_;
				gboolean _tmp231_ = FALSE;
				gchar* _tmp232_ = NULL;
				gchar* _tmp233_;
				gboolean _tmp234_ = FALSE;
				gboolean _tmp235_;
				gboolean _tmp237_;
				const gchar* _tmp251_;
				gchar* _tmp252_;
				gboolean _tmp253_;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp227_ = self->current_graph;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = g_strdup (_tmp227_);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph = _tmp228_;
#line 1079 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp229_ = self->priv->current_graph_is_var;
#line 1079 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph_is_var = _tmp229_;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp230_ = sql;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp232_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp230_, &_tmp231_, &_inner_error_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp231_;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp233_ = _tmp232_;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10515 "tracker-sparql-pattern.c"
					} else {
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10529 "tracker-sparql-pattern.c"
					}
				}
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp233_;
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp235_ = in_triples_block;
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp235_) {
#line 10540 "tracker-sparql-pattern.c"
					gboolean _tmp236_;
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp236_ = in_group_graph_pattern;
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp234_ = !_tmp236_;
#line 10546 "tracker-sparql-pattern.c"
				} else {
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp234_ = FALSE;
#line 10550 "tracker-sparql-pattern.c"
				}
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp237_ = _tmp234_;
#line 1082 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp237_) {
#line 10556 "tracker-sparql-pattern.c"
					GString* _tmp238_;
					glong _tmp239_;
					GString* _tmp240_;
					GString* _tmp241_;
#line 1083 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp238_ = sql;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp239_ = group_graph_pattern_start;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp238_, (gssize) _tmp239_, "SELECT * FROM (");
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp240_ = sql;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp240_, &_inner_error_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 10587 "tracker-sparql-pattern.c"
						} else {
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 10601 "tracker-sparql-pattern.c"
						}
					}
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp241_ = sql;
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp241_, ")");
#line 10608 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp242_;
					gboolean _tmp245_;
					GString* _tmp246_;
					glong _tmp247_;
					GString* _tmp248_;
					GString* _tmp249_;
					GString* _tmp250_;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp242_ = in_triples_block;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp242_) {
#line 10621 "tracker-sparql-pattern.c"
						GString* _tmp243_;
						gboolean _tmp244_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp243_ = sql;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp244_ = in_group_graph_pattern;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp243_, &first_where, _tmp244_, &_inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10644 "tracker-sparql-pattern.c"
							} else {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10658 "tracker-sparql-pattern.c"
							}
						}
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 10663 "tracker-sparql-pattern.c"
					}
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp245_ = in_group_graph_pattern;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp245_) {
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_group_graph_pattern = TRUE;
#line 10671 "tracker-sparql-pattern.c"
					}
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp246_ = sql;
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp247_ = group_graph_pattern_start;
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp246_, (gssize) _tmp247_, "SELECT * FROM (");
#line 1098 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp248_ = sql;
#line 1098 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp248_, ") NATURAL INNER JOIN (");
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp249_ = sql;
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp249_, &_inner_error_);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 10701 "tracker-sparql-pattern.c"
						} else {
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 10715 "tracker-sparql-pattern.c"
						}
					}
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp250_ = sql;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp250_, ")");
#line 10722 "tracker-sparql-pattern.c"
				}
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp251_ = old_graph;
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp252_ = g_strdup (_tmp251_);
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp252_;
#line 1104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp253_ = old_graph_is_var;
#line 1104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp253_;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_graph);
#line 10738 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp254_ = 0;
#line 1105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp254_ = tracker_sparql_pattern_current (self);
#line 1105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp254_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
#line 10745 "tracker-sparql-pattern.c"
					gboolean _tmp255_ = FALSE;
					gboolean _tmp256_;
					gboolean _tmp258_;
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp256_ = in_triples_block;
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp256_) {
#line 10753 "tracker-sparql-pattern.c"
						gboolean _tmp257_;
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp257_ = in_group_graph_pattern;
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp255_ = !_tmp257_;
#line 10759 "tracker-sparql-pattern.c"
					} else {
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp255_ = FALSE;
#line 10763 "tracker-sparql-pattern.c"
					}
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp258_ = _tmp255_;
#line 1106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp258_) {
#line 10769 "tracker-sparql-pattern.c"
						GString* _tmp259_;
						glong _tmp260_;
						GString* _tmp261_;
						GString* _tmp262_;
#line 1107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_group_graph_pattern = TRUE;
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp259_ = sql;
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp260_ = group_graph_pattern_start;
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_insert (_tmp259_, (gssize) _tmp260_, "SELECT * FROM (");
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp261_ = sql;
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp261_, &_inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10798 "tracker-sparql-pattern.c"
							} else {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10810 "tracker-sparql-pattern.c"
							}
						}
#line 1111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp262_ = sql;
#line 1111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp262_, ")");
#line 10817 "tracker-sparql-pattern.c"
					} else {
						gboolean _tmp263_;
						gboolean _tmp266_;
						GString* _tmp267_;
						glong _tmp268_;
						GString* _tmp269_;
						GString* _tmp270_;
						GString* _tmp271_;
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp263_ = in_triples_block;
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp263_) {
#line 10830 "tracker-sparql-pattern.c"
							GString* _tmp264_;
							gboolean _tmp265_;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp264_ = sql;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp265_ = in_group_graph_pattern;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_end_triples_block (self, _tmp264_, &first_where, _tmp265_, &_inner_error_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_ != NULL) {
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 10851 "tracker-sparql-pattern.c"
								} else {
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 10863 "tracker-sparql-pattern.c"
								}
							}
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_triples_block = FALSE;
#line 10868 "tracker-sparql-pattern.c"
						}
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp266_ = in_group_graph_pattern;
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp266_) {
#line 1118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_group_graph_pattern = TRUE;
#line 10876 "tracker-sparql-pattern.c"
						}
#line 1121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp267_ = sql;
#line 1121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp268_ = group_graph_pattern_start;
#line 1121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_insert (_tmp267_, (gssize) _tmp268_, "SELECT * FROM (");
#line 1122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp269_ = sql;
#line 1122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp269_, ") NATURAL INNER JOIN (");
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp270_ = sql;
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp270_, &_inner_error_);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10904 "tracker-sparql-pattern.c"
							} else {
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10916 "tracker-sparql-pattern.c"
							}
						}
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp271_ = sql;
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp271_, ")");
#line 10923 "tracker-sparql-pattern.c"
					}
				} else {
					TrackerSparqlTokenType _tmp272_ = 0;
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp272_ = tracker_sparql_pattern_current (self);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp272_ == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
#line 10931 "tracker-sparql-pattern.c"
						TrackerSourceLocation* _tmp273_;
						gint _tmp273__length1;
						TrackerSourceLocation _tmp274_ = {0};
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp273_ = filters;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp273__length1 = filters_length1;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_get_location (self, &_tmp274_);
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_vala_array_add8 (&filters, &filters_length1, &_filters_size_, &_tmp274_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_skip_filter (self, &_inner_error_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_ != NULL) {
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10957 "tracker-sparql-pattern.c"
							} else {
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10969 "tracker-sparql-pattern.c"
							}
						}
					} else {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 10975 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 10994 "tracker-sparql-pattern.c"
			} else {
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 11006 "tracker-sparql-pattern.c"
			}
		}
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp275_ = sql;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp276_ = group_graph_pattern_start;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp277_ = found_simple_optional;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_triples (self, _tmp275_, _tmp276_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp277_, &_inner_error_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_ != NULL) {
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 11029 "tracker-sparql-pattern.c"
			} else {
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 11041 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 11059 "tracker-sparql-pattern.c"
		} else {
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 11071 "tracker-sparql-pattern.c"
		}
	}
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp279_ = in_triples_block;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp279_) {
#line 11078 "tracker-sparql-pattern.c"
		gboolean _tmp280_;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp280_ = in_group_graph_pattern;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp278_ = !_tmp280_;
#line 11084 "tracker-sparql-pattern.c"
	} else {
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp278_ = FALSE;
#line 11088 "tracker-sparql-pattern.c"
	}
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp281_ = _tmp278_;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp281_) {
#line 11094 "tracker-sparql-pattern.c"
		GString* _tmp282_;
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp282_ = sql;
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp282_, "SELECT 1");
#line 11100 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp283_;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp283_ = in_triples_block;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp283_) {
#line 11107 "tracker-sparql-pattern.c"
			GString* _tmp284_;
			gboolean _tmp285_;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp284_ = sql;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp285_ = in_group_graph_pattern;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp284_, &first_where, _tmp285_, &_inner_error_);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11128 "tracker-sparql-pattern.c"
				} else {
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11140 "tracker-sparql-pattern.c"
				}
			}
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_triples_block = FALSE;
#line 11145 "tracker-sparql-pattern.c"
		}
	}
#line 1149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp286_ = in_group_graph_pattern;
#line 1149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp286_) {
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_where = TRUE;
#line 11154 "tracker-sparql-pattern.c"
	}
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp287_ = filters;
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp287__length1 = filters_length1;
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp287__length1 > 0) {
#line 11162 "tracker-sparql-pattern.c"
		TrackerSourceLocation _tmp288_ = {0};
		TrackerSourceLocation end;
		TrackerSourceLocation* _tmp289_;
		gint _tmp289__length1;
		TrackerSourceLocation _tmp295_;
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_get_location (self, &_tmp288_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		end = _tmp288_;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp289_ = filters;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp289__length1 = filters_length1;
#line 11176 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation* filter_location_collection = NULL;
			gint filter_location_collection_length1 = 0;
			gint _filter_location_collection_size_ = 0;
			gint filter_location_it = 0;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection = _tmp289_;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection_length1 = _tmp289__length1;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (filter_location_it = 0; filter_location_it < _tmp289__length1; filter_location_it = filter_location_it + 1) {
#line 11188 "tracker-sparql-pattern.c"
				TrackerSourceLocation filter_location = {0};
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filter_location = filter_location_collection[filter_location_it];
#line 11192 "tracker-sparql-pattern.c"
				{
					gboolean _tmp290_;
					TrackerSourceLocation _tmp293_;
					GString* _tmp294_;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp290_ = first_where;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp290_) {
#line 11201 "tracker-sparql-pattern.c"
						GString* _tmp291_;
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp291_ = sql;
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp291_, " AND ");
#line 11207 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp292_;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp292_ = sql;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp292_, " WHERE ");
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first_where = FALSE;
#line 11216 "tracker-sparql-pattern.c"
					}
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp293_ = filter_location;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp293_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp294_ = sql;
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_filter (self, _tmp294_, &_inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_ != NULL) {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11238 "tracker-sparql-pattern.c"
						} else {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11250 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp295_ = end;
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp295_);
#line 11260 "tracker-sparql-pattern.c"
	}
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp296_ = tracker_sparql_pattern_get_context (self);
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp297_ = _tmp296_;
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp298_ = _tmp297_->parent_context;
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp298_);
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = (g_free (filters), NULL);
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 11276 "tracker-sparql-pattern.c"
}


static void _vala_array_add9 (glong** array, int* length, int* size, glong value) {
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (glong, *array, *size);
#line 11287 "tracker-sparql-pattern.c"
	}
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 11291 "tracker-sparql-pattern.c"
}


static void _vala_array_add10 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
#line 11302 "tracker-sparql-pattern.c"
	}
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 11308 "tracker-sparql-pattern.c"
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? tracker_sparql_context_ref (self) : NULL;
#line 11315 "tracker-sparql-pattern.c"
}


static void _vala_array_add11 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value) {
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
#line 11326 "tracker-sparql-pattern.c"
	}
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 11332 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlVariable** _tmp0_ = NULL;
	TrackerSparqlVariable** all_vars;
	gint all_vars_length1;
	gint _all_vars_size_;
	GDestroyNotify _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* all_var_set;
	TrackerSparqlContext** _tmp3_ = NULL;
	TrackerSparqlContext** contexts;
	gint contexts_length1;
	gint _contexts_size_;
	glong* _tmp4_ = NULL;
	glong* offsets;
	gint offsets_length1;
	gint _offsets_size_;
	TrackerSparqlContext** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1);
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = _tmp0_;
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars_length1 = 0;
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_all_vars_size_ = all_vars_length1;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = g_object_unref;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp1_, NULL);
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_var_set = _tmp2_;
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_new0 (TrackerSparqlContext*, 0 + 1);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = _tmp3_;
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts_length1 = 0;
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_contexts_size_ = contexts_length1;
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_new0 (glong, 0);
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = _tmp4_;
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets_length1 = 0;
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_offsets_size_ = offsets_length1;
#line 11389 "tracker-sparql-pattern.c"
	{
		gboolean _tmp5_;
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = TRUE;
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 11396 "tracker-sparql-pattern.c"
			gboolean _tmp6_;
			glong* _tmp9_;
			gint _tmp9__length1;
			GString* _tmp10_;
			gssize _tmp11_;
			GString* _tmp12_;
			TrackerSparqlContext* _tmp13_ = NULL;
			TrackerSparqlContext* _tmp14_;
			TrackerSparqlContext** _tmp15_;
			gint _tmp15__length1;
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = _tmp5_;
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp6_) {
#line 11411 "tracker-sparql-pattern.c"
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_;
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = _tmp7_;
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_ != NULL) {
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 11434 "tracker-sparql-pattern.c"
					} else {
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 11450 "tracker-sparql-pattern.c"
					}
				}
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp8_) {
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 11457 "tracker-sparql-pattern.c"
				}
			}
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = FALSE;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = offsets;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9__length1 = offsets_length1;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = sql;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp10_->len;
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add9 (&offsets, &offsets_length1, &_offsets_size_, (glong) _tmp11_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = sql;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp12_, &_inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = _tmp13_;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_ != NULL) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 11494 "tracker-sparql-pattern.c"
				} else {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 11510 "tracker-sparql-pattern.c"
				}
			}
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = contexts;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15__length1 = contexts_length1;
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add10 (&contexts, &contexts_length1, &_contexts_size_, _tmp14_);
#line 11519 "tracker-sparql-pattern.c"
		}
	}
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16_ = contexts;
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16__length1 = contexts_length1;
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp16__length1 > 1) {
#line 11528 "tracker-sparql-pattern.c"
		TrackerSparqlContext** _tmp17_;
		gint _tmp17__length1;
		glong extra_offset;
		GString* _tmp72_;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = contexts;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17__length1 = contexts_length1;
#line 11537 "tracker-sparql-pattern.c"
		{
			TrackerSparqlContext** sub_context_collection = NULL;
			gint sub_context_collection_length1 = 0;
			gint _sub_context_collection_size_ = 0;
			gint sub_context_it = 0;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection = _tmp17_;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection_length1 = _tmp17__length1;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (sub_context_it = 0; sub_context_it < _tmp17__length1; sub_context_it = sub_context_it + 1) {
#line 11549 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp18_;
				TrackerSparqlContext* sub_context = NULL;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				sub_context = _tmp18_;
#line 11556 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp19_;
					GHashTable* _tmp20_;
					GList* _tmp21_ = NULL;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sub_context;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp19_->var_set;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = g_hash_table_get_keys (_tmp20_);
#line 11567 "tracker-sparql-pattern.c"
					{
						GList* v_collection = NULL;
						GList* v_it = NULL;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp21_;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 11575 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* v = NULL;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = (TrackerSparqlVariable*) v_it->data;
#line 11579 "tracker-sparql-pattern.c"
							{
								GHashTable* _tmp22_;
								TrackerSparqlVariable* _tmp23_;
								gconstpointer _tmp24_ = NULL;
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp22_ = all_var_set;
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp23_ = v;
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp24_ = g_hash_table_lookup (_tmp22_, _tmp23_);
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp24_)) == 0) {
#line 11592 "tracker-sparql-pattern.c"
									TrackerSparqlVariable** _tmp25_;
									gint _tmp25__length1;
									TrackerSparqlVariable* _tmp26_;
									TrackerSparqlVariable* _tmp27_;
									GHashTable* _tmp28_;
									TrackerSparqlVariable* _tmp29_;
									TrackerSparqlVariable* _tmp30_;
									TrackerSparqlContext* _tmp31_;
									TrackerSparqlContext* _tmp32_;
									GHashTable* _tmp33_;
									TrackerSparqlVariable* _tmp34_;
									TrackerSparqlVariable* _tmp35_;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25_ = all_vars;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25__length1 = all_vars_length1;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp26_ = v;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp27_ = _g_object_ref0 (_tmp26_);
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_vala_array_add11 (&all_vars, &all_vars_length1, &_all_vars_size_, _tmp27_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp28_ = all_var_set;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp29_ = v;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp30_ = _g_object_ref0 (_tmp29_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp28_, _tmp30_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp31_ = tracker_sparql_pattern_get_context (self);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp32_ = _tmp31_;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp33_ = _tmp32_->var_set;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp34_ = v;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp35_ = _g_object_ref0 (_tmp34_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp33_, _tmp35_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 11635 "tracker-sparql-pattern.c"
								}
							}
						}
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (v_collection);
#line 11641 "tracker-sparql-pattern.c"
					}
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (sub_context);
#line 11645 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		extra_offset = (glong) 0;
#line 11651 "tracker-sparql-pattern.c"
		{
			gint i;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 11656 "tracker-sparql-pattern.c"
			{
				gboolean _tmp36_;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = TRUE;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 11663 "tracker-sparql-pattern.c"
					gboolean _tmp37_;
					gint _tmp39_;
					TrackerSparqlContext** _tmp40_;
					gint _tmp40__length1;
					GString* _tmp41_;
					GString* projection;
					gint _tmp42_;
					GString* _tmp44_;
					TrackerSparqlVariable** _tmp45_;
					gint _tmp45__length1;
					GString* _tmp58_;
					GString* _tmp59_;
					gssize _tmp60_;
					GString* _tmp61_;
					GString* _tmp62_;
					glong* _tmp63_;
					gint _tmp63__length1;
					gint _tmp64_;
					glong _tmp65_;
					glong _tmp66_;
					GString* _tmp67_;
					const gchar* _tmp68_;
					glong _tmp69_;
					GString* _tmp70_;
					gssize _tmp71_;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp37_ = _tmp36_;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp37_) {
#line 11693 "tracker-sparql-pattern.c"
						gint _tmp38_;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp38_ = i;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp38_ + 1;
#line 11699 "tracker-sparql-pattern.c"
					}
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = FALSE;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = i;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = contexts;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40__length1 = contexts_length1;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!(_tmp39_ < _tmp40__length1)) {
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 11713 "tracker-sparql-pattern.c"
					}
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = g_string_new ("");
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					projection = _tmp41_;
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = i;
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp42_ > 0) {
#line 11723 "tracker-sparql-pattern.c"
						GString* _tmp43_;
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp43_ = projection;
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp43_, ") UNION ALL ");
#line 11729 "tracker-sparql-pattern.c"
					}
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = projection;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp44_, "SELECT ");
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = all_vars;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45__length1 = all_vars_length1;
#line 11739 "tracker-sparql-pattern.c"
					{
						TrackerSparqlVariable** v_collection = NULL;
						gint v_collection_length1 = 0;
						gint _v_collection_size_ = 0;
						gint v_it = 0;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp45_;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection_length1 = _tmp45__length1;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = 0; v_it < _tmp45__length1; v_it = v_it + 1) {
#line 11751 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* _tmp46_;
							TrackerSparqlVariable* v = NULL;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp46_ = _g_object_ref0 (v_collection[v_it]);
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = _tmp46_;
#line 11758 "tracker-sparql-pattern.c"
							{
								TrackerSparqlContext** _tmp47_;
								gint _tmp47__length1;
								gint _tmp48_;
								TrackerSparqlContext* _tmp49_;
								GHashTable* _tmp50_;
								TrackerSparqlVariable* _tmp51_;
								gconstpointer _tmp52_ = NULL;
								GString* _tmp54_;
								TrackerSparqlVariable* _tmp55_;
								const gchar* _tmp56_;
								const gchar* _tmp57_;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47_ = contexts;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47__length1 = contexts_length1;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp48_ = i;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp49_ = _tmp47_[_tmp48_];
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp50_ = _tmp49_->var_set;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp51_ = v;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp52_ = g_hash_table_lookup (_tmp50_, _tmp51_);
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp52_)) == 0) {
#line 11787 "tracker-sparql-pattern.c"
									GString* _tmp53_;
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = projection;
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp53_, "NULL AS ");
#line 11793 "tracker-sparql-pattern.c"
								}
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp54_ = projection;
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp55_ = v;
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp56_ = tracker_sparql_variable_get_sql_expression (_tmp55_);
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp57_ = _tmp56_;
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp54_, "%s, ", _tmp57_);
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (v);
#line 11807 "tracker-sparql-pattern.c"
							}
						}
					}
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = projection;
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp59_ = projection;
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = _tmp59_->len;
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_truncate (_tmp58_, (gsize) (_tmp60_ - 2));
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp61_ = projection;
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp61_, " FROM (");
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = sql;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = offsets;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63__length1 = offsets_length1;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = i;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = _tmp63_[_tmp64_];
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = extra_offset;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = projection;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = _tmp67_->str;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp62_, (gssize) (_tmp65_ + _tmp66_), _tmp68_);
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = extra_offset;
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = projection;
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp71_ = _tmp70_->len;
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					extra_offset = _tmp69_ + _tmp71_;
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (projection);
#line 11851 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = sql;
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp72_, ")");
#line 11859 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlContext** _tmp73_;
		gint _tmp73__length1;
		TrackerSparqlContext* _tmp74_;
		GHashTable* _tmp75_;
		GList* _tmp76_ = NULL;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp73_ = contexts;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp73__length1 = contexts_length1;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp74_ = _tmp73_[0];
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp75_ = _tmp74_->var_set;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp76_ = g_hash_table_get_keys (_tmp75_);
#line 11876 "tracker-sparql-pattern.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key_collection = _tmp76_;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 11884 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* key = NULL;
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				key = (TrackerSparqlVariable*) key_it->data;
#line 11888 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp77_;
					TrackerSparqlContext* _tmp78_;
					GHashTable* _tmp79_;
					TrackerSparqlVariable* _tmp80_;
					TrackerSparqlVariable* _tmp81_;
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = tracker_sparql_pattern_get_context (self);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_;
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = _tmp78_->var_set;
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = key;
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = _g_object_ref0 (_tmp80_);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp79_, _tmp81_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 11907 "tracker-sparql-pattern.c"
				}
			}
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (key_collection);
#line 11912 "tracker-sparql-pattern.c"
		}
	}
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = (g_free (offsets), NULL);
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (all_var_set);
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 11923 "tracker-sparql-pattern.c"
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	TrackerSparqlPatternTripleContext* _tmp0_;
	gboolean _tmp6_ = FALSE;
	TrackerSparqlVariableBindingList* _tmp7_;
	gboolean _tmp10_;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = NULL;
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->triple_context;
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ != NULL) {
#line 11944 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp1_;
		GHashTable* _tmp2_;
		TrackerSparqlVariable* _tmp3_;
		gconstpointer _tmp4_ = NULL;
		TrackerSparqlVariableBindingList* _tmp5_;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->triple_context;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp1_->var_bindings;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = variable;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp4_);
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp5_;
#line 11964 "tracker-sparql-pattern.c"
	}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = binding_list;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp7_ == NULL) {
#line 11970 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariableBinding* _tmp9_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = variable;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_->binding;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 11979 "tracker-sparql-pattern.c"
	} else {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = FALSE;
#line 11983 "tracker-sparql-pattern.c"
	}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = _tmp6_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp10_) {
#line 11989 "tracker-sparql-pattern.c"
		TrackerSparqlContext* _tmp11_;
		TrackerSparqlContext* _tmp12_;
		TrackerSparqlContext* _tmp13_;
		TrackerSparqlContext* current_context;
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = tracker_sparql_pattern_get_context (self);
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _tmp11_;
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = _tracker_sparql_context_ref0 (_tmp12_);
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		current_context = _tmp13_;
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 12004 "tracker-sparql-pattern.c"
			TrackerSparqlContext* _tmp14_;
			gboolean _tmp15_ = FALSE;
			TrackerSparqlContext* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp23_;
			TrackerSparqlContext* _tmp64_;
			TrackerSparqlContext* _tmp65_;
			TrackerSparqlContext* _tmp66_;
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = current_context;
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!(_tmp14_ != NULL)) {
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 12019 "tracker-sparql-pattern.c"
			}
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = current_context;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = _tmp16_->scalar_subquery;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp17_) {
#line 12027 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp18_;
				TrackerSparqlContext* _tmp19_;
				GHashTable* _tmp20_;
				TrackerSparqlVariable* _tmp21_;
				gconstpointer _tmp22_ = NULL;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = current_context;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = _tmp18_->parent_context;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = _tmp19_->var_set;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = variable;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = ((gint) ((gintptr) _tmp22_)) != 0;
#line 12045 "tracker-sparql-pattern.c"
			} else {
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = FALSE;
#line 12049 "tracker-sparql-pattern.c"
			}
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp23_ = _tmp15_;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp23_) {
#line 12055 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp24_;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlVariableBinding* _tmp25_;
				TrackerSparqlVariable* _tmp26_;
				TrackerSparqlVariableBinding* _tmp27_;
				TrackerPropertyType _tmp28_;
				TrackerSparqlVariableBinding* _tmp29_;
				TrackerSparqlContext* _tmp30_;
				TrackerSparqlContext* _tmp31_;
				TrackerSparqlVariable* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				TrackerSparqlVariable* _tmp35_ = NULL;
				TrackerSparqlVariableBinding* _tmp36_;
				TrackerSparqlVariable* _tmp37_;
				TrackerSparqlVariableBinding* _tmp38_;
				TrackerClass* _tmp39_;
				TrackerClass* _tmp40_;
				TrackerSparqlVariableBinding* _tmp41_;
				TrackerSparqlVariable* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				TrackerSparqlVariableBindingList* _tmp45_;
				TrackerSparqlPatternTripleContext* _tmp46_;
				TrackerSparqlContext* _tmp56_;
				TrackerSparqlContext* _tmp57_;
				GHashTable* _tmp58_;
				TrackerSparqlVariable* _tmp59_;
				TrackerSparqlVariable* _tmp60_;
				TrackerSparqlVariableBindingList* _tmp61_;
				TrackerSparqlVariableBinding* _tmp62_;
				TrackerSparqlVariableBinding* _tmp63_;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = tracker_sparql_variable_binding_new ();
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp24_;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = binding;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = variable;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = _tmp26_->binding;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = ((TrackerSparqlDataBinding*) _tmp27_)->data_type;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp25_)->data_type = _tmp28_;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = binding;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = tracker_sparql_pattern_get_context (self);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = _tmp30_;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = variable;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = tracker_sparql_variable_get_name (_tmp32_);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = _tmp33_;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = tracker_sparql_context_get_variable (_tmp31_, _tmp34_);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_->variable = _tmp35_;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = binding;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = variable;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = _tmp37_->binding;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = _tmp38_->type;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _g_object_ref0 (_tmp39_);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp36_->type);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_->type = _tmp40_;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp41_ = binding;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = variable;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp43_ = tracker_sparql_variable_get_sql_expression (_tmp42_);
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp44_ = _tmp43_;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp41_, _tmp44_);
#line 1250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp45_ = tracker_sparql_variable_binding_list_new ();
#line 1250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding_list);
#line 1250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_list = _tmp45_;
#line 1251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = self->priv->triple_context;
#line 1251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp46_ != NULL) {
#line 12152 "tracker-sparql-pattern.c"
					TrackerSparqlPatternTripleContext* _tmp47_;
					TrackerSparqlVariable* _tmp48_;
					TrackerSparqlVariable* _tmp49_;
					TrackerSparqlPatternTripleContext* _tmp50_;
					GHashTable* _tmp51_;
					TrackerSparqlVariable* _tmp52_;
					TrackerSparqlVariable* _tmp53_;
					TrackerSparqlVariableBindingList* _tmp54_;
					TrackerSparqlVariableBindingList* _tmp55_;
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = self->priv->triple_context;
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = variable;
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp49_ = _g_object_ref0 (_tmp48_);
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_->variables = g_list_append (_tmp47_->variables, _tmp49_);
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = self->priv->triple_context;
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = _tmp50_->var_bindings;
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = variable;
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = binding_list;
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp55_ = _g_object_ref0 (_tmp54_);
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp51_, _tmp53_, _tmp55_);
#line 12184 "tracker-sparql-pattern.c"
				}
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = tracker_sparql_pattern_get_context (self);
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = _tmp56_;
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = _tmp57_->var_set;
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = variable;
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = _g_object_ref0 (_tmp59_);
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp58_, _tmp60_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = binding_list;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp62_ = binding;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp63_ = _g_object_ref0 (_tmp62_);
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_->list = g_list_append (_tmp61_->list, _tmp63_);
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 12210 "tracker-sparql-pattern.c"
			}
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp64_ = current_context;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp65_ = _tmp64_->parent_context;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp66_ = _tracker_sparql_context_ref0 (_tmp65_);
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (current_context);
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			current_context = _tmp66_;
#line 12222 "tracker-sparql-pattern.c"
		}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (current_context);
#line 12226 "tracker-sparql-pattern.c"
	}
#line 1263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = binding_list;
#line 1263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 12232 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBinding* _tmp0_;
	TrackerSparqlVariable* _tmp1_;
	TrackerSparqlVariableBindingList* _tmp2_ = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	TrackerSparqlVariableBindingList* _tmp3_;
	TrackerSparqlVariableBindingList* _tmp50_;
	TrackerSparqlVariableBinding* _tmp51_;
	TrackerSparqlVariableBinding* _tmp52_;
	TrackerSparqlVariableBinding* _tmp53_;
	TrackerSparqlVariable* _tmp54_;
	TrackerSparqlVariableBinding* _tmp55_;
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (binding != NULL);
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = binding;
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->variable;
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_variable_binding_list (self, _tmp1_);
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = _tmp2_;
#line 1268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = binding_list;
#line 1268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_ == NULL) {
#line 12266 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBindingList* _tmp4_;
		TrackerSparqlPatternTripleContext* _tmp5_;
		GString* _tmp17_;
		TrackerSparqlVariableBinding* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		TrackerSparqlVariableBinding* _tmp21_;
		TrackerSparqlVariable* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		TrackerSparqlVariableBinding* _tmp25_;
		TrackerPropertyType _tmp26_;
		TrackerSparqlContext* _tmp43_;
		TrackerSparqlContext* _tmp44_;
		GHashTable* _tmp45_;
		TrackerSparqlVariableBinding* _tmp46_;
		TrackerSparqlVariable* _tmp47_;
		TrackerSparqlVariable* _tmp48_;
		TrackerSparqlVariableState _tmp49_;
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_variable_binding_list_new ();
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp4_;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->triple_context;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ != NULL) {
#line 12296 "tracker-sparql-pattern.c"
			TrackerSparqlPatternTripleContext* _tmp6_;
			TrackerSparqlVariableBinding* _tmp7_;
			TrackerSparqlVariable* _tmp8_;
			TrackerSparqlVariable* _tmp9_;
			TrackerSparqlPatternTripleContext* _tmp10_;
			GHashTable* _tmp11_;
			TrackerSparqlVariableBinding* _tmp12_;
			TrackerSparqlVariable* _tmp13_;
			TrackerSparqlVariable* _tmp14_;
			TrackerSparqlVariableBindingList* _tmp15_;
			TrackerSparqlVariableBindingList* _tmp16_;
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = self->priv->triple_context;
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = binding;
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = _tmp7_->variable;
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_->variables = g_list_append (_tmp6_->variables, _tmp9_);
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = self->priv->triple_context;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp10_->var_bindings;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = binding;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp12_->variable;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = binding_list;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp11_, _tmp14_, _tmp16_);
#line 12334 "tracker-sparql-pattern.c"
		}
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = sql;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = binding;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp18_);
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = _tmp19_;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = binding;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp21_->variable;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = tracker_sparql_variable_get_sql_expression (_tmp22_);
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = _tmp23_;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp17_, "%s AS %s, ", _tmp20_, _tmp24_);
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = binding;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = ((TrackerSparqlDataBinding*) _tmp25_)->data_type;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp26_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 12360 "tracker-sparql-pattern.c"
			GString* _tmp27_;
			TrackerSparqlVariableBinding* _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			TrackerSparqlVariableBinding* _tmp31_;
			TrackerSparqlVariable* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			GString* _tmp35_;
			TrackerSparqlVariableBinding* _tmp36_;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			TrackerSparqlVariableBinding* _tmp39_;
			TrackerSparqlVariable* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = sql;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = binding;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp28_, "localDate");
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _tmp29_;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = binding;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp32_ = _tmp31_->variable;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = tracker_sparql_variable_get_extra_sql_expression (_tmp32_, "localDate");
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp34_ = _tmp33_;
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp27_, "%s AS %s, ", _tmp30_, _tmp34_);
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp34_);
#line 1280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp30_);
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp35_ = sql;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp36_ = binding;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp37_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp36_, "localTime");
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp38_ = _tmp37_;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp39_ = binding;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp40_ = _tmp39_->variable;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp41_ = tracker_sparql_variable_get_extra_sql_expression (_tmp40_, "localTime");
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp42_ = _tmp41_;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp35_, "%s AS %s, ", _tmp38_, _tmp42_);
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp42_);
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp38_);
#line 12421 "tracker-sparql-pattern.c"
		}
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp43_ = tracker_sparql_pattern_get_context (self);
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp44_ = _tmp43_;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp45_ = _tmp44_->var_set;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp46_ = binding;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp47_ = _tmp46_->variable;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp48_ = _g_object_ref0 (_tmp47_);
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp49_ = variable_state;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp45_, _tmp48_, (gpointer) ((gintptr) ((gint) _tmp49_)));
#line 12439 "tracker-sparql-pattern.c"
	}
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = binding_list;
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = binding;
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->list = g_list_append (_tmp50_->list, _tmp52_);
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = binding;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp54_ = _tmp53_->variable;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp55_ = _tmp54_->binding;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp55_ == NULL) {
#line 12457 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBinding* _tmp56_;
		TrackerSparqlVariable* _tmp57_;
		TrackerSparqlVariableBinding* _tmp58_;
		TrackerSparqlVariableBinding* _tmp59_;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = binding;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = _tmp56_->variable;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp58_ = binding;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp57_->binding);
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_->binding = _tmp59_;
#line 12474 "tracker-sparql-pattern.c"
	}
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (binding_list);
#line 12478 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin_sql_len;
	gboolean object_is_var = FALSE;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* object;
	gchar* db_table;
	gboolean rdftype;
	gboolean share_table;
	gboolean is_fts_match;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table = NULL;
	TrackerProperty* prop;
	TrackerClass* subject_type;
	gboolean _tmp5_;
	gboolean _tmp268_;
	gboolean _tmp303_;
	GString* _tmp439_;
	gssize _tmp440_;
	glong _tmp441_;
	GError * _inner_error_ = NULL;
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->len;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	begin_sql_len = (glong) _tmp1_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = sql;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp2_, &_tmp3_, &_inner_error_);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object_is_var = _tmp3_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object = _tmp4_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_ != NULL) {
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 12532 "tracker-sparql-pattern.c"
		} else {
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 12540 "tracker-sparql-pattern.c"
		}
	}
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	db_table = NULL;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	rdftype = FALSE;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	share_table = TRUE;
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	is_fts_match = FALSE;
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	prop = NULL;
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	subject_type = NULL;
#line 1313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = self->priv->current_predicate_is_var;
#line 1313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp5_) {
#line 12559 "tracker-sparql-pattern.c"
		const gchar* _tmp6_;
		TrackerProperty* _tmp7_ = NULL;
		TrackerProperty* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		gboolean _tmp13_;
		gboolean _tmp15_;
		const gchar* _tmp200_;
		const gchar* _tmp201_;
		gboolean _tmp202_;
		gboolean _tmp203_ = FALSE;
		TrackerSparqlDataTable* _tmp204_ = NULL;
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = self->priv->current_predicate;
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = tracker_ontologies_get_property_by_uri (_tmp6_);
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp8_;
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = self->priv->current_predicate;
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (g_strcmp0 (_tmp11_, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
#line 12587 "tracker-sparql-pattern.c"
			gboolean _tmp12_;
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = object_is_var;
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = !_tmp12_;
#line 12593 "tracker-sparql-pattern.c"
		} else {
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = FALSE;
#line 12597 "tracker-sparql-pattern.c"
		}
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = _tmp10_;
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp13_) {
#line 12603 "tracker-sparql-pattern.c"
			const gchar* _tmp14_;
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = self->current_graph;
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _tmp14_ == NULL;
#line 12609 "tracker-sparql-pattern.c"
		} else {
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = FALSE;
#line 12613 "tracker-sparql-pattern.c"
		}
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _tmp9_;
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp15_) {
#line 12619 "tracker-sparql-pattern.c"
			const gchar* _tmp16_;
			TrackerClass* _tmp17_ = NULL;
			TrackerClass* _tmp18_;
			TrackerClass* cl;
			TrackerClass* _tmp19_;
			TrackerClass* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			TrackerClass* _tmp29_;
			TrackerClass* _tmp30_;
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			rdftype = TRUE;
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = object;
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = tracker_ontologies_get_class_by_uri (_tmp16_);
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cl = _tmp18_;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp19_ = cl;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp19_ == NULL) {
#line 12645 "tracker-sparql-pattern.c"
				const gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				GError* _tmp23_;
				GError* _tmp24_;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = object;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = g_strdup_printf ("Unknown class `%s'", _tmp20_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = _tmp21_;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp22_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = _tmp23_;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_inner_error_ = _tmp24_;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12683 "tracker-sparql-pattern.c"
				} else {
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12703 "tracker-sparql-pattern.c"
				}
			}
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp25_ = cl;
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp26_ = tracker_class_get_name (_tmp25_);
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = _tmp26_;
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (db_table);
#line 1325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			db_table = _tmp28_;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = cl;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _g_object_ref0 (_tmp29_);
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (subject_type);
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_type = _tmp30_;
#line 1316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cl);
#line 12728 "tracker-sparql-pattern.c"
		} else {
			TrackerProperty* _tmp31_;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = prop;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp31_ == NULL) {
#line 12735 "tracker-sparql-pattern.c"
				const gchar* _tmp32_;
#line 1328 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = self->priv->current_predicate;
#line 1328 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp32_, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
#line 12741 "tracker-sparql-pattern.c"
					gchar* _tmp33_;
					TrackerSparqlContext* _tmp34_;
					TrackerSparqlContext* _tmp35_;
					const gchar* _tmp36_;
					TrackerSparqlVariable* _tmp37_ = NULL;
					TrackerSparqlVariable* _tmp38_;
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp33_ = g_strdup ("fts");
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp33_;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					is_fts_match = TRUE;
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp34_ = tracker_sparql_pattern_get_context (self);
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp35_ = _tmp34_;
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = self->priv->current_subject;
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp37_ = tracker_sparql_context_get_variable (_tmp35_, _tmp36_);
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp38_ = _g_object_ref0 (_tmp37_);
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (self->fts_subject);
#line 1333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->fts_subject = _tmp38_;
#line 12772 "tracker-sparql-pattern.c"
				} else {
					const gchar* _tmp39_;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_;
					GError* _tmp42_;
					GError* _tmp43_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = self->priv->current_predicate;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = g_strdup_printf ("Unknown property `%s'", _tmp39_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = _tmp40_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp41_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = _tmp42_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp41_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp43_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12809 "tracker-sparql-pattern.c"
					} else {
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12827 "tracker-sparql-pattern.c"
					}
				}
			} else {
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				const gchar* _tmp46_;
				gboolean _tmp48_;
				gboolean _tmp50_;
				gboolean _tmp84_;
				const gchar* _tmp115_;
				TrackerProperty* _tmp120_;
				gboolean _tmp121_;
				gboolean _tmp122_;
				TrackerProperty* _tmp123_;
				TrackerClass* _tmp124_;
				TrackerClass* _tmp125_;
				TrackerClass* _tmp126_;
				gboolean _tmp127_ = FALSE;
				gboolean _tmp128_;
				gboolean _tmp137_;
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = self->priv->current_predicate;
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp46_, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
#line 12852 "tracker-sparql-pattern.c"
					gboolean _tmp47_;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = self->priv->current_subject_is_var;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = _tmp47_;
#line 12858 "tracker-sparql-pattern.c"
				} else {
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = FALSE;
#line 12862 "tracker-sparql-pattern.c"
				}
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp48_ = _tmp45_;
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp48_) {
#line 12868 "tracker-sparql-pattern.c"
					gboolean _tmp49_;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp49_ = object_is_var;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = !_tmp49_;
#line 12874 "tracker-sparql-pattern.c"
				} else {
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = FALSE;
#line 12878 "tracker-sparql-pattern.c"
				}
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp50_ = _tmp44_;
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp50_) {
#line 12884 "tracker-sparql-pattern.c"
					const gchar* _tmp51_;
					TrackerClass* _tmp52_ = NULL;
					TrackerClass* _tmp53_;
					TrackerClass* domain;
					TrackerClass* _tmp54_;
					TrackerSparqlContext* _tmp60_;
					TrackerSparqlContext* _tmp61_;
					GHashTable* _tmp62_;
					TrackerSparqlContext* _tmp63_;
					TrackerSparqlContext* _tmp64_;
					const gchar* _tmp65_;
					TrackerSparqlVariable* _tmp66_ = NULL;
					gconstpointer _tmp67_ = NULL;
					TrackerSparqlPredicateVariable* _tmp68_;
					TrackerSparqlPredicateVariable* pv;
					TrackerSparqlPredicateVariable* _tmp69_;
					TrackerSparqlPredicateVariable* _tmp81_;
					TrackerClass* _tmp82_;
					TrackerClass* _tmp83_;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = object;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = tracker_ontologies_get_class_by_uri (_tmp51_);
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp53_;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = domain;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp54_ == NULL) {
#line 12916 "tracker-sparql-pattern.c"
						const gchar* _tmp55_;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_;
						GError* _tmp58_;
						GError* _tmp59_;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp55_ = object;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp56_ = g_strdup_printf ("Unknown class `%s'", _tmp55_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp57_ = _tmp56_;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp58_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp57_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = _tmp58_;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp57_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_inner_error_ = _tmp59_;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 12954 "tracker-sparql-pattern.c"
						} else {
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 12974 "tracker-sparql-pattern.c"
						}
					}
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = tracker_sparql_pattern_get_context (self);
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp61_ = _tmp60_;
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = _tmp61_->predicate_variable_map;
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = tracker_sparql_pattern_get_context (self);
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = _tmp63_;
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = self->priv->current_subject;
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = tracker_sparql_context_get_variable (_tmp64_, _tmp65_);
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = g_hash_table_lookup (_tmp62_, _tmp66_);
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp67_);
#line 1346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					pv = _tmp68_;
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = pv;
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp69_ == NULL) {
#line 13001 "tracker-sparql-pattern.c"
						TrackerSparqlPredicateVariable* _tmp70_;
						TrackerSparqlContext* _tmp71_;
						TrackerSparqlContext* _tmp72_;
						GHashTable* _tmp73_;
						TrackerSparqlContext* _tmp74_;
						TrackerSparqlContext* _tmp75_;
						const gchar* _tmp76_;
						TrackerSparqlVariable* _tmp77_ = NULL;
						TrackerSparqlVariable* _tmp78_;
						TrackerSparqlPredicateVariable* _tmp79_;
						TrackerSparqlPredicateVariable* _tmp80_;
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp70_ = tracker_sparql_predicate_variable_new ();
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (pv);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						pv = _tmp70_;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp71_ = tracker_sparql_pattern_get_context (self);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = _tmp71_;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = _tmp72_->predicate_variable_map;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_pattern_get_context (self);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp76_ = self->priv->current_subject;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp77_ = tracker_sparql_context_get_variable (_tmp75_, _tmp76_);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp78_ = _g_object_ref0 (_tmp77_);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp79_ = pv;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_hash_table_insert (_tmp73_, _tmp78_, _tmp80_);
#line 13041 "tracker-sparql-pattern.c"
					}
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = pv;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp82_ = domain;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp83_ = _g_object_ref0 (_tmp82_);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp81_->domain);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_->domain = _tmp83_;
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (pv);
#line 1338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 13057 "tracker-sparql-pattern.c"
				}
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp84_ = self->priv->current_subject_is_var;
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp84_) {
#line 13063 "tracker-sparql-pattern.c"
					TrackerSparqlContext* _tmp85_;
					TrackerSparqlContext* _tmp86_;
					const gchar* _tmp87_;
					TrackerSparqlVariable* _tmp88_ = NULL;
					TrackerSparqlVariable* _tmp89_;
					TrackerSparqlVariable* v;
					TrackerSparqlPatternTripleContext* _tmp90_;
					GHashTable* _tmp91_;
					TrackerSparqlVariable* _tmp92_;
					gconstpointer _tmp93_ = NULL;
					TrackerSparqlVariableBindingList* _tmp94_;
					TrackerSparqlVariableBindingList* list;
					gboolean _tmp95_ = FALSE;
					TrackerSparqlVariableBindingList* _tmp96_;
					gboolean _tmp99_;
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = tracker_sparql_pattern_get_context (self);
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = _tmp85_;
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp87_ = self->priv->current_subject;
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = tracker_sparql_context_get_variable (_tmp86_, _tmp87_);
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = _g_object_ref0 (_tmp88_);
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v = _tmp89_;
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp90_ = self->priv->triple_context;
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp91_ = _tmp90_->var_bindings;
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = v;
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = g_hash_table_lookup (_tmp91_, _tmp92_);
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp93_);
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					list = _tmp94_;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = list;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp96_ != NULL) {
#line 13107 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBindingList* _tmp97_;
						GList* _tmp98_;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp97_ = list;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp98_ = _tmp97_->list;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp95_ = _tmp98_ != NULL;
#line 13116 "tracker-sparql-pattern.c"
					} else {
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp95_ = FALSE;
#line 13120 "tracker-sparql-pattern.c"
					}
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = _tmp95_;
#line 1359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp99_) {
#line 13126 "tracker-sparql-pattern.c"
						gboolean stop;
						TrackerProperty* _tmp100_;
						TrackerClass** _tmp101_;
						TrackerClass** _tmp102_ = NULL;
#line 1360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						stop = FALSE;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp100_ = prop;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp102_ = _tmp101_ = tracker_property_get_domain_indexes (_tmp100_);
#line 13137 "tracker-sparql-pattern.c"
						{
							TrackerClass** cl_collection = NULL;
							gint cl_collection_length1 = 0;
							gint _cl_collection_size_ = 0;
							gint cl_it = 0;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection = _tmp102_;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection_length1 = _vala_array_length (_tmp101_);
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (cl_it = 0; cl_it < _vala_array_length (_tmp101_); cl_it = cl_it + 1) {
#line 13149 "tracker-sparql-pattern.c"
								TrackerClass* _tmp103_;
								TrackerClass* cl = NULL;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp103_ = _g_object_ref0 (cl_collection[cl_it]);
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								cl = _tmp103_;
#line 13156 "tracker-sparql-pattern.c"
								{
									TrackerSparqlVariableBindingList* _tmp104_;
									GList* _tmp105_;
									gboolean _tmp114_;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp104_ = list;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp105_ = _tmp104_->list;
#line 13165 "tracker-sparql-pattern.c"
									{
										GList* b_collection = NULL;
										GList* b_it = NULL;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										b_collection = _tmp105_;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
#line 13173 "tracker-sparql-pattern.c"
											TrackerSparqlVariableBinding* _tmp106_;
											TrackerSparqlVariableBinding* b = NULL;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp106_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) b_it->data);
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											b = _tmp106_;
#line 13180 "tracker-sparql-pattern.c"
											{
												TrackerSparqlVariableBinding* _tmp107_;
												TrackerClass* _tmp108_;
												TrackerClass* _tmp109_;
#line 1363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp107_ = b;
#line 1363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp108_ = _tmp107_->type;
#line 1363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp109_ = cl;
#line 1363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp108_ == _tmp109_) {
#line 13193 "tracker-sparql-pattern.c"
													TrackerClass* _tmp110_;
													const gchar* _tmp111_;
													const gchar* _tmp112_;
													gchar* _tmp113_;
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp110_ = cl;
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp111_ = tracker_class_get_name (_tmp110_);
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp112_ = _tmp111_;
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp113_ = g_strdup (_tmp112_);
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (db_table);
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													db_table = _tmp113_;
#line 1365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													stop = TRUE;
#line 1366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_object_unref0 (b);
#line 1366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													break;
#line 13216 "tracker-sparql-pattern.c"
												}
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_object_unref0 (b);
#line 13220 "tracker-sparql-pattern.c"
											}
										}
									}
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp114_ = stop;
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp114_) {
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_object_unref0 (cl);
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										break;
#line 13232 "tracker-sparql-pattern.c"
									}
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (cl);
#line 13236 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (list);
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (v);
#line 13245 "tracker-sparql-pattern.c"
				}
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp115_ = db_table;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp115_ == NULL) {
#line 13251 "tracker-sparql-pattern.c"
					TrackerProperty* _tmp116_;
					const gchar* _tmp117_;
					const gchar* _tmp118_;
					gchar* _tmp119_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp116_ = prop;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp117_ = tracker_property_get_table_name (_tmp116_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp118_ = _tmp117_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp119_ = g_strdup (_tmp118_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp119_;
#line 13268 "tracker-sparql-pattern.c"
				}
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp120_ = prop;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = tracker_property_get_multiple_values (_tmp120_);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = _tmp121_;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp122_) {
#line 1382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 13280 "tracker-sparql-pattern.c"
				}
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = prop;
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = tracker_property_get_domain (_tmp123_);
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = _tmp124_;
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = _g_object_ref0 (_tmp125_);
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (subject_type);
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				subject_type = _tmp126_;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp128_ = in_simple_optional;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp128_) {
#line 13298 "tracker-sparql-pattern.c"
					TrackerSparqlContext* _tmp129_;
					TrackerSparqlContext* _tmp130_;
					GHashTable* _tmp131_;
					TrackerSparqlContext* _tmp132_;
					TrackerSparqlContext* _tmp133_;
					const gchar* _tmp134_;
					TrackerSparqlVariable* _tmp135_ = NULL;
					gconstpointer _tmp136_ = NULL;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = tracker_sparql_pattern_get_context (self);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp130_ = _tmp129_;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp131_ = _tmp130_->var_set;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp132_ = tracker_sparql_pattern_get_context (self);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp133_ = _tmp132_;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp134_ = self->priv->current_subject;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp135_ = tracker_sparql_context_get_variable (_tmp133_, _tmp134_);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp136_ = g_hash_table_lookup (_tmp131_, _tmp135_);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp127_ = ((gint) ((gintptr) _tmp136_)) == 0;
#line 13325 "tracker-sparql-pattern.c"
				} else {
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp127_ = FALSE;
#line 13329 "tracker-sparql-pattern.c"
				}
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp137_ = _tmp127_;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp137_) {
#line 13335 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp138_;
					TrackerSparqlVariableBinding* binding;
					TrackerSparqlVariableBinding* _tmp139_;
					TrackerSparqlVariableBinding* _tmp140_;
					TrackerSparqlContext* _tmp141_;
					TrackerSparqlContext* _tmp142_;
					const gchar* _tmp143_;
					TrackerSparqlVariable* _tmp144_ = NULL;
					TrackerSparqlPatternTripleContext* _tmp145_;
					GHashTable* _tmp146_;
					TrackerSparqlVariableBinding* _tmp147_;
					TrackerSparqlVariable* _tmp148_;
					gconstpointer _tmp149_ = NULL;
					TrackerSparqlVariableBindingList* _tmp150_;
					TrackerSparqlVariableBindingList* binding_list;
					TrackerSparqlPatternTripleContext* _tmp151_;
					TrackerSparqlVariableBinding* _tmp152_;
					TrackerSparqlVariable* _tmp153_;
					TrackerSparqlVariable* _tmp154_;
					TrackerSparqlPatternTripleContext* _tmp155_;
					GHashTable* _tmp156_;
					TrackerSparqlVariableBinding* _tmp157_;
					TrackerSparqlVariable* _tmp158_;
					TrackerSparqlVariable* _tmp159_;
					TrackerSparqlVariableBindingList* _tmp160_;
					TrackerSparqlVariableBindingList* _tmp161_;
					TrackerSparqlPatternTripleContext* _tmp162_;
					GHashTable* _tmp163_;
					TrackerSparqlContext* _tmp164_;
					TrackerSparqlContext* _tmp165_;
					const gchar* _tmp166_;
					TrackerSparqlVariable* _tmp167_ = NULL;
					gconstpointer _tmp168_ = NULL;
					GList* _tmp169_;
					gconstpointer _tmp170_;
					TrackerSparqlVariableBinding* _tmp171_;
					TrackerSparqlVariableBinding* object_binding;
					GString* _tmp172_;
					const gchar* _tmp173_;
					TrackerProperty* _tmp174_;
					const gchar* _tmp175_;
					const gchar* _tmp176_;
					TrackerSparqlVariableBinding* _tmp177_;
					const gchar* _tmp178_;
					const gchar* _tmp179_;
					TrackerSparqlVariableBinding* _tmp180_;
					TrackerSparqlVariable* _tmp181_;
					const gchar* _tmp182_;
					const gchar* _tmp183_;
					TrackerSparqlContext* _tmp184_;
					TrackerSparqlContext* _tmp185_;
					GHashTable* _tmp186_;
					TrackerSparqlVariableBinding* _tmp187_;
					TrackerSparqlVariable* _tmp188_;
					TrackerSparqlVariable* _tmp189_;
					TrackerSparqlVariableBindingList* _tmp190_;
					TrackerSparqlVariableBinding* _tmp191_;
					TrackerSparqlVariableBinding* _tmp192_;
					TrackerSparqlVariableBinding* _tmp193_;
					TrackerSparqlVariable* _tmp194_;
					TrackerSparqlVariableBinding* _tmp195_;
					TrackerSparqlVariableBinding* _tmp196_;
					TrackerSparqlVariable* _tmp197_;
					TrackerSparqlVariableBinding* _tmp198_;
					TrackerSparqlVariableBinding* _tmp199_;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp138_ = tracker_sparql_variable_binding_new ();
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp138_;
#line 1390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp139_ = binding;
#line 1390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp139_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp140_ = binding;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_ = tracker_sparql_pattern_get_context (self);
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp142_ = _tmp141_;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp143_ = self->priv->current_subject;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp144_ = tracker_sparql_context_get_variable (_tmp142_, _tmp143_);
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp140_->variable = _tmp144_;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp145_ = self->priv->triple_context;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp146_ = _tmp145_->var_bindings;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp147_ = binding;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp148_ = _tmp147_->variable;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp149_ = g_hash_table_lookup (_tmp146_, _tmp148_);
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (((TrackerSparqlVariableBindingList*) _tmp149_) == NULL, "triple_context.var_bindings.lookup (binding.variable) == null");
#line 1394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp150_ = tracker_sparql_variable_binding_list_new ();
#line 1394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_list = _tmp150_;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_ = self->priv->triple_context;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_ = binding;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp153_ = _tmp152_->variable;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp154_ = _g_object_ref0 (_tmp153_);
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_->variables = g_list_append (_tmp151_->variables, _tmp154_);
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp155_ = self->priv->triple_context;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp156_ = _tmp155_->var_bindings;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp157_ = binding;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp158_ = _tmp157_->variable;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp159_ = _g_object_ref0 (_tmp158_);
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp160_ = binding_list;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp161_ = _g_object_ref0 (_tmp160_);
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp156_, _tmp159_, _tmp161_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp162_ = self->priv->triple_context;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp163_ = _tmp162_->var_bindings;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp164_ = tracker_sparql_pattern_get_context (self);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp165_ = _tmp164_;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp166_ = object;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp167_ = tracker_sparql_context_get_variable (_tmp165_, _tmp166_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp168_ = g_hash_table_lookup (_tmp163_, _tmp167_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp169_ = ((TrackerSparqlVariableBindingList*) _tmp168_)->list;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp170_ = _tmp169_->data;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp171_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) _tmp170_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					object_binding = _tmp171_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp172_ = sql;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp173_ = db_table;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp174_ = prop;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp175_ = tracker_property_get_name (_tmp174_);
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp176_ = _tmp175_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp177_ = object_binding;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp178_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp177_);
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp179_ = _tmp178_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp180_ = binding;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp181_ = _tmp180_->variable;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp182_ = tracker_sparql_variable_get_sql_expression (_tmp181_);
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp183_ = _tmp182_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp172_, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", _tmp173_, _tmp176_, _tmp179_, _tmp183_);
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp184_ = tracker_sparql_pattern_get_context (self);
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp185_ = _tmp184_;
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp186_ = _tmp185_->var_set;
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp187_ = binding;
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp188_ = _tmp187_->variable;
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp189_ = _g_object_ref0 (_tmp188_);
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp186_, _tmp189_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp190_ = binding_list;
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp191_ = binding;
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp192_ = _g_object_ref0 (_tmp191_);
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp190_->list = g_list_append (_tmp190_->list, _tmp192_);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp193_ = binding;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp194_ = _tmp193_->variable;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp195_ = _tmp194_->binding;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (_tmp195_ == NULL, "binding.variable.binding == null");
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp196_ = binding;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp197_ = _tmp196_->variable;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp198_ = binding;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp199_ = _g_object_ref0 (_tmp198_);
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp197_->binding);
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp197_->binding = _tmp199_;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (object_binding);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding_list);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 13571 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp200_ = self->priv->current_subject;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp201_ = db_table;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp202_ = share_table;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp204_ = tracker_sparql_pattern_get_table (self, _tmp200_, _tmp201_, _tmp202_, &_tmp203_);
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = _tmp203_;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp204_;
#line 13589 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlDataTable* _tmp205_;
		TrackerSparqlDataTable* _tmp206_;
		TrackerSparqlContext* _tmp207_;
		TrackerSparqlContext* _tmp208_;
		GHashTable* _tmp209_;
		TrackerSparqlContext* _tmp210_;
		TrackerSparqlContext* _tmp211_;
		const gchar* _tmp212_;
		TrackerSparqlVariable* _tmp213_ = NULL;
		gconstpointer _tmp214_ = NULL;
		TrackerSparqlPredicateVariable* _tmp215_;
		TrackerSparqlDataTable* _tmp216_;
		TrackerSparqlPredicateVariable* _tmp217_;
		gboolean _tmp231_;
		gboolean _tmp236_;
		const gchar* _tmp241_;
		TrackerSparqlDataTable* _tmp244_;
		const gchar* _tmp245_;
		gint _tmp246_;
		gint _tmp247_;
		gchar* _tmp248_ = NULL;
		gchar* _tmp249_;
		gchar* _tmp250_;
		TrackerSparqlPatternTripleContext* _tmp251_;
		TrackerSparqlDataTable* _tmp252_;
		TrackerSparqlDataTable* _tmp253_;
		TrackerSparqlVariableBinding* _tmp254_;
		TrackerSparqlVariableBinding* binding;
		TrackerSparqlVariableBinding* _tmp255_;
		TrackerSparqlVariableBinding* _tmp256_;
		TrackerSparqlContext* _tmp257_;
		TrackerSparqlContext* _tmp258_;
		const gchar* _tmp259_;
		TrackerSparqlVariable* _tmp260_ = NULL;
		TrackerSparqlVariableBinding* _tmp261_;
		TrackerSparqlDataTable* _tmp262_;
		TrackerSparqlDataTable* _tmp263_;
		TrackerSparqlVariableBinding* _tmp264_;
		gchar* _tmp265_;
		GString* _tmp266_;
		TrackerSparqlVariableBinding* _tmp267_;
#line 1419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = TRUE;
#line 1420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp205_ = tracker_sparql_data_table_new ();
#line 1420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp205_;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp206_ = table;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_ = tracker_sparql_pattern_get_context (self);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp208_ = _tmp207_;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp209_ = _tmp208_->predicate_variable_map;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp210_ = tracker_sparql_pattern_get_context (self);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = _tmp210_;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp212_ = self->priv->current_predicate;
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp213_ = tracker_sparql_context_get_variable (_tmp211_, _tmp212_);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp214_ = g_hash_table_lookup (_tmp209_, _tmp213_);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp215_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp214_);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp206_->predicate_variable);
#line 1421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp206_->predicate_variable = _tmp215_;
#line 1422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp216_ = table;
#line 1422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp217_ = _tmp216_->predicate_variable;
#line 1422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp217_ == NULL) {
#line 13670 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp218_;
			TrackerSparqlPredicateVariable* _tmp219_;
			TrackerSparqlContext* _tmp220_;
			TrackerSparqlContext* _tmp221_;
			GHashTable* _tmp222_;
			TrackerSparqlContext* _tmp223_;
			TrackerSparqlContext* _tmp224_;
			const gchar* _tmp225_;
			TrackerSparqlVariable* _tmp226_ = NULL;
			TrackerSparqlVariable* _tmp227_;
			TrackerSparqlDataTable* _tmp228_;
			TrackerSparqlPredicateVariable* _tmp229_;
			TrackerSparqlPredicateVariable* _tmp230_;
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_ = table;
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = tracker_sparql_predicate_variable_new ();
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp218_->predicate_variable);
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_->predicate_variable = _tmp219_;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = tracker_sparql_pattern_get_context (self);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp221_ = _tmp220_;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp222_ = _tmp221_->predicate_variable_map;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = tracker_sparql_pattern_get_context (self);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = _tmp223_;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp225_ = self->priv->current_predicate;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp226_ = tracker_sparql_context_get_variable (_tmp224_, _tmp225_);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp227_ = _g_object_ref0 (_tmp226_);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp228_ = table;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp229_ = _tmp228_->predicate_variable;
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp230_ = _g_object_ref0 (_tmp229_);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp222_, _tmp227_, _tmp230_);
#line 13716 "tracker-sparql-pattern.c"
		}
#line 1426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp231_ = self->priv->current_subject_is_var;
#line 1426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp231_) {
#line 13722 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp232_;
			TrackerSparqlPredicateVariable* _tmp233_;
			const gchar* _tmp234_;
			gchar* _tmp235_;
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp232_ = table;
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp233_ = _tmp232_->predicate_variable;
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp234_ = self->priv->current_subject;
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp235_ = g_strdup (_tmp234_);
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp233_->subject);
#line 1428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp233_->subject = _tmp235_;
#line 13739 "tracker-sparql-pattern.c"
		}
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp236_ = object_is_var;
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp236_) {
#line 13745 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp237_;
			TrackerSparqlPredicateVariable* _tmp238_;
			const gchar* _tmp239_;
			gchar* _tmp240_;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp237_ = table;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp238_ = _tmp237_->predicate_variable;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp239_ = object;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp240_ = g_strdup (_tmp239_);
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp238_->object);
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp238_->object = _tmp240_;
#line 13762 "tracker-sparql-pattern.c"
		}
#line 1434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp241_ = self->current_graph;
#line 1434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp241_ != NULL) {
#line 13768 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp242_;
			TrackerSparqlPredicateVariable* _tmp243_;
#line 1435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp242_ = table;
#line 1435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp243_ = _tmp242_->predicate_variable;
#line 1435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp243_->return_graph = TRUE;
#line 13777 "tracker-sparql-pattern.c"
		}
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp244_ = table;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp245_ = self->priv->current_predicate;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp246_ = self->priv->counter;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp246_ + 1;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp247_ = self->priv->counter;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp248_ = g_strdup_printf ("%i", _tmp247_);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp249_ = _tmp248_;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp250_ = g_strconcat (_tmp245_, _tmp249_, NULL);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp244_->sql_query_tablename);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp244_->sql_query_tablename = _tmp250_;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp249_);
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp251_ = self->priv->triple_context;
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp252_ = table;
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_ = _g_object_ref0 (_tmp252_);
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp251_->tables = g_list_append (_tmp251_->tables, _tmp253_);
#line 1441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp254_ = tracker_sparql_variable_binding_new ();
#line 1441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp254_;
#line 1442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp255_ = binding;
#line 1442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp255_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp256_ = binding;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp257_ = tracker_sparql_pattern_get_context (self);
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp258_ = _tmp257_;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp259_ = self->priv->current_predicate;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp260_ = tracker_sparql_context_get_variable (_tmp258_, _tmp259_);
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp256_->variable = _tmp260_;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp261_ = binding;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp262_ = table;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp263_ = _g_object_ref0 (_tmp262_);
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp261_)->table);
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp261_)->table = _tmp263_;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp264_ = binding;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp265_ = g_strdup ("predicate");
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (((TrackerSparqlDataBinding*) _tmp264_)->sql_db_column_name);
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp264_)->sql_db_column_name = _tmp265_;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp266_ = sql;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp267_ = binding;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_add_variable_binding (self, _tmp266_, _tmp267_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 13855 "tracker-sparql-pattern.c"
	}
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp268_ = newtable;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp268_) {
#line 13861 "tracker-sparql-pattern.c"
		gboolean _tmp269_;
#line 1451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp269_ = self->priv->current_subject_is_var;
#line 1451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp269_) {
#line 13867 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* _tmp270_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp271_;
			TrackerSparqlVariableBinding* _tmp272_;
			TrackerSparqlContext* _tmp273_;
			TrackerSparqlContext* _tmp274_;
			const gchar* _tmp275_;
			TrackerSparqlVariable* _tmp276_ = NULL;
			TrackerSparqlVariableBinding* _tmp277_;
			TrackerSparqlDataTable* _tmp278_;
			TrackerSparqlDataTable* _tmp279_;
			TrackerSparqlVariableBinding* _tmp280_;
			TrackerClass* _tmp281_;
			TrackerClass* _tmp282_;
			gboolean _tmp283_;
			GString* _tmp288_;
			TrackerSparqlVariableBinding* _tmp289_;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp270_ = tracker_sparql_variable_binding_new ();
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp270_;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp271_ = binding;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp271_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp272_ = binding;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp273_ = tracker_sparql_pattern_get_context (self);
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp274_ = _tmp273_;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp275_ = self->priv->current_subject;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp276_ = tracker_sparql_context_get_variable (_tmp274_, _tmp275_);
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp272_->variable = _tmp276_;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp277_ = binding;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp278_ = table;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp279_ = _g_object_ref0 (_tmp278_);
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp277_)->table);
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp277_)->table = _tmp279_;
#line 1456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp280_ = binding;
#line 1456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp281_ = subject_type;
#line 1456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp282_ = _g_object_ref0 (_tmp281_);
#line 1456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp280_->type);
#line 1456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp280_->type = _tmp282_;
#line 1457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp283_ = is_fts_match;
#line 1457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp283_) {
#line 13929 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp284_;
				gchar* _tmp285_;
#line 1458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp284_ = binding;
#line 1458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp285_ = g_strdup ("docid");
#line 1458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp284_)->sql_db_column_name);
#line 1458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp284_)->sql_db_column_name = _tmp285_;
#line 13940 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlVariableBinding* _tmp286_;
				gchar* _tmp287_;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp286_ = binding;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp287_ = g_strdup ("ID");
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name);
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name = _tmp287_;
#line 13952 "tracker-sparql-pattern.c"
			}
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp288_ = sql;
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp289_ = binding;
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp288_, _tmp289_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 13962 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp290_;
			TrackerSparqlLiteralBinding* binding;
			TrackerSparqlLiteralBinding* _tmp291_;
			TrackerSparqlLiteralBinding* _tmp292_;
			const gchar* _tmp293_;
			gchar* _tmp294_;
			TrackerSparqlLiteralBinding* _tmp295_;
			TrackerSparqlDataTable* _tmp296_;
			TrackerSparqlDataTable* _tmp297_;
			TrackerSparqlLiteralBinding* _tmp298_;
			gchar* _tmp299_;
			TrackerSparqlPatternTripleContext* _tmp300_;
			TrackerSparqlLiteralBinding* _tmp301_;
			TrackerSparqlLiteralBinding* _tmp302_;
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp290_ = tracker_sparql_literal_binding_new ();
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp290_;
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp291_ = binding;
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp291_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp292_ = binding;
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp293_ = self->priv->current_subject;
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp294_ = g_strdup (_tmp293_);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp292_->literal);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp292_->literal = _tmp294_;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp295_ = binding;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp296_ = table;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp297_ = _g_object_ref0 (_tmp296_);
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp295_)->table);
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp295_)->table = _tmp297_;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp298_ = binding;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp299_ = g_strdup ("ID");
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (((TrackerSparqlDataBinding*) _tmp298_)->sql_db_column_name);
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp298_)->sql_db_column_name = _tmp299_;
#line 1471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp300_ = self->priv->triple_context;
#line 1471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp301_ = binding;
#line 1471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp302_ = _g_object_ref0 (_tmp301_);
#line 1471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp300_->bindings = g_list_append (_tmp300_->bindings, _tmp302_);
#line 1451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 14024 "tracker-sparql-pattern.c"
		}
	}
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp303_ = rdftype;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp303_) {
#line 14031 "tracker-sparql-pattern.c"
		gboolean _tmp304_;
		const gchar* _tmp393_;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp304_ = object_is_var;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp304_) {
#line 14038 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* _tmp305_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp306_;
			TrackerSparqlContext* _tmp307_;
			TrackerSparqlContext* _tmp308_;
			const gchar* _tmp309_;
			TrackerSparqlVariable* _tmp310_ = NULL;
			TrackerSparqlVariableBinding* _tmp311_;
			TrackerSparqlDataTable* _tmp312_;
			TrackerSparqlDataTable* _tmp313_;
			TrackerProperty* _tmp314_;
			TrackerSparqlVariableState state = 0;
			gboolean _tmp339_;
			GString* _tmp340_;
			TrackerSparqlVariableBinding* _tmp341_;
			TrackerSparqlVariableState _tmp342_;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp305_ = tracker_sparql_variable_binding_new ();
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp305_;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp306_ = binding;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp307_ = tracker_sparql_pattern_get_context (self);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp308_ = _tmp307_;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp309_ = object;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp310_ = tracker_sparql_context_get_variable (_tmp308_, _tmp309_);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp306_->variable = _tmp310_;
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp311_ = binding;
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp312_ = table;
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp313_ = _g_object_ref0 (_tmp312_);
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp311_)->table);
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp311_)->table = _tmp313_;
#line 1480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp314_ = prop;
#line 1480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp314_ != NULL) {
#line 14085 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp315_;
				TrackerProperty* _tmp316_;
				TrackerClass* _tmp317_;
				TrackerClass* _tmp318_;
				TrackerClass* _tmp319_;
				TrackerSparqlVariableBinding* _tmp320_;
				TrackerProperty* _tmp321_;
				TrackerPropertyType _tmp322_;
				TrackerPropertyType _tmp323_;
				TrackerSparqlVariableBinding* _tmp324_;
				TrackerProperty* _tmp325_;
				const gchar* _tmp326_;
				const gchar* _tmp327_;
				gchar* _tmp328_;
				TrackerProperty* _tmp329_;
				gboolean _tmp330_;
				gboolean _tmp331_;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp315_ = binding;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp316_ = prop;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp317_ = tracker_property_get_range (_tmp316_);
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp318_ = _tmp317_;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp319_ = _g_object_ref0 (_tmp318_);
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp315_->type);
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp315_->type = _tmp319_;
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp320_ = binding;
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp321_ = prop;
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp322_ = tracker_property_get_data_type (_tmp321_);
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp323_ = _tmp322_;
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp320_)->data_type = _tmp323_;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp324_ = binding;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp325_ = prop;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp326_ = tracker_property_get_name (_tmp325_);
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp327_ = _tmp326_;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp328_ = g_strdup (_tmp327_);
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp324_)->sql_db_column_name);
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp324_)->sql_db_column_name = _tmp328_;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp329_ = prop;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp330_ = tracker_property_get_multiple_values (_tmp329_);
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp331_ = _tmp330_;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp331_) {
#line 14149 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp332_;
					TrackerSparqlVariableBinding* _tmp333_;
					gboolean _tmp334_;
#line 1489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp332_ = binding;
#line 1489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp332_->maybe_null = TRUE;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp333_ = binding;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp334_ = in_simple_optional;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp333_->in_simple_optional = _tmp334_;
#line 14163 "tracker-sparql-pattern.c"
				}
			} else {
				TrackerSparqlVariableBinding* _tmp335_;
				TrackerSparqlVariableBinding* _tmp336_;
				gchar* _tmp337_;
				TrackerSparqlVariableBinding* _tmp338_;
#line 1494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp335_ = binding;
#line 1494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp335_)->data_type = TRACKER_PROPERTY_TYPE_STRING;
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp336_ = binding;
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp337_ = g_strdup ("object");
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp336_)->sql_db_column_name);
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp336_)->sql_db_column_name = _tmp337_;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp338_ = binding;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp338_->maybe_null = TRUE;
#line 14186 "tracker-sparql-pattern.c"
			}
#line 1500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp339_ = in_simple_optional;
#line 1500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp339_) {
#line 1501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 14194 "tracker-sparql-pattern.c"
			} else {
#line 1503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 14198 "tracker-sparql-pattern.c"
			}
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp340_ = sql;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp341_ = binding;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp342_ = state;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp340_, _tmp341_, _tmp342_);
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 14210 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp343_;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp343_ = is_fts_match;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp343_) {
#line 14217 "tracker-sparql-pattern.c"
				TrackerSparqlLiteralBinding* _tmp344_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp345_;
				TrackerSparqlLiteralBinding* _tmp346_;
				const gchar* _tmp347_;
				gchar* _tmp348_;
				TrackerSparqlLiteralBinding* _tmp349_;
				TrackerSparqlDataTable* _tmp350_;
				TrackerSparqlDataTable* _tmp351_;
				TrackerSparqlLiteralBinding* _tmp352_;
				gchar* _tmp353_;
				TrackerSparqlPatternTripleContext* _tmp354_;
				TrackerSparqlLiteralBinding* _tmp355_;
				TrackerSparqlLiteralBinding* _tmp356_;
				GString* _tmp357_;
				TrackerSparqlLiteralBinding* _tmp358_;
				TrackerSparqlDataTable* _tmp359_;
				const gchar* _tmp360_;
				GString* _tmp361_;
				TrackerSparqlLiteralBinding* _tmp362_;
				TrackerSparqlDataTable* _tmp363_;
				const gchar* _tmp364_;
				TrackerSparqlContext* _tmp365_;
				TrackerSparqlContext* _tmp366_;
				const gchar* _tmp367_;
				TrackerSparqlVariable* _tmp368_ = NULL;
				const gchar* _tmp369_;
				const gchar* _tmp370_;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp344_ = tracker_sparql_literal_binding_new ();
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp344_;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp345_ = binding;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp345_->is_fts_match = TRUE;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp346_ = binding;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp347_ = object;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp348_ = g_strdup (_tmp347_);
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp346_->literal);
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp346_->literal = _tmp348_;
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp349_ = binding;
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp350_ = table;
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp351_ = _g_object_ref0 (_tmp350_);
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp349_)->table);
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp349_)->table = _tmp351_;
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp352_ = binding;
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp353_ = g_strdup ("fts");
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp352_)->sql_db_column_name);
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp352_)->sql_db_column_name = _tmp353_;
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp354_ = self->priv->triple_context;
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp355_ = binding;
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp356_ = _g_object_ref0 (_tmp355_);
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp354_->bindings = g_list_append (_tmp354_->bindings, _tmp356_);
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp357_ = sql;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp358_ = binding;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp359_ = ((TrackerSparqlDataBinding*) _tmp358_)->table;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp360_ = _tmp359_->sql_query_tablename;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp357_, "\"%s\".\"docid\" AS \"ID\", ", _tmp360_);
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp361_ = sql;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp362_ = binding;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp363_ = ((TrackerSparqlDataBinding*) _tmp362_)->table;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp364_ = _tmp363_->sql_query_tablename;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp365_ = tracker_sparql_pattern_get_context (self);
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp366_ = _tmp365_;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp367_ = self->priv->current_subject;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp368_ = tracker_sparql_context_get_variable (_tmp366_, _tmp367_);
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp369_ = tracker_sparql_variable_get_name (_tmp368_);
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp370_ = _tmp369_;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp361_, "tracker_rank(matchinfo(\"%s\".\"fts\", 'cl'),fts_column_weights()) " "AS \"%s_u_rank\", ", _tmp364_, _tmp370_);
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 14324 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* _tmp371_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp372_;
				const gchar* _tmp373_;
				gchar* _tmp374_;
				TrackerSparqlLiteralBinding* _tmp375_;
				TrackerSparqlDataTable* _tmp376_;
				TrackerSparqlDataTable* _tmp377_;
				TrackerProperty* _tmp378_;
				TrackerSparqlPatternTripleContext* _tmp390_;
				TrackerSparqlLiteralBinding* _tmp391_;
				TrackerSparqlLiteralBinding* _tmp392_;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp371_ = tracker_sparql_literal_binding_new ();
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp371_;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp372_ = binding;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp373_ = object;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp374_ = g_strdup (_tmp373_);
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp372_->literal);
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp372_->literal = _tmp374_;
#line 1526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp375_ = binding;
#line 1526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp376_ = table;
#line 1526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp377_ = _g_object_ref0 (_tmp376_);
#line 1526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp375_)->table);
#line 1526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp375_)->table = _tmp377_;
#line 1527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp378_ = prop;
#line 1527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp378_ != NULL) {
#line 14366 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp379_;
					TrackerProperty* _tmp380_;
					TrackerPropertyType _tmp381_;
					TrackerPropertyType _tmp382_;
					TrackerSparqlLiteralBinding* _tmp383_;
					TrackerProperty* _tmp384_;
					const gchar* _tmp385_;
					const gchar* _tmp386_;
					gchar* _tmp387_;
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp379_ = binding;
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp380_ = prop;
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp381_ = tracker_property_get_data_type (_tmp380_);
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp382_ = _tmp381_;
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp379_)->data_type = _tmp382_;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp383_ = binding;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp384_ = prop;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp385_ = tracker_property_get_name (_tmp384_);
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp386_ = _tmp385_;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp387_ = g_strdup (_tmp386_);
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp383_)->sql_db_column_name);
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp383_)->sql_db_column_name = _tmp387_;
#line 14400 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp388_;
					gchar* _tmp389_;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp388_ = binding;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp389_ = g_strdup ("object");
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp388_)->sql_db_column_name);
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp388_)->sql_db_column_name = _tmp389_;
#line 14412 "tracker-sparql-pattern.c"
				}
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp390_ = self->priv->triple_context;
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp391_ = binding;
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp392_ = _g_object_ref0 (_tmp391_);
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp390_->bindings = g_list_append (_tmp390_->bindings, _tmp392_);
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 14424 "tracker-sparql-pattern.c"
			}
		}
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp393_ = self->current_graph;
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp393_ != NULL) {
#line 14431 "tracker-sparql-pattern.c"
			gboolean _tmp394_;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp394_ = self->priv->current_graph_is_var;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp394_) {
#line 14437 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp395_;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlVariableBinding* _tmp396_;
				TrackerSparqlContext* _tmp397_;
				TrackerSparqlContext* _tmp398_;
				const gchar* _tmp399_;
				TrackerSparqlVariable* _tmp400_ = NULL;
				TrackerSparqlVariableBinding* _tmp401_;
				TrackerSparqlDataTable* _tmp402_;
				TrackerSparqlDataTable* _tmp403_;
				TrackerSparqlVariableBinding* _tmp404_;
				TrackerProperty* _tmp405_;
				TrackerSparqlVariableBinding* _tmp413_;
				TrackerSparqlVariableBinding* _tmp414_;
				gboolean _tmp415_;
				TrackerSparqlVariableState state = 0;
				gboolean _tmp416_;
				GString* _tmp417_;
				TrackerSparqlVariableBinding* _tmp418_;
				TrackerSparqlVariableState _tmp419_;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp395_ = tracker_sparql_variable_binding_new ();
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp395_;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp396_ = binding;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp397_ = tracker_sparql_pattern_get_context (self);
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp398_ = _tmp397_;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp399_ = self->current_graph;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp400_ = tracker_sparql_context_get_variable (_tmp398_, _tmp399_);
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp396_->variable = _tmp400_;
#line 1541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp401_ = binding;
#line 1541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp402_ = table;
#line 1541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp403_ = _g_object_ref0 (_tmp402_);
#line 1541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp401_)->table);
#line 1541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp401_)->table = _tmp403_;
#line 1542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp404_ = binding;
#line 1542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp404_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp405_ = prop;
#line 1544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp405_ != NULL) {
#line 14492 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp406_;
					TrackerProperty* _tmp407_;
					const gchar* _tmp408_;
					const gchar* _tmp409_;
					gchar* _tmp410_;
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp406_ = binding;
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp407_ = prop;
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp408_ = tracker_property_get_name (_tmp407_);
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp409_ = _tmp408_;
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp410_ = g_strconcat (_tmp409_, ":graph", NULL);
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp406_)->sql_db_column_name);
#line 1545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp406_)->sql_db_column_name = _tmp410_;
#line 14512 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlVariableBinding* _tmp411_;
					gchar* _tmp412_;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp411_ = binding;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp412_ = g_strdup ("graph");
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp411_)->sql_db_column_name);
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp411_)->sql_db_column_name = _tmp412_;
#line 14524 "tracker-sparql-pattern.c"
				}
#line 1551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp413_ = binding;
#line 1551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp413_->maybe_null = TRUE;
#line 1552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp414_ = binding;
#line 1552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp415_ = in_simple_optional;
#line 1552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp414_->in_simple_optional = _tmp415_;
#line 1555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp416_ = in_simple_optional;
#line 1555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp416_) {
#line 1556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 14542 "tracker-sparql-pattern.c"
				} else {
#line 1558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 14546 "tracker-sparql-pattern.c"
				}
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp417_ = sql;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp418_ = binding;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp419_ = state;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_add_variable_binding (self, _tmp417_, _tmp418_, _tmp419_);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 14558 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* _tmp420_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp421_;
				const gchar* _tmp422_;
				gchar* _tmp423_;
				TrackerSparqlLiteralBinding* _tmp424_;
				TrackerSparqlDataTable* _tmp425_;
				TrackerSparqlDataTable* _tmp426_;
				TrackerSparqlLiteralBinding* _tmp427_;
				TrackerProperty* _tmp428_;
				TrackerSparqlPatternTripleContext* _tmp436_;
				TrackerSparqlLiteralBinding* _tmp437_;
				TrackerSparqlLiteralBinding* _tmp438_;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp420_ = tracker_sparql_literal_binding_new ();
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp420_;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp421_ = binding;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp422_ = self->current_graph;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp423_ = g_strdup (_tmp422_);
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp421_->literal);
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp421_->literal = _tmp423_;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp424_ = binding;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp425_ = table;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp426_ = _g_object_ref0 (_tmp425_);
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp424_)->table);
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp424_)->table = _tmp426_;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp427_ = binding;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp427_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp428_ = prop;
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp428_ != NULL) {
#line 14605 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp429_;
					TrackerProperty* _tmp430_;
					const gchar* _tmp431_;
					const gchar* _tmp432_;
					gchar* _tmp433_;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp429_ = binding;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp430_ = prop;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp431_ = tracker_property_get_name (_tmp430_);
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp432_ = _tmp431_;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp433_ = g_strconcat (_tmp432_, ":graph", NULL);
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp429_)->sql_db_column_name);
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp429_)->sql_db_column_name = _tmp433_;
#line 14625 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp434_;
					gchar* _tmp435_;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp434_ = binding;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp435_ = g_strdup ("graph");
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp434_)->sql_db_column_name);
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp434_)->sql_db_column_name = _tmp435_;
#line 14637 "tracker-sparql-pattern.c"
				}
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp436_ = self->priv->triple_context;
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp437_ = binding;
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp438_ = _g_object_ref0 (_tmp437_);
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp436_->bindings = g_list_append (_tmp436_->bindings, _tmp438_);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 14649 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp439_ = sql;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp440_ = _tmp439_->len;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp441_ = begin_sql_len;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp440_ == ((gssize) _tmp441_)) {
#line 14661 "tracker-sparql-pattern.c"
		GString* _tmp442_;
#line 1583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp442_ = sql;
#line 1583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp442_, "1, ");
#line 14667 "tracker-sparql-pattern.c"
	}
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (subject_type);
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (prop);
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (table);
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (db_table);
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (object);
#line 14679 "tracker-sparql-pattern.c"
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable) {
	gboolean _vala_newtable = FALSE;
	TrackerSparqlDataTable* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* tablestring;
	TrackerSparqlDataTable* table;
	gboolean _tmp3_;
	TrackerSparqlDataTable* _tmp9_;
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (db_table != NULL, NULL);
#line 1588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = subject;
#line 1588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = db_table;
#line 1588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_strdup_printf ("%s.%s", _tmp0_, _tmp1_);
#line 1588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tablestring = _tmp2_;
#line 1589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	table = NULL;
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_newtable = FALSE;
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = share_table;
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_) {
#line 14715 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp4_;
		GHashTable* _tmp5_;
		const gchar* _tmp6_;
		gconstpointer _tmp7_ = NULL;
		TrackerSparqlDataTable* _tmp8_;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = self->priv->triple_context;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_->table_map;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tablestring;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _g_object_ref0 ((TrackerSparqlDataTable*) _tmp7_);
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp8_;
#line 14735 "tracker-sparql-pattern.c"
	}
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = table;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp9_ == NULL) {
#line 14741 "tracker-sparql-pattern.c"
		TrackerSparqlDataTable* _tmp10_;
		TrackerSparqlDataTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		TrackerSparqlDataTable* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		TrackerSparqlPatternTripleContext* _tmp21_;
		TrackerSparqlDataTable* _tmp22_;
		TrackerSparqlDataTable* _tmp23_;
		TrackerSparqlPatternTripleContext* _tmp24_;
		GHashTable* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		TrackerSparqlDataTable* _tmp28_;
		TrackerSparqlDataTable* _tmp29_;
#line 1595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_newtable = TRUE;
#line 1596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_data_table_new ();
#line 1596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp10_;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = table;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = db_table;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_->sql_db_tablename);
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->sql_db_tablename = _tmp13_;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = table;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = db_table;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = self->priv->counter;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp16_ + 1;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = self->priv->counter;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp18_;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp14_->sql_query_tablename);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_->sql_query_tablename = _tmp20_;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp19_);
#line 1599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = self->priv->triple_context;
#line 1599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = table;
#line 1599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 1599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_->tables = g_list_append (_tmp21_->tables, _tmp23_);
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = self->priv->triple_context;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = _tmp24_->table_map;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = tablestring;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = table;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
#line 14824 "tracker-sparql-pattern.c"
	}
#line 1602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = table;
#line 1602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (tablestring);
#line 1602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (newtable) {
#line 1602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*newtable = _vala_newtable;
#line 14834 "tracker-sparql-pattern.c"
	}
#line 1602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 14838 "tracker-sparql-pattern.c"
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->context;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 14856 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = value;
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_tmp0_->context);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_->context = _tmp2_;
#line 14876 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GDestroyNotify _tmp4_;
	GDestroyNotify _tmp5_;
	GHashTable* _tmp6_;
	GDestroyNotify _tmp7_;
	GDestroyNotify _tmp8_;
	GHashTable* _tmp9_;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = parent_context;
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, _tmp0_, _tmp1_);
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->tables = NULL;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_str_hash;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_str_equal;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_free;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = g_object_unref;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = g_hash_table_new_full (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->table_map = _tmp6_;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->variables = NULL;
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = g_object_unref;
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp8_ = g_object_unref;
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp7_, _tmp8_);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->var_bindings = _tmp9_;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->bindings = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 14940 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, query, parent_context);
#line 14947 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
#line 14956 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlPatternTripleContext * self;
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
#line 14980 "tracker-sparql-pattern.c"
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_pattern_get_property;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_pattern_set_property;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
#line 15007 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->queries_fts_data = FALSE;
#line 15016 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_finalize (GObject* obj) {
	TrackerSparqlPattern * self;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->current_graph);
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_subject);
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_predicate);
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_variables = (_vala_array_free (self->fts_variables, self->fts_variables_length1, (GDestroyNotify) g_free), NULL);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
#line 15040 "tracker-sparql-pattern.c"
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 15061 "tracker-sparql-pattern.c"
		default:
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 15067 "tracker-sparql-pattern.c"
	}
}


static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 15077 "tracker-sparql-pattern.c"
		default:
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 15083 "tracker-sparql-pattern.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



