/* tracker-needle.c generated by valac 0.22.0, the Vala compiler
 * generated from tracker-needle.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_NEEDLE (tracker_needle_get_type ())
#define TRACKER_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedle))
#define TRACKER_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))
#define TRACKER_IS_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_NEEDLE))
#define TRACKER_IS_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_NEEDLE))
#define TRACKER_NEEDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))

typedef struct _TrackerNeedle TrackerNeedle;
typedef struct _TrackerNeedleClass TrackerNeedleClass;
typedef struct _TrackerNeedlePrivate TrackerNeedlePrivate;

#define TRACKER_TYPE_HISTORY (tracker_history_get_type ())
#define TRACKER_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_HISTORY, TrackerHistory))
#define TRACKER_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_HISTORY, TrackerHistoryClass))
#define TRACKER_IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_HISTORY))
#define TRACKER_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_HISTORY))
#define TRACKER_HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_HISTORY, TrackerHistoryClass))

typedef struct _TrackerHistory TrackerHistory;
typedef struct _TrackerHistoryClass TrackerHistoryClass;

#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _tracker_history_unref0(var) ((var == NULL) ? NULL : (var = (tracker_history_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _tracker_needle_unref0(var) ((var == NULL) ? NULL : (var = (tracker_needle_unref (var), NULL)))

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerParamSpecNeedle TrackerParamSpecNeedle;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _TrackerNeedle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerNeedlePrivate * priv;
};

struct _TrackerNeedleClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerNeedle *self);
};

struct _TrackerNeedlePrivate {
	TrackerHistory* history;
	GtkWindow* window;
	GtkToggleToolButton* view_categories;
	GtkToggleToolButton* view_filelist;
	GtkToggleToolButton* view_icons;
	GtkSeparatorToolItem* separator_secondary;
	GtkToggleToolButton* find_in_contents;
	GtkToggleToolButton* find_in_titles;
	GtkToggleToolButton* find_in_all;
	GtkToolItem* search_entry;
	GtkComboBox* search_list;
	GtkEntry* search;
	GtkSpinner* spinner;
	GtkToolItem* spinner_shell;
	GtkToggleToolButton* show_tags;
	GtkToolButton* show_stats;
	GtkHBox* view;
	TrackerView* sw_noresults;
	TrackerView* sw_categories;
	TrackerView* sw_filelist;
	TrackerView* sw_icons;
	GtkInfoBar* info_bar;
	GtkLabel* info_bar_label;
	TrackerTagsView* tags_view;
	guint last_search_id;
	gint size_small;
	gint size_medium;
	gint size_big;
	guint limit;
	TrackerResultStore* categories_model;
	TrackerResultStore* files_model;
	TrackerResultStore* files_in_title_model;
	TrackerResultStore* images_model;
	TrackerResultStore* images_in_title_model;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT,
	TRACKER_QUERY_MATCH_TAGS_ONLY,
	TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT
} TrackerQueryMatch;

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _Block4Data {
	int _ref_count_;
	TrackerNeedle * self;
	GtkTreeModel* model;
	GList* uris;
};

struct _TrackerParamSpecNeedle {
	GParamSpec parent_instance;
};


static gpointer tracker_needle_parent_class = NULL;
static gboolean tracker_needle_current_find_in_filelist;
static gboolean tracker_needle_current_find_in_filelist = TRUE;
static gboolean tracker_needle_current_find_in_icons;
static gboolean tracker_needle_current_find_in_icons = TRUE;
extern gboolean print_version;
gboolean print_version = FALSE;
extern gchar** search_criteria;
gchar** search_criteria = NULL;

gpointer tracker_needle_ref (gpointer instance);
void tracker_needle_unref (gpointer instance);
GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_needle (GValue* value, gpointer v_object);
void tracker_value_take_needle (GValue* value, gpointer v_object);
gpointer tracker_value_get_needle (const GValue* value);
GType tracker_needle_get_type (void) G_GNUC_CONST;
gpointer tracker_history_ref (gpointer instance);
void tracker_history_unref (gpointer instance);
GParamSpec* tracker_param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_history (GValue* value, gpointer v_object);
void tracker_value_take_history (GValue* value, gpointer v_object);
gpointer tracker_value_get_history (const GValue* value);
GType tracker_history_get_type (void) G_GNUC_CONST;
GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_NEEDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_NEEDLE, TrackerNeedlePrivate))
enum  {
	TRACKER_NEEDLE_DUMMY_PROPERTY
};
#define TRACKER_NEEDLE_UI_FILE "tracker-needle.ui"
static void tracker_needle_result_overflow (TrackerNeedle* self);
void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type);
static void tracker_needle_create_models (TrackerNeedle* self);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
void tracker_result_store_set_limit (TrackerResultStore* self, guint value);
static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
TrackerNeedle* tracker_needle_new (void);
TrackerNeedle* tracker_needle_construct (GType object_type);
TrackerHistory* tracker_history_new (void);
TrackerHistory* tracker_history_construct (GType object_type);
void tracker_needle_show (TrackerNeedle* self);
static void tracker_needle_setup_ui (TrackerNeedle* self);
void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1);
static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source);
static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tracker_needle_view_toggled (TrackerNeedle* self);
static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_find_in_toggled (TrackerNeedle* self);
static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable);
static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry);
static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1);
gchar** tracker_history_get (TrackerHistory* self, int* result_length1);
static void tracker_needle_show_tags_clicked (TrackerNeedle* self);
static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void tracker_needle_show_stats_clicked (TrackerNeedle* self);
static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GType tracker_view_display_get_type (void) G_GNUC_CONST;
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection);
static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path);
static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self);
static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
void tracker_tags_view_hide_label (TrackerTagsView* self);
static gboolean tracker_needle_search_run (TrackerNeedle* self);
static gboolean _tracker_needle_search_run_gsource_func (gpointer self);
static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
void tracker_history_add (TrackerHistory* self, const gchar* criteria);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
void tracker_result_store_set_search_tags (TrackerResultStore* self, GPtrArray* value);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void tracker_tags_view_set_files (TrackerTagsView* self, GList* _files);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda6_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path);
static void ___lambda6__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self);
GType tracker_stats_get_type (void) G_GNUC_CONST;
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
static void tracker_needle_finalize (TrackerNeedle* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[3] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &print_version, "Print version", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &search_criteria, "[SEARCH-CRITERIA]", "[SEARCH-CRITERIA]"}, {NULL}};

static void tracker_needle_result_overflow (TrackerNeedle* self) {
	gchar* str = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Search criteria was too generic");
	_tmp1_ = _ ("Only the first 500 items will be displayed");
	_tmp2_ = g_strdup_printf ("%s\n<small>%s</small>", _tmp0_, _tmp1_);
	str = _tmp2_;
	tracker_needle_show_info_message (self, str, GTK_MESSAGE_INFO);
	_g_free0 (str);
}


static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self) {
	tracker_needle_result_overflow (self);
}


static void tracker_needle_create_models (TrackerNeedle* self) {
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	TrackerResultStore* _tmp3_ = NULL;
	TrackerResultStore* _tmp4_ = NULL;
	TrackerResultStore* _tmp5_ = NULL;
	TrackerResultStore* _tmp6_ = NULL;
	TrackerResultStore* _tmp7_ = NULL;
	TrackerResultStore* _tmp8_ = NULL;
	TrackerResultStore* _tmp9_ = NULL;
	TrackerResultStore* _tmp10_ = NULL;
	TrackerResultStore* _tmp11_ = NULL;
	TrackerResultStore* _tmp12_ = NULL;
	TrackerResultStore* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	TrackerResultStore* _tmp15_ = NULL;
	TrackerResultStore* _tmp16_ = NULL;
	TrackerResultStore* _tmp17_ = NULL;
	TrackerResultStore* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	TrackerResultStore* _tmp20_ = NULL;
	TrackerResultStore* _tmp21_ = NULL;
	TrackerResultStore* _tmp22_ = NULL;
	TrackerResultStore* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	TrackerResultStore* _tmp25_ = NULL;
	TrackerResultStore* _tmp26_ = NULL;
	TrackerResultStore* _tmp27_ = NULL;
	TrackerResultStore* _tmp28_ = NULL;
	TrackerResultStore* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	TrackerResultStore* _tmp31_ = NULL;
	TrackerResultStore* _tmp32_ = NULL;
	TrackerResultStore* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_result_store_new (6);
	_g_object_unref0 (self->priv->categories_model);
	self->priv->categories_model = _tmp0_;
	_tmp1_ = self->priv->categories_model;
	_tmp2_ = self->priv->limit;
	tracker_result_store_set_limit (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->categories_model;
	g_signal_connect (_tmp3_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
	_tmp4_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp4_, TRACKER_QUERY_TYPE_APPLICATIONS, TRACKER_QUERY_MATCH_FTS, "?urn", "tracker:coalesce(nfo:softwareCmdLine(?urn), ?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:comment(?urn)", "\"\"", "\"\"", NULL);
	_tmp5_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp5_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((nfo:height(?urn), nfo:width(?urn)), \" x \")", "nfo:fileSize(?urn)", "nie:url(?urn)", NULL);
	_tmp6_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp6_, TRACKER_QUERY_TYPE_MUSIC, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((?performer, ?album), \" - \")", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
	_tmp7_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp7_, TRACKER_QUERY_TYPE_VIDEOS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "\"\"", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
	_tmp8_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp8_, TRACKER_QUERY_TYPE_DOCUMENTS, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?creator), nco:fullnam" \
"e(?publisher))", "nfo:pageCount(?urn)", "nie:url(?urn)", NULL);
	_tmp9_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp9_, TRACKER_QUERY_TYPE_MAIL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "nmo:messageSubject(?urn)", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?sender), nco:nickname" \
"(?sender), nco:emailAddress(?sender))", "nmo:receivedDate(?urn)", "fn:concat(\"To: \", tracker:coalesce(nco:fullname(?to), nco:nickname(?" \
"to), nco:emailAddress(?to)))", NULL);
	_tmp10_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp10_, TRACKER_QUERY_TYPE_FOLDERS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "nie:url(?parent)", "nfo:fileLastModified(?urn)", "?tooltip", NULL);
	_tmp11_ = self->priv->categories_model;
	tracker_result_store_add_query (_tmp11_, TRACKER_QUERY_TYPE_BOOKMARKS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?bookmark)", "nie:title(?urn)", "nie:url(?bookmark)", "nie:contentLastModified(?urn)", "nie:url(?bookmark)", NULL);
	_tmp12_ = tracker_result_store_new (7);
	_g_object_unref0 (self->priv->files_model);
	self->priv->files_model = _tmp12_;
	_tmp13_ = self->priv->files_model;
	_tmp14_ = self->priv->limit;
	tracker_result_store_set_limit (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->files_model;
	g_signal_connect (_tmp15_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
	_tmp16_ = self->priv->files_model;
	tracker_result_store_add_query (_tmp16_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
	_tmp17_ = tracker_result_store_new (7);
	_g_object_unref0 (self->priv->files_in_title_model);
	self->priv->files_in_title_model = _tmp17_;
	_tmp18_ = self->priv->files_in_title_model;
	_tmp19_ = self->priv->limit;
	tracker_result_store_set_limit (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->files_in_title_model;
	g_signal_connect (_tmp20_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
	_tmp21_ = self->priv->files_in_title_model;
	tracker_result_store_add_query (_tmp21_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
	_tmp22_ = tracker_result_store_new (6);
	_g_object_unref0 (self->priv->images_model);
	self->priv->images_model = _tmp22_;
	_tmp23_ = self->priv->images_model;
	_tmp24_ = self->priv->limit;
	tracker_result_store_set_limit (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->images_model;
	g_signal_connect (_tmp25_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
	_tmp26_ = self->priv->images_model;
	tracker_result_store_set_icon_size (_tmp26_, 128);
	_tmp27_ = self->priv->images_model;
	tracker_result_store_add_query (_tmp27_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_NONE, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
	_tmp28_ = tracker_result_store_new (6);
	_g_object_unref0 (self->priv->images_in_title_model);
	self->priv->images_in_title_model = _tmp28_;
	_tmp29_ = self->priv->images_in_title_model;
	_tmp30_ = self->priv->limit;
	tracker_result_store_set_limit (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->images_in_title_model;
	g_signal_connect (_tmp31_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
	_tmp32_ = self->priv->images_in_title_model;
	tracker_result_store_set_icon_size (_tmp32_, 128);
	_tmp33_ = self->priv->images_in_title_model;
	tracker_result_store_add_query (_tmp33_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
}


TrackerNeedle* tracker_needle_construct (GType object_type) {
	TrackerNeedle* self = NULL;
	TrackerHistory* _tmp0_ = NULL;
	self = (TrackerNeedle*) g_type_create_instance (object_type);
	tracker_needle_create_models (self);
	_tmp0_ = tracker_history_new ();
	_tracker_history_unref0 (self->priv->history);
	self->priv->history = _tmp0_;
	return self;
}


TrackerNeedle* tracker_needle_new (void) {
	return tracker_needle_construct (TRACKER_TYPE_NEEDLE);
}


void tracker_needle_show (TrackerNeedle* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_needle_setup_ui (self);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	if (_tmp0_ != NULL) {
		gchar* text = NULL;
		gchar* _tmp1_ = NULL;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp12_ = NULL;
		GtkEntry* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp1_ = g_strdup ("");
		text = _tmp1_;
		_tmp2_ = args;
		_tmp2__length1 = args_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp2_;
			s_collection_length1 = _tmp2__length1;
			for (s_it = 0; s_it < _tmp2__length1; s_it = s_it + 1) {
				gchar* _tmp3_ = NULL;
				gchar* s = NULL;
				_tmp3_ = g_strdup (s_collection[s_it]);
				s = _tmp3_;
				{
					const gchar* _tmp4_ = NULL;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					const gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp4_ = text;
					_tmp5_ = strlen (_tmp4_);
					_tmp6_ = _tmp5_;
					if (_tmp6_ > 1) {
						const gchar* _tmp7_ = NULL;
						gchar* _tmp8_ = NULL;
						_tmp7_ = text;
						_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
						_g_free0 (text);
						text = _tmp8_;
					}
					_tmp9_ = text;
					_tmp10_ = s;
					_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
					_g_free0 (text);
					text = _tmp11_;
					_g_free0 (s);
				}
			}
		}
		_tmp12_ = text;
		g_debug ("tracker-needle.vala:223: Setting search criteria to: '%s'\n", _tmp12_);
		_tmp13_ = self->priv->search;
		_tmp14_ = text;
		gtk_entry_set_text (_tmp13_, _tmp14_);
		_g_free0 (text);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p) {
	TrackerResultStore* store = NULL;
	GObject* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	TrackerResultStore* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TRACKER_TYPE_RESULT_STORE, TrackerResultStore));
	store = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = tracker_result_store_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkToolItem* _tmp5_ = NULL;
		GtkSpinner* _tmp6_ = NULL;
		_tmp5_ = self->priv->spinner_shell;
		gtk_widget_show_all ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->spinner;
		gtk_spinner_start (_tmp6_);
	} else {
		GtkToolItem* _tmp7_ = NULL;
		GtkSpinner* _tmp8_ = NULL;
		_tmp7_ = self->priv->spinner_shell;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->spinner;
		gtk_spinner_stop (_tmp8_);
	}
	_g_object_unref0 (store);
}


static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	gtk_main_quit ();
}


static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_window_key_press_event (self, _sender, event);
	return result;
}


static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tracker_needle_info_bar_closed (self, _sender);
}


static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	tracker_needle_view_toggled (self);
}


static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	tracker_needle_find_in_toggled (self);
}


static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	tracker_needle_search_changed (self, _sender);
}


static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	tracker_needle_search_activated (self, _sender);
}


static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	tracker_needle_show_tags_clicked (self);
}


static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	tracker_needle_show_stats_clicked (self);
}


static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tracker_needle_store_state_changed (self, _sender, pspec);
}


static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	tracker_needle_view_row_activated (self, _sender, path, column);
}


static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	tracker_needle_view_row_selected (self, _sender);
}


static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	tracker_needle_icon_item_activated (self, _sender, path);
}


static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	tracker_needle_icon_view_selection_changed (self);
}


static void tracker_needle_setup_ui (TrackerNeedle* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkButton* info_bar_button = NULL;
	GtkToolbar* toolbar = NULL;
	GtkPaned* paned = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GObject* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GtkWindow* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkToolbar* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkInfoBar* _tmp16_ = NULL;
	GObject* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkToggleToolButton* _tmp22_ = NULL;
	GtkToggleToolButton* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkToggleToolButton* _tmp25_ = NULL;
	GtkToggleToolButton* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkToggleToolButton* _tmp28_ = NULL;
	GtkToggleToolButton* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	GtkSeparatorToolItem* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkToggleToolButton* _tmp33_ = NULL;
	GtkToggleToolButton* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkToggleToolButton* _tmp36_ = NULL;
	GtkToggleToolButton* _tmp37_ = NULL;
	GObject* _tmp38_ = NULL;
	GtkToggleToolButton* _tmp39_ = NULL;
	GtkToggleToolButton* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	GtkToolItem* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkComboBox* _tmp44_ = NULL;
	GtkComboBox* _tmp45_ = NULL;
	GtkWidget* _tmp46_ = NULL;
	GtkEntry* _tmp47_ = NULL;
	GtkEntry* _tmp48_ = NULL;
	GtkEntry* _tmp49_ = NULL;
	TrackerHistory* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	gchar** _tmp52_ = NULL;
	gchar** _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	GtkSpinner* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkToolItem* _tmp56_ = NULL;
	GtkToolItem* _tmp57_ = NULL;
	GtkSpinner* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkToggleToolButton* _tmp60_ = NULL;
	GtkToggleToolButton* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkToolButton* _tmp63_ = NULL;
	GtkToolButton* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkHBox* _tmp66_ = NULL;
	GtkTreeView* treeview = NULL;
	GtkIconView* iconview = NULL;
	GtkTreeSelection* treeselection = NULL;
	TrackerViewDisplay _tmp67_ = 0;
	TrackerView* _tmp68_ = NULL;
	GtkHBox* _tmp69_ = NULL;
	TrackerView* _tmp70_ = NULL;
	TrackerViewDisplay _tmp71_ = 0;
	TrackerResultStore* _tmp72_ = NULL;
	TrackerView* _tmp73_ = NULL;
	TrackerView* _tmp74_ = NULL;
	TrackerResultStore* _tmp75_ = NULL;
	TrackerResultStore* _tmp76_ = NULL;
	TrackerView* _tmp77_ = NULL;
	GtkWidget* _tmp78_ = NULL;
	GtkTreeView* _tmp79_ = NULL;
	GtkTreeView* _tmp80_ = NULL;
	GtkTreeView* _tmp81_ = NULL;
	GtkTreeSelection* _tmp82_ = NULL;
	GtkTreeSelection* _tmp83_ = NULL;
	GtkTreeSelection* _tmp84_ = NULL;
	GtkHBox* _tmp85_ = NULL;
	TrackerView* _tmp86_ = NULL;
	TrackerViewDisplay _tmp87_ = 0;
	TrackerView* _tmp88_ = NULL;
	TrackerView* _tmp89_ = NULL;
	GtkWidget* _tmp90_ = NULL;
	GtkTreeView* _tmp91_ = NULL;
	GtkTreeView* _tmp92_ = NULL;
	GtkTreeView* _tmp93_ = NULL;
	GtkTreeSelection* _tmp94_ = NULL;
	GtkTreeSelection* _tmp95_ = NULL;
	GtkTreeSelection* _tmp96_ = NULL;
	GtkHBox* _tmp97_ = NULL;
	TrackerView* _tmp98_ = NULL;
	TrackerViewDisplay _tmp99_ = 0;
	TrackerView* _tmp100_ = NULL;
	TrackerView* _tmp101_ = NULL;
	GtkWidget* _tmp102_ = NULL;
	GtkIconView* _tmp103_ = NULL;
	GtkHBox* _tmp104_ = NULL;
	TrackerView* _tmp105_ = NULL;
	GObject* _tmp106_ = NULL;
	GtkPaned* _tmp107_ = NULL;
	TrackerTagsView* _tmp108_ = NULL;
	TrackerTagsView* _tmp109_ = NULL;
	TrackerTagsView* _tmp110_ = NULL;
	TrackerTagsView* _tmp111_ = NULL;
	GtkToggleToolButton* _tmp112_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		gtk_builder_add_from_file (builder, SRCDIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
		}
		goto __finally29;
		__catch29_g_error:
		{
			GError* e = NULL;
			GtkMessageDialog* msg = NULL;
			GError* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GtkMessageDialog* _tmp3_ = NULL;
			GtkMessageDialog* _tmp4_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", _tmp2_);
			g_object_ref_sink (_tmp3_);
			msg = _tmp3_;
			_tmp4_ = msg;
			gtk_dialog_run ((GtkDialog*) _tmp4_);
			gtk_main_quit ();
			_g_object_unref0 (msg);
			_g_error_free0 (e);
		}
		__finally29:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (paned);
			_g_object_unref0 (toolbar);
			_g_object_unref0 (info_bar_button);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (paned);
		_g_object_unref0 (toolbar);
		_g_object_unref0 (info_bar_button);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp5_, NULL);
	self->priv->size_small = _tmp5_;
	gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp6_, NULL);
	self->priv->size_medium = _tmp6_;
	gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp7_, NULL);
	self->priv->size_big = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "window_needle");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp9_;
	_tmp10_ = self->priv->window;
	g_signal_connect ((GtkWidget*) _tmp10_, "destroy", (GCallback) _gtk_main_quit_gtk_widget_destroy, NULL);
	_tmp11_ = self->priv->window;
	g_signal_connect ((GtkWidget*) _tmp11_, "key-press-event", (GCallback) _tracker_needle_window_key_press_event_gtk_widget_key_press_event, self);
	_tmp12_ = gtk_builder_get_object (builder, "toolbar_main");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_TOOLBAR) ? ((GtkToolbar*) _tmp12_) : NULL);
	_g_object_unref0 (toolbar);
	toolbar = _tmp13_;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp14_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp15_ = gtk_builder_get_object (builder, "info_bar");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GTK_TYPE_INFO_BAR) ? ((GtkInfoBar*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp16_;
	_tmp17_ = gtk_builder_get_object (builder, "info_bar_label");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->info_bar_label);
	self->priv->info_bar_label = _tmp18_;
	_tmp19_ = gtk_builder_get_object (builder, "info_bar_button");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp19_) : NULL);
	_g_object_unref0 (info_bar_button);
	info_bar_button = _tmp20_;
	g_signal_connect (info_bar_button, "clicked", (GCallback) _tracker_needle_info_bar_closed_gtk_button_clicked, self);
	_tmp21_ = gtk_builder_get_object (builder, "toolbutton_view_filelist");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->view_filelist);
	self->priv->view_filelist = _tmp22_;
	_tmp23_ = self->priv->view_filelist;
	g_signal_connect (_tmp23_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp24_ = gtk_builder_get_object (builder, "toolbutton_view_icons");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->view_icons);
	self->priv->view_icons = _tmp25_;
	_tmp26_ = self->priv->view_icons;
	g_signal_connect (_tmp26_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp27_ = gtk_builder_get_object (builder, "toolbutton_view_categories");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->view_categories);
	self->priv->view_categories = _tmp28_;
	_tmp29_ = self->priv->view_categories;
	g_signal_connect (_tmp29_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp30_ = gtk_builder_get_object (builder, "separator_secondary");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, GTK_TYPE_SEPARATOR_TOOL_ITEM) ? ((GtkSeparatorToolItem*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->separator_secondary);
	self->priv->separator_secondary = _tmp31_;
	_tmp32_ = gtk_builder_get_object (builder, "toolbutton_find_in_contents");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp32_) : NULL);
	_g_object_unref0 (self->priv->find_in_contents);
	self->priv->find_in_contents = _tmp33_;
	_tmp34_ = self->priv->find_in_contents;
	g_signal_connect (_tmp34_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp35_ = gtk_builder_get_object (builder, "toolbutton_find_in_titles");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp35_) : NULL);
	_g_object_unref0 (self->priv->find_in_titles);
	self->priv->find_in_titles = _tmp36_;
	_tmp37_ = self->priv->find_in_titles;
	g_signal_connect (_tmp37_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp38_ = gtk_builder_get_object (builder, "toolbutton_find_in_all");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->find_in_all);
	self->priv->find_in_all = _tmp39_;
	_tmp40_ = self->priv->find_in_all;
	g_signal_connect (_tmp40_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
	_tmp41_ = gtk_builder_get_object (builder, "toolitem_search_entry");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, GTK_TYPE_TOOL_ITEM) ? ((GtkToolItem*) _tmp41_) : NULL);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp42_;
	_tmp43_ = gtk_builder_get_object (builder, "combobox_search");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp43_) : NULL);
	_g_object_unref0 (self->priv->search_list);
	self->priv->search_list = _tmp44_;
	_tmp45_ = self->priv->search_list;
	_tmp46_ = gtk_bin_get_child ((GtkBin*) _tmp45_);
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp46_) : NULL);
	_g_object_unref0 (self->priv->search);
	self->priv->search = _tmp47_;
	_tmp48_ = self->priv->search;
	g_signal_connect ((GtkEditable*) _tmp48_, "changed", (GCallback) _tracker_needle_search_changed_gtk_editable_changed, self);
	_tmp49_ = self->priv->search;
	g_signal_connect (_tmp49_, "activate", (GCallback) _tracker_needle_search_activated_gtk_entry_activate, self);
	_tmp50_ = self->priv->history;
	_tmp52_ = tracker_history_get (_tmp50_, &_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp53__length1 = _tmp51_;
	tracker_needle_search_history_insert (self, _tmp53_, _tmp51_);
	_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
	_tmp54_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp54_;
	_tmp55_ = gtk_builder_get_object (builder, "toolcustom_spinner");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, GTK_TYPE_TOOL_ITEM) ? ((GtkToolItem*) _tmp55_) : NULL);
	_g_object_unref0 (self->priv->spinner_shell);
	self->priv->spinner_shell = _tmp56_;
	_tmp57_ = self->priv->spinner_shell;
	_tmp58_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = gtk_builder_get_object (builder, "toolbutton_show_tags");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, GTK_TYPE_TOGGLE_TOOL_BUTTON) ? ((GtkToggleToolButton*) _tmp59_) : NULL);
	_g_object_unref0 (self->priv->show_tags);
	self->priv->show_tags = _tmp60_;
	_tmp61_ = self->priv->show_tags;
	g_signal_connect ((GtkToolButton*) _tmp61_, "clicked", (GCallback) _tracker_needle_show_tags_clicked_gtk_tool_button_clicked, self);
	_tmp62_ = gtk_builder_get_object (builder, "toolbutton_show_stats");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GTK_TYPE_TOOL_BUTTON) ? ((GtkToolButton*) _tmp62_) : NULL);
	_g_object_unref0 (self->priv->show_stats);
	self->priv->show_stats = _tmp63_;
	_tmp64_ = self->priv->show_stats;
	g_signal_connect (_tmp64_, "clicked", (GCallback) _tracker_needle_show_stats_clicked_gtk_tool_button_clicked, self);
	_tmp65_ = gtk_builder_get_object (builder, "hbox_view");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, GTK_TYPE_HBOX) ? ((GtkHBox*) _tmp65_) : NULL);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp66_;
	_tmp67_ = TRACKER_VIEW_DISPLAY_NO_RESULTS;
	_tmp68_ = tracker_view_new (&_tmp67_, NULL);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->sw_noresults);
	self->priv->sw_noresults = _tmp68_;
	_tmp69_ = self->priv->view;
	_tmp70_ = self->priv->sw_noresults;
	gtk_box_pack_start ((GtkBox*) _tmp69_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
	_tmp71_ = TRACKER_VIEW_DISPLAY_CATEGORIES;
	_tmp72_ = self->priv->categories_model;
	_tmp73_ = tracker_view_new (&_tmp71_, _tmp72_);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->sw_categories);
	self->priv->sw_categories = _tmp73_;
	_tmp74_ = self->priv->sw_categories;
	_tmp75_ = tracker_view_get_store (_tmp74_);
	_tmp76_ = _tmp75_;
	g_signal_connect ((GObject*) _tmp76_, "notify::active", (GCallback) _tracker_needle_store_state_changed_g_object_notify, self);
	_tmp77_ = self->priv->sw_categories;
	_tmp78_ = gtk_bin_get_child ((GtkBin*) _tmp77_);
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, GTK_TYPE_TREE_VIEW, GtkTreeView));
	_g_object_unref0 (treeview);
	treeview = _tmp79_;
	_tmp80_ = treeview;
	g_signal_connect (_tmp80_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
	_tmp81_ = treeview;
	_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
	_tmp83_ = _g_object_ref0 (_tmp82_);
	_g_object_unref0 (treeselection);
	treeselection = _tmp83_;
	_tmp84_ = treeselection;
	g_signal_connect (_tmp84_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
	_tmp85_ = self->priv->view;
	_tmp86_ = self->priv->sw_categories;
	gtk_box_pack_start ((GtkBox*) _tmp85_, (GtkWidget*) _tmp86_, TRUE, TRUE, (guint) 0);
	_tmp87_ = TRACKER_VIEW_DISPLAY_FILE_LIST;
	_tmp88_ = tracker_view_new (&_tmp87_, NULL);
	g_object_ref_sink (_tmp88_);
	_g_object_unref0 (self->priv->sw_filelist);
	self->priv->sw_filelist = _tmp88_;
	_tmp89_ = self->priv->sw_filelist;
	_tmp90_ = gtk_bin_get_child ((GtkBin*) _tmp89_);
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, GTK_TYPE_TREE_VIEW, GtkTreeView));
	_g_object_unref0 (treeview);
	treeview = _tmp91_;
	_tmp92_ = treeview;
	g_signal_connect (_tmp92_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
	_tmp93_ = treeview;
	_tmp94_ = gtk_tree_view_get_selection (_tmp93_);
	_tmp95_ = _g_object_ref0 (_tmp94_);
	_g_object_unref0 (treeselection);
	treeselection = _tmp95_;
	_tmp96_ = treeselection;
	g_signal_connect (_tmp96_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
	_tmp97_ = self->priv->view;
	_tmp98_ = self->priv->sw_filelist;
	gtk_box_pack_start ((GtkBox*) _tmp97_, (GtkWidget*) _tmp98_, TRUE, TRUE, (guint) 0);
	_tmp99_ = TRACKER_VIEW_DISPLAY_FILE_ICONS;
	_tmp100_ = tracker_view_new (&_tmp99_, NULL);
	g_object_ref_sink (_tmp100_);
	_g_object_unref0 (self->priv->sw_icons);
	self->priv->sw_icons = _tmp100_;
	_tmp101_ = self->priv->sw_icons;
	_tmp102_ = gtk_bin_get_child ((GtkBin*) _tmp101_);
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, GTK_TYPE_ICON_VIEW, GtkIconView));
	_g_object_unref0 (iconview);
	iconview = _tmp103_;
	g_signal_connect (iconview, "item-activated", (GCallback) _tracker_needle_icon_item_activated_gtk_icon_view_item_activated, self);
	g_signal_connect (iconview, "selection-changed", (GCallback) _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed, self);
	_tmp104_ = self->priv->view;
	_tmp105_ = self->priv->sw_icons;
	gtk_box_pack_start ((GtkBox*) _tmp104_, (GtkWidget*) _tmp105_, TRUE, TRUE, (guint) 0);
	_tmp106_ = gtk_builder_get_object (builder, "hpaned");
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, GTK_TYPE_PANED) ? ((GtkPaned*) _tmp106_) : NULL);
	_g_object_unref0 (paned);
	paned = _tmp107_;
	_tmp108_ = tracker_tags_view_new (NULL);
	g_object_ref_sink (_tmp108_);
	_g_object_unref0 (self->priv->tags_view);
	self->priv->tags_view = _tmp108_;
	_tmp109_ = self->priv->tags_view;
	gtk_widget_hide ((GtkWidget*) _tmp109_);
	_tmp110_ = self->priv->tags_view;
	tracker_tags_view_hide_label (_tmp110_);
	_tmp111_ = self->priv->tags_view;
	gtk_paned_pack2 (paned, (GtkWidget*) _tmp111_, FALSE, FALSE);
	_tmp112_ = self->priv->view_categories;
	gtk_toggle_tool_button_set_active (_tmp112_, TRUE);
	_g_object_unref0 (treeselection);
	_g_object_unref0 (iconview);
	_g_object_unref0 (treeview);
	_g_object_unref0 (paned);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (info_bar_button);
	_g_object_unref0 (builder);
}


static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey _tmp1_ = {0};
	GdkModifierType _tmp2_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.state;
	if ((_tmp2_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		GdkEventKey _tmp3_ = {0};
		guint _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.keyval;
		_tmp5_ = gdk_keyval_name (_tmp4_);
		_tmp0_ = g_strcmp0 (_tmp5_, "w") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		GtkWidget* _tmp7_ = NULL;
		_tmp7_ = widget;
		gtk_widget_destroy (_tmp7_);
	}
	result = FALSE;
	return result;
}


static gboolean _tracker_needle_search_run_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_needle_search_run (self);
	return result;
}


static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = self->priv->last_search_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->last_search_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _tracker_needle_search_run_gsource_func, tracker_needle_ref (self), tracker_needle_unref);
	self->priv->last_search_id = _tmp2_;
}


static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->last_search_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->last_search_id;
		g_source_remove (_tmp1_);
		self->priv->last_search_id = (guint) 0;
	}
	tracker_needle_search_run (self);
}


static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store) {
	gboolean _tmp0_ = FALSE;
	TrackerResultStore* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = store;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		TrackerResultStore* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = store;
		_tmp3_ = tracker_result_store_has_results (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		TrackerView* _tmp5_ = NULL;
		TrackerView* _tmp6_ = NULL;
		TrackerView* _tmp7_ = NULL;
		TrackerView* _tmp8_ = NULL;
		_tmp5_ = self->priv->sw_noresults;
		gtk_widget_show ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->sw_icons;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->sw_categories;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->sw_filelist;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model) {
	GtkTreeIter* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkComboBox* _tmp4_ = NULL;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	gchar* criteria_folded = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	gboolean* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (criteria != NULL, NULL);
	_tmp0_ = criteria;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 1) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->search_list;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp3_) : NULL);
	combo = _tmp4_;
	_tmp5_ = combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	model = _tmp7_;
	_tmp8_ = criteria;
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) (-1));
	criteria_folded = _tmp9_;
	_tmp10_ = model;
	_tmp12_ = gtk_tree_model_iter_children (_tmp10_, &_tmp11_, NULL);
	iter = _tmp11_;
	valid = _tmp12_;
	while (TRUE) {
		gboolean _tmp13_ = FALSE;
		gchar* text = NULL;
		GtkTreeModel* _tmp14_ = NULL;
		GtkTreeIter _tmp15_ = {0};
		gchar* text_folded = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GtkTreeModel* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp13_ = valid;
		if (!_tmp13_) {
			break;
		}
		_tmp14_ = model;
		_tmp15_ = iter;
		gtk_tree_model_get (_tmp14_, &_tmp15_, 0, &text, -1, -1);
		_tmp16_ = text;
		_tmp17_ = g_utf8_casefold (_tmp16_, (gssize) (-1));
		text_folded = _tmp17_;
		_tmp18_ = text_folded;
		_tmp19_ = criteria_folded;
		if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
			GtkTreeIter* _tmp20_ = NULL;
			_tmp20_ = __gtk_tree_iter_dup0 (&iter);
			result = _tmp20_;
			_g_free0 (text_folded);
			_g_free0 (text);
			_g_free0 (criteria_folded);
			_g_object_unref0 (model);
			_g_object_unref0 (combo);
			return result;
		}
		_tmp21_ = model;
		_tmp22_ = gtk_tree_model_iter_next (_tmp21_, &iter);
		valid = _tmp22_;
		_g_free0 (text_folded);
		_g_free0 (text);
	}
	_tmp23_ = add_to_model;
	if (*_tmp23_) {
		GtkTreeIter new_iter = {0};
		GtkListStore* store = NULL;
		GtkTreeModel* _tmp24_ = NULL;
		GtkListStore* _tmp25_ = NULL;
		GtkListStore* _tmp26_ = NULL;
		GtkTreeIter _tmp27_ = {0};
		GtkListStore* _tmp28_ = NULL;
		GtkTreeIter _tmp29_ = {0};
		const gchar* _tmp30_ = NULL;
		TrackerHistory* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		_tmp24_ = model;
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GTK_TYPE_LIST_STORE, GtkListStore));
		store = _tmp25_;
		_tmp26_ = store;
		gtk_list_store_prepend (_tmp26_, &_tmp27_);
		new_iter = _tmp27_;
		_tmp28_ = store;
		_tmp29_ = new_iter;
		_tmp30_ = criteria;
		gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, -1, -1);
		_tmp31_ = self->priv->history;
		_tmp32_ = criteria;
		tracker_history_add (_tmp31_, _tmp32_);
		_g_object_unref0 (store);
	}
	result = NULL;
	_g_free0 (criteria_folded);
	_g_object_unref0 (model);
	_g_object_unref0 (combo);
	return result;
}


static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = history;
	_tmp0__length1 = history_length1;
	{
		gchar** criteria_collection = NULL;
		gint criteria_collection_length1 = 0;
		gint _criteria_collection_size_ = 0;
		gint criteria_it = 0;
		criteria_collection = _tmp0_;
		criteria_collection_length1 = _tmp0__length1;
		for (criteria_it = 0; criteria_it < _tmp0__length1; criteria_it = criteria_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* criteria = NULL;
			_tmp1_ = g_strdup (criteria_collection[criteria_it]);
			criteria = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GtkTreeIter* _tmp4_ = NULL;
				GtkTreeIter* _tmp5_ = NULL;
				_tmp2_ = criteria;
				_tmp3_ = TRUE;
				_tmp4_ = tracker_needle_search_history_find_or_insert (self, _tmp2_, &_tmp3_);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp5_);
				_g_free0 (criteria);
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean tracker_needle_search_run (TrackerNeedle* self) {
	gboolean result = FALSE;
	gchar* str = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* criteria = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	TrackerResultStore* store = NULL;
	GtkToggleToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	TrackerView* _tmp24_ = NULL;
	GtkToggleToolButton* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkToggleToolButton* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GtkToggleToolButton* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	TrackerResultStore* _tmp60_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->last_search_id = (guint) 0;
	_tmp0_ = self->priv->search;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	str = _tmp2_;
	_tmp3_ = str;
	_tmp4_ = string_strip (_tmp3_);
	criteria = _tmp4_;
	store = NULL;
	_tmp5_ = self->priv->show_tags;
	_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		GtkTreeIter* _tmp22_ = NULL;
		GtkTreeIter* _tmp23_ = NULL;
		_tmp8_ = criteria;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ < 3) {
			gboolean _tmp11_ = FALSE;
			GtkToggleToolButton* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp18_ = FALSE;
			_tmp12_ = self->priv->view_icons;
			_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
			_tmp14_ = _tmp13_;
			if (!_tmp14_) {
				_tmp11_ = TRUE;
			} else {
				GtkToggleToolButton* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				_tmp15_ = self->priv->find_in_all;
				_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = !_tmp17_;
			}
			_tmp18_ = _tmp11_;
			if (_tmp18_) {
				TrackerResultStore* _tmp19_ = NULL;
				_tmp19_ = store;
				tracker_needle_search_finished (self, _tmp19_);
				result = FALSE;
				_g_object_unref0 (store);
				_g_free0 (criteria);
				_g_free0 (str);
				return result;
			}
		}
		_tmp20_ = criteria;
		_tmp21_ = TRUE;
		_tmp22_ = tracker_needle_search_history_find_or_insert (self, _tmp20_, &_tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp23_);
	}
	_tmp24_ = self->priv->sw_noresults;
	gtk_widget_hide ((GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->view_icons;
	_tmp26_ = gtk_toggle_tool_button_get_active (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		TrackerView* _tmp28_ = NULL;
		GtkToggleToolButton* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		TrackerView* _tmp36_ = NULL;
		TrackerResultStore* _tmp37_ = NULL;
		_tmp28_ = self->priv->sw_icons;
		gtk_widget_show ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->find_in_all;
		_tmp30_ = gtk_toggle_tool_button_get_active (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_) {
			TrackerResultStore* _tmp32_ = NULL;
			TrackerResultStore* _tmp33_ = NULL;
			_tmp32_ = self->priv->images_model;
			_tmp33_ = _g_object_ref0 (_tmp32_);
			_g_object_unref0 (store);
			store = _tmp33_;
		} else {
			TrackerResultStore* _tmp34_ = NULL;
			TrackerResultStore* _tmp35_ = NULL;
			_tmp34_ = self->priv->images_in_title_model;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_g_object_unref0 (store);
			store = _tmp35_;
		}
		_tmp36_ = self->priv->sw_icons;
		_tmp37_ = store;
		tracker_view_set_store (_tmp36_, _tmp37_);
	} else {
		TrackerView* _tmp38_ = NULL;
		_tmp38_ = self->priv->sw_icons;
		gtk_widget_hide ((GtkWidget*) _tmp38_);
	}
	_tmp39_ = self->priv->view_categories;
	_tmp40_ = gtk_toggle_tool_button_get_active (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_) {
		TrackerView* _tmp42_ = NULL;
		TrackerResultStore* _tmp43_ = NULL;
		TrackerResultStore* _tmp44_ = NULL;
		_tmp42_ = self->priv->sw_categories;
		gtk_widget_show ((GtkWidget*) _tmp42_);
		_tmp43_ = self->priv->categories_model;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_g_object_unref0 (store);
		store = _tmp44_;
	} else {
		TrackerView* _tmp45_ = NULL;
		_tmp45_ = self->priv->sw_categories;
		gtk_widget_hide ((GtkWidget*) _tmp45_);
	}
	_tmp46_ = self->priv->view_filelist;
	_tmp47_ = gtk_toggle_tool_button_get_active (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_) {
		TrackerView* _tmp49_ = NULL;
		GtkToggleToolButton* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		TrackerView* _tmp57_ = NULL;
		TrackerResultStore* _tmp58_ = NULL;
		_tmp49_ = self->priv->sw_filelist;
		gtk_widget_show ((GtkWidget*) _tmp49_);
		_tmp50_ = self->priv->find_in_contents;
		_tmp51_ = gtk_toggle_tool_button_get_active (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_) {
			TrackerResultStore* _tmp53_ = NULL;
			TrackerResultStore* _tmp54_ = NULL;
			_tmp53_ = self->priv->files_model;
			_tmp54_ = _g_object_ref0 (_tmp53_);
			_g_object_unref0 (store);
			store = _tmp54_;
		} else {
			TrackerResultStore* _tmp55_ = NULL;
			TrackerResultStore* _tmp56_ = NULL;
			_tmp55_ = self->priv->files_in_title_model;
			_tmp56_ = _g_object_ref0 (_tmp55_);
			_g_object_unref0 (store);
			store = _tmp56_;
		}
		_tmp57_ = self->priv->sw_filelist;
		_tmp58_ = store;
		tracker_view_set_store (_tmp57_, _tmp58_);
	} else {
		TrackerView* _tmp59_ = NULL;
		_tmp59_ = self->priv->sw_filelist;
		gtk_widget_hide ((GtkWidget*) _tmp59_);
	}
	_tmp60_ = store;
	if (_tmp60_ != NULL) {
		TrackerResultStore* _tmp61_ = NULL;
		TrackerResultStore* _tmp62_ = NULL;
		GtkEntry* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		_tmp61_ = store;
		tracker_result_store_set_search_tags (_tmp61_, NULL);
		_tmp62_ = store;
		_tmp63_ = self->priv->search;
		_tmp64_ = gtk_entry_get_text (_tmp63_);
		tracker_result_store_set_search_term (_tmp62_, _tmp64_);
	}
	result = FALSE;
	_g_object_unref0 (store);
	_g_free0 (criteria);
	_g_free0 (str);
	return result;
}


static void tracker_needle_view_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleToolButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GtkToggleToolButton* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp20_ = FALSE;
	TrackerView* _tmp30_ = NULL;
	TrackerView* _tmp31_ = NULL;
	TrackerView* _tmp32_ = NULL;
	TrackerView* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	GtkToggleToolButton* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GtkSeparatorToolItem* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	GtkToggleToolButton* _tmp43_ = NULL;
	GtkToggleToolButton* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	GtkToggleToolButton* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	GtkToggleToolButton* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	GtkToggleToolButton* _tmp56_ = NULL;
	GtkToggleToolButton* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->view_icons;
	_tmp3_ = gtk_toggle_tool_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkToggleToolButton* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->view_filelist;
		_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		GtkToggleToolButton* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->view_categories;
		_tmp10_ = gtk_toggle_tool_button_get_active (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp14_ = self->priv->view_categories;
	_tmp15_ = gtk_toggle_tool_button_get_active (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		_tmp13_ = TRUE;
	} else {
		GtkToggleToolButton* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->view_filelist;
		_tmp18_ = gtk_toggle_tool_button_get_active (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		gboolean _tmp21_ = FALSE;
		_tmp21_ = tracker_needle_current_find_in_filelist;
		if (_tmp21_) {
			GtkToggleToolButton* _tmp22_ = NULL;
			_tmp22_ = self->priv->find_in_contents;
			gtk_toggle_tool_button_set_active (_tmp22_, TRUE);
		} else {
			GtkToggleToolButton* _tmp23_ = NULL;
			_tmp23_ = self->priv->find_in_titles;
			gtk_toggle_tool_button_set_active (_tmp23_, TRUE);
		}
	} else {
		GtkToggleToolButton* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		_tmp24_ = self->priv->view_icons;
		_tmp25_ = gtk_toggle_tool_button_get_active (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_) {
			gboolean _tmp27_ = FALSE;
			_tmp27_ = tracker_needle_current_find_in_icons;
			if (_tmp27_) {
				GtkToggleToolButton* _tmp28_ = NULL;
				_tmp28_ = self->priv->find_in_titles;
				gtk_toggle_tool_button_set_active (_tmp28_, TRUE);
			} else {
				GtkToggleToolButton* _tmp29_ = NULL;
				_tmp29_ = self->priv->find_in_all;
				gtk_toggle_tool_button_set_active (_tmp29_, TRUE);
			}
		}
	}
	_tmp30_ = self->priv->sw_noresults;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->sw_icons;
	gtk_widget_hide ((GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->sw_filelist;
	gtk_widget_hide ((GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->sw_categories;
	gtk_widget_hide ((GtkWidget*) _tmp33_);
	_tmp35_ = self->priv->view_filelist;
	_tmp36_ = gtk_toggle_tool_button_get_active (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		_tmp34_ = TRUE;
	} else {
		GtkToggleToolButton* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		_tmp38_ = self->priv->view_icons;
		_tmp39_ = gtk_toggle_tool_button_get_active (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp34_ = _tmp40_;
	}
	_tmp41_ = self->priv->separator_secondary;
	_tmp42_ = _tmp34_;
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, _tmp42_);
	_tmp43_ = self->priv->find_in_contents;
	_tmp44_ = self->priv->view_filelist;
	_tmp45_ = gtk_toggle_tool_button_get_active (_tmp44_);
	_tmp46_ = _tmp45_;
	gtk_widget_set_visible ((GtkWidget*) _tmp43_, _tmp46_);
	_tmp48_ = self->priv->view_filelist;
	_tmp49_ = gtk_toggle_tool_button_get_active (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_) {
		_tmp47_ = TRUE;
	} else {
		GtkToggleToolButton* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		_tmp51_ = self->priv->view_icons;
		_tmp52_ = gtk_toggle_tool_button_get_active (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp47_ = _tmp53_;
	}
	_tmp54_ = self->priv->find_in_titles;
	_tmp55_ = _tmp47_;
	gtk_widget_set_visible ((GtkWidget*) _tmp54_, _tmp55_);
	_tmp56_ = self->priv->find_in_all;
	_tmp57_ = self->priv->view_icons;
	_tmp58_ = gtk_toggle_tool_button_get_active (_tmp57_);
	_tmp59_ = _tmp58_;
	gtk_widget_set_visible ((GtkWidget*) _tmp56_, _tmp59_);
	tracker_needle_search_run (self);
}


static void tracker_needle_find_in_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleToolButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GtkToggleToolButton* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GtkToggleToolButton* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->find_in_contents;
	_tmp3_ = gtk_toggle_tool_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkToggleToolButton* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->find_in_titles;
		_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		GtkToggleToolButton* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->find_in_all;
		_tmp10_ = gtk_toggle_tool_button_get_active (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->find_in_contents;
	_tmp14_ = gtk_toggle_tool_button_get_active (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GtkToggleToolButton* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		g_debug ("tracker-needle.vala:552: Find in toggled to 'contents'");
		_tmp16_ = self->priv->show_tags;
		_tmp17_ = gtk_toggle_tool_button_get_active (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ != TRUE) {
			GtkToolItem* _tmp19_ = NULL;
			_tmp19_ = self->priv->search_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, TRUE);
		}
		tracker_needle_search_run (self);
	} else {
		GtkToggleToolButton* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		_tmp20_ = self->priv->find_in_titles;
		_tmp21_ = gtk_toggle_tool_button_get_active (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GtkToggleToolButton* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			g_debug ("tracker-needle.vala:560: Find in toggled to 'titles'");
			_tmp23_ = self->priv->show_tags;
			_tmp24_ = gtk_toggle_tool_button_get_active (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_ != TRUE) {
				GtkToolItem* _tmp26_ = NULL;
				_tmp26_ = self->priv->search_entry;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, TRUE);
			}
			tracker_needle_search_run (self);
		} else {
			GtkToggleToolButton* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			_tmp27_ = self->priv->find_in_all;
			_tmp28_ = gtk_toggle_tool_button_get_active (_tmp27_);
			_tmp29_ = _tmp28_;
			if (_tmp29_) {
				GtkToolItem* _tmp30_ = NULL;
				g_debug ("tracker-needle.vala:568: Find in toggled to 'all'");
				_tmp30_ = self->priv->search_entry;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, FALSE);
				tracker_needle_search_run (self);
			}
		}
	}
	_tmp31_ = self->priv->view_filelist;
	_tmp32_ = gtk_toggle_tool_button_get_active (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_) {
		GtkToggleToolButton* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		_tmp34_ = self->priv->find_in_contents;
		_tmp35_ = gtk_toggle_tool_button_get_active (_tmp34_);
		_tmp36_ = _tmp35_;
		tracker_needle_current_find_in_filelist = _tmp36_;
	} else {
		GtkToggleToolButton* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		_tmp37_ = self->priv->view_icons;
		_tmp38_ = gtk_toggle_tool_button_get_active (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_) {
			GtkToggleToolButton* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			_tmp40_ = self->priv->find_in_titles;
			_tmp41_ = gtk_toggle_tool_button_get_active (_tmp40_);
			_tmp42_ = _tmp41_;
			tracker_needle_current_find_in_icons = _tmp42_;
		}
	}
}


static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = view;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = path;
	tracker_model_launch_selected (model, _tmp3_, 1);
	_g_object_unref0 (model);
}


static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path) {
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = view;
	_tmp1_ = gtk_icon_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = path;
	tracker_model_launch_selected (model, _tmp3_, 1);
	_g_object_unref0 (model);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GList* uris = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	TrackerTagsView* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	model = NULL;
	g_debug ("tracker-needle.vala:596: Row selection changed");
	_tmp0_ = selection;
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
	_g_object_unref0 (model);
	_tmp3_ = _g_object_ref0 (_tmp1_);
	model = _tmp3_;
	rows = _tmp2_;
	uris = NULL;
	_tmp4_ = rows;
	if (_tmp4_ == NULL) {
		__g_list_free__g_free0_0 (uris);
		__g_list_free__gtk_tree_path_free0_0 (rows);
		_g_object_unref0 (model);
		return;
	}
	_tmp5_ = rows;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp5_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp6_ = NULL;
			GtkTreePath* path = NULL;
			_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp6_;
			{
				GtkTreeModel* _tmp7_ = NULL;
				GtkTreePath* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				_tmp7_ = model;
				_tmp8_ = path;
				_tmp10_ = gtk_tree_model_get_iter (_tmp7_, &_tmp9_, _tmp8_);
				iter = _tmp9_;
				if (_tmp10_) {
					gchar* uri = NULL;
					GtkTreeModel* _tmp11_ = NULL;
					GtkTreeIter _tmp12_ = {0};
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp11_ = model;
					_tmp12_ = iter;
					gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &uri, -1, -1);
					_tmp13_ = uri;
					g_debug ("tracker-needle.vala:610: --> %s", _tmp13_);
					_tmp14_ = uri;
					if (_tmp14_ != NULL) {
						const gchar* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						_tmp15_ = uri;
						_tmp16_ = g_strdup (_tmp15_);
						uris = g_list_prepend (uris, _tmp16_);
					}
					_g_free0 (uri);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->tags_view;
	_tmp18_ = uris;
	tracker_tags_view_set_files (_tmp17_, _tmp18_);
	__g_list_free__g_free0_0 (uris);
	__g_list_free__gtk_tree_path_free0_0 (rows);
	_g_object_unref0 (model);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TrackerNeedle * self;
		self = _data4_->self;
		__g_list_free__g_free0_0 (_data4_->uris);
		_g_object_unref0 (_data4_->model);
		_tracker_needle_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda6_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path) {
	TrackerNeedle * self;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	self = _data4_->self;
	g_return_if_fail (iconview != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _data4_->model;
	_tmp1_ = path;
	_tmp3_ = gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	if (_tmp3_) {
		gchar* uri = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp4_ = _data4_->model;
		_tmp5_ = iter;
		gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &uri, -1, -1);
		_tmp6_ = uri;
		g_debug ("tracker-needle.vala:637: --> %s", _tmp6_);
		_tmp7_ = uri;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = uri;
			_tmp9_ = g_strdup (_tmp8_);
			_data4_->uris = g_list_prepend (_data4_->uris, _tmp9_);
		}
		_g_free0 (uri);
	}
}


static void ___lambda6__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self) {
	__lambda6_ (self, icon_view, path);
}


static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self) {
	Block4Data* _data4_;
	GtkIconView* iconview = NULL;
	TrackerView* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkIconView* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	TrackerTagsView* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = tracker_needle_ref (self);
	_data4_->model = NULL;
	g_debug ("tracker-needle.vala:624: Icon selection changed");
	_tmp0_ = self->priv->sw_icons;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_ICON_VIEW, GtkIconView));
	_g_object_unref0 (iconview);
	iconview = _tmp2_;
	_tmp3_ = gtk_icon_view_get_model (iconview);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data4_->model);
	_data4_->model = _tmp4_;
	_data4_->uris = NULL;
	gtk_icon_view_selected_foreach (iconview, ___lambda6__gtk_icon_view_foreach_func, _data4_);
	_tmp5_ = self->priv->tags_view;
	tracker_tags_view_set_files (_tmp5_, _data4_->uris);
	_g_object_unref0 (iconview);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void tracker_needle_show_tags_clicked (TrackerNeedle* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->show_tags;
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		TrackerTagsView* _tmp3_ = NULL;
		g_debug ("tracker-needle.vala:650: Showing tags");
		_tmp3_ = self->priv->tags_view;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		TrackerTagsView* _tmp4_ = NULL;
		g_debug ("tracker-needle.vala:654: Hiding tags");
		_tmp4_ = self->priv->tags_view;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	}
}


static void tracker_needle_show_stats_clicked (TrackerNeedle* self) {
	TrackerStats* s = NULL;
	TrackerStats* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("tracker-needle.vala:664: Showing stats dialog");
	_tmp0_ = tracker_stats_new ();
	g_object_ref_sink (_tmp0_);
	s = _tmp0_;
	gtk_widget_show ((GtkWidget*) s);
	_g_object_unref0 (s);
}


void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type) {
	GtkInfoBar* _tmp0_ = NULL;
	GtkMessageType _tmp1_ = 0;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkInfoBar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->info_bar;
	_tmp1_ = type;
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->info_bar_label;
	_tmp3_ = message;
	gtk_label_set_markup (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp4_);
}


static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source) {
	GtkInfoBar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->info_bar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void tracker_value_needle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_needle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_needle_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_needle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_needle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_needle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_needle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerNeedle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_needle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_needle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerNeedle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_needle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecNeedle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_NEEDLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_needle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_needle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_needle_unref (old);
	}
}


void tracker_value_take_needle (GValue* value, gpointer v_object) {
	TrackerNeedle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_needle_unref (old);
	}
}


static void tracker_needle_class_init (TrackerNeedleClass * klass) {
	tracker_needle_parent_class = g_type_class_peek_parent (klass);
	TRACKER_NEEDLE_CLASS (klass)->finalize = tracker_needle_finalize;
	g_type_class_add_private (klass, sizeof (TrackerNeedlePrivate));
}


static void tracker_needle_instance_init (TrackerNeedle * self) {
	self->priv = TRACKER_NEEDLE_GET_PRIVATE (self);
	self->priv->last_search_id = (guint) 0;
	self->priv->size_small = 0;
	self->priv->size_medium = 0;
	self->priv->size_big = 0;
	self->priv->limit = (guint) 500;
	self->ref_count = 1;
}


static void tracker_needle_finalize (TrackerNeedle* obj) {
	TrackerNeedle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_NEEDLE, TrackerNeedle);
	_tracker_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view_categories);
	_g_object_unref0 (self->priv->view_filelist);
	_g_object_unref0 (self->priv->view_icons);
	_g_object_unref0 (self->priv->separator_secondary);
	_g_object_unref0 (self->priv->find_in_contents);
	_g_object_unref0 (self->priv->find_in_titles);
	_g_object_unref0 (self->priv->find_in_all);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_list);
	_g_object_unref0 (self->priv->search);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->spinner_shell);
	_g_object_unref0 (self->priv->show_tags);
	_g_object_unref0 (self->priv->show_stats);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->sw_noresults);
	_g_object_unref0 (self->priv->sw_categories);
	_g_object_unref0 (self->priv->sw_filelist);
	_g_object_unref0 (self->priv->sw_icons);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_bar_label);
	_g_object_unref0 (self->priv->tags_view);
	_g_object_unref0 (self->priv->categories_model);
	_g_object_unref0 (self->priv->files_model);
	_g_object_unref0 (self->priv->files_in_title_model);
	_g_object_unref0 (self->priv->images_model);
	_g_object_unref0 (self->priv->images_in_title_model);
}


GType tracker_needle_get_type (void) {
	static volatile gsize tracker_needle_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_needle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_needle_init, tracker_value_needle_free_value, tracker_value_needle_copy_value, tracker_value_needle_peek_pointer, "p", tracker_value_needle_collect_value, "p", tracker_value_needle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerNeedleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_needle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerNeedle), 0, (GInstanceInitFunc) tracker_needle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_needle_type_id;
		tracker_needle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerNeedle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_needle_type_id__volatile, tracker_needle_type_id);
	}
	return tracker_needle_type_id__volatile;
}


gpointer tracker_needle_ref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_needle_unref (gpointer instance) {
	TrackerNeedle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_NEEDLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	gboolean _tmp14_ = FALSE;
	TrackerNeedle* n = NULL;
	TrackerNeedle* _tmp39_ = NULL;
	TrackerNeedle* _tmp40_ = NULL;
	TrackerNeedle* _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = _ ("Desktop Search user interface using Tracker");
	_tmp1_ = g_option_context_new (_tmp0_);
	context = _tmp1_;
	{
		GOptionContext* _tmp2_ = NULL;
		GOptionContext* _tmp3_ = NULL;
		GOptionContext* _tmp4_ = NULL;
		GOptionGroup* _tmp5_ = NULL;
		GOptionContext* _tmp6_ = NULL;
		_tmp2_ = context;
		g_option_context_set_help_enabled (_tmp2_, TRUE);
		_tmp3_ = context;
		g_option_context_add_main_entries (_tmp3_, options, NULL);
		_tmp4_ = context;
		_tmp5_ = gtk_get_option_group (TRUE);
		g_option_context_add_group (_tmp4_, _tmp5_);
		_tmp6_ = context;
		g_option_context_parse (_tmp6_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GOptionContext* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strconcat (_tmp8_, "\n\n", NULL);
		_tmp10_ = _tmp9_;
		g_printerr ("%s", _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = context;
		_tmp12_ = g_option_context_get_help (_tmp11_, TRUE, NULL);
		_tmp13_ = _tmp12_;
		g_printerr ("%s", _tmp13_);
		_g_free0 (_tmp13_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally30:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = print_version;
	if (_tmp14_) {
		gchar* about = NULL;
		gchar* _tmp15_ = NULL;
		gchar* license = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		_tmp15_ = g_strdup ("");
		about = _tmp15_;
		_tmp16_ = g_strdup ("");
		license = _tmp16_;
		_tmp17_ = about;
		_tmp18_ = g_strconcat (_tmp17_, "Tracker " PACKAGE_VERSION "\n", NULL);
		_g_free0 (about);
		about = _tmp18_;
		_tmp19_ = license;
		_tmp20_ = g_strconcat (_tmp19_, "This program is free software and comes without any warranty.\n", NULL);
		_g_free0 (license);
		license = _tmp20_;
		_tmp21_ = license;
		_tmp22_ = g_strconcat (_tmp21_, "It is licensed under version 2 or later of the General Public ", NULL);
		_g_free0 (license);
		license = _tmp22_;
		_tmp23_ = license;
		_tmp24_ = g_strconcat (_tmp23_, "License which can be viewed at:\n", NULL);
		_g_free0 (license);
		license = _tmp24_;
		_tmp25_ = license;
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
		_g_free0 (license);
		license = _tmp26_;
		_tmp27_ = license;
		_tmp28_ = g_strconcat (_tmp27_, "  http://www.gnu.org/licenses/gpl.txt\n", NULL);
		_g_free0 (license);
		license = _tmp28_;
		_tmp29_ = about;
		_tmp30_ = g_strconcat ("\n", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = license;
		_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
		_tmp38_ = _tmp37_;
		g_print ("%s", _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		result = 0;
		_g_free0 (license);
		_g_free0 (about);
		_g_option_context_free0 (context);
		return result;
	}
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp39_ = tracker_needle_new ();
	n = _tmp39_;
	_tmp40_ = n;
	tracker_needle_show (_tmp40_);
	_tmp41_ = n;
	_tmp42_ = search_criteria;
	_tmp42__length1 = _vala_array_length (search_criteria);
	tracker_needle_set_search (_tmp41_, _tmp42_, _tmp42__length1);
	gtk_main ();
	result = 0;
	_tracker_needle_unref0 (n);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



