
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_RESULT_COLUMNS (result_columns_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

struct _TrackerResultGridPrivate {
	TrackerQuery* _query;
};


static gpointer tracker_result_grid_parent_class = NULL;

GType result_columns_get_type (void);
GType tracker_result_grid_get_type (void);
GType tracker_query_get_type (void);
#define TRACKER_RESULT_GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_RESULT_GRID, TrackerResultGridPrivate))
enum  {
	TRACKER_RESULT_GRID_DUMMY_PROPERTY,
	TRACKER_RESULT_GRID_QUERY
};
GtkTreePath* tracker_result_grid_GetSelectedPath (TrackerResultGrid* self);
const char* tracker_result_grid_GetSelectedUri (TrackerResultGrid* self);
char** tracker_query_Search (TrackerQuery* self, int* result_length1, int* result_length2);
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen);
void tracker_result_grid_RefreshQuery (TrackerResultGrid* self);
gboolean tracker_utils_OpenUri (const char* uri, gboolean is_dir);
void tracker_result_grid_ActivateUri (TrackerResultGrid* self, const GtkTreePath* path);
TrackerResultGrid* tracker_result_grid_new (void);
TrackerResultGrid* tracker_result_grid_construct (GType object_type);
TrackerQuery* tracker_result_grid_get_Query (TrackerResultGrid* self);
static void _lambda2_ (TrackerResultGrid* self);
static void __lambda2__tracker_query_search_settings_changed (TrackerQuery* _sender, gpointer self);
static void _lambda3_ (TrackerResultGrid* self);
static void __lambda3__tracker_query_clear_search_results (TrackerQuery* _sender, gpointer self);
void tracker_result_grid_set_Query (TrackerResultGrid* self, TrackerQuery* value);
static void _tracker_result_grid_ActivateUri_gtk_icon_view_item_activated (GtkIconView* _sender, const GtkTreePath* path, gpointer self);
static void _lambda4_ (TrackerResultGrid* self);
static void __lambda4__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _lambda5_ (GdkDragContext* context, GtkSelectionData* data, guint info, guint time, TrackerResultGrid* self);
static void __lambda5__gtk_widget_drag_data_get (GtkIconView* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static GObject * tracker_result_grid_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_result_grid_finalize (GObject* obj);
static void tracker_result_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_result_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkTargetEntry targets[] = {{"text/uri-list", (guint) 0, (guint) 1}, {"text/plain", (guint) 0, (guint) 0}, {"STRING", (guint) 0, (guint) 0}};



GType result_columns_get_type (void) {
	static GType result_columns_type_id = 0;
	if (G_UNLIKELY (result_columns_type_id == 0)) {
		static const GEnumValue values[] = {{RESULT_COLUMNS_Uri, "RESULT_COLUMNS_Uri", "uri"}, {RESULT_COLUMNS_Icon, "RESULT_COLUMNS_Icon", "icon"}, {RESULT_COLUMNS_DisplayName, "RESULT_COLUMNS_DisplayName", "displayname"}, {RESULT_COLUMNS_Mime, "RESULT_COLUMNS_Mime", "mime"}, {RESULT_COLUMNS_Category, "RESULT_COLUMNS_Category", "category"}, {RESULT_COLUMNS_Snippet, "RESULT_COLUMNS_Snippet", "snippet"}, {RESULT_COLUMNS_IsDirectory, "RESULT_COLUMNS_IsDirectory", "isdirectory"}, {RESULT_COLUMNS_Path, "RESULT_COLUMNS_Path", "path"}, {RESULT_COLUMNS_NumOfCols, "RESULT_COLUMNS_NumOfCols", "numofcols"}, {0, NULL, NULL}};
		result_columns_type_id = g_enum_register_static ("ResultColumns", values);
	}
	return result_columns_type_id;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


#line 61 "tracker-result-grid.gs"
GtkTreePath* tracker_result_grid_GetSelectedPath (TrackerResultGrid* self) {
#line 126 "tracker-result-grid.c"
	GtkTreePath* result;
	GList* l;
	gboolean _tmp0_;
#line 61 "tracker-result-grid.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "tracker-result-grid.c"
	l = NULL;
#line 64 "tracker-result-grid.gs"
	l = gtk_icon_view_get_selected_items (self->iconview);
#line 136 "tracker-result-grid.c"
	_tmp0_ = FALSE;
#line 66 "tracker-result-grid.gs"
	if (l != NULL) {
#line 66 "tracker-result-grid.gs"
		_tmp0_ = ((const GtkTreePath*) l->data) != NULL;
#line 142 "tracker-result-grid.c"
	} else {
#line 66 "tracker-result-grid.gs"
		_tmp0_ = FALSE;
#line 146 "tracker-result-grid.c"
	}
#line 66 "tracker-result-grid.gs"
	if (_tmp0_) {
#line 150 "tracker-result-grid.c"
		result = _gtk_tree_path_copy0 ((const GtkTreePath*) l->data);
		return result;
	}
	result = NULL;
	return result;
}


#line 72 "tracker-result-grid.gs"
const char* tracker_result_grid_GetSelectedUri (TrackerResultGrid* self) {
#line 161 "tracker-result-grid.c"
	const char* result;
	GtkTreeIter iter = {0};
	const char* uri;
	GtkTreePath* path;
#line 72 "tracker-result-grid.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 168 "tracker-result-grid.c"
	uri = NULL;
	path = tracker_result_grid_GetSelectedPath (self);
#line 77 "tracker-result-grid.gs"
	if (path != NULL) {
#line 78 "tracker-result-grid.gs"
		gtk_tree_model_get_iter ((GtkTreeModel*) self->store, &iter, path);
#line 79 "tracker-result-grid.gs"
		gtk_tree_model_get ((GtkTreeModel*) self->store, &iter, RESULT_COLUMNS_Uri, &uri, -1);
#line 177 "tracker-result-grid.c"
		result = uri;
		_gtk_tree_path_free0 (path);
		return result;
	}
	result = "";
	_gtk_tree_path_free0 (path);
	return result;
}


#line 121 "tracker-result-grid.gs"
void tracker_result_grid_RefreshQuery (TrackerResultGrid* self) {
#line 190 "tracker-result-grid.c"
	GError * _inner_error_;
#line 121 "tracker-result-grid.gs"
	g_return_if_fail (self != NULL);
#line 194 "tracker-result-grid.c"
	_inner_error_ = NULL;
#line 122 "tracker-result-grid.gs"
	if (self->priv->_query != NULL) {
#line 198 "tracker-result-grid.c"
		char** _tmp2_;
		gint results_length2;
		gint results_length1;
		gint _tmp1_;
		gint _tmp0_;
		char** results;
		gboolean has_results;
		GtkTreeIter iter = {0};
		results = (_tmp2_ = tracker_query_Search (self->priv->_query, &_tmp0_, &_tmp1_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
		has_results = FALSE;
#line 127 "tracker-result-grid.gs"
		gtk_list_store_clear (self->store);
#line 129 "tracker-result-grid.gs"
		if (results == NULL) {
#line 213 "tracker-result-grid.c"
			results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
			return;
		}
		{
			char** uri_collection;
			int uri_collection_length1;
			int uri_it;
#line 131 "tracker-result-grid.gs"
			uri_collection = results;
#line 223 "tracker-result-grid.c"
			uri_collection_length1 = results_length1 * results_length2;
			for (uri_it = 0; uri_it < (results_length1 * results_length2); uri_it = uri_it + 1) {
				char* uri;
				uri = g_strdup (uri_collection[uri_it]);
				{
#line 132 "tracker-result-grid.gs"
					if (g_str_has_prefix (uri, "file://")) {
#line 231 "tracker-result-grid.c"
						GFile* file;
#line 134 "tracker-result-grid.gs"
						has_results = TRUE;
#line 235 "tracker-result-grid.c"
						file = g_file_new_for_uri (uri);
						{
							GFileInfo* info;
							GFileType filetype;
							GdkPixbuf* _tmp3_;
							info = g_file_query_info (file, "standard::display-name,standard::icon,thumbnail::path", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch3_g_error;
								goto __finally3;
							}
							filetype = g_file_info_get_file_type (info);
#line 143 "tracker-result-grid.gs"
							gtk_list_store_append (self->store, &iter);
#line 144 "tracker-result-grid.gs"
							gtk_list_store_set (self->store, &iter, RESULT_COLUMNS_Uri, uri, RESULT_COLUMNS_Icon, _tmp3_ = tracker_utils_GetThumbNail (info, 64, 48, gtk_widget_get_screen ((GtkWidget*) self)), RESULT_COLUMNS_DisplayName, g_file_info_get_display_name (info), RESULT_COLUMNS_IsDirectory, filetype == G_FILE_TYPE_DIRECTORY, -1, -1);
#line 251 "tracker-result-grid.c"
							_g_object_unref0 (_tmp3_);
							_g_object_unref0 (info);
						}
						goto __finally3;
						__catch3_g_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							{
#line 148 "tracker-result-grid.gs"
								g_print ("Could not get file info for %s\n", uri);
#line 264 "tracker-result-grid.c"
								_g_error_free0 (e);
							}
						}
						__finally3:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (file);
							_g_free0 (uri);
							results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_object_unref0 (file);
					}
					_g_free0 (uri);
				}
			}
		}
#line 151 "tracker-result-grid.gs"
		if (has_results) {
#line 285 "tracker-result-grid.c"
			GtkTreePath* path;
			path = gtk_tree_path_new_from_string ("0:0:0");
#line 153 "tracker-result-grid.gs"
			if (path != NULL) {
#line 154 "tracker-result-grid.gs"
				gtk_icon_view_select_path (self->iconview, path);
#line 292 "tracker-result-grid.c"
			}
			_gtk_tree_path_free0 (path);
		}
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	}
}


#line 159 "tracker-result-grid.gs"
void tracker_result_grid_ActivateUri (TrackerResultGrid* self, const GtkTreePath* path) {
#line 303 "tracker-result-grid.c"
	GtkTreeIter iter = {0};
	gboolean is_dir;
	const char* uri;
#line 159 "tracker-result-grid.gs"
	g_return_if_fail (self != NULL);
#line 159 "tracker-result-grid.gs"
	g_return_if_fail (path != NULL);
#line 311 "tracker-result-grid.c"
	is_dir = FALSE;
#line 163 "tracker-result-grid.gs"
	gtk_tree_model_get_iter ((GtkTreeModel*) self->store, &iter, path);
#line 315 "tracker-result-grid.c"
	uri = NULL;
#line 165 "tracker-result-grid.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->store, &iter, RESULT_COLUMNS_Uri, &uri, -1);
#line 166 "tracker-result-grid.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->store, &iter, RESULT_COLUMNS_IsDirectory, &is_dir, -1);
#line 168 "tracker-result-grid.gs"
	tracker_utils_OpenUri (uri, is_dir);
#line 323 "tracker-result-grid.c"
}


#line 43 "tracker-result-grid.gs"
TrackerResultGrid* tracker_result_grid_construct (GType object_type) {
#line 329 "tracker-result-grid.c"
	TrackerResultGrid * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 43 "tracker-result-grid.gs"
TrackerResultGrid* tracker_result_grid_new (void) {
#line 43 "tracker-result-grid.gs"
	return tracker_result_grid_construct (TYPE_TRACKER_RESULT_GRID);
#line 340 "tracker-result-grid.c"
}


TrackerQuery* tracker_result_grid_get_Query (TrackerResultGrid* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_query;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda2_ (TrackerResultGrid* self) {
#line 57 "tracker-result-grid.gs"
	tracker_result_grid_RefreshQuery (self);
#line 360 "tracker-result-grid.c"
}


static void __lambda2__tracker_query_search_settings_changed (TrackerQuery* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _lambda3_ (TrackerResultGrid* self) {
#line 59 "tracker-result-grid.gs"
	gtk_list_store_clear (self->store);
#line 372 "tracker-result-grid.c"
}


static void __lambda3__tracker_query_clear_search_results (TrackerQuery* _sender, gpointer self) {
	_lambda3_ (self);
}


void tracker_result_grid_set_Query (TrackerResultGrid* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
#line 54 "tracker-result-grid.gs"
	if (value != NULL) {
#line 385 "tracker-result-grid.c"
		TrackerQuery* _tmp0_;
#line 55 "tracker-result-grid.gs"
		self->priv->_query = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_query), _tmp0_);
#line 56 "tracker-result-grid.gs"
		g_signal_connect_object (self->priv->_query, "search-settings-changed", (GCallback) __lambda2__tracker_query_search_settings_changed, self, 0);
#line 58 "tracker-result-grid.gs"
		g_signal_connect_object (self->priv->_query, "clear-search-results", (GCallback) __lambda3__tracker_query_clear_search_results, self, 0);
#line 393 "tracker-result-grid.c"
	}
	g_object_notify ((GObject *) self, "Query");
}


#line 159 "tracker-result-grid.gs"
static void _tracker_result_grid_ActivateUri_gtk_icon_view_item_activated (GtkIconView* _sender, const GtkTreePath* path, gpointer self) {
#line 401 "tracker-result-grid.c"
	tracker_result_grid_ActivateUri (self, path);
}


static void _lambda4_ (TrackerResultGrid* self) {
	GtkTreePath* path;
	path = tracker_result_grid_GetSelectedPath (self);
#line 107 "tracker-result-grid.gs"
	g_signal_emit_by_name (self, "selection-changed", path);
#line 411 "tracker-result-grid.c"
	_gtk_tree_path_free0 (path);
}


static void __lambda4__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_lambda4_ (self);
}


static void _lambda5_ (GdkDragContext* context, GtkSelectionData* data, guint info, guint time, TrackerResultGrid* self) {
	char* uri;
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	uri = g_strdup (tracker_result_grid_GetSelectedUri (self));
#line 112 "tracker-result-grid.gs"
	if (uri != NULL) {
#line 428 "tracker-result-grid.c"
		char** _tmp0_;
		gint s_size;
		gint s_length1;
		char** s;
		char* _tmp1_;
		s = (_tmp0_ = g_new0 (char*, 1 + 1), s_length1 = 1, s_size = s_length1, _tmp0_);
#line 114 "tracker-result-grid.gs"
		s[0] = (_tmp1_ = g_strdup (uri), _g_free0 (s[0]), _tmp1_);
#line 115 "tracker-result-grid.gs"
		gtk_selection_data_set_uris (data, s);
#line 439 "tracker-result-grid.c"
		s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (uri);
}


static void __lambda5__gtk_widget_drag_data_get (GtkIconView* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	_lambda5_ (context, selection_data, info, time_, self);
}


static GObject * tracker_result_grid_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TrackerResultGridClass * klass;
	GObjectClass * parent_class;
	TrackerResultGrid * self;
	klass = TRACKER_RESULT_GRID_CLASS (g_type_class_peek (TYPE_TRACKER_RESULT_GRID));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_RESULT_GRID (obj);
	{
		GtkListStore* _tmp0_;
		GtkIconView* _tmp1_;
#line 87 "tracker-result-grid.gs"
		g_object_set ((GtkScrolledWindow*) self, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
#line 88 "tracker-result-grid.gs"
		g_object_set ((GtkScrolledWindow*) self, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
#line 89 "tracker-result-grid.gs"
		gtk_scrolled_window_set_shadow_type ((GtkScrolledWindow*) self, GTK_SHADOW_ETCHED_OUT);
#line 91 "tracker-result-grid.gs"
		self->store = (_tmp0_ = gtk_list_store_new ((gint) RESULT_COLUMNS_NumOfCols, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, NULL), _g_object_unref0 (self->store), _tmp0_);
#line 96 "tracker-result-grid.gs"
		self->iconview = (_tmp1_ = g_object_ref_sink ((GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) self->store)), _g_object_unref0 (self->iconview), _tmp1_);
#line 97 "tracker-result-grid.gs"
		gtk_icon_view_set_pixbuf_column (self->iconview, (gint) RESULT_COLUMNS_Icon);
#line 98 "tracker-result-grid.gs"
		gtk_icon_view_set_text_column (self->iconview, (gint) RESULT_COLUMNS_DisplayName);
#line 99 "tracker-result-grid.gs"
		gtk_icon_view_set_selection_mode (self->iconview, GTK_SELECTION_BROWSE);
#line 100 "tracker-result-grid.gs"
		gtk_icon_view_enable_model_drag_source (self->iconview, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, targets, G_N_ELEMENTS (targets), (GDK_ACTION_COPY | GDK_ACTION_MOVE) | GDK_ACTION_ASK);
#line 101 "tracker-result-grid.gs"
		gtk_icon_view_set_item_width (self->iconview, 150);
#line 102 "tracker-result-grid.gs"
		gtk_icon_view_set_row_spacing (self->iconview, 10);
#line 103 "tracker-result-grid.gs"
		g_signal_connect_object (self->iconview, "item-activated", (GCallback) _tracker_result_grid_ActivateUri_gtk_icon_view_item_activated, self, 0);
#line 105 "tracker-result-grid.gs"
		g_signal_connect_object (self->iconview, "selection-changed", (GCallback) __lambda4__gtk_icon_view_selection_changed, self, 0);
#line 110 "tracker-result-grid.gs"
		g_signal_connect_object ((GtkWidget*) self->iconview, "drag-data-get", (GCallback) __lambda5__gtk_widget_drag_data_get, self, 0);
#line 117 "tracker-result-grid.gs"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->iconview);
#line 118 "tracker-result-grid.gs"
		gtk_widget_show_all ((GtkWidget*) self);
#line 495 "tracker-result-grid.c"
	}
	return obj;
}


static void tracker_result_grid_class_init (TrackerResultGridClass * klass) {
	tracker_result_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerResultGridPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_result_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_result_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_result_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_result_grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_GRID_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("selection_changed", TYPE_TRACKER_RESULT_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, GTK_TYPE_TREE_PATH);
}


static void tracker_result_grid_instance_init (TrackerResultGrid * self) {
	self->priv = TRACKER_RESULT_GRID_GET_PRIVATE (self);
}


static void tracker_result_grid_finalize (GObject* obj) {
	TrackerResultGrid * self;
	self = TRACKER_RESULT_GRID (obj);
	_g_object_unref0 (self->store);
	_g_object_unref0 (self->iconview);
	_g_object_unref0 (self->priv->_query);
	G_OBJECT_CLASS (tracker_result_grid_parent_class)->finalize (obj);
}


GType tracker_result_grid_get_type (void) {
	static GType tracker_result_grid_type_id = 0;
	if (tracker_result_grid_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultGrid), 0, (GInstanceInitFunc) tracker_result_grid_instance_init, NULL };
		tracker_result_grid_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "TrackerResultGrid", &g_define_type_info, 0);
	}
	return tracker_result_grid_type_id;
}


static void tracker_result_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerResultGrid * self;
	self = TRACKER_RESULT_GRID (object);
	switch (property_id) {
		case TRACKER_RESULT_GRID_QUERY:
		g_value_set_object (value, tracker_result_grid_get_Query (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_result_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerResultGrid * self;
	self = TRACKER_RESULT_GRID (object);
	switch (property_id) {
		case TRACKER_RESULT_GRID_QUERY:
		tracker_result_grid_set_Query (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




