
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;

#define TYPE_TRACKER_SEARCH_ENTRY (tracker_search_entry_get_type ())
#define TRACKER_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntry))
#define TRACKER_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntryClass))
#define IS_TRACKER_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_SEARCH_ENTRY))
#define IS_TRACKER_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_SEARCH_ENTRY))
#define TRACKER_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_SEARCH_ENTRY, TrackerSearchEntryClass))

typedef struct _TrackerSearchEntry TrackerSearchEntry;
typedef struct _TrackerSearchEntryClass TrackerSearchEntryClass;

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_CATEGORY_VIEW (tracker_category_view_get_type ())
#define TRACKER_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_CATEGORY_VIEW, TrackerCategoryView))
#define TRACKER_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_CATEGORY_VIEW, TrackerCategoryViewClass))
#define IS_TRACKER_CATEGORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_CATEGORY_VIEW))
#define IS_TRACKER_CATEGORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_CATEGORY_VIEW))
#define TRACKER_CATEGORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_CATEGORY_VIEW, TrackerCategoryViewClass))

typedef struct _TrackerCategoryView TrackerCategoryView;
typedef struct _TrackerCategoryViewClass TrackerCategoryViewClass;

#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;



static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self);
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
GType tracker_query_get_type (void);
TrackerSearchEntry* tracker_search_entry_new (void);
TrackerSearchEntry* tracker_search_entry_construct (GType object_type);
GType tracker_search_entry_get_type (void);
TrackerResultGrid* tracker_result_grid_new (void);
TrackerResultGrid* tracker_result_grid_construct (GType object_type);
GType tracker_result_grid_get_type (void);
TrackerCategoryView* tracker_category_view_new (void);
TrackerCategoryView* tracker_category_view_construct (GType object_type);
GType tracker_category_view_get_type (void);
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
GType tracker_metadata_tile_get_type (void);
gboolean tracker_query_Connect (TrackerQuery* self);
void tracker_search_entry_set_Query (TrackerSearchEntry* self, TrackerQuery* value);
void tracker_result_grid_set_Query (TrackerResultGrid* self, TrackerQuery* value);
void tracker_category_view_set_Query (TrackerCategoryView* self, TrackerQuery* value);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
void _main (char** args, int args_length1);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 7481 "gtk+-2.0.vapi"
static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
#line 98 "tracker-search-tool.c"
	gtk_main_quit ();
}


#line 26 "tracker-search-tool.gs"
void _main (char** args, int args_length1) {
#line 105 "tracker-search-tool.c"
	GError * _inner_error_;
	GtkBuilder* builder;
	GObject* _tmp0_;
	GtkWindow* window;
	TrackerQuery* query;
	TrackerSearchEntry* entry;
	TrackerResultGrid* grid;
	TrackerCategoryView* categories;
	TrackerMetadataTile* tile;
	GObject* _tmp1_;
	GtkContainer* entry_box;
	GObject* _tmp2_;
	GtkContainer* grid_box;
	GObject* _tmp3_;
	GtkContainer* category_box;
	GObject* _tmp4_;
	GtkContainer* detail_box;
	_inner_error_ = NULL;
#line 27 "tracker-search-tool.gs"
	gtk_init (&args_length1, &args);
#line 126 "tracker-search-tool.c"
	builder = gtk_builder_new ();
	{
#line 32 "tracker-search-tool.gs"
		gtk_builder_add_from_file (builder, SRCDIR "tst.ui", &_inner_error_);
#line 131 "tracker-search-tool.c"
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			{
#line 37 "tracker-search-tool.gs"
				gtk_builder_add_from_file (builder, TRACKER_UI_DIR "tst.ui", &_inner_error_);
#line 147 "tracker-search-tool.c"
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
					goto __finally4;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					GtkMessageDialog* msg;
					msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, N_ ("Failed to load UI\n%s"), e->message));
#line 44 "tracker-search-tool.gs"
					gtk_dialog_run ((GtkDialog*) msg);
#line 45 "tracker-search-tool.gs"
					gtk_main_quit ();
#line 166 "tracker-search-tool.c"
					_g_error_free0 (e);
					_g_object_unref0 (msg);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				_g_object_unref0 (builder);
				goto __finally3;
			}
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	window = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (builder, "window"), GTK_IS_WINDOW (_tmp0_) ? ((GtkWindow*) _tmp0_) : NULL));
#line 49 "tracker-search-tool.gs"
	g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
#line 190 "tracker-search-tool.c"
	query = tracker_query_new ();
	entry = g_object_ref_sink (tracker_search_entry_new ());
	grid = g_object_ref_sink (tracker_result_grid_new ());
	categories = g_object_ref_sink (tracker_category_view_new ());
	tile = g_object_ref_sink (tracker_metadata_tile_new ());
	entry_box = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (builder, "EntryBox"), GTK_IS_CONTAINER (_tmp1_) ? ((GtkContainer*) _tmp1_) : NULL));
	grid_box = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "GridBox"), GTK_IS_CONTAINER (_tmp2_) ? ((GtkContainer*) _tmp2_) : NULL));
	category_box = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "CategoryBox"), GTK_IS_CONTAINER (_tmp3_) ? ((GtkContainer*) _tmp3_) : NULL));
	detail_box = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "DetailBox"), GTK_IS_CONTAINER (_tmp4_) ? ((GtkContainer*) _tmp4_) : NULL));
#line 66 "tracker-search-tool.gs"
	tracker_query_Connect (query);
#line 67 "tracker-search-tool.gs"
	tracker_search_entry_set_Query (entry, query);
#line 68 "tracker-search-tool.gs"
	gtk_container_add (entry_box, (GtkWidget*) entry);
#line 70 "tracker-search-tool.gs"
	tracker_result_grid_set_Query (grid, query);
#line 71 "tracker-search-tool.gs"
	gtk_container_add (grid_box, (GtkWidget*) grid);
#line 73 "tracker-search-tool.gs"
	tracker_category_view_set_Query (categories, query);
#line 74 "tracker-search-tool.gs"
	gtk_container_add (category_box, (GtkWidget*) categories);
#line 76 "tracker-search-tool.gs"
	tracker_metadata_tile_set_ResultGrid (tile, grid);
#line 77 "tracker-search-tool.gs"
	tracker_metadata_tile_set_Query (tile, query);
#line 78 "tracker-search-tool.gs"
	gtk_container_add (detail_box, (GtkWidget*) tile);
#line 80 "tracker-search-tool.gs"
	gtk_widget_show_all ((GtkWidget*) window);
#line 82 "tracker-search-tool.gs"
	gtk_main ();
#line 224 "tracker-search-tool.c"
	_g_object_unref0 (builder);
	_g_object_unref0 (window);
	_g_object_unref0 (query);
	_g_object_unref0 (entry);
	_g_object_unref0 (grid);
	_g_object_unref0 (categories);
	_g_object_unref0 (tile);
	_g_object_unref0 (entry_box);
	_g_object_unref0 (grid_box);
	_g_object_unref0 (category_box);
	_g_object_unref0 (detail_box);
}


#line 26 "tracker-search-tool.gs"
int main (int argc, char ** argv) {
#line 26 "tracker-search-tool.gs"
	g_type_init ();
#line 26 "tracker-search-tool.gs"
	_main (argv, argc);
#line 26 "tracker-search-tool.gs"
	return 0;
#line 247 "tracker-search-tool.c"
}




