/* tracker-turtle-reader.c generated by valac, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>


#define TRACKER_TYPE_TURTLE_READER (tracker_turtle_reader_get_type ())
#define TRACKER_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader))
#define TRACKER_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))
#define TRACKER_IS_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_IS_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_TURTLE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))

typedef struct _TrackerTurtleReader TrackerTurtleReader;
typedef struct _TrackerTurtleReaderClass TrackerTurtleReaderClass;
typedef struct _TrackerTurtleReaderPrivate TrackerTurtleReaderPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _TrackerTurtleReader {
	GObject parent_instance;
	TrackerTurtleReaderPrivate * priv;
};

struct _TrackerTurtleReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint tokens_size;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	char* _graph;
	char* _subject;
	char* _predicate;
	char* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	char** subject_stack;
	gint subject_stack_length1;
	gint subject_stack_size;
	char** predicate_stack;
	gint predicate_stack_length1;
	gint predicate_stack_size;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint base_uuid_size;
	GMappedFile* mapped_file;
};

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()

static gpointer tracker_turtle_reader_parent_class = NULL;

GType tracker_turtle_reader_get_type (void);
GType tracker_sparql_scanner_get_type (void);
static GType tracker_turtle_reader_token_info_get_type (void);
GType tracker_sparql_token_type_get_type (void);
GType tracker_source_location_get_type (void);
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void);
#define TRACKER_TURTLE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderPrivate))
enum  {
	TRACKER_TURTLE_READER_DUMMY_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH,
	TRACKER_TURTLE_READER_SUBJECT,
	TRACKER_TURTLE_READER_PREDICATE,
	TRACKER_TURTLE_READER_OBJECT,
	TRACKER_TURTLE_READER_OBJECT_IS_URI
};
#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
void uuid_generate (guchar* uuid);
TrackerTurtleReader* tracker_turtle_reader_new (const char* path, GError** error);
TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const char* path, GError** error);
static char* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const char* user_bnodeid);
GQuark tracker_sparql_error_quark (void);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const char* msg);
const char* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
static char* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip);
static char* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const char* prefix, const char* local_name, GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const char* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const char* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const char* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value);
const char* tracker_turtle_reader_get_subject (TrackerTurtleReader* self);
static void _vala_array_add5 (char*** array, int* length, int* size, char* value);
const char* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self);
static void _vala_array_add6 (char*** array, int* length, int* size, char* value);
gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error);
gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self);
const char* tracker_turtle_reader_get_graph (TrackerTurtleReader* self);
const char* tracker_turtle_reader_get_object (TrackerTurtleReader* self);
void tracker_turtle_reader_load (const char* path, GError** error);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const char* value);
static void tracker_turtle_reader_finalize (GObject* obj);
static void tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);




static GType tracker_turtle_reader_state_get_type (void) {
	static GType tracker_turtle_reader_state_type_id = 0;
	if (G_UNLIKELY (tracker_turtle_reader_state_type_id == 0)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
		tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
	}
	return tracker_turtle_reader_state_type_id;
}


TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const char* path, GError** error) {
	GError * _inner_error_;
	TrackerTurtleReader * self;
	GMappedFile* _tmp0_;
	GMappedFile* _tmp1_;
	TrackerSparqlScanner* _tmp2_;
	guchar* _tmp3_;
	TrackerTurtleReaderTokenInfo* _tmp4_;
	GHashTable* _tmp5_;
	g_return_val_if_fail (path != NULL, NULL);
	_inner_error_ = NULL;
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
	_tmp0_ = g_mapped_file_new (path, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			g_object_unref (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->mapped_file = (_tmp1_ = _tmp0_, _g_mapped_file_free0 (self->priv->mapped_file), _tmp1_);
	self->priv->scanner = (_tmp2_ = tracker_sparql_scanner_new (g_mapped_file_get_contents (self->priv->mapped_file), g_mapped_file_get_length (self->priv->mapped_file)), _g_object_unref0 (self->priv->scanner), _tmp2_);
	self->priv->base_uuid = (_tmp3_ = g_new0 (guchar, 16), self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL), self->priv->base_uuid_length1 = 16, self->priv->base_uuid_size = self->priv->base_uuid_length1, _tmp3_);
	uuid_generate (self->priv->base_uuid);
	self->priv->tokens = (_tmp4_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE), self->priv->tokens = (g_free (self->priv->tokens), NULL), self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE, self->priv->tokens_size = self->priv->tokens_length1, _tmp4_);
	self->priv->prefix_map = (_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->prefix_map), _tmp5_);
	return self;
}


TrackerTurtleReader* tracker_turtle_reader_new (const char* path, GError** error) {
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, path, error);
}


static char* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const char* user_bnodeid) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (user_bnodeid == NULL) {
		result = g_strdup_printf (":%d", self->priv->bnodeid = self->priv->bnodeid + 1);
		return result;
	} else {
		GChecksum* checksum;
		char* sha1;
		checksum = g_checksum_new (G_CHECKSUM_SHA1);
		g_checksum_update (checksum, self->priv->base_uuid, (gsize) 16);
		g_checksum_update (checksum, (guchar*) user_bnodeid, (gsize) (-1));
		sha1 = g_strdup (g_checksum_get_string (checksum));
		result = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, g_utf8_offset_to_pointer (sha1, (glong) 8), g_utf8_offset_to_pointer (sha1, (glong) 12), g_utf8_offset_to_pointer (sha1, (glong) 16), g_utf8_offset_to_pointer (sha1, (glong) 20));
		_g_checksum_free0 (checksum);
		_g_free0 (sha1);
		return result;
	}
}


static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	self->priv->index = (self->priv->index + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type;
		type = tracker_sparql_scanner_read_token (self->priv->scanner, &begin, &end, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	result = self->priv->tokens[self->priv->index].type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
	return result;
}


static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self) {
	TrackerSparqlTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tokens[self->priv->index].type;
	return result;
}


static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	if (tracker_turtle_reader_current (self) == type) {
		tracker_turtle_reader_next_token (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const char* msg) {
	GError* result;
	char* _tmp0_;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = (_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp0_ = g_strdup_printf ("%d.%d: syntax error, %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result;
	GError * _inner_error_;
	gboolean _tmp0_;
	char* _tmp1_;
	GError* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_turtle_reader_accept (self, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_inner_error_ = (_tmp2_ = tracker_turtle_reader_get_error (self, _tmp1_ = g_strdup_printf ("expected %s", tracker_sparql_token_type_to_string (type))), _g_free0 (_tmp1_), _tmp2_);
	{
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
}


static char* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip) {
	char* result;
	gint last_index;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
	result = g_strndup ((const char*) (self->priv->tokens[last_index].begin.pos + strip), (self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos) - (2 * strip));
	return result;
}


static char* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const char* prefix, const char* local_name, GError** error) {
	char* result;
	GError * _inner_error_;
	char* ns;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_inner_error_ = NULL;
	ns = g_strdup ((const char*) g_hash_table_lookup (self->priv->prefix_map, prefix));
	if (ns == NULL) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = tracker_turtle_reader_get_error (self, _tmp0_ = g_strdup_printf ("use of undefined prefix `%s'", prefix)), _g_free0 (_tmp0_), _tmp1_);
		{
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return NULL;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = g_strconcat (ns, local_name, NULL);
	_g_free0 (ns);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void _vala_array_add5 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	while (TRUE) {
		switch (self->priv->state) {
			case TRACKER_TURTLE_READER_STATE_INITIAL:
			{
				tracker_turtle_reader_next_token (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
				continue;
			}
			case TRACKER_TURTLE_READER_STATE_BOS:
			{
				gboolean _tmp0_;
				gboolean _tmp4_;
				_tmp0_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp0_) {
					char* ns;
					gboolean _tmp1_;
					char* uri;
					ns = g_strdup ("");
					_tmp1_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp1_) {
						char* _tmp2_;
						ns = (_tmp2_ = tracker_turtle_reader_get_last_string (self, 0), _g_free0 (ns), _tmp2_);
					}
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					uri = tracker_turtle_reader_get_last_string (self, 1);
					g_hash_table_insert (self->priv->prefix_map, g_strdup (ns), g_strdup (uri));
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (uri);
							return FALSE;
						} else {
							_g_free0 (ns);
							_g_free0 (uri);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (ns);
					_g_free0 (uri);
					continue;
				} else {
					gboolean _tmp3_;
					_tmp3_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp3_) {
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						continue;
					} else {
						if (tracker_turtle_reader_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
							result = FALSE;
							return result;
						}
					}
				}
				_tmp4_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp4_) {
					char* _tmp5_;
					tracker_turtle_reader_set_subject (self, _tmp5_ = tracker_turtle_reader_get_last_string (self, 1));
					_g_free0 (_tmp5_);
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
					continue;
				} else {
					gboolean _tmp6_;
					_tmp6_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp6_) {
						char* ns;
						char* _tmp8_;
						char* _tmp7_;
						char* _tmp9_;
						char* _tmp10_;
						char* _tmp11_;
						ns = tracker_turtle_reader_get_last_string (self, 0);
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp10_ = (_tmp9_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp8_ = string_substring (_tmp7_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _tmp9_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						tracker_turtle_reader_set_subject (self, _tmp11_ = _tmp10_);
						_g_free0 (_tmp11_);
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
						_g_free0 (ns);
						continue;
					} else {
						gboolean _tmp12_;
						_tmp12_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp12_) {
							char* _tmp14_;
							char* _tmp13_;
							char* _tmp15_;
							char* _tmp16_;
							char* _tmp17_;
							_tmp16_ = (_tmp15_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp14_ = string_substring (_tmp13_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							tracker_turtle_reader_set_subject (self, _tmp17_ = _tmp16_);
							_g_free0 (_tmp17_);
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
							continue;
						} else {
							gboolean _tmp18_;
							_tmp18_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp18_) {
								char* _tmp21_;
								char* _tmp20_;
								char* _tmp19_;
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								tracker_turtle_reader_set_subject (self, _tmp21_ = tracker_turtle_reader_generate_bnodeid (self, _tmp20_ = string_substring (_tmp19_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1)));
								_g_free0 (_tmp21_);
								_g_free0 (_tmp20_);
								_g_free0 (_tmp19_);
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
								continue;
							} else {
								_inner_error_ = tracker_turtle_reader_get_error (self, "expected subject");
								{
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
			{
				gboolean _tmp22_;
				_tmp22_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp22_) {
					char* _tmp23_;
					tracker_turtle_reader_set_predicate (self, _tmp23_ = tracker_turtle_reader_get_last_string (self, 1));
					_g_free0 (_tmp23_);
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
					continue;
				} else {
					gboolean _tmp24_;
					_tmp24_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp24_) {
						char* ns;
						char* _tmp26_;
						char* _tmp25_;
						char* _tmp27_;
						char* _tmp28_;
						char* _tmp29_;
						ns = tracker_turtle_reader_get_last_string (self, 0);
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp28_ = (_tmp27_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp26_ = string_substring (_tmp25_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp26_), _g_free0 (_tmp25_), _tmp27_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						tracker_turtle_reader_set_predicate (self, _tmp29_ = _tmp28_);
						_g_free0 (_tmp29_);
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
						_g_free0 (ns);
						continue;
					} else {
						gboolean _tmp30_;
						_tmp30_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp30_) {
							char* _tmp32_;
							char* _tmp31_;
							char* _tmp33_;
							char* _tmp34_;
							char* _tmp35_;
							_tmp34_ = (_tmp33_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp32_ = string_substring (_tmp31_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp32_), _g_free0 (_tmp31_), _tmp33_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							tracker_turtle_reader_set_predicate (self, _tmp35_ = _tmp34_);
							_g_free0 (_tmp35_);
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
							continue;
						} else {
							gboolean _tmp36_;
							_tmp36_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp36_) {
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
								continue;
							} else {
								_inner_error_ = tracker_turtle_reader_get_error (self, "expected predicate");
								{
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
			{
				gboolean _tmp37_;
				_tmp37_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp37_) {
					char* _tmp38_;
					tracker_turtle_reader_set_object (self, _tmp38_ = tracker_turtle_reader_get_last_string (self, 1));
					_g_free0 (_tmp38_);
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
					result = TRUE;
					return result;
				} else {
					gboolean _tmp39_;
					_tmp39_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp39_) {
						char* ns;
						char* _tmp41_;
						char* _tmp40_;
						char* _tmp42_;
						char* _tmp43_;
						char* _tmp44_;
						ns = tracker_turtle_reader_get_last_string (self, 0);
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp43_ = (_tmp42_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp41_ = string_substring (_tmp40_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp41_), _g_free0 (_tmp40_), _tmp42_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						tracker_turtle_reader_set_object (self, _tmp44_ = _tmp43_);
						_g_free0 (_tmp44_);
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
						result = TRUE;
						_g_free0 (ns);
						return result;
					} else {
						gboolean _tmp45_;
						_tmp45_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp45_) {
							char* _tmp47_;
							char* _tmp46_;
							char* _tmp48_;
							char* _tmp49_;
							char* _tmp50_;
							_tmp49_ = (_tmp48_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp47_ = string_substring (_tmp46_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp47_), _g_free0 (_tmp46_), _tmp48_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							tracker_turtle_reader_set_object (self, _tmp50_ = _tmp49_);
							_g_free0 (_tmp50_);
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
							result = TRUE;
							return result;
						} else {
							gboolean _tmp51_;
							_tmp51_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp51_) {
								char* _tmp54_;
								char* _tmp53_;
								char* _tmp52_;
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								tracker_turtle_reader_set_object (self, _tmp54_ = tracker_turtle_reader_generate_bnodeid (self, _tmp53_ = string_substring (_tmp52_ = tracker_turtle_reader_get_last_string (self, 0), (glong) 1, -1)));
								_g_free0 (_tmp54_);
								_g_free0 (_tmp53_);
								_g_free0 (_tmp52_);
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
								result = TRUE;
								return result;
							} else {
								gboolean _tmp55_;
								_tmp55_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								if (_tmp55_) {
									char* _tmp56_;
									_vala_array_add5 (&self->priv->subject_stack, &self->priv->subject_stack_length1, &self->priv->subject_stack_size, g_strdup (self->priv->_subject));
									_vala_array_add6 (&self->priv->predicate_stack, &self->priv->predicate_stack_length1, &self->priv->predicate_stack_size, g_strdup (self->priv->_predicate));
									tracker_turtle_reader_set_subject (self, _tmp56_ = tracker_turtle_reader_generate_bnodeid (self, NULL));
									_g_free0 (_tmp56_);
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
									continue;
								} else {
									gboolean _tmp57_ = FALSE;
									gboolean _tmp58_;
									_tmp58_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return FALSE;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return FALSE;
										}
									}
									if (_tmp58_) {
										_tmp57_ = TRUE;
									} else {
										gboolean _tmp59_;
										_tmp59_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return FALSE;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										_tmp57_ = _tmp59_;
									}
									if (_tmp57_) {
										GString* sb;
										char* s;
										const char* p;
										const char* end;
										gboolean _tmp60_;
										sb = g_string_new ("");
										s = tracker_turtle_reader_get_last_string (self, 1);
										p = s;
										end = p + strlen (s);
										while (TRUE) {
											const char* q;
											if (!(((glong) p) < ((glong) end))) {
												break;
											}
											q = strchr (p, (gint) '\\');
											if (q == NULL) {
												g_string_append_len (sb, p, (gssize) ((glong) (end - p)));
												p = end;
											} else {
												g_string_append_len (sb, p, (gssize) ((glong) (q - p)));
												p = q + 1;
												switch (((gchar*) p)[0]) {
													case '\'':
													case '"':
													case '\\':
													{
														g_string_append_c (sb, ((gchar*) p)[0]);
														break;
													}
													case 'b':
													{
														g_string_append_c (sb, '\b');
														break;
													}
													case 'f':
													{
														g_string_append_c (sb, '\f');
														break;
													}
													case 'n':
													{
														g_string_append_c (sb, '\n');
														break;
													}
													case 'r':
													{
														g_string_append_c (sb, '\r');
														break;
													}
													case 't':
													{
														g_string_append_c (sb, '\t');
														break;
													}
												}
												p++;
											}
										}
										tracker_turtle_reader_set_object (self, sb->str);
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
										_tmp60_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_string_free0 (sb);
												_g_free0 (s);
												return FALSE;
											} else {
												_g_string_free0 (sb);
												_g_free0 (s);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										if (_tmp60_) {
											gboolean _tmp61_;
											_tmp61_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_string_free0 (sb);
													_g_free0 (s);
													return FALSE;
												} else {
													_g_string_free0 (sb);
													_g_free0 (s);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (!_tmp61_) {
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_string_free0 (sb);
														_g_free0 (s);
														return FALSE;
													} else {
														_g_string_free0 (sb);
														_g_free0 (s);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_string_free0 (sb);
														_g_free0 (s);
														return FALSE;
													} else {
														_g_string_free0 (sb);
														_g_free0 (s);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
											}
										}
										result = TRUE;
										_g_string_free0 (sb);
										_g_free0 (s);
										return result;
									} else {
										gboolean _tmp62_ = FALSE;
										gboolean _tmp63_;
										_tmp63_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return FALSE;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										if (_tmp63_) {
											_tmp62_ = TRUE;
										} else {
											gboolean _tmp64_;
											_tmp64_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											_tmp62_ = _tmp64_;
										}
										if (_tmp62_) {
											char* _tmp65_;
											gboolean _tmp66_;
											tracker_turtle_reader_set_object (self, _tmp65_ = tracker_turtle_reader_get_last_string (self, 3));
											_g_free0 (_tmp65_);
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
											_tmp66_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (_tmp66_) {
												gboolean _tmp67_;
												_tmp67_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												if (!_tmp67_) {
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return FALSE;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return FALSE;
														}
													}
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return FALSE;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return FALSE;
														}
													}
												}
											}
											result = TRUE;
											return result;
										} else {
											gboolean _tmp68_ = FALSE;
											gboolean _tmp69_ = FALSE;
											gboolean _tmp70_ = FALSE;
											gboolean _tmp71_ = FALSE;
											gboolean _tmp72_;
											_tmp72_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (_tmp72_) {
												_tmp71_ = TRUE;
											} else {
												gboolean _tmp73_;
												_tmp73_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp71_ = _tmp73_;
											}
											if (_tmp71_) {
												_tmp70_ = TRUE;
											} else {
												gboolean _tmp74_;
												_tmp74_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp70_ = _tmp74_;
											}
											if (_tmp70_) {
												_tmp69_ = TRUE;
											} else {
												gboolean _tmp75_;
												_tmp75_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp69_ = _tmp75_;
											}
											if (_tmp69_) {
												_tmp68_ = TRUE;
											} else {
												gboolean _tmp76_;
												_tmp76_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp68_ = _tmp76_;
											}
											if (_tmp68_) {
												char* _tmp77_;
												tracker_turtle_reader_set_object (self, _tmp77_ = tracker_turtle_reader_get_last_string (self, 0));
												_g_free0 (_tmp77_);
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
												result = TRUE;
												return result;
											} else {
												_inner_error_ = tracker_turtle_reader_get_error (self, "expected object");
												{
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_OBJECT:
			{
				gboolean _tmp78_;
				_tmp78_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp78_) {
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
					continue;
				} else {
					gboolean _tmp79_;
					_tmp79_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp79_) {
						gboolean _tmp80_;
						_tmp80_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp80_) {
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
							continue;
						}
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
						continue;
					} else {
						if (self->priv->subject_stack_length1 > 0) {
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							tracker_turtle_reader_set_object (self, self->priv->_subject);
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
							tracker_turtle_reader_set_subject (self, self->priv->subject_stack[self->priv->subject_stack_length1 - 1]);
							self->priv->subject_stack_length1--;
							tracker_turtle_reader_set_predicate (self, self->priv->predicate_stack[self->priv->predicate_stack_length1 - 1]);
							self->priv->predicate_stack_length1--;
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
							result = TRUE;
							return result;
						} else {
							gboolean _tmp81_;
							_tmp81_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp81_) {
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
								continue;
							} else {
								_inner_error_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
								{
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


void tracker_turtle_reader_load (const char* path, GError** error) {
	GError * _inner_error_;
	TrackerTurtleReader* reader;
	g_return_if_fail (path != NULL);
	_inner_error_ = NULL;
	reader = tracker_turtle_reader_new (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = tracker_turtle_reader_next (reader, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (reader);
				return;
			} else {
				_g_object_unref0 (reader);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp0_) {
			break;
		}
		if (reader->priv->_object_is_uri) {
			tracker_data_insert_statement_with_uri (reader->priv->_graph, reader->priv->_subject, reader->priv->_predicate, reader->priv->_object, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (reader);
					return;
				} else {
					_g_object_unref0 (reader);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			tracker_data_insert_statement_with_string (reader->priv->_graph, reader->priv->_subject, reader->priv->_predicate, reader->priv->_object, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATA_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (reader);
					return;
				} else {
					_g_object_unref0 (reader);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	_g_object_unref0 (reader);
}


const char* tracker_turtle_reader_get_graph (TrackerTurtleReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_graph;
	return result;
}


static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_graph = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_graph), _tmp0_);
	g_object_notify ((GObject *) self, "graph");
}


const char* tracker_turtle_reader_get_subject (TrackerTurtleReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_subject;
	return result;
}


static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_subject = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_subject), _tmp0_);
	g_object_notify ((GObject *) self, "subject");
}


const char* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_predicate;
	return result;
}


static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_predicate = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_predicate), _tmp0_);
	g_object_notify ((GObject *) self, "predicate");
}


const char* tracker_turtle_reader_get_object (TrackerTurtleReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_object;
	return result;
}


static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_object = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_object), _tmp0_);
	g_object_notify ((GObject *) self, "object");
}


gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_object_is_uri;
	return result;
}


static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_object_is_uri = value;
	g_object_notify ((GObject *) self, "object-is-uri");
}


static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self) {
	TrackerTurtleReaderTokenInfo* dup;
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
	memcpy (dup, self, sizeof (TrackerTurtleReaderTokenInfo));
	return dup;
}


static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self) {
	g_free (self);
}


static GType tracker_turtle_reader_token_info_get_type (void) {
	static GType tracker_turtle_reader_token_info_type_id = 0;
	if (tracker_turtle_reader_token_info_type_id == 0) {
		tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
	}
	return tracker_turtle_reader_token_info_type_id;
}


static void tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass) {
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerTurtleReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_turtle_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_turtle_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH, g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE, g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT, g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI, g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_turtle_reader_instance_init (TrackerTurtleReader * self) {
	self->priv = TRACKER_TURTLE_READER_GET_PRIVATE (self);
	self->priv->bnodeid = 0;
}


static void tracker_turtle_reader_finalize (GObject* obj) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (obj);
	_g_object_unref0 (self->priv->scanner);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_g_free0 (self->priv->_graph);
	_g_free0 (self->priv->_subject);
	_g_free0 (self->priv->_predicate);
	_g_free0 (self->priv->_object);
	_g_hash_table_unref0 (self->priv->prefix_map);
	self->priv->subject_stack = (_vala_array_free (self->priv->subject_stack, self->priv->subject_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->predicate_stack = (_vala_array_free (self->priv->predicate_stack, self->priv->predicate_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	_g_mapped_file_free0 (self->priv->mapped_file);
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
}


GType tracker_turtle_reader_get_type (void) {
	static GType tracker_turtle_reader_type_id = 0;
	if (tracker_turtle_reader_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
		tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
	}
	return tracker_turtle_reader_type_id;
}


static void tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (object);
	switch (property_id) {
		case TRACKER_TURTLE_READER_GRAPH:
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
		break;
		case TRACKER_TURTLE_READER_SUBJECT:
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
		break;
		case TRACKER_TURTLE_READER_PREDICATE:
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
		break;
		case TRACKER_TURTLE_READER_OBJECT:
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
		break;
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (object);
	switch (property_id) {
		case TRACKER_TURTLE_READER_GRAPH:
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_SUBJECT:
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_PREDICATE:
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_OBJECT:
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




