/* tracker-sparql-expression.c generated by valac, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-ontologies.h>


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
};

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	char* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	GHashTable* used_sql_identifiers;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	char* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
GQuark tracker_sparql_error_quark (void);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const char* msg);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static char* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
static char* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const char* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const char* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const char* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const char* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const char* value);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, GError** error);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
char* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const char* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
char* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const char* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
char* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const char* suffix);
char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const char* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const char* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
	self->priv->query = query;
	return self;
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = tracker_sparql_query_current (self->priv->query);
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = tracker_sparql_query_last (self->priv->query);
	return result;
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const char* msg) {
	GError* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = tracker_sparql_query_get_error (self->priv->query, msg);
	return result;
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp0_;
	return result;
}


static char* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = tracker_sparql_query_get_last_string (self->priv->query, strip);
	return result;
}


static char* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const char* literal) {
	char* result = NULL;
	char* _tmp2_;
	gint _tmp1__length1;
	char** _tmp1_;
	char** _tmp0_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	result = (_tmp3_ = g_strdup_printf ("'%s'", _tmp2_ = g_strjoinv ("''", (_tmp1_ = _tmp0_ = g_strsplit (literal, "'", 0), _tmp1__length1 = _vala_array_length (_tmp0_), _tmp1_))), _g_free0 (_tmp2_), _tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL), _tmp3_);
	return result;
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (type == TRACKER_PROPERTY_TYPE_INTEGER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == TRACKER_PROPERTY_TYPE_DOUBLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == TRACKER_PROPERTY_TYPE_DATETIME;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == TRACKER_PROPERTY_TYPE_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		switch (tracker_sparql_expression_current (self)) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		switch (tracker_sparql_expression_current (self)) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerSparqlVariable* variable;
	glong begin;
	TrackerPropertyType type;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	variable = NULL;
	begin = (glong) sql->len;
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		TrackerPropertyType _tmp0_;
		TrackerSparqlVariable* _tmp3_;
		char* _tmp2_;
		char* _tmp1_;
		_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp0_;
		variable = (_tmp3_ = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), _tmp2_ = string_substring (_tmp1_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1))), _g_object_unref0 (variable), _tmp3_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		if (variable->binding == NULL) {
			char* _tmp4_;
			GError* _tmp5_;
			_inner_error_ = (_tmp5_ = tracker_sparql_expression_get_error (self, _tmp4_ = g_strdup_printf ("use of undefined variable `%s'", tracker_sparql_variable_get_name (variable))), _g_free0 (_tmp4_), _tmp5_);
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					return 0;
				} else {
					_g_object_unref0 (variable);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	} else {
		TrackerPropertyType _tmp6_;
		_tmp6_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp6_;
	}
	if (!subquery) {
		tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
		type = TRACKER_PROPERTY_TYPE_STRING;
	}
	_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (variable);
			return 0;
		} else {
			_g_object_unref0 (variable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp8_) {
			TrackerSparqlVariable* _tmp10_;
			char* _tmp9_;
			variable = (_tmp10_ = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), _tmp9_ = tracker_sparql_expression_get_last_string (self, 0))), _g_object_unref0 (variable), _tmp10_);
			_g_free0 (_tmp9_);
		} else {
			TrackerSparqlVariable* _tmp13_;
			char* _tmp12_;
			char* _tmp11_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					return 0;
				} else {
					_g_object_unref0 (variable);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			variable = (_tmp13_ = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), _tmp12_ = string_substring (_tmp11_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1))), _g_object_unref0 (variable), _tmp13_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp11_);
		}
		g_string_append_printf (sql, " AS %s", tracker_sparql_variable_get_sql_expression (variable));
		if (subquery) {
			TrackerSparqlVariableBinding* binding;
			GString* _tmp14_;
			binding = tracker_sparql_variable_binding_new ();
			((TrackerSparqlDataBinding*) binding)->data_type = type;
			binding->variable = variable;
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, tracker_sparql_variable_get_sql_expression (variable));
			tracker_sparql_pattern_add_variable_binding (tracker_sparql_expression_get_pattern (self), _tmp14_ = g_string_new (""), binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_string_free0 (_tmp14_);
			_g_object_unref0 (binding);
		}
	}
	if (variable != NULL) {
		gint state;
		state = GPOINTER_TO_INT (g_hash_table_lookup (tracker_sparql_expression_get_context (self)->var_set, variable));
		if (state == 0) {
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
		}
		g_hash_table_insert (tracker_sparql_expression_get_context (self)->select_var_set, _g_object_ref0 (variable), GINT_TO_POINTER (state));
	}
	result = type;
	_g_object_unref0 (variable);
	return result;
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
		g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
		g_string_append (sql, ")");
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, " ASC");
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_string_append (sql, " DESC");
		} else {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "(");
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, " IS NOT NULL)");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp2_;
	char* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "SparqlRegex(");
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ", ");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, _tmp2_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp1_ = _tmp0_));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	g_string_append (sql, ", ");
	_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp3_) {
		char* _tmp4_;
		char* _tmp6_;
		char* _tmp5_;
		_tmp4_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, _tmp6_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp5_ = _tmp4_));
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
	} else {
		g_string_append (sql, "''");
	}
	g_string_append (sql, ")");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	g_string_append (sql, "(");
	tracker_sparql_pattern_translate_exists (tracker_sparql_expression_get_pattern (self), sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ")");
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const char* expression, TrackerPropertyType type) {
	glong begin;
	g_return_if_fail (sql != NULL);
	g_return_if_fail (expression != NULL);
	begin = (glong) sql->len;
	g_string_append (sql, expression);
	tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	g_return_if_fail (sql != NULL);
	switch (type) {
		case TRACKER_PROPERTY_TYPE_STRING:
		case TRACKER_PROPERTY_TYPE_INTEGER:
		{
			break;
		}
		case TRACKER_PROPERTY_TYPE_RESOURCE:
		{
			g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
			g_string_append (sql, ")");
			break;
		}
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
		{
			g_string_insert (sql, (gssize) begin, "CASE ");
			g_string_append (sql, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
			break;
		}
		case TRACKER_PROPERTY_TYPE_DATETIME:
		{
			g_string_insert (sql, (gssize) begin, "strftime (\"%Y-%m-%dT%H:%M:%SZ\", ");
			g_string_append (sql, ", \"unixepoch\")");
			break;
		}
		default:
		{
			g_string_insert (sql, (gssize) begin, "CAST (");
			g_string_append (sql, " AS TEXT)");
			break;
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	switch (tracker_sparql_expression_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			char* _tmp0_;
			char* _tmp1_;
			gboolean _tmp2_;
			binding = tracker_sparql_literal_binding_new ();
			_tmp0_ = tracker_sparql_pattern_parse_var_or_term (tracker_sparql_expression_get_pattern (self), NULL, &is_var, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			binding->literal = (_tmp1_ = _tmp0_, _g_free0 (binding->literal), _tmp1_);
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp2_) {
				glong begin;
				TrackerPropertyType type;
				begin = (glong) sql->len;
				type = tracker_sparql_expression_translate_function (self, sql, binding->literal, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			} else {
				g_string_append (sql, "?");
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			}
			_g_object_unref0 (binding);
			break;
		}
		default:
		{
			glong begin;
			TrackerPropertyType type;
			begin = (glong) sql->len;
			type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			break;
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	TrackerSparqlLiteralBinding* new_binding;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!_tmp0_) {
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "?");
	new_binding = tracker_sparql_literal_binding_new ();
	((TrackerSparqlDataBinding*) new_binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
		char* _tmp1_;
		new_binding->literal = (_tmp1_ = g_strdup ("1"), _g_free0 (new_binding->literal), _tmp1_);
		tracker_sparql_expression_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GString* _tmp2_;
		TrackerPropertyType _tmp3_;
		TrackerPropertyType _tmp4_;
		_tmp4_ = (_tmp3_ = tracker_sparql_expression_translate_expression (self, _tmp2_ = g_string_new (""), &_inner_error_), _g_string_free0 (_tmp2_), _tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
			char* _tmp5_;
			new_binding->literal = (_tmp5_ = g_strdup ("1"), _g_free0 (new_binding->literal), _tmp5_);
		} else {
			char* _tmp6_;
			new_binding->literal = (_tmp6_ = g_strdup ("0"), _g_free0 (new_binding->literal), _tmp6_);
		}
	}
	self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (new_binding));
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (new_binding);
			return;
		} else {
			_g_object_unref0 (new_binding);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_binding);
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		char* variable_name;
		TrackerSparqlVariable* variable;
		gboolean _tmp5_ = FALSE;
		TrackerSparqlLiteralBinding* new_binding;
		char* _tmp6_;
		variable_name = (_tmp2_ = string_substring (_tmp1_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp1_), _tmp2_);
		variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
		if (variable->binding == NULL) {
			char* _tmp3_;
			GError* _tmp4_;
			_inner_error_ = (_tmp4_ = tracker_sparql_expression_get_error (self, _tmp3_ = g_strdup_printf ("`%s' is not a valid variable", tracker_sparql_variable_get_name (variable))), _g_free0 (_tmp3_), _tmp4_);
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					_g_free0 (variable_name);
					return;
				} else {
					_g_object_unref0 (variable);
					_g_free0 (variable_name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		if (((TrackerSparqlDataBinding*) variable->binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = variable->binding->type == NULL;
		}
		if (_tmp5_) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					_g_free0 (variable_name);
					return;
				} else {
					_g_object_unref0 (variable);
					_g_free0 (variable_name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
		new_binding = tracker_sparql_literal_binding_new ();
		new_binding->literal = (_tmp6_ = g_strdup (tracker_class_get_uri (variable->binding->type)), _g_free0 (new_binding->literal), _tmp6_);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (new_binding));
		_g_object_unref0 (new_binding);
		_g_object_unref0 (variable);
		_g_free0 (variable_name);
	} else {
		_inner_error_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
		{
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const char* uri, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_inner_error_ = NULL;
	if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = TRACKER_PROPERTY_TYPE_STRING;
		return result;
	} else {
		if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			g_string_append (sql, "CAST (");
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " AS INTEGER)");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		} else {
			if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				g_string_append (sql, "CAST (");
				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, " AS REAL)");
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
				return result;
			} else {
				if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
					g_string_append (sql, "lower (");
					tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					g_string_append (sql, ")");
					result = TRACKER_PROPERTY_TYPE_STRING;
					return result;
				} else {
					if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
						TrackerSparqlLiteralBinding* binding;
						char* _tmp0_;
						char* _tmp2_;
						char* _tmp1_;
						g_string_append (sql, "(");
						tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						g_string_append (sql, " GLOB ");
						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						g_string_append (sql, "?");
						binding = tracker_sparql_literal_binding_new ();
						_tmp0_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								return 0;
							} else {
								_g_object_unref0 (binding);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						binding->literal = (_tmp2_ = g_strdup_printf ("*%s*", _tmp1_ = _tmp0_), _g_free0 (binding->literal), _tmp2_);
						_g_free0 (_tmp1_);
						self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
						g_string_append (sql, ")");
						result = TRACKER_PROPERTY_TYPE_BOOLEAN;
						_g_object_unref0 (binding);
						return result;
					} else {
						if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
							TrackerSparqlLiteralBinding* binding;
							char* _tmp3_;
							char* _tmp5_;
							char* _tmp4_;
							g_string_append (sql, "(");
							tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							g_string_append (sql, " GLOB ");
							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							g_string_append (sql, "?");
							binding = tracker_sparql_literal_binding_new ();
							_tmp3_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (binding);
									return 0;
								} else {
									_g_object_unref0 (binding);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							binding->literal = (_tmp5_ = g_strdup_printf ("%s*", _tmp4_ = _tmp3_), _g_free0 (binding->literal), _tmp5_);
							_g_free0 (_tmp4_);
							self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
							g_string_append (sql, ")");
							result = TRACKER_PROPERTY_TYPE_BOOLEAN;
							_g_object_unref0 (binding);
							return result;
						} else {
							if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
								TrackerSparqlLiteralBinding* binding;
								char* _tmp6_;
								char* _tmp8_;
								char* _tmp7_;
								g_string_append (sql, "(");
								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, " GLOB ");
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, "?");
								binding = tracker_sparql_literal_binding_new ();
								_tmp6_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (binding);
										return 0;
									} else {
										_g_object_unref0 (binding);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								binding->literal = (_tmp8_ = g_strdup_printf ("*%s", _tmp7_ = _tmp6_), _g_free0 (binding->literal), _tmp8_);
								_g_free0 (_tmp7_);
								self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
								g_string_append (sql, ")");
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
								_g_object_unref0 (binding);
								return result;
							} else {
								if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
									gboolean _tmp9_;
									g_string_append (sql, "substr(");
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									g_string_append (sql, ", ");
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									if (_tmp9_) {
										g_string_append (sql, ", ");
										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
									}
									g_string_append (sql, ")");
									result = TRACKER_PROPERTY_TYPE_STRING;
									return result;
								} else {
									if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										g_string_append (sql, "||");
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										while (TRUE) {
											gboolean _tmp10_;
											_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											if (!_tmp10_) {
												break;
											}
											g_string_append (sql, "||");
											tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
										}
										result = TRACKER_PROPERTY_TYPE_STRING;
										return result;
									} else {
										if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
											g_string_append (sql, "SparqlStringJoin(");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ", ");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											while (TRUE) {
												gboolean _tmp11_;
												_tmp11_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												if (!_tmp11_) {
													break;
												}
												g_string_append (sql, ", ");
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
											}
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ",");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ")");
											result = TRACKER_PROPERTY_TYPE_STRING;
											return result;
										} else {
											if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
												char* _tmp12_;
												char* _tmp13_;
												char* variable_name;
												TrackerSparqlVariable* variable;
												char* _tmp14_;
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												variable_name = (_tmp13_ = string_substring (_tmp12_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp12_), _tmp13_);
												variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
												g_string_append (sql, "strftime (\"%Y\", ");
												g_string_append (sql, _tmp14_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate"));
												_g_free0 (_tmp14_);
												g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
												result = TRACKER_PROPERTY_TYPE_INTEGER;
												_g_object_unref0 (variable);
												_g_free0 (variable_name);
												return result;
											} else {
												if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
													char* _tmp15_;
													char* _tmp16_;
													char* variable_name;
													TrackerSparqlVariable* variable;
													char* _tmp17_;
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													variable_name = (_tmp16_ = string_substring (_tmp15_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp15_), _tmp16_);
													variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
													g_string_append (sql, "strftime (\"%m\", ");
													g_string_append (sql, _tmp17_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate"));
													_g_free0 (_tmp17_);
													g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
													result = TRACKER_PROPERTY_TYPE_INTEGER;
													_g_object_unref0 (variable);
													_g_free0 (variable_name);
													return result;
												} else {
													if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
														char* _tmp18_;
														char* _tmp19_;
														char* variable_name;
														TrackerSparqlVariable* variable;
														char* _tmp20_;
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																return 0;
															} else {
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return 0;
															}
														}
														variable_name = (_tmp19_ = string_substring (_tmp18_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp18_), _tmp19_);
														variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
														g_string_append (sql, "strftime (\"%d\", ");
														g_string_append (sql, _tmp20_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate"));
														_g_free0 (_tmp20_);
														g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
														result = TRACKER_PROPERTY_TYPE_INTEGER;
														_g_object_unref0 (variable);
														_g_free0 (variable_name);
														return result;
													} else {
														if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
															char* _tmp21_;
															char* _tmp22_;
															char* variable_name;
															TrackerSparqlVariable* variable;
															char* _tmp23_;
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	return 0;
																} else {
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return 0;
																}
															}
															variable_name = (_tmp22_ = string_substring (_tmp21_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp21_), _tmp22_);
															variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
															g_string_append (sql, "(");
															g_string_append (sql, _tmp23_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime"));
															_g_free0 (_tmp23_);
															g_string_append (sql, " / 3600)");
															result = TRACKER_PROPERTY_TYPE_INTEGER;
															_g_object_unref0 (variable);
															_g_free0 (variable_name);
															return result;
														} else {
															if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
																char* _tmp24_;
																char* _tmp25_;
																char* variable_name;
																TrackerSparqlVariable* variable;
																char* _tmp26_;
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		return 0;
																	} else {
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return 0;
																	}
																}
																variable_name = (_tmp25_ = string_substring (_tmp24_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp24_), _tmp25_);
																variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
																g_string_append (sql, "(");
																g_string_append (sql, _tmp26_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime"));
																_g_free0 (_tmp26_);
																g_string_append (sql, " / 60 % 60)");
																result = TRACKER_PROPERTY_TYPE_INTEGER;
																_g_object_unref0 (variable);
																_g_free0 (variable_name);
																return result;
															} else {
																if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
																	char* _tmp27_;
																	char* _tmp28_;
																	char* variable_name;
																	TrackerSparqlVariable* variable;
																	char* _tmp29_;
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																			g_propagate_error (error, _inner_error_);
																			return 0;
																		} else {
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return 0;
																		}
																	}
																	variable_name = (_tmp28_ = string_substring (_tmp27_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp27_), _tmp28_);
																	variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
																	g_string_append (sql, "(");
																	g_string_append (sql, _tmp29_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime"));
																	_g_free0 (_tmp29_);
																	g_string_append (sql, "% 60)");
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
																	_g_object_unref0 (variable);
																	_g_free0 (variable_name);
																	return result;
																} else {
																	if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
																		char* _tmp30_;
																		char* _tmp31_;
																		char* variable_name;
																		TrackerSparqlVariable* variable;
																		char* _tmp32_;
																		char* _tmp33_;
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																		if (_inner_error_ != NULL) {
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																				g_propagate_error (error, _inner_error_);
																				return 0;
																			} else {
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																				g_clear_error (&_inner_error_);
																				return 0;
																			}
																		}
																		variable_name = (_tmp31_ = string_substring (_tmp30_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp30_), _tmp31_);
																		variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
																		g_string_append (sql, "(");
																		g_string_append (sql, _tmp32_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate"));
																		_g_free0 (_tmp32_);
																		g_string_append (sql, " * 24 * 3600 + ");
																		g_string_append (sql, _tmp33_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime"));
																		_g_free0 (_tmp33_);
																		g_string_append (sql, "- ");
																		g_string_append (sql, tracker_sparql_variable_get_sql_expression (variable));
																		g_string_append (sql, ")");
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
																		_g_object_unref0 (variable);
																		_g_free0 (variable_name);
																		return result;
																	} else {
																		if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
																			gboolean is_var = FALSE;
																			char* v;
																			v = tracker_sparql_pattern_parse_var_or_term (tracker_sparql_expression_get_pattern (self), NULL, &is_var, &_inner_error_);
																			if (_inner_error_ != NULL) {
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																					g_propagate_error (error, _inner_error_);
																					return 0;
																				} else {
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																					g_clear_error (&_inner_error_);
																					return 0;
																				}
																			}
																			g_string_append_printf (sql, "\"%s_u_rank\"", v);
																			result = TRACKER_PROPERTY_TYPE_DOUBLE;
																			_g_free0 (v);
																			return result;
																		} else {
																			if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
																				gboolean is_var = FALSE;
																				char* v;
																				v = tracker_sparql_pattern_parse_var_or_term (tracker_sparql_expression_get_pattern (self), NULL, &is_var, &_inner_error_);
																				if (_inner_error_ != NULL) {
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																						g_propagate_error (error, _inner_error_);
																						return 0;
																					} else {
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																						g_clear_error (&_inner_error_);
																						return 0;
																					}
																				}
																				g_string_append_printf (sql, "\"%s_u_offsets\"", v);
																				result = TRACKER_PROPERTY_TYPE_STRING;
																				_g_free0 (v);
																				return result;
																			} else {
																				if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
																					TrackerPropertyType type;
																					type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																					if (_inner_error_ != NULL) {
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																							g_propagate_error (error, _inner_error_);
																							return 0;
																						} else {
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return 0;
																						}
																					}
																					if (type != TRACKER_PROPERTY_TYPE_RESOURCE) {
																						_inner_error_ = tracker_sparql_expression_get_error (self, "expected resource");
																						{
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																					}
																					result = TRACKER_PROPERTY_TYPE_INTEGER;
																					return result;
																				} else {
																					if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
																						g_string_append (sql, "SparqlCartesianDistance(");
																						tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						g_string_append (sql, ", ");
																						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						g_string_append (sql, ", ");
																						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						g_string_append (sql, ", ");
																						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						g_string_append (sql, ")");
																						result = TRACKER_PROPERTY_TYPE_DOUBLE;
																						return result;
																					} else {
																						if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
																							g_string_append (sql, "SparqlHaversineDistance(");
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ")");
																							result = TRACKER_PROPERTY_TYPE_DOUBLE;
																							return result;
																						} else {
																							if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
																								g_string_append (sql, "COALESCE(");
																								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								g_string_append (sql, ", ");
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								while (TRUE) {
																									gboolean _tmp34_;
																									_tmp34_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									if (!_tmp34_) {
																										break;
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																								}
																								g_string_append (sql, ")");
																								result = TRACKER_PROPERTY_TYPE_STRING;
																								return result;
																							} else {
																								if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
																									g_string_append (sql, "SparqlUriIsParent(");
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ")");
																									result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																									return result;
																								} else {
																									if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
																										g_string_append (sql, "SparqlUriIsDescendant(");
																										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ")");
																										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																										return result;
																									} else {
																										if (_vala_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
																											g_string_append (sql, "SparqlStringFromFilename(");
																											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											g_string_append (sql, ")");
																											result = TRACKER_PROPERTY_TYPE_STRING;
																											return result;
																										} else {
																											TrackerProperty* prop;
																											prop = _g_object_ref0 (tracker_ontologies_get_property_by_uri (uri));
																											if (prop == NULL) {
																												_inner_error_ = tracker_sparql_expression_get_error (self, "Unknown function");
																												{
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														_g_object_unref0 (prop);
																														return 0;
																													} else {
																														_g_object_unref0 (prop);
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																											}
																											if (tracker_property_get_multiple_values (prop)) {
																												glong begin;
																												g_string_append (sql, "(SELECT GROUP_CONCAT(");
																												begin = (glong) sql->len;
																												g_string_append_printf (sql, "\"%s\"", tracker_property_get_name (prop));
																												tracker_sparql_expression_convert_expression_to_string (sql, tracker_property_get_data_type (prop), begin);
																												g_string_append_printf (sql, ",',') FROM \"%s\" WHERE ID = ", tracker_property_get_table_name (prop));
																												tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														_g_object_unref0 (prop);
																														return 0;
																													} else {
																														_g_object_unref0 (prop);
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												g_string_append (sql, ")");
																												result = TRACKER_PROPERTY_TYPE_STRING;
																												_g_object_unref0 (prop);
																												return result;
																											} else {
																												g_string_append_printf (sql, "(SELECT \"%s\" FROM \"%s\" WHERE ID = ", tracker_property_get_name (prop), tracker_property_get_table_name (prop));
																												tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														_g_object_unref0 (prop);
																														return 0;
																													} else {
																														_g_object_unref0 (prop);
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												g_string_append (sql, ")");
																												result = tracker_property_get_data_type (prop);
																												_g_object_unref0 (prop);
																												return result;
																											}
																											_g_object_unref0 (prop);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	char* type_iri;
	TrackerPropertyType type = 0;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_inner_error_ = NULL;
	type_iri = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type_iri);
			return 0;
		} else {
			_g_free0 (type_iri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		char* _tmp1_;
		type_iri = (_tmp1_ = tracker_sparql_expression_get_last_string (self, 1), _g_free0 (type_iri), _tmp1_);
	} else {
		gboolean _tmp2_;
		_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (type_iri);
				return 0;
			} else {
				_g_free0 (type_iri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			char* ns;
			char* _tmp4_;
			char* _tmp3_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			ns = tracker_sparql_expression_get_last_string (self, 0);
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp6_ = (_tmp5_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp4_ = string_substring (_tmp3_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type_iri = (_tmp7_ = _tmp6_, _g_free0 (type_iri), _tmp7_);
			_g_free0 (ns);
		} else {
			char* _tmp9_;
			char* _tmp8_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp9_ = string_substring (_tmp8_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type_iri = (_tmp12_ = _tmp11_, _g_free0 (type_iri), _tmp12_);
		}
	}
	if (_vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		if (_vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			_tmp18_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = _vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
		}
		if (_tmp13_) {
			type = TRACKER_PROPERTY_TYPE_INTEGER;
		} else {
			if (_vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
			} else {
				if (_vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
					type = TRACKER_PROPERTY_TYPE_DATE;
				} else {
					if (_vala_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
						type = TRACKER_PROPERTY_TYPE_DATETIME;
					} else {
						type = TRACKER_PROPERTY_TYPE_STRING;
					}
				}
			}
		}
	}
	result = type;
	_g_free0 (type_iri);
	return result;
}


char* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	tracker_sparql_expression_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	switch (tracker_sparql_expression_last (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		{
			GString* sb;
			char* s;
			const char* p;
			const char* end;
			gboolean _tmp0_;
			sb = g_string_new ("");
			s = tracker_sparql_expression_get_last_string (self, 1);
			p = s;
			end = p + strlen (s);
			while (TRUE) {
				const char* q;
				if (!(((glong) p) < ((glong) end))) {
					break;
				}
				q = strchr (p, (gint) '\\');
				if (q == NULL) {
					g_string_append_len (sb, p, (gssize) ((glong) (end - p)));
					p = end;
				} else {
					g_string_append_len (sb, p, (gssize) ((glong) (q - p)));
					p = q + 1;
					switch (((gchar*) p)[0]) {
						case '\'':
						case '"':
						case '\\':
						{
							g_string_append_c (sb, ((gchar*) p)[0]);
							break;
						}
						case 'b':
						{
							g_string_append_c (sb, '\b');
							break;
						}
						case 'f':
						{
							g_string_append_c (sb, '\f');
							break;
						}
						case 'n':
						{
							g_string_append_c (sb, '\n');
							break;
						}
						case 'r':
						{
							g_string_append_c (sb, '\r');
							break;
						}
						case 't':
						{
							g_string_append_c (sb, '\t');
							break;
						}
					}
					p++;
				}
			}
			_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (s);
					_g_string_free0 (sb);
					return NULL;
				} else {
					_g_free0 (s);
					_g_string_free0 (sb);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp0_) {
				TrackerPropertyType parsed_type;
				parsed_type = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (s);
						_g_string_free0 (sb);
						return NULL;
					} else {
						_g_free0 (s);
						_g_string_free0 (sb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((type) == NULL) {
				} else {
					*type = parsed_type;
				}
			}
			result = g_strdup (sb->str);
			_g_free0 (s);
			_g_string_free0 (sb);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			char* _result_;
			gboolean _tmp1_;
			_result_ = tracker_sparql_expression_get_last_string (self, 3);
			_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp1_) {
				TrackerPropertyType parsed_type;
				parsed_type = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((type) == NULL) {
				} else {
					*type = parsed_type;
				}
			}
			result = _result_;
			return result;
		}
		default:
		{
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected string literal");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const char* uri, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		TrackerPropertyType _result_;
		_result_ = tracker_sparql_expression_translate_function (self, sql, uri, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _result_;
		return result;
	} else {
		TrackerSparqlLiteralBinding* binding;
		char* _tmp1_;
		g_string_append (sql, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
		binding = tracker_sparql_literal_binding_new ();
		binding->literal = (_tmp1_ = g_strdup (uri), _g_free0 (binding->literal), _tmp1_);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
		_g_object_unref0 (binding);
		return result;
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType type = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	switch (tracker_sparql_expression_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
		{
			TrackerPropertyType _tmp0_;
			_tmp0_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp0_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		{
			char* _tmp1_;
			TrackerPropertyType _tmp2_;
			TrackerPropertyType _tmp3_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp3_ = (_tmp2_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp1_ = tracker_sparql_expression_get_last_string (self, 1), &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp3_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
		{
			TrackerSparqlLiteralBinding* binding;
			char* _tmp4_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_literal_binding_new ();
			binding->literal = (_tmp4_ = tracker_sparql_expression_get_last_string (self, 0), _g_free0 (binding->literal), _tmp4_);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
		{
			TrackerSparqlLiteralBinding* binding;
			char* _tmp5_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_literal_binding_new ();
			binding->literal = (_tmp5_ = g_strdup ("1"), _g_free0 (binding->literal), _tmp5_);
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
		{
			TrackerSparqlLiteralBinding* binding;
			char* _tmp6_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_literal_binding_new ();
			binding->literal = (_tmp6_ = g_strdup ("0"), _g_free0 (binding->literal), _tmp6_);
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			TrackerSparqlLiteralBinding* binding;
			char* _tmp7_;
			char* _tmp8_;
			binding = tracker_sparql_literal_binding_new ();
			_tmp7_ = tracker_sparql_expression_parse_string_literal (self, &type, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return 0;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			binding->literal = (_tmp8_ = _tmp7_, _g_free0 (binding->literal), _tmp8_);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			switch (type) {
				case TRACKER_PROPERTY_TYPE_INTEGER:
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
				{
					g_string_append (sql, "?");
					((TrackerSparqlDataBinding*) binding)->data_type = type;
					result = type;
					_g_object_unref0 (binding);
					return result;
				}
				default:
				{
					g_string_append (sql, "?");
					result = TRACKER_PROPERTY_TYPE_STRING;
					_g_object_unref0 (binding);
					return result;
				}
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
		{
			TrackerSparqlLiteralBinding* binding;
			char* _tmp9_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			binding = tracker_sparql_literal_binding_new ();
			binding->literal = (_tmp9_ = tracker_sparql_expression_get_last_string (self, 0), _g_free0 (binding->literal), _tmp9_);
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _g_object_ref0 (binding));
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
		{
			char* _tmp10_;
			char* _tmp11_;
			char* variable_name;
			TrackerSparqlVariable* variable;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			variable_name = (_tmp11_ = string_substring (_tmp10_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), _g_free0 (_tmp10_), _tmp11_);
			variable = _g_object_ref0 (tracker_sparql_context_get_variable (tracker_sparql_expression_get_context (self), variable_name));
			g_string_append (sql, tracker_sparql_variable_get_sql_expression (variable));
			if (variable->binding == NULL) {
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			} else {
				result = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		{
			tracker_sparql_expression_translate_str (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "''");
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		{
			tracker_sparql_expression_translate_datatype (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		{
			tracker_sparql_expression_translate_bound_call (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(");
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " = ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		{
			tracker_sparql_expression_translate_isuri (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_expression_translate_regex (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			tracker_sparql_expression_translate_exists (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "COUNT(");
			tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
		{
			TrackerPropertyType _tmp12_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "SUM(");
			_tmp12_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp12_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
		{
			TrackerPropertyType _tmp13_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "AVG(");
			_tmp13_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp13_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
		{
			TrackerPropertyType _tmp14_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MIN(");
			_tmp14_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp14_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
		{
			TrackerPropertyType _tmp15_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MAX(");
			_tmp15_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp15_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
		{
			char* _tmp16_;
			char* _tmp18_;
			char* _tmp17_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "GROUP_CONCAT(");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ", ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp16_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, _tmp18_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp17_ = _tmp16_));
			_g_free0 (_tmp18_);
			_g_free0 (_tmp17_);
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		{
			char* ns;
			char* _tmp20_;
			char* _tmp19_;
			char* _tmp21_;
			char* uri;
			TrackerPropertyType _tmp22_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			ns = tracker_sparql_expression_get_last_string (self, 0);
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			uri = (_tmp21_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp20_ = string_substring (_tmp19_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp20_), _g_free0 (_tmp19_), _tmp21_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp22_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (uri);
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp22_;
			_g_free0 (uri);
			_g_free0 (ns);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			char* _tmp24_;
			char* _tmp23_;
			char* _tmp25_;
			char* uri;
			TrackerPropertyType _tmp26_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			uri = (_tmp25_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp24_ = string_substring (_tmp23_ = tracker_sparql_expression_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _tmp25_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp26_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					return 0;
				} else {
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp26_;
			_g_free0 (uri);
			return result;
		}
		default:
		{
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected primary expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	gboolean _tmp0_;
	TrackerPropertyType _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		TrackerPropertyType optype;
		g_string_append (sql, "NOT (");
		optype = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
		return result;
	} else {
		gboolean _tmp1_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp1_) {
			TrackerPropertyType _tmp2_;
			_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		} else {
			gboolean _tmp3_;
			_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp3_) {
				TrackerPropertyType optype;
				g_string_append (sql, "-(");
				optype = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
				result = optype;
				return result;
			}
		}
	}
	_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp4_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	optype = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp0_) {
			TrackerPropertyType _tmp1_;
			if (!tracker_sparql_expression_maybe_numeric (self, optype)) {
				_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				{
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " * ");
			_tmp1_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp1_)) {
				_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				{
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp2_) {
				TrackerPropertyType _tmp3_;
				if (!tracker_sparql_expression_maybe_numeric (self, optype)) {
					_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " / ");
				_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp3_)) {
					_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	optype = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp0_) {
			TrackerPropertyType _tmp1_;
			if (!tracker_sparql_expression_maybe_numeric (self, optype)) {
				_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				{
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " + ");
			_tmp1_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp1_)) {
				_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				{
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp2_;
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp2_) {
				TrackerPropertyType _tmp3_;
				if (!tracker_sparql_expression_maybe_numeric (self, optype)) {
					_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " - ");
				_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp3_)) {
					_inner_error_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_translate_additive_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const char* operator, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType op2type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (operator != NULL, 0);
	_inner_error_ = NULL;
	g_string_insert (sql, (gssize) begin, "(");
	g_string_append (sql, operator);
	op2type = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, ")");
	if (op1type == TRACKER_PROPERTY_TYPE_DATETIME) {
		_tmp1_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
			_tmp2_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		if (g_list_length (self->priv->query->bindings) == (n_bindings + 1)) {
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) g_list_last (self->priv->query->bindings)->data))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
		}
	}
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	glong begin;
	guint n_bindings;
	TrackerPropertyType optype;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	n_bindings = g_list_length (self->priv->query->bindings);
	optype = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		TrackerPropertyType _tmp1_;
		_tmp1_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " >= ", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_;
		_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			TrackerPropertyType _tmp3_;
			_tmp3_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " = ", &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp3_;
			return result;
		} else {
			gboolean _tmp4_;
			_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp4_) {
				TrackerPropertyType _tmp5_;
				_tmp5_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <> ", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				result = _tmp5_;
				return result;
			} else {
				gboolean _tmp6_;
				_tmp6_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (_tmp6_) {
					TrackerPropertyType _tmp7_;
					_tmp7_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " < ", &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					result = _tmp7_;
					return result;
				} else {
					gboolean _tmp8_;
					_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					if (_tmp8_) {
						TrackerPropertyType _tmp9_;
						_tmp9_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <= ", &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						result = _tmp9_;
						return result;
					} else {
						gboolean _tmp10_;
						_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						if (_tmp10_) {
							TrackerPropertyType _tmp11_;
							_tmp11_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " > ", &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							result = _tmp11_;
							return result;
						}
					}
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_translate_relational_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	optype = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		TrackerPropertyType _tmp1_;
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp0_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " AND ");
		_tmp1_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp1_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	glong begin;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	begin = (glong) sql->len;
	optype = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		TrackerPropertyType _tmp1_;
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp0_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " OR ");
		_tmp1_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp1_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			_inner_error_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			{
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_expression_translate_conditional_or_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp0_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlSelectContext* select_context;
		g_string_append (sql, "(");
		select_context = tracker_sparql_pattern_translate_select (tracker_sparql_expression_get_pattern (self), sql, TRUE, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (select_context);
				return 0;
			} else {
				_tracker_sparql_context_unref0 (select_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = select_context->type;
		_tracker_sparql_context_unref0 (select_context);
		return result;
	}
	optype = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	gboolean _tmp0_;
	TrackerPropertyType optype;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp0_) {
		g_string_append (sql, "DISTINCT ");
	}
	optype = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	switch (tracker_sparql_expression_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			TrackerPropertyType _tmp0_;
			_tmp0_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp0_;
			return result;
		}
		default:
		{
			TrackerPropertyType _tmp1_;
			_tmp1_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp1_;
			return result;
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->pattern;
	return result;
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_expression_get_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (obj);
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




