/* busy-handling-test.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from busy-handling-test.vala, do not modify */

/*
 * Copyright (C) 2008, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/* To run this test:*/
/* -===-------------*/
/**/
/* tracker-control -k*/
/* rm ~/.cache/tracker/meta.db*/
/* export TRACKER_DEBUG_MAKE_JOURNAL_READER_GO_VERY_SLOW=yes*/
/* tracker-store*/
/* ./busy-handling-test*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ResourcesDBusProxy ResourcesDBusProxy;
typedef DBusGProxyClass ResourcesDBusProxyClass;
typedef struct _ResourcesDBusProxySparqlQueryData ResourcesDBusProxySparqlQueryData;

#define TYPE_STATUS (status_get_type ())
#define STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS, Status))
#define IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS))
#define STATUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STATUS, StatusIface))

typedef struct _Status Status;
typedef struct _StatusIface StatusIface;
typedef struct _StatusDBusProxy StatusDBusProxy;
typedef DBusGProxyClass StatusDBusProxyClass;

#define TYPE_TEST_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_APP, TestAppClass))
#define IS_TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_APP))
#define IS_TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TestAppDoQueryTestsAsyncData TestAppDoQueryTestsAsyncData;
typedef struct _TestAppDoAsyncQueryTestsData TestAppDoAsyncQueryTestsData;
typedef struct _TestAppJumperAsyncData TestAppJumperAsyncData;
typedef struct _ParamSpecTestApp ParamSpecTestApp;
#define _test_app_unref0(var) ((var == NULL) ? NULL : (var = (test_app_unref (var), NULL)))

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (Resources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _ResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _ResourcesDBusProxySparqlQueryData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _StatusIface {
	GTypeInterface parent_iface;
	double (*get_progress) (Status* self, GError** error);
	char* (*get_status) (Status* self, GError** error);
};

struct _StatusDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TestApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GTypeClass parent_class;
	void (*finalize) (TestApp *self);
};

struct _TestAppPrivate {
	gint res;
	gint users;
	GMainLoop* loop;
	gboolean initialized;
	gboolean ready;
};

struct _TestAppDoQueryTestsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
	char* test_name;
	gint cnt;
	char** results;
	gint _tmp0_;
	gint _tmp1_;
	gint results_length1;
	gint results_length2;
	char** _tmp2_;
	char** res_collection;
	int res_collection_length1;
	int res_it;
	char* res;
	GError * e;
	GError * _inner_error_;
};

struct _TestAppDoAsyncQueryTestsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
};

struct _TestAppJumperAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TestApp* self;
};

struct _ParamSpecTestApp {
	GParamSpec parent_instance;
};


static DBusGConnection* test_app_connection;
static DBusGConnection* test_app_connection = NULL;
static Resources* test_app_resources_object;
static Resources* test_app_resources_object = NULL;
static Status* test_app_status_object;
static Status* test_app_status_object = NULL;
static gpointer test_app_parent_class = NULL;

Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType resources_get_type (void) G_GNUC_CONST;
void resources_sparql_query (Resources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_sparql_query (Resources* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType resources_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static void resources_dbus_proxy_sparql_query_async (Resources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void resources_dbus_proxy_sparql_query_ready (DBusPendingCall* pending, void* user_data);
static char** resources_dbus_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface);
static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
Status* status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType status_get_type (void) G_GNUC_CONST;
double status_get_progress (Status* self, GError** error);
char* status_get_status (Status* self, GError** error);
void status_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _status_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_status_introspect (Status* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_status_property_get_all (Status* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_status_get_progress (Status* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_status_get_status (Status* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_status_progress (GObject* _sender, const char* status, double progress, DBusConnection* _connection);
GType status_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_status_progress (Status* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	STATUS_DBUS_PROXY_DUMMY_PROPERTY
};
static double status_dbus_proxy_get_progress (Status* self, GError** error);
static char* status_dbus_proxy_get_status (Status* self, GError** error);
static void status_dbus_proxy_status__interface_init (StatusIface* iface);
static void status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer test_app_ref (gpointer instance);
void test_app_unref (gpointer instance);
GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_app (GValue* value, gpointer v_object);
void value_take_test_app (GValue* value, gpointer v_object);
gpointer value_get_test_app (const GValue* value);
GType test_app_get_type (void) G_GNUC_CONST;
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
static void test_app_on_status_cb (TestApp* self, const char* status, double progress);
static void _test_app_on_status_cb_status_progress (Status* _sender, const char* status, double progress, gpointer self);
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_do_query_tests_async_data_free (gpointer _data);
static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_do_query_tests_async (TestApp* self, const char* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* data);
static void test_app_check_shutdown (TestApp* self);
static void test_app_do_async_query_tests_data_free (gpointer _data);
static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* data);
static void test_app_jumper_async_data_free (gpointer _data);
static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_);
static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* data);
static gboolean test_app_test_ready (TestApp* self);
static gboolean _test_app_test_ready_gsource_func (gpointer self);
static gboolean test_app_in_mainloop (TestApp* self);
static gboolean _test_app_in_mainloop_gsource_func (gpointer self);
gint test_app_run (TestApp* self);
static void test_app_finalize (TestApp* obj);
gint _vala_main (char** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _resources_dbus_path_vtable = {_resources_dbus_unregister, resources_dbus_message};
static const _DBusObjectVTable _resources_dbus_vtable = {resources_dbus_register_object};
static const DBusObjectPathVTable _status_dbus_path_vtable = {_status_dbus_unregister, status_dbus_message};
static const _DBusObjectVTable _status_dbus_vtable = {status_dbus_register_object};

static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void resources_sparql_query (Resources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RESOURCES_GET_INTERFACE (self)->sparql_query (self, query, _callback_, _user_data_);
}


char** resources_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return RESOURCES_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_sparql_query (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp1_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	resources_sparql_query (self, query, (GAsyncReadyCallback) _dbus_resources_sparql_query_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = resources_sparql_query_finish ((Resources*) source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		DBusMessageIter _tmp5_;
		int _tmp6_;
		dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_ARRAY, "s", &_tmp5_);
		for (_tmp6_ = 0; _tmp6_ < result_length2; _tmp6_++) {
			const char* _tmp7_;
			_tmp7_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp5_, DBUS_TYPE_STRING, &_tmp7_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&_tmp3_, &_tmp5_);
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_resources_sparql_query (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_resources_dbus_vtable));
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &resources_dbus_proxy_get_type);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesDBusProxy, resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_dbus_proxy_resources__interface_init) );
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Resources* self;
	self = g_object_new (resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((ResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->dispose (self);
}


static void resources_dbus_proxy_class_init (ResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = resources_dbus_proxy_set_property;
}


static void resources_dbus_proxy_init (ResourcesDBusProxy* self) {
}


static void resources_dbus_proxy_sparql_query_async (Resources* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp8_;
	ResourcesDBusProxySparqlQueryData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp8_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp8_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, 1215752191);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (ResourcesDBusProxySparqlQueryData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, resources_dbus_proxy_sparql_query_ready, _data_, NULL);
}


static void resources_dbus_proxy_sparql_query_ready (DBusPendingCall* pending, void* user_data) {
	ResourcesDBusProxySparqlQueryData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (ResourcesDBusProxySparqlQueryData, _data_);
	dbus_pending_call_unref (pending);
}


static char** resources_dbus_proxy_sparql_query_finish (Resources* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	ResourcesDBusProxySparqlQueryData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp15_;
	int _tmp15__length;
	int _tmp15__size;
	int _tmp15__length1;
	DBusMessageIter _tmp16_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp13_;
			_edomain = DBUS_GERROR;
			_tmp13_ = _dbus_error.name + 27;
			if (strcmp (_tmp13_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp13_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp13_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp13_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp13_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp13_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp13_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp13_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp13_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp13_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp13_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp13_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp13_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp13_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp13_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp13_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp13_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp13_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp13_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp13_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp13_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp13_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp13_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp13_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp13_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp13_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp13_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp13_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp13_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp15_ = g_new (char*, 5);
	_tmp15__length = 0;
	_tmp15__size = 4;
	_tmp15__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp16_);
	for (; dbus_message_iter_get_arg_type (&_tmp16_); _tmp15__length1++) {
		int _tmp15__length2;
		DBusMessageIter _tmp17_;
		_tmp15__length2 = 0;
		dbus_message_iter_recurse (&_tmp16_, &_tmp17_);
		for (; dbus_message_iter_get_arg_type (&_tmp17_); _tmp15__length2++) {
			const char* _tmp18_;
			if (_tmp15__size == _tmp15__length) {
				_tmp15__size = 2 * _tmp15__size;
				_tmp15_ = g_renew (char*, _tmp15_, _tmp15__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp17_, &_tmp18_);
			dbus_message_iter_next (&_tmp17_);
			_tmp15_[_tmp15__length++] = g_strdup (_tmp18_);
		}
		_result_length2 = _tmp15__length2;
		dbus_message_iter_next (&_tmp16_);
	}
	_result_length1 = _tmp15__length1;
	_tmp15_[_tmp15__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp15_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface) {
	iface->sparql_query = resources_dbus_proxy_sparql_query_async;
	iface->sparql_query_finish = resources_dbus_proxy_sparql_query_finish;
}


static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


double status_get_progress (Status* self, GError** error) {
	return STATUS_GET_INTERFACE (self)->get_progress (self, error);
}


char* status_get_status (Status* self, GError** error) {
	return STATUS_GET_INTERFACE (self)->get_status (self, error);
}


void _status_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_status_introspect (Status* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Status\">\n  <method name=\"GetProgress\">\n    <arg name=\"result\" type=\"d\" direction=\"out\"/>\n  </method>\n  <method name=\"GetStatus\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <signal name=\"Progress\">\n    <arg name=\"status\" type=\"s\"/>\n    <arg name=\"progress\" type=\"d\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_status_property_get_all (Status* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp19_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp19_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp19_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Status") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_status_get_progress (Status* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	double result;
	DBusMessage* reply;
	double _tmp20_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = status_get_progress (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp20_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_DOUBLE, &_tmp20_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_status_get_status (Status* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp21_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = status_get_status (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp21_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult status_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_status_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_status_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Status", "GetProgress")) {
		result = _dbus_status_get_progress (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Status", "GetStatus")) {
		result = _dbus_status_get_status (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_status_progress (GObject* _sender, const char* status, double progress, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp22_;
	double _tmp23_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Tracker1.Status", "Progress");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp22_ = status;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp22_);
	_tmp23_ = progress;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_DOUBLE, &_tmp23_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void status_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_status_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "progress", (GCallback) _dbus_status_progress, connection);
}


static void status_base_init (StatusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("progress", TYPE_STATUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_DOUBLE, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_DOUBLE);
		g_type_set_qdata (TYPE_STATUS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_status_dbus_vtable));
	}
}


GType status_get_type (void) {
	static volatile gsize status_type_id__volatile = 0;
	if (g_once_init_enter (&status_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIface), (GBaseInitFunc) status_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType status_type_id;
		status_type_id = g_type_register_static (G_TYPE_INTERFACE, "Status", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (status_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (status_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &status_dbus_proxy_get_type);
		g_once_init_leave (&status_type_id__volatile, status_type_id);
	}
	return status_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StatusDBusProxy, status_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STATUS, status_dbus_proxy_status__interface_init) );
Status* status_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Status* self;
	self = g_object_new (status_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Status", NULL);
	return self;
}


static GObject* status_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (status_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), status_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_status_progress (Status* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* status = NULL;
	const char* _tmp24_;
	double progress = 0.0;
	double _tmp25_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sd")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	status = g_strdup (_tmp24_);
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	progress = _tmp25_;
	g_signal_emit_by_name (self, "progress", status, progress);
	_g_free0 (status);
}


DBusHandlerResult status_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.Tracker1.Status", "Progress")) {
			_dbus_handle_status_progress (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void status_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((StatusDBusProxy*) self)->disposed) {
		return;
	}
	((StatusDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), status_dbus_proxy_filter, self);
	G_OBJECT_CLASS (status_dbus_proxy_parent_class)->dispose (self);
}


static void status_dbus_proxy_class_init (StatusDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = status_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = status_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = status_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = status_dbus_proxy_set_property;
}


static void status_dbus_proxy_init (StatusDBusProxy* self) {
}


static double status_dbus_proxy_get_progress (Status* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	double _result;
	double _tmp26_;
	if (((StatusDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return 0.0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Status", "GetProgress");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp27_;
			_edomain = DBUS_GERROR;
			_tmp27_ = _dbus_error.name + 27;
			if (strcmp (_tmp27_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp27_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp27_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp27_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp27_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp27_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp27_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp27_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp27_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp27_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp27_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp27_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp27_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp27_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp27_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp27_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp27_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp27_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp27_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp27_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp27_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp27_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp27_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp27_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp27_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp27_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp27_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp27_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp27_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp27_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp27_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return 0.0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "d")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "d", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0.0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp26_);
	dbus_message_iter_next (&_iter);
	_result = _tmp26_;
	dbus_message_unref (_reply);
	return _result;
}


static char* status_dbus_proxy_get_status (Status* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp28_;
	if (((StatusDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Status", "GetStatus");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp29_;
			_edomain = DBUS_GERROR;
			_tmp29_ = _dbus_error.name + 27;
			if (strcmp (_tmp29_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp29_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp29_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp29_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp29_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp29_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp29_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp29_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp29_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp29_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp29_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp29_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp29_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp29_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp29_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp29_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp29_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp29_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp29_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp29_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp29_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp29_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp29_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp29_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp29_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp29_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp29_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp29_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp29_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp29_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp29_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp29_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp29_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp28_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp28_);
	dbus_message_unref (_reply);
	return _result;
}


static void status_dbus_proxy_status__interface_init (StatusIface* iface) {
	iface->get_progress = status_dbus_proxy_get_progress;
	iface->get_status = status_dbus_proxy_get_status;
}


static void status_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void status_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _test_app_on_status_cb_status_progress (Status* _sender, const char* status, double progress, gpointer self) {
	test_app_on_status_cb (self, status, progress);
}


TestApp* test_app_construct (GType object_type) {
	GError * _inner_error_;
	TestApp* self;
	_inner_error_ = NULL;
	self = (TestApp*) g_type_create_instance (object_type);
	g_return_val_if_fail (!self->priv->initialized, NULL);
	{
		double progress = 0.0;
		char* status;
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		Resources* _tmp2_;
		Status* _tmp3_;
		double _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		gboolean _tmp7_ = FALSE;
		status = NULL;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (status);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			_g_free0 (status);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		test_app_connection = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (test_app_connection), _tmp1_);
		test_app_resources_object = (_tmp2_ = resources_dbus_proxy_new (test_app_connection, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources"), _g_object_unref0 (test_app_resources_object), _tmp2_);
		test_app_status_object = (_tmp3_ = status_dbus_proxy_new (test_app_connection, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Status"), _g_object_unref0 (test_app_status_object), _tmp3_);
		g_signal_connect (test_app_status_object, "progress", (GCallback) _test_app_on_status_cb_status_progress, self);
		_tmp4_ = status_get_progress (test_app_status_object, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (status);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			_g_free0 (status);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		progress = _tmp4_;
		_tmp5_ = status_get_status (test_app_status_object, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (status);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			_g_free0 (status);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		status = (_tmp6_ = _tmp5_, _g_free0 (status), _tmp6_);
		if (progress == 1.0) {
			_tmp7_ = _vala_strcmp0 (status, "Idle") == 0;
		} else {
			_tmp7_ = FALSE;
		}
		self->priv->ready = _tmp7_;
		_g_free0 (status);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("busy-handling-test.vala:73: Could not connect to D-Bus service: %s", e->message);
			self->priv->initialized = FALSE;
			self->priv->res = -1;
			_g_error_free0 (e);
			return self;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->initialized = TRUE;
	return self;
}


TestApp* test_app_new (void) {
	return test_app_construct (TYPE_TEST_APP);
}


static void test_app_on_status_cb (TestApp* self, const char* status, double progress) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (status != NULL);
	g_print ("%s: %f\n", status, progress);
	if (progress == 1.0) {
		self->priv->ready = TRUE;
	}
}


static void test_app_do_query_tests_async_data_free (gpointer _data) {
	TestAppDoQueryTestsAsyncData* data;
	data = _data;
	_g_free0 (data->test_name);
	test_app_unref (data->self);
	g_slice_free (TestAppDoQueryTestsAsyncData, data);
}


static void test_app_do_query_tests_async (TestApp* self, const char* test_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppDoQueryTestsAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, test_app_do_query_tests_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_query_tests_async_data_free);
	_data_->self = test_app_ref (self);
	_data_->test_name = g_strdup (test_name);
	test_app_do_query_tests_async_co (_data_);
}


static void test_app_do_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoQueryTestsAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_do_query_tests_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoQueryTestsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	test_app_do_query_tests_async_co (data);
}


static gboolean test_app_do_query_tests_async_co (TestAppDoQueryTestsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			data->cnt = 0;
			data->_state_ = 1;
			resources_sparql_query (test_app_resources_object, "SELECT ?u { ?u a rdfs:Resource }", test_app_do_query_tests_async_ready, data);
			return FALSE;
			_state_1:
			data->results = (data->_tmp2_ = resources_sparql_query_finish (test_app_resources_object, data->_res_, &data->_tmp0_, &data->_tmp1_, &data->_inner_error_), data->results_length1 = data->_tmp0_, data->results_length2 = data->_tmp1_, data->_tmp2_);
			if (data->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			{
				data->res_collection = data->results;
				data->res_collection_length1 = data->results_length1 * data->results_length2;
				for (data->res_it = 0; data->res_it < (data->results_length1 * data->results_length2); data->res_it = data->res_it + 1) {
					data->res = g_strdup (data->res_collection[data->res_it]);
					{
						data->cnt++;
						_g_free0 (data->res);
					}
				}
			}
			g_print ("%s: Saw %d strings in result\n", data->test_name, data->cnt);
			data->results = (_vala_array_free (data->results, data->results_length1 * data->results_length2, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			{
				g_print ("Fail: %s\n", data->e->message);
				data->self->priv->res = -1;
				_g_error_free0 (data->e);
			}
		}
		__finally1:
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void test_app_check_shutdown (TestApp* self) {
	g_return_if_fail (self != NULL);
	self->priv->users--;
	if (self->priv->users == 0) {
		g_print ("Async tests done, now I can quit the mainloop\n");
		g_main_loop_quit (self->priv->loop);
	}
}


static void test_app_do_async_query_tests_data_free (gpointer _data) {
	TestAppDoAsyncQueryTestsData* data;
	data = _data;
	test_app_unref (data->self);
	g_slice_free (TestAppDoAsyncQueryTestsData, data);
}


static void test_app_do_async_query_tests (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* _data_;
	_data_ = g_slice_new0 (TestAppDoAsyncQueryTestsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, test_app_do_async_query_tests);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_do_async_query_tests_data_free);
	_data_->self = test_app_ref (self);
	test_app_do_async_query_tests_co (_data_);
}


static void test_app_do_async_query_tests_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppDoAsyncQueryTestsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_do_async_query_tests_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppDoAsyncQueryTestsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	test_app_do_async_query_tests_co (data);
}


static gboolean test_app_do_async_query_tests_co (TestAppDoAsyncQueryTestsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_print ("Test 1: Just launch the query and let it wait\n" \
"Test 1: query launches immediately\n");
		data->self->priv->users++;
		data->_state_ = 2;
		test_app_do_query_tests_async (data->self, "Test 1", test_app_do_async_query_tests_ready, data);
		return FALSE;
		_state_2:
		test_app_do_query_tests_finish (data->self, data->_res_);
		test_app_check_shutdown (data->self);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void test_app_jumper_async_data_free (gpointer _data) {
	TestAppJumperAsyncData* data;
	data = _data;
	test_app_unref (data->self);
	g_slice_free (TestAppJumperAsyncData, data);
}


static void test_app_jumper_async (TestApp* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TestAppJumperAsyncData* _data_;
	_data_ = g_slice_new0 (TestAppJumperAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, test_app_jumper_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, test_app_jumper_async_data_free);
	_data_->self = test_app_ref (self);
	test_app_jumper_async_co (_data_);
}


static void test_app_jumper_finish (TestApp* self, GAsyncResult* _res_) {
	TestAppJumperAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void test_app_jumper_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TestAppJumperAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	test_app_jumper_async_co (data);
}


static gboolean test_app_jumper_async_co (TestAppJumperAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 3;
		test_app_do_query_tests_async (data->self, "Test 2", test_app_jumper_async_ready, data);
		return FALSE;
		_state_3:
		test_app_do_query_tests_finish (data->self, data->_res_);
		test_app_check_shutdown (data->self);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static gboolean test_app_test_ready (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->ready) {
		g_print ("Test 2: query launches now\n");
		test_app_jumper_async (self, NULL, NULL);
	}
	result = !self->priv->ready;
	return result;
}


static gboolean _test_app_test_ready_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_test_ready (self);
	return result;
}


static gboolean test_app_in_mainloop (TestApp* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	test_app_do_async_query_tests (self, NULL, NULL);
	g_print ("Test 2: Wait for the status signal to indicate readyness\n");
	self->priv->users++;
	if (!self->priv->ready) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1, _test_app_test_ready_gsource_func, test_app_ref (self), test_app_unref);
	} else {
		test_app_test_ready (self);
	}
	result = FALSE;
	return result;
}


static gboolean _test_app_in_mainloop_gsource_func (gpointer self) {
	gboolean result;
	result = test_app_in_mainloop (self);
	return result;
}


gint test_app_run (TestApp* self) {
	gint result = 0;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->loop = (_tmp0_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->loop), _tmp0_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _test_app_in_mainloop_gsource_func, test_app_ref (self), test_app_unref);
	g_main_loop_run (self->priv->loop);
	result = self->priv->res;
	return result;
}


static void value_test_app_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_app_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_app_unref (value->data[0].v_pointer);
	}
}


static void value_test_app_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_app_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_app_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestApp* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_app_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestApp** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_app_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestApp* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_APP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_app (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_app_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


void value_take_test_app (GValue* value, gpointer v_object) {
	TestApp* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_APP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_APP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_app_unref (old);
	}
}


static void test_app_class_init (TestAppClass * klass) {
	test_app_parent_class = g_type_class_peek_parent (klass);
	TEST_APP_CLASS (klass)->finalize = test_app_finalize;
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
}


static void test_app_instance_init (TestApp * self) {
	self->priv = TEST_APP_GET_PRIVATE (self);
	self->priv->res = -1;
	self->priv->users = 0;
	self->priv->initialized = FALSE;
	self->priv->ready = FALSE;
	self->ref_count = 1;
}


static void test_app_finalize (TestApp* obj) {
	TestApp * self;
	self = TEST_APP (obj);
	_g_main_loop_unref0 (self->priv->loop);
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_app_init, value_test_app_free_value, value_test_app_copy_value, value_test_app_peek_pointer, "p", value_test_app_collect_value, "p", value_test_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_app_type_id;
		test_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


gpointer test_app_ref (gpointer instance) {
	TestApp* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_app_unref (gpointer instance) {
	TestApp* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_APP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	TestApp* app;
	app = test_app_new ();
	result = test_app_run (app);
	_test_app_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__STRING_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_DOUBLE) (gpointer data1, const char* arg_1, double arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_double (param_values + 2), data2);
}



