/* tracker-turtle-reader.c generated by valac 0.11.1, the Vala compiler
 * generated from tracker-turtle-reader.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-common/tracker-date-time.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>


#define TRACKER_TYPE_TURTLE_READER (tracker_turtle_reader_get_type ())
#define TRACKER_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReader))
#define TRACKER_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))
#define TRACKER_IS_TURTLE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_IS_TURTLE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_TURTLE_READER))
#define TRACKER_TURTLE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderClass))

typedef struct _TrackerTurtleReader TrackerTurtleReader;
typedef struct _TrackerTurtleReaderClass TrackerTurtleReaderClass;
typedef struct _TrackerTurtleReaderPrivate TrackerTurtleReaderPrivate;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_TURTLE_READER_TYPE_TOKEN_INFO (tracker_turtle_reader_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerTurtleReaderTokenInfo TrackerTurtleReaderTokenInfo;

#define TRACKER_TURTLE_READER_TYPE_STATE (tracker_turtle_reader_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TrackerTurtleReader {
	GObject parent_instance;
	TrackerTurtleReaderPrivate * priv;
};

struct _TrackerTurtleReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerTurtleReaderTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

typedef enum  {
	TRACKER_TURTLE_READER_STATE_INITIAL,
	TRACKER_TURTLE_READER_STATE_BOS,
	TRACKER_TURTLE_READER_STATE_SUBJECT,
	TRACKER_TURTLE_READER_STATE_PREDICATE,
	TRACKER_TURTLE_READER_STATE_OBJECT
} TrackerTurtleReaderState;

struct _TrackerTurtleReaderPrivate {
	TrackerSparqlScanner* scanner;
	TrackerTurtleReaderTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	TrackerTurtleReaderState state;
	gchar* _graph;
	gchar* _subject;
	gchar* _predicate;
	gchar* _object;
	gboolean _object_is_uri;
	GHashTable* prefix_map;
	gchar** subject_stack;
	gint subject_stack_length1;
	gint _subject_stack_size_;
	gchar** predicate_stack;
	gint predicate_stack_length1;
	gint _predicate_stack_size_;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GMappedFile* mapped_file;
};


static gpointer tracker_turtle_reader_parent_class = NULL;

GType tracker_turtle_reader_get_type (void) G_GNUC_CONST;
GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
static GType tracker_turtle_reader_token_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_source_location_copy (const TrackerSourceLocation* self, TrackerSourceLocation* dest);
void tracker_source_location_destroy (TrackerSourceLocation* self);
static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self);
static void tracker_turtle_reader_token_info_copy (const TrackerTurtleReaderTokenInfo* self, TrackerTurtleReaderTokenInfo* dest);
static void tracker_turtle_reader_token_info_destroy (TrackerTurtleReaderTokenInfo* self);
static GType tracker_turtle_reader_state_get_type (void) G_GNUC_UNUSED;
#define TRACKER_TURTLE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_TURTLE_READER, TrackerTurtleReaderPrivate))
enum  {
	TRACKER_TURTLE_READER_DUMMY_PROPERTY,
	TRACKER_TURTLE_READER_GRAPH,
	TRACKER_TURTLE_READER_SUBJECT,
	TRACKER_TURTLE_READER_PREDICATE,
	TRACKER_TURTLE_READER_OBJECT,
	TRACKER_TURTLE_READER_OBJECT_IS_URI
};
static void _vala_TrackerTurtleReaderTokenInfo_array_free (TrackerTurtleReaderTokenInfo* array, gint array_length);
#define TRACKER_TURTLE_READER_BUFFER_SIZE 32
TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error);
TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
void uuid_generate (guchar* uuid);
static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid);
static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self);
static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg);
static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip);
static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error);
gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error);
static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value);
const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
void tracker_turtle_reader_load (const gchar* path, GError** error);
gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self);
const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self);
static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value);
static void tracker_turtle_reader_finalize (GObject* obj);
static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType tracker_turtle_reader_state_get_type (void) {
	static volatile gsize tracker_turtle_reader_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_TURTLE_READER_STATE_INITIAL, "TRACKER_TURTLE_READER_STATE_INITIAL", "initial"}, {TRACKER_TURTLE_READER_STATE_BOS, "TRACKER_TURTLE_READER_STATE_BOS", "bos"}, {TRACKER_TURTLE_READER_STATE_SUBJECT, "TRACKER_TURTLE_READER_STATE_SUBJECT", "subject"}, {TRACKER_TURTLE_READER_STATE_PREDICATE, "TRACKER_TURTLE_READER_STATE_PREDICATE", "predicate"}, {TRACKER_TURTLE_READER_STATE_OBJECT, "TRACKER_TURTLE_READER_STATE_OBJECT", "object"}, {0, NULL, NULL}};
		GType tracker_turtle_reader_state_type_id;
		tracker_turtle_reader_state_type_id = g_enum_register_static ("TrackerTurtleReaderState", values);
		g_once_init_leave (&tracker_turtle_reader_state_type_id__volatile, tracker_turtle_reader_state_type_id);
	}
	return tracker_turtle_reader_state_type_id__volatile;
}


static void _vala_TrackerTurtleReaderTokenInfo_array_free (TrackerTurtleReaderTokenInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			tracker_turtle_reader_token_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


TrackerTurtleReader* tracker_turtle_reader_construct (GType object_type, const gchar* path, GError** error) {
	TrackerTurtleReader * self = NULL;
	GMappedFile* _tmp0_ = NULL;
	GMappedFile* _tmp1_;
	GMappedFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gsize _tmp4_;
	TrackerSparqlScanner* _tmp5_ = NULL;
	TrackerSparqlScanner* _tmp6_;
	guchar* _tmp7_ = NULL;
	guchar* _tmp8_;
	TrackerTurtleReaderTokenInfo* _tmp9_ = NULL;
	TrackerTurtleReaderTokenInfo* _tmp10_;
	GHashTable* _tmp11_ = NULL;
	GHashTable* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (TrackerTurtleReader*) g_object_new (object_type, NULL);
	_tmp0_ = g_mapped_file_new (path, FALSE, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp1_;
	_g_mapped_file_free0 (self->priv->mapped_file);
	self->priv->mapped_file = _tmp2_;
	_tmp3_ = g_mapped_file_get_contents (self->priv->mapped_file);
	_tmp4_ = g_mapped_file_get_length (self->priv->mapped_file);
	_tmp5_ = tracker_sparql_scanner_new (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp6_;
	_tmp7_ = g_new0 (guchar, 16);
	_tmp8_ = _tmp7_;
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	self->priv->base_uuid_length1 = 16;
	self->priv->_base_uuid_size_ = self->priv->base_uuid_length1;
	self->priv->base_uuid = _tmp8_;
	uuid_generate (self->priv->base_uuid);
	_tmp9_ = g_new0 (TrackerTurtleReaderTokenInfo, TRACKER_TURTLE_READER_BUFFER_SIZE);
	_tmp10_ = _tmp9_;
	self->priv->tokens = (_vala_TrackerTurtleReaderTokenInfo_array_free (self->priv->tokens, self->priv->tokens_length1), NULL);
	self->priv->tokens_length1 = TRACKER_TURTLE_READER_BUFFER_SIZE;
	self->priv->_tokens_size_ = self->priv->tokens_length1;
	self->priv->tokens = _tmp10_;
	_tmp11_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	_tmp12_ = _tmp11_;
	_g_hash_table_unref0 (self->priv->prefix_map);
	self->priv->prefix_map = _tmp12_;
	return self;
}


TrackerTurtleReader* tracker_turtle_reader_new (const gchar* path, GError** error) {
	return tracker_turtle_reader_construct (TRACKER_TYPE_TURTLE_READER, path, error);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* tracker_turtle_reader_generate_bnodeid (TrackerTurtleReader* self, const gchar* user_bnodeid) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (user_bnodeid == NULL) {
		gchar* _tmp0_ = NULL;
		self->priv->bnodeid = self->priv->bnodeid + 1;
		_tmp0_ = g_strdup_printf (":%d", self->priv->bnodeid);
		result = _tmp0_;
		return result;
	} else {
		GChecksum* _tmp1_ = NULL;
		GChecksum* checksum;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* sha1;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp1_ = g_checksum_new (G_CHECKSUM_SHA1);
		checksum = _tmp1_;
		g_checksum_update (checksum, self->priv->base_uuid, (gsize) 16);
		g_checksum_update (checksum, (guchar*) user_bnodeid, (gsize) (-1));
		_tmp2_ = g_checksum_get_string (checksum);
		_tmp3_ = g_strdup (_tmp2_);
		sha1 = _tmp3_;
		_tmp4_ = string_offset (sha1, (glong) 8);
		_tmp5_ = string_offset (sha1, (glong) 12);
		_tmp6_ = string_offset (sha1, (glong) 16);
		_tmp7_ = string_offset (sha1, (glong) 20);
		_tmp8_ = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
		result = _tmp8_;
		_g_free0 (sha1);
		_g_checksum_free0 (checksum);
		return result;
	}
}


static inline gboolean tracker_turtle_reader_next_token (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->index = (self->priv->index + 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSourceLocation _tmp0_ = {0};
		TrackerSourceLocation _tmp1_ = {0};
		TrackerSparqlTokenType _tmp2_;
		TrackerSparqlTokenType type;
		TrackerSourceLocation _tmp3_;
		TrackerSourceLocation _tmp4_ = {0};
		TrackerSourceLocation _tmp5_;
		TrackerSourceLocation _tmp6_;
		TrackerSourceLocation _tmp7_ = {0};
		TrackerSourceLocation _tmp8_;
		_tmp2_ = tracker_sparql_scanner_read_token (self->priv->scanner, &_tmp0_, &_tmp1_, &_inner_error_);
		tracker_source_location_destroy (&begin);
		begin = _tmp0_;
		tracker_source_location_destroy (&end);
		end = _tmp1_;
		type = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				tracker_source_location_destroy (&end);
				tracker_source_location_destroy (&begin);
				return FALSE;
			} else {
				tracker_source_location_destroy (&end);
				tracker_source_location_destroy (&begin);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		self->priv->tokens[self->priv->index].type = type;
		_tmp3_ = (tracker_source_location_copy (&begin, &_tmp4_), _tmp4_);
		_tmp5_ = _tmp3_;
		tracker_source_location_destroy (&self->priv->tokens[self->priv->index].begin);
		self->priv->tokens[self->priv->index].begin = _tmp5_;
		_tmp6_ = (tracker_source_location_copy (&end, &_tmp7_), _tmp7_);
		_tmp8_ = _tmp6_;
		tracker_source_location_destroy (&self->priv->tokens[self->priv->index].end);
		self->priv->tokens[self->priv->index].end = _tmp8_;
		self->priv->size = 1;
		tracker_source_location_destroy (&end);
		tracker_source_location_destroy (&begin);
	}
	result = self->priv->tokens[self->priv->index].type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
	return result;
}


static inline TrackerSparqlTokenType tracker_turtle_reader_current (TrackerTurtleReader* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tokens[self->priv->index].type;
	return result;
}


static inline gboolean tracker_turtle_reader_accept (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_turtle_reader_current (self);
	if (_tmp0_ == type) {
		tracker_turtle_reader_next_token (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static GError* tracker_turtle_reader_get_error (TrackerTurtleReader* self, const gchar* msg) {
	GError* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError* _tmp2_ = NULL;
	GError* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d.%d: syntax error, %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp1_);
	result = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	return result;
}


static gboolean tracker_turtle_reader_expect (TrackerTurtleReader* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError* _tmp5_ = NULL;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_turtle_reader_accept (self, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = tracker_sparql_token_type_to_string (type);
	_tmp3_ = g_strdup_printf ("expected %s", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = tracker_turtle_reader_get_error (self, _tmp4_);
	_inner_error_ = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static gchar* tracker_turtle_reader_get_last_string (TrackerTurtleReader* self, gint strip) {
	gchar* result = NULL;
	gint last_index;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + TRACKER_TURTLE_READER_BUFFER_SIZE) - 1) % TRACKER_TURTLE_READER_BUFFER_SIZE;
	_tmp0_ = g_strndup ((const gchar*) (self->priv->tokens[last_index].begin.pos + strip), (self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos) - (2 * strip));
	result = _tmp0_;
	return result;
}


static gchar* tracker_turtle_reader_resolve_prefixed_name (TrackerTurtleReader* self, const gchar* prefix, const gchar* local_name, GError** error) {
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* ns;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->prefix_map, prefix);
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	ns = _tmp1_;
	if (ns == NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GError* _tmp4_ = NULL;
		GError* _tmp5_;
		_tmp2_ = g_strdup_printf ("use of undefined prefix `%s'", prefix);
		_tmp3_ = _tmp2_;
		_tmp4_ = tracker_turtle_reader_get_error (self, _tmp3_);
		_inner_error_ = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ns);
			return NULL;
		} else {
			_g_free0 (ns);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = g_strconcat (ns, local_name, NULL);
	_g_free0 (ns);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean tracker_turtle_reader_next (TrackerTurtleReader* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		switch (self->priv->state) {
			case TRACKER_TURTLE_READER_STATE_INITIAL:
			{
				tracker_turtle_reader_next_token (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
				continue;
			}
			case TRACKER_TURTLE_READER_STATE_BOS:
			{
				gboolean _tmp0_;
				gboolean _tmp1_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp0_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, &_inner_error_);
				_tmp1_ = _tmp0_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp1_) {
					gchar* _tmp2_;
					gchar* ns;
					gboolean _tmp3_;
					gboolean _tmp4_;
					gchar* _tmp7_ = NULL;
					gchar* uri;
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp2_ = g_strdup ("");
					ns = _tmp2_;
					_tmp3_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					_tmp4_ = _tmp3_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp4_) {
						gchar* _tmp5_ = NULL;
						gchar* _tmp6_;
						_tmp5_ = tracker_turtle_reader_get_last_string (self, 0);
						_tmp6_ = _tmp5_;
						_g_free0 (ns);
						ns = _tmp6_;
					}
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_tmp7_ = tracker_turtle_reader_get_last_string (self, 1);
					uri = _tmp7_;
					_tmp8_ = g_strdup (ns);
					_tmp9_ = g_strdup (uri);
					g_hash_table_insert (self->priv->prefix_map, _tmp8_, _tmp9_);
					tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (uri);
							_g_free0 (ns);
							return FALSE;
						} else {
							_g_free0 (uri);
							_g_free0 (ns);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (uri);
					_g_free0 (ns);
					continue;
				} else {
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp10_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ATBASE, &_inner_error_);
					_tmp11_ = _tmp10_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp11_) {
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						continue;
					} else {
						TrackerSparqlTokenType _tmp12_;
						_tmp12_ = tracker_turtle_reader_current (self);
						if (_tmp12_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
							result = FALSE;
							return result;
						}
					}
				}
				_tmp13_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp14_) {
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					_tmp15_ = tracker_turtle_reader_get_last_string (self, 1);
					_tmp16_ = _tmp15_;
					tracker_turtle_reader_set_subject (self, _tmp16_);
					_g_free0 (_tmp16_);
					self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
					continue;
				} else {
					gboolean _tmp17_;
					gboolean _tmp18_;
					_tmp17_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					_tmp18_ = _tmp17_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp18_) {
						gchar* _tmp19_ = NULL;
						gchar* ns;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_;
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp19_ = tracker_turtle_reader_get_last_string (self, 0);
						ns = _tmp19_;
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp20_ = tracker_turtle_reader_get_last_string (self, 0);
						_tmp21_ = _tmp20_;
						_tmp22_ = string_substring (_tmp21_, (glong) 1, (glong) (-1));
						_tmp23_ = _tmp22_;
						_tmp24_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp23_, &_inner_error_);
						_tmp26_ = (_tmp25_ = _tmp24_, _g_free0 (_tmp23_), _g_free0 (_tmp21_), _tmp25_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp27_ = _tmp26_;
						tracker_turtle_reader_set_subject (self, _tmp27_);
						_g_free0 (_tmp27_);
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
						_g_free0 (ns);
						continue;
					} else {
						gboolean _tmp28_;
						gboolean _tmp29_;
						_tmp28_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						_tmp29_ = _tmp28_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp29_) {
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_;
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp30_ = tracker_turtle_reader_get_last_string (self, 0);
							_tmp31_ = _tmp30_;
							_tmp32_ = string_substring (_tmp31_, (glong) 1, (glong) (-1));
							_tmp33_ = _tmp32_;
							_tmp34_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp33_, &_inner_error_);
							_tmp36_ = (_tmp35_ = _tmp34_, _g_free0 (_tmp33_), _g_free0 (_tmp31_), _tmp35_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							_tmp37_ = _tmp36_;
							tracker_turtle_reader_set_subject (self, _tmp37_);
							_g_free0 (_tmp37_);
							self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
							continue;
						} else {
							gboolean _tmp38_;
							gboolean _tmp39_;
							_tmp38_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
							_tmp39_ = _tmp38_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp39_) {
								gchar* _tmp40_ = NULL;
								gchar* _tmp41_;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_;
								gchar* _tmp44_ = NULL;
								gchar* _tmp45_;
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								_tmp40_ = tracker_turtle_reader_get_last_string (self, 0);
								_tmp41_ = _tmp40_;
								_tmp42_ = string_substring (_tmp41_, (glong) 1, (glong) (-1));
								_tmp43_ = _tmp42_;
								_tmp44_ = tracker_turtle_reader_generate_bnodeid (self, _tmp43_);
								_tmp45_ = _tmp44_;
								tracker_turtle_reader_set_subject (self, _tmp45_);
								_g_free0 (_tmp45_);
								_g_free0 (_tmp43_);
								_g_free0 (_tmp41_);
								self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
								continue;
							} else {
								GError* _tmp46_ = NULL;
								_tmp46_ = tracker_turtle_reader_get_error (self, "expected subject");
								_inner_error_ = _tmp46_;
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_SUBJECT:
			{
				gboolean _tmp47_;
				gboolean _tmp48_;
				_tmp47_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				_tmp48_ = _tmp47_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp48_) {
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_;
					_tmp49_ = tracker_turtle_reader_get_last_string (self, 1);
					_tmp50_ = _tmp49_;
					tracker_turtle_reader_set_predicate (self, _tmp50_);
					_g_free0 (_tmp50_);
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
					continue;
				} else {
					gboolean _tmp51_;
					gboolean _tmp52_;
					_tmp51_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					_tmp52_ = _tmp51_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp52_) {
						gchar* _tmp53_ = NULL;
						gchar* ns;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_;
						gchar* _tmp58_ = NULL;
						gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp53_ = tracker_turtle_reader_get_last_string (self, 0);
						ns = _tmp53_;
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp54_ = tracker_turtle_reader_get_last_string (self, 0);
						_tmp55_ = _tmp54_;
						_tmp56_ = string_substring (_tmp55_, (glong) 1, (glong) (-1));
						_tmp57_ = _tmp56_;
						_tmp58_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp57_, &_inner_error_);
						_tmp60_ = (_tmp59_ = _tmp58_, _g_free0 (_tmp57_), _g_free0 (_tmp55_), _tmp59_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp61_ = _tmp60_;
						tracker_turtle_reader_set_predicate (self, _tmp61_);
						_g_free0 (_tmp61_);
						self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
						_g_free0 (ns);
						continue;
					} else {
						gboolean _tmp62_;
						gboolean _tmp63_;
						_tmp62_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						_tmp63_ = _tmp62_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp63_) {
							gchar* _tmp64_ = NULL;
							gchar* _tmp65_;
							gchar* _tmp66_ = NULL;
							gchar* _tmp67_;
							gchar* _tmp68_ = NULL;
							gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							_tmp64_ = tracker_turtle_reader_get_last_string (self, 0);
							_tmp65_ = _tmp64_;
							_tmp66_ = string_substring (_tmp65_, (glong) 1, (glong) (-1));
							_tmp67_ = _tmp66_;
							_tmp68_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp67_, &_inner_error_);
							_tmp70_ = (_tmp69_ = _tmp68_, _g_free0 (_tmp67_), _g_free0 (_tmp65_), _tmp69_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							_tmp71_ = _tmp70_;
							tracker_turtle_reader_set_predicate (self, _tmp71_);
							_g_free0 (_tmp71_);
							self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
							continue;
						} else {
							gboolean _tmp72_;
							gboolean _tmp73_;
							_tmp72_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_A, &_inner_error_);
							_tmp73_ = _tmp72_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp73_) {
								tracker_turtle_reader_set_predicate (self, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
								self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
								continue;
							} else {
								GError* _tmp74_ = NULL;
								_tmp74_ = tracker_turtle_reader_get_error (self, "expected predicate");
								_inner_error_ = _tmp74_;
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_PREDICATE:
			{
				gboolean _tmp75_;
				gboolean _tmp76_;
				_tmp75_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
				_tmp76_ = _tmp75_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp76_) {
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_;
					_tmp77_ = tracker_turtle_reader_get_last_string (self, 1);
					_tmp78_ = _tmp77_;
					tracker_turtle_reader_set_object (self, _tmp78_);
					_g_free0 (_tmp78_);
					tracker_turtle_reader_set_object_is_uri (self, TRUE);
					self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
					result = TRUE;
					return result;
				} else {
					gboolean _tmp79_;
					gboolean _tmp80_;
					_tmp79_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
					_tmp80_ = _tmp79_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp80_) {
						gchar* _tmp81_ = NULL;
						gchar* ns;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_;
						gchar* _tmp84_ = NULL;
						gchar* _tmp85_;
						gchar* _tmp86_ = NULL;
						gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						_tmp81_ = tracker_turtle_reader_get_last_string (self, 0);
						ns = _tmp81_;
						tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp82_ = tracker_turtle_reader_get_last_string (self, 0);
						_tmp83_ = _tmp82_;
						_tmp84_ = string_substring (_tmp83_, (glong) 1, (glong) (-1));
						_tmp85_ = _tmp84_;
						_tmp86_ = tracker_turtle_reader_resolve_prefixed_name (self, ns, _tmp85_, &_inner_error_);
						_tmp88_ = (_tmp87_ = _tmp86_, _g_free0 (_tmp85_), _g_free0 (_tmp83_), _tmp87_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (ns);
								return FALSE;
							} else {
								_g_free0 (ns);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_tmp89_ = _tmp88_;
						tracker_turtle_reader_set_object (self, _tmp89_);
						_g_free0 (_tmp89_);
						tracker_turtle_reader_set_object_is_uri (self, TRUE);
						self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
						result = TRUE;
						_g_free0 (ns);
						return result;
					} else {
						gboolean _tmp90_;
						gboolean _tmp91_;
						_tmp90_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						_tmp91_ = _tmp90_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp91_) {
							gchar* _tmp92_ = NULL;
							gchar* _tmp93_;
							gchar* _tmp94_ = NULL;
							gchar* _tmp95_;
							gchar* _tmp96_ = NULL;
							gchar* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							_tmp92_ = tracker_turtle_reader_get_last_string (self, 0);
							_tmp93_ = _tmp92_;
							_tmp94_ = string_substring (_tmp93_, (glong) 1, (glong) (-1));
							_tmp95_ = _tmp94_;
							_tmp96_ = tracker_turtle_reader_resolve_prefixed_name (self, "", _tmp95_, &_inner_error_);
							_tmp98_ = (_tmp97_ = _tmp96_, _g_free0 (_tmp95_), _g_free0 (_tmp93_), _tmp97_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							_tmp99_ = _tmp98_;
							tracker_turtle_reader_set_object (self, _tmp99_);
							_g_free0 (_tmp99_);
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
							result = TRUE;
							return result;
						} else {
							gboolean _tmp100_;
							gboolean _tmp101_;
							_tmp100_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
							_tmp101_ = _tmp100_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp101_) {
								gchar* _tmp102_ = NULL;
								gchar* _tmp103_;
								gchar* _tmp104_ = NULL;
								gchar* _tmp105_;
								gchar* _tmp106_ = NULL;
								gchar* _tmp107_;
								tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								_tmp102_ = tracker_turtle_reader_get_last_string (self, 0);
								_tmp103_ = _tmp102_;
								_tmp104_ = string_substring (_tmp103_, (glong) 1, (glong) (-1));
								_tmp105_ = _tmp104_;
								_tmp106_ = tracker_turtle_reader_generate_bnodeid (self, _tmp105_);
								_tmp107_ = _tmp106_;
								tracker_turtle_reader_set_object (self, _tmp107_);
								_g_free0 (_tmp107_);
								_g_free0 (_tmp105_);
								_g_free0 (_tmp103_);
								tracker_turtle_reader_set_object_is_uri (self, TRUE);
								self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
								result = TRUE;
								return result;
							} else {
								gboolean _tmp108_;
								gboolean _tmp109_;
								_tmp108_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
								_tmp109_ = _tmp108_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return FALSE;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return FALSE;
									}
								}
								if (_tmp109_) {
									gchar* _tmp110_;
									gchar* _tmp111_;
									gchar* _tmp112_ = NULL;
									gchar* _tmp113_;
									_tmp110_ = g_strdup (self->priv->_subject);
									_vala_array_add10 (&self->priv->subject_stack, &self->priv->subject_stack_length1, &self->priv->_subject_stack_size_, _tmp110_);
									_tmp111_ = g_strdup (self->priv->_predicate);
									_vala_array_add11 (&self->priv->predicate_stack, &self->priv->predicate_stack_length1, &self->priv->_predicate_stack_size_, _tmp111_);
									_tmp112_ = tracker_turtle_reader_generate_bnodeid (self, NULL);
									_tmp113_ = _tmp112_;
									tracker_turtle_reader_set_subject (self, _tmp113_);
									_g_free0 (_tmp113_);
									self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
									continue;
								} else {
									gboolean _tmp114_ = FALSE;
									gboolean _tmp115_;
									gboolean _tmp116_;
									_tmp115_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, &_inner_error_);
									_tmp116_ = _tmp115_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return FALSE;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return FALSE;
										}
									}
									if (_tmp116_) {
										_tmp114_ = TRUE;
									} else {
										gboolean _tmp117_;
										gboolean _tmp118_;
										_tmp117_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, &_inner_error_);
										_tmp118_ = _tmp117_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return FALSE;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										_tmp114_ = _tmp118_;
									}
									if (_tmp114_) {
										GString* _tmp119_ = NULL;
										GString* sb;
										gchar* _tmp120_ = NULL;
										gchar* s;
										const gchar* p;
										gsize _tmp121_;
										const gchar* end;
										gboolean _tmp123_;
										gboolean _tmp124_;
										_tmp119_ = g_string_new ("");
										sb = _tmp119_;
										_tmp120_ = tracker_turtle_reader_get_last_string (self, 1);
										s = _tmp120_;
										p = s;
										_tmp121_ = strlen (s);
										end = p + _tmp121_;
										while (TRUE) {
											const gchar* _tmp122_ = NULL;
											const gchar* q;
											if (!(((glong) p) < ((glong) end))) {
												break;
											}
											_tmp122_ = strchr (p, (gint) '\\');
											q = _tmp122_;
											if (q == NULL) {
												g_string_append_len (sb, p, (gssize) ((glong) (end - p)));
												p = end;
											} else {
												g_string_append_len (sb, p, (gssize) ((glong) (q - p)));
												p = q + 1;
												switch (((gchar*) p)[0]) {
													case '\'':
													case '"':
													case '\\':
													{
														g_string_append_c (sb, ((gchar*) p)[0]);
														break;
													}
													case 'b':
													{
														g_string_append_c (sb, '\b');
														break;
													}
													case 'f':
													{
														g_string_append_c (sb, '\f');
														break;
													}
													case 'n':
													{
														g_string_append_c (sb, '\n');
														break;
													}
													case 'r':
													{
														g_string_append_c (sb, '\r');
														break;
													}
													case 't':
													{
														g_string_append_c (sb, '\t');
														break;
													}
												}
												p++;
											}
										}
										tracker_turtle_reader_set_object (self, sb->str);
										tracker_turtle_reader_set_object_is_uri (self, FALSE);
										self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
										_tmp123_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
										_tmp124_ = _tmp123_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (s);
												_g_string_free0 (sb);
												return FALSE;
											} else {
												_g_free0 (s);
												_g_string_free0 (sb);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										if (_tmp124_) {
											gboolean _tmp125_;
											gboolean _tmp126_;
											_tmp125_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
											_tmp126_ = _tmp125_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (s);
													_g_string_free0 (sb);
													return FALSE;
												} else {
													_g_free0 (s);
													_g_string_free0 (sb);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (!_tmp126_) {
												tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (s);
														_g_string_free0 (sb);
														return FALSE;
													} else {
														_g_free0 (s);
														_g_string_free0 (sb);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (s);
														_g_string_free0 (sb);
														return FALSE;
													} else {
														_g_free0 (s);
														_g_string_free0 (sb);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
											}
										}
										result = TRUE;
										_g_free0 (s);
										_g_string_free0 (sb);
										return result;
									} else {
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_;
										gboolean _tmp129_;
										_tmp128_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, &_inner_error_);
										_tmp129_ = _tmp128_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return FALSE;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return FALSE;
											}
										}
										if (_tmp129_) {
											_tmp127_ = TRUE;
										} else {
											gboolean _tmp130_;
											gboolean _tmp131_;
											_tmp130_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, &_inner_error_);
											_tmp131_ = _tmp130_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											_tmp127_ = _tmp131_;
										}
										if (_tmp127_) {
											gchar* _tmp132_ = NULL;
											gchar* _tmp133_;
											gboolean _tmp134_;
											gboolean _tmp135_;
											_tmp132_ = tracker_turtle_reader_get_last_string (self, 3);
											_tmp133_ = _tmp132_;
											tracker_turtle_reader_set_object (self, _tmp133_);
											_g_free0 (_tmp133_);
											tracker_turtle_reader_set_object_is_uri (self, FALSE);
											self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
											_tmp134_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
											_tmp135_ = _tmp134_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (_tmp135_) {
												gboolean _tmp136_;
												gboolean _tmp137_;
												_tmp136_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
												_tmp137_ = _tmp136_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												if (!_tmp137_) {
													tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return FALSE;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return FALSE;
														}
													}
													tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return FALSE;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return FALSE;
														}
													}
												}
											}
											result = TRUE;
											return result;
										} else {
											gboolean _tmp138_ = FALSE;
											gboolean _tmp139_ = FALSE;
											gboolean _tmp140_ = FALSE;
											gboolean _tmp141_ = FALSE;
											gboolean _tmp142_;
											gboolean _tmp143_;
											_tmp142_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
											_tmp143_ = _tmp142_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
											if (_tmp143_) {
												_tmp141_ = TRUE;
											} else {
												gboolean _tmp144_;
												gboolean _tmp145_;
												_tmp144_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, &_inner_error_);
												_tmp145_ = _tmp144_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp141_ = _tmp145_;
											}
											if (_tmp141_) {
												_tmp140_ = TRUE;
											} else {
												gboolean _tmp146_;
												gboolean _tmp147_;
												_tmp146_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, &_inner_error_);
												_tmp147_ = _tmp146_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp140_ = _tmp147_;
											}
											if (_tmp140_) {
												_tmp139_ = TRUE;
											} else {
												gboolean _tmp148_;
												gboolean _tmp149_;
												_tmp148_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_TRUE, &_inner_error_);
												_tmp149_ = _tmp148_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp139_ = _tmp149_;
											}
											if (_tmp139_) {
												_tmp138_ = TRUE;
											} else {
												gboolean _tmp150_;
												gboolean _tmp151_;
												_tmp150_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FALSE, &_inner_error_);
												_tmp151_ = _tmp150_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return FALSE;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return FALSE;
													}
												}
												_tmp138_ = _tmp151_;
											}
											if (_tmp138_) {
												gchar* _tmp152_ = NULL;
												gchar* _tmp153_;
												_tmp152_ = tracker_turtle_reader_get_last_string (self, 0);
												_tmp153_ = _tmp152_;
												tracker_turtle_reader_set_object (self, _tmp153_);
												_g_free0 (_tmp153_);
												tracker_turtle_reader_set_object_is_uri (self, FALSE);
												self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
												result = TRUE;
												return result;
											} else {
												GError* _tmp154_ = NULL;
												_tmp154_ = tracker_turtle_reader_get_error (self, "expected object");
												_inner_error_ = _tmp154_;
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return FALSE;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return FALSE;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			case TRACKER_TURTLE_READER_STATE_OBJECT:
			{
				gboolean _tmp155_;
				gboolean _tmp156_;
				_tmp155_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
				_tmp156_ = _tmp155_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (_tmp156_) {
					self->priv->state = TRACKER_TURTLE_READER_STATE_PREDICATE;
					continue;
				} else {
					gboolean _tmp157_;
					gboolean _tmp158_;
					_tmp157_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
					_tmp158_ = _tmp157_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					if (_tmp158_) {
						gboolean _tmp159_;
						gboolean _tmp160_;
						_tmp159_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
						_tmp160_ = _tmp159_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						if (_tmp160_) {
							self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
							continue;
						}
						self->priv->state = TRACKER_TURTLE_READER_STATE_SUBJECT;
						continue;
					} else {
						if (self->priv->subject_stack_length1 > 0) {
							tracker_turtle_reader_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							tracker_turtle_reader_set_object (self, self->priv->_subject);
							tracker_turtle_reader_set_object_is_uri (self, TRUE);
							tracker_turtle_reader_set_subject (self, self->priv->subject_stack[self->priv->subject_stack_length1 - 1]);
							self->priv->subject_stack_length1--;
							tracker_turtle_reader_set_predicate (self, self->priv->predicate_stack[self->priv->predicate_stack_length1 - 1]);
							self->priv->predicate_stack_length1--;
							self->priv->state = TRACKER_TURTLE_READER_STATE_OBJECT;
							result = TRUE;
							return result;
						} else {
							gboolean _tmp161_;
							gboolean _tmp162_;
							_tmp161_ = tracker_turtle_reader_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
							_tmp162_ = _tmp161_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
							if (_tmp162_) {
								self->priv->state = TRACKER_TURTLE_READER_STATE_BOS;
								continue;
							} else {
								GError* _tmp163_ = NULL;
								_tmp163_ = tracker_turtle_reader_get_error (self, "expected comma, semicolon, or dot");
								_inner_error_ = _tmp163_;
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return FALSE;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return FALSE;
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void tracker_turtle_reader_load (const gchar* path, GError** error) {
	TrackerTurtleReader* _tmp0_ = NULL;
	TrackerTurtleReader* reader;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	tracker_data_begin_transaction (&_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch4_tracker_sparql_error;
		}
		if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
			goto __catch4_tracker_db_interface_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp0_ = tracker_turtle_reader_new (path, &_inner_error_);
	reader = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch4_tracker_sparql_error;
		}
		if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
			goto __catch4_tracker_db_interface_error;
		}
		goto __finally4;
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = tracker_turtle_reader_next (reader, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (reader);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch4_tracker_sparql_error;
			}
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
				goto __catch4_tracker_db_interface_error;
			}
			_g_object_unref0 (reader);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp2_) {
			break;
		}
		if (reader->priv->_object_is_uri) {
			tracker_data_insert_statement_with_uri (reader->priv->_graph, reader->priv->_subject, reader->priv->_predicate, reader->priv->_object, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (reader);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch4_tracker_sparql_error;
				}
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
					goto __catch4_tracker_db_interface_error;
				}
				_g_object_unref0 (reader);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			tracker_data_insert_statement_with_string (reader->priv->_graph, reader->priv->_subject, reader->priv->_predicate, reader->priv->_object, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (reader);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch4_tracker_sparql_error;
				}
				if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
					goto __catch4_tracker_db_interface_error;
				}
				goto __finally4;
			}
		}
		tracker_data_update_buffer_might_flush (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (reader);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch4_tracker_sparql_error;
			}
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
				goto __catch4_tracker_db_interface_error;
			}
			_g_object_unref0 (reader);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_data_commit_transaction (&_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (reader);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch4_tracker_sparql_error;
		}
		if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
			goto __catch4_tracker_db_interface_error;
		}
		_g_object_unref0 (reader);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (reader);
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError * e;
		GError* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		tracker_data_rollback_transaction ();
		_tmp3_ = _g_error_copy0 (e);
		_inner_error_ = _tmp3_;
		_g_error_free0 (e);
		goto __finally4;
	}
	goto __finally4;
	__catch4_tracker_db_interface_error:
	{
		GError * e;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		tracker_data_rollback_transaction ();
		_tmp4_ = _g_error_copy0 (e);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally4;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == G_FILE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


const gchar* tracker_turtle_reader_get_graph (TrackerTurtleReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_graph;
	return result;
}


static void tracker_turtle_reader_set_graph (TrackerTurtleReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_graph);
	self->priv->_graph = _tmp1_;
	g_object_notify ((GObject *) self, "graph");
}


const gchar* tracker_turtle_reader_get_subject (TrackerTurtleReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_subject;
	return result;
}


static void tracker_turtle_reader_set_subject (TrackerTurtleReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_subject);
	self->priv->_subject = _tmp1_;
	g_object_notify ((GObject *) self, "subject");
}


const gchar* tracker_turtle_reader_get_predicate (TrackerTurtleReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_predicate;
	return result;
}


static void tracker_turtle_reader_set_predicate (TrackerTurtleReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_predicate);
	self->priv->_predicate = _tmp1_;
	g_object_notify ((GObject *) self, "predicate");
}


const gchar* tracker_turtle_reader_get_object (TrackerTurtleReader* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_object;
	return result;
}


static void tracker_turtle_reader_set_object (TrackerTurtleReader* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_object);
	self->priv->_object = _tmp1_;
	g_object_notify ((GObject *) self, "object");
}


gboolean tracker_turtle_reader_get_object_is_uri (TrackerTurtleReader* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_object_is_uri;
	return result;
}


static void tracker_turtle_reader_set_object_is_uri (TrackerTurtleReader* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_object_is_uri = value;
	g_object_notify ((GObject *) self, "object-is-uri");
}


static void tracker_turtle_reader_token_info_copy (const TrackerTurtleReaderTokenInfo* self, TrackerTurtleReaderTokenInfo* dest) {
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation _tmp1_ = {0};
	dest->type = self->type;
	dest->begin = (tracker_source_location_copy (&self->begin, &_tmp0_), _tmp0_);
	dest->end = (tracker_source_location_copy (&self->end, &_tmp1_), _tmp1_);
}


static void tracker_turtle_reader_token_info_destroy (TrackerTurtleReaderTokenInfo* self) {
	tracker_source_location_destroy (&self->begin);
	tracker_source_location_destroy (&self->end);
}


static TrackerTurtleReaderTokenInfo* tracker_turtle_reader_token_info_dup (const TrackerTurtleReaderTokenInfo* self) {
	TrackerTurtleReaderTokenInfo* dup;
	dup = g_new0 (TrackerTurtleReaderTokenInfo, 1);
	tracker_turtle_reader_token_info_copy (self, dup);
	return dup;
}


static void tracker_turtle_reader_token_info_free (TrackerTurtleReaderTokenInfo* self) {
	tracker_turtle_reader_token_info_destroy (self);
	g_free (self);
}


static GType tracker_turtle_reader_token_info_get_type (void) {
	static volatile gsize tracker_turtle_reader_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_token_info_type_id__volatile)) {
		GType tracker_turtle_reader_token_info_type_id;
		tracker_turtle_reader_token_info_type_id = g_boxed_type_register_static ("TrackerTurtleReaderTokenInfo", (GBoxedCopyFunc) tracker_turtle_reader_token_info_dup, (GBoxedFreeFunc) tracker_turtle_reader_token_info_free);
		g_once_init_leave (&tracker_turtle_reader_token_info_type_id__volatile, tracker_turtle_reader_token_info_type_id);
	}
	return tracker_turtle_reader_token_info_type_id__volatile;
}


static void tracker_turtle_reader_class_init (TrackerTurtleReaderClass * klass) {
	tracker_turtle_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerTurtleReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_turtle_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_turtle_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_turtle_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_GRAPH, g_param_spec_string ("graph", "graph", "graph", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_PREDICATE, g_param_spec_string ("predicate", "predicate", "predicate", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT, g_param_spec_string ("object", "object", "object", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_TURTLE_READER_OBJECT_IS_URI, g_param_spec_boolean ("object-is-uri", "object-is-uri", "object-is-uri", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_turtle_reader_instance_init (TrackerTurtleReader * self) {
	self->priv = TRACKER_TURTLE_READER_GET_PRIVATE (self);
	self->priv->bnodeid = 0;
}


static void tracker_turtle_reader_finalize (GObject* obj) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (obj);
	_g_object_unref0 (self->priv->scanner);
	self->priv->tokens = (_vala_TrackerTurtleReaderTokenInfo_array_free (self->priv->tokens, self->priv->tokens_length1), NULL);
	_g_free0 (self->priv->_graph);
	_g_free0 (self->priv->_subject);
	_g_free0 (self->priv->_predicate);
	_g_free0 (self->priv->_object);
	_g_hash_table_unref0 (self->priv->prefix_map);
	self->priv->subject_stack = (_vala_array_free (self->priv->subject_stack, self->priv->subject_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->predicate_stack = (_vala_array_free (self->priv->predicate_stack, self->priv->predicate_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	_g_mapped_file_free0 (self->priv->mapped_file);
	G_OBJECT_CLASS (tracker_turtle_reader_parent_class)->finalize (obj);
}


GType tracker_turtle_reader_get_type (void) {
	static volatile gsize tracker_turtle_reader_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_turtle_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerTurtleReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_turtle_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerTurtleReader), 0, (GInstanceInitFunc) tracker_turtle_reader_instance_init, NULL };
		GType tracker_turtle_reader_type_id;
		tracker_turtle_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerTurtleReader", &g_define_type_info, 0);
		g_once_init_leave (&tracker_turtle_reader_type_id__volatile, tracker_turtle_reader_type_id);
	}
	return tracker_turtle_reader_type_id__volatile;
}


static void _vala_tracker_turtle_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (object);
	switch (property_id) {
		case TRACKER_TURTLE_READER_GRAPH:
		g_value_set_string (value, tracker_turtle_reader_get_graph (self));
		break;
		case TRACKER_TURTLE_READER_SUBJECT:
		g_value_set_string (value, tracker_turtle_reader_get_subject (self));
		break;
		case TRACKER_TURTLE_READER_PREDICATE:
		g_value_set_string (value, tracker_turtle_reader_get_predicate (self));
		break;
		case TRACKER_TURTLE_READER_OBJECT:
		g_value_set_string (value, tracker_turtle_reader_get_object (self));
		break;
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
		g_value_set_boolean (value, tracker_turtle_reader_get_object_is_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_turtle_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerTurtleReader * self;
	self = TRACKER_TURTLE_READER (object);
	switch (property_id) {
		case TRACKER_TURTLE_READER_GRAPH:
		tracker_turtle_reader_set_graph (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_SUBJECT:
		tracker_turtle_reader_set_subject (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_PREDICATE:
		tracker_turtle_reader_set_predicate (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_OBJECT:
		tracker_turtle_reader_set_object (self, g_value_get_string (value));
		break;
		case TRACKER_TURTLE_READER_OBJECT_IS_URI:
		tracker_turtle_reader_set_object_is_uri (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



