/* tracker-explorer.c generated by valac 0.11.2, the Vala compiler
 * generated from tracker-explorer.vala, do not modify */

/**/
/* Copyright 2009, Rob Taylor <rob.taylor@codethink.co.uk>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ResourcesDBusProxy ResourcesDBusProxy;
typedef DBusGProxyClass ResourcesDBusProxyClass;

#define TYPE_HISTORY_ITEM (history_item_get_type ())
#define HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ITEM, HistoryItem))
#define HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ITEM, HistoryItemClass))
#define IS_HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ITEM))
#define IS_HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ITEM))
#define HISTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ITEM, HistoryItemClass))

typedef struct _HistoryItem HistoryItem;
typedef struct _HistoryItemClass HistoryItemClass;
typedef struct _HistoryItemPrivate HistoryItemPrivate;
#define _history_item_unref0(var) ((var == NULL) ? NULL : (var = (history_item_unref (var), NULL)))
typedef struct _ParamSpecHistoryItem ParamSpecHistoryItem;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _ParamSpecHistory ParamSpecHistory;

#define TYPE_EXPLORER (explorer_get_type ())
#define EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPLORER, Explorer))
#define EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPLORER, ExplorerClass))
#define IS_EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPLORER))
#define IS_EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPLORER))
#define EXPLORER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPLORER, ExplorerClass))

typedef struct _Explorer Explorer;
typedef struct _ExplorerClass ExplorerClass;
typedef struct _ExplorerPrivate ExplorerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecExplorer ParamSpecExplorer;
#define _explorer_unref0(var) ((var == NULL) ? NULL : (var = (explorer_unref (var), NULL)))

struct _ResourcesIface {
	GTypeInterface parent_iface;
	gchar** (*SparqlQuery) (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _ResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _HistoryItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryItemPrivate * priv;
	gchar* uri;
	HistoryItem* next;
	HistoryItem* prev;
};

struct _HistoryItemClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryItem *self);
};

struct _ParamSpecHistoryItem {
	GParamSpec parent_instance;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	HistoryItem* items;
	HistoryItem* current;
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

struct _Explorer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExplorerPrivate * priv;
};

struct _ExplorerClass {
	GTypeClass parent_class;
	void (*finalize) (Explorer *self);
};

struct _ExplorerPrivate {
	Resources* tracker;
	History* history;
	GtkListStore* uris;
	GtkListStore* relationships;
	GtkLabel* current_uri_label;
	GeeHashMap* namespaces;
	GtkNotebook* types;
	GtkButton* forward;
	GtkButton* back;
};

struct _ParamSpecExplorer {
	GParamSpec parent_instance;
};


static gpointer history_item_parent_class = NULL;
static gpointer history_parent_class = NULL;
static gpointer explorer_parent_class = NULL;

Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType resources_get_type (void) G_GNUC_CONST;
gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message);
GType resources_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static gchar** resources_dbus_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error);
static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface);
static void _vala_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer history_item_ref (gpointer instance);
void history_item_unref (gpointer instance);
GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_item (GValue* value, gpointer v_object);
void value_take_history_item (GValue* value, gpointer v_object);
gpointer value_get_history_item (const GValue* value);
GType history_item_get_type (void) G_GNUC_CONST;
enum  {
	HISTORY_ITEM_DUMMY_PROPERTY
};
HistoryItem* history_item_new (const gchar* uri);
HistoryItem* history_item_construct (GType object_type, const gchar* uri);
static void history_item_finalize (HistoryItem* obj);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
gchar* history_current_uri (History* self);
gboolean history_can_go_forward (History* self);
gboolean history_can_go_back (History* self);
gboolean history_forward (History* self);
gboolean history_back (History* self);
void history_add (History* self, const gchar* uri);
History* history_new (void);
History* history_construct (GType object_type);
static void history_finalize (History* obj);
gpointer explorer_ref (gpointer instance);
void explorer_unref (gpointer instance);
GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_explorer (GValue* value, gpointer v_object);
void value_take_explorer (GValue* value, gpointer v_object);
gpointer value_get_explorer (const GValue* value);
GType explorer_get_type (void) G_GNUC_CONST;
#define EXPLORER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPLORER, ExplorerPrivate))
enum  {
	EXPLORER_DUMMY_PROPERTY
};
#define EXPLORER_UI_FILE "tracker-explorer.ui"
void explorer_show (Explorer* self);
static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static void explorer_entry_changed (Explorer* self, GtkEditable* editable);
static void _explorer_entry_changed_gtk_editable_changed (GtkEntry* _sender, gpointer self);
static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview);
static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview);
static void explorer_update_types_page (Explorer* self, GtkWidget* w);
static void _explorer_update_types_page_gtk_container_set_focus_child (GtkNotebook* _sender, GtkWidget* widget, gpointer self);
static void explorer_forward_clicked (Explorer* self);
static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_back_clicked (Explorer* self);
static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_fetch_prefixes (Explorer* self);
static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static GtkTreeView* explorer_setup_reverserelationships (Explorer* self);
static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri);
static void explorer_clear_types (Explorer* self);
static void explorer_add_type (Explorer* self, const gchar* type);
static void explorer_set_current_uri (Explorer* self, const gchar* uri);
static void explorer_update_pane (Explorer* self);
Explorer* explorer_new (void);
Explorer* explorer_construct (GType object_type);
static void explorer_finalize (Explorer* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const DBusObjectPathVTable _resources_dbus_path_vtable = {_resources_dbus_unregister, resources_dbus_message};
static const _DBusObjectVTable _resources_dbus_vtable = {resources_dbus_register_object};

gchar** resources_real_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `resources_SparqlQuery'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar** resources_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	return RESOURCES_GET_INTERFACE (self)->SparqlQuery (self, query, result_length1, result_length2, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar* query = NULL;
	const char* _tmp1_;
	gchar** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	gchar** _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	result_length1 = 0;
	result_length2 = 0;
	result = resources_SparqlQuery (self, query, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		DBusMessageIter _tmp5_;
		int _tmp6_;
		dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_ARRAY, "s", &_tmp5_);
		for (_tmp6_ = 0; _tmp6_ < result_length2; _tmp6_++) {
			const char* _tmp7_;
			_tmp7_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp5_, DBUS_TYPE_STRING, &_tmp7_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&_tmp3_, &_tmp5_);
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_resources_SparqlQuery (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_resources_dbus_vtable));
	}
}


GType resources_get_type (void) {
	static volatile gsize resources_type_id__volatile = 0;
	if (g_once_init_enter (&resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType resources_type_id;
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &resources_dbus_proxy_get_type);
		g_once_init_leave (&resources_type_id__volatile, resources_type_id);
	}
	return resources_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ResourcesDBusProxy, resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_dbus_proxy_resources__interface_init) );
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Resources* self;
	self = g_object_new (resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((ResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->dispose (self);
}


static void resources_dbus_proxy_class_init (ResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_resources_dbus_proxy_set_property;
}


static void resources_dbus_proxy_init (ResourcesDBusProxy* self) {
}


static gchar** resources_dbus_proxy_SparqlQuery (Resources* self, const gchar* query, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp0_;
	gchar** _result;
	int _result_length1;
	int _result_length2;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	DBusMessageIter _tmp2_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp0_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp0_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp5_;
			_edomain = DBUS_GERROR;
			_tmp5_ = _dbus_error.name + 27;
			if (strcmp (_tmp5_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp5_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp5_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp5_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp5_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp5_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp5_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp5_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp5_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp5_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp5_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp5_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp5_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp5_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp5_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp5_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp5_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp5_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp5_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp5_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp5_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp5_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp5_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp5_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp5_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp5_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp5_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp5_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp5_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp2_);
	for (; dbus_message_iter_get_arg_type (&_tmp2_); _tmp1__length1++) {
		int _tmp1__length2;
		DBusMessageIter _tmp3_;
		_tmp1__length2 = 0;
		dbus_message_iter_recurse (&_tmp2_, &_tmp3_);
		for (; dbus_message_iter_get_arg_type (&_tmp3_); _tmp1__length2++) {
			const char* _tmp4_;
			if (_tmp1__size == _tmp1__length) {
				_tmp1__size = 2 * _tmp1__size;
				_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp3_, &_tmp4_);
			dbus_message_iter_next (&_tmp3_);
			_tmp1_[_tmp1__length++] = g_strdup (_tmp4_);
		}
		_result_length2 = _tmp1__length2;
		dbus_message_iter_next (&_tmp2_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp1_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void resources_dbus_proxy_resources__interface_init (ResourcesIface* iface) {
	iface->SparqlQuery = resources_dbus_proxy_SparqlQuery;
}


static void _vala_resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


HistoryItem* history_item_construct (GType object_type, const gchar* uri) {
	HistoryItem* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (HistoryItem*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (uri);
	_tmp1_ = _tmp0_;
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	return self;
}


HistoryItem* history_item_new (const gchar* uri) {
	return history_item_construct (TYPE_HISTORY_ITEM, uri);
}


static void value_history_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_item_unref (value->data[0].v_pointer);
	}
}


static void value_history_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		HistoryItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HistoryItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistoryItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM), NULL);
	return value->data[0].v_pointer;
}


void value_set_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_item_unref (old);
	}
}


void value_take_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_item_unref (old);
	}
}


static void history_item_class_init (HistoryItemClass * klass) {
	history_item_parent_class = g_type_class_peek_parent (klass);
	HISTORY_ITEM_CLASS (klass)->finalize = history_item_finalize;
}


static void history_item_instance_init (HistoryItem * self) {
	self->next = NULL;
	self->prev = NULL;
	self->ref_count = 1;
}


static void history_item_finalize (HistoryItem* obj) {
	HistoryItem * self;
	self = HISTORY_ITEM (obj);
	_g_free0 (self->uri);
	_history_item_unref0 (self->next);
	_history_item_unref0 (self->prev);
}


GType history_item_get_type (void) {
	static volatile gsize history_item_type_id__volatile = 0;
	if (g_once_init_enter (&history_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_item_init, value_history_item_free_value, value_history_item_copy_value, value_history_item_peek_pointer, "p", value_history_item_collect_value, "p", value_history_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryItem), 0, (GInstanceInitFunc) history_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_item_type_id;
		history_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_item_type_id__volatile, history_item_type_id);
	}
	return history_item_type_id__volatile;
}


gpointer history_item_ref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_item_unref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gchar* history_current_uri (History* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->current != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self->priv->current->uri);
		result = _tmp0_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


gboolean history_can_go_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		_tmp0_ = self->priv->current->next != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean history_can_go_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		_tmp0_ = self->priv->current->prev != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer _history_item_ref0 (gpointer self) {
	return self ? history_item_ref (self) : NULL;
}


gboolean history_forward (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = history_can_go_forward (self);
	if (_tmp0_) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		_tmp1_ = _history_item_ref0 (self->priv->current->next);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp2_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean history_back (History* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = history_can_go_back (self);
	if (_tmp0_) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		_tmp1_ = _history_item_ref0 (self->priv->current->prev);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp2_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void history_add (History* self, const gchar* uri) {
	HistoryItem* _tmp0_ = NULL;
	HistoryItem* hi;
	HistoryItem* _tmp9_;
	HistoryItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = history_item_new (uri);
	hi = _tmp0_;
	if (self->priv->current == NULL) {
		HistoryItem* _tmp1_;
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
		HistoryItem* _tmp4_;
		_tmp1_ = _history_item_ref0 (hi);
		_tmp2_ = _tmp1_;
		_history_item_unref0 (self->priv->items);
		self->priv->items = _tmp2_;
		_tmp3_ = _history_item_ref0 (self->priv->items);
		_tmp4_ = _tmp3_;
		_history_item_unref0 (self->priv->current);
		self->priv->current = _tmp4_;
	} else {
		HistoryItem* _tmp5_;
		HistoryItem* _tmp6_;
		HistoryItem* _tmp7_;
		HistoryItem* _tmp8_;
		_tmp5_ = _history_item_ref0 (hi);
		_tmp6_ = _tmp5_;
		_history_item_unref0 (self->priv->current->next);
		self->priv->current->next = _tmp6_;
		_tmp7_ = _history_item_ref0 (self->priv->current);
		_tmp8_ = _tmp7_;
		_history_item_unref0 (hi->prev);
		hi->prev = _tmp8_;
	}
	_tmp9_ = _history_item_ref0 (hi);
	_tmp10_ = _tmp9_;
	_history_item_unref0 (self->priv->current);
	self->priv->current = _tmp10_;
	_history_item_unref0 (hi);
}


History* history_construct (GType object_type) {
	History* self = NULL;
	self = (History*) g_type_create_instance (object_type);
	return self;
}


History* history_new (void) {
	return history_construct (TYPE_HISTORY);
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
}


static void history_instance_init (History * self) {
	self->priv = HISTORY_GET_PRIVATE (self);
	self->priv->items = NULL;
	self->priv->current = NULL;
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = HISTORY (obj);
	_history_item_unref0 (self->priv->items);
	_history_item_unref0 (self->priv->current);
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _explorer_entry_changed_gtk_editable_changed (GtkEntry* _sender, gpointer self) {
	explorer_entry_changed (self, _sender);
}


static void _explorer_update_types_page_gtk_container_set_focus_child (GtkNotebook* _sender, GtkWidget* widget, gpointer self) {
	explorer_update_types_page (self, widget);
}


static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	explorer_forward_clicked (self);
}


static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	explorer_back_clicked (self);
}


void explorer_show (Explorer* self) {
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* conn;
	DBusGProxy* _tmp1_ = NULL;
	Resources* _tmp2_;
	GtkBuilder* _tmp4_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* window;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* entry;
	GObject* _tmp12_ = NULL;
	GObject* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeView* urisview;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkTreeView* relationshipsview;
	GObject* _tmp18_ = NULL;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkNotebook* _tmp24_;
	GtkNotebook* _tmp25_;
	GObject* _tmp26_ = NULL;
	GObject* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GObject* _tmp30_ = NULL;
	GObject* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch0_dbus_gerror;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = dbus_g_proxy_new_for_name (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources", "org.freedesktop.Tracker1.Resources");
	_tmp2_ = resources_dbus_proxy_new (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources");
	_g_object_unref0 (self->priv->tracker);
	self->priv->tracker = _tmp2_;
	_dbus_g_connection_unref0 (conn);
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		GtkMessageDialog* _tmp3_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus\n%s", e->message);
		msg = g_object_ref_sink (_tmp3_);
		gtk_dialog_run ((GtkDialog*) msg);
		gtk_main_quit ();
		_g_object_unref0 (msg);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	gtk_builder_add_from_file (builder, SRCDIR EXPLORER_UI_FILE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		gtk_builder_add_from_file (builder, TRACKER_UI_DIR EXPLORER_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			GtkMessageDialog* _tmp5_ = NULL;
			GtkMessageDialog* msg;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI\n%s", e->message);
			msg = g_object_ref_sink (_tmp5_);
			gtk_dialog_run ((GtkDialog*) msg);
			gtk_main_quit ();
			_g_object_unref0 (msg);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_object_unref0 (builder);
			_g_error_free0 (e);
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = gtk_builder_get_object (builder, "explorer");
	_tmp8_ = _g_object_ref0 ((_tmp7_ = _tmp6_, GTK_IS_WINDOW (_tmp7_) ? ((GtkWindow*) _tmp7_) : NULL));
	window = _tmp8_;
	g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	_tmp9_ = gtk_builder_get_object (builder, "text-search");
	_tmp11_ = _g_object_ref0 ((_tmp10_ = _tmp9_, GTK_IS_ENTRY (_tmp10_) ? ((GtkEntry*) _tmp10_) : NULL));
	entry = _tmp11_;
	g_signal_connect ((GtkEditable*) entry, "changed", (GCallback) _explorer_entry_changed_gtk_editable_changed, self);
	_tmp12_ = gtk_builder_get_object (builder, "uris");
	_tmp14_ = _g_object_ref0 ((_tmp13_ = _tmp12_, GTK_IS_TREE_VIEW (_tmp13_) ? ((GtkTreeView*) _tmp13_) : NULL));
	urisview = _tmp14_;
	explorer_setup_uris (self, urisview);
	_tmp15_ = gtk_builder_get_object (builder, "relationshipsview");
	_tmp17_ = _g_object_ref0 ((_tmp16_ = _tmp15_, GTK_IS_TREE_VIEW (_tmp16_) ? ((GtkTreeView*) _tmp16_) : NULL));
	relationshipsview = _tmp17_;
	explorer_setup_relationships (self, relationshipsview);
	_tmp18_ = gtk_builder_get_object (builder, "current-object");
	_tmp20_ = _g_object_ref0 ((_tmp19_ = _tmp18_, GTK_IS_LABEL (_tmp19_) ? ((GtkLabel*) _tmp19_) : NULL));
	_tmp21_ = _tmp20_;
	_g_object_unref0 (self->priv->current_uri_label);
	self->priv->current_uri_label = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "types");
	_tmp24_ = _g_object_ref0 ((_tmp23_ = _tmp22_, GTK_IS_NOTEBOOK (_tmp23_) ? ((GtkNotebook*) _tmp23_) : NULL));
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->priv->types);
	self->priv->types = _tmp25_;
	g_signal_connect ((GtkContainer*) self->priv->types, "set-focus-child", (GCallback) _explorer_update_types_page_gtk_container_set_focus_child, self);
	_tmp26_ = gtk_builder_get_object (builder, "forward");
	_tmp28_ = _g_object_ref0 ((_tmp27_ = _tmp26_, GTK_IS_BUTTON (_tmp27_) ? ((GtkButton*) _tmp27_) : NULL));
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->priv->forward);
	self->priv->forward = _tmp29_;
	g_signal_connect (self->priv->forward, "clicked", (GCallback) _explorer_forward_clicked_gtk_button_clicked, self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, FALSE);
	_tmp30_ = gtk_builder_get_object (builder, "back");
	_tmp32_ = _g_object_ref0 ((_tmp31_ = _tmp30_, GTK_IS_BUTTON (_tmp31_) ? ((GtkButton*) _tmp31_) : NULL));
	_tmp33_ = _tmp32_;
	_g_object_unref0 (self->priv->back);
	self->priv->back = _tmp33_;
	g_signal_connect (self->priv->back, "clicked", (GCallback) _explorer_back_clicked_gtk_button_clicked, self);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, FALSE);
	explorer_fetch_prefixes (self);
	gtk_widget_show_all ((GtkWidget*) window);
	_g_object_unref0 (relationshipsview);
	_g_object_unref0 (urisview);
	_g_object_unref0 (entry);
	_g_object_unref0 (window);
	_g_object_unref0 (builder);
}


static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	explorer_row_selected (self, _sender, path, column);
}


static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (urisview != NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp1_;
	gtk_tree_view_set_model (urisview, (GtkTreeModel*) self->priv->uris);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (urisview, -1, "URI", (GtkCellRenderer*) _tmp3_, "text", 0, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	g_signal_connect (urisview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
}


static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (relationshipsview != NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->relationships);
	self->priv->relationships = _tmp1_;
	gtk_tree_view_set_model (relationshipsview, (GtkTreeModel*) self->priv->relationships);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Relationship", (GtkCellRenderer*) _tmp3_, "text", 1, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Object", (GtkCellRenderer*) _tmp5_, "text", 2, NULL, NULL);
	_g_object_unref0 (_tmp5_);
	g_signal_connect (relationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
}


static GtkTreeView* explorer_setup_reverserelationships (Explorer* self) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* reverserelationships;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeView* reverserelationshipsview;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkCellRendererText* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	reverserelationships = _tmp0_;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) reverserelationships);
	reverserelationshipsview = g_object_ref_sink (_tmp1_);
	gtk_tree_view_set_model (reverserelationshipsview, (GtkTreeModel*) reverserelationships);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Subject", (GtkCellRenderer*) _tmp3_, "text", 1, NULL, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Relationship", (GtkCellRenderer*) _tmp5_, "text", 2, NULL, NULL);
	_g_object_unref0 (_tmp5_);
	g_signal_connect (reverserelationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
	result = reverserelationshipsview;
	_g_object_unref0 (reverserelationships);
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static void explorer_fetch_prefixes (Explorer* self) {
	gchar* _tmp0_;
	gchar* query;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp4_;
	gchar** _result_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("SELECT ?s ?prefix WHERE { ?s a tracker:Namespace ; tracker:prefix ?pre" \
"fix }");
	query = _tmp0_;
	_tmp3_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp1_, &_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	_result__length1 = _tmp1_;
	_result__length2 = _tmp2_;
	_result_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch3_dbus_gerror;
		}
		_g_free0 (query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar* _tmp6_;
				gchar* _namespace;
				glong _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp6_ = g_strdup (_result_[(i * _result__length2) + 0]);
				_namespace = _tmp6_;
				_tmp7_ = strlen (_namespace);
				_tmp8_ = string_substring (_namespace, (glong) 0, _tmp7_ - 1);
				_tmp9_ = _tmp8_;
				_g_free0 (_namespace);
				_namespace = _tmp9_;
				gee_abstract_map_set ((GeeAbstractMap*) self->priv->namespaces, _namespace, _result_[(i * _result__length2) + 1]);
				_g_free0 (_namespace);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


static void explorer_entry_changed (Explorer* self, GtkEditable* editable) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* query;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp5_;
	gchar** _result_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = gtk_entry_get_text (GTK_ENTRY (editable));
	_tmp1_ = g_strdup_printf ("SELECT ?s WHERE { ?s fts:match \"%s*\" }", _tmp0_);
	query = _tmp1_;
	_tmp4_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp2_, &_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_result__length1 = _tmp2_;
	_result__length2 = _tmp3_;
	_result_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch4_dbus_gerror;
		}
		_g_free0 (query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_list_store_clear (self->priv->uris);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _result_;
		s_collection_length1 = _result__length1 * _result__length2;
		for (s_it = 0; s_it < (_result__length1 * _result__length2); s_it = s_it + 1) {
			gchar* _tmp6_;
			gchar* s;
			_tmp6_ = g_strdup (s_collection[s_it]);
			s = _tmp6_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp7_ = {0};
				gtk_list_store_append (self->priv->uris, &_tmp7_);
				iter = _tmp7_;
				gtk_list_store_set (self->priv->uris, &iter, 0, s, -1, -1);
				_g_free0 (s);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


static gchar* explorer_subst_prefix (Explorer* self, const gchar* uri) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp2_;
	gchar** parts;
	gpointer _tmp3_ = NULL;
	gchar* prefix;
	gchar* relationship;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (uri, "#", 0);
	_tmp2_ = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	parts = _tmp2_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->namespaces, parts[0]);
	prefix = (gchar*) _tmp3_;
	relationship = NULL;
	if (prefix != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_strjoin (":", prefix, parts[1], NULL);
		_tmp5_ = _tmp4_;
		_g_free0 (relationship);
		relationship = _tmp5_;
	} else {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup (uri);
		_tmp7_ = _tmp6_;
		_g_free0 (relationship);
		relationship = _tmp7_;
	}
	result = relationship;
	_g_free0 (prefix);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void explorer_clear_types (Explorer* self) {
	gint _tmp0_;
	gint npages;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_notebook_get_n_pages (self->priv->types);
	npages = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < npages)) {
					break;
				}
				gtk_notebook_remove_page (self->priv->types, 0);
			}
		}
	}
}


static void explorer_update_types_page (Explorer* self, GtkWidget* w) {
	gint _tmp0_;
	gint page_num;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* sw;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* type;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_;
	GtkListStore* _tmp12_;
	GtkListStore* model;
	gchar* _tmp13_ = NULL;
	gchar* query;
	gint _tmp14_;
	gint _tmp15_;
	gchar** _tmp16_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp17_;
	gchar** _result_;
	GtkTreeIter iter = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_notebook_get_current_page (self->priv->types);
	page_num = _tmp0_;
	if (page_num < 0) {
		return;
	}
	_tmp1_ = gtk_notebook_get_nth_page (self->priv->types, page_num);
	_tmp3_ = _g_object_ref0 ((_tmp2_ = _tmp1_, GTK_IS_SCROLLED_WINDOW (_tmp2_) ? ((GtkScrolledWindow*) _tmp2_) : NULL));
	sw = _tmp3_;
	_tmp4_ = gtk_notebook_get_tab_label (self->priv->types, (GtkWidget*) sw);
	_tmp6_ = gtk_label_get_text ((_tmp5_ = _tmp4_, GTK_IS_LABEL (_tmp5_) ? ((GtkLabel*) _tmp5_) : NULL));
	_tmp7_ = g_strdup (_tmp6_);
	type = _tmp7_;
	_tmp8_ = gtk_bin_get_child ((GtkBin*) sw);
	_tmp10_ = gtk_tree_view_get_model ((_tmp9_ = _tmp8_, GTK_IS_TREE_VIEW (_tmp9_) ? ((GtkTreeView*) _tmp9_) : NULL));
	_tmp12_ = _g_object_ref0 ((_tmp11_ = _tmp10_, GTK_IS_LIST_STORE (_tmp11_) ? ((GtkListStore*) _tmp11_) : NULL));
	model = _tmp12_;
	_tmp13_ = g_strdup_printf ("SELECT ?r WHERE { ?r rdfs:range %s }", type);
	query = _tmp13_;
	_tmp16_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp14_, &_tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	_result__length1 = _tmp14_;
	_result__length2 = _tmp15_;
	_result_ = _tmp17_;
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch5_dbus_gerror;
		}
		_g_free0 (query);
		_g_object_unref0 (model);
		_g_free0 (type);
		_g_object_unref0 (sw);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_list_store_clear (model);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				gchar* _tmp19_ = NULL;
				gchar* relation;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gchar* query2;
				gint _tmp24_;
				gint _tmp25_;
				gchar** _tmp26_ = NULL;
				gint result2_length1;
				gint result2_length2;
				gchar** _tmp27_;
				gchar** result2;
				if (!_tmp18_) {
					i++;
				}
				_tmp18_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp19_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
				relation = _tmp19_;
				_tmp20_ = history_current_uri (self->priv->history);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("SELECT ?s WHERE { ?s %s <%s>}", relation, _tmp21_);
				query2 = (_tmp23_ = _tmp22_, _g_free0 (_tmp21_), _tmp23_);
				_tmp26_ = resources_SparqlQuery (self->priv->tracker, query2, &_tmp24_, &_tmp25_, &_inner_error_);
				_tmp27_ = _tmp26_;
				result2_length1 = _tmp24_;
				result2_length2 = _tmp25_;
				result2 = _tmp27_;
				if (_inner_error_ != NULL) {
					_g_free0 (query2);
					_g_free0 (relation);
					_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
					_g_free0 (query);
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch5_dbus_gerror;
					}
					_g_free0 (query2);
					_g_free0 (relation);
					_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
					_g_free0 (query);
					_g_object_unref0 (model);
					_g_free0 (type);
					_g_object_unref0 (sw);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							gchar* _tmp29_ = NULL;
							gchar* subject;
							GtkTreeIter _tmp30_ = {0};
							if (!_tmp28_) {
								j++;
							}
							_tmp28_ = FALSE;
							if (!(j < result2_length1)) {
								break;
							}
							_tmp29_ = explorer_subst_prefix (self, result2[(j * result2_length2) + 0]);
							subject = _tmp29_;
							gtk_list_store_append (model, &_tmp30_);
							iter = _tmp30_;
							gtk_list_store_set (model, &iter, 0, result2[(j * result2_length2) + 0], -1, -1);
							gtk_list_store_set (model, &iter, 1, subject, -1, -1);
							gtk_list_store_set (model, &iter, 2, relation, -1, -1);
							_g_free0 (subject);
						}
					}
				}
				result2 = (_vala_array_free (result2, result2_length1 * result2_length2, (GDestroyNotify) g_free), NULL);
				_g_free0 (query2);
				_g_free0 (relation);
			}
		}
	}
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		_g_free0 (type);
		_g_object_unref0 (sw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (model);
	_g_free0 (type);
	_g_object_unref0 (sw);
}


static void explorer_add_type (Explorer* self, const gchar* type) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* tab_label;
	GtkScrolledWindow* _tmp1_ = NULL;
	GtkScrolledWindow* child;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeView* tv;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (type);
	tab_label = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	child = g_object_ref_sink (_tmp1_);
	_tmp2_ = explorer_setup_reverserelationships (self);
	tv = _tmp2_;
	gtk_container_add ((GtkContainer*) child, (GtkWidget*) tv);
	gtk_notebook_append_page (self->priv->types, (GtkWidget*) child, (GtkWidget*) tab_label);
	gtk_widget_show_all ((GtkWidget*) child);
	_g_object_unref0 (tv);
	_g_object_unref0 (child);
	_g_object_unref0 (tab_label);
}


static void explorer_set_current_uri (Explorer* self, const gchar* uri) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	history_add (self->priv->history, uri);
	explorer_update_pane (self);
}


static void explorer_forward_clicked (Explorer* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_forward (self->priv->history);
	if (_tmp0_) {
		explorer_update_pane (self);
	}
}


static void explorer_back_clicked (Explorer* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_back (self->priv->history);
	if (_tmp0_) {
		explorer_update_pane (self);
	}
}


static void explorer_update_pane (Explorer* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* query;
	GtkTreeIter iter = {0};
	gint _tmp10_;
	gint _tmp11_;
	gchar** _tmp12_ = NULL;
	gint _result__length1;
	gint _result__length2;
	gchar** _tmp13_;
	gchar** _result_;
	gint _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = history_can_go_forward (self->priv->history);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, _tmp0_);
	_tmp1_ = history_can_go_back (self->priv->history);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, _tmp1_);
	_tmp2_ = history_current_uri (self->priv->history);
	_tmp3_ = _tmp2_;
	_tmp4_ = explorer_subst_prefix (self, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (self->priv->current_uri_label, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = history_current_uri (self->priv->history);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("SELECT ?r ?o  WHERE { <%s> ?r ?o }", _tmp7_);
	query = (_tmp9_ = _tmp8_, _g_free0 (_tmp7_), _tmp9_);
	_tmp12_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp10_, &_tmp11_, &_inner_error_);
	_tmp13_ = _tmp12_;
	_result__length1 = _tmp10_;
	_result__length2 = _tmp11_;
	_result_ = _tmp13_;
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		if (_inner_error_->domain == DBUS_GERROR) {
			goto __catch6_dbus_gerror;
		}
		_g_free0 (query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_list_store_clear (self->priv->relationships);
	explorer_clear_types (self);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gchar* _tmp15_ = NULL;
				gchar* relationship;
				gchar* _tmp16_ = NULL;
				gchar* obj;
				GtkTreeIter _tmp17_ = {0};
				gboolean _tmp18_ = FALSE;
				if (!_tmp14_) {
					i++;
				}
				_tmp14_ = FALSE;
				if (!(i < _result__length1)) {
					break;
				}
				_tmp15_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
				relationship = _tmp15_;
				_tmp16_ = explorer_subst_prefix (self, _result_[(i * _result__length2) + 1]);
				obj = _tmp16_;
				gtk_list_store_append (self->priv->relationships, &_tmp17_);
				iter = _tmp17_;
				gtk_list_store_set (self->priv->relationships, &iter, 0, _result_[(i * _result__length2) + 1], -1, -1);
				gtk_list_store_set (self->priv->relationships, &iter, 1, relationship, -1, -1);
				gtk_list_store_set (self->priv->relationships, &iter, 2, obj, -1, -1);
				if (g_strcmp0 (relationship, "rdf:type") == 0) {
					_tmp18_ = g_strcmp0 (obj, "rdfs:Resource") != 0;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					explorer_add_type (self, obj);
				}
				_g_free0 (obj);
				_g_free0 (relationship);
			}
		}
	}
	_tmp19_ = gtk_notebook_get_n_pages (self->priv->types);
	gtk_notebook_set_current_page (self->priv->types, _tmp19_ - 1);
	explorer_update_types_page (self, NULL);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void explorer_row_selected (Explorer* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter _tmp2_ = {0};
	const gchar* uri;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = gtk_tree_view_get_model (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	gtk_tree_model_get_iter (model, &_tmp2_, path);
	iter = _tmp2_;
	uri = NULL;
	gtk_tree_model_get (model, &iter, 0, &uri, -1);
	explorer_set_current_uri (self, uri);
	_g_object_unref0 (model);
}


Explorer* explorer_construct (GType object_type) {
	Explorer* self = NULL;
	self = (Explorer*) g_type_create_instance (object_type);
	return self;
}


Explorer* explorer_new (void) {
	return explorer_construct (TYPE_EXPLORER);
}


static void value_explorer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_explorer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		explorer_unref (value->data[0].v_pointer);
	}
}


static void value_explorer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = explorer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_explorer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_explorer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Explorer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = explorer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_explorer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Explorer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = explorer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExplorer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPLORER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_explorer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER), NULL);
	return value->data[0].v_pointer;
}


void value_set_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		explorer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		explorer_unref (old);
	}
}


void value_take_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		explorer_unref (old);
	}
}


static void explorer_class_init (ExplorerClass * klass) {
	explorer_parent_class = g_type_class_peek_parent (klass);
	EXPLORER_CLASS (klass)->finalize = explorer_finalize;
	g_type_class_add_private (klass, sizeof (ExplorerPrivate));
}


static void explorer_instance_init (Explorer * self) {
	History* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self->priv = EXPLORER_GET_PRIVATE (self);
	_tmp0_ = history_new ();
	self->priv->history = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->priv->namespaces = _tmp1_;
	self->ref_count = 1;
}


static void explorer_finalize (Explorer* obj) {
	Explorer * self;
	self = EXPLORER (obj);
	_g_object_unref0 (self->priv->tracker);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->relationships);
	_g_object_unref0 (self->priv->current_uri_label);
	_g_object_unref0 (self->priv->namespaces);
	_g_object_unref0 (self->priv->types);
	_g_object_unref0 (self->priv->forward);
	_g_object_unref0 (self->priv->back);
}


GType explorer_get_type (void) {
	static volatile gsize explorer_type_id__volatile = 0;
	if (g_once_init_enter (&explorer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_explorer_init, value_explorer_free_value, value_explorer_copy_value, value_explorer_peek_pointer, "p", value_explorer_collect_value, "p", value_explorer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExplorerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) explorer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Explorer), 0, (GInstanceInitFunc) explorer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType explorer_type_id;
		explorer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Explorer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&explorer_type_id__volatile, explorer_type_id);
	}
	return explorer_type_id__volatile;
}


gpointer explorer_ref (gpointer instance) {
	Explorer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void explorer_unref (gpointer instance) {
	Explorer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPLORER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Explorer* _tmp0_ = NULL;
	Explorer* s;
	gtk_init (&args_length1, &args);
	_tmp0_ = explorer_new ();
	s = _tmp0_;
	explorer_show (s);
	gtk_main ();
	result = 0;
	_explorer_unref0 (s);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



