/* tracker-utils.c generated by valac 0.11.2, the Vala compiler
 * generated from tracker-utils.gs, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>


#define TYPE_CATEGORIES (categories_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Audio,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;



GType categories_get_type (void) G_GNUC_CONST;
gchar* tracker_utils_EscapeSparql (const gchar* sparql, gboolean add_wildcard);
gboolean tracker_utils_LaunchApp (const gchar* uri);
gboolean tracker_utils_OpenUri (const gchar* uri, gboolean is_dir);
GdkPixbuf* tracker_utils_GetThemePixbufByName (const gchar* icon_name, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen);
GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen);
gchar* tracker_utils_FormatFileSize (gint64 size);


GType categories_get_type (void) {
	static volatile gsize categories_type_id__volatile = 0;
	if (g_once_init_enter (&categories_type_id__volatile)) {
		static const GEnumValue values[] = {{CATEGORIES_Application, "CATEGORIES_Application", "application"}, {CATEGORIES_Contact, "CATEGORIES_Contact", "contact"}, {CATEGORIES_Email, "CATEGORIES_Email", "email"}, {CATEGORIES_EmailAttachment, "CATEGORIES_EmailAttachment", "emailattachment"}, {CATEGORIES_File, "CATEGORIES_File", "file"}, {CATEGORIES_Folder, "CATEGORIES_Folder", "folder"}, {CATEGORIES_Audio, "CATEGORIES_Audio", "audio"}, {CATEGORIES_Video, "CATEGORIES_Video", "video"}, {CATEGORIES_Image, "CATEGORIES_Image", "image"}, {CATEGORIES_Document, "CATEGORIES_Document", "document"}, {CATEGORIES_Text, "CATEGORIES_Text", "text"}, {CATEGORIES_Development, "CATEGORIES_Development", "development"}, {CATEGORIES_Web, "CATEGORIES_Web", "web"}, {CATEGORIES_WebHistory, "CATEGORIES_WebHistory", "webhistory"}, {0, NULL, NULL}};
		GType categories_type_id;
		categories_type_id = g_enum_register_static ("Categories", values);
		g_once_init_leave (&categories_type_id__volatile, categories_type_id);
	}
	return categories_type_id__volatile;
}


gchar* tracker_utils_EscapeSparql (const gchar* sparql, gboolean add_wildcard) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	glong _tmp2_;
	glong len;
	gchar* p;
	gchar* _tmp4_;
	g_return_val_if_fail (sparql != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	if (sparql == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		_g_string_free0 (str);
		return result;
	}
	_tmp2_ = strlen (sparql);
	len = _tmp2_;
	if (len < 3) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (sparql);
		result = _tmp3_;
		_g_string_free0 (str);
		return result;
	}
	p = sparql;
	while (TRUE) {
		if (!((*p) != '\0')) {
			break;
		}
		if ((*p) == '"') {
			g_string_append (str, "\\\"");
		} else {
			if ((*p) == '\\') {
				g_string_append (str, "\\\\");
			} else {
				g_string_append_c (str, *p);
			}
		}
		p++;
	}
	if (add_wildcard) {
		p--;
		if ((*p) != ' ') {
			g_string_append_c (str, '*');
		}
	}
	_tmp4_ = g_strdup (str->str);
	result = _tmp4_;
	_g_string_free0 (str);
	return result;
}


gboolean tracker_utils_LaunchApp (const gchar* uri) {
	gboolean result = FALSE;
	GAppInfo* app_info;
	GAppLaunchContext* context;
	GFile* _tmp0_ = NULL;
	GFile* file;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_ = NULL;
	GAppInfo* _tmp4_;
	GdkAppLaunchContext* _tmp6_ = NULL;
	GAppLaunchContext* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, FALSE);
	app_info = NULL;
	context = NULL;
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = g_file_get_path (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
	_tmp4_ = (GAppInfo*) _tmp3_;
	_g_object_unref0 (app_info);
	app_info = _tmp4_;
	_g_free0 (_tmp2_);
	if (app_info == NULL) {
		gboolean _tmp5_;
		_tmp5_ = tracker_utils_OpenUri (uri, FALSE);
		result = _tmp5_;
		_g_object_unref0 (file);
		_g_object_unref0 (context);
		_g_object_unref0 (app_info);
		return result;
	}
	_tmp6_ = gdk_app_launch_context_new ();
	_tmp7_ = (GAppLaunchContext*) _tmp6_;
	_g_object_unref0 (context);
	context = _tmp7_;
	g_app_info_launch (app_info, NULL, context, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		const gchar* _tmp8_ = NULL;
		GtkMessageDialog* _tmp9_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = g_app_info_get_display_name (app_info);
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not launch \"%s\"\nError: %s\n", _tmp8_, e->message);
		msg = g_object_ref_sink (_tmp9_);
		gtk_dialog_run ((GtkDialog*) msg);
		result = FALSE;
		_g_object_unref0 (msg);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_object_unref0 (context);
		_g_object_unref0 (app_info);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (context);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_object_unref0 (context);
	_g_object_unref0 (app_info);
	return result;
}


gboolean tracker_utils_OpenUri (const gchar* uri, gboolean is_dir) {
	gboolean result = FALSE;
	GAppInfo* app_info;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* _tmp2_;
	GAppInfo* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, FALSE);
	app_info = NULL;
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = g_file_query_default_handler (file, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch11_g_error;
	}
	_tmp3_ = _tmp2_;
	_g_object_unref0 (app_info);
	app_info = _tmp3_;
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		GtkMessageDialog* _tmp4_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not get application info for %s\nError: %s\n", uri, e->message);
		msg = g_object_ref_sink (_tmp4_);
		gtk_dialog_run ((GtkDialog*) msg);
		result = FALSE;
		_g_object_unref0 (msg);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_app_info_launch_default_for_uri (uri, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		GtkMessageDialog* _tmp5_ = NULL;
		GtkMessageDialog* msg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not lauch %s\nError: %s\n", uri, e->message);
		msg = g_object_ref_sink (_tmp5_);
		gtk_dialog_run ((GtkDialog*) msg);
		result = FALSE;
		_g_object_unref0 (msg);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		return result;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_object_unref0 (app_info);
	return result;
}


inline GdkPixbuf* tracker_utils_GetThemePixbufByName (const gchar* icon_name, gint size, GdkScreen* screen) {
	GdkPixbuf* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	GThemedIcon* icon;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (screen != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	icon = _tmp0_;
	_tmp1_ = tracker_utils_GetThemeIconPixbuf ((GIcon*) icon, size, screen);
	result = _tmp1_;
	_g_object_unref0 (icon);
	return result;
}


GdkPixbuf* tracker_utils_GetThumbNail (GFileInfo* info, gint thumb_size, gint icon_size, GdkScreen* screen) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* thumbpath;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (screen != NULL, NULL);
	pixbuf = NULL;
	_tmp0_ = g_file_info_get_attribute_byte_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
	_tmp1_ = g_strdup (_tmp0_);
	thumbpath = _tmp1_;
	if (thumbpath != NULL) {
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = gdk_pixbuf_new_from_file_at_size (thumbpath, thumb_size, thumb_size, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_free0 (thumbpath);
			goto __catch13_g_error;
		}
		_tmp4_ = _tmp3_;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp4_;
	}
	_g_free0 (thumbpath);
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (pixbuf == NULL) {
		GIcon* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_;
		_tmp5_ = g_file_info_get_icon (info);
		_tmp6_ = tracker_utils_GetThemeIconPixbuf (_tmp5_, icon_size, screen);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp7_;
	}
	if (pixbuf == NULL) {
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_;
		_tmp8_ = tracker_utils_GetThemePixbufByName ("text-x-generic", icon_size, screen);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp9_;
	}
	result = pixbuf;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* tracker_utils_GetThemeIconPixbuf (GIcon* icon, gint size, GdkScreen* screen) {
	GdkPixbuf* result = NULL;
	GtkIconInfo* icon_info;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp2_ = NULL;
	GtkIconInfo* _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (screen != NULL, NULL);
	icon_info = NULL;
	_tmp0_ = gtk_icon_theme_get_for_screen (screen);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = gtk_icon_theme_lookup_by_gicon (theme, icon, size, GTK_ICON_LOOKUP_USE_BUILTIN);
	_tmp3_ = _tmp2_;
	_gtk_icon_info_free0 (icon_info);
	icon_info = _tmp3_;
	_tmp4_ = gtk_icon_info_load_icon (icon_info, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		goto __catch14_g_error;
	}
	result = _tmp5_;
	_g_object_unref0 (theme);
	_gtk_icon_info_free0 (icon_info);
	return result;
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (theme);
		_gtk_icon_info_free0 (icon_info);
		return result;
	}
	__finally14:
	_g_object_unref0 (theme);
	_gtk_icon_info_free0 (icon_info);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gchar* tracker_utils_FormatFileSize (gint64 size) {
	gchar* result = NULL;
	gdouble displayed_size = 0.0;
	gchar* _tmp3_ = NULL;
	if (size < 1024) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup_printf ("%u bytes", (guint) size);
		result = _tmp0_;
		return result;
	}
	if (size < 1048576) {
		gchar* _tmp1_ = NULL;
		displayed_size = ((gdouble) size) / 1024;
		_tmp1_ = g_strdup_printf ("%.1f KB", displayed_size);
		result = _tmp1_;
		return result;
	}
	if (size < 1073741824) {
		gchar* _tmp2_ = NULL;
		displayed_size = ((gdouble) size) / 1048576;
		_tmp2_ = g_strdup_printf ("%.1f MB", displayed_size);
		result = _tmp2_;
		return result;
	}
	displayed_size = ((gdouble) size) / 1073741824;
	_tmp3_ = g_strdup_printf ("%.1f GB", displayed_size);
	result = _tmp3_;
	return result;
}



