/* tracker-sparql-pattern.c generated by valac 0.11.4, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-data/tracker-db-manager.h>
#include <libtracker-data/tracker-ontologies.h>
#include <libtracker-data/tracker-property.h>


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	gchar* subject;
	gchar* object;
	gboolean return_graph;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	gboolean current_graph_is_var;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type);
static void tracker_sparql_predicate_variable_finalize (GObject* obj);
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void _vala_array_add3 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
static void _vala_array_add6 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add7 (glong** array, int* length, int* size, glong value);
static void _vala_array_add8 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add9 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj);
static void tracker_sparql_pattern_finalize (GObject* obj);
static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* sql;
	gchar* _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sql = _tmp0_;
	if (self->subject != NULL) {
		gint _tmp1_;
		gint subject_id;
		TrackerDBCursor* cursor;
		_tmp1_ = tracker_data_query_resource_id (self->subject);
		subject_id = _tmp1_;
		cursor = NULL;
		if (subject_id > 0) {
			TrackerDBInterface* _tmp2_ = NULL;
			TrackerDBInterface* _tmp3_;
			TrackerDBInterface* iface;
			TrackerDBStatement* _tmp4_ = NULL;
			TrackerDBStatement* stmt;
			TrackerDBCursor* _tmp5_ = NULL;
			TrackerDBCursor* _tmp6_;
			TrackerDBCursor* _tmp7_;
			_tmp2_ = tracker_db_manager_get_db_interface ();
			_tmp3_ = _g_object_ref0 (_tmp2_);
			iface = _tmp3_;
			_tmp4_ = tracker_db_interface_create_statement (iface, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
			stmt = _tmp4_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (iface);
				_g_object_unref0 (cursor);
				_g_string_free0 (sql);
				goto __catch0_g_error;
			}
			tracker_db_statement_bind_int (stmt, 0, subject_id);
			_tmp5_ = tracker_db_statement_start_cursor (stmt, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_object_unref0 (cursor);
				_g_string_free0 (sql);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp6_;
			_g_object_unref0 (cursor);
			cursor = _tmp7_;
			_g_object_unref0 (stmt);
			_g_object_unref0 (iface);
		}
		if (cursor != NULL) {
			gboolean first;
			first = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gboolean _tmp9_;
				const gchar* _tmp10_ = NULL;
				TrackerClass* _tmp11_ = NULL;
				TrackerClass* _tmp12_;
				TrackerClass* domain;
				gint _tmp13_;
				TrackerProperty** _tmp14_ = NULL;
				_tmp8_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
				_tmp9_ = _tmp8_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (cursor);
					_g_string_free0 (sql);
					goto __catch0_g_error;
				}
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, 0, NULL);
				_tmp11_ = tracker_ontologies_get_class_by_uri (_tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				domain = _tmp12_;
				_tmp14_ = tracker_ontologies_get_properties (&_tmp13_);
				{
					TrackerProperty** prop_collection;
					int prop_collection_length1;
					int prop_it;
					prop_collection = _tmp14_;
					prop_collection_length1 = _tmp13_;
					for (prop_it = 0; prop_it < _tmp13_; prop_it = prop_it + 1) {
						TrackerProperty* _tmp15_;
						TrackerProperty* prop;
						_tmp15_ = _g_object_ref0 (prop_collection[prop_it]);
						prop = _tmp15_;
						{
							TrackerClass* _tmp16_ = NULL;
							_tmp16_ = tracker_property_get_domain (prop);
							if (_tmp16_ == domain) {
								const gchar* _tmp17_ = NULL;
								const gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_;
								TrackerPropertyType _tmp21_;
								const gchar* _tmp23_ = NULL;
								TrackerSparqlLiteralBinding* _tmp24_ = NULL;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp25_ = NULL;
								gchar* _tmp26_;
								TrackerSparqlLiteralBinding* _tmp27_;
								if (first) {
									first = FALSE;
								} else {
									g_string_append (sql, " UNION ALL ");
								}
								_tmp17_ = tracker_property_get_uri (prop);
								g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp17_);
								_tmp18_ = tracker_property_get_name (prop);
								_tmp19_ = g_strdup_printf ("\"%s\"", _tmp18_);
								_tmp20_ = _tmp19_;
								_tmp21_ = tracker_property_get_data_type (prop);
								tracker_sparql_expression_append_expression_as_string (sql, _tmp20_, _tmp21_);
								_g_free0 (_tmp20_);
								g_string_append (sql, " AS \"object\"");
								if (self->return_graph) {
									const gchar* _tmp22_ = NULL;
									_tmp22_ = tracker_property_get_name (prop);
									g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", _tmp22_);
								}
								_tmp23_ = tracker_property_get_table_name (prop);
								g_string_append_printf (sql, " FROM \"%s\"", _tmp23_);
								g_string_append (sql, " WHERE ID = ?");
								_tmp24_ = tracker_sparql_literal_binding_new ();
								binding = _tmp24_;
								_tmp25_ = g_strdup_printf ("%i", subject_id);
								_tmp26_ = _tmp25_;
								_g_free0 (binding->literal);
								binding->literal = _tmp26_;
								((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
								_tmp27_ = _g_object_ref0 (binding);
								query->bindings = g_list_append (query->bindings, _tmp27_);
								_g_object_unref0 (binding);
							}
							_g_object_unref0 (prop);
						}
					}
				}
				_g_object_unref0 (domain);
			}
		} else {
			g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
		}
		_g_object_unref0 (cursor);
	} else {
		if (self->object != NULL) {
			gint _tmp28_;
			gint object_id;
			TrackerDBInterface* _tmp29_ = NULL;
			TrackerDBInterface* _tmp30_;
			TrackerDBInterface* iface;
			TrackerDBStatement* _tmp31_ = NULL;
			TrackerDBStatement* stmt;
			TrackerDBCursor* _tmp32_ = NULL;
			TrackerDBCursor* cursor;
			gboolean first;
			_tmp28_ = tracker_data_query_resource_id (self->object);
			object_id = _tmp28_;
			_tmp29_ = tracker_db_manager_get_db_interface ();
			_tmp30_ = _g_object_ref0 (_tmp29_);
			iface = _tmp30_;
			_tmp31_ = tracker_db_interface_create_statement (iface, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
			stmt = _tmp31_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (iface);
				_g_string_free0 (sql);
				goto __catch0_g_error;
			}
			tracker_db_statement_bind_int (stmt, 0, object_id);
			_tmp32_ = tracker_db_statement_start_cursor (stmt, &_inner_error_);
			cursor = _tmp32_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (stmt);
				_g_object_unref0 (iface);
				_g_string_free0 (sql);
				goto __catch0_g_error;
			}
			first = TRUE;
			if (cursor != NULL) {
				while (TRUE) {
					gboolean _tmp33_;
					gboolean _tmp34_;
					const gchar* _tmp35_ = NULL;
					TrackerClass* _tmp36_ = NULL;
					TrackerClass* _tmp37_;
					TrackerClass* range;
					gint _tmp38_;
					TrackerProperty** _tmp39_ = NULL;
					_tmp33_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) cursor, NULL, &_inner_error_);
					_tmp34_ = _tmp33_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (cursor);
						_g_object_unref0 (stmt);
						_g_object_unref0 (iface);
						_g_string_free0 (sql);
						goto __catch0_g_error;
					}
					if (!_tmp34_) {
						break;
					}
					_tmp35_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) cursor, 0, NULL);
					_tmp36_ = tracker_ontologies_get_class_by_uri (_tmp35_);
					_tmp37_ = _g_object_ref0 (_tmp36_);
					range = _tmp37_;
					_tmp39_ = tracker_ontologies_get_properties (&_tmp38_);
					{
						TrackerProperty** prop_collection;
						int prop_collection_length1;
						int prop_it;
						prop_collection = _tmp39_;
						prop_collection_length1 = _tmp38_;
						for (prop_it = 0; prop_it < _tmp38_; prop_it = prop_it + 1) {
							TrackerProperty* _tmp40_;
							TrackerProperty* prop;
							_tmp40_ = _g_object_ref0 (prop_collection[prop_it]);
							prop = _tmp40_;
							{
								TrackerClass* _tmp41_ = NULL;
								_tmp41_ = tracker_property_get_range (prop);
								if (_tmp41_ == range) {
									const gchar* _tmp42_ = NULL;
									const gchar* _tmp43_ = NULL;
									gchar* _tmp44_ = NULL;
									gchar* _tmp45_;
									TrackerPropertyType _tmp46_;
									const gchar* _tmp48_ = NULL;
									if (first) {
										first = FALSE;
									} else {
										g_string_append (sql, " UNION ALL ");
									}
									_tmp42_ = tracker_property_get_uri (prop);
									g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp42_);
									_tmp43_ = tracker_property_get_name (prop);
									_tmp44_ = g_strdup_printf ("\"%s\"", _tmp43_);
									_tmp45_ = _tmp44_;
									_tmp46_ = tracker_property_get_data_type (prop);
									tracker_sparql_expression_append_expression_as_string (sql, _tmp45_, _tmp46_);
									_g_free0 (_tmp45_);
									g_string_append (sql, " AS \"object\"");
									if (self->return_graph) {
										const gchar* _tmp47_ = NULL;
										_tmp47_ = tracker_property_get_name (prop);
										g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", _tmp47_);
									}
									_tmp48_ = tracker_property_get_table_name (prop);
									g_string_append_printf (sql, " FROM \"%s\"", _tmp48_);
								}
								_g_object_unref0 (prop);
							}
						}
					}
					_g_object_unref0 (range);
				}
			} else {
				g_string_append (sql, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
			}
			_g_object_unref0 (cursor);
			_g_object_unref0 (stmt);
			_g_object_unref0 (iface);
		} else {
			if (self->domain != NULL) {
				gboolean first;
				gint _tmp49_;
				TrackerProperty** _tmp50_ = NULL;
				first = TRUE;
				_tmp50_ = tracker_ontologies_get_properties (&_tmp49_);
				{
					TrackerProperty** prop_collection;
					int prop_collection_length1;
					int prop_it;
					prop_collection = _tmp50_;
					prop_collection_length1 = _tmp49_;
					for (prop_it = 0; prop_it < _tmp49_; prop_it = prop_it + 1) {
						TrackerProperty* _tmp51_;
						TrackerProperty* prop;
						_tmp51_ = _g_object_ref0 (prop_collection[prop_it]);
						prop = _tmp51_;
						{
							TrackerClass* _tmp52_ = NULL;
							_tmp52_ = tracker_property_get_domain (prop);
							if (_tmp52_ == self->domain) {
								const gchar* _tmp53_ = NULL;
								const gchar* _tmp54_ = NULL;
								gchar* _tmp55_ = NULL;
								gchar* _tmp56_;
								TrackerPropertyType _tmp57_;
								const gchar* _tmp59_ = NULL;
								if (first) {
									first = FALSE;
								} else {
									g_string_append (sql, " UNION ALL ");
								}
								_tmp53_ = tracker_property_get_uri (prop);
								g_string_append_printf (sql, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp53_);
								_tmp54_ = tracker_property_get_name (prop);
								_tmp55_ = g_strdup_printf ("\"%s\"", _tmp54_);
								_tmp56_ = _tmp55_;
								_tmp57_ = tracker_property_get_data_type (prop);
								tracker_sparql_expression_append_expression_as_string (sql, _tmp56_, _tmp57_);
								_g_free0 (_tmp56_);
								g_string_append (sql, " AS \"object\"");
								if (self->return_graph) {
									const gchar* _tmp58_ = NULL;
									_tmp58_ = tracker_property_get_name (prop);
									g_string_append_printf (sql, ", \"%s:graph\" AS \"graph\"", _tmp58_);
								}
								_tmp59_ = tracker_property_get_table_name (prop);
								g_string_append_printf (sql, " FROM \"%s\"", _tmp59_);
							}
							_g_object_unref0 (prop);
						}
					}
				}
			} else {
				GError* _tmp60_ = NULL;
				_tmp60_ = tracker_sparql_query_get_internal_error (query, "Unrestricted predicate variables not supported");
				_inner_error_ = _tmp60_;
				_g_string_free0 (sql);
				goto __catch0_g_error;
			}
		}
	}
	_tmp61_ = g_strdup (sql->str);
	result = _tmp61_;
	_g_string_free0 (sql);
	return result;
	_g_string_free0 (sql);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GError* _tmp62_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp62_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, e->message);
		_inner_error_ = _tmp62_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type) {
	TrackerSparqlPredicateVariable * self = NULL;
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (void) {
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE);
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
}


static void tracker_sparql_predicate_variable_finalize (GObject* obj) {
	TrackerSparqlPredicateVariable * self;
	self = TRACKER_SPARQL_PREDICATE_VARIABLE (obj);
	_g_free0 (self->subject);
	_g_free0 (self->object);
	_g_object_unref0 (self->domain);
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
	self->priv->query = query;
	self->priv->expression = query->expression;
	return self;
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_current (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg) {
	GError* result = NULL;
	GError* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_error (self->priv->query, msg);
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp1_ = (tracker_sparql_query_get_location (self->priv->query, &_tmp0_), _tmp0_);
	*result = _tmp1_;
	return;
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	g_return_if_fail (self != NULL);
	tracker_sparql_query_set_location (self->priv->query, location);
}


static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_last_string (self->priv->query, strip);
	result = _tmp0_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _vala_array_add3 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerPropertyType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (TrackerPropertyType** array, int* length, int* size, TrackerPropertyType value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerPropertyType, *array, *size);
	}
	(*array)[(*length)++] = value;
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	TrackerSparqlSelectContext* _result_;
	TrackerPropertyType type;
	GString* _tmp6_ = NULL;
	GString* pattern_sql;
	GList* _tmp7_;
	GList* old_bindings;
	gboolean _tmp8_;
	gboolean _tmp9_;
	TrackerSourceLocation _tmp12_ = {0};
	TrackerSourceLocation _tmp13_ = {0};
	TrackerSourceLocation select_variables_location;
	gboolean _tmp14_;
	gboolean _tmp15_;
	TrackerSparqlContext* _tmp16_ = NULL;
	TrackerSparqlContext* pattern;
	GList* _tmp17_ = NULL;
	TrackerSourceLocation _tmp20_ = {0};
	TrackerSourceLocation _tmp21_ = {0};
	TrackerSourceLocation after_where;
	TrackerSparqlContext* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	GList* _tmp29_;
	GList* where_bindings;
	GList* _tmp30_;
	GList* _tmp31_;
	gboolean first;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	gint limit;
	gint offset;
	gboolean _tmp73_;
	gboolean _tmp74_;
	TrackerSparqlContext* _tmp106_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_result_ = NULL;
	if (scalar_subquery) {
		TrackerSparqlContext* _tmp0_ = NULL;
		TrackerSparqlSelectContext* _tmp1_ = NULL;
		TrackerSparqlSelectContext* _tmp2_;
		_tmp0_ = tracker_sparql_pattern_get_context (self);
		_tmp1_ = tracker_sparql_select_context_new_subquery (self->priv->query, _tmp0_);
		_tmp2_ = _tmp1_;
		_tracker_sparql_context_unref0 (_result_);
		_result_ = _tmp2_;
	} else {
		TrackerSparqlContext* _tmp3_ = NULL;
		TrackerSparqlSelectContext* _tmp4_ = NULL;
		TrackerSparqlSelectContext* _tmp5_;
		_tmp3_ = tracker_sparql_pattern_get_context (self);
		_tmp4_ = tracker_sparql_select_context_new (self->priv->query, _tmp3_);
		_tmp5_ = _tmp4_;
		_tracker_sparql_context_unref0 (_result_);
		_result_ = _tmp5_;
	}
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	_tmp6_ = g_string_new ("");
	pattern_sql = _tmp6_;
	_tmp7_ = self->priv->query->bindings;
	self->priv->query->bindings = NULL;
	old_bindings = _tmp7_;
	g_string_append (sql, "SELECT ");
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp9_) {
		g_string_append (sql, "DISTINCT ");
	} else {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp11_) {
		}
	}
	_tmp13_ = (tracker_sparql_pattern_get_location (self, &_tmp12_), _tmp12_);
	select_variables_location = _tmp13_;
	tracker_sparql_expression_skip_select_variables (self->priv->expression, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp15_) {
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = tracker_sparql_pattern_translate_group_graph_pattern (self, pattern_sql, &_inner_error_);
	pattern = _tmp16_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = g_hash_table_get_keys (pattern->var_set);
	{
		GList* key_collection;
		GList* key_it;
		key_collection = _tmp17_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			TrackerSparqlVariable* key;
			key = (TrackerSparqlVariable*) key_it->data;
			{
				TrackerSparqlContext* _tmp18_ = NULL;
				TrackerSparqlVariable* _tmp19_;
				_tmp18_ = tracker_sparql_pattern_get_context (self);
				_tmp19_ = _g_object_ref0 (key);
				g_hash_table_insert (_tmp18_->var_set, _tmp19_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (key_collection);
	}
	_tmp21_ = (tracker_sparql_pattern_get_location (self, &_tmp20_), _tmp20_);
	after_where = _tmp21_;
	tracker_sparql_pattern_set_location (self, &select_variables_location);
	_tmp22_ = tracker_sparql_pattern_get_context (self);
	_tmp23_ = g_hash_table_get_keys (_tmp22_->var_set);
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = _tmp23_;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (variable->binding == NULL) {
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					GError* _tmp27_ = NULL;
					GError* _tmp28_;
					_tmp24_ = tracker_sparql_variable_get_name (variable);
					_tmp25_ = g_strdup_printf ("use of undefined variable `%s'", _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = tracker_sparql_pattern_get_error (self, _tmp26_);
					_inner_error_ = (_tmp28_ = _tmp27_, _g_free0 (_tmp26_), _tmp28_);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
		_g_list_free0 (variable_collection);
	}
	_tmp29_ = self->priv->query->bindings;
	self->priv->query->bindings = NULL;
	where_bindings = _tmp29_;
	_tmp30_ = old_bindings;
	old_bindings = NULL;
	_tmp31_ = _tmp30_;
	__g_list_free__g_object_unref0_0 (self->priv->query->bindings);
	self->priv->query->bindings = _tmp31_;
	first = TRUE;
	_tmp32_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
	_tmp33_ = _tmp32_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp33_) {
		TrackerSparqlContext* _tmp34_ = NULL;
		GList* _tmp35_ = NULL;
		_tmp34_ = tracker_sparql_pattern_get_context (self);
		_tmp35_ = g_hash_table_get_keys (_tmp34_->var_set);
		{
			GList* variable_collection;
			GList* variable_it;
			variable_collection = _tmp35_;
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
				TrackerSparqlVariable* variable;
				variable = (TrackerSparqlVariable*) variable_it->data;
				{
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_;
					if (!first) {
						g_string_append (sql, ", ");
					} else {
						first = FALSE;
					}
					if (subquery) {
						const gchar* _tmp36_ = NULL;
						_tmp36_ = tracker_sparql_variable_get_sql_expression (variable);
						g_string_append (sql, _tmp36_);
					} else {
						const gchar* _tmp37_ = NULL;
						const gchar* _tmp38_ = NULL;
						_tmp37_ = tracker_sparql_variable_get_sql_expression (variable);
						tracker_sparql_expression_append_expression_as_string (sql, _tmp37_, ((TrackerSparqlDataBinding*) variable->binding)->data_type);
						_tmp38_ = tracker_sparql_variable_get_name (variable);
						g_string_append_printf (sql, " AS \"%s\"", _tmp38_);
					}
					_vala_array_add3 (&_result_->types, &_result_->types_length1, &_result_->_types_size_, ((TrackerSparqlDataBinding*) variable->binding)->data_type);
					_tmp39_ = tracker_sparql_variable_get_name (variable);
					_tmp40_ = g_strdup (_tmp39_);
					_vala_array_add4 (&_result_->variable_names, &_result_->variable_names_length1, &_result_->_variable_names_size_, _tmp40_);
				}
			}
			_g_list_free0 (variable_collection);
		}
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp41_;
				_tmp41_ = TRUE;
				while (TRUE) {
					TrackerPropertyType _tmp42_;
					TrackerPropertyType _tmp43_;
					TrackerSparqlTokenType _tmp44_;
					if (!_tmp41_) {
						i++;
					}
					_tmp41_ = FALSE;
					first = FALSE;
					if (i > 0) {
						g_string_append (sql, ", ");
					}
					_tmp42_ = tracker_sparql_expression_translate_select_expression (self->priv->expression, sql, subquery, i, &_inner_error_);
					_tmp43_ = _tmp42_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							__g_list_free__g_object_unref0_0 (where_bindings);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free__g_object_unref0_0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							__g_list_free__g_object_unref0_0 (where_bindings);
							_tracker_sparql_context_unref0 (pattern);
							__g_list_free__g_object_unref0_0 (old_bindings);
							_g_string_free0 (pattern_sql);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					type = _tmp43_;
					_vala_array_add5 (&_result_->types, &_result_->types_length1, &_result_->_types_size_, type);
					_tmp44_ = tracker_sparql_pattern_current (self);
					switch (_tmp44_) {
						case TRACKER_SPARQL_TOKEN_TYPE_FROM:
						case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
						case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
						case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
						case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
						case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
						case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
						case TRACKER_SPARQL_TOKEN_TYPE_EOF:
						{
							break;
						}
						default:
						{
							continue;
						}
					}
					break;
				}
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = where_bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* _tmp45_;
			TrackerSparqlLiteralBinding* binding;
			_tmp45_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			binding = _tmp45_;
			{
				TrackerSparqlLiteralBinding* _tmp46_;
				_tmp46_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp46_);
				_g_object_unref0 (binding);
			}
		}
	}
	if (first) {
		g_string_append (sql, "NULL");
	}
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	tracker_sparql_pattern_set_location (self, &after_where);
	_tmp47_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
	_tmp48_ = _tmp47_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp48_) {
		gboolean first_group;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " GROUP BY ");
		first_group = TRUE;
		{
			gboolean _tmp49_;
			_tmp49_ = TRUE;
			while (TRUE) {
				if (!_tmp49_) {
					gboolean _tmp50_ = FALSE;
					gboolean _tmp51_ = FALSE;
					gboolean _tmp52_ = FALSE;
					gboolean _tmp53_ = FALSE;
					gboolean _tmp54_ = FALSE;
					TrackerSparqlTokenType _tmp55_;
					_tmp55_ = tracker_sparql_pattern_current (self);
					if (_tmp55_ != TRACKER_SPARQL_TOKEN_TYPE_ORDER) {
						TrackerSparqlTokenType _tmp56_;
						_tmp56_ = tracker_sparql_pattern_current (self);
						_tmp54_ = _tmp56_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
					} else {
						_tmp54_ = FALSE;
					}
					if (_tmp54_) {
						TrackerSparqlTokenType _tmp57_;
						_tmp57_ = tracker_sparql_pattern_current (self);
						_tmp53_ = _tmp57_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp53_ = FALSE;
					}
					if (_tmp53_) {
						TrackerSparqlTokenType _tmp58_;
						_tmp58_ = tracker_sparql_pattern_current (self);
						_tmp52_ = _tmp58_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						TrackerSparqlTokenType _tmp59_;
						_tmp59_ = tracker_sparql_pattern_current (self);
						_tmp51_ = _tmp59_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						TrackerSparqlTokenType _tmp60_;
						_tmp60_ = tracker_sparql_pattern_current (self);
						_tmp50_ = _tmp60_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp50_ = FALSE;
					}
					if (!_tmp50_) {
						break;
					}
				}
				_tmp49_ = FALSE;
				if (first_group) {
					first_group = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_expression (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp61_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
	_tmp62_ = _tmp61_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp62_) {
		gboolean first_order;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_string_append (sql, " ORDER BY ");
		first_order = TRUE;
		{
			gboolean _tmp63_;
			_tmp63_ = TRUE;
			while (TRUE) {
				if (!_tmp63_) {
					gboolean _tmp64_ = FALSE;
					gboolean _tmp65_ = FALSE;
					gboolean _tmp66_ = FALSE;
					gboolean _tmp67_ = FALSE;
					TrackerSparqlTokenType _tmp68_;
					_tmp68_ = tracker_sparql_pattern_current (self);
					if (_tmp68_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
						TrackerSparqlTokenType _tmp69_;
						_tmp69_ = tracker_sparql_pattern_current (self);
						_tmp67_ = _tmp69_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
					} else {
						_tmp67_ = FALSE;
					}
					if (_tmp67_) {
						TrackerSparqlTokenType _tmp70_;
						_tmp70_ = tracker_sparql_pattern_current (self);
						_tmp66_ = _tmp70_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
					} else {
						_tmp66_ = FALSE;
					}
					if (_tmp66_) {
						TrackerSparqlTokenType _tmp71_;
						_tmp71_ = tracker_sparql_pattern_current (self);
						_tmp65_ = _tmp71_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
					} else {
						_tmp65_ = FALSE;
					}
					if (_tmp65_) {
						TrackerSparqlTokenType _tmp72_;
						_tmp72_ = tracker_sparql_pattern_current (self);
						_tmp64_ = _tmp72_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
					} else {
						_tmp64_ = FALSE;
					}
					if (!_tmp64_) {
						break;
					}
				}
				_tmp63_ = FALSE;
				if (first_order) {
					first_order = FALSE;
				} else {
					g_string_append (sql, ", ");
				}
				tracker_sparql_expression_translate_order_condition (self->priv->expression, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	limit = -1;
	offset = -1;
	_tmp73_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
	_tmp74_ = _tmp73_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			__g_list_free__g_object_unref0_0 (where_bindings);
			_tracker_sparql_context_unref0 (pattern);
			__g_list_free__g_object_unref0_0 (old_bindings);
			_g_string_free0 (pattern_sql);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp74_) {
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		gint _tmp77_;
		gboolean _tmp78_;
		gboolean _tmp79_;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp75_ = tracker_sparql_pattern_get_last_string (self, 0);
		_tmp76_ = _tmp75_;
		_tmp77_ = atoi (_tmp76_);
		limit = _tmp77_;
		_g_free0 (_tmp76_);
		_tmp78_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		_tmp79_ = _tmp78_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp79_) {
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			gint _tmp82_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp80_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp81_ = _tmp80_;
			_tmp82_ = atoi (_tmp81_);
			offset = _tmp82_;
			_g_free0 (_tmp81_);
		}
	} else {
		gboolean _tmp83_;
		gboolean _tmp84_;
		_tmp83_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
		_tmp84_ = _tmp83_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				__g_list_free__g_object_unref0_0 (where_bindings);
				_tracker_sparql_context_unref0 (pattern);
				__g_list_free__g_object_unref0_0 (old_bindings);
				_g_string_free0 (pattern_sql);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp84_) {
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gint _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp85_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp86_ = _tmp85_;
			_tmp87_ = atoi (_tmp86_);
			offset = _tmp87_;
			_g_free0 (_tmp86_);
			_tmp88_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
			_tmp89_ = _tmp88_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					__g_list_free__g_object_unref0_0 (where_bindings);
					_tracker_sparql_context_unref0 (pattern);
					__g_list_free__g_object_unref0_0 (old_bindings);
					_g_string_free0 (pattern_sql);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp89_) {
				gchar* _tmp90_ = NULL;
				gchar* _tmp91_;
				gint _tmp92_;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						__g_list_free__g_object_unref0_0 (where_bindings);
						_tracker_sparql_context_unref0 (pattern);
						__g_list_free__g_object_unref0_0 (old_bindings);
						_g_string_free0 (pattern_sql);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp90_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp91_ = _tmp90_;
				_tmp92_ = atoi (_tmp91_);
				limit = _tmp92_;
				_g_free0 (_tmp91_);
			}
		}
	}
	if (limit >= 0) {
		TrackerSparqlLiteralBinding* _tmp93_ = NULL;
		TrackerSparqlLiteralBinding* binding;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_;
		TrackerSparqlLiteralBinding* _tmp96_;
		g_string_append (sql, " LIMIT ?");
		_tmp93_ = tracker_sparql_literal_binding_new ();
		binding = _tmp93_;
		_tmp94_ = g_strdup_printf ("%i", limit);
		_tmp95_ = _tmp94_;
		_g_free0 (binding->literal);
		binding->literal = _tmp95_;
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
		_tmp96_ = _g_object_ref0 (binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp96_);
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* _tmp97_ = NULL;
			TrackerSparqlLiteralBinding* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_;
			TrackerSparqlLiteralBinding* _tmp101_;
			g_string_append (sql, " OFFSET ?");
			_tmp97_ = tracker_sparql_literal_binding_new ();
			_tmp98_ = _tmp97_;
			_g_object_unref0 (binding);
			binding = _tmp98_;
			_tmp99_ = g_strdup_printf ("%i", offset);
			_tmp100_ = _tmp99_;
			_g_free0 (binding->literal);
			binding->literal = _tmp100_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp101_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp101_);
		}
		_g_object_unref0 (binding);
	} else {
		if (offset >= 0) {
			TrackerSparqlLiteralBinding* _tmp102_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_;
			TrackerSparqlLiteralBinding* _tmp105_;
			g_string_append (sql, " LIMIT -1 OFFSET ?");
			_tmp102_ = tracker_sparql_literal_binding_new ();
			binding = _tmp102_;
			_tmp103_ = g_strdup_printf ("%i", offset);
			_tmp104_ = _tmp103_;
			_g_free0 (binding->literal);
			binding->literal = _tmp104_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp105_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp105_);
			_g_object_unref0 (binding);
		}
	}
	_tmp106_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp106_->parent_context);
	_result_->type = type;
	result = _result_;
	__g_list_free__g_object_unref0_0 (where_bindings);
	_tracker_sparql_context_unref0 (pattern);
	__g_list_free__g_object_unref0_0 (old_bindings);
	_g_string_free0 (pattern_sql);
	return result;
}


void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean not;
	TrackerSparqlSelectContext* _result_;
	TrackerSparqlContext* _tmp1_ = NULL;
	TrackerSparqlSelectContext* _tmp2_ = NULL;
	TrackerSparqlSelectContext* _tmp3_;
	TrackerSparqlContext* _tmp4_ = NULL;
	TrackerSparqlContext* pattern;
	GList* _tmp5_ = NULL;
	TrackerSparqlContext* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	TrackerSparqlContext* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
	not = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EXISTS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_result_ = NULL;
	_tmp1_ = tracker_sparql_pattern_get_context (self);
	_tmp2_ = tracker_sparql_select_context_new_subquery (self->priv->query, _tmp1_);
	_tmp3_ = _tmp2_;
	_tracker_sparql_context_unref0 (_result_);
	_result_ = _tmp3_;
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
	if (not) {
		g_string_append (sql, "NOT EXISTS (");
	} else {
		g_string_append (sql, "EXISTS (");
	}
	_tmp4_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
	pattern = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_tracker_sparql_context_unref0 (_result_);
			return;
		} else {
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = g_hash_table_get_keys (pattern->var_set);
	{
		GList* key_collection;
		GList* key_it;
		key_collection = _tmp5_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			TrackerSparqlVariable* key;
			key = (TrackerSparqlVariable*) key_it->data;
			{
				TrackerSparqlContext* _tmp6_ = NULL;
				TrackerSparqlVariable* _tmp7_;
				_tmp6_ = tracker_sparql_pattern_get_context (self);
				_tmp7_ = _g_object_ref0 (key);
				g_hash_table_insert (_tmp6_->var_set, _tmp7_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (key_collection);
	}
	_tmp8_ = tracker_sparql_pattern_get_context (self);
	_tmp9_ = g_hash_table_get_keys (_tmp8_->var_set);
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = _tmp9_;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (variable->binding == NULL) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					GError* _tmp13_ = NULL;
					GError* _tmp14_;
					_tmp10_ = tracker_sparql_variable_get_name (variable);
					_tmp11_ = g_strdup_printf ("use of undefined variable `%s'", _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = tracker_sparql_pattern_get_error (self, _tmp12_);
					_inner_error_ = (_tmp14_ = _tmp13_, _g_free0 (_tmp12_), _tmp14_);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						_tracker_sparql_context_unref0 (_result_);
						return;
					} else {
						_g_list_free0 (variable_collection);
						_tracker_sparql_context_unref0 (pattern);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (variable_collection);
	}
	g_string_append (sql, ")");
	_tmp15_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp15_->parent_context);
	_tracker_sparql_context_unref0 (pattern);
	_tracker_sparql_context_unref0 (_result_);
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	gboolean _is_var = FALSE;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	_is_var = FALSE;
	_tmp1_ = tracker_sparql_pattern_current (self);
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_is_var = TRUE;
		tracker_sparql_pattern_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
		_tmp5_ = _tmp4_;
		_g_free0 (_result_);
		_result_ = _tmp5_;
		_g_free0 (_tmp3_);
	} else {
		TrackerSparqlTokenType _tmp6_;
		_tmp6_ = tracker_sparql_pattern_current (self);
		if (_tmp6_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp7_ = tracker_sparql_pattern_get_last_string (self, 1);
			_tmp8_ = _tmp7_;
			_g_free0 (_result_);
			_result_ = _tmp8_;
		} else {
			TrackerSparqlTokenType _tmp9_;
			_tmp9_ = tracker_sparql_pattern_current (self);
			if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				gchar* _tmp10_ = NULL;
				gchar* ns;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
				ns = _tmp10_;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp11_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp12_ = _tmp11_;
				_tmp13_ = string_substring (_tmp12_, (glong) 1, (glong) (-1));
				_tmp14_ = _tmp13_;
				_tmp15_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp14_, &_inner_error_);
				_tmp17_ = (_tmp16_ = _tmp15_, _g_free0 (_tmp14_), _g_free0 (_tmp12_), _tmp16_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp18_ = _tmp17_;
				_g_free0 (_result_);
				_result_ = _tmp18_;
				_g_free0 (ns);
			} else {
				TrackerSparqlTokenType _tmp19_;
				_tmp19_ = tracker_sparql_pattern_current (self);
				if (_tmp19_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp20_ = tracker_sparql_pattern_get_last_string (self, 0);
					_tmp21_ = _tmp20_;
					_tmp22_ = string_substring (_tmp21_, (glong) 1, (glong) (-1));
					_tmp23_ = _tmp22_;
					_tmp24_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp23_, &_inner_error_);
					_tmp26_ = (_tmp25_ = _tmp24_, _g_free0 (_tmp23_), _g_free0 (_tmp21_), _tmp25_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp27_ = _tmp26_;
					_g_free0 (_result_);
					_result_ = _tmp27_;
				} else {
					gboolean _tmp28_;
					gboolean _tmp29_;
					_tmp28_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					_tmp29_ = _tmp28_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp29_) {
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_;
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp30_ = tracker_sparql_pattern_get_last_string (self, 0);
						_tmp31_ = _tmp30_;
						_tmp32_ = string_substring (_tmp31_, (glong) 1, (glong) (-1));
						_tmp33_ = _tmp32_;
						_tmp34_ = tracker_sparql_query_generate_bnodeid (self->priv->query, _tmp33_);
						_tmp35_ = _tmp34_;
						_g_free0 (_result_);
						_result_ = _tmp35_;
						_g_free0 (_tmp33_);
						_g_free0 (_tmp31_);
					} else {
						TrackerSparqlTokenType _tmp36_;
						_tmp36_ = tracker_sparql_pattern_current (self);
						if (_tmp36_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
							gchar* _tmp39_;
							_tmp37_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
							_tmp38_ = _tmp37_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_tmp39_ = _tmp38_;
							_g_free0 (_result_);
							_result_ = _tmp39_;
						} else {
							TrackerSparqlTokenType _tmp40_;
							_tmp40_ = tracker_sparql_pattern_current (self);
							if (_tmp40_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_;
								gchar* _tmp43_;
								_tmp41_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
								_tmp42_ = _tmp41_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp43_ = _tmp42_;
								_g_free0 (_result_);
								_result_ = _tmp43_;
							} else {
								TrackerSparqlTokenType _tmp44_;
								_tmp44_ = tracker_sparql_pattern_current (self);
								if (_tmp44_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
									gchar* _tmp45_ = NULL;
									gchar* _tmp46_;
									gchar* _tmp47_;
									_tmp45_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
									_tmp46_ = _tmp45_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_tmp47_ = _tmp46_;
									_g_free0 (_result_);
									_result_ = _tmp47_;
								} else {
									TrackerSparqlTokenType _tmp48_;
									_tmp48_ = tracker_sparql_pattern_current (self);
									if (_tmp48_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
										gchar* _tmp49_ = NULL;
										gchar* _tmp50_;
										gchar* _tmp51_;
										_tmp49_ = tracker_sparql_expression_parse_string_literal (self->priv->expression, NULL, &_inner_error_);
										_tmp50_ = _tmp49_;
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_tmp51_ = _tmp50_;
										_g_free0 (_result_);
										_result_ = _tmp51_;
									} else {
										TrackerSparqlTokenType _tmp52_;
										_tmp52_ = tracker_sparql_pattern_current (self);
										if (_tmp52_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
											gchar* _tmp53_ = NULL;
											gchar* _tmp54_;
											tracker_sparql_pattern_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_tmp53_ = tracker_sparql_pattern_get_last_string (self, 0);
											_tmp54_ = _tmp53_;
											_g_free0 (_result_);
											_result_ = _tmp54_;
										} else {
											TrackerSparqlTokenType _tmp55_;
											_tmp55_ = tracker_sparql_pattern_current (self);
											if (_tmp55_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
												gchar* _tmp56_ = NULL;
												gchar* _tmp57_;
												tracker_sparql_pattern_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp56_ = tracker_sparql_pattern_get_last_string (self, 0);
												_tmp57_ = _tmp56_;
												_g_free0 (_result_);
												_result_ = _tmp57_;
											} else {
												TrackerSparqlTokenType _tmp58_;
												_tmp58_ = tracker_sparql_pattern_current (self);
												if (_tmp58_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
													gchar* _tmp59_ = NULL;
													gchar* _tmp60_;
													tracker_sparql_pattern_next (self, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_tmp59_ = tracker_sparql_pattern_get_last_string (self, 0);
													_tmp60_ = _tmp59_;
													_g_free0 (_result_);
													_result_ = _tmp60_;
												} else {
													TrackerSparqlTokenType _tmp61_;
													_tmp61_ = tracker_sparql_pattern_current (self);
													if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
														gchar* _tmp62_;
														gchar* _tmp63_;
														tracker_sparql_pattern_next (self, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_tmp62_ = g_strdup ("true");
														_tmp63_ = _tmp62_;
														_g_free0 (_result_);
														_result_ = _tmp63_;
													} else {
														TrackerSparqlTokenType _tmp64_;
														_tmp64_ = tracker_sparql_pattern_current (self);
														if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
															gchar* _tmp65_;
															gchar* _tmp66_;
															tracker_sparql_pattern_next (self, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_tmp65_ = g_strdup ("false");
															_tmp66_ = _tmp65_;
															_g_free0 (_result_);
															_result_ = _tmp66_;
														} else {
															TrackerSparqlTokenType _tmp67_;
															_tmp67_ = tracker_sparql_pattern_current (self);
															if (_tmp67_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																gchar* _tmp68_ = NULL;
																gchar* _tmp69_;
																gchar* _tmp70_;
																gchar* old_subject;
																gboolean old_subject_is_var;
																gchar* _tmp71_;
																gchar* _tmp72_;
																gchar* _tmp73_;
																gchar* _tmp74_;
																tracker_sparql_pattern_next (self, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_tmp68_ = tracker_sparql_query_generate_bnodeid (self->priv->query, NULL);
																_tmp69_ = _tmp68_;
																_g_free0 (_result_);
																_result_ = _tmp69_;
																_tmp70_ = g_strdup (self->priv->current_subject);
																old_subject = _tmp70_;
																old_subject_is_var = self->priv->current_subject_is_var;
																_tmp71_ = g_strdup (_result_);
																_tmp72_ = _tmp71_;
																_g_free0 (self->priv->current_subject);
																self->priv->current_subject = _tmp72_;
																self->priv->current_subject_is_var = TRUE;
																tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (old_subject);
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_tmp73_ = g_strdup (old_subject);
																_tmp74_ = _tmp73_;
																_g_free0 (self->priv->current_subject);
																self->priv->current_subject = _tmp74_;
																self->priv->current_subject_is_var = old_subject_is_var;
																_is_var = TRUE;
																_g_free0 (old_subject);
															} else {
																GError* _tmp75_ = NULL;
																_tmp75_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
																_inner_error_ = _tmp75_;
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	if (is_var) {
		*is_var = _is_var;
	}
	return result;
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		tracker_sparql_pattern_parse_object (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp1_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gchar* _tmp0_;
		gchar* old_predicate;
		gboolean old_predicate_is_var;
		gchar* _tmp1_;
		TrackerSparqlTokenType _tmp2_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp36_;
		_tmp0_ = g_strdup (self->priv->current_predicate);
		old_predicate = _tmp0_;
		old_predicate_is_var = self->priv->current_predicate_is_var;
		_tmp1_ = NULL;
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = _tmp1_;
		self->priv->current_predicate_is_var = FALSE;
		_tmp2_ = tracker_sparql_pattern_current (self);
		if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp3_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) (-1));
			_tmp6_ = _tmp5_;
			_g_free0 (self->priv->current_predicate);
			self->priv->current_predicate = _tmp6_;
			_g_free0 (_tmp4_);
		} else {
			TrackerSparqlTokenType _tmp7_;
			_tmp7_ = tracker_sparql_pattern_current (self);
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				tracker_sparql_pattern_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 1);
				_tmp9_ = _tmp8_;
				_g_free0 (self->priv->current_predicate);
				self->priv->current_predicate = _tmp9_;
			} else {
				TrackerSparqlTokenType _tmp10_;
				_tmp10_ = tracker_sparql_pattern_current (self);
				if (_tmp10_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					gchar* _tmp11_ = NULL;
					gchar* ns;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp11_ = tracker_sparql_pattern_get_last_string (self, 0);
					ns = _tmp11_;
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp12_ = tracker_sparql_pattern_get_last_string (self, 0);
					_tmp13_ = _tmp12_;
					_tmp14_ = string_substring (_tmp13_, (glong) 1, (glong) (-1));
					_tmp15_ = _tmp14_;
					_tmp16_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp15_, &_inner_error_);
					_tmp18_ = (_tmp17_ = _tmp16_, _g_free0 (_tmp15_), _g_free0 (_tmp13_), _tmp17_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp19_ = _tmp18_;
					_g_free0 (self->priv->current_predicate);
					self->priv->current_predicate = _tmp19_;
					_g_free0 (ns);
				} else {
					TrackerSparqlTokenType _tmp20_;
					_tmp20_ = tracker_sparql_pattern_current (self);
					if (_tmp20_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						tracker_sparql_pattern_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp21_ = tracker_sparql_pattern_get_last_string (self, 0);
						_tmp22_ = _tmp21_;
						_tmp23_ = string_substring (_tmp22_, (glong) 1, (glong) (-1));
						_tmp24_ = _tmp23_;
						_tmp25_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp24_, &_inner_error_);
						_tmp27_ = (_tmp26_ = _tmp25_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp26_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp28_ = _tmp27_;
						_g_free0 (self->priv->current_predicate);
						self->priv->current_predicate = _tmp28_;
					} else {
						TrackerSparqlTokenType _tmp29_;
						_tmp29_ = tracker_sparql_pattern_current (self);
						if (_tmp29_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
							gchar* _tmp30_;
							gchar* _tmp31_;
							tracker_sparql_pattern_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp30_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
							_tmp31_ = _tmp30_;
							_g_free0 (self->priv->current_predicate);
							self->priv->current_predicate = _tmp31_;
						} else {
							GError* _tmp32_ = NULL;
							_tmp32_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
							_inner_error_ = _tmp32_;
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
		tracker_sparql_pattern_parse_object_list (self, sql, in_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp33_ = g_strdup (old_predicate);
		_tmp34_ = _tmp33_;
		_g_free0 (self->priv->current_predicate);
		self->priv->current_predicate = _tmp34_;
		self->priv->current_predicate_is_var = old_predicate_is_var;
		_tmp35_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		_tmp36_ = _tmp35_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp36_) {
			TrackerSparqlTokenType _tmp37_;
			_tmp37_ = tracker_sparql_pattern_current (self);
			if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
				_g_free0 (old_predicate);
				break;
			}
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_constraint (self->priv->expression, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	gint n_parens;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_pattern_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_pattern_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_parens = 1;
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		if (!(n_parens > 0)) {
			break;
		}
		_tmp1_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			n_parens++;
		} else {
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp4_) {
				n_parens--;
			} else {
				TrackerSparqlTokenType _tmp5_;
				_tmp5_ = tracker_sparql_pattern_current (self);
				if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					GError* _tmp6_ = NULL;
					_tmp6_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
					_inner_error_ = _tmp6_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					tracker_sparql_pattern_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* _tmp0_ = NULL;
	TrackerSparqlPatternTripleContext* _tmp1_ = NULL;
	TrackerSparqlPatternTripleContext* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_pattern_get_context (self);
	_tmp1_ = tracker_sparql_pattern_triple_context_new (self->priv->query, _tmp0_);
	_tmp2_ = _tmp1_;
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	self->priv->triple_context = _tmp2_;
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) self->priv->triple_context);
	g_string_append (sql, "SELECT ");
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	gboolean first;
	TrackerSparqlContext* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	TrackerSparqlPatternTripleContext* _tmp31_;
	TrackerSparqlContext* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_truncate (sql, (gsize) (sql->len - 2));
	g_string_append (sql, " FROM ");
	first = TRUE;
	{
		GList* table_collection;
		GList* table_it;
		table_collection = self->priv->triple_context->tables;
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
			TrackerSparqlDataTable* _tmp0_;
			TrackerSparqlDataTable* table;
			_tmp0_ = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
			table = _tmp0_;
			{
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (table->sql_db_tablename != NULL) {
					g_string_append_printf (sql, "\"%s\"", table->sql_db_tablename);
				} else {
					gchar* _tmp1_ = NULL;
					gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = tracker_sparql_predicate_variable_get_sql_query (table->predicate_variable, self->priv->query, &_inner_error_);
					_tmp2_ = _tmp1_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (table);
							return;
						} else {
							_g_object_unref0 (table);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp3_ = _tmp2_;
					g_string_append_printf (sql, "(%s)", _tmp3_);
					_g_free0 (_tmp3_);
				}
				g_string_append_printf (sql, " AS \"%s\"", table->sql_query_tablename);
				_g_object_unref0 (table);
			}
		}
	}
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = self->priv->triple_context->variables;
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* _tmp4_;
			TrackerSparqlVariable* variable;
			_tmp4_ = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
			variable = _tmp4_;
			{
				gboolean maybe_null;
				gboolean in_simple_optional;
				TrackerPropertyType last_type;
				gchar* last_name;
				gconstpointer _tmp5_ = NULL;
				gboolean _tmp17_ = FALSE;
				maybe_null = TRUE;
				in_simple_optional = FALSE;
				last_type = TRACKER_PROPERTY_TYPE_UNKNOWN;
				last_name = NULL;
				_tmp5_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, variable);
				{
					GList* binding_collection;
					GList* binding_it;
					binding_collection = ((TrackerSparqlVariableBindingList*) _tmp5_)->list;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						TrackerSparqlVariableBinding* _tmp6_;
						TrackerSparqlVariableBinding* binding;
						_tmp6_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
						binding = _tmp6_;
						{
							gchar* name;
							TrackerPropertyType type;
							gchar* _tmp15_;
							gchar* _tmp16_;
							name = NULL;
							if (((TrackerSparqlDataBinding*) binding)->table != NULL) {
								const gchar* _tmp7_ = NULL;
								gchar* _tmp8_;
								gchar* _tmp9_;
								_tmp7_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
								_tmp8_ = g_strdup (_tmp7_);
								_tmp9_ = _tmp8_;
								_g_free0 (name);
								name = _tmp9_;
							} else {
								const gchar* _tmp10_ = NULL;
								gchar* _tmp11_;
								gchar* _tmp12_;
								_tmp10_ = tracker_sparql_variable_get_sql_expression (variable);
								_tmp11_ = g_strdup (_tmp10_);
								_tmp12_ = _tmp11_;
								_g_free0 (name);
								name = _tmp12_;
							}
							type = ((TrackerSparqlDataBinding*) binding)->data_type;
							if (last_name != NULL) {
								gboolean _tmp13_ = FALSE;
								gboolean _tmp14_ = FALSE;
								if (!(*first_where)) {
									g_string_append (sql, " AND ");
								} else {
									g_string_append (sql, " WHERE ");
									*first_where = FALSE;
								}
								if (last_type == TRACKER_PROPERTY_TYPE_STRING) {
									_tmp13_ = type == TRACKER_PROPERTY_TYPE_RESOURCE;
								} else {
									_tmp13_ = FALSE;
								}
								if (_tmp13_) {
									g_string_append_printf (sql, "(SELECT ID FROM Resource WHERE Uri = %s)", last_name);
								} else {
									g_string_append (sql, last_name);
								}
								g_string_append (sql, " = ");
								if (last_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
									_tmp14_ = type == TRACKER_PROPERTY_TYPE_STRING;
								} else {
									_tmp14_ = FALSE;
								}
								if (_tmp14_) {
									g_string_append_printf (sql, "(SELECT ID FROM Resource WHERE Uri = %s)", name);
								} else {
									g_string_append (sql, name);
								}
							}
							_tmp15_ = g_strdup (name);
							_tmp16_ = _tmp15_;
							_g_free0 (last_name);
							last_name = _tmp16_;
							last_type = type;
							if (!binding->maybe_null) {
								maybe_null = FALSE;
							}
							in_simple_optional = binding->in_simple_optional;
							_g_free0 (name);
							_g_object_unref0 (binding);
						}
					}
				}
				if (maybe_null) {
					_tmp17_ = !in_simple_optional;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					const gchar* _tmp18_ = NULL;
					if (!(*first_where)) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						*first_where = FALSE;
					}
					_tmp18_ = tracker_sparql_variable_get_sql_expression (variable);
					g_string_append_printf (sql, "%s IS NOT NULL", _tmp18_);
				}
				_g_free0 (last_name);
				_g_object_unref0 (variable);
			}
		}
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->priv->triple_context->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* _tmp19_;
			TrackerSparqlLiteralBinding* binding;
			_tmp19_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			binding = _tmp19_;
			{
				const gchar* _tmp20_ = NULL;
				if (!(*first_where)) {
					g_string_append (sql, " AND ");
				} else {
					g_string_append (sql, " WHERE ");
					*first_where = FALSE;
				}
				_tmp20_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
				g_string_append (sql, _tmp20_);
				if (binding->is_fts_match) {
					gchar** _tmp21_;
					gchar** _tmp22_ = NULL;
					gchar** _tmp23_;
					gint _tmp23__length1;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gchar* escaped_literal;
					_tmp22_ = _tmp21_ = g_strsplit (binding->literal, "'", 0);
					_tmp23_ = _tmp22_;
					_tmp23__length1 = _vala_array_length (_tmp21_);
					_tmp24_ = g_strjoinv ("''", _tmp23_);
					escaped_literal = (_tmp25_ = _tmp24_, _tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL), _tmp25_);
					g_string_append_printf (sql, " MATCH '%s'", escaped_literal);
					_g_free0 (escaped_literal);
				} else {
					TrackerSparqlLiteralBinding* _tmp26_;
					g_string_append (sql, " = ");
					if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
						g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
					} else {
						g_string_append (sql, "?");
					}
					_tmp26_ = _g_object_ref0 (binding);
					self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp26_);
				}
				_g_object_unref0 (binding);
			}
		}
	}
	if (in_group_graph_pattern) {
		g_string_append (sql, ")");
	}
	_tmp27_ = tracker_sparql_pattern_get_context (self);
	_tmp28_ = g_hash_table_get_keys (_tmp27_->var_set);
	{
		GList* v_collection;
		GList* v_it;
		v_collection = _tmp28_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			TrackerSparqlVariable* v;
			v = (TrackerSparqlVariable*) v_it->data;
			{
				TrackerSparqlContext* _tmp29_ = NULL;
				TrackerSparqlVariable* _tmp30_;
				_tmp29_ = tracker_sparql_pattern_get_context (self);
				_tmp30_ = _g_object_ref0 (v);
				g_hash_table_insert (_tmp29_->parent_context->var_set, _tmp30_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
			}
		}
		_g_list_free0 (v_collection);
	}
	_tmp31_ = NULL;
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	self->priv->triple_context = _tmp31_;
	_tmp32_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp32_->parent_context);
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		TrackerSparqlTokenType _tmp4_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp4_ = tracker_sparql_pattern_current (self);
		if (_tmp4_ != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			TrackerSparqlTokenType _tmp5_;
			_tmp5_ = tracker_sparql_pattern_current (self);
			_tmp3_ = _tmp5_ != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			TrackerSparqlTokenType _tmp6_;
			_tmp6_ = tracker_sparql_pattern_current (self);
			_tmp2_ = _tmp6_ != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			TrackerSparqlTokenType _tmp7_;
			_tmp7_ = tracker_sparql_pattern_current (self);
			_tmp1_ = _tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_COLON;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			TrackerSparqlTokenType _tmp8_;
			_tmp8_ = tracker_sparql_pattern_current (self);
			_tmp0_ = _tmp8_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			break;
		}
		if (*in_triples_block) {
			_tmp10_ = !(*in_group_graph_pattern);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = found_simple_optional;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			tracker_sparql_pattern_end_triples_block (self, sql, first_where, *in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			*in_triples_block = FALSE;
			*in_group_graph_pattern = TRUE;
		}
		if (!(*in_triples_block)) {
			if (*in_group_graph_pattern) {
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ") NATURAL INNER JOIN (");
			}
			*in_triples_block = TRUE;
			*first_where = TRUE;
			tracker_sparql_pattern_start_triples_block (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		_tmp12_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp11_, &_inner_error_);
		self->priv->current_subject_is_var = _tmp11_;
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp14_ = _tmp13_;
		_g_free0 (self->priv->current_subject);
		self->priv->current_subject = _tmp14_;
		tracker_sparql_pattern_parse_property_list_not_empty (self, sql, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp15_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp16_) {
			break;
		}
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	TrackerClass** _tmp0_;
	TrackerClass** _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class1 != NULL, FALSE);
	g_return_val_if_fail (class2 != NULL, FALSE);
	if (class1 == class2) {
		result = TRUE;
		return result;
	}
	_tmp1_ = _tmp0_ = tracker_class_get_super_classes (class1);
	{
		TrackerClass** superclass_collection;
		int superclass_collection_length1;
		int superclass_it;
		superclass_collection = _tmp1_;
		superclass_collection_length1 = _vala_array_length (_tmp0_);
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp0_); superclass_it = superclass_it + 1) {
			TrackerClass* _tmp2_;
			TrackerClass* superclass;
			_tmp2_ = _g_object_ref0 (superclass_collection[superclass_it]);
			superclass = _tmp2_;
			{
				gboolean _tmp3_;
				_tmp3_ = tracker_sparql_pattern_is_subclass (self, superclass, class2);
				if (_tmp3_) {
					result = TRUE;
					_g_object_unref0 (superclass);
					return result;
				}
				_g_object_unref0 (superclass);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	TrackerSourceLocation _tmp0_ = {0};
	TrackerSourceLocation _tmp1_ = {0};
	TrackerSourceLocation optional_start;
	gboolean _tmp2_;
	gboolean _tmp3_;
	TrackerSparqlContext* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	TrackerSparqlVariable* _tmp9_ = NULL;
	TrackerSparqlVariable* _tmp10_;
	TrackerSparqlVariable* _tmp11_;
	TrackerSparqlVariable* left_variable;
	TrackerSparqlContext* _tmp12_ = NULL;
	gconstpointer _tmp13_ = NULL;
	gint left_variable_state;
	gchar* predicate;
	gboolean _tmp14_;
	gboolean _tmp15_;
	TrackerProperty* _tmp39_ = NULL;
	TrackerProperty* _tmp40_;
	TrackerProperty* prop;
	gboolean _tmp41_;
	gboolean _tmp42_;
	TrackerSparqlContext* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	TrackerSparqlVariable* _tmp48_ = NULL;
	TrackerSparqlVariable* _tmp49_;
	TrackerSparqlVariable* _tmp50_;
	TrackerSparqlVariable* right_variable;
	TrackerSparqlContext* _tmp51_ = NULL;
	gconstpointer _tmp52_ = NULL;
	gint right_variable_state;
	gboolean _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = (tracker_sparql_pattern_get_location (self, &_tmp0_), _tmp0_);
	optional_start = _tmp1_;
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp3_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		return result;
	}
	_tmp4_ = tracker_sparql_pattern_get_context (self);
	_tmp5_ = tracker_sparql_pattern_get_last_string (self, 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = tracker_sparql_context_get_variable (_tmp4_, _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	left_variable = (_tmp11_ = _tmp10_, _g_free0 (_tmp8_), _g_free0 (_tmp6_), _tmp11_);
	_tmp12_ = tracker_sparql_pattern_get_context (self);
	_tmp13_ = g_hash_table_lookup (_tmp12_->var_set, left_variable);
	left_variable_state = GPOINTER_TO_INT (_tmp13_);
	predicate = NULL;
	_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp16_ = tracker_sparql_pattern_get_last_string (self, 1);
		_tmp17_ = _tmp16_;
		_g_free0 (predicate);
		predicate = _tmp17_;
	} else {
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp18_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch1_tracker_sparql_error;
			}
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (_tmp19_) {
			gchar* _tmp20_ = NULL;
			gchar* ns;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = tracker_sparql_pattern_get_last_string (self, 0);
			ns = _tmp20_;
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (ns);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				_g_free0 (ns);
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp21_ = tracker_sparql_pattern_get_last_string (self, 0);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_substring (_tmp22_, (glong) 1, (glong) (-1));
			_tmp24_ = _tmp23_;
			_tmp25_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp24_, &_inner_error_);
			_tmp27_ = (_tmp26_ = _tmp25_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp26_);
			if (_inner_error_ != NULL) {
				_g_free0 (ns);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				_g_free0 (ns);
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp28_ = _tmp27_;
			_g_free0 (predicate);
			predicate = _tmp28_;
			_g_free0 (ns);
		} else {
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			_tmp30_ = _tmp29_;
			if (_inner_error_ != NULL) {
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					goto __catch1_tracker_sparql_error;
				}
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			if (_tmp30_) {
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp31_ = tracker_sparql_pattern_get_last_string (self, 0);
				_tmp32_ = _tmp31_;
				_tmp33_ = string_substring (_tmp32_, (glong) 1, (glong) (-1));
				_tmp34_ = _tmp33_;
				_tmp35_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp34_, &_inner_error_);
				_tmp37_ = (_tmp36_ = _tmp35_, _g_free0 (_tmp34_), _g_free0 (_tmp32_), _tmp36_);
				if (_inner_error_ != NULL) {
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						goto __catch1_tracker_sparql_error;
					}
					tracker_sparql_pattern_set_location (self, &optional_start);
					_g_free0 (predicate);
					_g_object_unref0 (left_variable);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp38_ = _tmp37_;
				_g_free0 (predicate);
				predicate = _tmp38_;
			} else {
				result = FALSE;
				tracker_sparql_pattern_set_location (self, &optional_start);
				_g_free0 (predicate);
				_g_object_unref0 (left_variable);
				return result;
			}
		}
	}
	_tmp39_ = tracker_ontologies_get_property_by_uri (predicate);
	_tmp40_ = _g_object_ref0 (_tmp39_);
	prop = _tmp40_;
	if (prop == NULL) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	_tmp41_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp42_ = _tmp41_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp42_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	_tmp43_ = tracker_sparql_pattern_get_context (self);
	_tmp44_ = tracker_sparql_pattern_get_last_string (self, 0);
	_tmp45_ = _tmp44_;
	_tmp46_ = string_substring (_tmp45_, (glong) 1, (glong) (-1));
	_tmp47_ = _tmp46_;
	_tmp48_ = tracker_sparql_context_get_variable (_tmp43_, _tmp47_);
	_tmp49_ = _g_object_ref0 (_tmp48_);
	right_variable = (_tmp50_ = _tmp49_, _g_free0 (_tmp47_), _g_free0 (_tmp45_), _tmp50_);
	_tmp51_ = tracker_sparql_pattern_get_context (self);
	_tmp52_ = g_hash_table_lookup (_tmp51_->var_set, right_variable);
	right_variable_state = GPOINTER_TO_INT (_tmp52_);
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp53_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	_tmp54_ = _tmp53_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			goto __catch1_tracker_sparql_error;
		}
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (!_tmp54_) {
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_object_unref0 (right_variable);
		_g_object_unref0 (prop);
		_g_free0 (predicate);
		_g_object_unref0 (left_variable);
		return result;
	}
	if (left_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
		gboolean _tmp57_;
		_tmp57_ = tracker_property_get_multiple_values (prop);
		_tmp56_ = !_tmp57_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		_tmp55_ = right_variable_state == 0;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		gboolean in_domain;
		gconstpointer _tmp58_ = NULL;
		in_domain = FALSE;
		_tmp58_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, left_variable);
		{
			GList* binding_collection;
			GList* binding_it;
			binding_collection = ((TrackerSparqlVariableBindingList*) _tmp58_)->list;
			for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
				TrackerSparqlVariableBinding* _tmp59_;
				TrackerSparqlVariableBinding* binding;
				_tmp59_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
				binding = _tmp59_;
				{
					gboolean _tmp60_ = FALSE;
					if (binding->type != NULL) {
						TrackerClass* _tmp61_ = NULL;
						gboolean _tmp62_;
						_tmp61_ = tracker_property_get_domain (prop);
						_tmp62_ = tracker_sparql_pattern_is_subclass (self, binding->type, _tmp61_);
						_tmp60_ = _tmp62_;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						in_domain = TRUE;
						_g_object_unref0 (binding);
						break;
					}
					_g_object_unref0 (binding);
				}
			}
		}
		if (in_domain) {
			result = TRUE;
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
	} else {
		gboolean _tmp63_ = FALSE;
		gboolean _tmp64_ = FALSE;
		if (left_variable_state == 0) {
			gboolean _tmp65_;
			_tmp65_ = tracker_property_get_is_inverse_functional_property (prop);
			_tmp64_ = _tmp65_;
		} else {
			_tmp64_ = FALSE;
		}
		if (_tmp64_) {
			_tmp63_ = right_variable_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND;
		} else {
			_tmp63_ = FALSE;
		}
		if (_tmp63_) {
			result = TRUE;
			tracker_sparql_pattern_set_location (self, &optional_start);
			_g_object_unref0 (right_variable);
			_g_object_unref0 (prop);
			_g_free0 (predicate);
			_g_object_unref0 (left_variable);
			return result;
		}
	}
	result = FALSE;
	tracker_sparql_pattern_set_location (self, &optional_start);
	_g_object_unref0 (right_variable);
	_g_object_unref0 (prop);
	_g_free0 (predicate);
	_g_object_unref0 (left_variable);
	return result;
	_g_object_unref0 (right_variable);
	_g_object_unref0 (prop);
	_g_free0 (predicate);
	_g_object_unref0 (left_variable);
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		tracker_sparql_pattern_set_location (self, &optional_start);
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	tracker_sparql_pattern_set_location (self, &optional_start);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash (key);
	return result;
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal (a, b);
	return result;
}


static void _vala_array_add6 (TrackerSourceLocation** array, int* length, int* size, const TrackerSourceLocation* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSourceLocation, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlContext* _tmp10_ = NULL;
	TrackerSparqlContext* _tmp11_ = NULL;
	TrackerSparqlContext* _result_;
	TrackerSourceLocation* _tmp12_ = NULL;
	gint filters_length1;
	gint _filters_size_;
	TrackerSourceLocation* _tmp13_;
	TrackerSourceLocation* filters;
	gboolean in_triples_block;
	gboolean in_group_graph_pattern;
	gboolean first_where;
	gboolean found_simple_optional;
	glong group_graph_pattern_start;
	gboolean _tmp64_ = FALSE;
	TrackerSparqlContext* _tmp67_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_pattern_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlSelectContext* _tmp1_ = NULL;
		TrackerSparqlSelectContext* _result_;
		TrackerSparqlContext* _tmp2_ = NULL;
		TrackerSparqlContext* _tmp3_ = NULL;
		GHashTable* _tmp4_;
		GHashTable* _tmp5_;
		TrackerSparqlContext* _tmp6_ = NULL;
		GHashTable* _tmp7_ = NULL;
		GHashTable* _tmp8_;
		TrackerSparqlContext* _tmp9_ = NULL;
		_tmp1_ = tracker_sparql_pattern_translate_select (self, sql, TRUE, FALSE, &_inner_error_);
		_result_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _result_);
		_tmp2_ = tracker_sparql_pattern_get_context (self);
		_tmp3_ = tracker_sparql_pattern_get_context (self);
		_tmp4_ = _g_hash_table_ref0 (_tmp3_->select_var_set);
		_tmp5_ = _tmp4_;
		_g_hash_table_unref0 (_tmp2_->var_set);
		_tmp2_->var_set = _tmp5_;
		_tmp6_ = tracker_sparql_pattern_get_context (self);
		_tmp7_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
		_tmp8_ = _tmp7_;
		_g_hash_table_unref0 (_tmp6_->select_var_set);
		_tmp6_->select_var_set = _tmp8_;
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp9_ = tracker_sparql_pattern_get_context (self);
		tracker_sparql_pattern_set_context (self, _tmp9_->parent_context);
		result = (TrackerSparqlContext*) _result_;
		return result;
	}
	_tmp10_ = tracker_sparql_pattern_get_context (self);
	_tmp11_ = tracker_sparql_context_new (self->priv->query, _tmp10_);
	_result_ = _tmp11_;
	tracker_sparql_pattern_set_context (self, _result_);
	_tmp12_ = g_new0 (TrackerSourceLocation, 0);
	_tmp13_ = _tmp12_;
	filters_length1 = 0;
	_filters_size_ = filters_length1;
	filters = _tmp13_;
	in_triples_block = FALSE;
	in_group_graph_pattern = FALSE;
	first_where = TRUE;
	found_simple_optional = FALSE;
	group_graph_pattern_start = (glong) sql->len;
	tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
		_tmp15_ = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (_tmp15_) {
			gboolean _tmp16_ = FALSE;
			if (!in_group_graph_pattern) {
				gboolean _tmp17_;
				_tmp17_ = tracker_sparql_pattern_is_simple_optional (self);
				_tmp16_ = _tmp17_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gboolean _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_;
				found_simple_optional = TRUE;
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp19_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp18_, &_inner_error_);
				self->priv->current_subject_is_var = _tmp18_;
				_tmp20_ = _tmp19_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp21_ = _tmp20_;
				_g_free0 (self->priv->current_subject);
				self->priv->current_subject = _tmp21_;
				tracker_sparql_pattern_parse_property_list_not_empty (self, sql, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			} else {
				gboolean _tmp22_ = FALSE;
				GString* _tmp23_ = NULL;
				GString* select;
				gint left_index;
				gint right_index;
				TrackerSparqlContext* _tmp24_ = NULL;
				TrackerSparqlContext* _tmp25_;
				TrackerSparqlContext* _tmp26_;
				gboolean first;
				gboolean first_common;
				TrackerSparqlContext* _tmp27_ = NULL;
				GList* _tmp28_ = NULL;
				TrackerSparqlContext* _tmp43_ = NULL;
				GList* _tmp44_ = NULL;
				TrackerSparqlContext* _tmp48_ = NULL;
				if (!in_triples_block) {
					_tmp22_ = !in_group_graph_pattern;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					g_string_append (sql, "SELECT 1");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
				}
				if (!in_group_graph_pattern) {
					in_group_graph_pattern = TRUE;
				}
				_tmp23_ = g_string_new ("SELECT ");
				select = _tmp23_;
				self->priv->next_table_index = self->priv->next_table_index + 1;
				left_index = self->priv->next_table_index;
				self->priv->next_table_index = self->priv->next_table_index + 1;
				right_index = self->priv->next_table_index;
				g_string_append_printf (sql, ") AS t%d_g LEFT JOIN (", left_index);
				_tmp24_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
				_tmp25_ = _tmp24_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_string_free0 (select);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp26_ = _tmp25_;
				tracker_sparql_pattern_set_context (self, _tmp26_);
				_tracker_sparql_context_unref0 (_tmp26_);
				g_string_append_printf (sql, ") AS t%d_g", right_index);
				first = TRUE;
				first_common = TRUE;
				_tmp27_ = tracker_sparql_pattern_get_context (self);
				_tmp28_ = g_hash_table_get_keys (_tmp27_->var_set);
				{
					GList* v_collection;
					GList* v_it;
					v_collection = _tmp28_;
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							TrackerSparqlContext* _tmp29_ = NULL;
							gconstpointer _tmp30_ = NULL;
							gint old_state;
							if (first) {
								first = FALSE;
							} else {
								g_string_append (select, ", ");
							}
							_tmp29_ = tracker_sparql_pattern_get_context (self);
							_tmp30_ = g_hash_table_lookup (_tmp29_->parent_context->var_set, v);
							old_state = GPOINTER_TO_INT (_tmp30_);
							if (old_state == 0) {
								TrackerSparqlContext* _tmp31_ = NULL;
								TrackerSparqlVariable* _tmp32_;
								const gchar* _tmp33_ = NULL;
								_tmp31_ = tracker_sparql_pattern_get_context (self);
								_tmp32_ = _g_object_ref0 (v);
								g_hash_table_insert (_tmp31_->parent_context->var_set, _tmp32_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
								_tmp33_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (select, "t%d_g.%s", right_index, _tmp33_);
							} else {
								if (first_common) {
									g_string_append (sql, " ON ");
									first_common = FALSE;
								} else {
									g_string_append (sql, " AND ");
								}
								if (old_state == TRACKER_SPARQL_VARIABLE_STATE_BOUND) {
									const gchar* _tmp34_ = NULL;
									const gchar* _tmp35_ = NULL;
									const gchar* _tmp36_ = NULL;
									_tmp34_ = tracker_sparql_variable_get_sql_expression (v);
									_tmp35_ = tracker_sparql_variable_get_sql_expression (v);
									g_string_append_printf (sql, "t%d_g.%s = t%d_g.%s", left_index, _tmp34_, right_index, _tmp35_);
									_tmp36_ = tracker_sparql_variable_get_sql_expression (v);
									g_string_append_printf (select, "t%d_g.%s", left_index, _tmp36_);
								} else {
									if (old_state == TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL) {
										const gchar* _tmp37_ = NULL;
										const gchar* _tmp38_ = NULL;
										const gchar* _tmp39_ = NULL;
										const gchar* _tmp40_ = NULL;
										const gchar* _tmp41_ = NULL;
										const gchar* _tmp42_ = NULL;
										_tmp37_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp38_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp39_ = tracker_sparql_variable_get_sql_expression (v);
										g_string_append_printf (sql, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", left_index, _tmp37_, left_index, _tmp38_, right_index, _tmp39_);
										_tmp40_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp41_ = tracker_sparql_variable_get_sql_expression (v);
										_tmp42_ = tracker_sparql_variable_get_sql_expression (v);
										g_string_append_printf (select, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", left_index, _tmp40_, right_index, _tmp41_, _tmp42_);
									}
								}
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				_tmp43_ = tracker_sparql_pattern_get_context (self);
				_tmp44_ = g_hash_table_get_keys (_tmp43_->parent_context->var_set);
				{
					GList* v_collection;
					GList* v_it;
					v_collection = _tmp44_;
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
						TrackerSparqlVariable* v;
						v = (TrackerSparqlVariable*) v_it->data;
						{
							TrackerSparqlContext* _tmp45_ = NULL;
							gconstpointer _tmp46_ = NULL;
							_tmp45_ = tracker_sparql_pattern_get_context (self);
							_tmp46_ = g_hash_table_lookup (_tmp45_->var_set, v);
							if (GPOINTER_TO_INT (_tmp46_) == 0) {
								const gchar* _tmp47_ = NULL;
								if (first) {
									first = FALSE;
								} else {
									g_string_append (select, ", ");
								}
								_tmp47_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (select, "t%d_g.%s", left_index, _tmp47_);
							}
						}
					}
					_g_list_free0 (v_collection);
				}
				if (first) {
					g_string_append (select, "1");
				}
				_tmp48_ = tracker_sparql_pattern_get_context (self);
				tracker_sparql_pattern_set_context (self, _tmp48_->parent_context);
				g_string_append (select, " FROM (");
				g_string_insert (sql, (gssize) group_graph_pattern_start, select->str);
				g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
				g_string_append (sql, ")");
				_g_string_free0 (select);
			}
		} else {
			gboolean _tmp49_;
			gboolean _tmp50_;
			_tmp49_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
			_tmp50_ = _tmp49_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp50_) {
				gchar* _tmp51_;
				gchar* old_graph;
				gboolean old_graph_is_var;
				gboolean _tmp52_;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gboolean _tmp56_ = FALSE;
				gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp51_ = g_strdup (self->current_graph);
				old_graph = _tmp51_;
				old_graph_is_var = self->priv->current_graph_is_var;
				_tmp53_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp52_, &_inner_error_);
				self->priv->current_graph_is_var = _tmp52_;
				_tmp54_ = _tmp53_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						return NULL;
					} else {
						_g_free0 (old_graph);
						filters = (g_free (filters), NULL);
						_tracker_sparql_context_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp55_ = _tmp54_;
				_g_free0 (self->current_graph);
				self->current_graph = _tmp55_;
				if (!in_triples_block) {
					_tmp56_ = !in_group_graph_pattern;
				} else {
					_tmp56_ = FALSE;
				}
				if (_tmp56_) {
					in_group_graph_pattern = TRUE;
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				} else {
					if (in_triples_block) {
						tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								_g_free0 (old_graph);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						in_triples_block = FALSE;
					}
					if (!in_group_graph_pattern) {
						in_group_graph_pattern = TRUE;
					}
					g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
					g_string_append (sql, ") NATURAL INNER JOIN (");
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							_g_free0 (old_graph);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					g_string_append (sql, ")");
				}
				_tmp57_ = g_strdup (old_graph);
				_tmp58_ = _tmp57_;
				_g_free0 (self->current_graph);
				self->current_graph = _tmp58_;
				self->priv->current_graph_is_var = old_graph_is_var;
				_g_free0 (old_graph);
			} else {
				TrackerSparqlTokenType _tmp59_;
				_tmp59_ = tracker_sparql_pattern_current (self);
				if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
					gboolean _tmp60_ = FALSE;
					if (!in_triples_block) {
						_tmp60_ = !in_group_graph_pattern;
					} else {
						_tmp60_ = FALSE;
					}
					if (_tmp60_) {
						in_group_graph_pattern = TRUE;
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					} else {
						if (in_triples_block) {
							tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									return NULL;
								} else {
									filters = (g_free (filters), NULL);
									_tracker_sparql_context_unref0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							in_triples_block = FALSE;
						}
						if (!in_group_graph_pattern) {
							in_group_graph_pattern = TRUE;
						}
						g_string_insert (sql, (gssize) group_graph_pattern_start, "SELECT * FROM (");
						g_string_append (sql, ") NATURAL INNER JOIN (");
						tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						g_string_append (sql, ")");
					}
				} else {
					TrackerSparqlTokenType _tmp61_;
					_tmp61_ = tracker_sparql_pattern_current (self);
					if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
						TrackerSourceLocation _tmp62_ = {0};
						TrackerSourceLocation _tmp63_ = {0};
						_tmp63_ = (tracker_sparql_pattern_get_location (self, &_tmp62_), _tmp62_);
						_vala_array_add6 (&filters, &filters_length1, &_filters_size_, &_tmp63_);
						tracker_sparql_pattern_skip_filter (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								return NULL;
							} else {
								filters = (g_free (filters), NULL);
								_tracker_sparql_context_unref0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					} else {
						break;
					}
				}
			}
		}
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_pattern_parse_triples (self, sql, group_graph_pattern_start, &in_triples_block, &first_where, &in_group_graph_pattern, found_simple_optional, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				return NULL;
			} else {
				filters = (g_free (filters), NULL);
				_tracker_sparql_context_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			return NULL;
		} else {
			filters = (g_free (filters), NULL);
			_tracker_sparql_context_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!in_triples_block) {
		_tmp64_ = !in_group_graph_pattern;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		g_string_append (sql, "SELECT 1");
	} else {
		if (in_triples_block) {
			tracker_sparql_pattern_end_triples_block (self, sql, &first_where, in_group_graph_pattern, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					return NULL;
				} else {
					filters = (g_free (filters), NULL);
					_tracker_sparql_context_unref0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			in_triples_block = FALSE;
		}
	}
	if (in_group_graph_pattern) {
		first_where = TRUE;
	}
	if (filters_length1 > 0) {
		TrackerSourceLocation _tmp65_ = {0};
		TrackerSourceLocation _tmp66_ = {0};
		TrackerSourceLocation end;
		_tmp66_ = (tracker_sparql_pattern_get_location (self, &_tmp65_), _tmp65_);
		end = _tmp66_;
		{
			TrackerSourceLocation* filter_location_collection;
			int filter_location_collection_length1;
			int filter_location_it;
			filter_location_collection = filters;
			filter_location_collection_length1 = filters_length1;
			for (filter_location_it = 0; filter_location_it < filters_length1; filter_location_it = filter_location_it + 1) {
				TrackerSourceLocation filter_location;
				filter_location = filter_location_collection[filter_location_it];
				{
					if (!first_where) {
						g_string_append (sql, " AND ");
					} else {
						g_string_append (sql, " WHERE ");
						first_where = FALSE;
					}
					tracker_sparql_pattern_set_location (self, &filter_location);
					tracker_sparql_pattern_translate_filter (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							return NULL;
						} else {
							filters = (g_free (filters), NULL);
							_tracker_sparql_context_unref0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
			}
		}
		tracker_sparql_pattern_set_location (self, &end);
	}
	_tmp67_ = tracker_sparql_pattern_get_context (self);
	tracker_sparql_pattern_set_context (self, _tmp67_->parent_context);
	result = _result_;
	filters = (g_free (filters), NULL);
	return result;
}


static void _vala_array_add7 (glong** array, int* length, int* size, glong value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (glong, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add8 (TrackerSparqlContext*** array, int* length, int* size, TrackerSparqlContext* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
	return self ? tracker_sparql_context_ref (self) : NULL;
}


static void _vala_array_add9 (TrackerSparqlVariable*** array, int* length, int* size, TrackerSparqlVariable* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlVariable** _tmp0_ = NULL;
	gint all_vars_length1;
	gint _all_vars_size_;
	TrackerSparqlVariable** _tmp1_;
	TrackerSparqlVariable** all_vars;
	GHashTable* _tmp2_ = NULL;
	GHashTable* all_var_set;
	TrackerSparqlContext** _tmp3_ = NULL;
	gint contexts_length1;
	gint _contexts_size_;
	TrackerSparqlContext** _tmp4_;
	TrackerSparqlContext** contexts;
	glong* _tmp5_ = NULL;
	gint offsets_length1;
	gint _offsets_size_;
	glong* _tmp6_;
	glong* offsets;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1);
	_tmp1_ = _tmp0_;
	all_vars_length1 = 0;
	_all_vars_size_ = all_vars_length1;
	all_vars = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, NULL);
	all_var_set = _tmp2_;
	_tmp3_ = g_new0 (TrackerSparqlContext*, 0 + 1);
	_tmp4_ = _tmp3_;
	contexts_length1 = 0;
	_contexts_size_ = contexts_length1;
	contexts = _tmp4_;
	_tmp5_ = g_new0 (glong, 0);
	_tmp6_ = _tmp5_;
	offsets_length1 = 0;
	_offsets_size_ = offsets_length1;
	offsets = _tmp6_;
	{
		gboolean _tmp7_;
		_tmp7_ = TRUE;
		while (TRUE) {
			TrackerSparqlContext* _tmp10_ = NULL;
			TrackerSparqlContext* _tmp11_;
			if (!_tmp7_) {
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp8_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
				_tmp9_ = _tmp8_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						return;
					} else {
						offsets = (g_free (offsets), NULL);
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
						_g_hash_table_unref0 (all_var_set);
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp9_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_vala_array_add7 (&offsets, &offsets_length1, &_offsets_size_, (glong) sql->len);
			_tmp10_ = tracker_sparql_pattern_translate_group_graph_pattern (self, sql, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					return;
				} else {
					offsets = (g_free (offsets), NULL);
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
					_g_hash_table_unref0 (all_var_set);
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_vala_array_add8 (&contexts, &contexts_length1, &_contexts_size_, _tmp11_);
		}
	}
	if (contexts_length1 > 1) {
		glong extra_offset;
		{
			TrackerSparqlContext** sub_context_collection;
			int sub_context_collection_length1;
			int sub_context_it;
			sub_context_collection = contexts;
			sub_context_collection_length1 = contexts_length1;
			for (sub_context_it = 0; sub_context_it < contexts_length1; sub_context_it = sub_context_it + 1) {
				TrackerSparqlContext* _tmp12_;
				TrackerSparqlContext* sub_context;
				_tmp12_ = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
				sub_context = _tmp12_;
				{
					GList* _tmp13_ = NULL;
					_tmp13_ = g_hash_table_get_keys (sub_context->var_set);
					{
						GList* v_collection;
						GList* v_it;
						v_collection = _tmp13_;
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
							TrackerSparqlVariable* v;
							v = (TrackerSparqlVariable*) v_it->data;
							{
								gconstpointer _tmp14_ = NULL;
								_tmp14_ = g_hash_table_lookup (all_var_set, v);
								if (GPOINTER_TO_INT (_tmp14_) == 0) {
									TrackerSparqlVariable* _tmp15_;
									TrackerSparqlVariable* _tmp16_;
									TrackerSparqlContext* _tmp17_ = NULL;
									TrackerSparqlVariable* _tmp18_;
									_tmp15_ = _g_object_ref0 (v);
									_vala_array_add9 (&all_vars, &all_vars_length1, &_all_vars_size_, _tmp15_);
									_tmp16_ = _g_object_ref0 (v);
									g_hash_table_insert (all_var_set, _tmp16_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
									_tmp17_ = tracker_sparql_pattern_get_context (self);
									_tmp18_ = _g_object_ref0 (v);
									g_hash_table_insert (_tmp17_->var_set, _tmp18_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
								}
							}
						}
						_g_list_free0 (v_collection);
					}
					_tracker_sparql_context_unref0 (sub_context);
				}
			}
		}
		extra_offset = (glong) 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					GString* _tmp20_ = NULL;
					GString* projection;
					if (!_tmp19_) {
						i++;
					}
					_tmp19_ = FALSE;
					if (!(i < contexts_length1)) {
						break;
					}
					_tmp20_ = g_string_new ("");
					projection = _tmp20_;
					if (i > 0) {
						g_string_append (projection, ") UNION ALL ");
					}
					g_string_append (projection, "SELECT ");
					{
						TrackerSparqlVariable** v_collection;
						int v_collection_length1;
						int v_it;
						v_collection = all_vars;
						v_collection_length1 = all_vars_length1;
						for (v_it = 0; v_it < all_vars_length1; v_it = v_it + 1) {
							TrackerSparqlVariable* _tmp21_;
							TrackerSparqlVariable* v;
							_tmp21_ = _g_object_ref0 (v_collection[v_it]);
							v = _tmp21_;
							{
								gconstpointer _tmp22_ = NULL;
								const gchar* _tmp23_ = NULL;
								_tmp22_ = g_hash_table_lookup (contexts[i]->var_set, v);
								if (GPOINTER_TO_INT (_tmp22_) == 0) {
									g_string_append (projection, "NULL AS ");
								}
								_tmp23_ = tracker_sparql_variable_get_sql_expression (v);
								g_string_append_printf (projection, "%s, ", _tmp23_);
								_g_object_unref0 (v);
							}
						}
					}
					g_string_truncate (projection, (gsize) (projection->len - 2));
					g_string_append (projection, " FROM (");
					g_string_insert (sql, (gssize) (offsets[i] + extra_offset), projection->str);
					extra_offset = extra_offset + ((glong) projection->len);
					_g_string_free0 (projection);
				}
			}
		}
		g_string_append (sql, ")");
	} else {
		GList* _tmp24_ = NULL;
		_tmp24_ = g_hash_table_get_keys (contexts[0]->var_set);
		{
			GList* key_collection;
			GList* key_it;
			key_collection = _tmp24_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				TrackerSparqlVariable* key;
				key = (TrackerSparqlVariable*) key_it->data;
				{
					TrackerSparqlContext* _tmp25_ = NULL;
					TrackerSparqlVariable* _tmp26_;
					_tmp25_ = tracker_sparql_pattern_get_context (self);
					_tmp26_ = _g_object_ref0 (key);
					g_hash_table_insert (_tmp25_->var_set, _tmp26_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				}
			}
			_g_list_free0 (key_collection);
		}
	}
	offsets = (g_free (offsets), NULL);
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
	_g_hash_table_unref0 (all_var_set);
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	binding_list = NULL;
	if (self->priv->triple_context != NULL) {
		gconstpointer _tmp0_ = NULL;
		TrackerSparqlVariableBindingList* _tmp1_;
		TrackerSparqlVariableBindingList* _tmp2_;
		_tmp0_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, variable);
		_tmp1_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (binding_list);
		binding_list = _tmp2_;
	}
	if (binding_list == NULL) {
		_tmp3_ = variable->binding != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TrackerSparqlContext* _tmp4_ = NULL;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* current_context;
		_tmp4_ = tracker_sparql_pattern_get_context (self);
		_tmp5_ = _tracker_sparql_context_ref0 (_tmp4_);
		current_context = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			TrackerSparqlContext* _tmp23_;
			TrackerSparqlContext* _tmp24_;
			if (!(current_context != NULL)) {
				break;
			}
			if (current_context->scalar_subquery) {
				gconstpointer _tmp7_ = NULL;
				_tmp7_ = g_hash_table_lookup (current_context->parent_context->var_set, variable);
				_tmp6_ = GPOINTER_TO_INT (_tmp7_) != 0;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				TrackerSparqlVariableBinding* _tmp8_ = NULL;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlContext* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				TrackerSparqlVariable* _tmp11_ = NULL;
				TrackerClass* _tmp12_;
				TrackerClass* _tmp13_;
				const gchar* _tmp14_ = NULL;
				TrackerSparqlVariableBindingList* _tmp15_ = NULL;
				TrackerSparqlVariableBindingList* _tmp16_;
				TrackerSparqlContext* _tmp20_ = NULL;
				TrackerSparqlVariable* _tmp21_;
				TrackerSparqlVariableBinding* _tmp22_;
				_tmp8_ = tracker_sparql_variable_binding_new ();
				binding = _tmp8_;
				((TrackerSparqlDataBinding*) binding)->data_type = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				_tmp9_ = tracker_sparql_pattern_get_context (self);
				_tmp10_ = tracker_sparql_variable_get_name (variable);
				_tmp11_ = tracker_sparql_context_get_variable (_tmp9_, _tmp10_);
				binding->variable = _tmp11_;
				_tmp12_ = _g_object_ref0 (variable->binding->type);
				_tmp13_ = _tmp12_;
				_g_object_unref0 (binding->type);
				binding->type = _tmp13_;
				_tmp14_ = tracker_sparql_variable_get_sql_expression (variable);
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, _tmp14_);
				_tmp15_ = tracker_sparql_variable_binding_list_new ();
				_tmp16_ = _tmp15_;
				_g_object_unref0 (binding_list);
				binding_list = _tmp16_;
				if (self->priv->triple_context != NULL) {
					TrackerSparqlVariable* _tmp17_;
					TrackerSparqlVariable* _tmp18_;
					TrackerSparqlVariableBindingList* _tmp19_;
					_tmp17_ = _g_object_ref0 (variable);
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp17_);
					_tmp18_ = _g_object_ref0 (variable);
					_tmp19_ = _g_object_ref0 (binding_list);
					g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp18_, _tmp19_);
				}
				_tmp20_ = tracker_sparql_pattern_get_context (self);
				_tmp21_ = _g_object_ref0 (variable);
				g_hash_table_insert (_tmp20_->var_set, _tmp21_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND));
				_tmp22_ = _g_object_ref0 (binding);
				binding_list->list = g_list_append (binding_list->list, _tmp22_);
				_g_object_unref0 (binding);
				break;
			}
			_tmp23_ = _tracker_sparql_context_ref0 (current_context->parent_context);
			_tmp24_ = _tmp23_;
			_tracker_sparql_context_unref0 (current_context);
			current_context = _tmp24_;
		}
		_tracker_sparql_context_unref0 (current_context);
	}
	result = binding_list;
	return result;
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBindingList* _tmp0_ = NULL;
	TrackerSparqlVariableBindingList* binding_list;
	TrackerSparqlVariableBinding* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = tracker_sparql_pattern_get_variable_binding_list (self, binding->variable);
	binding_list = _tmp0_;
	if (binding_list == NULL) {
		TrackerSparqlVariableBindingList* _tmp1_ = NULL;
		TrackerSparqlVariableBindingList* _tmp2_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		TrackerSparqlContext* _tmp16_ = NULL;
		TrackerSparqlVariable* _tmp17_;
		_tmp1_ = tracker_sparql_variable_binding_list_new ();
		_tmp2_ = _tmp1_;
		_g_object_unref0 (binding_list);
		binding_list = _tmp2_;
		if (self->priv->triple_context != NULL) {
			TrackerSparqlVariable* _tmp3_;
			TrackerSparqlVariable* _tmp4_;
			TrackerSparqlVariableBindingList* _tmp5_;
			_tmp3_ = _g_object_ref0 (binding->variable);
			self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp3_);
			_tmp4_ = _g_object_ref0 (binding->variable);
			_tmp5_ = _g_object_ref0 (binding_list);
			g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp4_, _tmp5_);
		}
		_tmp6_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) binding);
		_tmp7_ = tracker_sparql_variable_get_sql_expression (binding->variable);
		g_string_append_printf (sql, "%s AS %s, ", _tmp6_, _tmp7_);
		if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp8_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localDate");
			_tmp9_ = _tmp8_;
			_tmp10_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localDate");
			_tmp11_ = _tmp10_;
			g_string_append_printf (sql, "%s AS %s, ", _tmp9_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_tmp12_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) binding, "localTime");
			_tmp13_ = _tmp12_;
			_tmp14_ = tracker_sparql_variable_get_extra_sql_expression (binding->variable, "localTime");
			_tmp15_ = _tmp14_;
			g_string_append_printf (sql, "%s AS %s, ", _tmp13_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		}
		_tmp16_ = tracker_sparql_pattern_get_context (self);
		_tmp17_ = _g_object_ref0 (binding->variable);
		g_hash_table_insert (_tmp16_->var_set, _tmp17_, GINT_TO_POINTER ((gint) variable_state));
	}
	_tmp18_ = _g_object_ref0 (binding);
	binding_list->list = g_list_append (binding_list->list, _tmp18_);
	if (binding->variable->binding == NULL) {
		TrackerSparqlVariableBinding* _tmp19_;
		TrackerSparqlVariableBinding* _tmp20_;
		_tmp19_ = _g_object_ref0 (binding);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (binding->variable->binding);
		binding->variable->binding = _tmp20_;
	}
	_g_object_unref0 (binding_list);
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	glong begin_sql_len;
	gboolean object_is_var = FALSE;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* object;
	gchar* db_table;
	gboolean rdftype;
	gboolean share_table;
	gboolean is_fts_match;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table;
	TrackerProperty* prop;
	TrackerClass* subject_type;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	begin_sql_len = (glong) sql->len;
	_tmp1_ = tracker_sparql_pattern_parse_var_or_term (self, sql, &_tmp0_, &_inner_error_);
	object_is_var = _tmp0_;
	object = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	db_table = NULL;
	rdftype = FALSE;
	share_table = TRUE;
	is_fts_match = FALSE;
	table = NULL;
	prop = NULL;
	subject_type = NULL;
	if (!self->priv->current_predicate_is_var) {
		TrackerProperty* _tmp2_ = NULL;
		TrackerProperty* _tmp3_;
		TrackerProperty* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp91_;
		TrackerSparqlDataTable* _tmp92_ = NULL;
		TrackerSparqlDataTable* _tmp93_;
		_tmp2_ = tracker_ontologies_get_property_by_uri (self->priv->current_predicate);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (prop);
		prop = _tmp4_;
		if (g_strcmp0 (self->priv->current_predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
			_tmp6_ = !object_is_var;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = self->current_graph == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			TrackerClass* _tmp7_ = NULL;
			TrackerClass* _tmp8_;
			TrackerClass* cl;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			TrackerClass* _tmp16_;
			TrackerClass* _tmp17_;
			rdftype = TRUE;
			_tmp7_ = tracker_ontologies_get_class_by_uri (object);
			_tmp8_ = _g_object_ref0 (_tmp7_);
			cl = _tmp8_;
			if (cl == NULL) {
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				GError* _tmp11_ = NULL;
				GError* _tmp12_;
				_tmp9_ = g_strdup_printf ("Unknown class `%s'", object);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp10_);
				_inner_error_ = (_tmp12_ = _tmp11_, _g_free0 (_tmp10_), _tmp12_);
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (cl);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					return;
				} else {
					_g_object_unref0 (cl);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp13_ = tracker_class_get_name (cl);
			_tmp14_ = g_strdup (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (db_table);
			db_table = _tmp15_;
			_tmp16_ = _g_object_ref0 (cl);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (subject_type);
			subject_type = _tmp17_;
			_g_object_unref0 (cl);
		} else {
			if (prop == NULL) {
				if (g_strcmp0 (self->priv->current_predicate, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = g_strdup ("fts");
					_tmp19_ = _tmp18_;
					_g_free0 (db_table);
					db_table = _tmp19_;
					share_table = FALSE;
					is_fts_match = TRUE;
				} else {
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					GError* _tmp22_ = NULL;
					GError* _tmp23_;
					_tmp20_ = g_strdup_printf ("Unknown property `%s'", self->priv->current_predicate);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp21_);
					_inner_error_ = (_tmp23_ = _tmp22_, _g_free0 (_tmp21_), _tmp23_);
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						return;
					} else {
						_g_object_unref0 (subject_type);
						_g_object_unref0 (prop);
						_g_object_unref0 (table);
						_g_free0 (db_table);
						_g_free0 (object);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp62_;
				TrackerClass* _tmp63_ = NULL;
				TrackerClass* _tmp64_;
				TrackerClass* _tmp65_;
				gboolean _tmp66_ = FALSE;
				if (g_strcmp0 (self->priv->current_predicate, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
					_tmp25_ = self->priv->current_subject_is_var;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					_tmp24_ = !object_is_var;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					TrackerClass* _tmp26_ = NULL;
					TrackerClass* _tmp27_;
					TrackerClass* domain;
					TrackerSparqlContext* _tmp32_ = NULL;
					TrackerSparqlContext* _tmp33_ = NULL;
					TrackerSparqlVariable* _tmp34_ = NULL;
					gconstpointer _tmp35_ = NULL;
					TrackerSparqlPredicateVariable* _tmp36_;
					TrackerSparqlPredicateVariable* pv;
					TrackerClass* _tmp44_;
					TrackerClass* _tmp45_;
					_tmp26_ = tracker_ontologies_get_class_by_uri (object);
					_tmp27_ = _g_object_ref0 (_tmp26_);
					domain = _tmp27_;
					if (domain == NULL) {
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						GError* _tmp30_ = NULL;
						GError* _tmp31_;
						_tmp28_ = g_strdup_printf ("Unknown class `%s'", object);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp29_);
						_inner_error_ = (_tmp31_ = _tmp30_, _g_free0 (_tmp29_), _tmp31_);
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (domain);
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							return;
						} else {
							_g_object_unref0 (domain);
							_g_object_unref0 (subject_type);
							_g_object_unref0 (prop);
							_g_object_unref0 (table);
							_g_free0 (db_table);
							_g_free0 (object);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp32_ = tracker_sparql_pattern_get_context (self);
					_tmp33_ = tracker_sparql_pattern_get_context (self);
					_tmp34_ = tracker_sparql_context_get_variable (_tmp33_, self->priv->current_subject);
					_tmp35_ = g_hash_table_lookup (_tmp32_->predicate_variable_map, _tmp34_);
					_tmp36_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp35_);
					pv = _tmp36_;
					if (pv == NULL) {
						TrackerSparqlPredicateVariable* _tmp37_ = NULL;
						TrackerSparqlPredicateVariable* _tmp38_;
						TrackerSparqlContext* _tmp39_ = NULL;
						TrackerSparqlContext* _tmp40_ = NULL;
						TrackerSparqlVariable* _tmp41_ = NULL;
						TrackerSparqlVariable* _tmp42_;
						TrackerSparqlPredicateVariable* _tmp43_;
						_tmp37_ = tracker_sparql_predicate_variable_new ();
						_tmp38_ = _tmp37_;
						_g_object_unref0 (pv);
						pv = _tmp38_;
						_tmp39_ = tracker_sparql_pattern_get_context (self);
						_tmp40_ = tracker_sparql_pattern_get_context (self);
						_tmp41_ = tracker_sparql_context_get_variable (_tmp40_, self->priv->current_subject);
						_tmp42_ = _g_object_ref0 (_tmp41_);
						_tmp43_ = _g_object_ref0 (pv);
						g_hash_table_insert (_tmp39_->predicate_variable_map, _tmp42_, _tmp43_);
					}
					_tmp44_ = _g_object_ref0 (domain);
					_tmp45_ = _tmp44_;
					_g_object_unref0 (pv->domain);
					pv->domain = _tmp45_;
					_g_object_unref0 (pv);
					_g_object_unref0 (domain);
				}
				if (self->priv->current_subject_is_var) {
					TrackerSparqlContext* _tmp46_ = NULL;
					TrackerSparqlVariable* _tmp47_ = NULL;
					TrackerSparqlVariable* _tmp48_;
					TrackerSparqlVariable* v;
					gconstpointer _tmp49_ = NULL;
					TrackerSparqlVariableBindingList* _tmp50_;
					TrackerSparqlVariableBindingList* list;
					gboolean _tmp51_ = FALSE;
					_tmp46_ = tracker_sparql_pattern_get_context (self);
					_tmp47_ = tracker_sparql_context_get_variable (_tmp46_, self->priv->current_subject);
					_tmp48_ = _g_object_ref0 (_tmp47_);
					v = _tmp48_;
					_tmp49_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, v);
					_tmp50_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp49_);
					list = _tmp50_;
					if (list != NULL) {
						_tmp51_ = list->list != NULL;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						gboolean stop;
						TrackerClass** _tmp52_;
						TrackerClass** _tmp53_ = NULL;
						stop = FALSE;
						_tmp53_ = _tmp52_ = tracker_property_get_domain_indexes (prop);
						{
							TrackerClass** cl_collection;
							int cl_collection_length1;
							int cl_it;
							cl_collection = _tmp53_;
							cl_collection_length1 = _vala_array_length (_tmp52_);
							for (cl_it = 0; cl_it < _vala_array_length (_tmp52_); cl_it = cl_it + 1) {
								TrackerClass* _tmp54_;
								TrackerClass* cl;
								_tmp54_ = _g_object_ref0 (cl_collection[cl_it]);
								cl = _tmp54_;
								{
									{
										GList* b_collection;
										GList* b_it;
										b_collection = list->list;
										for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
											TrackerSparqlVariableBinding* _tmp55_;
											TrackerSparqlVariableBinding* b;
											_tmp55_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) b_it->data);
											b = _tmp55_;
											{
												if (b->type == cl) {
													const gchar* _tmp56_ = NULL;
													gchar* _tmp57_;
													gchar* _tmp58_;
													_tmp56_ = tracker_class_get_name (cl);
													_tmp57_ = g_strdup (_tmp56_);
													_tmp58_ = _tmp57_;
													_g_free0 (db_table);
													db_table = _tmp58_;
													stop = TRUE;
													_g_object_unref0 (b);
													break;
												}
												_g_object_unref0 (b);
											}
										}
									}
									if (stop) {
										_g_object_unref0 (cl);
										break;
									}
									_g_object_unref0 (cl);
								}
							}
						}
					}
					_g_object_unref0 (list);
					_g_object_unref0 (v);
				}
				if (db_table == NULL) {
					const gchar* _tmp59_ = NULL;
					gchar* _tmp60_;
					gchar* _tmp61_;
					_tmp59_ = tracker_property_get_table_name (prop);
					_tmp60_ = g_strdup (_tmp59_);
					_tmp61_ = _tmp60_;
					_g_free0 (db_table);
					db_table = _tmp61_;
				}
				_tmp62_ = tracker_property_get_multiple_values (prop);
				if (_tmp62_) {
					share_table = FALSE;
				}
				_tmp63_ = tracker_property_get_domain (prop);
				_tmp64_ = _g_object_ref0 (_tmp63_);
				_tmp65_ = _tmp64_;
				_g_object_unref0 (subject_type);
				subject_type = _tmp65_;
				if (in_simple_optional) {
					TrackerSparqlContext* _tmp67_ = NULL;
					TrackerSparqlContext* _tmp68_ = NULL;
					TrackerSparqlVariable* _tmp69_ = NULL;
					gconstpointer _tmp70_ = NULL;
					_tmp67_ = tracker_sparql_pattern_get_context (self);
					_tmp68_ = tracker_sparql_pattern_get_context (self);
					_tmp69_ = tracker_sparql_context_get_variable (_tmp68_, self->priv->current_subject);
					_tmp70_ = g_hash_table_lookup (_tmp67_->var_set, _tmp69_);
					_tmp66_ = GPOINTER_TO_INT (_tmp70_) == 0;
				} else {
					_tmp66_ = FALSE;
				}
				if (_tmp66_) {
					TrackerSparqlVariableBinding* _tmp71_ = NULL;
					TrackerSparqlVariableBinding* binding;
					TrackerSparqlContext* _tmp72_ = NULL;
					TrackerSparqlVariable* _tmp73_ = NULL;
					gconstpointer _tmp74_ = NULL;
					TrackerSparqlVariableBindingList* _tmp75_ = NULL;
					TrackerSparqlVariableBindingList* binding_list;
					TrackerSparqlVariable* _tmp76_;
					TrackerSparqlVariable* _tmp77_;
					TrackerSparqlVariableBindingList* _tmp78_;
					TrackerSparqlContext* _tmp79_ = NULL;
					TrackerSparqlVariable* _tmp80_ = NULL;
					gconstpointer _tmp81_ = NULL;
					TrackerSparqlVariableBinding* _tmp82_;
					TrackerSparqlVariableBinding* object_binding;
					const gchar* _tmp83_ = NULL;
					const gchar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					TrackerSparqlContext* _tmp86_ = NULL;
					TrackerSparqlVariable* _tmp87_;
					TrackerSparqlVariableBinding* _tmp88_;
					TrackerSparqlVariableBinding* _tmp89_;
					TrackerSparqlVariableBinding* _tmp90_;
					_tmp71_ = tracker_sparql_variable_binding_new ();
					binding = _tmp71_;
					((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
					_tmp72_ = tracker_sparql_pattern_get_context (self);
					_tmp73_ = tracker_sparql_context_get_variable (_tmp72_, self->priv->current_subject);
					binding->variable = _tmp73_;
					_tmp74_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, binding->variable);
					g_assert (((TrackerSparqlVariableBindingList*) _tmp74_) == NULL);
					_tmp75_ = tracker_sparql_variable_binding_list_new ();
					binding_list = _tmp75_;
					_tmp76_ = _g_object_ref0 (binding->variable);
					self->priv->triple_context->variables = g_list_append (self->priv->triple_context->variables, _tmp76_);
					_tmp77_ = _g_object_ref0 (binding->variable);
					_tmp78_ = _g_object_ref0 (binding_list);
					g_hash_table_insert (self->priv->triple_context->var_bindings, _tmp77_, _tmp78_);
					_tmp79_ = tracker_sparql_pattern_get_context (self);
					_tmp80_ = tracker_sparql_context_get_variable (_tmp79_, object);
					_tmp81_ = g_hash_table_lookup (self->priv->triple_context->var_bindings, _tmp80_);
					_tmp82_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) ((TrackerSparqlVariableBindingList*) _tmp81_)->list->data);
					object_binding = _tmp82_;
					_tmp83_ = tracker_property_get_name (prop);
					_tmp84_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) object_binding);
					_tmp85_ = tracker_sparql_variable_get_sql_expression (binding->variable);
					g_string_append_printf (sql, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", db_table, _tmp83_, _tmp84_, _tmp85_);
					_tmp86_ = tracker_sparql_pattern_get_context (self);
					_tmp87_ = _g_object_ref0 (binding->variable);
					g_hash_table_insert (_tmp86_->var_set, _tmp87_, GINT_TO_POINTER ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL));
					_tmp88_ = _g_object_ref0 (binding);
					binding_list->list = g_list_append (binding_list->list, _tmp88_);
					g_assert (binding->variable->binding == NULL);
					_tmp89_ = _g_object_ref0 (binding);
					_tmp90_ = _tmp89_;
					_g_object_unref0 (binding->variable->binding);
					binding->variable->binding = _tmp90_;
					_g_object_unref0 (object_binding);
					_g_object_unref0 (binding_list);
					_g_object_unref0 (binding);
					_g_object_unref0 (subject_type);
					_g_object_unref0 (prop);
					_g_object_unref0 (table);
					_g_free0 (db_table);
					_g_free0 (object);
					return;
				}
			}
		}
		_tmp92_ = tracker_sparql_pattern_get_table (self, self->priv->current_subject, db_table, share_table, &_tmp91_);
		newtable = _tmp91_;
		_tmp93_ = _tmp92_;
		_g_object_unref0 (table);
		table = _tmp93_;
	} else {
		TrackerSparqlDataTable* _tmp94_ = NULL;
		TrackerSparqlDataTable* _tmp95_;
		TrackerSparqlContext* _tmp96_ = NULL;
		TrackerSparqlContext* _tmp97_ = NULL;
		TrackerSparqlVariable* _tmp98_ = NULL;
		gconstpointer _tmp99_ = NULL;
		TrackerSparqlPredicateVariable* _tmp100_;
		TrackerSparqlPredicateVariable* _tmp101_;
		gchar* _tmp113_ = NULL;
		gchar* _tmp114_;
		gchar* _tmp115_;
		TrackerSparqlDataTable* _tmp116_;
		TrackerSparqlVariableBinding* _tmp117_ = NULL;
		TrackerSparqlVariableBinding* binding;
		TrackerSparqlContext* _tmp118_ = NULL;
		TrackerSparqlVariable* _tmp119_ = NULL;
		TrackerSparqlDataTable* _tmp120_;
		TrackerSparqlDataTable* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		newtable = TRUE;
		_tmp94_ = tracker_sparql_data_table_new ();
		_tmp95_ = _tmp94_;
		_g_object_unref0 (table);
		table = _tmp95_;
		_tmp96_ = tracker_sparql_pattern_get_context (self);
		_tmp97_ = tracker_sparql_pattern_get_context (self);
		_tmp98_ = tracker_sparql_context_get_variable (_tmp97_, self->priv->current_predicate);
		_tmp99_ = g_hash_table_lookup (_tmp96_->predicate_variable_map, _tmp98_);
		_tmp100_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp99_);
		_tmp101_ = _tmp100_;
		_g_object_unref0 (table->predicate_variable);
		table->predicate_variable = _tmp101_;
		if (table->predicate_variable == NULL) {
			TrackerSparqlPredicateVariable* _tmp102_ = NULL;
			TrackerSparqlPredicateVariable* _tmp103_;
			TrackerSparqlContext* _tmp104_ = NULL;
			TrackerSparqlContext* _tmp105_ = NULL;
			TrackerSparqlVariable* _tmp106_ = NULL;
			TrackerSparqlVariable* _tmp107_;
			TrackerSparqlPredicateVariable* _tmp108_;
			_tmp102_ = tracker_sparql_predicate_variable_new ();
			_tmp103_ = _tmp102_;
			_g_object_unref0 (table->predicate_variable);
			table->predicate_variable = _tmp103_;
			_tmp104_ = tracker_sparql_pattern_get_context (self);
			_tmp105_ = tracker_sparql_pattern_get_context (self);
			_tmp106_ = tracker_sparql_context_get_variable (_tmp105_, self->priv->current_predicate);
			_tmp107_ = _g_object_ref0 (_tmp106_);
			_tmp108_ = _g_object_ref0 (table->predicate_variable);
			g_hash_table_insert (_tmp104_->predicate_variable_map, _tmp107_, _tmp108_);
		}
		if (!self->priv->current_subject_is_var) {
			gchar* _tmp109_;
			gchar* _tmp110_;
			_tmp109_ = g_strdup (self->priv->current_subject);
			_tmp110_ = _tmp109_;
			_g_free0 (table->predicate_variable->subject);
			table->predicate_variable->subject = _tmp110_;
		}
		if (!object_is_var) {
			gchar* _tmp111_;
			gchar* _tmp112_;
			_tmp111_ = g_strdup (object);
			_tmp112_ = _tmp111_;
			_g_free0 (table->predicate_variable->object);
			table->predicate_variable->object = _tmp112_;
		}
		if (self->current_graph != NULL) {
			table->predicate_variable->return_graph = TRUE;
		}
		self->priv->counter = self->priv->counter + 1;
		_tmp113_ = g_strdup_printf ("%i", self->priv->counter);
		_tmp114_ = _tmp113_;
		_tmp115_ = g_strconcat (self->priv->current_predicate, _tmp114_, NULL);
		_g_free0 (table->sql_query_tablename);
		table->sql_query_tablename = _tmp115_;
		_g_free0 (_tmp114_);
		_tmp116_ = _g_object_ref0 (table);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _tmp116_);
		_tmp117_ = tracker_sparql_variable_binding_new ();
		binding = _tmp117_;
		((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
		_tmp118_ = tracker_sparql_pattern_get_context (self);
		_tmp119_ = tracker_sparql_context_get_variable (_tmp118_, self->priv->current_predicate);
		binding->variable = _tmp119_;
		_tmp120_ = _g_object_ref0 (table);
		_tmp121_ = _tmp120_;
		_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
		((TrackerSparqlDataBinding*) binding)->table = _tmp121_;
		_tmp122_ = g_strdup ("predicate");
		_tmp123_ = _tmp122_;
		_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
		((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp123_;
		tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
		_g_object_unref0 (binding);
	}
	if (newtable) {
		if (self->priv->current_subject_is_var) {
			TrackerSparqlVariableBinding* _tmp124_ = NULL;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlContext* _tmp125_ = NULL;
			TrackerSparqlVariable* _tmp126_ = NULL;
			TrackerSparqlDataTable* _tmp127_;
			TrackerSparqlDataTable* _tmp128_;
			TrackerClass* _tmp129_;
			TrackerClass* _tmp130_;
			_tmp124_ = tracker_sparql_variable_binding_new ();
			binding = _tmp124_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			_tmp125_ = tracker_sparql_pattern_get_context (self);
			_tmp126_ = tracker_sparql_context_get_variable (_tmp125_, self->priv->current_subject);
			binding->variable = _tmp126_;
			_tmp127_ = _g_object_ref0 (table);
			_tmp128_ = _tmp127_;
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp128_;
			_tmp129_ = _g_object_ref0 (subject_type);
			_tmp130_ = _tmp129_;
			_g_object_unref0 (binding->type);
			binding->type = _tmp130_;
			if (is_fts_match) {
				gchar* _tmp131_;
				gchar* _tmp132_;
				_tmp131_ = g_strdup ("rowid");
				_tmp132_ = _tmp131_;
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp132_;
			} else {
				gchar* _tmp133_;
				gchar* _tmp134_;
				_tmp133_ = g_strdup ("ID");
				_tmp134_ = _tmp133_;
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp134_;
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_object_unref0 (binding);
		} else {
			TrackerSparqlLiteralBinding* _tmp135_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp136_;
			gchar* _tmp137_;
			TrackerSparqlDataTable* _tmp138_;
			TrackerSparqlDataTable* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			TrackerSparqlLiteralBinding* _tmp142_;
			_tmp135_ = tracker_sparql_literal_binding_new ();
			binding = _tmp135_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
			_tmp136_ = g_strdup (self->priv->current_subject);
			_tmp137_ = _tmp136_;
			_g_free0 (binding->literal);
			binding->literal = _tmp137_;
			_tmp138_ = _g_object_ref0 (table);
			_tmp139_ = _tmp138_;
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp139_;
			_tmp140_ = g_strdup ("ID");
			_tmp141_ = _tmp140_;
			_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
			((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp141_;
			_tmp142_ = _g_object_ref0 (binding);
			self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp142_);
			_g_object_unref0 (binding);
		}
	}
	if (!rdftype) {
		if (object_is_var) {
			TrackerSparqlVariableBinding* _tmp143_ = NULL;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlContext* _tmp144_ = NULL;
			TrackerSparqlVariable* _tmp145_ = NULL;
			TrackerSparqlDataTable* _tmp146_;
			TrackerSparqlDataTable* _tmp147_;
			TrackerSparqlVariableState state = 0;
			_tmp143_ = tracker_sparql_variable_binding_new ();
			binding = _tmp143_;
			_tmp144_ = tracker_sparql_pattern_get_context (self);
			_tmp145_ = tracker_sparql_context_get_variable (_tmp144_, object);
			binding->variable = _tmp145_;
			_tmp146_ = _g_object_ref0 (table);
			_tmp147_ = _tmp146_;
			_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
			((TrackerSparqlDataBinding*) binding)->table = _tmp147_;
			if (prop != NULL) {
				TrackerClass* _tmp148_ = NULL;
				TrackerClass* _tmp149_;
				TrackerClass* _tmp150_;
				TrackerPropertyType _tmp151_;
				const gchar* _tmp152_ = NULL;
				gchar* _tmp153_;
				gchar* _tmp154_;
				gboolean _tmp155_;
				_tmp148_ = tracker_property_get_range (prop);
				_tmp149_ = _g_object_ref0 (_tmp148_);
				_tmp150_ = _tmp149_;
				_g_object_unref0 (binding->type);
				binding->type = _tmp150_;
				_tmp151_ = tracker_property_get_data_type (prop);
				((TrackerSparqlDataBinding*) binding)->data_type = _tmp151_;
				_tmp152_ = tracker_property_get_name (prop);
				_tmp153_ = g_strdup (_tmp152_);
				_tmp154_ = _tmp153_;
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp154_;
				_tmp155_ = tracker_property_get_multiple_values (prop);
				if (!_tmp155_) {
					binding->maybe_null = TRUE;
					binding->in_simple_optional = in_simple_optional;
				}
			} else {
				gchar* _tmp156_;
				gchar* _tmp157_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_STRING;
				_tmp156_ = g_strdup ("object");
				_tmp157_ = _tmp156_;
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp157_;
				binding->maybe_null = TRUE;
			}
			if (in_simple_optional) {
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
			} else {
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
			}
			tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
			_g_object_unref0 (binding);
		} else {
			if (is_fts_match) {
				TrackerSparqlLiteralBinding* _tmp158_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp159_;
				gchar* _tmp160_;
				TrackerSparqlDataTable* _tmp161_;
				TrackerSparqlDataTable* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				TrackerSparqlLiteralBinding* _tmp165_;
				TrackerSparqlContext* _tmp166_ = NULL;
				TrackerSparqlVariable* _tmp167_ = NULL;
				const gchar* _tmp168_ = NULL;
				TrackerSparqlContext* _tmp169_ = NULL;
				TrackerSparqlVariable* _tmp170_ = NULL;
				const gchar* _tmp171_ = NULL;
				_tmp158_ = tracker_sparql_literal_binding_new ();
				binding = _tmp158_;
				binding->is_fts_match = TRUE;
				_tmp159_ = g_strdup (object);
				_tmp160_ = _tmp159_;
				_g_free0 (binding->literal);
				binding->literal = _tmp160_;
				_tmp161_ = _g_object_ref0 (table);
				_tmp162_ = _tmp161_;
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp162_;
				_tmp163_ = g_strdup ("fts");
				_tmp164_ = _tmp163_;
				_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
				((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp164_;
				_tmp165_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp165_);
				_tmp166_ = tracker_sparql_pattern_get_context (self);
				_tmp167_ = tracker_sparql_context_get_variable (_tmp166_, self->priv->current_subject);
				_tmp168_ = tracker_sparql_variable_get_name (_tmp167_);
				g_string_append_printf (sql, "rank(\"%s\".\"fts\") AS \"%s_u_rank\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, _tmp168_);
				_tmp169_ = tracker_sparql_pattern_get_context (self);
				_tmp170_ = tracker_sparql_context_get_variable (_tmp169_, self->priv->current_subject);
				_tmp171_ = tracker_sparql_variable_get_name (_tmp170_);
				g_string_append_printf (sql, "offsets(\"%s\".\"fts\") AS \"%s_u_offsets\", ", ((TrackerSparqlDataBinding*) binding)->table->sql_query_tablename, _tmp171_);
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* _tmp172_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp173_;
				gchar* _tmp174_;
				TrackerSparqlDataTable* _tmp175_;
				TrackerSparqlDataTable* _tmp176_;
				TrackerSparqlLiteralBinding* _tmp183_;
				_tmp172_ = tracker_sparql_literal_binding_new ();
				binding = _tmp172_;
				_tmp173_ = g_strdup (object);
				_tmp174_ = _tmp173_;
				_g_free0 (binding->literal);
				binding->literal = _tmp174_;
				_tmp175_ = _g_object_ref0 (table);
				_tmp176_ = _tmp175_;
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp176_;
				if (prop != NULL) {
					TrackerPropertyType _tmp177_;
					const gchar* _tmp178_ = NULL;
					gchar* _tmp179_;
					gchar* _tmp180_;
					_tmp177_ = tracker_property_get_data_type (prop);
					((TrackerSparqlDataBinding*) binding)->data_type = _tmp177_;
					_tmp178_ = tracker_property_get_name (prop);
					_tmp179_ = g_strdup (_tmp178_);
					_tmp180_ = _tmp179_;
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp180_;
				} else {
					gchar* _tmp181_;
					gchar* _tmp182_;
					_tmp181_ = g_strdup ("object");
					_tmp182_ = _tmp181_;
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp182_;
				}
				_tmp183_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp183_);
				_g_object_unref0 (binding);
			}
		}
		if (self->current_graph != NULL) {
			if (self->priv->current_graph_is_var) {
				TrackerSparqlVariableBinding* _tmp184_ = NULL;
				TrackerSparqlVariableBinding* binding;
				TrackerSparqlContext* _tmp185_ = NULL;
				TrackerSparqlVariable* _tmp186_ = NULL;
				TrackerSparqlDataTable* _tmp187_;
				TrackerSparqlDataTable* _tmp188_;
				TrackerSparqlVariableState state = 0;
				_tmp184_ = tracker_sparql_variable_binding_new ();
				binding = _tmp184_;
				_tmp185_ = tracker_sparql_pattern_get_context (self);
				_tmp186_ = tracker_sparql_context_get_variable (_tmp185_, self->current_graph);
				binding->variable = _tmp186_;
				_tmp187_ = _g_object_ref0 (table);
				_tmp188_ = _tmp187_;
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp188_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				if (prop != NULL) {
					const gchar* _tmp189_ = NULL;
					gchar* _tmp190_;
					_tmp189_ = tracker_property_get_name (prop);
					_tmp190_ = g_strconcat (_tmp189_, ":graph", NULL);
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp190_;
				} else {
					gchar* _tmp191_;
					gchar* _tmp192_;
					_tmp191_ = g_strdup ("graph");
					_tmp192_ = _tmp191_;
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp192_;
				}
				binding->maybe_null = TRUE;
				binding->in_simple_optional = in_simple_optional;
				if (in_simple_optional) {
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
				} else {
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
				}
				tracker_sparql_pattern_add_variable_binding (self, sql, binding, state);
				_g_object_unref0 (binding);
			} else {
				TrackerSparqlLiteralBinding* _tmp193_ = NULL;
				TrackerSparqlLiteralBinding* binding;
				gchar* _tmp194_;
				gchar* _tmp195_;
				TrackerSparqlDataTable* _tmp196_;
				TrackerSparqlDataTable* _tmp197_;
				TrackerSparqlLiteralBinding* _tmp202_;
				_tmp193_ = tracker_sparql_literal_binding_new ();
				binding = _tmp193_;
				_tmp194_ = g_strdup (self->current_graph);
				_tmp195_ = _tmp194_;
				_g_free0 (binding->literal);
				binding->literal = _tmp195_;
				_tmp196_ = _g_object_ref0 (table);
				_tmp197_ = _tmp196_;
				_g_object_unref0 (((TrackerSparqlDataBinding*) binding)->table);
				((TrackerSparqlDataBinding*) binding)->table = _tmp197_;
				((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
				if (prop != NULL) {
					const gchar* _tmp198_ = NULL;
					gchar* _tmp199_;
					_tmp198_ = tracker_property_get_name (prop);
					_tmp199_ = g_strconcat (_tmp198_, ":graph", NULL);
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp199_;
				} else {
					gchar* _tmp200_;
					gchar* _tmp201_;
					_tmp200_ = g_strdup ("graph");
					_tmp201_ = _tmp200_;
					_g_free0 (((TrackerSparqlDataBinding*) binding)->sql_db_column_name);
					((TrackerSparqlDataBinding*) binding)->sql_db_column_name = _tmp201_;
				}
				_tmp202_ = _g_object_ref0 (binding);
				self->priv->triple_context->bindings = g_list_append (self->priv->triple_context->bindings, _tmp202_);
				_g_object_unref0 (binding);
			}
		}
	}
	if (sql->len == begin_sql_len) {
		g_string_append (sql, "1, ");
	}
	_g_object_unref0 (subject_type);
	_g_object_unref0 (prop);
	_g_object_unref0 (table);
	_g_free0 (db_table);
	_g_free0 (object);
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable) {
	gboolean _newtable = FALSE;
	TrackerSparqlDataTable* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* tablestring;
	TrackerSparqlDataTable* table;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subject != NULL, NULL);
	g_return_val_if_fail (db_table != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s.%s", subject, db_table);
	tablestring = _tmp0_;
	table = NULL;
	_newtable = FALSE;
	if (share_table) {
		gconstpointer _tmp1_ = NULL;
		TrackerSparqlDataTable* _tmp2_;
		TrackerSparqlDataTable* _tmp3_;
		_tmp1_ = g_hash_table_lookup (self->priv->triple_context->table_map, tablestring);
		_tmp2_ = _g_object_ref0 ((TrackerSparqlDataTable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (table);
		table = _tmp3_;
	}
	if (table == NULL) {
		TrackerSparqlDataTable* _tmp4_ = NULL;
		TrackerSparqlDataTable* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		TrackerSparqlDataTable* _tmp11_;
		gchar* _tmp12_;
		TrackerSparqlDataTable* _tmp13_;
		_newtable = TRUE;
		_tmp4_ = tracker_sparql_data_table_new ();
		_tmp5_ = _tmp4_;
		_g_object_unref0 (table);
		table = _tmp5_;
		_tmp6_ = g_strdup (db_table);
		_tmp7_ = _tmp6_;
		_g_free0 (table->sql_db_tablename);
		table->sql_db_tablename = _tmp7_;
		self->priv->counter = self->priv->counter + 1;
		_tmp8_ = g_strdup_printf ("%i", self->priv->counter);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (db_table, _tmp9_, NULL);
		_g_free0 (table->sql_query_tablename);
		table->sql_query_tablename = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = _g_object_ref0 (table);
		self->priv->triple_context->tables = g_list_append (self->priv->triple_context->tables, _tmp11_);
		_tmp12_ = g_strdup (tablestring);
		_tmp13_ = _g_object_ref0 (table);
		g_hash_table_insert (self->priv->triple_context->table_map, _tmp12_, _tmp13_);
	}
	result = table;
	_g_free0 (tablestring);
	if (newtable) {
		*newtable = _newtable;
	}
	return result;
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlContext* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _tracker_sparql_context_ref0 (value);
	_tmp1_ = _tmp0_;
	_tracker_sparql_context_unref0 (self->priv->query->context);
	self->priv->query->context = _tmp1_;
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self = NULL;
	GList* _tmp0_;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GList* _tmp6_;
	g_return_val_if_fail (query != NULL, NULL);
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, query, parent_context);
	_tmp0_ = NULL;
	__g_list_free__g_object_unref0_0 (self->tables);
	self->tables = _tmp0_;
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
	_tmp2_ = _tmp1_;
	_g_hash_table_unref0 (self->table_map);
	self->table_map = _tmp2_;
	_tmp3_ = NULL;
	__g_list_free__g_object_unref0_0 (self->variables);
	self->variables = _tmp3_;
	_tmp4_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, g_object_unref, g_object_unref);
	_tmp5_ = _tmp4_;
	_g_hash_table_unref0 (self->var_bindings);
	self->var_bindings = _tmp5_;
	_tmp6_ = NULL;
	__g_list_free__g_object_unref0_0 (self->bindings);
	self->bindings = _tmp6_;
	return self;
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, query, parent_context);
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlPatternTripleContext * self;
	self = TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT (obj);
	__g_list_free__g_object_unref0_0 (self->tables);
	_g_hash_table_unref0 (self->table_map);
	__g_list_free__g_object_unref0_0 (self->bindings);
	__g_list_free__g_object_unref0_0 (self->variables);
	_g_hash_table_unref0 (self->var_bindings);
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_pattern_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_pattern_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
}


static void tracker_sparql_pattern_finalize (GObject* obj) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (obj);
	_g_free0 (self->current_graph);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_tracker_sparql_context_unref0 (self->priv->triple_context);
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = TRACKER_SPARQL_PATTERN (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



