/* tracker-remote.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-remote.vala, do not modify */

/*
 * Copyright (C) 2016 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TRACKER_REMOTE_TYPE_CONNECTION (tracker_remote_connection_get_type ())
#define TRACKER_REMOTE_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnection))
#define TRACKER_REMOTE_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnectionClass))
#define TRACKER_REMOTE_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_REMOTE_TYPE_CONNECTION))
#define TRACKER_REMOTE_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_REMOTE_TYPE_CONNECTION))
#define TRACKER_REMOTE_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnectionClass))

typedef struct _TrackerRemoteConnection TrackerRemoteConnection;
typedef struct _TrackerRemoteConnectionClass TrackerRemoteConnectionClass;
typedef struct _TrackerRemoteConnectionPrivate TrackerRemoteConnectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))

#define TRACKER_REMOTE_TYPE_JSON_CURSOR (tracker_remote_json_cursor_get_type ())
#define TRACKER_REMOTE_JSON_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_REMOTE_TYPE_JSON_CURSOR, TrackerRemoteJsonCursor))
#define TRACKER_REMOTE_JSON_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_REMOTE_TYPE_JSON_CURSOR, TrackerRemoteJsonCursorClass))
#define TRACKER_REMOTE_IS_JSON_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_REMOTE_TYPE_JSON_CURSOR))
#define TRACKER_REMOTE_IS_JSON_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_REMOTE_TYPE_JSON_CURSOR))
#define TRACKER_REMOTE_JSON_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_REMOTE_TYPE_JSON_CURSOR, TrackerRemoteJsonCursorClass))

typedef struct _TrackerRemoteJsonCursor TrackerRemoteJsonCursor;
typedef struct _TrackerRemoteJsonCursorClass TrackerRemoteJsonCursorClass;

#define TRACKER_REMOTE_TYPE_XML_CURSOR (tracker_remote_xml_cursor_get_type ())
#define TRACKER_REMOTE_XML_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_REMOTE_TYPE_XML_CURSOR, TrackerRemoteXmlCursor))
#define TRACKER_REMOTE_XML_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_REMOTE_TYPE_XML_CURSOR, TrackerRemoteXmlCursorClass))
#define TRACKER_REMOTE_IS_XML_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_REMOTE_TYPE_XML_CURSOR))
#define TRACKER_REMOTE_IS_XML_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_REMOTE_TYPE_XML_CURSOR))
#define TRACKER_REMOTE_XML_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_REMOTE_TYPE_XML_CURSOR, TrackerRemoteXmlCursorClass))

typedef struct _TrackerRemoteXmlCursor TrackerRemoteXmlCursor;
typedef struct _TrackerRemoteXmlCursorClass TrackerRemoteXmlCursorClass;
typedef struct _TrackerRemoteConnectionQueryAsyncData TrackerRemoteConnectionQueryAsyncData;

struct _TrackerRemoteConnection {
	TrackerSparqlConnection parent_instance;
	TrackerRemoteConnectionPrivate * priv;
	SoupSession* _session;
	gchar* _base_uri;
};

struct _TrackerRemoteConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerRemoteConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	SoupMessage* message;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	GCancellable* _tmp4_;
	GInputStream* _tmp5_;
	GInputStream* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	SoupMessage* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	GError * _inner_error_;
};


static gpointer tracker_remote_connection_parent_class = NULL;

GType tracker_remote_connection_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_REMOTE_CONNECTION_DUMMY_PROPERTY
};
#define TRACKER_REMOTE_CONNECTION_XML_TYPE "application/sparql-results+xml"
#define TRACKER_REMOTE_CONNECTION_JSON_TYPE "application/sparql-results+json"
TrackerRemoteConnection* tracker_remote_connection_new (const gchar* base_uri);
TrackerRemoteConnection* tracker_remote_connection_construct (GType object_type, const gchar* base_uri);
static SoupMessage* tracker_remote_connection_create_request (TrackerRemoteConnection* self, const gchar* sparql);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static TrackerSparqlCursor* tracker_remote_connection_create_cursor (TrackerRemoteConnection* self, SoupMessage* message, GError** error);
static void _vala_SoupBuffer_free (SoupBuffer* self);
GType tracker_remote_json_cursor_get_type (void) G_GNUC_CONST;
TrackerRemoteJsonCursor* tracker_remote_json_cursor_new (const gchar* document, glong length, GError** error);
TrackerRemoteJsonCursor* tracker_remote_json_cursor_construct (GType object_type, const gchar* document, glong length, GError** error);
GType tracker_remote_xml_cursor_get_type (void) G_GNUC_CONST;
TrackerRemoteXmlCursor* tracker_remote_xml_cursor_new (const gchar* document, glong length, GError** error);
TrackerRemoteXmlCursor* tracker_remote_xml_cursor_construct (GType object_type, const gchar* document, glong length, GError** error);
static TrackerSparqlCursor* tracker_remote_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_remote_connection_real_query_async_data_free (gpointer _data);
static void tracker_remote_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_);
static void tracker_remote_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_remote_connection_finalize (GObject * obj);


TrackerRemoteConnection* tracker_remote_connection_construct (GType object_type, const gchar* base_uri) {
	TrackerRemoteConnection * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SoupSession* _tmp2_;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (base_uri != NULL, NULL);
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) tracker_sparql_connection_construct (object_type);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = base_uri;
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self->_base_uri = _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = soup_session_new ();
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self->_session = _tmp2_;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return self;
#line 161 "tracker-remote.c"
}


TrackerRemoteConnection* tracker_remote_connection_new (const gchar* base_uri) {
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return tracker_remote_connection_construct (TRACKER_REMOTE_TYPE_CONNECTION, base_uri);
#line 168 "tracker-remote.c"
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return g_boxed_copy (soup_message_headers_get_type (), self);
#line 175 "tracker-remote.c"
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
#line 182 "tracker-remote.c"
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_boxed_free (soup_message_headers_get_type (), self);
#line 189 "tracker-remote.c"
}


static SoupMessage* tracker_remote_connection_create_request (TrackerRemoteConnection* self, const gchar* sparql) {
	SoupMessage* result = NULL;
	gchar* uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp3_;
	SoupMessageHeaders* headers = NULL;
	SoupMessageHeaders* _tmp4_;
	SoupMessageHeaders* _tmp5_;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = self->_base_uri;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = sparql;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	uri = _tmp2_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = soup_message_new ("GET", uri);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	message = _tmp3_;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4_ = message->request_headers;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = __vala_SoupMessageHeaders_copy0 (_tmp4_);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	headers = _tmp5_;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_JSON_TYPE);
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_XML_TYPE);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	result = message;
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (uri);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 238 "tracker-remote.c"
}


static void _vala_SoupBuffer_free (SoupBuffer* self) {
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_boxed_free (soup_buffer_get_type (), self);
#line 245 "tracker-remote.c"
}


static TrackerSparqlCursor* tracker_remote_connection_create_cursor (TrackerRemoteConnection* self, SoupMessage* message, GError** error) {
	TrackerSparqlCursor* result = NULL;
	gchar* document = NULL;
	SoupMessage* _tmp0_;
	SoupMessageBody* _tmp1_;
	SoupBuffer* _tmp2_;
	SoupBuffer* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupMessage* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	SoupMessageHeaders* headers = NULL;
	SoupMessage* _tmp15_;
	SoupMessageHeaders* _tmp16_;
	SoupMessageHeaders* _tmp17_;
	gchar* content_type = NULL;
	SoupMessageHeaders* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	glong length = 0L;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_ = NULL;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = message;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = _tmp0_->response_body;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = soup_message_body_flatten (_tmp1_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = _tmp2_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4_ = _tmp3_->data;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4__length1 = (gint) _tmp3_->length;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = g_strdup ((const gchar*) _tmp4_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp6_ = _tmp5_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	__vala_SoupBuffer_free0 (_tmp3_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	document = _tmp6_;
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp7_ = message;
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_object_get (_tmp7_, "status-code", &_tmp8_, NULL);
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp9_ = _tmp8_;
#line 48 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (_tmp9_ != ((guint) SOUP_STATUS_OK)) {
#line 309 "tracker-remote.c"
		SoupMessage* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp10_ = message;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_get (_tmp10_, "status-code", &_tmp11_, NULL);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp12_ = _tmp11_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp13_ = document;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp14_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unhandled status code %u, document is: %s", _tmp12_, _tmp13_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_inner_error_ = _tmp14_;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (document);
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 333 "tracker-remote.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp15_ = message;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp16_ = _tmp15_->response_headers;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp17_ = __vala_SoupMessageHeaders_copy0 (_tmp16_);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	headers = _tmp17_;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp18_ = headers;
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp19_ = soup_message_headers_get_content_type (_tmp18_, NULL);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	content_type = _tmp20_;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp21_ = document;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp22_ = strlen (_tmp21_);
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp23_ = _tmp22_;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	length = (glong) _tmp23_;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp24_ = content_type;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (g_strcmp0 (_tmp24_, TRACKER_REMOTE_CONNECTION_JSON_TYPE) == 0) {
#line 363 "tracker-remote.c"
		TrackerRemoteJsonCursor* _tmp25_ = NULL;
		const gchar* _tmp26_;
		glong _tmp27_;
		TrackerRemoteJsonCursor* _tmp28_;
		TrackerRemoteJsonCursor* _tmp29_;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp26_ = document;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp27_ = length;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp28_ = tracker_remote_json_cursor_new (_tmp26_, _tmp27_, &_inner_error_);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp25_ = _tmp28_;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			return NULL;
#line 389 "tracker-remote.c"
		}
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp29_ = _tmp25_;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp25_ = NULL;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		result = (TrackerSparqlCursor*) _tmp29_;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_tmp25_);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (content_type);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		__vala_SoupMessageHeaders_free0 (headers);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_free0 (document);
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return result;
#line 407 "tracker-remote.c"
	} else {
		const gchar* _tmp30_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp30_ = content_type;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		if (g_strcmp0 (_tmp30_, TRACKER_REMOTE_CONNECTION_XML_TYPE) == 0) {
#line 414 "tracker-remote.c"
			TrackerRemoteXmlCursor* _tmp31_ = NULL;
			const gchar* _tmp32_;
			glong _tmp33_;
			TrackerRemoteXmlCursor* _tmp34_;
			TrackerRemoteXmlCursor* _tmp35_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp32_ = document;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp33_ = length;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp34_ = tracker_remote_xml_cursor_new (_tmp32_, _tmp33_, &_inner_error_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp31_ = _tmp34_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
				g_propagate_error (error, _inner_error_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
				_g_free0 (content_type);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
				__vala_SoupMessageHeaders_free0 (headers);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
				_g_free0 (document);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
				return NULL;
#line 440 "tracker-remote.c"
			}
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp35_ = _tmp31_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp31_ = NULL;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			result = (TrackerSparqlCursor*) _tmp35_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_object_unref0 (_tmp31_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			return result;
#line 458 "tracker-remote.c"
		} else {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			GError* _tmp38_;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp36_ = content_type;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp37_ = document;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_tmp38_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unknown content type '%s', document is: %s", _tmp36_, _tmp37_);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_inner_error_ = _tmp38_;
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			__vala_SoupMessageHeaders_free0 (headers);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			_g_free0 (document);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			return NULL;
#line 481 "tracker-remote.c"
		}
	}
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (content_type);
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	__vala_SoupMessageHeaders_free0 (headers);
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (document);
#line 490 "tracker-remote.c"
}


static TrackerSparqlCursor* tracker_remote_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerRemoteConnection * self;
	TrackerSparqlCursor* result = NULL;
	SoupMessage* message = NULL;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GCancellable* _tmp5_;
	TrackerSparqlCursor* _tmp9_ = NULL;
	SoupMessage* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	TrackerSparqlCursor* _tmp12_;
	GError * _inner_error_ = NULL;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = sparql;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = tracker_remote_connection_create_request (self, _tmp0_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	message = _tmp1_;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = self->_session;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = message;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	soup_session_send_message (_tmp2_, _tmp3_);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp5_ = cancellable;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (_tmp5_ != NULL) {
#line 529 "tracker-remote.c"
		GCancellable* _tmp6_;
		gboolean _tmp7_;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp6_ = cancellable;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp7_ = g_cancellable_is_cancelled (_tmp6_);
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp4_ = _tmp7_;
#line 538 "tracker-remote.c"
	} else {
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp4_ = FALSE;
#line 542 "tracker-remote.c"
	}
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (_tmp4_) {
#line 546 "tracker-remote.c"
		GError* _tmp8_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_inner_error_ = _tmp8_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 558 "tracker-remote.c"
	}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp10_ = message;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp11_ = tracker_remote_connection_create_cursor (self, _tmp10_, &_inner_error_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp9_ = _tmp11_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 574 "tracker-remote.c"
	}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp12_ = _tmp9_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp9_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	result = _tmp12_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_tmp9_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (message);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 588 "tracker-remote.c"
}


static void tracker_remote_connection_real_query_async_data_free (gpointer _data) {
	TrackerRemoteConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_slice_free (TrackerRemoteConnectionQueryAsyncData, _data_);
#line 605 "tracker-remote.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return self ? g_object_ref (self) : NULL;
#line 612 "tracker-remote.c"
}


static void tracker_remote_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerRemoteConnection * self;
	TrackerRemoteConnectionQueryAsyncData* _data_;
	TrackerRemoteConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = g_slice_new0 (TrackerRemoteConnectionQueryAsyncData);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_connection_real_query_async_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp1_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->sparql = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp3_ = cancellable;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->cancellable = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 654 "tracker-remote.c"
}


static TrackerSparqlCursor* tracker_remote_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return NULL;
#line 667 "tracker-remote.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return result;
#line 675 "tracker-remote.c"
}


static void tracker_remote_connection_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_ = _user_data_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_source_object_ = source_object;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_res_ = _res_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 689 "tracker-remote.c"
}


static gboolean tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	switch (_data_->_state_) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		case 0:
#line 698 "tracker-remote.c"
		goto _state_0;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		case 1:
#line 702 "tracker-remote.c"
		goto _state_1;
		default:
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_assert_not_reached ();
#line 707 "tracker-remote.c"
	}
	_state_0:
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp1_ = tracker_remote_connection_create_request (_data_->self, _data_->_tmp0_);
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->message = _data_->_tmp1_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp2_ = _data_->self->_session;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp3_ = _data_->message;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_state_ = 1;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	soup_session_send_async (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, tracker_remote_connection_query_async_ready, _data_);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return FALSE;
#line 728 "tracker-remote.c"
	_state_1:
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp5_ = soup_session_send_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return FALSE;
#line 746 "tracker-remote.c"
	}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp8_ = _data_->message;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp9_ = tracker_remote_connection_create_cursor (_data_->self, _data_->_tmp8_, &_data_->_inner_error_);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp7_ = _data_->_tmp9_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		return FALSE;
#line 764 "tracker-remote.c"
	}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp10_ = _data_->_tmp7_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->_tmp7_ = NULL;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_data_->result = _data_->_tmp10_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp7_);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (_data_->message);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	if (_data_->_state_ != 0) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 784 "tracker-remote.c"
		}
	}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	g_object_unref (_data_->_async_result);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	return FALSE;
#line 791 "tracker-remote.c"
}


static void tracker_remote_connection_class_init (TrackerRemoteConnectionClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	tracker_remote_connection_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_remote_connection_real_query;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_connection_real_query_async;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_remote_connection_real_query_finish;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_remote_connection_finalize;
#line 806 "tracker-remote.c"
}


static void tracker_remote_connection_instance_init (TrackerRemoteConnection * self) {
}


static void tracker_remote_connection_finalize (GObject * obj) {
	TrackerRemoteConnection * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnection);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-remote/tracker-remote.vala"
	G_OBJECT_CLASS (tracker_remote_connection_parent_class)->finalize (obj);
#line 824 "tracker-remote.c"
}


GType tracker_remote_connection_get_type (void) {
	static volatile gsize tracker_remote_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_remote_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerRemoteConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_remote_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerRemoteConnection), 0, (GInstanceInitFunc) tracker_remote_connection_instance_init, NULL };
		GType tracker_remote_connection_type_id;
		tracker_remote_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerRemoteConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_remote_connection_type_id__volatile, tracker_remote_connection_type_id);
	}
	return tracker_remote_connection_type_id__volatile;
}



