/* tracker-sparql-pattern.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-ontologies.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-property.h"


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	gchar* subject;
	gchar* object;
	gboolean return_graph;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPredicateVariablePrivate {
	TrackerDataManager* manager;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	TrackerDataManager* manager;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	gboolean current_graph_is_var;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	TrackerDataManager* manager;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
	gboolean need_binding_expression;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariablePrivate))
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (TrackerDataManager* manager);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type, TrackerDataManager* manager);
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
static void tracker_sparql_predicate_variable_finalize (GObject * obj);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void _vala_array_add5 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
static void _vala_array_add7 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static void _vala_array_add8 (TrackerSourceLocation* * array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add9 (glong* * array, int* length, int* size, glong value);
static void _vala_array_add10 (TrackerSparqlContext** * array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add11 (TrackerSparqlVariable** * array, int* length, int* size, TrackerSparqlVariable* value);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext * obj);
static void tracker_sparql_pattern_finalize (GObject * obj);
static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_object_ref (self) : NULL;
#line 659 "tracker-sparql-pattern.c"
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type, TrackerDataManager* manager) {
	TrackerSparqlPredicateVariable * self = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = manager;
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->manager = _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 681 "tracker-sparql-pattern.c"
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (TrackerDataManager* manager) {
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, manager);
#line 688 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 699 "tracker-sparql-pattern.c"
	{
		GString* sql = NULL;
		GString* _tmp0_;
		TrackerOntologies* ontologies = NULL;
		TrackerDataManager* _tmp1_;
		TrackerOntologies* _tmp2_;
		TrackerOntologies* _tmp3_;
		TrackerDBInterface* iface = NULL;
		TrackerDataManager* _tmp4_;
		TrackerDBInterface* _tmp5_;
		TrackerDBInterface* _tmp6_;
		const gchar* _tmp7_;
		GString* _tmp165_;
		const gchar* _tmp166_;
		gchar* _tmp167_;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = g_string_new ("");
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		sql = _tmp0_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->manager;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_data_manager_get_ontologies (_tmp1_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		ontologies = _tmp3_;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = self->priv->manager;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = tracker_data_manager_get_db_interface (_tmp4_);
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		iface = _tmp6_;
#line 41 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = self->subject;
#line 41 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp7_ != NULL) {
#line 739 "tracker-sparql-pattern.c"
			gint subject_id = 0;
			TrackerDataManager* _tmp8_;
			TrackerDBInterface* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			TrackerDBCursor* cursor = NULL;
			gint _tmp12_;
			gboolean first = FALSE;
			TrackerDBCursor* _tmp21_;
			gboolean _tmp72_;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = self->priv->manager;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = iface;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = self->subject;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = tracker_data_query_resource_id (_tmp8_, _tmp9_, _tmp10_);
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_id = _tmp11_;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cursor = NULL;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = subject_id;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp12_ > 0) {
#line 766 "tracker-sparql-pattern.c"
				TrackerDBStatement* stmt = NULL;
				TrackerDBInterface* _tmp13_;
				TrackerDBStatement* _tmp14_;
				TrackerDBStatement* _tmp15_;
				gint _tmp16_;
				TrackerDBCursor* _tmp17_ = NULL;
				TrackerDBStatement* _tmp18_;
				TrackerDBCursor* _tmp19_;
				TrackerDBCursor* _tmp20_;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = iface;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = tracker_db_interface_create_statement (_tmp13_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp14_;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 792 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = stmt;
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = subject_id;
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp15_, 0, _tmp16_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = stmt;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = tracker_db_statement_start_cursor (_tmp18_, &_inner_error_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = _tmp19_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 819 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = _tmp17_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = NULL;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp20_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp17_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 834 "tracker-sparql-pattern.c"
			}
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = TRUE;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = cursor;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp21_ != NULL) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 844 "tracker-sparql-pattern.c"
					gboolean _tmp22_ = FALSE;
					TrackerDBCursor* _tmp23_;
					gboolean _tmp24_;
					TrackerClass* domain = NULL;
					TrackerOntologies* _tmp25_;
					TrackerDBCursor* _tmp26_;
					const gchar* _tmp27_;
					TrackerClass* _tmp28_;
					TrackerClass* _tmp29_;
					TrackerOntologies* _tmp30_;
					gint _tmp31_;
					TrackerProperty** _tmp32_;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = cursor;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp24_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp23_, NULL, &_inner_error_);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp22_ = _tmp24_;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (cursor);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (iface);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (sql);
#line 873 "tracker-sparql-pattern.c"
						goto __catch0_g_error;
					}
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp22_) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 880 "tracker-sparql-pattern.c"
					}
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = ontologies;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = cursor;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp26_, 0, NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = tracker_ontologies_get_class_by_uri (_tmp25_, _tmp27_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _g_object_ref0 (_tmp28_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp29_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = ontologies;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp32_ = tracker_ontologies_get_properties (_tmp30_, &_tmp31_);
#line 898 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp32_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp31_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp31_; prop_it = prop_it + 1) {
#line 910 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp33_;
							TrackerProperty* prop = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = _g_object_ref0 (prop_collection[prop_it]);
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp33_;
#line 917 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp34_;
								TrackerClass* _tmp35_;
								TrackerClass* _tmp36_;
								TrackerClass* _tmp37_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp34_ = prop;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp35_ = tracker_property_get_domain (_tmp34_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp36_ = _tmp35_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp37_ = domain;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp36_ == _tmp37_) {
#line 933 "tracker-sparql-pattern.c"
									gboolean _tmp38_;
									GString* _tmp40_;
									TrackerProperty* _tmp41_;
									const gchar* _tmp42_;
									const gchar* _tmp43_;
									GString* _tmp44_;
									TrackerProperty* _tmp45_;
									const gchar* _tmp46_;
									const gchar* _tmp47_;
									gchar* _tmp48_;
									gchar* _tmp49_;
									TrackerProperty* _tmp50_;
									TrackerPropertyType _tmp51_;
									TrackerPropertyType _tmp52_;
									GString* _tmp53_;
									gboolean _tmp54_;
									GString* _tmp59_;
									TrackerProperty* _tmp60_;
									const gchar* _tmp61_;
									const gchar* _tmp62_;
									GString* _tmp63_;
									TrackerSparqlLiteralBinding* binding = NULL;
									TrackerSparqlLiteralBinding* _tmp64_;
									TrackerSparqlLiteralBinding* _tmp65_;
									gint _tmp66_;
									gchar* _tmp67_;
									TrackerSparqlLiteralBinding* _tmp68_;
									TrackerSparqlQuery* _tmp69_;
									TrackerSparqlLiteralBinding* _tmp70_;
									TrackerSparqlLiteralBinding* _tmp71_;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp38_ = first;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp38_) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 970 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp39_;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp39_ = sql;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp39_, " UNION ALL ");
#line 977 "tracker-sparql-pattern.c"
									}
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp40_ = sql;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp41_ = prop;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp42_ = tracker_property_get_uri (_tmp41_);
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp43_ = _tmp42_;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp40_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp43_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp44_ = sql;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp45_ = prop;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp46_ = tracker_property_get_name (_tmp45_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = _tmp46_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = g_strdup_printf ("\"%s\"", _tmp47_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = _tmp48_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = prop;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = tracker_property_get_data_type (_tmp50_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = _tmp51_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp44_, _tmp49_, _tmp52_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp49_);
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = sql;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp53_, " AS \"object\"");
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp54_ = self->return_graph;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp54_) {
#line 1019 "tracker-sparql-pattern.c"
										GString* _tmp55_;
										TrackerProperty* _tmp56_;
										const gchar* _tmp57_;
										const gchar* _tmp58_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp55_ = sql;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp56_ = prop;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp57_ = tracker_property_get_name (_tmp56_);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp58_ = _tmp57_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp55_, ", \"%s:graph\" AS \"graph\"", _tmp58_);
#line 1034 "tracker-sparql-pattern.c"
									}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp59_ = sql;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = prop;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp61_ = tracker_property_get_table_name (_tmp60_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = _tmp61_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp59_, " FROM \"%s\"", _tmp62_);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp63_ = sql;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp63_, " WHERE ID = ?");
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp64_ = tracker_sparql_literal_binding_new ();
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									binding = _tmp64_;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp65_ = binding;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp66_ = subject_id;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp67_ = g_strdup_printf ("%i", _tmp66_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp65_->literal);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp65_->literal = _tmp67_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp68_ = binding;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									((TrackerSparqlDataBinding*) _tmp68_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp69_ = query;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp70_ = binding;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp71_ = _g_object_ref0 (_tmp70_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp69_->bindings = g_list_append (_tmp69_->bindings, _tmp71_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (binding);
#line 1078 "tracker-sparql-pattern.c"
								}
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 1082 "tracker-sparql-pattern.c"
							}
						}
					}
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 1088 "tracker-sparql-pattern.c"
				}
			}
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp72_ = first;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp72_) {
#line 1095 "tracker-sparql-pattern.c"
				GString* _tmp73_;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp73_ = sql;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp73_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 1101 "tracker-sparql-pattern.c"
			}
#line 41 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cursor);
#line 1105 "tracker-sparql-pattern.c"
		} else {
			const gchar* _tmp74_;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp74_ = self->object;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp74_ != NULL) {
#line 1112 "tracker-sparql-pattern.c"
				gint object_id = 0;
				TrackerDataManager* _tmp75_;
				TrackerDBInterface* _tmp76_;
				const gchar* _tmp77_;
				gint _tmp78_;
				TrackerDBStatement* stmt = NULL;
				TrackerDBInterface* _tmp79_;
				TrackerDBStatement* _tmp80_;
				TrackerDBStatement* _tmp81_;
				gint _tmp82_;
				TrackerDBCursor* cursor = NULL;
				TrackerDBStatement* _tmp83_;
				TrackerDBCursor* _tmp84_;
				gboolean first = FALSE;
				TrackerDBCursor* _tmp85_;
				gboolean _tmp127_;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = self->priv->manager;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp76_ = iface;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp77_ = self->object;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp78_ = tracker_data_query_resource_id (_tmp75_, _tmp76_, _tmp77_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				object_id = _tmp78_;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp79_ = iface;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp80_ = tracker_db_interface_create_statement (_tmp79_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp80_;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1153 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp81_ = stmt;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp82_ = object_id;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp81_, 0, _tmp82_);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp83_ = stmt;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp84_ = tracker_db_statement_start_cursor (_tmp83_, &_inner_error_);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp84_;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1178 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp85_ = cursor;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp85_ != NULL) {
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					while (TRUE) {
#line 1189 "tracker-sparql-pattern.c"
						gboolean _tmp86_ = FALSE;
						TrackerDBCursor* _tmp87_;
						gboolean _tmp88_;
						TrackerClass* range = NULL;
						TrackerOntologies* _tmp89_;
						TrackerDBCursor* _tmp90_;
						const gchar* _tmp91_;
						TrackerClass* _tmp92_;
						TrackerClass* _tmp93_;
						TrackerOntologies* _tmp94_;
						gint _tmp95_;
						TrackerProperty** _tmp96_;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp87_ = cursor;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp88_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp87_, NULL, &_inner_error_);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp86_ = _tmp88_;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (cursor);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (stmt);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (iface);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (sql);
#line 1220 "tracker-sparql-pattern.c"
							goto __catch0_g_error;
						}
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp86_) {
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 1227 "tracker-sparql-pattern.c"
						}
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp89_ = ontologies;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp90_ = cursor;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp91_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp90_, 0, NULL);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp92_ = tracker_ontologies_get_class_by_uri (_tmp89_, _tmp91_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp93_ = _g_object_ref0 (_tmp92_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						range = _tmp93_;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp94_ = ontologies;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp96_ = tracker_ontologies_get_properties (_tmp94_, &_tmp95_);
#line 1245 "tracker-sparql-pattern.c"
						{
							TrackerProperty** prop_collection = NULL;
							gint prop_collection_length1 = 0;
							gint _prop_collection_size_ = 0;
							gint prop_it = 0;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection = _tmp96_;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection_length1 = _tmp95_;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (prop_it = 0; prop_it < _tmp95_; prop_it = prop_it + 1) {
#line 1257 "tracker-sparql-pattern.c"
								TrackerProperty* _tmp97_;
								TrackerProperty* prop = NULL;
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp97_ = _g_object_ref0 (prop_collection[prop_it]);
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								prop = _tmp97_;
#line 1264 "tracker-sparql-pattern.c"
								{
									TrackerProperty* _tmp98_;
									TrackerClass* _tmp99_;
									TrackerClass* _tmp100_;
									TrackerClass* _tmp101_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp98_ = prop;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp99_ = tracker_property_get_range (_tmp98_);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp100_ = _tmp99_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp101_ = range;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp100_ == _tmp101_) {
#line 1280 "tracker-sparql-pattern.c"
										gboolean _tmp102_;
										GString* _tmp104_;
										TrackerProperty* _tmp105_;
										const gchar* _tmp106_;
										const gchar* _tmp107_;
										GString* _tmp108_;
										TrackerProperty* _tmp109_;
										const gchar* _tmp110_;
										const gchar* _tmp111_;
										gchar* _tmp112_;
										gchar* _tmp113_;
										TrackerProperty* _tmp114_;
										TrackerPropertyType _tmp115_;
										TrackerPropertyType _tmp116_;
										GString* _tmp117_;
										gboolean _tmp118_;
										GString* _tmp123_;
										TrackerProperty* _tmp124_;
										const gchar* _tmp125_;
										const gchar* _tmp126_;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp102_ = first;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp102_) {
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											first = FALSE;
#line 1307 "tracker-sparql-pattern.c"
										} else {
											GString* _tmp103_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp103_ = sql;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append (_tmp103_, " UNION ALL ");
#line 1314 "tracker-sparql-pattern.c"
										}
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp104_ = sql;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp105_ = prop;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp106_ = tracker_property_get_uri (_tmp105_);
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp107_ = _tmp106_;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp104_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp107_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp108_ = sql;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp109_ = prop;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp110_ = tracker_property_get_name (_tmp109_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp111_ = _tmp110_;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp112_ = g_strdup_printf ("\"%s\"", _tmp111_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp113_ = _tmp112_;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp114_ = prop;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp115_ = tracker_property_get_data_type (_tmp114_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp116_ = _tmp115_;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										tracker_sparql_expression_append_expression_as_string (_tmp108_, _tmp113_, _tmp116_);
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp113_);
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp117_ = sql;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp117_, " AS \"object\"");
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp118_ = self->return_graph;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp118_) {
#line 1356 "tracker-sparql-pattern.c"
											GString* _tmp119_;
											TrackerProperty* _tmp120_;
											const gchar* _tmp121_;
											const gchar* _tmp122_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp119_ = sql;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp120_ = prop;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp121_ = tracker_property_get_name (_tmp120_);
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp122_ = _tmp121_;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp119_, ", \"%s:graph\" AS \"graph\"", _tmp122_);
#line 1371 "tracker-sparql-pattern.c"
										}
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp123_ = sql;
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp124_ = prop;
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp125_ = tracker_property_get_table_name (_tmp124_);
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp126_ = _tmp125_;
#line 121 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp123_, " FROM \"%s\"", _tmp126_);
#line 1383 "tracker-sparql-pattern.c"
									}
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (prop);
#line 1387 "tracker-sparql-pattern.c"
								}
							}
						}
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (range);
#line 1393 "tracker-sparql-pattern.c"
					}
				}
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = first;
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp127_) {
#line 1400 "tracker-sparql-pattern.c"
					GString* _tmp128_;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp128_ = sql;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp128_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 1406 "tracker-sparql-pattern.c"
				}
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 1412 "tracker-sparql-pattern.c"
			} else {
				TrackerClass* _tmp129_;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp129_ = self->domain;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp129_ != NULL) {
#line 1419 "tracker-sparql-pattern.c"
					gboolean first = FALSE;
					TrackerOntologies* _tmp130_;
					gint _tmp131_;
					TrackerProperty** _tmp132_;
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = TRUE;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp130_ = ontologies;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp132_ = tracker_ontologies_get_properties (_tmp130_, &_tmp131_);
#line 1430 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp132_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp131_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp131_; prop_it = prop_it + 1) {
#line 1442 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp133_;
							TrackerProperty* prop = NULL;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp133_ = _g_object_ref0 (prop_collection[prop_it]);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp133_;
#line 1449 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp134_;
								TrackerClass* _tmp135_;
								TrackerClass* _tmp136_;
								TrackerClass* _tmp137_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp134_ = prop;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp135_ = tracker_property_get_domain (_tmp134_);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp136_ = _tmp135_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp137_ = self->domain;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp136_ == _tmp137_) {
#line 1465 "tracker-sparql-pattern.c"
									gboolean _tmp138_;
									GString* _tmp140_;
									TrackerProperty* _tmp141_;
									const gchar* _tmp142_;
									const gchar* _tmp143_;
									GString* _tmp144_;
									TrackerProperty* _tmp145_;
									const gchar* _tmp146_;
									const gchar* _tmp147_;
									gchar* _tmp148_;
									gchar* _tmp149_;
									TrackerProperty* _tmp150_;
									TrackerPropertyType _tmp151_;
									TrackerPropertyType _tmp152_;
									GString* _tmp153_;
									gboolean _tmp154_;
									GString* _tmp159_;
									TrackerProperty* _tmp160_;
									const gchar* _tmp161_;
									const gchar* _tmp162_;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp138_ = first;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp138_) {
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 1492 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp139_;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp139_ = sql;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp139_, " UNION ALL ");
#line 1499 "tracker-sparql-pattern.c"
									}
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp140_ = sql;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp141_ = prop;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp142_ = tracker_property_get_uri (_tmp141_);
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp143_ = _tmp142_;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp140_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp143_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp144_ = sql;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp145_ = prop;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp146_ = tracker_property_get_name (_tmp145_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp147_ = _tmp146_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp148_ = g_strdup_printf ("\"%s\"", _tmp147_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp149_ = _tmp148_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp150_ = prop;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp151_ = tracker_property_get_data_type (_tmp150_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp152_ = _tmp151_;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp144_, _tmp149_, _tmp152_);
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp149_);
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp153_ = sql;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp153_, " AS \"object\"");
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp154_ = self->return_graph;
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp154_) {
#line 1541 "tracker-sparql-pattern.c"
										GString* _tmp155_;
										TrackerProperty* _tmp156_;
										const gchar* _tmp157_;
										const gchar* _tmp158_;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp155_ = sql;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp156_ = prop;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp157_ = tracker_property_get_name (_tmp156_);
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp158_ = _tmp157_;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp155_, ", \"%s:graph\" AS \"graph\"", _tmp158_);
#line 1556 "tracker-sparql-pattern.c"
									}
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp159_ = sql;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp160_ = prop;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp161_ = tracker_property_get_table_name (_tmp160_);
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp162_ = _tmp161_;
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp159_, " FROM \"%s\"", _tmp162_);
#line 1568 "tracker-sparql-pattern.c"
								}
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 1572 "tracker-sparql-pattern.c"
							}
						}
					}
				} else {
					TrackerSparqlQuery* _tmp163_;
					GError* _tmp164_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp163_ = query;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp164_ = tracker_sparql_query_get_internal_error (_tmp163_, "Unrestricted predicate variables not supported");
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp164_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1591 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
			}
		}
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp165_ = sql;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp166_ = _tmp165_->str;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp167_ = g_strdup (_tmp166_);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = _tmp167_;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (iface);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (ontologies);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (sql);
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 1612 "tracker-sparql-pattern.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp168_;
		const gchar* _tmp169_;
		GError* _tmp170_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp168_ = e;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp169_ = _tmp168_->message;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp170_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp169_);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = _tmp170_;
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 1635 "tracker-sparql-pattern.c"
		goto __finally0;
	}
	__finally0:
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_propagate_error (error, _inner_error_);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1645 "tracker-sparql-pattern.c"
	} else {
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_clear_error (&_inner_error_);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1653 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlPredicateVariablePrivate));
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
#line 1665 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv = TRACKER_SPARQL_PREDICATE_VARIABLE_GET_PRIVATE (self);
#line 1672 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_finalize (GObject * obj) {
	TrackerSparqlPredicateVariable * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->subject);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->object);
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->domain);
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
#line 1690 "tracker-sparql-pattern.c"
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlQuery* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerDataManager* _tmp3_;
	TrackerSparqlQuery* _tmp4_;
	TrackerSparqlExpression* _tmp5_;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->query = _tmp0_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = query;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->manager;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->manager = _tmp3_;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = query;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _tmp4_->expression;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->expression = _tmp5_;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 1740 "tracker-sparql-pattern.c"
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
#line 1747 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_next (_tmp1_, &_inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp2_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1769 "tracker-sparql-pattern.c"
			gboolean _tmp3_ = FALSE;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp3_;
#line 1775 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1784 "tracker-sparql-pattern.c"
		}
	}
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1791 "tracker-sparql-pattern.c"
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1809 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlTokenType _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = type;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_query_accept (_tmp1_, _tmp2_, &_inner_error_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp3_;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1834 "tracker-sparql-pattern.c"
			gboolean _tmp4_ = FALSE;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1840 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp5_;
#line 1849 "tracker-sparql-pattern.c"
		}
	}
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1856 "tracker-sparql-pattern.c"
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = msg;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1879 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlTokenType _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = type;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_query_expect (_tmp1_, _tmp2_, &_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp3_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1904 "tracker-sparql-pattern.c"
			gboolean _tmp4_ = FALSE;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1910 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp5_;
#line 1919 "tracker-sparql-pattern.c"
		}
	}
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1926 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_ = {0};
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_get_location (_tmp0_, &_tmp1_);
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	*result = _tmp1_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return;
#line 1943 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_;
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (location != NULL);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = *location;
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_set_location (_tmp0_, &_tmp1_);
#line 1960 "tracker-sparql-pattern.c"
}


static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = strip;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1981 "tracker-sparql-pattern.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1988 "tracker-sparql-pattern.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_free (self);
#line 1997 "tracker-sparql-pattern.c"
}


static void _vala_array_add5 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 2008 "tracker-sparql-pattern.c"
	}
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 2012 "tracker-sparql-pattern.c"
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2023 "tracker-sparql-pattern.c"
	}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 2029 "tracker-sparql-pattern.c"
}


static void _vala_array_add7 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 2040 "tracker-sparql-pattern.c"
	}
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 2044 "tracker-sparql-pattern.c"
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	TrackerSparqlSelectContext* _result_ = NULL;
	gboolean _tmp0_;
	TrackerSparqlSelectContext* _tmp9_;
	TrackerPropertyType type = 0;
	GString* pattern_sql = NULL;
	GString* _tmp10_;
	GList* old_bindings = NULL;
	TrackerSparqlQuery* _tmp11_;
	GList* _tmp12_;
	GString* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	TrackerSourceLocation select_variables_location = {0};
	TrackerSourceLocation _tmp19_ = {0};
	TrackerSparqlExpression* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_;
	TrackerSparqlContext* pattern = NULL;
	GString* _tmp23_;
	TrackerSparqlContext* _tmp24_;
	TrackerSparqlContext* _tmp25_;
	GHashTable* _tmp26_;
	GList* _tmp27_;
	TrackerSourceLocation after_where = {0};
	TrackerSourceLocation _tmp33_ = {0};
	TrackerSourceLocation _tmp34_;
	TrackerSparqlContext* _tmp35_;
	TrackerSparqlContext* _tmp36_;
	GHashTable* _tmp37_;
	GList* _tmp38_;
	GList* where_bindings = NULL;
	TrackerSparqlQuery* _tmp48_;
	GList* _tmp49_;
	TrackerSparqlQuery* _tmp50_;
	GList* _tmp51_;
	gboolean first = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	GList* _tmp115_;
	gboolean _tmp120_;
	GString* _tmp122_;
	GString* _tmp123_;
	GString* _tmp124_;
	const gchar* _tmp125_;
	GString* _tmp126_;
	TrackerSourceLocation _tmp127_;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_;
	gint limit = 0;
	gint offset = 0;
	gboolean _tmp171_ = FALSE;
	gboolean _tmp172_;
	gint _tmp191_;
	gboolean _tmp221_ = FALSE;
	gboolean _tmp222_ = FALSE;
	gboolean _tmp223_;
	TrackerSparqlContext* _tmp242_;
	TrackerSparqlContext* _tmp243_;
	TrackerSparqlContext* _tmp244_;
	TrackerSparqlSelectContext* _tmp245_;
	TrackerPropertyType _tmp246_;
	GError * _inner_error_ = NULL;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = scalar_subquery;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_) {
#line 2124 "tracker-sparql-pattern.c"
		TrackerSparqlQuery* _tmp1_;
		TrackerSparqlContext* _tmp2_;
		TrackerSparqlContext* _tmp3_;
		TrackerSparqlSelectContext* _tmp4_;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->query;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 2141 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlQuery* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		TrackerSparqlSelectContext* _tmp8_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->query;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_select_context_new (_tmp5_, _tmp7_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp8_;
#line 2159 "tracker-sparql-pattern.c"
	}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = _result_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp9_);
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = g_string_new ("");
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern_sql = _tmp10_;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = self->priv->query;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->bindings;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_->bindings = NULL;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = _tmp12_;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = sql;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp13_, "SELECT ");
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2199 "tracker-sparql-pattern.c"
		} else {
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2213 "tracker-sparql-pattern.c"
		}
	}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp15_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp14_ = _tmp15_;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2234 "tracker-sparql-pattern.c"
		} else {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2248 "tracker-sparql-pattern.c"
		}
	}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp14_) {
#line 2253 "tracker-sparql-pattern.c"
		GString* _tmp16_;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = sql;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp16_, "DISTINCT ");
#line 2259 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = _tmp18_;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2281 "tracker-sparql-pattern.c"
			} else {
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2295 "tracker-sparql-pattern.c"
			}
		}
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp17_) {
#line 2300 "tracker-sparql-pattern.c"
		}
	}
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp19_);
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	select_variables_location = _tmp19_;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = self->priv->expression;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_skip_select_variables (_tmp20_, &_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2325 "tracker-sparql-pattern.c"
		} else {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2339 "tracker-sparql-pattern.c"
		}
	}
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _tmp22_;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2360 "tracker-sparql-pattern.c"
		} else {
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2374 "tracker-sparql-pattern.c"
		}
	}
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp21_) {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2395 "tracker-sparql-pattern.c"
			} else {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2409 "tracker-sparql-pattern.c"
			}
		}
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2428 "tracker-sparql-pattern.c"
			} else {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2442 "tracker-sparql-pattern.c"
			}
		}
	}
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2462 "tracker-sparql-pattern.c"
		} else {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2476 "tracker-sparql-pattern.c"
		}
	}
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = pattern_sql;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp23_, &_inner_error_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp24_;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2499 "tracker-sparql-pattern.c"
		} else {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2513 "tracker-sparql-pattern.c"
		}
	}
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = pattern;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = _tmp25_->var_set;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = g_hash_table_get_keys (_tmp26_);
#line 2522 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp27_;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2530 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 2534 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp28_;
				TrackerSparqlContext* _tmp29_;
				GHashTable* _tmp30_;
				TrackerSparqlVariable* _tmp31_;
				TrackerSparqlVariable* _tmp32_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = tracker_sparql_pattern_get_context (self);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = _tmp28_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp29_->var_set;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = key;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _g_object_ref0 (_tmp31_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp30_, _tmp32_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 2553 "tracker-sparql-pattern.c"
			}
		}
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 2558 "tracker-sparql-pattern.c"
	}
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp33_);
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	after_where = _tmp33_;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = select_variables_location;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp34_);
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = tracker_sparql_pattern_get_context (self);
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp36_ = _tmp35_;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp37_ = _tmp36_->var_set;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp38_ = g_hash_table_get_keys (_tmp37_);
#line 2576 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp38_;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2584 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 2588 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp39_;
				TrackerSparqlVariableBinding* _tmp40_;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = variable;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_->binding;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp40_ == NULL) {
#line 2598 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					GError* _tmp46_;
					GError* _tmp47_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = variable;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = tracker_sparql_variable_get_name (_tmp41_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = _tmp42_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = g_strdup_printf ("use of undefined variable `%s'", _tmp43_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = _tmp44_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = tracker_sparql_pattern_get_error (self, _tmp45_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = _tmp46_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp45_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp47_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2640 "tracker-sparql-pattern.c"
					} else {
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2658 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 2665 "tracker-sparql-pattern.c"
	}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_ = self->priv->query;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp49_ = _tmp48_->bindings;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_->bindings = NULL;
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	where_bindings = _tmp49_;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = self->priv->query;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = old_bindings;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = NULL;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (_tmp50_->bindings);
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->bindings = _tmp51_;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = _tmp53_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2709 "tracker-sparql-pattern.c"
		} else {
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2727 "tracker-sparql-pattern.c"
		}
	}
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp52_) {
#line 2732 "tracker-sparql-pattern.c"
		TrackerSparqlContext* _tmp54_;
		TrackerSparqlContext* _tmp55_;
		GHashTable* _tmp56_;
		GList* _tmp57_;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp54_ = tracker_sparql_pattern_get_context (self);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp55_ = _tmp54_;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = _tmp55_->var_set;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = g_hash_table_get_keys (_tmp56_);
#line 2745 "tracker-sparql-pattern.c"
		{
			GList* variable_collection = NULL;
			GList* variable_it = NULL;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable_collection = _tmp57_;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2753 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* variable = NULL;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				variable = (TrackerSparqlVariable*) variable_it->data;
#line 2757 "tracker-sparql-pattern.c"
				{
					gboolean _tmp58_;
					gboolean _tmp60_;
					TrackerSparqlSelectContext* _tmp76_;
					TrackerSparqlSelectContext* _tmp77_;
					TrackerPropertyType* _tmp78_;
					gint _tmp78__length1;
					TrackerSparqlVariable* _tmp79_;
					TrackerSparqlVariableBinding* _tmp80_;
					TrackerPropertyType _tmp81_;
					TrackerSparqlSelectContext* _tmp82_;
					TrackerSparqlSelectContext* _tmp83_;
					gchar** _tmp84_;
					gint _tmp84__length1;
					TrackerSparqlVariable* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = first;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp58_) {
#line 2780 "tracker-sparql-pattern.c"
						GString* _tmp59_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = sql;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp59_, ", ");
#line 2786 "tracker-sparql-pattern.c"
					} else {
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 2790 "tracker-sparql-pattern.c"
					}
#line 314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = subquery;
#line 314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp60_) {
#line 2796 "tracker-sparql-pattern.c"
						GString* _tmp61_;
						TrackerSparqlVariable* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = sql;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp62_ = variable;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp63_ = tracker_sparql_variable_get_sql_expression (_tmp62_);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp64_ = _tmp63_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp61_, _tmp64_);
#line 2811 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp65_;
						TrackerSparqlVariable* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						TrackerSparqlVariable* _tmp69_;
						TrackerSparqlVariableBinding* _tmp70_;
						TrackerPropertyType _tmp71_;
						GString* _tmp72_;
						TrackerSparqlVariable* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp65_ = sql;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp66_ = variable;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp67_ = tracker_sparql_variable_get_sql_expression (_tmp66_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp68_ = _tmp67_;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp69_ = variable;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp70_ = _tmp69_->binding;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp71_ = ((TrackerSparqlDataBinding*) _tmp70_)->data_type;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_expression_append_expression_as_string (_tmp65_, _tmp68_, _tmp71_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = sql;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = variable;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_variable_get_name (_tmp73_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp72_, " AS \"%s\"", _tmp75_);
#line 2850 "tracker-sparql-pattern.c"
					}
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = _result_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = _result_;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_->types;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78__length1 = _tmp77_->types_length1;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = variable;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = _tmp79_->binding;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = ((TrackerSparqlDataBinding*) _tmp80_)->data_type;
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add5 (&_tmp76_->types, &_tmp76_->types_length1, &_tmp76_->_types_size_, _tmp81_);
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp82_ = _result_;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp83_ = _result_;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = _tmp83_->variable_names;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84__length1 = _tmp83_->variable_names_length1;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = variable;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = tracker_sparql_variable_get_name (_tmp85_);
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp87_ = _tmp86_;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = g_strdup (_tmp87_);
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add6 (&_tmp82_->variable_names, &_tmp82_->variable_names_length1, &_tmp82_->_variable_names_size_, _tmp88_);
#line 2886 "tracker-sparql-pattern.c"
				}
			}
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (variable_collection);
#line 2891 "tracker-sparql-pattern.c"
		}
	} else {
		{
			gint i = 0;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 2898 "tracker-sparql-pattern.c"
			{
				gboolean _tmp89_ = FALSE;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp89_ = TRUE;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 2905 "tracker-sparql-pattern.c"
					gint _tmp91_;
					TrackerPropertyType _tmp93_ = 0;
					TrackerSparqlExpression* _tmp94_;
					GString* _tmp95_;
					gboolean _tmp96_;
					gint _tmp97_;
					TrackerPropertyType _tmp98_;
					TrackerSparqlSelectContext* _tmp99_;
					TrackerSparqlSelectContext* _tmp100_;
					TrackerPropertyType* _tmp101_;
					gint _tmp101__length1;
					TrackerPropertyType _tmp102_;
					TrackerSparqlTokenType _tmp103_;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp89_) {
#line 2921 "tracker-sparql-pattern.c"
						gint _tmp90_;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp90_ = i;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp90_ + 1;
#line 2927 "tracker-sparql-pattern.c"
					}
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = FALSE;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp91_ = i;
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp91_ > 0) {
#line 2937 "tracker-sparql-pattern.c"
						GString* _tmp92_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp92_ = sql;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp92_, ", ");
#line 2943 "tracker-sparql-pattern.c"
					}
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = self->priv->expression;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = sql;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = subquery;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = i;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp98_ = tracker_sparql_expression_translate_select_expression (_tmp94_, _tmp95_, _tmp96_, _tmp97_, &_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = _tmp98_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2975 "tracker-sparql-pattern.c"
						} else {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2993 "tracker-sparql-pattern.c"
						}
					}
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					type = _tmp93_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = _result_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = _result_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = _tmp100_->types;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101__length1 = _tmp100_->types_length1;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp102_ = type;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add7 (&_tmp99_->types, &_tmp99_->types_length1, &_tmp99_->_types_size_, _tmp102_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp103_ = tracker_sparql_pattern_current (self);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					switch (_tmp103_) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 3030 "tracker-sparql-pattern.c"
						{
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 3034 "tracker-sparql-pattern.c"
						}
						default:
						{
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							continue;
#line 3040 "tracker-sparql-pattern.c"
						}
					}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 3045 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp105_ = self->queries_fts_data;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp105_) {
#line 3054 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp106_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp106_ = self->fts_subject;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp104_ = _tmp106_ != NULL;
#line 3060 "tracker-sparql-pattern.c"
	} else {
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp104_ = FALSE;
#line 3064 "tracker-sparql-pattern.c"
	}
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp104_) {
#line 3068 "tracker-sparql-pattern.c"
		gboolean _tmp107_;
		GString* _tmp109_;
		TrackerSparqlVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp107_ = first;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp107_) {
#line 3080 "tracker-sparql-pattern.c"
			GString* _tmp108_;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp108_ = sql;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp108_, ", ");
#line 3086 "tracker-sparql-pattern.c"
		} else {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = FALSE;
#line 3090 "tracker-sparql-pattern.c"
		}
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp109_ = sql;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp110_ = self->fts_subject;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp111_ = tracker_sparql_variable_get_sql_expression (_tmp110_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp112_ = _tmp111_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp113_ = g_strdup_printf ("%s AS rowid ", _tmp112_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp114_ = _tmp113_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp109_, _tmp114_);
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp114_);
#line 3108 "tracker-sparql-pattern.c"
	}
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp115_ = where_bindings;
#line 3112 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp115_;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 3120 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp116_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp116_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp116_;
#line 3127 "tracker-sparql-pattern.c"
			{
				TrackerSparqlQuery* _tmp117_;
				TrackerSparqlLiteralBinding* _tmp118_;
				TrackerSparqlLiteralBinding* _tmp119_;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_ = self->priv->query;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp118_ = binding;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_ = _g_object_ref0 (_tmp118_);
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_->bindings = g_list_append (_tmp117_->bindings, _tmp119_);
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 3142 "tracker-sparql-pattern.c"
			}
		}
	}
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp120_ = first;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp120_) {
#line 3150 "tracker-sparql-pattern.c"
		GString* _tmp121_;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp121_ = sql;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp121_, "NULL");
#line 3156 "tracker-sparql-pattern.c"
	}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp122_ = sql;
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp122_, " FROM (");
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp123_ = sql;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp124_ = pattern_sql;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp125_ = _tmp124_->str;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp123_, _tmp125_);
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp126_ = sql;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp126_, ")");
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp127_ = after_where;
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp127_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp129_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp128_ = _tmp129_;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3200 "tracker-sparql-pattern.c"
		} else {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3218 "tracker-sparql-pattern.c"
		}
	}
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp128_) {
#line 3223 "tracker-sparql-pattern.c"
		GString* _tmp130_;
		gboolean first_group = FALSE;
		gboolean _tmp149_ = FALSE;
		gboolean _tmp150_;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3248 "tracker-sparql-pattern.c"
			} else {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3266 "tracker-sparql-pattern.c"
			}
		}
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp130_ = sql;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp130_, " GROUP BY ");
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_group = TRUE;
#line 3275 "tracker-sparql-pattern.c"
		{
			gboolean _tmp131_ = FALSE;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp131_ = TRUE;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3282 "tracker-sparql-pattern.c"
				gboolean _tmp145_;
				TrackerSparqlExpression* _tmp147_;
				GString* _tmp148_;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp131_) {
#line 3288 "tracker-sparql-pattern.c"
					gboolean _tmp132_ = FALSE;
					gboolean _tmp133_ = FALSE;
					gboolean _tmp134_ = FALSE;
					gboolean _tmp135_ = FALSE;
					gboolean _tmp136_ = FALSE;
					gboolean _tmp137_ = FALSE;
					TrackerSparqlTokenType _tmp138_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp138_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp138_ != TRACKER_SPARQL_TOKEN_TYPE_HAVING) {
#line 3300 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp139_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp139_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = _tmp139_ != TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 3306 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = FALSE;
#line 3310 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp137_) {
#line 3314 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp140_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp140_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = _tmp140_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 3320 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = FALSE;
#line 3324 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp136_) {
#line 3328 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp141_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp141_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = _tmp141_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3334 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = FALSE;
#line 3338 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp135_) {
#line 3342 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp142_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp142_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp134_ = _tmp142_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3348 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp134_ = FALSE;
#line 3352 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp134_) {
#line 3356 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp143_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp143_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp133_ = _tmp143_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3362 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp133_ = FALSE;
#line 3366 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp133_) {
#line 3370 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp144_;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp144_ = tracker_sparql_pattern_current (self);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp132_ = _tmp144_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3376 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp132_ = FALSE;
#line 3380 "tracker-sparql-pattern.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp132_) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3386 "tracker-sparql-pattern.c"
					}
				}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp131_ = FALSE;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp145_ = first_group;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp145_) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_group = FALSE;
#line 3397 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp146_;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp146_ = sql;
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp146_, ", ");
#line 3404 "tracker-sparql-pattern.c"
				}
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp147_ = self->priv->expression;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp148_ = sql;
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_expression (_tmp147_, _tmp148_, &_inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3430 "tracker-sparql-pattern.c"
					} else {
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3448 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp150_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_HAVING, &_inner_error_);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp149_ = _tmp150_;
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3475 "tracker-sparql-pattern.c"
			} else {
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3493 "tracker-sparql-pattern.c"
			}
		}
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp149_) {
#line 3498 "tracker-sparql-pattern.c"
			GString* _tmp151_;
			TrackerSparqlExpression* _tmp152_;
			GString* _tmp153_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp151_ = sql;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp151_, " HAVING ");
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp152_ = self->priv->expression;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp153_ = sql;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_expression_translate_constraint (_tmp152_, _tmp153_, &_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3530 "tracker-sparql-pattern.c"
				} else {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3548 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp155_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp154_ = _tmp155_;
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3575 "tracker-sparql-pattern.c"
		} else {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3593 "tracker-sparql-pattern.c"
		}
	}
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp154_) {
#line 3598 "tracker-sparql-pattern.c"
		GString* _tmp156_;
		gboolean first_order = FALSE;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3621 "tracker-sparql-pattern.c"
			} else {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3639 "tracker-sparql-pattern.c"
			}
		}
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp156_ = sql;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp156_, " ORDER BY ");
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_order = TRUE;
#line 3648 "tracker-sparql-pattern.c"
		{
			gboolean _tmp157_ = FALSE;
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp157_ = TRUE;
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3655 "tracker-sparql-pattern.c"
				gboolean _tmp167_;
				TrackerSparqlExpression* _tmp169_;
				GString* _tmp170_;
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp157_) {
#line 3661 "tracker-sparql-pattern.c"
					gboolean _tmp158_ = FALSE;
					gboolean _tmp159_ = FALSE;
					gboolean _tmp160_ = FALSE;
					gboolean _tmp161_ = FALSE;
					TrackerSparqlTokenType _tmp162_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp162_ = tracker_sparql_pattern_current (self);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp162_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
#line 3671 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp163_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp163_ = tracker_sparql_pattern_current (self);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp161_ = _tmp163_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3677 "tracker-sparql-pattern.c"
					} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp161_ = FALSE;
#line 3681 "tracker-sparql-pattern.c"
					}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp161_) {
#line 3685 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp164_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp164_ = tracker_sparql_pattern_current (self);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp160_ = _tmp164_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3691 "tracker-sparql-pattern.c"
					} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp160_ = FALSE;
#line 3695 "tracker-sparql-pattern.c"
					}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp160_) {
#line 3699 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp165_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp165_ = tracker_sparql_pattern_current (self);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp159_ = _tmp165_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3705 "tracker-sparql-pattern.c"
					} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp159_ = FALSE;
#line 3709 "tracker-sparql-pattern.c"
					}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp159_) {
#line 3713 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp166_;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp166_ = tracker_sparql_pattern_current (self);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp158_ = _tmp166_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3719 "tracker-sparql-pattern.c"
					} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp158_ = FALSE;
#line 3723 "tracker-sparql-pattern.c"
					}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp158_) {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3729 "tracker-sparql-pattern.c"
					}
				}
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp157_ = FALSE;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp167_ = first_order;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp167_) {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_order = FALSE;
#line 3740 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp168_;
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp168_ = sql;
#line 406 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp168_, ", ");
#line 3747 "tracker-sparql-pattern.c"
				}
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp169_ = self->priv->expression;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp170_ = sql;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_order_condition (_tmp169_, _tmp170_, &_inner_error_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3773 "tracker-sparql-pattern.c"
					} else {
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3791 "tracker-sparql-pattern.c"
					}
				}
			}
		}
	}
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	limit = -1;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offset = -1;
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp172_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp171_ = _tmp172_;
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3823 "tracker-sparql-pattern.c"
		} else {
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3841 "tracker-sparql-pattern.c"
		}
	}
#line 415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp171_) {
#line 3846 "tracker-sparql-pattern.c"
		gchar* _tmp173_;
		gchar* _tmp174_;
		gint _tmp175_;
		gboolean _tmp176_ = FALSE;
		gboolean _tmp177_;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3872 "tracker-sparql-pattern.c"
			} else {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3890 "tracker-sparql-pattern.c"
			}
		}
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp173_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp174_ = _tmp173_;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp175_ = atoi (_tmp174_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		limit = _tmp175_;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp174_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp177_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp176_ = _tmp177_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3925 "tracker-sparql-pattern.c"
			} else {
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3943 "tracker-sparql-pattern.c"
			}
		}
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp176_) {
#line 3948 "tracker-sparql-pattern.c"
			gchar* _tmp178_;
			gchar* _tmp179_;
			gint _tmp180_;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3972 "tracker-sparql-pattern.c"
				} else {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3990 "tracker-sparql-pattern.c"
				}
			}
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp178_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp179_ = _tmp178_;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp180_ = atoi (_tmp179_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp180_;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp179_);
#line 4003 "tracker-sparql-pattern.c"
		}
	} else {
		gboolean _tmp181_ = FALSE;
		gboolean _tmp182_;
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp182_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp181_ = _tmp182_;
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4030 "tracker-sparql-pattern.c"
			} else {
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4048 "tracker-sparql-pattern.c"
			}
		}
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp181_) {
#line 4053 "tracker-sparql-pattern.c"
			gchar* _tmp183_;
			gchar* _tmp184_;
			gint _tmp185_;
			gboolean _tmp186_ = FALSE;
			gboolean _tmp187_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4079 "tracker-sparql-pattern.c"
				} else {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4097 "tracker-sparql-pattern.c"
				}
			}
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp183_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp184_ = _tmp183_;
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp185_ = atoi (_tmp184_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp185_;
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp184_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp187_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp186_ = _tmp187_;
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4132 "tracker-sparql-pattern.c"
				} else {
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4150 "tracker-sparql-pattern.c"
				}
			}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp186_) {
#line 4155 "tracker-sparql-pattern.c"
				gchar* _tmp188_;
				gchar* _tmp189_;
				gint _tmp190_;
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4179 "tracker-sparql-pattern.c"
					} else {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4197 "tracker-sparql-pattern.c"
					}
				}
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp188_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp189_ = _tmp188_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp190_ = atoi (_tmp189_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				limit = _tmp190_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp189_);
#line 4210 "tracker-sparql-pattern.c"
			}
		}
	}
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp191_ = limit;
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp191_ >= 0) {
#line 4218 "tracker-sparql-pattern.c"
		GString* _tmp192_;
		TrackerSparqlLiteralBinding* binding = NULL;
		TrackerSparqlLiteralBinding* _tmp193_;
		TrackerSparqlLiteralBinding* _tmp194_;
		gint _tmp195_;
		gchar* _tmp196_;
		TrackerSparqlLiteralBinding* _tmp197_;
		TrackerSparqlQuery* _tmp198_;
		TrackerSparqlLiteralBinding* _tmp199_;
		TrackerSparqlLiteralBinding* _tmp200_;
		gint _tmp201_;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp192_ = sql;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp192_, " LIMIT ?");
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp193_ = tracker_sparql_literal_binding_new ();
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp193_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp194_ = binding;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp195_ = limit;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp196_ = g_strdup_printf ("%i", _tmp195_);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp194_->literal);
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp194_->literal = _tmp196_;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp197_ = binding;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp197_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp198_ = self->priv->query;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp199_ = binding;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp200_ = _g_object_ref0 (_tmp199_);
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp198_->bindings = g_list_append (_tmp198_->bindings, _tmp200_);
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp201_ = offset;
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp201_ >= 0) {
#line 4264 "tracker-sparql-pattern.c"
			GString* _tmp202_;
			TrackerSparqlLiteralBinding* _tmp203_;
			TrackerSparqlLiteralBinding* _tmp204_;
			gint _tmp205_;
			gchar* _tmp206_;
			TrackerSparqlLiteralBinding* _tmp207_;
			TrackerSparqlQuery* _tmp208_;
			TrackerSparqlLiteralBinding* _tmp209_;
			TrackerSparqlLiteralBinding* _tmp210_;
#line 441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp202_ = sql;
#line 441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp202_, " OFFSET ?");
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp203_ = tracker_sparql_literal_binding_new ();
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp203_;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp204_ = binding;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp205_ = offset;
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp206_ = g_strdup_printf ("%i", _tmp205_);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp204_->literal);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp204_->literal = _tmp206_;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp207_ = binding;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp207_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp208_ = self->priv->query;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp209_ = binding;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp210_ = _g_object_ref0 (_tmp209_);
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp208_->bindings = g_list_append (_tmp208_->bindings, _tmp210_);
#line 4306 "tracker-sparql-pattern.c"
		}
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 4310 "tracker-sparql-pattern.c"
	} else {
		gint _tmp211_;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = offset;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp211_ >= 0) {
#line 4317 "tracker-sparql-pattern.c"
			GString* _tmp212_;
			TrackerSparqlLiteralBinding* binding = NULL;
			TrackerSparqlLiteralBinding* _tmp213_;
			TrackerSparqlLiteralBinding* _tmp214_;
			gint _tmp215_;
			gchar* _tmp216_;
			TrackerSparqlLiteralBinding* _tmp217_;
			TrackerSparqlQuery* _tmp218_;
			TrackerSparqlLiteralBinding* _tmp219_;
			TrackerSparqlLiteralBinding* _tmp220_;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp212_ = sql;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp212_, " LIMIT -1 OFFSET ?");
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp213_ = tracker_sparql_literal_binding_new ();
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp213_;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp214_ = binding;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp215_ = offset;
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp216_ = g_strdup_printf ("%i", _tmp215_);
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp214_->literal);
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp214_->literal = _tmp216_;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp217_ = binding;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp217_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_ = self->priv->query;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = binding;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = _g_object_ref0 (_tmp219_);
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_->bindings = g_list_append (_tmp218_->bindings, _tmp220_);
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 4360 "tracker-sparql-pattern.c"
		}
	}
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp223_ = self->queries_fts_data;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp223_) {
#line 4367 "tracker-sparql-pattern.c"
		GString* _tmp224_;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp224_ = self->match_str;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp222_ = _tmp224_ != NULL;
#line 4373 "tracker-sparql-pattern.c"
	} else {
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp222_ = FALSE;
#line 4377 "tracker-sparql-pattern.c"
	}
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp222_) {
#line 4381 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp225_;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp225_ = self->fts_subject;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp221_ = _tmp225_ != NULL;
#line 4387 "tracker-sparql-pattern.c"
	} else {
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp221_ = FALSE;
#line 4391 "tracker-sparql-pattern.c"
	}
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp221_) {
#line 4395 "tracker-sparql-pattern.c"
		GString* str = NULL;
		GString* _tmp226_;
		gchar** _tmp227_;
		gint _tmp227__length1;
		GString* _tmp233_;
		GString* _tmp234_;
		GString* _tmp235_;
		const gchar* _tmp236_;
		GString* _tmp237_;
		GString* _tmp238_;
		const gchar* _tmp239_;
		gchar* _tmp240_;
		gchar* _tmp241_;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp226_ = g_string_new ("SELECT ");
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		str = _tmp226_;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first = TRUE;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp227_ = self->fts_variables;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp227__length1 = self->fts_variables_length1;
#line 4419 "tracker-sparql-pattern.c"
		{
			gchar** fts_var_collection = NULL;
			gint fts_var_collection_length1 = 0;
			gint _fts_var_collection_size_ = 0;
			gint fts_var_it = 0;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection = _tmp227_;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection_length1 = _tmp227__length1;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (fts_var_it = 0; fts_var_it < _tmp227__length1; fts_var_it = fts_var_it + 1) {
#line 4431 "tracker-sparql-pattern.c"
				gchar* _tmp228_;
				gchar* fts_var = NULL;
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = g_strdup (fts_var_collection[fts_var_it]);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				fts_var = _tmp228_;
#line 4438 "tracker-sparql-pattern.c"
				{
					gboolean _tmp229_;
					GString* _tmp231_;
					const gchar* _tmp232_;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp229_ = first;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp229_) {
#line 4447 "tracker-sparql-pattern.c"
						GString* _tmp230_;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp230_ = str;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp230_, ", ");
#line 4453 "tracker-sparql-pattern.c"
					} else {
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 4457 "tracker-sparql-pattern.c"
					}
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp231_ = str;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp232_ = fts_var;
#line 468 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp231_, _tmp232_);
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (fts_var);
#line 4467 "tracker-sparql-pattern.c"
				}
			}
		}
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp233_ = str;
#line 471 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp233_, " FROM fts5 JOIN (");
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp234_ = sql;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp235_ = str;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp236_ = _tmp235_->str;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_prepend (_tmp234_, _tmp236_);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp237_ = sql;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp238_ = self->match_str;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp239_ = _tmp238_->str;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp240_ = g_strdup_printf (") AS ranks ON fts5.rowid=rowid WHERE fts5 %s", _tmp239_);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp241_ = _tmp240_;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp237_, "%s", _tmp241_);
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp241_);
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (str);
#line 4499 "tracker-sparql-pattern.c"
	}
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp242_ = tracker_sparql_pattern_get_context (self);
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp243_ = _tmp242_;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp244_ = _tmp243_->parent_context;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp244_);
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp245_ = _result_;
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp246_ = type;
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp245_->type = _tmp246_;
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->match_str = NULL;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_subject = NULL;
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (where_bindings);
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (old_bindings);
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (pattern_sql);
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 4535 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error) {
	gboolean not = FALSE;
	gboolean _tmp0_;
	TrackerSparqlSelectContext* _result_ = NULL;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlContext* _tmp3_;
	TrackerSparqlSelectContext* _tmp4_;
	TrackerSparqlSelectContext* _tmp5_;
	gboolean _tmp6_;
	TrackerSparqlContext* pattern = NULL;
	GString* _tmp9_;
	TrackerSparqlContext* _tmp10_;
	TrackerSparqlContext* _tmp11_;
	GHashTable* _tmp12_;
	GList* _tmp13_;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	GHashTable* _tmp21_;
	GList* _tmp22_;
	GString* _tmp32_;
	TrackerSparqlContext* _tmp33_;
	TrackerSparqlContext* _tmp34_;
	TrackerSparqlContext* _tmp35_;
	GError * _inner_error_ = NULL;
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	not = _tmp0_;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4580 "tracker-sparql-pattern.c"
		} else {
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4588 "tracker-sparql-pattern.c"
		}
	}
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EXISTS, &_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4601 "tracker-sparql-pattern.c"
		} else {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4609 "tracker-sparql-pattern.c"
		}
	}
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _tmp2_;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp4_;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _result_;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp5_);
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = not;
#line 493 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp6_) {
#line 4632 "tracker-sparql-pattern.c"
		GString* _tmp7_;
#line 495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = sql;
#line 495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp7_, "NOT EXISTS (");
#line 4638 "tracker-sparql-pattern.c"
	} else {
		GString* _tmp8_;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = sql;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp8_, "EXISTS (");
#line 4645 "tracker-sparql-pattern.c"
	}
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = sql;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp9_, &_inner_error_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp10_;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4663 "tracker-sparql-pattern.c"
		} else {
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4673 "tracker-sparql-pattern.c"
		}
	}
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = pattern;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->var_set;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = g_hash_table_get_keys (_tmp12_);
#line 4682 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp13_;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 4690 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 4694 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp14_;
				TrackerSparqlContext* _tmp15_;
				GHashTable* _tmp16_;
				TrackerSparqlVariable* _tmp17_;
				TrackerSparqlVariable* _tmp18_;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = _tmp14_;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = _tmp15_->var_set;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = key;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp16_, _tmp18_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 4713 "tracker-sparql-pattern.c"
			}
		}
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 4718 "tracker-sparql-pattern.c"
	}
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = tracker_sparql_pattern_get_context (self);
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = _tmp19_;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _tmp20_->var_set;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_hash_table_get_keys (_tmp21_);
#line 4728 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp22_;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 4736 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 4740 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp23_;
				TrackerSparqlVariableBinding* _tmp24_;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = variable;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = _tmp23_->binding;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp24_ == NULL) {
#line 4750 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					GError* _tmp30_;
					GError* _tmp31_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = variable;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_variable_get_name (_tmp25_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = _tmp26_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = g_strdup_printf ("use of undefined variable `%s'", _tmp27_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _tmp28_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = tracker_sparql_pattern_get_error (self, _tmp29_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp31_ = _tmp30_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp29_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp31_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4788 "tracker-sparql-pattern.c"
					} else {
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4802 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 4809 "tracker-sparql-pattern.c"
	}
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp32_ = sql;
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp32_, ")");
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp33_ = tracker_sparql_pattern_get_context (self);
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = _tmp33_;
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = _tmp34_->parent_context;
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp35_);
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 4827 "tracker-sparql-pattern.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4850 "tracker-sparql-pattern.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 4858 "tracker-sparql-pattern.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 4870 "tracker-sparql-pattern.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 4894 "tracker-sparql-pattern.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 4900 "tracker-sparql-pattern.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 4904 "tracker-sparql-pattern.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 4908 "tracker-sparql-pattern.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 4920 "tracker-sparql-pattern.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 4930 "tracker-sparql-pattern.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 4936 "tracker-sparql-pattern.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 4950 "tracker-sparql-pattern.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 4960 "tracker-sparql-pattern.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 4966 "tracker-sparql-pattern.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 4975 "tracker-sparql-pattern.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 4995 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	gboolean _vala_is_var = FALSE;
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_strdup ("");
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp0_;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_is_var = FALSE;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_current (self);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 5018 "tracker-sparql-pattern.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_is_var = TRUE;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_next (self, &_inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 5036 "tracker-sparql-pattern.c"
			} else {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 5046 "tracker-sparql-pattern.c"
			}
		}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) -1);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp3_);
#line 5061 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlTokenType _tmp5_;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = tracker_sparql_pattern_current (self);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 5068 "tracker-sparql-pattern.c"
			gchar* _tmp6_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 5082 "tracker-sparql-pattern.c"
				} else {
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 5092 "tracker-sparql-pattern.c"
				}
			}
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_result_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_result_ = _tmp6_;
#line 5101 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 5108 "tracker-sparql-pattern.c"
				gchar* ns = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				TrackerSparqlQuery* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5133 "tracker-sparql-pattern.c"
					} else {
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5143 "tracker-sparql-pattern.c"
					}
				}
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp8_;
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5164 "tracker-sparql-pattern.c"
					} else {
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5176 "tracker-sparql-pattern.c"
					}
				}
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = self->priv->query;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp11_ = ns;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp12_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = _tmp12_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = string_substring (_tmp13_, (glong) 1, (glong) -1);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = _tmp14_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = tracker_sparql_query_resolve_prefixed_name (_tmp10_, _tmp11_, _tmp15_, &_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = _tmp16_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp15_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp13_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = _tmp17_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5213 "tracker-sparql-pattern.c"
					} else {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5225 "tracker-sparql-pattern.c"
					}
				}
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tmp9_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = NULL;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_result_ = _tmp18_;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp9_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 5240 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp19_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = tracker_sparql_pattern_current (self);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp19_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 5247 "tracker-sparql-pattern.c"
					gchar* _tmp20_ = NULL;
					TrackerSparqlQuery* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5269 "tracker-sparql-pattern.c"
						} else {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5279 "tracker-sparql-pattern.c"
						}
					}
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = self->priv->query;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp22_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = _tmp22_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) -1);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = _tmp24_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_query_resolve_prefixed_name (_tmp21_, "", _tmp25_, &_inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = _tmp26_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp25_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp23_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp27_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5312 "tracker-sparql-pattern.c"
						} else {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5322 "tracker-sparql-pattern.c"
						}
					}
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = _tmp20_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = NULL;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_result_ = _tmp28_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp20_);
#line 5335 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _tmp30_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5353 "tracker-sparql-pattern.c"
						} else {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5363 "tracker-sparql-pattern.c"
						}
					}
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp29_) {
#line 5368 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5387 "tracker-sparql-pattern.c"
							} else {
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5397 "tracker-sparql-pattern.c"
							}
						}
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = self->priv->query;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp33_ = _tmp32_;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp35_ = _tmp34_;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp36_ = tracker_sparql_query_generate_bnodeid (_tmp31_, _tmp35_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_result_ = _tmp36_;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp35_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 5420 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp37_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp37_ = tracker_sparql_pattern_current (self);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
#line 5427 "tracker-sparql-pattern.c"
							gchar* _tmp38_ = NULL;
							TrackerSparqlExpression* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp39_ = self->priv->expression;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp40_ = tracker_sparql_expression_parse_string_literal (_tmp39_, NULL, &_inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp38_ = _tmp40_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5448 "tracker-sparql-pattern.c"
								} else {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5458 "tracker-sparql-pattern.c"
								}
							}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp41_ = _tmp38_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp38_ = NULL;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_result_ = _tmp41_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp38_);
#line 5471 "tracker-sparql-pattern.c"
						} else {
							TrackerSparqlTokenType _tmp42_;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp42_ = tracker_sparql_pattern_current (self);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp42_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
#line 5478 "tracker-sparql-pattern.c"
								gchar* _tmp43_ = NULL;
								TrackerSparqlExpression* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp44_ = self->priv->expression;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp45_ = tracker_sparql_expression_parse_string_literal (_tmp44_, NULL, &_inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp43_ = _tmp45_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_propagate_error (error, _inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5499 "tracker-sparql-pattern.c"
									} else {
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_clear_error (&_inner_error_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5509 "tracker-sparql-pattern.c"
									}
								}
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46_ = _tmp43_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp43_ = NULL;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_result_ = _tmp46_;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp43_);
#line 5522 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlTokenType _tmp47_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47_ = tracker_sparql_pattern_current (self);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
#line 5529 "tracker-sparql-pattern.c"
									gchar* _tmp48_ = NULL;
									TrackerSparqlExpression* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = self->priv->expression;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = tracker_sparql_expression_parse_string_literal (_tmp49_, NULL, &_inner_error_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = _tmp50_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_propagate_error (error, _inner_error_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5550 "tracker-sparql-pattern.c"
										} else {
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_clear_error (&_inner_error_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5560 "tracker-sparql-pattern.c"
										}
									}
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = _tmp48_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = NULL;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_result_ = _tmp51_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp48_);
#line 5573 "tracker-sparql-pattern.c"
								} else {
									TrackerSparqlTokenType _tmp52_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = tracker_sparql_pattern_current (self);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp52_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
#line 5580 "tracker-sparql-pattern.c"
										gchar* _tmp53_ = NULL;
										TrackerSparqlExpression* _tmp54_;
										gchar* _tmp55_;
										gchar* _tmp56_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp54_ = self->priv->expression;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp55_ = tracker_sparql_expression_parse_string_literal (_tmp54_, NULL, &_inner_error_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp53_ = _tmp55_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_propagate_error (error, _inner_error_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5601 "tracker-sparql-pattern.c"
											} else {
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_clear_error (&_inner_error_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5611 "tracker-sparql-pattern.c"
											}
										}
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp56_ = _tmp53_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp53_ = NULL;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_result_ = _tmp56_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp53_);
#line 5624 "tracker-sparql-pattern.c"
									} else {
										TrackerSparqlTokenType _tmp57_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp57_ = tracker_sparql_pattern_current (self);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp57_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 5631 "tracker-sparql-pattern.c"
											gchar* _tmp58_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											tracker_sparql_pattern_next (self, &_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_propagate_error (error, _inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5645 "tracker-sparql-pattern.c"
												} else {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_clear_error (&_inner_error_);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5655 "tracker-sparql-pattern.c"
												}
											}
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp58_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_result_ = _tmp58_;
#line 5664 "tracker-sparql-pattern.c"
										} else {
											TrackerSparqlTokenType _tmp59_;
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp59_ = tracker_sparql_pattern_current (self);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
#line 5671 "tracker-sparql-pattern.c"
												gchar* _tmp60_;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												tracker_sparql_pattern_next (self, &_inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_propagate_error (error, _inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5685 "tracker-sparql-pattern.c"
													} else {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_clear_error (&_inner_error_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5695 "tracker-sparql-pattern.c"
													}
												}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp60_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_result_ = _tmp60_;
#line 5704 "tracker-sparql-pattern.c"
											} else {
												TrackerSparqlTokenType _tmp61_;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp61_ = tracker_sparql_pattern_current (self);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
#line 5711 "tracker-sparql-pattern.c"
													gchar* _tmp62_;
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													tracker_sparql_pattern_next (self, &_inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_propagate_error (error, _inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5725 "tracker-sparql-pattern.c"
														} else {
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_clear_error (&_inner_error_);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5735 "tracker-sparql-pattern.c"
														}
													}
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp62_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_result_ = _tmp62_;
#line 5744 "tracker-sparql-pattern.c"
												} else {
													TrackerSparqlTokenType _tmp63_;
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp63_ = tracker_sparql_pattern_current (self);
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_tmp63_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
#line 5751 "tracker-sparql-pattern.c"
														gchar* _tmp64_;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														tracker_sparql_pattern_next (self, &_inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_propagate_error (error, _inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5765 "tracker-sparql-pattern.c"
															} else {
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_clear_error (&_inner_error_);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5775 "tracker-sparql-pattern.c"
															}
														}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp64_ = g_strdup ("true");
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_result_ = _tmp64_;
#line 5784 "tracker-sparql-pattern.c"
													} else {
														TrackerSparqlTokenType _tmp65_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp65_ = tracker_sparql_pattern_current (self);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_tmp65_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
#line 5791 "tracker-sparql-pattern.c"
															gchar* _tmp66_;
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															tracker_sparql_pattern_next (self, &_inner_error_);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5805 "tracker-sparql-pattern.c"
																} else {
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5815 "tracker-sparql-pattern.c"
																}
															}
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp66_ = g_strdup ("false");
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_result_ = _tmp66_;
#line 5824 "tracker-sparql-pattern.c"
														} else {
															TrackerSparqlTokenType _tmp67_;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp67_ = tracker_sparql_pattern_current (self);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_tmp67_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
#line 5831 "tracker-sparql-pattern.c"
																TrackerSparqlQuery* _tmp68_;
																gchar* _tmp69_;
																gchar* old_subject = NULL;
																const gchar* _tmp70_;
																gchar* _tmp71_;
																gboolean old_subject_is_var = FALSE;
																gboolean _tmp72_;
																const gchar* _tmp73_;
																gchar* _tmp74_;
																GString* _tmp75_;
																const gchar* _tmp76_;
																gchar* _tmp77_;
																gboolean _tmp78_;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_next (self, &_inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5857 "tracker-sparql-pattern.c"
																	} else {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5867 "tracker-sparql-pattern.c"
																	}
																}
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp68_ = self->priv->query;
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp69_ = tracker_sparql_query_generate_bnodeid (_tmp68_, NULL);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_result_ = _tmp69_;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp70_ = self->priv->current_subject;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp71_ = g_strdup (_tmp70_);
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject = _tmp71_;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp72_ = self->priv->current_subject_is_var;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject_is_var = _tmp72_;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp73_ = _result_;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp74_ = g_strdup (_tmp73_);
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp74_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = TRUE;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp75_ = sql;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp75_, FALSE, &_inner_error_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5914 "tracker-sparql-pattern.c"
																	} else {
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5926 "tracker-sparql-pattern.c"
																	}
																}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5943 "tracker-sparql-pattern.c"
																	} else {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5955 "tracker-sparql-pattern.c"
																	}
																}
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp76_ = old_subject;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp77_ = g_strdup (_tmp76_);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp77_;
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp78_ = old_subject_is_var;
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = _tmp78_;
#line 581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_vala_is_var = TRUE;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (old_subject);
#line 5974 "tracker-sparql-pattern.c"
															} else {
																GError* _tmp79_;
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp79_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_inner_error_ = _tmp79_;
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5989 "tracker-sparql-pattern.c"
																} else {
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5999 "tracker-sparql-pattern.c"
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (is_var) {
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*is_var = _vala_is_var;
#line 6022 "tracker-sparql-pattern.c"
	}
#line 585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 6026 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6038 "tracker-sparql-pattern.c"
		GString* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = sql;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = in_simple_optional;
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object (self, _tmp0_, _tmp1_, &_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6057 "tracker-sparql-pattern.c"
			} else {
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6065 "tracker-sparql-pattern.c"
			}
		}
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp3_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6080 "tracker-sparql-pattern.c"
			} else {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6088 "tracker-sparql-pattern.c"
			}
		}
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 6095 "tracker-sparql-pattern.c"
		}
#line 594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 6099 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6112 "tracker-sparql-pattern.c"
		gchar* old_predicate = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean old_predicate_is_var = FALSE;
		gboolean _tmp2_;
		TrackerSparqlTokenType _tmp3_;
		GString* _tmp34_;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = self->priv->current_predicate;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate = _tmp1_;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = self->priv->current_predicate_is_var;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate_is_var = _tmp2_;
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = NULL;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = FALSE;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_current (self);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 6146 "tracker-sparql-pattern.c"
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate_is_var = TRUE;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6164 "tracker-sparql-pattern.c"
				} else {
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6174 "tracker-sparql-pattern.c"
				}
			}
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _tmp4_;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (self->priv->current_predicate);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate = _tmp6_;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp5_);
#line 6189 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 6196 "tracker-sparql-pattern.c"
				gchar* _tmp8_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6210 "tracker-sparql-pattern.c"
					} else {
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6220 "tracker-sparql-pattern.c"
					}
				}
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_predicate);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_predicate = _tmp8_;
#line 6229 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp9_;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = tracker_sparql_pattern_current (self);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 6236 "tracker-sparql-pattern.c"
					gchar* ns = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					TrackerSparqlQuery* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6261 "tracker-sparql-pattern.c"
						} else {
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6271 "tracker-sparql-pattern.c"
						}
					}
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					ns = _tmp10_;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6292 "tracker-sparql-pattern.c"
						} else {
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6304 "tracker-sparql-pattern.c"
						}
					}
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = self->priv->query;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = ns;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = _tmp14_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = _tmp16_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = tracker_sparql_query_resolve_prefixed_name (_tmp12_, _tmp13_, _tmp17_, &_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = _tmp18_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp17_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp15_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = _tmp19_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6341 "tracker-sparql-pattern.c"
						} else {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6353 "tracker-sparql-pattern.c"
						}
					}
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp11_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = NULL;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (self->priv->current_predicate);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->priv->current_predicate = _tmp20_;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp11_);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 6368 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlTokenType _tmp21_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = tracker_sparql_pattern_current (self);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp21_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 6375 "tracker-sparql-pattern.c"
						gchar* _tmp22_ = NULL;
						TrackerSparqlQuery* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_next (self, &_inner_error_);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6397 "tracker-sparql-pattern.c"
							} else {
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6407 "tracker-sparql-pattern.c"
							}
						}
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp23_ = self->priv->query;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp24_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp25_ = _tmp24_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp27_ = _tmp26_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp28_ = tracker_sparql_query_resolve_prefixed_name (_tmp23_, "", _tmp27_, &_inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp29_ = _tmp28_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp27_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp25_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp22_ = _tmp29_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6440 "tracker-sparql-pattern.c"
							} else {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6450 "tracker-sparql-pattern.c"
							}
						}
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp30_ = _tmp22_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp22_ = NULL;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (self->priv->current_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->priv->current_predicate = _tmp30_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp22_);
#line 6463 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp31_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = tracker_sparql_pattern_current (self);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp31_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
#line 6470 "tracker-sparql-pattern.c"
							gchar* _tmp32_;
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_next (self, &_inner_error_);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6484 "tracker-sparql-pattern.c"
								} else {
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6494 "tracker-sparql-pattern.c"
								}
							}
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp32_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (self->priv->current_predicate);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							self->priv->current_predicate = _tmp32_;
#line 6503 "tracker-sparql-pattern.c"
						} else {
							GError* _tmp33_;
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_inner_error_ = _tmp33_;
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6518 "tracker-sparql-pattern.c"
							} else {
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6528 "tracker-sparql-pattern.c"
							}
						}
					}
				}
			}
		}
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp34_ = sql;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp35_ = in_simple_optional;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object_list (self, _tmp34_, _tmp35_, &_inner_error_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6551 "tracker-sparql-pattern.c"
			} else {
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6561 "tracker-sparql-pattern.c"
			}
		}
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp36_ = old_predicate;
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = _tmp37_;
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp38_ = old_predicate_is_var;
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = _tmp38_;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp40_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp39_ = _tmp40_;
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6590 "tracker-sparql-pattern.c"
			} else {
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6600 "tracker-sparql-pattern.c"
			}
		}
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp39_) {
#line 6605 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp41_;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp41_ = tracker_sparql_pattern_current (self);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp41_ == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 6615 "tracker-sparql-pattern.c"
			}
#line 636 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (old_predicate);
#line 636 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 6621 "tracker-sparql-pattern.c"
		}
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (old_predicate);
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 6627 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlExpression* _tmp0_;
	GString* _tmp1_;
	GError * _inner_error_ = NULL;
#line 642 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 642 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6650 "tracker-sparql-pattern.c"
		} else {
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6658 "tracker-sparql-pattern.c"
		}
	}
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->expression;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_translate_constraint (_tmp0_, _tmp1_, &_inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6675 "tracker-sparql-pattern.c"
		} else {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6683 "tracker-sparql-pattern.c"
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	gint n_parens = 0;
	GError * _inner_error_ = NULL;
#line 647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6705 "tracker-sparql-pattern.c"
		} else {
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6713 "tracker-sparql-pattern.c"
		}
	}
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (_tmp0_) {
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6742 "tracker-sparql-pattern.c"
		{
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6754 "tracker-sparql-pattern.c"
				} else {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6762 "tracker-sparql-pattern.c"
				}
			}
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6767 "tracker-sparql-pattern.c"
		}
		default:
		{
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6773 "tracker-sparql-pattern.c"
		}
	}
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6786 "tracker-sparql-pattern.c"
		} else {
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6794 "tracker-sparql-pattern.c"
		}
	}
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	n_parens = 1;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6801 "tracker-sparql-pattern.c"
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = n_parens;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!(_tmp1_ > 0)) {
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6811 "tracker-sparql-pattern.c"
		}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp3_;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6825 "tracker-sparql-pattern.c"
			} else {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6833 "tracker-sparql-pattern.c"
			}
		}
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 6838 "tracker-sparql-pattern.c"
			gint _tmp4_;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = n_parens;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			n_parens = _tmp4_ + 1;
#line 6844 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _tmp6_;
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6860 "tracker-sparql-pattern.c"
				} else {
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6868 "tracker-sparql-pattern.c"
				}
			}
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp5_) {
#line 6873 "tracker-sparql-pattern.c"
				gint _tmp7_;
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = n_parens;
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				n_parens = _tmp7_ - 1;
#line 6879 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp8_;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_current (self);
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 6886 "tracker-sparql-pattern.c"
					GError* _tmp9_;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp9_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp9_;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6898 "tracker-sparql-pattern.c"
					} else {
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6906 "tracker-sparql-pattern.c"
					}
				} else {
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6919 "tracker-sparql-pattern.c"
						} else {
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6927 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlPatternTripleContext* _tmp3_;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GString* _tmp5_;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_get_context (self);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_pattern_triple_context_new (_tmp0_, _tmp2_);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = _tmp3_;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp4_);
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = sql;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp5_, "SELECT ");
#line 6968 "tracker-sparql-pattern.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1079 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		separator = "";
#line 6985 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 6995 "tracker-sparql-pattern.c"
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 7005 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 7011 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 7022 "tracker-sparql-pattern.c"
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 7034 "tracker-sparql-pattern.c"
		} else {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 7038 "tracker-sparql-pattern.c"
		}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 7042 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 7046 "tracker-sparql-pattern.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
#line 1083 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 7069 "tracker-sparql-pattern.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 0;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 7078 "tracker-sparql-pattern.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 7091 "tracker-sparql-pattern.c"
					gint _tmp10_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 7097 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 7107 "tracker-sparql-pattern.c"
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 7119 "tracker-sparql-pattern.c"
				} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 7123 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 7129 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 7140 "tracker-sparql-pattern.c"
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 7155 "tracker-sparql-pattern.c"
					} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 7159 "tracker-sparql-pattern.c"
					}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 7163 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 7169 "tracker-sparql-pattern.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 7181 "tracker-sparql-pattern.c"
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 7202 "tracker-sparql-pattern.c"
				} else {
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 7206 "tracker-sparql-pattern.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 7212 "tracker-sparql-pattern.c"
			}
		}
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 7219 "tracker-sparql-pattern.c"
			gchar* _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return result;
#line 7227 "tracker-sparql-pattern.c"
		}
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 7265 "tracker-sparql-pattern.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 7274 "tracker-sparql-pattern.c"
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 7290 "tracker-sparql-pattern.c"
					gint _tmp47_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 7296 "tracker-sparql-pattern.c"
				}
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 7310 "tracker-sparql-pattern.c"
				}
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 7330 "tracker-sparql-pattern.c"
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 7345 "tracker-sparql-pattern.c"
				} else {
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 7349 "tracker-sparql-pattern.c"
				}
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 7357 "tracker-sparql-pattern.c"
			}
		}
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = NULL;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7368 "tracker-sparql-pattern.c"
	} else {
		gchar* _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7377 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	gssize _tmp2_;
	GString* _tmp3_;
	gboolean first = FALSE;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GList* _tmp5_;
	TrackerSparqlPatternTripleContext* _tmp23_;
	GList* _tmp24_;
	TrackerSparqlPatternTripleContext* _tmp80_;
	GList* _tmp81_;
	gboolean _tmp113_;
	TrackerSparqlContext* _tmp115_;
	TrackerSparqlContext* _tmp116_;
	GHashTable* _tmp117_;
	GList* _tmp118_;
	TrackerSparqlContext* _tmp125_;
	TrackerSparqlContext* _tmp126_;
	TrackerSparqlContext* _tmp127_;
	GError * _inner_error_ = NULL;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->len;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_truncate (_tmp0_, (gsize) (_tmp2_ - 2));
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = sql;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp3_, " FROM ");
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _tmp4_->tables;
#line 7425 "tracker-sparql-pattern.c"
	{
		GList* table_collection = NULL;
		GList* table_it = NULL;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table_collection = _tmp5_;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
#line 7433 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp6_;
			TrackerSparqlDataTable* table = NULL;
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			table = _tmp6_;
#line 7440 "tracker-sparql-pattern.c"
			{
				gboolean _tmp7_;
				TrackerSparqlDataTable* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp20_;
				TrackerSparqlDataTable* _tmp21_;
				const gchar* _tmp22_;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = first;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp7_) {
#line 7452 "tracker-sparql-pattern.c"
					GString* _tmp8_;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp8_ = sql;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp8_, ", ");
#line 7458 "tracker-sparql-pattern.c"
				} else {
#line 700 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 7462 "tracker-sparql-pattern.c"
				}
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = table;
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = _tmp9_->sql_db_tablename;
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp10_ != NULL) {
#line 7470 "tracker-sparql-pattern.c"
					GString* _tmp11_;
					TrackerSparqlDataTable* _tmp12_;
					const gchar* _tmp13_;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = sql;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = table;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = _tmp12_->sql_db_tablename;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp11_, "\"%s\"", _tmp13_);
#line 7482 "tracker-sparql-pattern.c"
				} else {
					gchar* _tmp14_ = NULL;
					TrackerSparqlDataTable* _tmp15_;
					TrackerSparqlPredicateVariable* _tmp16_;
					TrackerSparqlQuery* _tmp17_;
					gchar* _tmp18_;
					GString* _tmp19_;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = table;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = _tmp15_->predicate_variable;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = self->priv->query;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = tracker_sparql_predicate_variable_get_sql_query (_tmp16_, _tmp17_, &_inner_error_);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = _tmp18_;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 7510 "tracker-sparql-pattern.c"
						} else {
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 7520 "tracker-sparql-pattern.c"
						}
					}
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sql;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp19_, "(%s)", _tmp14_);
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp14_);
#line 7529 "tracker-sparql-pattern.c"
				}
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = sql;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = table;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = _tmp21_->sql_query_tablename;
#line 707 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp20_, " AS \"%s\"", _tmp22_);
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (table);
#line 7541 "tracker-sparql-pattern.c"
			}
		}
	}
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = self->priv->triple_context;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = _tmp23_->variables;
#line 7549 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp24_;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 7557 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* _tmp25_;
			TrackerSparqlVariable* variable = NULL;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp25_ = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = _tmp25_;
#line 7564 "tracker-sparql-pattern.c"
			{
				gboolean maybe_null = FALSE;
				gboolean in_simple_optional = FALSE;
				TrackerPropertyType last_type = 0;
				gchar* last_name = NULL;
				TrackerSparqlPatternTripleContext* _tmp26_;
				GHashTable* _tmp27_;
				TrackerSparqlVariable* _tmp28_;
				gconstpointer _tmp29_;
				GList* _tmp30_;
				gboolean _tmp70_ = FALSE;
				gboolean _tmp71_;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				maybe_null = TRUE;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				in_simple_optional = FALSE;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_name = NULL;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = self->priv->triple_context;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = _tmp26_->var_bindings;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = variable;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = ((TrackerSparqlVariableBindingList*) _tmp29_)->list;
#line 7595 "tracker-sparql-pattern.c"
				{
					GList* binding_collection = NULL;
					GList* binding_it = NULL;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_collection = _tmp30_;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7603 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBinding* _tmp31_;
						TrackerSparqlVariableBinding* binding = NULL;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						binding = _tmp31_;
#line 7610 "tracker-sparql-pattern.c"
						{
							gchar* name = NULL;
							TrackerSparqlVariableBinding* _tmp32_;
							TrackerSparqlDataTable* _tmp33_;
							TrackerPropertyType type = 0;
							TrackerSparqlVariableBinding* _tmp42_;
							TrackerPropertyType _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp63_;
							gchar* _tmp64_;
							TrackerPropertyType _tmp65_;
							TrackerSparqlVariableBinding* _tmp66_;
							gboolean _tmp67_;
							TrackerSparqlVariableBinding* _tmp68_;
							gboolean _tmp69_;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp32_ = binding;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = ((TrackerSparqlDataBinding*) _tmp32_)->table;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp33_ != NULL) {
#line 7632 "tracker-sparql-pattern.c"
								TrackerSparqlVariableBinding* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp34_ = binding;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp35_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp34_);
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp36_ = _tmp35_;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp37_ = g_strdup (_tmp36_);
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp37_;
#line 7649 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlVariable* _tmp38_;
								const gchar* _tmp39_;
								const gchar* _tmp40_;
								gchar* _tmp41_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp38_ = variable;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp39_ = tracker_sparql_variable_get_sql_expression (_tmp38_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp40_ = _tmp39_;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp41_ = g_strdup (_tmp40_);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp41_;
#line 7667 "tracker-sparql-pattern.c"
							}
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp42_ = binding;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp43_ = ((TrackerSparqlDataBinding*) _tmp42_)->data_type;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							type = _tmp43_;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp44_ = last_name;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp44_ != NULL) {
#line 7679 "tracker-sparql-pattern.c"
								gboolean _tmp45_;
								gboolean _tmp48_ = FALSE;
								TrackerPropertyType _tmp49_;
								GString* _tmp55_;
								gboolean _tmp56_ = FALSE;
								TrackerPropertyType _tmp57_;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp45_ = *first_where;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (!_tmp45_) {
#line 7690 "tracker-sparql-pattern.c"
									GString* _tmp46_;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp46_ = sql;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp46_, " AND ");
#line 7696 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp47_;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = sql;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp47_, " WHERE ");
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									*first_where = FALSE;
#line 7705 "tracker-sparql-pattern.c"
								}
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp49_ = last_type;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp49_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 7711 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp50_;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = type;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = _tmp50_ == TRACKER_PROPERTY_TYPE_RESOURCE;
#line 7717 "tracker-sparql-pattern.c"
								} else {
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = FALSE;
#line 7721 "tracker-sparql-pattern.c"
								}
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp48_) {
#line 7725 "tracker-sparql-pattern.c"
									GString* _tmp51_;
									const gchar* _tmp52_;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = sql;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = last_name;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp51_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp52_);
#line 7734 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp53_;
									const gchar* _tmp54_;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = sql;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp54_ = last_name;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp53_, _tmp54_);
#line 7744 "tracker-sparql-pattern.c"
								}
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp55_ = sql;
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp55_, " = ");
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp57_ = last_type;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp57_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 7754 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp58_;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = type;
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = _tmp58_ == TRACKER_PROPERTY_TYPE_STRING;
#line 7760 "tracker-sparql-pattern.c"
								} else {
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = FALSE;
#line 7764 "tracker-sparql-pattern.c"
								}
#line 741 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp56_) {
#line 7768 "tracker-sparql-pattern.c"
									GString* _tmp59_;
									const gchar* _tmp60_;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp59_ = sql;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = name;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp59_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp60_);
#line 7777 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp61_;
									const gchar* _tmp62_;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp61_ = sql;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = name;
#line 744 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp61_, _tmp62_);
#line 7787 "tracker-sparql-pattern.c"
								}
							}
#line 747 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp63_ = name;
#line 747 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp64_ = g_strdup (_tmp63_);
#line 747 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (last_name);
#line 747 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_name = _tmp64_;
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp65_ = type;
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_type = _tmp65_;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp66_ = binding;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = _tmp66_->maybe_null;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (!_tmp67_) {
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								maybe_null = FALSE;
#line 7810 "tracker-sparql-pattern.c"
							}
#line 752 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = binding;
#line 752 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = _tmp68_->in_simple_optional;
#line 752 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_simple_optional = _tmp69_;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (name);
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 7822 "tracker-sparql-pattern.c"
						}
					}
				}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp71_ = maybe_null;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp71_) {
#line 7830 "tracker-sparql-pattern.c"
					gboolean _tmp72_;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp72_ = in_simple_optional;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = !_tmp72_;
#line 7836 "tracker-sparql-pattern.c"
				} else {
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = FALSE;
#line 7840 "tracker-sparql-pattern.c"
				}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp70_) {
#line 7844 "tracker-sparql-pattern.c"
					gboolean _tmp73_;
					GString* _tmp76_;
					TrackerSparqlVariable* _tmp77_;
					const gchar* _tmp78_;
					const gchar* _tmp79_;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp73_ = *first_where;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp73_) {
#line 7854 "tracker-sparql-pattern.c"
						GString* _tmp74_;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = sql;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp74_, " AND ");
#line 7860 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp75_;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = sql;
#line 761 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp75_, " WHERE ");
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						*first_where = FALSE;
#line 7869 "tracker-sparql-pattern.c"
					}
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = sql;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = variable;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = tracker_sparql_variable_get_sql_expression (_tmp77_);
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = _tmp78_;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp76_, "%s IS NOT NULL", _tmp79_);
#line 7881 "tracker-sparql-pattern.c"
				}
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (last_name);
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (variable);
#line 7887 "tracker-sparql-pattern.c"
			}
		}
	}
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp80_ = self->priv->triple_context;
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp81_ = _tmp80_->bindings;
#line 7895 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp81_;
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7903 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp82_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp82_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp82_;
#line 7910 "tracker-sparql-pattern.c"
			{
				gboolean _tmp83_;
				GString* _tmp86_;
				TrackerSparqlLiteralBinding* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				gboolean _tmp91_;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp83_ = *first_where;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp83_) {
#line 7923 "tracker-sparql-pattern.c"
					GString* _tmp84_;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = sql;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp84_, " AND ");
#line 7929 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp85_;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = sql;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp85_, " WHERE ");
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					*first_where = FALSE;
#line 7938 "tracker-sparql-pattern.c"
				}
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp86_ = sql;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp87_ = binding;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp88_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp87_);
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp89_ = _tmp88_;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp86_, _tmp89_);
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp90_ = binding;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp91_ = _tmp90_->is_fts_match;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp91_) {
#line 7956 "tracker-sparql-pattern.c"
					gchar* escaped_literal = NULL;
					TrackerSparqlLiteralBinding* _tmp92_;
					const gchar* _tmp93_;
					gchar** _tmp94_;
					gchar** _tmp95_;
					gchar** _tmp96_;
					gint _tmp96__length1;
					gchar* _tmp97_;
					gchar* _tmp98_;
					GString* _tmp99_;
					const gchar* _tmp100_;
					GString* _tmp101_;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = binding;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = _tmp92_->literal;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = _tmp94_ = g_strsplit (_tmp93_, "'", 0);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = _tmp95_;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96__length1 = _vala_array_length (_tmp94_);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = _vala_g_strjoinv ("''", _tmp96_, _vala_array_length (_tmp94_));
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp98_ = _tmp97_;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = (_vala_array_free (_tmp96_, _tmp96__length1, (GDestroyNotify) g_free), NULL);
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					escaped_literal = _tmp98_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = sql;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = escaped_literal;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp99_, " MATCH '%s'", _tmp100_);
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = self->match_str;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp101_ == NULL) {
#line 7997 "tracker-sparql-pattern.c"
						GString* _tmp102_;
						GString* _tmp103_;
						const gchar* _tmp104_;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp102_ = g_string_new ("");
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (self->match_str);
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->match_str = _tmp102_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp103_ = self->match_str;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp104_ = escaped_literal;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp103_, " MATCH '%s'", _tmp104_);
#line 8013 "tracker-sparql-pattern.c"
					}
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (escaped_literal);
#line 8017 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp105_;
					TrackerSparqlLiteralBinding* _tmp106_;
					TrackerPropertyType _tmp107_;
					TrackerSparqlQuery* _tmp110_;
					TrackerSparqlLiteralBinding* _tmp111_;
					TrackerSparqlLiteralBinding* _tmp112_;
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp105_ = sql;
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp105_, " = ");
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp106_ = binding;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp107_ = ((TrackerSparqlDataBinding*) _tmp106_)->data_type;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp107_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 8035 "tracker-sparql-pattern.c"
						GString* _tmp108_;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp108_ = sql;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp108_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 8041 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp109_;
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp109_ = sql;
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp109_, "?");
#line 8048 "tracker-sparql-pattern.c"
					}
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp110_ = self->priv->query;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp111_ = binding;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp112_ = _g_object_ref0 (_tmp111_);
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp110_->bindings = g_list_append (_tmp110_->bindings, _tmp112_);
#line 8058 "tracker-sparql-pattern.c"
				}
#line 767 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 8062 "tracker-sparql-pattern.c"
			}
		}
	}
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp113_ = in_group_graph_pattern;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp113_) {
#line 8070 "tracker-sparql-pattern.c"
		GString* _tmp114_;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp114_ = sql;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp114_, ")");
#line 8076 "tracker-sparql-pattern.c"
	}
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp115_ = tracker_sparql_pattern_get_context (self);
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp116_ = _tmp115_;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp117_ = _tmp116_->var_set;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp118_ = g_hash_table_get_keys (_tmp117_);
#line 8086 "tracker-sparql-pattern.c"
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		v_collection = _tmp118_;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 8094 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* v = NULL;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			v = (TrackerSparqlVariable*) v_it->data;
#line 8098 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp119_;
				TrackerSparqlContext* _tmp120_;
				TrackerSparqlContext* _tmp121_;
				GHashTable* _tmp122_;
				TrackerSparqlVariable* _tmp123_;
				TrackerSparqlVariable* _tmp124_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_ = tracker_sparql_pattern_get_context (self);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp120_ = _tmp119_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = _tmp120_->parent_context;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = _tmp121_->var_set;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = v;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = _g_object_ref0 (_tmp123_);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp122_, _tmp124_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 8120 "tracker-sparql-pattern.c"
			}
		}
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (v_collection);
#line 8125 "tracker-sparql-pattern.c"
	}
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = NULL;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp125_ = tracker_sparql_pattern_get_context (self);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp126_ = _tmp125_;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp127_ = _tmp126_->parent_context;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp127_);
#line 8139 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 8151 "tracker-sparql-pattern.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		TrackerSparqlTokenType _tmp4_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp16_;
		gchar* _tmp22_ = NULL;
		GString* _tmp23_;
		gboolean _tmp24_ = FALSE;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GString* _tmp27_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_current (self);
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp4_ != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 8173 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp5_;
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = tracker_sparql_pattern_current (self);
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = _tmp5_ != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 8179 "tracker-sparql-pattern.c"
		} else {
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = FALSE;
#line 8183 "tracker-sparql-pattern.c"
		}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_) {
#line 8187 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp6_;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_current (self);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = _tmp6_ != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 8193 "tracker-sparql-pattern.c"
		} else {
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = FALSE;
#line 8197 "tracker-sparql-pattern.c"
		}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 8201 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp7_;
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = _tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 8207 "tracker-sparql-pattern.c"
		} else {
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = FALSE;
#line 8211 "tracker-sparql-pattern.c"
		}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp1_) {
#line 8215 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp8_;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = tracker_sparql_pattern_current (self);
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = _tmp8_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 8221 "tracker-sparql-pattern.c"
		} else {
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = FALSE;
#line 8225 "tracker-sparql-pattern.c"
		}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp0_) {
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 8231 "tracker-sparql-pattern.c"
		}
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = *in_triples_block;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp11_) {
#line 8237 "tracker-sparql-pattern.c"
			gboolean _tmp12_;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = *in_group_graph_pattern;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = !_tmp12_;
#line 8243 "tracker-sparql-pattern.c"
		} else {
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = FALSE;
#line 8247 "tracker-sparql-pattern.c"
		}
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp10_) {
#line 8251 "tracker-sparql-pattern.c"
			gboolean _tmp13_;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = found_simple_optional;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _tmp13_;
#line 8257 "tracker-sparql-pattern.c"
		} else {
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = FALSE;
#line 8261 "tracker-sparql-pattern.c"
		}
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp9_) {
#line 8265 "tracker-sparql-pattern.c"
			GString* _tmp14_;
			gboolean _tmp15_;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = sql;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = *in_group_graph_pattern;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp14_, first_where, _tmp15_, &_inner_error_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8282 "tracker-sparql-pattern.c"
				} else {
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8290 "tracker-sparql-pattern.c"
				}
			}
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = FALSE;
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_group_graph_pattern = TRUE;
#line 8297 "tracker-sparql-pattern.c"
		}
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = *in_triples_block;
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp16_) {
#line 8303 "tracker-sparql-pattern.c"
			gboolean _tmp17_;
			GString* _tmp21_;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = *in_group_graph_pattern;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp17_) {
#line 8310 "tracker-sparql-pattern.c"
				GString* _tmp18_;
				glong _tmp19_;
				GString* _tmp20_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = sql;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = group_graph_pattern_start;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp18_, (gssize) _tmp19_, "SELECT * FROM (");
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = sql;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp20_, ") NATURAL INNER JOIN (");
#line 8324 "tracker-sparql-pattern.c"
			}
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = TRUE;
#line 830 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*first_where = TRUE;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = sql;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_start_triples_block (self, _tmp21_, &_inner_error_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8342 "tracker-sparql-pattern.c"
				} else {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8350 "tracker-sparql-pattern.c"
				}
			}
		}
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = sql;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp23_, &_tmp24_, &_inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject_is_var = _tmp24_;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp25_;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8370 "tracker-sparql-pattern.c"
			} else {
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8378 "tracker-sparql-pattern.c"
			}
		}
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = _tmp22_;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = NULL;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_subject);
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject = _tmp26_;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp27_ = sql;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp27_, FALSE, &_inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8403 "tracker-sparql-pattern.c"
			} else {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8413 "tracker-sparql-pattern.c"
			}
		}
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = _tmp29_;
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8430 "tracker-sparql-pattern.c"
			} else {
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8440 "tracker-sparql-pattern.c"
			}
		}
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp28_) {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp22_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 8449 "tracker-sparql-pattern.c"
		}
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp22_);
#line 8453 "tracker-sparql-pattern.c"
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	TrackerClass* _tmp0_;
	TrackerClass* _tmp1_;
	TrackerClass* _tmp2_;
	TrackerClass** _tmp3_;
	TrackerClass** _tmp4_;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class1 != NULL, FALSE);
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class2 != NULL, FALSE);
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = class1;
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = class2;
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == _tmp1_) {
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = TRUE;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 8481 "tracker-sparql-pattern.c"
	}
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = class1;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = _tmp3_ = tracker_class_get_super_classes (_tmp2_);
#line 8487 "tracker-sparql-pattern.c"
	{
		TrackerClass** superclass_collection = NULL;
		gint superclass_collection_length1 = 0;
		gint _superclass_collection_size_ = 0;
		gint superclass_it = 0;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection = _tmp4_;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection_length1 = _vala_array_length (_tmp3_);
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp3_); superclass_it = superclass_it + 1) {
#line 8499 "tracker-sparql-pattern.c"
			TrackerClass* _tmp5_;
			TrackerClass* superclass = NULL;
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _g_object_ref0 (superclass_collection[superclass_it]);
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			superclass = _tmp5_;
#line 8506 "tracker-sparql-pattern.c"
			{
				TrackerClass* _tmp6_;
				TrackerClass* _tmp7_;
				gboolean _tmp8_;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = superclass;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = class2;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_is_subclass (self, _tmp6_, _tmp7_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_) {
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = TRUE;
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (superclass);
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 8525 "tracker-sparql-pattern.c"
				}
#line 847 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (superclass);
#line 8529 "tracker-sparql-pattern.c"
			}
		}
	}
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = FALSE;
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 8537 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	TrackerSourceLocation optional_start = {0};
	TrackerSourceLocation _tmp0_ = {0};
	gboolean _tmp132_ = FALSE;
	GError * _inner_error_ = NULL;
#line 855 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 856 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp0_);
#line 856 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	optional_start = _tmp0_;
#line 8553 "tracker-sparql-pattern.c"
	{
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		TrackerSparqlVariable* left_variable = NULL;
		TrackerSparqlContext* _tmp8_;
		TrackerSparqlContext* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariable* _tmp15_;
		TrackerSparqlVariable* _tmp16_;
		gint left_variable_state = 0;
		TrackerSparqlContext* _tmp17_;
		TrackerSparqlContext* _tmp18_;
		GHashTable* _tmp19_;
		TrackerSparqlVariable* _tmp20_;
		gconstpointer _tmp21_;
		gchar* predicate = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_;
		TrackerOntologies* ontologies = NULL;
		TrackerDataManager* _tmp62_;
		TrackerOntologies* _tmp63_;
		TrackerOntologies* _tmp64_;
		TrackerProperty* prop = NULL;
		TrackerOntologies* _tmp65_;
		const gchar* _tmp66_;
		TrackerProperty* _tmp67_;
		TrackerProperty* _tmp68_;
		TrackerProperty* _tmp69_;
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_;
		TrackerSparqlVariable* right_variable = NULL;
		TrackerSparqlContext* _tmp76_;
		TrackerSparqlContext* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		TrackerSparqlVariable* _tmp82_;
		TrackerSparqlVariable* _tmp83_;
		TrackerSparqlVariable* _tmp84_;
		gint right_variable_state = 0;
		TrackerSparqlContext* _tmp85_;
		TrackerSparqlContext* _tmp86_;
		GHashTable* _tmp87_;
		TrackerSparqlVariable* _tmp88_;
		gconstpointer _tmp89_;
		gboolean _tmp92_ = FALSE;
		gboolean _tmp93_;
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_ = FALSE;
		gint _tmp99_;
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8613 "tracker-sparql-pattern.c"
			gboolean _tmp2_ = FALSE;
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8617 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp1_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp1_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp1_);
#line 8626 "tracker-sparql-pattern.c"
			}
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp2_;
#line 8634 "tracker-sparql-pattern.c"
		}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp4_;
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8642 "tracker-sparql-pattern.c"
			gboolean _tmp6_ = FALSE;
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8646 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp5_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp5_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp5_);
#line 8655 "tracker-sparql-pattern.c"
			}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp6_;
#line 8663 "tracker-sparql-pattern.c"
		}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp3_) {
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 8669 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp7_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp7_);
#line 8676 "tracker-sparql-pattern.c"
			}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8680 "tracker-sparql-pattern.c"
		}
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_pattern_get_context (self);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = _tmp12_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = tracker_sparql_context_get_variable (_tmp9_, _tmp13_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp13_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable = _tmp16_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = tracker_sparql_pattern_get_context (self);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = _tmp17_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp18_->var_set;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = left_variable;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable_state = (gint) ((gintptr) _tmp21_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp23_;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8724 "tracker-sparql-pattern.c"
			gboolean _tmp25_ = FALSE;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8732 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8739 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp24_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp24_);
#line 8746 "tracker-sparql-pattern.c"
			}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp25_;
#line 8754 "tracker-sparql-pattern.c"
		}
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp22_) {
#line 8758 "tracker-sparql-pattern.c"
			gchar* _tmp26_;
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp26_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			predicate = _tmp26_;
#line 8766 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = _tmp28_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8776 "tracker-sparql-pattern.c"
				gboolean _tmp30_ = FALSE;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8784 "tracker-sparql-pattern.c"
					goto __catch1_tracker_sparql_error;
				}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 8791 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp29_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp29_);
#line 8798 "tracker-sparql-pattern.c"
				}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return _tmp30_;
#line 8806 "tracker-sparql-pattern.c"
			}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp27_) {
#line 8810 "tracker-sparql-pattern.c"
				gchar* ns = NULL;
				gchar* _tmp31_;
				gchar* _tmp34_ = NULL;
				TrackerSparqlQuery* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp45_;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp31_;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8831 "tracker-sparql-pattern.c"
					gboolean _tmp33_ = FALSE;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8841 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8850 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp32_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp32_);
#line 8857 "tracker-sparql-pattern.c"
					}
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp33_;
#line 8865 "tracker-sparql-pattern.c"
				}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = self->priv->query;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = ns;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = _tmp37_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = string_substring (_tmp38_, (glong) 1, (glong) -1);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp41_ = tracker_sparql_query_resolve_prefixed_name (_tmp35_, _tmp36_, _tmp40_, &_inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = _tmp41_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp40_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp38_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = _tmp42_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8891 "tracker-sparql-pattern.c"
					gboolean _tmp44_ = FALSE;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8901 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8910 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp43_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp43_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp43_);
#line 8917 "tracker-sparql-pattern.c"
					}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp44_;
#line 8925 "tracker-sparql-pattern.c"
				}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp45_ = _tmp34_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = NULL;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				predicate = _tmp45_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp34_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 8939 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp47_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = _tmp47_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8949 "tracker-sparql-pattern.c"
					gboolean _tmp49_ = FALSE;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8957 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8964 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp48_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp48_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp48_);
#line 8971 "tracker-sparql-pattern.c"
					}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp49_;
#line 8979 "tracker-sparql-pattern.c"
				}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp46_) {
#line 8983 "tracker-sparql-pattern.c"
					gchar* _tmp50_ = NULL;
					TrackerSparqlQuery* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp60_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = self->priv->query;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _tmp52_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = string_substring (_tmp53_, (glong) 1, (glong) -1);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp55_ = _tmp54_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp56_ = tracker_sparql_query_resolve_prefixed_name (_tmp51_, "", _tmp55_, &_inner_error_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp57_ = _tmp56_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp55_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp53_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = _tmp57_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9015 "tracker-sparql-pattern.c"
						gboolean _tmp59_ = FALSE;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9023 "tracker-sparql-pattern.c"
							goto __catch1_tracker_sparql_error;
						}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 9030 "tracker-sparql-pattern.c"
						{
							TrackerSourceLocation _tmp58_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp58_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_set_location (self, &_tmp58_);
#line 9037 "tracker-sparql-pattern.c"
						}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return _tmp59_;
#line 9045 "tracker-sparql-pattern.c"
					}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = _tmp50_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = NULL;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					predicate = _tmp60_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp50_);
#line 9057 "tracker-sparql-pattern.c"
				} else {
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = FALSE;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 9065 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp61_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp61_);
#line 9072 "tracker-sparql-pattern.c"
					}
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 9076 "tracker-sparql-pattern.c"
				}
			}
		}
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp62_ = self->priv->manager;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp63_ = tracker_data_manager_get_ontologies (_tmp62_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp64_ = _g_object_ref0 (_tmp63_);
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		ontologies = _tmp64_;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp65_ = ontologies;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp66_ = predicate;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp67_ = tracker_ontologies_get_property_by_uri (_tmp65_, _tmp66_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp68_ = _g_object_ref0 (_tmp67_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp68_;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp69_ = prop;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp69_ == NULL) {
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9112 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp70_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp70_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp70_);
#line 9119 "tracker-sparql-pattern.c"
			}
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9123 "tracker-sparql-pattern.c"
		}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp71_ = _tmp72_;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9131 "tracker-sparql-pattern.c"
			gboolean _tmp74_ = FALSE;
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9143 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9154 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp73_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp73_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp73_);
#line 9161 "tracker-sparql-pattern.c"
			}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp74_;
#line 9169 "tracker-sparql-pattern.c"
		}
#line 897 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp71_) {
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9183 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp75_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp75_);
#line 9190 "tracker-sparql-pattern.c"
			}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9194 "tracker-sparql-pattern.c"
		}
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp76_ = tracker_sparql_pattern_get_context (self);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp77_ = _tmp76_;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp78_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp79_ = _tmp78_;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp80_ = string_substring (_tmp79_, (glong) 1, (glong) -1);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp81_ = _tmp80_;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp82_ = tracker_sparql_context_get_variable (_tmp77_, _tmp81_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp83_ = _g_object_ref0 (_tmp82_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp84_ = _tmp83_;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp81_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp79_);
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable = _tmp84_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp85_ = tracker_sparql_pattern_get_context (self);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp86_ = _tmp85_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp87_ = _tmp86_->var_set;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp88_ = right_variable;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp89_ = g_hash_table_lookup (_tmp87_, _tmp88_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable_state = (gint) ((gintptr) _tmp89_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9236 "tracker-sparql-pattern.c"
			gboolean _tmp91_ = FALSE;
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9250 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9263 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp90_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp90_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp90_);
#line 9270 "tracker-sparql-pattern.c"
			}
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 904 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp91_;
#line 9278 "tracker-sparql-pattern.c"
		}
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp93_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp92_ = _tmp93_;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9286 "tracker-sparql-pattern.c"
			gboolean _tmp95_ = FALSE;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9300 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9313 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp94_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp94_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp94_);
#line 9320 "tracker-sparql-pattern.c"
			}
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp95_;
#line 9328 "tracker-sparql-pattern.c"
		}
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp92_) {
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9344 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp96_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp96_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp96_);
#line 9351 "tracker-sparql-pattern.c"
			}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9355 "tracker-sparql-pattern.c"
		}
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp99_ = left_variable_state;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp99_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 9361 "tracker-sparql-pattern.c"
			TrackerProperty* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp100_ = prop;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp101_ = tracker_property_get_multiple_values (_tmp100_);
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp102_ = _tmp101_;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp98_ = !_tmp102_;
#line 9373 "tracker-sparql-pattern.c"
		} else {
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp98_ = FALSE;
#line 9377 "tracker-sparql-pattern.c"
		}
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp98_) {
#line 9381 "tracker-sparql-pattern.c"
			gint _tmp103_;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp103_ = right_variable_state;
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp97_ = _tmp103_ == 0;
#line 9387 "tracker-sparql-pattern.c"
		} else {
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp97_ = FALSE;
#line 9391 "tracker-sparql-pattern.c"
		}
#line 911 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp97_) {
#line 9395 "tracker-sparql-pattern.c"
			gboolean in_domain = FALSE;
			TrackerSparqlPatternTripleContext* _tmp104_;
			GHashTable* _tmp105_;
			TrackerSparqlVariable* _tmp106_;
			gconstpointer _tmp107_;
			GList* _tmp108_;
			gboolean _tmp119_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_domain = FALSE;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp104_ = self->priv->triple_context;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp105_ = _tmp104_->var_bindings;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp106_ = left_variable;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp107_ = g_hash_table_lookup (_tmp105_, _tmp106_);
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp108_ = ((TrackerSparqlVariableBindingList*) _tmp107_)->list;
#line 9415 "tracker-sparql-pattern.c"
			{
				GList* binding_collection = NULL;
				GList* binding_it = NULL;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_collection = _tmp108_;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 9423 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp109_;
					TrackerSparqlVariableBinding* binding = NULL;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp109_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp109_;
#line 9430 "tracker-sparql-pattern.c"
					{
						gboolean _tmp110_ = FALSE;
						TrackerSparqlVariableBinding* _tmp111_;
						TrackerClass* _tmp112_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp111_ = binding;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp112_ = _tmp111_->type;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp112_ != NULL) {
#line 9441 "tracker-sparql-pattern.c"
							TrackerSparqlVariableBinding* _tmp113_;
							TrackerClass* _tmp114_;
							TrackerProperty* _tmp115_;
							TrackerClass* _tmp116_;
							TrackerClass* _tmp117_;
							gboolean _tmp118_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp113_ = binding;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp114_ = _tmp113_->type;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp115_ = prop;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp116_ = tracker_property_get_domain (_tmp115_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp117_ = _tmp116_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp118_ = tracker_sparql_pattern_is_subclass (self, _tmp114_, _tmp117_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp110_ = _tmp118_;
#line 9462 "tracker-sparql-pattern.c"
						} else {
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp110_ = FALSE;
#line 9466 "tracker-sparql-pattern.c"
						}
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp110_) {
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_domain = TRUE;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 9476 "tracker-sparql-pattern.c"
						}
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (binding);
#line 9480 "tracker-sparql-pattern.c"
					}
				}
			}
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp119_ = in_domain;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp119_) {
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (ontologies);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 9500 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp120_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp120_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp120_);
#line 9507 "tracker-sparql-pattern.c"
				}
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 9511 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			gint _tmp123_;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp123_ = left_variable_state;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp123_ == 0) {
#line 9521 "tracker-sparql-pattern.c"
				TrackerProperty* _tmp124_;
				gboolean _tmp125_;
				gboolean _tmp126_;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = prop;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = tracker_property_get_is_inverse_functional_property (_tmp124_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = _tmp125_;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = _tmp126_;
#line 9533 "tracker-sparql-pattern.c"
			} else {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = FALSE;
#line 9537 "tracker-sparql-pattern.c"
			}
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp122_) {
#line 9541 "tracker-sparql-pattern.c"
				gint _tmp127_;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = right_variable_state;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = _tmp127_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 9547 "tracker-sparql-pattern.c"
			} else {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = FALSE;
#line 9551 "tracker-sparql-pattern.c"
			}
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp121_) {
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (ontologies);
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 9567 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp128_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp128_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp128_);
#line 9574 "tracker-sparql-pattern.c"
				}
#line 926 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 9578 "tracker-sparql-pattern.c"
			}
		}
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (right_variable);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (ontologies);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (predicate);
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (left_variable);
#line 9593 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp129_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp129_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp129_);
#line 9600 "tracker-sparql-pattern.c"
		}
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9604 "tracker-sparql-pattern.c"
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e = NULL;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 9618 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp130_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp130_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp130_);
#line 9625 "tracker-sparql-pattern.c"
		}
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9629 "tracker-sparql-pattern.c"
	}
	__finally1:
	{
		TrackerSourceLocation _tmp131_;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp131_ = optional_start;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp131_);
#line 9638 "tracker-sparql-pattern.c"
	}
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_clear_error (&_inner_error_);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return _tmp132_;
#line 9646 "tracker-sparql-pattern.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 9653 "tracker-sparql-pattern.c"
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash ((TrackerSparqlVariable*) key);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9662 "tracker-sparql-pattern.c"
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal ((TrackerSparqlVariable*) a, (TrackerSparqlVariable*) b);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9671 "tracker-sparql-pattern.c"
}


static void _vala_array_add8 (TrackerSourceLocation* * array, int* length, int* size, const TrackerSourceLocation* value) {
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSourceLocation, *array, *size);
#line 9682 "tracker-sparql-pattern.c"
	}
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = *value;
#line 9686 "tracker-sparql-pattern.c"
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlContext* _result_ = NULL;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlContext* _tmp18_;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	TrackerSparqlContext* _tmp21_;
	TrackerSourceLocation* filters = NULL;
	TrackerSourceLocation* _tmp22_;
	gint filters_length1;
	gint _filters_size_;
	gboolean in_triples_block = FALSE;
	gboolean in_group_graph_pattern = FALSE;
	gboolean first_where = FALSE;
	gboolean found_simple_optional = FALSE;
	glong group_graph_pattern_start = 0L;
	GString* _tmp23_;
	gssize _tmp24_;
	GString* _tmp25_;
	glong _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp316_ = FALSE;
	gboolean _tmp317_;
	gboolean _tmp323_;
	TrackerSourceLocation* _tmp324_;
	gint _tmp324__length1;
	TrackerSparqlContext* _tmp333_;
	TrackerSparqlContext* _tmp334_;
	TrackerSparqlContext* _tmp335_;
	GError * _inner_error_ = NULL;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9736 "tracker-sparql-pattern.c"
		} else {
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9744 "tracker-sparql-pattern.c"
		}
	}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 9751 "tracker-sparql-pattern.c"
		TrackerSparqlSelectContext* _result_ = NULL;
		GString* _tmp1_;
		TrackerSparqlSelectContext* _tmp2_;
		TrackerSparqlSelectContext* _tmp3_;
		TrackerSparqlContext* _tmp4_;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		GDestroyNotify _tmp12_;
		GHashTable* _tmp13_;
		TrackerSparqlContext* _tmp14_;
		TrackerSparqlContext* _tmp15_;
		TrackerSparqlContext* _tmp16_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = sql;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_translate_select (self, _tmp1_, TRUE, FALSE, &_inner_error_);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp2_;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9783 "tracker-sparql-pattern.c"
			} else {
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9791 "tracker-sparql-pattern.c"
			}
		}
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _result_;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp3_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_get_context (self);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _tmp7_->select_var_set;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _g_hash_table_ref0 (_tmp8_);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp5_->var_set);
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_->var_set = _tmp9_;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_context (self);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = g_object_unref;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp12_, NULL);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp11_->select_var_set);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->select_var_set = _tmp13_;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9838 "tracker-sparql-pattern.c"
			} else {
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9848 "tracker-sparql-pattern.c"
			}
		}
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _tmp14_;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_->parent_context;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, _tmp16_);
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = (TrackerSparqlContext*) _result_;
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9863 "tracker-sparql-pattern.c"
	}
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp17_ = self->priv->query;
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp18_ = tracker_sparql_pattern_get_context (self);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = _tmp18_;
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = tracker_sparql_context_new (_tmp17_, _tmp19_);
#line 956 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp20_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _result_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp21_);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_new0 (TrackerSourceLocation, 0);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = _tmp22_;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters_length1 = 0;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_filters_size_ = filters_length1;
#line 961 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_triples_block = FALSE;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_group_graph_pattern = FALSE;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first_where = TRUE;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	found_simple_optional = FALSE;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = sql;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = _tmp23_->len;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	group_graph_pattern_start = (glong) _tmp24_;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = sql;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = group_graph_pattern_start;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = found_simple_optional;
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parse_triples (self, _tmp25_, _tmp26_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp27_, &_inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9921 "tracker-sparql-pattern.c"
		} else {
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 968 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9933 "tracker-sparql-pattern.c"
		}
	}
#line 970 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 9938 "tracker-sparql-pattern.c"
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		GString* _tmp313_;
		glong _tmp314_;
		gboolean _tmp315_;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = _tmp29_;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9960 "tracker-sparql-pattern.c"
			} else {
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9972 "tracker-sparql-pattern.c"
			}
		}
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp28_) {
#line 9977 "tracker-sparql-pattern.c"
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_;
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = in_group_graph_pattern;
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp31_) {
#line 9984 "tracker-sparql-pattern.c"
				gboolean _tmp32_;
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = tracker_sparql_pattern_is_simple_optional (self);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp32_;
#line 9990 "tracker-sparql-pattern.c"
			} else {
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = FALSE;
#line 9994 "tracker-sparql-pattern.c"
			}
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp30_) {
#line 9998 "tracker-sparql-pattern.c"
				gchar* _tmp33_ = NULL;
				GString* _tmp34_;
				gboolean _tmp35_ = FALSE;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GString* _tmp38_;
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				found_simple_optional = TRUE;
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10021 "tracker-sparql-pattern.c"
					} else {
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10033 "tracker-sparql-pattern.c"
					}
				}
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = sql;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp34_, &_tmp35_, &_inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject_is_var = _tmp35_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = _tmp36_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10056 "tracker-sparql-pattern.c"
					} else {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10068 "tracker-sparql-pattern.c"
					}
				}
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp33_;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = NULL;
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_subject);
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject = _tmp37_;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = sql;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp38_, TRUE, &_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10097 "tracker-sparql-pattern.c"
					} else {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10111 "tracker-sparql-pattern.c"
					}
				}
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10130 "tracker-sparql-pattern.c"
					} else {
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10144 "tracker-sparql-pattern.c"
					}
				}
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10163 "tracker-sparql-pattern.c"
					} else {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10177 "tracker-sparql-pattern.c"
					}
				}
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp33_);
#line 10182 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
				gboolean _tmp46_;
				GString* select = NULL;
				GString* _tmp47_;
				gint left_index = 0;
				gint _tmp48_;
				gint _tmp49_;
				gint right_index = 0;
				gint _tmp50_;
				gint _tmp51_;
				GString* _tmp52_;
				gint _tmp53_;
				TrackerSparqlContext* _tmp54_ = NULL;
				GString* _tmp55_;
				TrackerSparqlContext* _tmp56_;
				GString* _tmp57_;
				gint _tmp58_;
				gboolean first = FALSE;
				gboolean first_common = FALSE;
				TrackerSparqlContext* _tmp59_;
				TrackerSparqlContext* _tmp60_;
				GHashTable* _tmp61_;
				GList* _tmp62_;
				TrackerSparqlContext* _tmp180_;
				TrackerSparqlContext* _tmp181_;
				TrackerSparqlContext* _tmp182_;
				GHashTable* _tmp183_;
				GList* _tmp184_;
				gboolean _tmp210_;
				TrackerSparqlContext* _tmp212_;
				TrackerSparqlContext* _tmp213_;
				TrackerSparqlContext* _tmp214_;
				GString* _tmp215_;
				GString* _tmp216_;
				glong _tmp217_;
				GString* _tmp218_;
				const gchar* _tmp219_;
				GString* _tmp220_;
				glong _tmp221_;
				GString* _tmp222_;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = in_triples_block;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp40_) {
#line 10229 "tracker-sparql-pattern.c"
					gboolean _tmp41_;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = in_group_graph_pattern;
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = !_tmp41_;
#line 10235 "tracker-sparql-pattern.c"
				} else {
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = FALSE;
#line 10239 "tracker-sparql-pattern.c"
				}
#line 984 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp39_) {
#line 10243 "tracker-sparql-pattern.c"
					GString* _tmp42_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = sql;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp42_, "SELECT 1");
#line 10249 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp43_;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = in_triples_block;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp43_) {
#line 10256 "tracker-sparql-pattern.c"
						GString* _tmp44_;
						gboolean _tmp45_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp44_ = sql;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp45_ = in_group_graph_pattern;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp44_, &first_where, _tmp45_, &_inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10277 "tracker-sparql-pattern.c"
							} else {
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10289 "tracker-sparql-pattern.c"
							}
						}
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 10294 "tracker-sparql-pattern.c"
					}
				}
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = in_group_graph_pattern;
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp46_) {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 10303 "tracker-sparql-pattern.c"
				}
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp47_ = g_string_new ("SELECT ");
#line 996 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				select = _tmp47_;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp48_ = self->priv->next_table_index;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp48_ + 1;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp49_ = self->priv->next_table_index;
#line 998 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				left_index = _tmp49_;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp50_ = self->priv->next_table_index;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp50_ + 1;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp51_ = self->priv->next_table_index;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				right_index = _tmp51_;
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp52_ = sql;
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp53_ = left_index;
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp52_, ") AS t%d_g LEFT JOIN (", _tmp53_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp55_ = sql;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp55_, &_inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp54_ = _tmp56_;
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10351 "tracker-sparql-pattern.c"
					} else {
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10365 "tracker-sparql-pattern.c"
					}
				}
#line 1003 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp54_);
#line 1005 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = sql;
#line 1005 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = right_index;
#line 1005 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp57_, ") AS t%d_g", _tmp58_);
#line 1007 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 1008 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first_common = TRUE;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = tracker_sparql_pattern_get_context (self);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = _tmp59_;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = _tmp60_->var_set;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp62_ = g_hash_table_get_keys (_tmp61_);
#line 10388 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp62_;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 10396 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 10400 "tracker-sparql-pattern.c"
						{
							gboolean _tmp63_;
							gint old_state = 0;
							TrackerSparqlContext* _tmp65_;
							TrackerSparqlContext* _tmp66_;
							TrackerSparqlContext* _tmp67_;
							GHashTable* _tmp68_;
							TrackerSparqlVariable* _tmp69_;
							gconstpointer _tmp70_;
							gint _tmp71_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp63_ = first;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp63_) {
#line 1011 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								first = FALSE;
#line 10417 "tracker-sparql-pattern.c"
							} else {
								GString* _tmp64_;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp64_ = select;
#line 1013 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp64_, ", ");
#line 10424 "tracker-sparql-pattern.c"
							}
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp65_ = tracker_sparql_pattern_get_context (self);
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp66_ = _tmp65_;
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = _tmp66_->parent_context;
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = _tmp67_->var_set;
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = v;
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp70_ = g_hash_table_lookup (_tmp68_, _tmp69_);
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							old_state = (gint) ((gintptr) _tmp70_);
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp71_ = old_state;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp71_ == 0) {
#line 10444 "tracker-sparql-pattern.c"
								TrackerSparqlContext* _tmp72_;
								TrackerSparqlContext* _tmp73_;
								TrackerSparqlContext* _tmp74_;
								GHashTable* _tmp75_;
								TrackerSparqlVariable* _tmp76_;
								TrackerSparqlVariable* _tmp77_;
								GString* _tmp78_;
								gint _tmp79_;
								TrackerSparqlVariable* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								TrackerSparqlVariable* _tmp83_;
								TrackerSparqlVariableBinding* _tmp84_;
								TrackerPropertyType _tmp85_;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp72_ = tracker_sparql_pattern_get_context (self);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp73_ = _tmp72_;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp74_ = _tmp73_->parent_context;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp75_ = _tmp74_->var_set;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp76_ = v;
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp77_ = _g_object_ref0 (_tmp76_);
#line 1019 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_hash_table_insert (_tmp75_, _tmp77_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp78_ = select;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp79_ = right_index;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp80_ = v;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp81_ = tracker_sparql_variable_get_sql_expression (_tmp80_);
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp82_ = _tmp81_;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp78_, "t%d_g.%s", _tmp79_, _tmp82_);
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp83_ = v;
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp84_ = _tmp83_->binding;
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp85_ = ((TrackerSparqlDataBinding*) _tmp84_)->data_type;
#line 1022 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp85_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10493 "tracker-sparql-pattern.c"
									GString* _tmp86_;
									gint _tmp87_;
									TrackerSparqlVariable* _tmp88_;
									gchar* _tmp89_;
									gchar* _tmp90_;
									GString* _tmp91_;
									gint _tmp92_;
									TrackerSparqlVariable* _tmp93_;
									gchar* _tmp94_;
									gchar* _tmp95_;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp86_ = select;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp87_ = right_index;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp88_ = v;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp89_ = tracker_sparql_variable_get_extra_sql_expression (_tmp88_, "localDate");
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp90_ = _tmp89_;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp86_, ", t%d_g.%s", _tmp87_, _tmp90_);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp90_);
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp91_ = select;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp92_ = right_index;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp93_ = v;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp94_ = tracker_sparql_variable_get_extra_sql_expression (_tmp93_, "localTime");
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp95_ = _tmp94_;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp91_, ", t%d_g.%s", _tmp92_, _tmp95_);
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp95_);
#line 10532 "tracker-sparql-pattern.c"
								}
							} else {
								gboolean _tmp96_;
								gint _tmp99_;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp96_ = first_common;
#line 1027 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp96_) {
#line 10541 "tracker-sparql-pattern.c"
									GString* _tmp97_;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp97_ = sql;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp97_, " ON ");
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first_common = FALSE;
#line 10549 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp98_;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp98_ = sql;
#line 1031 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp98_, " AND ");
#line 10556 "tracker-sparql-pattern.c"
								}
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp99_ = old_state;
#line 1034 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp99_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 10562 "tracker-sparql-pattern.c"
									GString* _tmp100_;
									gint _tmp101_;
									TrackerSparqlVariable* _tmp102_;
									const gchar* _tmp103_;
									const gchar* _tmp104_;
									gint _tmp105_;
									TrackerSparqlVariable* _tmp106_;
									const gchar* _tmp107_;
									const gchar* _tmp108_;
									GString* _tmp109_;
									gint _tmp110_;
									TrackerSparqlVariable* _tmp111_;
									const gchar* _tmp112_;
									const gchar* _tmp113_;
									TrackerSparqlVariable* _tmp114_;
									TrackerSparqlVariableBinding* _tmp115_;
									TrackerPropertyType _tmp116_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp100_ = sql;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp101_ = left_index;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp102_ = v;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp103_ = tracker_sparql_variable_get_sql_expression (_tmp102_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp104_ = _tmp103_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp105_ = right_index;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp106_ = v;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp107_ = tracker_sparql_variable_get_sql_expression (_tmp106_);
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp108_ = _tmp107_;
#line 1036 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp100_, "t%d_g.%s = t%d_g.%s", _tmp101_, _tmp104_, _tmp105_, _tmp108_);
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp109_ = select;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp110_ = left_index;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp111_ = v;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp112_ = tracker_sparql_variable_get_sql_expression (_tmp111_);
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp113_ = _tmp112_;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp109_, "t%d_g.%s", _tmp110_, _tmp113_);
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp114_ = v;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp115_ = _tmp114_->binding;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp116_ = ((TrackerSparqlDataBinding*) _tmp115_)->data_type;
#line 1039 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp116_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10620 "tracker-sparql-pattern.c"
										GString* _tmp117_;
										gint _tmp118_;
										TrackerSparqlVariable* _tmp119_;
										gchar* _tmp120_;
										gchar* _tmp121_;
										GString* _tmp122_;
										gint _tmp123_;
										TrackerSparqlVariable* _tmp124_;
										gchar* _tmp125_;
										gchar* _tmp126_;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp117_ = select;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp118_ = left_index;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp119_ = v;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp120_ = tracker_sparql_variable_get_extra_sql_expression (_tmp119_, "localDate");
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp121_ = _tmp120_;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp117_, ", t%d_g.%s", _tmp118_, _tmp121_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp121_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp122_ = select;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp123_ = left_index;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp124_ = v;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp125_ = tracker_sparql_variable_get_extra_sql_expression (_tmp124_, "localTime");
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp126_ = _tmp125_;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp122_, ", t%d_g.%s", _tmp123_, _tmp126_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp126_);
#line 10659 "tracker-sparql-pattern.c"
									}
								} else {
									gint _tmp127_;
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp127_ = old_state;
#line 1043 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp127_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)) {
#line 10667 "tracker-sparql-pattern.c"
										GString* _tmp128_;
										gint _tmp129_;
										TrackerSparqlVariable* _tmp130_;
										const gchar* _tmp131_;
										const gchar* _tmp132_;
										gint _tmp133_;
										TrackerSparqlVariable* _tmp134_;
										const gchar* _tmp135_;
										const gchar* _tmp136_;
										gint _tmp137_;
										TrackerSparqlVariable* _tmp138_;
										const gchar* _tmp139_;
										const gchar* _tmp140_;
										GString* _tmp141_;
										gint _tmp142_;
										TrackerSparqlVariable* _tmp143_;
										const gchar* _tmp144_;
										const gchar* _tmp145_;
										gint _tmp146_;
										TrackerSparqlVariable* _tmp147_;
										const gchar* _tmp148_;
										const gchar* _tmp149_;
										TrackerSparqlVariable* _tmp150_;
										const gchar* _tmp151_;
										const gchar* _tmp152_;
										TrackerSparqlVariable* _tmp153_;
										TrackerSparqlVariableBinding* _tmp154_;
										TrackerPropertyType _tmp155_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp128_ = sql;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp129_ = left_index;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp130_ = v;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp131_ = tracker_sparql_variable_get_sql_expression (_tmp130_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp132_ = _tmp131_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp133_ = left_index;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp134_ = v;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp135_ = tracker_sparql_variable_get_sql_expression (_tmp134_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp136_ = _tmp135_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp137_ = right_index;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp138_ = v;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp139_ = tracker_sparql_variable_get_sql_expression (_tmp138_);
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp140_ = _tmp139_;
#line 1045 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp128_, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", _tmp129_, _tmp132_, _tmp133_, _tmp136_, _tmp137_, _tmp140_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp141_ = select;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp142_ = left_index;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp143_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp144_ = tracker_sparql_variable_get_sql_expression (_tmp143_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp145_ = _tmp144_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp146_ = right_index;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp147_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp148_ = tracker_sparql_variable_get_sql_expression (_tmp147_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp149_ = _tmp148_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp150_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp151_ = tracker_sparql_variable_get_sql_expression (_tmp150_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp152_ = _tmp151_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp141_, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp142_, _tmp145_, _tmp146_, _tmp149_, _tmp152_);
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp153_ = v;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp154_ = _tmp153_->binding;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp155_ = ((TrackerSparqlDataBinding*) _tmp154_)->data_type;
#line 1048 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp155_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10758 "tracker-sparql-pattern.c"
											GString* _tmp156_;
											gint _tmp157_;
											TrackerSparqlVariable* _tmp158_;
											gchar* _tmp159_;
											gchar* _tmp160_;
											gint _tmp161_;
											TrackerSparqlVariable* _tmp162_;
											gchar* _tmp163_;
											gchar* _tmp164_;
											TrackerSparqlVariable* _tmp165_;
											gchar* _tmp166_;
											gchar* _tmp167_;
											GString* _tmp168_;
											gint _tmp169_;
											TrackerSparqlVariable* _tmp170_;
											gchar* _tmp171_;
											gchar* _tmp172_;
											gint _tmp173_;
											TrackerSparqlVariable* _tmp174_;
											gchar* _tmp175_;
											gchar* _tmp176_;
											TrackerSparqlVariable* _tmp177_;
											gchar* _tmp178_;
											gchar* _tmp179_;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp156_ = select;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp157_ = left_index;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp158_ = v;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp159_ = tracker_sparql_variable_get_extra_sql_expression (_tmp158_, "localDate");
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp160_ = _tmp159_;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp161_ = right_index;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp162_ = v;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp163_ = tracker_sparql_variable_get_extra_sql_expression (_tmp162_, "localDate");
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp164_ = _tmp163_;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp165_ = v;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp166_ = tracker_sparql_variable_get_extra_sql_expression (_tmp165_, "localDate");
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp167_ = _tmp166_;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp156_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp157_, _tmp160_, _tmp161_, _tmp164_, _tmp167_);
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp167_);
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp164_);
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp160_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp168_ = select;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp169_ = left_index;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp170_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp171_ = tracker_sparql_variable_get_extra_sql_expression (_tmp170_, "localTime");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp172_ = _tmp171_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp173_ = right_index;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp174_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp175_ = tracker_sparql_variable_get_extra_sql_expression (_tmp174_, "localTime");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp176_ = _tmp175_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp177_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp178_ = tracker_sparql_variable_get_extra_sql_expression (_tmp177_, "localTime");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp179_ = _tmp178_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp168_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp169_, _tmp172_, _tmp173_, _tmp176_, _tmp179_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp179_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp176_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp172_);
#line 10847 "tracker-sparql-pattern.c"
										}
									}
								}
							}
						}
					}
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10856 "tracker-sparql-pattern.c"
				}
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp180_ = tracker_sparql_pattern_get_context (self);
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp181_ = _tmp180_;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp182_ = _tmp181_->parent_context;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp183_ = _tmp182_->var_set;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp184_ = g_hash_table_get_keys (_tmp183_);
#line 10868 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp184_;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 10876 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 10880 "tracker-sparql-pattern.c"
						{
							TrackerSparqlContext* _tmp185_;
							TrackerSparqlContext* _tmp186_;
							GHashTable* _tmp187_;
							TrackerSparqlVariable* _tmp188_;
							gconstpointer _tmp189_;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp185_ = tracker_sparql_pattern_get_context (self);
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp186_ = _tmp185_;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp187_ = _tmp186_->var_set;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp188_ = v;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp189_ = g_hash_table_lookup (_tmp187_, _tmp188_);
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (((gint) ((gintptr) _tmp189_)) == 0) {
#line 10899 "tracker-sparql-pattern.c"
								gboolean _tmp190_;
								GString* _tmp192_;
								gint _tmp193_;
								TrackerSparqlVariable* _tmp194_;
								const gchar* _tmp195_;
								const gchar* _tmp196_;
								TrackerSparqlVariable* _tmp197_;
								TrackerSparqlVariableBinding* _tmp198_;
								TrackerPropertyType _tmp199_;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp190_ = first;
#line 1058 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp190_) {
#line 1059 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first = FALSE;
#line 10915 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp191_;
#line 1061 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp191_ = select;
#line 1061 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp191_, ", ");
#line 10922 "tracker-sparql-pattern.c"
								}
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp192_ = select;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp193_ = left_index;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp194_ = v;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp195_ = tracker_sparql_variable_get_sql_expression (_tmp194_);
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp196_ = _tmp195_;
#line 1064 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp192_, "t%d_g.%s", _tmp193_, _tmp196_);
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp197_ = v;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp198_ = _tmp197_->binding;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp199_ = ((TrackerSparqlDataBinding*) _tmp198_)->data_type;
#line 1066 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp199_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10944 "tracker-sparql-pattern.c"
									GString* _tmp200_;
									gint _tmp201_;
									TrackerSparqlVariable* _tmp202_;
									gchar* _tmp203_;
									gchar* _tmp204_;
									GString* _tmp205_;
									gint _tmp206_;
									TrackerSparqlVariable* _tmp207_;
									gchar* _tmp208_;
									gchar* _tmp209_;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp200_ = select;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp201_ = left_index;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp202_ = v;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp203_ = tracker_sparql_variable_get_extra_sql_expression (_tmp202_, "localDate");
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp204_ = _tmp203_;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp200_, ", t%d_g.%s", _tmp201_, _tmp204_);
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp204_);
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp205_ = select;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp206_ = left_index;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp207_ = v;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp208_ = tracker_sparql_variable_get_extra_sql_expression (_tmp207_, "localTime");
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp209_ = _tmp208_;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp205_, ", t%d_g.%s", _tmp206_, _tmp209_);
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp209_);
#line 10983 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1055 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10990 "tracker-sparql-pattern.c"
				}
#line 1072 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp210_ = first;
#line 1072 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp210_) {
#line 10996 "tracker-sparql-pattern.c"
					GString* _tmp211_;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp211_ = select;
#line 1074 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp211_, "1");
#line 11002 "tracker-sparql-pattern.c"
				}
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp212_ = tracker_sparql_pattern_get_context (self);
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp213_ = _tmp212_;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp214_ = _tmp213_->parent_context;
#line 1077 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp214_);
#line 1079 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp215_ = select;
#line 1079 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp215_, " FROM (");
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp216_ = sql;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp217_ = group_graph_pattern_start;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp218_ = select;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp219_ = _tmp218_->str;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp216_, (gssize) _tmp217_, _tmp219_);
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp220_ = sql;
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp221_ = group_graph_pattern_start;
#line 1084 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp220_, (gssize) _tmp221_, "SELECT * FROM (");
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp222_ = sql;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp222_, ")");
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_tmp54_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (select);
#line 11040 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_;
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = _tmp224_;
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11061 "tracker-sparql-pattern.c"
				} else {
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11073 "tracker-sparql-pattern.c"
				}
			}
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp223_) {
#line 11078 "tracker-sparql-pattern.c"
				gchar* old_graph = NULL;
				const gchar* _tmp225_;
				gchar* _tmp226_;
				gboolean old_graph_is_var = FALSE;
				gboolean _tmp227_;
				gchar* _tmp228_ = NULL;
				GString* _tmp229_;
				gboolean _tmp230_ = FALSE;
				gchar* _tmp231_;
				gchar* _tmp232_;
				gboolean _tmp233_ = FALSE;
				gboolean _tmp234_;
				const gchar* _tmp249_;
				gchar* _tmp250_;
				gboolean _tmp251_;
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp225_ = self->current_graph;
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp226_ = g_strdup (_tmp225_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph = _tmp226_;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp227_ = self->priv->current_graph_is_var;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph_is_var = _tmp227_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp229_ = sql;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp231_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp229_, &_tmp230_, &_inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp230_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = _tmp231_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11126 "tracker-sparql-pattern.c"
					} else {
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11140 "tracker-sparql-pattern.c"
					}
				}
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp232_ = _tmp228_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = NULL;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp232_;
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp234_ = in_triples_block;
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp234_) {
#line 11155 "tracker-sparql-pattern.c"
					gboolean _tmp235_;
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp235_ = in_group_graph_pattern;
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp233_ = !_tmp235_;
#line 11161 "tracker-sparql-pattern.c"
				} else {
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp233_ = FALSE;
#line 11165 "tracker-sparql-pattern.c"
				}
#line 1092 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp233_) {
#line 11169 "tracker-sparql-pattern.c"
					GString* _tmp236_;
					glong _tmp237_;
					GString* _tmp238_;
					GString* _tmp239_;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 1095 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp236_ = sql;
#line 1095 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp237_ = group_graph_pattern_start;
#line 1095 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp236_, (gssize) _tmp237_, "SELECT * FROM (");
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp238_ = sql;
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp238_, &_inner_error_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11202 "tracker-sparql-pattern.c"
						} else {
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11218 "tracker-sparql-pattern.c"
						}
					}
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp239_ = sql;
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp239_, ")");
#line 11225 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp240_;
					gboolean _tmp243_;
					GString* _tmp244_;
					glong _tmp245_;
					GString* _tmp246_;
					GString* _tmp247_;
					GString* _tmp248_;
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp240_ = in_triples_block;
#line 1099 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp240_) {
#line 11238 "tracker-sparql-pattern.c"
						GString* _tmp241_;
						gboolean _tmp242_;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp241_ = sql;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp242_ = in_group_graph_pattern;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp241_, &first_where, _tmp242_, &_inner_error_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp228_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 11263 "tracker-sparql-pattern.c"
							} else {
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp228_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 11279 "tracker-sparql-pattern.c"
							}
						}
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 11284 "tracker-sparql-pattern.c"
					}
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp243_ = in_group_graph_pattern;
#line 1103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp243_) {
#line 1104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_group_graph_pattern = TRUE;
#line 11292 "tracker-sparql-pattern.c"
					}
#line 1107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp244_ = sql;
#line 1107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp245_ = group_graph_pattern_start;
#line 1107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp244_, (gssize) _tmp245_, "SELECT * FROM (");
#line 1108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp246_ = sql;
#line 1108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp246_, ") NATURAL INNER JOIN (");
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp247_ = sql;
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp247_, &_inner_error_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11324 "tracker-sparql-pattern.c"
						} else {
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11340 "tracker-sparql-pattern.c"
						}
					}
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp248_ = sql;
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp248_, ")");
#line 11347 "tracker-sparql-pattern.c"
				}
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp249_ = old_graph;
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp250_ = g_strdup (_tmp249_);
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1113 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp250_;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp251_ = old_graph_is_var;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp251_;
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp228_);
#line 1087 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_graph);
#line 11365 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp252_ = FALSE;
				gboolean _tmp253_;
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp253_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BIND, &_inner_error_);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp252_ = _tmp253_;
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11385 "tracker-sparql-pattern.c"
					} else {
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11397 "tracker-sparql-pattern.c"
					}
				}
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp252_) {
#line 11402 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* binding = NULL;
					TrackerSparqlVariableBinding* _tmp254_;
					GString* bind_sql = NULL;
					GString* _tmp255_;
					TrackerSparqlContext* _tmp256_;
					TrackerSparqlContext* _tmp257_;
					gboolean _tmp258_;
					TrackerSparqlExpression* _tmp259_;
					GString* _tmp260_;
					TrackerSparqlContext* _tmp261_;
					TrackerSparqlContext* _tmp262_;
					TrackerSparqlVariableBinding* _tmp263_;
					GString* _tmp264_;
					const gchar* _tmp265_;
					TrackerSparqlVariable* as_var = NULL;
					TrackerSparqlContext* _tmp266_;
					TrackerSparqlContext* _tmp267_;
					gchar* _tmp268_;
					gchar* _tmp269_;
					gchar* _tmp270_;
					gchar* _tmp271_;
					TrackerSparqlVariable* _tmp272_;
					TrackerSparqlVariable* _tmp273_;
					TrackerSparqlVariable* _tmp274_;
					TrackerSparqlVariable* _tmp275_;
					TrackerSparqlVariableBinding* _tmp276_;
					TrackerSparqlVariableBinding* _tmp279_;
					TrackerSparqlVariable* _tmp280_;
					gboolean _tmp281_;
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp254_ = tracker_sparql_variable_binding_new ();
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp254_;
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp255_ = g_string_new ("");
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					bind_sql = _tmp255_;
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11458 "tracker-sparql-pattern.c"
						} else {
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11474 "tracker-sparql-pattern.c"
						}
					}
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp256_ = tracker_sparql_pattern_get_context (self);
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp257_ = _tmp256_;
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp258_ = in_group_graph_pattern;
#line 1124 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp257_->need_binding_expression = !_tmp258_;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp259_ = self->priv->expression;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp260_ = bind_sql;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_expression_translate_expression (_tmp259_, _tmp260_, &_inner_error_);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11507 "tracker-sparql-pattern.c"
						} else {
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11523 "tracker-sparql-pattern.c"
						}
					}
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp261_ = tracker_sparql_pattern_get_context (self);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp262_ = _tmp261_;
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp262_->need_binding_expression = FALSE;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp263_ = binding;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp264_ = bind_sql;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp265_ = _tmp264_->str;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp263_, _tmp265_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11558 "tracker-sparql-pattern.c"
						} else {
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11574 "tracker-sparql-pattern.c"
						}
					}
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11595 "tracker-sparql-pattern.c"
						} else {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11611 "tracker-sparql-pattern.c"
						}
					}
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp266_ = tracker_sparql_pattern_get_context (self);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp267_ = _tmp266_;
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp268_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp269_ = _tmp268_;
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp270_ = string_substring (_tmp269_, (glong) 1, (glong) -1);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp271_ = _tmp270_;
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp272_ = tracker_sparql_context_get_variable (_tmp267_, _tmp271_);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp273_ = _g_object_ref0 (_tmp272_);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp274_ = _tmp273_;
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp271_);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp269_);
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					as_var = _tmp274_;
#line 1134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp275_ = as_var;
#line 1134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp276_ = _tmp275_->binding;
#line 1134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp276_ != NULL) {
#line 11644 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp277_;
						GError* _tmp278_;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp277_ = self->priv->query;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp278_ = tracker_sparql_query_get_internal_error (_tmp277_, "Expected undefined variable in BIND alias");
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_inner_error_ = _tmp278_;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11669 "tracker-sparql-pattern.c"
						} else {
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11687 "tracker-sparql-pattern.c"
						}
					}
#line 1138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp279_ = binding;
#line 1138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp280_ = as_var;
#line 1138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp279_->variable = _tmp280_;
#line 1140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp281_ = in_group_graph_pattern;
#line 1140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp281_) {
#line 11700 "tracker-sparql-pattern.c"
						GString* binding_sql = NULL;
						GString* _tmp282_;
						GString* _tmp283_;
						TrackerSparqlVariableBinding* _tmp284_;
						GString* _tmp285_;
						GString* _tmp286_;
						glong _tmp287_;
						GString* _tmp288_;
						const gchar* _tmp289_;
						GString* _tmp290_;
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp282_ = g_string_new ("SELECT ");
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						binding_sql = _tmp282_;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp283_ = binding_sql;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp284_ = binding;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_add_variable_binding (self, _tmp283_, _tmp284_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp285_ = binding_sql;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp285_, " * FROM (");
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp286_ = sql;
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp287_ = group_graph_pattern_start;
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp288_ = binding_sql;
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp289_ = _tmp288_->str;
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_insert (_tmp286_, (gssize) _tmp287_, _tmp289_);
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp290_ = sql;
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp290_, ")");
#line 1140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (binding_sql);
#line 11741 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp291_;
						TrackerSparqlVariableBinding* _tmp292_;
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp291_ = sql;
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp292_ = binding;
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_add_variable_binding (self, _tmp291_, _tmp292_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 11751 "tracker-sparql-pattern.c"
					}
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11773 "tracker-sparql-pattern.c"
						} else {
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11791 "tracker-sparql-pattern.c"
						}
					}
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (as_var);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (bind_sql);
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding);
#line 11800 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlTokenType _tmp293_;
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp293_ = tracker_sparql_pattern_current (self);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp293_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
#line 11807 "tracker-sparql-pattern.c"
						gboolean _tmp294_ = FALSE;
						gboolean _tmp295_;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp295_ = in_triples_block;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp295_) {
#line 11814 "tracker-sparql-pattern.c"
							gboolean _tmp296_;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp296_ = in_group_graph_pattern;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp294_ = !_tmp296_;
#line 11820 "tracker-sparql-pattern.c"
						} else {
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp294_ = FALSE;
#line 11824 "tracker-sparql-pattern.c"
						}
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp294_) {
#line 11828 "tracker-sparql-pattern.c"
							GString* _tmp297_;
							glong _tmp298_;
							GString* _tmp299_;
							GString* _tmp300_;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_group_graph_pattern = TRUE;
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp297_ = sql;
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp298_ = group_graph_pattern_start;
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_insert (_tmp297_, (gssize) _tmp298_, "SELECT * FROM (");
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp299_ = sql;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp299_, &_inner_error_);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11857 "tracker-sparql-pattern.c"
								} else {
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11869 "tracker-sparql-pattern.c"
								}
							}
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp300_ = sql;
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp300_, ")");
#line 11876 "tracker-sparql-pattern.c"
						} else {
							gboolean _tmp301_;
							gboolean _tmp304_;
							GString* _tmp305_;
							glong _tmp306_;
							GString* _tmp307_;
							GString* _tmp308_;
							GString* _tmp309_;
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp301_ = in_triples_block;
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp301_) {
#line 11889 "tracker-sparql-pattern.c"
								GString* _tmp302_;
								gboolean _tmp303_;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp302_ = sql;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp303_ = in_group_graph_pattern;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								tracker_sparql_pattern_end_triples_block (self, _tmp302_, &first_where, _tmp303_, &_inner_error_);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_propagate_error (error, _inner_error_);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										filters = (g_free (filters), NULL);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tracker_sparql_context_unref0 (_result_);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 11910 "tracker-sparql-pattern.c"
									} else {
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										filters = (g_free (filters), NULL);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tracker_sparql_context_unref0 (_result_);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_clear_error (&_inner_error_);
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 11922 "tracker-sparql-pattern.c"
									}
								}
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								in_triples_block = FALSE;
#line 11927 "tracker-sparql-pattern.c"
							}
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp304_ = in_group_graph_pattern;
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (!_tmp304_) {
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								in_group_graph_pattern = TRUE;
#line 11935 "tracker-sparql-pattern.c"
							}
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp305_ = sql;
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp306_ = group_graph_pattern_start;
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_insert (_tmp305_, (gssize) _tmp306_, "SELECT * FROM (");
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp307_ = sql;
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp307_, ") NATURAL INNER JOIN (");
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp308_ = sql;
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp308_, &_inner_error_);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11963 "tracker-sparql-pattern.c"
								} else {
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11975 "tracker-sparql-pattern.c"
								}
							}
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp309_ = sql;
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp309_, ")");
#line 11982 "tracker-sparql-pattern.c"
						}
					} else {
						TrackerSparqlTokenType _tmp310_;
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp310_ = tracker_sparql_pattern_current (self);
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp310_ == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
#line 11990 "tracker-sparql-pattern.c"
							TrackerSourceLocation* _tmp311_;
							gint _tmp311__length1;
							TrackerSourceLocation _tmp312_ = {0};
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp311_ = filters;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp311__length1 = filters_length1;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_get_location (self, &_tmp312_);
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_vala_array_add8 (&filters, &filters_length1, &_filters_size_, &_tmp312_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_skip_filter (self, &_inner_error_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 12016 "tracker-sparql-pattern.c"
								} else {
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 12028 "tracker-sparql-pattern.c"
								}
							}
						} else {
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 12034 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12054 "tracker-sparql-pattern.c"
			} else {
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12066 "tracker-sparql-pattern.c"
			}
		}
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp313_ = sql;
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp314_ = group_graph_pattern_start;
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp315_ = found_simple_optional;
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_triples (self, _tmp313_, _tmp314_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp315_, &_inner_error_);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12089 "tracker-sparql-pattern.c"
			} else {
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12101 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 12119 "tracker-sparql-pattern.c"
		} else {
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 12131 "tracker-sparql-pattern.c"
		}
	}
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp317_ = in_triples_block;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp317_) {
#line 12138 "tracker-sparql-pattern.c"
		gboolean _tmp318_;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp318_ = in_group_graph_pattern;
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp316_ = !_tmp318_;
#line 12144 "tracker-sparql-pattern.c"
	} else {
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp316_ = FALSE;
#line 12148 "tracker-sparql-pattern.c"
	}
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp316_) {
#line 12152 "tracker-sparql-pattern.c"
		GString* _tmp319_;
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp319_ = sql;
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp319_, "SELECT 1");
#line 12158 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp320_;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp320_ = in_triples_block;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp320_) {
#line 12165 "tracker-sparql-pattern.c"
			GString* _tmp321_;
			gboolean _tmp322_;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp321_ = sql;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp322_ = in_group_graph_pattern;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp321_, &first_where, _tmp322_, &_inner_error_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 12186 "tracker-sparql-pattern.c"
				} else {
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 12198 "tracker-sparql-pattern.c"
				}
			}
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_triples_block = FALSE;
#line 12203 "tracker-sparql-pattern.c"
		}
	}
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp323_ = in_group_graph_pattern;
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp323_) {
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_where = TRUE;
#line 12212 "tracker-sparql-pattern.c"
	}
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp324_ = filters;
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp324__length1 = filters_length1;
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp324__length1 > 0) {
#line 12220 "tracker-sparql-pattern.c"
		TrackerSourceLocation end = {0};
		TrackerSourceLocation _tmp325_ = {0};
		TrackerSourceLocation* _tmp326_;
		gint _tmp326__length1;
		TrackerSourceLocation _tmp332_;
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_get_location (self, &_tmp325_);
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		end = _tmp325_;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp326_ = filters;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp326__length1 = filters_length1;
#line 12234 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation* filter_location_collection = NULL;
			gint filter_location_collection_length1 = 0;
			gint _filter_location_collection_size_ = 0;
			gint filter_location_it = 0;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection = _tmp326_;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection_length1 = _tmp326__length1;
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (filter_location_it = 0; filter_location_it < _tmp326__length1; filter_location_it = filter_location_it + 1) {
#line 12246 "tracker-sparql-pattern.c"
				TrackerSourceLocation filter_location = {0};
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filter_location = filter_location_collection[filter_location_it];
#line 12250 "tracker-sparql-pattern.c"
				{
					gboolean _tmp327_;
					TrackerSourceLocation _tmp330_;
					GString* _tmp331_;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp327_ = first_where;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp327_) {
#line 12259 "tracker-sparql-pattern.c"
						GString* _tmp328_;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp328_ = sql;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp328_, " AND ");
#line 12265 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp329_;
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp329_ = sql;
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp329_, " WHERE ");
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first_where = FALSE;
#line 12274 "tracker-sparql-pattern.c"
					}
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp330_ = filter_location;
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp330_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp331_ = sql;
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_filter (self, _tmp331_, &_inner_error_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 12296 "tracker-sparql-pattern.c"
						} else {
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 12308 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp332_ = end;
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp332_);
#line 12318 "tracker-sparql-pattern.c"
	}
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp333_ = tracker_sparql_pattern_get_context (self);
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp334_ = _tmp333_;
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp335_ = _tmp334_->parent_context;
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp335_);
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = (g_free (filters), NULL);
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 12334 "tracker-sparql-pattern.c"
}


static void _vala_array_add9 (glong* * array, int* length, int* size, glong value) {
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (glong, *array, *size);
#line 12345 "tracker-sparql-pattern.c"
	}
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 12349 "tracker-sparql-pattern.c"
}


static void _vala_array_add10 (TrackerSparqlContext** * array, int* length, int* size, TrackerSparqlContext* value) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
#line 12360 "tracker-sparql-pattern.c"
	}
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 12366 "tracker-sparql-pattern.c"
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? tracker_sparql_context_ref (self) : NULL;
#line 12373 "tracker-sparql-pattern.c"
}


static void _vala_array_add11 (TrackerSparqlVariable** * array, int* length, int* size, TrackerSparqlVariable* value) {
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
#line 12384 "tracker-sparql-pattern.c"
	}
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 12390 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlVariable** all_vars = NULL;
	TrackerSparqlVariable** _tmp0_;
	gint all_vars_length1;
	gint _all_vars_size_;
	GHashTable* all_var_set = NULL;
	GDestroyNotify _tmp1_;
	GHashTable* _tmp2_;
	TrackerSparqlContext** contexts = NULL;
	TrackerSparqlContext** _tmp3_;
	gint contexts_length1;
	gint _contexts_size_;
	glong* offsets = NULL;
	glong* _tmp4_;
	gint offsets_length1;
	gint _offsets_size_;
	TrackerSparqlContext** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = _tmp0_;
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars_length1 = 0;
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_all_vars_size_ = all_vars_length1;
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = g_object_unref;
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp1_, NULL);
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_var_set = _tmp2_;
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_new0 (TrackerSparqlContext*, 0 + 1);
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = _tmp3_;
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts_length1 = 0;
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_contexts_size_ = contexts_length1;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_new0 (glong, 0);
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = _tmp4_;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets_length1 = 0;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_offsets_size_ = offsets_length1;
#line 12447 "tracker-sparql-pattern.c"
	{
		gboolean _tmp5_ = FALSE;
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = TRUE;
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 12454 "tracker-sparql-pattern.c"
			glong* _tmp8_;
			gint _tmp8__length1;
			GString* _tmp9_;
			gssize _tmp10_;
			TrackerSparqlContext* _tmp11_ = NULL;
			GString* _tmp12_;
			TrackerSparqlContext* _tmp13_;
			TrackerSparqlContext** _tmp14_;
			gint _tmp14__length1;
			TrackerSparqlContext* _tmp15_;
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp5_) {
#line 12467 "tracker-sparql-pattern.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = _tmp7_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12490 "tracker-sparql-pattern.c"
					} else {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12506 "tracker-sparql-pattern.c"
					}
				}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp6_) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 12513 "tracker-sparql-pattern.c"
				}
			}
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = FALSE;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = offsets;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8__length1 = offsets_length1;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = sql;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = _tmp9_->len;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add9 (&offsets, &offsets_length1, &_offsets_size_, (glong) _tmp10_);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = sql;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp12_, &_inner_error_);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp13_;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12550 "tracker-sparql-pattern.c"
				} else {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12566 "tracker-sparql-pattern.c"
				}
			}
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = contexts;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14__length1 = contexts_length1;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = _tmp11_;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = NULL;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add10 (&contexts, &contexts_length1, &_contexts_size_, _tmp15_);
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_tmp11_);
#line 12581 "tracker-sparql-pattern.c"
		}
	}
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16_ = contexts;
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16__length1 = contexts_length1;
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp16__length1 > 1) {
#line 12590 "tracker-sparql-pattern.c"
		TrackerSparqlContext** _tmp17_;
		gint _tmp17__length1;
		glong extra_offset = 0L;
		GString* _tmp71_;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = contexts;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17__length1 = contexts_length1;
#line 12599 "tracker-sparql-pattern.c"
		{
			TrackerSparqlContext** sub_context_collection = NULL;
			gint sub_context_collection_length1 = 0;
			gint _sub_context_collection_size_ = 0;
			gint sub_context_it = 0;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection = _tmp17_;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection_length1 = _tmp17__length1;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (sub_context_it = 0; sub_context_it < _tmp17__length1; sub_context_it = sub_context_it + 1) {
#line 12611 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp18_;
				TrackerSparqlContext* sub_context = NULL;
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				sub_context = _tmp18_;
#line 12618 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp19_;
					GHashTable* _tmp20_;
					GList* _tmp21_;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sub_context;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp19_->var_set;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = g_hash_table_get_keys (_tmp20_);
#line 12629 "tracker-sparql-pattern.c"
					{
						GList* v_collection = NULL;
						GList* v_it = NULL;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp21_;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 12637 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* v = NULL;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = (TrackerSparqlVariable*) v_it->data;
#line 12641 "tracker-sparql-pattern.c"
							{
								GHashTable* _tmp22_;
								TrackerSparqlVariable* _tmp23_;
								gconstpointer _tmp24_;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp22_ = all_var_set;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp23_ = v;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp24_ = g_hash_table_lookup (_tmp22_, _tmp23_);
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp24_)) == 0) {
#line 12654 "tracker-sparql-pattern.c"
									TrackerSparqlVariable** _tmp25_;
									gint _tmp25__length1;
									TrackerSparqlVariable* _tmp26_;
									TrackerSparqlVariable* _tmp27_;
									GHashTable* _tmp28_;
									TrackerSparqlVariable* _tmp29_;
									TrackerSparqlVariable* _tmp30_;
									TrackerSparqlContext* _tmp31_;
									TrackerSparqlContext* _tmp32_;
									GHashTable* _tmp33_;
									TrackerSparqlVariable* _tmp34_;
									TrackerSparqlVariable* _tmp35_;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25_ = all_vars;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25__length1 = all_vars_length1;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp26_ = v;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp27_ = _g_object_ref0 (_tmp26_);
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_vala_array_add11 (&all_vars, &all_vars_length1, &_all_vars_size_, _tmp27_);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp28_ = all_var_set;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp29_ = v;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp30_ = _g_object_ref0 (_tmp29_);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp28_, _tmp30_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp31_ = tracker_sparql_pattern_get_context (self);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp32_ = _tmp31_;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp33_ = _tmp32_->var_set;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp34_ = v;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp35_ = _g_object_ref0 (_tmp34_);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp33_, _tmp35_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 12697 "tracker-sparql-pattern.c"
								}
							}
						}
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (v_collection);
#line 12703 "tracker-sparql-pattern.c"
					}
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (sub_context);
#line 12707 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		extra_offset = (glong) 0;
#line 12713 "tracker-sparql-pattern.c"
		{
			gint i = 0;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 12718 "tracker-sparql-pattern.c"
			{
				gboolean _tmp36_ = FALSE;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = TRUE;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 12725 "tracker-sparql-pattern.c"
					gint _tmp38_;
					TrackerSparqlContext** _tmp39_;
					gint _tmp39__length1;
					GString* projection = NULL;
					GString* _tmp40_;
					gint _tmp41_;
					GString* _tmp43_;
					TrackerSparqlVariable** _tmp44_;
					gint _tmp44__length1;
					GString* _tmp57_;
					GString* _tmp58_;
					gssize _tmp59_;
					GString* _tmp60_;
					GString* _tmp61_;
					glong* _tmp62_;
					gint _tmp62__length1;
					gint _tmp63_;
					glong _tmp64_;
					glong _tmp65_;
					GString* _tmp66_;
					const gchar* _tmp67_;
					glong _tmp68_;
					GString* _tmp69_;
					gssize _tmp70_;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp36_) {
#line 12752 "tracker-sparql-pattern.c"
						gint _tmp37_;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp37_ = i;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp37_ + 1;
#line 12758 "tracker-sparql-pattern.c"
					}
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = FALSE;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp38_ = i;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = contexts;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39__length1 = contexts_length1;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!(_tmp38_ < _tmp39__length1)) {
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 12772 "tracker-sparql-pattern.c"
					}
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = g_string_new ("");
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					projection = _tmp40_;
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = i;
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp41_ > 0) {
#line 12782 "tracker-sparql-pattern.c"
						GString* _tmp42_;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp42_ = projection;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp42_, ") UNION ALL ");
#line 12788 "tracker-sparql-pattern.c"
					}
#line 1259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = projection;
#line 1259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp43_, "SELECT ");
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = all_vars;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44__length1 = all_vars_length1;
#line 12798 "tracker-sparql-pattern.c"
					{
						TrackerSparqlVariable** v_collection = NULL;
						gint v_collection_length1 = 0;
						gint _v_collection_size_ = 0;
						gint v_it = 0;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp44_;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection_length1 = _tmp44__length1;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = 0; v_it < _tmp44__length1; v_it = v_it + 1) {
#line 12810 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* _tmp45_;
							TrackerSparqlVariable* v = NULL;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp45_ = _g_object_ref0 (v_collection[v_it]);
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = _tmp45_;
#line 12817 "tracker-sparql-pattern.c"
							{
								TrackerSparqlContext** _tmp46_;
								gint _tmp46__length1;
								gint _tmp47_;
								TrackerSparqlContext* _tmp48_;
								GHashTable* _tmp49_;
								TrackerSparqlVariable* _tmp50_;
								gconstpointer _tmp51_;
								GString* _tmp53_;
								TrackerSparqlVariable* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46_ = contexts;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46__length1 = contexts_length1;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47_ = i;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp48_ = _tmp46_[_tmp47_];
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp49_ = _tmp48_->var_set;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp50_ = v;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp51_ = g_hash_table_lookup (_tmp49_, _tmp50_);
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp51_)) == 0) {
#line 12846 "tracker-sparql-pattern.c"
									GString* _tmp52_;
#line 1264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = projection;
#line 1264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp52_, "NULL AS ");
#line 12852 "tracker-sparql-pattern.c"
								}
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp53_ = projection;
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp54_ = v;
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp55_ = tracker_sparql_variable_get_sql_expression (_tmp54_);
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp56_ = _tmp55_;
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp53_, "%s, ", _tmp56_);
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (v);
#line 12866 "tracker-sparql-pattern.c"
							}
						}
					}
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp57_ = projection;
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = projection;
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp59_ = _tmp58_->len;
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_truncate (_tmp57_, (gsize) (_tmp59_ - 2));
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = projection;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp60_, " FROM (");
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp61_ = sql;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = offsets;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62__length1 = offsets_length1;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = i;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = _tmp62_[_tmp63_];
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = extra_offset;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = projection;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = _tmp66_->str;
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp61_, (gssize) (_tmp64_ + _tmp65_), _tmp67_);
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = extra_offset;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = projection;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = _tmp69_->len;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					extra_offset = _tmp68_ + _tmp70_;
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (projection);
#line 12910 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp71_ = sql;
#line 1275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp71_, ")");
#line 12918 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlContext** _tmp72_;
		gint _tmp72__length1;
		TrackerSparqlContext* _tmp73_;
		GHashTable* _tmp74_;
		GList* _tmp75_;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = contexts;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72__length1 = contexts_length1;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp73_ = _tmp72_[0];
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp74_ = _tmp73_->var_set;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp75_ = g_hash_table_get_keys (_tmp74_);
#line 12935 "tracker-sparql-pattern.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key_collection = _tmp75_;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 12943 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* key = NULL;
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				key = (TrackerSparqlVariable*) key_it->data;
#line 12947 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp76_;
					TrackerSparqlContext* _tmp77_;
					GHashTable* _tmp78_;
					TrackerSparqlVariable* _tmp79_;
					TrackerSparqlVariable* _tmp80_;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = tracker_sparql_pattern_get_context (self);
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = _tmp76_;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_->var_set;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = key;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp78_, _tmp80_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 12966 "tracker-sparql-pattern.c"
				}
			}
#line 1277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (key_collection);
#line 12971 "tracker-sparql-pattern.c"
		}
	}
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = (g_free (offsets), NULL);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (all_var_set);
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 12982 "tracker-sparql-pattern.c"
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list = NULL;
	TrackerSparqlPatternTripleContext* _tmp0_;
	gboolean _tmp6_ = FALSE;
	TrackerSparqlVariableBindingList* _tmp7_;
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 1284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = NULL;
#line 1285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->triple_context;
#line 1285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ != NULL) {
#line 13002 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp1_;
		GHashTable* _tmp2_;
		TrackerSparqlVariable* _tmp3_;
		gconstpointer _tmp4_;
		TrackerSparqlVariableBindingList* _tmp5_;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->triple_context;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp1_->var_bindings;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = variable;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp4_);
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp5_;
#line 13022 "tracker-sparql-pattern.c"
	}
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = binding_list;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp7_ == NULL) {
#line 13028 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariableBinding* _tmp9_;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = variable;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_->binding;
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 13037 "tracker-sparql-pattern.c"
	} else {
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = FALSE;
#line 13041 "tracker-sparql-pattern.c"
	}
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp6_) {
#line 13045 "tracker-sparql-pattern.c"
		TrackerSparqlContext* current_context = NULL;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		TrackerSparqlContext* _tmp12_;
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_context (self);
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _tracker_sparql_context_ref0 (_tmp11_);
#line 1290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		current_context = _tmp12_;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 13060 "tracker-sparql-pattern.c"
			TrackerSparqlContext* _tmp13_;
			gboolean _tmp14_ = FALSE;
			TrackerSparqlContext* _tmp15_;
			gboolean _tmp16_;
			TrackerSparqlContext* _tmp62_;
			TrackerSparqlContext* _tmp63_;
			TrackerSparqlContext* _tmp64_;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = current_context;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!(_tmp13_ != NULL)) {
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 13074 "tracker-sparql-pattern.c"
			}
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = current_context;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = _tmp15_->scalar_subquery;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp16_) {
#line 13082 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp17_;
				TrackerSparqlContext* _tmp18_;
				GHashTable* _tmp19_;
				TrackerSparqlVariable* _tmp20_;
				gconstpointer _tmp21_;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = current_context;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tmp17_->parent_context;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = _tmp18_->var_set;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = variable;
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = ((gint) ((gintptr) _tmp21_)) != 0;
#line 13100 "tracker-sparql-pattern.c"
			} else {
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = FALSE;
#line 13104 "tracker-sparql-pattern.c"
			}
#line 1294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp14_) {
#line 13108 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* binding = NULL;
				TrackerSparqlVariableBinding* _tmp22_;
				TrackerSparqlVariableBinding* _tmp23_;
				TrackerSparqlVariable* _tmp24_;
				TrackerSparqlVariableBinding* _tmp25_;
				TrackerPropertyType _tmp26_;
				TrackerSparqlVariableBinding* _tmp27_;
				TrackerSparqlContext* _tmp28_;
				TrackerSparqlContext* _tmp29_;
				TrackerSparqlVariable* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				TrackerSparqlVariable* _tmp33_;
				TrackerSparqlVariableBinding* _tmp34_;
				TrackerSparqlVariable* _tmp35_;
				TrackerSparqlVariableBinding* _tmp36_;
				TrackerClass* _tmp37_;
				TrackerClass* _tmp38_;
				TrackerSparqlVariableBinding* _tmp39_;
				TrackerSparqlVariable* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				TrackerSparqlVariableBindingList* _tmp43_;
				TrackerSparqlPatternTripleContext* _tmp44_;
				TrackerSparqlContext* _tmp54_;
				TrackerSparqlContext* _tmp55_;
				GHashTable* _tmp56_;
				TrackerSparqlVariable* _tmp57_;
				TrackerSparqlVariable* _tmp58_;
				TrackerSparqlVariableBindingList* _tmp59_;
				TrackerSparqlVariableBinding* _tmp60_;
				TrackerSparqlVariableBinding* _tmp61_;
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = tracker_sparql_variable_binding_new ();
#line 1296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp22_;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = binding;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = variable;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = _tmp24_->binding;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = ((TrackerSparqlDataBinding*) _tmp25_)->data_type;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp23_)->data_type = _tmp26_;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = binding;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = tracker_sparql_pattern_get_context (self);
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = _tmp28_;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = variable;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = tracker_sparql_variable_get_name (_tmp30_);
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _tmp31_;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = tracker_sparql_context_get_variable (_tmp29_, _tmp32_);
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_->variable = _tmp33_;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = binding;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = variable;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = _tmp35_->binding;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp36_->type;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = _g_object_ref0 (_tmp37_);
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp34_->type);
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_->type = _tmp38_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = binding;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = variable;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp41_ = tracker_sparql_variable_get_sql_expression (_tmp40_);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = _tmp41_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp39_, _tmp42_);
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp43_ = tracker_sparql_variable_binding_list_new ();
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding_list);
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_list = _tmp43_;
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp44_ = self->priv->triple_context;
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp44_ != NULL) {
#line 13205 "tracker-sparql-pattern.c"
					TrackerSparqlPatternTripleContext* _tmp45_;
					TrackerSparqlVariable* _tmp46_;
					TrackerSparqlVariable* _tmp47_;
					TrackerSparqlPatternTripleContext* _tmp48_;
					GHashTable* _tmp49_;
					TrackerSparqlVariable* _tmp50_;
					TrackerSparqlVariable* _tmp51_;
					TrackerSparqlVariableBindingList* _tmp52_;
					TrackerSparqlVariableBindingList* _tmp53_;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = self->priv->triple_context;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = variable;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = _g_object_ref0 (_tmp46_);
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_->variables = g_list_append (_tmp45_->variables, _tmp47_);
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = self->priv->triple_context;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp49_ = _tmp48_->var_bindings;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = variable;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = _g_object_ref0 (_tmp50_);
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = binding_list;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp49_, _tmp51_, _tmp53_);
#line 13237 "tracker-sparql-pattern.c"
				}
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp54_ = tracker_sparql_pattern_get_context (self);
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp55_ = _tmp54_;
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = _tmp55_->var_set;
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = variable;
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = _g_object_ref0 (_tmp57_);
#line 1307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp56_, _tmp58_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = binding_list;
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = binding;
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = _g_object_ref0 (_tmp60_);
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_->list = g_list_append (_tmp59_->list, _tmp61_);
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 13263 "tracker-sparql-pattern.c"
			}
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp62_ = current_context;
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp63_ = _tmp62_->parent_context;
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp64_ = _tracker_sparql_context_ref0 (_tmp63_);
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (current_context);
#line 1311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			current_context = _tmp64_;
#line 13275 "tracker-sparql-pattern.c"
		}
#line 1288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (current_context);
#line 13279 "tracker-sparql-pattern.c"
	}
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = binding_list;
#line 1314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 13285 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBindingList* binding_list = NULL;
	TrackerSparqlVariableBinding* _tmp0_;
	TrackerSparqlVariable* _tmp1_;
	TrackerSparqlVariableBindingList* _tmp2_;
	TrackerSparqlVariableBindingList* _tmp3_;
	TrackerSparqlVariableBindingList* _tmp50_;
	TrackerSparqlVariableBinding* _tmp51_;
	TrackerSparqlVariableBinding* _tmp52_;
	TrackerSparqlVariableBinding* _tmp53_;
	TrackerSparqlVariable* _tmp54_;
	TrackerSparqlVariableBinding* _tmp55_;
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (binding != NULL);
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = binding;
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->variable;
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_variable_binding_list (self, _tmp1_);
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = _tmp2_;
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = binding_list;
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_ == NULL) {
#line 13319 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBindingList* _tmp4_;
		TrackerSparqlPatternTripleContext* _tmp5_;
		GString* _tmp17_;
		TrackerSparqlVariableBinding* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		TrackerSparqlVariableBinding* _tmp21_;
		TrackerSparqlVariable* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		TrackerSparqlVariableBinding* _tmp25_;
		TrackerPropertyType _tmp26_;
		TrackerSparqlContext* _tmp43_;
		TrackerSparqlContext* _tmp44_;
		GHashTable* _tmp45_;
		TrackerSparqlVariableBinding* _tmp46_;
		TrackerSparqlVariable* _tmp47_;
		TrackerSparqlVariable* _tmp48_;
		TrackerSparqlVariableState _tmp49_;
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_variable_binding_list_new ();
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp4_;
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->triple_context;
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ != NULL) {
#line 13349 "tracker-sparql-pattern.c"
			TrackerSparqlPatternTripleContext* _tmp6_;
			TrackerSparqlVariableBinding* _tmp7_;
			TrackerSparqlVariable* _tmp8_;
			TrackerSparqlVariable* _tmp9_;
			TrackerSparqlPatternTripleContext* _tmp10_;
			GHashTable* _tmp11_;
			TrackerSparqlVariableBinding* _tmp12_;
			TrackerSparqlVariable* _tmp13_;
			TrackerSparqlVariable* _tmp14_;
			TrackerSparqlVariableBindingList* _tmp15_;
			TrackerSparqlVariableBindingList* _tmp16_;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = self->priv->triple_context;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = binding;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = _tmp7_->variable;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_->variables = g_list_append (_tmp6_->variables, _tmp9_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = self->priv->triple_context;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp10_->var_bindings;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = binding;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp12_->variable;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = binding_list;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp11_, _tmp14_, _tmp16_);
#line 13387 "tracker-sparql-pattern.c"
		}
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = sql;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = binding;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp18_);
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = _tmp19_;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = binding;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp21_->variable;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = tracker_sparql_variable_get_sql_expression (_tmp22_);
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = _tmp23_;
#line 1326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp17_, "%s AS %s, ", _tmp20_, _tmp24_);
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = binding;
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = ((TrackerSparqlDataBinding*) _tmp25_)->data_type;
#line 1330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp26_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 13413 "tracker-sparql-pattern.c"
			GString* _tmp27_;
			TrackerSparqlVariableBinding* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			TrackerSparqlVariableBinding* _tmp31_;
			TrackerSparqlVariable* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GString* _tmp35_;
			TrackerSparqlVariableBinding* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			TrackerSparqlVariableBinding* _tmp39_;
			TrackerSparqlVariable* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = sql;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = binding;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp28_, "localDate");
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _tmp29_;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = binding;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp32_ = _tmp31_->variable;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = tracker_sparql_variable_get_extra_sql_expression (_tmp32_, "localDate");
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp34_ = _tmp33_;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp27_, "%s AS %s, ", _tmp30_, _tmp34_);
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp34_);
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp30_);
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp35_ = sql;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp36_ = binding;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp37_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp36_, "localTime");
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp38_ = _tmp37_;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp39_ = binding;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp40_ = _tmp39_->variable;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp41_ = tracker_sparql_variable_get_extra_sql_expression (_tmp40_, "localTime");
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp42_ = _tmp41_;
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp35_, "%s AS %s, ", _tmp38_, _tmp42_);
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp42_);
#line 1334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp38_);
#line 13474 "tracker-sparql-pattern.c"
		}
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp43_ = tracker_sparql_pattern_get_context (self);
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp44_ = _tmp43_;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp45_ = _tmp44_->var_set;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp46_ = binding;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp47_ = _tmp46_->variable;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp48_ = _g_object_ref0 (_tmp47_);
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp49_ = variable_state;
#line 1339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp45_, _tmp48_, (gpointer) ((gintptr) ((gint) _tmp49_)));
#line 13492 "tracker-sparql-pattern.c"
	}
#line 1341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = binding_list;
#line 1341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = binding;
#line 1341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->list = g_list_append (_tmp50_->list, _tmp52_);
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = binding;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp54_ = _tmp53_->variable;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp55_ = _tmp54_->binding;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp55_ == NULL) {
#line 13510 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBinding* _tmp56_;
		TrackerSparqlVariable* _tmp57_;
		TrackerSparqlVariableBinding* _tmp58_;
		TrackerSparqlVariableBinding* _tmp59_;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = binding;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = _tmp56_->variable;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp58_ = binding;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp57_->binding);
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_->binding = _tmp59_;
#line 13527 "tracker-sparql-pattern.c"
	}
#line 1317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (binding_list);
#line 13531 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	glong begin_sql_len = 0L;
	GString* _tmp0_;
	gssize _tmp1_;
	gboolean object_is_var = FALSE;
	gchar* object = NULL;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* db_table = NULL;
	gboolean rdftype = FALSE;
	gboolean share_table = FALSE;
	gboolean is_fts_match = FALSE;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table = NULL;
	TrackerProperty* prop = NULL;
	TrackerClass* subject_type = NULL;
	TrackerOntologies* ontologies = NULL;
	TrackerDataManager* _tmp5_;
	TrackerOntologies* _tmp6_;
	TrackerOntologies* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp270_;
	gboolean _tmp305_;
	GString* _tmp441_;
	gssize _tmp442_;
	glong _tmp443_;
	GError * _inner_error_ = NULL;
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->len;
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	begin_sql_len = (glong) _tmp1_;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = sql;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp2_, &_tmp3_, &_inner_error_);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object_is_var = _tmp3_;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object = _tmp4_;
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 13589 "tracker-sparql-pattern.c"
		} else {
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 13597 "tracker-sparql-pattern.c"
		}
	}
#line 1353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	db_table = NULL;
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	rdftype = FALSE;
#line 1355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	share_table = TRUE;
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	is_fts_match = FALSE;
#line 1360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	prop = NULL;
#line 1362 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	subject_type = NULL;
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = self->priv->manager;
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = tracker_data_manager_get_ontologies (_tmp5_);
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 1364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	ontologies = _tmp7_;
#line 1366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp8_ = self->priv->current_predicate_is_var;
#line 1366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp8_) {
#line 13624 "tracker-sparql-pattern.c"
		TrackerOntologies* _tmp9_;
		const gchar* _tmp10_;
		TrackerProperty* _tmp11_;
		TrackerProperty* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		const gchar* _tmp201_;
		const gchar* _tmp202_;
		gboolean _tmp203_;
		gboolean _tmp204_ = FALSE;
		TrackerSparqlDataTable* _tmp205_;
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = ontologies;
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = self->priv->current_predicate;
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = tracker_ontologies_get_property_by_uri (_tmp9_, _tmp10_);
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp12_;
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = self->priv->current_predicate;
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (g_strcmp0 (_tmp15_, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
#line 13653 "tracker-sparql-pattern.c"
			gboolean _tmp16_;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = object_is_var;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = !_tmp16_;
#line 13659 "tracker-sparql-pattern.c"
		} else {
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = FALSE;
#line 13663 "tracker-sparql-pattern.c"
		}
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp14_) {
#line 13667 "tracker-sparql-pattern.c"
			const gchar* _tmp17_;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = self->current_graph;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp17_ == NULL;
#line 13673 "tracker-sparql-pattern.c"
		} else {
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = FALSE;
#line 13677 "tracker-sparql-pattern.c"
		}
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp13_) {
#line 13681 "tracker-sparql-pattern.c"
			TrackerClass* cl = NULL;
			TrackerOntologies* _tmp18_;
			const gchar* _tmp19_;
			TrackerClass* _tmp20_;
			TrackerClass* _tmp21_;
			TrackerClass* _tmp22_;
			TrackerClass* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			TrackerClass* _tmp32_;
			TrackerClass* _tmp33_;
#line 1373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			rdftype = TRUE;
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp18_ = ontologies;
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp19_ = object;
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp20_ = tracker_ontologies_get_class_by_uri (_tmp18_, _tmp19_);
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cl = _tmp21_;
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp22_ = cl;
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp22_ == NULL) {
#line 13710 "tracker-sparql-pattern.c"
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = object;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = g_strdup_printf ("Unknown class `%s'", _tmp23_);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = _tmp24_;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp25_);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = _tmp26_;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp25_);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_inner_error_ = _tmp27_;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 13750 "tracker-sparql-pattern.c"
				} else {
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 13772 "tracker-sparql-pattern.c"
				}
			}
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = cl;
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = tracker_class_get_name (_tmp28_);
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _tmp29_;
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (db_table);
#line 1378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			db_table = _tmp31_;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp32_ = cl;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (subject_type);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_type = _tmp33_;
#line 1369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cl);
#line 13797 "tracker-sparql-pattern.c"
		} else {
			TrackerProperty* _tmp34_;
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp34_ = prop;
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp34_ == NULL) {
#line 13804 "tracker-sparql-pattern.c"
				const gchar* _tmp35_;
#line 1381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = self->priv->current_predicate;
#line 1381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp35_, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
#line 13810 "tracker-sparql-pattern.c"
					gchar* _tmp36_;
					TrackerSparqlContext* _tmp37_;
					TrackerSparqlContext* _tmp38_;
					const gchar* _tmp39_;
					TrackerSparqlVariable* _tmp40_;
					TrackerSparqlVariable* _tmp41_;
#line 1383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = g_strdup ("fts5");
#line 1383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp36_;
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 1385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					is_fts_match = TRUE;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp37_ = tracker_sparql_pattern_get_context (self);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp38_ = _tmp37_;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = self->priv->current_subject;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = tracker_sparql_context_get_variable (_tmp38_, _tmp39_);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = _g_object_ref0 (_tmp40_);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (self->fts_subject);
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->fts_subject = _tmp41_;
#line 13841 "tracker-sparql-pattern.c"
				} else {
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					GError* _tmp45_;
					GError* _tmp46_;
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = self->priv->current_predicate;
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = g_strdup_printf ("Unknown property `%s'", _tmp42_);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = _tmp43_;
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp44_);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = _tmp45_;
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp44_);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp46_;
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 13880 "tracker-sparql-pattern.c"
					} else {
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 13900 "tracker-sparql-pattern.c"
					}
				}
			} else {
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				const gchar* _tmp49_;
				gboolean _tmp87_;
				const gchar* _tmp117_;
				TrackerProperty* _tmp122_;
				gboolean _tmp123_;
				gboolean _tmp124_;
				TrackerProperty* _tmp125_;
				TrackerClass* _tmp126_;
				TrackerClass* _tmp127_;
				TrackerClass* _tmp128_;
				gboolean _tmp129_ = FALSE;
				gboolean _tmp130_;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp49_ = self->priv->current_predicate;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp49_, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
#line 13922 "tracker-sparql-pattern.c"
					gboolean _tmp50_;
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = self->priv->current_subject_is_var;
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = _tmp50_;
#line 13928 "tracker-sparql-pattern.c"
				} else {
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = FALSE;
#line 13932 "tracker-sparql-pattern.c"
				}
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp48_) {
#line 13936 "tracker-sparql-pattern.c"
					gboolean _tmp51_;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = object_is_var;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = !_tmp51_;
#line 13942 "tracker-sparql-pattern.c"
				} else {
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = FALSE;
#line 13946 "tracker-sparql-pattern.c"
				}
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp47_) {
#line 13950 "tracker-sparql-pattern.c"
					TrackerClass* domain = NULL;
					TrackerOntologies* _tmp52_;
					const gchar* _tmp53_;
					TrackerClass* _tmp54_;
					TrackerClass* _tmp55_;
					TrackerClass* _tmp56_;
					TrackerSparqlPredicateVariable* pv = NULL;
					TrackerSparqlContext* _tmp62_;
					TrackerSparqlContext* _tmp63_;
					GHashTable* _tmp64_;
					TrackerSparqlContext* _tmp65_;
					TrackerSparqlContext* _tmp66_;
					const gchar* _tmp67_;
					TrackerSparqlVariable* _tmp68_;
					gconstpointer _tmp69_;
					TrackerSparqlPredicateVariable* _tmp70_;
					TrackerSparqlPredicateVariable* _tmp71_;
					TrackerSparqlPredicateVariable* _tmp84_;
					TrackerClass* _tmp85_;
					TrackerClass* _tmp86_;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = ontologies;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = object;
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = tracker_ontologies_get_class_by_uri (_tmp52_, _tmp53_);
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp55_ = _g_object_ref0 (_tmp54_);
#line 1395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp55_;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp56_ = domain;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp56_ == NULL) {
#line 13985 "tracker-sparql-pattern.c"
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						GError* _tmp60_;
						GError* _tmp61_;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp57_ = object;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp58_ = g_strdup_printf ("Unknown class `%s'", _tmp57_);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = _tmp58_;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp60_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp59_);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = _tmp60_;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp59_);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_inner_error_ = _tmp61_;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 14025 "tracker-sparql-pattern.c"
						} else {
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 14047 "tracker-sparql-pattern.c"
						}
					}
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = tracker_sparql_pattern_get_context (self);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = _tmp62_;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = _tmp63_->predicate_variable_map;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = tracker_sparql_pattern_get_context (self);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = _tmp65_;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = self->priv->current_subject;
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = tracker_sparql_context_get_variable (_tmp66_, _tmp67_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = g_hash_table_lookup (_tmp64_, _tmp68_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp69_);
#line 1399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					pv = _tmp70_;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp71_ = pv;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp71_ == NULL) {
#line 14074 "tracker-sparql-pattern.c"
						TrackerDataManager* _tmp72_;
						TrackerSparqlPredicateVariable* _tmp73_;
						TrackerSparqlContext* _tmp74_;
						TrackerSparqlContext* _tmp75_;
						GHashTable* _tmp76_;
						TrackerSparqlContext* _tmp77_;
						TrackerSparqlContext* _tmp78_;
						const gchar* _tmp79_;
						TrackerSparqlVariable* _tmp80_;
						TrackerSparqlVariable* _tmp81_;
						TrackerSparqlPredicateVariable* _tmp82_;
						TrackerSparqlPredicateVariable* _tmp83_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = self->priv->manager;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = tracker_sparql_predicate_variable_new (_tmp72_);
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (pv);
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						pv = _tmp73_;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_pattern_get_context (self);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp76_ = _tmp75_->predicate_variable_map;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp77_ = tracker_sparql_pattern_get_context (self);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp78_ = _tmp77_;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp79_ = self->priv->current_subject;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp80_ = tracker_sparql_context_get_variable (_tmp78_, _tmp79_);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp81_ = _g_object_ref0 (_tmp80_);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp82_ = pv;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp83_ = _g_object_ref0 (_tmp82_);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_hash_table_insert (_tmp76_, _tmp81_, _tmp83_);
#line 14117 "tracker-sparql-pattern.c"
					}
#line 1404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = pv;
#line 1404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = domain;
#line 1404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = _g_object_ref0 (_tmp85_);
#line 1404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp84_->domain);
#line 1404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_->domain = _tmp86_;
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (pv);
#line 1391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 14133 "tracker-sparql-pattern.c"
				}
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp87_ = self->priv->current_subject_is_var;
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp87_) {
#line 14139 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* v = NULL;
					TrackerSparqlContext* _tmp88_;
					TrackerSparqlContext* _tmp89_;
					const gchar* _tmp90_;
					TrackerSparqlVariable* _tmp91_;
					TrackerSparqlVariable* _tmp92_;
					TrackerSparqlVariableBindingList* list = NULL;
					TrackerSparqlPatternTripleContext* _tmp93_;
					GHashTable* _tmp94_;
					TrackerSparqlVariable* _tmp95_;
					gconstpointer _tmp96_;
					TrackerSparqlVariableBindingList* _tmp97_;
					gboolean _tmp98_ = FALSE;
					TrackerSparqlVariableBindingList* _tmp99_;
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = tracker_sparql_pattern_get_context (self);
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = _tmp88_;
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp90_ = self->priv->current_subject;
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp91_ = tracker_sparql_context_get_variable (_tmp89_, _tmp90_);
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = _g_object_ref0 (_tmp91_);
#line 1409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v = _tmp92_;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = self->priv->triple_context;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = _tmp93_->var_bindings;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = v;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = g_hash_table_lookup (_tmp94_, _tmp95_);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp96_);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					list = _tmp97_;
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = list;
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp99_ != NULL) {
#line 14182 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBindingList* _tmp100_;
						GList* _tmp101_;
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp100_ = list;
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp101_ = _tmp100_->list;
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp98_ = _tmp101_ != NULL;
#line 14191 "tracker-sparql-pattern.c"
					} else {
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp98_ = FALSE;
#line 14195 "tracker-sparql-pattern.c"
					}
#line 1412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp98_) {
#line 14199 "tracker-sparql-pattern.c"
						gboolean stop = FALSE;
						TrackerProperty* _tmp102_;
						TrackerClass** _tmp103_;
						TrackerClass** _tmp104_;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						stop = FALSE;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp102_ = prop;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp104_ = _tmp103_ = tracker_property_get_domain_indexes (_tmp102_);
#line 14210 "tracker-sparql-pattern.c"
						{
							TrackerClass** cl_collection = NULL;
							gint cl_collection_length1 = 0;
							gint _cl_collection_size_ = 0;
							gint cl_it = 0;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection = _tmp104_;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection_length1 = _vala_array_length (_tmp103_);
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (cl_it = 0; cl_it < _vala_array_length (_tmp103_); cl_it = cl_it + 1) {
#line 14222 "tracker-sparql-pattern.c"
								TrackerClass* _tmp105_;
								TrackerClass* cl = NULL;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp105_ = _g_object_ref0 (cl_collection[cl_it]);
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								cl = _tmp105_;
#line 14229 "tracker-sparql-pattern.c"
								{
									TrackerSparqlVariableBindingList* _tmp106_;
									GList* _tmp107_;
									gboolean _tmp116_;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp106_ = list;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp107_ = _tmp106_->list;
#line 14238 "tracker-sparql-pattern.c"
									{
										GList* b_collection = NULL;
										GList* b_it = NULL;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										b_collection = _tmp107_;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
#line 14246 "tracker-sparql-pattern.c"
											TrackerSparqlVariableBinding* _tmp108_;
											TrackerSparqlVariableBinding* b = NULL;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp108_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) b_it->data);
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											b = _tmp108_;
#line 14253 "tracker-sparql-pattern.c"
											{
												TrackerSparqlVariableBinding* _tmp109_;
												TrackerClass* _tmp110_;
												TrackerClass* _tmp111_;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp109_ = b;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp110_ = _tmp109_->type;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp111_ = cl;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp110_ == _tmp111_) {
#line 14266 "tracker-sparql-pattern.c"
													TrackerClass* _tmp112_;
													const gchar* _tmp113_;
													const gchar* _tmp114_;
													gchar* _tmp115_;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp112_ = cl;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp113_ = tracker_class_get_name (_tmp112_);
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp114_ = _tmp113_;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp115_ = g_strdup (_tmp114_);
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (db_table);
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													db_table = _tmp115_;
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													stop = TRUE;
#line 1419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_object_unref0 (b);
#line 1419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													break;
#line 14289 "tracker-sparql-pattern.c"
												}
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_object_unref0 (b);
#line 14293 "tracker-sparql-pattern.c"
											}
										}
									}
#line 1422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp116_ = stop;
#line 1422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp116_) {
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_object_unref0 (cl);
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										break;
#line 14305 "tracker-sparql-pattern.c"
									}
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (cl);
#line 14309 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (list);
#line 1407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (v);
#line 14318 "tracker-sparql-pattern.c"
				}
#line 1429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_ = db_table;
#line 1429 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp117_ == NULL) {
#line 14324 "tracker-sparql-pattern.c"
					TrackerProperty* _tmp118_;
					const gchar* _tmp119_;
					const gchar* _tmp120_;
					gchar* _tmp121_;
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp118_ = prop;
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp119_ = tracker_property_get_table_name (_tmp118_);
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp120_ = _tmp119_;
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp121_ = g_strdup (_tmp120_);
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp121_;
#line 14341 "tracker-sparql-pattern.c"
				}
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = prop;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = tracker_property_get_multiple_values (_tmp122_);
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = _tmp123_;
#line 1432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp124_) {
#line 1435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 14353 "tracker-sparql-pattern.c"
				}
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = prop;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = tracker_property_get_domain (_tmp125_);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = _tmp126_;
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp128_ = _g_object_ref0 (_tmp127_);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (subject_type);
#line 1437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				subject_type = _tmp128_;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp130_ = in_simple_optional;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp130_) {
#line 14371 "tracker-sparql-pattern.c"
					TrackerSparqlContext* _tmp131_;
					TrackerSparqlContext* _tmp132_;
					GHashTable* _tmp133_;
					TrackerSparqlContext* _tmp134_;
					TrackerSparqlContext* _tmp135_;
					const gchar* _tmp136_;
					TrackerSparqlVariable* _tmp137_;
					gconstpointer _tmp138_;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp131_ = tracker_sparql_pattern_get_context (self);
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp132_ = _tmp131_;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp133_ = _tmp132_->var_set;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp134_ = tracker_sparql_pattern_get_context (self);
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp135_ = _tmp134_;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp136_ = self->priv->current_subject;
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp137_ = tracker_sparql_context_get_variable (_tmp135_, _tmp136_);
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp138_ = g_hash_table_lookup (_tmp133_, _tmp137_);
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = ((gint) ((gintptr) _tmp138_)) == 0;
#line 14398 "tracker-sparql-pattern.c"
				} else {
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = FALSE;
#line 14402 "tracker-sparql-pattern.c"
				}
#line 1439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp129_) {
#line 14406 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* binding = NULL;
					TrackerSparqlVariableBinding* _tmp139_;
					TrackerSparqlVariableBinding* _tmp140_;
					TrackerSparqlVariableBinding* _tmp141_;
					TrackerSparqlContext* _tmp142_;
					TrackerSparqlContext* _tmp143_;
					const gchar* _tmp144_;
					TrackerSparqlVariable* _tmp145_;
					TrackerSparqlPatternTripleContext* _tmp146_;
					GHashTable* _tmp147_;
					TrackerSparqlVariableBinding* _tmp148_;
					TrackerSparqlVariable* _tmp149_;
					gconstpointer _tmp150_;
					TrackerSparqlVariableBindingList* binding_list = NULL;
					TrackerSparqlVariableBindingList* _tmp151_;
					TrackerSparqlPatternTripleContext* _tmp152_;
					TrackerSparqlVariableBinding* _tmp153_;
					TrackerSparqlVariable* _tmp154_;
					TrackerSparqlVariable* _tmp155_;
					TrackerSparqlPatternTripleContext* _tmp156_;
					GHashTable* _tmp157_;
					TrackerSparqlVariableBinding* _tmp158_;
					TrackerSparqlVariable* _tmp159_;
					TrackerSparqlVariable* _tmp160_;
					TrackerSparqlVariableBindingList* _tmp161_;
					TrackerSparqlVariableBindingList* _tmp162_;
					TrackerSparqlVariableBinding* object_binding = NULL;
					TrackerSparqlPatternTripleContext* _tmp163_;
					GHashTable* _tmp164_;
					TrackerSparqlContext* _tmp165_;
					TrackerSparqlContext* _tmp166_;
					const gchar* _tmp167_;
					TrackerSparqlVariable* _tmp168_;
					gconstpointer _tmp169_;
					GList* _tmp170_;
					gconstpointer _tmp171_;
					TrackerSparqlVariableBinding* _tmp172_;
					GString* _tmp173_;
					const gchar* _tmp174_;
					TrackerProperty* _tmp175_;
					const gchar* _tmp176_;
					const gchar* _tmp177_;
					TrackerSparqlVariableBinding* _tmp178_;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					TrackerSparqlVariableBinding* _tmp181_;
					TrackerSparqlVariable* _tmp182_;
					const gchar* _tmp183_;
					const gchar* _tmp184_;
					TrackerSparqlContext* _tmp185_;
					TrackerSparqlContext* _tmp186_;
					GHashTable* _tmp187_;
					TrackerSparqlVariableBinding* _tmp188_;
					TrackerSparqlVariable* _tmp189_;
					TrackerSparqlVariable* _tmp190_;
					TrackerSparqlVariableBindingList* _tmp191_;
					TrackerSparqlVariableBinding* _tmp192_;
					TrackerSparqlVariableBinding* _tmp193_;
					TrackerSparqlVariableBinding* _tmp194_;
					TrackerSparqlVariable* _tmp195_;
					TrackerSparqlVariableBinding* _tmp196_;
					TrackerSparqlVariableBinding* _tmp197_;
					TrackerSparqlVariable* _tmp198_;
					TrackerSparqlVariableBinding* _tmp199_;
					TrackerSparqlVariableBinding* _tmp200_;
#line 1442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp139_ = tracker_sparql_variable_binding_new ();
#line 1442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp139_;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp140_ = binding;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp140_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_ = binding;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp142_ = tracker_sparql_pattern_get_context (self);
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp143_ = _tmp142_;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp144_ = self->priv->current_subject;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp145_ = tracker_sparql_context_get_variable (_tmp143_, _tmp144_);
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_->variable = _tmp145_;
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp146_ = self->priv->triple_context;
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp147_ = _tmp146_->var_bindings;
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp148_ = binding;
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp149_ = _tmp148_->variable;
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp150_ = g_hash_table_lookup (_tmp147_, _tmp149_);
#line 1446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (((TrackerSparqlVariableBindingList*) _tmp150_) == NULL, "triple_context.var_bindings.lookup (binding.variable) == null");
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_ = tracker_sparql_variable_binding_list_new ();
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_list = _tmp151_;
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_ = self->priv->triple_context;
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp153_ = binding;
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp154_ = _tmp153_->variable;
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp155_ = _g_object_ref0 (_tmp154_);
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_->variables = g_list_append (_tmp152_->variables, _tmp155_);
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp156_ = self->priv->triple_context;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp157_ = _tmp156_->var_bindings;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp158_ = binding;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp159_ = _tmp158_->variable;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp160_ = _g_object_ref0 (_tmp159_);
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp161_ = binding_list;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp162_ = _g_object_ref0 (_tmp161_);
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp157_, _tmp160_, _tmp162_);
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp163_ = self->priv->triple_context;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp164_ = _tmp163_->var_bindings;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp165_ = tracker_sparql_pattern_get_context (self);
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp166_ = _tmp165_;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp167_ = object;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp168_ = tracker_sparql_context_get_variable (_tmp166_, _tmp167_);
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp169_ = g_hash_table_lookup (_tmp164_, _tmp168_);
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp170_ = ((TrackerSparqlVariableBindingList*) _tmp169_)->list;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp171_ = _tmp170_->data;
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp172_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) _tmp171_);
#line 1452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					object_binding = _tmp172_;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp173_ = sql;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp174_ = db_table;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp175_ = prop;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp176_ = tracker_property_get_name (_tmp175_);
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp177_ = _tmp176_;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp178_ = object_binding;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp179_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp178_);
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp180_ = _tmp179_;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp181_ = binding;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp182_ = _tmp181_->variable;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp183_ = tracker_sparql_variable_get_sql_expression (_tmp182_);
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp184_ = _tmp183_;
#line 1454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp173_, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", _tmp174_, _tmp177_, _tmp180_, _tmp184_);
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp185_ = tracker_sparql_pattern_get_context (self);
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp186_ = _tmp185_;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp187_ = _tmp186_->var_set;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp188_ = binding;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp189_ = _tmp188_->variable;
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp190_ = _g_object_ref0 (_tmp189_);
#line 1460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp187_, _tmp190_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp191_ = binding_list;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp192_ = binding;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp193_ = _g_object_ref0 (_tmp192_);
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp191_->list = g_list_append (_tmp191_->list, _tmp193_);
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp194_ = binding;
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp195_ = _tmp194_->variable;
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp196_ = _tmp195_->binding;
#line 1463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (_tmp196_ == NULL, "binding.variable.binding == null");
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp197_ = binding;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp198_ = _tmp197_->variable;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp199_ = binding;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp200_ = _g_object_ref0 (_tmp199_);
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp198_->binding);
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp198_->binding = _tmp200_;
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (object_binding);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding_list);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 14644 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp201_ = self->priv->current_subject;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp202_ = db_table;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp203_ = share_table;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp205_ = tracker_sparql_pattern_get_table (self, _tmp201_, _tmp202_, _tmp203_, &_tmp204_);
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = _tmp204_;
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp205_;
#line 14662 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlDataTable* _tmp206_;
		TrackerSparqlDataTable* _tmp207_;
		TrackerSparqlContext* _tmp208_;
		TrackerSparqlContext* _tmp209_;
		GHashTable* _tmp210_;
		TrackerSparqlContext* _tmp211_;
		TrackerSparqlContext* _tmp212_;
		const gchar* _tmp213_;
		TrackerSparqlVariable* _tmp214_;
		gconstpointer _tmp215_;
		TrackerSparqlPredicateVariable* _tmp216_;
		TrackerSparqlDataTable* _tmp217_;
		TrackerSparqlPredicateVariable* _tmp218_;
		gboolean _tmp233_;
		gboolean _tmp238_;
		const gchar* _tmp243_;
		TrackerSparqlDataTable* _tmp246_;
		const gchar* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		TrackerSparqlPatternTripleContext* _tmp253_;
		TrackerSparqlDataTable* _tmp254_;
		TrackerSparqlDataTable* _tmp255_;
		TrackerSparqlVariableBinding* binding = NULL;
		TrackerSparqlVariableBinding* _tmp256_;
		TrackerSparqlVariableBinding* _tmp257_;
		TrackerSparqlVariableBinding* _tmp258_;
		TrackerSparqlContext* _tmp259_;
		TrackerSparqlContext* _tmp260_;
		const gchar* _tmp261_;
		TrackerSparqlVariable* _tmp262_;
		TrackerSparqlVariableBinding* _tmp263_;
		TrackerSparqlDataTable* _tmp264_;
		TrackerSparqlDataTable* _tmp265_;
		TrackerSparqlVariableBinding* _tmp266_;
		gchar* _tmp267_;
		GString* _tmp268_;
		TrackerSparqlVariableBinding* _tmp269_;
#line 1472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = TRUE;
#line 1473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp206_ = tracker_sparql_data_table_new ();
#line 1473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp206_;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_ = table;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp208_ = tracker_sparql_pattern_get_context (self);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp209_ = _tmp208_;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp210_ = _tmp209_->predicate_variable_map;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = tracker_sparql_pattern_get_context (self);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp212_ = _tmp211_;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp213_ = self->priv->current_predicate;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp214_ = tracker_sparql_context_get_variable (_tmp212_, _tmp213_);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp215_ = g_hash_table_lookup (_tmp210_, _tmp214_);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp216_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp215_);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp207_->predicate_variable);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_->predicate_variable = _tmp216_;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp217_ = table;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp218_ = _tmp217_->predicate_variable;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp218_ == NULL) {
#line 14743 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp219_;
			TrackerDataManager* _tmp220_;
			TrackerSparqlPredicateVariable* _tmp221_;
			TrackerSparqlContext* _tmp222_;
			TrackerSparqlContext* _tmp223_;
			GHashTable* _tmp224_;
			TrackerSparqlContext* _tmp225_;
			TrackerSparqlContext* _tmp226_;
			const gchar* _tmp227_;
			TrackerSparqlVariable* _tmp228_;
			TrackerSparqlVariable* _tmp229_;
			TrackerSparqlDataTable* _tmp230_;
			TrackerSparqlPredicateVariable* _tmp231_;
			TrackerSparqlPredicateVariable* _tmp232_;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = table;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = self->priv->manager;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp221_ = tracker_sparql_predicate_variable_new (_tmp220_);
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp219_->predicate_variable);
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_->predicate_variable = _tmp221_;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp222_ = tracker_sparql_pattern_get_context (self);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = _tmp222_;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = _tmp223_->predicate_variable_map;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp225_ = tracker_sparql_pattern_get_context (self);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp226_ = _tmp225_;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp227_ = self->priv->current_predicate;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp228_ = tracker_sparql_context_get_variable (_tmp226_, _tmp227_);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp229_ = _g_object_ref0 (_tmp228_);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp230_ = table;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp231_ = _tmp230_->predicate_variable;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp232_ = _g_object_ref0 (_tmp231_);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp224_, _tmp229_, _tmp232_);
#line 14792 "tracker-sparql-pattern.c"
		}
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp233_ = self->priv->current_subject_is_var;
#line 1479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp233_) {
#line 14798 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp234_;
			TrackerSparqlPredicateVariable* _tmp235_;
			const gchar* _tmp236_;
			gchar* _tmp237_;
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp234_ = table;
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp235_ = _tmp234_->predicate_variable;
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp236_ = self->priv->current_subject;
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp237_ = g_strdup (_tmp236_);
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp235_->subject);
#line 1481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp235_->subject = _tmp237_;
#line 14815 "tracker-sparql-pattern.c"
		}
#line 1483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp238_ = object_is_var;
#line 1483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp238_) {
#line 14821 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp239_;
			TrackerSparqlPredicateVariable* _tmp240_;
			const gchar* _tmp241_;
			gchar* _tmp242_;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp239_ = table;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp240_ = _tmp239_->predicate_variable;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp241_ = object;
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp242_ = g_strdup (_tmp241_);
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp240_->object);
#line 1485 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp240_->object = _tmp242_;
#line 14838 "tracker-sparql-pattern.c"
		}
#line 1487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp243_ = self->current_graph;
#line 1487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp243_ != NULL) {
#line 14844 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp244_;
			TrackerSparqlPredicateVariable* _tmp245_;
#line 1488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp244_ = table;
#line 1488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp245_ = _tmp244_->predicate_variable;
#line 1488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp245_->return_graph = TRUE;
#line 14853 "tracker-sparql-pattern.c"
		}
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp246_ = table;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp247_ = self->priv->current_predicate;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp248_ = self->priv->counter;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp248_ + 1;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp249_ = self->priv->counter;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp250_ = g_strdup_printf ("%i", _tmp249_);
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp251_ = _tmp250_;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp252_ = g_strconcat (_tmp247_, _tmp251_, NULL);
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp246_->sql_query_tablename);
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp246_->sql_query_tablename = _tmp252_;
#line 1490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp251_);
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_ = self->priv->triple_context;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp254_ = table;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp255_ = _g_object_ref0 (_tmp254_);
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_->tables = g_list_append (_tmp253_->tables, _tmp255_);
#line 1494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp256_ = tracker_sparql_variable_binding_new ();
#line 1494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp256_;
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp257_ = binding;
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp257_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp258_ = binding;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp259_ = tracker_sparql_pattern_get_context (self);
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp260_ = _tmp259_;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp261_ = self->priv->current_predicate;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp262_ = tracker_sparql_context_get_variable (_tmp260_, _tmp261_);
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp258_->variable = _tmp262_;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp263_ = binding;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp264_ = table;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp265_ = _g_object_ref0 (_tmp264_);
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp263_)->table);
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp263_)->table = _tmp265_;
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp266_ = binding;
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp267_ = g_strdup ("predicate");
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (((TrackerSparqlDataBinding*) _tmp266_)->sql_db_column_name);
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp266_)->sql_db_column_name = _tmp267_;
#line 1500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp268_ = sql;
#line 1500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp269_ = binding;
#line 1500 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_add_variable_binding (self, _tmp268_, _tmp269_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 14931 "tracker-sparql-pattern.c"
	}
#line 1503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp270_ = newtable;
#line 1503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp270_) {
#line 14937 "tracker-sparql-pattern.c"
		gboolean _tmp271_;
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp271_ = self->priv->current_subject_is_var;
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp271_) {
#line 14943 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* binding = NULL;
			TrackerSparqlVariableBinding* _tmp272_;
			TrackerSparqlVariableBinding* _tmp273_;
			TrackerSparqlVariableBinding* _tmp274_;
			TrackerSparqlContext* _tmp275_;
			TrackerSparqlContext* _tmp276_;
			const gchar* _tmp277_;
			TrackerSparqlVariable* _tmp278_;
			TrackerSparqlVariableBinding* _tmp279_;
			TrackerSparqlDataTable* _tmp280_;
			TrackerSparqlDataTable* _tmp281_;
			TrackerSparqlVariableBinding* _tmp282_;
			TrackerClass* _tmp283_;
			TrackerClass* _tmp284_;
			gboolean _tmp285_;
			GString* _tmp290_;
			TrackerSparqlVariableBinding* _tmp291_;
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp272_ = tracker_sparql_variable_binding_new ();
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp272_;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp273_ = binding;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp273_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp274_ = binding;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp275_ = tracker_sparql_pattern_get_context (self);
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp276_ = _tmp275_;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp277_ = self->priv->current_subject;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp278_ = tracker_sparql_context_get_variable (_tmp276_, _tmp277_);
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp274_->variable = _tmp278_;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp279_ = binding;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp280_ = table;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp281_ = _g_object_ref0 (_tmp280_);
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp279_)->table);
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp279_)->table = _tmp281_;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp282_ = binding;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp283_ = subject_type;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp284_ = _g_object_ref0 (_tmp283_);
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp282_->type);
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp282_->type = _tmp284_;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp285_ = is_fts_match;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp285_) {
#line 15005 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp286_;
				gchar* _tmp287_;
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp286_ = binding;
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp287_ = g_strdup ("rowid");
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name);
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name = _tmp287_;
#line 15016 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlVariableBinding* _tmp288_;
				gchar* _tmp289_;
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp288_ = binding;
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp289_ = g_strdup ("ID");
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp288_)->sql_db_column_name);
#line 1513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp288_)->sql_db_column_name = _tmp289_;
#line 15028 "tracker-sparql-pattern.c"
			}
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp290_ = sql;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp291_ = binding;
#line 1516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp290_, _tmp291_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15038 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlLiteralBinding* binding = NULL;
			TrackerSparqlLiteralBinding* _tmp292_;
			TrackerSparqlLiteralBinding* _tmp293_;
			TrackerSparqlLiteralBinding* _tmp294_;
			const gchar* _tmp295_;
			gchar* _tmp296_;
			TrackerSparqlLiteralBinding* _tmp297_;
			TrackerSparqlDataTable* _tmp298_;
			TrackerSparqlDataTable* _tmp299_;
			TrackerSparqlLiteralBinding* _tmp300_;
			gchar* _tmp301_;
			TrackerSparqlPatternTripleContext* _tmp302_;
			TrackerSparqlLiteralBinding* _tmp303_;
			TrackerSparqlLiteralBinding* _tmp304_;
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp292_ = tracker_sparql_literal_binding_new ();
#line 1518 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp292_;
#line 1519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp293_ = binding;
#line 1519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp293_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp294_ = binding;
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp295_ = self->priv->current_subject;
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp296_ = g_strdup (_tmp295_);
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp294_->literal);
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp294_->literal = _tmp296_;
#line 1522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp297_ = binding;
#line 1522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp298_ = table;
#line 1522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp299_ = _g_object_ref0 (_tmp298_);
#line 1522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp297_)->table);
#line 1522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp297_)->table = _tmp299_;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp300_ = binding;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp301_ = g_strdup ("ID");
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (((TrackerSparqlDataBinding*) _tmp300_)->sql_db_column_name);
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp300_)->sql_db_column_name = _tmp301_;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp302_ = self->priv->triple_context;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp303_ = binding;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp304_ = _g_object_ref0 (_tmp303_);
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp302_->bindings = g_list_append (_tmp302_->bindings, _tmp304_);
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15100 "tracker-sparql-pattern.c"
		}
	}
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp305_ = rdftype;
#line 1528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp305_) {
#line 15107 "tracker-sparql-pattern.c"
		gboolean _tmp306_;
		const gchar* _tmp395_;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp306_ = object_is_var;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp306_) {
#line 15114 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* binding = NULL;
			TrackerSparqlVariableBinding* _tmp307_;
			TrackerSparqlVariableBinding* _tmp308_;
			TrackerSparqlContext* _tmp309_;
			TrackerSparqlContext* _tmp310_;
			const gchar* _tmp311_;
			TrackerSparqlVariable* _tmp312_;
			TrackerSparqlVariableBinding* _tmp313_;
			TrackerSparqlDataTable* _tmp314_;
			TrackerSparqlDataTable* _tmp315_;
			TrackerProperty* _tmp316_;
			TrackerSparqlVariableState state = 0;
			gboolean _tmp341_;
			GString* _tmp342_;
			TrackerSparqlVariableBinding* _tmp343_;
			TrackerSparqlVariableState _tmp344_;
#line 1530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp307_ = tracker_sparql_variable_binding_new ();
#line 1530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp307_;
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp308_ = binding;
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp309_ = tracker_sparql_pattern_get_context (self);
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp310_ = _tmp309_;
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp311_ = object;
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp312_ = tracker_sparql_context_get_variable (_tmp310_, _tmp311_);
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp308_->variable = _tmp312_;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp313_ = binding;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp314_ = table;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp315_ = _g_object_ref0 (_tmp314_);
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp313_)->table);
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp313_)->table = _tmp315_;
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp316_ = prop;
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp316_ != NULL) {
#line 15161 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp317_;
				TrackerProperty* _tmp318_;
				TrackerClass* _tmp319_;
				TrackerClass* _tmp320_;
				TrackerClass* _tmp321_;
				TrackerSparqlVariableBinding* _tmp322_;
				TrackerProperty* _tmp323_;
				TrackerPropertyType _tmp324_;
				TrackerPropertyType _tmp325_;
				TrackerSparqlVariableBinding* _tmp326_;
				TrackerProperty* _tmp327_;
				const gchar* _tmp328_;
				const gchar* _tmp329_;
				gchar* _tmp330_;
				TrackerProperty* _tmp331_;
				gboolean _tmp332_;
				gboolean _tmp333_;
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp317_ = binding;
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp318_ = prop;
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp319_ = tracker_property_get_range (_tmp318_);
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp320_ = _tmp319_;
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp321_ = _g_object_ref0 (_tmp320_);
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp317_->type);
#line 1535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp317_->type = _tmp321_;
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp322_ = binding;
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp323_ = prop;
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp324_ = tracker_property_get_data_type (_tmp323_);
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp325_ = _tmp324_;
#line 1537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp322_)->data_type = _tmp325_;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp326_ = binding;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp327_ = prop;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp328_ = tracker_property_get_name (_tmp327_);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp329_ = _tmp328_;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp330_ = g_strdup (_tmp329_);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp326_)->sql_db_column_name);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp326_)->sql_db_column_name = _tmp330_;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp331_ = prop;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp332_ = tracker_property_get_multiple_values (_tmp331_);
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp333_ = _tmp332_;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp333_) {
#line 15225 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp334_;
					TrackerSparqlVariableBinding* _tmp335_;
					gboolean _tmp336_;
#line 1542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp334_ = binding;
#line 1542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp334_->maybe_null = TRUE;
#line 1543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp335_ = binding;
#line 1543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp336_ = in_simple_optional;
#line 1543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp335_->in_simple_optional = _tmp336_;
#line 15239 "tracker-sparql-pattern.c"
				}
			} else {
				TrackerSparqlVariableBinding* _tmp337_;
				TrackerSparqlVariableBinding* _tmp338_;
				gchar* _tmp339_;
				TrackerSparqlVariableBinding* _tmp340_;
#line 1547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp337_ = binding;
#line 1547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp337_)->data_type = TRACKER_PROPERTY_TYPE_STRING;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp338_ = binding;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp339_ = g_strdup ("object");
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp338_)->sql_db_column_name);
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp338_)->sql_db_column_name = _tmp339_;
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp340_ = binding;
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp340_->maybe_null = TRUE;
#line 15262 "tracker-sparql-pattern.c"
			}
#line 1553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp341_ = in_simple_optional;
#line 1553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp341_) {
#line 1554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 15270 "tracker-sparql-pattern.c"
			} else {
#line 1556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 15274 "tracker-sparql-pattern.c"
			}
#line 1559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp342_ = sql;
#line 1559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp343_ = binding;
#line 1559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp344_ = state;
#line 1559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp342_, _tmp343_, _tmp344_);
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15286 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp345_;
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp345_ = is_fts_match;
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp345_) {
#line 15293 "tracker-sparql-pattern.c"
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp346_;
				TrackerSparqlLiteralBinding* _tmp347_;
				TrackerSparqlLiteralBinding* _tmp348_;
				const gchar* _tmp349_;
				gchar* _tmp350_;
				TrackerSparqlLiteralBinding* _tmp351_;
				TrackerSparqlDataTable* _tmp352_;
				TrackerSparqlDataTable* _tmp353_;
				TrackerSparqlLiteralBinding* _tmp354_;
				gchar* _tmp355_;
				TrackerSparqlPatternTripleContext* _tmp356_;
				TrackerSparqlLiteralBinding* _tmp357_;
				TrackerSparqlLiteralBinding* _tmp358_;
				GString* _tmp359_;
				TrackerSparqlLiteralBinding* _tmp360_;
				TrackerSparqlDataTable* _tmp361_;
				const gchar* _tmp362_;
				GString* _tmp363_;
				TrackerSparqlLiteralBinding* _tmp364_;
				TrackerSparqlDataTable* _tmp365_;
				const gchar* _tmp366_;
				TrackerSparqlContext* _tmp367_;
				TrackerSparqlContext* _tmp368_;
				const gchar* _tmp369_;
				TrackerSparqlVariable* _tmp370_;
				const gchar* _tmp371_;
				const gchar* _tmp372_;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp346_ = tracker_sparql_literal_binding_new ();
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp346_;
#line 1562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp347_ = binding;
#line 1562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp347_->is_fts_match = TRUE;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp348_ = binding;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp349_ = object;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp350_ = g_strdup (_tmp349_);
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp348_->literal);
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp348_->literal = _tmp350_;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp351_ = binding;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp352_ = table;
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp353_ = _g_object_ref0 (_tmp352_);
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp351_)->table);
#line 1565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp351_)->table = _tmp353_;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp354_ = binding;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp355_ = g_strdup ("fts5");
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp354_)->sql_db_column_name);
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp354_)->sql_db_column_name = _tmp355_;
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp356_ = self->priv->triple_context;
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp357_ = binding;
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp358_ = _g_object_ref0 (_tmp357_);
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp356_->bindings = g_list_append (_tmp356_->bindings, _tmp358_);
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp359_ = sql;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp360_ = binding;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp361_ = ((TrackerSparqlDataBinding*) _tmp360_)->table;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp362_ = _tmp361_->sql_query_tablename;
#line 1569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp359_, "\"%s\".\"rowid\" AS \"ID\", ", _tmp362_);
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp363_ = sql;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp364_ = binding;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp365_ = ((TrackerSparqlDataBinding*) _tmp364_)->table;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp366_ = _tmp365_->sql_query_tablename;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp367_ = tracker_sparql_pattern_get_context (self);
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp368_ = _tmp367_;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp369_ = self->priv->current_subject;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp370_ = tracker_sparql_context_get_variable (_tmp368_, _tmp369_);
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp371_ = tracker_sparql_variable_get_name (_tmp370_);
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp372_ = _tmp371_;
#line 1571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp363_, "\"%s\".\"rank\" AS \"%s_u_rank\", ", _tmp366_, _tmp372_);
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15400 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp373_;
				TrackerSparqlLiteralBinding* _tmp374_;
				const gchar* _tmp375_;
				gchar* _tmp376_;
				TrackerSparqlLiteralBinding* _tmp377_;
				TrackerSparqlDataTable* _tmp378_;
				TrackerSparqlDataTable* _tmp379_;
				TrackerProperty* _tmp380_;
				TrackerSparqlPatternTripleContext* _tmp392_;
				TrackerSparqlLiteralBinding* _tmp393_;
				TrackerSparqlLiteralBinding* _tmp394_;
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp373_ = tracker_sparql_literal_binding_new ();
#line 1575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp373_;
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp374_ = binding;
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp375_ = object;
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp376_ = g_strdup (_tmp375_);
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp374_->literal);
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp374_->literal = _tmp376_;
#line 1578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp377_ = binding;
#line 1578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp378_ = table;
#line 1578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp379_ = _g_object_ref0 (_tmp378_);
#line 1578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp377_)->table);
#line 1578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp377_)->table = _tmp379_;
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp380_ = prop;
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp380_ != NULL) {
#line 15442 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp381_;
					TrackerProperty* _tmp382_;
					TrackerPropertyType _tmp383_;
					TrackerPropertyType _tmp384_;
					TrackerSparqlLiteralBinding* _tmp385_;
					TrackerProperty* _tmp386_;
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					gchar* _tmp389_;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp381_ = binding;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp382_ = prop;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp383_ = tracker_property_get_data_type (_tmp382_);
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp384_ = _tmp383_;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp381_)->data_type = _tmp384_;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp385_ = binding;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp386_ = prop;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp387_ = tracker_property_get_name (_tmp386_);
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp388_ = _tmp387_;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp389_ = g_strdup (_tmp388_);
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp385_)->sql_db_column_name);
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp385_)->sql_db_column_name = _tmp389_;
#line 15476 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp390_;
					gchar* _tmp391_;
#line 1584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp390_ = binding;
#line 1584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp391_ = g_strdup ("object");
#line 1584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp390_)->sql_db_column_name);
#line 1584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp390_)->sql_db_column_name = _tmp391_;
#line 15488 "tracker-sparql-pattern.c"
				}
#line 1586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp392_ = self->priv->triple_context;
#line 1586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp393_ = binding;
#line 1586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp394_ = _g_object_ref0 (_tmp393_);
#line 1586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp392_->bindings = g_list_append (_tmp392_->bindings, _tmp394_);
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15500 "tracker-sparql-pattern.c"
			}
		}
#line 1589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp395_ = self->current_graph;
#line 1589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp395_ != NULL) {
#line 15507 "tracker-sparql-pattern.c"
			gboolean _tmp396_;
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp396_ = self->priv->current_graph_is_var;
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp396_) {
#line 15513 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* binding = NULL;
				TrackerSparqlVariableBinding* _tmp397_;
				TrackerSparqlVariableBinding* _tmp398_;
				TrackerSparqlContext* _tmp399_;
				TrackerSparqlContext* _tmp400_;
				const gchar* _tmp401_;
				TrackerSparqlVariable* _tmp402_;
				TrackerSparqlVariableBinding* _tmp403_;
				TrackerSparqlDataTable* _tmp404_;
				TrackerSparqlDataTable* _tmp405_;
				TrackerSparqlVariableBinding* _tmp406_;
				TrackerProperty* _tmp407_;
				TrackerSparqlVariableBinding* _tmp415_;
				TrackerSparqlVariableBinding* _tmp416_;
				gboolean _tmp417_;
				TrackerSparqlVariableState state = 0;
				gboolean _tmp418_;
				GString* _tmp419_;
				TrackerSparqlVariableBinding* _tmp420_;
				TrackerSparqlVariableState _tmp421_;
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp397_ = tracker_sparql_variable_binding_new ();
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp397_;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp398_ = binding;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp399_ = tracker_sparql_pattern_get_context (self);
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp400_ = _tmp399_;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp401_ = self->current_graph;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp402_ = tracker_sparql_context_get_variable (_tmp400_, _tmp401_);
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp398_->variable = _tmp402_;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp403_ = binding;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp404_ = table;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp405_ = _g_object_ref0 (_tmp404_);
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp403_)->table);
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp403_)->table = _tmp405_;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp406_ = binding;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp406_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp407_ = prop;
#line 1596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp407_ != NULL) {
#line 15568 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp408_;
					TrackerProperty* _tmp409_;
					const gchar* _tmp410_;
					const gchar* _tmp411_;
					gchar* _tmp412_;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp408_ = binding;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp409_ = prop;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp410_ = tracker_property_get_name (_tmp409_);
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp411_ = _tmp410_;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp412_ = g_strconcat (_tmp411_, ":graph", NULL);
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp408_)->sql_db_column_name);
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp408_)->sql_db_column_name = _tmp412_;
#line 15588 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlVariableBinding* _tmp413_;
					gchar* _tmp414_;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp413_ = binding;
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp414_ = g_strdup ("graph");
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp413_)->sql_db_column_name);
#line 1600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp413_)->sql_db_column_name = _tmp414_;
#line 15600 "tracker-sparql-pattern.c"
				}
#line 1603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp415_ = binding;
#line 1603 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp415_->maybe_null = TRUE;
#line 1604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp416_ = binding;
#line 1604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp417_ = in_simple_optional;
#line 1604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp416_->in_simple_optional = _tmp417_;
#line 1607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp418_ = in_simple_optional;
#line 1607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp418_) {
#line 1608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 15618 "tracker-sparql-pattern.c"
				} else {
#line 1610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 15622 "tracker-sparql-pattern.c"
				}
#line 1613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp419_ = sql;
#line 1613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp420_ = binding;
#line 1613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp421_ = state;
#line 1613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_add_variable_binding (self, _tmp419_, _tmp420_, _tmp421_);
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15634 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp422_;
				TrackerSparqlLiteralBinding* _tmp423_;
				const gchar* _tmp424_;
				gchar* _tmp425_;
				TrackerSparqlLiteralBinding* _tmp426_;
				TrackerSparqlDataTable* _tmp427_;
				TrackerSparqlDataTable* _tmp428_;
				TrackerSparqlLiteralBinding* _tmp429_;
				TrackerProperty* _tmp430_;
				TrackerSparqlPatternTripleContext* _tmp438_;
				TrackerSparqlLiteralBinding* _tmp439_;
				TrackerSparqlLiteralBinding* _tmp440_;
#line 1615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp422_ = tracker_sparql_literal_binding_new ();
#line 1615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp422_;
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp423_ = binding;
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp424_ = self->current_graph;
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp425_ = g_strdup (_tmp424_);
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp423_->literal);
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp423_->literal = _tmp425_;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp426_ = binding;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp427_ = table;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp428_ = _g_object_ref0 (_tmp427_);
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp426_)->table);
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp426_)->table = _tmp428_;
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp429_ = binding;
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp429_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp430_ = prop;
#line 1620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp430_ != NULL) {
#line 15681 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp431_;
					TrackerProperty* _tmp432_;
					const gchar* _tmp433_;
					const gchar* _tmp434_;
					gchar* _tmp435_;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp431_ = binding;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp432_ = prop;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp433_ = tracker_property_get_name (_tmp432_);
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp434_ = _tmp433_;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp435_ = g_strconcat (_tmp434_, ":graph", NULL);
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp431_)->sql_db_column_name);
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp431_)->sql_db_column_name = _tmp435_;
#line 15701 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp436_;
					gchar* _tmp437_;
#line 1624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp436_ = binding;
#line 1624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp437_ = g_strdup ("graph");
#line 1624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp436_)->sql_db_column_name);
#line 1624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp436_)->sql_db_column_name = _tmp437_;
#line 15713 "tracker-sparql-pattern.c"
				}
#line 1627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp438_ = self->priv->triple_context;
#line 1627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp439_ = binding;
#line 1627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp440_ = _g_object_ref0 (_tmp439_);
#line 1627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp438_->bindings = g_list_append (_tmp438_->bindings, _tmp440_);
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15725 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp441_ = sql;
#line 1632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp442_ = _tmp441_->len;
#line 1632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp443_ = begin_sql_len;
#line 1632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp442_ == ((gssize) _tmp443_)) {
#line 15737 "tracker-sparql-pattern.c"
		GString* _tmp444_;
#line 1635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp444_ = sql;
#line 1635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp444_, "1, ");
#line 15743 "tracker-sparql-pattern.c"
	}
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (ontologies);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (subject_type);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (prop);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (table);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (db_table);
#line 1347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (object);
#line 15757 "tracker-sparql-pattern.c"
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable) {
	gboolean _vala_newtable = FALSE;
	TrackerSparqlDataTable* result = NULL;
	gchar* tablestring = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	TrackerSparqlDataTable* table = NULL;
	gboolean _tmp3_;
	TrackerSparqlDataTable* _tmp9_;
#line 1639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 1639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (db_table != NULL, NULL);
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = subject;
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = db_table;
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_strdup_printf ("%s.%s", _tmp0_, _tmp1_);
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tablestring = _tmp2_;
#line 1641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	table = NULL;
#line 1642 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_newtable = FALSE;
#line 1643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = share_table;
#line 1643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_) {
#line 15793 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp4_;
		GHashTable* _tmp5_;
		const gchar* _tmp6_;
		gconstpointer _tmp7_;
		TrackerSparqlDataTable* _tmp8_;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = self->priv->triple_context;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_->table_map;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tablestring;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _g_object_ref0 ((TrackerSparqlDataTable*) _tmp7_);
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp8_;
#line 15813 "tracker-sparql-pattern.c"
	}
#line 1646 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = table;
#line 1646 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp9_ == NULL) {
#line 15819 "tracker-sparql-pattern.c"
		TrackerSparqlDataTable* _tmp10_;
		TrackerSparqlDataTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		TrackerSparqlDataTable* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		TrackerSparqlPatternTripleContext* _tmp21_;
		TrackerSparqlDataTable* _tmp22_;
		TrackerSparqlDataTable* _tmp23_;
		TrackerSparqlPatternTripleContext* _tmp24_;
		GHashTable* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		TrackerSparqlDataTable* _tmp28_;
		TrackerSparqlDataTable* _tmp29_;
#line 1647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_newtable = TRUE;
#line 1648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_data_table_new ();
#line 1648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp10_;
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = table;
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = db_table;
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_->sql_db_tablename);
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->sql_db_tablename = _tmp13_;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = table;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = db_table;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = self->priv->counter;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp16_ + 1;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = self->priv->counter;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp18_;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp14_->sql_query_tablename);
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_->sql_query_tablename = _tmp20_;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp19_);
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = self->priv->triple_context;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = table;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_->tables = g_list_append (_tmp21_->tables, _tmp23_);
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = self->priv->triple_context;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = _tmp24_->table_map;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = tablestring;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = table;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
#line 15902 "tracker-sparql-pattern.c"
	}
#line 1654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = table;
#line 1654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (tablestring);
#line 1654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (newtable) {
#line 1654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*newtable = _vala_newtable;
#line 15912 "tracker-sparql-pattern.c"
	}
#line 1654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 15916 "tracker-sparql-pattern.c"
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->context;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 15934 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = value;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_tmp0_->context);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_->context = _tmp2_;
#line 15954 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GDestroyNotify _tmp4_;
	GDestroyNotify _tmp5_;
	GHashTable* _tmp6_;
	GDestroyNotify _tmp7_;
	GDestroyNotify _tmp8_;
	GHashTable* _tmp9_;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = parent_context;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, _tmp0_, _tmp1_);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->tables = NULL;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_str_hash;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_str_equal;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_free;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = g_object_unref;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = g_hash_table_new_full (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->table_map = _tmp6_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->variables = NULL;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = g_object_unref;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp8_ = g_object_unref;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp7_, _tmp8_);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->var_bindings = _tmp9_;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->bindings = NULL;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 16018 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, query, parent_context);
#line 16025 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
#line 16034 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext * obj) {
	TrackerSparqlPatternTripleContext * self;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext);
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
#line 16058 "tracker-sparql-pattern.c"
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_pattern_get_property;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_pattern_set_property;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
#line 16085 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->queries_fts_data = FALSE;
#line 16094 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_finalize (GObject * obj) {
	TrackerSparqlPattern * self;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->current_graph);
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_subject);
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_predicate);
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_variables = (_vala_array_free (self->fts_variables, self->fts_variables_length1, (GDestroyNotify) g_free), NULL);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
#line 16120 "tracker-sparql-pattern.c"
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 16141 "tracker-sparql-pattern.c"
		default:
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 16147 "tracker-sparql-pattern.c"
	}
}


static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 16157 "tracker-sparql-pattern.c"
		default:
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 16163 "tracker-sparql-pattern.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



