/* tracker-main.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-main.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "tracker-store/tracker-config.h"
#include <signal.h>
#include <glib-unix.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <locale.h>
#include "libtracker-data/tracker-db-config.h"
#include "libtracker-common/tracker-domain-ontology.h"
#include "libtracker-data/tracker-db-manager.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"
#include <gobject/gvaluecollector.h>

#define TRACKER_TYPE_MAIN (tracker_main_get_type ())
#define TRACKER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MAIN, TrackerMain))
#define TRACKER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MAIN, TrackerMainClass))
#define TRACKER_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MAIN))
#define TRACKER_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MAIN))
#define TRACKER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MAIN, TrackerMainClass))

typedef struct _TrackerMain TrackerMain;
typedef struct _TrackerMainClass TrackerMainClass;
typedef struct _TrackerMainPrivate TrackerMainPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TrackerParamSpecMain TrackerParamSpecMain;

struct _TrackerMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerMainPrivate * priv;
};

struct _TrackerMainClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerMain *self);
};

struct _TrackerParamSpecMain {
	GParamSpec parent_instance;
};

static gpointer tracker_main_parent_class = NULL;
static GMainLoop* tracker_main_main_loop;
static GMainLoop* tracker_main_main_loop = NULL;
static gchar* tracker_main_log_filename;
static gchar* tracker_main_log_filename = NULL;
static gboolean tracker_main_shutdown;
static gboolean tracker_main_shutdown = FALSE;
static TrackerDirectConnection* tracker_main_connection;
static TrackerDirectConnection* tracker_main_connection = NULL;
static TrackerDataManager* tracker_main_data_manager;
static TrackerDataManager* tracker_main_data_manager = NULL;
static gboolean tracker_main_version;
static gboolean tracker_main_version = FALSE;
static gint tracker_main_verbosity;
static gint tracker_main_verbosity = 0;
static gboolean tracker_main_force_reindex;
static gboolean tracker_main_force_reindex = FALSE;
static gboolean tracker_main_readonly_mode;
static gboolean tracker_main_readonly_mode = FALSE;
static gchar* tracker_main_domain_ontology;
static gchar* tracker_main_domain_ontology = NULL;
static GFile* tracker_main_cache_location;
static GFile* tracker_main_cache_location = NULL;
static GFile* tracker_main_data_location;
static GFile* tracker_main_data_location = NULL;
static GFile* tracker_main_ontology_location;
static GFile* tracker_main_ontology_location = NULL;
static gchar* tracker_main_domain;
static gchar* tracker_main_domain = NULL;
static gboolean tracker_main_in_loop;
static gboolean tracker_main_in_loop = FALSE;

gpointer tracker_main_ref (gpointer instance);
void tracker_main_unref (gpointer instance);
GParamSpec* tracker_param_spec_main (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void tracker_value_set_main (GValue* value,
                             gpointer v_object);
void tracker_value_take_main (GValue* value,
                              gpointer v_object);
gpointer tracker_value_get_main (const GValue* value);
GType tracker_main_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerMain, tracker_main_unref)
#define TRACKER_MAIN_LICENSE "This program is free software and comes without any warranty.\n" \
"It is licensed under version 2 or later of the General Public\n" \
"License which can be viewed at:\n" \
"  http://www.gnu.org/licenses/gpl.txt\n"
#define TRACKER_MAIN_SELECT_CACHE_SIZE 100
#define TRACKER_MAIN_UPDATE_CACHE_SIZE 100
static void tracker_main_sanity_check_option_values (TrackerConfig* config);
static void tracker_main_do_shutdown (void);
static gboolean tracker_main_shutdown_timeout_cb (void);
static gboolean tracker_main_signal_handler (gint signo);
static void tracker_main_initialize_signal_handler (void);
static gboolean __lambda4_ (void);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (void);
static gboolean ___lambda5__gsource_func (gpointer self);
static void tracker_main_initialize_priority (void);
static gchar** tracker_main_get_writeback_predicates (void);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void tracker_main_config_verbosity_changed_cb (GObject* object,
                                               GParamSpec* spec);
TrackerDataManager* tracker_main_get_data_manager (void);
TrackerDirectConnection* tracker_main_get_sparql_connection (void);
static gint tracker_main_main (gchar** args,
                        gint args_length1);
void tzset (void);
gboolean tracker_dbus_init (void);
static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
GType tracker_status_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStatus, g_object_unref)
guint tracker_status_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
TrackerStatus* tracker_dbus_register_notifier (void);
void tracker_store_init (TrackerConfig* config_p);
gboolean tracker_dbus_register_objects (void);
gboolean tracker_dbus_register_names (const gchar* domain);
gboolean tracker_dbus_register_prepare_class_signal (void);
static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (gint* result_length1);
void tracker_store_resume (void);
void tracker_dbus_watch_domain (const gchar* domain,
                                GMainLoop* main_loop);
void tracker_store_shutdown (void);
static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self);
void tracker_dbus_shutdown (void);
TrackerMain* tracker_main_new (void);
TrackerMain* tracker_main_construct (GType object_type);
static void tracker_main_finalize (TrackerMain * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TRACKER_MAIN_entries[6] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &tracker_main_version, N_ ("Displays version information"), NULL}, {"verbosity", 'v', 0, G_OPTION_ARG_INT, &tracker_main_verbosity, N_ ("Logging, 0 = errors only, 1 = minimal, 2 = detailed and 3 = debug (def" \
"ault = 0)"), NULL}, {"force-reindex", 'r', 0, G_OPTION_ARG_NONE, &tracker_main_force_reindex, N_ ("Force a re-index of all content"), NULL}, {"readonly-mode", 'n', 0, G_OPTION_ARG_NONE, &tracker_main_readonly_mode, N_ ("Only allow read based actions on the database"), NULL}, {"domain-ontology", 'd', 0, G_OPTION_ARG_STRING, &tracker_main_domain_ontology, N_ ("Load a specified domain ontology"), NULL}, {NULL}};

static void
tracker_main_sanity_check_option_values (TrackerConfig* config)
{
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp7_;
	GFile* _tmp9_;
	GFile* _tmp13_;
	GFile* _tmp17_;
#line 68 "tracker-main.vala"
	g_return_if_fail (config != NULL);
#line 69 "tracker-main.vala"
	g_message ("General options:");
#line 70 "tracker-main.vala"
	_tmp0_ = tracker_config_get_verbosity (config);
#line 70 "tracker-main.vala"
	_tmp1_ = _tmp0_;
#line 70 "tracker-main.vala"
	g_message ("  Verbosity  ............................  %d", _tmp1_);
#line 72 "tracker-main.vala"
	g_message ("Store options:");
#line 73 "tracker-main.vala"
	if (tracker_main_readonly_mode) {
#line 73 "tracker-main.vala"
		_tmp2_ = "yes";
#line 225 "tracker-main.c"
	} else {
#line 73 "tracker-main.vala"
		_tmp2_ = "no";
#line 229 "tracker-main.c"
	}
#line 73 "tracker-main.vala"
	g_message ("  Readonly mode  ........................  %s", _tmp2_);
#line 74 "tracker-main.vala"
	_tmp3_ = tracker_config_get_graphupdated_delay (config);
#line 74 "tracker-main.vala"
	_tmp4_ = _tmp3_;
#line 74 "tracker-main.vala"
	g_message ("  GraphUpdated Delay ....................  %d", _tmp4_);
#line 76 "tracker-main.vala"
	_tmp5_ = tracker_main_domain_ontology;
#line 76 "tracker-main.vala"
	if (_tmp5_ != NULL) {
#line 243 "tracker-main.c"
		const gchar* _tmp6_;
#line 77 "tracker-main.vala"
		_tmp6_ = tracker_main_domain_ontology;
#line 77 "tracker-main.vala"
		g_message ("  Domain ontology........................  %s", _tmp6_);
#line 249 "tracker-main.c"
	}
#line 79 "tracker-main.vala"
	_tmp7_ = tracker_main_domain;
#line 79 "tracker-main.vala"
	if (_tmp7_ != NULL) {
#line 255 "tracker-main.c"
		const gchar* _tmp8_;
#line 80 "tracker-main.vala"
		_tmp8_ = tracker_main_domain;
#line 80 "tracker-main.vala"
		g_message ("  Domain.................................  %s", _tmp8_);
#line 261 "tracker-main.c"
	}
#line 82 "tracker-main.vala"
	_tmp9_ = tracker_main_cache_location;
#line 82 "tracker-main.vala"
	if (_tmp9_ != NULL) {
#line 267 "tracker-main.c"
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 83 "tracker-main.vala"
		_tmp10_ = tracker_main_cache_location;
#line 83 "tracker-main.vala"
		_tmp11_ = g_file_get_uri (_tmp10_);
#line 83 "tracker-main.vala"
		_tmp12_ = _tmp11_;
#line 83 "tracker-main.vala"
		g_message ("  Cache location.........................  %s", _tmp12_);
#line 83 "tracker-main.vala"
		_g_free0 (_tmp12_);
#line 281 "tracker-main.c"
	}
#line 84 "tracker-main.vala"
	_tmp13_ = tracker_main_data_location;
#line 84 "tracker-main.vala"
	if (_tmp13_ != NULL) {
#line 287 "tracker-main.c"
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 85 "tracker-main.vala"
		_tmp14_ = tracker_main_data_location;
#line 85 "tracker-main.vala"
		_tmp15_ = g_file_get_uri (_tmp14_);
#line 85 "tracker-main.vala"
		_tmp16_ = _tmp15_;
#line 85 "tracker-main.vala"
		g_message ("  Data location..........................  %s", _tmp16_);
#line 85 "tracker-main.vala"
		_g_free0 (_tmp16_);
#line 301 "tracker-main.c"
	}
#line 86 "tracker-main.vala"
	_tmp17_ = tracker_main_ontology_location;
#line 86 "tracker-main.vala"
	if (_tmp17_ != NULL) {
#line 307 "tracker-main.c"
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 87 "tracker-main.vala"
		_tmp18_ = tracker_main_ontology_location;
#line 87 "tracker-main.vala"
		_tmp19_ = g_file_get_uri (_tmp18_);
#line 87 "tracker-main.vala"
		_tmp20_ = _tmp19_;
#line 87 "tracker-main.vala"
		g_message ("  Ontology location......................  %s", _tmp20_);
#line 87 "tracker-main.vala"
		_g_free0 (_tmp20_);
#line 321 "tracker-main.c"
	}
}

static void
tracker_main_do_shutdown (void)
{
	GMainLoop* _tmp0_;
#line 91 "tracker-main.vala"
	_tmp0_ = tracker_main_main_loop;
#line 91 "tracker-main.vala"
	if (_tmp0_ != NULL) {
#line 333 "tracker-main.c"
		GMainLoop* _tmp1_;
#line 92 "tracker-main.vala"
		_tmp1_ = tracker_main_main_loop;
#line 92 "tracker-main.vala"
		g_main_loop_quit (_tmp1_);
#line 339 "tracker-main.c"
	}
#line 95 "tracker-main.vala"
	tracker_main_shutdown = TRUE;
#line 343 "tracker-main.c"
}

static gboolean
tracker_main_shutdown_timeout_cb (void)
{
	gboolean result = FALSE;
#line 99 "tracker-main.vala"
	g_critical ("Could not exit in a timely fashion - terminating...");
#line 100 "tracker-main.vala"
	exit (1);
#line 98 "tracker-main.vala"
	return result;
#line 356 "tracker-main.c"
}

static gboolean
tracker_main_signal_handler (gint signo)
{
	gboolean result = FALSE;
#line 107 "tracker-main.vala"
	if (tracker_main_in_loop) {
#line 108 "tracker-main.vala"
		exit (1);
#line 367 "tracker-main.c"
	}
#line 111 "tracker-main.vala"
	switch (signo) {
#line 111 "tracker-main.vala"
		case SIGTERM:
#line 111 "tracker-main.vala"
		case SIGINT:
#line 375 "tracker-main.c"
		{
			const gchar* _tmp0_;
#line 114 "tracker-main.vala"
			tracker_main_in_loop = TRUE;
#line 115 "tracker-main.vala"
			tracker_main_do_shutdown ();
#line 117 "tracker-main.vala"
			_tmp0_ = g_strsignal (signo);
#line 117 "tracker-main.vala"
			if (_tmp0_ != NULL) {
#line 386 "tracker-main.c"
				const gchar* _tmp1_;
#line 118 "tracker-main.vala"
				g_print ("\n");
#line 119 "tracker-main.vala"
				_tmp1_ = g_strsignal (signo);
#line 119 "tracker-main.vala"
				g_print ("Received signal:%d->'%s'", signo, _tmp1_);
#line 394 "tracker-main.c"
			}
#line 121 "tracker-main.vala"
			break;
#line 398 "tracker-main.c"
		}
		default:
		{
			const gchar* _tmp2_;
#line 123 "tracker-main.vala"
			_tmp2_ = g_strsignal (signo);
#line 123 "tracker-main.vala"
			if (_tmp2_ != NULL) {
#line 407 "tracker-main.c"
				const gchar* _tmp3_;
#line 124 "tracker-main.vala"
				g_print ("\n");
#line 125 "tracker-main.vala"
				_tmp3_ = g_strsignal (signo);
#line 125 "tracker-main.vala"
				g_print ("Received signal:%d->'%s'", signo, _tmp3_);
#line 415 "tracker-main.c"
			}
#line 127 "tracker-main.vala"
			break;
#line 419 "tracker-main.c"
		}
	}
#line 130 "tracker-main.vala"
	result = TRUE;
#line 130 "tracker-main.vala"
	return result;
#line 426 "tracker-main.c"
}

static gboolean
__lambda4_ (void)
{
	gboolean result = FALSE;
#line 134 "tracker-main.vala"
	result = tracker_main_signal_handler (SIGTERM);
#line 134 "tracker-main.vala"
	return result;
#line 437 "tracker-main.c"
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ();
#line 134 "tracker-main.vala"
	return result;
#line 447 "tracker-main.c"
}

static gboolean
__lambda5_ (void)
{
	gboolean result = FALSE;
#line 135 "tracker-main.vala"
	result = tracker_main_signal_handler (SIGINT);
#line 135 "tracker-main.vala"
	return result;
#line 458 "tracker-main.c"
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ();
#line 135 "tracker-main.vala"
	return result;
#line 468 "tracker-main.c"
}

static void
tracker_main_initialize_signal_handler (void)
{
#line 134 "tracker-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGTERM, ___lambda4__gsource_func, NULL, NULL);
#line 135 "tracker-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGINT, ___lambda5__gsource_func, NULL, NULL);
#line 478 "tracker-main.c"
}

static void
tracker_main_initialize_priority (void)
{
#line 140 "tracker-main.vala"
	tracker_ioprio_init ();
#line 486 "tracker-main.c"
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 156 "tracker-main.vala"
	if ((*length) == (*size)) {
#line 156 "tracker-main.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 156 "tracker-main.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 501 "tracker-main.c"
	}
#line 156 "tracker-main.vala"
	(*array)[(*length)++] = value;
#line 156 "tracker-main.vala"
	(*array)[*length] = NULL;
#line 507 "tracker-main.c"
}

static gchar**
tracker_main_get_writeback_predicates (void)
{
	gchar** result = NULL;
	gchar** predicates_to_signal = NULL;
	gint predicates_to_signal_length1;
	gint _predicates_to_signal_size_;
	GError* _inner_error0_ = NULL;
#line 150 "tracker-main.vala"
	predicates_to_signal = NULL;
#line 150 "tracker-main.vala"
	predicates_to_signal_length1 = 0;
#line 150 "tracker-main.vala"
	_predicates_to_signal_size_ = predicates_to_signal_length1;
#line 524 "tracker-main.c"
	{
		TrackerDBCursor* cursor = NULL;
		TrackerDataManager* _tmp0_;
		TrackerDBCursor* _tmp1_;
#line 153 "tracker-main.vala"
		_tmp0_ = tracker_main_data_manager;
#line 153 "tracker-main.vala"
		_tmp1_ = tracker_data_query_sparql_cursor (_tmp0_, "SELECT ?predicate WHERE { ?predicate tracker:writeback true }", &_inner_error0_);
#line 153 "tracker-main.vala"
		cursor = _tmp1_;
#line 153 "tracker-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 537 "tracker-main.c"
			goto __catch5_g_error;
		}
#line 155 "tracker-main.vala"
		while (TRUE) {
#line 542 "tracker-main.c"
			gboolean _tmp2_ = FALSE;
			TrackerDBCursor* _tmp3_;
			gchar** _tmp4_;
			gint _tmp4__length1;
			TrackerDBCursor* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
#line 155 "tracker-main.vala"
			_tmp3_ = cursor;
#line 155 "tracker-main.vala"
			_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp3_, NULL, &_inner_error0_);
#line 155 "tracker-main.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 155 "tracker-main.vala"
				_g_object_unref0 (cursor);
#line 558 "tracker-main.c"
				goto __catch5_g_error;
			}
#line 155 "tracker-main.vala"
			if (!_tmp2_) {
#line 155 "tracker-main.vala"
				break;
#line 565 "tracker-main.c"
			}
#line 156 "tracker-main.vala"
			_tmp4_ = predicates_to_signal;
#line 156 "tracker-main.vala"
			_tmp4__length1 = predicates_to_signal_length1;
#line 156 "tracker-main.vala"
			_tmp5_ = cursor;
#line 156 "tracker-main.vala"
			_tmp6_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp5_, 0, NULL);
#line 156 "tracker-main.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 156 "tracker-main.vala"
			_vala_array_add1 (&predicates_to_signal, &predicates_to_signal_length1, &_predicates_to_signal_size_, _tmp7_);
#line 579 "tracker-main.c"
		}
#line 152 "tracker-main.vala"
		_g_object_unref0 (cursor);
#line 583 "tracker-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 152 "tracker-main.vala"
		e = _inner_error0_;
#line 152 "tracker-main.vala"
		_inner_error0_ = NULL;
#line 159 "tracker-main.vala"
		_tmp8_ = e;
#line 159 "tracker-main.vala"
		_tmp9_ = _tmp8_->message;
#line 159 "tracker-main.vala"
		g_critical ("Unable to retrieve tracker:writeback properties: %s", _tmp9_);
#line 152 "tracker-main.vala"
		_g_error_free0 (e);
#line 603 "tracker-main.c"
	}
	__finally5:
#line 152 "tracker-main.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "tracker-main.vala"
		predicates_to_signal = (_vala_array_free (predicates_to_signal, predicates_to_signal_length1, (GDestroyNotify) g_free), NULL);
#line 152 "tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 152 "tracker-main.vala"
		g_clear_error (&_inner_error0_);
#line 152 "tracker-main.vala"
		return NULL;
#line 616 "tracker-main.c"
	}
#line 162 "tracker-main.vala"
	result = predicates_to_signal;
#line 162 "tracker-main.vala"
	return result;
#line 622 "tracker-main.c"
}

static void
tracker_main_config_verbosity_changed_cb (GObject* object,
                                          GParamSpec* spec)
{
	gint verbosity = 0;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
#line 165 "tracker-main.vala"
	g_return_if_fail (object != NULL);
#line 166 "tracker-main.vala"
	_tmp0_ = tracker_config_get_verbosity (G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_CONFIG, TrackerConfig));
#line 166 "tracker-main.vala"
	_tmp1_ = _tmp0_;
#line 166 "tracker-main.vala"
	verbosity = _tmp1_;
#line 170 "tracker-main.vala"
	if (verbosity > 0) {
#line 170 "tracker-main.vala"
		_tmp2_ = "enabling";
#line 645 "tracker-main.c"
	} else {
#line 170 "tracker-main.vala"
		_tmp2_ = "disabling";
#line 649 "tracker-main.c"
	}
#line 168 "tracker-main.vala"
	g_message ("Log verbosity is set to %d, %s D-Bus client lookup", verbosity, _tmp2_);
#line 172 "tracker-main.vala"
	tracker_dbus_enable_client_lookup (verbosity > 0);
#line 655 "tracker-main.c"
}

TrackerDataManager*
tracker_main_get_data_manager (void)
{
	TrackerDataManager* result = NULL;
	TrackerDataManager* _tmp0_;
#line 176 "tracker-main.vala"
	_tmp0_ = tracker_main_data_manager;
#line 176 "tracker-main.vala"
	result = _tmp0_;
#line 176 "tracker-main.vala"
	return result;
#line 669 "tracker-main.c"
}

TrackerDirectConnection*
tracker_main_get_sparql_connection (void)
{
	TrackerDirectConnection* result = NULL;
	TrackerDirectConnection* _tmp0_;
#line 180 "tracker-main.vala"
	_tmp0_ = tracker_main_connection;
#line 180 "tracker-main.vala"
	result = _tmp0_;
#line 180 "tracker-main.vala"
	return result;
#line 683 "tracker-main.c"
}

static void
_tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
#line 253 "tracker-main.vala"
	tracker_main_config_verbosity_changed_cb (_sender, pspec);
#line 693 "tracker-main.c"
}

static gchar**
_tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (gint* result_length1)
{
	gchar** result;
	result = tracker_main_get_writeback_predicates ();
#line 310 "tracker-main.vala"
	return result;
#line 703 "tracker-main.c"
}

static gboolean
_tracker_main_shutdown_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_main_shutdown_timeout_cb ();
#line 337 "tracker-main.vala"
	return result;
#line 713 "tracker-main.c"
}

static gint
tracker_main_main (gchar** args,
                   gint args_length1)
{
	gint result = 0;
	TrackerConfig* config = NULL;
	TrackerConfig* _tmp6_;
	TrackerDBConfig* db_config = NULL;
	TrackerDBConfig* _tmp7_;
	TrackerConfig* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	TrackerDomainOntology* domain_ontology_config = NULL;
	TrackerDomainOntology* _tmp23_;
	GFile* _tmp24_;
	TrackerDomainOntology* _tmp25_;
	GFile* _tmp26_;
	TrackerDomainOntology* _tmp27_;
	GFile* _tmp28_;
	TrackerDomainOntology* _tmp29_;
	gchar* _tmp30_;
	TrackerConfig* _tmp31_;
	TrackerConfig* _tmp32_;
	gulong config_verbosity_id = 0UL;
	TrackerConfig* _tmp33_;
	gulong _tmp34_;
	TrackerDBManagerFlags flags = 0;
	TrackerDBManagerFlags _tmp36_;
	TrackerStatus* notifier = NULL;
	TrackerStatus* _tmp37_;
	TrackerConfig* _tmp38_;
	const gchar* _tmp39_;
	gint chunk_size_mb = 0;
	TrackerDBConfig* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gsize chunk_size = 0UL;
	gchar* rotate_to = NULL;
	TrackerDBConfig* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	gboolean do_rotating = FALSE;
	const gchar* _tmp47_;
	TrackerDirectConnection* _tmp58_;
	TrackerDataManager* _tmp59_;
	TrackerConfig* _tmp68_;
	GError* _inner_error0_ = NULL;
#line 184 "tracker-main.vala"
	setlocale (LC_ALL, "");
#line 186 "tracker-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 187 "tracker-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 188 "tracker-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 191 "tracker-main.vala"
	tzset ();
#line 193 "tracker-main.vala"
	tracker_main_verbosity = -1;
#line 778 "tracker-main.c"
	{
		GOptionContext* context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
#line 199 "tracker-main.vala"
		_tmp0_ = g_option_context_new (_ ("— start the tracker daemon"));
#line 199 "tracker-main.vala"
		context = _tmp0_;
#line 200 "tracker-main.vala"
		_tmp1_ = context;
#line 200 "tracker-main.vala"
		g_option_context_add_main_entries (_tmp1_, TRACKER_MAIN_entries, NULL);
#line 201 "tracker-main.vala"
		_tmp2_ = context;
#line 201 "tracker-main.vala"
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
#line 201 "tracker-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 201 "tracker-main.vala"
			_g_option_context_free0 (context);
#line 800 "tracker-main.c"
			goto __catch6_g_error;
		}
#line 195 "tracker-main.vala"
		_g_option_context_free0 (context);
#line 805 "tracker-main.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 195 "tracker-main.vala"
		e = _inner_error0_;
#line 195 "tracker-main.vala"
		_inner_error0_ = NULL;
#line 203 "tracker-main.vala"
		_tmp3_ = e;
#line 203 "tracker-main.vala"
		_tmp4_ = _tmp3_->message;
#line 203 "tracker-main.vala"
		g_printerr ("Invalid arguments, %s\n", _tmp4_);
#line 204 "tracker-main.vala"
		result = 1;
#line 204 "tracker-main.vala"
		_g_error_free0 (e);
#line 204 "tracker-main.vala"
		return result;
#line 829 "tracker-main.c"
	}
	__finally6:
#line 195 "tracker-main.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 834 "tracker-main.c"
		gint _tmp5_ = -1;
#line 195 "tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 195 "tracker-main.vala"
		g_clear_error (&_inner_error0_);
#line 195 "tracker-main.vala"
		return _tmp5_;
#line 842 "tracker-main.c"
	}
#line 207 "tracker-main.vala"
	if (tracker_main_version) {
#line 209 "tracker-main.vala"
		g_print ("%s", "\nTracker " PACKAGE_VERSION "\n\n" TRACKER_MAIN_LICENSE "\n");
#line 210 "tracker-main.vala"
		result = 0;
#line 210 "tracker-main.vala"
		return result;
#line 852 "tracker-main.c"
	}
#line 214 "tracker-main.vala"
	tracker_main_initialize_priority ();
#line 217 "tracker-main.vala"
	_tmp6_ = tracker_config_new ();
#line 217 "tracker-main.vala"
	config = _tmp6_;
#line 218 "tracker-main.vala"
	_tmp7_ = tracker_db_config_new ();
#line 218 "tracker-main.vala"
	db_config = _tmp7_;
#line 221 "tracker-main.vala"
	if (tracker_main_verbosity > -1) {
#line 866 "tracker-main.c"
		TrackerConfig* _tmp8_;
#line 222 "tracker-main.vala"
		_tmp8_ = config;
#line 222 "tracker-main.vala"
		tracker_config_set_verbosity (_tmp8_, tracker_main_verbosity);
#line 872 "tracker-main.c"
	}
#line 226 "tracker-main.vala"
	_tmp9_ = config;
#line 226 "tracker-main.vala"
	_tmp10_ = tracker_config_get_verbosity (_tmp9_);
#line 226 "tracker-main.vala"
	_tmp11_ = _tmp10_;
#line 226 "tracker-main.vala"
	tracker_log_init (_tmp11_, &_tmp12_);
#line 226 "tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 226 "tracker-main.vala"
	tracker_main_log_filename = _tmp12_;
#line 227 "tracker-main.vala"
	_tmp13_ = tracker_main_log_filename;
#line 227 "tracker-main.vala"
	if (_tmp13_ != NULL) {
#line 890 "tracker-main.c"
		const gchar* _tmp14_;
#line 228 "tracker-main.vala"
		_tmp14_ = tracker_main_log_filename;
#line 228 "tracker-main.vala"
		g_message ("Using log file:'%s'", _tmp14_);
#line 896 "tracker-main.c"
	}
	{
		TrackerDomainOntology* _tmp15_ = NULL;
		const gchar* _tmp16_;
		TrackerDomainOntology* _tmp17_;
		TrackerDomainOntology* _tmp18_;
#line 234 "tracker-main.vala"
		_tmp16_ = tracker_main_domain_ontology;
#line 234 "tracker-main.vala"
		_tmp17_ = tracker_domain_ontology_new (_tmp16_, NULL, &_inner_error0_);
#line 234 "tracker-main.vala"
		_tmp15_ = _tmp17_;
#line 234 "tracker-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 911 "tracker-main.c"
			goto __catch7_g_error;
		}
#line 234 "tracker-main.vala"
		_tmp18_ = _tmp15_;
#line 234 "tracker-main.vala"
		_tmp15_ = NULL;
#line 234 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 234 "tracker-main.vala"
		domain_ontology_config = _tmp18_;
#line 233 "tracker-main.vala"
		_g_object_unref0 (_tmp15_);
#line 924 "tracker-main.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
#line 233 "tracker-main.vala"
		e = _inner_error0_;
#line 233 "tracker-main.vala"
		_inner_error0_ = NULL;
#line 236 "tracker-main.vala"
		_tmp19_ = tracker_main_domain_ontology;
#line 236 "tracker-main.vala"
		_tmp20_ = e;
#line 236 "tracker-main.vala"
		_tmp21_ = _tmp20_->message;
#line 236 "tracker-main.vala"
		g_critical ("Could not load domain ontology definition '%s': %s", _tmp19_, _tmp21_);
#line 237 "tracker-main.vala"
		result = -1;
#line 237 "tracker-main.vala"
		_g_error_free0 (e);
#line 237 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 237 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 237 "tracker-main.vala"
		_g_object_unref0 (config);
#line 237 "tracker-main.vala"
		return result;
#line 957 "tracker-main.c"
	}
	__finally7:
#line 233 "tracker-main.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 962 "tracker-main.c"
		gint _tmp22_ = -1;
#line 233 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 233 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 233 "tracker-main.vala"
		_g_object_unref0 (config);
#line 233 "tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 233 "tracker-main.vala"
		g_clear_error (&_inner_error0_);
#line 233 "tracker-main.vala"
		return _tmp22_;
#line 976 "tracker-main.c"
	}
#line 240 "tracker-main.vala"
	_tmp23_ = domain_ontology_config;
#line 240 "tracker-main.vala"
	_tmp24_ = tracker_domain_ontology_get_cache (_tmp23_);
#line 240 "tracker-main.vala"
	_g_object_unref0 (tracker_main_cache_location);
#line 240 "tracker-main.vala"
	tracker_main_cache_location = _tmp24_;
#line 241 "tracker-main.vala"
	_tmp25_ = domain_ontology_config;
#line 241 "tracker-main.vala"
	_tmp26_ = tracker_domain_ontology_get_journal (_tmp25_);
#line 241 "tracker-main.vala"
	_g_object_unref0 (tracker_main_data_location);
#line 241 "tracker-main.vala"
	tracker_main_data_location = _tmp26_;
#line 242 "tracker-main.vala"
	_tmp27_ = domain_ontology_config;
#line 242 "tracker-main.vala"
	_tmp28_ = tracker_domain_ontology_get_ontology (_tmp27_);
#line 242 "tracker-main.vala"
	_g_object_unref0 (tracker_main_ontology_location);
#line 242 "tracker-main.vala"
	tracker_main_ontology_location = _tmp28_;
#line 243 "tracker-main.vala"
	_tmp29_ = domain_ontology_config;
#line 243 "tracker-main.vala"
	_tmp30_ = tracker_domain_ontology_get_domain (_tmp29_, "Tracker1");
#line 243 "tracker-main.vala"
	_g_free0 (tracker_main_domain);
#line 243 "tracker-main.vala"
	tracker_main_domain = _tmp30_;
#line 245 "tracker-main.vala"
	_tmp31_ = config;
#line 245 "tracker-main.vala"
	tracker_main_sanity_check_option_values (_tmp31_);
#line 247 "tracker-main.vala"
	if (!tracker_dbus_init ()) {
#line 248 "tracker-main.vala"
		result = 1;
#line 248 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 248 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 248 "tracker-main.vala"
		_g_object_unref0 (config);
#line 248 "tracker-main.vala"
		return result;
#line 1026 "tracker-main.c"
	}
#line 252 "tracker-main.vala"
	_tmp32_ = config;
#line 252 "tracker-main.vala"
	tracker_main_config_verbosity_changed_cb ((GObject*) _tmp32_, NULL);
#line 253 "tracker-main.vala"
	_tmp33_ = config;
#line 253 "tracker-main.vala"
	_tmp34_ = g_signal_connect ((GObject*) _tmp33_, "notify::verbosity", (GCallback) _tracker_main_config_verbosity_changed_cb_g_object_notify, NULL);
#line 253 "tracker-main.vala"
	config_verbosity_id = _tmp34_;
#line 255 "tracker-main.vala"
	flags = 0;
#line 257 "tracker-main.vala"
	if (tracker_main_force_reindex) {
#line 1042 "tracker-main.c"
		TrackerDBManagerFlags _tmp35_;
#line 261 "tracker-main.vala"
		_tmp35_ = flags;
#line 261 "tracker-main.vala"
		flags = _tmp35_ | TRACKER_DB_MANAGER_FORCE_REINDEX;
#line 1048 "tracker-main.c"
	}
#line 264 "tracker-main.vala"
	_tmp36_ = flags;
#line 264 "tracker-main.vala"
	tracker_direct_connection_set_default_flags (_tmp36_);
#line 266 "tracker-main.vala"
	_tmp37_ = tracker_dbus_register_notifier ();
#line 266 "tracker-main.vala"
	notifier = _tmp37_;
#line 268 "tracker-main.vala"
	_tmp38_ = config;
#line 268 "tracker-main.vala"
	tracker_store_init (_tmp38_);
#line 271 "tracker-main.vala"
	if (!tracker_dbus_register_objects ()) {
#line 272 "tracker-main.vala"
		result = 1;
#line 272 "tracker-main.vala"
		_g_object_unref0 (notifier);
#line 272 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 272 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 272 "tracker-main.vala"
		_g_object_unref0 (config);
#line 272 "tracker-main.vala"
		return result;
#line 1076 "tracker-main.c"
	}
#line 275 "tracker-main.vala"
	_tmp39_ = tracker_main_domain;
#line 275 "tracker-main.vala"
	if (!tracker_dbus_register_names (_tmp39_)) {
#line 276 "tracker-main.vala"
		result = 1;
#line 276 "tracker-main.vala"
		_g_object_unref0 (notifier);
#line 276 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 276 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 276 "tracker-main.vala"
		_g_object_unref0 (config);
#line 276 "tracker-main.vala"
		return result;
#line 1094 "tracker-main.c"
	}
#line 279 "tracker-main.vala"
	_tmp40_ = db_config;
#line 279 "tracker-main.vala"
	_tmp41_ = tracker_db_config_get_journal_chunk_size (_tmp40_);
#line 279 "tracker-main.vala"
	_tmp42_ = _tmp41_;
#line 279 "tracker-main.vala"
	chunk_size_mb = _tmp42_;
#line 280 "tracker-main.vala"
	chunk_size = (gsize) ((((gsize) chunk_size_mb) * ((gsize) 1024)) * ((gsize) 1024));
#line 281 "tracker-main.vala"
	_tmp43_ = db_config;
#line 281 "tracker-main.vala"
	_tmp44_ = tracker_db_config_get_journal_rotate_destination (_tmp43_);
#line 281 "tracker-main.vala"
	_tmp45_ = _tmp44_;
#line 281 "tracker-main.vala"
	rotate_to = _tmp45_;
#line 283 "tracker-main.vala"
	_tmp46_ = rotate_to;
#line 283 "tracker-main.vala"
	if (g_strcmp0 (_tmp46_, "") == 0) {
#line 284 "tracker-main.vala"
		_g_free0 (rotate_to);
#line 284 "tracker-main.vala"
		rotate_to = NULL;
#line 1122 "tracker-main.c"
	}
#line 287 "tracker-main.vala"
	do_rotating = chunk_size_mb != -1;
#line 289 "tracker-main.vala"
	_tmp47_ = rotate_to;
#line 289 "tracker-main.vala"
	tracker_db_journal_set_rotating (do_rotating, chunk_size, _tmp47_);
#line 1130 "tracker-main.c"
	{
		TrackerDirectConnection* _tmp48_ = NULL;
		GFile* _tmp49_;
		GFile* _tmp50_;
		GFile* _tmp51_;
		TrackerDirectConnection* _tmp52_;
		TrackerDirectConnection* _tmp53_;
		TrackerDirectConnection* _tmp54_;
#line 292 "tracker-main.vala"
		_tmp49_ = tracker_main_cache_location;
#line 292 "tracker-main.vala"
		_tmp50_ = tracker_main_data_location;
#line 292 "tracker-main.vala"
		_tmp51_ = tracker_main_ontology_location;
#line 292 "tracker-main.vala"
		_tmp52_ = tracker_direct_connection_new (TRACKER_SPARQL_CONNECTION_FLAGS_NONE, _tmp49_, _tmp50_, _tmp51_, &_inner_error0_);
#line 292 "tracker-main.vala"
		_tmp48_ = _tmp52_;
#line 292 "tracker-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1151 "tracker-main.c"
			goto __catch8_g_error;
		}
#line 292 "tracker-main.vala"
		_tmp53_ = _tmp48_;
#line 292 "tracker-main.vala"
		_tmp48_ = NULL;
#line 292 "tracker-main.vala"
		_g_object_unref0 (tracker_main_connection);
#line 292 "tracker-main.vala"
		tracker_main_connection = _tmp53_;
#line 296 "tracker-main.vala"
		_tmp54_ = tracker_main_connection;
#line 296 "tracker-main.vala"
		g_initable_init ((GInitable*) _tmp54_, NULL, &_inner_error0_);
#line 296 "tracker-main.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 296 "tracker-main.vala"
			_g_object_unref0 (_tmp48_);
#line 1170 "tracker-main.c"
			goto __catch8_g_error;
		}
#line 291 "tracker-main.vala"
		_g_object_unref0 (_tmp48_);
#line 1175 "tracker-main.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
#line 291 "tracker-main.vala"
		e = _inner_error0_;
#line 291 "tracker-main.vala"
		_inner_error0_ = NULL;
#line 298 "tracker-main.vala"
		_tmp55_ = e;
#line 298 "tracker-main.vala"
		_tmp56_ = _tmp55_->message;
#line 298 "tracker-main.vala"
		g_critical ("Cannot initialize database: %s", _tmp56_);
#line 299 "tracker-main.vala"
		result = 1;
#line 299 "tracker-main.vala"
		_g_error_free0 (e);
#line 299 "tracker-main.vala"
		_g_free0 (rotate_to);
#line 299 "tracker-main.vala"
		_g_object_unref0 (notifier);
#line 299 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 299 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 299 "tracker-main.vala"
		_g_object_unref0 (config);
#line 299 "tracker-main.vala"
		return result;
#line 1209 "tracker-main.c"
	}
	__finally8:
#line 291 "tracker-main.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1214 "tracker-main.c"
		gint _tmp57_ = -1;
#line 291 "tracker-main.vala"
		_g_free0 (rotate_to);
#line 291 "tracker-main.vala"
		_g_object_unref0 (notifier);
#line 291 "tracker-main.vala"
		_g_object_unref0 (domain_ontology_config);
#line 291 "tracker-main.vala"
		_g_object_unref0 (db_config);
#line 291 "tracker-main.vala"
		_g_object_unref0 (config);
#line 291 "tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 291 "tracker-main.vala"
		g_clear_error (&_inner_error0_);
#line 291 "tracker-main.vala"
		return _tmp57_;
#line 1232 "tracker-main.c"
	}
#line 302 "tracker-main.vala"
	_tmp58_ = tracker_main_connection;
#line 302 "tracker-main.vala"
	_tmp59_ = tracker_direct_connection_get_data_manager (_tmp58_);
#line 302 "tracker-main.vala"
	_g_object_unref0 (tracker_main_data_manager);
#line 302 "tracker-main.vala"
	tracker_main_data_manager = _tmp59_;
#line 303 "tracker-main.vala"
	_g_object_unref0 (db_config);
#line 303 "tracker-main.vala"
	db_config = NULL;
#line 304 "tracker-main.vala"
	_g_object_unref0 (notifier);
#line 304 "tracker-main.vala"
	notifier = NULL;
#line 306 "tracker-main.vala"
	if (!tracker_main_shutdown) {
#line 1252 "tracker-main.c"
		TrackerDataManager* _tmp60_;
#line 307 "tracker-main.vala"
		tracker_dbus_register_prepare_class_signal ();
#line 309 "tracker-main.vala"
		tracker_events_init ();
#line 310 "tracker-main.vala"
		_tmp60_ = tracker_main_data_manager;
#line 310 "tracker-main.vala"
		tracker_writeback_init (_tmp60_, _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func);
#line 311 "tracker-main.vala"
		tracker_store_resume ();
#line 313 "tracker-main.vala"
		g_message ("Waiting for D-Bus requests...");
#line 1266 "tracker-main.c"
	}
#line 319 "tracker-main.vala"
	if (!tracker_main_shutdown) {
#line 1270 "tracker-main.c"
		GMainLoop* _tmp61_;
		const gchar* _tmp62_;
		GMainLoop* _tmp67_;
#line 320 "tracker-main.vala"
		_tmp61_ = g_main_loop_new (NULL, FALSE);
#line 320 "tracker-main.vala"
		_g_main_loop_unref0 (tracker_main_main_loop);
#line 320 "tracker-main.vala"
		tracker_main_main_loop = _tmp61_;
#line 322 "tracker-main.vala"
		_tmp62_ = tracker_main_domain_ontology;
#line 322 "tracker-main.vala"
		if (_tmp62_ != NULL) {
#line 1284 "tracker-main.c"
			TrackerDomainOntology* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			GMainLoop* _tmp66_;
#line 323 "tracker-main.vala"
			_tmp63_ = domain_ontology_config;
#line 323 "tracker-main.vala"
			_tmp64_ = tracker_domain_ontology_get_domain (_tmp63_, NULL);
#line 323 "tracker-main.vala"
			_tmp65_ = _tmp64_;
#line 323 "tracker-main.vala"
			_tmp66_ = tracker_main_main_loop;
#line 323 "tracker-main.vala"
			tracker_dbus_watch_domain (_tmp65_, _tmp66_);
#line 323 "tracker-main.vala"
			_g_free0 (_tmp65_);
#line 1301 "tracker-main.c"
		}
#line 325 "tracker-main.vala"
		tracker_main_initialize_signal_handler ();
#line 327 "tracker-main.vala"
		_tmp67_ = tracker_main_main_loop;
#line 327 "tracker-main.vala"
		g_main_loop_run (_tmp67_);
#line 1309 "tracker-main.c"
	}
#line 333 "tracker-main.vala"
	g_message ("Shutdown started");
#line 335 "tracker-main.vala"
	tracker_store_shutdown ();
#line 337 "tracker-main.vala"
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 5000, _tracker_main_shutdown_timeout_cb_gsource_func, NULL, NULL);
#line 339 "tracker-main.vala"
	g_message ("Cleaning up");
#line 342 "tracker-main.vala"
	tracker_writeback_shutdown ();
#line 343 "tracker-main.vala"
	tracker_events_shutdown ();
#line 345 "tracker-main.vala"
	_g_object_unref0 (tracker_main_data_manager);
#line 345 "tracker-main.vala"
	tracker_main_data_manager = NULL;
#line 346 "tracker-main.vala"
	_g_object_unref0 (tracker_main_connection);
#line 346 "tracker-main.vala"
	tracker_main_connection = NULL;
#line 347 "tracker-main.vala"
	tracker_dbus_shutdown ();
#line 348 "tracker-main.vala"
	tracker_log_shutdown ();
#line 350 "tracker-main.vala"
	_tmp68_ = config;
#line 350 "tracker-main.vala"
	g_signal_handler_disconnect ((GObject*) _tmp68_, config_verbosity_id);
#line 351 "tracker-main.vala"
	_g_object_unref0 (config);
#line 351 "tracker-main.vala"
	config = NULL;
#line 354 "tracker-main.vala"
	tracker_db_journal_set_rotating (chunk_size_mb != -1, chunk_size, NULL);
#line 356 "tracker-main.vala"
	g_print ("\nOK\n\n");
#line 358 "tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 358 "tracker-main.vala"
	tracker_main_log_filename = NULL;
#line 360 "tracker-main.vala"
	_g_main_loop_unref0 (tracker_main_main_loop);
#line 360 "tracker-main.vala"
	tracker_main_main_loop = NULL;
#line 362 "tracker-main.vala"
	result = 0;
#line 362 "tracker-main.vala"
	_g_free0 (rotate_to);
#line 362 "tracker-main.vala"
	_g_object_unref0 (notifier);
#line 362 "tracker-main.vala"
	_g_object_unref0 (domain_ontology_config);
#line 362 "tracker-main.vala"
	_g_object_unref0 (db_config);
#line 362 "tracker-main.vala"
	_g_object_unref0 (config);
#line 362 "tracker-main.vala"
	return result;
#line 1369 "tracker-main.c"
}

int
main (int argc,
      char ** argv)
{
#line 183 "tracker-main.vala"
	return tracker_main_main (argv, argc);
#line 1378 "tracker-main.c"
}

TrackerMain*
tracker_main_construct (GType object_type)
{
	TrackerMain* self = NULL;
#line 21 "tracker-main.vala"
	self = (TrackerMain*) g_type_create_instance (object_type);
#line 21 "tracker-main.vala"
	return self;
#line 1389 "tracker-main.c"
}

TrackerMain*
tracker_main_new (void)
{
#line 21 "tracker-main.vala"
	return tracker_main_construct (TRACKER_TYPE_MAIN);
#line 1397 "tracker-main.c"
}

static void
tracker_value_main_init (GValue* value)
{
#line 21 "tracker-main.vala"
	value->data[0].v_pointer = NULL;
#line 1405 "tracker-main.c"
}

static void
tracker_value_main_free_value (GValue* value)
{
#line 21 "tracker-main.vala"
	if (value->data[0].v_pointer) {
#line 21 "tracker-main.vala"
		tracker_main_unref (value->data[0].v_pointer);
#line 1415 "tracker-main.c"
	}
}

static void
tracker_value_main_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 21 "tracker-main.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "tracker-main.vala"
		dest_value->data[0].v_pointer = tracker_main_ref (src_value->data[0].v_pointer);
#line 1427 "tracker-main.c"
	} else {
#line 21 "tracker-main.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1431 "tracker-main.c"
	}
}

static gpointer
tracker_value_main_peek_pointer (const GValue* value)
{
#line 21 "tracker-main.vala"
	return value->data[0].v_pointer;
#line 1440 "tracker-main.c"
}

static gchar*
tracker_value_main_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 21 "tracker-main.vala"
	if (collect_values[0].v_pointer) {
#line 1451 "tracker-main.c"
		TrackerMain * object;
		object = collect_values[0].v_pointer;
#line 21 "tracker-main.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "tracker-main.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1458 "tracker-main.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "tracker-main.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1462 "tracker-main.c"
		}
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = tracker_main_ref (object);
#line 1466 "tracker-main.c"
	} else {
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1470 "tracker-main.c"
	}
#line 21 "tracker-main.vala"
	return NULL;
#line 1474 "tracker-main.c"
}

static gchar*
tracker_value_main_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	TrackerMain ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "tracker-main.vala"
	if (!object_p) {
#line 21 "tracker-main.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1489 "tracker-main.c"
	}
#line 21 "tracker-main.vala"
	if (!value->data[0].v_pointer) {
#line 21 "tracker-main.vala"
		*object_p = NULL;
#line 1495 "tracker-main.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "tracker-main.vala"
		*object_p = value->data[0].v_pointer;
#line 1499 "tracker-main.c"
	} else {
#line 21 "tracker-main.vala"
		*object_p = tracker_main_ref (value->data[0].v_pointer);
#line 1503 "tracker-main.c"
	}
#line 21 "tracker-main.vala"
	return NULL;
#line 1507 "tracker-main.c"
}

GParamSpec*
tracker_param_spec_main (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	TrackerParamSpecMain* spec;
#line 21 "tracker-main.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_MAIN), NULL);
#line 21 "tracker-main.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "tracker-main.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "tracker-main.vala"
	return G_PARAM_SPEC (spec);
#line 1526 "tracker-main.c"
}

gpointer
tracker_value_get_main (const GValue* value)
{
#line 21 "tracker-main.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN), NULL);
#line 21 "tracker-main.vala"
	return value->data[0].v_pointer;
#line 1536 "tracker-main.c"
}

void
tracker_value_set_main (GValue* value,
                        gpointer v_object)
{
	TrackerMain * old;
#line 21 "tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "tracker-main.vala"
	if (v_object) {
#line 21 "tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 21 "tracker-main.vala"
		tracker_main_ref (value->data[0].v_pointer);
#line 1558 "tracker-main.c"
	} else {
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1562 "tracker-main.c"
	}
#line 21 "tracker-main.vala"
	if (old) {
#line 21 "tracker-main.vala"
		tracker_main_unref (old);
#line 1568 "tracker-main.c"
	}
}

void
tracker_value_take_main (GValue* value,
                         gpointer v_object)
{
	TrackerMain * old;
#line 21 "tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "tracker-main.vala"
	if (v_object) {
#line 21 "tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 1589 "tracker-main.c"
	} else {
#line 21 "tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1593 "tracker-main.c"
	}
#line 21 "tracker-main.vala"
	if (old) {
#line 21 "tracker-main.vala"
		tracker_main_unref (old);
#line 1599 "tracker-main.c"
	}
}

static void
tracker_main_class_init (TrackerMainClass * klass,
                         gpointer klass_data)
{
#line 21 "tracker-main.vala"
	tracker_main_parent_class = g_type_class_peek_parent (klass);
#line 21 "tracker-main.vala"
	((TrackerMainClass *) klass)->finalize = tracker_main_finalize;
#line 1611 "tracker-main.c"
}

static void
tracker_main_instance_init (TrackerMain * self,
                            gpointer klass)
{
#line 21 "tracker-main.vala"
	self->ref_count = 1;
#line 1620 "tracker-main.c"
}

static void
tracker_main_finalize (TrackerMain * obj)
{
	TrackerMain * self;
#line 21 "tracker-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_MAIN, TrackerMain);
#line 21 "tracker-main.vala"
	g_signal_handlers_destroy (self);
#line 1631 "tracker-main.c"
}

GType
tracker_main_get_type (void)
{
	static volatile gsize tracker_main_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_main_init, tracker_value_main_free_value, tracker_value_main_copy_value, tracker_value_main_peek_pointer, "p", tracker_value_main_collect_value, "p", tracker_value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMain), 0, (GInstanceInitFunc) tracker_main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_main_type_id;
		tracker_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_main_type_id__volatile, tracker_main_type_id);
	}
	return tracker_main_type_id__volatile;
}

gpointer
tracker_main_ref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
#line 21 "tracker-main.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "tracker-main.vala"
	return instance;
#line 1658 "tracker-main.c"
}

void
tracker_main_unref (gpointer instance)
{
	TrackerMain * self;
	self = instance;
#line 21 "tracker-main.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "tracker-main.vala"
		TRACKER_MAIN_GET_CLASS (self)->finalize (self);
#line 21 "tracker-main.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1672 "tracker-main.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

