/* importerhelper.c generated by valac, the Vala compiler
 * generated from importerhelper.vala, do not modify */

/* importhelper.vala
 *
 * Copyright (C) 2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *  Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))



G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree, ValadocApiNode* element, const gchar* parameter_name, gchar* * param_name, gchar* * param_array_name, gboolean* is_return_type_len);
G_GNUC_INTERNAL gchar** valadoc_importer_helper_split_type_name (const gchar* id, int* result_length1);
G_GNUC_INTERNAL const gchar* valadoc_api_formal_parameter_get_implicit_array_length_cparameter_name (ValadocApiFormalParameter* self);
G_GNUC_INTERNAL const gchar* valadoc_api_callable_get_implicit_array_length_cparameter_name (ValadocApiCallable* self);
G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment, ValadocContentContentFactory* factory);
G_GNUC_INTERNAL ValadocContentParagraph* valadoc_importer_helper_split_paragraph (ValadocContentParagraph* p, ValadocContentContentFactory* factory);
G_GNUC_INTERNAL ValadocContentText* valadoc_importer_helper_split_text (ValadocContentText* text, ValadocContentContentFactory* factory);
G_GNUC_INTERNAL ValadocContentRun* valadoc_importer_helper_split_run (ValadocContentRun* run, ValadocContentContentFactory* factory);
G_GNUC_INTERNAL ValadocContentInline* valadoc_importer_helper_split_inline (ValadocContentInline* item, ValadocContentContentFactory* factory);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


G_GNUC_INTERNAL gchar* valadoc_importer_helper_resolve_parameter_ctype (ValadocApiTree* tree, ValadocApiNode* element, const gchar* parameter_name, gchar* * param_name, gchar* * param_array_name, gboolean* is_return_type_len) {
	gchar* _vala_param_name = NULL;
	gchar* _vala_param_array_name = NULL;
	gboolean _vala_is_return_type_len = FALSE;
	gchar* result = NULL;
	gchar** parts = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	ValadocApiFormalParameter* param = NULL;
	gboolean _tmp30_ = FALSE;
	ValadocApiNode* _tmp31_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	ValadocApiItem* inner = NULL;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_;
	ValadocApiItem* _tmp66_;
	gchar* cname = NULL;
	ValadocApiItem* _tmp69_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	gchar* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar** _tmp90_;
	gint _tmp90__length1;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp0_ = parameter_name;
	_tmp2_ = valadoc_importer_helper_split_type_name (_tmp0_, &_tmp1_);
	parts = _tmp2_;
	parts_length1 = _tmp1_;
	_parts_size_ = parts_length1;
	_vala_is_return_type_len = FALSE;
	_g_free0 (_vala_param_array_name);
	_vala_param_array_name = NULL;
	param = NULL;
	{
		ValaList* _node_list = NULL;
		ValadocApiNode* _tmp3_;
		ValaList* _tmp4_;
		gint _node_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _node_index = 0;
		_tmp3_ = element;
		_tmp4_ = valadoc_api_node_get_children_by_type (_tmp3_, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, FALSE);
		_node_list = _tmp4_;
		_tmp5_ = _node_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_node_size = _tmp7_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValadocApiNode* node = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValadocApiNode* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar** _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			ValadocApiNode* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			_tmp8_ = _node_index;
			_node_index = _tmp8_ + 1;
			_tmp9_ = _node_index;
			_tmp10_ = _node_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _node_list;
			_tmp12_ = _node_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			node = (ValadocApiNode*) _tmp13_;
			_tmp14_ = node;
			_tmp15_ = valadoc_api_node_get_name (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = parts;
			_tmp17__length1 = parts_length1;
			_tmp18_ = _tmp17_[0];
			if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
				ValadocApiNode* _tmp19_;
				ValadocApiFormalParameter* _tmp20_;
				_tmp19_ = node;
				_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALADOC_API_TYPE_FORMAL_PARAMETER) ? ((ValadocApiFormalParameter*) _tmp19_) : NULL);
				_g_object_unref0 (param);
				param = _tmp20_;
				_g_object_unref0 (node);
				break;
			}
			_tmp21_ = node;
			_tmp22_ = valadoc_api_formal_parameter_get_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp23_ = _tmp22_;
			_tmp24_ = parts;
			_tmp24__length1 = parts_length1;
			_tmp25_ = _tmp24_[0];
			if (g_strcmp0 (_tmp23_, _tmp25_) == 0) {
				ValadocApiNode* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp26_ = node;
				_tmp27_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_vala_param_array_name);
				_vala_param_array_name = _tmp29_;
				_g_object_unref0 (node);
				break;
			}
			_g_object_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp31_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALADOC_API_TYPE_CALLABLE)) {
		ValadocApiNode* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		const gchar* _tmp36_;
		_tmp32_ = element;
		_tmp33_ = valadoc_api_callable_get_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALADOC_API_TYPE_CALLABLE, ValadocApiCallable));
		_tmp34_ = _tmp33_;
		_tmp35_ = parts;
		_tmp35__length1 = parts_length1;
		_tmp36_ = _tmp35_[0];
		_tmp30_ = g_strcmp0 (_tmp34_, _tmp36_) == 0;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		_vala_is_return_type_len = TRUE;
	}
	_tmp37_ = parts;
	_tmp37__length1 = parts_length1;
	if (_tmp37__length1 == 1) {
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp38_ = parameter_name;
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp39_;
		result = NULL;
		_g_object_unref0 (param);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (param_name) {
			*param_name = _vala_param_name;
		} else {
			_g_free0 (_vala_param_name);
		}
		if (param_array_name) {
			*param_array_name = _vala_param_array_name;
		} else {
			_g_free0 (_vala_param_array_name);
		}
		if (is_return_type_len) {
			*is_return_type_len = _vala_is_return_type_len;
		}
		return result;
	}
	inner = NULL;
	_tmp41_ = _vala_param_array_name;
	if (_tmp41_ != NULL) {
		_tmp40_ = TRUE;
	} else {
		gboolean _tmp42_;
		_tmp42_ = _vala_is_return_type_len;
		_tmp40_ = _tmp42_;
	}
	if (_tmp40_) {
		ValadocApiTree* _tmp43_;
		ValadocApiNode* _tmp44_;
		_tmp43_ = tree;
		_tmp44_ = valadoc_api_tree_search_symbol_str (_tmp43_, NULL, "int");
		_g_object_unref0 (inner);
		inner = (ValadocApiItem*) _tmp44_;
	} else {
		ValadocApiFormalParameter* _tmp45_;
		_tmp45_ = param;
		if (_tmp45_ != NULL) {
			ValadocApiFormalParameter* _tmp46_;
			ValadocApiTypeReference* _tmp47_;
			ValadocApiTypeReference* _tmp48_;
			ValadocApiItem* _tmp49_;
			_tmp46_ = param;
			_tmp47_ = valadoc_api_formal_parameter_get_parameter_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _g_object_ref0 ((ValadocApiItem*) _tmp48_);
			_g_object_unref0 (inner);
			inner = _tmp49_;
		}
	}
	while (TRUE) {
		ValadocApiItem* _tmp50_;
		ValadocApiItem* _tmp51_;
		_tmp50_ = inner;
		if (!(_tmp50_ != NULL)) {
			break;
		}
		_tmp51_ = inner;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALADOC_API_TYPE_TYPEREFERENCE)) {
			ValadocApiItem* _tmp52_;
			ValadocApiItem* _tmp53_;
			ValadocApiItem* _tmp54_;
			ValadocApiItem* _tmp55_;
			_tmp52_ = inner;
			_tmp53_ = valadoc_api_typereference_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference));
			_tmp54_ = _tmp53_;
			_tmp55_ = _g_object_ref0 (_tmp54_);
			_g_object_unref0 (inner);
			inner = _tmp55_;
		} else {
			ValadocApiItem* _tmp56_;
			_tmp56_ = inner;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALADOC_API_TYPE_POINTER)) {
				ValadocApiItem* _tmp57_;
				ValadocApiItem* _tmp58_;
				ValadocApiItem* _tmp59_;
				ValadocApiItem* _tmp60_;
				_tmp57_ = inner;
				_tmp58_ = valadoc_api_pointer_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALADOC_API_TYPE_POINTER, ValadocApiPointer));
				_tmp59_ = _tmp58_;
				_tmp60_ = _g_object_ref0 (_tmp59_);
				_g_object_unref0 (inner);
				inner = _tmp60_;
			} else {
				ValadocApiItem* _tmp61_;
				_tmp61_ = inner;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALADOC_API_TYPE_ARRAY)) {
					ValadocApiItem* _tmp62_;
					ValadocApiItem* _tmp63_;
					ValadocApiItem* _tmp64_;
					ValadocApiItem* _tmp65_;
					_tmp62_ = inner;
					_tmp63_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
					_tmp64_ = _tmp63_;
					_tmp65_ = _g_object_ref0 (_tmp64_);
					_g_object_unref0 (inner);
					inner = _tmp65_;
				} else {
					break;
				}
			}
		}
	}
	_tmp66_ = inner;
	if (_tmp66_ == NULL) {
		const gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp67_ = parameter_name;
		_tmp68_ = g_strdup (_tmp67_);
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp68_;
		result = NULL;
		_g_object_unref0 (inner);
		_g_object_unref0 (param);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (param_name) {
			*param_name = _vala_param_name;
		} else {
			_g_free0 (_vala_param_name);
		}
		if (param_array_name) {
			*param_array_name = _vala_param_array_name;
		} else {
			_g_free0 (_vala_param_array_name);
		}
		if (is_return_type_len) {
			*is_return_type_len = _vala_is_return_type_len;
		}
		return result;
	}
	cname = NULL;
	_tmp69_ = inner;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALADOC_API_TYPE_ERROR_DOMAIN)) {
		ValadocApiItem* _tmp70_;
		gchar* _tmp71_;
		_tmp70_ = inner;
		_tmp71_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
		_g_free0 (cname);
		cname = _tmp71_;
	} else {
		ValadocApiItem* _tmp72_;
		_tmp72_ = inner;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALADOC_API_TYPE_STRUCT)) {
			ValadocApiItem* _tmp73_;
			gchar* _tmp74_;
			_tmp73_ = inner;
			_tmp74_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
			_g_free0 (cname);
			cname = _tmp74_;
		} else {
			ValadocApiItem* _tmp75_;
			_tmp75_ = inner;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALADOC_API_TYPE_CLASS)) {
				ValadocApiItem* _tmp76_;
				gchar* _tmp77_;
				_tmp76_ = inner;
				_tmp77_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
				_g_free0 (cname);
				cname = _tmp77_;
			} else {
				ValadocApiItem* _tmp78_;
				_tmp78_ = inner;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALADOC_API_TYPE_ENUM)) {
					ValadocApiItem* _tmp79_;
					gchar* _tmp80_;
					_tmp79_ = inner;
					_tmp80_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
					_g_free0 (cname);
					cname = _tmp80_;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp81_ = parts;
	_tmp81__length1 = parts_length1;
	_tmp82_ = _tmp81_[0];
	_tmp81_[0] = NULL;
	_g_free0 (_vala_param_name);
	_vala_param_name = _tmp82_;
	_tmp83_ = cname;
	_tmp84_ = g_strconcat ("c::", _tmp83_, NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = parts;
	_tmp86__length1 = parts_length1;
	_tmp87_ = _tmp86_[1];
	_tmp88_ = g_strconcat (_tmp85_, _tmp87_, NULL);
	_tmp89_ = _tmp88_;
	_tmp90_ = parts;
	_tmp90__length1 = parts_length1;
	_tmp91_ = _tmp90_[2];
	_tmp92_ = g_strconcat (_tmp89_, _tmp91_, NULL);
	_tmp93_ = _tmp92_;
	_g_free0 (_tmp89_);
	_g_free0 (_tmp85_);
	result = _tmp93_;
	_g_free0 (cname);
	_g_object_unref0 (inner);
	_g_object_unref0 (param);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (param_name) {
		*param_name = _vala_param_name;
	} else {
		_g_free0 (_vala_param_name);
	}
	if (param_array_name) {
		*param_array_name = _vala_param_array_name;
	} else {
		_g_free0 (_vala_param_array_name);
	}
	if (is_return_type_len) {
		*is_return_type_len = _vala_is_return_type_len;
	}
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


G_GNUC_INTERNAL gchar** valadoc_importer_helper_split_type_name (const gchar* id, int* result_length1) {
	gchar** result = NULL;
	gunichar c = 0U;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	g_return_val_if_fail (id != NULL, NULL);
	{
		const gchar* pos = NULL;
		const gchar* _tmp0_;
		_tmp0_ = id;
		pos = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp4_;
				gunichar _tmp5_;
				gunichar _tmp6_;
				gunichar _tmp7_;
				if (!_tmp1_) {
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp2_ = pos;
					_tmp3_ = g_utf8_next_char (_tmp2_);
					pos = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = pos;
				_tmp5_ = string_get_char (_tmp4_, (glong) 0);
				c = _tmp5_;
				_tmp6_ = c;
				if (!(_tmp6_ != ((gunichar) '\0'))) {
					break;
				}
				_tmp7_ = c;
				switch (_tmp7_) {
					case '-':
					{
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						const gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gchar** _tmp15_;
						gchar** _tmp16_;
						gint _tmp16__length1;
						_tmp8_ = id;
						_tmp9_ = pos;
						_tmp10_ = id;
						_tmp11_ = string_substring (_tmp8_, (glong) 0, (glong) (((gchar*) _tmp9_) - ((gchar*) _tmp10_)));
						_tmp12_ = g_strdup ("->");
						_tmp13_ = pos;
						_tmp14_ = g_strdup ((const gchar*) (((gchar*) _tmp13_) + 2));
						_tmp15_ = g_new0 (gchar*, 3 + 1);
						_tmp15_[0] = _tmp11_;
						_tmp15_[1] = _tmp12_;
						_tmp15_[2] = _tmp14_;
						_tmp16_ = _tmp15_;
						_tmp16__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp16__length1;
						}
						result = _tmp16_;
						return result;
					}
					case ':':
					{
						const gchar* _tmp17_ = NULL;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						gunichar _tmp20_;
						gchar* sep = NULL;
						gchar* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						gchar* _tmp32_;
						gchar** _tmp33_;
						gchar** _tmp34_;
						gint _tmp34__length1;
						_tmp18_ = pos;
						_tmp19_ = g_utf8_next_char (_tmp18_);
						_tmp20_ = string_get_char (_tmp19_, (glong) 0);
						if (_tmp20_ == ((gunichar) ':')) {
							_tmp17_ = "::";
						} else {
							_tmp17_ = ":";
						}
						_tmp21_ = g_strdup (_tmp17_);
						sep = _tmp21_;
						_tmp22_ = id;
						_tmp23_ = pos;
						_tmp24_ = id;
						_tmp25_ = string_substring (_tmp22_, (glong) 0, (glong) (((gchar*) _tmp23_) - ((gchar*) _tmp24_)));
						_tmp26_ = sep;
						_tmp27_ = g_strdup (_tmp26_);
						_tmp28_ = pos;
						_tmp29_ = sep;
						_tmp30_ = strlen (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strdup ((const gchar*) (((gchar*) _tmp28_) + _tmp31_));
						_tmp33_ = g_new0 (gchar*, 3 + 1);
						_tmp33_[0] = _tmp25_;
						_tmp33_[1] = _tmp27_;
						_tmp33_[2] = _tmp32_;
						_tmp34_ = _tmp33_;
						_tmp34__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp34__length1;
						}
						result = _tmp34_;
						_g_free0 (sep);
						return result;
					}
					case '.':
					{
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar** _tmp42_;
						gchar** _tmp43_;
						gint _tmp43__length1;
						_tmp35_ = id;
						_tmp36_ = pos;
						_tmp37_ = id;
						_tmp38_ = string_substring (_tmp35_, (glong) 0, (glong) (((gchar*) _tmp36_) - ((gchar*) _tmp37_)));
						_tmp39_ = g_strdup (".");
						_tmp40_ = pos;
						_tmp41_ = g_strdup ((const gchar*) (((gchar*) _tmp40_) + 1));
						_tmp42_ = g_new0 (gchar*, 3 + 1);
						_tmp42_[0] = _tmp38_;
						_tmp42_[1] = _tmp39_;
						_tmp42_[2] = _tmp41_;
						_tmp43_ = _tmp42_;
						_tmp43__length1 = 3;
						if (result_length1) {
							*result_length1 = _tmp43__length1;
						}
						result = _tmp43_;
						return result;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp44_ = id;
	_tmp45_ = g_strdup (_tmp44_);
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp47__length1;
	}
	result = _tmp47_;
	return result;
}


G_GNUC_INTERNAL void valadoc_importer_helper_extract_short_desc (ValadocContentComment* comment, ValadocContentContentFactory* factory) {
	ValadocContentComment* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValadocContentParagraph* first_paragraph = NULL;
	ValadocContentComment* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	gpointer _tmp8_;
	ValadocContentBlock* _tmp9_;
	ValadocContentParagraph* _tmp10_;
	ValadocContentParagraph* _tmp11_;
	ValadocContentParagraph* _tmp18_;
	ValadocContentParagraph* _tmp19_;
	ValadocContentParagraph* _tmp20_;
	ValadocContentParagraph* second_paragraph = NULL;
	ValadocContentParagraph* _tmp21_;
	ValadocContentContentFactory* _tmp22_;
	ValadocContentParagraph* _tmp23_;
	ValadocContentParagraph* _tmp24_;
	ValadocContentParagraph* _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (comment != NULL);
	g_return_if_fail (factory != NULL);
	_tmp0_ = comment;
	_tmp1_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = comment;
	_tmp6_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_list_get (_tmp7_, 0);
	_tmp9_ = (ValadocContentBlock*) _tmp8_;
	_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALADOC_CONTENT_TYPE_PARAGRAPH) ? ((ValadocContentParagraph*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	first_paragraph = _tmp10_;
	_tmp11_ = first_paragraph;
	if (_tmp11_ == NULL) {
		ValadocContentComment* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		ValadocContentContentFactory* _tmp15_;
		ValadocContentParagraph* _tmp16_;
		ValadocContentParagraph* _tmp17_;
		_tmp12_ = comment;
		_tmp13_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = factory;
		_tmp16_ = valadoc_content_content_factory_create_paragraph (_tmp15_);
		_tmp17_ = _tmp16_;
		vala_list_insert (_tmp14_, 1, (ValadocContentBlock*) _tmp17_);
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (first_paragraph);
		return;
	}
	_tmp18_ = first_paragraph;
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp18_, NULL);
	_tmp19_ = first_paragraph;
	valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp19_, NULL);
	_tmp20_ = first_paragraph;
	valadoc_content_style_attributes_set_style ((ValadocContentStyleAttributes*) _tmp20_, NULL);
	_tmp21_ = first_paragraph;
	_tmp22_ = factory;
	_tmp23_ = valadoc_importer_helper_split_paragraph (_tmp21_, _tmp22_);
	second_paragraph = _tmp23_;
	_tmp24_ = second_paragraph;
	if (_tmp24_ == NULL) {
		_g_object_unref0 (second_paragraph);
		_g_object_unref0 (first_paragraph);
		return;
	}
	_tmp25_ = second_paragraph;
	_tmp26_ = valadoc_content_content_element_is_empty ((ValadocContentContentElement*) _tmp25_);
	if (_tmp26_ == FALSE) {
		ValadocContentComment* _tmp27_;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		ValadocContentParagraph* _tmp30_;
		_tmp27_ = comment;
		_tmp28_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = second_paragraph;
		vala_list_insert (_tmp29_, 1, (ValadocContentBlock*) _tmp30_);
	}
	_g_object_unref0 (second_paragraph);
	_g_object_unref0 (first_paragraph);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


G_GNUC_INTERNAL inline ValadocContentText* valadoc_importer_helper_split_text (ValadocContentText* text, ValadocContentContentFactory* factory) {
	ValadocContentText* result = NULL;
	gint offset = 0;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	offset = 0;
	while (TRUE) {
		ValadocContentText* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		const gchar* cmp0 = NULL;
		ValadocContentText* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		const gchar* _tmp27_;
		gboolean _tmp28_;
		const gchar* _tmp30_;
		gchar _tmp31_;
		gboolean _tmp32_;
		ValadocContentText* sec = NULL;
		ValadocContentContentFactory* _tmp34_;
		ValadocContentText* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gint _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		ValadocContentText* _tmp41_;
		ValadocContentText* _tmp42_;
		ValadocContentText* _tmp43_;
		ValadocContentText* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gint _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp0_ = text;
		_tmp1_ = valadoc_content_text_get_content (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = offset;
		_tmp4_ = string_index_of_char (_tmp2_, (gunichar) '.', _tmp3_);
		offset = _tmp4_;
		_tmp5_ = offset;
		if (!(_tmp5_ >= 0)) {
			break;
		}
		_tmp6_ = offset;
		if (_tmp6_ >= 2) {
			const gchar* cmp4 = NULL;
			ValadocContentText* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp7_ = text;
			_tmp8_ = valadoc_content_text_get_content (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = offset;
			cmp4 = (const gchar*) ((((gchar*) _tmp9_) + _tmp10_) - 2);
			_tmp12_ = cmp4;
			_tmp13_ = g_str_has_prefix (_tmp12_, " e.g.");
			if (_tmp13_) {
				_tmp11_ = TRUE;
			} else {
				const gchar* _tmp14_;
				gboolean _tmp15_;
				_tmp14_ = cmp4;
				_tmp15_ = g_str_has_prefix (_tmp14_, "(e.g.");
				_tmp11_ = _tmp15_;
			}
			if (_tmp11_) {
				gint _tmp16_;
				_tmp16_ = offset;
				offset = _tmp16_ + 3;
				continue;
			}
			_tmp18_ = cmp4;
			_tmp19_ = g_str_has_prefix (_tmp18_, " i.e.");
			if (_tmp19_) {
				_tmp17_ = TRUE;
			} else {
				const gchar* _tmp20_;
				gboolean _tmp21_;
				_tmp20_ = cmp4;
				_tmp21_ = g_str_has_prefix (_tmp20_, "(i.e.");
				_tmp17_ = _tmp21_;
			}
			if (_tmp17_) {
				gint _tmp22_;
				_tmp22_ = offset;
				offset = _tmp22_ + 3;
				continue;
			}
		}
		_tmp23_ = text;
		_tmp24_ = valadoc_content_text_get_content (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = offset;
		cmp0 = (const gchar*) (((gchar*) _tmp25_) + _tmp26_);
		_tmp27_ = cmp0;
		_tmp28_ = g_str_has_prefix (_tmp27_, "...");
		if (_tmp28_) {
			gint _tmp29_;
			_tmp29_ = offset;
			offset = _tmp29_ + 3;
			continue;
		}
		_tmp30_ = cmp0;
		_tmp31_ = string_get (_tmp30_, (glong) 1);
		_tmp32_ = g_ascii_isdigit (_tmp31_);
		if (_tmp32_) {
			gint _tmp33_;
			_tmp33_ = offset;
			offset = _tmp33_ + 2;
			continue;
		}
		_tmp34_ = factory;
		_tmp35_ = text;
		_tmp36_ = valadoc_content_text_get_content (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = offset;
		_tmp39_ = string_substring (_tmp37_, (glong) (_tmp38_ + 1), (glong) -1);
		_tmp40_ = _tmp39_;
		_tmp41_ = valadoc_content_content_factory_create_text (_tmp34_, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		sec = _tmp42_;
		_tmp43_ = text;
		_tmp44_ = text;
		_tmp45_ = valadoc_content_text_get_content (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = offset;
		_tmp48_ = string_substring (_tmp46_, (glong) 0, (glong) (_tmp47_ + 1));
		_tmp49_ = _tmp48_;
		valadoc_content_text_set_content (_tmp43_, _tmp49_);
		_g_free0 (_tmp49_);
		result = sec;
		return result;
	}
	result = NULL;
	return result;
}


G_GNUC_INTERNAL inline ValadocContentRun* valadoc_importer_helper_split_run (ValadocContentRun* run, ValadocContentContentFactory* factory) {
	ValadocContentRun* result = NULL;
	ValadocContentRun* _tmp0_;
	ValadocContentRunStyle _tmp1_;
	ValadocContentRunStyle _tmp2_;
	ValadocContentRun* sec = NULL;
	ValaIterator* iter = NULL;
	ValadocContentRun* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	ValaIterator* _tmp6_;
	g_return_val_if_fail (run != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	_tmp0_ = run;
	_tmp1_ = valadoc_content_run_get_style (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALADOC_CONTENT_RUN_STYLE_NONE) {
		result = NULL;
		return result;
	}
	sec = NULL;
	_tmp3_ = run;
	_tmp4_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
	iter = _tmp6_;
	{
		gboolean has_next = FALSE;
		ValaIterator* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = iter;
		_tmp8_ = vala_iterator_next (_tmp7_);
		has_next = _tmp8_;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				ValadocContentInline* item = NULL;
				ValaIterator* _tmp13_;
				gpointer _tmp14_;
				ValadocContentRun* _tmp15_;
				if (!_tmp9_) {
					ValaIterator* _tmp10_;
					gboolean _tmp11_;
					_tmp10_ = iter;
					_tmp11_ = vala_iterator_next (_tmp10_);
					has_next = _tmp11_;
				}
				_tmp9_ = FALSE;
				_tmp12_ = has_next;
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = iter;
				_tmp14_ = vala_iterator_get (_tmp13_);
				item = (ValadocContentInline*) _tmp14_;
				_tmp15_ = sec;
				if (_tmp15_ == NULL) {
					ValadocContentInline* tmp = NULL;
					ValadocContentInline* _tmp16_;
					ValadocContentContentFactory* _tmp17_;
					ValadocContentInline* _tmp18_;
					ValadocContentInline* _tmp19_;
					_tmp16_ = item;
					_tmp17_ = factory;
					_tmp18_ = valadoc_importer_helper_split_inline (_tmp16_, _tmp17_);
					tmp = _tmp18_;
					_tmp19_ = tmp;
					if (_tmp19_ != NULL) {
						ValadocContentContentFactory* _tmp20_;
						ValadocContentRun* _tmp21_;
						ValadocContentRunStyle _tmp22_;
						ValadocContentRunStyle _tmp23_;
						ValadocContentRun* _tmp24_;
						ValadocContentRun* _tmp25_;
						ValaList* _tmp26_;
						ValaList* _tmp27_;
						ValadocContentInline* _tmp28_;
						_tmp20_ = factory;
						_tmp21_ = run;
						_tmp22_ = valadoc_content_run_get_style (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = valadoc_content_content_factory_create_run (_tmp20_, _tmp23_);
						_g_object_unref0 (sec);
						sec = _tmp24_;
						_tmp25_ = sec;
						_tmp26_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = tmp;
						vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
					}
					_g_object_unref0 (tmp);
				} else {
					ValadocContentRun* _tmp29_;
					ValaList* _tmp30_;
					ValaList* _tmp31_;
					ValadocContentInline* _tmp32_;
					ValaIterator* _tmp33_;
					_tmp29_ = sec;
					_tmp30_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = item;
					vala_collection_add ((ValaCollection*) _tmp31_, _tmp32_);
					_tmp33_ = iter;
					vala_iterator_remove (_tmp33_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = sec;
	_vala_iterator_unref0 (iter);
	return result;
}


G_GNUC_INTERNAL inline ValadocContentInline* valadoc_importer_helper_split_inline (ValadocContentInline* item, ValadocContentContentFactory* factory) {
	ValadocContentInline* result = NULL;
	ValadocContentInline* _tmp0_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	_tmp0_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_CONTENT_TYPE_TEXT)) {
		ValadocContentInline* _tmp1_;
		ValadocContentContentFactory* _tmp2_;
		ValadocContentText* _tmp3_;
		_tmp1_ = item;
		_tmp2_ = factory;
		_tmp3_ = valadoc_importer_helper_split_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText), _tmp2_);
		result = (ValadocContentInline*) _tmp3_;
		return result;
	} else {
		ValadocContentInline* _tmp4_;
		_tmp4_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALADOC_CONTENT_TYPE_RUN)) {
			ValadocContentInline* _tmp5_;
			ValadocContentContentFactory* _tmp6_;
			ValadocContentRun* _tmp7_;
			_tmp5_ = item;
			_tmp6_ = factory;
			_tmp7_ = valadoc_importer_helper_split_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_CONTENT_TYPE_RUN, ValadocContentRun), _tmp6_);
			result = (ValadocContentInline*) _tmp7_;
			return result;
		}
	}
	result = NULL;
	return result;
}


G_GNUC_INTERNAL inline ValadocContentParagraph* valadoc_importer_helper_split_paragraph (ValadocContentParagraph* p, ValadocContentContentFactory* factory) {
	ValadocContentParagraph* result = NULL;
	ValadocContentParagraph* sec = NULL;
	ValaIterator* iter = NULL;
	ValadocContentParagraph* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaIterator* _tmp3_;
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (factory != NULL, NULL);
	sec = NULL;
	_tmp0_ = p;
	_tmp1_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
	iter = _tmp3_;
	{
		gboolean has_next = FALSE;
		ValaIterator* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = iter;
		_tmp5_ = vala_iterator_next (_tmp4_);
		has_next = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				ValadocContentInline* item = NULL;
				ValaIterator* _tmp10_;
				gpointer _tmp11_;
				ValadocContentParagraph* _tmp12_;
				if (!_tmp6_) {
					ValaIterator* _tmp7_;
					gboolean _tmp8_;
					_tmp7_ = iter;
					_tmp8_ = vala_iterator_next (_tmp7_);
					has_next = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = has_next;
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = iter;
				_tmp11_ = vala_iterator_get (_tmp10_);
				item = (ValadocContentInline*) _tmp11_;
				_tmp12_ = sec;
				if (_tmp12_ == NULL) {
					ValadocContentInline* tmp = NULL;
					ValadocContentInline* _tmp13_;
					ValadocContentContentFactory* _tmp14_;
					ValadocContentInline* _tmp15_;
					ValadocContentInline* _tmp16_;
					_tmp13_ = item;
					_tmp14_ = factory;
					_tmp15_ = valadoc_importer_helper_split_inline (_tmp13_, _tmp14_);
					tmp = _tmp15_;
					_tmp16_ = tmp;
					if (_tmp16_ != NULL) {
						ValadocContentContentFactory* _tmp17_;
						ValadocContentParagraph* _tmp18_;
						ValadocContentParagraph* _tmp19_;
						ValadocContentParagraph* _tmp20_;
						ValadocContentHorizontalAlign* _tmp21_;
						ValadocContentHorizontalAlign* _tmp22_;
						ValadocContentParagraph* _tmp23_;
						ValadocContentParagraph* _tmp24_;
						ValadocContentVerticalAlign* _tmp25_;
						ValadocContentVerticalAlign* _tmp26_;
						ValadocContentParagraph* _tmp27_;
						ValadocContentParagraph* _tmp28_;
						const gchar* _tmp29_;
						const gchar* _tmp30_;
						ValadocContentParagraph* _tmp31_;
						ValaList* _tmp32_;
						ValaList* _tmp33_;
						ValadocContentInline* _tmp34_;
						_tmp17_ = factory;
						_tmp18_ = valadoc_content_content_factory_create_paragraph (_tmp17_);
						_g_object_unref0 (sec);
						sec = _tmp18_;
						_tmp19_ = sec;
						_tmp20_ = p;
						_tmp21_ = valadoc_content_style_attributes_get_horizontal_align ((ValadocContentStyleAttributes*) _tmp20_);
						_tmp22_ = _tmp21_;
						valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp19_, _tmp22_);
						_tmp23_ = sec;
						_tmp24_ = p;
						_tmp25_ = valadoc_content_style_attributes_get_vertical_align ((ValadocContentStyleAttributes*) _tmp24_);
						_tmp26_ = _tmp25_;
						valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp23_, _tmp26_);
						_tmp27_ = sec;
						_tmp28_ = p;
						_tmp29_ = valadoc_content_style_attributes_get_style ((ValadocContentStyleAttributes*) _tmp28_);
						_tmp30_ = _tmp29_;
						valadoc_content_style_attributes_set_style ((ValadocContentStyleAttributes*) _tmp27_, _tmp30_);
						_tmp31_ = sec;
						_tmp32_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = tmp;
						vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
					}
					_g_object_unref0 (tmp);
				} else {
					ValadocContentParagraph* _tmp35_;
					ValaList* _tmp36_;
					ValaList* _tmp37_;
					ValadocContentInline* _tmp38_;
					ValaIterator* _tmp39_;
					_tmp35_ = sec;
					_tmp36_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = item;
					vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
					_tmp39_ = iter;
					vala_iterator_remove (_tmp39_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = sec;
	_vala_iterator_unref0 (iter);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



