/* valanamespace.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALANAMESPACE_H__
#define __VALA_VALANAMESPACE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespacePrivate ValaNamespacePrivate;

/**
 * Represents a namespace declaration in the source code.
 */
struct _ValaNamespace {
	ValaSymbol parent_instance;
	ValaNamespacePrivate * priv;
};

struct _ValaNamespaceClass {
	ValaSymbolClass parent_class;
};


ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
void vala_namespace_add_namespace (ValaNamespace* self, ValaNamespace* ns);
GeeList* vala_namespace_get_namespaces (ValaNamespace* self);
void vala_namespace_add_class (ValaNamespace* self, ValaClass* cl);
void vala_namespace_add_interface (ValaNamespace* self, ValaInterface* iface);
void vala_namespace_add_struct (ValaNamespace* self, ValaStruct* st);
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st);
void vala_namespace_add_enum (ValaNamespace* self, ValaEnum* en);
void vala_namespace_add_error_domain (ValaNamespace* self, ValaErrorDomain* edomain);
void vala_namespace_add_delegate (ValaNamespace* self, ValaDelegate* d);
GeeList* vala_namespace_get_structs (ValaNamespace* self);
GeeList* vala_namespace_get_classes (ValaNamespace* self);
GeeList* vala_namespace_get_interfaces (ValaNamespace* self);
GeeList* vala_namespace_get_enums (ValaNamespace* self);
GeeList* vala_namespace_get_error_domains (ValaNamespace* self);
GeeList* vala_namespace_get_fields (ValaNamespace* self);
GeeList* vala_namespace_get_constants (ValaNamespace* self);
GeeList* vala_namespace_get_delegates (ValaNamespace* self);
GeeList* vala_namespace_get_methods (ValaNamespace* self);
void vala_namespace_add_constant (ValaNamespace* self, ValaConstant* constant);
void vala_namespace_add_field (ValaNamespace* self, ValaField* f);
void vala_namespace_add_method (ValaNamespace* self, ValaMethod* m);
GeeList* vala_namespace_get_cprefixes (ValaNamespace* self);
void vala_namespace_add_cprefix (ValaNamespace* self, const char* cprefix);
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix);
char* vala_namespace_get_cheader_filename (ValaNamespace* self);
void vala_namespace_set_cheader_filename (ValaNamespace* self, const char* cheader_filename);
void vala_namespace_add_cheader_filename (ValaNamespace* self, const char* cheader_filename);
void vala_namespace_process_attributes (ValaNamespace* self);
GType vala_namespace_get_type (void);


G_END_DECLS

#endif
