/* valaccodebasemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodebasemodule.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valainterface.h>
#include <vala/valabooleantype.h>
#include <vala/valaintegertype.h>
#include <vala/valafloatingtype.h>
#include <vala/valastructvaluetype.h>
#include <vala/valaenumvaluetype.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <vala/valareport.h>
#include <vala/valainvalidtype.h>
#include <vala/valacodevisitor.h>
#include <vala/valavaluetype.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <gee/hashmap.h>
#include <gee/collection.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valanulltype.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valareferencetype.h>
#include <vala/valadostatement.h>
#include <vala/valawhilestatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valadelegatetype.h>
#include <vala/valagenerictype.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valacreationmethod.h>
#include <gee/hashset.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodenewline.h>
#include <vala/valascope.h>
#include <ccode/valaccodeenumvalue.h>
#include <vala/valalockable.h>
#include <vala/valadelegate.h>
#include <vala/valaarraycreationexpression.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valamemberinitializer.h>




static gboolean string_contains (const char* self, const char* needle);
static char* string_substring (const char* self, glong offset, glong len);
static glong string_get_length (const char* self);
struct _ValaCCodeBaseModulePrivate {
	ValaCodeContext* _context;
};

#define VALA_CCODE_BASE_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModulePrivate))
enum  {
	VALA_CCODE_BASE_MODULE_DUMMY_PROPERTY
};
static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference);
static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_length (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file);
static char* vala_ccode_base_module_get_define_for_filename (const char* filename);
static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context);
static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en);
static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev);
static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m);
static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c);
static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f);
static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p);
static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop);
static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc);
static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d);
static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b);
static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt);
static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt);
static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local);
static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list);
static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type);
static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression);
static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt);
static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag);
static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma);
static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);
static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym);
static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt);
static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt);
static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr);
static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr);
static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr);
static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr);
static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr);
static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr);
static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr);
static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr);
static gboolean vala_ccode_base_module_is_ref_function_void (ValaCCodeBaseModule* self, ValaDataType* type);
static gboolean vala_ccode_base_module_is_reference_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_nullable_value_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_signed_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_unsigned_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static void vala_ccode_base_module_check_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr);
static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr);
static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr);
static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr);
static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr);
static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr);
static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type);
static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr);
static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l);
static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static gpointer vala_ccode_base_module_parent_class = NULL;
static void vala_ccode_base_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean string_contains (const char* self, const char* needle) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	return strstr (self, needle) != NULL;
}


static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeBaseModule* self;
	GeeSet* _tmp0;
	GeeSet* _tmp1;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeBaseModule*) vala_ccode_module_construct (object_type, codegen, next);
	_tmp0 = NULL;
	self->predefined_marshal_set = (_tmp0 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL)), _tmp0);
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:VOID");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:BOOLEAN");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:CHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UCHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:INT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:LONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ULONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ENUM");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLAGS");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLOAT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:DOUBLE");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:STRING");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:OBJECT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "STRING:OBJECT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "BOOLEAN:FLAGS");
	_tmp1 = NULL;
	self->c_keywords = (_tmp1 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->c_keywords == NULL) ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL)), _tmp1);
	/* C99 keywords*/
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Bool");
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Complex");
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Imaginary");
	gee_collection_add ((GeeCollection*) self->c_keywords, "auto");
	gee_collection_add ((GeeCollection*) self->c_keywords, "break");
	gee_collection_add ((GeeCollection*) self->c_keywords, "case");
	gee_collection_add ((GeeCollection*) self->c_keywords, "char");
	gee_collection_add ((GeeCollection*) self->c_keywords, "const");
	gee_collection_add ((GeeCollection*) self->c_keywords, "continue");
	gee_collection_add ((GeeCollection*) self->c_keywords, "default");
	gee_collection_add ((GeeCollection*) self->c_keywords, "do");
	gee_collection_add ((GeeCollection*) self->c_keywords, "double");
	gee_collection_add ((GeeCollection*) self->c_keywords, "else");
	gee_collection_add ((GeeCollection*) self->c_keywords, "enum");
	gee_collection_add ((GeeCollection*) self->c_keywords, "extern");
	gee_collection_add ((GeeCollection*) self->c_keywords, "float");
	gee_collection_add ((GeeCollection*) self->c_keywords, "for");
	gee_collection_add ((GeeCollection*) self->c_keywords, "goto");
	gee_collection_add ((GeeCollection*) self->c_keywords, "if");
	gee_collection_add ((GeeCollection*) self->c_keywords, "inline");
	gee_collection_add ((GeeCollection*) self->c_keywords, "int");
	gee_collection_add ((GeeCollection*) self->c_keywords, "long");
	gee_collection_add ((GeeCollection*) self->c_keywords, "register");
	gee_collection_add ((GeeCollection*) self->c_keywords, "restrict");
	gee_collection_add ((GeeCollection*) self->c_keywords, "return");
	gee_collection_add ((GeeCollection*) self->c_keywords, "short");
	gee_collection_add ((GeeCollection*) self->c_keywords, "signed");
	gee_collection_add ((GeeCollection*) self->c_keywords, "sizeof");
	gee_collection_add ((GeeCollection*) self->c_keywords, "static");
	gee_collection_add ((GeeCollection*) self->c_keywords, "struct");
	gee_collection_add ((GeeCollection*) self->c_keywords, "switch");
	gee_collection_add ((GeeCollection*) self->c_keywords, "typedef");
	gee_collection_add ((GeeCollection*) self->c_keywords, "union");
	gee_collection_add ((GeeCollection*) self->c_keywords, "unsigned");
	gee_collection_add ((GeeCollection*) self->c_keywords, "void");
	gee_collection_add ((GeeCollection*) self->c_keywords, "volatile");
	gee_collection_add ((GeeCollection*) self->c_keywords, "while");
	/* MSVC keywords*/
	gee_collection_add ((GeeCollection*) self->c_keywords, "cdecl");
	return self;
}


ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_base_module_construct (VALA_TYPE_CCODE_BASE_MODULE, codegen, next);
}


static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_val_if_fail (type_reference != NULL, NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new (_tmp0 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_free (self);
}


static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_move (self);
}


static void vala_ccode_base_module_real_append_vala_array_length (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_length (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_length (self);
}


static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeBinaryExpression* _tmp5;
	ValaCCodeBinaryExpression* cineq;
	ValaCCodeBlock* _tmp6;
	ValaCCodeBlock* cblock;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeConstant* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeBlock* _tmp13;
	ValaCCodeIfStatement* _tmp17;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeReturnStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeReturnStatement* _tmp23;
	g_return_if_fail (self != NULL);
	fun = vala_ccode_function_new ("_vala_strcmp0", "int");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0 = vala_ccode_formal_parameter_new ("str1", "const char *"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1 = vala_ccode_formal_parameter_new ("str2", "const char *"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp2 = vala_ccode_function_copy (fun)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	/* (str1 != str2)*/
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	cineq = (_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("str2"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_function_set_block (fun, _tmp6 = vala_ccode_block_new ());
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	cblock = vala_ccode_block_new ();
	/* if (str1 == NULL)*/
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp10 = NULL;
	cif = (_tmp10 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp10);
	/* return -(str1 != str2);*/
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp12 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_MINUS, (ValaCCodeExpression*) cineq)))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	_tmp13 = NULL;
	cblock = (_tmp13 = vala_ccode_block_new (), (cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)), _tmp13);
	/* if (str2 == NULL)*/
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	cif = (_tmp17 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("str2")), (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	/* return (str1 != str2);*/
	_tmp18 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp18 = vala_ccode_return_statement_new ((ValaCCodeExpression*) cineq)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	/* strcmp (str1, str2)*/
	_tmp19 = NULL;
	_tmp20 = NULL;
	ccall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("strcmp"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("str1")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("str2")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	/* return strcmp (str1, str2);*/
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp23 = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cineq == NULL) ? NULL : (cineq = (vala_ccode_node_unref (cineq), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file) {
	ValaCCodeBaseModule * self;
	ValaCCodeDeclarationSpace* _tmp0;
	ValaCCodeDeclarationSpace* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	GeeSet* _tmp5;
	GeeSet* _tmp6;
	GeeList* used_includes;
	char* _tmp54;
	char* _tmp55;
	char* header_define;
	gboolean _tmp57;
	ValaCCodeComment* comment;
	char* _tmp127;
	ValaCCodeWriter* _tmp128;
	ValaCCodeWriter* writer;
	ValaCCodeDeclarationSpace* _tmp130;
	ValaCCodeDeclarationSpace* _tmp131;
	ValaCCodeFragment* _tmp132;
	ValaCCodeFragment* _tmp133;
	ValaCCodeFragment* _tmp134;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0 = NULL;
	self->header_declarations = (_tmp0 = vala_ccode_declaration_space_new (), (self->header_declarations == NULL) ? NULL : (self->header_declarations = (vala_ccode_declaration_space_unref (self->header_declarations), NULL)), _tmp0);
	_tmp1 = NULL;
	self->source_declarations = (_tmp1 = vala_ccode_declaration_space_new (), (self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL)), _tmp1);
	_tmp2 = NULL;
	self->source_type_member_definition = (_tmp2 = vala_ccode_fragment_new (), (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp2);
	_tmp3 = NULL;
	self->source_signal_marshaller_definition = (_tmp3 = vala_ccode_fragment_new (), (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp3);
	_tmp4 = NULL;
	self->source_signal_marshaller_declaration = (_tmp4 = vala_ccode_fragment_new (), (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp4);
	_tmp5 = NULL;
	self->user_marshal_set = (_tmp5 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL)), _tmp5);
	self->next_temp_var_id = 0;
	gee_map_clear (self->variable_name_map);
	self->string_h_needed = FALSE;
	self->gvaluecollector_h_needed = FALSE;
	self->gio_h_needed = FALSE;
	self->dbus_glib_h_needed = FALSE;
	self->dbus_glib_h_needed_in_header = FALSE;
	self->requires_free_checked = FALSE;
	self->requires_array_free = FALSE;
	self->requires_array_move = FALSE;
	self->requires_array_length = FALSE;
	self->requires_strcmp0 = FALSE;
	_tmp6 = NULL;
	self->wrappers = (_tmp6 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL)), _tmp6);
	vala_ccode_declaration_space_add_include (self->header_declarations, "glib.h", FALSE);
	vala_ccode_declaration_space_add_include (self->header_declarations, "glib-object.h", FALSE);
	if (vala_code_context_get_legacy_headers (self->priv->_context)) {
		gboolean _tmp7;
		_tmp7 = FALSE;
		if (vala_code_context_get_basedir (self->priv->_context) != NULL) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_code_context_get_library (self->priv->_context) != NULL;
		}
		if (_tmp7) {
			char* _tmp8;
			_tmp8 = NULL;
			vala_ccode_declaration_space_add_include (self->source_declarations, _tmp8 = vala_source_file_get_cinclude_filename (source_file), FALSE);
			_tmp8 = (g_free (_tmp8), NULL);
		} else {
			char* _tmp9;
			_tmp9 = NULL;
			vala_ccode_declaration_space_add_include (self->source_declarations, _tmp9 = vala_source_file_get_cinclude_filename (source_file), TRUE);
			_tmp9 = (g_free (_tmp9), NULL);
		}
	}
	used_includes = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	gee_collection_add ((GeeCollection*) used_includes, "glib.h");
	gee_collection_add ((GeeCollection*) used_includes, "glib-object.h");
	if (vala_code_context_get_legacy_headers (self->priv->_context)) {
		char* _tmp10;
		_tmp10 = NULL;
		gee_collection_add ((GeeCollection*) used_includes, _tmp10 = vala_source_file_get_cinclude_filename (source_file));
		_tmp10 = (g_free (_tmp10), NULL);
		{
			GeeList* _tmp11;
			GeeIterator* _tmp12;
			GeeIterator* _filename_it;
			_tmp11 = NULL;
			_tmp12 = NULL;
			_filename_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_source_file_get_header_external_includes (source_file))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
			while (gee_iterator_next (_filename_it)) {
				char* filename;
				filename = (char*) gee_iterator_get (_filename_it);
				if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
					vala_ccode_declaration_space_add_include (self->header_declarations, filename, FALSE);
					gee_collection_add ((GeeCollection*) used_includes, filename);
				}
				filename = (g_free (filename), NULL);
			}
			(_filename_it == NULL) ? NULL : (_filename_it = (gee_collection_object_unref (_filename_it), NULL));
		}
		{
			GeeList* _tmp13;
			GeeIterator* _tmp14;
			GeeIterator* _filename_it;
			_tmp13 = NULL;
			_tmp14 = NULL;
			_filename_it = (_tmp14 = gee_iterable_iterator ((GeeIterable*) (_tmp13 = vala_source_file_get_header_internal_includes (source_file))), (_tmp13 == NULL) ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)), _tmp14);
			while (gee_iterator_next (_filename_it)) {
				char* filename;
				filename = (char*) gee_iterator_get (_filename_it);
				if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
					vala_ccode_declaration_space_add_include (self->header_declarations, filename, vala_code_context_get_library (self->priv->_context) == NULL);
					gee_collection_add ((GeeCollection*) used_includes, filename);
				}
				filename = (g_free (filename), NULL);
			}
			(_filename_it == NULL) ? NULL : (_filename_it = (gee_collection_object_unref (_filename_it), NULL));
		}
		{
			GeeList* _tmp15;
			GeeIterator* _tmp16;
			GeeIterator* _filename_it;
			_tmp15 = NULL;
			_tmp16 = NULL;
			_filename_it = (_tmp16 = gee_iterable_iterator ((GeeIterable*) (_tmp15 = vala_source_file_get_source_external_includes (source_file))), (_tmp15 == NULL) ? NULL : (_tmp15 = (gee_collection_object_unref (_tmp15), NULL)), _tmp16);
			while (gee_iterator_next (_filename_it)) {
				char* filename;
				filename = (char*) gee_iterator_get (_filename_it);
				if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
					vala_ccode_declaration_space_add_include (self->source_declarations, filename, FALSE);
					gee_collection_add ((GeeCollection*) used_includes, filename);
				}
				filename = (g_free (filename), NULL);
			}
			(_filename_it == NULL) ? NULL : (_filename_it = (gee_collection_object_unref (_filename_it), NULL));
		}
		{
			GeeList* _tmp17;
			GeeIterator* _tmp18;
			GeeIterator* _filename_it;
			_tmp17 = NULL;
			_tmp18 = NULL;
			_filename_it = (_tmp18 = gee_iterable_iterator ((GeeIterable*) (_tmp17 = vala_source_file_get_source_internal_includes (source_file))), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp18);
			while (gee_iterator_next (_filename_it)) {
				char* filename;
				filename = (char*) gee_iterator_get (_filename_it);
				if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
					vala_ccode_declaration_space_add_include (self->source_declarations, filename, vala_code_context_get_library (self->priv->_context) == NULL);
					gee_collection_add ((GeeCollection*) used_includes, filename);
				}
				filename = (g_free (filename), NULL);
			}
			(_filename_it == NULL) ? NULL : (_filename_it = (gee_collection_object_unref (_filename_it), NULL));
		}
		if (vala_source_file_get_is_cycle_head (source_file)) {
			{
				GeeIterator* _cycle_file_it;
				_cycle_file_it = gee_iterable_iterator ((GeeIterable*) vala_source_file_get_cycle (source_file)->files);
				while (gee_iterator_next (_cycle_file_it)) {
					ValaSourceFile* _tmp19;
					ValaSourceFile* cycle_file;
					_tmp19 = NULL;
					cycle_file = (_tmp19 = (ValaSourceFile*) gee_iterator_get (_cycle_file_it), (_tmp19 == NULL) ? NULL : vala_source_file_ref (_tmp19));
					{
						GeeList* _tmp20;
						GeeIterator* _tmp21;
						GeeIterator* _node_it;
						_tmp20 = NULL;
						_tmp21 = NULL;
						_node_it = (_tmp21 = gee_iterable_iterator ((GeeIterable*) (_tmp20 = vala_source_file_get_nodes (cycle_file))), (_tmp20 == NULL) ? NULL : (_tmp20 = (gee_collection_object_unref (_tmp20), NULL)), _tmp21);
						while (gee_iterator_next (_node_it)) {
							ValaCodeNode* node;
							node = (ValaCodeNode*) gee_iterator_get (_node_it);
							if (VALA_IS_STRUCT (node)) {
								ValaStruct* _tmp22;
								ValaStruct* st;
								ValaCCodeTypeDefinition* _tmp27;
								ValaCCodeVariableDeclarator* _tmp26;
								char* _tmp25;
								char* _tmp24;
								char* _tmp23;
								_tmp22 = NULL;
								st = (_tmp22 = VALA_STRUCT (node), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
								_tmp27 = NULL;
								_tmp26 = NULL;
								_tmp25 = NULL;
								_tmp24 = NULL;
								_tmp23 = NULL;
								vala_ccode_declaration_space_add_type_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp27 = vala_ccode_type_definition_new (_tmp24 = g_strdup_printf ("struct _%s", _tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), (ValaCCodeDeclarator*) (_tmp26 = vala_ccode_variable_declarator_new (_tmp25 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL)))));
								(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
								(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
								_tmp25 = (g_free (_tmp25), NULL);
								_tmp24 = (g_free (_tmp24), NULL);
								_tmp23 = (g_free (_tmp23), NULL);
								(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							} else {
								if (VALA_IS_CLASS (node)) {
									ValaClass* _tmp28;
									ValaClass* cl;
									ValaCCodeTypeDefinition* _tmp33;
									ValaCCodeVariableDeclarator* _tmp32;
									char* _tmp31;
									char* _tmp30;
									char* _tmp29;
									ValaCCodeTypeDefinition* _tmp39;
									ValaCCodeVariableDeclarator* _tmp38;
									char* _tmp37;
									char* _tmp36;
									char* _tmp35;
									char* _tmp34;
									_tmp28 = NULL;
									cl = (_tmp28 = VALA_CLASS (node), (_tmp28 == NULL) ? NULL : vala_code_node_ref (_tmp28));
									_tmp33 = NULL;
									_tmp32 = NULL;
									_tmp31 = NULL;
									_tmp30 = NULL;
									_tmp29 = NULL;
									vala_ccode_declaration_space_add_type_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp33 = vala_ccode_type_definition_new (_tmp30 = g_strdup_printf ("struct _%s", _tmp29 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp32 = vala_ccode_variable_declarator_new (_tmp31 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), NULL)))));
									(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
									(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
									_tmp31 = (g_free (_tmp31), NULL);
									_tmp30 = (g_free (_tmp30), NULL);
									_tmp29 = (g_free (_tmp29), NULL);
									_tmp39 = NULL;
									_tmp38 = NULL;
									_tmp37 = NULL;
									_tmp36 = NULL;
									_tmp35 = NULL;
									_tmp34 = NULL;
									vala_ccode_declaration_space_add_type_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp39 = vala_ccode_type_definition_new (_tmp35 = g_strdup_printf ("struct _%sClass", _tmp34 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp38 = vala_ccode_variable_declarator_new (_tmp37 = g_strdup_printf ("%sClass", _tmp36 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), NULL)))));
									(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
									(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
									_tmp37 = (g_free (_tmp37), NULL);
									_tmp36 = (g_free (_tmp36), NULL);
									_tmp35 = (g_free (_tmp35), NULL);
									_tmp34 = (g_free (_tmp34), NULL);
									(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
								} else {
									if (VALA_IS_INTERFACE (node)) {
										ValaInterface* _tmp40;
										ValaInterface* iface;
										ValaCCodeTypeDefinition* _tmp45;
										ValaCCodeVariableDeclarator* _tmp44;
										char* _tmp43;
										char* _tmp42;
										char* _tmp41;
										ValaCCodeTypeDefinition* _tmp50;
										ValaCCodeVariableDeclarator* _tmp49;
										char* _tmp48;
										char* _tmp47;
										char* _tmp46;
										_tmp40 = NULL;
										iface = (_tmp40 = VALA_INTERFACE (node), (_tmp40 == NULL) ? NULL : vala_code_node_ref (_tmp40));
										_tmp45 = NULL;
										_tmp44 = NULL;
										_tmp43 = NULL;
										_tmp42 = NULL;
										_tmp41 = NULL;
										vala_ccode_declaration_space_add_type_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp45 = vala_ccode_type_definition_new (_tmp42 = g_strdup_printf ("struct _%s", _tmp41 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), (ValaCCodeDeclarator*) (_tmp44 = vala_ccode_variable_declarator_new (_tmp43 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), NULL)))));
										(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
										(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
										_tmp43 = (g_free (_tmp43), NULL);
										_tmp42 = (g_free (_tmp42), NULL);
										_tmp41 = (g_free (_tmp41), NULL);
										_tmp50 = NULL;
										_tmp49 = NULL;
										_tmp48 = NULL;
										_tmp47 = NULL;
										_tmp46 = NULL;
										vala_ccode_declaration_space_add_type_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp50 = vala_ccode_type_definition_new (_tmp47 = g_strdup_printf ("struct _%s", _tmp46 = vala_interface_get_type_cname (iface)), (ValaCCodeDeclarator*) (_tmp49 = vala_ccode_variable_declarator_new (_tmp48 = vala_interface_get_type_cname (iface), NULL)))));
										(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
										(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
										_tmp48 = (g_free (_tmp48), NULL);
										_tmp47 = (g_free (_tmp47), NULL);
										_tmp46 = (g_free (_tmp46), NULL);
										(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
									}
								}
							}
							(node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL));
						}
						(_node_it == NULL) ? NULL : (_node_it = (gee_collection_object_unref (_node_it), NULL));
					}
					(cycle_file == NULL) ? NULL : (cycle_file = (vala_source_file_unref (cycle_file), NULL));
				}
				(_cycle_file_it == NULL) ? NULL : (_cycle_file_it = (gee_collection_object_unref (_cycle_file_it), NULL));
			}
		}
	}
	{
		GeeSet* _tmp51;
		GeeIterator* _tmp52;
		GeeIterator* _symbol_it;
		_tmp51 = NULL;
		_tmp52 = NULL;
		_symbol_it = (_tmp52 = gee_iterable_iterator ((GeeIterable*) (_tmp51 = vala_source_file_get_source_symbol_dependencies (source_file))), (_tmp51 == NULL) ? NULL : (_tmp51 = (gee_collection_object_unref (_tmp51), NULL)), _tmp52);
		while (gee_iterator_next (_symbol_it)) {
			ValaSymbol* symbol;
			gboolean _tmp53;
			symbol = (ValaSymbol*) gee_iterator_get (_symbol_it);
			_tmp53 = FALSE;
			if (!vala_symbol_get_external (symbol)) {
				_tmp53 = vala_symbol_get_external_package (symbol);
			} else {
				_tmp53 = FALSE;
			}
			if (_tmp53) {
				vala_code_node_accept ((ValaCodeNode*) symbol, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			}
			(symbol == NULL) ? NULL : (symbol = (vala_code_node_unref (symbol), NULL));
		}
		(_symbol_it == NULL) ? NULL : (_symbol_it = (gee_collection_object_unref (_symbol_it), NULL));
	}
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->_context)) > 0) {
		(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
		return;
	}
	_tmp54 = NULL;
	_tmp55 = NULL;
	header_define = (_tmp55 = vala_ccode_base_module_get_define_for_filename (_tmp54 = vala_source_file_get_cinclude_filename (source_file)), _tmp54 = (g_free (_tmp54), NULL), _tmp55);
	/* generate hardcoded "well-known" macros */
	if (self->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp56;
		_tmp56 = NULL;
		vala_ccode_declaration_space_add_begin (self->source_declarations, (ValaCCodeNode*) (_tmp56 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))")));
		(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	}
	if (self->requires_array_free) {
		vala_ccode_base_module_append_vala_array_free (self);
	}
	if (self->requires_array_move) {
		vala_ccode_base_module_append_vala_array_move (self);
	}
	if (self->requires_array_length) {
		vala_ccode_base_module_append_vala_array_length (self);
	}
	if (self->requires_strcmp0) {
		vala_ccode_base_module_append_vala_strcmp0 (self);
	}
	if (self->string_h_needed) {
		vala_ccode_declaration_space_add_include (self->source_declarations, "string.h", FALSE);
	}
	if (self->gvaluecollector_h_needed) {
		vala_ccode_declaration_space_add_include (self->source_declarations, "gobject/gvaluecollector.h", FALSE);
	}
	if (self->gio_h_needed) {
		vala_ccode_declaration_space_add_include (self->header_declarations, "gio/gio.h", FALSE);
	}
	if (self->dbus_glib_h_needed_in_header) {
		vala_ccode_declaration_space_add_include (self->header_declarations, "dbus/dbus.h", FALSE);
		vala_ccode_declaration_space_add_include (self->header_declarations, "dbus/dbus-glib.h", FALSE);
		vala_ccode_declaration_space_add_include (self->header_declarations, "dbus/dbus-glib-lowlevel.h", FALSE);
	} else {
		if (self->dbus_glib_h_needed) {
			vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus.h", FALSE);
			vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus-glib.h", FALSE);
			vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus-glib-lowlevel.h", FALSE);
		}
	}
	_tmp57 = FALSE;
	if (self->dbus_glib_h_needed_in_header) {
		_tmp57 = TRUE;
	} else {
		_tmp57 = self->dbus_glib_h_needed;
	}
	if (_tmp57) {
		ValaCCodeStruct* dbusvtable;
		ValaCCodeTypeDefinition* _tmp59;
		ValaCCodeVariableDeclarator* _tmp58;
		ValaCCodeFunction* cfunc;
		ValaCCodeFormalParameter* _tmp60;
		ValaCCodeFormalParameter* _tmp61;
		ValaCCodeFormalParameter* _tmp62;
		ValaCCodeFunction* _tmp63;
		ValaCCodeBlock* block;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp64;
		ValaCCodeIdentifier* _tmp65;
		ValaCCodeFunctionCall* _tmp66;
		ValaCCodeFunctionCall* quark;
		ValaCCodeConstant* _tmp67;
		ValaCCodeIdentifier* _tmp68;
		ValaCCodeFunctionCall* _tmp69;
		ValaCCodeFunctionCall* get_qdata;
		ValaCCodeIdentifier* _tmp70;
		ValaCCodeExpressionStatement* _tmp73;
		ValaCCodeAssignment* _tmp72;
		ValaCCodeIdentifier* _tmp71;
		ValaCCodeMemberAccess* _tmp75;
		ValaCCodeIdentifier* _tmp74;
		ValaCCodeFunctionCall* _tmp76;
		ValaCCodeFunctionCall* cregister;
		ValaCCodeIdentifier* _tmp77;
		ValaCCodeIdentifier* _tmp78;
		ValaCCodeIdentifier* _tmp79;
		ValaCCodeBlock* ifblock;
		ValaCCodeExpressionStatement* _tmp80;
		ValaCCodeBlock* elseblock;
		ValaCCodeIdentifier* _tmp81;
		ValaCCodeFunctionCall* _tmp82;
		ValaCCodeFunctionCall* warn;
		ValaCCodeConstant* _tmp83;
		ValaCCodeExpressionStatement* _tmp84;
		ValaCCodeIfStatement* _tmp86;
		ValaCCodeIdentifier* _tmp85;
		ValaCCodeFunction* _tmp87;
		ValaCCodeFormalParameter* _tmp88;
		ValaCCodeFormalParameter* _tmp89;
		ValaCCodeFunction* _tmp90;
		ValaCCodeBlock* _tmp91;
		ValaCCodeDeclaration* _tmp92;
		ValaCCodeVariableDeclarator* _tmp93;
		ValaCCodeIdentifier* _tmp94;
		ValaCCodeFunctionCall* _tmp95;
		ValaCCodeFunctionCall* path;
		ValaCCodeCastExpression* _tmp97;
		ValaCCodeIdentifier* _tmp96;
		ValaCCodeConstant* _tmp98;
		ValaCCodeExpressionStatement* _tmp101;
		ValaCCodeAssignment* _tmp100;
		ValaCCodeIdentifier* _tmp99;
		ValaCCodeIdentifier* _tmp102;
		ValaCCodeFunctionCall* _tmp103;
		ValaCCodeFunctionCall* unregister_call;
		ValaCCodeIdentifier* _tmp104;
		ValaCCodeIdentifier* _tmp105;
		ValaCCodeExpressionStatement* _tmp106;
		ValaCCodeIdentifier* _tmp107;
		ValaCCodeFunctionCall* _tmp108;
		ValaCCodeFunctionCall* path_free;
		ValaCCodeIdentifier* _tmp109;
		ValaCCodeExpressionStatement* _tmp110;
		dbusvtable = vala_ccode_struct_new ("_DBusObjectVTable");
		vala_ccode_struct_add_field (dbusvtable, "void", "(*register_object) (DBusConnection*, const char*, void*)");
		vala_ccode_declaration_space_add_type_definition (self->source_declarations, (ValaCCodeNode*) dbusvtable);
		_tmp59 = NULL;
		_tmp58 = NULL;
		vala_ccode_declaration_space_add_type_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp59 = vala_ccode_type_definition_new ("struct _DBusObjectVTable", (ValaCCodeDeclarator*) (_tmp58 = vala_ccode_variable_declarator_new ("_DBusObjectVTable", NULL)))));
		(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
		(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
		cfunc = vala_ccode_function_new ("_vala_dbus_register_object", "void");
		_tmp60 = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp60 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
		(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		_tmp61 = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp61 = vala_ccode_formal_parameter_new ("path", "const char*"));
		(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
		_tmp62 = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp62 = vala_ccode_formal_parameter_new ("object", "void*"));
		(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp63 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp63 = vala_ccode_function_copy (cfunc)));
		(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (cfunc, block);
		cdecl_ = vala_ccode_declaration_new ("const _DBusObjectVTable *");
		_tmp64 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp64 = vala_ccode_variable_declarator_new ("vtable", NULL)));
		(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
		_tmp65 = NULL;
		_tmp66 = NULL;
		quark = (_tmp66 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)), _tmp66);
		_tmp67 = NULL;
		vala_ccode_function_call_add_argument (quark, (ValaCCodeExpression*) (_tmp67 = vala_ccode_constant_new ("\"DBusObjectVTable\"")));
		(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
		_tmp68 = NULL;
		_tmp69 = NULL;
		get_qdata = (_tmp69 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("g_type_get_qdata"))), (_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)), _tmp69);
		_tmp70 = NULL;
		vala_ccode_function_call_add_argument (get_qdata, (ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE (object)")));
		(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
		vala_ccode_function_call_add_argument (get_qdata, (ValaCCodeExpression*) quark);
		_tmp73 = NULL;
		_tmp72 = NULL;
		_tmp71 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp73 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp71 = vala_ccode_identifier_new ("vtable")), (ValaCCodeExpression*) get_qdata, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
		(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		_tmp75 = NULL;
		_tmp74 = NULL;
		_tmp76 = NULL;
		cregister = (_tmp76 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new ("vtable")), "register_object"))), (_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)), (_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)), _tmp76);
		_tmp77 = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("connection")));
		(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
		_tmp78 = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new ("path")));
		(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
		_tmp79 = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp79 = vala_ccode_identifier_new ("object")));
		(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
		ifblock = vala_ccode_block_new ();
		_tmp80 = NULL;
		vala_ccode_block_add_statement (ifblock, (ValaCCodeNode*) (_tmp80 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cregister)));
		(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
		elseblock = vala_ccode_block_new ();
		_tmp81 = NULL;
		_tmp82 = NULL;
		warn = (_tmp82 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new ("g_warning"))), (_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)), _tmp82);
		_tmp83 = NULL;
		vala_ccode_function_call_add_argument (warn, (ValaCCodeExpression*) (_tmp83 = vala_ccode_constant_new ("\"Object does not implement any D-Bus interface\"")));
		(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		_tmp84 = NULL;
		vala_ccode_block_add_statement (elseblock, (ValaCCodeNode*) (_tmp84 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) warn)));
		(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
		_tmp86 = NULL;
		_tmp85 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp86 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("vtable")), (ValaCCodeStatement*) ifblock, (ValaCCodeStatement*) elseblock)));
		(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
		(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) cfunc);
		/* unregister function*/
		_tmp87 = NULL;
		cfunc = (_tmp87 = vala_ccode_function_new ("_vala_dbus_unregister_object", "void"), (cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL)), _tmp87);
		_tmp88 = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp88 = vala_ccode_formal_parameter_new ("connection", "gpointer"));
		(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
		_tmp89 = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp89 = vala_ccode_formal_parameter_new ("object", "GObject*"));
		(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp90 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp90 = vala_ccode_function_copy (cfunc)));
		(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
		_tmp91 = NULL;
		block = (_tmp91 = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp91);
		vala_ccode_function_set_block (cfunc, block);
		_tmp92 = NULL;
		cdecl_ = (_tmp92 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp92);
		_tmp93 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp93 = vala_ccode_variable_declarator_new ("path", NULL)));
		(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
		_tmp94 = NULL;
		_tmp95 = NULL;
		path = (_tmp95 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("g_object_steal_data"))), (_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)), _tmp95);
		_tmp97 = NULL;
		_tmp96 = NULL;
		vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp97 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new ("object")), "GObject*")));
		(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
		(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
		_tmp98 = NULL;
		vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp98 = vala_ccode_constant_new ("\"dbus_object_path\"")));
		(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
		_tmp101 = NULL;
		_tmp100 = NULL;
		_tmp99 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp101 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new ("path")), (ValaCCodeExpression*) path, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
		(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
		(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
		_tmp102 = NULL;
		_tmp103 = NULL;
		unregister_call = (_tmp103 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("dbus_connection_unregister_object_path"))), (_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)), _tmp103);
		_tmp104 = NULL;
		vala_ccode_function_call_add_argument (unregister_call, (ValaCCodeExpression*) (_tmp104 = vala_ccode_identifier_new ("connection")));
		(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
		_tmp105 = NULL;
		vala_ccode_function_call_add_argument (unregister_call, (ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new ("path")));
		(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
		_tmp106 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp106 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) unregister_call)));
		(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
		_tmp107 = NULL;
		_tmp108 = NULL;
		path_free = (_tmp108 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp107 = vala_ccode_identifier_new ("g_free"))), (_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)), _tmp108);
		_tmp109 = NULL;
		vala_ccode_function_call_add_argument (path_free, (ValaCCodeExpression*) (_tmp109 = vala_ccode_identifier_new ("path")));
		(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
		_tmp110 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp110 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) path_free)));
		(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) cfunc);
		(dbusvtable == NULL) ? NULL : (dbusvtable = (vala_ccode_node_unref (dbusvtable), NULL));
		(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		(quark == NULL) ? NULL : (quark = (vala_ccode_node_unref (quark), NULL));
		(get_qdata == NULL) ? NULL : (get_qdata = (vala_ccode_node_unref (get_qdata), NULL));
		(cregister == NULL) ? NULL : (cregister = (vala_ccode_node_unref (cregister), NULL));
		(ifblock == NULL) ? NULL : (ifblock = (vala_ccode_node_unref (ifblock), NULL));
		(elseblock == NULL) ? NULL : (elseblock = (vala_ccode_node_unref (elseblock), NULL));
		(warn == NULL) ? NULL : (warn = (vala_ccode_node_unref (warn), NULL));
		(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
		(unregister_call == NULL) ? NULL : (unregister_call = (vala_ccode_node_unref (unregister_call), NULL));
		(path_free == NULL) ? NULL : (path_free = (vala_ccode_node_unref (path_free), NULL));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp111;
		_tmp111 = NULL;
		comment = (_tmp111 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)), _tmp111);
	}
	if (vala_code_context_get_legacy_headers (self->priv->_context)) {
		char* _tmp112;
		ValaCCodeWriter* _tmp113;
		ValaCCodeWriter* writer;
		ValaCCodeOnceSection* once;
		ValaCCodeNewline* _tmp115;
		ValaCCodeNewline* _tmp116;
		ValaCCodeIdentifier* _tmp117;
		ValaCCodeNewline* _tmp118;
		ValaCCodeNewline* _tmp119;
		ValaCCodeNewline* _tmp120;
		ValaCCodeNewline* _tmp121;
		ValaCCodeNewline* _tmp122;
		ValaCCodeNewline* _tmp123;
		ValaCCodeIdentifier* _tmp124;
		ValaCCodeNewline* _tmp125;
		ValaCCodeNewline* _tmp126;
		_tmp112 = NULL;
		_tmp113 = NULL;
		writer = (_tmp113 = vala_ccode_writer_new (_tmp112 = vala_source_file_get_cheader_filename (source_file)), _tmp112 = (g_free (_tmp112), NULL), _tmp113);
		if (!vala_ccode_writer_open (writer)) {
			char* _tmp114;
			_tmp114 = NULL;
			vala_report_error (NULL, _tmp114 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
			_tmp114 = (g_free (_tmp114), NULL);
			(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
			(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
			header_define = (g_free (header_define), NULL);
			(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
			return;
		}
		if (comment != NULL) {
			vala_ccode_node_write ((ValaCCodeNode*) comment, writer);
		}
		vala_ccode_writer_write_newline (writer);
		once = vala_ccode_once_section_new (header_define);
		_tmp115 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp115 = vala_ccode_newline_new ()));
		(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->include_directives);
		_tmp116 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp116 = vala_ccode_newline_new ()));
		(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
		_tmp117 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp117 = vala_ccode_identifier_new ("G_BEGIN_DECLS")));
		(_tmp117 == NULL) ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL));
		_tmp118 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp118 = vala_ccode_newline_new ()));
		(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
		_tmp119 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp119 = vala_ccode_newline_new ()));
		(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_declaration);
		_tmp120 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp120 = vala_ccode_newline_new ()));
		(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_definition);
		_tmp121 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp121 = vala_ccode_newline_new ()));
		(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_member_declaration);
		_tmp122 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp122 = vala_ccode_newline_new ()));
		(_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->constant_declaration);
		_tmp123 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp123 = vala_ccode_newline_new ()));
		(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
		_tmp124 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp124 = vala_ccode_identifier_new ("G_END_DECLS")));
		(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
		_tmp125 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp125 = vala_ccode_newline_new ()));
		(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
		_tmp126 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp126 = vala_ccode_newline_new ()));
		(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
		vala_ccode_node_write ((ValaCCodeNode*) once, writer);
		vala_ccode_writer_close (writer);
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
	}
	_tmp127 = NULL;
	_tmp128 = NULL;
	writer = (_tmp128 = vala_ccode_writer_new (_tmp127 = vala_source_file_get_csource_filename (source_file)), _tmp127 = (g_free (_tmp127), NULL), _tmp128);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp129;
		_tmp129 = NULL;
		vala_report_error (NULL, _tmp129 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
		_tmp129 = (g_free (_tmp129), NULL);
		(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
		header_define = (g_free (header_define), NULL);
		(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		return;
	}
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->priv->_context));
	if (comment != NULL) {
		vala_ccode_node_write ((ValaCCodeNode*) comment, writer);
	}
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->begin, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->include_directives, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_declarations->type_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_declarations->type_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_declarations->type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->constant_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_type_member_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp130 = NULL;
	self->header_declarations = (_tmp130 = NULL, (self->header_declarations == NULL) ? NULL : (self->header_declarations = (vala_ccode_declaration_space_unref (self->header_declarations), NULL)), _tmp130);
	_tmp131 = NULL;
	self->source_declarations = (_tmp131 = NULL, (self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL)), _tmp131);
	_tmp132 = NULL;
	self->source_type_member_definition = (_tmp132 = NULL, (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp132);
	_tmp133 = NULL;
	self->source_signal_marshaller_definition = (_tmp133 = NULL, (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp133);
	_tmp134 = NULL;
	self->source_signal_marshaller_declaration = (_tmp134 = NULL, (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp134);
	(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
	header_define = (g_free (header_define), NULL);
	(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
	(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
}


static char* vala_ccode_base_module_get_define_for_filename (const char* filename) {
	GString* define;
	const char* _tmp0;
	char* i;
	const char* _tmp4;
	char* _tmp5;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	_tmp0 = NULL;
	i = (_tmp0 = filename, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		gboolean _tmp1;
		char* _tmp3;
		const char* _tmp2;
		c = g_utf8_get_char (i);
		_tmp1 = FALSE;
		if (g_unichar_isalnum (c)) {
			_tmp1 = c < 0x80;
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		i = (_tmp3 = (_tmp2 = g_utf8_next_char (i), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), i = (g_free (i), NULL), _tmp3);
	}
	g_string_append (define, "__");
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = define->str, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), (define == NULL) ? NULL : (define = (g_string_free (define, TRUE), NULL)), i = (g_free (i), NULL), _tmp5);
}


static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaDataType* _tmp3;
	ValaStruct* _tmp2;
	ValaDataType* _tmp5;
	ValaStruct* _tmp4;
	ValaDataType* _tmp7;
	ValaStruct* _tmp6;
	ValaDataType* _tmp9;
	ValaStruct* _tmp8;
	ValaDataType* _tmp11;
	ValaStruct* _tmp10;
	ValaDataType* _tmp13;
	ValaStruct* _tmp12;
	ValaDataType* _tmp15;
	ValaStruct* _tmp14;
	ValaDataType* _tmp17;
	ValaStruct* _tmp16;
	ValaDataType* _tmp19;
	ValaStruct* _tmp18;
	ValaDataType* _tmp21;
	ValaStruct* _tmp20;
	ValaDataType* _tmp23;
	ValaStruct* _tmp22;
	ValaDataType* _tmp25;
	ValaStruct* _tmp24;
	ValaDataType* _tmp27;
	ValaStruct* _tmp26;
	ValaDataType* _tmp29;
	ValaStruct* _tmp28;
	ValaDataType* _tmp31;
	ValaStruct* _tmp30;
	ValaDataType* _tmp33;
	ValaStruct* _tmp32;
	ValaDataType* _tmp35;
	ValaStruct* _tmp34;
	ValaDataType* _tmp37;
	ValaStruct* _tmp36;
	ValaDataType* _tmp39;
	ValaStruct* _tmp38;
	ValaDataType* _tmp41;
	ValaStruct* _tmp40;
	ValaDataType* _tmp43;
	ValaClass* _tmp42;
	ValaSymbol* glib_ns;
	ValaTypeSymbol* _tmp44;
	ValaTypeSymbol* _tmp45;
	ValaErrorType* _tmp46;
	ValaClass* _tmp47;
	ValaClass* _tmp48;
	ValaTypeSymbol* _tmp49;
	ValaTypeSymbol* _tmp50;
	ValaTypeSymbol* _tmp51;
	ValaTypeSymbol* _tmp52;
	ValaDataType* _tmp54;
	ValaStruct* _tmp53;
	ValaStruct* _tmp55;
	ValaStruct* _tmp56;
	ValaTypeSymbol* _tmp57;
	ValaSymbol* dbus_ns;
	GeeList* source_files;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (context != NULL);
	vala_ccode_base_module_set_context (self, context);
	if (vala_code_context_get_legacy_headers (context)) {
		vala_code_context_find_header_cycles (context);
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->root_symbol = (_tmp1 = (_tmp0 = (ValaSymbol*) vala_code_context_get_root (context), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->bool_type = (_tmp3 = (ValaDataType*) vala_boolean_type_new (_tmp2 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))), (self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)), _tmp3);
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->char_type = (_tmp5 = (ValaDataType*) vala_integer_type_new (_tmp4 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "char")), NULL, NULL), (self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL)), _tmp5);
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->uchar_type = (_tmp7 = (ValaDataType*) vala_integer_type_new (_tmp6 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar")), NULL, NULL), (self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)), _tmp7);
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->unichar_type = (_tmp9 = (ValaDataType*) vala_integer_type_new (_tmp8 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar")), NULL, NULL), (self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)), _tmp9);
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->short_type = (_tmp11 = (ValaDataType*) vala_integer_type_new (_tmp10 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short")), NULL, NULL), (self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->ushort_type = (_tmp13 = (ValaDataType*) vala_integer_type_new (_tmp12 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort")), NULL, NULL), (self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)), _tmp13);
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->int_type = (_tmp15 = (ValaDataType*) vala_integer_type_new (_tmp14 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int")), NULL, NULL), (self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)), _tmp15);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->uint_type = (_tmp17 = (ValaDataType*) vala_integer_type_new (_tmp16 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint")), NULL, NULL), (self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->long_type = (_tmp19 = (ValaDataType*) vala_integer_type_new (_tmp18 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long")), NULL, NULL), (self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)), _tmp19);
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->ulong_type = (_tmp21 = (ValaDataType*) vala_integer_type_new (_tmp20 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong")), NULL, NULL), (self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)), _tmp21);
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->int8_type = (_tmp23 = (ValaDataType*) vala_integer_type_new (_tmp22 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8")), NULL, NULL), (self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)), _tmp23);
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint8_type = (_tmp25 = (ValaDataType*) vala_integer_type_new (_tmp24 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint8")), NULL, NULL), (self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL)), _tmp25);
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->int16_type = (_tmp27 = (ValaDataType*) vala_integer_type_new (_tmp26 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int16")), NULL, NULL), (self->int16_type == NULL) ? NULL : (self->int16_type = (vala_code_node_unref (self->int16_type), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->uint16_type = (_tmp29 = (ValaDataType*) vala_integer_type_new (_tmp28 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint16")), NULL, NULL), (self->uint16_type == NULL) ? NULL : (self->uint16_type = (vala_code_node_unref (self->uint16_type), NULL)), _tmp29);
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_code_node_unref (_tmp28), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->int32_type = (_tmp31 = (ValaDataType*) vala_integer_type_new (_tmp30 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int32")), NULL, NULL), (self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL)), _tmp31);
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	self->uint32_type = (_tmp33 = (ValaDataType*) vala_integer_type_new (_tmp32 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint32")), NULL, NULL), (self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL)), _tmp33);
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL));
	_tmp35 = NULL;
	_tmp34 = NULL;
	self->int64_type = (_tmp35 = (ValaDataType*) vala_integer_type_new (_tmp34 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int64")), NULL, NULL), (self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL)), _tmp35);
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL));
	_tmp37 = NULL;
	_tmp36 = NULL;
	self->uint64_type = (_tmp37 = (ValaDataType*) vala_integer_type_new (_tmp36 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64")), NULL, NULL), (self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)), _tmp37);
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL));
	_tmp39 = NULL;
	_tmp38 = NULL;
	self->float_type = (_tmp39 = (ValaDataType*) vala_floating_type_new (_tmp38 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "float"))), (self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL)), _tmp39);
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_code_node_unref (_tmp38), NULL));
	_tmp41 = NULL;
	_tmp40 = NULL;
	self->double_type = (_tmp41 = (ValaDataType*) vala_floating_type_new (_tmp40 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))), (self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)), _tmp41);
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_code_node_unref (_tmp40), NULL));
	_tmp43 = NULL;
	_tmp42 = NULL;
	self->string_type = (_tmp43 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp42 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))), (self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)), _tmp43);
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_code_node_unref (_tmp42), NULL));
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	_tmp44 = NULL;
	self->gtype_type = (_tmp44 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), (self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL)), _tmp44);
	_tmp45 = NULL;
	self->gobject_type = (_tmp45 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL)), _tmp45);
	_tmp46 = NULL;
	self->gerror_type = (_tmp46 = vala_error_type_new (NULL, NULL, NULL), (self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)), _tmp46);
	_tmp47 = NULL;
	self->glist_type = (_tmp47 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)), _tmp47);
	_tmp48 = NULL;
	self->gslist_type = (_tmp48 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)), _tmp48);
	_tmp49 = NULL;
	self->gstringbuilder_type = (_tmp49 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StringBuilder")), (self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL)), _tmp49);
	_tmp50 = NULL;
	self->garray_type = (_tmp50 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)), _tmp50);
	_tmp51 = NULL;
	self->gbytearray_type = (_tmp51 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "ByteArray")), (self->gbytearray_type == NULL) ? NULL : (self->gbytearray_type = (vala_code_node_unref (self->gbytearray_type), NULL)), _tmp51);
	_tmp52 = NULL;
	self->gptrarray_type = (_tmp52 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "PtrArray")), (self->gptrarray_type == NULL) ? NULL : (self->gptrarray_type = (vala_code_node_unref (self->gptrarray_type), NULL)), _tmp52);
	_tmp54 = NULL;
	_tmp53 = NULL;
	self->gquark_type = (_tmp54 = (ValaDataType*) vala_integer_type_new (_tmp53 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark")), NULL, NULL), (self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL)), _tmp54);
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_code_node_unref (_tmp53), NULL));
	_tmp55 = NULL;
	self->gvalue_type = (_tmp55 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Value")), (self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL)), _tmp55);
	_tmp56 = NULL;
	self->mutex_type = (_tmp56 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StaticRecMutex")), (self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL)), _tmp56);
	_tmp57 = NULL;
	self->type_module_type = (_tmp57 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL)), _tmp57);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp58;
		_tmp58 = NULL;
		self->module_init_fragment = (_tmp58 = vala_ccode_fragment_new (), (self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL)), _tmp58);
		{
			GeeList* _tmp59;
			GeeIterator* _tmp60;
			GeeIterator* _parameter_it;
			_tmp59 = NULL;
			_tmp60 = NULL;
			_parameter_it = (_tmp60 = gee_iterable_iterator ((GeeIterable*) (_tmp59 = vala_method_get_parameters (vala_code_context_get_module_init_method (context)))), (_tmp59 == NULL) ? NULL : (_tmp59 = (gee_collection_object_unref (_tmp59), NULL)), _tmp60);
			while (gee_iterator_next (_parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = (ValaFormalParameter*) gee_iterator_get (_parameter_it);
				if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (parameter)) == self->type_module_type) {
					char* _tmp62;
					const char* _tmp61;
					self->in_plugin = TRUE;
					_tmp62 = NULL;
					_tmp61 = NULL;
					self->module_init_param_name = (_tmp62 = (_tmp61 = vala_symbol_get_name ((ValaSymbol*) parameter), (_tmp61 == NULL) ? NULL : g_strdup (_tmp61)), self->module_init_param_name = (g_free (self->module_init_param_name), NULL), _tmp62);
					(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
					break;
				}
				(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
			}
			(_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL));
		}
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaTypeSymbol* _tmp63;
		_tmp63 = NULL;
		self->dbus_object_type = (_tmp63 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Object")), (self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL)), _tmp63);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeIterator* _file_it;
		_file_it = gee_iterable_iterator ((GeeIterable*) source_files);
		while (gee_iterator_next (_file_it)) {
			ValaSourceFile* file;
			file = (ValaSourceFile*) gee_iterator_get (_file_it);
			if (!vala_source_file_get_external_package (file)) {
				vala_source_file_accept (file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			}
			(file == NULL) ? NULL : (file = (vala_source_file_unref (file), NULL));
		}
		(_file_it == NULL) ? NULL : (_file_it = (gee_collection_object_unref (_file_it), NULL));
	}
	/* generate C header file for public API*/
	if (vala_code_context_get_header_filename (context) != NULL) {
		ValaCCodeWriter* writer;
		char* _tmp65;
		ValaCCodeOnceSection* _tmp66;
		ValaCCodeOnceSection* once;
		ValaCCodeNewline* _tmp67;
		ValaCCodeIdentifier* _tmp68;
		ValaCCodeNewline* _tmp69;
		ValaCCodeNewline* _tmp70;
		ValaCCodeIdentifier* _tmp71;
		ValaCCodeNewline* _tmp72;
		ValaCCodeNewline* _tmp73;
		writer = vala_ccode_writer_new (vala_code_context_get_header_filename (context));
		if (!vala_ccode_writer_open (writer)) {
			char* _tmp64;
			_tmp64 = NULL;
			vala_report_error (NULL, _tmp64 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
			_tmp64 = (g_free (_tmp64), NULL);
			(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
			(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
			(dbus_ns == NULL) ? NULL : (dbus_ns = (vala_code_node_unref (dbus_ns), NULL));
			(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
			return;
		}
		vala_ccode_writer_write_newline (writer);
		_tmp65 = NULL;
		_tmp66 = NULL;
		once = (_tmp66 = vala_ccode_once_section_new (_tmp65 = vala_ccode_base_module_get_define_for_filename (vala_ccode_writer_get_filename (writer))), _tmp65 = (g_free (_tmp65), NULL), _tmp66);
		_tmp67 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp67 = vala_ccode_newline_new ()));
		(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
		_tmp68 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp68 = vala_ccode_identifier_new ("G_BEGIN_DECLS")));
		(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
		_tmp69 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp69 = vala_ccode_newline_new ()));
		(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
		_tmp70 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp70 = vala_ccode_newline_new ()));
		(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
		_tmp71 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp71 = vala_ccode_identifier_new ("G_END_DECLS")));
		(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		_tmp72 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp72 = vala_ccode_newline_new ()));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
		_tmp73 = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp73 = vala_ccode_newline_new ()));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
		vala_ccode_node_write ((ValaCCodeNode*) once, writer);
		vala_ccode_writer_close (writer);
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
	}
	(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
	(dbus_ns == NULL) ? NULL : (dbus_ns = (vala_code_node_unref (dbus_ns), NULL));
	(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
}


static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en) {
	ValaCCodeBaseModule * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	ValaCCodeDeclarationSpace* decl_space;
	ValaCCodeNewline* _tmp7;
	ValaCCodeNewline* _tmp8;
	char* _tmp9;
	char* _tmp10;
	char* macro;
	ValaCCodeMacroReplacement* _tmp12;
	char* _tmp11;
	ValaCCodeInitializerList* clist;
	ValaCCodeInitializerList* clist_ev;
	ValaCCodeInitializerList* _tmp22;
	ValaCCodeConstant* _tmp23;
	ValaCCodeConstant* _tmp24;
	ValaCCodeConstant* _tmp25;
	ValaCCodeVariableDeclarator* enum_decl;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeBlock* type_init;
	char* _tmp28;
	char* _tmp29;
	char* fun_name;
	ValaCCodeFunction* regfun;
	ValaCCodeBlock* regblock;
	ValaCCodeDeclaration* _tmp30;
	char* _tmp31;
	char* _tmp32;
	char* type_id_name;
	ValaCCodeVariableDeclarator* _tmp34;
	ValaCCodeConstant* _tmp33;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp41;
	char* _tmp40;
	char* _tmp39;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpressionStatement* _tmp45;
	ValaCCodeAssignment* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeFunctionCall* _tmp47;
	ValaCCodeFunctionCall* cond;
	ValaCCodeBinaryExpression* _tmp50;
	ValaCCodeConstant* _tmp49;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp52;
	ValaCCodeConstant* _tmp51;
	ValaCCodeNewline* _tmp55;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (en != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->cenum = (_tmp1 = vala_ccode_enum_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)), (self->cenum == NULL) ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	decl_space = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) en) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeDeclarationSpace* _tmp3;
		ValaCCodeDeclarationSpace* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		decl_space = (_tmp3 = (_tmp2 = self->header_declarations, (_tmp2 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp2)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp3);
	} else {
		ValaCCodeDeclarationSpace* _tmp5;
		ValaCCodeDeclarationSpace* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		decl_space = (_tmp5 = (_tmp4 = self->source_declarations, (_tmp4 == NULL) ? NULL : vala_ccode_declaration_space_ref (_tmp4)), (decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL)), _tmp5);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)) != NULL) {
		ValaCCodeComment* _tmp6;
		_tmp6 = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp6 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)))));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) self->cenum);
	_tmp7 = NULL;
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp7 = vala_ccode_newline_new ()));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!vala_enum_get_has_type_id (en)) {
		(decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL));
		return;
	}
	_tmp8 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp8 = vala_ccode_newline_new ()));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp9 = NULL;
	_tmp10 = NULL;
	macro = (_tmp10 = g_strdup_printf ("(%s_get_type ())", _tmp9 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp10);
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp12 = vala_ccode_macro_replacement_new (_tmp11 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) en), macro)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp11 = (g_free (_tmp11), NULL);
	clist = vala_ccode_initializer_list_new ();
	/* or during visit time? */
	clist_ev = NULL;
	{
		GeeList* _tmp13;
		GeeIterator* _tmp14;
		GeeIterator* _ev_it;
		_tmp13 = NULL;
		_tmp14 = NULL;
		_ev_it = (_tmp14 = gee_iterable_iterator ((GeeIterable*) (_tmp13 = vala_enum_get_values (en))), (_tmp13 == NULL) ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)), _tmp14);
		while (gee_iterator_next (_ev_it)) {
			ValaEnumValue* ev;
			ValaCCodeInitializerList* _tmp15;
			ValaCCodeConstant* _tmp17;
			char* _tmp16;
			ValaCCodeIdentifier* _tmp20;
			char* _tmp19;
			char* _tmp18;
			ValaCCodeConstant* _tmp21;
			ev = (ValaEnumValue*) gee_iterator_get (_ev_it);
			_tmp15 = NULL;
			clist_ev = (_tmp15 = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp15);
			_tmp17 = NULL;
			_tmp16 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new (_tmp16 = vala_enum_value_get_cname (ev))));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
			_tmp16 = (g_free (_tmp16), NULL);
			_tmp20 = NULL;
			_tmp19 = NULL;
			_tmp18 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (_tmp19 = g_strdup_printf ("\"%s\"", _tmp18 = vala_enum_value_get_cname (ev)))));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			_tmp19 = (g_free (_tmp19), NULL);
			_tmp18 = (g_free (_tmp18), NULL);
			_tmp21 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp21 = vala_enum_value_get_canonical_cconstant (ev)));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
			(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
		}
		(_ev_it == NULL) ? NULL : (_ev_it = (gee_collection_object_unref (_ev_it), NULL));
	}
	_tmp22 = NULL;
	clist_ev = (_tmp22 = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("0")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp24 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp24 = vala_ccode_constant_new ("NULL")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp25 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new ("NULL")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
	enum_decl = vala_ccode_variable_declarator_new ("values[]", (ValaCCodeExpression*) clist);
	cdecl_ = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeDeclaration* _tmp26;
		_tmp26 = NULL;
		cdecl_ = (_tmp26 = vala_ccode_declaration_new ("const GFlagsValue"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp26);
	} else {
		ValaCCodeDeclaration* _tmp27;
		_tmp27 = NULL;
		cdecl_ = (_tmp27 = vala_ccode_declaration_new ("const GEnumValue"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp27);
	}
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) enum_decl);
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	type_init = vala_ccode_block_new ();
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cdecl_);
	_tmp28 = NULL;
	_tmp29 = NULL;
	fun_name = (_tmp29 = g_strdup_printf ("%s_get_type", _tmp28 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp28 = (g_free (_tmp28), NULL), _tmp29);
	regfun = vala_ccode_function_new (fun_name, "GType");
	regblock = vala_ccode_block_new ();
	_tmp30 = NULL;
	cdecl_ = (_tmp30 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp30);
	_tmp31 = NULL;
	_tmp32 = NULL;
	type_id_name = (_tmp32 = g_strdup_printf ("%s_type_id", _tmp31 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp31 = (g_free (_tmp31), NULL), _tmp32);
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp34 = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) (_tmp33 = vala_ccode_constant_new ("0")))));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) cdecl_);
	reg_call = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeFunctionCall* _tmp36;
		ValaCCodeIdentifier* _tmp35;
		_tmp36 = NULL;
		_tmp35 = NULL;
		reg_call = (_tmp36 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("g_flags_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp36);
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeIdentifier* _tmp37;
		_tmp38 = NULL;
		_tmp37 = NULL;
		reg_call = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_enum_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp38);
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	}
	_tmp41 = NULL;
	_tmp40 = NULL;
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp41 = vala_ccode_constant_new (_tmp40 = g_strdup_printf ("\"%s\"", _tmp39 = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)))));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	_tmp40 = (g_free (_tmp40), NULL);
	_tmp39 = (g_free (_tmp39), NULL);
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("values")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp45 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp46 = NULL;
	_tmp47 = NULL;
	cond = (_tmp47 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("G_UNLIKELY"))), (_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)), _tmp47);
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) (_tmp50 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) (_tmp49 = vala_ccode_constant_new ("0")))));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) type_init, NULL);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) cif);
	_tmp52 = NULL;
	_tmp51 = NULL;
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) (_tmp52 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp51 = vala_ccode_constant_new (type_id_name)))));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) en) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp53;
		_tmp53 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp53 = vala_ccode_function_copy (regfun)));
		(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	} else {
		ValaCCodeFunction* _tmp54;
		_tmp54 = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp54 = vala_ccode_function_copy (regfun)));
		(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	}
	vala_ccode_function_set_block (regfun, regblock);
	_tmp55 = NULL;
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) (_tmp55 = vala_ccode_newline_new ()));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) regfun);
	(decl_space == NULL) ? NULL : (decl_space = (vala_ccode_declaration_space_unref (decl_space), NULL));
	macro = (g_free (macro), NULL);
	(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	(clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL));
	(enum_decl == NULL) ? NULL : (enum_decl = (vala_ccode_node_unref (enum_decl), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL) ? NULL : (regfun = (vala_ccode_node_unref (regfun), NULL));
	(regblock == NULL) ? NULL : (regblock = (vala_ccode_node_unref (regblock), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
	(cond == NULL) ? NULL : (cond = (vala_ccode_node_unref (cond), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (ev != NULL);
	if (vala_enum_value_get_value (ev) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->cenum, _tmp1 = vala_ccode_enum_value_new (_tmp0 = vala_enum_value_get_cname (ev), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept ((ValaCodeNode*) vala_enum_value_get_value (ev), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->cenum, _tmp3 = vala_ccode_enum_value_new (_tmp2 = vala_enum_value_get_cname (ev), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_enum_value_get_value (ev)))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_LOCKABLE (m)) {
		_tmp0 = vala_lockable_get_lock_used (VALA_LOCKABLE (m));
	} else {
		_tmp0 = FALSE;
	}
	/* stuff meant for all lockable members */
	if (_tmp0) {
		ValaCCodeExpression* l;
		ValaCCodeExpression* _tmp3;
		char* _tmp2;
		ValaCCodeMemberAccess* _tmp1;
		char* _tmp5;
		char* _tmp4;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* initf;
		ValaCCodeUnaryExpression* _tmp9;
		ValaCCodeExpressionStatement* _tmp10;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* fc;
		ValaCCodeUnaryExpression* _tmp13;
		l = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		l = (_tmp3 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1 = vala_ccode_member_access_new_pointer (l, "priv")), _tmp2 = vala_ccode_base_module_get_symbol_lock_name (self, (ValaSymbol*) m)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_struct_add_field (self->instance_priv_struct, _tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->mutex_type, FALSE), _tmp5 = vala_ccode_base_module_get_symbol_lock_name (self, (ValaSymbol*) m));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp8 = NULL;
		initf = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_method_get_cname (vala_struct_get_default_construction_method (self->mutex_type))))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp6 = (g_free (_tmp6), NULL), _tmp8);
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (initf, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		_tmp10 = NULL;
		vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) initf)));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		self->requires_free_checked = TRUE;
		_tmp11 = NULL;
		_tmp12 = NULL;
		fc = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_static_rec_mutex_free"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		if (self->instance_finalize_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp14;
			_tmp14 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		}
		(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
		(initf == NULL) ? NULL : (initf = (vala_ccode_node_unref (initf), NULL));
		(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	}
}


static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (c != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_INITIALIZER_LIST (vala_constant_get_initializer (c))) {
		char* _tmp0;
		ValaCCodeDeclaration* _tmp1;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* _tmp5;
		char* _tmp4;
		char* _tmp3;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cdecl_ = (_tmp1 = vala_ccode_declaration_new (_tmp0 = vala_data_type_get_const_cname (vala_constant_get_type_reference (c))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c))) {
			char* _tmp2;
			_tmp2 = NULL;
			arr = (_tmp2 = g_strdup ("[]"), arr = (g_free (arr), NULL), _tmp2);
		}
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp5 = vala_ccode_variable_declarator_new (_tmp4 = g_strdup_printf ("%s%s", _tmp3 = vala_constant_get_cname (c), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c))))));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) c)) {
			vala_ccode_declaration_space_add_constant_declaration (self->header_declarations, (ValaCCodeNode*) cdecl_);
		} else {
			vala_ccode_declaration_space_add_constant_declaration (self->source_declarations, (ValaCCodeNode*) cdecl_);
		}
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		arr = (g_free (arr), NULL);
	} else {
		char* _tmp6;
		ValaCCodeMacroReplacement* _tmp7;
		ValaCCodeMacroReplacement* cdefine;
		_tmp6 = NULL;
		_tmp7 = NULL;
		cdefine = (_tmp7 = vala_ccode_macro_replacement_new_with_expression (_tmp6 = vala_constant_get_cname (c), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c)))), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) c)) {
			vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) cdefine);
		} else {
			vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) cdefine);
		}
		(cdefine == NULL) ? NULL : (cdefine = (vala_ccode_node_unref (cdefine), NULL));
	}
}


static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	char* field_ctype;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (f != NULL);
	vala_ccode_base_module_check_type (self, vala_field_get_field_type (f));
	vala_code_node_accept_children ((ValaCodeNode*) f, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = !vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	is_gtypeinstance = _tmp2;
	lhs = NULL;
	st = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp3;
		_tmp3 = NULL;
		field_ctype = (_tmp3 = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp3);
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp4;
		char* _tmp16;
		gboolean _tmp17;
		gboolean _tmp36;
		_tmp4 = FALSE;
		if (is_gtypeinstance) {
			_tmp4 = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			ValaCCodeStruct* _tmp6;
			ValaCCodeStruct* _tmp5;
			ValaCCodeExpression* _tmp10;
			char* _tmp9;
			ValaCCodeMemberAccess* _tmp8;
			ValaCCodeIdentifier* _tmp7;
			_tmp6 = NULL;
			_tmp5 = NULL;
			st = (_tmp6 = (_tmp5 = self->instance_priv_struct, (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp6);
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			lhs = (_tmp10 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("self")), "priv")), _tmp9 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp10);
			_tmp9 = (g_free (_tmp9), NULL);
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		} else {
			ValaCCodeStruct* _tmp12;
			ValaCCodeStruct* _tmp11;
			ValaCCodeExpression* _tmp15;
			char* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			_tmp12 = NULL;
			_tmp11 = NULL;
			st = (_tmp12 = (_tmp11 = self->instance_struct, (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp12);
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			lhs = (_tmp15 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("self")), _tmp14 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp15);
			_tmp14 = (g_free (_tmp14), NULL);
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		}
		_tmp16 = NULL;
		vala_ccode_struct_add_field (st, field_ctype, _tmp16 = vala_field_get_cname (f));
		_tmp16 = (g_free (_tmp16), NULL);
		_tmp17 = FALSE;
		if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
			_tmp17 = !vala_field_get_no_array_length (f);
		} else {
			_tmp17 = FALSE;
		}
		if (_tmp17) {
			ValaArrayType* _tmp18;
			ValaArrayType* array_type;
			ValaDataType* len_type;
			gboolean _tmp21;
			/* create fields to store array dimensions*/
			_tmp18 = NULL;
			array_type = (_tmp18 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp18 == NULL) ? NULL : vala_code_node_ref (_tmp18));
			len_type = vala_data_type_copy (self->int_type);
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp20;
					char* _tmp19;
					_tmp20 = NULL;
					_tmp19 = NULL;
					vala_ccode_struct_add_field (st, _tmp19 = vala_data_type_get_cname (len_type), _tmp20 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f), dim));
					_tmp20 = (g_free (_tmp20), NULL);
					_tmp19 = (g_free (_tmp19), NULL);
				}
			}
			_tmp21 = FALSE;
			if (vala_array_type_get_rank (array_type) == 1) {
				_tmp21 = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
			} else {
				_tmp21 = FALSE;
			}
			if (_tmp21) {
				char* _tmp23;
				char* _tmp22;
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_struct_add_field (st, _tmp22 = vala_data_type_get_cname (len_type), _tmp23 = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f)));
				_tmp23 = (g_free (_tmp23), NULL);
				_tmp22 = (g_free (_tmp22), NULL);
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
				ValaDelegateType* _tmp24;
				ValaDelegateType* delegate_type;
				_tmp24 = NULL;
				delegate_type = (_tmp24 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
				if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
					char* _tmp25;
					/* create field to store delegate target*/
					_tmp25 = NULL;
					vala_ccode_struct_add_field (st, "gpointer", _tmp25 = vala_ccode_base_module_get_delegate_target_cname (self, vala_symbol_get_name ((ValaSymbol*) f)));
					_tmp25 = (g_free (_tmp25), NULL);
				}
				(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
			}
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp26;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* _tmp28;
			ValaCCodeAssignment* _tmp27;
			gboolean _tmp29;
			gboolean _tmp30;
			_tmp26 = NULL;
			rhs = (_tmp26 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp26 == NULL) ? NULL : vala_ccode_node_ref (_tmp26));
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			_tmp29 = FALSE;
			_tmp30 = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp30 = !vala_field_get_no_array_length (f);
			} else {
				_tmp30 = FALSE;
			}
			if (_tmp30) {
				_tmp29 = VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f));
			} else {
				_tmp29 = FALSE;
			}
			if (_tmp29) {
				ValaArrayType* _tmp31;
				ValaArrayType* array_type;
				ValaMemberAccess* this_access;
				ValaDataType* _tmp32;
				ValaCCodeIdentifier* _tmp33;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp31 = NULL;
				array_type = (_tmp31 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp31 == NULL) ? NULL : vala_code_node_ref (_tmp31));
				this_access = vala_member_access_new_simple ("this", NULL);
				_tmp32 = NULL;
				vala_expression_set_value_type ((ValaExpression*) this_access, _tmp32 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL));
				_tmp33 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp33 = vala_ccode_identifier_new ("self")));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
				sizes = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f)));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp35;
						ValaCCodeAssignment* _tmp34;
						array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaExpression*) ma, dim);
						size = (ValaExpression*) gee_list_get (sizes, dim - 1);
						_tmp35 = NULL;
						_tmp34 = NULL;
						vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp35 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
						(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
						(array_len_lhs == NULL) ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL));
						(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(sizes == NULL) ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL));
			}
			vala_ccode_base_module_append_temp_decl (self, self->instance_init_fragment, (GeeList*) self->temp_vars);
			gee_collection_clear ((GeeCollection*) self->temp_vars);
			(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
		}
		_tmp36 = FALSE;
		if (vala_ccode_base_module_requires_destroy (self, vala_field_get_field_type (f))) {
			_tmp36 = self->instance_finalize_fragment != NULL;
		} else {
			_tmp36 = FALSE;
		}
		if (_tmp36) {
			ValaMemberAccess* this_access;
			ValaDataType* _tmp37;
			ValaStruct* _tmp39;
			ValaSymbol* _tmp38;
			ValaStruct* field_st;
			gboolean _tmp40;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp44;
			ValaCCodeExpression* _tmp43;
			this_access = vala_member_access_new_simple ("this", NULL);
			_tmp37 = NULL;
			vala_expression_set_value_type ((ValaExpression*) this_access, _tmp37 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_code_node_unref (_tmp37), NULL));
			_tmp39 = NULL;
			_tmp38 = NULL;
			field_st = (_tmp39 = (_tmp38 = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_STRUCT (_tmp38) ? ((ValaStruct*) _tmp38) : NULL), (_tmp39 == NULL) ? NULL : vala_code_node_ref (_tmp39));
			_tmp40 = FALSE;
			if (field_st != NULL) {
				_tmp40 = !vala_struct_is_simple_type (field_st);
			} else {
				_tmp40 = FALSE;
			}
			if (_tmp40) {
				ValaCCodeIdentifier* _tmp41;
				_tmp41 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp41 = vala_ccode_identifier_new ("(*self)")));
				(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
			} else {
				ValaCCodeIdentifier* _tmp42;
				_tmp42 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp42 = vala_ccode_identifier_new ("self")));
				(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
			}
			ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
			_tmp44 = NULL;
			_tmp43 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, (ValaCCodeNode*) (_tmp44 = vala_ccode_expression_statement_new (_tmp43 = vala_ccode_base_module_get_unref_expression (self, lhs, vala_field_get_field_type (f), (ValaExpression*) ma))));
			(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
			(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
			(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
			(field_st == NULL) ? NULL : (field_st = (vala_code_node_unref (field_st), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			char* _tmp49;
			if (!is_gtypeinstance) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "class fields are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
				(st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL));
				field_ctype = (g_free (field_ctype), NULL);
				return;
			}
			if (vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeStruct* _tmp46;
				ValaCCodeStruct* _tmp45;
				_tmp46 = NULL;
				_tmp45 = NULL;
				st = (_tmp46 = (_tmp45 = self->type_struct, (_tmp45 == NULL) ? NULL : vala_ccode_node_ref (_tmp45)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp46);
			} else {
				ValaCCodeStruct* _tmp48;
				ValaCCodeStruct* _tmp47;
				_tmp48 = NULL;
				_tmp47 = NULL;
				st = (_tmp48 = (_tmp47 = self->type_priv_struct, (_tmp47 == NULL) ? NULL : vala_ccode_node_ref (_tmp47)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp48);
			}
			_tmp49 = NULL;
			vala_ccode_struct_add_field (st, field_ctype, _tmp49 = vala_field_get_cname (f));
			_tmp49 = (g_free (_tmp49), NULL);
		} else {
			ValaCCodeExpression* _tmp51;
			char* _tmp50;
			char* _tmp54;
			ValaCCodeVariableDeclarator* _tmp55;
			ValaCCodeVariableDeclarator* var_decl;
			ValaCCodeExpression* _tmp56;
			ValaCCodeDeclaration* var_def;
			gboolean _tmp58;
			_tmp51 = NULL;
			_tmp50 = NULL;
			lhs = (_tmp51 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp50 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp51);
			_tmp50 = (g_free (_tmp50), NULL);
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp53;
				char* _tmp52;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp53 = NULL;
				_tmp52 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp53 = vala_ccode_variable_declarator_new (_tmp52 = vala_field_get_cname (f), NULL)));
				(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
				_tmp52 = (g_free (_tmp52), NULL);
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			}
			_tmp54 = NULL;
			_tmp55 = NULL;
			var_decl = (_tmp55 = vala_ccode_variable_declarator_new (_tmp54 = vala_field_get_cname (f), NULL), _tmp54 = (g_free (_tmp54), NULL), _tmp55);
			_tmp56 = NULL;
			vala_ccode_variable_declarator_set_initializer (var_decl, _tmp56 = vala_ccode_base_module_default_value_for_type (self, vala_field_get_field_type (f), TRUE));
			(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp57;
				ValaCCodeExpression* init;
				_tmp57 = NULL;
				init = (_tmp57 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp57 == NULL) ? NULL : vala_ccode_node_ref (_tmp57));
				if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
					vala_ccode_variable_declarator_set_initializer (var_decl, init);
				}
				(init == NULL) ? NULL : (init = (vala_ccode_node_unref (init), NULL));
			}
			var_def = vala_ccode_declaration_new (field_ctype);
			vala_ccode_declaration_add_declarator (var_def, (ValaCCodeDeclarator*) var_decl);
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_EXTERN);
			} else {
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_STATIC);
			}
			vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) var_def);
			_tmp58 = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp58 = !vala_field_get_no_array_length (f);
			} else {
				_tmp58 = FALSE;
			}
			/* add array length fields where necessary */
			if (_tmp58) {
				ValaArrayType* _tmp59;
				ValaArrayType* array_type;
				gboolean _tmp71;
				_tmp59 = NULL;
				array_type = (_tmp59 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp59 == NULL) ? NULL : vala_code_node_ref (_tmp59));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaDataType* len_type;
						char* _tmp65;
						ValaCCodeDeclaration* _tmp66;
						ValaCCodeDeclaration* len_def;
						ValaCCodeVariableDeclarator* _tmp70;
						ValaCCodeConstant* _tmp69;
						char* _tmp68;
						char* _tmp67;
						len_type = vala_data_type_copy (self->int_type);
						if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
							char* _tmp60;
							ValaCCodeDeclaration* _tmp61;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeVariableDeclarator* _tmp64;
							char* _tmp63;
							char* _tmp62;
							_tmp60 = NULL;
							_tmp61 = NULL;
							cdecl_ = (_tmp61 = vala_ccode_declaration_new (_tmp60 = vala_data_type_get_cname (len_type)), _tmp60 = (g_free (_tmp60), NULL), _tmp61);
							_tmp64 = NULL;
							_tmp63 = NULL;
							_tmp62 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp64 = vala_ccode_variable_declarator_new (_tmp63 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp62 = vala_field_get_cname (f), dim), NULL)));
							(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
							_tmp63 = (g_free (_tmp63), NULL);
							_tmp62 = (g_free (_tmp62), NULL);
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) cdecl_);
							(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
						}
						_tmp65 = NULL;
						_tmp66 = NULL;
						len_def = (_tmp66 = vala_ccode_declaration_new (_tmp65 = vala_data_type_get_cname (len_type)), _tmp65 = (g_free (_tmp65), NULL), _tmp66);
						_tmp70 = NULL;
						_tmp69 = NULL;
						_tmp68 = NULL;
						_tmp67 = NULL;
						vala_ccode_declaration_add_declarator (len_def, (ValaCCodeDeclarator*) (_tmp70 = vala_ccode_variable_declarator_new (_tmp68 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp67 = vala_field_get_cname (f), dim), (ValaCCodeExpression*) (_tmp69 = vala_ccode_constant_new ("0")))));
						(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
						(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
						_tmp68 = (g_free (_tmp68), NULL);
						_tmp67 = (g_free (_tmp67), NULL);
						if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
							vala_ccode_declaration_set_modifiers (len_def, VALA_CCODE_MODIFIERS_EXTERN);
						} else {
							vala_ccode_declaration_set_modifiers (len_def, VALA_CCODE_MODIFIERS_STATIC);
						}
						vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) len_def);
						(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
						(len_def == NULL) ? NULL : (len_def = (vala_ccode_node_unref (len_def), NULL));
					}
				}
				_tmp71 = FALSE;
				if (vala_array_type_get_rank (array_type) == 1) {
					_tmp71 = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
				} else {
					_tmp71 = FALSE;
				}
				if (_tmp71) {
					ValaDataType* len_type;
					char* _tmp72;
					ValaCCodeDeclaration* _tmp73;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp77;
					ValaCCodeConstant* _tmp76;
					char* _tmp75;
					char* _tmp74;
					len_type = vala_data_type_copy (self->int_type);
					_tmp72 = NULL;
					_tmp73 = NULL;
					cdecl_ = (_tmp73 = vala_ccode_declaration_new (_tmp72 = vala_data_type_get_cname (len_type)), _tmp72 = (g_free (_tmp72), NULL), _tmp73);
					_tmp77 = NULL;
					_tmp76 = NULL;
					_tmp75 = NULL;
					_tmp74 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp77 = vala_ccode_variable_declarator_new (_tmp75 = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp74 = vala_field_get_cname (f)), (ValaCCodeExpression*) (_tmp76 = vala_ccode_constant_new ("0")))));
					(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
					(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
					_tmp75 = (g_free (_tmp75), NULL);
					_tmp74 = (g_free (_tmp74), NULL);
					vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) cdecl_);
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
					ValaDelegateType* _tmp78;
					ValaDelegateType* delegate_type;
					_tmp78 = NULL;
					delegate_type = (_tmp78 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp78 == NULL) ? NULL : vala_code_node_ref (_tmp78));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
						ValaCCodeDeclaration* target_def;
						ValaCCodeVariableDeclarator* _tmp85;
						ValaCCodeConstant* _tmp84;
						char* _tmp83;
						char* _tmp82;
						/* create field to store delegate target*/
						if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeVariableDeclarator* _tmp81;
							char* _tmp80;
							char* _tmp79;
							cdecl_ = vala_ccode_declaration_new ("gpointer");
							_tmp81 = NULL;
							_tmp80 = NULL;
							_tmp79 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp81 = vala_ccode_variable_declarator_new (_tmp80 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp79 = vala_field_get_cname (f)), NULL)));
							(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
							_tmp80 = (g_free (_tmp80), NULL);
							_tmp79 = (g_free (_tmp79), NULL);
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) cdecl_);
							(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
						}
						target_def = vala_ccode_declaration_new ("gpointer");
						_tmp85 = NULL;
						_tmp84 = NULL;
						_tmp83 = NULL;
						_tmp82 = NULL;
						vala_ccode_declaration_add_declarator (target_def, (ValaCCodeDeclarator*) (_tmp85 = vala_ccode_variable_declarator_new (_tmp83 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp82 = vala_field_get_cname (f)), (ValaCCodeExpression*) (_tmp84 = vala_ccode_constant_new ("NULL")))));
						(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
						(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
						_tmp83 = (g_free (_tmp83), NULL);
						_tmp82 = (g_free (_tmp82), NULL);
						if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
							vala_ccode_declaration_set_modifiers (target_def, VALA_CCODE_MODIFIERS_EXTERN);
						} else {
							vala_ccode_declaration_set_modifiers (target_def, VALA_CCODE_MODIFIERS_STATIC);
						}
						vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) target_def);
						(target_def == NULL) ? NULL : (target_def = (vala_ccode_node_unref (target_def), NULL));
					}
					(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
				}
			}
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp86;
				ValaCCodeExpression* rhs;
				_tmp86 = NULL;
				rhs = (_tmp86 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp86 == NULL) ? NULL : vala_ccode_node_ref (_tmp86));
				if (!vala_ccode_base_module_is_constant_ccode_expression (self, rhs)) {
					if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f))) {
						ValaCCodeExpressionStatement* _tmp88;
						ValaCCodeAssignment* _tmp87;
						gboolean _tmp89;
						gboolean _tmp90;
						_tmp88 = NULL;
						_tmp87 = NULL;
						vala_ccode_fragment_append (self->class_init_fragment, (ValaCCodeNode*) (_tmp88 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp87 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
						(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
						_tmp89 = FALSE;
						_tmp90 = FALSE;
						if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
							_tmp90 = !vala_field_get_no_array_length (f);
						} else {
							_tmp90 = FALSE;
						}
						if (_tmp90) {
							_tmp89 = VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f));
						} else {
							_tmp89 = FALSE;
						}
						if (_tmp89) {
							ValaArrayType* _tmp91;
							ValaArrayType* array_type;
							ValaMemberAccess* ma;
							GeeList* sizes;
							_tmp91 = NULL;
							array_type = (_tmp91 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp91 == NULL) ? NULL : vala_code_node_ref (_tmp91));
							ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) f), NULL);
							vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
							sizes = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* array_len_lhs;
									ValaExpression* size;
									ValaCCodeExpressionStatement* _tmp93;
									ValaCCodeAssignment* _tmp92;
									array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaExpression*) ma, dim);
									size = (ValaExpression*) gee_list_get (sizes, dim - 1);
									_tmp93 = NULL;
									_tmp92 = NULL;
									vala_ccode_fragment_append (self->class_init_fragment, (ValaCCodeNode*) (_tmp93 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp92 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
									(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
									(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
									(array_len_lhs == NULL) ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL));
									(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
								}
							}
							(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							(sizes == NULL) ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL));
						}
						vala_ccode_base_module_append_temp_decl (self, self->class_init_fragment, (GeeList*) self->temp_vars);
						gee_collection_clear ((GeeCollection*) self->temp_vars);
					} else {
						vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "Non-constant field initializers not supported in this context");
						(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
						(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
						(var_def == NULL) ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL));
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
						(st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL));
						field_ctype = (g_free (field_ctype), NULL);
						return;
					}
				}
				(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
			}
			(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
			(var_def == NULL) ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL));
		}
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
	(st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL));
	field_ctype = (g_free (field_ctype), NULL);
}


gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp5;
	ValaCCodeExpression* _tmp4;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp6;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			gboolean _tmp3;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
			_tmp2 = FALSE;
			if (vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
				_tmp2 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
			} else {
				_tmp2 = FALSE;
			}
			return (_tmp3 = _tmp2, (cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL)), _tmp3);
		}
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	cparenthesized = (_tmp5 = (_tmp4 = cexpr, VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp4) ? ((ValaCCodeParenthesizedExpression*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
	_tmp6 = FALSE;
	if (NULL != cparenthesized) {
		_tmp6 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized));
	} else {
		_tmp6 = FALSE;
	}
	return (_tmp7 = _tmp6, (cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL)), _tmp7);
}


/**
 * Returns whether the passed cexpr is a pure expression, i.e. an
 * expression without side-effects.
 */
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	_tmp0 = FALSE;
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = VALA_IS_CCODE_IDENTIFIER (cexpr);
	}
	if (_tmp0) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp2;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp3;
			gboolean _tmp4;
			_tmp2 = NULL;
			cbinary = (_tmp2 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2));
			_tmp3 = FALSE;
			if (vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
				_tmp3 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
			} else {
				_tmp3 = FALSE;
			}
			return (_tmp4 = _tmp3, (cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL)), _tmp4);
		} else {
			if (VALA_IS_CCODE_UNARY_EXPRESSION (cexpr)) {
				ValaCCodeUnaryExpression* _tmp5;
				ValaCCodeUnaryExpression* cunary;
				_tmp5 = NULL;
				cunary = (_tmp5 = VALA_CCODE_UNARY_EXPRESSION (cexpr), (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
				switch (vala_ccode_unary_expression_get_operator (cunary)) {
					case VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT:
					case VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT:
					case VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT:
					case VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT:
					{
						gboolean _tmp6;
						return (_tmp6 = FALSE, (cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL)), _tmp6);
					}
					default:
					{
						gboolean _tmp7;
						return (_tmp7 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_unary_expression_get_inner (cunary)), (cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL)), _tmp7);
					}
				}
				(cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL));
			} else {
				if (VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
					ValaCCodeMemberAccess* _tmp8;
					ValaCCodeMemberAccess* cma;
					gboolean _tmp9;
					_tmp8 = NULL;
					cma = (_tmp8 = VALA_CCODE_MEMBER_ACCESS (cexpr), (_tmp8 == NULL) ? NULL : vala_ccode_node_ref (_tmp8));
					return (_tmp9 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_member_access_get_inner (cma)), (cma == NULL) ? NULL : (cma = (vala_ccode_node_unref (cma), NULL)), _tmp9);
				} else {
					if (VALA_IS_CCODE_ELEMENT_ACCESS (cexpr)) {
						ValaCCodeElementAccess* _tmp10;
						ValaCCodeElementAccess* cea;
						gboolean _tmp11;
						gboolean _tmp12;
						_tmp10 = NULL;
						cea = (_tmp10 = VALA_CCODE_ELEMENT_ACCESS (cexpr), (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10));
						_tmp11 = FALSE;
						if (vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_element_access_get_container (cea))) {
							_tmp11 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_element_access_get_index (cea));
						} else {
							_tmp11 = FALSE;
						}
						return (_tmp12 = _tmp11, (cea == NULL) ? NULL : (cea = (vala_ccode_node_unref (cea), NULL)), _tmp12);
					} else {
						if (VALA_IS_CCODE_CAST_EXPRESSION (cexpr)) {
							ValaCCodeCastExpression* _tmp13;
							ValaCCodeCastExpression* ccast;
							gboolean _tmp14;
							_tmp13 = NULL;
							ccast = (_tmp13 = VALA_CCODE_CAST_EXPRESSION (cexpr), (_tmp13 == NULL) ? NULL : vala_ccode_node_ref (_tmp13));
							return (_tmp14 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_cast_expression_get_inner (ccast)), (ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)), _tmp14);
						} else {
							if (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (cexpr)) {
								ValaCCodeParenthesizedExpression* _tmp15;
								ValaCCodeParenthesizedExpression* cparenthesized;
								gboolean _tmp16;
								_tmp15 = NULL;
								cparenthesized = (_tmp15 = VALA_CCODE_PARENTHESIZED_EXPRESSION (cexpr), (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15));
								return (_tmp16 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized)), (cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL)), _tmp16);
							}
						}
					}
				}
			}
		}
	}
	return FALSE;
}


static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (p != NULL);
	vala_ccode_base_module_check_type (self, vala_formal_parameter_get_parameter_type (p));
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		char* ctypename;
		const char* _tmp0;
		char* cname;
		ValaCCodeFormalParameter* _tmp6;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (p));
		_tmp0 = NULL;
		cname = (_tmp0 = vala_symbol_get_name ((ValaSymbol*) p), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
		/* pass non-simple structs always by reference*/
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)))) {
			ValaStruct* _tmp1;
			ValaStruct* st;
			gboolean _tmp2;
			_tmp1 = NULL;
			st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
			_tmp2 = FALSE;
			if (!vala_struct_is_simple_type (st)) {
				_tmp2 = vala_formal_parameter_get_direction (p) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				if (vala_struct_get_use_const (st)) {
					char* _tmp3;
					_tmp3 = NULL;
					ctypename = (_tmp3 = g_strconcat ("const ", ctypename, NULL), ctypename = (g_free (ctypename), NULL), _tmp3);
				}
				if (!vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p))) {
					char* _tmp4;
					_tmp4 = NULL;
					ctypename = (_tmp4 = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp4);
				}
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp5;
			_tmp5 = NULL;
			ctypename = (_tmp5 = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp5);
		}
		_tmp6 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) p, (ValaCCodeNode*) (_tmp6 = vala_ccode_formal_parameter_new (cname, ctypename)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		ctypename = (g_free (ctypename), NULL);
		cname = (g_free (cname), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp7;
		_tmp7 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) p, (ValaCCodeNode*) (_tmp7 = vala_ccode_formal_parameter_new_with_ellipsis ()));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	}
}


static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop) {
	ValaCCodeBaseModule * self;
	gint old_next_temp_var_id;
	GeeMap* _tmp0;
	GeeMap* old_variable_name_map;
	GeeMap* _tmp1;
	GeeMap* _tmp3;
	GeeMap* _tmp2;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (prop != NULL);
	vala_ccode_base_module_check_type (self, vala_property_get_property_type (prop));
	old_next_temp_var_id = self->next_temp_var_id;
	_tmp0 = NULL;
	old_variable_name_map = (_tmp0 = self->variable_name_map, (_tmp0 == NULL) ? NULL : gee_collection_object_ref (_tmp0));
	self->next_temp_var_id = 0;
	_tmp1 = NULL;
	self->variable_name_map = (_tmp1 = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), (self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL)), _tmp1);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	self->next_temp_var_id = old_next_temp_var_id;
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->variable_name_map = (_tmp3 = (_tmp2 = old_variable_name_map, (_tmp2 == NULL) ? NULL : gee_collection_object_ref (_tmp2)), (self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL)), _tmp3);
	(old_variable_name_map == NULL) ? NULL : (old_variable_name_map = (gee_collection_object_unref (old_variable_name_map), NULL));
}


static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc) {
	ValaCCodeBaseModule * self;
	ValaPropertyAccessor* _tmp1;
	ValaPropertyAccessor* _tmp0;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	gboolean returns_real_struct;
	gboolean _tmp3;
	ValaTypeSymbol* _tmp7;
	ValaTypeSymbol* t;
	gboolean _tmp8;
	ValaReferenceType* this_type;
	char* _tmp11;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFormalParameter* cselfparam;
	ValaCCodeFormalParameter* cvalueparam;
	gboolean _tmp18;
	ValaPropertyAccessor* _tmp109;
	ValaDataType* _tmp110;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (acc != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_property_accessor = (_tmp1 = (_tmp0 = acc, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp1);
	self->current_method_inner_error = FALSE;
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
	_tmp3 = FALSE;
	if (vala_property_accessor_get_readable (acc)) {
		_tmp3 = !returns_real_struct;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		ValaDataType* _tmp5;
		ValaDataType* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->current_return_type = (_tmp5 = (_tmp4 = vala_property_get_property_type (prop), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp5);
	} else {
		ValaDataType* _tmp6;
		_tmp6 = NULL;
		self->current_return_type = (_tmp6 = (ValaDataType*) vala_void_type_new (NULL), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp6);
	}
	vala_code_node_accept_children ((ValaCodeNode*) acc, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp7 = NULL;
	t = (_tmp7 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
	_tmp8 = FALSE;
	if (vala_property_accessor_get_construction (acc)) {
		_tmp8 = !vala_typesymbol_is_subtype_of (t, self->gobject_type);
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) acc), "construct properties require GLib.Object");
		vala_code_node_set_error ((ValaCodeNode*) acc, TRUE);
		(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
		return;
	}
	this_type = NULL;
	if (VALA_IS_CLASS (t)) {
		ValaReferenceType* _tmp9;
		_tmp9 = NULL;
		this_type = (_tmp9 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (t)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp9);
	} else {
		ValaReferenceType* _tmp10;
		_tmp10 = NULL;
		this_type = (_tmp10 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (t)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp10);
	}
	_tmp11 = NULL;
	_tmp12 = NULL;
	cselfparam = (_tmp12 = vala_ccode_formal_parameter_new ("self", _tmp11 = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
	cvalueparam = NULL;
	if (returns_real_struct) {
		ValaCCodeFormalParameter* _tmp15;
		char* _tmp14;
		char* _tmp13;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		cvalueparam = (_tmp15 = vala_ccode_formal_parameter_new ("value", _tmp14 = g_strconcat (_tmp13 = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc)), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp15);
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp17;
		char* _tmp16;
		_tmp17 = NULL;
		_tmp16 = NULL;
		cvalueparam = (_tmp17 = vala_ccode_formal_parameter_new ("value", _tmp16 = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp17);
		_tmp16 = (g_free (_tmp16), NULL);
	}
	_tmp18 = FALSE;
	if (vala_property_get_is_abstract (prop)) {
		_tmp18 = TRUE;
	} else {
		_tmp18 = vala_property_get_is_virtual (prop);
	}
	if (_tmp18) {
		ValaCCodeFunctionDeclarator* vdeclarator;
		gboolean _tmp30;
		gboolean _tmp31;
		gboolean _tmp32;
		gboolean _tmp33;
		ValaCCodeBlock* block;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp47;
		vdeclarator = NULL;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp21;
			char* _tmp20;
			char* _tmp19;
			char* _tmp22;
			ValaCCodeDeclaration* _tmp23;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp25;
			char* _tmp24;
			_tmp21 = NULL;
			_tmp20 = NULL;
			_tmp19 = NULL;
			self->function = (_tmp21 = vala_ccode_function_new (_tmp19 = vala_property_accessor_get_cname (acc), _tmp20 = vala_data_type_get_cname (self->current_return_type)), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp21);
			_tmp20 = (g_free (_tmp20), NULL);
			_tmp19 = (g_free (_tmp19), NULL);
			_tmp22 = NULL;
			_tmp23 = NULL;
			vdecl = (_tmp23 = vala_ccode_declaration_new (_tmp22 = vala_data_type_get_cname (self->current_return_type)), _tmp22 = (g_free (_tmp22), NULL), _tmp23);
			_tmp25 = NULL;
			_tmp24 = NULL;
			vdeclarator = (_tmp25 = vala_ccode_function_declarator_new (_tmp24 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp25);
			_tmp24 = (g_free (_tmp24), NULL);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		} else {
			ValaCCodeFunction* _tmp27;
			char* _tmp26;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp29;
			char* _tmp28;
			_tmp27 = NULL;
			_tmp26 = NULL;
			self->function = (_tmp27 = vala_ccode_function_new (_tmp26 = vala_property_accessor_get_cname (acc), "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp27);
			_tmp26 = (g_free (_tmp26), NULL);
			vdecl = vala_ccode_declaration_new ("void");
			_tmp29 = NULL;
			_tmp28 = NULL;
			vdeclarator = (_tmp29 = vala_ccode_function_declarator_new (_tmp28 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp29);
			_tmp28 = (g_free (_tmp28), NULL);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
		_tmp30 = FALSE;
		_tmp31 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp31 = TRUE;
		} else {
			_tmp31 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp31) {
			_tmp30 = TRUE;
		} else {
			_tmp30 = returns_real_struct;
		}
		if (_tmp30) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
			vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
		}
		_tmp32 = FALSE;
		_tmp33 = FALSE;
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) prop)) {
			gboolean _tmp34;
			_tmp34 = FALSE;
			if (vala_property_accessor_get_readable (acc)) {
				_tmp34 = TRUE;
			} else {
				_tmp34 = vala_property_accessor_get_writable (acc);
			}
			_tmp33 = _tmp34;
		} else {
			_tmp33 = FALSE;
		}
		if (_tmp33) {
			_tmp32 = vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp32 = FALSE;
		}
		if (_tmp32) {
			ValaCCodeFunction* _tmp35;
			/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
			_tmp35 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp35 = vala_ccode_function_copy (self->function)));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		} else {
			ValaCCodeFunction* _tmp36;
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
			_tmp36 = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp36 = vala_ccode_function_copy (self->function)));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->function, block);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop))) {
			ValaInterface* _tmp37;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp41;
			ValaCCodeIdentifier* _tmp40;
			char* _tmp39;
			char* _tmp38;
			_tmp37 = NULL;
			iface = (_tmp37 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
			_tmp41 = NULL;
			_tmp40 = NULL;
			_tmp39 = NULL;
			_tmp38 = NULL;
			vcast = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = g_strdup_printf ("%s_GET_INTERFACE", _tmp38 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp41);
			(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
			_tmp39 = (g_free (_tmp39), NULL);
			_tmp38 = (g_free (_tmp38), NULL);
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
		} else {
			ValaClass* _tmp42;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp46;
			ValaCCodeIdentifier* _tmp45;
			char* _tmp44;
			char* _tmp43;
			_tmp42 = NULL;
			cl = (_tmp42 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp42 == NULL) ? NULL : vala_code_node_ref (_tmp42));
			_tmp46 = NULL;
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			vcast = (_tmp46 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new (_tmp44 = g_strdup_printf ("%s_GET_CLASS", _tmp43 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp46);
			(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
			_tmp44 = (g_free (_tmp44), NULL);
			_tmp43 = (g_free (_tmp43), NULL);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		}
		_tmp47 = NULL;
		vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("self")));
		(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeMemberAccess* _tmp49;
			char* _tmp48;
			ValaCCodeFunctionCall* _tmp50;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp51;
			_tmp49 = NULL;
			_tmp48 = NULL;
			_tmp50 = NULL;
			vcall = (_tmp50 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp48 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)), _tmp48 = (g_free (_tmp48), NULL), _tmp50);
			_tmp51 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("self")));
			(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
			if (returns_real_struct) {
				ValaCCodeIdentifier* _tmp52;
				ValaCCodeExpressionStatement* _tmp53;
				_tmp52 = NULL;
				vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("value")));
				(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
				_tmp53 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp53 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
			} else {
				ValaCCodeReturnStatement* _tmp54;
				_tmp54 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp54 = vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
			}
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		} else {
			ValaCCodeMemberAccess* _tmp56;
			char* _tmp55;
			ValaCCodeFunctionCall* _tmp57;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp58;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeExpressionStatement* _tmp60;
			_tmp56 = NULL;
			_tmp55 = NULL;
			_tmp57 = NULL;
			vcall = (_tmp57 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp55 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)), _tmp55 = (g_free (_tmp55), NULL), _tmp57);
			_tmp58 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("self")));
			(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
			_tmp59 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("value")));
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			_tmp60 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp60 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
			(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean _tmp61;
		gboolean is_virtual;
		char* cname;
		gboolean _tmp67;
		gboolean _tmp68;
		ValaObjectType* base_type;
		gboolean _tmp76;
		gboolean _tmp77;
		gboolean _tmp90;
		ValaTypeSymbol* _tmp93;
		ValaTypeSymbol* typesymbol;
		ValaStruct* _tmp95;
		ValaTypeSymbol* _tmp94;
		ValaStruct* st;
		gboolean _tmp96;
		gboolean _tmp97;
		gboolean _tmp98;
		gboolean _tmp99;
		gboolean _tmp100;
		_tmp61 = FALSE;
		if (vala_property_get_base_property (prop) != NULL) {
			_tmp61 = TRUE;
		} else {
			_tmp61 = vala_property_get_base_interface_property (prop) != NULL;
		}
		is_virtual = _tmp61;
		cname = NULL;
		if (is_virtual) {
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp63;
				char* _tmp62;
				_tmp63 = NULL;
				_tmp62 = NULL;
				cname = (_tmp63 = g_strdup_printf ("%s_real_get_%s", _tmp62 = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp63);
				_tmp62 = (g_free (_tmp62), NULL);
			} else {
				char* _tmp65;
				char* _tmp64;
				_tmp65 = NULL;
				_tmp64 = NULL;
				cname = (_tmp65 = g_strdup_printf ("%s_real_set_%s", _tmp64 = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp65);
				_tmp64 = (g_free (_tmp64), NULL);
			}
		} else {
			char* _tmp66;
			_tmp66 = NULL;
			cname = (_tmp66 = vala_property_accessor_get_cname (acc), cname = (g_free (cname), NULL), _tmp66);
		}
		_tmp67 = FALSE;
		_tmp68 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp68 = TRUE;
		} else {
			_tmp68 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp68) {
			_tmp67 = TRUE;
		} else {
			_tmp67 = returns_real_struct;
		}
		if (_tmp67) {
			ValaCCodeFunction* _tmp69;
			_tmp69 = NULL;
			self->function = (_tmp69 = vala_ccode_function_new (cname, "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp69);
		} else {
			ValaCCodeFunction* _tmp71;
			char* _tmp70;
			_tmp71 = NULL;
			_tmp70 = NULL;
			self->function = (_tmp71 = vala_ccode_function_new (cname, _tmp70 = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp71);
			_tmp70 = (g_free (_tmp70), NULL);
		}
		base_type = NULL;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			if (is_virtual) {
				ValaCCodeFormalParameter* _tmp75;
				char* _tmp74;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaObjectType* _tmp72;
					_tmp72 = NULL;
					base_type = (_tmp72 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp72);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaObjectType* _tmp73;
						_tmp73 = NULL;
						base_type = (_tmp73 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp73);
					}
				}
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
				_tmp75 = NULL;
				_tmp74 = NULL;
				vala_ccode_function_add_parameter (self->function, _tmp75 = vala_ccode_formal_parameter_new ("base", _tmp74 = vala_data_type_get_cname ((ValaDataType*) base_type)));
				(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
				_tmp74 = (g_free (_tmp74), NULL);
			} else {
				vala_ccode_function_add_parameter (self->function, cselfparam);
			}
		}
		_tmp76 = FALSE;
		_tmp77 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp77 = TRUE;
		} else {
			_tmp77 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp77) {
			_tmp76 = TRUE;
		} else {
			_tmp76 = returns_real_struct;
		}
		if (_tmp76) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (!is_virtual) {
			gboolean _tmp78;
			gboolean _tmp79;
			_tmp78 = FALSE;
			_tmp79 = FALSE;
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) prop)) {
				gboolean _tmp80;
				_tmp80 = FALSE;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp80 = TRUE;
				} else {
					_tmp80 = vala_property_accessor_get_writable (acc);
				}
				_tmp79 = _tmp80;
			} else {
				_tmp79 = FALSE;
			}
			if (_tmp79) {
				_tmp78 = vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp78 = FALSE;
			}
			if (_tmp78) {
				ValaCCodeFunction* _tmp81;
				/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
				_tmp81 = NULL;
				vala_ccode_declaration_space_add_type_member_declaration (self->header_declarations, (ValaCCodeNode*) (_tmp81 = vala_ccode_function_copy (self->function)));
				(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			} else {
				ValaCCodeFunction* _tmp82;
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
				_tmp82 = NULL;
				vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp82 = vala_ccode_function_copy (self->function)));
				(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
			}
		}
		vala_ccode_function_set_block (self->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_accessor_get_body (acc))));
		if (is_virtual) {
			char* _tmp83;
			ValaCCodeDeclaration* _tmp84;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp87;
			ValaCCodeExpression* _tmp86;
			ValaCCodeIdentifier* _tmp85;
			_tmp83 = NULL;
			_tmp84 = NULL;
			cdecl_ = (_tmp84 = vala_ccode_declaration_new (_tmp83 = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp83 = (g_free (_tmp83), NULL), _tmp84);
			_tmp87 = NULL;
			_tmp86 = NULL;
			_tmp85 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp87 = vala_ccode_variable_declarator_new ("self", _tmp86 = vala_ccode_base_module_transform_expression (self, (ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_type, (ValaDataType*) this_type, NULL))));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp89;
			ValaCCodeConstant* _tmp88;
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp89 = NULL;
			_tmp88 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp89 = vala_ccode_variable_declarator_new ("inner_error", (ValaCCodeExpression*) (_tmp88 = vala_ccode_constant_new ("NULL")))));
			(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		_tmp90 = FALSE;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			_tmp90 = !is_virtual;
		} else {
			_tmp90 = FALSE;
		}
		if (_tmp90) {
			ValaCCodeStatement* check_stmt;
			check_stmt = NULL;
			if (returns_real_struct) {
				ValaCCodeStatement* _tmp91;
				_tmp91 = NULL;
				check_stmt = (_tmp91 = vala_ccode_base_module_create_property_type_check_statement (self, prop, FALSE, t, TRUE, "self"), (check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL)), _tmp91);
			} else {
				ValaCCodeStatement* _tmp92;
				_tmp92 = NULL;
				check_stmt = (_tmp92 = vala_ccode_base_module_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"), (check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL)), _tmp92);
			}
			if (check_stmt != NULL) {
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) check_stmt);
			}
			(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
		}
		/* notify on property changes*/
		_tmp93 = NULL;
		typesymbol = (_tmp93 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93));
		_tmp95 = NULL;
		_tmp94 = NULL;
		st = (_tmp95 = (_tmp94 = vala_data_type_get_data_type (vala_property_get_property_type (prop)), VALA_IS_STRUCT (_tmp94) ? ((ValaStruct*) _tmp94) : NULL), (_tmp95 == NULL) ? NULL : vala_code_node_ref (_tmp95));
		_tmp96 = FALSE;
		_tmp97 = FALSE;
		_tmp98 = FALSE;
		_tmp99 = FALSE;
		_tmp100 = FALSE;
		if (vala_typesymbol_is_subtype_of (typesymbol, self->gobject_type)) {
			gboolean _tmp101;
			_tmp101 = FALSE;
			if (st == NULL) {
				_tmp101 = TRUE;
			} else {
				_tmp101 = vala_struct_get_has_type_id (st);
			}
			_tmp100 = _tmp101;
		} else {
			_tmp100 = FALSE;
		}
		if (_tmp100) {
			_tmp99 = vala_property_get_notify (prop);
		} else {
			_tmp99 = FALSE;
		}
		if (_tmp99) {
			_tmp98 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp98 = FALSE;
		}
		if (_tmp98) {
			_tmp97 = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
		} else {
			_tmp97 = FALSE;
		}
		if (_tmp97) {
			gboolean _tmp102;
			_tmp102 = FALSE;
			if (vala_property_accessor_get_writable (acc)) {
				_tmp102 = TRUE;
			} else {
				_tmp102 = vala_property_accessor_get_construction (acc);
			}
			_tmp96 = _tmp102;
		} else {
			_tmp96 = FALSE;
		}
		if (_tmp96) {
			ValaCCodeIdentifier* _tmp103;
			ValaCCodeFunctionCall* _tmp104;
			ValaCCodeFunctionCall* notify_call;
			ValaCCodeCastExpression* _tmp106;
			ValaCCodeIdentifier* _tmp105;
			ValaCCodeConstant* _tmp107;
			ValaCCodeExpressionStatement* _tmp108;
			/* FIXME: use better means to detect gobject properties*/
			_tmp103 = NULL;
			_tmp104 = NULL;
			notify_call = (_tmp104 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp103 = vala_ccode_identifier_new ("g_object_notify"))), (_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)), _tmp104);
			_tmp106 = NULL;
			_tmp105 = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp106 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new ("self")), "GObject *")));
			(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
			(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
			_tmp107 = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp107 = vala_property_get_canonical_cconstant (prop)));
			(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
			_tmp108 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) (_tmp108 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) notify_call)));
			(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
			(notify_call == NULL) ? NULL : (notify_call = (vala_ccode_node_unref (notify_call), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		cname = (g_free (cname), NULL);
		(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		(typesymbol == NULL) ? NULL : (typesymbol = (vala_code_node_unref (typesymbol), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	_tmp109 = NULL;
	self->current_property_accessor = (_tmp109 = NULL, (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp109);
	_tmp110 = NULL;
	self->current_return_type = (_tmp110 = NULL, (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp110);
	(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
	(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
	(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
	(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
	(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
}


static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (d != NULL);
	self->current_method_inner_error = FALSE;
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = FALSE;
	if (vala_destructor_get_binding (d) == MEMBER_BINDING_STATIC) {
		_tmp0 = !self->in_plugin;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) d), "static destructors are only supported for dynamic types");
		vala_code_node_set_error ((ValaCodeNode*) d, TRUE);
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	if (self->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp2;
		ValaCCodeConstant* _tmp1;
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new ("inner_error", (ValaCCodeExpression*) (_tmp1 = vala_ccode_constant_new ("NULL")))));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_destructor_get_body (d)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) d, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	GeeList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp22;
	ValaSymbol* _tmp21;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	old_symbol = (_tmp0 = self->current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->current_symbol = (_tmp2 = (_tmp1 = (ValaSymbol*) b, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp2);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			vala_symbol_set_active ((ValaSymbol*) local, FALSE);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	cblock = vala_ccode_block_new ();
	{
		GeeList* _tmp3;
		GeeIterator* _tmp4;
		GeeIterator* _stmt_it;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_stmt_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_block_get_statements (b))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
		while (gee_iterator_next (_stmt_it)) {
			ValaCodeNode* stmt;
			ValaSourceReference* _tmp5;
			ValaSourceReference* src;
			gboolean _tmp6;
			stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
			if (vala_code_node_get_error (stmt)) {
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				continue;
			}
			_tmp5 = NULL;
			src = (_tmp5 = vala_code_node_get_source_reference (stmt), (_tmp5 == NULL) ? NULL : vala_source_reference_ref (_tmp5));
			_tmp6 = FALSE;
			if (src != NULL) {
				_tmp6 = vala_source_reference_get_comment (src) != NULL;
			} else {
				_tmp6 = FALSE;
			}
			if (_tmp6) {
				ValaCCodeComment* _tmp7;
				_tmp7 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp7 = vala_ccode_comment_new (vala_source_reference_get_comment (src))));
				(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			}
			if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
				{
					GeeList* _tmp8;
					GeeIterator* _tmp9;
					GeeIterator* _cstmt_it;
					_tmp8 = NULL;
					_tmp9 = NULL;
					_cstmt_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
					while (gee_iterator_next (_cstmt_it)) {
						ValaCCodeNode* cstmt;
						cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
						vala_ccode_block_add_statement (cblock, cstmt);
						(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
					}
					(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
				}
			} else {
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
			}
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
		}
		(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
	}
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp10;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp10 = FALSE;
			if (!vala_local_variable_get_floating (local)) {
				_tmp10 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp13;
				ValaCCodeExpression* _tmp12;
				ValaCCodeExpression* _tmp11;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new (_tmp12 = vala_ccode_base_module_get_unref_expression (self, _tmp11 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b))) {
		ValaMethod* _tmp14;
		ValaMethod* m;
		_tmp14 = NULL;
		m = (_tmp14 = VALA_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b)), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
		{
			GeeList* _tmp15;
			GeeIterator* _tmp16;
			GeeIterator* _param_it;
			_tmp15 = NULL;
			_tmp16 = NULL;
			_param_it = (_tmp16 = gee_iterable_iterator ((GeeIterable*) (_tmp15 = vala_method_get_parameters (m))), (_tmp15 == NULL) ? NULL : (_tmp15 = (gee_collection_object_unref (_tmp15), NULL)), _tmp16);
			while (gee_iterator_next (_param_it)) {
				ValaFormalParameter* param;
				gboolean _tmp17;
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				_tmp17 = FALSE;
				if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
					_tmp17 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
				} else {
					_tmp17 = FALSE;
				}
				if (_tmp17) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp20;
					ValaCCodeExpression* _tmp19;
					ValaCCodeExpression* _tmp18;
					ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
					vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
					_tmp20 = NULL;
					_tmp19 = NULL;
					_tmp18 = NULL;
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp20 = vala_ccode_expression_statement_new (_tmp19 = vala_ccode_base_module_get_unref_expression (self, _tmp18 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) param)), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) b, (ValaCCodeNode*) cblock);
	_tmp22 = NULL;
	_tmp21 = NULL;
	self->current_symbol = (_tmp22 = (_tmp21 = old_symbol, (_tmp21 == NULL) ? NULL : vala_code_node_ref (_tmp21)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp22);
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_empty_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	gboolean _tmp2;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt)));
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (stmt), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (local != NULL) {
		_tmp2 = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_local_variable_get_initializer (local)->temp_vars);
	}
	vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0 = FALSE;
	if (self->current_method != NULL) {
		_tmp0 = vala_method_get_coroutine (self->current_method);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* _tmp3;
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("data")), _tmp2 = vala_ccode_base_module_get_variable_cname (self, name)), _tmp2 = (g_free (_tmp2), NULL), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp3);
	} else {
		char* _tmp5;
		ValaCCodeExpression* _tmp6;
		_tmp5 = NULL;
		_tmp6 = NULL;
		return (_tmp6 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp5 = vala_ccode_base_module_get_variable_cname (self, name)), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
	}
}


char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (name, 0)) == '.') {
		/* compiler-internal variable*/
		if (!gee_map_contains (self->variable_name_map, name)) {
			char* _tmp0;
			_tmp0 = NULL;
			gee_map_set (self->variable_name_map, name, _tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id));
			_tmp0 = (g_free (_tmp0), NULL);
			self->next_temp_var_id++;
		}
		return (char*) gee_map_get (self->variable_name_map, name);
	} else {
		if (gee_collection_contains ((GeeCollection*) self->c_keywords, name)) {
			return g_strconcat (name, "_", NULL);
		} else {
			const char* _tmp3;
			_tmp3 = NULL;
			return (_tmp3 = name, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
		}
	}
}


static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* rhs;
	gboolean _tmp16;
	ValaCCodeFragment* cfrag;
	gboolean _tmp57;
	gboolean _tmp70;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (local != NULL);
	vala_ccode_base_module_check_type (self, vala_local_variable_get_variable_type (local));
	vala_code_node_accept_children ((ValaCodeNode*) local, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
		ValaArrayType* _tmp0;
		ValaArrayType* array_type;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp3;
				char* _tmp2;
				ValaDataType* _tmp1;
				ValaLocalVariable* _tmp4;
				ValaLocalVariable* len_var;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp4 = NULL;
				len_var = (_tmp4 = vala_local_variable_new (_tmp1 = vala_data_type_copy (self->int_type), _tmp3 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp2 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim), NULL, NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp2 = (g_free (_tmp2), NULL), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)), _tmp4);
				gee_list_insert ((GeeList*) self->temp_vars, 0, len_var);
				(len_var == NULL) ? NULL : (len_var = (vala_code_node_unref (len_var), NULL));
			}
		}
		if (vala_array_type_get_rank (array_type) == 1) {
			char* _tmp7;
			char* _tmp6;
			ValaDataType* _tmp5;
			ValaLocalVariable* _tmp8;
			ValaLocalVariable* size_var;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp8 = NULL;
			size_var = (_tmp8 = vala_local_variable_new (_tmp5 = vala_data_type_copy (self->int_type), _tmp7 = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp6 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local))), NULL, NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL)), _tmp8);
			gee_list_insert ((GeeList*) self->temp_vars, 0, size_var);
			(size_var == NULL) ? NULL : (size_var = (vala_code_node_unref (size_var), NULL));
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaDelegateType* _tmp9;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp10;
			ValaDelegate* d;
			_tmp9 = NULL;
			deleg_type = (_tmp9 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
			_tmp10 = NULL;
			d = (_tmp10 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp14;
				char* _tmp13;
				ValaPointerType* _tmp12;
				ValaVoidType* _tmp11;
				ValaLocalVariable* _tmp15;
				ValaLocalVariable* target_var;
				/* create variable to store delegate target*/
				_tmp14 = NULL;
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp11 = NULL;
				_tmp15 = NULL;
				target_var = (_tmp15 = vala_local_variable_new ((ValaDataType*) (_tmp12 = vala_pointer_type_new ((ValaDataType*) (_tmp11 = vala_void_type_new (NULL)), NULL)), _tmp14 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp13 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local))), NULL, NULL), _tmp14 = (g_free (_tmp14), NULL), _tmp13 = (g_free (_tmp13), NULL), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL)), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL)), _tmp15);
				gee_list_insert ((GeeList*) self->temp_vars, 0, target_var);
				(target_var == NULL) ? NULL : (target_var = (vala_code_node_unref (target_var), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	rhs = NULL;
	_tmp16 = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp16 = vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local)) != NULL;
	} else {
		_tmp16 = FALSE;
	}
	if (_tmp16) {
		ValaCCodeExpression* _tmp18;
		ValaCCodeExpression* _tmp17;
		_tmp18 = NULL;
		_tmp17 = NULL;
		rhs = (_tmp18 = (_tmp17 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local))), (_tmp17 == NULL) ? NULL : vala_ccode_node_ref (_tmp17)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp18);
		if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaArrayType* _tmp19;
			ValaArrayType* array_type;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_var;
			ValaCCodeAssignment* _tmp21;
			ValaCCodeExpression* _tmp20;
			ValaCCodeExpression* _tmp33;
			ValaCCodeExpression* _tmp35;
			ValaCCodeExpression* _tmp34;
			_tmp19 = NULL;
			array_type = (_tmp19 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp19 == NULL) ? NULL : vala_code_node_ref (_tmp19));
			ccomma = vala_ccode_comma_expression_new ();
			temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
			gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp21 = vala_ccode_assignment_new (_tmp20 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp23;
					char* _tmp22;
					ValaCCodeExpression* _tmp24;
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp25;
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp24 = NULL;
					lhs_array_len = (_tmp24 = vala_ccode_base_module_get_variable_cexpression (self, _tmp23 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp22 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _tmp23 = (g_free (_tmp23), NULL), _tmp22 = (g_free (_tmp22), NULL), _tmp24);
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_local_variable_get_initializer (local), dim);
					_tmp25 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp25 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
					(lhs_array_len == NULL) ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL));
					(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
				}
			}
			if (vala_array_type_get_rank (array_type) == 1) {
				char* _tmp27;
				char* _tmp26;
				ValaCCodeExpression* _tmp28;
				ValaCCodeExpression* lhs_array_size;
				char* _tmp30;
				char* _tmp29;
				ValaCCodeExpression* _tmp31;
				ValaCCodeExpression* rhs_array_len;
				ValaCCodeAssignment* _tmp32;
				_tmp27 = NULL;
				_tmp26 = NULL;
				_tmp28 = NULL;
				lhs_array_size = (_tmp28 = vala_ccode_base_module_get_variable_cexpression (self, _tmp27 = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp26 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp27 = (g_free (_tmp27), NULL), _tmp26 = (g_free (_tmp26), NULL), _tmp28);
				_tmp30 = NULL;
				_tmp29 = NULL;
				_tmp31 = NULL;
				rhs_array_len = (_tmp31 = vala_ccode_base_module_get_variable_cexpression (self, _tmp30 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp29 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), 1)), _tmp30 = (g_free (_tmp30), NULL), _tmp29 = (g_free (_tmp29), NULL), _tmp31);
				_tmp32 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp32 = vala_ccode_assignment_new (lhs_array_size, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				(lhs_array_size == NULL) ? NULL : (lhs_array_size = (vala_ccode_node_unref (lhs_array_size), NULL));
				(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
			}
			_tmp33 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, _tmp33 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			_tmp35 = NULL;
			_tmp34 = NULL;
			rhs = (_tmp35 = (_tmp34 = (ValaCCodeExpression*) ccomma, (_tmp34 == NULL) ? NULL : vala_ccode_node_ref (_tmp34)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp35);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaDelegateType* _tmp36;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp37;
				ValaDelegate* d;
				_tmp36 = NULL;
				deleg_type = (_tmp36 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36));
				_tmp37 = NULL;
				d = (_tmp37 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
				if (vala_delegate_get_has_target (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp39;
					ValaCCodeExpression* _tmp38;
					char* _tmp41;
					char* _tmp40;
					ValaCCodeExpression* _tmp42;
					ValaCCodeExpression* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp43;
					ValaCCodeExpression* _tmp44;
					ValaCCodeExpression* _tmp46;
					ValaCCodeExpression* _tmp45;
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp39 = NULL;
					_tmp38 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp39 = vala_ccode_assignment_new (_tmp38 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
					_tmp41 = NULL;
					_tmp40 = NULL;
					_tmp42 = NULL;
					lhs_delegate_target = (_tmp42 = vala_ccode_base_module_get_variable_cexpression (self, _tmp41 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp40 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp41 = (g_free (_tmp41), NULL), _tmp40 = (g_free (_tmp40), NULL), _tmp42);
					rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_local_variable_get_initializer (local));
					_tmp43 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp43 = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
					_tmp44 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, _tmp44 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)));
					(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
					_tmp46 = NULL;
					_tmp45 = NULL;
					rhs = (_tmp46 = (_tmp45 = (ValaCCodeExpression*) ccomma, (_tmp45 == NULL) ? NULL : vala_ccode_node_ref (_tmp45)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp46);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(lhs_delegate_target == NULL) ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL));
					(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			}
		}
	} else {
		if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
			ValaCCodeExpression* _tmp47;
			_tmp47 = NULL;
			rhs = (_tmp47 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp47);
			if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaArrayType* _tmp48;
				ValaArrayType* array_type;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp55;
				ValaCCodeExpression* _tmp54;
				/* initialize array length variables*/
				_tmp48 = NULL;
				array_type = (_tmp48 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp48 == NULL) ? NULL : vala_code_node_ref (_tmp48));
				ccomma = vala_ccode_comma_expression_new ();
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeAssignment* _tmp53;
						ValaCCodeConstant* _tmp52;
						ValaCCodeExpression* _tmp51;
						char* _tmp50;
						char* _tmp49;
						_tmp53 = NULL;
						_tmp52 = NULL;
						_tmp51 = NULL;
						_tmp50 = NULL;
						_tmp49 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp53 = vala_ccode_assignment_new (_tmp51 = vala_ccode_base_module_get_variable_cexpression (self, _tmp50 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp49 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), (ValaCCodeExpression*) (_tmp52 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
						(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
						(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
						_tmp50 = (g_free (_tmp50), NULL);
						_tmp49 = (g_free (_tmp49), NULL);
					}
				}
				vala_ccode_comma_expression_append_expression (ccomma, rhs);
				_tmp55 = NULL;
				_tmp54 = NULL;
				rhs = (_tmp55 = (_tmp54 = (ValaCCodeExpression*) ccomma, (_tmp54 == NULL) ? NULL : vala_ccode_node_ref (_tmp54)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp55);
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
	}
	cfrag = vala_ccode_fragment_new ();
	if (self->pre_statement_fragment != NULL) {
		ValaCCodeFragment* _tmp56;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) self->pre_statement_fragment);
		_tmp56 = NULL;
		self->pre_statement_fragment = (_tmp56 = NULL, (self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL)), _tmp56);
	}
	_tmp57 = FALSE;
	if (self->current_method != NULL) {
		_tmp57 = vala_method_get_coroutine (self->current_method);
	} else {
		_tmp57 = FALSE;
	}
	if (_tmp57) {
		char* _tmp59;
		char* _tmp58;
		_tmp59 = NULL;
		_tmp58 = NULL;
		vala_ccode_struct_add_field (self->closure_struct, _tmp58 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)), _tmp59 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)));
		_tmp59 = (g_free (_tmp59), NULL);
		_tmp58 = (g_free (_tmp58), NULL);
		if (vala_local_variable_get_initializer (local) != NULL) {
			ValaCCodeExpressionStatement* _tmp64;
			ValaCCodeAssignment* _tmp63;
			ValaCCodeMemberAccess* _tmp62;
			char* _tmp61;
			ValaCCodeIdentifier* _tmp60;
			_tmp64 = NULL;
			_tmp63 = NULL;
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp64 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp63 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp62 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("data")), _tmp61 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
			(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
			_tmp61 = (g_free (_tmp61), NULL);
			(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		}
	} else {
		char* _tmp65;
		ValaCCodeVariableDeclarator* _tmp66;
		ValaCCodeVariableDeclarator* cvar;
		char* _tmp67;
		ValaCCodeDeclaration* _tmp68;
		ValaCCodeDeclaration* cdecl_;
		_tmp65 = NULL;
		_tmp66 = NULL;
		cvar = (_tmp66 = vala_ccode_variable_declarator_new (_tmp65 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), rhs), _tmp65 = (g_free (_tmp65), NULL), _tmp66);
		_tmp67 = NULL;
		_tmp68 = NULL;
		cdecl_ = (_tmp68 = vala_ccode_declaration_new (_tmp67 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp67 = (g_free (_tmp67), NULL), _tmp68);
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) cvar);
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
		/* try to initialize uninitialized variables
		 initialization not necessary for variables stored in closure*/
		if (vala_ccode_variable_declarator_get_initializer (cvar) == NULL) {
			ValaCCodeExpression* _tmp69;
			_tmp69 = NULL;
			vala_ccode_variable_declarator_set_initializer (cvar, _tmp69 = vala_ccode_base_module_default_value_for_type (self, vala_local_variable_get_variable_type (local), TRUE));
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
		}
		(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	}
	_tmp70 = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp70 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_local_variable_get_initializer (local));
	} else {
		_tmp70 = FALSE;
	}
	if (_tmp70) {
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_local_variable_get_initializer (local), cfrag);
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) cfrag);
	vala_symbol_set_active ((ValaSymbol*) local, TRUE);
	(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (list != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) list, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list)))) {
		ValaStruct* _tmp0;
		ValaStruct* st;
		ValaCCodeInitializerList* clist;
		GeeList* _tmp1;
		GeeIterator* _tmp2;
		GeeIterator* field_it;
		/* initializer is used as struct initializer */
		_tmp0 = NULL;
		st = (_tmp0 = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		clist = vala_ccode_initializer_list_new ();
		_tmp1 = NULL;
		_tmp2 = NULL;
		field_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = vala_struct_get_fields (st))), (_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)), _tmp2);
		{
			GeeList* _tmp3;
			GeeIterator* _tmp4;
			GeeIterator* _expr_it;
			_tmp3 = NULL;
			_tmp4 = NULL;
			_expr_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_initializer_list_get_initializers (list))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
			while (gee_iterator_next (_expr_it)) {
				ValaExpression* expr;
				ValaField* field;
				ValaCCodeExpression* _tmp7;
				ValaCCodeExpression* cexpr;
				char* ctype;
				expr = (ValaExpression*) gee_iterator_get (_expr_it);
				field = NULL;
				while (field == NULL) {
					ValaField* _tmp5;
					gee_iterator_next (field_it);
					_tmp5 = NULL;
					field = (_tmp5 = (ValaField*) gee_iterator_get (field_it), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp5);
					if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
						ValaField* _tmp6;
						/* we only initialize instance fields*/
						_tmp6 = NULL;
						field = (_tmp6 = NULL, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp6);
					}
				}
				_tmp7 = NULL;
				cexpr = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7));
				ctype = vala_field_get_ctype (field);
				if (ctype != NULL) {
					ValaCCodeExpression* _tmp8;
					_tmp8 = NULL;
					cexpr = (_tmp8 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, ctype), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp8);
				}
				vala_ccode_initializer_list_append (clist, cexpr);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
				(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				ctype = (g_free (ctype), NULL);
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
		(field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL));
	} else {
		ValaCCodeInitializerList* clist;
		clist = vala_ccode_initializer_list_new ();
		{
			GeeList* _tmp9;
			GeeIterator* _tmp10;
			GeeIterator* _expr_it;
			_tmp9 = NULL;
			_tmp10 = NULL;
			_expr_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_initializer_list_get_initializers (list))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
			while (gee_iterator_next (_expr_it)) {
				ValaExpression* expr;
				expr = (ValaExpression*) gee_iterator_get (_expr_it);
				vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	}
}


ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference) {
	ValaDataType* var_type;
	char* _tmp0;
	ValaLocalVariable* _tmp1;
	ValaLocalVariable* local;
	ValaLocalVariable* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	var_type = vala_data_type_copy (type);
	vala_data_type_set_value_owned (var_type, value_owned);
	_tmp0 = NULL;
	_tmp1 = NULL;
	local = (_tmp1 = vala_local_variable_new (var_type, _tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id), NULL, NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference ((ValaCodeNode*) local, vala_code_node_get_source_reference (node_reference));
	}
	self->next_temp_var_id++;
	_tmp2 = NULL;
	return (_tmp2 = local, (var_type == NULL) ? NULL : (var_type = (vala_code_node_unref (var_type), NULL)), _tmp2);
}


static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_GENERIC_TYPE (type)) {
		char* _tmp0;
		char* _tmp1;
		char* var_name;
		ValaCCodeMemberAccess* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeExpression* _tmp4;
		ValaCCodeExpression* _tmp5;
		_tmp0 = NULL;
		_tmp1 = NULL;
		var_name = (_tmp1 = g_strdup_printf ("%s_type", _tmp0 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("self")), "priv")), var_name), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp4), var_name = (g_free (var_name), NULL), _tmp5);
	} else {
		char* type_id;
		ValaCCodeExpression* _tmp7;
		type_id = vala_data_type_get_type_id (type);
		if (type_id == NULL) {
			char* _tmp6;
			_tmp6 = NULL;
			type_id = (_tmp6 = g_strdup ("G_TYPE_INVALID"), type_id = (g_free (type_id), NULL), _tmp6);
		}
		_tmp7 = NULL;
		return (_tmp7 = (ValaCCodeExpression*) vala_ccode_identifier_new (type_id), type_id = (g_free (type_id), NULL), _tmp7);
	}
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ERROR_TYPE (type)) {
		return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_copy");
	} else {
		if (vala_data_type_get_data_type (type) != NULL) {
			char* dup_function;
			ValaClass* _tmp2;
			ValaTypeSymbol* _tmp1;
			ValaClass* cl;
			ValaCCodeExpression* _tmp17;
			dup_function = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			cl = (_tmp2 = (_tmp1 = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
				char* _tmp3;
				gboolean _tmp4;
				_tmp3 = NULL;
				dup_function = (_tmp3 = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp3);
				_tmp4 = FALSE;
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
					_tmp4 = dup_function == NULL;
				} else {
					_tmp4 = FALSE;
				}
				if (_tmp4) {
					char* _tmp6;
					char* _tmp5;
					ValaCCodeExpression* _tmp7;
					_tmp6 = NULL;
					_tmp5 = NULL;
					vala_report_error (source_reference, _tmp6 = g_strdup_printf ("missing class prerequisite for interface `%s', add GLib.Object to interface declaration if unsure", _tmp5 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
					_tmp6 = (g_free (_tmp6), NULL);
					_tmp5 = (g_free (_tmp5), NULL);
					_tmp7 = NULL;
					return (_tmp7 = NULL, dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp7);
				}
			} else {
				gboolean _tmp8;
				_tmp8 = FALSE;
				if (cl != NULL) {
					_tmp8 = vala_class_get_is_immutable (cl);
				} else {
					_tmp8 = FALSE;
				}
				if (_tmp8) {
					char* _tmp9;
					/* allow duplicates of immutable instances as for example strings*/
					_tmp9 = NULL;
					dup_function = (_tmp9 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp9);
					if (dup_function == NULL) {
						char* _tmp10;
						_tmp10 = NULL;
						dup_function = (_tmp10 = g_strdup (""), dup_function = (g_free (dup_function), NULL), _tmp10);
					}
				} else {
					if (VALA_IS_VALUE_TYPE (type)) {
						char* _tmp11;
						gboolean _tmp12;
						_tmp11 = NULL;
						dup_function = (_tmp11 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp11);
						_tmp12 = FALSE;
						if (dup_function == NULL) {
							_tmp12 = vala_data_type_get_nullable (type);
						} else {
							_tmp12 = FALSE;
						}
						if (_tmp12) {
							char* _tmp13;
							_tmp13 = NULL;
							dup_function = (_tmp13 = vala_ccode_base_module_generate_struct_dup_wrapper (self, VALA_VALUE_TYPE (type)), dup_function = (g_free (dup_function), NULL), _tmp13);
						} else {
							if (dup_function == NULL) {
								char* _tmp14;
								_tmp14 = NULL;
								dup_function = (_tmp14 = g_strdup (""), dup_function = (g_free (dup_function), NULL), _tmp14);
							}
						}
					} else {
						char* _tmp15;
						ValaCCodeExpression* _tmp16;
						/* duplicating non-reference counted objects may cause side-effects (and performance issues)*/
						_tmp15 = NULL;
						vala_report_error (source_reference, _tmp15 = g_strdup_printf ("duplicating %s instance, use unowned variable or explicitly invoke copy method", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
						_tmp15 = (g_free (_tmp15), NULL);
						_tmp16 = NULL;
						return (_tmp16 = NULL, dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp16);
					}
				}
			}
			_tmp17 = NULL;
			return (_tmp17 = (ValaCCodeExpression*) vala_ccode_identifier_new (dup_function), dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp17);
		} else {
			gboolean _tmp18;
			_tmp18 = FALSE;
			if (vala_data_type_get_type_parameter (type) != NULL) {
				_tmp18 = VALA_IS_CLASS (self->current_type_symbol);
			} else {
				_tmp18 = FALSE;
			}
			if (_tmp18) {
				char* _tmp19;
				char* _tmp20;
				char* func_name;
				ValaCCodeMemberAccess* _tmp22;
				ValaCCodeIdentifier* _tmp21;
				ValaCCodeExpression* _tmp23;
				ValaCCodeExpression* _tmp24;
				_tmp19 = NULL;
				_tmp20 = NULL;
				func_name = (_tmp20 = g_strdup_printf ("%s_dup_func", _tmp19 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp19 = (g_free (_tmp19), NULL), _tmp20);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp23 = NULL;
				_tmp24 = NULL;
				return (_tmp24 = (_tmp23 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp22 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp23), func_name = (g_free (func_name), NULL), _tmp24);
			} else {
				if (VALA_IS_POINTER_TYPE (type)) {
					ValaPointerType* _tmp25;
					ValaPointerType* pointer_type;
					ValaCCodeExpression* _tmp26;
					_tmp25 = NULL;
					pointer_type = (_tmp25 = VALA_POINTER_TYPE (type), (_tmp25 == NULL) ? NULL : vala_code_node_ref (_tmp25));
					_tmp26 = NULL;
					return (_tmp26 = vala_ccode_base_module_get_dup_func_expression (self, vala_pointer_type_get_base_type (pointer_type), source_reference), (pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)), _tmp26);
				} else {
					return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
				}
			}
		}
	}
}


ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_dup_func_expression (self, type, source_reference);
}


static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type) {
	char* _tmp0;
	char* _tmp1;
	char* dup_func;
	char* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp43;
	char* _tmp44;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	dup_func = (_tmp1 = g_strdup_printf ("_%sdup", _tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_value_type_get_type_symbol (value_type))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, dup_func)) {
		/* wrapper already defined*/
		return dup_func;
	}
	/* declaration*/
	_tmp3 = NULL;
	_tmp4 = NULL;
	function = (_tmp4 = vala_ccode_function_new (dup_func, _tmp3 = vala_data_type_get_cname ((ValaDataType*) value_type)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("self", _tmp5 = vala_data_type_get_cname ((ValaDataType*) value_type)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_value_type_get_type_symbol (value_type) == VALA_TYPESYMBOL (self->gvalue_type)) {
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeReturnStatement* _tmp11;
		_tmp7 = NULL;
		_tmp8 = NULL;
		dup_call = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_boxed_copy"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("G_TYPE_VALUE")));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("self")));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		_tmp11 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp11 = vala_ccode_return_statement_new ((ValaCCodeExpression*) dup_call)));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		(dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL));
	} else {
		char* _tmp12;
		ValaCCodeDeclaration* _tmp13;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp14;
		ValaCCodeIdentifier* _tmp15;
		ValaCCodeFunctionCall* _tmp16;
		ValaCCodeFunctionCall* creation_call;
		ValaCCodeConstant* _tmp18;
		char* _tmp17;
		ValaCCodeConstant* _tmp19;
		ValaCCodeExpressionStatement* _tmp22;
		ValaCCodeAssignment* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		ValaStruct* _tmp24;
		ValaTypeSymbol* _tmp23;
		ValaStruct* st;
		gboolean _tmp25;
		ValaCCodeReturnStatement* _tmp42;
		ValaCCodeIdentifier* _tmp41;
		_tmp12 = NULL;
		_tmp13 = NULL;
		cdecl_ = (_tmp13 = vala_ccode_declaration_new (_tmp12 = vala_data_type_get_cname ((ValaDataType*) value_type)), _tmp12 = (g_free (_tmp12), NULL), _tmp13);
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new ("dup", NULL)));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
		_tmp15 = NULL;
		_tmp16 = NULL;
		creation_call = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_new0"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new (_tmp17 = vala_typesymbol_get_cname (vala_data_type_get_data_type ((ValaDataType*) value_type), FALSE))));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp19 = NULL;
		vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("1")));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("dup")), (ValaCCodeExpression*) creation_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		_tmp24 = NULL;
		_tmp23 = NULL;
		st = (_tmp24 = (_tmp23 = vala_data_type_get_data_type ((ValaDataType*) value_type), VALA_IS_STRUCT (_tmp23) ? ((ValaStruct*) _tmp23) : NULL), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
		_tmp25 = FALSE;
		if (st != NULL) {
			_tmp25 = vala_struct_is_disposable (st);
		} else {
			_tmp25 = FALSE;
		}
		if (_tmp25) {
			ValaCCodeIdentifier* _tmp27;
			char* _tmp26;
			ValaCCodeFunctionCall* _tmp28;
			ValaCCodeFunctionCall* copy_call;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeExpressionStatement* _tmp31;
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp28 = NULL;
			copy_call = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (_tmp26 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp26 = (g_free (_tmp26), NULL), _tmp28);
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("self")));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("dup")));
			(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
			_tmp31 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		} else {
			ValaCCodeIdentifier* _tmp32;
			ValaCCodeFunctionCall* _tmp33;
			ValaCCodeFunctionCall* sizeof_call;
			ValaCCodeConstant* _tmp35;
			char* _tmp34;
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeFunctionCall* _tmp37;
			ValaCCodeFunctionCall* copy_call;
			ValaCCodeIdentifier* _tmp38;
			ValaCCodeIdentifier* _tmp39;
			ValaCCodeExpressionStatement* _tmp40;
			_tmp32 = NULL;
			_tmp33 = NULL;
			sizeof_call = (_tmp33 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("sizeof"))), (_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)), _tmp33);
			_tmp35 = NULL;
			_tmp34 = NULL;
			vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp35 = vala_ccode_constant_new (_tmp34 = vala_typesymbol_get_cname (vala_data_type_get_data_type ((ValaDataType*) value_type), FALSE))));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			_tmp34 = (g_free (_tmp34), NULL);
			_tmp36 = NULL;
			_tmp37 = NULL;
			copy_call = (_tmp37 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("memcpy"))), (_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)), _tmp37);
			_tmp38 = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("dup")));
			(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
			_tmp39 = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("self")));
			(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) sizeof_call);
			_tmp40 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp40 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
			(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
			(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		}
		_tmp42 = NULL;
		_tmp41 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp42 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("dup")))));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	/* append to file*/
	_tmp43 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp43 = vala_ccode_function_copy (function)));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp44 = NULL;
	return (_tmp44 = dup_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp44);
}


ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->glist_type)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gslist_type);
	}
	if (_tmp0) {
		gboolean elements_require_free;
		ValaCCodeExpression* element_destroy_func_expression;
		gboolean _tmp4;
		/* create wrapper function to free list elements if necessary*/
		elements_require_free = FALSE;
		element_destroy_func_expression = NULL;
		{
			GeeList* _tmp1;
			GeeIterator* _tmp2;
			GeeIterator* _type_arg_it;
			_tmp1 = NULL;
			_tmp2 = NULL;
			_type_arg_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = vala_data_type_get_type_arguments (type))), (_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)), _tmp2);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				elements_require_free = vala_ccode_base_module_requires_destroy (self, type_arg);
				if (elements_require_free) {
					ValaCCodeExpression* _tmp3;
					_tmp3 = NULL;
					element_destroy_func_expression = (_tmp3 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp3);
				}
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
		_tmp4 = FALSE;
		if (elements_require_free) {
			_tmp4 = VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			char* _tmp5;
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* _tmp7;
			_tmp5 = NULL;
			_tmp6 = NULL;
			_tmp7 = NULL;
			return (_tmp7 = (_tmp6 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp5 = vala_ccode_base_module_generate_glist_free_wrapper (self, type, VALA_CCODE_IDENTIFIER (element_destroy_func_expression))), _tmp5 = (g_free (_tmp5), NULL), _tmp6), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp7);
		} else {
			char* _tmp8;
			ValaCCodeExpression* _tmp9;
			ValaCCodeExpression* _tmp10;
			_tmp8 = NULL;
			_tmp9 = NULL;
			_tmp10 = NULL;
			return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), _tmp8 = (g_free (_tmp8), NULL), _tmp9), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp10);
		}
		(element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (type)) {
			return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_free");
		} else {
			if (vala_data_type_get_data_type (type) != NULL) {
				char* unref_function;
				ValaCCodeExpression* _tmp23;
				unref_function = NULL;
				if (VALA_IS_REFERENCE_TYPE (type)) {
					if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
						char* _tmp12;
						gboolean _tmp13;
						_tmp12 = NULL;
						unref_function = (_tmp12 = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp12);
						_tmp13 = FALSE;
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
							_tmp13 = unref_function == NULL;
						} else {
							_tmp13 = FALSE;
						}
						if (_tmp13) {
							char* _tmp15;
							char* _tmp14;
							ValaCCodeExpression* _tmp16;
							_tmp15 = NULL;
							_tmp14 = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp15 = g_strdup_printf ("missing class prerequisite for interface `%s', add GLib.Object to interface declaration if unsure", _tmp14 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
							_tmp15 = (g_free (_tmp15), NULL);
							_tmp14 = (g_free (_tmp14), NULL);
							_tmp16 = NULL;
							return (_tmp16 = NULL, unref_function = (g_free (unref_function), NULL), _tmp16);
						}
					} else {
						char* _tmp17;
						_tmp17 = NULL;
						unref_function = (_tmp17 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp17);
					}
				} else {
					if (vala_data_type_get_nullable (type)) {
						char* _tmp18;
						_tmp18 = NULL;
						unref_function = (_tmp18 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp18);
						if (unref_function == NULL) {
							char* _tmp19;
							_tmp19 = NULL;
							unref_function = (_tmp19 = g_strdup ("g_free"), unref_function = (g_free (unref_function), NULL), _tmp19);
						}
					} else {
						ValaStruct* _tmp20;
						ValaStruct* st;
						char* _tmp21;
						_tmp20 = NULL;
						st = (_tmp20 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
						_tmp21 = NULL;
						unref_function = (_tmp21 = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), unref_function = (g_free (unref_function), NULL), _tmp21);
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					}
				}
				if (unref_function == NULL) {
					ValaCCodeExpression* _tmp22;
					_tmp22 = NULL;
					return (_tmp22 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), unref_function = (g_free (unref_function), NULL), _tmp22);
				}
				_tmp23 = NULL;
				return (_tmp23 = (ValaCCodeExpression*) vala_ccode_identifier_new (unref_function), unref_function = (g_free (unref_function), NULL), _tmp23);
			} else {
				gboolean _tmp24;
				_tmp24 = FALSE;
				if (vala_data_type_get_type_parameter (type) != NULL) {
					_tmp24 = VALA_IS_CLASS (self->current_type_symbol);
				} else {
					_tmp24 = FALSE;
				}
				if (_tmp24) {
					char* _tmp25;
					char* _tmp26;
					char* func_name;
					ValaCCodeMemberAccess* _tmp28;
					ValaCCodeIdentifier* _tmp27;
					ValaCCodeExpression* _tmp29;
					ValaCCodeExpression* _tmp30;
					_tmp25 = NULL;
					_tmp26 = NULL;
					func_name = (_tmp26 = g_strdup_printf ("%s_destroy_func", _tmp25 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp25 = (g_free (_tmp25), NULL), _tmp26);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp29 = NULL;
					_tmp30 = NULL;
					return (_tmp30 = (_tmp29 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp28 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp29), func_name = (g_free (func_name), NULL), _tmp30);
				} else {
					if (VALA_IS_ARRAY_TYPE (type)) {
						return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
					} else {
						if (VALA_IS_POINTER_TYPE (type)) {
							return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
						} else {
							return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
						}
					}
				}
			}
		}
	}
}


static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression) {
	char* _tmp0;
	char* _tmp1;
	char* destroy_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* element_free_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeCastExpression* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeIdentifier* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeFunction* _tmp18;
	char* _tmp19;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_type != NULL, NULL);
	g_return_val_if_fail (element_destroy_func_expression != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	destroy_func = (_tmp1 = g_strdup_printf ("_%s_%s", _tmp0 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type)), vala_ccode_identifier_get_name (element_destroy_func_expression)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		return destroy_func;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = vala_data_type_get_cname (list_type)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	element_free_call = NULL;
	if (vala_data_type_get_data_type (list_type) == VALA_TYPESYMBOL (self->glist_type)) {
		ValaCCodeFunctionCall* _tmp6;
		ValaCCodeIdentifier* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		element_free_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("g_list_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp6);
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		element_free_call = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_slist_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp8);
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	}
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("self")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) element_destroy_func_expression, "GFunc")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("NULL")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) element_free_call)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp15 = NULL;
	cfreecall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("self")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	/* append to file*/
	_tmp18 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp18 = vala_ccode_function_copy (function)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp19 = NULL;
	return (_tmp19 = destroy_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), (cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL)), _tmp19);
}


ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp2;
	ValaCCodeConstant* _tmp12;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeCommaExpression* ccomma;
	gboolean _tmp20;
	gboolean _tmp21;
	gboolean _tmp22;
	ValaCCodeConstant* _tmp32;
	ValaCCodeAssignment* cassign;
	gboolean _tmp33;
	gboolean _tmp34;
	gboolean uses_gfree;
	gboolean _tmp36;
	ValaCCodeConstant* _tmp38;
	ValaCCodeExpression* _tmp39;
	ValaCCodeExpression* _tmp40;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccall = (_tmp1 = vala_ccode_function_call_new (_tmp0 = vala_ccode_base_module_get_destroy_func_expression (self, type)), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = FALSE;
	if (VALA_IS_VALUE_TYPE (type)) {
		_tmp2 = !vala_data_type_get_nullable (type);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaCCodeUnaryExpression* _tmp3;
		/* normal value type, no null check*/
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gvalue_type)) {
			ValaCCodeIdentifier* _tmp4;
			ValaCCodeFunctionCall* _tmp5;
			ValaCCodeFunctionCall* cisvalid;
			ValaCCodeUnaryExpression* _tmp6;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeConstant* _tmp7;
			ValaCCodeConstant* _tmp8;
			ValaCCodeExpression* _tmp9;
			ValaCCodeExpression* _tmp10;
			/* g_value_unset must not be called for already unset values*/
			_tmp4 = NULL;
			_tmp5 = NULL;
			cisvalid = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("G_IS_VALUE"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (cisvalid, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
			_tmp7 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("NULL")));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			_tmp8 = NULL;
			_tmp9 = NULL;
			_tmp10 = NULL;
			return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisvalid, (ValaCCodeExpression*) ccomma, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("NULL"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9), (cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp10);
		} else {
			return (ValaCCodeExpression*) ccall;
		}
	}
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	_tmp12 = NULL;
	_tmp13 = NULL;
	cisnull = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, (ValaCCodeExpression*) (_tmp12 = vala_ccode_constant_new ("NULL"))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp14;
		ValaCCodeConstant* _tmp17;
		ValaCCodeExpression* _tmp16;
		ValaCCodeBinaryExpression* _tmp18;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp19;
		_tmp14 = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp14 = TRUE;
		} else {
			_tmp14 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp14) {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			return (_tmp15 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp15);
		}
		/* unref functions are optional for type parameters*/
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp18 = NULL;
		cunrefisnull = (_tmp18 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp16 = vala_ccode_base_module_get_destroy_func_expression (self, type), (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL"))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp18);
		_tmp19 = NULL;
		cisnull = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cunrefisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp19);
		(cunrefisnull == NULL) ? NULL : (cunrefisnull = (vala_ccode_node_unref (cunrefisnull), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	_tmp20 = FALSE;
	_tmp21 = FALSE;
	_tmp22 = FALSE;
	if (vala_data_type_get_data_type (type) == self->gstringbuilder_type) {
		_tmp22 = TRUE;
	} else {
		_tmp22 = vala_data_type_get_data_type (type) == self->garray_type;
	}
	if (_tmp22) {
		_tmp21 = TRUE;
	} else {
		_tmp21 = vala_data_type_get_data_type (type) == self->gbytearray_type;
	}
	if (_tmp21) {
		_tmp20 = TRUE;
	} else {
		_tmp20 = vala_data_type_get_data_type (type) == self->gptrarray_type;
	}
	if (_tmp20) {
		ValaCCodeConstant* _tmp23;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("TRUE")));
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaArrayType* _tmp24;
			ValaArrayType* array_type;
			gboolean _tmp25;
			_tmp24 = NULL;
			array_type = (_tmp24 = VALA_ARRAY_TYPE (type), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
			_tmp25 = FALSE;
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == NULL) {
				_tmp25 = TRUE;
			} else {
				_tmp25 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)));
			}
			if (_tmp25) {
				gboolean first;
				ValaCCodeExpression* csizeexpr;
				ValaCCodeIdentifier* _tmp29;
				ValaCCodeCastExpression* _tmp31;
				ValaCCodeExpression* _tmp30;
				self->requires_array_free = TRUE;
				first = TRUE;
				csizeexpr = NULL;
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						if (first) {
							ValaCCodeExpression* _tmp26;
							_tmp26 = NULL;
							csizeexpr = (_tmp26 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp26);
							first = FALSE;
						} else {
							ValaCCodeExpression* _tmp28;
							ValaCCodeExpression* _tmp27;
							_tmp28 = NULL;
							_tmp27 = NULL;
							csizeexpr = (_tmp28 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp27 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp28);
							(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
						}
					}
				}
				_tmp29 = NULL;
				vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("_vala_array_free")));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				vala_ccode_function_call_add_argument (ccall, csizeexpr);
				_tmp31 = NULL;
				_tmp30 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp31 = vala_ccode_cast_expression_new (_tmp30 = vala_ccode_base_module_get_destroy_func_expression (self, vala_array_type_get_element_type (array_type)), "GDestroyNotify")));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
	_tmp32 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp32 = vala_ccode_constant_new ("NULL")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	cassign = vala_ccode_assignment_new (cvar, (ValaCCodeExpression*) ccomma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp33 = FALSE;
	_tmp34 = FALSE;
	if (vala_data_type_get_data_type (type) != NULL) {
		_tmp34 = !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type));
	} else {
		_tmp34 = FALSE;
	}
	if (_tmp34) {
		char* _tmp35;
		_tmp35 = NULL;
		_tmp33 = _vala_strcmp0 (_tmp35 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), "g_free") == 0;
		_tmp35 = (g_free (_tmp35), NULL);
	} else {
		_tmp33 = FALSE;
	}
	/* g_free (NULL) is allowed*/
	uses_gfree = _tmp33;
	_tmp36 = FALSE;
	if (uses_gfree) {
		_tmp36 = TRUE;
	} else {
		_tmp36 = VALA_IS_ARRAY_TYPE (type);
	}
	uses_gfree = _tmp36;
	if (uses_gfree) {
		ValaCCodeExpression* _tmp37;
		_tmp37 = NULL;
		return (_tmp37 = (ValaCCodeExpression*) cassign, (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), _tmp37);
	}
	_tmp38 = NULL;
	_tmp39 = NULL;
	_tmp40 = NULL;
	return (_tmp40 = (_tmp39 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp38 = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) cassign), (_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)), _tmp39), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), (cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL)), _tmp40);
}


static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* full_expr_var;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeExpression* _tmp3;
	ValaCCodeExpression* _tmp7;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear ((GeeCollection*) expr->temp_vars);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			gee_collection_add ((GeeCollection*) expr->temp_vars, local);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (self->temp_ref_vars)) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)), _tmp2);
	}
	full_expr_var = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, (ValaCodeNode*) expr);
	gee_collection_add ((GeeCollection*) expr->temp_vars, full_expr_var);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, (ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new (_tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) full_expr_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* _tmp5;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (expr_list, _tmp6 = vala_ccode_base_module_get_unref_expression (self, _tmp5 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	_tmp7 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, _tmp7 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) full_expr_var)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) expr_list);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
	(full_expr_var == NULL) ? NULL : (full_expr_var = (vala_code_node_unref (full_expr_var), NULL));
	(expr_list == NULL) ? NULL : (expr_list = (vala_ccode_node_unref (expr_list), NULL));
}


void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (temp_vars != NULL);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) temp_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp0;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp0 = FALSE;
			if (self->current_method != NULL) {
				_tmp0 = vala_method_get_coroutine (self->current_method);
			} else {
				_tmp0 = FALSE;
			}
			if (_tmp0) {
				char* _tmp1;
				_tmp1 = NULL;
				vala_ccode_struct_add_field (self->closure_struct, _tmp1 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)), vala_symbol_get_name ((ValaSymbol*) local));
				_tmp1 = (g_free (_tmp1), NULL);
			} else {
				char* _tmp2;
				ValaCCodeDeclaration* _tmp3;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				ValaStruct* _tmp5;
				ValaTypeSymbol* _tmp4;
				ValaStruct* st;
				/* no initialization necessary, closure struct is zeroed*/
				_tmp2 = NULL;
				_tmp3 = NULL;
				cdecl_ = (_tmp3 = vala_ccode_declaration_new (_tmp2 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				/* sets #line*/
				vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) vardecl);
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) vardecl);
				_tmp5 = NULL;
				_tmp4 = NULL;
				st = (_tmp5 = (_tmp4 = vala_data_type_get_data_type (vala_local_variable_get_variable_type (local)), VALA_IS_STRUCT (_tmp4) ? ((ValaStruct*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) local), "*")) {
				} else {
					if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
						ValaCCodeConstant* _tmp6;
						_tmp6 = NULL;
						vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new ("NULL")));
						(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
					} else {
						gboolean _tmp7;
						_tmp7 = FALSE;
						if (st != NULL) {
							_tmp7 = !vala_struct_is_simple_type (st);
						} else {
							_tmp7 = FALSE;
						}
						if (_tmp7) {
							ValaCCodeInitializerList* clist;
							ValaCCodeConstant* _tmp8;
							/* 0-initialize struct with struct initializer { 0 }
							 necessary as they will be passed by reference*/
							clist = vala_ccode_initializer_list_new ();
							_tmp8 = NULL;
							vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("0")));
							(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
							vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) clist);
							(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
						}
					}
				}
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				(vardecl == NULL) ? NULL : (vardecl = (vala_ccode_node_unref (vardecl), NULL));
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
}


static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpressionStatement* _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp1 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_expression_statement_get_expression (stmt));
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_expression_statement_get_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	_tmp2 = FALSE;
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (self->temp_vars)) == 0) {
		_tmp2 = self->pre_statement_fragment == NULL;
	} else {
		_tmp2 = FALSE;
	}
	/* free temporary objects */
	if (_tmp2) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, (GeeList*) self->temp_vars);
	if (self->pre_statement_fragment != NULL) {
		ValaCCodeFragment* _tmp3;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) self->pre_statement_fragment);
		_tmp3 = NULL;
		self->pre_statement_fragment = (_tmp3 = NULL, (self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL)), _tmp3);
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp6;
			ValaCCodeExpression* _tmp5;
			ValaCCodeIdentifier* _tmp4;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp4 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new (_tmp5 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (temp_vars != NULL);
	/* declare temporary variables */
	if (gee_collection_get_size ((GeeCollection*) temp_vars) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp1;
			gboolean _tmp2;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp1 = FALSE;
			_tmp2 = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2 = !vala_local_variable_get_floating (local);
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				_tmp1 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5;
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new (_tmp4 = vala_ccode_base_module_get_unref_expression (self, _tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (stop_at_loop) {
		gboolean _tmp6;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp9;
		_tmp6 = FALSE;
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		_tmp9 = FALSE;
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b))) {
			_tmp9 = TRUE;
		} else {
			_tmp9 = VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp9) {
			_tmp8 = TRUE;
		} else {
			_tmp8 = VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp8) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp7) {
			_tmp6 = TRUE;
		} else {
			_tmp6 = VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp6) {
			(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
			(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
}


void vala_ccode_base_module_append_error_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, ValaTryStatement* current_try) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (current_try != NULL);
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp1;
			gboolean _tmp2;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp1 = FALSE;
			_tmp2 = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2 = !vala_local_variable_get_floating (local);
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				_tmp1 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5;
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new (_tmp4 = vala_ccode_base_module_get_unref_expression (self, _tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (sym == VALA_SYMBOL (vala_try_statement_get_body (current_try))) {
		(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
		(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
		return;
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_error_free (self, vala_symbol_get_parent_symbol (sym), cfrag, current_try);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
}


static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (cfrag != NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _param_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_param_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_method_get_parameters (m))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp2;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp2 = FALSE;
			if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
				_tmp2 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5;
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new (_tmp4 = vala_ccode_base_module_get_unref_expression (self, _tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) param)), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
}


void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop) {
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp1;
			gboolean _tmp2;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp1 = FALSE;
			_tmp2 = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2 = !vala_local_variable_get_floating (local);
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				_tmp1 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				found = TRUE;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, _tmp4 = vala_ccode_base_module_get_unref_expression (self, _tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		gboolean _tmp5;
		_tmp5 = FALSE;
		if (vala_ccode_base_module_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop)) {
			_tmp5 = TRUE;
		} else {
			_tmp5 = found;
		}
		found = _tmp5;
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			gboolean _tmp6;
			_tmp6 = FALSE;
			if (vala_ccode_base_module_append_param_free_expr (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), ccomma)) {
				_tmp6 = TRUE;
			} else {
				_tmp6 = found;
			}
			found = _tmp6;
		}
	}
	return (_tmp7 = found, (b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL)), (local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL)), _tmp7);
}


static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma) {
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _param_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_param_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_method_get_parameters (m))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp2;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp2 = FALSE;
			if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
				_tmp2 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				found = TRUE;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, _tmp4 = vala_ccode_base_module_get_unref_expression (self, _tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) param)), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	return found;
}


static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeExpression* _tmp3;
	ValaCCodeExpression* _tmp5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)), _tmp2);
	}
	return_expr_decl = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, (ValaCodeNode*) expr);
	ccomma = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new (_tmp3 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	if (!vala_ccode_base_module_append_local_free_expr (self, self->current_symbol, ccomma, FALSE)) {
		/* no local variables need to be freed */
		(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
		(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		return;
	}
	_tmp5 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, _tmp5 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	gee_collection_add ((GeeCollection*) expr->temp_vars, return_expr_decl);
	(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
	(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
}


static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	/* avoid unnecessary ref/unref pair*/
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaLocalVariable* _tmp1;
		ValaSymbol* _tmp0;
		ValaLocalVariable* local;
		gboolean _tmp2;
		gboolean _tmp3;
		_tmp1 = NULL;
		_tmp0 = NULL;
		local = (_tmp1 = (_tmp0 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		_tmp3 = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp3 = local != NULL;
		} else {
			_tmp3 = FALSE;
		}
		if (_tmp3) {
			_tmp2 = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't ref expression*/
			vala_data_type_set_value_owned (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE);
		}
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp4;
		_tmp4 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp4 = vala_ccode_return_statement_new (NULL)));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		vala_ccode_base_module_create_local_free (self, (ValaCodeNode*) stmt, FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaLocalVariable* _tmp6;
		ValaSymbol* _tmp5;
		ValaLocalVariable* local;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp11;
		gboolean _tmp12;
		gboolean _tmp21;
		gboolean _tmp22;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		_tmp6 = NULL;
		_tmp5 = NULL;
		local = (_tmp6 = (_tmp5 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp5) ? ((ValaLocalVariable*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp8 = local != NULL;
		} else {
			_tmp8 = FALSE;
		}
		if (_tmp8) {
			_tmp7 = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp7 = FALSE;
		}
		if (_tmp7) {
			ValaSymbol* _tmp10;
			ValaSymbol* _tmp9;
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't unref variable*/
			_tmp10 = NULL;
			_tmp9 = NULL;
			return_expression_symbol = (_tmp10 = (_tmp9 = (ValaSymbol*) local, (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9)), (return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL)), _tmp10);
			vala_symbol_set_active (return_expression_symbol, FALSE);
		}
		_tmp11 = FALSE;
		_tmp12 = FALSE;
		if (self->current_method != NULL) {
			_tmp12 = !vala_method_get_no_array_length (self->current_method);
		} else {
			_tmp12 = FALSE;
		}
		if (_tmp12) {
			_tmp11 = VALA_IS_ARRAY_TYPE (self->current_return_type);
		} else {
			_tmp11 = FALSE;
		}
		/* return array length if appropriate*/
		if (_tmp11) {
			ValaLocalVariable* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp14;
			ValaCCodeExpression* _tmp13;
			ValaArrayType* _tmp15;
			ValaArrayType* array_type;
			ValaCCodeExpression* _tmp20;
			return_expr_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp14 = vala_ccode_assignment_new (_tmp13 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			_tmp15 = NULL;
			array_type = (_tmp15 = VALA_ARRAY_TYPE (self->current_return_type), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeIdentifier* _tmp17;
					char* _tmp16;
					ValaCCodeUnaryExpression* _tmp18;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp19;
					_tmp17 = NULL;
					_tmp16 = NULL;
					_tmp18 = NULL;
					len_l = (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp18);
					len_r = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_return_statement_get_return_expression (stmt), dim);
					_tmp19 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp19 = vala_ccode_assignment_new ((ValaCCodeExpression*) len_l, len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(len_l == NULL) ? NULL : (len_l = (vala_ccode_node_unref (len_l), NULL));
					(len_r == NULL) ? NULL : (len_r = (vala_ccode_node_unref (len_r), NULL));
				}
			}
			_tmp20 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, _tmp20 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt), (ValaCCodeNode*) ccomma);
			gee_collection_add ((GeeCollection*) vala_return_statement_get_return_expression (stmt)->temp_vars, return_expr_decl);
			(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		vala_ccode_base_module_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		_tmp21 = FALSE;
		_tmp22 = FALSE;
		if (self->current_property_accessor != NULL) {
			_tmp22 = vala_property_accessor_get_readable (self->current_property_accessor);
		} else {
			_tmp22 = FALSE;
		}
		if (_tmp22) {
			_tmp21 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (self->current_property_accessor)));
		} else {
			_tmp21 = FALSE;
		}
		/* Property getters of non simple structs shall return the struct value as out parameter,
		 therefore replace any return statement with an assignment statement to the out formal
		 paramenter and insert an empty return statement afterwards.*/
		if (_tmp21) {
			ValaCCodeFragment* cfragment;
			ValaCCodeExpressionStatement* _tmp25;
			ValaCCodeAssignment* _tmp24;
			ValaCCodeIdentifier* _tmp23;
			ValaCCodeReturnStatement* _tmp26;
			cfragment = vala_ccode_fragment_new ();
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			vala_ccode_fragment_append (cfragment, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("*value")), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
			(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			_tmp26 = NULL;
			vala_ccode_fragment_append (cfragment, (ValaCCodeNode*) (_tmp26 = vala_ccode_return_statement_new (NULL)));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfragment);
			(cfragment == NULL) ? NULL : (cfragment = (vala_ccode_node_unref (cfragment), NULL));
		} else {
			ValaCCodeReturnStatement* _tmp27;
			_tmp27 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp27 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))))));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		}
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL));
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
}


static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp7;
	char* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaMethod* _tmp8;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	char* _tmp15;
	ValaMethod* _tmp14;
	ValaCCodeUnaryExpression* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			l = (_tmp2 = (ValaCCodeExpression*) vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp2);
		} else {
			ValaCCodeExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			l = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp4);
		}
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	l = (_tmp7 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer (l, "priv")), _tmp6 = vala_ccode_base_module_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	fc = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_cname (_tmp8 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "lock")))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_lock_statement_get_body (stmt)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	fc = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_cname (_tmp14 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "unlock")))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp15 = (g_free (_tmp15), NULL);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cn);
	(cn == NULL) ? NULL : (cn = (vala_ccode_node_unref (cn), NULL));
	(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
	(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	(inner_node == NULL) ? NULL : (inner_node = (vala_code_node_unref (inner_node), NULL));
}


static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaPointerType* _tmp0;
	ValaPointerType* pointer_type;
	ValaDataType* _tmp1;
	ValaDataType* type;
	gboolean _tmp2;
	ValaCCodeExpression* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp7;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	pointer_type = (_tmp0 = VALA_POINTER_TYPE (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	type = (_tmp1 = (ValaDataType*) pointer_type, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)) != NULL) {
		_tmp2 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)));
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaDataType* _tmp4;
		ValaDataType* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		type = (_tmp4 = (_tmp3 = vala_pointer_type_get_base_type (pointer_type), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4);
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	ccall = (_tmp6 = vala_ccode_function_call_new (_tmp5 = vala_ccode_base_module_get_destroy_func_expression (self, type)), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_delete_statement_get_expression (stmt))));
	_tmp7 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = FALSE;
	if (vala_code_node_get_ccodenode ((ValaCodeNode*) expr) != NULL) {
		_tmp0 = !vala_expression_get_lvalue (expr);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gboolean _tmp1;
		ValaCCodeExpression* _tmp3;
		gboolean _tmp4;
		_tmp1 = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_value_type (expr))) {
			_tmp1 = !VALA_IS_GENERIC_TYPE (vala_expression_get_value_type (expr));
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_value_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp2;
				/* GArray doesn't use pointer-based generics*/
				_tmp2 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp2 = vala_ccode_base_module_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr))));
				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
			}
		}
		/* memory management, implicit casts, and boxing/unboxing*/
		_tmp3 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_base_module_transform_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr), vala_expression_get_target_type (expr), expr)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp4 = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_target_type (expr))) {
			_tmp4 = !VALA_IS_GENERIC_TYPE (vala_expression_get_target_type (expr));
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_target_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp5;
				/* GArray doesn't use pointer-based generics*/
				_tmp5 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp5 = vala_ccode_base_module_convert_to_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_target_type (expr))));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			}
		}
	}
}


static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr) {
	ValaCCodeBaseModule * self;
	const char* _tmp0;
	ValaCCodeConstant* _tmp1;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	if (vala_boolean_literal_get_value (expr)) {
		_tmp0 = "TRUE";
	} else {
		_tmp0 = "FALSE";
	}
	_tmp1 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_ccode_constant_new (_tmp0)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
}


static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = FALSE;
	if (vala_character_literal_get_char (expr) >= 0x20) {
		_tmp0 = vala_character_literal_get_char (expr) < 0x80;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaCCodeConstant* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_ccode_constant_new (vala_character_literal_get_value (expr))));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	} else {
		ValaCCodeConstant* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_constant_new (_tmp2 = g_strdup_printf ("%uU", (guint) vala_character_literal_get_char (expr)))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr) {
	ValaCCodeBaseModule * self;
	const char* _tmp0;
	char* c_literal;
	gboolean _tmp1;
	gboolean _tmp3;
	gboolean _tmp4;
	ValaCCodeConstant* _tmp9;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	c_literal = (_tmp0 = vala_real_literal_get_value (expr), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	_tmp1 = FALSE;
	if (g_str_has_suffix (c_literal, "d")) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = g_str_has_suffix (c_literal, "D");
	}
	if (_tmp1) {
		char* _tmp2;
		/* there is no suffix for double in C*/
		_tmp2 = NULL;
		c_literal = (_tmp2 = string_substring (c_literal, (glong) 0, string_get_length (c_literal) - 1), c_literal = (g_free (c_literal), NULL), _tmp2);
	}
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (string_contains (c_literal, ".")) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = string_contains (c_literal, "e");
	}
	if (_tmp4) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = string_contains (c_literal, "E");
	}
	if (!_tmp3) {
		gboolean _tmp5;
		_tmp5 = FALSE;
		if (string_contains (c_literal, "f")) {
			_tmp5 = TRUE;
		} else {
			_tmp5 = string_contains (c_literal, "F");
		}
		/* C requires period or exponent part for floating constants*/
		if (_tmp5) {
			char* _tmp7;
			char* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			c_literal = (_tmp7 = g_strconcat (_tmp6 = string_substring (c_literal, (glong) 0, string_get_length (c_literal) - 1), ".f", NULL), c_literal = (g_free (c_literal), NULL), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
		} else {
			char* _tmp8;
			_tmp8 = NULL;
			c_literal = (_tmp8 = g_strconcat (c_literal, ".", NULL), c_literal = (g_free (c_literal), NULL), _tmp8);
		}
	}
	_tmp9 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_ccode_constant_new (c_literal)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	c_literal = (g_free (c_literal), NULL);
}


static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new ("NULL")));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cname (self, delegate_cname);
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	g_assert_not_reached ();
}


ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cexpression (self, delegate_expr);
}


static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_destroy_notify_cname (self, delegate_cname);
}


static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr) {
	ValaCCodeBaseModule * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_instance_cast_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("self")), vala_data_type_get_data_type (vala_expression_get_value_type ((ValaExpression*) expr)))));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator _tmp8;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp9;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	ma = vala_ccode_base_module_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeExpression* _tmp1;
		ValaCCodeBinaryOperator _tmp3;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp5;
		ValaCCodeExpression* _tmp4;
		ValaCCodeBinaryExpression* _tmp6;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp7;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_property_get_property_type (prop), TRUE, (ValaCodeNode*) expr);
		gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_assignment_new (_tmp1 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp3 = 0;
		if (vala_postfix_expression_get_increment (expr)) {
			_tmp3 = VALA_CCODE_BINARY_OPERATOR_PLUS;
		} else {
			_tmp3 = VALA_CCODE_BINARY_OPERATOR_MINUS;
		}
		/* increment/decrement property*/
		op = _tmp3;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp6 = NULL;
		cexpr = (_tmp6 = vala_ccode_binary_expression_new (op, _tmp4 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), (ValaCCodeExpression*) (_tmp5 = vala_ccode_constant_new ("1"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp6);
		ccall = vala_ccode_base_module_get_property_set_call (self, prop, ma, (ValaCCodeExpression*) cexpr);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
		/* return previous value*/
		_tmp7 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return;
	}
	_tmp8 = 0;
	if (vala_postfix_expression_get_increment (expr)) {
		_tmp8 = VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT;
	} else {
		_tmp8 = VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT;
	}
	op = _tmp8;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
}


static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaMemberAccess* _tmp1;
	ValaMemberAccess* ma;
	ValaMemberAccess* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (!VALA_IS_MEMBER_ACCESS (expr)) {
		return NULL;
	}
	_tmp1 = NULL;
	ma = (_tmp1 = VALA_MEMBER_ACCESS (expr), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		return ma;
	}
	_tmp3 = NULL;
	return (_tmp3 = NULL, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp3);
}


gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type) {
	ValaClass* _tmp2;
	ValaTypeSymbol* _tmp1;
	ValaClass* cl;
	gboolean _tmp3;
	gboolean _tmp4;
	gboolean _tmp9;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	cl = (_tmp2 = (_tmp1 = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (cl != NULL) {
		_tmp4 = vala_typesymbol_is_reference_counting ((ValaTypeSymbol*) cl);
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		char* _tmp5;
		_tmp5 = NULL;
		_tmp3 = _vala_strcmp0 (_tmp5 = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl), "") == 0;
		_tmp5 = (g_free (_tmp5), NULL);
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		gboolean _tmp6;
		/* empty ref_function => no ref necessary*/
		return (_tmp6 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp6);
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp7;
		_tmp7 = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp7) {
			gboolean _tmp8;
			return (_tmp8 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp8);
		}
	}
	return (_tmp9 = TRUE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp9);
}


gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type) {
	ValaClass* _tmp2;
	ValaTypeSymbol* _tmp1;
	ValaClass* cl;
	gboolean _tmp3;
	gboolean _tmp4;
	gboolean _tmp9;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	cl = (_tmp2 = (_tmp1 = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (cl != NULL) {
		_tmp4 = vala_typesymbol_is_reference_counting ((ValaTypeSymbol*) cl);
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		char* _tmp5;
		_tmp5 = NULL;
		_tmp3 = _vala_strcmp0 (_tmp5 = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) cl), "") == 0;
		_tmp5 = (g_free (_tmp5), NULL);
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		gboolean _tmp6;
		/* empty unref_function => no unref necessary*/
		return (_tmp6 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp6);
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp7;
		_tmp7 = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp7) {
			gboolean _tmp8;
			return (_tmp8 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp8);
		}
	}
	return (_tmp9 = TRUE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp9);
}


static gboolean vala_ccode_base_module_is_ref_function_void (ValaCCodeBaseModule* self, ValaDataType* type) {
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_ref_function_void (cl);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		gboolean _tmp3;
		return (_tmp3 = TRUE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp3);
	} else {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	gboolean _tmp0;
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp22;
	gboolean _tmp23;
	gboolean _tmp24;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp0 = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		ValaValueType* _tmp1;
		ValaValueType* vt;
		ValaStruct* _tmp2;
		ValaStruct* st;
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		ValaCCodeFunctionCall* _tmp5;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeUnaryExpression* _tmp6;
		ValaCCodeUnaryExpression* _tmp7;
		ValaCCodeCommaExpression* ccomma;
		char* _tmp8;
		gboolean _tmp9;
		/* normal value type, no null check
		 (copy (&expr, &temp), temp)*/
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp1 = NULL;
		vt = (_tmp1 = VALA_VALUE_TYPE (expression_type), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = NULL;
		st = (_tmp2 = VALA_STRUCT (vala_value_type_get_type_symbol (vt)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		copy_call = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp8 = NULL;
		if ((_tmp9 = _vala_strcmp0 (_tmp8 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "g_value_copy") == 0, _tmp8 = (g_free (_tmp8), NULL), _tmp9)) {
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeFunctionCall* _tmp11;
			ValaCCodeFunctionCall* value_type_call;
			ValaCCodeUnaryExpression* _tmp12;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeFunctionCall* _tmp14;
			ValaCCodeFunctionCall* init_call;
			ValaCCodeUnaryExpression* _tmp15;
			/* GValue requires g_value_init in addition to g_value_copy*/
			_tmp10 = NULL;
			_tmp11 = NULL;
			value_type_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (value_type_call, (ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
			_tmp13 = NULL;
			_tmp14 = NULL;
			init_call = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_value_init"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
			_tmp15 = NULL;
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) (_tmp15 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
			(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) value_type_call);
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) init_call);
			(value_type_call == NULL) ? NULL : (value_type_call = (vala_ccode_node_unref (value_type_call), NULL));
			(init_call == NULL) ? NULL : (init_call = (vala_ccode_node_unref (init_call), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) copy_call);
		vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		if (vala_data_type_get_data_type (expression_type) == VALA_TYPESYMBOL (self->gvalue_type)) {
			ValaCCodeIdentifier* _tmp16;
			ValaCCodeFunctionCall* _tmp17;
			ValaCCodeFunctionCall* cisvalid;
			ValaCCodeUnaryExpression* _tmp18;
			ValaCCodeExpression* _tmp19;
			/* g_value_init/copy must not be called for uninitialized values*/
			_tmp16 = NULL;
			_tmp17 = NULL;
			cisvalid = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("G_IS_VALUE"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
			_tmp18 = NULL;
			vala_ccode_function_call_add_argument (cisvalid, (ValaCCodeExpression*) (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
			_tmp19 = NULL;
			return (_tmp19 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisvalid, (ValaCCodeExpression*) ccomma, cexpr), (cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), _tmp19);
		} else {
			ValaCCodeExpression* _tmp20;
			_tmp20 = NULL;
			return (_tmp20 = (ValaCCodeExpression*) ccomma, (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL)), _tmp20);
		}
		(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
		(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
		(vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node));
	if (dupexpr == NULL) {
		ValaCCodeExpression* _tmp21;
		vala_code_node_set_error (node, TRUE);
		_tmp21 = NULL;
		return (_tmp21 = NULL, (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), _tmp21);
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	_tmp22 = FALSE;
	_tmp23 = FALSE;
	_tmp24 = FALSE;
	if (!VALA_IS_ARRAY_TYPE (expression_type)) {
		_tmp24 = expr != NULL;
	} else {
		_tmp24 = FALSE;
	}
	if (_tmp24) {
		_tmp23 = vala_expression_is_non_null (expr);
	} else {
		_tmp23 = FALSE;
	}
	if (_tmp23) {
		_tmp22 = !vala_ccode_base_module_is_ref_function_void (self, expression_type);
	} else {
		_tmp22 = FALSE;
	}
	if (_tmp22) {
		ValaCCodeExpression* _tmp25;
		/* expression is non-null*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp25 = NULL;
		return (_tmp25 = (ValaCCodeExpression*) ccall, (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), _tmp25);
	} else {
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		ValaCCodeConstant* _tmp26;
		ValaCCodeBinaryExpression* _tmp27;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp39;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp42;
		ValaCCodeExpression* _tmp43;
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp26 = NULL;
		_tmp27 = NULL;
		cisnull = (_tmp27 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ctemp, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new ("NULL"))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp27);
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeConstant* _tmp31;
			ValaCCodeExpression* _tmp30;
			ValaCCodeBinaryExpression* _tmp32;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp33;
			if (!VALA_IS_CLASS (self->current_type_symbol)) {
				ValaCCodeExpression* _tmp28;
				ValaCCodeExpression* _tmp29;
				_tmp28 = NULL;
				_tmp29 = NULL;
				return (_tmp29 = (_tmp28 = cexpr, (_tmp28 == NULL) ? NULL : vala_ccode_node_ref (_tmp28)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp29);
			}
			/* dup functions are optional for type parameters*/
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp32 = NULL;
			cdupisnull = (_tmp32 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp30 = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node)), (ValaCCodeExpression*) (_tmp31 = vala_ccode_constant_new ("NULL"))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp32);
			_tmp33 = NULL;
			cisnull = (_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cdupisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp33);
			(cdupisnull == NULL) ? NULL : (cdupisnull = (vala_ccode_node_unref (cdupisnull), NULL));
		}
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeCastExpression* _tmp34;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp34 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_cast_expression_new (ctemp, "gpointer")));
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		} else {
			vala_ccode_function_call_add_argument (ccall, ctemp);
		}
		if (VALA_IS_ARRAY_TYPE (expression_type)) {
			ValaArrayType* _tmp35;
			ValaArrayType* array_type;
			gboolean first;
			ValaCCodeExpression* csizeexpr;
			_tmp35 = NULL;
			array_type = (_tmp35 = VALA_ARRAY_TYPE (expression_type), (_tmp35 == NULL) ? NULL : vala_code_node_ref (_tmp35));
			first = TRUE;
			csizeexpr = NULL;
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					if (first) {
						ValaCCodeExpression* _tmp36;
						_tmp36 = NULL;
						csizeexpr = (_tmp36 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp36);
						first = FALSE;
					} else {
						ValaCCodeExpression* _tmp38;
						ValaCCodeExpression* _tmp37;
						_tmp38 = NULL;
						_tmp37 = NULL;
						csizeexpr = (_tmp38 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp37 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp38);
						(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					}
				}
			}
			vala_ccode_function_call_add_argument (ccall, csizeexpr);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp39 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp39 = vala_ccode_assignment_new (ctemp, cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		cifnull = NULL;
		if (vala_data_type_get_data_type (expression_type) != NULL) {
			ValaCCodeExpression* _tmp40;
			_tmp40 = NULL;
			cifnull = (_tmp40 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp40);
		} else {
			ValaCCodeExpression* _tmp41;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp41 = NULL;
			cifnull = (_tmp41 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (ctemp, "gpointer"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp41);
		}
		_tmp42 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp42 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, cifnull, (ValaCCodeExpression*) ccall)));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		/* repeat temp variable at the end of the comma expression
		 if the ref function returns void*/
		if (vala_ccode_base_module_is_ref_function_void (self, expression_type)) {
			vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		}
		_tmp43 = NULL;
		return (_tmp43 = (ValaCCodeExpression*) ccomma, (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp43);
	}
	(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static gboolean vala_ccode_base_module_is_reference_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (type_arg) != NULL) {
		_tmp0 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type_arg));
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		return TRUE;
	} else {
		return FALSE;
	}
}


static gboolean vala_ccode_base_module_is_nullable_value_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0 = FALSE;
	if (VALA_IS_VALUE_TYPE (type_arg)) {
		_tmp0 = vala_data_type_get_nullable (type_arg);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		return TRUE;
	} else {
		return FALSE;
	}
}


static gboolean vala_ccode_base_module_is_signed_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	ValaStruct* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaStruct* st;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	st = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (type_arg), VALA_IS_STRUCT (_tmp0) ? ((ValaStruct*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (vala_data_type_get_nullable (type_arg)) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp2);
	} else {
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type)) {
			gboolean _tmp3;
			return (_tmp3 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp3);
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->char_type)) {
				gboolean _tmp4;
				return (_tmp4 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp4);
			} else {
				if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->unichar_type)) {
					gboolean _tmp5;
					return (_tmp5 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp5);
				} else {
					if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->short_type)) {
						gboolean _tmp6;
						return (_tmp6 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp6);
					} else {
						if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int_type)) {
							gboolean _tmp7;
							return (_tmp7 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp7);
						} else {
							if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->long_type)) {
								gboolean _tmp8;
								return (_tmp8 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp8);
							} else {
								if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int8_type)) {
									gboolean _tmp9;
									return (_tmp9 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp9);
								} else {
									if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int16_type)) {
										gboolean _tmp10;
										return (_tmp10 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp10);
									} else {
										if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int32_type)) {
											gboolean _tmp11;
											return (_tmp11 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp11);
										} else {
											if (VALA_TYPESYMBOL (st) == self->gtype_type) {
												gboolean _tmp12;
												return (_tmp12 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp12);
											} else {
												gboolean _tmp13;
												return (_tmp13 = FALSE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp13);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


static gboolean vala_ccode_base_module_is_unsigned_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	ValaStruct* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaStruct* st;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	st = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (type_arg), VALA_IS_STRUCT (_tmp0) ? ((ValaStruct*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (vala_data_type_get_nullable (type_arg)) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp2);
	} else {
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uchar_type)) {
			gboolean _tmp3;
			return (_tmp3 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp3);
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->ushort_type)) {
				gboolean _tmp4;
				return (_tmp4 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp4);
			} else {
				if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
					gboolean _tmp5;
					return (_tmp5 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp5);
				} else {
					if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->ulong_type)) {
						gboolean _tmp6;
						return (_tmp6 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp6);
					} else {
						if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint8_type)) {
							gboolean _tmp7;
							return (_tmp7 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp7);
						} else {
							if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint16_type)) {
								gboolean _tmp8;
								return (_tmp8 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp8);
							} else {
								if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint32_type)) {
									gboolean _tmp9;
									return (_tmp9 = TRUE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp9);
								} else {
									gboolean _tmp10;
									return (_tmp10 = FALSE, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp10);
								}
							}
						}
					}
				}
			}
		}
	}
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


void vala_ccode_base_module_check_type (ValaCCodeBaseModule* self, ValaDataType* type) {
	ValaArrayType* _tmp1;
	ValaDataType* _tmp0;
	ValaArrayType* array_type;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	array_type = (_tmp1 = (_tmp0 = type, VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (array_type != NULL) {
		vala_ccode_base_module_check_type (self, vala_array_type_get_element_type (array_type));
	}
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _type_arg_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_type_arg_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_data_type_get_type_arguments (type))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_type_arg_it)) {
			ValaDataType* type_arg;
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			vala_ccode_base_module_check_type (self, type_arg);
			vala_ccode_base_module_check_type_argument (self, type_arg);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
}


static void vala_ccode_base_module_check_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	gboolean _tmp3;
	gboolean _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_arg != NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	if (VALA_IS_GENERIC_TYPE (type_arg)) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = VALA_IS_POINTER_TYPE (type_arg);
	}
	if (_tmp4) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = vala_ccode_base_module_is_reference_type_argument (self, type_arg);
	}
	if (_tmp3) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = vala_ccode_base_module_is_nullable_value_type_argument (self, type_arg);
	}
	if (_tmp2) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = vala_ccode_base_module_is_signed_integer_type_argument (self, type_arg);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_ccode_base_module_is_unsigned_integer_type_argument (self, type_arg);
	}
	if (_tmp0) {
	} else {
		char* _tmp6;
		char* _tmp5;
		/* no error*/
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type_arg), _tmp6 = g_strdup_printf ("`%s' is not a supported generic type argument, use `?' to box value types", _tmp5 = vala_code_node_to_string ((ValaCodeNode*) type_arg)));
		_tmp6 = (g_free (_tmp6), NULL);
		_tmp5 = (g_free (_tmp5), NULL);
	}
}


static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* instance;
	ValaCCodeExpression* creation_expr;
	ValaStruct* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaStruct* st;
	gboolean _tmp2;
	gboolean _tmp3;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	instance = NULL;
	creation_expr = NULL;
	vala_ccode_base_module_check_type (self, vala_object_creation_expression_get_type_reference (expr));
	_tmp1 = NULL;
	_tmp0 = NULL;
	st = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_STRUCT (_tmp0) ? ((ValaStruct*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (st != NULL) {
		_tmp3 = !vala_struct_is_simple_type (st);
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = TRUE;
	} else {
		GeeList* _tmp4;
		_tmp4 = NULL;
		_tmp2 = gee_collection_get_size ((GeeCollection*) (_tmp4 = vala_object_creation_expression_get_object_initializer (expr))) > 0;
		(_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL));
	}
	if (_tmp2) {
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* _tmp6;
		char* _tmp5;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_object_creation_expression_get_type_reference (expr), FALSE, (ValaCodeNode*) expr);
		gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
		_tmp6 = NULL;
		_tmp5 = NULL;
		instance = (_tmp6 = vala_ccode_base_module_get_variable_cexpression (self, _tmp5 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) temp_decl))), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp6);
		_tmp5 = (g_free (_tmp5), NULL);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) expr) == NULL) {
		ValaCCodeFunctionCall* creation_call;
		gboolean _tmp7;
		ValaCCodeExpression* _tmp28;
		ValaCCodeExpression* _tmp27;
		creation_call = NULL;
		_tmp7 = FALSE;
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->glist_type)) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->gslist_type);
		}
		/* no creation method*/
		if (_tmp7) {
			ValaCCodeConstant* _tmp8;
			/* NULL is an empty list*/
			_tmp8 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp8 = vala_ccode_constant_new ("NULL")));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		} else {
			gboolean _tmp9;
			_tmp9 = FALSE;
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				_tmp9 = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type);
			} else {
				_tmp9 = FALSE;
			}
			if (_tmp9) {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeIdentifier* _tmp10;
				ValaCCodeConstant* _tmp13;
				char* _tmp12;
				ValaCCodeConstant* _tmp14;
				_tmp11 = NULL;
				_tmp10 = NULL;
				creation_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_object_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp11);
				(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
				_tmp13 = NULL;
				_tmp12 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new (_tmp12 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				_tmp12 = (g_free (_tmp12), NULL);
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("NULL")));
				(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp16;
					ValaCCodeIdentifier* _tmp15;
					ValaCCodeConstant* _tmp18;
					char* _tmp17;
					ValaCCodeConstant* _tmp19;
					_tmp16 = NULL;
					_tmp15 = NULL;
					creation_call = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_new0"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp16);
					(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new (_tmp17 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					_tmp17 = (g_free (_tmp17), NULL);
					_tmp19 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("1")));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp21;
						ValaCCodeIdentifier* _tmp20;
						ValaCCodeUnaryExpression* _tmp22;
						ValaCCodeConstant* _tmp23;
						ValaCCodeIdentifier* _tmp26;
						char* _tmp25;
						char* _tmp24;
						/* memset needs string.h*/
						self->string_h_needed = TRUE;
						_tmp21 = NULL;
						_tmp20 = NULL;
						creation_call = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("memset"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp21);
						(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
						_tmp22 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
						(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("0")));
						(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
						_tmp26 = NULL;
						_tmp25 = NULL;
						_tmp24 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("sizeof (%s)", _tmp24 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))))));
						(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
						_tmp25 = (g_free (_tmp25), NULL);
						_tmp24 = (g_free (_tmp24), NULL);
					}
				}
			}
		}
		_tmp28 = NULL;
		_tmp27 = NULL;
		creation_expr = (_tmp28 = (_tmp27 = (ValaCCodeExpression*) creation_call, (_tmp27 == NULL) ? NULL : vala_ccode_node_ref (_tmp27)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp28);
		(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaMethod* _tmp29;
			ValaMethod* m;
			GeeList* params;
			ValaCCodeFunctionCall* creation_call;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			gboolean _tmp33;
			gboolean _tmp34;
			ValaClass* _tmp37;
			ValaTypeSymbol* _tmp36;
			ValaClass* cl;
			gboolean _tmp38;
			GeeHashMap* carg_map;
			gboolean ellipsis;
			gint i;
			gint arg_pos;
			GeeIterator* params_it;
			gint last_pos;
			gint min_pos;
			gboolean _tmp62;
			gboolean _tmp63;
			ValaCCodeExpression* _tmp70;
			ValaCCodeExpression* _tmp69;
			char* _tmp71;
			gboolean _tmp72;
			/* use creation method*/
			_tmp29 = NULL;
			m = (_tmp29 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp29 == NULL) ? NULL : vala_code_node_ref (_tmp29));
			params = vala_method_get_parameters (m);
			creation_call = NULL;
			_tmp32 = NULL;
			_tmp31 = NULL;
			_tmp30 = NULL;
			creation_call = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (_tmp30 = vala_method_get_cname (m)))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp32);
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			_tmp30 = (g_free (_tmp30), NULL);
			_tmp33 = FALSE;
			_tmp34 = FALSE;
			if (st != NULL) {
				_tmp34 = !vala_struct_is_simple_type (st);
			} else {
				_tmp34 = FALSE;
			}
			if (_tmp34) {
				_tmp33 = !(vala_method_get_cinstance_parameter_position (m) < 0);
			} else {
				_tmp33 = FALSE;
			}
			if (_tmp33) {
				ValaCCodeUnaryExpression* _tmp35;
				_tmp35 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp35 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			}
			_tmp37 = NULL;
			_tmp36 = NULL;
			cl = (_tmp37 = (_tmp36 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp36) ? ((ValaClass*) _tmp36) : NULL), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
			_tmp38 = FALSE;
			if (cl != NULL) {
				_tmp38 = !vala_class_get_is_compact (cl);
			} else {
				_tmp38 = FALSE;
			}
			if (_tmp38) {
				{
					GeeList* _tmp39;
					GeeIterator* _tmp40;
					GeeIterator* _type_arg_it;
					_tmp39 = NULL;
					_tmp40 = NULL;
					_type_arg_it = (_tmp40 = gee_iterable_iterator ((GeeIterable*) (_tmp39 = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr)))), (_tmp39 == NULL) ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL)), _tmp40);
					while (gee_iterator_next (_type_arg_it)) {
						ValaDataType* type_arg;
						ValaCCodeExpression* _tmp41;
						type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
						_tmp41 = NULL;
						vala_ccode_function_call_add_argument (creation_call, _tmp41 = vala_ccode_base_module_get_type_id_expression (self, type_arg));
						(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
						if (vala_ccode_base_module_requires_copy (self, type_arg)) {
							ValaCCodeExpression* dup_func;
							ValaCCodeCastExpression* _tmp42;
							ValaCCodeExpression* _tmp43;
							dup_func = vala_ccode_base_module_get_dup_func_expression (self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg));
							if (dup_func == NULL) {
								/* type doesn't contain a copy function*/
								vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
								(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
								(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
								(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
								(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
								(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
								(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
								(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
								(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
								(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
								(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
								return;
							}
							_tmp42 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
							(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
							_tmp43 = NULL;
							vala_ccode_function_call_add_argument (creation_call, _tmp43 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg));
							(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
							(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
						} else {
							ValaCCodeConstant* _tmp44;
							ValaCCodeConstant* _tmp45;
							_tmp44 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("NULL")));
							(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
							_tmp45 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("NULL")));
							(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
						}
						(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
					}
					(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
				}
			}
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			ellipsis = FALSE;
			i = 1;
			arg_pos = 0;
			params_it = gee_iterable_iterator ((GeeIterable*) params);
			{
				GeeList* _tmp46;
				GeeIterator* _tmp47;
				GeeIterator* _arg_it;
				_tmp46 = NULL;
				_tmp47 = NULL;
				_arg_it = (_tmp47 = gee_iterable_iterator ((GeeIterable*) (_tmp46 = vala_object_creation_expression_get_argument_list (expr))), (_tmp46 == NULL) ? NULL : (_tmp46 = (gee_collection_object_unref (_tmp46), NULL)), _tmp47);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaCCodeExpression* _tmp48;
					ValaCCodeExpression* cexpr;
					ValaFormalParameter* param;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp48 = NULL;
					cexpr = (_tmp48 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48));
					param = NULL;
					if (gee_iterator_next (params_it)) {
						ValaFormalParameter* _tmp49;
						_tmp49 = NULL;
						param = (_tmp49 = (ValaFormalParameter*) gee_iterator_get (params_it), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp49);
						ellipsis = vala_formal_parameter_get_ellipsis (param);
						if (!ellipsis) {
							gboolean _tmp50;
							ValaCCodeExpression* _tmp55;
							_tmp50 = FALSE;
							if (!vala_formal_parameter_get_no_array_length (param)) {
								_tmp50 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
							} else {
								_tmp50 = FALSE;
							}
							if (_tmp50) {
								ValaArrayType* _tmp51;
								ValaArrayType* array_type;
								_tmp51 = NULL;
								array_type = (_tmp51 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp51 == NULL) ? NULL : vala_code_node_ref (_tmp51));
								{
									gint dim;
									dim = 1;
									for (; dim <= vala_array_type_get_rank (array_type); dim++) {
										ValaCCodeExpression* _tmp52;
										_tmp52 = NULL;
										gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp52 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
										(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
									}
								}
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							} else {
								if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaDelegateType* _tmp53;
									ValaDelegateType* deleg_type;
									ValaDelegate* _tmp54;
									ValaDelegate* d;
									_tmp53 = NULL;
									deleg_type = (_tmp53 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
									_tmp54 = NULL;
									d = (_tmp54 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp54 == NULL) ? NULL : vala_code_node_ref (_tmp54));
									if (vala_delegate_get_has_target (d)) {
										ValaCCodeExpression* delegate_target;
										delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, arg);
										gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
										(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
									}
									(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
									(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
								}
							}
							_tmp55 = NULL;
							cexpr = (_tmp55 = vala_ccode_base_module_handle_struct_argument (self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp55);
						}
						arg_pos = vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
					} else {
						/* default argument position*/
						arg_pos = vala_ccode_base_module_get_param_pos (self, (double) i, ellipsis);
					}
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
					i++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp56;
					_tmp56 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp56 = g_strdup_printf ("no default expression for argument %d", i));
					_tmp56 = (g_free (_tmp56), NULL);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
					(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
					(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
					(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param))));
				i++;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			/* append C arguments in the right order*/
			last_pos = -1;
			min_pos = 0;
			while (TRUE) {
				ValaCCodeExpression* _tmp61;
				min_pos = -1;
				{
					GeeSet* _tmp57;
					GeeIterator* _tmp58;
					GeeIterator* _pos_it;
					_tmp57 = NULL;
					_tmp58 = NULL;
					_pos_it = (_tmp58 = gee_iterable_iterator ((GeeIterable*) (_tmp57 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp57 == NULL) ? NULL : (_tmp57 = (gee_collection_object_unref (_tmp57), NULL)), _tmp58);
					while (gee_iterator_next (_pos_it)) {
						gint pos;
						gboolean _tmp59;
						pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
						_tmp59 = FALSE;
						if (pos > last_pos) {
							gboolean _tmp60;
							_tmp60 = FALSE;
							if (min_pos == (-1)) {
								_tmp60 = TRUE;
							} else {
								_tmp60 = pos < min_pos;
							}
							_tmp59 = _tmp60;
						} else {
							_tmp59 = FALSE;
						}
						if (_tmp59) {
							min_pos = pos;
						}
					}
					(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
				}
				if (min_pos == (-1)) {
					break;
				}
				_tmp61 = NULL;
				vala_ccode_function_call_add_argument (creation_call, _tmp61 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
				(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
				last_pos = min_pos;
			}
			_tmp62 = FALSE;
			_tmp63 = FALSE;
			if (st != NULL) {
				_tmp63 = !vala_struct_is_simple_type (st);
			} else {
				_tmp63 = FALSE;
			}
			if (_tmp63) {
				_tmp62 = vala_method_get_cinstance_parameter_position (m) < 0;
			} else {
				_tmp62 = FALSE;
			}
			if (_tmp62) {
				ValaCCodeUnaryExpression* _tmp64;
				/* instance parameter is at the end in a struct creation method*/
				_tmp64 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp64 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			}
			if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
				ValaCCodeUnaryExpression* _tmp66;
				ValaCCodeIdentifier* _tmp65;
				/* method can fail*/
				self->current_method_inner_error = TRUE;
				_tmp66 = NULL;
				_tmp65 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new ("inner_error")))));
				(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
				(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
			}
			if (ellipsis) {
				gboolean _tmp67;
				_tmp67 = FALSE;
				if (!vala_method_get_printf_format (m)) {
					_tmp67 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
				} else {
					_tmp67 = FALSE;
				}
				/* ensure variable argument list ends with NULL
				 * except when using printf-style arguments */
				if (_tmp67) {
					ValaCCodeConstant* _tmp68;
					_tmp68 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp68 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
					(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
				}
			}
			_tmp70 = NULL;
			_tmp69 = NULL;
			creation_expr = (_tmp70 = (_tmp69 = (ValaCCodeExpression*) creation_call, (_tmp69 == NULL) ? NULL : vala_ccode_node_ref (_tmp69)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp70);
			/* cast the return value of the creation method back to the intended type if
			 it requested a special C return type*/
			_tmp71 = NULL;
			if ((_tmp72 = (_tmp71 = vala_ccode_module_get_custom_creturn_type (vala_ccode_module_get_head ((ValaCCodeModule*) self), m)) != NULL, _tmp71 = (g_free (_tmp71), NULL), _tmp72)) {
				ValaCCodeExpression* _tmp74;
				char* _tmp73;
				_tmp74 = NULL;
				_tmp73 = NULL;
				creation_expr = (_tmp74 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (creation_expr, _tmp73 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp74);
				_tmp73 = (g_free (_tmp73), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
			(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		} else {
			if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaErrorCode* _tmp75;
				ValaErrorCode* ecode;
				ValaErrorDomain* _tmp76;
				ValaErrorDomain* edomain;
				ValaCCodeFunctionCall* creation_call;
				GeeList* _tmp77;
				gboolean _tmp78;
				ValaCCodeIdentifier* _tmp84;
				char* _tmp83;
				ValaCCodeIdentifier* _tmp86;
				char* _tmp85;
				ValaCCodeExpression* _tmp90;
				ValaCCodeExpression* _tmp89;
				_tmp75 = NULL;
				ecode = (_tmp75 = VALA_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp75 == NULL) ? NULL : vala_code_node_ref (_tmp75));
				_tmp76 = NULL;
				edomain = (_tmp76 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) ecode)), (_tmp76 == NULL) ? NULL : vala_code_node_ref (_tmp76));
				creation_call = NULL;
				_tmp77 = NULL;
				if ((_tmp78 = gee_collection_get_size ((GeeCollection*) (_tmp77 = vala_object_creation_expression_get_argument_list (expr))) == 1, (_tmp77 == NULL) ? NULL : (_tmp77 = (gee_collection_object_unref (_tmp77), NULL)), _tmp78)) {
					ValaCCodeFunctionCall* _tmp80;
					ValaCCodeIdentifier* _tmp79;
					/* must not be a format argument*/
					_tmp80 = NULL;
					_tmp79 = NULL;
					creation_call = (_tmp80 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp79 = vala_ccode_identifier_new ("g_error_new_literal"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp80);
					(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
				} else {
					ValaCCodeFunctionCall* _tmp82;
					ValaCCodeIdentifier* _tmp81;
					_tmp82 = NULL;
					_tmp81 = NULL;
					creation_call = (_tmp82 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new ("g_error_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp82);
					(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
				}
				_tmp84 = NULL;
				_tmp83 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new (_tmp83 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) edomain, NULL))));
				(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
				_tmp83 = (g_free (_tmp83), NULL);
				_tmp86 = NULL;
				_tmp85 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new (_tmp85 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE))));
				(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
				_tmp85 = (g_free (_tmp85), NULL);
				{
					GeeList* _tmp87;
					GeeIterator* _tmp88;
					GeeIterator* _arg_it;
					_tmp87 = NULL;
					_tmp88 = NULL;
					_arg_it = (_tmp88 = gee_iterable_iterator ((GeeIterable*) (_tmp87 = vala_object_creation_expression_get_argument_list (expr))), (_tmp87 == NULL) ? NULL : (_tmp87 = (gee_collection_object_unref (_tmp87), NULL)), _tmp88);
					while (gee_iterator_next (_arg_it)) {
						ValaExpression* arg;
						arg = (ValaExpression*) gee_iterator_get (_arg_it);
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					}
					(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
				}
				_tmp90 = NULL;
				_tmp89 = NULL;
				creation_expr = (_tmp90 = (_tmp89 = (ValaCCodeExpression*) creation_call, (_tmp89 == NULL) ? NULL : vala_ccode_node_ref (_tmp89)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp90);
				(ecode == NULL) ? NULL : (ecode = (vala_code_node_unref (ecode), NULL));
				(edomain == NULL) ? NULL : (edomain = (vala_code_node_unref (edomain), NULL));
				(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, creation_expr);
		} else {
			ValaCCodeAssignment* _tmp91;
			_tmp91 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp91 = vala_ccode_assignment_new (instance, creation_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
		}
		{
			GeeList* _tmp92;
			GeeIterator* _tmp93;
			GeeIterator* _init_it;
			_tmp92 = NULL;
			_tmp93 = NULL;
			_init_it = (_tmp93 = gee_iterable_iterator ((GeeIterable*) (_tmp92 = vala_object_creation_expression_get_object_initializer (expr))), (_tmp92 == NULL) ? NULL : (_tmp92 = (gee_collection_object_unref (_tmp92), NULL)), _tmp93);
			while (gee_iterator_next (_init_it)) {
				ValaMemberInitializer* init;
				init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
				if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
					ValaField* _tmp94;
					ValaField* f;
					ValaDataType* instance_target_type;
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* lhs;
					ValaCCodeAssignment* _tmp99;
					gboolean _tmp100;
					_tmp94 = NULL;
					f = (_tmp94 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp94 == NULL) ? NULL : vala_code_node_ref (_tmp94));
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					typed_inst = vala_ccode_base_module_transform_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type, NULL);
					lhs = NULL;
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeExpression* _tmp96;
						char* _tmp95;
						_tmp96 = NULL;
						_tmp95 = NULL;
						lhs = (_tmp96 = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp95 = vala_field_get_cname (f), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp96);
						_tmp95 = (g_free (_tmp95), NULL);
					} else {
						ValaCCodeExpression* _tmp98;
						char* _tmp97;
						_tmp98 = NULL;
						_tmp97 = NULL;
						lhs = (_tmp98 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp97 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp98);
						_tmp97 = (g_free (_tmp97), NULL);
					}
					_tmp99 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp99 = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
					_tmp100 = FALSE;
					if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
						_tmp100 = !vala_field_get_no_array_length (f);
					} else {
						_tmp100 = FALSE;
					}
					if (_tmp100) {
						ValaArrayType* _tmp101;
						ValaArrayType* array_type;
						_tmp101 = NULL;
						array_type = (_tmp101 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp101 == NULL) ? NULL : vala_code_node_ref (_tmp101));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* rhs_array_len;
								ValaCCodeAssignment* _tmp108;
								if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
									ValaCCodeExpression* _tmp104;
									char* _tmp103;
									char* _tmp102;
									_tmp104 = NULL;
									_tmp103 = NULL;
									_tmp102 = NULL;
									lhs = (_tmp104 = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp103 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp102 = vala_field_get_cname (f), dim), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp104);
									_tmp103 = (g_free (_tmp103), NULL);
									_tmp102 = (g_free (_tmp102), NULL);
								} else {
									ValaCCodeExpression* _tmp107;
									char* _tmp106;
									char* _tmp105;
									_tmp107 = NULL;
									_tmp106 = NULL;
									_tmp105 = NULL;
									lhs = (_tmp107 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp106 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp105 = vala_field_get_cname (f), dim)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp107);
									_tmp106 = (g_free (_tmp106), NULL);
									_tmp105 = (g_free (_tmp105), NULL);
								}
								rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_initializer_get_initializer (init), dim);
								_tmp108 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp108 = vala_ccode_assignment_new (lhs, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
								(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
								(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
							}
						}
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
							ValaCCodeExpression* rhs_delegate_target;
							ValaCCodeAssignment* _tmp115;
							if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
								ValaCCodeExpression* _tmp111;
								char* _tmp110;
								char* _tmp109;
								_tmp111 = NULL;
								_tmp110 = NULL;
								_tmp109 = NULL;
								lhs = (_tmp111 = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp110 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp109 = vala_field_get_cname (f)), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp111);
								_tmp110 = (g_free (_tmp110), NULL);
								_tmp109 = (g_free (_tmp109), NULL);
							} else {
								ValaCCodeExpression* _tmp114;
								char* _tmp113;
								char* _tmp112;
								_tmp114 = NULL;
								_tmp113 = NULL;
								_tmp112 = NULL;
								lhs = (_tmp114 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp113 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp112 = vala_field_get_cname (f))), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp114);
								_tmp113 = (g_free (_tmp113), NULL);
								_tmp112 = (g_free (_tmp112), NULL);
							}
							rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_member_initializer_get_initializer (init));
							_tmp115 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp115 = vala_ccode_assignment_new (lhs, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
							(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
						}
					}
					(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
					(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
				} else {
					if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
						ValaMemberAccess* inst_ma;
						ValaMemberAccess* ma;
						ValaCCodeFunctionCall* _tmp116;
						inst_ma = vala_member_access_new_simple ("new", NULL);
						vala_expression_set_value_type ((ValaExpression*) inst_ma, vala_object_creation_expression_get_type_reference (expr));
						vala_code_node_set_ccodenode ((ValaCodeNode*) inst_ma, (ValaCCodeNode*) instance);
						ma = vala_member_access_new ((ValaExpression*) inst_ma, vala_member_initializer_get_name (init), NULL);
						_tmp116 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp116 = vala_ccode_base_module_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))))));
						(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
						(inst_ma == NULL) ? NULL : (inst_ma = (vala_code_node_unref (inst_ma), NULL));
						(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
					}
				}
				(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
			}
			(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	} else {
		if (creation_expr != NULL) {
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) creation_expr);
		}
	}
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr) {
	gboolean _tmp0;
	gboolean _tmp1;
	ValaCCodeExpression* _tmp15;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (!VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) {
		_tmp1 = VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)));
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = !vala_struct_is_simple_type (VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))));
	} else {
		_tmp0 = FALSE;
	}
	/* pass non-simple struct instances always by reference*/
	if (_tmp0) {
		gboolean _tmp2;
		_tmp2 = FALSE;
		if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
			_tmp2 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param));
		} else {
			_tmp2 = FALSE;
		}
		/* we already use a reference for arguments of ref, out, and nullable parameters*/
		if (_tmp2) {
			ValaCCodeUnaryExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp5;
			_tmp4 = NULL;
			_tmp3 = NULL;
			unary = (_tmp4 = (_tmp3 = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp3) ? ((ValaCCodeUnaryExpression*) _tmp3) : NULL), (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4));
			_tmp5 = FALSE;
			if (unary != NULL) {
				_tmp5 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp5 = FALSE;
			}
			if (_tmp5) {
				ValaCCodeExpression* _tmp6;
				ValaCCodeExpression* _tmp7;
				/* *expr => expr*/
				_tmp6 = NULL;
				_tmp7 = NULL;
				return (_tmp7 = (_tmp6 = vala_ccode_unary_expression_get_inner (unary), (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6)), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp7);
			} else {
				gboolean _tmp8;
				_tmp8 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
					_tmp8 = TRUE;
				} else {
					_tmp8 = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
				}
				if (_tmp8) {
					ValaCCodeExpression* _tmp9;
					_tmp9 = NULL;
					return (_tmp9 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp9);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp11;
					ValaCCodeExpression* _tmp10;
					ValaCCodeUnaryExpression* _tmp13;
					ValaCCodeIdentifier* _tmp12;
					ValaCCodeExpression* _tmp14;
					/* if cexpr is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (arg), TRUE, NULL);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp11 = NULL;
					_tmp10 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp11 = vala_ccode_assignment_new (_tmp10 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
					(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))))));
					(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
					(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
					_tmp14 = NULL;
					return (_tmp14 = (ValaCCodeExpression*) ccomma, (temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp14);
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
	}
	_tmp15 = NULL;
	return (_tmp15 = cexpr, (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15));
}


static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("sizeof"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = vala_data_type_get_cname (vala_sizeof_expression_get_type_reference (expr)))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) csizeof);
	(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
}


static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_base_module_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	op = 0;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	ValaInterface* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaInterface* iface;
	gboolean _tmp4;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	iface = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_INTERFACE (_tmp2) ? ((ValaInterface*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = FALSE;
	if (iface != NULL) {
		_tmp4 = TRUE;
	} else {
		gboolean _tmp5;
		_tmp5 = FALSE;
		if (cl != NULL) {
			_tmp5 = !vala_class_get_is_compact (cl);
		} else {
			_tmp5 = FALSE;
		}
		_tmp4 = _tmp5;
	}
	if (_tmp4) {
		/* checked cast for strict subtypes of GTypeInstance*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeExpression* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeExpression* ccheck;
			char* _tmp6;
			ValaCCodeCastExpression* _tmp7;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp8;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_cast_expression_get_inner (expr)), TRUE, (ValaCodeNode*) expr);
			gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
			ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
			cinit = vala_ccode_assignment_new (ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_base_module_create_type_check (self, (ValaCCodeNode*) ctemp, vala_cast_expression_get_type_reference (expr));
			_tmp6 = NULL;
			_tmp7 = NULL;
			ccast = (_tmp7 = vala_ccode_cast_expression_new (ctemp, _tmp6 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr))), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cinit);
			_tmp8 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp8 = vala_ccode_conditional_expression_new (ccheck, (ValaCCodeExpression*) ccast, (ValaCCodeExpression*) cnull)));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
			(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
		} else {
			ValaInstanceCast* _tmp9;
			_tmp9 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)))));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		}
	} else {
		ValaCCodeCastExpression* _tmp11;
		char* _tmp10;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "Operation not supported for this type");
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return;
		}
		_tmp11 = NULL;
		_tmp10 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp11 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), _tmp10 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		_tmp10 = (g_free (_tmp10), NULL);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_pointer_indirection_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_addressof_expression_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeExpression* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr);
	gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
	cvar = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp0 = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), (ValaCCodeExpression*) (_tmp1 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_comma_expression_append_expression (ccomma, cvar);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
}


static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	gboolean _tmp4;
	gboolean _tmp20;
	gboolean _tmp21;
	gboolean _tmp22;
	ValaCCodeBinaryExpression* _tmp47;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_left (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_right (expr))), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	op = 0;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaCCodeBinaryExpression* _tmp3;
																				ValaCCodeBinaryExpression* _tmp2;
																				_tmp3 = NULL;
																				_tmp2 = NULL;
																				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, cright, cleft)), cleft)));
																				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
																				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
																				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
																				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
																				return;
																			} else {
																				g_assert_not_reached ();
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp4 = FALSE;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
	}
	if (_tmp4) {
		ValaStruct* _tmp6;
		ValaTypeSymbol* _tmp5;
		ValaStruct* left_type_as_struct;
		ValaStruct* _tmp8;
		ValaTypeSymbol* _tmp7;
		ValaStruct* right_type_as_struct;
		gboolean _tmp9;
		gboolean _tmp10;
		gboolean _tmp11;
		_tmp6 = NULL;
		_tmp5 = NULL;
		left_type_as_struct = (_tmp6 = (_tmp5 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))), VALA_IS_STRUCT (_tmp5) ? ((ValaStruct*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp8 = NULL;
		_tmp7 = NULL;
		right_type_as_struct = (_tmp8 = (_tmp7 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), VALA_IS_STRUCT (_tmp7) ? ((ValaStruct*) _tmp7) : NULL), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		_tmp11 = FALSE;
		if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))))) {
			_tmp11 = !vala_class_get_is_compact (VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))));
		} else {
			_tmp11 = FALSE;
		}
		if (_tmp11) {
			_tmp10 = VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))));
		} else {
			_tmp10 = FALSE;
		}
		if (_tmp10) {
			_tmp9 = !vala_class_get_is_compact (VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))));
		} else {
			_tmp9 = FALSE;
		}
		if (_tmp9) {
			ValaClass* _tmp12;
			ValaClass* left_cl;
			ValaClass* _tmp13;
			ValaClass* right_cl;
			_tmp12 = NULL;
			left_cl = (_tmp12 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
			_tmp13 = NULL;
			right_cl = (_tmp13 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) left_cl, (ValaTypeSymbol*) right_cl)) {
					ValaCCodeExpression* _tmp14;
					_tmp14 = NULL;
					cleft = (_tmp14 = (ValaCCodeExpression*) vala_instance_cast_new (cleft, (ValaTypeSymbol*) right_cl), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp14);
				} else {
					if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) right_cl, (ValaTypeSymbol*) left_cl)) {
						ValaCCodeExpression* _tmp15;
						_tmp15 = NULL;
						cright = (_tmp15 = (ValaCCodeExpression*) vala_instance_cast_new (cright, (ValaTypeSymbol*) left_cl), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp15);
					}
				}
			}
			(left_cl == NULL) ? NULL : (left_cl = (vala_code_node_unref (left_cl), NULL));
			(right_cl == NULL) ? NULL : (right_cl = (vala_code_node_unref (right_cl), NULL));
		} else {
			gboolean _tmp16;
			_tmp16 = FALSE;
			if (left_type_as_struct != NULL) {
				_tmp16 = right_type_as_struct != NULL;
			} else {
				_tmp16 = FALSE;
			}
			if (_tmp16) {
				gboolean _tmp17;
				_tmp17 = FALSE;
				if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
					_tmp17 = vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
				} else {
					_tmp17 = FALSE;
				}
				/* FIXME generate and use compare/equal function for real structs*/
				if (_tmp17) {
				} else {
					if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
						ValaCCodeExpression* _tmp18;
						/* FIXME check left value is not null*/
						_tmp18 = NULL;
						cleft = (_tmp18 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cleft), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp18);
					} else {
						if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
							ValaCCodeExpression* _tmp19;
							/* FIXME check right value is not null*/
							_tmp19 = NULL;
							cright = (_tmp19 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cright), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp19);
						}
					}
				}
			}
		}
		(left_type_as_struct == NULL) ? NULL : (left_type_as_struct = (vala_code_node_unref (left_type_as_struct), NULL));
		(right_type_as_struct == NULL) ? NULL : (right_type_as_struct = (vala_code_node_unref (right_type_as_struct), NULL));
	}
	_tmp20 = FALSE;
	_tmp21 = FALSE;
	_tmp22 = FALSE;
	if (!VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
		_tmp22 = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->string_type);
	} else {
		_tmp22 = FALSE;
	}
	if (_tmp22) {
		_tmp21 = !VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
	} else {
		_tmp21 = FALSE;
	}
	if (_tmp21) {
		_tmp20 = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->string_type);
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
			gboolean _tmp23;
			_tmp23 = FALSE;
			if (vala_expression_is_constant (vala_binary_expression_get_left (expr))) {
				_tmp23 = vala_expression_is_constant (vala_binary_expression_get_right (expr));
			} else {
				_tmp23 = FALSE;
			}
			/* string concatenation*/
			if (_tmp23) {
				char* left;
				char* right;
				ValaCCodeConstant* _tmp33;
				char* _tmp32;
				left = NULL;
				right = NULL;
				if (VALA_IS_CCODE_IDENTIFIER (cleft)) {
					char* _tmp25;
					const char* _tmp24;
					_tmp25 = NULL;
					_tmp24 = NULL;
					left = (_tmp25 = (_tmp24 = vala_ccode_identifier_get_name (VALA_CCODE_IDENTIFIER (cleft)), (_tmp24 == NULL) ? NULL : g_strdup (_tmp24)), left = (g_free (left), NULL), _tmp25);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cleft)) {
						char* _tmp27;
						const char* _tmp26;
						_tmp27 = NULL;
						_tmp26 = NULL;
						left = (_tmp27 = (_tmp26 = vala_ccode_constant_get_name (VALA_CCODE_CONSTANT (cleft)), (_tmp26 == NULL) ? NULL : g_strdup (_tmp26)), left = (g_free (left), NULL), _tmp27);
					} else {
						g_assert_not_reached ();
					}
				}
				if (VALA_IS_CCODE_IDENTIFIER (cright)) {
					char* _tmp29;
					const char* _tmp28;
					_tmp29 = NULL;
					_tmp28 = NULL;
					right = (_tmp29 = (_tmp28 = vala_ccode_identifier_get_name (VALA_CCODE_IDENTIFIER (cright)), (_tmp28 == NULL) ? NULL : g_strdup (_tmp28)), right = (g_free (right), NULL), _tmp29);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cright)) {
						char* _tmp31;
						const char* _tmp30;
						_tmp31 = NULL;
						_tmp30 = NULL;
						right = (_tmp31 = (_tmp30 = vala_ccode_constant_get_name (VALA_CCODE_CONSTANT (cright)), (_tmp30 == NULL) ? NULL : g_strdup (_tmp30)), right = (g_free (right), NULL), _tmp31);
					} else {
						g_assert_not_reached ();
					}
				}
				_tmp33 = NULL;
				_tmp32 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp33 = vala_ccode_constant_new (_tmp32 = g_strdup_printf ("%s %s", left, right))));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				_tmp32 = (g_free (_tmp32), NULL);
				left = (g_free (left), NULL);
				right = (g_free (right), NULL);
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			} else {
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeFunctionCall* _tmp35;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp36;
				/* convert to g_strconcat (a, b, NULL)*/
				_tmp34 = NULL;
				_tmp35 = NULL;
				ccall = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("g_strconcat"))), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp36 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("NULL")));
				(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			}
		} else {
			gboolean _tmp37;
			gboolean _tmp38;
			gboolean _tmp39;
			gboolean _tmp40;
			gboolean _tmp41;
			_tmp37 = FALSE;
			_tmp38 = FALSE;
			_tmp39 = FALSE;
			_tmp40 = FALSE;
			_tmp41 = FALSE;
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
				_tmp41 = TRUE;
			} else {
				_tmp41 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
			}
			if (_tmp41) {
				_tmp40 = TRUE;
			} else {
				_tmp40 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN;
			}
			if (_tmp40) {
				_tmp39 = TRUE;
			} else {
				_tmp39 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN;
			}
			if (_tmp39) {
				_tmp38 = TRUE;
			} else {
				_tmp38 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
			}
			if (_tmp38) {
				_tmp37 = TRUE;
			} else {
				_tmp37 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
			}
			if (_tmp37) {
				ValaCCodeIdentifier* _tmp42;
				ValaCCodeFunctionCall* _tmp43;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp45;
				ValaCCodeExpression* _tmp44;
				ValaCCodeExpression* _tmp46;
				self->requires_strcmp0 = TRUE;
				_tmp42 = NULL;
				_tmp43 = NULL;
				ccall = (_tmp43 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("_vala_strcmp0"))), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp45 = NULL;
				_tmp44 = NULL;
				cleft = (_tmp45 = (_tmp44 = (ValaCCodeExpression*) ccall, (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp45);
				_tmp46 = NULL;
				cright = (_tmp46 = (ValaCCodeExpression*) vala_ccode_constant_new ("0"), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp46);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			}
		}
	}
	_tmp47 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp47 = vala_ccode_binary_expression_new (op, cleft, cright)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
	(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
}


char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type) {
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = type, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_type_check_function (cl) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		const char* _tmp3;
		char* _tmp4;
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_class_get_type_check_function (cl), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	} else {
		char* _tmp5;
		_tmp5 = NULL;
		return (_tmp5 = vala_typesymbol_get_upper_case_cname (type, "IS_"), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp5);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type) {
	ValaErrorType* _tmp1;
	ValaDataType* _tmp0;
	ValaErrorType* et;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ccodenode != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	et = (_tmp1 = (_tmp0 = type, VALA_IS_ERROR_TYPE (_tmp0) ? ((ValaErrorType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (et != NULL) {
		_tmp2 = vala_error_type_get_error_code (et) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* matches_call;
		ValaCCodeIdentifier* _tmp6;
		char* _tmp5;
		ValaCCodeIdentifier* _tmp8;
		char* _tmp7;
		ValaCCodeExpression* _tmp9;
		_tmp3 = NULL;
		_tmp4 = NULL;
		matches_call = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("g_error_matches"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
		vala_ccode_function_call_add_argument (matches_call, VALA_CCODE_EXPRESSION (ccodenode));
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (_tmp5 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL))));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_error_type_get_error_code (et), FALSE))));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp9 = NULL;
		return (_tmp9 = (ValaCCodeExpression*) matches_call, (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp9);
	} else {
		gboolean _tmp10;
		_tmp10 = FALSE;
		if (et != NULL) {
			_tmp10 = vala_error_type_get_error_domain (et) != NULL;
		} else {
			_tmp10 = FALSE;
		}
		if (_tmp10) {
			ValaCCodeMemberAccess* instance_domain;
			char* _tmp11;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeIdentifier* type_domain;
			ValaCCodeExpression* _tmp13;
			instance_domain = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccodenode), "domain");
			_tmp11 = NULL;
			_tmp12 = NULL;
			type_domain = (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
			_tmp13 = NULL;
			return (_tmp13 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) instance_domain, (ValaCCodeExpression*) type_domain), (instance_domain == NULL) ? NULL : (instance_domain = (vala_ccode_node_unref (instance_domain), NULL)), (type_domain == NULL) ? NULL : (type_domain = (vala_ccode_node_unref (type_domain), NULL)), (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp13);
		} else {
			ValaCCodeIdentifier* _tmp15;
			char* _tmp14;
			ValaCCodeFunctionCall* _tmp16;
			ValaCCodeFunctionCall* ccheck;
			ValaCCodeExpression* _tmp17;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp16 = NULL;
			ccheck = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = vala_ccode_base_module_get_type_check_function (self, vala_data_type_get_data_type (type))))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp16);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
			_tmp17 = NULL;
			return (_tmp17 = (ValaCCodeExpression*) ccheck, (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp17);
		}
	}
	(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
}


static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_base_module_create_type_check (self, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_typecheck_get_expression (expr)), vala_typecheck_get_type_reference (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l) {
	ValaCCodeBaseModule * self;
	ValaDelegateType* _tmp0;
	ValaDelegateType* dt;
	GeeArrayList* _tmp1;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp2;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp3;
	GeeArrayList* _tmp4;
	GeeArrayList* _tmp6;
	GeeArrayList* _tmp5;
	GeeArrayList* _tmp8;
	GeeArrayList* _tmp7;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (l != NULL);
	/* use instance position from delegate*/
	_tmp0 = NULL;
	dt = (_tmp0 = VALA_DELEGATE_TYPE (vala_expression_get_target_type ((ValaExpression*) l)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vala_method_set_cinstance_parameter_position (vala_lambda_expression_get_method (l), vala_delegate_get_cinstance_parameter_position (vala_delegate_type_get_delegate_symbol (dt)));
	_tmp1 = NULL;
	old_temp_vars = (_tmp1 = self->temp_vars, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1));
	_tmp2 = NULL;
	old_temp_ref_vars = (_tmp2 = self->temp_ref_vars, (_tmp2 == NULL) ? NULL : gee_collection_object_ref (_tmp2));
	_tmp3 = NULL;
	self->temp_vars = (_tmp3 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp3);
	_tmp4 = NULL;
	self->temp_ref_vars = (_tmp4 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp4);
	vala_code_node_accept_children ((ValaCodeNode*) l, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->temp_vars = (_tmp6 = (_tmp5 = old_temp_vars, (_tmp5 == NULL) ? NULL : gee_collection_object_ref (_tmp5)), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->temp_ref_vars = (_tmp8 = (_tmp7 = old_temp_ref_vars, (_tmp7 == NULL) ? NULL : gee_collection_object_ref (_tmp7)), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) l, (ValaCCodeNode*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_cname (vala_lambda_expression_get_method (l)))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
	(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
	(old_temp_ref_vars == NULL) ? NULL : (old_temp_ref_vars = (gee_collection_object_unref (old_temp_ref_vars), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	_tmp1 = FALSE;
	if (vala_ccode_base_module_is_reference_type_argument (self, actual_type)) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = vala_ccode_base_module_is_nullable_value_type_argument (self, actual_type);
	}
	if (_tmp1) {
		ValaCCodeExpression* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		result = (_tmp3 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp2 = vala_data_type_get_cname (actual_type)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
	} else {
		if (vala_ccode_base_module_is_signed_integer_type_argument (self, actual_type)) {
			ValaCCodeIdentifier* _tmp4;
			ValaCCodeFunctionCall* _tmp5;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp7;
			ValaCCodeExpression* _tmp6;
			_tmp4 = NULL;
			_tmp5 = NULL;
			cconv = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("GPOINTER_TO_INT"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp7 = NULL;
			_tmp6 = NULL;
			result = (_tmp7 = (_tmp6 = (ValaCCodeExpression*) cconv, (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp7);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		} else {
			if (vala_ccode_base_module_is_unsigned_integer_type_argument (self, actual_type)) {
				ValaCCodeIdentifier* _tmp8;
				ValaCCodeFunctionCall* _tmp9;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp11;
				ValaCCodeExpression* _tmp10;
				_tmp8 = NULL;
				_tmp9 = NULL;
				cconv = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("GPOINTER_TO_UINT"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp11 = NULL;
				_tmp10 = NULL;
				result = (_tmp11 = (_tmp10 = (ValaCCodeExpression*) cconv, (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp11);
				(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
			}
		}
	}
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	if (vala_ccode_base_module_is_signed_integer_type_argument (self, actual_type)) {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeFunctionCall* _tmp2;
		ValaCCodeFunctionCall* cconv;
		ValaCCodeExpression* _tmp4;
		ValaCCodeExpression* _tmp3;
		_tmp1 = NULL;
		_tmp2 = NULL;
		cconv = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("GINT_TO_POINTER"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
		vala_ccode_function_call_add_argument (cconv, cexpr);
		_tmp4 = NULL;
		_tmp3 = NULL;
		result = (_tmp4 = (_tmp3 = (ValaCCodeExpression*) cconv, (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp4);
		(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
	} else {
		if (vala_ccode_base_module_is_unsigned_integer_type_argument (self, actual_type)) {
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeFunctionCall* _tmp6;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp8;
			ValaCCodeExpression* _tmp7;
			_tmp5 = NULL;
			_tmp6 = NULL;
			cconv = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("GUINT_TO_POINTER"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp8 = NULL;
			_tmp7 = NULL;
			result = (_tmp8 = (_tmp7 = (ValaCCodeExpression*) cconv, (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp8);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		}
	}
	return result;
}


/* manage memory and implicit casts*/
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	gboolean _tmp2;
	gboolean _tmp14;
	gboolean _tmp15;
	gboolean _tmp16;
	gboolean boxing;
	gboolean _tmp17;
	gboolean _tmp18;
	gboolean _tmp19;
	gboolean unboxing;
	gboolean _tmp20;
	gboolean _tmp56;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	if (expression_type == NULL) {
		return cexpr;
	}
	_tmp2 = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		_tmp2 = vala_data_type_get_floating_reference (expression_type);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaObjectTypeSymbol* _tmp4;
		ValaTypeSymbol* _tmp3;
		ValaObjectTypeSymbol* cl;
		char* _tmp5;
		const char* _tmp8;
		char* sink_func;
		/* floating reference, sink it.
		 */
		_tmp4 = NULL;
		_tmp3 = NULL;
		cl = (_tmp4 = (_tmp3 = vala_data_type_get_data_type (expression_type), VALA_IS_OBJECT_TYPE_SYMBOL (_tmp3) ? ((ValaObjectTypeSymbol*) _tmp3) : NULL), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		_tmp5 = NULL;
		if (cl != NULL) {
			char* _tmp6;
			_tmp6 = NULL;
			_tmp5 = (_tmp6 = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) cl), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
		} else {
			char* _tmp7;
			_tmp7 = NULL;
			_tmp5 = (_tmp7 = NULL, _tmp5 = (g_free (_tmp5), NULL), _tmp7);
		}
		_tmp8 = NULL;
		sink_func = (_tmp8 = _tmp5, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8));
		if (sink_func != NULL) {
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeFunctionCall* _tmp10;
			ValaCCodeFunctionCall* csink;
			ValaCCodeExpression* _tmp12;
			ValaCCodeExpression* _tmp11;
			_tmp9 = NULL;
			_tmp10 = NULL;
			csink = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (sink_func))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
			vala_ccode_function_call_add_argument (csink, cexpr);
			_tmp12 = NULL;
			_tmp11 = NULL;
			cexpr = (_tmp12 = (_tmp11 = (ValaCCodeExpression*) csink, (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp12);
			(csink == NULL) ? NULL : (csink = (vala_ccode_node_unref (csink), NULL));
		} else {
			char* _tmp13;
			_tmp13 = NULL;
			vala_report_error (NULL, _tmp13 = g_strdup_printf ("type `%s' does not support floating references", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_data_type (expression_type))));
			_tmp13 = (g_free (_tmp13), NULL);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		_tmp5 = (g_free (_tmp5), NULL);
		sink_func = (g_free (sink_func), NULL);
	}
	_tmp14 = FALSE;
	_tmp15 = FALSE;
	_tmp16 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp16 = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp16 = FALSE;
	}
	if (_tmp16) {
		_tmp15 = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp15 = FALSE;
	}
	if (_tmp15) {
		_tmp14 = vala_data_type_get_nullable (target_type);
	} else {
		_tmp14 = FALSE;
	}
	boxing = _tmp14;
	_tmp17 = FALSE;
	_tmp18 = FALSE;
	_tmp19 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp19 = vala_data_type_get_nullable (expression_type);
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		_tmp18 = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		_tmp17 = !vala_data_type_get_nullable (target_type);
	} else {
		_tmp17 = FALSE;
	}
	unboxing = _tmp17;
	_tmp20 = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		gboolean _tmp21;
		gboolean _tmp22;
		gboolean _tmp23;
		_tmp21 = FALSE;
		_tmp22 = FALSE;
		_tmp23 = FALSE;
		if (target_type == NULL) {
			_tmp23 = TRUE;
		} else {
			_tmp23 = !vala_data_type_get_value_owned (target_type);
		}
		if (_tmp23) {
			_tmp22 = TRUE;
		} else {
			_tmp22 = boxing;
		}
		if (_tmp22) {
			_tmp21 = TRUE;
		} else {
			_tmp21 = unboxing;
		}
		_tmp20 = _tmp21;
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaPointerType* _tmp25;
		ValaDataType* _tmp24;
		ValaPointerType* pointer_type;
		gboolean _tmp26;
		/* value leaked, destroy it*/
		_tmp25 = NULL;
		_tmp24 = NULL;
		pointer_type = (_tmp25 = (_tmp24 = target_type, VALA_IS_POINTER_TYPE (_tmp24) ? ((ValaPointerType*) _tmp24) : NULL), (_tmp25 == NULL) ? NULL : vala_code_node_ref (_tmp25));
		_tmp26 = FALSE;
		if (pointer_type != NULL) {
			_tmp26 = !VALA_IS_VOID_TYPE (vala_pointer_type_get_base_type (pointer_type));
		} else {
			_tmp26 = FALSE;
		}
		if (_tmp26) {
		} else {
			if (vala_ccode_base_module_requires_destroy (self, expression_type)) {
				ValaLocalVariable* decl;
				ValaCCodeExpression* _tmp28;
				ValaCCodeExpression* _tmp27;
				gboolean _tmp29;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, TRUE, (ValaCodeNode*) expression_type);
				gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
				gee_list_insert ((GeeList*) self->temp_ref_vars, 0, decl);
				_tmp28 = NULL;
				_tmp27 = NULL;
				cexpr = (_tmp28 = (ValaCCodeExpression*) vala_ccode_assignment_new (_tmp27 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp28);
				(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
				_tmp29 = FALSE;
				if (VALA_IS_ARRAY_TYPE (expression_type)) {
					_tmp29 = expr != NULL;
				} else {
					_tmp29 = FALSE;
				}
				if (_tmp29) {
					ValaArrayType* _tmp30;
					ValaArrayType* array_type;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeExpression* _tmp37;
					ValaCCodeExpression* _tmp39;
					ValaCCodeExpression* _tmp38;
					_tmp30 = NULL;
					array_type = (_tmp30 = VALA_ARRAY_TYPE (expression_type), (_tmp30 == NULL) ? NULL : vala_code_node_ref (_tmp30));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, cexpr);
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp32;
							ValaDataType* _tmp31;
							ValaLocalVariable* _tmp33;
							ValaLocalVariable* len_decl;
							ValaCCodeAssignment* _tmp36;
							ValaCCodeExpression* _tmp35;
							ValaCCodeExpression* _tmp34;
							_tmp32 = NULL;
							_tmp31 = NULL;
							_tmp33 = NULL;
							len_decl = (_tmp33 = vala_local_variable_new (_tmp31 = vala_data_type_copy (self->int_type), _tmp32 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) decl), dim), NULL, NULL), _tmp32 = (g_free (_tmp32), NULL), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_code_node_unref (_tmp31), NULL)), _tmp33);
							gee_list_insert ((GeeList*) self->temp_vars, 0, len_decl);
							_tmp36 = NULL;
							_tmp35 = NULL;
							_tmp34 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp36 = vala_ccode_assignment_new (_tmp34 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) len_decl)), _tmp35 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
							(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
							(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
							(len_decl == NULL) ? NULL : (len_decl = (vala_code_node_unref (len_decl), NULL));
						}
					}
					_tmp37 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, _tmp37 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp39 = NULL;
					_tmp38 = NULL;
					cexpr = (_tmp39 = (_tmp38 = (ValaCCodeExpression*) ccomma, (_tmp38 == NULL) ? NULL : vala_ccode_node_ref (_tmp38)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp39);
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			}
		}
		(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	}
	if (target_type == NULL) {
		/* value will be destroyed, no need for implicit casts*/
		return cexpr;
	}
	if (boxing) {
		ValaCCodeUnaryExpression* _tmp42;
		ValaCCodeExpression* _tmp41;
		ValaCCodeUnaryExpression* unary;
		gboolean _tmp43;
		/* value needs to be boxed*/
		_tmp42 = NULL;
		_tmp41 = NULL;
		unary = (_tmp42 = (_tmp41 = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp41) ? ((ValaCCodeUnaryExpression*) _tmp41) : NULL), (_tmp42 == NULL) ? NULL : vala_ccode_node_ref (_tmp42));
		_tmp43 = FALSE;
		if (unary != NULL) {
			_tmp43 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
		} else {
			_tmp43 = FALSE;
		}
		if (_tmp43) {
			ValaCCodeExpression* _tmp45;
			ValaCCodeExpression* _tmp44;
			/* *expr => expr*/
			_tmp45 = NULL;
			_tmp44 = NULL;
			cexpr = (_tmp45 = (_tmp44 = vala_ccode_unary_expression_get_inner (unary), (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp45);
		} else {
			gboolean _tmp46;
			_tmp46 = FALSE;
			if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
				_tmp46 = TRUE;
			} else {
				_tmp46 = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
			}
			if (_tmp46) {
				ValaCCodeExpression* _tmp47;
				_tmp47 = NULL;
				cexpr = (_tmp47 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp47);
			} else {
				ValaLocalVariable* decl;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeAssignment* _tmp49;
				ValaCCodeExpression* _tmp48;
				ValaCCodeUnaryExpression* _tmp51;
				ValaCCodeExpression* _tmp50;
				ValaCCodeExpression* _tmp53;
				ValaCCodeExpression* _tmp52;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, vala_data_type_get_value_owned (expression_type), (ValaCodeNode*) expression_type);
				gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
				ccomma = vala_ccode_comma_expression_new ();
				_tmp49 = NULL;
				_tmp48 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp49 = vala_ccode_assignment_new (_tmp48 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
				(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
				_tmp51 = NULL;
				_tmp50 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp51 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp50 = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)))));
				(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
				(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
				_tmp53 = NULL;
				_tmp52 = NULL;
				cexpr = (_tmp53 = (_tmp52 = (ValaCCodeExpression*) ccomma, (_tmp52 == NULL) ? NULL : vala_ccode_node_ref (_tmp52)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp53);
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
	} else {
		if (unboxing) {
			ValaCCodeExpression* _tmp54;
			/* unbox value*/
			_tmp54 = NULL;
			cexpr = (_tmp54 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp54);
		} else {
			ValaCCodeExpression* _tmp55;
			_tmp55 = NULL;
			cexpr = (_tmp55 = vala_ccode_base_module_get_implicit_cast_expression (self, cexpr, expression_type, target_type, expr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp55);
		}
	}
	_tmp56 = FALSE;
	if (vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp57;
		gboolean _tmp58;
		_tmp57 = FALSE;
		_tmp58 = FALSE;
		if (!vala_data_type_get_value_owned (expression_type)) {
			_tmp58 = TRUE;
		} else {
			_tmp58 = boxing;
		}
		if (_tmp58) {
			_tmp57 = TRUE;
		} else {
			_tmp57 = unboxing;
		}
		_tmp56 = _tmp57;
	} else {
		_tmp56 = FALSE;
	}
	if (_tmp56) {
		gboolean _tmp59;
		_tmp59 = FALSE;
		if (vala_ccode_base_module_requires_copy (self, target_type)) {
			_tmp59 = !VALA_IS_NULL_TYPE (expression_type);
		} else {
			_tmp59 = FALSE;
		}
		/* need to copy value*/
		if (_tmp59) {
			ValaCodeNode* _tmp60;
			ValaCodeNode* node;
			ValaCCodeExpression* _tmp63;
			_tmp60 = NULL;
			node = (_tmp60 = (ValaCodeNode*) expr, (_tmp60 == NULL) ? NULL : vala_code_node_ref (_tmp60));
			if (node == NULL) {
				ValaCodeNode* _tmp62;
				ValaCodeNode* _tmp61;
				_tmp62 = NULL;
				_tmp61 = NULL;
				node = (_tmp62 = (_tmp61 = (ValaCodeNode*) expression_type, (_tmp61 == NULL) ? NULL : vala_code_node_ref (_tmp61)), (node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL)), _tmp62);
			}
			_tmp63 = NULL;
			cexpr = (_tmp63 = vala_ccode_base_module_get_ref_cexpression (self, target_type, cexpr, expr, node), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp63);
			(node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL));
		}
	}
	return cexpr;
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	gboolean _tmp1;
	ValaClass* _tmp5;
	ValaTypeSymbol* _tmp4;
	ValaClass* cl;
	ValaInterface* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaInterface* iface;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	_tmp1 = FALSE;
	if (vala_data_type_get_data_type (expression_type) != NULL) {
		_tmp1 = vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		/* same type, no cast required*/
		return cexpr;
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		/* null literal, no cast required when not converting to generic type pointer*/
		return cexpr;
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	cl = (_tmp5 = (_tmp4 = vala_data_type_get_data_type (target_type), VALA_IS_CLASS (_tmp4) ? ((ValaClass*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	_tmp7 = NULL;
	_tmp6 = NULL;
	iface = (_tmp7 = (_tmp6 = vala_data_type_get_data_type (target_type), VALA_IS_INTERFACE (_tmp6) ? ((ValaInterface*) _tmp6) : NULL), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
	_tmp8 = FALSE;
	if (vala_code_context_get_checking (self->priv->_context)) {
		gboolean _tmp9;
		_tmp9 = FALSE;
		if (iface != NULL) {
			_tmp9 = TRUE;
		} else {
			gboolean _tmp10;
			_tmp10 = FALSE;
			if (cl != NULL) {
				_tmp10 = !vala_class_get_is_compact (cl);
			} else {
				_tmp10 = FALSE;
			}
			_tmp9 = _tmp10;
		}
		_tmp8 = _tmp9;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		ValaCCodeExpression* _tmp11;
		/* checked cast for strict subtypes of GTypeInstance*/
		_tmp11 = NULL;
		return (_tmp11 = (ValaCCodeExpression*) vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp11);
	} else {
		gboolean _tmp12;
		_tmp12 = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			char* _tmp14;
			char* _tmp13;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp12 = _vala_strcmp0 (_tmp13 = vala_data_type_get_cname (expression_type), _tmp14 = vala_data_type_get_cname (target_type)) != 0;
			_tmp14 = (g_free (_tmp14), NULL);
			_tmp13 = (g_free (_tmp13), NULL);
		} else {
			_tmp12 = FALSE;
		}
		if (_tmp12) {
			ValaStruct* _tmp16;
			ValaTypeSymbol* _tmp15;
			ValaStruct* st;
			gboolean _tmp17;
			_tmp16 = NULL;
			_tmp15 = NULL;
			st = (_tmp16 = (_tmp15 = vala_data_type_get_data_type (target_type), VALA_IS_STRUCT (_tmp15) ? ((ValaStruct*) _tmp15) : NULL), (_tmp16 == NULL) ? NULL : vala_code_node_ref (_tmp16));
			_tmp17 = FALSE;
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type))) {
				_tmp17 = TRUE;
			} else {
				gboolean _tmp18;
				_tmp18 = FALSE;
				if (st != NULL) {
					_tmp18 = vala_struct_is_simple_type (st);
				} else {
					_tmp18 = FALSE;
				}
				_tmp17 = _tmp18;
			}
			if (_tmp17) {
				char* _tmp19;
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* _tmp21;
				/* don't cast non-simple structs*/
				_tmp19 = NULL;
				_tmp20 = NULL;
				_tmp21 = NULL;
				return (_tmp21 = (_tmp20 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp19 = vala_data_type_get_cname (target_type)), _tmp19 = (g_free (_tmp19), NULL), _tmp20), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp21);
			} else {
				ValaCCodeExpression* _tmp22;
				_tmp22 = NULL;
				return (_tmp22 = cexpr, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp22);
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			ValaCCodeExpression* _tmp23;
			_tmp23 = NULL;
			return (_tmp23 = cexpr, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp23);
		}
	}
	(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_implicit_cast_expression (self, source_cexpr, expression_type, target_type, expr);
}


ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr) {
	char* set_func;
	ValaProperty* _tmp23;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* _tmp35;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (ma != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma))) {
		if (vala_property_get_base_property (prop) != NULL) {
			ValaClass* _tmp0;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp3;
			char* _tmp2;
			char* _tmp1;
			ValaCCodeFunctionCall* _tmp4;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp7;
			char* _tmp6;
			char* _tmp5;
			ValaCCodeMemberAccess* _tmp9;
			char* _tmp8;
			ValaCCodeFunctionCall* _tmp10;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* _tmp11;
			ValaCCodeFunctionCall* _tmp12;
			_tmp0 = NULL;
			base_class = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp4 = NULL;
			vcast = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = g_strdup_printf ("%s_CLASS", _tmp1 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp4);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = g_strdup_printf ("%s_parent_class", _tmp5 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL)))));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			ccall = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp8 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp8 = (g_free (_tmp8), NULL), _tmp10);
			_tmp11 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			vala_ccode_function_call_add_argument (ccall, cexpr);
			_tmp12 = NULL;
			return (_tmp12 = ccall, (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp12);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaInterface* _tmp13;
				ValaInterface* base_iface;
				char* _tmp15;
				char* _tmp14;
				char* _tmp16;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp19;
				char* _tmp18;
				ValaCCodeIdentifier* _tmp17;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp21;
				ValaCCodeFunctionCall* _tmp22;
				_tmp13 = NULL;
				base_iface = (_tmp13 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13));
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp16 = NULL;
				parent_iface_var = (_tmp16 = g_strdup_printf ("%s_%s_parent_iface", _tmp14 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL), _tmp15 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp15 = (g_free (_tmp15), NULL), _tmp14 = (g_free (_tmp14), NULL), _tmp16);
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp17 = NULL;
				_tmp20 = NULL;
				ccall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (parent_iface_var)), _tmp18 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp18 = (g_free (_tmp18), NULL), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp20);
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				vala_ccode_function_call_add_argument (ccall, cexpr);
				_tmp22 = NULL;
				return (_tmp22 = ccall, (base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL)), parent_iface_var = (g_free (parent_iface_var), NULL), _tmp22);
			}
		}
	}
	set_func = g_strdup ("g_object_set");
	_tmp23 = NULL;
	base_property = (_tmp23 = prop, (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
	if (!vala_property_get_no_accessor_method (prop)) {
		char* _tmp28;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp25;
			ValaProperty* _tmp24;
			_tmp25 = NULL;
			_tmp24 = NULL;
			base_property = (_tmp25 = (_tmp24 = vala_property_get_base_property (prop), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp25);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp27;
				ValaProperty* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				base_property = (_tmp27 = (_tmp26 = vala_property_get_base_interface_property (prop), (_tmp26 == NULL) ? NULL : vala_code_node_ref (_tmp26)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp27);
			}
		}
		_tmp28 = NULL;
		set_func = (_tmp28 = vala_property_accessor_get_cname (vala_property_get_set_accessor (base_property)), set_func = (g_free (set_func), NULL), _tmp28);
		if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
			char* _tmp29;
			_tmp29 = NULL;
			set_func = (_tmp29 = vala_ccode_module_get_dynamic_property_setter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), set_func = (g_free (set_func), NULL), _tmp29);
		}
	}
	_tmp30 = NULL;
	_tmp31 = NULL;
	ccall = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (set_func))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp32;
		/* target instance is first argument */
		_tmp32 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	}
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp33;
		/* property name is second argument of g_object_set */
		_tmp33 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp33 = vala_property_get_canonical_cconstant (prop)));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp34;
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_constant_new ("NULL")));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	}
	_tmp35 = NULL;
	return (_tmp35 = ccall, set_func = (g_free (set_func), NULL), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp35);
}


/* indicates whether a given Expression eligable for an ADDRESS_OF operator
 * from a vala to C point of view all expressions denoting locals, fields and
 * parameters are eligable to an ADDRESS_OF operator */
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = e, VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (ma == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp2);
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) ma) == NULL) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp3);
	}
	if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp4;
		return (_tmp4 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp4);
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp5;
		return (_tmp5 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp5);
	}
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp6;
		return (_tmp6 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp6);
	}
	return (_tmp7 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp7);
}


/* retrieve the correct address_of expression for a give expression, creates temporary variables
 * where necessary, ce is the corresponding ccode expression for e */
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce) {
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeExpression* ctemp;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeUnaryExpression* _tmp2;
	ValaCCodeExpression* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	g_return_val_if_fail (ce != NULL, NULL);
	/* is address of trivially possible?*/
	if (vala_ccode_base_module_is_address_of_possible (self, e)) {
		return (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ce);
	}
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (e), TRUE, NULL);
	ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
	gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp1 = vala_ccode_assignment_new (ctemp, ce, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	return (_tmp3 = (ValaCCodeExpression*) ccomma, (temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), _tmp3);
}


gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wrapper_name != NULL, FALSE);
	return gee_collection_add ((GeeCollection*) self->wrappers, wrapper_name);
}


ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_CLASS (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0);
	} else {
		if (VALA_IS_INTERFACE (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaStruct* _tmp2;
				ValaStruct* st;
				_tmp2 = NULL;
				st = (_tmp2 = VALA_STRUCT (sym), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
				if (vala_struct_is_boolean_type (st)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = (ValaDataType*) vala_boolean_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3);
				} else {
					if (vala_struct_is_integer_type (st)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = (ValaDataType*) vala_integer_type_new (st, NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4);
					} else {
						if (vala_struct_is_floating_type (st)) {
							ValaDataType* _tmp5;
							_tmp5 = NULL;
							type = (_tmp5 = (ValaDataType*) vala_floating_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5);
						} else {
							ValaDataType* _tmp6;
							_tmp6 = NULL;
							type = (_tmp6 = (ValaDataType*) vala_struct_value_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp6);
						}
					}
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaDataType* _tmp7;
					_tmp7 = NULL;
					type = (_tmp7 = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7);
				} else {
					if (VALA_IS_ERROR_DOMAIN (sym)) {
						ValaDataType* _tmp8;
						_tmp8 = NULL;
						type = (_tmp8 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp8);
					} else {
						if (VALA_IS_ERROR_CODE (sym)) {
							ValaDataType* _tmp9;
							_tmp9 = NULL;
							type = (_tmp9 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) sym)), VALA_ERROR_CODE (sym), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp9);
						} else {
							char* _tmp11;
							char* _tmp10;
							ValaDataType* _tmp12;
							_tmp11 = NULL;
							_tmp10 = NULL;
							vala_report_error (NULL, _tmp11 = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp10 = vala_symbol_get_full_name ((ValaSymbol*) sym)));
							_tmp11 = (g_free (_tmp11), NULL);
							_tmp10 = (g_free (_tmp10), NULL);
							_tmp12 = NULL;
							return (_tmp12 = (ValaDataType*) vala_invalid_type_new (), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp12);
						}
					}
				}
			}
		}
	}
	return type;
}


ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	gboolean _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (vala_data_type_get_data_type (type) != NULL) {
		_tmp3 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type));
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = VALA_IS_POINTER_TYPE (type);
	}
	if (_tmp2) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = VALA_IS_ARRAY_TYPE (type);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = VALA_IS_DELEGATE_TYPE (type);
	}
	if (_tmp0) {
		return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
	} else {
		gboolean _tmp5;
		_tmp5 = FALSE;
		if (vala_data_type_get_data_type (type) != NULL) {
			char* _tmp6;
			_tmp6 = NULL;
			_tmp5 = (_tmp6 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL;
			_tmp6 = (g_free (_tmp6), NULL);
		} else {
			_tmp5 = FALSE;
		}
		if (_tmp5) {
			char* _tmp7;
			ValaCCodeExpression* _tmp8;
			_tmp7 = NULL;
			_tmp8 = NULL;
			return (_tmp8 = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp7 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
		} else {
			gboolean _tmp10;
			_tmp10 = FALSE;
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				_tmp10 = initializer_expression;
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				ValaCCodeInitializerList* clist;
				ValaCCodeConstant* _tmp11;
				/* 0-initialize struct with struct initializer { 0 }
				 only allowed as initializer expression in C*/
				clist = vala_ccode_initializer_list_new ();
				_tmp11 = NULL;
				vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("0")));
				(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
				return (ValaCCodeExpression*) clist;
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL) {
					return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
				} else {
					if (VALA_IS_ERROR_TYPE (type)) {
						return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					}
				}
			}
		}
	}
	return NULL;
}


static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (check_return_type) {
		return vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, vala_property_get_property_type (prop), t, non_null, var_name);
	} else {
		ValaVoidType* _tmp1;
		ValaCCodeStatement* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, (ValaDataType*) (_tmp1 = vala_void_type_new (NULL)), t, non_null, var_name), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)), _tmp2);
	}
}


ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeFunctionCall* ccheck;
	gboolean _tmp0;
	ValaCreationMethod* _tmp17;
	ValaCodeNode* _tmp16;
	ValaCreationMethod* cm;
	gboolean _tmp18;
	ValaCCodeStatement* _tmp24;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	_tmp0 = FALSE;
	if (vala_code_context_get_checking (self->priv->_context)) {
		gboolean _tmp1;
		gboolean _tmp2;
		_tmp1 = FALSE;
		_tmp2 = FALSE;
		if (VALA_IS_CLASS (t)) {
			_tmp2 = !vala_class_get_is_compact (VALA_CLASS (t));
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = VALA_IS_INTERFACE (t);
		}
		_tmp0 = _tmp1;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		ValaCCodeFunctionCall* _tmp5;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp6;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* cexpr;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		ctype_check = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_type_check_function (self, t)))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (var_name)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		cexpr = (_tmp7 = (ValaCCodeExpression*) ctype_check, (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7));
		if (!non_null) {
			ValaCCodeConstant* _tmp9;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeBinaryExpression* _tmp10;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp11;
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			cnull = (_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp10);
			_tmp11 = NULL;
			cexpr = (_tmp11 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cnull, (ValaCCodeExpression*) ctype_check), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp11);
			(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL) ? NULL : (ctype_check = (vala_ccode_node_unref (ctype_check), NULL));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
	} else {
		if (!non_null) {
			ValaCCodeStatement* _tmp12;
			_tmp12 = NULL;
			return (_tmp12 = NULL, (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp12);
		} else {
			ValaCCodeConstant* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeBinaryExpression* _tmp15;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp15 = NULL;
			cnonnull = (_tmp15 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("NULL"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp15);
			vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) cnonnull);
			(cnonnull == NULL) ? NULL : (cnonnull = (vala_ccode_node_unref (cnonnull), NULL));
		}
	}
	_tmp17 = NULL;
	_tmp16 = NULL;
	cm = (_tmp17 = (_tmp16 = method_node, VALA_IS_CREATION_METHOD (_tmp16) ? ((ValaCreationMethod*) _tmp16) : NULL), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
	_tmp18 = FALSE;
	if (cm != NULL) {
		_tmp18 = VALA_IS_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) cm));
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeConstant* _tmp20;
		_tmp19 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp20 = NULL;
		vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("NULL")));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	} else {
		if (VALA_IS_VOID_TYPE (ret_type)) {
			ValaCCodeIdentifier* _tmp21;
			/* void function */
			_tmp21 = NULL;
			vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("g_return_if_fail")));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		} else {
			ValaCCodeIdentifier* _tmp22;
			ValaCCodeExpression* cdefault;
			_tmp22 = NULL;
			vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("g_return_val_if_fail")));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			cdefault = vala_ccode_base_module_default_value_for_type (self, ret_type, FALSE);
			if (cdefault != NULL) {
				vala_ccode_function_call_add_argument (ccheck, cdefault);
			} else {
				ValaCCodeStatement* _tmp23;
				_tmp23 = NULL;
				return (_tmp23 = NULL, (cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), _tmp23);
			}
			(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
		}
	}
	_tmp24 = NULL;
	return (_tmp24 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), _tmp24);
}


gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis) {
	g_return_val_if_fail (self != NULL, 0);
	if (!ellipsis) {
		if (param_pos >= 0) {
			return (gint) (param_pos * 1000);
		} else {
			return (gint) ((100 + param_pos) * 1000);
		}
	} else {
		if (param_pos >= 0) {
			return (gint) ((100 + param_pos) * 1000);
		} else {
			return (gint) ((200 + param_pos) * 1000);
		}
	}
}


ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node) {
	ValaCCodeNode* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (vala_code_node_get_ccodenode (node) == NULL) {
		vala_code_node_accept (node, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	_tmp0 = NULL;
	return (_tmp0 = vala_code_node_get_ccodenode (node), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
}


static void vala_ccode_base_module_class_init (ValaCCodeBaseModuleClass * klass) {
	vala_ccode_base_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_base_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBaseModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->get_value_setter_function = vala_ccode_base_module_real_get_value_setter_function;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_base_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_base_module_real_append_vala_array_move;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_length = vala_ccode_base_module_real_append_vala_array_length;
	VALA_CCODE_MODULE_CLASS (klass)->visit_source_file = vala_ccode_base_module_real_visit_source_file;
	VALA_CCODE_MODULE_CLASS (klass)->emit = vala_ccode_base_module_real_emit;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum = vala_ccode_base_module_real_visit_enum;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum_value = vala_ccode_base_module_real_visit_enum_value;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member = vala_ccode_base_module_real_visit_member;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constant = vala_ccode_base_module_real_visit_constant;
	VALA_CCODE_MODULE_CLASS (klass)->visit_field = vala_ccode_base_module_real_visit_field;
	VALA_CCODE_MODULE_CLASS (klass)->visit_formal_parameter = vala_ccode_base_module_real_visit_formal_parameter;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property = vala_ccode_base_module_real_visit_property;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property_accessor = vala_ccode_base_module_real_visit_property_accessor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_destructor = vala_ccode_base_module_real_visit_destructor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_block = vala_ccode_base_module_real_visit_block;
	VALA_CCODE_MODULE_CLASS (klass)->visit_empty_statement = vala_ccode_base_module_real_visit_empty_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_declaration_statement = vala_ccode_base_module_real_visit_declaration_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_local_variable = vala_ccode_base_module_real_visit_local_variable;
	VALA_CCODE_MODULE_CLASS (klass)->visit_initializer_list = vala_ccode_base_module_real_visit_initializer_list;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_base_module_real_get_dup_func_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_end_full_expression = vala_ccode_base_module_real_visit_end_full_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression_statement = vala_ccode_base_module_real_visit_expression_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_ccode_base_module_real_visit_return_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lock_statement = vala_ccode_base_module_real_visit_lock_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delete_statement = vala_ccode_base_module_real_visit_delete_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression = vala_ccode_base_module_real_visit_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_boolean_literal = vala_ccode_base_module_real_visit_boolean_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_character_literal = vala_ccode_base_module_real_visit_character_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_integer_literal = vala_ccode_base_module_real_visit_integer_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_real_literal = vala_ccode_base_module_real_visit_real_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_string_literal = vala_ccode_base_module_real_visit_string_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_null_literal = vala_ccode_base_module_real_visit_null_literal;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_base_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_base_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_MODULE_CLASS (klass)->visit_base_access = vala_ccode_base_module_real_visit_base_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_postfix_expression = vala_ccode_base_module_real_visit_postfix_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_object_creation_expression = vala_ccode_base_module_real_visit_object_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_sizeof_expression = vala_ccode_base_module_real_visit_sizeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_typeof_expression = vala_ccode_base_module_real_visit_typeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_unary_expression = vala_ccode_base_module_real_visit_unary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_ccode_base_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_pointer_indirection = vala_ccode_base_module_real_visit_pointer_indirection;
	VALA_CCODE_MODULE_CLASS (klass)->visit_addressof_expression = vala_ccode_base_module_real_visit_addressof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_base_module_real_visit_reference_transfer_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_binary_expression = vala_ccode_base_module_real_visit_binary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_type_check = vala_ccode_base_module_real_visit_type_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lambda_expression = vala_ccode_base_module_real_visit_lambda_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_base_module_real_get_implicit_cast_expression;
}


static void vala_ccode_base_module_instance_init (ValaCCodeBaseModule * self) {
	self->priv = VALA_CCODE_BASE_MODULE_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->temp_ref_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->next_temp_var_id = 0;
	self->in_creation_method = FALSE;
	self->in_constructor = FALSE;
	self->in_static_or_class_ctor = FALSE;
	self->current_method_inner_error = FALSE;
	self->next_coroutine_state = 1;
	self->in_plugin = FALSE;
	self->variable_name_map = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
}


static void vala_ccode_base_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeBaseModule * self;
	self = VALA_CCODE_BASE_MODULE (obj);
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	(self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL));
	(self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL));
	(self->current_type_symbol == NULL) ? NULL : (self->current_type_symbol = (vala_code_node_unref (self->current_type_symbol), NULL));
	(self->current_class == NULL) ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL));
	(self->current_method == NULL) ? NULL : (self->current_method = (vala_code_node_unref (self->current_method), NULL));
	(self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL));
	(self->current_try == NULL) ? NULL : (self->current_try = (vala_code_node_unref (self->current_try), NULL));
	(self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL));
	(self->header_declarations == NULL) ? NULL : (self->header_declarations = (vala_ccode_declaration_space_unref (self->header_declarations), NULL));
	(self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL));
	(self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL));
	(self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL));
	(self->class_init_fragment == NULL) ? NULL : (self->class_init_fragment = (vala_ccode_node_unref (self->class_init_fragment), NULL));
	(self->base_init_fragment == NULL) ? NULL : (self->base_init_fragment = (vala_ccode_node_unref (self->base_init_fragment), NULL));
	(self->class_finalize_fragment == NULL) ? NULL : (self->class_finalize_fragment = (vala_ccode_node_unref (self->class_finalize_fragment), NULL));
	(self->base_finalize_fragment == NULL) ? NULL : (self->base_finalize_fragment = (vala_ccode_node_unref (self->base_finalize_fragment), NULL));
	(self->instance_init_fragment == NULL) ? NULL : (self->instance_init_fragment = (vala_ccode_node_unref (self->instance_init_fragment), NULL));
	(self->instance_finalize_fragment == NULL) ? NULL : (self->instance_finalize_fragment = (vala_ccode_node_unref (self->instance_finalize_fragment), NULL));
	(self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL));
	(self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL));
	(self->param_spec_struct == NULL) ? NULL : (self->param_spec_struct = (vala_ccode_node_unref (self->param_spec_struct), NULL));
	(self->instance_struct == NULL) ? NULL : (self->instance_struct = (vala_ccode_node_unref (self->instance_struct), NULL));
	(self->type_struct == NULL) ? NULL : (self->type_struct = (vala_ccode_node_unref (self->type_struct), NULL));
	(self->instance_priv_struct == NULL) ? NULL : (self->instance_priv_struct = (vala_ccode_node_unref (self->instance_priv_struct), NULL));
	(self->type_priv_struct == NULL) ? NULL : (self->type_priv_struct = (vala_ccode_node_unref (self->type_priv_struct), NULL));
	(self->closure_struct == NULL) ? NULL : (self->closure_struct = (vala_ccode_node_unref (self->closure_struct), NULL));
	(self->prop_enum == NULL) ? NULL : (self->prop_enum = (vala_ccode_node_unref (self->prop_enum), NULL));
	(self->cenum == NULL) ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL));
	(self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL));
	(self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL));
	(self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL));
	(self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL));
	(self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL));
	(self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL));
	(self->c_keywords == NULL) ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL));
	(self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL));
	(self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL));
	(self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL));
	(self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL));
	(self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL));
	(self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL));
	(self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL));
	(self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL));
	(self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL));
	(self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL));
	(self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL));
	(self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL));
	(self->int16_type == NULL) ? NULL : (self->int16_type = (vala_code_node_unref (self->int16_type), NULL));
	(self->uint16_type == NULL) ? NULL : (self->uint16_type = (vala_code_node_unref (self->uint16_type), NULL));
	(self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL));
	(self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL));
	(self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL));
	(self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL));
	(self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL));
	(self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL));
	(self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL));
	(self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL));
	(self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL));
	(self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL));
	(self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL));
	(self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL));
	(self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL));
	(self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL));
	(self->gbytearray_type == NULL) ? NULL : (self->gbytearray_type = (vala_code_node_unref (self->gbytearray_type), NULL));
	(self->gptrarray_type == NULL) ? NULL : (self->gptrarray_type = (vala_code_node_unref (self->gptrarray_type), NULL));
	(self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL));
	(self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL));
	(self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL));
	(self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL));
	(self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL));
	self->module_init_param_name = (g_free (self->module_init_param_name), NULL);
	(self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL));
	(self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL));
	VALA_CCODE_MODULE_CLASS (vala_ccode_base_module_parent_class)->finalize (obj);
}


GType vala_ccode_base_module_get_type (void) {
	static GType vala_ccode_base_module_type_id = 0;
	if (vala_ccode_base_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBaseModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_base_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBaseModule), 0, (GInstanceInitFunc) vala_ccode_base_module_instance_init, NULL };
		vala_ccode_base_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MODULE, "ValaCCodeBaseModule", &g_define_type_info, 0);
	}
	return vala_ccode_base_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




