/* valabooleantype.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabooleantype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>




enum  {
	VALA_BOOLEAN_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_boolean_type_real_copy (ValaDataType* base);
static gpointer vala_boolean_type_parent_class = NULL;



ValaBooleanType* vala_boolean_type_construct (GType object_type, ValaStruct* type_symbol) {
	ValaBooleanType* self;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	self = (ValaBooleanType*) vala_value_type_construct (object_type, (ValaTypeSymbol*) type_symbol);
	return self;
}


ValaBooleanType* vala_boolean_type_new (ValaStruct* type_symbol) {
	return vala_boolean_type_construct (VALA_TYPE_BOOLEAN_TYPE, type_symbol);
}


static ValaDataType* vala_boolean_type_real_copy (ValaDataType* base) {
	ValaBooleanType * self;
	ValaBooleanType* result;
	self = (ValaBooleanType*) base;
	result = vala_boolean_type_new (VALA_STRUCT (vala_value_type_get_type_symbol ((ValaValueType*) self)));
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	return (ValaDataType*) result;
}


static void vala_boolean_type_class_init (ValaBooleanTypeClass * klass) {
	vala_boolean_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_boolean_type_real_copy;
}


static void vala_boolean_type_instance_init (ValaBooleanType * self) {
}


GType vala_boolean_type_get_type (void) {
	static GType vala_boolean_type_type_id = 0;
	if (vala_boolean_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBooleanTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_boolean_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBooleanType), 0, (GInstanceInitFunc) vala_boolean_type_instance_init, NULL };
		vala_boolean_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaBooleanType", &g_define_type_info, 0);
	}
	return vala_boolean_type_type_id;
}




