/* valanullliteral.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanullliteral.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaexpression.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valanulltype.h>




enum  {
	VALA_NULL_LITERAL_DUMMY_PROPERTY
};
static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_null_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_null_literal_real_is_pure (ValaExpression* base);
static gboolean vala_null_literal_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_null_literal_parent_class = NULL;



/**
 * Creates a new null literal.
 *
 * @param source reference to source code
 * @return       newly created null literal
 */
ValaNullLiteral* vala_null_literal_construct (GType object_type, ValaSourceReference* source) {
	ValaNullLiteral* self;
	self = (ValaNullLiteral*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaNullLiteral* vala_null_literal_new (ValaSourceReference* source) {
	return vala_null_literal_construct (VALA_TYPE_NULL_LITERAL, source);
}


static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNullLiteral * self;
	self = (ValaNullLiteral*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_null_literal (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static char* vala_null_literal_real_to_string (ValaCodeNode* base) {
	ValaNullLiteral * self;
	self = (ValaNullLiteral*) base;
	return g_strdup ("null");
}


static gboolean vala_null_literal_real_is_pure (ValaExpression* base) {
	ValaNullLiteral * self;
	self = (ValaNullLiteral*) base;
	return TRUE;
}


static gboolean vala_null_literal_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaNullLiteral * self;
	ValaNullType* _tmp1;
	self = (ValaNullLiteral*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp1 = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp1 = vala_null_type_new (vala_code_node_get_source_reference ((ValaCodeNode*) self))));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL));
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


static void vala_null_literal_class_init (ValaNullLiteralClass * klass) {
	vala_null_literal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_null_literal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_null_literal_real_to_string;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_null_literal_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->check = vala_null_literal_real_check;
}


static void vala_null_literal_instance_init (ValaNullLiteral * self) {
}


GType vala_null_literal_get_type (void) {
	static GType vala_null_literal_type_id = 0;
	if (vala_null_literal_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNullLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_null_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNullLiteral), 0, (GInstanceInitFunc) vala_null_literal_instance_init, NULL };
		vala_null_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaNullLiteral", &g_define_type_info, 0);
	}
	return vala_null_literal_type_id;
}




