/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rfb.Exception;
import rfb.PixelFormat;

public class PixelBuffer {
    public int[] data;
    protected PixelFormat format;
    protected int width_;
    protected int height_;

    public PixelBuffer() {
        this.setPF(new PixelFormat());
    }

    public void setPF(PixelFormat pixelFormat) {
        if (pixelFormat.bpp != 32) {
            throw new Exception("Internal error: bpp must be 32 in PixelBuffer");
        }
        this.format = pixelFormat;
    }

    public PixelFormat getPF() {
        return this.format;
    }

    public final int width() {
        return this.width_;
    }

    public final int height() {
        return this.height_;
    }

    public final int area() {
        return this.width_ * this.height_;
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5) {
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                this.data[i * this.width_ + j] = n5;
            }
        }
    }

    public void imageRect(int n, int n2, int n3, int n4, int[] nArray) {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, n3 * i, this.data, this.width_ * (n2 + i) + n, n3);
        }
    }

    public void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.width_ * n2 + n;
        int n8 = this.width_ * n6 + n5;
        int n9 = this.width_;
        if (n2 > n6) {
            n8 += (n4 - 1) * n9;
            n7 += (n4 - 1) * n9;
            n9 = -n9;
        }
        int n10 = n7 + n4 * n9;
        while (n7 != n10) {
            System.arraycopy(this.data, n8, this.data, n7, n3);
            n8 += n9;
            n7 += n9;
        }
    }

    public void maskRect(int n, int n2, int n3, int n4, int[] nArray, byte[] byArray) {
        int n5 = (n3 + 7) / 8;
        for (int i = 0; i < n4; ++i) {
            int n6 = n2 + i;
            if (n6 < 0 || n6 >= this.height_) continue;
            for (int j = 0; j < n3; ++j) {
                int n7;
                int n8;
                int n9 = n + j;
                if (n9 < 0 || n9 >= this.width_ || (byArray[n8 = i * n5 + j / 8] & 1 << (n7 = 7 - j % 8)) == 0) continue;
                this.data[n6 * this.width_ + n9] = nArray[i * n3 + j];
            }
        }
    }
}

