'''OpenGL extension EXT.debug_label

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.debug_label to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/debug_label.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.debug_label import *
from OpenGL.raw.GL.EXT.debug_label import _EXTENSION_NAME

def glInitDebugLabelEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glGetObjectLabelEXT.label size not checked against bufSize
glGetObjectLabelEXT=wrapper.wrapper(glGetObjectLabelEXT).setInputArraySize(
    'length', 1
).setInputArraySize(
    'label', None
)
### END AUTOGENERATED SECTION