%%
%% This is file `lebhart/lebhart.cls',
%% generated with the docstrip utility.

%% Copyright (C) 2021-2022 by Jinwen XU
%% 
%% This is part of the colorist class series.
%% 
%% This work may be distributed and/or modified under the conditions of the
%% LaTeX Project Public License, either version 1.3c of this license or (at
%% your option) any later version. The latest version of this license is in
%% 
%%     http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3c or later is part of all distributions of LaTeX version
%% 2005/12/01 or later.
%% 
\NeedsTeXFormat{LaTeX2e}[2020-10-01]
\RequirePackage{l3keys2e}
\ProvidesExplClass
  {lebhart}
  {2022/03/19} {}
  {A colorful article style}

\tl_const:Nn \l__colorclass_base_class_tl { article }


\bool_new:N \l__colorclass_load_custom_font_file_bool
\bool_set_false:N \l__colorclass_load_custom_font_file_bool

\bool_new:N \l__colorclass_load_custom_font_file_latin_bool
\bool_set_false:N \l__colorclass_load_custom_font_file_latin_bool

\bool_new:N \l__colorclass_load_custom_font_file_cjk_bool
\bool_set_false:N \l__colorclass_load_custom_font_file_cjk_bool

\bool_new:N \l__colorclass_load_custom_font_file_math_bool
\bool_set_false:N \l__colorclass_load_custom_font_file_math_bool

\keys_define:nn { colorclass }
  {
    , draft                   .bool_set:N         = \l__colorclass_fast_bool
    , draft                   .initial:n          = { false }
    , fast                    .bool_set:N         = \l__colorclass_fast_bool


    , load custom font file   .code:n             = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_str { #1 }
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_latin_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_latin_str { colorist.font.latin }
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_cjk_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_cjk_str   { colorist.font.cjk }
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_math_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_math_str  { colorist.font.math }
                                                    }
    , load custom font file   .default:n          = { colorist.font }
    , load~custom~font~file   .code:n             = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_str { #1 }
                                                    }
    , load~custom~font~file   .default:n          = { colorist.font }
    , load-custom-font-file   .code:n             = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_str { #1 }
                                                    }
    , load-custom-font-file   .default:n          = { colorist.font }

    , load custom latin font file   .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_latin_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_latin_str { #1 }
                                                    }
    , load custom latin font file   .default:n    = { colorist.font.latin }
    , load~custom~latin~font~file   .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_latin_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_latin_str { #1 }
                                                    }
    , load~custom~latin~font~file   .default:n    = { colorist.font.latin }
    , load-custom-latin-font-file   .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_latin_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_latin_str { #1 }
                                                    }
    , load-custom-latin-font-file   .default:n    = { colorist.font.latin }

    , load custom cjk font file     .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_cjk_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_cjk_str { #1 }
                                                    }
    , load custom cjk font file     .default:n    = { colorist.font.cjk }
    , load~custom~cjk~font~file     .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_cjk_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_cjk_str { #1 }
                                                    }
    , load~custom~cjk~font~file     .default:n    = { colorist.font.cjk }
    , load-custom-cjk-font-file     .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_cjk_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_cjk_str { #1 }
                                                    }
    , load-custom-cjk-font-file     .default:n    = { colorist.font.cjk }

    , load custom math font file    .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_math_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_math_str { #1 }
                                                    }
    , load custom math font file    .default:n    = { colorist.font.math }
    , load~custom~math~font~file    .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_math_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_math_str { #1 }
                                                    }
    , load~custom~math~font~file    .default:n    = { colorist.font.math }
    , load-custom-math-font-file    .code:n       = {
                                                      \bool_set_true:N \l__colorclass_load_custom_font_file_math_bool
                                                      \str_set:Nn \l__colorclass_custom_font_file_math_str { #1 }
                                                    }
    , load-custom-math-font-file    .default:n    = { colorist.font.math }

    , a4paper                 .bool_set:N         = \l__colorclass_a_four_paper_bool
    , a4paper                 .initial:n          = { false }
    , b5paper                 .bool_set:N         = \l__colorclass_b_five_paper_bool
    , b5paper                 .initial:n          = { false }

    , 11pt                    .code:n             = { \PassOptionsToClass { \CurrentOption } { \l__colorclass_base_class_tl } }
    , 12pt                    .code:n             = { \PassOptionsToClass { \CurrentOption } { \l__colorclass_base_class_tl } }

    , unknown                 .code:n             = {
                                                      \PassOptionsToPackage { \CurrentOption } { colorist }
                                                    }
  }
\ProcessKeysOptions { colorclass }

\LoadClass{\l__colorclass_base_class_tl}

%%================================
%%  Page layout
%%================================
\RequirePackage { silence }
\WarningFilter { geometry } { Over-specification }

\PassOptionsToPackage { heightrounded } { geometry }
\RequirePackage { geometry }

\geometry
  {
    papersize = { 8.5in, 11in },
    total = { 6.500in, 9.130in },
    centering,
    footnotesep = 2em plus 2pt minus 2pt,
  }

\bool_if:NT \l__colorclass_b_five_paper_bool
  {
    \geometry
      {
        b5paper,
        total = { 5.535in, 8.160in },
        centering,
        footnotesep = 2em plus 2pt minus 2pt,
      }
  }

\bool_if:NT \l__colorclass_a_four_paper_bool
  {
    \geometry
      {
        a4paper,
        total = { 6.500in, 9.685in },
        centering,
        footnotesep = 2em plus 2pt minus 2pt,
      }
  }

\bool_if:NT \l__colorclass_fast_bool
  {
    \PassOptionsToPackage { fast } { colorist }
    \RequirePackage { draftwatermark }
    \DraftwatermarkOptions { text = { \normalfont DRAFT }, color = paper!97!-paper }
  }

\RequirePackage { indentfirst }

\RequirePackage { colorist }

\hfuzz=2pt
\vfuzz=2pt

%%================================
%%  Fonts
%%================================
\WarningFilter { latexfont } { Font~shape }
\WarningFilter { latexfont } { Some~font  }

\cs_new_protected:Nn \__colorclass_load_file_or_config:Nnn
  {
    \bool_if:NT #1
      {
        \exp_args:Nx \file_if_exist:nT { #2 }
          {
            \exp_args:Nx \file_input:n { #2 }
            \use_none:nn
          }
      }
    \use:n { #3 }
  }

\cs_new_protected:Nn \__colorclass_if_font_exist:nnn
  {
    \bool_if:NTF \l__colorclass_fast_bool
      { #3 }
      { \fontspec_font_if_exist:nTF { #1 } { #2 } { #3 } }
  }

\__colorclass_load_file_or_config:Nnn \l__colorclass_load_custom_font_file_bool { \l__colorclass_custom_font_file_str }
  {
    \RequirePackage { projlib-font }

    \bool_if:NF \g_projlib_font_already_set_bool
      {
        \bool_if:NT \l__colorclass_fast_bool
          {
            \RequirePackage { mathpazo }
          }

        \PassOptionsToPackage { no-math,quiet } { fontspec }
        \RequirePackage { fontspec }

        \__colorclass_load_file_or_config:Nnn \l__colorclass_load_custom_font_file_latin_bool { \l__colorclass_custom_font_file_latin_str }
          {
            \__colorclass_if_font_exist:nnn { Palatino~Linotype }
              {
                \bool_if:NTF \l__projlib_font_useosf_bool
                  {
                    \setmainfont { Palatino~Linotype } [ Numbers = OldStyle ]
                  }
                  {
                    \setmainfont { Palatino~Linotype }
                  }
              }
              {
                \bool_if:NTF \l__projlib_font_useosf_bool
                  {
                    \setmainfont { TeXGyrePagellaX-Regular.otf }
                      [
                        BoldFont       = TeXGyrePagellaX-Bold.otf ,
                        ItalicFont     = TeXGyrePagellaX-Italic.otf ,
                        BoldItalicFont = TeXGyrePagellaX-BoldItalic.otf ,
                        Numbers        = OldStyle ,
                      ]
                  }
                  {
                    \setmainfont { TeXGyrePagellaX-Regular.otf }
                      [
                        BoldFont       = TeXGyrePagellaX-Bold.otf ,
                        ItalicFont     = TeXGyrePagellaX-Italic.otf ,
                        BoldItalicFont = TeXGyrePagellaX-BoldItalic.otf ,
                      ]
                  }
              }
            \setsansfont { SourceSansPro-Regular.otf }
              [
                Scale          = MatchLowercase ,
                BoldFont       = SourceSansPro-Bold.otf ,
                ItalicFont     = SourceSansPro-RegularIt.otf ,
                BoldItalicFont = SourceSansPro-BoldIt.otf ,
              ]
            \setmonofont { NewCMMono10-Regular.otf }
              [
                Scale          = 1.05 ,
                BoldFont       = NewCMMono10-Bold.otf ,
                ItalicFont     = NewCMMono10-Italic.otf ,
                BoldItalicFont = NewCMMono10-BoldOblique.otf ,
              ]

            \projlib_language_set_linespacing_latin:n { \setstretch { 1.07 } }
          }
      }

    \PassOptionsToPackage { fontset = none, scheme = plain } { ctex }
    \RequirePackage { ctex }

    \__colorclass_load_file_or_config:Nnn \l__colorclass_load_custom_font_file_cjk_bool { \l__colorclass_custom_font_file_cjk_str }
      {
        \__colorclass_if_font_exist:nnn { SourceHanSerifSC-Regular }
          {
            \setCJKmainfont { SourceHanSerifSC-Regular }
              [
                BoldFont       = SourceHanSerifSC-Bold ,
                ItalicFont     = * ,
                BoldItalicFont = SourceHanSerifSC-Bold ,
              ]
          }
          {
            \setCJKmainfont { FandolSong-Regular.otf }
              [
                BoldFont       = FandolSong-Bold.otf ,
                ItalicFont     = FandolKai-Regular.otf ,
                BoldItalicFont = FandolKai-Regular.otf ,
                BoldItalicFeatures = { FakeBold = 4 } ,
              ]
          }

        \__colorclass_if_font_exist:nnn { SourceHanSansSC-Regular }
          {
            \setCJKsansfont{SourceHanSansSC-Regular}
              [
                BoldFont       = SourceHanSansSC-Bold ,
                ItalicFont     = * ,
                BoldItalicFont = SourceHanSansSC-Bold ,
              ]
          }
          {
            \setCJKsansfont { FandolHei-Regular.otf }
              [
                BoldFont       = FandolHei-Bold.otf ,
                ItalicFont     = * ,
                BoldItalicFont = FandolHei-Bold.otf ,
              ]
          }

        \__colorclass_if_font_exist:nnn { SourceHanMonoSC-Regular }
          {
            \setCJKmonofont { SourceHanMonoSC-Regular }
              [
                BoldFont       = SourceHanMonoSC-Medium ,
                ItalicFont     = * ,
                BoldItalicFont = SourceHanMonoSC-Medium ,
              ]
          }
          {
            \setCJKmonofont { FandolFang-Regular.otf }
              [
                BoldFont       = * ,
                BoldFeatures   = { FakeBold = 4 } ,
                ItalicFont     = * ,
                BoldItalicFont = * ,
                BoldItalicFeatures = { FakeBold = 4 } ,
              ]
          }

        \bool_if:NT \g__projlib_language_enabled_schinese_bool
          {
            \__colorclass_if_font_exist:nnn { SourceHanSerifSC-Regular }
              {
                \setCJKfamilyfont { SCmain } { SourceHanSerifSC-Regular }
                  [
                    BoldFont       = SourceHanSerifSC-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSerifSC-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { SCmain } { FandolSong-Regular.otf }
                  [
                    BoldFont       = FandolSong-Bold.otf ,
                    ItalicFont     = FandolKai-Regular.otf ,
                    BoldItalicFont = FandolKai-Regular.otf ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanSansSC-Regular }
              {
                \setCJKfamilyfont { SCsans } { SourceHanSansSC-Regular }
                  [
                    BoldFont       = SourceHanSansSC-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSansSC-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { SCsans } { FandolHei-Regular.otf }
                  [
                    BoldFont       = FandolHei-Bold.otf ,
                    ItalicFont     = * ,
                    BoldItalicFont = FandolHei-Bold.otf ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanMonoSC-Regular }
              {
                \setCJKfamilyfont { SCmono } { SourceHanMonoSC-Regular }
                  [
                    BoldFont       = SourceHanMonoSC-Medium ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanMonoSC-Medium ,
                  ]
              }
              {
                \setCJKfamilyfont { SCmono } { FandolFang-Regular.otf }
                  [
                    BoldFont       = * ,
                    BoldFeatures   = { FakeBold = 4 } ,
                    ItalicFont     = * ,
                    BoldItalicFont = * ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
          }

        \bool_if:NT \g__projlib_language_enabled_tchinese_bool
          {
            \__colorclass_if_font_exist:nnn { SourceHanSerifTC-Regular }
              {
                \setCJKfamilyfont { TCmain } { SourceHanSerifTC-Regular }
                  [
                    BoldFont       = SourceHanSerifTC-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSerifTC-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { TCmain } { FandolSong-Regular.otf }
                  [
                    BoldFont       = FandolSong-Bold.otf ,
                    ItalicFont     = FandolKai-Regular.otf ,
                    BoldItalicFont = FandolKai-Regular.otf ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanSansTC-Regular }
              {
                \setCJKfamilyfont { TCsans } { SourceHanSansTC-Regular }
                  [
                    BoldFont       = SourceHanSansTC-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSansTC-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { TCsans } { FandolHei-Regular.otf }
                  [
                    BoldFont       = FandolHei-Bold.otf ,
                    ItalicFont     = * ,
                    BoldItalicFont = FandolHei-Bold.otf ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanMonoTC-Regular }
              {
                \setCJKfamilyfont { TCmono } { SourceHanMonoTC-Regular }
                  [
                    BoldFont       = SourceHanMonoTC-Medium ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanMonoTC-Medium ,
                  ]
              }
              {
                \setCJKfamilyfont { TCmono } { FandolFang-Regular.otf }
                  [
                    BoldFont       = * ,
                    BoldFeatures   = { FakeBold = 4 } ,
                    ItalicFont     = * ,
                    BoldItalicFont = * ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
          }

        \bool_if:NT \g__projlib_language_enabled_japanese_bool
          {
            \__colorclass_if_font_exist:nnn { SourceHanSerif-Regular }
              {
                \setCJKfamilyfont { JPmain } { SourceHanSerif-Regular }
                  [
                    BoldFont       = SourceHanSerif-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSerif-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { JPmain } { FandolSong-Regular.otf }
                  [
                    BoldFont       = FandolSong-Bold.otf ,
                    ItalicFont     = FandolKai-Regular.otf ,
                    BoldItalicFont = FandolKai-Regular.otf ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanSans-Regular }
              {
                \setCJKfamilyfont { JPsans } { SourceHanSans-Regular }
                  [
                    BoldFont       = SourceHanSans-Bold ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanSans-Bold ,
                  ]
              }
              {
                \setCJKfamilyfont { JPsans } { FandolHei-Regular.otf }
                  [
                    BoldFont       = FandolHei-Bold.otf ,
                    ItalicFont     = * ,
                    BoldItalicFont = FandolHei-Bold.otf ,
                  ]
              }
            \__colorclass_if_font_exist:nnn { SourceHanMono-Regular }
              {
                \setCJKfamilyfont { JPmono } { SourceHanMono-Regular }
                  [
                    BoldFont       = SourceHanMono-Medium ,
                    ItalicFont     = * ,
                    BoldItalicFont = SourceHanMono-Medium ,
                  ]
              }
              {
                \setCJKfamilyfont { JPmono } { FandolFang-Regular.otf }
                  [
                    BoldFont       = * ,
                    BoldFeatures   = { FakeBold = 4 } ,
                    ItalicFont     = * ,
                    BoldItalicFont = * ,
                    BoldItalicFeatures = { FakeBold = 4 } ,
                  ]
              }
          }

        \cs_new:Nn \colorclass_cjk_sffamily: {}
        \cs_new:Nn \colorclass_cjk_ttfamily: {}

        \hook_gput_code:nnn { cmd/sffamily/after } { colorclass } { \colorclass_cjk_sffamily: }
        \hook_gput_code:nnn { cmd/ttfamily/after } { colorclass } { \colorclass_cjk_ttfamily: }

        \AddLanguageSetting [schinese]
          {
            \cs_set:Nn \colorclass_cjk_sffamily: { \CJKfamily { SCsans } }
            \cs_set:Nn \colorclass_cjk_ttfamily: { \CJKfamily { SCmono } }
            \CJKfamily { SCmain }
          }
        \AddLanguageSetting [tchinese]
          {
            \cs_set:Nn \colorclass_cjk_sffamily: { \CJKfamily { TCsans } }
            \cs_set:Nn \colorclass_cjk_ttfamily: { \CJKfamily { TCmono } }
            \CJKfamily { TCmain }
          }
        \AddLanguageSetting [japanese]
          {
            \cs_set:Nn \colorclass_cjk_sffamily: { \CJKfamily { JPsans } }
            \cs_set:Nn \colorclass_cjk_ttfamily: { \CJKfamily { JPmono } }
            \CJKfamily { JPmain }
          }
      }

    \__colorclass_load_file_or_config:Nnn \l__colorclass_load_custom_font_file_math_bool { \l__colorclass_custom_font_file_math_str }
      {
        \bool_if:NF \g_projlib_font_already_set_bool
          {
            \bool_if:NTF \l__colorclass_fast_bool
              {
                \RequirePackage { amssymb }
              }
              {
                \PassOptionsToPackage { warnings-off = { mathtools-colon, mathtools-overbracket } } { unicode-math }
                \RequirePackage { unicode-math }
                \unimathsetup { math-style = ISO, partial = upright, nabla = upright }
                \setmathfont { Asana-Math.otf }
                \__colorclass_if_font_exist:nnn { Neo~Euler }
                  {
                    \setmathfont { Neo~Euler }
                      [
                        range             = { up / { Latin, latin, Greek, greek },
                                              bfup / { Latin, latin, Greek, greek },
                                              cal, bfcal, frak, bffrak,
                                              `(, `), `[, `], `\{, `\}, `:, `=, \ne, \equiv, `/, \backslash,
                                              \in, \notin, \ni, \subset, \supset, \subseteq, \supseteq,
                                              \rightarrow, \leftarrow, \leftrightarrow,
                                              \longleftarrow, \longrightarrow, \longleftrightarrow,
                                              \Leftarrow, \Rightarrow, \Leftrightarrow,
                                              \Longleftarrow, \Longrightarrow, \Longleftrightarrow,
                                              \nrightarrow, \nleftarrow, \nleftrightarrow,
                                              \nLeftarrow, \nRightarrow, \nLeftrightarrow,
                                              \mapsto, \hookrightarrow, \hookleftarrow,
                                              \leftharpoonup, \rightharpoonup, \leftharpoondown, \rightharpoondown,
                                              \rightleftharpoons, \leftrightharpoons,
                                              \sum, \prod, \coprod,
                                              \sqrt, \int, \iint, \iiint, \oint
                                            },
                        script-features   = {},
                        sscript-features  = {},
                        Scale             = 1.05,
                      ]
                  }{}
                \setmathfont { latinmodern-math.otf }
                  [
                    range = { \leq, \geq, \ll, \gg, \lll, \ggg, \leqslant, \geqslant },
                    Scale = 0.95,
                  ]
                \setmathfont { texgyrepagella-math.otf }
                  [
                    range = { up / num, bfup / num }
                  ]

                \hook_gput_code:nnn { begindocument } { colorclass }
                  {
                    \NewCommandCopy \colorclass_backup_mid: \mid
                    \RenewDocumentCommand \mid {}
                      { \skip_horizontal:n {-.15em} \colorclass_backup_mid: \skip_horizontal:n {-.15em} }
                    \NewCommandCopy \colorclass_backup_nmid: \nmid
                    \RenewDocumentCommand \nmid {}
                      { \skip_horizontal:n {-.15em} \colorclass_backup_nmid: \skip_horizontal:n {-.15em} }
                  }

                \RequirePackage { tikz-cd }

                \box_new:N \l__colorclass_xarrows_above_box
                \box_new:N \l__colorclass_xarrows_below_box
                \dim_new:N \l__colorclass_xarrows_length_dim
                \cs_new_protected:Nn \colorclass_xarrows_generic:nnnn
                  % #3 = option of \tikz
                  % #4 = edge of \draw
                  {
                    \hbox_set:Nn \l__colorclass_xarrows_below_box { \ensuremath { \scriptstyle #1 } }
                    \hbox_set:Nn \l__colorclass_xarrows_above_box { \ensuremath { \scriptstyle #2 } }
                    \dim_set:Nn \l__colorclass_xarrows_length_dim
                      { \dim_eval:n { \dim_max:nn { \box_wd:N \l__colorclass_xarrows_below_box } { \box_wd:N \l__colorclass_xarrows_above_box } + .8em } }
                    \mathrel
                      {
                        \tikz [ #3, baseline = -.55ex, every~node/.style = { inner~sep = 0pt } ]
                          \draw (0,0) #4
                            node [ below = 3pt ] { \box_use:N \l__colorclass_xarrows_below_box }
                            node [ above = 2pt ] { \box_use:N \l__colorclass_xarrows_above_box }
                            ( \l__colorclass_xarrows_length_dim ,0) ;
                      }
                  }

                \RenewDocumentCommand \xrightarrow { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } { -> } { -- }
                  }
                \RenewDocumentCommand \xleftarrow { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } { <- } { -- }
                  }
                \RenewDocumentCommand \xleftrightarrow { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } { <-> } { -- }
                  }
                \RenewDocumentCommand \xhookrightarrow { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } {} { edge [ commutative~diagrams/hookrightarrow ] }
                  }
                \RenewDocumentCommand \xhookleftarrow { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } {} { edge [ commutative~diagrams/hookleftarrow ] }
                  }
                \RenewDocumentCommand \xmapsto { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } {} { edge [ commutative~diagrams/mapsto ] }
                  }
                \NewDocumentCommand \xlongequal { O{} m }
                  {
                    \colorclass_xarrows_generic:nnnn { #1 } { #2 } {} { edge [ commutative~diagrams/equal ] }
                  }
                \hook_gput_code:nnn { begindocument/end } { colorclass }
                  {
                    \RenewDocumentCommand \twoheadrightarrow {}
                      {
                        \colorclass_xarrows_generic:nnnn { \,\, } {} {} { edge [ commutative~diagrams/twoheadrightarrow ] }
                      }
                    \RenewDocumentCommand \twoheadleftarrow {}
                      {
                        \colorclass_xarrows_generic:nnnn { \,\, } {} {} { edge [ commutative~diagrams/twoheadleftarrow ] }
                      }
                  }
              }
          }
      }
  }

\PassOptionsToPackage { all } { nowidow }
\RequirePackage { nowidow }
\RequirePackage { embrac }

%%================================
%%  Graphics
%%================================
\RequirePackage { graphicx }
\graphicspath { { images/ } }
\RequirePackage { wrapfig }
\RequirePackage { float }
\RequirePackage { caption }
\captionsetup { font = small }

\endinput
%%
%% End of file `lebhart/lebhart.cls'.
