/* AssistantOperation.c generated by valac 0.30.2, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include "widgets.h"
#include <libsecret/secret.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantOperationDoApplyData AssistantOperationDoApplyData;
typedef struct _Block2Data Block2Data;
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _AssistantOperationLookupKeyringData AssistantOperationLookupKeyringData;
typedef struct _Block3Data Block3Data;
typedef struct _AssistantOperationProvidePasswordData AssistantOperationProvidePasswordData;

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	gboolean _automatic;
	GtkEntry* nag_entry;
	GtkEntry* encrypt_entry;
	GtkEntry* encrypt_confirm_entry;
	GtkRadioButton* encrypt_enabled;
	GtkCheckButton* encrypt_remember;
	GtkWidget* _password_page;
	GtkWidget* _nag_page;
	GList* first_password_widgets;
	GMainLoop* password_ask_loop;
	GtkLabel* question_label;
	GtkWidget* _question_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkLabel* secondary_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkExpander* progress_expander;
	GtkWidget* _progress_page;
	GtkTextView* detail_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _op_icon;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean searched_for_passphrase;
	gboolean saved_pos;
	gint saved_x;
	gint saved_y;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantOperationDoApplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantOperation* self;
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	const gchar* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupOperation* _tmp5_;
	DejaDupOperation* _tmp6_;
	DejaDupOperation* _tmp7_;
	DejaDupOperation* _tmp8_;
	DejaDupOperation* _tmp9_;
	DejaDupOperation* _tmp10_;
	DejaDupBackend* _tmp11_;
	DejaDupBackend* _tmp12_;
	MountOperationAssistant* _tmp13_;
	MountOperationAssistant* _tmp14_;
	DejaDupOperation* _tmp15_;
	DejaDupBackend* _tmp16_;
	DejaDupBackend* _tmp17_;
	DejaDupOperation* _tmp18_;
	DejaDupOperation* _tmp19_;
};

struct _Block2Data {
	int _ref_count_;
	AssistantOperation* self;
	GtkWindow* win;
};

struct _AssistantOperationLookupKeyringData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantOperation* self;
	gchar* result;
	gchar* _tmp0_;
	SecretSchema* _tmp1_;
	SecretSchema* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	AssistantOperation* self;
	gchar* str;
	GMainLoop* loop;
};

struct _AssistantOperationProvidePasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantOperation* self;
	gchar* passphrase;
	gchar* _tmp0_;
	DejaDupOperation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkRadioButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GtkEntry* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	GtkCheckButton* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	SecretSchema* _tmp18_;
	SecretSchema* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GtkEntry* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkEntry* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	DejaDupOperation* _tmp31_;
	const gchar* _tmp32_;
	GError * _inner_error_;
};


static gpointer assistant_operation_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
gpointer assistant_page_info_ref (gpointer instance);
void assistant_page_info_unref (gpointer instance);
GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void assistant_value_set_page_info (GValue* value, gpointer v_object);
void assistant_value_take_page_info (GValue* value, gpointer v_object);
gpointer assistant_value_get_page_info (const GValue* value);
GType assistant_page_info_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_AUTOMATIC,
	ASSISTANT_OPERATION_PASSWORD_PAGE,
	ASSISTANT_OPERATION_NAG_PAGE,
	ASSISTANT_OPERATION_QUESTION_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_OP_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual);
void assistant_operation_set_secondary_label (AssistantOperation* self, const gchar* text);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
static void assistant_operation_show_detail (AssistantOperation* self, const gchar* detail);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_set_header_icon (Assistant* self, const gchar* name);
GtkWidget* assistant_operation_make_password_page (AssistantOperation* self);
static void __lambda12_ (AssistantOperation* self);
static void assistant_operation_check_password_validity (AssistantOperation* self);
static void ___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda13_ (AssistantOperation* self);
static void ___lambda13__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda14_ (AssistantOperation* self);
static void ___lambda14__gtk_editable_changed (GtkEditable* _sender, gpointer self);
GtkWidget* assistant_operation_make_nag_page (AssistantOperation* self);
static void __lambda15_ (AssistantOperation* self, GtkEditable* entry);
static void assistant_operation_check_nag_validity (AssistantOperation* self);
static void ___lambda15__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda16_ (AssistantOperation* self, GtkToggleButton* button);
static void ___lambda16__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
GtkWidget* assistant_operation_make_question_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_password_page (AssistantOperation* self);
static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_nag_page (AssistantOperation* self);
static void assistant_operation_set_nag_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_question_page (AssistantOperation* self);
static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
void status_icon_done (StatusIcon* self, gboolean success, gboolean cancelled, const gchar* detail);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o);
StatusIcon* status_icon_create (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
static void ___lambda18_ (AssistantOperation* self, StatusIcon* s, gboolean user_click);
static void ____lambda18__status_icon_show_window (StatusIcon* _sender, gboolean user_click, gpointer self);
static void ___lambda19_ (AssistantOperation* self, StatusIcon* s);
void assistant_operation_hide_everything (AssistantOperation* self);
static void ____lambda19__status_icon_hide_all (StatusIcon* _sender, gpointer self);
static void assistant_operation_do_apply_data_free (gpointer _data);
void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_);
static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* _data_);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self);
static void __lambda20_ (AssistantOperation* self, DejaDupOperation* o, const gchar* e, const gchar* d);
static void ___lambda20__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message);
static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_provide_password_finish (AssistantOperation* self, GAsyncResult* _res_);
GtkWidget* assistant_operation_get_password_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_nag_page (AssistantOperation* self);
void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_operation_real_do_cancel (AssistantOperation* self);
static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEventAny* event);
gboolean assistant_is_interrupted (Assistant* self);
void assistant_hide_for_now (Assistant* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click);
static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e);
static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ____lambda17_ (Block2Data* _data2_);
static gboolean _____lambda17__gsource_func (gpointer self);
static void assistant_operation_lookup_keyring_data_free (gpointer _data);
static void assistant_operation_lookup_keyring (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* assistant_operation_lookup_keyring_finish (AssistantOperation* self, GAsyncResult* _res_);
static gboolean assistant_operation_lookup_keyring_co (AssistantOperationLookupKeyringData* _data_);
static void assistant_operation_lookup_keyring_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda21_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ____lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void assistant_operation_ask_passphrase (AssistantOperation* self, gboolean first);
void assistant_allow_forward (Assistant* self, gboolean allow);
static void assistant_operation_configure_password_page (AssistantOperation* self, gboolean first);
static void assistant_operation_configure_nag_page (AssistantOperation* self);
static void assistant_operation_stop_password_loop (AssistantOperation* self, Assistant* dlg, gint resp);
static gboolean __lambda22_ (AssistantOperation* self);
static gboolean ___lambda22__gsource_func (gpointer self);
static void _assistant_operation_stop_password_loop_assistant_response (Assistant* _sender, gint response, gpointer self);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void assistant_operation_provide_password_data_free (gpointer _data);
static gboolean assistant_operation_provide_password_co (AssistantOperationProvidePasswordData* _data_);
static void assistant_operation_provide_password_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void assistant_operation_stop_question (AssistantOperation* self, Assistant* dlg, gint resp);
static void _assistant_operation_stop_question_assistant_response (Assistant* _sender, gint response, gpointer self);
GtkWidget* assistant_operation_get_question_page (AssistantOperation* self);
void assistant_go_forward (Assistant* self);
AssistantOperation* assistant_operation_construct (GType object_type);
Assistant* assistant_construct (GType object_type);
static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self);
static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self);
static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void assistant_operation_finalize (GObject* obj);
static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	result = NULL;
	return result;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self) {
}


void assistant_operation_add_custom_config_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->add_custom_config_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_window_get_icon_name ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	{
		GtkIconTheme* theme = NULL;
		GdkScreen* _tmp2_ = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		GtkIconTheme* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GtkIconTheme* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		_tmp2_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp3_ = gtk_icon_theme_get_for_screen (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		theme = _tmp4_;
		_tmp6_ = theme;
		_tmp7_ = gtk_window_get_icon_name ((GtkWindow*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_icon_theme_load_icon (_tmp6_, _tmp8_, 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (theme);
			goto __catch2_g_error;
		}
		_tmp10_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp10_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (theme);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("AssistantOperation.vala:138: %s\n", _tmp12_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->gives_progress;
	if (!_tmp0_) {
		GtkProgressBar* _tmp1_ = NULL;
		_tmp1_ = self->priv->progress_bar;
		gtk_progress_bar_pulse (_tmp1_);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, gdouble percent) {
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = percent;
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const gchar* label) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->progress_label;
	_tmp1_ = label;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->progress_file_label;
	gtk_label_set_label (_tmp2_, "");
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual) {
	gchar* prefix = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* log_line = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean adjustment_at_end = FALSE;
	GtkAdjustment* adjust = NULL;
	GtkScrolledWindow* _tmp23_ = NULL;
	GtkAdjustment* _tmp24_ = NULL;
	GtkAdjustment* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkAdjustment* _tmp28_ = NULL;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	GtkAdjustment* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	GtkAdjustment* _tmp34_ = NULL;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	GtkTextBuffer* buffer = NULL;
	GtkTextView* _tmp43_ = NULL;
	GtkTextBuffer* _tmp44_ = NULL;
	GtkTextBuffer* _tmp45_ = NULL;
	GtkTextBuffer* _tmp46_ = NULL;
	GtkTextBuffer* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gboolean _tmp51_ = FALSE;
	GtkTextBuffer* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	GtkTextIter iter = {0};
	GtkTextBuffer* _tmp62_ = NULL;
	GtkTextIter _tmp63_ = {0};
	GtkTextBuffer* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gboolean _tmp69_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = actual;
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		GtkLabel* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GtkLabel* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp1_ = assistant_operation_get_progress_file_prefix (self);
		_g_free0 (prefix);
		prefix = _tmp1_;
		_tmp2_ = self->priv->progress_label;
		_tmp3_ = prefix;
		_tmp4_ = g_strconcat (_tmp3_, " ", NULL);
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->progress_file_label;
		_tmp7_ = file;
		_tmp8_ = deja_dup_get_display_name (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GtkLabel* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkLabel* _tmp14_ = NULL;
		_tmp10_ = _ ("Scanning:");
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (prefix);
		prefix = _tmp11_;
		_tmp12_ = self->priv->progress_label;
		_tmp13_ = _ ("Scanning…");
		gtk_label_set_label (_tmp12_, _tmp13_);
		_tmp14_ = self->priv->progress_file_label;
		gtk_label_set_label (_tmp14_, "");
	}
	_tmp15_ = prefix;
	_tmp16_ = g_strconcat (_tmp15_, " ", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = file;
	_tmp19_ = g_file_get_parse_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	log_line = _tmp22_;
	adjustment_at_end = FALSE;
	_tmp23_ = self->priv->progress_scroll;
	_tmp24_ = gtk_scrolled_window_get_vadjustment (_tmp23_);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	adjust = _tmp25_;
	_tmp28_ = adjust;
	_tmp29_ = gtk_adjustment_get_value (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = adjust;
	_tmp32_ = gtk_adjustment_get_upper (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = adjust;
	_tmp35_ = gtk_adjustment_get_page_size (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp30_ >= (_tmp33_ - _tmp36_)) {
		_tmp27_ = TRUE;
	} else {
		GtkAdjustment* _tmp37_ = NULL;
		gdouble _tmp38_ = 0.0;
		gdouble _tmp39_ = 0.0;
		_tmp37_ = adjust;
		_tmp38_ = gtk_adjustment_get_page_size (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp27_ = _tmp39_ == ((gdouble) 0);
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		GtkExpander* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		_tmp40_ = self->priv->progress_expander;
		_tmp41_ = gtk_expander_get_expanded (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp26_ = !_tmp42_;
	}
	if (_tmp26_) {
		adjustment_at_end = TRUE;
	}
	_tmp43_ = self->priv->progress_text;
	_tmp44_ = gtk_text_view_get_buffer (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _g_object_ref0 (_tmp45_);
	buffer = _tmp46_;
	_tmp47_ = buffer;
	_tmp48_ = gtk_text_buffer_get_char_count (_tmp47_);
	if (_tmp48_ > 0) {
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		_tmp49_ = log_line;
		_tmp50_ = g_strconcat ("\n", _tmp49_, NULL);
		_g_free0 (log_line);
		log_line = _tmp50_;
	}
	_tmp52_ = buffer;
	_tmp53_ = gtk_text_buffer_get_line_count (_tmp52_);
	if (_tmp53_ >= 100) {
		gboolean _tmp54_ = FALSE;
		_tmp54_ = adjustment_at_end;
		_tmp51_ = _tmp54_;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		GtkTextIter start = {0};
		GtkTextIter line100 = {0};
		GtkTextBuffer* _tmp55_ = NULL;
		GtkTextIter _tmp56_ = {0};
		GtkTextBuffer* _tmp57_ = NULL;
		GtkTextBuffer* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		GtkTextIter _tmp60_ = {0};
		GtkTextBuffer* _tmp61_ = NULL;
		_tmp55_ = buffer;
		gtk_text_buffer_get_start_iter (_tmp55_, &_tmp56_);
		start = _tmp56_;
		_tmp57_ = buffer;
		_tmp58_ = buffer;
		_tmp59_ = gtk_text_buffer_get_line_count (_tmp58_);
		gtk_text_buffer_get_iter_at_line (_tmp57_, &_tmp60_, _tmp59_ - 100);
		line100 = _tmp60_;
		_tmp61_ = buffer;
		gtk_text_buffer_delete (_tmp61_, &start, &line100);
	}
	_tmp62_ = buffer;
	gtk_text_buffer_get_end_iter (_tmp62_, &_tmp63_);
	iter = _tmp63_;
	_tmp64_ = buffer;
	_tmp65_ = log_line;
	_tmp66_ = log_line;
	_tmp67_ = strlen (_tmp66_);
	_tmp68_ = _tmp67_;
	g_signal_emit_by_name (_tmp64_, "insert-text", &iter, _tmp65_, (gint) _tmp68_);
	_tmp69_ = adjustment_at_end;
	if (_tmp69_) {
		GtkAdjustment* _tmp70_ = NULL;
		GtkAdjustment* _tmp71_ = NULL;
		gdouble _tmp72_ = 0.0;
		gdouble _tmp73_ = 0.0;
		_tmp70_ = adjust;
		_tmp71_ = adjust;
		_tmp72_ = gtk_adjustment_get_upper (_tmp71_);
		_tmp73_ = _tmp72_;
		gtk_adjustment_set_value (_tmp70_, _tmp73_);
	}
	_g_object_unref0 (buffer);
	_g_object_unref0 (adjust);
	_g_free0 (log_line);
	_g_free0 (prefix);
}


void assistant_operation_set_secondary_label (AssistantOperation* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = text;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = text;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GtkLabel* _tmp9_ = NULL;
		_tmp3_ = self->priv->secondary_label;
		_tmp4_ = text;
		_tmp5_ = g_strconcat ("<i>", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "</i>", NULL);
		_tmp8_ = _tmp7_;
		gtk_label_set_label (_tmp3_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp9_ = self->priv->secondary_label;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	} else {
		GtkLabel* _tmp10_ = NULL;
		_tmp10_ = self->priv->secondary_label;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_ = NULL;
	gint row = 0;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GtkLabel* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GtkProgressBar* _tmp21_ = NULL;
	GtkProgressBar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GtkTextView* _tmp25_ = NULL;
	GtkTextView* _tmp26_ = NULL;
	GtkScrolledWindow* _tmp27_ = NULL;
	GtkScrolledWindow* _tmp28_ = NULL;
	GtkTextView* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkExpander* _tmp31_ = NULL;
	GtkExpander* _tmp32_ = NULL;
	GtkScrolledWindow* _tmp33_ = NULL;
	GtkExpander* _tmp34_ = NULL;
	GtkExpander* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) page, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (page, 6);
	row = 0;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = _tmp1_;
	_tmp2_ = self->priv->progress_label;
	gtk_label_set_xalign (_tmp2_, 0.0f);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->progress_file_label);
	self->priv->progress_file_label = _tmp3_;
	_tmp4_ = self->priv->progress_file_label;
	gtk_label_set_xalign (_tmp4_, 0.0f);
	_tmp5_ = self->priv->progress_file_label;
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp6_ = self->priv->progress_file_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->progress_label;
	_tmp8_ = row;
	gtk_grid_attach (page, (GtkWidget*) _tmp7_, 0, _tmp8_, 1, 1);
	_tmp9_ = self->priv->progress_file_label;
	_tmp10_ = row;
	gtk_grid_attach (page, (GtkWidget*) _tmp9_, 1, _tmp10_, 1, 1);
	_tmp11_ = row;
	row = _tmp11_ + 1;
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->secondary_label);
	self->priv->secondary_label = _tmp12_;
	_tmp13_ = self->priv->secondary_label;
	gtk_label_set_xalign (_tmp13_, 0.0f);
	_tmp14_ = self->priv->secondary_label;
	g_object_set (_tmp14_, "wrap", TRUE, NULL);
	_tmp15_ = self->priv->secondary_label;
	gtk_label_set_max_width_chars (_tmp15_, 30);
	_tmp16_ = self->priv->secondary_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->secondary_label;
	gtk_label_set_use_markup (_tmp17_, TRUE);
	_tmp18_ = self->priv->secondary_label;
	_tmp19_ = row;
	gtk_grid_attach (page, (GtkWidget*) _tmp18_, 0, _tmp19_, 2, 1);
	_tmp20_ = row;
	row = _tmp20_ + 1;
	_tmp21_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp21_;
	_tmp22_ = self->priv->progress_bar;
	_tmp23_ = row;
	gtk_grid_attach (page, (GtkWidget*) _tmp22_, 0, _tmp23_, 2, 1);
	_tmp24_ = row;
	row = _tmp24_ + 1;
	_tmp25_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->progress_text);
	self->priv->progress_text = _tmp25_;
	_tmp26_ = self->priv->progress_text;
	gtk_text_view_set_editable (_tmp26_, FALSE);
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->progress_scroll);
	self->priv->progress_scroll = _tmp27_;
	_tmp28_ = self->priv->progress_scroll;
	_tmp29_ = self->priv->progress_text;
	g_object_set ((GObject*) _tmp28_, "child", _tmp29_, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, "border-width", 0, "min-content-height", 200, NULL);
	_tmp30_ = _ ("_Details");
	_tmp31_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->progress_expander);
	self->priv->progress_expander = _tmp31_;
	_tmp32_ = self->priv->progress_expander;
	_tmp33_ = self->priv->progress_scroll;
	g_object_set ((GObject*) _tmp32_, "child", _tmp33_, NULL);
	_tmp34_ = self->priv->progress_expander;
	g_object_set ((GtkWidget*) _tmp34_, "expand", TRUE, NULL);
	_tmp35_ = self->priv->progress_expander;
	_tmp36_ = row;
	gtk_grid_attach (page, (GtkWidget*) _tmp35_, 0, _tmp36_, 2, 1);
	_tmp37_ = row;
	row = _tmp37_ + 1;
	gtk_container_set_border_width ((GtkContainer*) page, (guint) 12);
	gtk_widget_set_size_request ((GtkWidget*) page, -1, 200);
	result = (GtkWidget*) page;
	return result;
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_show_detail (AssistantOperation* self, const gchar* detail) {
	GtkEventBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkTextView* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail != NULL);
	_tmp0_ = ((Assistant*) self)->page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, 300, 200);
	_tmp1_ = self->detail_widget;
	gtk_widget_set_no_show_all (_tmp1_, FALSE);
	_tmp2_ = self->detail_widget;
	gtk_widget_show_all (_tmp2_);
	_tmp3_ = self->priv->detail_text_view;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = detail;
	gtk_text_buffer_set_text (_tmp5_, _tmp6_, -1);
}


static void assistant_operation_real_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	g_return_if_fail (_error_ != NULL);
	assistant_operation_set_error_occurred (self, TRUE);
	_tmp0_ = self->summary_label;
	_tmp1_ = _error_;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->summary_label;
	gtk_label_set_selectable (_tmp2_, TRUE);
	_tmp3_ = detail;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = detail;
		assistant_operation_show_detail (self, _tmp4_);
	}
	_tmp5_ = self->priv->_summary_page;
	assistant_go_to_page ((Assistant*) self, _tmp5_);
	assistant_set_header_icon ((Assistant*) self, "dialog-error");
	_tmp6_ = ((Assistant*) self)->page_box;
	gtk_widget_queue_resize ((GtkWidget*) _tmp6_);
}


void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, _error_, detail);
}


static void __lambda12_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void ___lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda12_ ((AssistantOperation*) self);
}


static void __lambda13_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void ___lambda13__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda13_ ((AssistantOperation*) self);
}


static void __lambda14_ (AssistantOperation* self) {
	assistant_operation_check_password_validity (self);
}


static void ___lambda14__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda14_ ((AssistantOperation*) self);
}


GtkWidget* assistant_operation_make_password_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows = 0;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkRadioButton* _tmp10_ = NULL;
	GtkRadioButton* _tmp11_ = NULL;
	GtkRadioButton* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GtkRadioButton* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	GtkRadioButton* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkLabel* _tmp18_ = NULL;
	GtkWidget* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GtkWidget* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	GtkWidget* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	GtkRadioButton* _tmp30_ = NULL;
	GtkWidget* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GtkEntry* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkWidget* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	GtkWidget* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	GtkWidget* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GtkRadioButton* _tmp46_ = NULL;
	GtkWidget* _tmp47_ = NULL;
	GtkRadioButton* _tmp48_ = NULL;
	GtkWidget* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	GtkWidget* _tmp51_ = NULL;
	GtkEntry* _tmp52_ = NULL;
	GtkEntry* _tmp53_ = NULL;
	GtkWidget* _tmp54_ = NULL;
	GtkWidget* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	GtkLabel* _tmp57_ = NULL;
	GtkWidget* _tmp58_ = NULL;
	GtkWidget* _tmp59_ = NULL;
	GtkWidget* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	GtkWidget* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	GtkRadioButton* _tmp64_ = NULL;
	GtkWidget* _tmp65_ = NULL;
	GtkRadioButton* _tmp66_ = NULL;
	GtkWidget* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	GtkWidget* _tmp69_ = NULL;
	GtkEntry* _tmp70_ = NULL;
	GtkWidget* _tmp71_ = NULL;
	GtkWidget* _tmp72_ = NULL;
	GtkWidget* _tmp73_ = NULL;
	GtkWidget* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	GtkCheckButton* _tmp76_ = NULL;
	GtkWidget* _tmp77_ = NULL;
	GtkEntry* _tmp78_ = NULL;
	GtkWidget* _tmp79_ = NULL;
	GtkEntry* _tmp80_ = NULL;
	GtkWidget* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	GtkRadioButton* _tmp83_ = NULL;
	GtkWidget* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	const gchar* _tmp86_ = NULL;
	GtkCheckButton* _tmp87_ = NULL;
	GtkWidget* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	GtkRadioButton* _tmp90_ = NULL;
	GtkWidget* _tmp91_ = NULL;
	gint _tmp92_ = 0;
	GtkWidget* _tmp93_ = NULL;
	GtkCheckButton* _tmp94_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = _ ("_Allow restoring without a password");
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp2_;
	_tmp3_ = w;
	_tmp4_ = rows;
	gtk_grid_attach (page, _tmp3_, 0, _tmp4_, 3, 1);
	_tmp5_ = w;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp6_);
	_tmp7_ = rows;
	rows = _tmp7_ + 1;
	_tmp8_ = w;
	_tmp9_ = _ ("_Password-protect your backup");
	_tmp10_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp8_) : NULL, _tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->encrypt_enabled);
	self->priv->encrypt_enabled = _tmp10_;
	_tmp11_ = self->priv->encrypt_enabled;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp11_, TRUE);
	_tmp12_ = self->priv->encrypt_enabled;
	_tmp13_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp12_, 0, _tmp13_, 3, 1);
	_tmp14_ = self->priv->encrypt_enabled;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp15_);
	_tmp16_ = self->priv->encrypt_enabled;
	g_signal_connect_object ((GtkToggleButton*) _tmp16_, "toggled", (GCallback) ___lambda12__gtk_toggle_button_toggled, self, 0);
	_tmp17_ = rows;
	rows = _tmp17_ + 1;
	_tmp18_ = (GtkLabel*) gtk_label_new ("    ");
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp18_;
	_tmp19_ = w;
	_tmp20_ = rows;
	gtk_grid_attach (page, _tmp19_, 0, _tmp20_, 1, 1);
	_tmp21_ = w;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp22_);
	_tmp23_ = _ ("You will need your password to restore your files. You might want to w" \
"rite it down.");
	_tmp24_ = g_strdup_printf ("<i>%s</i>", _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp26_;
	_g_free0 (_tmp25_);
	_tmp27_ = w;
	g_object_set ((GObject*) _tmp27_, "xalign", 0.0f, "use-markup", TRUE, "max-width-chars", 25, "wrap", TRUE, NULL);
	_tmp28_ = w;
	_tmp29_ = rows;
	gtk_grid_attach (page, _tmp28_, 1, _tmp29_, 2, 1);
	_tmp30_ = self->priv->encrypt_enabled;
	_tmp31_ = w;
	g_object_bind_property_with_closures ((GObject*) _tmp30_, "active", (GObject*) _tmp31_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp32_ = w;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp33_);
	_tmp34_ = rows;
	rows = _tmp34_ + 1;
	_tmp35_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp35_;
	_tmp36_ = w;
	g_object_set ((GObject*) _tmp36_, "input-purpose", GTK_INPUT_PURPOSE_PASSWORD, "hexpand", TRUE, "activates-default", TRUE, NULL);
	_tmp37_ = w;
	g_signal_connect_object ((GtkEditable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_entry_get_type (), GtkEntry), "changed", (GCallback) ___lambda13__gtk_editable_changed, self, 0);
	_tmp38_ = _ ("E_ncryption password");
	_tmp39_ = (GtkLabel*) gtk_label_new (_tmp38_);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp39_;
	_tmp40_ = label;
	_tmp41_ = w;
	g_object_set ((GObject*) _tmp40_, "mnemonic-widget", _tmp41_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	_tmp42_ = label;
	_tmp43_ = rows;
	gtk_grid_attach (page, _tmp42_, 1, _tmp43_, 1, 1);
	_tmp44_ = w;
	_tmp45_ = rows;
	gtk_grid_attach (page, _tmp44_, 2, _tmp45_, 1, 1);
	_tmp46_ = self->priv->encrypt_enabled;
	_tmp47_ = w;
	g_object_bind_property_with_closures ((GObject*) _tmp46_, "active", (GObject*) _tmp47_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp48_ = self->priv->encrypt_enabled;
	_tmp49_ = label;
	g_object_bind_property_with_closures ((GObject*) _tmp48_, "active", (GObject*) _tmp49_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp50_ = rows;
	rows = _tmp50_ + 1;
	_tmp51_ = w;
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->encrypt_entry);
	self->priv->encrypt_entry = _tmp52_;
	_tmp53_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp53_;
	_tmp54_ = w;
	g_object_set ((GObject*) _tmp54_, "input-purpose", GTK_INPUT_PURPOSE_PASSWORD, "hexpand", TRUE, "activates-default", TRUE, NULL);
	_tmp55_ = w;
	g_signal_connect_object ((GtkEditable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_entry_get_type (), GtkEntry), "changed", (GCallback) ___lambda14__gtk_editable_changed, self, 0);
	_tmp56_ = _ ("Confir_m password");
	_tmp57_ = (GtkLabel*) gtk_label_new (_tmp56_);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp57_;
	_tmp58_ = label;
	_tmp59_ = w;
	g_object_set ((GObject*) _tmp58_, "mnemonic-widget", _tmp59_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	_tmp60_ = label;
	_tmp61_ = rows;
	gtk_grid_attach (page, _tmp60_, 1, _tmp61_, 1, 1);
	_tmp62_ = w;
	_tmp63_ = rows;
	gtk_grid_attach (page, _tmp62_, 2, _tmp63_, 1, 1);
	_tmp64_ = self->priv->encrypt_enabled;
	_tmp65_ = w;
	g_object_bind_property_with_closures ((GObject*) _tmp64_, "active", (GObject*) _tmp65_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp66_ = self->priv->encrypt_enabled;
	_tmp67_ = label;
	g_object_bind_property_with_closures ((GObject*) _tmp66_, "active", (GObject*) _tmp67_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp68_ = rows;
	rows = _tmp68_ + 1;
	_tmp69_ = w;
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->encrypt_confirm_entry);
	self->priv->encrypt_confirm_entry = _tmp70_;
	_tmp71_ = w;
	_tmp72_ = _g_object_ref0 (_tmp71_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp72_);
	_tmp73_ = label;
	_tmp74_ = _g_object_ref0 (_tmp73_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp74_);
	_tmp75_ = _ ("_Show password");
	_tmp76_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp76_;
	_tmp77_ = w;
	_tmp78_ = self->priv->encrypt_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp77_, "active", (GObject*) _tmp78_, "visibility", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp79_ = w;
	_tmp80_ = self->priv->encrypt_confirm_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp79_, "active", (GObject*) _tmp80_, "visibility", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp81_ = w;
	_tmp82_ = rows;
	gtk_grid_attach (page, _tmp81_, 2, _tmp82_, 1, 1);
	_tmp83_ = self->priv->encrypt_enabled;
	_tmp84_ = w;
	g_object_bind_property_with_closures ((GObject*) _tmp83_, "active", (GObject*) _tmp84_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp85_ = rows;
	rows = _tmp85_ + 1;
	_tmp86_ = _ ("_Remember password");
	_tmp87_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp86_);
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp87_;
	_tmp88_ = w;
	_tmp89_ = rows;
	gtk_grid_attach (page, _tmp88_, 2, _tmp89_, 1, 1);
	_tmp90_ = self->priv->encrypt_enabled;
	_tmp91_ = w;
	g_object_bind_property_with_closures ((GObject*) _tmp90_, "active", (GObject*) _tmp91_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp92_ = rows;
	rows = _tmp92_ + 1;
	_tmp93_ = w;
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->encrypt_remember);
	self->priv->encrypt_remember = _tmp94_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


static void __lambda15_ (AssistantOperation* self, GtkEditable* entry) {
	g_return_if_fail (entry != NULL);
	assistant_operation_check_nag_validity (self);
}


static void ___lambda15__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda15_ ((AssistantOperation*) self, _sender);
}


static void __lambda16_ (AssistantOperation* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	deja_dup_update_nag_time (!_tmp1_);
}


static void ___lambda16__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda16_ ((AssistantOperation*) self, _sender);
}


GtkWidget* assistant_operation_make_nag_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows = 0;
	GtkWidget* w = NULL;
	GtkWidget* label = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkWidget* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkEntry* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GtkWidget* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkWidget* _tmp17_ = NULL;
	GtkEntry* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	const gchar* _tmp20_ = NULL;
	GtkCheckButton* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	GtkEntry* _tmp23_ = NULL;
	GtkWidget* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	GtkCheckButton* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	GtkWidget* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = _ ("In order to check that you will be able to retrieve your files in the " \
"case of an emergency, please enter your encryption password again to p" \
"erform a brief restore test.");
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp2_;
	_tmp3_ = w;
	g_object_set ((GObject*) _tmp3_, "xalign", 0.0f, "max-width-chars", 25, "wrap", TRUE, NULL);
	_tmp4_ = w;
	_tmp5_ = rows;
	gtk_grid_attach (page, _tmp4_, 0, _tmp5_, 3, 1);
	_tmp6_ = w;
	gtk_widget_hide (_tmp6_);
	_tmp7_ = rows;
	rows = _tmp7_ + 1;
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp8_;
	_tmp9_ = w;
	g_object_set ((GObject*) _tmp9_, "input-purpose", GTK_INPUT_PURPOSE_PASSWORD, "hexpand", TRUE, "activates-default", TRUE, NULL);
	_tmp10_ = w;
	g_signal_connect_object ((GtkEditable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_entry_get_type (), GtkEntry), "changed", (GCallback) ___lambda15__gtk_editable_changed, self, 0);
	_tmp11_ = _ ("E_ncryption password");
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp12_;
	_tmp13_ = w;
	g_object_set ((GObject*) label, "mnemonic-widget", _tmp13_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	_tmp14_ = rows;
	gtk_grid_attach (page, label, 1, _tmp14_, 1, 1);
	_tmp15_ = w;
	_tmp16_ = rows;
	gtk_grid_attach (page, _tmp15_, 2, _tmp16_, 1, 1);
	_tmp17_ = w;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->nag_entry);
	self->priv->nag_entry = _tmp18_;
	_tmp19_ = rows;
	rows = _tmp19_ + 1;
	_tmp20_ = _ ("_Show password");
	_tmp21_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp21_;
	_tmp22_ = w;
	_tmp23_ = self->priv->nag_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp22_, "active", (GObject*) _tmp23_, "visibility", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp24_ = w;
	_tmp25_ = rows;
	gtk_grid_attach (page, _tmp24_, 2, _tmp25_, 1, 1);
	_tmp26_ = rows;
	rows = _tmp26_ + 1;
	_tmp27_ = _ ("Test every two _months");
	_tmp28_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp28_;
	_tmp29_ = w;
	_tmp30_ = rows;
	gtk_grid_attach (page, _tmp29_, 0, _tmp30_, 3, 1);
	_tmp31_ = w;
	gtk_widget_hide (_tmp31_);
	_tmp32_ = w;
	gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_check_button_get_type (), GtkCheckButton), TRUE);
	_tmp33_ = w;
	gtk_widget_set_vexpand (_tmp33_, TRUE);
	_tmp34_ = w;
	gtk_widget_set_valign (_tmp34_, GTK_ALIGN_END);
	_tmp35_ = w;
	g_signal_connect_object ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_check_button_get_type (), GtkCheckButton), "toggled", (GCallback) ___lambda16__gtk_toggle_button_toggled, self, 0);
	_tmp36_ = rows;
	rows = _tmp36_ + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	return result;
}


GtkWidget* assistant_operation_make_question_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows = 0;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkLabel* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	g_object_set ((GObject*) label, "use-underline", TRUE, "wrap", TRUE, "max-width-chars", 25, "hexpand", TRUE, "xalign", 0.0f, NULL);
	_tmp2_ = rows;
	gtk_grid_attach (page, (GtkWidget*) label, 0, _tmp2_, 1, 1);
	_tmp3_ = rows;
	rows = _tmp3_ + 1;
	_tmp4_ = _g_object_ref0 (label);
	_g_object_unref0 (self->priv->question_label);
	self->priv->question_label = _tmp4_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	return result;
}


static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkTextView* _tmp4_ = NULL;
	GtkTextView* _tmp5_ = NULL;
	GtkTextView* _tmp6_ = NULL;
	GtkTextView* _tmp7_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkTextView* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkBox* page = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->summary_label);
	self->summary_label = _tmp0_;
	_tmp1_ = self->summary_label;
	g_object_set ((GObject*) _tmp1_, "xalign", 0.0f, NULL);
	_tmp2_ = self->summary_label;
	g_object_set (_tmp2_, "wrap", TRUE, NULL);
	_tmp3_ = self->summary_label;
	gtk_label_set_max_width_chars (_tmp3_, 25);
	_tmp4_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->detail_text_view);
	self->priv->detail_text_view = _tmp4_;
	_tmp5_ = self->priv->detail_text_view;
	gtk_text_view_set_editable (_tmp5_, FALSE);
	_tmp6_ = self->priv->detail_text_view;
	gtk_text_view_set_wrap_mode (_tmp6_, GTK_WRAP_WORD);
	_tmp7_ = self->priv->detail_text_view;
	g_object_set ((GtkWidget*) _tmp7_, "height-request", 150, NULL);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp8_);
	scroll = _tmp8_;
	_tmp9_ = self->priv->detail_text_view;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp9_);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	_tmp10_ = _g_object_ref0 ((GtkWidget*) scroll);
	_g_object_unref0 (self->detail_widget);
	self->detail_widget = _tmp10_;
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp11_);
	page = _tmp11_;
	_tmp12_ = self->summary_label;
	_tmp13_ = self->detail_widget;
	g_object_set ((GObject*) page, "child", _tmp12_, "child", _tmp13_, "border-width", 12, NULL);
	_tmp14_ = self->summary_label;
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) _tmp14_, "expand", FALSE, NULL);
	_tmp15_ = self->detail_widget;
	gtk_container_child_set ((GtkContainer*) page, _tmp15_, "expand", TRUE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_confirm_page (self);
	page = _tmp0_;
	_tmp1_ = page;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp2_ = page;
	assistant_append_page ((Assistant*) self, _tmp2_, ASSISTANT_TYPE_SUMMARY);
	_tmp3_ = page;
	_tmp4_ = _ ("Summary");
	assistant_set_page_title ((Assistant*) self, _tmp3_, _tmp4_);
	_tmp5_ = page;
	assistant_operation_set_confirm_page (self, _tmp5_);
	_g_object_unref0 (page);
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_progress_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_password_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_password_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_password_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_nag_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_nag_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_CHECK);
	_tmp1_ = _ ("Restore Test");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	assistant_operation_set_nag_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_question_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_question_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_question_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_summary_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_FINISH);
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_real_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	StatusIcon* _tmp0_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (op != NULL);
	_tmp0_ = self->status_icon;
	if (_tmp0_ != NULL) {
		StatusIcon* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		_tmp1_ = self->status_icon;
		_tmp2_ = success;
		_tmp3_ = cancelled;
		_tmp4_ = detail;
		status_icon_done (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		_g_object_unref0 (self->status_icon);
		self->status_icon = NULL;
	}
	_g_object_unref0 (self->op);
	self->op = NULL;
	_tmp5_ = cancelled;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = success;
		if (_tmp6_) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close (self);
		}
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = success;
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			GtkWidget* _tmp21_ = NULL;
			self->succeeded = TRUE;
			_tmp8_ = detail;
			if (_tmp8_ != NULL) {
				gchar** halves = NULL;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint halves_length1 = 0;
				gint _halves_size_ = 0;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				_tmp9_ = detail;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\n\n", 2);
				halves = _tmp11_;
				halves_length1 = _vala_array_length (_tmp10_);
				_halves_size_ = halves_length1;
				_tmp12_ = halves;
				_tmp12__length1 = halves_length1;
				if (_tmp12__length1 == 1) {
					GtkLabel* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = self->summary_label;
					_tmp14_ = detail;
					gtk_label_set_label (_tmp13_, _tmp14_);
				} else {
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp15_ = halves;
					_tmp15__length1 = halves_length1;
					if (_tmp15__length1 == 2) {
						GtkLabel* _tmp16_ = NULL;
						gchar** _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						const gchar* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						const gchar* _tmp20_ = NULL;
						_tmp16_ = self->summary_label;
						_tmp17_ = halves;
						_tmp17__length1 = halves_length1;
						_tmp18_ = _tmp17_[0];
						gtk_label_set_label (_tmp16_, _tmp18_);
						_tmp19_ = halves;
						_tmp19__length1 = halves_length1;
						_tmp20_ = _tmp19_[1];
						assistant_operation_show_detail (self, _tmp20_);
					}
				}
				halves = (_vala_array_free (halves, halves_length1, (GDestroyNotify) g_free), NULL);
			}
			_tmp21_ = self->priv->_summary_page;
			assistant_go_to_page ((Assistant*) self, _tmp21_);
		} else {
			assistant_operation_force_visible (self, FALSE);
		}
	}
}


void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->apply_finished (self, op, success, cancelled, detail);
}


static void ___lambda18_ (AssistantOperation* self, StatusIcon* s, gboolean user_click) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (s != NULL);
	_tmp0_ = user_click;
	assistant_operation_force_visible (self, _tmp0_);
}


static void ____lambda18__status_icon_show_window (StatusIcon* _sender, gboolean user_click, gpointer self) {
	___lambda18_ ((AssistantOperation*) self, _sender, user_click);
}


static void ___lambda19_ (AssistantOperation* self, StatusIcon* s) {
	g_return_if_fail (s != NULL);
	assistant_operation_hide_everything (self);
}


static void ____lambda19__status_icon_hide_all (StatusIcon* _sender, gpointer self) {
	___lambda19_ ((AssistantOperation*) self, _sender);
}


void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o) {
	StatusIcon* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->status_icon;
	if (_tmp0_ == NULL) {
		DejaDupOperation* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		StatusIcon* _tmp3_ = NULL;
		StatusIcon* _tmp4_ = NULL;
		StatusIcon* _tmp5_ = NULL;
		_tmp1_ = o;
		_tmp2_ = self->priv->_automatic;
		_tmp3_ = status_icon_create ((GtkWindow*) self, _tmp1_, _tmp2_);
		_g_object_unref0 (self->status_icon);
		self->status_icon = _tmp3_;
		_tmp4_ = self->status_icon;
		g_signal_connect_object (_tmp4_, "show-window", (GCallback) ____lambda18__status_icon_show_window, self, 0);
		_tmp5_ = self->status_icon;
		g_signal_connect_object (_tmp5_, "hide-all", (GCallback) ____lambda19__status_icon_hide_all, self, 0);
	}
}


static void assistant_operation_do_apply_data_free (gpointer _data) {
	AssistantOperationDoApplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantOperationDoApplyData, _data_);
}


void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantOperationDoApplyData* _data_;
	AssistantOperation* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AssistantOperationDoApplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_operation_do_apply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_operation_do_apply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_operation_do_apply_co (_data_);
}


void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_) {
	AssistantOperationDoApplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self) {
	assistant_operation_apply_finished ((AssistantOperation*) self, _sender, success, cancelled, detail);
}


static void __lambda20_ (AssistantOperation* self, DejaDupOperation* o, const gchar* e, const gchar* d) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	_tmp1_ = d;
	assistant_operation_show_error (self, _tmp0_, _tmp1_);
}


static void ___lambda20__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	__lambda20_ ((AssistantOperation*) self, _sender, errstr, detail);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase ((AssistantOperation*) self);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const gchar* action, gpointer self) {
	assistant_operation_set_progress_label ((AssistantOperation*) self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self) {
	assistant_operation_set_progress_label_file ((AssistantOperation*) self, _sender, file, actual);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	assistant_operation_show_progress ((AssistantOperation*) self, _sender, percent);
}


static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self) {
	assistant_operation_show_question ((AssistantOperation*) self, _sender, title, msg);
}


static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self) {
	assistant_operation_pause_op ((AssistantOperation*) self, _sender, header, msg);
}


static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = assistant_operation_create_op (_data_->self);
	_g_object_unref0 (_data_->self->op);
	_data_->self->op = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->op;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Failed with an unknown error.");
		assistant_operation_show_error (_data_->self, _data_->_tmp2_, NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp3_, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp4_, "raise-error", (GCallback) ___lambda20__deja_dup_operation_raise_error, _data_->self, 0);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp5_, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, _data_->self, 0);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp6_, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, _data_->self, 0);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp7_, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, _data_->self, 0);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp8_, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, _data_->self, 0);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp9_, "question", (GCallback) _assistant_operation_show_question_deja_dup_operation_question, _data_->self, 0);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->op;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = deja_dup_operation_get_backend (_data_->_tmp10_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = mount_operation_assistant_new (_data_->self);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	deja_dup_backend_set_mount_op (_data_->_tmp12_, (GMountOperation*) _data_->_tmp14_);
	_g_object_unref0 (_data_->_tmp14_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->self->op;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = deja_dup_operation_get_backend (_data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	g_signal_connect_object (_data_->_tmp17_, "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, _data_->self, 0);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->self->op;
	assistant_operation_ensure_status_icon (_data_->self, _data_->_tmp18_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->self->op;
	deja_dup_operation_start (_data_->_tmp19_, TRUE, NULL, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_operation_pulse ((AssistantOperation*) self);
	return result;
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	guint _tmp0_ = 0U;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->timeout_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->timeout_id;
		g_source_remove (_tmp1_);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp2_ = page;
	_tmp3_ = self->priv->_confirm_page;
	if (_tmp2_ == _tmp3_) {
		DejaDupOperation* _tmp4_ = NULL;
		_tmp4_ = self->op;
		if (_tmp4_ != NULL) {
			DejaDupOperation* _tmp5_ = NULL;
			guint _tmp6_ = 0U;
			DejaDupOperation* _tmp7_ = NULL;
			_tmp5_ = self->op;
			g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			_tmp7_ = self->op;
			deja_dup_operation_cancel (_tmp7_);
			_g_object_unref0 (self->op);
			self->op = NULL;
		}
	} else {
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* _tmp9_ = NULL;
		_tmp8_ = page;
		_tmp9_ = self->priv->_progress_page;
		if (_tmp8_ == _tmp9_) {
			GtkProgressBar* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			gboolean _tmp12_ = FALSE;
			DejaDupOperation* _tmp13_ = NULL;
			_tmp10_ = self->priv->progress_bar;
			gtk_progress_bar_set_fraction (_tmp10_, (gdouble) 0);
			_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->timeout_id = _tmp11_;
			_tmp13_ = self->op;
			if (_tmp13_ != NULL) {
				DejaDupOperation* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				_tmp14_ = self->op;
				_tmp15_ = deja_dup_operation_get_needs_password (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				assistant_operation_provide_password (self, NULL, NULL);
			} else {
				DejaDupOperation* _tmp17_ = NULL;
				_tmp17_ = self->op;
				if (_tmp17_ == NULL) {
					assistant_operation_do_apply (self, NULL, NULL);
				}
			}
		} else {
			gboolean _tmp18_ = FALSE;
			GtkWidget* _tmp19_ = NULL;
			GtkWidget* _tmp20_ = NULL;
			_tmp19_ = page;
			_tmp20_ = self->priv->_password_page;
			if (_tmp19_ == _tmp20_) {
				_tmp18_ = TRUE;
			} else {
				GtkWidget* _tmp21_ = NULL;
				GtkWidget* _tmp22_ = NULL;
				_tmp21_ = page;
				_tmp22_ = self->priv->_nag_page;
				_tmp18_ = _tmp21_ == _tmp22_;
			}
			if (_tmp18_) {
				assistant_set_header_icon ((Assistant*) self, "dialog-password");
			}
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


void assistant_operation_hide_everything (AssistantOperation* self) {
	StatusIcon* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->status_icon;
	if (_tmp0_ != NULL) {
		StatusIcon* _tmp1_ = NULL;
		_tmp1_ = self->status_icon;
		status_icon_done (_tmp1_, FALSE, TRUE, NULL);
		_g_object_unref0 (self->status_icon);
		self->status_icon = NULL;
	}
}


static void assistant_operation_real_do_cancel (AssistantOperation* self) {
	DejaDupOperation* _tmp0_ = NULL;
	assistant_operation_hide_everything (self);
	_tmp0_ = self->op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_ = NULL;
		_tmp1_ = self->op;
		deja_dup_operation_cancel (_tmp1_);
	} else {
		assistant_operation_do_close (self);
	}
}


void assistant_operation_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->do_cancel (self);
}


static gboolean assistant_operation_do_minimize_to_tray (AssistantOperation* self, GdkEventAny* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = assistant_is_interrupted ((Assistant*) self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		DejaDupOperation* _tmp2_ = NULL;
		_tmp2_ = self->op;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		assistant_operation_do_cancel (self);
	} else {
		assistant_hide_for_now ((Assistant*) self);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	guint _tmp0_ = 0U;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->timeout_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->timeout_id;
		g_source_remove (_tmp1_);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp2_ = self->succeeded;
	g_signal_emit_by_name (self, "closing", _tmp2_);
	deja_dup_destroy_widget ((GtkWidget*) self);
}


void assistant_operation_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click) {
	guint32 _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_get_current_event_time ();
	_tmp1_ = user_click;
	assistant_operation_show_to_user (self, (GtkWindow*) self, (guint) _tmp0_, _tmp1_);
}


static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = assistant_operation_user_focused ((AssistantOperation*) self, _sender, event);
	return result;
}


static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (win != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = win;
	gtk_window_set_urgency_hint (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), FALSE);
	_tmp1_ = win;
	g_signal_parse_name ("focus-in-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self);
	result = FALSE;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AssistantOperation* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->win);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean ____lambda17_ (Block2Data* _data2_) {
	AssistantOperation* self;
	gboolean result = FALSE;
	GtkWindow* _tmp0_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->win;
	g_signal_connect_object ((GtkWidget*) _tmp0_, "focus-in-event", (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self, 0);
	result = FALSE;
	return result;
}


static gboolean _____lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda17_ (self);
	return result;
}


static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click) {
	Block2Data* _data2_;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = win;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->win);
	_data2_->win = _tmp1_;
	_tmp2_ = _data2_->win;
	_tmp3_ = user_click;
	gtk_window_set_focus_on_map (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->saved_pos;
	if (_tmp4_) {
		GtkWindow* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = _data2_->win;
		_tmp6_ = self->priv->saved_x;
		_tmp7_ = self->priv->saved_y;
		gtk_window_move (_tmp5_, _tmp6_, _tmp7_);
	}
	_tmp8_ = user_click;
	if (_tmp8_) {
		GtkWindow* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp9_ = _data2_->win;
		_tmp10_ = time;
		gtk_window_present_with_time (_tmp9_, (guint32) _tmp10_);
	} else {
		gboolean _tmp11_ = FALSE;
		GtkWindow* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = _data2_->win;
		g_object_get (_tmp12_, "is-active", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		if (!_tmp14_) {
			_tmp11_ = TRUE;
		} else {
			GtkWindow* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = _data2_->win;
			_tmp16_ = gtk_widget_get_visible ((GtkWidget*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = !_tmp17_;
		}
		if (_tmp11_) {
			GtkWindow* _tmp18_ = NULL;
			GtkWindow* _tmp19_ = NULL;
			_tmp18_ = _data2_->win;
			gtk_window_set_urgency_hint (_tmp18_, TRUE);
			_tmp19_ = _data2_->win;
			gtk_widget_show ((GtkWidget*) _tmp19_);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda17__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		}
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void assistant_operation_lookup_keyring_data_free (gpointer _data) {
	AssistantOperationLookupKeyringData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantOperationLookupKeyringData, _data_);
}


static void assistant_operation_lookup_keyring (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantOperationLookupKeyringData* _data_;
	AssistantOperation* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AssistantOperationLookupKeyringData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_operation_lookup_keyring);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_operation_lookup_keyring_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_operation_lookup_keyring_co (_data_);
}


static gchar* assistant_operation_lookup_keyring_finish (AssistantOperation* self, GAsyncResult* _res_) {
	gchar* result;
	AssistantOperationLookupKeyringData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void assistant_operation_lookup_keyring_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AssistantOperationLookupKeyringData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_operation_lookup_keyring_co (_data_);
}


static gboolean assistant_operation_lookup_keyring_co (AssistantOperationLookupKeyringData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = deja_dup_get_passphrase_schema ();
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_state_ = 1;
		secret_password_lookup (_data_->_tmp2_, NULL, assistant_operation_lookup_keyring_ready, _data_, "owner", PACKAGE, "type", "passphrase", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_;
		_secret_schema_unref0 (_data_->_tmp2_);
		_data_->_tmp0_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp5_;
		_g_free0 (_data_->_tmp0_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("AssistantOperation.vala:733: %s\n", _data_->_tmp7_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally3:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
	g_clear_error (&_data_->_inner_error_);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AssistantOperation* self;
		self = _data3_->self;
		_g_main_loop_unref0 (_data3_->loop);
		_g_free0 (_data3_->str);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void ___lambda21_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	AssistantOperation* self;
	GAsyncResult* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = assistant_operation_lookup_keyring_finish (self, _tmp0_);
	_g_free0 (_data3_->str);
	_data3_->str = _tmp1_;
	_tmp2_ = _data3_->loop;
	g_main_loop_quit (_tmp2_);
}


static void ____lambda21__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda21_ (self, source_object, res);
	block3_data_unref (self);
}


void assistant_operation_get_passphrase (AssistantOperation* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->searched_for_passphrase;
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = deja_dup_in_testing_mode ();
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		DejaDupOperation* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->op;
		_tmp5_ = deja_dup_operation_get_use_cached_password (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block3Data* _data3_;
		GMainLoop* _tmp7_ = NULL;
		GMainLoop* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->self = g_object_ref (self);
		self->priv->searched_for_passphrase = TRUE;
		_data3_->str = NULL;
		_tmp7_ = g_main_loop_new (NULL, FALSE);
		_data3_->loop = _tmp7_;
		assistant_operation_lookup_keyring (self, ____lambda21__gasync_ready_callback, block3_data_ref (_data3_));
		_tmp8_ = _data3_->loop;
		g_main_loop_run (_tmp8_);
		_tmp9_ = _data3_->str;
		if (_tmp9_ != NULL) {
			DejaDupOperation* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = self->op;
			_tmp11_ = _data3_->str;
			deja_dup_operation_set_passphrase (_tmp10_, _tmp11_);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return;
		}
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	assistant_operation_ask_passphrase (self, FALSE);
}


static void assistant_operation_check_password_validity (AssistantOperation* self) {
	GtkRadioButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* passphrase = NULL;
	GtkEntry* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkEntry* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->encrypt_enabled;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		assistant_allow_forward ((Assistant*) self, TRUE);
		return;
	}
	_tmp3_ = self->priv->encrypt_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	passphrase = _tmp5_;
	_tmp6_ = passphrase;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		assistant_allow_forward ((Assistant*) self, FALSE);
		_g_free0 (passphrase);
		return;
	}
	_tmp7_ = self->priv->encrypt_confirm_entry;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gchar* passphrase2 = NULL;
		GtkEntry* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean valid = FALSE;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp10_ = self->priv->encrypt_confirm_entry;
		_tmp11_ = gtk_entry_get_text (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		passphrase2 = _tmp12_;
		_tmp13_ = passphrase;
		_tmp14_ = passphrase2;
		valid = g_strcmp0 (_tmp13_, _tmp14_) == 0;
		_tmp15_ = valid;
		assistant_allow_forward ((Assistant*) self, _tmp15_);
		_g_free0 (passphrase2);
	} else {
		assistant_allow_forward ((Assistant*) self, TRUE);
	}
	_g_free0 (passphrase);
}


static void assistant_operation_configure_password_page (AssistantOperation* self, gboolean first) {
	gboolean _tmp0_ = FALSE;
	GList* _tmp5_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = first;
	if (_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->_password_page;
		_tmp2_ = _ ("Require Password?");
		assistant_set_page_title ((Assistant*) self, _tmp1_, _tmp2_);
	} else {
		GtkWidget* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->_password_page;
		_tmp4_ = _ ("Encryption Password Needed");
		assistant_set_page_title ((Assistant*) self, _tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->first_password_widgets;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp5_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp6_ = NULL;
			GtkWidget* w = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp6_;
			{
				GtkWidget* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp7_ = w;
				_tmp8_ = first;
				gtk_widget_set_visible (_tmp7_, _tmp8_);
				_g_object_unref0 (w);
			}
		}
	}
	assistant_operation_check_password_validity (self);
	_tmp9_ = self->priv->encrypt_entry;
	gtk_editable_select_region ((GtkEditable*) _tmp9_, 0, -1);
	_tmp10_ = self->priv->encrypt_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
}


static void assistant_operation_check_nag_validity (AssistantOperation* self) {
	gchar* passphrase = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nag_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	passphrase = _tmp2_;
	_tmp3_ = passphrase;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		assistant_allow_forward ((Assistant*) self, FALSE);
	} else {
		assistant_allow_forward ((Assistant*) self, TRUE);
	}
	_g_free0 (passphrase);
}


static void assistant_operation_configure_nag_page (AssistantOperation* self) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	assistant_operation_check_nag_validity (self);
	_tmp0_ = self->priv->nag_entry;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->nag_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static gboolean __lambda22_ (AssistantOperation* self) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_ = NULL;
	_tmp0_ = self->priv->password_ask_loop;
	g_main_loop_quit (_tmp0_);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = NULL;
	result = FALSE;
	return result;
}


static gboolean ___lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda22_ ((AssistantOperation*) self);
	return result;
}


static void _assistant_operation_stop_password_loop_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_operation_stop_password_loop ((AssistantOperation*) self, _sender, response);
}


static void assistant_operation_stop_password_loop (AssistantOperation* self, Assistant* dlg, gint resp) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda22__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_parse_name ("response", TYPE_ASSISTANT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((Assistant*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_password_loop_assistant_response, self);
}


void assistant_operation_ask_passphrase (AssistantOperation* self, gboolean first) {
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperation* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GMainLoop* _tmp7_ = NULL;
	GMainLoop* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->op;
	deja_dup_operation_set_needs_password (_tmp0_, TRUE);
	_tmp1_ = self->op;
	_tmp2_ = deja_dup_operation_get_use_cached_password (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkWidget* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->_password_page;
		assistant_interrupt ((Assistant*) self, _tmp4_, TRUE);
		_tmp5_ = first;
		assistant_operation_configure_password_page (self, _tmp5_);
	} else {
		GtkWidget* _tmp6_ = NULL;
		_tmp6_ = self->priv->_nag_page;
		assistant_interrupt ((Assistant*) self, _tmp6_, TRUE);
		assistant_operation_configure_nag_page (self);
		self->nagged = TRUE;
	}
	assistant_operation_force_visible (self, FALSE);
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = _tmp7_;
	g_signal_connect_object ((Assistant*) self, "response", (GCallback) _assistant_operation_stop_password_loop_assistant_response, self, 0);
	_tmp8_ = self->priv->password_ask_loop;
	g_main_loop_run (_tmp8_);
}


static void assistant_operation_provide_password_data_free (gpointer _data) {
	AssistantOperationProvidePasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantOperationProvidePasswordData, _data_);
}


void assistant_operation_provide_password (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantOperationProvidePasswordData* _data_;
	AssistantOperation* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AssistantOperationProvidePasswordData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_operation_provide_password);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_operation_provide_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_operation_provide_password_co (_data_);
}


void assistant_operation_provide_password_finish (AssistantOperation* self, GAsyncResult* _res_) {
	AssistantOperationProvidePasswordData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void assistant_operation_provide_password_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AssistantOperationProvidePasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_operation_provide_password_co (_data_);
}


static gboolean assistant_operation_provide_password_co (AssistantOperationProvidePasswordData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_strdup ("");
	_data_->passphrase = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->op;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = deja_dup_operation_get_use_cached_password (_data_->_tmp1_);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->encrypt_enabled;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data_->_tmp4_);
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = _data_->_tmp5_;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->self->priv->encrypt_entry;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = gtk_entry_get_text (_data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = string_strip (_data_->_tmp8_);
			_g_free0 (_data_->passphrase);
			_data_->passphrase = _data_->_tmp9_;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->passphrase;
			if (g_strcmp0 (_data_->_tmp10_, "") == 0) {
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->self->priv->encrypt_entry;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = gtk_entry_get_text (_data_->_tmp11_);
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
				_g_free0 (_data_->passphrase);
				_data_->passphrase = _data_->_tmp13_;
			}
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->passphrase;
		if (g_strcmp0 (_data_->_tmp14_, "") != 0) {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->self->priv->encrypt_remember;
			_data_->_tmp16_ = FALSE;
			_data_->_tmp16_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data_->_tmp15_);
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = _data_->_tmp16_;
			if (_data_->_tmp17_) {
				{
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = deja_dup_get_passphrase_schema ();
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = NULL;
					_data_->_tmp20_ = _ ("Backup encryption password");
					_data_->_tmp21_ = NULL;
					_data_->_tmp21_ = _data_->passphrase;
					_data_->_state_ = 1;
					secret_password_store (_data_->_tmp19_, SECRET_COLLECTION_DEFAULT, _data_->_tmp20_, _data_->_tmp21_, NULL, assistant_operation_provide_password_ready, _data_, "owner", PACKAGE, "type", "passphrase", NULL);
					return FALSE;
					_state_1:
					secret_password_store_finish (_data_->_res_, &_data_->_inner_error_);
					_secret_schema_unref0 (_data_->_tmp19_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp22_ = NULL;
					_data_->_tmp22_ = _data_->e;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = _data_->_tmp22_->message;
					g_warning ("AssistantOperation.vala:873: %s\n", _data_->_tmp23_);
					_g_error_free0 (_data_->e);
				}
				__finally4:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_free0 (_data_->passphrase);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
		}
	} else {
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->self->priv->nag_entry;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = gtk_entry_get_text (_data_->_tmp24_);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = string_strip (_data_->_tmp25_);
		_g_free0 (_data_->passphrase);
		_data_->passphrase = _data_->_tmp26_;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->passphrase;
		if (g_strcmp0 (_data_->_tmp27_, "") == 0) {
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->self->priv->nag_entry;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = gtk_entry_get_text (_data_->_tmp28_);
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_strdup (_data_->_tmp29_);
			_g_free0 (_data_->passphrase);
			_data_->passphrase = _data_->_tmp30_;
		}
	}
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->self->op;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->passphrase;
	deja_dup_operation_set_passphrase (_data_->_tmp31_, _data_->_tmp32_);
	_g_free0 (_data_->passphrase);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _assistant_operation_stop_question_assistant_response (Assistant* _sender, gint response, gpointer self) {
	assistant_operation_stop_question ((AssistantOperation*) self, _sender, response);
}


static void assistant_operation_stop_question (AssistantOperation* self, Assistant* dlg, gint resp) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	gtk_main_quit ();
	g_signal_parse_name ("response", TYPE_ASSISTANT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((Assistant*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_question_assistant_response, self);
}


static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const gchar* title, const gchar* message) {
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_question_page;
	_tmp1_ = title;
	assistant_set_page_title ((Assistant*) self, _tmp0_, _tmp1_);
	_tmp2_ = self->priv->question_label;
	_tmp3_ = message;
	gtk_label_set_label (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->_question_page;
	assistant_interrupt ((Assistant*) self, _tmp4_, TRUE);
	assistant_operation_force_visible (self, FALSE);
	g_signal_connect_object ((Assistant*) self, "response", (GCallback) _assistant_operation_stop_question_assistant_response, self, 0);
	gtk_main ();
}


void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (back != NULL);
	_tmp0_ = header;
	if (_tmp0_ == NULL) {
		assistant_go_forward ((Assistant*) self);
	} else {
		GtkWidget* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		_tmp1_ = self->priv->_question_page;
		_tmp2_ = header;
		assistant_set_page_title ((Assistant*) self, _tmp1_, _tmp2_);
		_tmp3_ = self->priv->question_label;
		_tmp4_ = msg;
		gtk_label_set_label (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->_question_page;
		assistant_interrupt ((Assistant*) self, _tmp5_, FALSE);
		assistant_operation_force_visible (self, FALSE);
	}
}


AssistantOperation* assistant_operation_construct (GType object_type) {
	AssistantOperation * self = NULL;
	self = (AssistantOperation*) assistant_construct (object_type);
	return self;
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_confirm_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_confirm_page);
	self->priv->_confirm_page = _tmp1_;
	g_object_notify ((GObject *) self, "confirm-page");
}


gboolean assistant_operation_get_automatic (AssistantOperation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_automatic = _tmp0_;
	g_object_notify ((GObject *) self, "automatic");
}


GtkWidget* assistant_operation_get_password_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_password_page);
	self->priv->_password_page = _tmp1_;
	g_object_notify ((GObject *) self, "password-page");
}


GtkWidget* assistant_operation_get_nag_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nag_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_nag_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_nag_page);
	self->priv->_nag_page = _tmp1_;
	g_object_notify ((GObject *) self, "nag-page");
}


GtkWidget* assistant_operation_get_question_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_question_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_question_page);
	self->priv->_question_page = _tmp1_;
	g_object_notify ((GObject *) self, "question-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_progress_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_progress_page);
	self->priv->_progress_page = _tmp1_;
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary_page;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_summary_page);
	self->priv->_summary_page = _tmp1_;
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_op_icon;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_op_icon);
	self->priv->_op_icon = _tmp1_;
	g_object_notify ((GObject *) self, "op-icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_error_occurred;
	result = _tmp0_;
	return result;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_error_occurred = _tmp0_;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self) {
	assistant_operation_do_cancel ((AssistantOperation*) self);
}


static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self) {
	assistant_operation_do_close ((AssistantOperation*) self);
}


static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare ((AssistantOperation*) self, _sender, page);
}


static gboolean _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = assistant_operation_do_minimize_to_tray ((AssistantOperation*) self, event);
	return result;
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	gtk_window_set_icon_name ((GtkWindow*) self, "deja-dup");
	_tmp0_ = assistant_operation_make_op_icon (self);
	_tmp1_ = _tmp0_;
	assistant_operation_set_op_icon (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = ((Assistant*) self)->header_icon;
	_tmp3_ = self->priv->_op_icon;
	g_object_set (_tmp2_, "pixbuf", _tmp3_, NULL);
	assistant_operation_add_custom_config_pages (self);
	assistant_operation_add_setup_pages (self);
	assistant_operation_add_confirm_page (self);
	assistant_operation_add_password_page (self);
	assistant_operation_add_nag_page (self);
	assistant_operation_add_question_page (self);
	assistant_operation_add_progress_page (self);
	assistant_operation_add_summary_page (self);
	g_signal_connect_object ((Assistant*) self, "canceled", (GCallback) _assistant_operation_do_cancel_assistant_canceled, self, 0);
	g_signal_connect_object ((Assistant*) self, "closed", (GCallback) _assistant_operation_do_close_assistant_closed, self, 0);
	g_signal_connect_object ((Assistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _assistant_operation_do_minimize_to_tray_gtk_widget_delete_event, self, 0);
	return obj;
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	((AssistantOperationClass *) klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	((AssistantOperationClass *) klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	((AssistantOperationClass *) klass)->add_custom_config_pages = assistant_operation_real_add_custom_config_pages;
	((AssistantOperationClass *) klass)->create_op = assistant_operation_real_create_op;
	((AssistantOperationClass *) klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	((AssistantOperationClass *) klass)->make_progress_page = assistant_operation_real_make_progress_page;
	((AssistantOperationClass *) klass)->show_error = assistant_operation_real_show_error;
	((AssistantOperationClass *) klass)->make_summary_page = assistant_operation_real_make_summary_page;
	((AssistantOperationClass *) klass)->apply_finished = assistant_operation_real_apply_finished;
	((AssistantOperationClass *) klass)->do_prepare = assistant_operation_real_do_prepare;
	((AssistantOperationClass *) klass)->do_cancel = assistant_operation_real_do_cancel;
	((AssistantOperationClass *) klass)->do_close = assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PASSWORD_PAGE, g_param_spec_object ("password-page", "password-page", "password-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_NAG_PAGE, g_param_spec_object ("nag-page", "nag-page", "nag-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_QUESTION_PAGE, g_param_spec_object ("question-page", "question-page", "question-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_OP_ICON, g_param_spec_object ("op-icon", "op-icon", "op-icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("closing", TYPE_ASSISTANT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->succeeded = FALSE;
	self->priv->searched_for_passphrase = FALSE;
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->status_icon);
	_g_object_unref0 (self->priv->nag_entry);
	_g_object_unref0 (self->priv->encrypt_entry);
	_g_object_unref0 (self->priv->encrypt_confirm_entry);
	_g_object_unref0 (self->priv->encrypt_enabled);
	_g_object_unref0 (self->priv->encrypt_remember);
	_g_object_unref0 (self->priv->_password_page);
	_g_object_unref0 (self->priv->_nag_page);
	__g_list_free__g_object_unref0_0 (self->priv->first_password_widgets);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	_g_object_unref0 (self->priv->question_label);
	_g_object_unref0 (self->priv->_question_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->secondary_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->progress_expander);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->detail_widget);
	_g_object_unref0 (self->priv->detail_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->priv->_op_icon);
	_g_object_unref0 (self->op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static volatile gsize assistant_operation_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		GType assistant_operation_type_id;
		assistant_operation_type_id = g_type_register_static (TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_operation_type_id__volatile, assistant_operation_type_id);
	}
	return assistant_operation_type_id__volatile;
}


static void _vala_assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		g_value_set_boolean (value, assistant_operation_get_automatic (self));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		g_value_set_object (value, assistant_operation_get_password_page (self));
		break;
		case ASSISTANT_OPERATION_NAG_PAGE:
		g_value_set_object (value, assistant_operation_get_nag_page (self));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		g_value_set_object (value, assistant_operation_get_question_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		g_value_set_object (value, assistant_operation_get_op_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		assistant_operation_set_automatic (self, g_value_get_boolean (value));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		assistant_operation_set_password_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_NAG_PAGE:
		assistant_operation_set_nag_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		assistant_operation_set_question_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		assistant_operation_set_op_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



