/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

int
main (int argc, char *argv[])
{
  GtkWidget *main_window, *statusbar, *text;
  GtkTextBuffer *buffer;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  main_window = create_main_window ();
  set_window_title (main_window);
  gtk_widget_show (main_window);

  /* We use the support function lookup_widget(), which is provided by Glade
     so you can get a pointer to any widget in a component, simply by passing
     any widget in the component, and the name of the widget you want.
     Here we pass the toplevel widget in the component, main_window, and
     we want to get the status bar widget which is called "statusbar1". */
  statusbar = lookup_widget (main_window, "statusbar1");
  gtk_statusbar_push (GTK_STATUSBAR (statusbar), 1,
		      "Welcome to the Glade Text Editor.");

  /* We also need to connect a signal to the GtkTextBuffer, to know when the
     text has changed. We can't connect the signal in Glade as GtkTextBuffer
     is not a widget. */
  text = lookup_widget (main_window, "text1");
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  g_signal_connect (buffer, "changed", G_CALLBACK (on_text_changed), NULL);

  gtk_main ();
  return 0;
}

