/* frames.h --

   This file is part of the lzop file compressor.

   Copyright (C) 1996-2010 Markus Franz Xaver Johannes Oberhumer
   All Rights Reserved.

   lzop and the LZO library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer
   <markus@oberhumer.com>
   http://www.oberhumer.com/opensource/lzop/
 */


#define UNCOMPRESSED_SIZE       54036u
#define COMPRESSED_SIZE         3522u

#define UNCOMPRESSED_ADLER32    0x3fe9a878L
#define COMPRESSED_ADLER32      0x367c5616L

static const unsigned char compressed_frames[3522] = {
0x13, 0x20, 0x00, 0x20, 0x00, 0x2c, 0x06, 0x00, 0xb2, 0x10, 0x20, 0x24,
0x15, 0x01, 0x20, 0xa4, 0x00, 0x39, 0x85, 0x00, 0x30, 0x2e, 0x04, 0x00,
0x34, 0x9e, 0x00, 0xb1, 0x10, 0x05, 0x00, 0xb0, 0x85, 0x00, 0x20, 0x45,
0x00, 0xb0, 0x3b, 0x76, 0x02, 0xb0, 0x20, 0x61, 0x00, 0xb0, 0x27, 0x05,
0x00, 0xb1, 0x85, 0x00, 0xb0, 0x29, 0x04, 0x00, 0x2c, 0x02, 0x00, 0xb0,
0x20, 0x2e, 0x4f, 0x02, 0xb1, 0x30, 0xb0, 0x0c, 0x21, 0x35, 0x05, 0x00,
0xb0, 0x54, 0x03, 0x2f, 0x95, 0x02, 0x10, 0x2a, 0x04, 0x00, 0x3c, 0x75,
0x02, 0x20, 0x20, 0x0e, 0x00, 0x00, 0x2a, 0xf5, 0x04, 0xb2, 0x37, 0x54,
0x02, 0x2e, 0x04, 0x00, 0x2b, 0x84, 0x02, 0x20, 0x0a, 0x75, 0x02, 0xb0,
0x2d, 0x64, 0x04, 0x34, 0xc4, 0x04, 0x32, 0xdd, 0x04, 0xb1, 0x39, 0x8c,
0x04, 0x7c, 0x3a, 0x2c, 0x4c, 0x05, 0x29, 0x74, 0x00, 0x2b, 0x76, 0x02,
0xb1, 0x10, 0x3c, 0x3c, 0x09, 0x74, 0x0e, 0x34, 0x3d, 0x09, 0xb2, 0x4c,
0x3c, 0x28, 0x02, 0x00, 0xb1, 0x20, 0x2c, 0x44, 0x07, 0x35, 0x65, 0x04,
0x00, 0x36, 0x04, 0x03, 0x34, 0x74, 0x02, 0x3e, 0x54, 0x0c, 0x3a, 0xa5,
0x0b, 0xb0, 0x35, 0xb4, 0x09, 0x44, 0x03, 0x29, 0xdc, 0x04, 0x3a, 0x75,
0x01, 0xb1, 0x30, 0x9c, 0x00, 0x20, 0x0c, 0x74, 0x02, 0x37, 0x5c, 0x01,
0x35, 0xd4, 0x04, 0xc4, 0x00, 0x20, 0x02, 0xe4, 0x04, 0x35, 0xa4, 0x00,
0x20, 0x20, 0x75, 0x02, 0xb2, 0x27, 0xe6, 0x09, 0xb1, 0x20, 0x20, 0x06,
0xcc, 0x01, 0x20, 0x16, 0x74, 0x02, 0x20, 0x11, 0x64, 0x02, 0x34, 0x84,
0x0e, 0x36, 0xcd, 0x01, 0xb0, 0x20, 0x48, 0x75, 0x02, 0xb2, 0x2b, 0xb4,
0x0e, 0x36, 0x6c, 0x02, 0x9d, 0x02, 0x30, 0x20, 0x05, 0xf4, 0x04, 0x31,
0xf4, 0x0c, 0x20, 0x14, 0x75, 0x02, 0xb2, 0x2d, 0x1c, 0x11, 0x30, 0x6d,
0x02, 0xb2, 0x9c, 0xb4, 0xac, 0x03, 0x2b, 0x34, 0x0e, 0x32, 0xcc, 0x15,
0xc5, 0xb5, 0x20, 0x3b, 0x54, 0x0c, 0x34, 0xb5, 0x13, 0xb2, 0x54, 0x51,
0x7c, 0xc9, 0xed, 0x52, 0xb2, 0x33, 0x84, 0x13, 0x28, 0xed, 0x18, 0xb1,
0x2e, 0x7c, 0x00, 0x2b, 0xd4, 0x0e, 0x28, 0xce, 0x13, 0xb1, 0x30, 0xa4,
0x9d, 0x30, 0xfd, 0x18, 0xb0, 0x33, 0x46, 0x11, 0xb0, 0x10, 0x28, 0x5c,
0x1b, 0x28, 0x74, 0x1b, 0x2c, 0xc5, 0x0c, 0xb1, 0x20, 0x16, 0xbd, 0x18,
0xb0, 0x20, 0x08, 0xad, 0x18, 0xb0, 0x37, 0xac, 0x18, 0x3a, 0x04, 0x00,
0x4c, 0x28, 0x20, 0x0f, 0x28, 0x1b, 0x2b, 0xed, 0x13, 0xb1, 0x20, 0x04,
0x64, 0x02, 0x2d, 0xd5, 0x07, 0x10, 0x2e, 0x2c, 0x1b, 0x34, 0x04, 0x00,
0x74, 0xc8, 0x75, 0x36, 0xb2, 0x20, 0x02, 0x04, 0x00, 0x28, 0x85, 0x07,
0xb2, 0x31, 0x1c, 0x20, 0x65, 0x39, 0xb0, 0x27, 0x34, 0x07, 0xad, 0x01,
0xb1, 0x35, 0x34, 0x0a, 0x20, 0x00, 0x00, 0x65, 0x04, 0x00, 0xa4, 0x9b,
0x3a, 0xac, 0x1d, 0x3c, 0x4c, 0x2e, 0x2a, 0x4d, 0x0c, 0xb0, 0x84, 0x68,
0x34, 0xcd, 0x2e, 0xb1, 0x2f, 0x04, 0x00, 0x38, 0x44, 0x0c, 0x2e, 0x5c,
0x13, 0x20, 0x05, 0x54, 0x1d, 0x28, 0x0c, 0x16, 0x38, 0x01, 0x00, 0xb1,
0x2d, 0x05, 0x2a, 0xb0, 0x3d, 0x36, 0x11, 0xb1, 0x30, 0x32, 0x74, 0x02,
0x20, 0x07, 0x34, 0x1b, 0x20, 0x0d, 0x25, 0x16, 0xb1, 0x2b, 0xdd, 0x2e,
0xb0, 0x2d, 0x24, 0x02, 0x28, 0x05, 0x00, 0x20, 0x2d, 0x9c, 0x1b, 0x3a,
0x64, 0x31, 0x20, 0x05, 0xec, 0x04, 0x2a, 0xdd, 0x1a, 0xb1, 0x33, 0xbc,
0x33, 0x36, 0x4d, 0x31, 0xb1, 0x3f, 0x8e, 0x1d, 0xb1, 0x30, 0x20, 0x17,
0xdd, 0x33, 0xb1, 0x35, 0x34, 0x09, 0x2c, 0xec, 0x02, 0x2e, 0x9d, 0x27,
0xb0, 0x3b, 0x6c, 0x02, 0x3d, 0x74, 0x2f, 0x20, 0x2e, 0x74, 0x2c, 0x30,
0x7c, 0x18, 0x20, 0x05, 0x74, 0x27, 0x32, 0x9e, 0x00, 0xb2, 0x10, 0x20,
0x1d, 0xfc, 0x29, 0x20, 0x01, 0xdd, 0x2e, 0xb2, 0x20, 0x08, 0xed, 0x29,
0xb0, 0x2f, 0xf4, 0x04, 0x20, 0x1f, 0x74, 0x02, 0x28, 0xbe, 0x24, 0xb0,
0x20, 0x20, 0x0e, 0xcc, 0x06, 0x39, 0x75, 0x02, 0xb1, 0x33, 0x75, 0x02,
0xb1, 0x20, 0x18, 0x74, 0x2c, 0x37, 0x4c, 0x31, 0x3f, 0x4c, 0x0c, 0x3a,
0x75, 0x02, 0xb1, 0x20, 0x16, 0x75, 0x02, 0xb1, 0x3f, 0xdd, 0x2e, 0xb2,
0xf4, 0x79, 0x2b, 0x6c, 0x27, 0x38, 0xe4, 0x15, 0x32, 0x3d, 0x3b, 0xb0,
0x20, 0x04, 0x4c, 0x0c, 0x2c, 0x0d, 0x19, 0xb1, 0x31, 0x04, 0x11, 0x2a,
0x74, 0x25, 0x2a, 0x7c, 0x00, 0x75, 0x13, 0xb2, 0x39, 0xc4, 0x44, 0x30,
0x24, 0x40, 0x2a, 0x7c, 0x0a, 0x2e, 0x74, 0x02, 0x7d, 0x10, 0xb1, 0x2b,
0x8c, 0x2c, 0x2c, 0x5d, 0x05, 0xb2, 0x3b, 0x74, 0x18, 0x36, 0x6c, 0x2c,
0x20, 0x09, 0x14, 0x45, 0x20, 0x1b, 0x6d, 0x2c, 0xb0, 0x20, 0x00, 0x00,
0x00, 0x73, 0x6c, 0x2c, 0x20, 0x83, 0xe4, 0x2e, 0x3c, 0xed, 0x2e, 0xb1,
0x29, 0xec, 0x2e, 0xe4, 0x72, 0x2c, 0xb4, 0x0e, 0x26, 0xb4, 0x27, 0x32,
0x94, 0x54, 0x2a, 0xcc, 0x0e, 0x2a, 0xb4, 0x0e, 0x3a, 0xbe, 0x0e, 0xb1,
0x10, 0x20, 0x07, 0x15, 0x25, 0xb1, 0x20, 0x1a, 0x54, 0x5b, 0x20, 0x01,
0xdc, 0x2e, 0x34, 0x8d, 0x02, 0xb1, 0x20, 0x08, 0x9d, 0x22, 0xb0, 0x20,
0x14, 0x1c, 0x16, 0x2c, 0x64, 0x02, 0xe4, 0x26, 0xf5, 0x28, 0x20, 0x3d,
0x95, 0x20, 0xb0, 0x20, 0x0e, 0xec, 0x2e, 0x2c, 0x54, 0x1d, 0x28, 0x4c,
0x07, 0x36, 0xbc, 0x33, 0x3e, 0xdc, 0x58, 0x2a, 0xf4, 0x02, 0x31, 0x84,
0x00, 0x20, 0x0d, 0xdc, 0x5d, 0x3d, 0xd4, 0x07, 0x2e, 0xbc, 0x09, 0x20,
0x05, 0xf4, 0x29, 0x36, 0x7e, 0x02, 0xb2, 0x10, 0x20, 0x3d, 0xed, 0x58,
0xb1, 0x20, 0x10, 0xec, 0x29, 0x2a, 0x9e, 0x00, 0xb1, 0x10, 0x20, 0x1f,
0xec, 0x58, 0x3c, 0x54, 0x5b, 0x20, 0x07, 0x75, 0x02, 0xb1, 0x33, 0xf5,
0x09, 0xb0, 0x20, 0x24, 0x75, 0x2c, 0xb0, 0x37, 0xac, 0x36, 0x33, 0x95,
0x64, 0x00, 0x20, 0x08, 0xfc, 0x31, 0x20, 0x16, 0xe4, 0x04, 0x2e, 0x8c,
0x29, 0x34, 0x74, 0x2c, 0x2c, 0x54, 0x5b, 0x20, 0x0f, 0xe5, 0x09, 0xb2,
0x20, 0x08, 0x34, 0x3b, 0x2a, 0x3d, 0x0a, 0xb1, 0x2f, 0xdc, 0x3f, 0x2a,
0x74, 0x45, 0x2a, 0x74, 0x2c, 0x7d, 0x16, 0xb1, 0x3c, 0x0c, 0x27, 0x2d,
0xb4, 0x3d, 0x2a, 0x64, 0x07, 0x2e, 0x5d, 0x31, 0xb2, 0x27, 0x04, 0x00,
0x2a, 0x8c, 0x2c, 0x2a, 0xe4, 0x02, 0x20, 0x13, 0x45, 0x16, 0xb1, 0x31,
0xf4, 0x15, 0x32, 0x9c, 0x42, 0x2e, 0x7d, 0x05, 0xb0, 0x20, 0x08, 0x6c,
0x2c, 0x24, 0xfc, 0x29, 0x20, 0x17, 0x6c, 0x2c, 0x3e, 0xac, 0x18, 0x34,
0x5d, 0x05, 0xb0, 0x20, 0x06, 0x6d, 0x2c, 0xb0, 0x25, 0x6c, 0x2c, 0x3c,
0x7d, 0x2c, 0xb1, 0x2d, 0x74, 0x45, 0x2e, 0xe5, 0x13, 0xb2, 0x29, 0x94,
0x1d, 0x2c, 0x0c, 0x05, 0x20, 0x00, 0x00, 0x00, 0x1a, 0x6c, 0x2c, 0x20,
0x7d, 0xd4, 0x2e, 0x28, 0x04, 0x16, 0x38, 0xb5, 0x1d, 0xb2, 0x31, 0x74,
0x27, 0x2c, 0x14, 0x11, 0x28, 0xe4, 0x2e, 0x32, 0xb5, 0x5d, 0xb0, 0x2d,
0x04, 0x00, 0x20, 0x01, 0xe4, 0x2e, 0x20, 0x0b, 0x8d, 0x27, 0xb0, 0x20,
0x24, 0x54, 0x5b, 0x20, 0x07, 0xc4, 0x5d, 0x20, 0x0f, 0x8d, 0x27, 0xb0,
0x20, 0x06, 0x4c, 0x60, 0x2a, 0x6c, 0x02, 0x2c, 0x85, 0x4c, 0xb1, 0x27,
0x74, 0x91, 0x2e, 0xe5, 0x2e, 0xb0, 0x20, 0x20, 0x65, 0x31, 0xb1, 0xcc,
0xfe, 0x32, 0x24, 0x65, 0x3e, 0xc5, 0x5d, 0xb0, 0x20, 0x02, 0xe5, 0x4e,
0xb2, 0x3f, 0x65, 0x31, 0xb1, 0x20, 0x1c, 0x75, 0x2c, 0xb2, 0x35, 0xc6,
0x5d, 0xb0, 0x30, 0x20, 0x05, 0x6c, 0x27, 0x2f, 0x04, 0x23, 0x20, 0x3c,
0x75, 0x2c, 0xb0, 0x20, 0x17, 0xa4, 0x8c, 0x33, 0xe5, 0x04, 0xb0, 0x20,
0x2e, 0x75, 0x2c, 0xb0, 0x20, 0x10, 0x3c, 0x85, 0x20, 0x25, 0xe4, 0x04,
0x2a, 0x74, 0x2c, 0x36, 0x74, 0x94, 0x20, 0x01, 0x54, 0x09, 0x3c, 0x4c,
0x8d, 0x20, 0x15, 0xcd, 0x09, 0xb1, 0x3b, 0xc4, 0x87, 0x6c, 0x64, 0x28,
0xd5, 0x13, 0xb0, 0x20, 0x02, 0xbd, 0x87, 0xb0, 0x33, 0xec, 0x04, 0x32,
0xe5, 0x2e, 0xb2, 0x2f, 0x84, 0x2c, 0x26, 0x84, 0x27, 0x3c, 0xe4, 0x58,
0x32, 0xc4, 0x9b, 0x7d, 0x16, 0xb2, 0x31, 0x4d, 0x87, 0xb0, 0x33, 0x2c,
0x40, 0x2e, 0x45, 0x36, 0xb1, 0x20, 0x08, 0x6c, 0x2c, 0x74, 0x13, 0x20,
0x0f, 0xe4, 0x58, 0x28, 0xbd, 0x18, 0xb1, 0x20, 0x06, 0x44, 0x5b, 0x3c,
0x6c, 0x2c, 0x38, 0x1c, 0x59, 0x5c, 0x28, 0x27, 0x64, 0x71, 0x3e, 0x64,
0x2c, 0xf4, 0x28, 0x2e, 0x6c, 0x2c, 0x34, 0xbc, 0x04, 0x26, 0x6c, 0x2c,
0x20, 0x00, 0x00, 0x00, 0xb2, 0x74, 0x2c, 0x20, 0x28, 0x94, 0x2d, 0x3f,
0x1c, 0xb9, 0x20, 0x15, 0xed, 0x2e, 0xb1, 0x31, 0x64, 0x18, 0x32, 0xfd,
0x29, 0xb0, 0x31, 0x4c, 0x85, 0x30, 0x96, 0x18, 0xb0, 0x20, 0x30, 0x14,
0xb9, 0x36, 0xa4, 0x13, 0x20, 0x02, 0x7c, 0x02, 0x20, 0x04, 0xa5, 0x22,
0xb2, 0x20, 0x08, 0x95, 0x18, 0xb2, 0x20, 0x0c, 0x0c, 0x45, 0x3c, 0xd6,
0x7b, 0xb2, 0x10, 0x20, 0x05, 0x65, 0x31, 0xb2, 0x2d, 0x54, 0x1d, 0x28,
0xec, 0x04, 0x38, 0xc4, 0x5d, 0x34, 0x0c, 0x20, 0x3b, 0x04, 0xb9, 0x3b,
0xed, 0x2e, 0xb0, 0x3b, 0xcc, 0x62, 0x35, 0x84, 0x93, 0x29, 0x9c, 0x7b,
0x20, 0x0b, 0xf4, 0x29, 0x2a, 0x64, 0x05, 0x37, 0x04, 0x05, 0x20, 0x1e,
0x65, 0x5b, 0xb1, 0x35, 0x75, 0x2c, 0xb2, 0x20, 0x04, 0x6d, 0x27, 0xb1,
0x20, 0x0a, 0xc4, 0x62, 0x20, 0x0f, 0x75, 0x2c, 0xb1, 0x29, 0x04, 0x54,
0x38, 0x54, 0x29, 0x3c, 0x64, 0x09, 0x38, 0x7d, 0x07, 0xb1, 0x20, 0x18,
0x6d, 0x02, 0xb1, 0x20, 0x02, 0x55, 0x5b, 0xb0, 0x20, 0x0e, 0xf4, 0x04,
0x20, 0x23, 0xbc, 0x62, 0x3a, 0xc4, 0xc2, 0x2a, 0xf4, 0x58, 0x44, 0x9f,
0x20, 0x02, 0xc4, 0x3a, 0x38, 0xb4, 0x67, 0x3c, 0xe4, 0x2e, 0x28, 0x85,
0x2c, 0xb0, 0x39, 0xc4, 0x87, 0x38, 0x05, 0x0f, 0xb2, 0x31, 0x54, 0x5b,
0x3c, 0x2e, 0xb4, 0xb1, 0x30, 0x38, 0xe4, 0x04, 0x2f, 0xac, 0xa0, 0x20,
0x24, 0x6c, 0x2c, 0x2e, 0x54, 0x5d, 0x20, 0x27, 0x6d, 0x2c, 0x20, 0x29,
0x6d, 0x2c, 0xb2, 0x2b, 0x84, 0x18, 0x3a, 0x04, 0x00, 0x38, 0x6d, 0x2c,
0xb0, 0x37, 0xc5, 0x18, 0xb1, 0x20, 0x00, 0x00, 0x00, 0xfb, 0x6c, 0x2c,
0x20, 0x7f, 0xdc, 0x2e, 0xac, 0x9e, 0x3e, 0xf4, 0xe7, 0x20, 0x11, 0xec,
0x2e, 0x2c, 0xd4, 0xcc, 0x34, 0xc5, 0x1d, 0xb2, 0x2d, 0x14, 0xe3, 0x36,
0x34, 0xe3, 0x2c, 0x75, 0x56, 0xb1, 0x35, 0xb5, 0x73, 0xb1, 0x3e, 0xec,
0x22, 0x20, 0x0e, 0xad, 0x22, 0xb1, 0x20, 0x10, 0xc5, 0x5d, 0xb0, 0x20,
0x11, 0x55, 0xa0, 0x00, 0x20, 0x17, 0xf5, 0x58, 0xb1, 0x33, 0xa4, 0xa7,
0x2a, 0x3c, 0x8a, 0x2c, 0x05, 0x1b, 0xb0, 0x35, 0xcc, 0x5f, 0x2e, 0xe4,
0x2e, 0x3d, 0x3c, 0xad, 0x20, 0x09, 0x0d, 0x7e, 0x20, 0x20, 0x09, 0x75,
0x2c, 0xb1, 0x3f, 0xc5, 0x82, 0xb1, 0x20, 0x02, 0x05, 0x05, 0xb1, 0x20,
0x1c, 0x54, 0x8a, 0x26, 0x4c, 0x25, 0x30, 0x75, 0x2c, 0xb1, 0x20, 0x02,
0x3d, 0x85, 0xb2, 0x29, 0x2c, 0x79, 0x32, 0x7c, 0x02, 0x20, 0x09, 0xcc,
0x33, 0x20, 0x0f, 0x35, 0x8a, 0xb2, 0x20, 0x04, 0xe4, 0x06, 0x3a, 0x3c,
0xb7, 0x20, 0x15, 0xbd, 0x8c, 0xb2, 0x37, 0xa4, 0x09, 0x2b, 0x84, 0x00,
0x2b, 0x04, 0xb6, 0x39, 0xec, 0x0b, 0x35, 0x74, 0x02, 0x20, 0x03, 0xdc,
0x04, 0x2c, 0x4d, 0xcd, 0xb2, 0x2f, 0x34, 0xe0, 0x28, 0x4c, 0x54, 0x2e,
0xc5, 0xc5, 0xb2, 0x2d, 0x55, 0x5b, 0xb0, 0x27, 0x24, 0x6a, 0xec, 0x9f,
0x2e, 0xad, 0x11, 0xb2, 0x3b, 0x7d, 0xc5, 0xb0, 0x37, 0xac, 0xe0, 0x36,
0xd4, 0x2e, 0x20, 0x01, 0x6f, 0x2c, 0xb1, 0x30, 0xb0, 0x20, 0x14, 0x6d,
0x2c, 0xb1, 0x20, 0x08, 0x6c, 0x2c, 0x4c, 0x27, 0x2f, 0x04, 0x45, 0x3c,
0x65, 0x2c, 0xb0, 0x2f, 0x44, 0x16, 0x34, 0x94, 0x5d, 0x20, 0x75, 0x6c,
0x2c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x75, 0xa4, 0x2e, 0x37, 0x9c, 0xcf,
0x2e, 0x0d, 0x42, 0x20, 0x2c, 0xfd, 0xe7, 0xb0, 0x31, 0x4c, 0x20, 0x10,
0x1f, 0xc8, 0x16, 0x20, 0x1f, 0x5d, 0x8a, 0xb0, 0x20, 0x1c, 0xac, 0xb6,
0x20, 0x05, 0xfc, 0xb8, 0x20, 0x1a, 0x94, 0x27, 0x20, 0x0c, 0xc5, 0x5d,
0xb1, 0x33, 0xe5, 0xe7, 0xb0, 0x20, 0x0a, 0xc4, 0x5d, 0x36, 0xb4, 0x4c,
0x38, 0xc6, 0x62, 0xb1, 0x20, 0x30, 0x74, 0x07, 0x32, 0x4c, 0x31, 0x3a,
0xb4, 0xb1, 0x2a, 0xdc, 0x4c, 0x3e, 0x66, 0x31, 0xb2, 0x10, 0x20, 0x23,
0xe4, 0xb1, 0x2f, 0xa4, 0x27, 0x3f, 0x74, 0x04, 0x10, 0x1b, 0xfb, 0x14,
0xb0, 0x10, 0x20, 0x20, 0x16, 0x6c, 0x02, 0x2a, 0x54, 0x5b, 0x20, 0x15,
0x35, 0x8a, 0xb2, 0x20, 0x0c, 0x2d, 0x8f, 0xb0, 0x20, 0x12, 0xbd, 0xe0,
0xb1, 0x3f, 0x8e, 0xe5, 0xb1, 0x30, 0x20, 0x13, 0xac, 0x8c, 0x2e, 0x44,
0x07, 0x38, 0x6c, 0x02, 0x28, 0x8c, 0x0c, 0x2e, 0x75, 0x2c, 0xb0, 0x31,
0x8c, 0x80, 0xde, 0x03, 0x00, 0xb2, 0x3b, 0x8c, 0x0e, 0x24, 0x75, 0x2c,
0x20, 0x20, 0x08, 0x25, 0x8f, 0xb1, 0x2f, 0xad, 0xe0, 0xb0, 0x29, 0x04,
0x0f, 0x30, 0xd4, 0x2e, 0x20, 0x01, 0x5d, 0x11, 0xb2, 0x36, 0xd4, 0xb3,
0x3c, 0x94, 0xe0, 0x20, 0x0c, 0xc4, 0x87, 0x28, 0x6d, 0x2c, 0xb0, 0x20,
0x02, 0x54, 0x2c, 0x34, 0x6d, 0x2c, 0xb0, 0x35, 0xe4, 0x13, 0x20, 0x03,
0xae, 0x71, 0xb2, 0x10, 0x10, 0x3d, 0xa8, 0x2f, 0x20, 0x00, 0x00, 0x00,
0x00, 0x9d, 0x6c, 0x2c, 0x20, 0x77, 0x54, 0xb9, 0x28, 0x04, 0xa3, 0x38,
0xb4, 0xd3, 0x32, 0xf5, 0x9d, 0xb0, 0x27, 0x9c, 0x51, 0x32, 0xf4, 0xe7,
0xe4, 0x00, 0x20, 0x19, 0xad, 0x9d, 0xb1, 0x20, 0x24, 0xed, 0x2e, 0xb1,
0x20, 0x04, 0x34, 0x8a, 0x20, 0x0f, 0xc5, 0xcc, 0xb2, 0x20, 0x0c, 0xec,
0x2e, 0x36, 0x45, 0x60, 0xb1, 0x33, 0xdd, 0x2e, 0xb1, 0x35, 0xed, 0xe7,
0xb0, 0x20, 0x06, 0x85, 0x02, 0xb1, 0x20, 0x06, 0x0c, 0x2a, 0x34, 0x2c,
0xb9, 0x32, 0x14, 0x8f, 0x3a, 0x54, 0x29, 0x2c, 0x34, 0x80, 0x3d, 0x1c,
0xe1, 0x2f, 0x9e, 0x27, 0xb2, 0x10, 0x20, 0x1f, 0x55, 0x5b, 0xb2, 0x20,
0x02, 0x4c, 0x5b, 0x20, 0x01, 0x85, 0x02, 0xb2, 0x33, 0xf4, 0xd8, 0x20,
0x23, 0x54, 0x5b, 0x20, 0x03, 0xe4, 0x2e, 0x3c, 0xa5, 0xe3, 0xb1, 0x20,
0x12, 0x64, 0x02, 0x10, 0x07, 0xb0, 0x0c, 0x30, 0xf5, 0x3d, 0xb1, 0x25,
0xcd, 0x3d, 0xb0, 0x10, 0x24, 0xe8, 0x3b, 0x3e, 0xc5, 0x5d, 0xb1, 0x27,
0x6d, 0xf9, 0xb1, 0x2d, 0x9c, 0x2c, 0x16, 0x21, 0x0d, 0xb1, 0x20, 0x0e,
0x6d, 0x2c, 0xb1, 0x20, 0x08, 0x2d, 0xb4, 0xb0, 0x3e, 0x7c, 0xc0, 0x39,
0xfd, 0x58, 0xb2, 0x31, 0xf5, 0x2b, 0xb0, 0x37, 0x64, 0x2c, 0x2c, 0x24,
0x6f, 0x38, 0xd4, 0x58, 0x20, 0x75, 0x6e, 0x2c, 0xb2, 0x30, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x0a, 0x6c, 0x2c, 0x20, 0x21, 0x4c, 0x8a, 0x20,
0x3d, 0x7c, 0x01, 0x2c, 0x9c, 0x1d, 0x32, 0x05, 0x19, 0xb0, 0x37, 0x8c,
0x47, 0x32, 0x8d, 0xe5, 0xb1, 0x10, 0x04, 0xd8, 0x16, 0x20, 0x2b, 0xec,
0x2e, 0x32, 0x25, 0x7e, 0xb2, 0x10, 0x20, 0xe8, 0x16, 0x3c, 0x15, 0xb9,
0xb0, 0x20, 0x08, 0xac, 0x8c, 0x20, 0x0b, 0xdd, 0x5d, 0xb1, 0x10, 0x04,
0x78, 0x43, 0x38, 0x3c, 0x8a, 0x2c, 0x7c, 0xe2, 0x28, 0xed, 0xe7, 0xb1,
0x2b, 0x54, 0x2c, 0x20, 0x05, 0x6d, 0x31, 0xb2, 0x2f, 0x44, 0xaa, 0x20,
0x09, 0x7c, 0x2c, 0x34, 0x55, 0x5b, 0xb1, 0x3b, 0x54, 0x56, 0x2c, 0xcd,
0x5d, 0xb1, 0x20, 0x08, 0x9c, 0xbb, 0x20, 0x0b, 0x64, 0x02, 0x28, 0x1c,
0x2a, 0x32, 0x7c, 0x67, 0x10, 0x23, 0xf8, 0x0c, 0x34, 0x14, 0x03, 0x30,
0xcd, 0x04, 0xb1, 0x20, 0x04, 0x64, 0x02, 0x2a, 0x7c, 0x2c, 0x34, 0x44,
0xed, 0x10, 0x01, 0x60, 0x68, 0x3a, 0x6d, 0x04, 0xb0, 0x39, 0xe5, 0x2e,
0xb1, 0x31, 0xcc, 0x04, 0x30, 0x04, 0x00, 0x2a, 0x34, 0xf7, 0x32, 0xec,
0x58, 0x34, 0x3d, 0x99, 0xb0, 0x2f, 0x9d, 0xe0, 0xb0, 0x10, 0x06, 0x98,
0x54, 0x3c, 0xcc, 0x67, 0x20, 0x0c, 0x6d, 0x2c, 0x10, 0x32, 0x6c, 0x2c,
0x36, 0x04, 0x00, 0x30, 0x6d, 0x2c, 0xb0, 0x39, 0xbc, 0x6c, 0x20, 0x73,
0x6c, 0x2c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0x74, 0x2c, 0x20,
0x7d, 0x24, 0xb9, 0x20, 0x41, 0xed, 0x2e, 0xb0, 0x10, 0x02, 0x50, 0x86,
0x30, 0x85, 0x1b, 0xb2, 0x37, 0xe5, 0x1f, 0x20, 0x3d, 0x84, 0x1d, 0x10,
0x39, 0xf8, 0x27, 0x20, 0x01, 0xed, 0x2e, 0xb0, 0x20, 0x06, 0xad, 0x8c,
0xb0, 0x10, 0x2c, 0xb0, 0x45, 0x3a, 0x14, 0xed, 0x20, 0x03, 0x14, 0x2a,
0x30, 0x44, 0x8a, 0x32, 0x55, 0x5b, 0xb0, 0x33, 0x64, 0x24, 0x2c, 0xa4,
0xac, 0x20, 0x05, 0x8d, 0x02, 0xb1, 0x31, 0x25, 0xd9, 0xb0, 0x20, 0x0e,
0x64, 0xde, 0x2e, 0x85, 0x56, 0xb0, 0x3d, 0xf5, 0xe7, 0xb1, 0x20, 0x04,
0x44, 0x8f, 0x32, 0xdc, 0x2e, 0x20, 0x03, 0x7c, 0x2c, 0x28, 0x1c, 0x2a,
0x35, 0x3c, 0xb4, 0x20, 0x02, 0xbd, 0x5f, 0xb1, 0x3b, 0x7d, 0x02, 0xb2,
0x20, 0x04, 0x5c, 0x02, 0x2c, 0x54, 0x6a, 0x30, 0xc4, 0x87, 0x30, 0x6c,
0x3b, 0x10, 0x09, 0xf9, 0x3b, 0xb0, 0x10, 0x04, 0x58, 0x1e, 0x26, 0x74,
0x36, 0x39, 0x24, 0xb4, 0x20, 0x0e, 0x6c, 0x2c, 0x34, 0xe4, 0x58, 0x38,
0x1e, 0xc8, 0xb2, 0x20, 0x3c, 0x14, 0xde, 0x20, 0x0b, 0x84, 0x0c, 0x2c,
0x6c, 0x2c, 0x38, 0x0c, 0x6f, 0x20, 0x27, 0x5c, 0x2c, 0x20, 0x00, 0x00,
0x00, 0x00, 0x00, 0xe6, 0x74, 0x2c, 0x20, 0x81, 0xfe, 0xe7, 0xb1, 0x20,
0x20, 0x3f, 0xad, 0x01, 0xb1, 0x2d, 0x84, 0xd4, 0x10, 0x0f, 0x59, 0xd0,
0x20, 0x34, 0x1c, 0xa8, 0x29, 0xdd, 0x84, 0xb0, 0x10, 0x08, 0xf8, 0x5b,
0x10, 0x35, 0x70, 0x2a, 0x20, 0x01, 0x1d, 0xad, 0xb2, 0x3b, 0x4c, 0x51,
0x10, 0x07, 0x48, 0xb7, 0x34, 0x04, 0xb9, 0x20, 0x0d, 0xe4, 0x2e, 0x14,
0x01, 0xbc, 0x20, 0x20, 0x04, 0x7c, 0x85, 0x30, 0xe5, 0x35, 0xb1, 0x37,
0x35, 0x8a, 0xb1, 0x33, 0x0c, 0xb9, 0x20, 0x09, 0x1d, 0x34, 0xb2, 0x33,
0x54, 0x02, 0x20, 0x0d, 0x7c, 0x2c, 0x10, 0x0b, 0xe1, 0xaa, 0xb0, 0x3d,
0x65, 0x2c, 0xb2, 0x3d, 0xf4, 0x29, 0x34, 0x15, 0xb9, 0xb1, 0x10, 0x1a,
0x48, 0xd0, 0x2c, 0x7c, 0x2c, 0x10, 0x0b, 0x80, 0x77, 0x7c, 0x28, 0xec,
0x24, 0x34, 0xac, 0x09, 0x10, 0x17, 0xf1, 0x1b, 0xb2, 0x10, 0x1c, 0x01,
0x37, 0xb0, 0xe4, 0x29, 0x33, 0x54, 0xb1, 0x3e, 0x74, 0xf4, 0x3c, 0x3c,
0x85, 0x20, 0x0b, 0x6d, 0x2c, 0xb2, 0x10, 0x08, 0x80, 0x3e, 0x20, 0x3d,
0x64, 0x2c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x6c, 0x2c,
0x20, 0x55, 0x4c, 0xb9, 0x36, 0xed, 0x76, 0xb2, 0x33, 0x5c, 0x22, 0x30,
0x04, 0xe8, 0x20, 0x35, 0x54, 0x1d, 0x10, 0x18, 0xc0, 0x14, 0x3f, 0x1c,
0xb9, 0x10, 0x13, 0xd0, 0x16, 0x10, 0x2b, 0x79, 0x19, 0xb2, 0x10, 0x04,
0x48, 0x8d, 0x3a, 0x05, 0x59, 0xb1, 0x10, 0x08, 0x09, 0x08, 0xb0, 0x2f,
0x4c, 0x51, 0x3c, 0x0d, 0xb9, 0xb0, 0x10, 0x04, 0x60, 0x08, 0x20, 0x0f,
0x4c, 0x5b, 0x3c, 0x84, 0x2c, 0x2c, 0xbc, 0x5d, 0x28, 0x7c, 0x2c, 0x31,
0x44, 0x58, 0x10, 0x0e, 0xa1, 0xd7, 0xb0, 0x10, 0x1c, 0x69, 0x48, 0xb1,
0x31, 0x3d, 0x02, 0xb1, 0x20, 0x02, 0x6c, 0x27, 0x2a, 0x7d, 0x2c, 0xb1,
0x10, 0x0c, 0x81, 0x68, 0xb1, 0x3f, 0x64, 0x29, 0x2d, 0x2c, 0xb2, 0x20,
0x04, 0x44, 0x31, 0x10, 0x0d, 0x18, 0x90, 0x84, 0x16, 0x10, 0x10, 0xd8,
0xd4, 0x36, 0xc4, 0x67, 0x10, 0x09, 0x60, 0xad, 0x32, 0x7c, 0xef, 0x20,
0x17, 0x6c, 0x2c, 0x20, 0x2f, 0x8c, 0x2c, 0x20, 0x24, 0xfc, 0xf6, 0x20,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x05, 0x00, 0xb1, 0x27,
0x34, 0x25, 0x10, 0x0b, 0x79, 0xff, 0xb0, 0x10, 0x0c, 0x20, 0xa1, 0x2c,
0x8c, 0xe5, 0x20, 0x25, 0xec, 0xe7, 0x2e, 0xac, 0x22, 0x64, 0x00, 0x3c,
0x6d, 0x5b, 0xb1, 0x10, 0x2e, 0x30, 0xe6, 0x20, 0x11, 0xcc, 0x5d, 0x36,
0x44, 0x5b, 0x2a, 0xb4, 0x27, 0x10, 0x0d, 0x00, 0x70, 0xc4, 0x11, 0x17,
0xc2, 0x9e, 0xb1, 0x20, 0x30, 0xd4, 0x58, 0x2a, 0x94, 0x82, 0x2e, 0x3c,
0x5b, 0x10, 0x17, 0x78, 0xb7, 0x30, 0x8c, 0x04, 0x10, 0x03, 0xb8, 0x0a,
0x3e, 0x6d, 0x27, 0xb2, 0x29, 0x25, 0x36, 0xb2, 0x10, 0x0a, 0x58, 0x43,
0x37, 0xec, 0xe4, 0x2f, 0xf5, 0x2e, 0xb0, 0x10, 0x1b, 0x90, 0xd2, 0x10,
0x06, 0xe9, 0x36, 0xb1, 0x2c, 0xa4, 0x02, 0x10, 0x0a, 0x90, 0x3b, 0x10,
0x0d, 0x89, 0x4d, 0xb0, 0x85, 0x3c, 0xb2, 0x2f, 0xec, 0xc2, 0x36, 0x0c,
0xed, 0x3e, 0xb4, 0xc0, 0x20, 0x01, 0x6c, 0x2c, 0x20, 0x0b, 0x6d, 0x98,
0xb2, 0x18, 0x10, 0x60, 0x0b, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x98, 0x6c, 0x2c, 0x10, 0x2d, 0x30, 0xa1, 0x20, 0x4b, 0xec, 0x2e,
0x2c, 0x24, 0x25, 0x32, 0x3c, 0xe3, 0x36, 0x1d, 0xb9, 0xb1, 0x10, 0x29,
0xc8, 0xcf, 0x10, 0x12, 0xa9, 0xa3, 0xb0, 0x10, 0x15, 0x08, 0x61, 0x30,
0x6c, 0x5b, 0x18, 0x0c, 0x09, 0x58, 0xb1, 0x33, 0x35, 0x8a, 0x20, 0x35,
0x64, 0xaf, 0x18, 0x17, 0x78, 0x30, 0x32, 0x74, 0xe5, 0x34, 0x5c, 0x56,
0x38, 0x05, 0x27, 0xb2, 0x10, 0x0b, 0xb0, 0x4a, 0x2f, 0x2c, 0x58, 0x28,
0x04, 0xe8, 0x10, 0x1f, 0xf8, 0x45, 0x3a, 0x6c, 0x2c, 0x2c, 0xfc, 0x2e,
0x15, 0xc0, 0x1e, 0x10, 0x0c, 0x20, 0x1e, 0x10, 0x0d, 0x6a, 0x37, 0xb0,
0x03, 0x2e, 0x44, 0x36, 0x2c, 0x7d, 0x31, 0xb0, 0x20, 0x28, 0x6c, 0x2c,
0x2a, 0x64, 0x02, 0x10, 0x1d, 0x9a, 0xad, 0xb2, 0x20, 0x20, 0x03, 0x64,
0x2c, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0x6c, 0x2c,
0x10, 0xb1, 0x28, 0xa1, 0x10, 0x39, 0x20, 0xd0, 0x2a, 0x5c, 0x27, 0x10,
0x01, 0x18, 0x08, 0x38, 0x4d, 0xb9, 0xb0, 0x10, 0x1e, 0x50, 0x8d, 0x10,
0x11, 0x90, 0x8a, 0x24, 0xbc, 0x27, 0x18, 0x23, 0xf9, 0x2d, 0x20, 0x35,
0xe4, 0x2e, 0x2e, 0xdd, 0x5d, 0xb1, 0x18, 0x0a, 0xf2, 0x72, 0xb0, 0x20,
0x2c, 0x4c, 0x5b, 0x34, 0x1c, 0x56, 0x32, 0xee, 0xdb, 0xb2, 0x30, 0x20,
0x03, 0x64, 0x02, 0x32, 0x6c, 0x2c, 0x2e, 0x7c, 0x5b, 0x18, 0x0b, 0x68,
0x41, 0x18, 0x06, 0x63, 0x04, 0x30, 0xb2, 0x23, 0x2e, 0xec, 0x5f, 0x18,
0x05, 0xc0, 0x61, 0x10, 0x25, 0xf0, 0x45, 0x20, 0x09, 0x6c, 0x2c, 0x2c,
0x04, 0x00, 0x38, 0x64, 0x94, 0x20, 0x01, 0x5c, 0x2c, 0x20, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x2c, 0x20, 0xaf, 0xdc, 0xb8,
0x2e, 0xac, 0x53, 0x10, 0x10, 0x29, 0x08, 0x10, 0x32, 0xd4, 0x24, 0x18,
0x09, 0x98, 0x3c, 0x20, 0x05, 0x8d, 0x24, 0xb2, 0x10, 0x26, 0xd8, 0x6a,
0x3f, 0x8c, 0x2c, 0x10, 0x14, 0x91, 0x43, 0xb2, 0x10, 0x0e, 0x58, 0x63,
0x2c, 0xe4, 0x2e, 0x10, 0x09, 0x58, 0x17, 0x20, 0x05, 0xd4, 0x2e, 0x30,
0x6c, 0x2c, 0x18, 0x07, 0x48, 0x6e, 0x30, 0x4c, 0x8a, 0x28, 0xdc, 0x87,
0x2a, 0xa5, 0x8c, 0xb0, 0x2f, 0x9d, 0x58, 0xb0, 0x37, 0x3c, 0xe8, 0x20,
0x1f, 0x6c, 0x2c, 0x20, 0x01, 0x94, 0xc0, 0x30, 0x6c, 0x2c, 0x10, 0x09,
0x10, 0x97, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c,
0x2c, 0x18, 0xdb, 0xf8, 0x57, 0x10, 0x53, 0x90, 0x2f, 0x10, 0x3b, 0xc8,
0x11, 0x2c, 0x94, 0xe0, 0x26, 0xcc, 0x27, 0x2a, 0xa4, 0x5b, 0x18, 0x05,
0x48, 0x73, 0x2c, 0x04, 0x83, 0x10, 0x03, 0x00, 0x08, 0x3a, 0x14, 0x8a,
0x2c, 0x75, 0x2c, 0xb1, 0x20, 0x14, 0x6c, 0x2c, 0x32, 0xec, 0x2e, 0x2a,
0x6d, 0x5b, 0xb0, 0x2d, 0xc5, 0x8c, 0xb0, 0x18, 0x12, 0xd9, 0x72, 0xb1,
0x37, 0xd5, 0x58, 0xb1, 0x20, 0x22, 0x6c, 0x2c, 0x30, 0xdc, 0x04, 0x25,
0x05, 0x2c, 0x20, 0x2e, 0xbc, 0x85, 0xbc, 0x22, 0xa4, 0x0e, 0x2a, 0xf4,
0x2e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x2c,
0x20, 0xc5, 0x74, 0x2c, 0x20, 0x71, 0x6c, 0x2c, 0x10, 0x0d, 0x69, 0x68,
0xb1, 0x20, 0x10, 0x9c, 0x02, 0x20, 0x0d, 0x1c, 0xb9, 0x28, 0x74, 0x2c,
0x18, 0x11, 0xd1, 0x81, 0xb0, 0x10, 0x18, 0x98, 0x0a, 0x10, 0x05, 0xf0,
0xbe, 0x2e, 0x4c, 0xb9, 0x18, 0x0b, 0x29, 0x89, 0xb2, 0x2d, 0x04, 0xb9,
0x32, 0x0c, 0x8a, 0x10, 0x25, 0xe0, 0x9e, 0x3e, 0x6c, 0x2c, 0x10, 0x03,
0xe1, 0x14, 0xb1, 0x29, 0xec, 0x87, 0x18, 0x05, 0x00, 0x49, 0x25, 0x24,
0x8f, 0x31, 0x0d, 0xb9, 0xb0, 0x2b, 0x0d, 0xb9, 0xb1, 0x20, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0x6c, 0x2c, 0x20, 0xbe, 0x74, 0x2c,
0x10, 0x87, 0xa9, 0x11, 0xb0, 0x10, 0x2e, 0xf8, 0x65, 0x10, 0x35, 0x51,
0x32, 0xb1, 0x27, 0x8c, 0x2a, 0x20, 0x0f, 0x44, 0x5b, 0x2a, 0x8c, 0xe0,
0x3c, 0x3c, 0x05, 0x10, 0x01, 0xa1, 0x0f, 0xb1, 0x2b, 0x34, 0x8a, 0x3c,
0x5c, 0x02, 0x20, 0x31, 0x6c, 0x2c, 0x2d, 0x94, 0x8a, 0x31, 0x4e, 0x8a,
0xb1, 0x20, 0x10, 0x05, 0x11, 0xcb, 0xb0, 0x18, 0x08, 0x30, 0x84, 0x20,
0x05, 0x6c, 0x2c, 0x11, 0x00, 0x00
};
