/****************************************************************************
** $Id: qinputcontextfactory.cpp,v 1.2 2004/06/20 18:43:11 daisuke Exp $
**
** Implementation of QInputContextFactory class
**
** Created : 001103
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition licenses may use this
** file in accordance with the Qt Commercial License Agreement provided
** with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "qinputcontextinterface_p.h" // up here for GCC 2.7.* compatibility
#include "qinputcontextfactory.h"
#include "qinputcontext.h"

#ifndef QT_NO_IM

#include "qapplication.h"

#ifdef QT_THREAD_SUPPORT
#include <private/qmutexpool_p.h>
#endif // QT_THREAD_SUPPORT

#include <stdlib.h>

#include "qcleanuphandler.h"
#include <private/qpluginmanager_p.h>
#ifndef QT_NO_COMPONENT


static QPluginManager<QInputContextFactoryInterface> *manager = 0;
static QSingleCleanupHandler< QPluginManager<QInputContextFactoryInterface> > cleanup_manager;

static void create_manager()
{
    if( manager ) // already created
	return;

#ifdef QT_THREAD_SUPPORT
    // protect manager creation
    QMutexLocker locker( qt_global_mutexpool ?
			 qt_global_mutexpool->get( &manager ) : 0);

    // we check the manager pointer again to make sure that another thread
    // has not created the manager before us.

    if ( manager ) // already created
        return;
#endif

    manager = new QPluginManager<QInputContextFactoryInterface>( IID_QInputContextFactory, QApplication::libraryPaths(), "/inputmethods", FALSE );

    Q_CHECK_PTR( manager );
    cleanup_manager.set( &manager );
}

#endif //QT_NO_COMPONENT


/*!
    This function generates the input context that has the identifier
    name which is in agreement with \a key. \a widget is the client
    widget of QInputContext. \a widget may be null.
*/
QInputContext *QInputContextFactory::create( const QString& key, QWidget *widget )
{
    QInputContext *ret = 0;
    QString inputcontext = key;
#ifndef QT_NO_COMPONENT
    // make sure the manager is created
    create_manager();

    QInterfacePtr<QInputContextFactoryInterface> iface;
    manager->queryInterface( inputcontext, &iface );

    if ( iface ) {
	ret = iface->create( inputcontext );
#ifdef Q_WS_X11
	if ( ret )
	    ret->setHolderWidget( widget );
#endif
    }
#endif
    return ret;
}


/*!
    This function returns the list of the names input methods.
    Only input methods included in default and placed under
    $QTDIR/plugins/inputmethods are listed.
*/
QStringList QInputContextFactory::keys()
{
    QStringList list;
#ifndef QT_NO_COMPONENT
    // make sure the manager is created
    create_manager();

    list = manager->featureList();
#endif //QT_NO_COMPONENT

    return list;
}


QStringList QInputContextFactory::languages( const QString &key )
{
    QStringList result;
#ifndef QT_NO_COMPONENT
    // make sure the manager is created
    create_manager();

    QInterfacePtr<QInputContextFactoryInterface> iface;
    manager->queryInterface( key, &iface );

    if ( iface )
	result = iface->languages( key );
#endif //QT_NO_COMPONENT

    return result;
}


QString QInputContextFactory::displayName( const QString &key )
{
    QString result( "" );
#ifndef QT_NO_COMPONENT
    // make sure the manager is created
    create_manager();

    QInterfacePtr<QInputContextFactoryInterface> iface;
    manager->queryInterface( key, &iface );

    if ( iface )
	result = iface->displayName( key );
#endif //QT_NO_COMPONENT

    return result;
}


QString QInputContextFactory::description( const QString &key )
{
    QString result( "" );
#ifndef QT_NO_COMPONENT
    // make sure the manager is created
    create_manager();

    QInterfacePtr<QInputContextFactoryInterface> iface;
    manager->queryInterface( key, &iface );

    if ( iface )
	result = iface->description( key );
#endif //QT_NO_COMPONENT

    return result;
}

#endif // QT_NO_IM
