

///
// Find the templates for coordinate generation
//
// Autogenerated, do not edit.
//
//   $SCHRODINGER/run mol_generator.py templates.mae
//
// generated using templates.mae version ad51e1ccece0b7b5f872.
//


#include "CoordgenTemplates.h"

#include <array>

#include "sketcherMinimizerMolecule.h"
#include "sketcherMinimizerAtom.h"
#include "sketcherMinimizerBond.h"

using std::array;
using std::tuple;

template <typename T>
void add_atoms(sketcherMinimizerMolecule* molecule, const T& atoms)
{
    for (const auto& a: atoms) {
        auto atom = molecule->addNewAtom();
        atom->setAtomicNumber(std::get<0>(a));
        atom->setCoordinates(sketcherMinimizerPointF(std::get<1>(a), std::get<2>(a)));
    }
}

template <typename T>
void add_bonds(sketcherMinimizerMolecule* molecule, const T& bonds)
{
    for (const auto& b: bonds) {
        auto* from_atom = molecule->getAtoms().at(b[0]);
        auto* to_atom = molecule->getAtoms().at(b[1]);
        auto bond = molecule->addNewBond(from_atom, to_atom);
        bond->setBondOrder(b[2]);
    }
}

namespace schrodinger {

std::vector<sketcherMinimizerMolecule*> coordgen_templates()
{
    std::vector<sketcherMinimizerMolecule*> molecules(82);
    size_t i = 0;

    
    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 36> atoms = {{
            tuple<int, float, float>(6, 5.4331f, -5.9998f),
            tuple<int, float, float>(6, 4.1959f, -5.2856f),
            tuple<int, float, float>(6, 4.1959f, -3.857f),
            tuple<int, float, float>(6, 5.4331f, -3.1427f),
            tuple<int, float, float>(6, 6.6703f, -3.857f),
            tuple<int, float, float>(6, 6.6703f, -5.2856f),
            tuple<int, float, float>(6, 3.2084f, -6.993f),
            tuple<int, float, float>(6, 1.9704f, -7.7058f),
            tuple<int, float, float>(6, 1.9686f, -9.1343f),
            tuple<int, float, float>(6, 3.205f, -9.8501f),
            tuple<int, float, float>(6, 4.443f, -9.1373f),
            tuple<int, float, float>(6, 4.4447f, -7.7087f),
            tuple<int, float, float>(6, -0.0072f, -7.7056f),
            tuple<int, float, float>(6, -1.2451f, -6.9926f),
            tuple<int, float, float>(6, -2.4815f, -7.7081f),
            tuple<int, float, float>(6, -2.48f, -9.1367f),
            tuple<int, float, float>(6, -1.2421f, -9.8497f),
            tuple<int, float, float>(6, -0.0057f, -9.1341f),
            tuple<int, float, float>(6, -3.4698f, -5.9991f),
            tuple<int, float, float>(6, -2.2326f, -5.2849f),
            tuple<int, float, float>(6, -2.2325f, -3.8563f),
            tuple<int, float, float>(6, -3.4697f, -3.142f),
            tuple<int, float, float>(6, -4.7069f, -3.8562f),
            tuple<int, float, float>(6, -4.7069f, -5.2848f),
            tuple<int, float, float>(6, -2.4796f, -0.0045f),
            tuple<int, float, float>(6, -2.4813f, -1.4331f),
            tuple<int, float, float>(6, -1.2449f, -2.1488f),
            tuple<int, float, float>(6, -0.0069f, -1.436f),
            tuple<int, float, float>(6, -0.0052f, -0.0074f),
            tuple<int, float, float>(6, -1.2416f, 0.7083f),
            tuple<int, float, float>(6, 3.2084f, -2.1492f),
            tuple<int, float, float>(6, 1.9705f, -1.4362f),
            tuple<int, float, float>(6, 1.9691f, -0.0076f),
            tuple<int, float, float>(6, 3.2055f, 0.7079f),
            tuple<int, float, float>(6, 4.4434f, -0.0051f),
            tuple<int, float, float>(6, 4.4449f, -1.4337f)
        }};
        std::array<std::array<int, 3>, 42> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 2 },
            { 0, 11, 1 },
            { 1, 2, 2 },
            { 2, 3, 1 },
            { 3, 4, 2 },
            { 3, 35, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 },
            { 6, 11, 2 },
            { 7, 8, 2 },
            { 8, 9, 1 },
            { 8, 17, 1 },
            { 9, 10, 2 },
            { 10, 11, 1 },
            { 12, 13, 1 },
            { 12, 17, 2 },
            { 13, 14, 2 },
            { 14, 15, 1 },
            { 14, 18, 1 },
            { 15, 16, 2 },
            { 16, 17, 1 },
            { 18, 19, 1 },
            { 18, 23, 2 },
            { 19, 20, 2 },
            { 20, 21, 1 },
            { 21, 22, 2 },
            { 21, 25, 1 },
            { 22, 23, 1 },
            { 24, 25, 1 },
            { 24, 29, 2 },
            { 25, 26, 2 },
            { 26, 27, 1 },
            { 27, 28, 2 },
            { 28, 29, 1 },
            { 28, 32, 1 },
            { 30, 31, 1 },
            { 30, 35, 2 },
            { 31, 32, 2 },
            { 32, 33, 1 },
            { 33, 34, 2 },
            { 34, 35, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 20> atoms = {{
            tuple<int, float, float>(6, -6.1782f, 2.1898f),
            tuple<int, float, float>(6, -6.7726f, 1.6177f),
            tuple<int, float, float>(6, -6.5745f, 0.8169f),
            tuple<int, float, float>(6, -5.7818f, 0.5881f),
            tuple<int, float, float>(6, -5.1874f, 1.1601f),
            tuple<int, float, float>(6, -5.3855f, 1.9609f),
            tuple<int, float, float>(7, -6.2055f, 3.0143f),
            tuple<int, float, float>(6, -5.4297f, 3.2951f),
            tuple<int, float, float>(6, -4.791f, 2.533f),
            tuple<int, float, float>(6, -3.8805f, 2.6283f),
            tuple<int, float, float>(7, -4.2474f, 0.6956f),
            tuple<int, float, float>(6, -3.8135f, -0.1347f),
            tuple<int, float, float>(6, -2.6968f, -0.0689f),
            tuple<int, float, float>(6, -3.1131f, 2.2969f),
            tuple<int, float, float>(6, -2.8996f, 1.5f),
            tuple<int, float, float>(6, -2.1027f, 1.2865f),
            tuple<int, float, float>(6, -1.8892f, 0.4896f),
            tuple<int, float, float>(6, -1.0923f, 0.2761f),
            tuple<int, float, float>(6, -1.4004f, -0.5109f),
            tuple<int, float, float>(6, 0.1037f, 0.5426f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 2 },
            { 0, 5, 1 },
            { 0, 6, 1 },
            { 1, 2, 1 },
            { 2, 3, 2 },
            { 3, 4, 1 },
            { 4, 5, 2 },
            { 4, 10, 1 },
            { 5, 8, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 13, 2 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 18, 1 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 15, 16, 1 },
            { 16, 17, 2 },
            { 17, 19, 1 },
            { 18, 19, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 23> atoms = {{
            tuple<int, float, float>(6, -0.5614f, 2.2242f),
            tuple<int, float, float>(6, -0.5614f, 1.3992f),
            tuple<int, float, float>(6, 0.153f, 0.9867f),
            tuple<int, float, float>(6, 0.8675f, 1.3992f),
            tuple<int, float, float>(6, 0.8675f, 2.2242f),
            tuple<int, float, float>(6, 0.153f, 2.6367f),
            tuple<int, float, float>(6, 0.153f, 3.4617f),
            tuple<int, float, float>(6, 0.8675f, 3.8742f),
            tuple<int, float, float>(6, 1.582f, 2.6367f),
            tuple<int, float, float>(6, 1.582f, 3.4617f),
            tuple<int, float, float>(6, 2.2964f, 3.8742f),
            tuple<int, float, float>(6, 2.2964f, 4.6992f),
            tuple<int, float, float>(6, 1.582f, 5.1117f),
            tuple<int, float, float>(6, 0.8675f, 4.6992f),
            tuple<int, float, float>(6, 0.153f, 5.1117f),
            tuple<int, float, float>(6, -0.5614f, 4.6992f),
            tuple<int, float, float>(6, -0.5614f, 3.8742f),
            tuple<int, float, float>(6, -1.2759f, 3.4617f),
            tuple<int, float, float>(6, -1.2759f, 2.6367f),
            tuple<int, float, float>(6, -1.9904f, 3.8742f),
            tuple<int, float, float>(6, -2.7049f, 3.4617f),
            tuple<int, float, float>(6, -2.7049f, 2.6367f),
            tuple<int, float, float>(6, -1.9904f, 2.2242f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 18, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 17, 19, 1 },
            { 18, 22, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 25> atoms = {{
            tuple<int, float, float>(6, -1.6638f, -1.7467f),
            tuple<int, float, float>(6, -1.6638f, -2.5717f),
            tuple<int, float, float>(6, -0.8388f, -2.5717f),
            tuple<int, float, float>(6, -0.4263f, -3.2862f),
            tuple<int, float, float>(6, 0.3987f, -3.2862f),
            tuple<int, float, float>(6, 0.769f, -4.0234f),
            tuple<int, float, float>(6, 1.592f, -4.0809f),
            tuple<int, float, float>(6, 2.0613f, -3.4024f),
            tuple<int, float, float>(6, 0.8112f, -2.5717f),
            tuple<int, float, float>(6, 1.7171f, -2.6526f),
            tuple<int, float, float>(6, 2.1296f, -1.9381f),
            tuple<int, float, float>(6, 1.7171f, -1.2237f),
            tuple<int, float, float>(6, 0.8921f, -1.2237f),
            tuple<int, float, float>(6, 0.4796f, -0.5092f),
            tuple<int, float, float>(6, -0.2349f, -0.0967f),
            tuple<int, float, float>(6, -0.2349f, 0.7283f),
            tuple<int, float, float>(6, -0.9494f, 1.1408f),
            tuple<int, float, float>(6, -1.6638f, 0.7283f),
            tuple<int, float, float>(6, -1.6638f, -0.0967f),
            tuple<int, float, float>(6, -2.3783f, -0.5092f),
            tuple<int, float, float>(6, -2.3783f, -1.3342f),
            tuple<int, float, float>(6, -3.0928f, -0.0967f),
            tuple<int, float, float>(6, -3.8072f, -0.5092f),
            tuple<int, float, float>(6, -3.8072f, -1.3342f),
            tuple<int, float, float>(6, -3.0928f, -1.7467f)
        }};
        std::array<std::array<int, 3>, 27> bonds = {{
            { 0, 1, 1 },
            { 0, 20, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 19, 21, 1 },
            { 20, 24, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 27> atoms = {{
            tuple<int, float, float>(6, 0.0716f, -7.5625f),
            tuple<int, float, float>(6, 0.0716f, -8.3875f),
            tuple<int, float, float>(6, 0.7861f, -8.8f),
            tuple<int, float, float>(6, 1.5005f, -8.3875f),
            tuple<int, float, float>(6, 2.215f, -8.8f),
            tuple<int, float, float>(6, 2.215f, -9.625f),
            tuple<int, float, float>(6, 2.9295f, -10.0375f),
            tuple<int, float, float>(6, 3.6439f, -9.625f),
            tuple<int, float, float>(6, 2.9295f, -8.3875f),
            tuple<int, float, float>(6, 3.6439f, -8.8f),
            tuple<int, float, float>(6, 4.3584f, -8.3875f),
            tuple<int, float, float>(6, 4.3584f, -7.5625f),
            tuple<int, float, float>(6, 3.6439f, -7.15f),
            tuple<int, float, float>(6, 3.6439f, -6.325f),
            tuple<int, float, float>(6, 2.9295f, -5.9125f),
            tuple<int, float, float>(6, 2.9295f, -5.0875f),
            tuple<int, float, float>(6, 2.215f, -4.675f),
            tuple<int, float, float>(6, 1.5005f, -5.0875f),
            tuple<int, float, float>(6, 1.5005f, -5.9125f),
            tuple<int, float, float>(6, 0.7861f, -6.325f),
            tuple<int, float, float>(6, 0.0716f, -5.9125f),
            tuple<int, float, float>(6, -0.6429f, -6.325f),
            tuple<int, float, float>(6, -0.6429f, -7.15f),
            tuple<int, float, float>(6, -1.3574f, -5.9125f),
            tuple<int, float, float>(6, -2.0718f, -6.325f),
            tuple<int, float, float>(6, -2.0718f, -7.15f),
            tuple<int, float, float>(6, -1.3574f, -7.5625f)
        }};
        std::array<std::array<int, 3>, 29> bonds = {{
            { 0, 1, 1 },
            { 0, 22, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 2 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 21, 23, 1 },
            { 22, 26, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 24> atoms = {{
            tuple<int, float, float>(6, -2.1593f, 7.9068f),
            tuple<int, float, float>(6, -1.7468f, 7.1923f),
            tuple<int, float, float>(6, -0.9218f, 7.1923f),
            tuple<int, float, float>(6, -0.5093f, 6.4778f),
            tuple<int, float, float>(6, 0.3157f, 6.4778f),
            tuple<int, float, float>(6, 0.7282f, 5.7633f),
            tuple<int, float, float>(6, 1.5532f, 5.7633f),
            tuple<int, float, float>(6, 1.9657f, 6.4778f),
            tuple<int, float, float>(6, 0.7282f, 7.1923f),
            tuple<int, float, float>(6, 1.5532f, 7.1923f),
            tuple<int, float, float>(6, 1.9657f, 7.9068f),
            tuple<int, float, float>(6, 1.5532f, 8.6086f),
            tuple<int, float, float>(6, 0.7282f, 8.6086f),
            tuple<int, float, float>(6, 0.3157f, 9.3231f),
            tuple<int, float, float>(6, -0.5093f, 9.3231f),
            tuple<int, float, float>(6, -0.9218f, 10.0375f),
            tuple<int, float, float>(6, -1.7468f, 10.0375f),
            tuple<int, float, float>(6, -2.1593f, 9.3231f),
            tuple<int, float, float>(6, -2.9295f, 9.0274f),
            tuple<int, float, float>(6, -2.9295f, 8.2024f),
            tuple<int, float, float>(6, -3.6439f, 9.4399f),
            tuple<int, float, float>(6, -4.3584f, 9.0274f),
            tuple<int, float, float>(6, -4.3584f, 8.2024f),
            tuple<int, float, float>(6, -3.6439f, 7.7899f)
        }};
        std::array<std::array<int, 3>, 26> bonds = {{
            { 0, 1, 1 },
            { 0, 19, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 18, 20, 1 },
            { 19, 23, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 27> atoms = {{
            tuple<int, float, float>(6, -0.7145f, 1.0312f),
            tuple<int, float, float>(6, -0.7145f, 0.2062f),
            tuple<int, float, float>(6, -1.4289f, -0.2063f),
            tuple<int, float, float>(6, -1.4289f, -1.0313f),
            tuple<int, float, float>(6, -0.7145f, -1.4438f),
            tuple<int, float, float>(6, -0.7145f, -2.2688f),
            tuple<int, float, float>(6, -0.0f, -2.6812f),
            tuple<int, float, float>(6, 0.7145f, -2.2688f),
            tuple<int, float, float>(6, 0.0f, -1.0313f),
            tuple<int, float, float>(6, 0.7145f, -1.4438f),
            tuple<int, float, float>(6, 1.4289f, -1.0313f),
            tuple<int, float, float>(6, 2.1434f, -1.4438f),
            tuple<int, float, float>(6, 2.8579f, -1.0313f),
            tuple<int, float, float>(6, 2.8579f, -0.2063f),
            tuple<int, float, float>(6, 2.1434f, 0.2062f),
            tuple<int, float, float>(6, 2.1434f, 1.0312f),
            tuple<int, float, float>(6, 1.4289f, 1.4437f),
            tuple<int, float, float>(6, 1.4289f, 2.2687f),
            tuple<int, float, float>(6, 0.7145f, 2.6812f),
            tuple<int, float, float>(6, 0.0f, 2.2687f),
            tuple<int, float, float>(6, -0.7145f, 2.6812f),
            tuple<int, float, float>(6, -1.4289f, 2.2687f),
            tuple<int, float, float>(6, -1.4289f, 1.4437f),
            tuple<int, float, float>(6, -2.1434f, 2.6812f),
            tuple<int, float, float>(6, -2.8579f, 2.2687f),
            tuple<int, float, float>(6, -2.8579f, 1.4437f),
            tuple<int, float, float>(6, -2.1434f, 1.0312f)
        }};
        std::array<std::array<int, 3>, 29> bonds = {{
            { 0, 1, 1 },
            { 0, 22, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 21, 23, 1 },
            { 22, 26, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 26> atoms = {{
            tuple<int, float, float>(6, -1.4289f, -0.5914f),
            tuple<int, float, float>(6, -0.7144f, -0.1789f),
            tuple<int, float, float>(6, -0.0f, -0.5914f),
            tuple<int, float, float>(6, 0.7144f, -0.1789f),
            tuple<int, float, float>(6, 1.4289f, -0.5914f),
            tuple<int, float, float>(6, 1.4289f, -1.4164f),
            tuple<int, float, float>(6, 2.1433f, -1.8288f),
            tuple<int, float, float>(6, 2.8578f, -1.4164f),
            tuple<int, float, float>(6, 2.1433f, -0.1789f),
            tuple<int, float, float>(6, 2.8578f, -0.5914f),
            tuple<int, float, float>(6, 3.5723f, -0.1789f),
            tuple<int, float, float>(6, 3.5723f, 0.6461f),
            tuple<int, float, float>(6, 2.8452f, 1.0586f),
            tuple<int, float, float>(6, 2.5495f, 1.8288f),
            tuple<int, float, float>(6, 1.7245f, 1.8288f),
            tuple<int, float, float>(6, 1.4289f, 1.0586f),
            tuple<int, float, float>(6, 0.7144f, 0.6461f),
            tuple<int, float, float>(6, -0.0f, 1.0586f),
            tuple<int, float, float>(6, -0.7144f, 0.6461f),
            tuple<int, float, float>(6, -1.4289f, 1.0586f),
            tuple<int, float, float>(6, -2.1434f, 0.6461f),
            tuple<int, float, float>(6, -2.1434f, -0.1789f),
            tuple<int, float, float>(6, -2.8578f, 1.0586f),
            tuple<int, float, float>(6, -3.5723f, 0.6461f),
            tuple<int, float, float>(6, -3.5723f, -0.1789f),
            tuple<int, float, float>(6, -2.8578f, -0.5914f)
        }};
        std::array<std::array<int, 3>, 28> bonds = {{
            { 0, 1, 1 },
            { 0, 21, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 20, 22, 1 },
            { 21, 25, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 34> atoms = {{
            tuple<int, float, float>(6, -0.7496f, -1.3082f),
            tuple<int, float, float>(6, -1.464f, -1.7207f),
            tuple<int, float, float>(6, -2.1785f, -1.3082f),
            tuple<int, float, float>(6, -2.1785f, -0.4832f),
            tuple<int, float, float>(6, -2.893f, -0.0707f),
            tuple<int, float, float>(6, -2.893f, 0.7543f),
            tuple<int, float, float>(6, -2.1785f, 1.1668f),
            tuple<int, float, float>(6, -1.464f, 0.7543f),
            tuple<int, float, float>(8, -0.6482f, 0.8767f),
            tuple<int, float, float>(6, -1.464f, -0.0707f),
            tuple<int, float, float>(7, -0.7496f, -0.4832f),
            tuple<int, float, float>(13, 0.5871f, 0.1009f),
            tuple<int, float, float>(7, 0.7496f, 1.5504f),
            tuple<int, float, float>(6, 1.464f, 1.9629f),
            tuple<int, float, float>(6, 1.464f, 2.7879f),
            tuple<int, float, float>(6, 0.7496f, 3.2004f),
            tuple<int, float, float>(6, 0.0351f, 2.7879f),
            tuple<int, float, float>(6, 0.0351f, 1.9629f),
            tuple<int, float, float>(6, 2.1785f, 3.2004f),
            tuple<int, float, float>(6, 2.893f, 2.7879f),
            tuple<int, float, float>(6, 2.893f, 1.9629f),
            tuple<int, float, float>(6, 2.1785f, 1.5504f),
            tuple<int, float, float>(8, 1.8765f, 0.7827f),
            tuple<int, float, float>(7, 0.5328f, -1.3568f),
            tuple<int, float, float>(6, 1.1782f, -1.8707f),
            tuple<int, float, float>(6, 1.9459f, -1.5687f),
            tuple<int, float, float>(8, 1.7612f, -0.7646f),
            tuple<int, float, float>(6, 2.5913f, -2.0826f),
            tuple<int, float, float>(6, 2.4689f, -2.8985f),
            tuple<int, float, float>(6, 1.7012f, -3.2004f),
            tuple<int, float, float>(6, 1.0558f, -2.6865f),
            tuple<int, float, float>(6, 0.2881f, -2.9885f),
            tuple<int, float, float>(6, -0.3573f, -2.4746f),
            tuple<int, float, float>(6, -0.235f, -1.6587f)
        }};
        std::array<std::array<int, 3>, 42> bonds = {{
            { 0, 1, 2 },
            { 0, 10, 1 },
            { 1, 2, 1 },
            { 2, 3, 2 },
            { 3, 4, 1 },
            { 3, 9, 1 },
            { 4, 5, 2 },
            { 5, 6, 1 },
            { 6, 7, 2 },
            { 7, 8, 1 },
            { 7, 9, 1 },
            { 8, 11, 1 },
            { 9, 10, 2 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 11, 22, 1 },
            { 11, 23, 1 },
            { 11, 26, 1 },
            { 12, 13, 2 },
            { 12, 17, 1 },
            { 13, 14, 1 },
            { 13, 21, 1 },
            { 14, 15, 2 },
            { 14, 18, 1 },
            { 15, 16, 1 },
            { 16, 17, 2 },
            { 18, 19, 2 },
            { 19, 20, 1 },
            { 20, 21, 2 },
            { 21, 22, 1 },
            { 23, 24, 2 },
            { 23, 33, 1 },
            { 24, 25, 1 },
            { 24, 30, 1 },
            { 25, 26, 1 },
            { 25, 27, 2 },
            { 27, 28, 1 },
            { 28, 29, 2 },
            { 29, 30, 1 },
            { 30, 31, 2 },
            { 31, 32, 1 },
            { 32, 33, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, 0.1593f, 3.0569f),
            tuple<int, float, float>(6, 0.8597f, 2.621f),
            tuple<int, float, float>(6, 0.8597f, 1.796f),
            tuple<int, float, float>(6, -0.581f, 2.6926f),
            tuple<int, float, float>(6, -0.6628f, 1.8717f),
            tuple<int, float, float>(6, 0.0827f, 1.5185f),
            tuple<int, float, float>(6, -1.3415f, 1.4026f),
            tuple<int, float, float>(6, -1.2746f, 0.5804f),
            tuple<int, float, float>(7, -1.8093f, -0.0488f),
            tuple<int, float, float>(6, -1.5319f, -0.8258f),
            tuple<int, float, float>(6, -0.7203f, -0.9739f),
            tuple<int, float, float>(6, -0.2512f, -1.6526f),
            tuple<int, float, float>(6, 0.5596f, -1.5001f),
            tuple<int, float, float>(6, 1.097f, -2.126f),
            tuple<int, float, float>(6, 0.8237f, -2.9044f),
            tuple<int, float, float>(6, 0.0129f, -3.0569f),
            tuple<int, float, float>(6, -0.5245f, -2.431f),
            tuple<int, float, float>(6, 1.7757f, -1.6569f),
            tuple<int, float, float>(6, 1.3801f, -0.933f),
            tuple<int, float, float>(6, 1.8093f, -0.2284f),
            tuple<int, float, float>(6, 1.3402f, 0.4503f),
            tuple<int, float, float>(6, 1.4884f, 1.2619f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 2 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 5, 2 },
            { 2, 21, 1 },
            { 3, 4, 2 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 2 },
            { 11, 16, 1 },
            { 12, 13, 1 },
            { 13, 14, 2 },
            { 13, 17, 1 },
            { 14, 15, 1 },
            { 15, 16, 2 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, 0.7145f, 1.65f),
            tuple<int, float, float>(7, 0.7145f, 0.825f),
            tuple<int, float, float>(6, 1.4289f, 0.4125f),
            tuple<int, float, float>(6, 0.0f, 2.0625f),
            tuple<int, float, float>(6, -0.7145f, 1.65f),
            tuple<int, float, float>(6, -1.4289f, 2.0625f),
            tuple<int, float, float>(6, -2.1434f, 1.65f),
            tuple<int, float, float>(6, -2.1434f, 0.825f),
            tuple<int, float, float>(6, -0.7145f, 0.825f),
            tuple<int, float, float>(6, -1.4289f, 0.4125f),
            tuple<int, float, float>(8, -1.4289f, -0.4125f),
            tuple<int, float, float>(6, -2.1434f, -0.825f),
            tuple<int, float, float>(6, -2.1434f, -1.65f),
            tuple<int, float, float>(6, -1.4289f, -2.0625f),
            tuple<int, float, float>(6, -0.7145f, -1.65f),
            tuple<int, float, float>(7, 0.0f, -2.0625f),
            tuple<int, float, float>(6, 0.7145f, -1.65f),
            tuple<int, float, float>(6, 0.7145f, -0.825f),
            tuple<int, float, float>(6, 1.4289f, -2.0625f),
            tuple<int, float, float>(6, 2.1434f, -1.65f),
            tuple<int, float, float>(6, 2.1434f, -0.825f),
            tuple<int, float, float>(6, 1.4289f, -0.4125f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 21, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 16, 18, 1 },
            { 17, 21, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 19> atoms = {{
            tuple<int, float, float>(6, -0.2062f, 1.7862f),
            tuple<int, float, float>(6, 0.2063f, 1.0717f),
            tuple<int, float, float>(7, 1.0313f, 1.0717f),
            tuple<int, float, float>(6, -1.0312f, 1.7862f),
            tuple<int, float, float>(6, -1.4437f, 1.0717f),
            tuple<int, float, float>(6, -2.2687f, 1.0717f),
            tuple<int, float, float>(6, -2.6812f, 0.3572f),
            tuple<int, float, float>(6, -2.2687f, -0.3572f),
            tuple<int, float, float>(6, -1.4437f, -0.3572f),
            tuple<int, float, float>(6, -1.0312f, -1.0717f),
            tuple<int, float, float>(7, -0.2062f, -1.0717f),
            tuple<int, float, float>(6, 0.2063f, -1.7862f),
            tuple<int, float, float>(6, 1.0313f, -1.7862f),
            tuple<int, float, float>(6, 1.4438f, -1.0717f),
            tuple<int, float, float>(6, 1.0313f, -0.3572f),
            tuple<int, float, float>(6, 1.4438f, 0.3572f),
            tuple<int, float, float>(6, 2.2688f, -1.0717f),
            tuple<int, float, float>(6, 2.6812f, -0.3572f),
            tuple<int, float, float>(6, 2.2688f, 0.3572f)
        }};
        std::array<std::array<int, 3>, 20> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 15, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 2 },
            { 13, 16, 1 },
            { 14, 15, 1 },
            { 15, 18, 2 },
            { 16, 17, 2 },
            { 17, 18, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 12> atoms = {{
            tuple<int, float, float>(7, 2.2594f, -2.751f),
            tuple<int, float, float>(7, 3.2304f, -1.7031f),
            tuple<int, float, float>(7, 0.9479f, -2.3215f),
            tuple<int, float, float>(6, 0.6005f, -1.1462f),
            tuple<int, float, float>(6, -0.5154f, -2.8288f),
            tuple<int, float, float>(6, -1.5255f, -1.8186f),
            tuple<int, float, float>(6, 1.3803f, -0.3684f),
            tuple<int, float, float>(6, 0.0f, 0.0f),
            tuple<int, float, float>(6, -2.9054f, -2.1883f),
            tuple<int, float, float>(6, -3.2752f, -3.5682f),
            tuple<int, float, float>(6, -2.2651f, -4.5784f),
            tuple<int, float, float>(6, -0.8852f, -4.2087f)
        }};
        std::array<std::array<int, 3>, 14> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 3, 1 },
            { 2, 6, 1 },
            { 2, 4, 1 },
            { 3, 7, 1 },
            { 3, 5, 1 },
            { 4, 5, 1 },
            { 4, 11, 1 },
            { 5, 8, 1 },
            { 6, 7, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, -17.6528f, -2.5809f),
            tuple<int, float, float>(6, -16.8634f, -2.422f),
            tuple<int, float, float>(6, -16.2566f, -0.9952f),
            tuple<int, float, float>(6, -16.6642f, -0.3065f),
            tuple<int, float, float>(6, -13.3058f, -3.061f),
            tuple<int, float, float>(6, -13.37f, -1.8602f),
            tuple<int, float, float>(6, -14.1606f, -1.6244f),
            tuple<int, float, float>(6, -13.9248f, -0.8338f),
            tuple<int, float, float>(6, -14.684f, -0.5109f),
            tuple<int, float, float>(6, -13.7895f, -3.7293f),
            tuple<int, float, float>(6, -14.5153f, -4.1216f),
            tuple<int, float, float>(6, -15.3394f, -4.1601f),
            tuple<int, float, float>(6, -16.0986f, -3.8372f),
            tuple<int, float, float>(6, -16.6425f, -3.2169f),
            tuple<int, float, float>(6, -16.3003f, -1.819f),
            tuple<int, float, float>(6, -15.5081f, -0.5494f),
            tuple<int, float, float>(6, -13.1342f, -1.0697f),
            tuple<int, float, float>(6, -18.4792f, -2.3085f),
            tuple<int, float, float>(6, -17.336f, 0.0706f),
            tuple<int, float, float>(6, -18.9447f, -1.6662f),
            tuple<int, float, float>(6, -18.8636f, -0.722f),
            tuple<int, float, float>(6, -18.2199f, -0.0178f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 1 },
            { 0, 17, 1 },
            { 1, 13, 1 },
            { 1, 14, 1 },
            { 2, 3, 1 },
            { 2, 15, 1 },
            { 2, 14, 1 },
            { 3, 18, 1 },
            { 4, 9, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 5, 16, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 16, 1 },
            { 8, 15, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 17, 19, 1 },
            { 18, 21, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 21> atoms = {{
            tuple<int, float, float>(6, -18.3739f, -2.0722f),
            tuple<int, float, float>(6, -17.6823f, -2.522f),
            tuple<int, float, float>(6, -16.8634f, -2.422f),
            tuple<int, float, float>(6, -16.2566f, -0.9952f),
            tuple<int, float, float>(6, -16.7526f, -0.336f),
            tuple<int, float, float>(6, -17.5564f, -0.1498f),
            tuple<int, float, float>(6, -18.2917f, -0.5239f),
            tuple<int, float, float>(6, -18.6146f, -1.2831f),
            tuple<int, float, float>(6, -13.3058f, -3.061f),
            tuple<int, float, float>(6, -13.37f, -1.8602f),
            tuple<int, float, float>(6, -14.1606f, -1.6244f),
            tuple<int, float, float>(6, -13.9248f, -0.8338f),
            tuple<int, float, float>(6, -14.684f, -0.5109f),
            tuple<int, float, float>(6, -13.7895f, -3.7293f),
            tuple<int, float, float>(6, -14.5153f, -4.1216f),
            tuple<int, float, float>(6, -15.3394f, -4.1601f),
            tuple<int, float, float>(6, -16.0986f, -3.8372f),
            tuple<int, float, float>(6, -16.6425f, -3.2169f),
            tuple<int, float, float>(6, -16.3003f, -1.819f),
            tuple<int, float, float>(6, -15.5081f, -0.5494f),
            tuple<int, float, float>(6, -13.1342f, -1.0697f)
        }};
        std::array<std::array<int, 3>, 23> bonds = {{
            { 0, 1, 1 },
            { 0, 7, 1 },
            { 1, 2, 1 },
            { 2, 17, 1 },
            { 2, 18, 1 },
            { 3, 4, 1 },
            { 3, 19, 1 },
            { 3, 18, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 8, 13, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 9, 20, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 11, 20, 1 },
            { 12, 19, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, -2.0218f, 0.7835f),
            tuple<int, float, float>(6, -1.8205f, -0.0165f),
            tuple<int, float, float>(6, -1.027f, -0.2422f),
            tuple<int, float, float>(6, -0.4348f, 0.3321f),
            tuple<int, float, float>(6, -0.6361f, 1.1322f),
            tuple<int, float, float>(6, -1.4296f, 1.3579f),
            tuple<int, float, float>(6, 0.3884f, 0.2763f),
            tuple<int, float, float>(6, 0.6958f, 1.0419f),
            tuple<int, float, float>(6, 0.0626f, 1.5709f),
            tuple<int, float, float>(6, 0.8977f, -0.3727f),
            tuple<int, float, float>(6, 1.7144f, -0.2561f),
            tuple<int, float, float>(6, 2.0218f, 0.5095f),
            tuple<int, float, float>(6, 1.5125f, 1.1585f),
            tuple<int, float, float>(6, -1.0777f, -1.0657f),
            tuple<int, float, float>(6, 0.5897f, -0.5237f),
            tuple<int, float, float>(6, 0.3591f, -1.3159f),
            tuple<int, float, float>(6, -0.4255f, -1.5709f)
        }};
        std::array<std::array<int, 3>, 20> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 6, 7, 1 },
            { 6, 9, 1 },
            { 6, 14, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 13, 16, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 15> atoms = {{
            tuple<int, float, float>(6, 1.1864f, 1.0359f),
            tuple<int, float, float>(6, 0.3703f, 1.157f),
            tuple<int, float, float>(6, -0.3265f, 0.7153f),
            tuple<int, float, float>(6, 0.0851f, 0.0004f),
            tuple<int, float, float>(7, -0.3283f, -0.7136f),
            tuple<int, float, float>(6, -1.1515f, 0.7164f),
            tuple<int, float, float>(6, -1.5649f, 0.0024f),
            tuple<int, float, float>(6, -1.1533f, -0.7126f),
            tuple<int, float, float>(6, 1.7248f, 0.4108f),
            tuple<int, float, float>(6, 1.7238f, -0.4142f),
            tuple<int, float, float>(6, 1.1838f, -1.0379f),
            tuple<int, float, float>(6, 0.3674f, -1.157f),
            tuple<int, float, float>(6, 2.5081f, -0.6701f),
            tuple<int, float, float>(6, 2.9938f, -0.0033f),
            tuple<int, float, float>(7, 2.5097f, 0.6648f)
        }};
        std::array<std::array<int, 3>, 17> bonds = {{
            { 0, 1, 1 },
            { 0, 8, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 5, 1 },
            { 3, 4, 1 },
            { 4, 7, 1 },
            { 4, 11, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 8, 9, 2 },
            { 8, 14, 1 },
            { 9, 10, 1 },
            { 9, 12, 1 },
            { 10, 11, 1 },
            { 12, 13, 2 },
            { 13, 14, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 21> atoms = {{
            tuple<int, float, float>(6, -1.1557f, -2.1853f),
            tuple<int, float, float>(6, -1.1557f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -2.5978f),
            tuple<int, float, float>(6, 0.2731f, -2.1853f),
            tuple<int, float, float>(6, 0.2731f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -0.9479f),
            tuple<int, float, float>(6, -0.2278f, -1.8009f),
            tuple<int, float, float>(6, -0.0288f, -0.2334f),
            tuple<int, float, float>(6, -0.0288f, 0.5916f),
            tuple<int, float, float>(6, -0.7433f, 1.0041f),
            tuple<int, float, float>(6, -1.1557f, 0.2896f),
            tuple<int, float, float>(6, -1.1557f, -0.5354f),
            tuple<int, float, float>(6, -0.1599f, 1.5875f),
            tuple<int, float, float>(7, -0.3735f, 2.3842f),
            tuple<int, float, float>(6, -1.1703f, 2.5978f),
            tuple<int, float, float>(6, -1.7536f, 2.0144f),
            tuple<int, float, float>(6, -1.5401f, 1.2176f),
            tuple<int, float, float>(6, -1.8702f, -0.9479f),
            tuple<int, float, float>(6, -2.5846f, -1.3604f),
            tuple<int, float, float>(6, -2.5846f, -2.1853f),
            tuple<int, float, float>(6, -1.8702f, -2.5978f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 0, 20, 1 },
            { 1, 5, 1 },
            { 1, 17, 1 },
            { 2, 3, 1 },
            { 2, 6, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 7, 1 },
            { 6, 11, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 9, 12, 1 },
            { 9, 16, 1 },
            { 10, 11, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 28> atoms = {{
            tuple<int, float, float>(6, -1.1557f, -2.1853f),
            tuple<int, float, float>(6, -1.1557f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -2.5978f),
            tuple<int, float, float>(6, 0.2731f, -2.1853f),
            tuple<int, float, float>(6, 0.2731f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -0.9479f),
            tuple<int, float, float>(6, 0.9876f, -2.5978f),
            tuple<int, float, float>(6, 1.7021f, -2.1853f),
            tuple<int, float, float>(6, 1.7021f, -1.3604f),
            tuple<int, float, float>(6, 0.9876f, -0.9479f),
            tuple<int, float, float>(6, 1.8703f, -0.4804f),
            tuple<int, float, float>(6, 2.5846f, -0.8929f),
            tuple<int, float, float>(6, 2.5846f, -1.7178f),
            tuple<int, float, float>(6, -0.2278f, -1.8009f),
            tuple<int, float, float>(6, -0.0288f, -0.2334f),
            tuple<int, float, float>(6, -0.0288f, 0.5916f),
            tuple<int, float, float>(6, -0.7433f, 1.0041f),
            tuple<int, float, float>(6, -1.1557f, 0.2896f),
            tuple<int, float, float>(6, -1.1557f, -0.5354f),
            tuple<int, float, float>(6, -0.1599f, 1.5875f),
            tuple<int, float, float>(7, -0.3735f, 2.3842f),
            tuple<int, float, float>(6, -1.1703f, 2.5978f),
            tuple<int, float, float>(6, -1.7536f, 2.0144f),
            tuple<int, float, float>(6, -1.5401f, 1.2176f),
            tuple<int, float, float>(6, -1.8702f, -0.9479f),
            tuple<int, float, float>(6, -2.5846f, -1.3604f),
            tuple<int, float, float>(6, -2.5846f, -2.1853f),
            tuple<int, float, float>(6, -1.8702f, -2.5978f)
        }};
        std::array<std::array<int, 3>, 33> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 0, 27, 1 },
            { 1, 5, 1 },
            { 1, 24, 1 },
            { 2, 3, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 14, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 16, 19, 1 },
            { 16, 23, 1 },
            { 17, 18, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 },
            { 26, 27, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 23> atoms = {{
            tuple<int, float, float>(6, -1.1557f, -2.1853f),
            tuple<int, float, float>(6, -1.1557f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -2.5978f),
            tuple<int, float, float>(6, 0.2731f, -2.1853f),
            tuple<int, float, float>(6, 0.2731f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -0.9479f),
            tuple<int, float, float>(6, 0.9876f, -2.5978f),
            tuple<int, float, float>(6, 1.7021f, -2.1853f),
            tuple<int, float, float>(6, 1.7021f, -1.3604f),
            tuple<int, float, float>(6, 0.9876f, -0.9479f),
            tuple<int, float, float>(6, 1.8703f, -0.4804f),
            tuple<int, float, float>(6, 2.5846f, -0.8929f),
            tuple<int, float, float>(6, 2.5846f, -1.7178f),
            tuple<int, float, float>(6, -0.2278f, -1.8009f),
            tuple<int, float, float>(6, -0.0288f, -0.2334f),
            tuple<int, float, float>(6, -0.0288f, 0.5916f),
            tuple<int, float, float>(6, -0.7433f, 1.0041f),
            tuple<int, float, float>(6, -1.1557f, 0.2896f),
            tuple<int, float, float>(6, -1.1557f, -0.5354f),
            tuple<int, float, float>(6, -1.8702f, -0.9479f),
            tuple<int, float, float>(6, -2.5846f, -1.3604f),
            tuple<int, float, float>(6, -2.5846f, -2.1853f),
            tuple<int, float, float>(6, -1.8702f, -2.5978f)
        }};
        std::array<std::array<int, 3>, 27> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 0, 22, 1 },
            { 1, 5, 1 },
            { 1, 19, 1 },
            { 2, 3, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 14, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 19> atoms = {{
            tuple<int, float, float>(6, -1.1557f, -2.1853f),
            tuple<int, float, float>(6, -1.1557f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -2.5978f),
            tuple<int, float, float>(6, 0.2731f, -2.1853f),
            tuple<int, float, float>(6, 0.2731f, -1.3604f),
            tuple<int, float, float>(6, -0.4413f, -0.9479f),
            tuple<int, float, float>(6, 0.9876f, -2.5978f),
            tuple<int, float, float>(6, 1.7021f, -2.1853f),
            tuple<int, float, float>(6, 1.7021f, -1.3604f),
            tuple<int, float, float>(6, 0.9876f, -0.9479f),
            tuple<int, float, float>(6, 1.8703f, -0.4804f),
            tuple<int, float, float>(6, 2.5846f, -0.8929f),
            tuple<int, float, float>(6, 2.5846f, -1.7178f),
            tuple<int, float, float>(6, -0.2278f, -1.8009f),
            tuple<int, float, float>(6, -0.0288f, -0.2334f),
            tuple<int, float, float>(6, -0.0288f, 0.5916f),
            tuple<int, float, float>(6, -0.7433f, 1.0041f),
            tuple<int, float, float>(6, -1.1557f, 0.2896f),
            tuple<int, float, float>(6, -1.1557f, -0.5354f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 5, 1 },
            { 2, 3, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 14, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 16> atoms = {{
            tuple<int, float, float>(6, -1.6619f, 0.54f),
            tuple<int, float, float>(6, -1.6619f, -0.285f),
            tuple<int, float, float>(6, -0.8772f, -0.54f),
            tuple<int, float, float>(6, -0.3923f, 0.1275f),
            tuple<int, float, float>(6, -0.8772f, 0.7949f),
            tuple<int, float, float>(6, -0.3923f, -1.2074f),
            tuple<int, float, float>(6, 0.3923f, -0.9525f),
            tuple<int, float, float>(6, 0.3923f, -0.1275f),
            tuple<int, float, float>(6, 1.1769f, -1.2074f),
            tuple<int, float, float>(6, 1.6619f, -0.54f),
            tuple<int, float, float>(6, 1.1769f, 0.1275f),
            tuple<int, float, float>(6, 0.8772f, 0.54f),
            tuple<int, float, float>(6, 0.3923f, 1.2074f),
            tuple<int, float, float>(6, -0.3923f, 0.9525f),
            tuple<int, float, float>(6, 0.1911f, 0.3691f),
            tuple<int, float, float>(6, -0.0803f, -0.3264f)
        }};
        std::array<std::array<int, 3>, 20> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 5, 1 },
            { 2, 15, 1 },
            { 3, 4, 1 },
            { 3, 7, 1 },
            { 3, 13, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 6, 8, 1 },
            { 7, 10, 1 },
            { 7, 11, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 33> atoms = {{
            tuple<int, float, float>(6, 4.9621f, -4.7103f),
            tuple<int, float, float>(6, 4.9621f, -6.1389f),
            tuple<int, float, float>(6, 5.9212f, -3.5981f),
            tuple<int, float, float>(6, 3.6968f, -6.9449f),
            tuple<int, float, float>(6, 2.3169f, -6.32f),
            tuple<int, float, float>(6, 0.9365f, -6.9621f),
            tuple<int, float, float>(6, -0.4126f, -6.3711f),
            tuple<int, float, float>(6, -1.9385f, -6.8286f),
            tuple<int, float, float>(6, -3.0544f, -5.8603f),
            tuple<int, float, float>(6, -3.3986f, -4.4171f),
            tuple<int, float, float>(6, -5.285f, -2.4894f),
            tuple<int, float, float>(6, -5.1939f, -0.9591f),
            tuple<int, float, float>(6, -4.7605f, -3.8655f),
            tuple<int, float, float>(7, -4.2857f, 0.0f),
            tuple<int, float, float>(6, -0.7143f, -1.2372f),
            tuple<int, float, float>(6, 0.0f, -2.4745f),
            tuple<int, float, float>(6, 0.0f, 0.0f),
            tuple<int, float, float>(6, -2.1429f, -1.2372f),
            tuple<int, float, float>(6, 1.4286f, 0.0f),
            tuple<int, float, float>(6, -0.7143f, 1.2372f),
            tuple<int, float, float>(6, 2.1429f, -1.2372f),
            tuple<int, float, float>(6, 2.3274f, 1.1101f),
            tuple<int, float, float>(6, 3.6611f, 0.5983f),
            tuple<int, float, float>(8, 3.5865f, -0.8284f),
            tuple<int, float, float>(6, 1.4286f, -2.4745f),
            tuple<int, float, float>(6, -2.8571f, 0.0f),
            tuple<int, float, float>(6, -2.1429f, 1.2372f),
            tuple<int, float, float>(6, 5.9721f, -2.0675f),
            tuple<int, float, float>(6, 5.041f, -1.2002f),
            tuple<int, float, float>(8, 5.143f, 0.1264f),
            tuple<int, float, float>(6, -0.2728f, 2.5959f),
            tuple<int, float, float>(6, -1.4286f, 3.4356f),
            tuple<int, float, float>(6, -2.5843f, 2.5959f)
        }};
        std::array<std::array<int, 3>, 37> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 3, 1 },
            { 2, 27, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 2 },
            { 9, 12, 1 },
            { 10, 11, 1 },
            { 10, 12, 2 },
            { 11, 13, 1 },
            { 13, 25, 1 },
            { 14, 15, 1 },
            { 14, 16, 2 },
            { 14, 17, 1 },
            { 15, 24, 2 },
            { 16, 18, 1 },
            { 16, 19, 1 },
            { 17, 25, 1 },
            { 18, 20, 2 },
            { 18, 21, 1 },
            { 19, 30, 1 },
            { 19, 26, 1 },
            { 20, 23, 1 },
            { 20, 24, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 22, 29, 1 },
            { 25, 26, 2 },
            { 26, 32, 1 },
            { 27, 28, 2 },
            { 28, 29, 1 },
            { 30, 31, 1 },
            { 31, 32, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, -0.5954f, 2.0369f),
            tuple<int, float, float>(6, 0.1067f, 1.6036f),
            tuple<int, float, float>(6, 0.9095f, 1.7937f),
            tuple<int, float, float>(6, -0.1301f, 0.8134f),
            tuple<int, float, float>(6, 0.4359f, 0.2131f),
            tuple<int, float, float>(6, -1.2768f, 1.5718f),
            tuple<int, float, float>(8, -2.0667f, 1.771f),
            tuple<int, float, float>(6, -2.5732f, 0.9006f),
            tuple<int, float, float>(6, -1.8434f, 0.2015f),
            tuple<int, float, float>(6, -2.041f, -0.7786f),
            tuple<int, float, float>(6, -1.0523f, -1.0654f),
            tuple<int, float, float>(6, -0.4916f, -0.4603f),
            tuple<int, float, float>(6, 0.3129f, -0.6432f),
            tuple<int, float, float>(6, -0.8088f, -1.8537f),
            tuple<int, float, float>(6, -0.0044f, -2.0369f),
            tuple<int, float, float>(6, 0.5568f, -1.4313f),
            tuple<int, float, float>(8, 1.509f, -1.201f),
            tuple<int, float, float>(6, 1.2387f, 0.4032f),
            tuple<int, float, float>(6, 1.4755f, 1.1935f),
            tuple<int, float, float>(6, 1.9171f, -0.0662f),
            tuple<int, float, float>(6, 2.5732f, 0.4339f),
            tuple<int, float, float>(6, 2.2928f, 1.2146f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 2 },
            { 1, 3, 1 },
            { 2, 18, 1 },
            { 3, 4, 2 },
            { 4, 17, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 2 },
            { 10, 13, 1 },
            { 11, 12, 1 },
            { 12, 15, 2 },
            { 13, 14, 2 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 19, 1 },
            { 17, 18, 2 },
            { 17, 19, 1 },
            { 18, 21, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 12> atoms = {{
            tuple<int, float, float>(6, 0.6671f, 1.194f),
            tuple<int, float, float>(6, 1.3729f, 0.7668f),
            tuple<int, float, float>(6, 1.6278f, -0.0178f),
            tuple<int, float, float>(6, -0.1463f, 1.056f),
            tuple<int, float, float>(6, -0.6717f, 0.42f),
            tuple<int, float, float>(6, -1.4563f, 0.165f),
            tuple<int, float, float>(6, -1.6278f, -0.6419f),
            tuple<int, float, float>(6, -1.0147f, -1.194f),
            tuple<int, float, float>(7, -0.2301f, -0.939f),
            tuple<int, float, float>(6, -0.0586f, -0.1321f),
            tuple<int, float, float>(6, 0.5688f, -1.1448f),
            tuple<int, float, float>(6, 1.308f, -0.7783f)
        }};
        std::array<std::array<int, 3>, 13> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 11, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 8, 10, 1 },
            { 10, 11, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 13> atoms = {{
            tuple<int, float, float>(6, 0.7206f, 1.0259f),
            tuple<int, float, float>(6, 0.0041f, 0.617f),
            tuple<int, float, float>(6, -0.0f, -0.208f),
            tuple<int, float, float>(6, 0.7124f, -0.6241f),
            tuple<int, float, float>(6, 1.4289f, -0.2152f),
            tuple<int, float, float>(6, 1.433f, 0.6098f),
            tuple<int, float, float>(6, -0.7083f, 1.033f),
            tuple<int, float, float>(6, -1.4248f, 0.6241f),
            tuple<int, float, float>(6, -1.4289f, -0.2009f),
            tuple<int, float, float>(6, -0.7165f, -0.617f),
            tuple<int, float, float>(6, -0.7124f, 0.208f),
            tuple<int, float, float>(6, -0.0041f, -1.033f),
            tuple<int, float, float>(6, -1.433f, -1.0259f)
        }};
        std::array<std::array<int, 3>, 16> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 1, 6, 1 },
            { 2, 3, 1 },
            { 2, 9, 1 },
            { 2, 11, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 },
            { 6, 10, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 8, 12, 1 },
            { 10, 12, 1 },
            { 11, 12, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 31> atoms = {{
            tuple<int, float, float>(6, 2.9876f, -0.7593f),
            tuple<int, float, float>(7, 3.2265f, 0.0303f),
            tuple<int, float, float>(6, 2.5493f, 0.5015f),
            tuple<int, float, float>(7, 1.8919f, 0.0031f),
            tuple<int, float, float>(6, 2.1628f, -0.7762f),
            tuple<int, float, float>(6, 1.0816f, 0.1581f),
            tuple<int, float, float>(6, 0.8107f, 0.9374f),
            tuple<int, float, float>(6, 1.3501f, 1.5616f),
            tuple<int, float, float>(6, 1.0792f, 2.3409f),
            tuple<int, float, float>(6, 0.2689f, 2.4959f),
            tuple<int, float, float>(6, -0.2705f, 1.8716f),
            tuple<int, float, float>(6, 0.0004f, 1.0924f),
            tuple<int, float, float>(8, -1.0689f, 2.0308f),
            tuple<int, float, float>(6, -1.6083f, 1.4066f),
            tuple<int, float, float>(6, -1.3374f, 0.6273f),
            tuple<int, float, float>(6, -1.8768f, 0.0031f),
            tuple<int, float, float>(6, -2.6871f, 0.1581f),
            tuple<int, float, float>(6, -2.958f, 0.9374f),
            tuple<int, float, float>(6, -2.4186f, 1.5616f),
            tuple<int, float, float>(6, -3.2265f, -0.4661f),
            tuple<int, float, float>(6, -2.9556f, -1.2454f),
            tuple<int, float, float>(6, -2.1453f, -1.4004f),
            tuple<int, float, float>(6, -1.6059f, -0.7762f),
            tuple<int, float, float>(7, -0.7956f, -0.9312f),
            tuple<int, float, float>(6, -0.5247f, -1.7104f),
            tuple<int, float, float>(6, 0.2856f, -1.8655f),
            tuple<int, float, float>(6, 0.5591f, -1.0871f),
            tuple<int, float, float>(6, -0.0651f, -0.5477f),
            tuple<int, float, float>(7, 0.8178f, -2.4959f),
            tuple<int, float, float>(6, 1.597f, -2.225f),
            tuple<int, float, float>(6, 1.6234f, -1.4004f)
        }};
        std::array<std::array<int, 3>, 36> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 2 },
            { 1, 2, 2 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 5, 1 },
            { 4, 30, 1 },
            { 5, 6, 1 },
            { 6, 7, 2 },
            { 6, 11, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 2 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 2 },
            { 15, 22, 1 },
            { 16, 17, 1 },
            { 16, 19, 1 },
            { 17, 18, 2 },
            { 19, 20, 2 },
            { 20, 21, 1 },
            { 21, 22, 2 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 23, 27, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 },
            { 25, 28, 1 },
            { 26, 27, 1 },
            { 28, 29, 1 },
            { 29, 30, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 24> atoms = {{
            tuple<int, float, float>(6, -1.5713f, -2.1854f),
            tuple<int, float, float>(6, -1.5713f, -1.3604f),
            tuple<int, float, float>(6, -0.8568f, -2.5979f),
            tuple<int, float, float>(6, -0.1424f, -2.1854f),
            tuple<int, float, float>(6, -0.1424f, -1.3604f),
            tuple<int, float, float>(6, -0.8568f, -0.9479f),
            tuple<int, float, float>(6, 0.5721f, -2.5979f),
            tuple<int, float, float>(6, 1.2866f, -2.1854f),
            tuple<int, float, float>(6, 1.2866f, -1.3604f),
            tuple<int, float, float>(6, 0.5721f, -0.9479f),
            tuple<int, float, float>(6, 1.4548f, -0.4804f),
            tuple<int, float, float>(6, 2.1692f, -0.8929f),
            tuple<int, float, float>(6, 2.1692f, -1.7179f),
            tuple<int, float, float>(6, -0.6433f, -1.801f),
            tuple<int, float, float>(6, -0.4443f, -0.2334f),
            tuple<int, float, float>(6, -0.4443f, 0.5916f),
            tuple<int, float, float>(6, -1.1588f, 1.0041f),
            tuple<int, float, float>(6, -1.5713f, 0.2896f),
            tuple<int, float, float>(6, -1.5713f, -0.5354f),
            tuple<int, float, float>(6, -0.5754f, 1.5875f),
            tuple<int, float, float>(7, -0.789f, 2.3843f),
            tuple<int, float, float>(6, -1.5859f, 2.5979f),
            tuple<int, float, float>(6, -2.1692f, 2.0145f),
            tuple<int, float, float>(6, -1.9557f, 1.2176f)
        }};
        std::array<std::array<int, 3>, 28> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 5, 1 },
            { 2, 3, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 14, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 16, 19, 1 },
            { 16, 23, 1 },
            { 17, 18, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 27> atoms = {{
            tuple<int, float, float>(6, -2.5006f, 1.8351f),
            tuple<int, float, float>(6, -2.5006f, 1.0101f),
            tuple<int, float, float>(6, -1.7862f, 0.5976f),
            tuple<int, float, float>(6, -1.0717f, 1.0101f),
            tuple<int, float, float>(6, -1.0717f, 1.8351f),
            tuple<int, float, float>(6, -1.7862f, 2.2476f),
            tuple<int, float, float>(6, -0.3572f, 0.5976f),
            tuple<int, float, float>(6, 0.3572f, 1.0101f),
            tuple<int, float, float>(6, 0.3572f, 1.8351f),
            tuple<int, float, float>(6, -0.3572f, 2.2476f),
            tuple<int, float, float>(6, 1.0717f, 0.5976f),
            tuple<int, float, float>(6, 1.0717f, -0.2274f),
            tuple<int, float, float>(6, 1.7862f, -0.6399f),
            tuple<int, float, float>(6, 2.5006f, -0.2274f),
            tuple<int, float, float>(6, 2.5006f, 0.5976f),
            tuple<int, float, float>(6, 1.7862f, 1.0101f),
            tuple<int, float, float>(6, 0.4586f, -0.7794f),
            tuple<int, float, float>(6, 0.7942f, -1.5331f),
            tuple<int, float, float>(6, 1.6147f, -1.4469f),
            tuple<int, float, float>(6, 0.3817f, -2.2476f),
            tuple<int, float, float>(6, -0.4708f, -2.2476f),
            tuple<int, float, float>(6, -0.9883f, -1.678f),
            tuple<int, float, float>(6, -1.0477f, -0.8552f),
            tuple<int, float, float>(6, -1.8486f, -0.6573f),
            tuple<int, float, float>(6, -2.2843f, -1.3579f),
            tuple<int, float, float>(6, -1.7526f, -1.9888f),
            tuple<int, float, float>(6, -2.3115f, 0.0256f)
        }};
        std::array<std::array<int, 3>, 32> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 26, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 10, 1 },
            { 8, 9, 1 },
            { 10, 11, 1 },
            { 10, 15, 1 },
            { 11, 12, 1 },
            { 11, 16, 1 },
            { 12, 13, 1 },
            { 12, 18, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 17, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 21, 25, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 23, 26, 1 },
            { 24, 25, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, -1.7862f, -0.825f),
            tuple<int, float, float>(6, -2.5006f, -0.4125f),
            tuple<int, float, float>(6, -2.5006f, 0.4125f),
            tuple<int, float, float>(6, -1.7862f, 0.825f),
            tuple<int, float, float>(6, -1.0717f, 0.4125f),
            tuple<int, float, float>(6, -1.0717f, -0.4125f),
            tuple<int, float, float>(7, -0.3572f, 0.825f),
            tuple<int, float, float>(6, -0.3572f, 1.65f),
            tuple<int, float, float>(7, 0.3572f, 2.0625f),
            tuple<int, float, float>(6, 1.0717f, 1.65f),
            tuple<int, float, float>(7, 1.0717f, 0.825f),
            tuple<int, float, float>(6, 1.7862f, 0.4125f),
            tuple<int, float, float>(6, 2.5006f, 0.825f),
            tuple<int, float, float>(7, 2.5006f, 1.65f),
            tuple<int, float, float>(6, 1.7862f, 2.0625f),
            tuple<int, float, float>(8, 1.7862f, -0.4125f),
            tuple<int, float, float>(6, 2.3054f, -1.0536f),
            tuple<int, float, float>(6, 1.8929f, -1.7681f),
            tuple<int, float, float>(6, 1.0717f, -1.65f),
            tuple<int, float, float>(6, 0.3572f, -2.0625f),
            tuple<int, float, float>(6, -0.3572f, -1.65f),
            tuple<int, float, float>(8, -0.3572f, -0.825f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 2 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 2 },
            { 3, 4, 1 },
            { 4, 5, 2 },
            { 4, 6, 1 },
            { 5, 21, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 2 },
            { 9, 14, 1 },
            { 10, 11, 1 },
            { 11, 12, 2 },
            { 11, 15, 1 },
            { 12, 13, 1 },
            { 13, 14, 2 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, -0.9687f, 0.294f),
            tuple<int, float, float>(6, -1.7749f, 0.119f),
            tuple<int, float, float>(6, -2.0264f, -0.6668f),
            tuple<int, float, float>(6, -1.4717f, -1.2774f),
            tuple<int, float, float>(6, -0.6655f, -1.1024f),
            tuple<int, float, float>(6, -0.414f, -0.3166f),
            tuple<int, float, float>(8, 0.0041f, -1.5844f),
            tuple<int, float, float>(6, 0.6694f, -1.0965f),
            tuple<int, float, float>(6, 0.411f, -0.313f),
            tuple<int, float, float>(6, 0.9603f, 0.3025f),
            tuple<int, float, float>(6, 1.768f, 0.1345f),
            tuple<int, float, float>(6, 2.0264f, -0.649f),
            tuple<int, float, float>(6, 1.4771f, -1.2645f),
            tuple<int, float, float>(6, 0.9517f, 1.1274f),
            tuple<int, float, float>(7, 0.3748f, 1.5844f),
            tuple<int, float, float>(6, -0.4444f, 1.3835f),
            tuple<int, float, float>(6, -0.6449f, 0.6594f)
        }};
        std::array<std::array<int, 3>, 20> bonds = {{
            { 0, 1, 2 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 5, 8, 1 },
            { 5, 16, 1 },
            { 6, 7, 1 },
            { 7, 8, 2 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 9, 10, 2 },
            { 9, 13, 1 },
            { 10, 11, 1 },
            { 11, 12, 2 },
            { 13, 14, 2 },
            { 14, 15, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 36> atoms = {{
            tuple<int, float, float>(6, -1.5817f, 0.3446f),
            tuple<int, float, float>(8, -1.1692f, -0.3699f),
            tuple<int, float, float>(6, -1.5817f, -1.0843f),
            tuple<int, float, float>(6, -2.3519f, -1.38f),
            tuple<int, float, float>(7, -2.3519f, -2.205f),
            tuple<int, float, float>(6, -1.5817f, -2.5006f),
            tuple<int, float, float>(6, -1.1692f, -3.2151f),
            tuple<int, float, float>(6, -3.0664f, -2.6175f),
            tuple<int, float, float>(6, -3.7808f, -2.205f),
            tuple<int, float, float>(6, -3.7808f, -1.38f),
            tuple<int, float, float>(6, -3.0664f, -0.9675f),
            tuple<int, float, float>(6, -1.1692f, 1.0591f),
            tuple<int, float, float>(6, -1.5817f, 1.7862f),
            tuple<int, float, float>(6, -1.1692f, 2.5006f),
            tuple<int, float, float>(6, -0.3442f, 2.5006f),
            tuple<int, float, float>(6, 0.0683f, 3.2151f),
            tuple<int, float, float>(6, 0.8933f, 3.2151f),
            tuple<int, float, float>(6, 1.3058f, 3.9296f),
            tuple<int, float, float>(6, 2.1308f, 3.9296f),
            tuple<int, float, float>(6, 2.5433f, 3.2151f),
            tuple<int, float, float>(6, 3.3683f, 3.2151f),
            tuple<int, float, float>(6, 3.7808f, 2.5006f),
            tuple<int, float, float>(6, 3.3683f, 1.7862f),
            tuple<int, float, float>(6, 3.7808f, 1.0717f),
            tuple<int, float, float>(6, 3.3683f, 0.3572f),
            tuple<int, float, float>(6, 3.7808f, -0.3572f),
            tuple<int, float, float>(6, 3.3683f, -1.0717f),
            tuple<int, float, float>(6, 2.5433f, -1.0717f),
            tuple<int, float, float>(6, 2.1308f, -1.7862f),
            tuple<int, float, float>(6, 1.3058f, -1.7862f),
            tuple<int, float, float>(6, 0.8933f, -2.5006f),
            tuple<int, float, float>(8, 0.0683f, -2.5006f),
            tuple<int, float, float>(6, 1.3058f, -3.2151f),
            tuple<int, float, float>(6, 0.8933f, -3.9296f),
            tuple<int, float, float>(6, 0.0683f, -3.9296f),
            tuple<int, float, float>(6, -0.3442f, -3.2151f)
        }};
        std::array<std::array<int, 3>, 38> bonds = {{
            { 0, 1, 1 },
            { 0, 11, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 10, 1 },
            { 4, 5, 1 },
            { 4, 7, 1 },
            { 5, 6, 1 },
            { 6, 35, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 2 },
            { 23, 24, 1 },
            { 24, 25, 2 },
            { 25, 26, 1 },
            { 26, 27, 2 },
            { 27, 28, 1 },
            { 28, 29, 1 },
            { 29, 30, 1 },
            { 30, 31, 1 },
            { 30, 32, 1 },
            { 31, 35, 1 },
            { 32, 33, 1 },
            { 33, 34, 1 },
            { 34, 35, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 8> atoms = {{
            tuple<int, float, float>(26, -5.7389f, 2.4841f),
            tuple<int, float, float>(16, -4.5017f, 3.1984f),
            tuple<int, float, float>(26, -4.5017f, 4.627f),
            tuple<int, float, float>(16, -5.7389f, 5.3413f),
            tuple<int, float, float>(26, -6.9761f, 4.627f),
            tuple<int, float, float>(16, -6.9761f, 3.1984f),
            tuple<int, float, float>(26, -6.2969f, 3.8639f),
            tuple<int, float, float>(16, -4.8637f, 3.9143f)
        }};
        std::array<std::array<int, 3>, 15> bonds = {{
            { 0, 1, 1 },
            { 0, 7, 1 },
            { 0, 5, 1 },
            { 0, 6, 1 },
            { 1, 2, 1 },
            { 1, 6, 1 },
            { 2, 3, 1 },
            { 2, 6, 1 },
            { 2, 7, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 4, 7, 1 },
            { 5, 6, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 16> atoms = {{
            tuple<int, float, float>(6, 0.054f, -2.4738f),
            tuple<int, float, float>(6, 1.276f, -3.2135f),
            tuple<int, float, float>(6, 0.7411f, -1.2213f),
            tuple<int, float, float>(7, -1.3742f, -2.5049f),
            tuple<int, float, float>(6, 2.6845f, -2.9747f),
            tuple<int, float, float>(6, 3.5944f, -1.8734f),
            tuple<int, float, float>(6, 3.5633f, -0.4452f),
            tuple<int, float, float>(6, 2.6062f, 0.6154f),
            tuple<int, float, float>(6, 1.1886f, 0.7924f),
            tuple<int, float, float>(7, 0.0f, 0.0f),
            tuple<int, float, float>(6, -1.4282f, -0.0312f),
            tuple<int, float, float>(6, -2.1153f, -1.2836f),
            tuple<int, float, float>(6, 3.4683f, 1.7546f),
            tuple<int, float, float>(6, 2.9127f, 3.0707f),
            tuple<int, float, float>(6, 1.4952f, 3.2477f),
            tuple<int, float, float>(6, 0.6331f, 2.1085f)
        }};
        std::array<std::array<int, 3>, 18> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 0, 3, 1 },
            { 1, 4, 1 },
            { 2, 9, 1 },
            { 3, 11, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 8, 9, 1 },
            { 8, 15, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 12> atoms = {{
            tuple<int, float, float>(6, 0.3959f, -0.7295f),
            tuple<int, float, float>(6, -0.3098f, -1.1567f),
            tuple<int, float, float>(6, -1.1232f, -1.0188f),
            tuple<int, float, float>(6, -1.6487f, -0.3828f),
            tuple<int, float, float>(6, -1.6307f, 0.442f),
            tuple<int, float, float>(6, -1.078f, 1.0545f),
            tuple<int, float, float>(6, -0.2593f, 1.1567f),
            tuple<int, float, float>(7, 0.4271f, 0.6991f),
            tuple<int, float, float>(6, -0.0009f, -0.0062f),
            tuple<int, float, float>(6, 1.2519f, 0.6811f),
            tuple<int, float, float>(6, 1.6487f, -0.0422f),
            tuple<int, float, float>(7, 1.2207f, -0.7475f)
        }};
        std::array<std::array<int, 3>, 13> bonds = {{
            { 0, 1, 1 },
            { 0, 8, 1 },
            { 0, 11, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 26> atoms = {{
            tuple<int, float, float>(6, 0.1992f, 1.5479f),
            tuple<int, float, float>(8, 0.7062f, 2.1987f),
            tuple<int, float, float>(6, 1.5206f, 2.0665f),
            tuple<int, float, float>(6, 1.7957f, 1.2887f),
            tuple<int, float, float>(6, 1.3309f, 0.6071f),
            tuple<int, float, float>(6, 0.5266f, 0.7907f),
            tuple<int, float, float>(6, 2.6183f, 1.2271f),
            tuple<int, float, float>(6, 2.9763f, 0.4838f),
            tuple<int, float, float>(6, 2.5116f, -0.1979f),
            tuple<int, float, float>(6, 1.6889f, -0.1362f),
            tuple<int, float, float>(6, 1.3309f, -0.8795f),
            tuple<int, float, float>(6, 0.5266f, -1.0631f),
            tuple<int, float, float>(6, -0.0064f, -0.1362f),
            tuple<int, float, float>(6, -0.1184f, -0.5487f),
            tuple<int, float, float>(6, -0.1184f, 0.2763f),
            tuple<int, float, float>(6, -0.8329f, 0.6888f),
            tuple<int, float, float>(6, -1.5474f, 0.2763f),
            tuple<int, float, float>(6, -1.5474f, -0.5487f),
            tuple<int, float, float>(6, -0.8329f, -0.9612f),
            tuple<int, float, float>(6, -0.8329f, -1.7862f),
            tuple<int, float, float>(6, -1.5474f, -2.1987f),
            tuple<int, float, float>(6, -2.2618f, -1.7862f),
            tuple<int, float, float>(6, -2.2618f, -0.9612f),
            tuple<int, float, float>(6, -2.9763f, -0.5487f),
            tuple<int, float, float>(8, -2.9763f, 0.2763f),
            tuple<int, float, float>(6, -2.2618f, 0.6888f)
        }};
        std::array<std::array<int, 3>, 32> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 2 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 12, 1 },
            { 5, 14, 1 },
            { 6, 7, 2 },
            { 7, 8, 1 },
            { 8, 9, 2 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 11, 13, 1 },
            { 13, 14, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 16, 25, 1 },
            { 17, 18, 2 },
            { 17, 22, 1 },
            { 18, 19, 1 },
            { 19, 20, 2 },
            { 20, 21, 1 },
            { 21, 22, 2 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 19> atoms = {{
            tuple<int, float, float>(6, -1.1536f, -1.4947f),
            tuple<int, float, float>(6, -1.9579f, -1.3111f),
            tuple<int, float, float>(6, -2.3159f, -0.5678f),
            tuple<int, float, float>(6, -1.2316f, -0.2195f),
            tuple<int, float, float>(6, -1.9579f, 0.1755f),
            tuple<int, float, float>(6, -1.1536f, 0.3591f),
            tuple<int, float, float>(6, -0.5086f, -0.1553f),
            tuple<int, float, float>(6, -0.5086f, -0.9803f),
            tuple<int, float, float>(6, 0.2058f, 0.2572f),
            tuple<int, float, float>(6, 0.9203f, -0.1553f),
            tuple<int, float, float>(6, 1.6348f, 0.2572f),
            tuple<int, float, float>(6, 2.3159f, -0.027f),
            tuple<int, float, float>(6, 1.787601f, -0.327842f),
            tuple<int, float, float>(6, 0.954927f, 0.36928f),
            tuple<int, float, float>(6, 1.6348f, 1.0822f),
            tuple<int, float, float>(8, 0.9203f, 1.4947f),
            tuple<int, float, float>(6, 0.2058f, 1.0822f),
            tuple<int, float, float>(6, 0.9203f, -0.9803f),
            tuple<int, float, float>(6, 0.2058f, -1.3928f)
        }};
        std::array<std::array<int, 3>, 23> bonds = {{
            { 0, 1, 1 },
            { 0, 7, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 4, 1 },
            { 3, 7, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 6, 8, 1 },
            { 7, 18, 1 },
            { 8, 9, 1 },
            { 8, 13, 1 },
            { 8, 16, 1 },
            { 9, 10, 1 },
            { 9, 17, 1 },
            { 10, 11, 1 },
            { 10, 14, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 17, 18, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 14> atoms = {{
            tuple<int, float, float>(7, 1.4289f, -0.4125f),
            tuple<int, float, float>(8, 1.4289f, 0.4125f),
            tuple<int, float, float>(6, 0.7145f, -0.825f),
            tuple<int, float, float>(6, 0.0f, -0.4125f),
            tuple<int, float, float>(6, 0.0f, 0.4125f),
            tuple<int, float, float>(6, 0.7145f, 0.825f),
            tuple<int, float, float>(6, 1.0565f, 0.3094f),
            tuple<int, float, float>(6, 1.0565f, -0.3094f),
            tuple<int, float, float>(6, -0.7145f, 0.825f),
            tuple<int, float, float>(7, -1.4289f, 0.4125f),
            tuple<int, float, float>(7, -1.4289f, -0.4125f),
            tuple<int, float, float>(6, -0.7145f, -0.825f),
            tuple<int, float, float>(6, -1.0565f, -0.3094f),
            tuple<int, float, float>(6, -1.0565f, 0.3094f)
        }};
        std::array<std::array<int, 3>, 17> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 5, 1 },
            { 2, 3, 1 },
            { 2, 7, 1 },
            { 3, 4, 1 },
            { 3, 11, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 2 },
            { 8, 9, 1 },
            { 8, 13, 1 },
            { 9, 10, 2 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, 0.9645f, -1.0314f),
            tuple<int, float, float>(6, 1.7715f, -0.8599f),
            tuple<int, float, float>(6, 2.0264f, -0.0753f),
            tuple<int, float, float>(6, 1.4744f, 0.5378f),
            tuple<int, float, float>(6, 0.9081f, 1.0314f),
            tuple<int, float, float>(8, 0.0831f, 0.3439f),
            tuple<int, float, float>(6, 0.6674f, 0.3663f),
            tuple<int, float, float>(6, -0.0f, 0.8512f),
            tuple<int, float, float>(6, -0.6674f, 0.3663f),
            tuple<int, float, float>(6, -0.4125f, -0.4183f),
            tuple<int, float, float>(6, 0.4125f, -0.4183f),
            tuple<int, float, float>(6, -1.4744f, 0.5378f),
            tuple<int, float, float>(6, -2.0264f, -0.0753f),
            tuple<int, float, float>(6, -1.5932f, -0.5171f),
            tuple<int, float, float>(6, -0.988f, -0.6457f),
            tuple<int, float, float>(6, -1.7715f, -0.8599f),
            tuple<int, float, float>(6, -0.9645f, -1.0314f)
        }};
        std::array<std::array<int, 3>, 21> bonds = {{
            { 0, 1, 1 },
            { 0, 10, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 5, 10, 1 },
            { 6, 7, 1 },
            { 6, 10, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 8, 11, 2 },
            { 9, 10, 1 },
            { 9, 14, 1 },
            { 9, 16, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 12, 15, 1 },
            { 13, 14, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 16> atoms = {{
            tuple<int, float, float>(7, -0.9959f, 1.5792f),
            tuple<int, float, float>(6, -1.5792f, 0.9959f),
            tuple<int, float, float>(6, -0.9959f, 0.4125f),
            tuple<int, float, float>(6, -0.4125f, 0.9959f),
            tuple<int, float, float>(6, -0.4125f, -0.1709f),
            tuple<int, float, float>(6, 0.1709f, 0.4125f),
            tuple<int, float, float>(6, -0.9959f, -0.4125f),
            tuple<int, float, float>(6, -0.4125f, -0.9959f),
            tuple<int, float, float>(6, 0.4125f, -0.9959f),
            tuple<int, float, float>(6, 0.9959f, -0.4125f),
            tuple<int, float, float>(6, 0.9959f, 0.4125f),
            tuple<int, float, float>(6, 0.4125f, 0.9959f),
            tuple<int, float, float>(6, 1.1026f, -0.8109f),
            tuple<int, float, float>(6, 0.510524f, -1.402976f),
            tuple<int, float, float>(7, 1.5792f, -0.9959f),
            tuple<int, float, float>(7, 0.9959f, -1.5792f)
        }};
        std::array<std::array<int, 3>, 20> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 4, 1 },
            { 2, 6, 1 },
            { 3, 5, 1 },
            { 3, 11, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 8, 13, 1 },
            { 8, 15, 1 },
            { 9, 10, 1 },
            { 9, 12, 1 },
            { 9, 14, 1 },
            { 10, 11, 1 },
            { 12, 13, 1 },
            { 14, 15, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 10> atoms = {{
            tuple<int, float, float>(6, 0.0f, 0.0f),
            tuple<int, float, float>(6, 1.7143f, 0.8571f),
            tuple<int, float, float>(7, -1.4286f, 0.4286f),
            tuple<int, float, float>(7, 0.1429f, -1.4286f),
            tuple<int, float, float>(6, 1.5714f, 2.2857f),
            tuple<int, float, float>(6, 3.1429f, 0.4286f),
            tuple<int, float, float>(6, 0.1429f, 2.2857f),
            tuple<int, float, float>(6, 0.0f, 0.8571f),
            tuple<int, float, float>(6, 1.7143f, 0.0f),
            tuple<int, float, float>(6, 1.5714f, -1.4286f)
        }};
        std::array<std::array<int, 3>, 12> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 0, 3, 1 },
            { 1, 4, 1 },
            { 1, 5, 1 },
            { 2, 7, 1 },
            { 3, 9, 1 },
            { 4, 6, 1 },
            { 5, 8, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 10> atoms = {{
            tuple<int, float, float>(7, -0.3709f, 2.6749f),
            tuple<int, float, float>(7, 0.8663f, 3.1035f),
            tuple<int, float, float>(8, -0.3709f, 1.2463f),
            tuple<int, float, float>(7, 2.1035f, 2.6749f),
            tuple<int, float, float>(6, 1.5806f, 2.152f),
            tuple<int, float, float>(6, 2.1035f, 1.2463f),
            tuple<int, float, float>(6, 0.8663f, 0.8178f),
            tuple<int, float, float>(6, 2.8178f, 0.2949f),
            tuple<int, float, float>(6, 0.3434f, 0.2949f),
            tuple<int, float, float>(6, 1.5806f, 0.7234f)
        }};
        std::array<std::array<int, 3>, 12> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 3, 1 },
            { 1, 4, 1 },
            { 2, 8, 1 },
            { 2, 6, 1 },
            { 3, 5, 1 },
            { 4, 9, 1 },
            { 5, 6, 1 },
            { 5, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 11> atoms = {{
            tuple<int, float, float>(6, 2.2594f, -2.751f),
            tuple<int, float, float>(6, 3.2304f, -1.7031f),
            tuple<int, float, float>(6, 0.9479f, -2.3215f),
            tuple<int, float, float>(6, 0.6005f, -1.1462f),
            tuple<int, float, float>(6, -0.5154f, -2.8288f),
            tuple<int, float, float>(6, -1.5255f, -1.8186f),
            tuple<int, float, float>(6, 1.3803f, -0.3684f),
            tuple<int, float, float>(6, 0.0f, 0.0f),
            tuple<int, float, float>(6, 2.1571f, 0.8305f),
            tuple<int, float, float>(6, 1.257f, 1.9398f),
            tuple<int, float, float>(6, -0.0762f, 1.4265f)
        }};
        std::array<std::array<int, 3>, 13> bonds = {{
            { 0, 1, 2 },
            { 0, 2, 1 },
            { 1, 3, 1 },
            { 2, 6, 1 },
            { 2, 4, 1 },
            { 3, 7, 1 },
            { 3, 5, 1 },
            { 4, 5, 1 },
            { 6, 8, 1 },
            { 6, 7, 2 },
            { 7, 10, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 30> atoms = {{
            tuple<int, float, float>(6, -6.8968f, -2.1736f),
            tuple<int, float, float>(6, -7.7218f, -2.1736f),
            tuple<int, float, float>(6, -7.7218f, -3.6026f),
            tuple<int, float, float>(6, -6.8968f, -3.6026f),
            tuple<int, float, float>(6, -6.4843f, -2.8881f),
            tuple<int, float, float>(6, -8.2409f, -1.5325f),
            tuple<int, float, float>(6, -9.0111f, -1.8281f),
            tuple<int, float, float>(8, -8.968f, -2.652f),
            tuple<int, float, float>(6, -8.1343f, -2.8881f),
            tuple<int, float, float>(8, -9.8669f, -2.1006f),
            tuple<int, float, float>(6, -5.6593f, -1.4591f),
            tuple<int, float, float>(6, -6.4843f, -1.4591f),
            tuple<int, float, float>(6, -5.6593f, -2.8881f),
            tuple<int, float, float>(6, -5.2468f, -2.1736f),
            tuple<int, float, float>(7, -4.4218f, -2.1736f),
            tuple<int, float, float>(6, -3.8973f, -2.7275f),
            tuple<int, float, float>(6, -9.808f, -2.8667f),
            tuple<int, float, float>(6, -10.3457f, -3.3676f),
            tuple<int, float, float>(6, -10.3163f, -4.2515f),
            tuple<int, float, float>(6, -9.7624f, -4.8938f),
            tuple<int, float, float>(6, -9.7624f, -5.7188f),
            tuple<int, float, float>(6, -9.0317f, -6.1843f),
            tuple<int, float, float>(6, -8.2348f, -5.8234f),
            tuple<int, float, float>(6, -7.4376f, -6.1942f),
            tuple<int, float, float>(6, -6.6585f, -5.8529f),
            tuple<int, float, float>(6, -5.7773f, -6.1171f),
            tuple<int, float, float>(6, -3.8447f, -3.6112f),
            tuple<int, float, float>(6, -4.1476f, -4.4059f),
            tuple<int, float, float>(6, -4.9341f, -4.7245f),
            tuple<int, float, float>(6, -5.1329f, -5.5579f)
        }};
        std::array<std::array<int, 3>, 33> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 2 },
            { 0, 11, 1 },
            { 1, 5, 1 },
            { 1, 8, 2 },
            { 2, 8, 1 },
            { 2, 3, 2 },
            { 3, 4, 1 },
            { 4, 12, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 6, 9, 1 },
            { 7, 8, 1 },
            { 9, 16, 1 },
            { 10, 11, 1 },
            { 10, 13, 1 },
            { 12, 13, 2 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 26, 1 },
            { 16, 17, 2 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 },
            { 25, 29, 1 },
            { 26, 27, 2 },
            { 27, 28, 1 },
            { 28, 29, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, -0.0447f, -0.7938f),
            tuple<int, float, float>(6, -0.0447f, -1.6188f),
            tuple<int, float, float>(6, 0.7399f, -1.8737f),
            tuple<int, float, float>(6, 1.2248f, -1.2063f),
            tuple<int, float, float>(6, 0.7399f, -0.5388f),
            tuple<int, float, float>(6, -0.8293f, -0.5388f),
            tuple<int, float, float>(6, -1.3143f, -1.2063f),
            tuple<int, float, float>(6, -0.8293f, -1.8737f),
            tuple<int, float, float>(6, -0.8093f, 0.2458f),
            tuple<int, float, float>(6, -1.4289f, 1.4612f),
            tuple<int, float, float>(6, -1.4289f, 0.6362f),
            tuple<int, float, float>(6, 0.0f, 1.4612f),
            tuple<int, float, float>(6, -0.7145f, 1.8737f),
            tuple<int, float, float>(6, 0.7145f, 0.2237f),
            tuple<int, float, float>(6, 1.4289f, 0.6362f),
            tuple<int, float, float>(6, 1.4289f, 1.4612f),
            tuple<int, float, float>(6, 0.7145f, 1.8737f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 1, 7, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 13, 1 },
            { 5, 6, 1 },
            { 5, 8, 1 },
            { 6, 7, 1 },
            { 8, 10, 1 },
            { 9, 10, 1 },
            { 9, 12, 1 },
            { 11, 12, 1 },
            { 11, 16, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 42> atoms = {{
            tuple<int, float, float>(6, -2.1434f, 2.0625f),
            tuple<int, float, float>(6, -1.4289f, 1.65f),
            tuple<int, float, float>(6, -0.7145f, 2.0625f),
            tuple<int, float, float>(6, -0.7145f, 2.8875f),
            tuple<int, float, float>(7, -1.4289f, 3.3f),
            tuple<int, float, float>(7, -2.1434f, 2.8875f),
            tuple<int, float, float>(6, 0.7145f, 2.0625f),
            tuple<int, float, float>(6, 0.7145f, 2.8875f),
            tuple<int, float, float>(6, 0.0f, 3.3f),
            tuple<int, float, float>(6, 1.4289f, 1.65f),
            tuple<int, float, float>(6, 2.1434f, 2.0625f),
            tuple<int, float, float>(7, 2.1434f, 2.8875f),
            tuple<int, float, float>(7, 1.4289f, 3.3f),
            tuple<int, float, float>(6, -2.8579f, 1.65f),
            tuple<int, float, float>(6, -2.8579f, 0.825f),
            tuple<int, float, float>(7, -3.5724f, 0.4125f),
            tuple<int, float, float>(7, -3.5724f, -0.4125f),
            tuple<int, float, float>(6, -2.1434f, 0.4125f),
            tuple<int, float, float>(6, -2.1434f, -0.4125f),
            tuple<int, float, float>(6, -2.8579f, -0.825f),
            tuple<int, float, float>(7, 2.8579f, 1.65f),
            tuple<int, float, float>(6, 2.8579f, 0.825f),
            tuple<int, float, float>(6, -2.8579f, -1.65f),
            tuple<int, float, float>(6, -2.1434f, -2.0625f),
            tuple<int, float, float>(6, -1.4289f, -1.65f),
            tuple<int, float, float>(6, -0.7145f, -2.0625f),
            tuple<int, float, float>(6, -0.7145f, -2.8875f),
            tuple<int, float, float>(7, -1.4289f, -3.3f),
            tuple<int, float, float>(7, -2.1434f, -2.8875f),
            tuple<int, float, float>(6, 2.1434f, 0.4125f),
            tuple<int, float, float>(6, 2.1434f, -0.4125f),
            tuple<int, float, float>(6, 2.8579f, -0.825f),
            tuple<int, float, float>(7, 3.5724f, -0.4125f),
            tuple<int, float, float>(7, 3.5724f, 0.4125f),
            tuple<int, float, float>(6, 2.8579f, -1.65f),
            tuple<int, float, float>(6, 2.1434f, -2.0625f),
            tuple<int, float, float>(6, 0.0f, -3.3f),
            tuple<int, float, float>(6, 0.7145f, -2.8875f),
            tuple<int, float, float>(6, 0.7145f, -2.0625f),
            tuple<int, float, float>(6, 1.4289f, -1.65f),
            tuple<int, float, float>(7, 2.1434f, -2.8875f),
            tuple<int, float, float>(7, 1.4289f, -3.3f)
        }};
        std::array<std::array<int, 3>, 48> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 0, 13, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 8, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 },
            { 6, 9, 1 },
            { 7, 8, 1 },
            { 7, 12, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 20, 1 },
            { 11, 12, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 17, 1 },
            { 15, 16, 1 },
            { 16, 19, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 22, 1 },
            { 20, 21, 1 },
            { 21, 29, 1 },
            { 21, 33, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 },
            { 23, 28, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 },
            { 26, 27, 1 },
            { 26, 36, 1 },
            { 27, 28, 1 },
            { 29, 30, 1 },
            { 30, 31, 1 },
            { 31, 32, 1 },
            { 31, 34, 1 },
            { 32, 33, 1 },
            { 34, 35, 1 },
            { 35, 39, 1 },
            { 35, 40, 1 },
            { 36, 37, 1 },
            { 37, 38, 1 },
            { 37, 41, 1 },
            { 38, 39, 1 },
            { 40, 41, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 20> atoms = {{
            tuple<int, float, float>(6, 2.0625f, -0.1207f),
            tuple<int, float, float>(6, 1.6494f, 0.5935f),
            tuple<int, float, float>(6, 1.6506f, -0.8355f),
            tuple<int, float, float>(6, 1.6885f, -0.2179f),
            tuple<int, float, float>(6, 1.3787f, 0.3177f),
            tuple<int, float, float>(6, 0.8256f, -0.8361f),
            tuple<int, float, float>(8, 0.001f, -1.384f),
            tuple<int, float, float>(6, -0.8244f, -0.8374f),
            tuple<int, float, float>(6, -1.6494f, -0.838f),
            tuple<int, float, float>(6, -2.0625f, -0.1239f),
            tuple<int, float, float>(6, -1.6506f, 0.5909f),
            tuple<int, float, float>(6, -0.4125f, -0.1226f),
            tuple<int, float, float>(6, -0.8256f, 0.5915f),
            tuple<int, float, float>(6, -0.4136f, 1.3063f),
            tuple<int, float, float>(6, 0.4114f, 1.307f),
            tuple<int, float, float>(6, 0.8244f, 0.5928f),
            tuple<int, float, float>(6, 0.4125f, -0.122f),
            tuple<int, float, float>(7, 1.3363f, 1.384f),
            tuple<int, float, float>(6, 1.8229f, 0.5936f),
            tuple<int, float, float>(6, 1.3375f, -0.1975f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 15, 1 },
            { 2, 3, 1 },
            { 2, 5, 1 },
            { 3, 4, 1 },
            { 4, 15, 1 },
            { 5, 6, 1 },
            { 5, 16, 1 },
            { 6, 7, 1 },
            { 7, 8, 2 },
            { 7, 11, 1 },
            { 8, 9, 1 },
            { 9, 10, 2 },
            { 10, 12, 1 },
            { 11, 12, 2 },
            { 11, 16, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 17, 1 },
            { 15, 16, 1 },
            { 16, 19, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, 2.0625f, -0.1207f),
            tuple<int, float, float>(6, 1.6494f, 0.5935f),
            tuple<int, float, float>(6, 1.6506f, -0.8355f),
            tuple<int, float, float>(6, 0.8256f, -0.8361f),
            tuple<int, float, float>(8, 0.001f, -1.384f),
            tuple<int, float, float>(6, -0.8244f, -0.8374f),
            tuple<int, float, float>(6, -1.6494f, -0.838f),
            tuple<int, float, float>(6, -2.0625f, -0.1239f),
            tuple<int, float, float>(6, -1.6506f, 0.5909f),
            tuple<int, float, float>(6, -0.4125f, -0.1226f),
            tuple<int, float, float>(6, -0.8256f, 0.5915f),
            tuple<int, float, float>(6, -0.4136f, 1.3063f),
            tuple<int, float, float>(6, 0.4114f, 1.307f),
            tuple<int, float, float>(6, 0.8244f, 0.5928f),
            tuple<int, float, float>(6, 0.4125f, -0.122f),
            tuple<int, float, float>(7, 1.3363f, 1.384f),
            tuple<int, float, float>(6, 1.8229f, 0.5936f),
            tuple<int, float, float>(6, 1.3375f, -0.1975f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 13, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 14, 1 },
            { 4, 5, 1 },
            { 5, 6, 2 },
            { 5, 9, 1 },
            { 6, 7, 1 },
            { 7, 8, 2 },
            { 8, 10, 1 },
            { 9, 10, 2 },
            { 9, 14, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 12, 15, 1 },
            { 13, 14, 1 },
            { 14, 17, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 21> atoms = {{
            tuple<int, float, float>(6, -1.4289f, -1.4438f),
            tuple<int, float, float>(6, -1.4289f, -2.2687f),
            tuple<int, float, float>(6, -0.7145f, -2.6812f),
            tuple<int, float, float>(6, 0.0f, -2.2687f),
            tuple<int, float, float>(6, 0.0f, -1.4438f),
            tuple<int, float, float>(6, -0.7145f, -1.0312f),
            tuple<int, float, float>(6, 0.7145f, -2.6812f),
            tuple<int, float, float>(6, 1.4289f, -2.2687f),
            tuple<int, float, float>(6, 1.4289f, -1.4438f),
            tuple<int, float, float>(6, 0.7145f, -1.0312f),
            tuple<int, float, float>(6, 0.7145f, -0.2062f),
            tuple<int, float, float>(6, -0.7145f, -0.2062f),
            tuple<int, float, float>(6, -0.7145f, 1.4438f),
            tuple<int, float, float>(6, -1.4289f, 1.0312f),
            tuple<int, float, float>(6, -1.4289f, 0.2062f),
            tuple<int, float, float>(6, 1.4289f, 0.2062f),
            tuple<int, float, float>(6, 1.4289f, 1.0312f),
            tuple<int, float, float>(6, 0.7145f, 1.4438f),
            tuple<int, float, float>(6, 0.7145f, 2.2687f),
            tuple<int, float, float>(6, 0.0f, 2.6812f),
            tuple<int, float, float>(6, -0.7145f, 2.2687f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 5, 11, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 15, 1 },
            { 11, 14, 1 },
            { 12, 13, 1 },
            { 12, 20, 1 },
            { 13, 14, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 25> atoms = {{
            tuple<int, float, float>(6, 1.7862f, -0.825f),
            tuple<int, float, float>(6, 1.7862f, -1.65f),
            tuple<int, float, float>(6, 2.5006f, -2.0625f),
            tuple<int, float, float>(6, 3.2151f, -1.65f),
            tuple<int, float, float>(6, 3.2151f, -0.825f),
            tuple<int, float, float>(6, 2.5006f, -0.4125f),
            tuple<int, float, float>(6, 1.0717f, -2.0625f),
            tuple<int, float, float>(6, 0.3572f, -1.65f),
            tuple<int, float, float>(6, -0.3572f, -2.0625f),
            tuple<int, float, float>(6, -1.0717f, -1.65f),
            tuple<int, float, float>(6, -1.7862f, -2.0625f),
            tuple<int, float, float>(6, -2.5006f, -1.65f),
            tuple<int, float, float>(6, -2.5006f, -0.825f),
            tuple<int, float, float>(6, -3.2151f, -1.2375f),
            tuple<int, float, float>(6, -1.7862f, -0.4125f),
            tuple<int, float, float>(6, -1.7862f, 0.4125f),
            tuple<int, float, float>(6, -1.0717f, 0.825f),
            tuple<int, float, float>(6, -1.0717f, 1.65f),
            tuple<int, float, float>(6, -0.3572f, 2.0625f),
            tuple<int, float, float>(6, 0.3572f, 1.65f),
            tuple<int, float, float>(6, 1.1817f, -0.3025f),
            tuple<int, float, float>(6, 0.3572f, 0.825f),
            tuple<int, float, float>(6, 1.1419f, 0.5701f),
            tuple<int, float, float>(6, 1.6268f, 1.2375f),
            tuple<int, float, float>(6, 1.1419f, 1.9049f)
        }};
        std::array<std::array<int, 3>, 28> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 0, 20, 1 },
            { 1, 2, 1 },
            { 1, 6, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 11, 13, 1 },
            { 12, 13, 1 },
            { 12, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 21, 1 },
            { 19, 24, 1 },
            { 20, 22, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 20> atoms = {{
            tuple<int, float, float>(6, -1.2612f, -1.5367f),
            tuple<int, float, float>(6, -1.5967f, -0.783f),
            tuple<int, float, float>(6, -0.9836f, -0.2309f),
            tuple<int, float, float>(7, -0.4407f, -1.4504f),
            tuple<int, float, float>(6, -0.2691f, -0.6434f),
            tuple<int, float, float>(6, 0.4453f, -0.2309f),
            tuple<int, float, float>(6, 0.4453f, 0.5941f),
            tuple<int, float, float>(6, 1.089f, 1.1102f),
            tuple<int, float, float>(6, -0.4245f, 1.9077f),
            tuple<int, float, float>(7, -1.7682f, 0.849f),
            tuple<int, float, float>(6, -0.9836f, 0.5941f),
            tuple<int, float, float>(6, -0.2691f, 1.0066f),
            tuple<int, float, float>(6, -2.2532f, 0.1816f),
            tuple<int, float, float>(6, -1.7682f, -0.4859f),
            tuple<int, float, float>(6, 1.8937f, 0.9285f),
            tuple<int, float, float>(6, 2.2532f, 0.1859f),
            tuple<int, float, float>(8, 1.8965f, -0.558f),
            tuple<int, float, float>(6, 1.0924f, -0.7427f),
            tuple<int, float, float>(6, 0.995f, -1.5619f),
            tuple<int, float, float>(6, 0.246f, -1.9077f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 2, 4, 1 },
            { 2, 10, 1 },
            { 2, 13, 1 },
            { 3, 4, 1 },
            { 3, 19, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 5, 17, 1 },
            { 6, 7, 1 },
            { 6, 11, 1 },
            { 7, 8, 1 },
            { 7, 14, 2 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 9, 12, 1 },
            { 10, 11, 1 },
            { 12, 13, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 36> atoms = {{
            tuple<int, float, float>(6, -3.3413f, -1.4289f),
            tuple<int, float, float>(6, -2.5162f, -1.4289f),
            tuple<int, float, float>(6, -2.1038f, -0.7145f),
            tuple<int, float, float>(6, -2.5162f, 0.0f),
            tuple<int, float, float>(6, -3.3413f, 0.0f),
            tuple<int, float, float>(6, -3.7538f, -0.7145f),
            tuple<int, float, float>(6, -2.1038f, 0.7145f),
            tuple<int, float, float>(6, -2.5162f, 1.4289f),
            tuple<int, float, float>(6, -3.3413f, 1.4289f),
            tuple<int, float, float>(6, -3.7538f, 0.7145f),
            tuple<int, float, float>(6, -1.6912f, -1.4289f),
            tuple<int, float, float>(6, -0.8662f, -1.4289f),
            tuple<int, float, float>(6, -1.6912f, 1.4289f),
            tuple<int, float, float>(6, -0.8662f, 1.4289f),
            tuple<int, float, float>(6, -0.4537f, 0.7145f),
            tuple<int, float, float>(6, 0.3713f, 0.7145f),
            tuple<int, float, float>(6, 0.7838f, 1.4289f),
            tuple<int, float, float>(6, 0.3713f, 2.1434f),
            tuple<int, float, float>(6, -0.4537f, 2.1434f),
            tuple<int, float, float>(6, -0.4537f, -2.1434f),
            tuple<int, float, float>(6, 0.3713f, -2.1434f),
            tuple<int, float, float>(6, 0.7838f, -1.4289f),
            tuple<int, float, float>(6, 0.3713f, -0.7145f),
            tuple<int, float, float>(6, -0.4537f, -0.7145f),
            tuple<int, float, float>(6, 1.6912f, -1.4289f),
            tuple<int, float, float>(6, 2.1038f, -0.7145f),
            tuple<int, float, float>(6, 2.5162f, -1.4289f),
            tuple<int, float, float>(6, 3.3413f, -1.4289f),
            tuple<int, float, float>(6, 3.7538f, -0.7145f),
            tuple<int, float, float>(6, 3.3413f, 0.0f),
            tuple<int, float, float>(6, 2.5162f, 0.0f),
            tuple<int, float, float>(6, 3.7538f, 0.7145f),
            tuple<int, float, float>(6, 3.3413f, 1.4289f),
            tuple<int, float, float>(6, 2.5162f, 1.4289f),
            tuple<int, float, float>(6, 2.1038f, 0.7145f),
            tuple<int, float, float>(6, 2.1038f, 2.1434f)
        }};
        std::array<std::array<int, 3>, 42> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 10, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 4, 9, 1 },
            { 6, 7, 1 },
            { 6, 12, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 10, 11, 1 },
            { 11, 19, 1 },
            { 11, 23, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 13, 18, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 17, 35, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 21, 24, 1 },
            { 22, 23, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 },
            { 25, 30, 1 },
            { 26, 27, 1 },
            { 27, 28, 1 },
            { 28, 29, 1 },
            { 29, 30, 1 },
            { 29, 31, 1 },
            { 30, 34, 1 },
            { 31, 32, 1 },
            { 32, 33, 1 },
            { 33, 34, 1 },
            { 33, 35, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 50> atoms = {{
            tuple<int, float, float>(6, -3.1562f, 1.7691f),
            tuple<int, float, float>(6, -2.4417f, 2.1816f),
            tuple<int, float, float>(6, -2.4417f, 3.0066f),
            tuple<int, float, float>(8, -1.7272f, 3.4191f),
            tuple<int, float, float>(6, -3.1562f, 3.4191f),
            tuple<int, float, float>(6, -3.8707f, 3.0066f),
            tuple<int, float, float>(6, -3.8707f, 2.1816f),
            tuple<int, float, float>(6, -4.5851f, 1.7691f),
            tuple<int, float, float>(6, -4.5851f, 0.9441f),
            tuple<int, float, float>(6, -3.8707f, 0.5316f),
            tuple<int, float, float>(7, -3.1562f, 0.9441f),
            tuple<int, float, float>(6, -2.4417f, 0.5316f),
            tuple<int, float, float>(6, -1.7272f, 0.9441f),
            tuple<int, float, float>(7, -1.0128f, 0.5316f),
            tuple<int, float, float>(6, -0.2983f, 0.9441f),
            tuple<int, float, float>(6, 0.4162f, 0.5316f),
            tuple<int, float, float>(7, 1.1306f, 0.9441f),
            tuple<int, float, float>(6, 1.8451f, 0.5316f),
            tuple<int, float, float>(6, 2.5596f, 0.9441f),
            tuple<int, float, float>(7, 3.2741f, 0.5316f),
            tuple<int, float, float>(6, 1.9073f, -0.2911f),
            tuple<int, float, float>(6, 2.6508f, -0.6486f),
            tuple<int, float, float>(6, 2.6139f, -1.4755f),
            tuple<int, float, float>(6, 1.9166f, -1.9164f),
            tuple<int, float, float>(6, 1.1929f, -1.5203f),
            tuple<int, float, float>(6, 1.1881f, -0.6954f),
            tuple<int, float, float>(6, -0.2983f, 1.7691f),
            tuple<int, float, float>(6, 0.4162f, 2.1816f),
            tuple<int, float, float>(6, -1.0128f, 2.1816f),
            tuple<int, float, float>(6, -1.0128f, 3.0066f),
            tuple<int, float, float>(6, -0.2983f, 3.4191f),
            tuple<int, float, float>(6, 0.4162f, 3.0066f),
            tuple<int, float, float>(8, 1.1306f, 3.4191f),
            tuple<int, float, float>(6, 1.8451f, 3.0066f),
            tuple<int, float, float>(6, 1.8451f, 2.1816f),
            tuple<int, float, float>(6, 2.5596f, 1.7691f),
            tuple<int, float, float>(6, 2.5596f, 3.4191f),
            tuple<int, float, float>(6, 3.2741f, 3.0066f),
            tuple<int, float, float>(6, 3.2741f, 2.1816f),
            tuple<int, float, float>(6, 3.9885f, 1.7691f),
            tuple<int, float, float>(6, 3.9885f, 0.9441f),
            tuple<int, float, float>(6, 4.567f, 0.3237f),
            tuple<int, float, float>(7, 4.1338f, -0.3784f),
            tuple<int, float, float>(6, 4.4472f, -1.1416f),
            tuple<int, float, float>(6, 4.0513f, -1.8654f),
            tuple<int, float, float>(6, 3.2396f, -2.0133f),
            tuple<int, float, float>(6, 4.5851f, -2.4944f),
            tuple<int, float, float>(6, 4.3073f, -3.2712f),
            tuple<int, float, float>(6, 3.4957f, -3.4191f),
            tuple<int, float, float>(6, 2.9618f, -2.7901f)
        }};
        std::array<std::array<int, 3>, 57> bonds = {{
            { 0, 1, 2 },
            { 0, 6, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 2, 4, 2 },
            { 3, 29, 1 },
            { 4, 5, 1 },
            { 5, 6, 2 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 26, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 17, 20, 1 },
            { 18, 19, 1 },
            { 19, 40, 1 },
            { 20, 21, 2 },
            { 20, 25, 1 },
            { 21, 22, 1 },
            { 22, 23, 2 },
            { 22, 45, 1 },
            { 23, 24, 1 },
            { 24, 25, 2 },
            { 26, 27, 2 },
            { 26, 28, 1 },
            { 27, 31, 1 },
            { 28, 29, 2 },
            { 29, 30, 1 },
            { 30, 31, 2 },
            { 31, 32, 1 },
            { 32, 33, 1 },
            { 33, 34, 2 },
            { 33, 36, 1 },
            { 34, 35, 1 },
            { 35, 38, 2 },
            { 36, 37, 2 },
            { 37, 38, 1 },
            { 38, 39, 1 },
            { 39, 40, 1 },
            { 40, 41, 1 },
            { 41, 42, 1 },
            { 42, 43, 1 },
            { 43, 44, 1 },
            { 44, 45, 2 },
            { 44, 46, 1 },
            { 45, 49, 1 },
            { 46, 47, 2 },
            { 47, 48, 1 },
            { 48, 49, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 23> atoms = {{
            tuple<int, float, float>(6, -0.442f, -1.5973f),
            tuple<int, float, float>(6, 0.418f, -1.6008f),
            tuple<int, float, float>(6, 1.1001f, -2.0649f),
            tuple<int, float, float>(6, 1.7523f, -1.5596f),
            tuple<int, float, float>(6, 1.4732f, -0.7832f),
            tuple<int, float, float>(7, 0.6486f, -0.8087f),
            tuple<int, float, float>(6, 1.9373f, -0.1011f),
            tuple<int, float, float>(6, 1.6048f, 0.6539f),
            tuple<int, float, float>(6, 2.0202f, 1.3667f),
            tuple<int, float, float>(6, 1.4706f, 1.982f),
            tuple<int, float, float>(6, 0.7156f, 1.6495f),
            tuple<int, float, float>(7, 0.7985f, 0.8287f),
            tuple<int, float, float>(6, 0.0028f, 2.0649f),
            tuple<int, float, float>(6, -0.7133f, 1.6553f),
            tuple<int, float, float>(6, -1.4657f, 1.9939f),
            tuple<int, float, float>(6, -2.0202f, 1.383f),
            tuple<int, float, float>(6, -1.6105f, 0.6669f),
            tuple<int, float, float>(7, -0.8029f, 0.8351f),
            tuple<int, float, float>(6, -1.9491f, -0.0855f),
            tuple<int, float, float>(6, -1.4906f, -0.7713f),
            tuple<int, float, float>(7, -0.6662f, -0.8034f),
            tuple<int, float, float>(6, -1.7758f, -1.5454f),
            tuple<int, float, float>(6, -1.1278f, -2.0559f)
        }};
        std::array<std::array<int, 3>, 27> bonds = {{
            { 0, 1, 1 },
            { 0, 20, 1 },
            { 0, 22, 1 },
            { 1, 2, 1 },
            { 1, 5, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 2 },
            { 4, 6, 1 },
            { 6, 7, 2 },
            { 7, 8, 1 },
            { 7, 11, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 2 },
            { 10, 12, 1 },
            { 12, 13, 2 },
            { 13, 14, 1 },
            { 13, 17, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 2 },
            { 16, 18, 1 },
            { 18, 19, 2 },
            { 19, 20, 1 },
            { 19, 21, 1 },
            { 21, 22, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, 0.0186f, -1.4569f),
            tuple<int, float, float>(6, 0.0952f, -0.6355f),
            tuple<int, float, float>(6, -0.5779f, -0.1584f),
            tuple<int, float, float>(6, -1.3276f, -0.5028f),
            tuple<int, float, float>(7, -1.4042f, -1.3242f),
            tuple<int, float, float>(7, -0.7311f, -1.8013f),
            tuple<int, float, float>(8, -1.8868f, 0.1038f),
            tuple<int, float, float>(6, -1.6411f, 0.8914f),
            tuple<int, float, float>(6, -0.8362f, 1.0723f),
            tuple<int, float, float>(6, -0.4321f, 1.7916f),
            tuple<int, float, float>(6, 0.3929f, 1.8013f),
            tuple<int, float, float>(7, 0.8137f, 1.0917f),
            tuple<int, float, float>(6, 1.6227f, 0.9296f),
            tuple<int, float, float>(6, 1.8868f, 0.1481f),
            tuple<int, float, float>(7, 1.342f, -0.4715f),
            tuple<int, float, float>(6, 1.4378f, -1.2909f),
            tuple<int, float, float>(6, 0.7761f, -1.7836f)
        }};
        std::array<std::array<int, 3>, 18> bonds = {{
            { 0, 1, 2 },
            { 0, 5, 1 },
            { 0, 16, 1 },
            { 1, 2, 1 },
            { 2, 3, 2 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 2 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 22> atoms = {{
            tuple<int, float, float>(6, 1.9567f, 1.6008f),
            tuple<int, float, float>(7, 1.936f, 0.6674f),
            tuple<int, float, float>(6, 1.1514f, 0.4125f),
            tuple<int, float, float>(6, 1.1514f, -0.4125f),
            tuple<int, float, float>(7, 2.421f, 0.0f),
            tuple<int, float, float>(6, 1.936f, -0.6674f),
            tuple<int, float, float>(7, 1.1867f, 2.0133f),
            tuple<int, float, float>(6, 0.4369f, 1.65f),
            tuple<int, float, float>(7, 0.4369f, 0.825f),
            tuple<int, float, float>(7, -0.2775f, 2.0625f),
            tuple<int, float, float>(6, -0.992f, 1.65f),
            tuple<int, float, float>(6, -0.992f, 0.825f),
            tuple<int, float, float>(6, -1.7065f, 0.4125f),
            tuple<int, float, float>(6, -2.421f, 0.825f),
            tuple<int, float, float>(6, -2.4209f, 1.65f),
            tuple<int, float, float>(6, -1.7065f, 2.0625f),
            tuple<int, float, float>(7, -1.7065f, -0.4125f),
            tuple<int, float, float>(6, -0.992f, -0.825f),
            tuple<int, float, float>(6, -0.992f, -1.65f),
            tuple<int, float, float>(6, -0.2775f, -2.0625f),
            tuple<int, float, float>(6, 0.4369f, -1.65f),
            tuple<int, float, float>(6, 0.4369f, -0.825f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 6, 2 },
            { 1, 2, 1 },
            { 1, 4, 1 },
            { 2, 3, 2 },
            { 2, 8, 1 },
            { 3, 5, 1 },
            { 3, 21, 1 },
            { 4, 5, 2 },
            { 6, 7, 1 },
            { 7, 8, 2 },
            { 7, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 2 },
            { 10, 15, 1 },
            { 11, 12, 1 },
            { 12, 13, 2 },
            { 12, 16, 1 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, 0.3572f, 2.0625f),
            tuple<int, float, float>(6, 1.0717f, 1.65f),
            tuple<int, float, float>(7, -0.3572f, 1.65f),
            tuple<int, float, float>(6, -1.0717f, 2.0625f),
            tuple<int, float, float>(6, -1.7862f, 1.65f),
            tuple<int, float, float>(7, -1.7862f, 0.825f),
            tuple<int, float, float>(6, -1.0717f, 0.4125f),
            tuple<int, float, float>(6, -1.0717f, -0.4125f),
            tuple<int, float, float>(6, -0.3572f, -0.825f),
            tuple<int, float, float>(6, -0.3572f, -1.65f),
            tuple<int, float, float>(6, 0.3572f, -2.0625f),
            tuple<int, float, float>(8, 1.0717f, -1.65f),
            tuple<int, float, float>(6, 1.0717f, -0.825f),
            tuple<int, float, float>(7, 1.7862f, -0.4125f),
            tuple<int, float, float>(7, 1.7862f, 0.4125f),
            tuple<int, float, float>(6, 1.0717f, 0.825f),
            tuple<int, float, float>(6, 0.3572f, -0.4125f),
            tuple<int, float, float>(6, 0.3572f, 0.4125f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 15, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 2 },
            { 12, 16, 1 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 15, 17, 1 },
            { 16, 17, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 17> atoms = {{
            tuple<int, float, float>(6, 1.0807f, -0.8666f),
            tuple<int, float, float>(6, 1.8877f, -0.6951f),
            tuple<int, float, float>(6, 2.1426f, 0.0895f),
            tuple<int, float, float>(6, 1.5906f, 0.7026f),
            tuple<int, float, float>(6, 0.9321f, 0.8748f),
            tuple<int, float, float>(8, 0.4263f, 0.4193f),
            tuple<int, float, float>(6, 0.7836f, 0.5311f),
            tuple<int, float, float>(6, 0.1162f, 1.016f),
            tuple<int, float, float>(6, 0.5287f, -0.2535f),
            tuple<int, float, float>(6, -0.2963f, -0.2535f),
            tuple<int, float, float>(6, -0.5513f, 0.5311f),
            tuple<int, float, float>(6, -0.7508f, -0.9421f),
            tuple<int, float, float>(6, -1.5725f, -1.016f),
            tuple<int, float, float>(6, -2.1426f, -0.4197f),
            tuple<int, float, float>(6, -1.0736f, -0.4019f),
            tuple<int, float, float>(6, -2.0319f, 0.3978f),
            tuple<int, float, float>(6, -1.3237f, 0.821f)
        }};
        std::array<std::array<int, 3>, 21> bonds = {{
            { 0, 1, 1 },
            { 0, 8, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 5, 8, 1 },
            { 6, 7, 1 },
            { 6, 8, 1 },
            { 7, 10, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 9, 11, 1 },
            { 10, 14, 1 },
            { 10, 16, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 13, 15, 1 },
            { 15, 16, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 15> atoms = {{
            tuple<int, float, float>(6, -2.0637f, 0.6406f),
            tuple<int, float, float>(6, -1.3492f, 1.0531f),
            tuple<int, float, float>(6, -2.0637f, -0.1844f),
            tuple<int, float, float>(6, -0.8306f, 1.0366f),
            tuple<int, float, float>(6, -1.3492f, -0.5969f),
            tuple<int, float, float>(6, -0.15f, -1.0531f),
            tuple<int, float, float>(6, -0.6348f, -0.1844f),
            tuple<int, float, float>(6, 0.0797f, -0.5969f),
            tuple<int, float, float>(7, -0.6348f, 0.6406f),
            tuple<int, float, float>(6, 0.0797f, 1.0531f),
            tuple<int, float, float>(6, 0.7942f, 0.6406f),
            tuple<int, float, float>(7, 1.5788f, 0.8955f),
            tuple<int, float, float>(6, 2.0637f, 0.2281f),
            tuple<int, float, float>(6, 1.5788f, -0.4393f),
            tuple<int, float, float>(6, 0.7942f, -0.1844f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 8, 1 },
            { 2, 3, 1 },
            { 2, 4, 1 },
            { 3, 9, 1 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 5, 14, 1 },
            { 6, 7, 1 },
            { 6, 8, 1 },
            { 7, 14, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 14, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 16> atoms = {{
            tuple<int, float, float>(6, 1.6245f, -0.1243f),
            tuple<int, float, float>(6, 1.6245f, -0.9493f),
            tuple<int, float, float>(6, 0.91f, -1.3618f),
            tuple<int, float, float>(6, 0.1955f, -0.9493f),
            tuple<int, float, float>(6, -0.3947f, -1.5257f),
            tuple<int, float, float>(6, -1.212f, -1.4132f),
            tuple<int, float, float>(6, -1.6245f, -0.6987f),
            tuple<int, float, float>(8, -0.9301f, -0.9617f),
            tuple<int, float, float>(8, -0.222f, -0.7382f),
            tuple<int, float, float>(8, -1.3133f, 0.0653f),
            tuple<int, float, float>(6, -0.5189f, 0.2882f),
            tuple<int, float, float>(8, -0.5189f, 1.1132f),
            tuple<int, float, float>(6, 0.1955f, 1.5257f),
            tuple<int, float, float>(6, 0.91f, 1.1132f),
            tuple<int, float, float>(6, 0.91f, 0.2882f),
            tuple<int, float, float>(6, 0.1955f, -0.1243f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 14, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 15, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 6, 9, 1 },
            { 7, 8, 1 },
            { 8, 15, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 15, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 11> atoms = {{
            tuple<int, float, float>(6, -0.4849f, 0.54f),
            tuple<int, float, float>(6, 0.0f, 1.2074f),
            tuple<int, float, float>(6, 0.7846f, 0.9525f),
            tuple<int, float, float>(6, 0.7846f, 0.1275f),
            tuple<int, float, float>(6, 0.0f, -0.1275f),
            tuple<int, float, float>(6, 1.2695f, -0.54f),
            tuple<int, float, float>(6, 0.7846f, -1.2074f),
            tuple<int, float, float>(6, 0.0f, -0.9525f),
            tuple<int, float, float>(6, -0.7846f, -1.2074f),
            tuple<int, float, float>(6, -1.2695f, -0.54f),
            tuple<int, float, float>(6, -0.7846f, 0.1275f)
        }};
        std::array<std::array<int, 3>, 13> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 5, 1 },
            { 4, 7, 1 },
            { 4, 10, 1 },
            { 5, 6, 2 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 20> atoms = {{
            tuple<int, float, float>(6, -2.1561f, 0.9057f),
            tuple<int, float, float>(6, -1.9813f, 0.0995f),
            tuple<int, float, float>(8, -1.2419f, -0.2665f),
            tuple<int, float, float>(6, -1.6481f, -0.6327f),
            tuple<int, float, float>(6, -1.6348f, 1.5451f),
            tuple<int, float, float>(6, -0.8098f, 1.5361f),
            tuple<int, float, float>(6, -0.3025f, 0.8856f),
            tuple<int, float, float>(6, -0.4948f, 0.0833f),
            tuple<int, float, float>(6, 0.2894f, 0.2623f),
            tuple<int, float, float>(6, -0.8438f, -0.6414f),
            tuple<int, float, float>(6, -0.4948f, -1.3661f),
            tuple<int, float, float>(6, 0.2894f, -1.5451f),
            tuple<int, float, float>(6, 0.9183f, -1.0436f),
            tuple<int, float, float>(6, 0.9183f, -0.2392f),
            tuple<int, float, float>(6, 1.6833f, -1.2922f),
            tuple<int, float, float>(8, 2.1561f, -0.6414f),
            tuple<int, float, float>(6, 1.6833f, 0.0093f),
            tuple<int, float, float>(6, 1.8013f, 0.8259f),
            tuple<int, float, float>(6, 1.0414f, 1.1469f),
            tuple<int, float, float>(8, 0.5383f, 0.493f)
        }};
        std::array<std::array<int, 3>, 24> bonds = {{
            { 0, 1, 1 },
            { 0, 4, 1 },
            { 1, 2, 1 },
            { 1, 3, 1 },
            { 2, 7, 1 },
            { 3, 9, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 7, 9, 1 },
            { 8, 13, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 12, 14, 1 },
            { 13, 16, 1 },
            { 13, 19, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, -1.6174f, -1.3111f),
            tuple<int, float, float>(6, -0.8131f, -1.4947f),
            tuple<int, float, float>(6, -1.9753f, -0.5678f),
            tuple<int, float, float>(6, -1.1903f, -1.2937f),
            tuple<int, float, float>(6, -1.6174f, 0.1755f),
            tuple<int, float, float>(6, -0.8131f, 0.3591f),
            tuple<int, float, float>(6, -0.1681f, -0.1553f),
            tuple<int, float, float>(6, 0.5464f, 0.2572f),
            tuple<int, float, float>(6, 0.8884f, -0.2584f),
            tuple<int, float, float>(8, 0.8884f, -0.8772f),
            tuple<int, float, float>(6, 1.2609f, -0.1553f),
            tuple<int, float, float>(6, 1.2609f, -0.9803f),
            tuple<int, float, float>(6, 0.5464f, -1.3928f),
            tuple<int, float, float>(6, -0.1681f, -0.9803f),
            tuple<int, float, float>(6, 0.5464f, 1.0822f),
            tuple<int, float, float>(6, 1.2609f, 1.4947f),
            tuple<int, float, float>(6, 1.9753f, 1.0822f),
            tuple<int, float, float>(6, 1.9753f, 0.2572f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 13, 1 },
            { 2, 3, 1 },
            { 2, 4, 1 },
            { 3, 13, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 6, 13, 1 },
            { 7, 8, 1 },
            { 7, 10, 1 },
            { 7, 14, 1 },
            { 8, 9, 1 },
            { 9, 12, 1 },
            { 10, 11, 1 },
            { 10, 17, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 23> atoms = {{
            tuple<int, float, float>(6, -1.0717f, 2.2687f),
            tuple<int, float, float>(6, -1.7862f, 1.8562f),
            tuple<int, float, float>(6, -1.7862f, 1.0312f),
            tuple<int, float, float>(6, -1.0717f, 0.6187f),
            tuple<int, float, float>(6, -0.3572f, 1.0312f),
            tuple<int, float, float>(6, -0.3572f, 1.8562f),
            tuple<int, float, float>(8, 0.3572f, 1.4437f),
            tuple<int, float, float>(6, 0.3572f, 0.6187f),
            tuple<int, float, float>(6, 1.0717f, 1.0312f),
            tuple<int, float, float>(6, 1.0717f, 1.8562f),
            tuple<int, float, float>(6, 0.3572f, 2.2687f),
            tuple<int, float, float>(8, -0.3572f, 0.2063f),
            tuple<int, float, float>(6, -0.3572f, -0.6187f),
            tuple<int, float, float>(6, 0.3572f, -1.0312f),
            tuple<int, float, float>(6, 0.3572f, -1.8562f),
            tuple<int, float, float>(6, -0.3572f, -2.2687f),
            tuple<int, float, float>(6, -1.0717f, -1.8562f),
            tuple<int, float, float>(6, -1.0717f, -1.0312f),
            tuple<int, float, float>(6, 1.0717f, -2.2687f),
            tuple<int, float, float>(6, 1.7862f, -1.8562f),
            tuple<int, float, float>(6, 1.7862f, -1.0312f),
            tuple<int, float, float>(6, 1.0717f, -0.6187f),
            tuple<int, float, float>(8, 1.0717f, 0.2063f)
        }};
        std::array<std::array<int, 3>, 28> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 1, 2, 2 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 4, 7, 1 },
            { 5, 6, 1 },
            { 5, 10, 1 },
            { 7, 8, 1 },
            { 7, 11, 1 },
            { 7, 22, 1 },
            { 8, 9, 2 },
            { 9, 10, 1 },
            { 11, 12, 1 },
            { 12, 13, 2 },
            { 12, 17, 1 },
            { 13, 14, 1 },
            { 13, 21, 1 },
            { 14, 15, 2 },
            { 14, 18, 1 },
            { 15, 16, 1 },
            { 16, 17, 2 },
            { 18, 19, 2 },
            { 19, 20, 1 },
            { 20, 21, 2 },
            { 21, 22, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 16> atoms = {{
            tuple<int, float, float>(6, -3.2502f, 0.0934f),
            tuple<int, float, float>(6, -2.0131f, 0.8077f),
            tuple<int, float, float>(6, -2.0131f, 2.2363f),
            tuple<int, float, float>(6, -3.2502f, 2.9506f),
            tuple<int, float, float>(8, -4.4874f, 2.2363f),
            tuple<int, float, float>(7, -4.4874f, 0.8077f),
            tuple<int, float, float>(6, -2.5429f, 4.18f),
            tuple<int, float, float>(6, -2.5429f, -1.1515f),
            tuple<int, float, float>(6, 1.5663f, 0.0934f),
            tuple<int, float, float>(7, 2.8034f, 0.8077f),
            tuple<int, float, float>(8, 2.8034f, 2.2363f),
            tuple<int, float, float>(6, 1.5663f, 2.9506f),
            tuple<int, float, float>(6, 0.3291f, 2.2363f),
            tuple<int, float, float>(6, 0.3291f, 0.8077f),
            tuple<int, float, float>(6, 0.8571f, 4.18f),
            tuple<int, float, float>(6, 0.8571f, -1.1515f)
        }};
        std::array<std::array<int, 3>, 18> bonds = {{
            { 0, 1, 1 },
            { 0, 7, 1 },
            { 0, 5, 2 },
            { 1, 2, 2 },
            { 2, 3, 1 },
            { 3, 4, 2 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 6, 14, 1 },
            { 7, 15, 1 },
            { 8, 9, 1 },
            { 8, 15, 1 },
            { 8, 13, 2 },
            { 9, 10, 2 },
            { 10, 11, 1 },
            { 11, 12, 2 },
            { 11, 14, 1 },
            { 12, 13, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 25> atoms = {{
            tuple<int, float, float>(6, 1.4521f, 1.4521f),
            tuple<int, float, float>(6, 1.707f, 0.6674f),
            tuple<int, float, float>(6, 0.6674f, 1.707f),
            tuple<int, float, float>(7, -0.0f, 1.2221f),
            tuple<int, float, float>(6, -0.6674f, 1.707f),
            tuple<int, float, float>(6, -0.4125f, 2.4916f),
            tuple<int, float, float>(6, 0.4125f, 2.4916f),
            tuple<int, float, float>(6, -1.4521f, 1.4521f),
            tuple<int, float, float>(6, -1.707f, 0.6674f),
            tuple<int, float, float>(7, -1.2221f, 0.0f),
            tuple<int, float, float>(6, -1.707f, -0.6674f),
            tuple<int, float, float>(6, -2.4916f, -0.4125f),
            tuple<int, float, float>(6, -2.4916f, 0.4125f),
            tuple<int, float, float>(6, -1.4521f, -1.4521f),
            tuple<int, float, float>(6, -0.6674f, -1.707f),
            tuple<int, float, float>(7, -0.0f, -1.2221f),
            tuple<int, float, float>(28, -0.0063f, 0.0208f),
            tuple<int, float, float>(6, 0.6674f, -1.707f),
            tuple<int, float, float>(6, 0.4125f, -2.4916f),
            tuple<int, float, float>(6, -0.4125f, -2.4916f),
            tuple<int, float, float>(6, 1.4521f, -1.4521f),
            tuple<int, float, float>(6, 1.707f, -0.6674f),
            tuple<int, float, float>(7, 1.2221f, 0.0f),
            tuple<int, float, float>(6, 2.4916f, -0.4125f),
            tuple<int, float, float>(6, 2.4916f, 0.4125f)
        }};
        std::array<std::array<int, 3>, 32> bonds = {{
            { 0, 1, 2 },
            { 0, 2, 1 },
            { 1, 22, 1 },
            { 1, 24, 1 },
            { 2, 3, 1 },
            { 2, 6, 2 },
            { 3, 4, 1 },
            { 3, 16, 1 },
            { 4, 5, 2 },
            { 4, 7, 1 },
            { 5, 6, 1 },
            { 7, 8, 2 },
            { 8, 9, 1 },
            { 8, 12, 1 },
            { 9, 10, 1 },
            { 9, 16, 1 },
            { 10, 11, 1 },
            { 10, 13, 2 },
            { 11, 12, 2 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 19, 2 },
            { 15, 16, 1 },
            { 15, 17, 1 },
            { 16, 22, 1 },
            { 17, 18, 2 },
            { 17, 20, 1 },
            { 18, 19, 1 },
            { 20, 21, 2 },
            { 21, 22, 1 },
            { 21, 23, 1 },
            { 23, 24, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 25> atoms = {{
            tuple<int, float, float>(6, 1.4521f, 1.4521f),
            tuple<int, float, float>(6, 1.707f, 0.6674f),
            tuple<int, float, float>(6, 0.6674f, 1.707f),
            tuple<int, float, float>(7, -0.0f, 1.2221f),
            tuple<int, float, float>(6, -0.6674f, 1.707f),
            tuple<int, float, float>(6, -0.4125f, 2.4916f),
            tuple<int, float, float>(6, 0.4125f, 2.4916f),
            tuple<int, float, float>(6, -1.4521f, 1.4521f),
            tuple<int, float, float>(6, -1.707f, 0.6674f),
            tuple<int, float, float>(7, -1.2221f, 0.0f),
            tuple<int, float, float>(6, -1.707f, -0.6674f),
            tuple<int, float, float>(6, -2.4916f, -0.4125f),
            tuple<int, float, float>(6, -2.4916f, 0.4125f),
            tuple<int, float, float>(6, -1.4521f, -1.4521f),
            tuple<int, float, float>(6, -0.6674f, -1.707f),
            tuple<int, float, float>(7, -0.0f, -1.2221f),
            tuple<int, float, float>(28, -0.0063f, 0.0208f),
            tuple<int, float, float>(6, 0.6674f, -1.707f),
            tuple<int, float, float>(6, 0.4125f, -2.4916f),
            tuple<int, float, float>(6, -0.4125f, -2.4916f),
            tuple<int, float, float>(6, 1.4521f, -1.4521f),
            tuple<int, float, float>(6, 1.707f, -0.6674f),
            tuple<int, float, float>(7, 1.2221f, 0.0f),
            tuple<int, float, float>(6, 2.4916f, -0.4125f),
            tuple<int, float, float>(6, 2.4916f, 0.4125f)
        }};
        std::array<std::array<int, 3>, 30> bonds = {{
            { 0, 1, 2 },
            { 0, 2, 1 },
            { 1, 22, 1 },
            { 1, 24, 1 },
            { 2, 3, 2 },
            { 2, 6, 1 },
            { 3, 4, 1 },
            { 4, 5, 2 },
            { 4, 7, 1 },
            { 5, 6, 1 },
            { 7, 8, 2 },
            { 8, 9, 1 },
            { 8, 12, 1 },
            { 9, 10, 1 },
            { 9, 16, 1 },
            { 10, 11, 1 },
            { 10, 13, 2 },
            { 11, 12, 2 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 14, 19, 1 },
            { 15, 17, 1 },
            { 16, 22, 1 },
            { 17, 18, 2 },
            { 17, 20, 1 },
            { 18, 19, 1 },
            { 20, 21, 2 },
            { 21, 22, 1 },
            { 21, 23, 1 },
            { 23, 24, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 24> atoms = {{
            tuple<int, float, float>(6, 1.4521f, 1.4521f),
            tuple<int, float, float>(6, 1.707f, 0.6674f),
            tuple<int, float, float>(6, 0.6674f, 1.707f),
            tuple<int, float, float>(7, -0.0f, 1.2221f),
            tuple<int, float, float>(6, -0.6674f, 1.707f),
            tuple<int, float, float>(6, -0.4125f, 2.4916f),
            tuple<int, float, float>(6, 0.4125f, 2.4916f),
            tuple<int, float, float>(6, -1.4521f, 1.4521f),
            tuple<int, float, float>(6, -1.707f, 0.6674f),
            tuple<int, float, float>(7, -1.2221f, 0.0f),
            tuple<int, float, float>(6, -1.707f, -0.6674f),
            tuple<int, float, float>(6, -2.4916f, -0.4125f),
            tuple<int, float, float>(6, -2.4916f, 0.4125f),
            tuple<int, float, float>(6, -1.4521f, -1.4521f),
            tuple<int, float, float>(6, -0.6674f, -1.707f),
            tuple<int, float, float>(7, -0.0f, -1.2221f),
            tuple<int, float, float>(6, 0.6674f, -1.707f),
            tuple<int, float, float>(6, 0.4125f, -2.4916f),
            tuple<int, float, float>(6, -0.4125f, -2.4916f),
            tuple<int, float, float>(6, 1.4521f, -1.4521f),
            tuple<int, float, float>(6, 1.707f, -0.6674f),
            tuple<int, float, float>(7, 1.2221f, 0.0f),
            tuple<int, float, float>(6, 2.4916f, -0.4125f),
            tuple<int, float, float>(6, 2.4916f, 0.4125f)
        }};
        std::array<std::array<int, 3>, 28> bonds = {{
            { 0, 1, 2 },
            { 0, 2, 1 },
            { 1, 21, 1 },
            { 1, 23, 1 },
            { 2, 3, 2 },
            { 2, 6, 1 },
            { 3, 4, 1 },
            { 4, 5, 2 },
            { 4, 7, 1 },
            { 5, 6, 1 },
            { 7, 8, 2 },
            { 8, 9, 1 },
            { 8, 12, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 13, 2 },
            { 11, 12, 2 },
            { 13, 14, 1 },
            { 14, 15, 2 },
            { 14, 18, 1 },
            { 15, 16, 1 },
            { 16, 17, 2 },
            { 16, 19, 1 },
            { 17, 18, 1 },
            { 19, 20, 2 },
            { 20, 21, 1 },
            { 20, 22, 1 },
            { 22, 23, 2 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 19> atoms = {{
            tuple<int, float, float>(7, 0.9191f, 1.4438f),
            tuple<int, float, float>(7, 0.2046f, 1.0312f),
            tuple<int, float, float>(7, 1.6336f, 1.0312f),
            tuple<int, float, float>(6, 1.6336f, 0.2062f),
            tuple<int, float, float>(6, 1.9388f, -0.4428f),
            tuple<int, float, float>(6, 1.3888f, -0.9653f),
            tuple<int, float, float>(6, 0.4813f, -0.5528f),
            tuple<int, float, float>(6, 0.9191f, -0.2062f),
            tuple<int, float, float>(6, 0.2046f, 0.2062f),
            tuple<int, float, float>(6, 0.9191f, -1.0312f),
            tuple<int, float, float>(6, 0.2046f, -1.4438f),
            tuple<int, float, float>(6, -0.5098f, -1.0312f),
            tuple<int, float, float>(6, -0.5098f, -0.2062f),
            tuple<int, float, float>(6, -1.2243f, 0.2062f),
            tuple<int, float, float>(6, -1.9388f, -0.2062f),
            tuple<int, float, float>(6, -1.6632f, -0.7603f),
            tuple<int, float, float>(6, -1.1274f, -1.0696f),
            tuple<int, float, float>(7, -1.9388f, -1.0312f),
            tuple<int, float, float>(7, -1.2243f, -1.4438f)
        }};
        std::array<std::array<int, 3>, 23> bonds = {{
            { 0, 1, 1 },
            { 0, 2, 1 },
            { 1, 8, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 7, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 8, 1 },
            { 7, 8, 1 },
            { 7, 9, 1 },
            { 8, 12, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 11, 16, 1 },
            { 11, 18, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 17, 1 },
            { 15, 16, 1 },
            { 17, 18, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 20> atoms = {{
            tuple<int, float, float>(6, 0.5773f, 0.9186f),
            tuple<int, float, float>(8, 0.1357f, 0.2217f),
            tuple<int, float, float>(6, -0.6743f, 0.3782f),
            tuple<int, float, float>(6, -1.3016f, -0.1576f),
            tuple<int, float, float>(6, -2.0296f, 0.2307f),
            tuple<int, float, float>(6, -2.7298f, -0.2056f),
            tuple<int, float, float>(8, -2.702f, -1.0302f),
            tuple<int, float, float>(6, -1.9741f, -1.4184f),
            tuple<int, float, float>(6, -1.2739f, -0.9821f),
            tuple<int, float, float>(6, -0.612f, -1.4745f),
            tuple<int, float, float>(6, 0.1857f, -1.264f),
            tuple<int, float, float>(8, 0.5185f, -0.5091f),
            tuple<int, float, float>(6, 1.3428f, -0.5431f),
            tuple<int, float, float>(6, 2.0429f, -0.9794f),
            tuple<int, float, float>(6, 2.7298f, -0.5224f),
            tuple<int, float, float>(6, 2.5977f, 0.292f),
            tuple<int, float, float>(7, 2.7176f, 1.1082f),
            tuple<int, float, float>(7, 1.9784f, 1.4745f),
            tuple<int, float, float>(6, 1.4016f, 0.8847f),
            tuple<int, float, float>(6, 1.7843f, 0.1538f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 18, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 8, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 12, 19, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 15, 19, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, 0.4011f, 1.0822f),
            tuple<int, float, float>(6, 1.1156f, 1.4947f),
            tuple<int, float, float>(6, 1.8301f, 1.0822f),
            tuple<int, float, float>(6, 1.8301f, 0.2572f),
            tuple<int, float, float>(6, 2.1206f, -0.3935f),
            tuple<int, float, float>(8, 0.8556f, -0.476f),
            tuple<int, float, float>(6, 1.1156f, -0.1553f),
            tuple<int, float, float>(6, 1.1156f, -0.9803f),
            tuple<int, float, float>(6, 0.4011f, -1.3928f),
            tuple<int, float, float>(6, 0.4011f, 0.2572f),
            tuple<int, float, float>(6, -0.3133f, -0.1553f),
            tuple<int, float, float>(6, -0.3133f, -0.9803f),
            tuple<int, float, float>(6, -0.9583f, 0.3591f),
            tuple<int, float, float>(6, -1.7626f, 0.1755f),
            tuple<int, float, float>(6, -2.1206f, -0.5678f),
            tuple<int, float, float>(6, -1.0984f, -0.2544f),
            tuple<int, float, float>(6, -1.7626f, -1.3111f),
            tuple<int, float, float>(6, -0.9583f, -1.4947f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 9, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 5, 9, 1 },
            { 6, 7, 1 },
            { 6, 9, 1 },
            { 7, 8, 1 },
            { 8, 11, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 12, 1 },
            { 11, 15, 1 },
            { 11, 17, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, 0.5382f, 0.7033f),
            tuple<int, float, float>(6, 1.1432f, 1.3633f),
            tuple<int, float, float>(6, 1.7207f, 1.0608f),
            tuple<int, float, float>(6, 1.5906f, 0.3553f),
            tuple<int, float, float>(6, 2.1426f, -0.2578f),
            tuple<int, float, float>(8, 1.8877f, -1.0424f),
            tuple<int, float, float>(6, 1.0807f, -1.214f),
            tuple<int, float, float>(6, 0.7836f, 0.1837f),
            tuple<int, float, float>(6, 0.1162f, 0.6687f),
            tuple<int, float, float>(6, 0.5287f, -0.6009f),
            tuple<int, float, float>(6, -0.2963f, -0.6009f),
            tuple<int, float, float>(6, -0.5513f, 0.1837f),
            tuple<int, float, float>(6, -0.7508f, -1.2894f),
            tuple<int, float, float>(6, -1.5725f, -1.3633f),
            tuple<int, float, float>(6, -2.1426f, -0.767f),
            tuple<int, float, float>(6, -1.0736f, -0.7492f),
            tuple<int, float, float>(6, -2.0319f, 0.0505f),
            tuple<int, float, float>(6, -1.3237f, 0.4736f)
        }};
        std::array<std::array<int, 3>, 22> bonds = {{
            { 0, 1, 1 },
            { 0, 9, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 7, 1 },
            { 4, 5, 1 },
            { 5, 6, 1 },
            { 6, 9, 1 },
            { 7, 8, 1 },
            { 7, 9, 1 },
            { 8, 11, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 10, 12, 1 },
            { 11, 15, 1 },
            { 11, 17, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 14, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, -0.825f, 2.0426f),
            tuple<int, float, float>(7, -0.4125f, 1.3281f),
            tuple<int, float, float>(6, 0.4125f, 1.3281f),
            tuple<int, float, float>(6, 0.825f, 0.6137f),
            tuple<int, float, float>(6, 0.4125f, -0.1008f),
            tuple<int, float, float>(6, 0.825f, -0.8153f),
            tuple<int, float, float>(6, 1.65f, 0.6137f),
            tuple<int, float, float>(6, 2.0625f, -0.1008f),
            tuple<int, float, float>(6, 1.65f, -0.8153f),
            tuple<int, float, float>(6, -1.65f, 2.0426f),
            tuple<int, float, float>(8, -2.0625f, 1.3281f),
            tuple<int, float, float>(6, -1.65f, 0.6137f),
            tuple<int, float, float>(6, -2.0625f, -0.1008f),
            tuple<int, float, float>(6, -1.65f, -0.8153f),
            tuple<int, float, float>(6, -1.7791f, -1.6301f),
            tuple<int, float, float>(6, -1.0646f, -2.0426f),
            tuple<int, float, float>(7, -0.4125f, -1.5297f),
            tuple<int, float, float>(6, 0.4125f, -1.5297f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 9, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 2 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 5, 8, 2 },
            { 5, 17, 1 },
            { 6, 7, 2 },
            { 7, 8, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 2 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 18> atoms = {{
            tuple<int, float, float>(6, -1.1713f, 1.5474f),
            tuple<int, float, float>(7, -0.7588f, 2.2618f),
            tuple<int, float, float>(6, 0.0662f, 2.2618f),
            tuple<int, float, float>(6, 0.4787f, 1.5474f),
            tuple<int, float, float>(6, 0.0662f, 0.8329f),
            tuple<int, float, float>(6, 0.5806f, 0.1879f),
            tuple<int, float, float>(6, 1.2988f, 1.637f),
            tuple<int, float, float>(6, 1.7713f, 0.9607f),
            tuple<int, float, float>(6, 1.4049f, 0.2215f),
            tuple<int, float, float>(6, -0.7588f, 0.8329f),
            tuple<int, float, float>(8, -1.2732f, 0.1879f),
            tuple<int, float, float>(6, -1.0896f, -0.6164f),
            tuple<int, float, float>(6, -1.7713f, -1.0812f),
            tuple<int, float, float>(6, -1.7096f, -1.9039f),
            tuple<int, float, float>(6, -0.9663f, -2.2618f),
            tuple<int, float, float>(6, -0.2847f, -1.7971f),
            tuple<int, float, float>(7, -0.3463f, -0.9744f),
            tuple<int, float, float>(6, 0.397f, -0.6164f)
        }};
        std::array<std::array<int, 3>, 19> bonds = {{
            { 0, 1, 1 },
            { 0, 9, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 2 },
            { 3, 6, 1 },
            { 4, 5, 1 },
            { 5, 8, 2 },
            { 5, 17, 1 },
            { 6, 7, 2 },
            { 7, 8, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 2 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 23> atoms = {{
            tuple<int, float, float>(6, -0.3572f, -0.825f),
            tuple<int, float, float>(6, -0.3572f, -1.65f),
            tuple<int, float, float>(6, 0.3572f, -2.0625f),
            tuple<int, float, float>(6, 1.0717f, -1.65f),
            tuple<int, float, float>(6, 1.0717f, -0.825f),
            tuple<int, float, float>(6, 0.3572f, -0.4125f),
            tuple<int, float, float>(6, 0.3572f, 0.4125f),
            tuple<int, float, float>(6, 1.0717f, 0.825f),
            tuple<int, float, float>(6, 1.7862f, -0.4125f),
            tuple<int, float, float>(6, 1.7862f, 0.4125f),
            tuple<int, float, float>(6, 2.5006f, 0.825f),
            tuple<int, float, float>(6, 2.5006f, 1.65f),
            tuple<int, float, float>(6, 1.7862f, 2.0625f),
            tuple<int, float, float>(6, 1.0717f, 1.65f),
            tuple<int, float, float>(6, 0.3572f, 2.0625f),
            tuple<int, float, float>(6, -0.3572f, 1.65f),
            tuple<int, float, float>(6, -0.3572f, 0.825f),
            tuple<int, float, float>(6, -1.0717f, 0.4125f),
            tuple<int, float, float>(6, -1.0717f, -0.4125f),
            tuple<int, float, float>(6, -1.7862f, 0.825f),
            tuple<int, float, float>(6, -2.5006f, 0.4125f),
            tuple<int, float, float>(6, -2.5006f, -0.4125f),
            tuple<int, float, float>(6, -1.7862f, -0.825f)
        }};
        std::array<std::array<int, 3>, 25> bonds = {{
            { 0, 1, 1 },
            { 0, 18, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 17, 19, 1 },
            { 18, 22, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 25> atoms = {{
            tuple<int, float, float>(6, -0.825f, -0.2767f),
            tuple<int, float, float>(6, -0.825f, -1.1017f),
            tuple<int, float, float>(6, -0.0f, -1.1017f),
            tuple<int, float, float>(6, 0.4125f, -1.8161f),
            tuple<int, float, float>(6, 1.2375f, -1.8161f),
            tuple<int, float, float>(6, 1.6078f, -2.5533f),
            tuple<int, float, float>(6, 2.4308f, -2.6108f),
            tuple<int, float, float>(6, 2.9001f, -1.9323f),
            tuple<int, float, float>(6, 1.65f, -1.1017f),
            tuple<int, float, float>(6, 2.5559f, -1.1826f),
            tuple<int, float, float>(6, 2.9684f, -0.4681f),
            tuple<int, float, float>(6, 2.5559f, 0.2464f),
            tuple<int, float, float>(6, 1.7309f, 0.2464f),
            tuple<int, float, float>(6, 1.3184f, 0.9608f),
            tuple<int, float, float>(6, 0.6039f, 1.3733f),
            tuple<int, float, float>(6, 0.6039f, 2.1983f),
            tuple<int, float, float>(6, -0.1105f, 2.6108f),
            tuple<int, float, float>(6, -0.825f, 2.1983f),
            tuple<int, float, float>(6, -0.825f, 1.3733f),
            tuple<int, float, float>(6, -1.5395f, 0.9608f),
            tuple<int, float, float>(6, -1.5395f, 0.1358f),
            tuple<int, float, float>(6, -2.2539f, 1.3733f),
            tuple<int, float, float>(6, -2.9684f, 0.9608f),
            tuple<int, float, float>(6, -2.9684f, 0.1358f),
            tuple<int, float, float>(6, -2.2539f, -0.2767f)
        }};
        std::array<std::array<int, 3>, 27> bonds = {{
            { 0, 1, 1 },
            { 0, 20, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 19, 21, 1 },
            { 20, 24, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 },
            { 23, 24, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 27> atoms = {{
            tuple<int, float, float>(6, -1.0717f, -0.2063f),
            tuple<int, float, float>(6, -1.0717f, -1.0313f),
            tuple<int, float, float>(6, -0.3572f, -1.4438f),
            tuple<int, float, float>(6, 0.3572f, -1.0313f),
            tuple<int, float, float>(6, 1.0717f, -1.4438f),
            tuple<int, float, float>(6, 1.0717f, -2.2688f),
            tuple<int, float, float>(6, 1.7862f, -2.6812f),
            tuple<int, float, float>(6, 2.5006f, -2.2688f),
            tuple<int, float, float>(6, 1.7862f, -1.0313f),
            tuple<int, float, float>(6, 2.5006f, -1.4438f),
            tuple<int, float, float>(6, 3.2151f, -1.0313f),
            tuple<int, float, float>(6, 3.2151f, -0.2063f),
            tuple<int, float, float>(6, 2.5006f, 0.2062f),
            tuple<int, float, float>(6, 2.5006f, 1.0312f),
            tuple<int, float, float>(6, 1.7862f, 1.4437f),
            tuple<int, float, float>(6, 1.7862f, 2.2687f),
            tuple<int, float, float>(6, 1.0717f, 2.6812f),
            tuple<int, float, float>(6, 0.3572f, 2.2687f),
            tuple<int, float, float>(6, 0.3572f, 1.4437f),
            tuple<int, float, float>(6, -0.3572f, 1.0312f),
            tuple<int, float, float>(6, -1.0717f, 1.4437f),
            tuple<int, float, float>(6, -1.7862f, 1.0312f),
            tuple<int, float, float>(6, -1.7862f, 0.2062f),
            tuple<int, float, float>(6, -2.5006f, 1.4437f),
            tuple<int, float, float>(6, -3.2151f, 1.0312f),
            tuple<int, float, float>(6, -3.2151f, 0.2062f),
            tuple<int, float, float>(6, -2.5006f, -0.2063f)
        }};
        std::array<std::array<int, 3>, 29> bonds = {{
            { 0, 1, 1 },
            { 0, 22, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 2 },
            { 18, 19, 1 },
            { 19, 20, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 21, 23, 1 },
            { 22, 26, 1 },
            { 23, 24, 1 },
            { 24, 25, 1 },
            { 25, 26, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 24> atoms = {{
            tuple<int, float, float>(6, -0.9629f, 0.0063f),
            tuple<int, float, float>(6, -0.5504f, -0.7082f),
            tuple<int, float, float>(6, 0.2746f, -0.7082f),
            tuple<int, float, float>(6, 0.6871f, -1.4226f),
            tuple<int, float, float>(6, 1.5121f, -1.4226f),
            tuple<int, float, float>(6, 1.9246f, -2.1371f),
            tuple<int, float, float>(6, 2.7496f, -2.1371f),
            tuple<int, float, float>(6, 3.1621f, -1.4226f),
            tuple<int, float, float>(6, 1.9246f, -0.7082f),
            tuple<int, float, float>(6, 2.7496f, -0.7082f),
            tuple<int, float, float>(6, 3.1621f, 0.0063f),
            tuple<int, float, float>(6, 2.7496f, 0.7082f),
            tuple<int, float, float>(6, 1.9246f, 0.7082f),
            tuple<int, float, float>(6, 1.5121f, 1.4226f),
            tuple<int, float, float>(6, 0.6871f, 1.4226f),
            tuple<int, float, float>(6, 0.2746f, 2.1371f),
            tuple<int, float, float>(6, -0.5504f, 2.1371f),
            tuple<int, float, float>(6, -0.9629f, 1.4226f),
            tuple<int, float, float>(6, -1.7331f, 1.127f),
            tuple<int, float, float>(6, -1.7331f, 0.302f),
            tuple<int, float, float>(6, -2.4476f, 1.5395f),
            tuple<int, float, float>(6, -3.1621f, 1.127f),
            tuple<int, float, float>(6, -3.1621f, 0.302f),
            tuple<int, float, float>(6, -2.4476f, -0.1105f)
        }};
        std::array<std::array<int, 3>, 26> bonds = {{
            { 0, 1, 1 },
            { 0, 19, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 4, 5, 1 },
            { 4, 8, 1 },
            { 5, 6, 1 },
            { 6, 7, 1 },
            { 7, 9, 1 },
            { 8, 9, 1 },
            { 9, 10, 1 },
            { 10, 11, 1 },
            { 11, 12, 1 },
            { 12, 13, 1 },
            { 13, 14, 1 },
            { 14, 15, 1 },
            { 15, 16, 1 },
            { 16, 17, 1 },
            { 17, 18, 1 },
            { 18, 19, 1 },
            { 18, 20, 1 },
            { 19, 23, 1 },
            { 20, 21, 1 },
            { 21, 22, 1 },
            { 22, 23, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 8> atoms = {{
            tuple<int, float, float>(6, -1.7634f, 2.7232f),
            tuple<int, float, float>(6, -1.7634f, 1.8982f),
            tuple<int, float, float>(6, -0.9384f, 1.8982f),
            tuple<int, float, float>(6, -0.9384f, 2.7232f),
            tuple<int, float, float>(6, -2.1145f, 1.5083f),
            tuple<int, float, float>(6, -1.2895f, 1.5083f),
            tuple<int, float, float>(6, -2.1145f, 2.3333f),
            tuple<int, float, float>(6, -1.2895f, 2.3333f)
        }};
        std::array<std::array<int, 3>, 12> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 0, 6, 1 },
            { 1, 2, 1 },
            { 1, 4, 1 },
            { 2, 3, 1 },
            { 2, 5, 1 },
            { 3, 7, 1 },
            { 4, 5, 1 },
            { 4, 6, 1 },
            { 5, 7, 1 },
            { 6, 7, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 8> atoms = {{
            tuple<int, float, float>(6, -1.808f, 0.4902f),
            tuple<int, float, float>(7, -2.5225f, 0.0777f),
            tuple<int, float, float>(6, -2.5225f, -0.7474f),
            tuple<int, float, float>(6, -1.808f, -1.1598f),
            tuple<int, float, float>(6, -1.0935f, -0.7474f),
            tuple<int, float, float>(7, -1.0935f, 0.0777f),
            tuple<int, float, float>(6, -1.5071f, -0.1127f),
            tuple<int, float, float>(6, -2.042f, -0.5793f)
        }};
        std::array<std::array<int, 3>, 9> bonds = {{
            { 0, 1, 1 },
            { 0, 5, 1 },
            { 0, 6, 1 },
            { 1, 2, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 },
            { 3, 7, 1 },
            { 4, 5, 1 },
            { 6, 7, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 5> atoms = {{
            tuple<int, float, float>(6, -0.5833f, -0.0f),
            tuple<int, float, float>(6, 0.0f, 0.5833f),
            tuple<int, float, float>(6, 0.5833f, -0.0f),
            tuple<int, float, float>(6, 0.0f, -0.5833f),
            tuple<int, float, float>(6, 0.1458f, -0.0f)
        }};
        std::array<std::array<int, 3>, 6> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 1, 4, 1 },
            { 2, 3, 1 },
            { 3, 4, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }

    {
        auto molecule = new sketcherMinimizerMolecule();
        std::array<std::tuple<int, float, float>, 9> atoms = {{
            tuple<int, float, float>(6, -6.0f, 7.8125f),
            tuple<int, float, float>(6, -4.46f, 7.8125f),
            tuple<int, float, float>(6, -3.69f, 6.4788f),
            tuple<int, float, float>(6, -6.77f, 6.4788f),
            tuple<int, float, float>(6, -6.0f, 5.1451f),
            tuple<int, float, float>(6, -4.46f, 5.1451f),
            tuple<int, float, float>(6, -2.9954f, 7.3366f),
            tuple<int, float, float>(6, -2.9954f, 5.621f),
            tuple<int, float, float>(6, -5.2637f, 6.1586f)
        }};
        std::array<std::array<int, 3>, 11> bonds = {{
            { 0, 1, 1 },
            { 0, 3, 1 },
            { 1, 2, 1 },
            { 1, 6, 1 },
            { 2, 5, 1 },
            { 3, 4, 1 },
            { 3, 8, 1 },
            { 4, 5, 1 },
            { 5, 7, 1 },
            { 6, 7, 1 },
            { 6, 8, 1 }
        }};

        add_atoms(molecule, atoms);
        add_bonds(molecule, bonds);

        molecules[i] = molecule;
        ++i;
    }


    return molecules;
}

}

