
/* autogenerated by generate-emulation */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <math.h>
#include <orc/orc.h>


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */


void
emulate_absb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: absb */
    var33 = ORC_ABS(var32);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_addb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: addb */
    var34 = var32 + var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_addssb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: addssb */
    var34 = ORC_CLAMP_SB(var32 + var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_addusb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: addusb */
    var34 = ORC_CLAMP_UB((orc_uint8)var32 + (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_andb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: andb */
    var34 = var32 & var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_andnb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: andnb */
    var34 = (~var32) & var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_avgsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgsb */
    var34 = (var32 + var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_avgub (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_cmpeqb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: cmpeqb */
    var34 = (var32 == var33) ? (~0) : 0;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_cmpgtsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: cmpgtsb */
    var34 = (var32 > var33) ? (~0) : 0;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_copyb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: copyb */
    var33 = var32;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_loadb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[offset + i];
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_loadoffb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadoffb */
    var32 = ptr4[offset + i + ((orc_union64 *)(ex->src_ptrs[1]))->i];
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_loadupdb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var32 = ptr4[(offset + i)>>1];
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_loadupib (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadupib */
    var32 = ((offset + i)&1) ? ((orc_uint8)ptr4[(offset + i)>>1] + (orc_uint8)ptr4[((offset + i)>>1)+1] + 1)>>1 : ptr4[(offset + i)>>1];
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_loadpb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];

    /* 0: loadpb */
    var32 = ((orc_union64 *)(ex->src_ptrs[0]))->i;

  for (i = 0; i < n; i++) {
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_ldresnearb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: ldresnearb */
    var32 = ptr4[(((orc_union64 *)(ex->src_ptrs[1]))->i + (offset + i)*((orc_union64 *)(ex->src_ptrs[2]))->i)>>16];
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_ldresnearl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: ldresnearl */
    var32 = ptr4[(((orc_union64 *)(ex->src_ptrs[1]))->i + (offset + i)*((orc_union64 *)(ex->src_ptrs[2]))->i)>>16];
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
emulate_ldreslinb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinb */
    {
    int tmp = ((orc_union64 *)(ex->src_ptrs[1]))->i + (offset + i) * ((orc_union64 *)(ex->src_ptrs[2]))->i;
    var32 = ((orc_uint8)ptr4[tmp>>16] * (256-((tmp>>8)&0xff)) + (orc_uint8)ptr4[(tmp>>16)+1] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
emulate_ldreslinl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
    int tmp = ((orc_union64 *)(ex->src_ptrs[1]))->i + (offset + i) * ((orc_union64 *)(ex->src_ptrs[2]))->i;
    orc_union32 a = ptr4[tmp>>16];
    orc_union32 b = ptr4[(tmp>>16)+1];
    var32.x4[0] = ((orc_uint8)a.x4[0] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[0] * ((tmp>>8)&0xff))>>8;
    var32.x4[1] = ((orc_uint8)a.x4[1] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[1] * ((tmp>>8)&0xff))>>8;
    var32.x4[2] = ((orc_uint8)a.x4[2] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[2] * ((tmp>>8)&0xff))>>8;
    var32.x4[3] = ((orc_uint8)a.x4[3] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[3] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
emulate_maxsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: maxsb */
    var34 = ORC_MAX(var32, var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_maxub (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: maxub */
    var34 = ORC_MAX((orc_uint8)var32, (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_minsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: minsb */
    var34 = ORC_MIN(var32, var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_minub (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: minub */
    var34 = ORC_MIN((orc_uint8)var32, (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_mullb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mullb */
    var34 = (var32 * var33) & 0xff;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_mulhsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mulhsb */
    var34 = (var32 * var33) >> 8;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_mulhub (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mulhub */
    var34 = ((orc_uint32)(orc_uint8)var32 * (orc_uint32)(orc_uint8)var33) >> 8;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_orb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: orb */
    var34 = var32 | var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_shlb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: shlb */
    var33 = ((orc_uint8)var32) << ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_shrsb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: shrsb */
    var33 = var32 >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_shrub (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: shrub */
    var33 = ((orc_uint8)var32) >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_signb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: signb */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_storeb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: storeb */
    ptr0[offset + i] = var32;
  }

}

void
emulate_subb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: subb */
    var34 = var32 - var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_subssb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: subssb */
    var34 = ORC_CLAMP_SB(var32 - var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_subusb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: subusb */
    var34 = ORC_CLAMP_UB((orc_uint8)var32 - (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_xorb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: xorb */
    var34 = var32 ^ var33;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
emulate_absw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: absw */
    var33.i = ORC_ABS(var32.i);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_addw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: addw */
    var34.i = var32.i + var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_addssw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: addssw */
    var34.i = ORC_CLAMP_SW(var32.i + var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_addusw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: addusw */
    var34.i = ORC_CLAMP_UW((orc_uint16)var32.i + (orc_uint16)var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_andw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: andw */
    var34.i = var32.i & var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_andnw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: andnw */
    var34.i = (~var32.i) & var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_avgsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: avgsw */
    var34.i = (var32.i + var33.i + 1)>>1;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_avguw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: avguw */
    var34.i = ((orc_uint16)var32.i + (orc_uint16)var33.i + 1)>>1;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_cmpeqw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: cmpeqw */
    var34.i = (var32.i == var33.i) ? (~0) : 0;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_cmpgtsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: cmpgtsw */
    var34.i = (var32.i > var33.i) ? (~0) : 0;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_copyw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: copyw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_div255w (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: div255w */
    var33.i = ((orc_uint16)(((orc_uint16)(var32.i+128)) + (((orc_uint16)(var32.i+128))>>8)))>>8;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_divluw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: divluw */
    var34.i = ((var33.i&0xff) == 0) ? 255 : ORC_CLAMP_UB(((orc_uint16)var32.i)/((orc_uint16)var33.i&0xff));
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_loadw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[offset + i];
    /* 1: storew */
    ptr0[i] = var32;
  }

}

void
emulate_loadoffw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var32 = ptr4[offset + i + ((orc_union64 *)(ex->src_ptrs[1]))->i];
    /* 1: storew */
    ptr0[i] = var32;
  }

}

void
emulate_loadpw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];

    /* 0: loadpw */
    var32.i = ((orc_union64 *)(ex->src_ptrs[0]))->i;

  for (i = 0; i < n; i++) {
    /* 1: storew */
    ptr0[i] = var32;
  }

}

void
emulate_maxsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: maxsw */
    var34.i = ORC_MAX(var32.i, var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_maxuw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: maxuw */
    var34.i = ORC_MAX((orc_uint16)var32.i, (orc_uint16)var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_minsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: minsw */
    var34.i = ORC_MIN(var32.i, var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_minuw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: minuw */
    var34.i = ORC_MIN((orc_uint16)var32.i, (orc_uint16)var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_mullw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mullw */
    var34.i = (var32.i * var33.i) & 0xffff;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_mulhsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mulhsw */
    var34.i = (var32.i * var33.i) >> 16;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_mulhuw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mulhuw */
    var34.i = ((orc_uint32)((orc_uint16)var32.i) * (orc_uint32)((orc_uint16)var33.i)) >> 16;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_orw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: orw */
    var34.i = var32.i | var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_shlw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shlw */
    var33.i = ((orc_uint16)var32.i) << ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_shrsw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shrsw */
    var33.i = var32.i >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_shruw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: shruw */
    var33.i = ((orc_uint16)var32.i) >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_signw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: signw */
    var33.i = ORC_CLAMP(var32.i,-1,1);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_storew (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: storew */
    ptr0[offset + i] = var32;
  }

}

void
emulate_subw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: subw */
    var34.i = var32.i - var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_subssw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: subssw */
    var34.i = ORC_CLAMP_SW(var32.i - var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_subusw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: subusw */
    var34.i = ORC_CLAMP_UW((orc_uint16)var32.i - (orc_uint16)var33.i);
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_xorw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: xorw */
    var34.i = var32.i ^ var33.i;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_absl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: absl */
    var33.i = ORC_ABS(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_addl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: addl */
    var34.i = ((orc_uint32)var32.i) + ((orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_addssl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: addssl */
    var34.i = ORC_CLAMP_SL((orc_int64)var32.i + (orc_int64)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_addusl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: addusl */
    var34.i = ORC_CLAMP_UL((orc_int64)(orc_uint32)var32.i + (orc_int64)(orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_andl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: andl */
    var34.i = var32.i & var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_andnl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: andnl */
    var34.i = (~var32.i) & var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_avgsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: avgsl */
    var34.i = ((orc_int64)var32.i + (orc_int64)var33.i + 1)>>1;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_avgul (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: avgul */
    var34.i = ((orc_uint64)(orc_uint32)var32.i + (orc_uint64)(orc_uint32)var33.i + 1)>>1;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_cmpeql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: cmpeql */
    var34.i = (var32.i == var33.i) ? (~0) : 0;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_cmpgtsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: cmpgtsl */
    var34.i = (var32.i > var33.i) ? (~0) : 0;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_copyl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: copyl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_loadl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[offset + i];
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
emulate_loadoffl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadoffl */
    var32 = ptr4[offset + i + ((orc_union64 *)(ex->src_ptrs[1]))->i];
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
emulate_loadpl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];

    /* 0: loadpl */
    var32.i = ((orc_union64 *)(ex->src_ptrs[0]))->i;

  for (i = 0; i < n; i++) {
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
emulate_maxsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: maxsl */
    var34.i = ORC_MAX(var32.i, var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_maxul (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: maxul */
    var34.i = ORC_MAX((orc_uint32)var32.i, (orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_minsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: minsl */
    var34.i = ORC_MIN(var32.i, var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_minul (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: minul */
    var34.i = ORC_MIN((orc_uint32)var32.i, (orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mulll (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mulll */
    var34.i = (((orc_uint32)var32.i) * ((orc_uint32)var33.i)) & 0xffffffff;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mulhsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mulhsl */
    var34.i = ((orc_int64)var32.i * (orc_int64)var33.i) >> 32;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mulhul (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mulhul */
    var34.i = ((orc_uint64)(orc_uint32)var32.i * (orc_uint64)(orc_uint32)var33.i) >> 32;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_orl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: orl */
    var34.i = var32.i | var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_shll (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shll */
    var33.i = ((orc_uint32)var32.i) << ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_shrsl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrsl */
    var33.i = var32.i >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_shrul (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: shrul */
    var33.i = ((orc_uint32)var32.i) >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_signl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: signl */
    var33.i = ORC_CLAMP(var32.i,-1,1);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_storel (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: storel */
    ptr0[offset + i] = var32;
  }

}

void
emulate_subl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: subl */
    var34.i = ((orc_uint32)var32.i) - ((orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_subssl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: subssl */
    var34.i = ORC_CLAMP_SL((orc_int64)var32.i - (orc_int64)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_subusl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: subusl */
    var34.i = ORC_CLAMP_UL((orc_int64)(orc_uint32)var32.i - (orc_int64)(orc_uint32)var33.i);
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_xorl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: xorl */
    var34.i = var32.i ^ var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_loadq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[offset + i];
    /* 1: storeq */
    ptr0[i] = var32;
  }

}

void
emulate_loadpq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var32;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];

    /* 0: loadpq */
    var32.i = ((orc_union64 *)(ex->src_ptrs[0]))->i;

  for (i = 0; i < n; i++) {
    /* 1: storeq */
    ptr0[i] = var32;
  }

}

void
emulate_storeq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: storeq */
    ptr0[offset + i] = var32;
  }

}

void
emulate_splatw3q (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: splatw3q */
    var33.i = ((((orc_uint64)var32.i)>>48) << 48) | ((((orc_uint64)var32.i)>>48)<<32) | ((((orc_uint64)var32.i)>>48) << 16) | ((((orc_uint64)var32.i)>>48));
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_copyq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_cmpeqq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: cmpeqq */
    var34.i = (var32.i == var33.i) ? (~0) : 0;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_cmpgtsq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: cmpgtsq */
    var34.i = (var32.i > var33.i) ? (~0) : 0;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_andq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: andq */
    var34.i = var32.i & var33.i;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_andnq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: andnq */
    var34.i = (~var32.i) & var33.i;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_orq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: orq */
    var34.i = var32.i | var33.i;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_xorq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: xorq */
    var34.i = var32.i ^ var33.i;
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_addq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: addq */
    var34.i = ((orc_uint64)var32.i) + ((orc_uint64)var33.i);
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_subq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: subq */
    var34.i = ((orc_uint64)var32.i) - ((orc_uint64)var33.i);
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_shlq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: shlq */
    var33.i = ((orc_uint64)var32.i) << ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_shrsq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: shrsq */
    var33.i = var32.i >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_shruq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: shruq */
    var33.i = ((orc_uint64)var32.i) >> ((orc_union64 *)(ex->src_ptrs[1]))->i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_convsbw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: convsbw */
    var33.i = var32;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convubw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: convubw */
    var33.i = (orc_uint8)var32;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_splatbw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: splatbw */
    var33.i = ((var32&0xff) << 8) | (var32&0xff);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_splatbl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: splatbl */
    var33.i = ((((orc_uint32)var32)&0xff) << 24) | ((((orc_uint32)var32)&0xff)<<16) | ((((orc_uint32)var32)&0xff) << 8) | (((orc_uint32)var32)&0xff);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convswl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convswl */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convuwl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convuwl */
    var33.i = (orc_uint16)var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convslq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convslq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_convulq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convulq */
    var33.i = (orc_uint32)var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_convwb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convwb */
    var33 = var32.i;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convhwb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convhwb */
    var33 = ((orc_uint16)var32.i)>>8;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convssswb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convssswb */
    var33 = ORC_CLAMP_SB(var32.i);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convsuswb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convsuswb */
    var33 = ORC_CLAMP_UB(var32.i);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convusswb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convusswb */
    var33 = ORC_MIN((orc_uint16)var32.i,ORC_SB_MAX);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convuuswb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convuuswb */
    var33 = ORC_MIN((orc_uint16)var32.i,ORC_UB_MAX);
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_convlw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convlw */
    var33.i = var32.i;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convhlw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convhlw */
    var33.i = ((orc_uint32)var32.i)>>16;
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convssslw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convssslw */
    var33.i = ORC_CLAMP_SW(var32.i);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convsuslw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convsuslw */
    var33.i = ORC_CLAMP_UW(var32.i);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convusslw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convusslw */
    var33.i = ORC_CLAMP((orc_uint32)var32.i,0,ORC_SW_MAX);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convuuslw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convuuslw */
    var33.i = ORC_CLAMP_UW((orc_uint32)var32.i);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_convql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convql */
    var33.i = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convsssql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convsssql */
    var33.i = ORC_CLAMP_SL(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convsusql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convsusql */
    var33.i = ORC_CLAMP_UL(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convussql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convussql */
    var33.i = ORC_CLAMP_SL((orc_uint64)var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convuusql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convuusql */
    var33.i = ORC_CLAMP_UL((orc_uint64)var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_mulsbw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mulsbw */
    var34.i = var32 * var33;
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_mulubw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mulubw */
    var34.i = ((orc_uint16)((orc_uint8)var32)) * ((orc_uint16)((orc_uint8)var33));
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_mulswl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mulswl */
    var34.i = var32.i * var33.i;
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_muluwl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: muluwl */
    var34.i = ((orc_uint32)((orc_uint16)var32.i)) * ((orc_uint32)((orc_uint16)var33.i));
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mulslq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mulslq */
    var34.i = ((orc_int64)var32.i) * ((orc_int64)var33.i);
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_mululq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mululq */
    var34.i = ((orc_uint64)((orc_uint32)var32.i)) * ((orc_uint64)((orc_uint32)var33.i));
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_accw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var12 =  { 0 };
  orc_union16 var32;

  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: accw */
    var12.i = var12.i + var32.i;
  }
  ((orc_union32 *)ex->dest_ptrs[0])->i = (var12.i + ((orc_union32 *)ex->dest_ptrs[0])->i) & 0xffff;

}

void
emulate_accl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_union32 var32;

  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: accl */
    var12.i = ((orc_uint32)var12.i) + ((orc_uint32)var32.i);
  }
  ((orc_union32 *)ex->dest_ptrs[0])->i += (orc_uint32)var12.i;

}

void
emulate_accsadubl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: accsadubl */
    var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
  }
  ((orc_union32 *)ex->dest_ptrs[0])->i += (orc_uint32)var12.i;

}

void
emulate_swapw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: swapw */
    var33.i = ORC_SWAP_W(var32.i);
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_swapl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_swapwl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapwl */
    var33.i = ((var32.i&0x0000ffffU) << 16) | ((var32.i&0xffff0000U) >> 16);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_swapq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swapq */
    var33.i = ORC_SWAP_Q(var32.i);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_swaplq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: swaplq */
    var33.i = ((var32.i&ORC_UINT64_C(0x00000000ffffffff)) << 32) | ((var32.i & ORC_UINT64_C(0xffffffff00000000)) >> 32);
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_select0wb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select0wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[0];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_select1wb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: select1wb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[1];
    }
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
emulate_select0lw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var32.i;
       var33.i = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_select1lw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: select1lw */
    {
       orc_union32 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
    }
    /* 2: storew */
    ptr0[i] = var33;
  }

}

void
emulate_select0ql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: select0ql */
    {
       orc_union64 _src;
       _src.i = var32.i;
       var33.i = _src.x2[0];
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_select1ql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: select1ql */
    {
       orc_union64 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_mergelq (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_mergewl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var32;
  orc_union16 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];
  ptr5 = (orc_union16 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: loadw */
    var33 = ptr5[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var32.i;
       _dest.x2[1] = var33.i;
       var34.i = _dest.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mergebw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr4 = (orc_int8 *)ex->src_ptrs[0];
  ptr5 = (orc_int8 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var32;
       _dest.x2[1] = var33;
       var34.i = _dest.i;
    }
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
emulate_splitql (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr1 = (orc_union32 *)ex->dest_ptrs[1];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storel */
    ptr0[i] = var33;
    /* 3: storel */
    ptr1[i] = var34;
  }

}

void
emulate_splitlw (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union16 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->dest_ptrs[0];
  ptr1 = (orc_union16 *)ex->dest_ptrs[1];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var32.i;
       var33.i = _src.x2[1];
       var34.i = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var33;
    /* 3: storew */
    ptr1[i] = var34;
  }

}

void
emulate_splitwb (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->dest_ptrs[0];
  ptr1 = (orc_int8 *)ex->dest_ptrs[1];
  ptr4 = (orc_union16 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var32.i;
       var33 = _src.x2[1];
       var34 = _src.x2[0];
    }
    /* 2: storeb */
    ptr0[i] = var33;
    /* 3: storeb */
    ptr1[i] = var34;
  }

}

void
emulate_addf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: addf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       orc_union32 _dest1;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       _dest1.f = _src1.f + _src2.f;
       var34.i = ORC_DENORMAL(_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_subf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: subf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       orc_union32 _dest1;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       _dest1.f = _src1.f - _src2.f;
       var34.i = ORC_DENORMAL(_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_mulf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: mulf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       orc_union32 _dest1;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       _dest1.f = _src1.f * _src2.f;
       var34.i = ORC_DENORMAL(_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_divf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: divf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       orc_union32 _dest1;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       _dest1.f = _src1.f / _src2.f;
       var34.i = ORC_DENORMAL(_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_sqrtf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: sqrtf */
    {
       orc_union32 _src1;
       orc_union32 _dest1;
       _src1.i = ORC_DENORMAL(var32.i);
       _dest1.f = sqrt(_src1.f);
       var33.i = ORC_DENORMAL(_dest1.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_maxf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: maxf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      _src1.i = ORC_DENORMAL(var32.i);
      _src2.i = ORC_DENORMAL(var33.i);
      if (ORC_ISNAN(_src1.i)) var34.i = _src1.i;
      else if (ORC_ISNAN(_src2.i)) var34.i = _src2.i;
      else var34.i = (_src1.f > _src2.f) ? _src1.i : _src2.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_minf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: minf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      _src1.i = ORC_DENORMAL(var32.i);
      _src2.i = ORC_DENORMAL(var33.i);
      if (ORC_ISNAN(_src1.i)) var34.i = _src1.i;
      else if (ORC_ISNAN(_src2.i)) var34.i = _src2.i;
      else var34.i = (_src1.f < _src2.f) ? _src1.i : _src2.i;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_cmpeqf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: cmpeqf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       var34.i = (_src1.f == _src2.f) ? (~0) : 0;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_cmpltf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: cmpltf */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       var34.i = (_src1.f < _src2.f) ? (~0) : 0;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_cmplef (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];
  ptr5 = (orc_union32 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: loadl */
    var33 = ptr5[i];
    /* 2: cmplef */
    {
       orc_union32 _src1;
       orc_union32 _src2;
       _src1.i = ORC_DENORMAL(var32.i);
       _src2.i = ORC_DENORMAL(var33.i);
       var34.i = (_src1.f <= _src2.f) ? (~0) : 0;
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
emulate_convfl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfl */
    {
       int tmp;
       tmp = (int)var32.f;
       if (tmp == 0x80000000 && !(var32.i&0x80000000)) tmp = 0x7fffffff;
       var33.i = tmp;
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convlf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convlf */
    var33.f = var32.i;
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_addd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: addd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest1.f = _src1.f + _src2.f;
       var34.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_subd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: subd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest1.f = _src1.f - _src2.f;
       var34.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_muld (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: muld */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest1.f = _src1.f * _src2.f;
       var34.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_divd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: divd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       _dest1.f = _src1.f / _src2.f;
       var34.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_sqrtd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: sqrtd */
    {
       orc_union64 _src1;
       orc_union64 _dest1;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _dest1.f = sqrt(_src1.f);
       var33.i = ORC_DENORMAL_DOUBLE(_dest1.i);
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_maxd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: maxd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
      if (ORC_ISNAN_DOUBLE(_src1.i)) var34.i = _src1.i;
      else if (ORC_ISNAN_DOUBLE(_src2.i)) var34.i = _src2.i;
      else var34.i = (_src1.f > _src2.f) ? _src1.i : _src2.i;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_mind (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: mind */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
      if (ORC_ISNAN_DOUBLE(_src1.i)) var34.i = _src1.i;
      else if (ORC_ISNAN_DOUBLE(_src2.i)) var34.i = _src2.i;
      else var34.i = (_src1.f < _src2.f) ? _src1.i : _src2.i;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_cmpeqd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: cmpeqd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       var34.i = (_src1.f == _src2.f) ? ORC_UINT64_C(~0) : 0;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_cmpltd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: cmpltd */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       var34.i = (_src1.f < _src2.f) ? ORC_UINT64_C(~0) : 0;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_cmpled (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];
  ptr5 = (orc_union64 *)ex->src_ptrs[1];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: loadq */
    var33 = ptr5[i];
    /* 2: cmpled */
    {
       orc_union64 _src1;
       orc_union64 _src2;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _src2.i = ORC_DENORMAL_DOUBLE(var33.i);
       var34.i = (_src1.f <= _src2.f) ? ORC_UINT64_C(~0) : 0;
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
emulate_convdl (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdl */
    {
       int tmp;
       tmp = var32.f;
       if (tmp == 0x80000000 && !(var32.i & ORC_UINT64_C(0x8000000000000000))) tmp = 0x7fffffff;
       var33.i = tmp;
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
emulate_convld (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convld */
    var33.f = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_convfd (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *)ex->dest_ptrs[0];
  ptr4 = (orc_union32 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: convfd */
    {
       orc_union32 _src1;
       _src1.i = ORC_DENORMAL(var32.i);
       var33.f = _src1.f;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
emulate_convdf (OrcOpcodeExecutor *ex, int offset, int n)
{
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->dest_ptrs[0];
  ptr4 = (orc_union64 *)ex->src_ptrs[0];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr4[i];
    /* 1: convdf */
    {
       orc_union64 _src1;
       orc_union32 _dest;
       _src1.i = ORC_DENORMAL_DOUBLE(var32.i);
       _dest.f = _src1.f;
       var33.i = ORC_DENORMAL(_dest.i);
    }
    /* 2: storel */
    ptr0[i] = var33;
  }

}

