---
title: References
---

# References

Sources and references may be standards or can also be dictionaries, journal style guides (such as *The Economist Style Guide for English*), and other available sources that provide guidance as to common practice. Online sources are preferred where available, since they can be more easily checked.

The goal is to follow common, customary practice. For example, language or territory display names should use the most recognizable name in common usage. *This is generally not the official name.* For example, one would use "Switzerland" not "Swiss Confederation".

Here are some possible resources for comparison of locale data. *This is* ***not*** *an endorsement of the sources, merely a collation of possibly\-useful links.* To suggest additions to this list, file a [Bug Report](http://www.unicode.org/cldr/filing_bug_reports.html).

### General

- [CIA World Factbook](https://www.cia.gov/the-world-factbook/)

*For English, The Economist Style Guide* (unfortunately only hard copy):

- http://www.amazon.com/exec/obidos/tg/detail/-/186197535X

For other languages, there should be similar guides for major publications.

### Exemplar Characters

- https://developer.mimer.com
- http://www.eki.ee/letter/
- http://en.wikipedia.org/wiki/Alphabets_derived_from_the_Latin
- http://www.omniglot.com/writing/
- http://www.geonames.de/alphab.html
- [UNGEGN: Working Group on Romanization Systems](http://www.eki.ee/wgrs/)

### Language Names

- http://www.geonames.de/

### Territory / Region Names

- http://unstats.un.org/unsd/geoinfo/
- http://www.eki.ee/knn/lingid2.htm#WRLD
- http://www.p.lodz.pl/I35/personal/jw37/EUROPE/europe.html
- http://www.geonames.de/
	- http://www.worldlanguage.com/Arabic/Countries/ (Use the links at the top switch languages)

### Currencies

- http://publications.eu.int/code/es/es-5000500.htm (Replace es with desired language code)
- http://publications.eu.int/code/es/es-5000700.htm
- http://publications.eu.int/
- http://www.geonames.de/
- http://www.globalfindata.com/gh/index.html

### Collation

- http://www.omniglot.com/writing/
	- http://www.alphabets-world.com/
- https://developer.mimer.com

### Dates and Times

- https://docs.microsoft.com/en-us/dotnet/standard/globalization-localization/globalization-icu
- http://www.geonames.de/

### Transliteration

- [UNGEGN: Working Group on Romanization Systems](http://www.eki.ee/wgrs/)
- [Transliteration of Non\-Roman Alphabets and Scripts](http://www.eki.ee/transliteration/)
- [Standards for Archival Description: Romanization](http://www.archivists.org/catalog/stds99/chapter8.html)
- [ISO\-15915 (Hindi)](http://ee.www.ee/transliteration/pdf/Hindi-Marathi-Nepali.pdf)
- [ISO\-15915 (Gujarati)](http://ee.www.ee/transliteration/pdf/Gujarati.pdf)
- [ISO\-15915 (Kannada)](http://ee.www.ee/transliteration/pdf/Kannada.pdf)
- [ISCII\-91](http://www.cdacindia.com/html/gist/down/iscii_d.asp)

