; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s
; RUN: llc -mtriple=aarch64-windows-pc-msvc < %s | FileCheck -check-prefix=WINDOWS %s

declare double @llvm.powi.f64.i32(double, i32)
declare float  @llvm.powi.f32.i32(float,  i32)
declare float  @pow(double noundef, double noundef)

define float @powi_f32_4(float %x) nounwind {
; CHECK-LABEL: powi_f32_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul s0, s0, s0
; CHECK-NEXT:    fmul s0, s0, s0
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: powi_f32_4:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    fmul s0, s0, s0
; WINDOWS-NEXT:    fmul s0, s0, s0
; WINDOWS-NEXT:    ret
  %1 = tail call float @llvm.powi.f32.i32(float %x, i32 4)
  ret float %1
}

define double @powi_f64_3(double %x) nounwind {
; CHECK-LABEL: powi_f64_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul d1, d0, d0
; CHECK-NEXT:    fmul d0, d0, d1
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: powi_f64_3:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    fmul d1, d0, d0
; WINDOWS-NEXT:    fmul d0, d0, d1
; WINDOWS-NEXT:    ret
  %1 = tail call double @llvm.powi.f64.i32(double %x, i32 3)
  ret double %1
}

define float @powi_f32(float %x, i32 %n) nounwind {
; CHECK-LABEL: powi_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    b __powisf2
;
; WINDOWS-LABEL: powi_f32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    scvtf s1, w0
; WINDOWS-NEXT:    b powf
  %ret = tail call float @llvm.powi.f32.i32(float %x, i32 %n)
  ret float %ret
}

define double @powi_f64(double %x, i32 %n) nounwind {
; CHECK-LABEL: powi_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    b __powidf2
;
; WINDOWS-LABEL: powi_f64:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    scvtf d1, w0
; WINDOWS-NEXT:    b pow
  %ret = tail call double @llvm.powi.f64.i32(double %x, i32 %n)
  ret double %ret
}
