/*
 * FileManager-Actions
 * A file-manager extension which offers configurable context menu actions.
 *
 * Copyright (C) 2005 The GNOME Foundation
 * Copyright (C) 2006-2008 Frederic Ruaudel and others (see AUTHORS)
 * Copyright (C) 2009-2015 Pierre Wieser and others (see AUTHORS)
 *
 * FileManager-Actions is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * FileManager-Actions is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileManager-Actions; see the file COPYING. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *   Frederic Ruaudel <grumz@grumz.net>
 *   Rodrigo Moya <rodrigo@gnome-db.org>
 *   Pierre Wieser <pwieser@trychlos.org>
 *   ... and many others (see AUTHORS)
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <api/fma-ifactory-object-data.h>
#include <api/fma-data-def.h>
#include <api/fma-data-types.h>

/*
 * As of 3.2 non copyables data are:
 * - the parent pointer
 */

FMADataDef data_def_id [] = {

	/* this data is marked non readable / non writable as it has to be read
	 * written specifically when serializing / deserializing items
	 */
	{ FMAFO_DATA_ID,
				FALSE,
				FALSE,
				TRUE,
				"FMAObjectId identifier",
				"Internal identifier of the FMAObjectId object. " \
				"Historically a UUID used as a GConf directory (thus ASCII, case insensitive), " \
				"it is also the basename of the .desktop file (thus UTF-8, case sensitive).",
				FMA_DATA_TYPE_STRING,
				"",
				FALSE,
				TRUE,
				TRUE,
				TRUE,			/* mandatory */
				FALSE,
				NULL,
				NULL,
				0,
				NULL,
				0,
				0,
				NULL,
				NULL },

	/* dynamic data, so not readable / not writable
	 */
	{ FMAFO_DATA_PARENT,
				FALSE,
				FALSE,
				TRUE,
				"FMAObjectId Parent",
				"The FMAObjectItem which is the parent of this object.",
				FMA_DATA_TYPE_POINTER,
				NULL,
				FALSE,
				FALSE,
				FALSE,
				FALSE,
				FALSE,
				NULL,
				NULL,
				0,
				NULL,
				0,
				0,
				NULL,
				NULL },

	{ NULL },
};
