# Migrate fish_variables.x86_64 -> fish_variables.
# Cygwin has dropped support for i686, so as of fish 3.6.1 we no longer keep
# separate fish_variables files for different architectures.

if not set -q __fish_variables_migrated

	begin

		flock 9

		# Kill other running fishes, in case some of them are old
		# and still using fish_variables.x86_64
		pgrep fish | grep -v \^$fish_pid\$ | xargs -r kill

		if test -f $__fish_config_dir/fish_variables.x86_64
			mv -f $__fish_config_dir/fish_variables.x86_64 $__fish_config_dir/fish_variables
			echo "Migrated $__fish_config_dir/fish_variables.x86_64 -> $__fish_config_dir/fish_variables"
		end

		set -U __fish_variables_migrated
		flock -u 9

	end 9>$__fish_config_dir/fish_variables.lock

	# Restart fish
	exec fish $argv

end
