
include(FindPkgConfig)

if(PKG_CONFIG_FOUND)
	pkg_check_modules(PULSE libpulse)
endif()

find_path(PULSE_INCLUDE_DIR pulse/pulseaudio.h PATHS ${PULSE_INCLUDE_DIRS} PATH_SUFFIXES pulse )
find_library(PULSE_LIBRARY pulse PATHS ${PULSE_LIBRARY_DIRS})

FIND_PACKAGE_HANDLE_STANDARD_ARGS(Pulse DEFAULT_MSG PULSE_INCLUDE_DIR PULSE_LIBRARY)

if(PULSE_LIBRARY)
	set(PULSE_FOUND 1)
	
	file(STRINGS "${PULSE_INCLUDE_DIR}/pulse/version.h" STR1 REGEX "PA_MAJOR")
	file(STRINGS "${PULSE_INCLUDE_DIR}/pulse/version.h" STR2 REGEX "PA_MINOR")
	file(STRINGS "${PULSE_INCLUDE_DIR}/pulse/version.h" STR3 REGEX "PA_MICRO")

	string(REGEX MATCHALL "[0-9]+" PULSE_VERSION_MAJOR ${STR1})
	string(REGEX MATCHALL "[0-9]+" PULSE_VERSION_MINOR ${STR2})
	string(REGEX MATCHALL "[0-9]+" PULSE_VERSION_PATCH ${STR3})
	
	if(PULSE_VERSION_PATCH EQUAL 0)
		set(PULSE_VERSION "${PULSE_VERSION_MAJOR}.${PULSE_VERSION_MINOR}")
	else()
		set(PULSE_VERSION "${PULSE_VERSION_MAJOR}.${PULSE_VERSION_MINOR}.${PULSE_VERSION_PATCH}")
	endif()
endif()

mark_as_advanced(PULSE_INCLUDE_DIR PULSE_LIBRARY PULSE_VERSION PULSE_VERSION_MAJOR PULSE_VERSION_MINOR PULSE_VERSION_PATCH)

