/* search-provider.c generated by valac 0.36.4, the Vala compiler
 * generated from search-provider.vala, do not modify */

/*
 * Copyright (C) 2014  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgweather/gweather.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define CLOCKS_TYPE_SEARCH_PROVIDER (clocks_search_provider_get_type ())
#define CLOCKS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProvider))
#define CLOCKS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))
#define CLOCKS_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))

typedef struct _ClocksSearchProvider ClocksSearchProvider;
typedef struct _ClocksSearchProviderClass ClocksSearchProviderClass;
typedef struct _ClocksSearchProviderPrivate ClocksSearchProviderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gweather_location_unref0(var) ((var == NULL) ? NULL : (var = (gweather_location_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ClocksSearchProviderSearchLocationsRecurseData ClocksSearchProviderSearchLocationsRecurseData;
typedef struct _Block7Data Block7Data;
typedef struct _ClocksSearchProviderSearchLocationsData ClocksSearchProviderSearchLocationsData;
typedef struct _ClocksSearchProviderGetInitialResultSetData ClocksSearchProviderGetInitialResultSetData;
typedef struct _ClocksSearchProviderGetSubsearchResultSetData ClocksSearchProviderGetSubsearchResultSetData;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL,
	CLOCKS_SEARCH_PROVIDER_LAST_SIGNAL
};
static guint clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_LAST_SIGNAL] = {0};

struct _ClocksSearchProvider {
	GObject parent_instance;
	ClocksSearchProviderPrivate * priv;
};

struct _ClocksSearchProviderClass {
	GObjectClass parent_class;
};

struct _ClocksSearchProviderSearchLocationsRecurseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ClocksSearchProvider* self;
	GWeatherLocation* location;
	gchar** normalized_terms;
	gint normalized_terms_length1;
	GPtrArray* matches;
	GWeatherLocation** locations;
	GWeatherLocation* _tmp0_;
	GWeatherLocation** _tmp1_;
	GWeatherLocation** _tmp2_;
	GWeatherLocation** _tmp3_;
	gint _tmp3__length1;
	gint locations_length1;
	gint _locations_size_;
	GWeatherLocation** _tmp4_;
	gint _tmp4__length1;
	gint i;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GWeatherLocation** _tmp8_;
	gint _tmp8__length1;
	GWeatherLocation** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	GWeatherLocation* _tmp11_;
	GWeatherLocationLevel _tmp12_;
	GWeatherLocation** _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GWeatherLocation* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gboolean _tmp17_;
	GPtrArray* _tmp18_;
	GWeatherLocation** _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_;
	GWeatherLocation* _tmp21_;
	GWeatherLocation* _tmp22_;
	GWeatherLocation** _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	GWeatherLocation* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GPtrArray* _tmp27_;
};

struct _Block7Data {
	int _ref_count_;
	ClocksSearchProvider* self;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gpointer _async_data_;
};

struct _ClocksSearchProviderSearchLocationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ClocksSearchProvider* self;
	gchar** normalized_terms;
	gint normalized_terms_length1;
	gchar** result;
	gint result_length1;
	Block7Data* _data7_;
	GWeatherLocation* world;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GPtrArray* matches;
	GPtrArray* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
};

struct _ClocksSearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ClocksSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
};

struct _ClocksSearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ClocksSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** normalized_terms;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gint normalized_terms_length1;
	gint _normalized_terms_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _result_;
	gchar** _tmp8_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** str_collection;
	gint str_collection_length1;
	gint _str_collection_size_;
	gint str_it;
	gchar* _tmp10_;
	gchar* str;
	GWeatherLocation* location;
	const gchar* _tmp11_;
	GWeatherLocation* _tmp12_;
	gboolean _tmp13_;
	GWeatherLocation* _tmp14_;
	GWeatherLocation* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gboolean _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*get_thumb_properties) (ClocksContentItem* self, gchar* * text, gchar* * subtext, GdkPixbuf* * pixbuf, gchar* * css_class);
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
	const gchar* (*get_title_icon) (ClocksContentItem* self);
	void (*set_title_icon) (ClocksContentItem* self, const gchar* value);
	gboolean (*get_selectable) (ClocksContentItem* self);
	void (*set_selectable) (ClocksContentItem* self, gboolean value);
	gboolean (*get_selected) (ClocksContentItem* self);
	void (*set_selected) (ClocksContentItem* self, gboolean value);
};


static gpointer clocks_search_provider_parent_class = NULL;

GType clocks_search_provider_get_type (void) G_GNUC_CONST;
guint clocks_search_provider_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
enum  {
	CLOCKS_SEARCH_PROVIDER_DUMMY_PROPERTY
};
static gchar** clocks_search_provider_normalize_terms (ClocksSearchProvider* self, gchar** terms, int terms_length1, int* result_length1);
static void _g_free0_ (gpointer var);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean clocks_search_provider_location_matches (ClocksSearchProvider* self, GWeatherLocation* location, gchar** normalized_terms, int normalized_terms_length1);
static gchar* clocks_search_provider_serialize_location (ClocksSearchProvider* self, GWeatherLocation* location);
static GWeatherLocation* clocks_search_provider_deserialize_location (ClocksSearchProvider* self, const gchar* str);
static void clocks_search_provider_search_locations_recurse_data_free (gpointer _data);
static void clocks_search_provider_search_locations_recurse_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void clocks_search_provider_search_locations_recurse (ClocksSearchProvider* self, GWeatherLocation* location, gchar** normalized_terms, int normalized_terms_length1, GPtrArray* matches, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_search_provider_search_locations_recurse_finish (ClocksSearchProvider* self, GAsyncResult* _res_);
static gboolean clocks_search_provider_search_locations_recurse_co (ClocksSearchProviderSearchLocationsRecurseData* _data_);
static GWeatherLocation** _vala_array_dup3 (GWeatherLocation** self, int length);
static void clocks_search_provider_search_locations_recurse_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void clocks_search_provider_search_locations_data_free (gpointer _data);
static void clocks_search_provider_search_locations_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void clocks_search_provider_search_locations (ClocksSearchProvider* self, gchar** normalized_terms, int normalized_terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** clocks_search_provider_search_locations_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean clocks_search_provider_search_locations_co (ClocksSearchProviderSearchLocationsData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _gweather_location_unref0_ (gpointer var);
static void clocks_search_provider_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda4_ (Block7Data* _data7_, GWeatherLocation* location);
static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value);
static void ___lambda4__gfunc (gconstpointer data, gpointer self);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void clocks_search_provider_get_initial_result_set_data_free (gpointer _data);
static void clocks_search_provider_get_initial_result_set_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** clocks_search_provider_get_initial_result_set_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean clocks_search_provider_get_initial_result_set_co (ClocksSearchProviderGetInitialResultSetData* _data_);
static void clocks_search_provider_get_initial_result_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void clocks_search_provider_get_subsearch_result_set_data_free (gpointer _data);
static void clocks_search_provider_get_subsearch_result_set_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
void clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self, gchar** previous_results, int previous_results_length1, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** clocks_search_provider_get_subsearch_result_set_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean clocks_search_provider_get_subsearch_result_set_co (ClocksSearchProviderGetSubsearchResultSetData* _data_);
static void clocks_search_provider_get_subsearch_result_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value);
GHashTable** clocks_search_provider_get_result_metas (ClocksSearchProvider* self, gchar** results, int results_length1, int* result_length1);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GType clocks_world_item_get_type (void) G_GNUC_CONST;
ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location);
gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
static GVariant* _variant_new1 (gchar* value);
static GVariant* _variant_new2 (const gchar* value);
GType clocks_content_item_get_type (void) G_GNUC_CONST;
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
static GVariant* _variant_new3 (const gchar* value);
static GHashTable** _vala_array_dup5 (GHashTable** self, int length);
void clocks_search_provider_activate_result (ClocksSearchProvider* self, const gchar* _result_, gchar** terms, int terms_length1, guint32 timestamp);
void clocks_search_provider_launch_search (ClocksSearchProvider* self, gchar** terms, int terms_length1, guint32 timestamp);
ClocksSearchProvider* clocks_search_provider_new (void);
ClocksSearchProvider* clocks_search_provider_construct (GType object_type);
static void _dbus_clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_get_initial_result_set_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_get_subsearch_result_set_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_clocks_search_provider_get_result_metas (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_activate_result (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_launch_search (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void clocks_search_provider_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* clocks_search_provider_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean clocks_search_provider_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _clocks_search_provider_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as"};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_clocks_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_clocks_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_initial_result_set_out)};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as"};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_out)};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}"};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_result_metas_in[] = {&_clocks_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_result_metas_out[] = {&_clocks_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_result_metas_out)};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_result = {-1, "result", "s"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_activate_result_in[] = {&_clocks_search_provider_dbus_arg_info_activate_result_result, &_clocks_search_provider_dbus_arg_info_activate_result_terms, &_clocks_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_activate_result_out)};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as"};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_launch_search_in[] = {&_clocks_search_provider_dbus_arg_info_launch_search_terms, &_clocks_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_launch_search_out)};
static const GDBusMethodInfo * const _clocks_search_provider_dbus_method_info[] = {&_clocks_search_provider_dbus_method_info_get_initial_result_set, &_clocks_search_provider_dbus_method_info_get_subsearch_result_set, &_clocks_search_provider_dbus_method_info_get_result_metas, &_clocks_search_provider_dbus_method_info_activate_result, &_clocks_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _clocks_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _clocks_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _clocks_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_clocks_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_clocks_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_clocks_search_provider_dbus_property_info)};
static const GDBusInterfaceVTable _clocks_search_provider_dbus_interface_vtable = {clocks_search_provider_dbus_interface_method_call, clocks_search_provider_dbus_interface_get_property, clocks_search_provider_dbus_interface_set_property};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** clocks_search_provider_normalize_terms (ClocksSearchProvider* self, gchar** terms, int terms_length1, int* result_length1) {
	gchar** result = NULL;
	GPtrArray* normalized_terms = NULL;
	GPtrArray* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GPtrArray* _tmp8_;
	gpointer* _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	normalized_terms = _tmp0_;
	_tmp1_ = terms;
	_tmp1__length1 = terms_length1;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp1_;
		t_collection_length1 = _tmp1__length1;
		for (t_it = 0; t_it < _tmp1__length1; t_it = t_it + 1) {
			gchar* _tmp2_;
			gchar* t = NULL;
			_tmp2_ = g_strdup (t_collection[t_it]);
			t = _tmp2_;
			{
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp3_ = normalized_terms;
				_tmp4_ = t;
				_tmp5_ = g_utf8_normalize (_tmp4_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) -1);
				g_ptr_array_add (_tmp3_, _tmp7_);
				_g_free0 (_tmp6_);
				_g_free0 (t);
			}
		}
	}
	_tmp8_ = normalized_terms;
	_tmp9_ = _tmp8_->pdata;
	_tmp9__length1 = (gint) _tmp8_->len;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup2 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	_g_ptr_array_unref0 (normalized_terms);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean clocks_search_provider_location_matches (ClocksSearchProvider* self, GWeatherLocation* location, gchar** normalized_terms, int normalized_terms_length1) {
	gboolean result = FALSE;
	gchar* city = NULL;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	gchar* country = NULL;
	GWeatherLocation* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = location;
	_tmp1_ = gweather_location_get_city_name (_tmp0_);
	city = _tmp1_;
	_tmp2_ = location;
	_tmp3_ = gweather_location_get_country_name (_tmp2_);
	country = _tmp3_;
	_tmp5_ = city;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = country;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = FALSE;
		_g_free0 (country);
		_g_free0 (city);
		return result;
	}
	_tmp7_ = normalized_terms;
	_tmp7__length1 = normalized_terms_length1;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp7_;
		t_collection_length1 = _tmp7__length1;
		for (t_it = 0; t_it < _tmp7__length1; t_it = t_it + 1) {
			gchar* _tmp8_;
			gchar* t = NULL;
			_tmp8_ = g_strdup (t_collection[t_it]);
			t = _tmp8_;
			{
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp10_ = city;
				_tmp11_ = g_utf8_normalize (_tmp10_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_utf8_casefold (_tmp12_, (gssize) -1);
				_tmp14_ = _tmp13_;
				_tmp15_ = t;
				_tmp16_ = string_contains (_tmp14_, _tmp15_);
				_tmp17_ = !_tmp16_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				if (_tmp17_) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					gboolean _tmp24_;
					_tmp18_ = country;
					_tmp19_ = g_utf8_normalize (_tmp18_, (gssize) -1, G_NORMALIZE_DEFAULT);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) -1);
					_tmp22_ = _tmp21_;
					_tmp23_ = t;
					_tmp24_ = string_contains (_tmp22_, _tmp23_);
					_tmp9_ = !_tmp24_;
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					result = FALSE;
					_g_free0 (t);
					_g_free0 (country);
					_g_free0 (city);
					return result;
				}
				_g_free0 (t);
			}
		}
	}
	result = TRUE;
	_g_free0 (country);
	_g_free0 (city);
	return result;
}


static gchar* clocks_search_provider_serialize_location (ClocksSearchProvider* self, GWeatherLocation* location) {
	gchar* result = NULL;
	GWeatherLocation* _tmp0_;
	GVariant* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	_tmp1_ = gweather_location_serialize (_tmp0_);
	_tmp2_ = g_variant_print (_tmp1_, FALSE);
	result = _tmp2_;
	return result;
}


static gpointer _gweather_location_ref0 (gpointer self) {
	return self ? gweather_location_ref (self) : NULL;
}


static GWeatherLocation* clocks_search_provider_deserialize_location (ClocksSearchProvider* self, const gchar* str) {
	GWeatherLocation* result = NULL;
	GVariant* variant = NULL;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp9_;
	GWeatherLocation* _tmp10_;
	GWeatherLocation* _tmp11_;
	GVariant* _tmp12_;
	GWeatherLocation* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	{
		GVariant* _tmp0_ = NULL;
		GVariantType* _tmp1_;
		GVariantType* _tmp2_;
		const gchar* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp1_ = g_variant_type_new ("(uv)");
		_tmp2_ = _tmp1_;
		_tmp3_ = str;
		_tmp4_ = g_variant_parse (_tmp2_, _tmp3_, NULL, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_variant_type_free0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
				goto __catch10_g_variant_parse_error;
			}
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp0_;
		_tmp0_ = NULL;
		_g_variant_unref0 (variant);
		variant = _tmp6_;
		_g_variant_unref0 (_tmp0_);
	}
	goto __finally10;
	__catch10_g_variant_parse_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("search-provider.vala:63: Malformed variant: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		return result;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = gweather_location_get_world ();
	_tmp10_ = _gweather_location_ref0 (_tmp9_);
	world = _tmp10_;
	_tmp11_ = world;
	_tmp12_ = variant;
	_tmp13_ = gweather_location_deserialize (_tmp11_, _tmp12_);
	result = _tmp13_;
	_gweather_location_unref0 (world);
	_g_variant_unref0 (variant);
	return result;
}


static void clocks_search_provider_search_locations_recurse_data_free (gpointer _data) {
	ClocksSearchProviderSearchLocationsRecurseData* _data_;
	_data_ = _data;
	_gweather_location_unref0 (_data_->location);
	_g_ptr_array_unref0 (_data_->matches);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderSearchLocationsRecurseData, _data_);
}


static void clocks_search_provider_search_locations_recurse_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ClocksSearchProviderSearchLocationsRecurseData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void clocks_search_provider_search_locations_recurse (ClocksSearchProvider* self, GWeatherLocation* location, gchar** normalized_terms, int normalized_terms_length1, GPtrArray* matches, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksSearchProviderSearchLocationsRecurseData* _data_;
	ClocksSearchProvider* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	_data_ = g_slice_new0 (ClocksSearchProviderSearchLocationsRecurseData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, clocks_search_provider_search_locations_recurse_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_search_locations_recurse_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = location;
	_tmp2_ = _gweather_location_ref0 (_tmp1_);
	_gweather_location_unref0 (_data_->location);
	_data_->location = _tmp2_;
	_tmp3_ = normalized_terms;
	_tmp3__length1 = normalized_terms_length1;
	_data_->normalized_terms = _tmp3_;
	_data_->normalized_terms_length1 = _tmp3__length1;
	_tmp4_ = matches;
	_tmp5_ = _g_ptr_array_ref0 (_tmp4_);
	_g_ptr_array_unref0 (_data_->matches);
	_data_->matches = _tmp5_;
	clocks_search_provider_search_locations_recurse_co (_data_);
}


static void clocks_search_provider_search_locations_recurse_finish (ClocksSearchProvider* self, GAsyncResult* _res_) {
	ClocksSearchProviderSearchLocationsRecurseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static GWeatherLocation** _vala_array_dup3 (GWeatherLocation** self, int length) {
	GWeatherLocation** result;
	int i;
	result = g_new0 (GWeatherLocation*, length + 1);
	for (i = 0; i < length; i++) {
		GWeatherLocation* _tmp0_;
		_tmp0_ = _gweather_location_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void clocks_search_provider_search_locations_recurse_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksSearchProviderSearchLocationsRecurseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	clocks_search_provider_search_locations_recurse_co (_data_);
}


static gboolean clocks_search_provider_search_locations_recurse_co (ClocksSearchProviderSearchLocationsRecurseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->location;
	_data_->_tmp2_ = _data_->_tmp1_ = gweather_location_get_children (_data_->_tmp0_);
	_data_->_tmp3_ = (_data_->_tmp2_ != NULL) ? _vala_array_dup3 (_data_->_tmp2_, _vala_array_length (_data_->_tmp1_)) : ((gpointer) _data_->_tmp2_);
	_data_->_tmp3__length1 = _vala_array_length (_data_->_tmp1_);
	_data_->locations = _data_->_tmp3_;
	_data_->locations_length1 = _data_->_tmp3__length1;
	_data_->_locations_size_ = _data_->locations_length1;
	_data_->_tmp4_ = _data_->locations;
	_data_->_tmp4__length1 = _data_->locations_length1;
	if (_data_->_tmp4_ != NULL) {
		{
			_data_->i = 0;
			{
				_data_->_tmp5_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp5_) {
						_data_->_tmp6_ = _data_->i;
						_data_->i = _data_->_tmp6_ + 1;
					}
					_data_->_tmp5_ = FALSE;
					_data_->_tmp7_ = _data_->i;
					_data_->_tmp8_ = _data_->locations;
					_data_->_tmp8__length1 = _data_->locations_length1;
					if (!(_data_->_tmp7_ < _data_->_tmp8__length1)) {
						break;
					}
					_data_->_tmp9_ = _data_->locations;
					_data_->_tmp9__length1 = _data_->locations_length1;
					_data_->_tmp10_ = _data_->i;
					_data_->_tmp11_ = _data_->_tmp9_[_data_->_tmp10_];
					_data_->_tmp12_ = gweather_location_get_level (_data_->_tmp11_);
					if (_data_->_tmp12_ == GWEATHER_LOCATION_CITY) {
						_data_->_tmp13_ = _data_->locations;
						_data_->_tmp13__length1 = _data_->locations_length1;
						_data_->_tmp14_ = _data_->i;
						_data_->_tmp15_ = _data_->_tmp13_[_data_->_tmp14_];
						_data_->_tmp16_ = _data_->normalized_terms;
						_data_->_tmp16__length1 = _data_->normalized_terms_length1;
						_data_->_tmp17_ = clocks_search_provider_location_matches (_data_->self, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp16__length1);
						if (_data_->_tmp17_) {
							_data_->_tmp18_ = _data_->matches;
							_data_->_tmp19_ = _data_->locations;
							_data_->_tmp19__length1 = _data_->locations_length1;
							_data_->_tmp20_ = _data_->i;
							_data_->_tmp21_ = _data_->_tmp19_[_data_->_tmp20_];
							_data_->_tmp22_ = _gweather_location_ref0 (_data_->_tmp21_);
							g_ptr_array_add (_data_->_tmp18_, _data_->_tmp22_);
						}
					}
					_data_->_tmp23_ = _data_->locations;
					_data_->_tmp23__length1 = _data_->locations_length1;
					_data_->_tmp24_ = _data_->i;
					_data_->_tmp25_ = _data_->_tmp23_[_data_->_tmp24_];
					_data_->_tmp26_ = _data_->normalized_terms;
					_data_->_tmp26__length1 = _data_->normalized_terms_length1;
					_data_->_tmp27_ = _data_->matches;
					_data_->_state_ = 1;
					clocks_search_provider_search_locations_recurse (_data_->self, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp26__length1, _data_->_tmp27_, clocks_search_provider_search_locations_recurse_ready, _data_);
					return FALSE;
					_state_1:
					clocks_search_provider_search_locations_recurse_finish (_data_->self, _data_->_res_);
				}
			}
		}
	}
	_data_->locations = (_vala_array_free (_data_->locations, _data_->locations_length1, (GDestroyNotify) gweather_location_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_search_provider_search_locations_data_free (gpointer _data) {
	ClocksSearchProviderSearchLocationsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderSearchLocationsData, _data_);
}


static void clocks_search_provider_search_locations_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ClocksSearchProviderSearchLocationsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void clocks_search_provider_search_locations (ClocksSearchProvider* self, gchar** normalized_terms, int normalized_terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksSearchProviderSearchLocationsData* _data_;
	ClocksSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (ClocksSearchProviderSearchLocationsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, clocks_search_provider_search_locations_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_search_locations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = normalized_terms;
	_tmp1__length1 = normalized_terms_length1;
	_data_->normalized_terms = _tmp1_;
	_data_->normalized_terms_length1 = _tmp1__length1;
	clocks_search_provider_search_locations_co (_data_);
}


static gchar** clocks_search_provider_search_locations_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	ClocksSearchProviderSearchLocationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ClocksSearchProvider* self;
		self = _data7_->self;
		_data7_->_result_ = (_vala_array_free (_data7_->_result_, _data7_->_result__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _gweather_location_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gweather_location_unref (var), NULL));
}


static void clocks_search_provider_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksSearchProviderSearchLocationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	clocks_search_provider_search_locations_co (_data_);
}


static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda4_ (Block7Data* _data7_, GWeatherLocation* location) {
	ClocksSearchProvider* self;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	self = _data7_->self;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = clocks_search_provider_serialize_location (self, _tmp0_);
	_vala_array_add3 (&_data7_->_result_, &_data7_->_result__length1, &_data7_->__result__size_, _tmp1_);
}


static void ___lambda4__gfunc (gconstpointer data, gpointer self) {
	__lambda4_ (self, (GWeatherLocation*) data);
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean clocks_search_provider_search_locations_co (ClocksSearchProviderSearchLocationsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data7_ = g_slice_new0 (Block7Data);
	_data_->_data7_->_ref_count_ = 1;
	_data_->_data7_->self = g_object_ref (_data_->self);
	_data_->_data7_->_async_data_ = _data_;
	_data_->_tmp0_ = gweather_location_get_world ();
	_data_->_tmp1_ = _gweather_location_ref0 (_data_->_tmp0_);
	_data_->world = _data_->_tmp1_;
	_data_->_tmp2_ = g_ptr_array_new_full ((guint) 0, _gweather_location_unref0_);
	_data_->matches = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->normalized_terms;
	_data_->_tmp3__length1 = _data_->normalized_terms_length1;
	_data_->_state_ = 1;
	clocks_search_provider_search_locations_recurse (_data_->self, _data_->world, _data_->_tmp3_, _data_->_tmp3__length1, _data_->matches, clocks_search_provider_search_locations_ready, _data_);
	return FALSE;
	_state_1:
	clocks_search_provider_search_locations_recurse_finish (_data_->self, _data_->_res_);
	_data_->_tmp4_ = g_new0 (gchar*, 0 + 1);
	_data_->_data7_->_result_ = _data_->_tmp4_;
	_data_->_data7_->_result__length1 = 0;
	_data_->_data7_->__result__size_ = _data_->_data7_->_result__length1;
	g_ptr_array_foreach (_data_->matches, ___lambda4__gfunc, _data_->_data7_);
	_data_->_tmp5_ = (_data_->_data7_->_result_ != NULL) ? _vala_array_dup4 (_data_->_data7_->_result_, _data_->_data7_->_result__length1) : ((gpointer) _data_->_data7_->_result_);
	_data_->_tmp5__length1 = _data_->_data7_->_result__length1;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->result_length1 = _data_->_tmp6__length1;
	_data_->result = _data_->_tmp6_;
	_g_ptr_array_unref0 (_data_->matches);
	_gweather_location_unref0 (_data_->world);
	block7_data_unref (_data_->_data7_);
	_data_->_data7_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_search_provider_get_initial_result_set_data_free (gpointer _data) {
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderGetInitialResultSetData, _data_);
}


static void clocks_search_provider_get_initial_result_set_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ClocksSearchProviderGetInitialResultSetData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksSearchProviderGetInitialResultSetData* _data_;
	ClocksSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (ClocksSearchProviderGetInitialResultSetData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, clocks_search_provider_get_initial_result_set_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = terms;
	_tmp1__length1 = terms_length1;
	_data_->terms = _tmp1_;
	_data_->terms_length1 = _tmp1__length1;
	clocks_search_provider_get_initial_result_set_co (_data_);
}


gchar** clocks_search_provider_get_initial_result_set_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void clocks_search_provider_get_initial_result_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	clocks_search_provider_get_initial_result_set_co (_data_);
}


static gboolean clocks_search_provider_get_initial_result_set_co (ClocksSearchProviderGetInitialResultSetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->terms;
	_data_->_tmp0__length1 = _data_->terms_length1;
	_data_->_tmp2_ = clocks_search_provider_normalize_terms (_data_->self, _data_->_tmp0_, _data_->_tmp0__length1, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->_state_ = 1;
	clocks_search_provider_search_locations (_data_->self, _data_->_tmp3_, _data_->_tmp1_, clocks_search_provider_get_initial_result_set_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = clocks_search_provider_search_locations_finish (_data_->self, _data_->_res_, &_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp4_;
	_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = _data_->_tmp6__length1;
	_data_->result_length1 = _data_->_tmp7__length1;
	_data_->result = _data_->_tmp7_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_search_provider_get_subsearch_result_set_data_free (gpointer _data) {
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderGetSubsearchResultSetData, _data_);
}


static void clocks_search_provider_get_subsearch_result_set_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	ClocksSearchProviderGetSubsearchResultSetData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self, gchar** previous_results, int previous_results_length1, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	ClocksSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_data_ = g_slice_new0 (ClocksSearchProviderGetSubsearchResultSetData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, clocks_search_provider_get_subsearch_result_set_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = previous_results;
	_tmp1__length1 = previous_results_length1;
	_data_->previous_results = _tmp1_;
	_data_->previous_results_length1 = _tmp1__length1;
	_tmp2_ = terms;
	_tmp2__length1 = terms_length1;
	_data_->terms = _tmp2_;
	_data_->terms_length1 = _tmp2__length1;
	clocks_search_provider_get_subsearch_result_set_co (_data_);
}


gchar** clocks_search_provider_get_subsearch_result_set_finish (ClocksSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void clocks_search_provider_get_subsearch_result_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	clocks_search_provider_get_subsearch_result_set_co (_data_);
}


static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean clocks_search_provider_get_subsearch_result_set_co (ClocksSearchProviderGetSubsearchResultSetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->terms;
	_data_->_tmp0__length1 = _data_->terms_length1;
	_data_->_tmp2_ = clocks_search_provider_normalize_terms (_data_->self, _data_->_tmp0_, _data_->_tmp0__length1, &_data_->_tmp1_);
	_data_->normalized_terms = _data_->_tmp2_;
	_data_->normalized_terms_length1 = _data_->_tmp1_;
	_data_->_normalized_terms_size_ = _data_->normalized_terms_length1;
	_data_->_tmp3_ = _data_->previous_results;
	_data_->_tmp3__length1 = _data_->previous_results_length1;
	if (_data_->_tmp3__length1 == 0) {
		_data_->_tmp4_ = _data_->normalized_terms;
		_data_->_tmp4__length1 = _data_->normalized_terms_length1;
		_data_->_state_ = 1;
		clocks_search_provider_search_locations (_data_->self, _data_->_tmp4_, _data_->_tmp4__length1, clocks_search_provider_get_subsearch_result_set_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = clocks_search_provider_search_locations_finish (_data_->self, _data_->_res_, &_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = _data_->_tmp5_;
		_data_->result_length1 = _data_->_tmp7__length1;
		_data_->result = _data_->_tmp7_;
		_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = g_new0 (gchar*, 0 + 1);
	_data_->_result_ = _data_->_tmp8_;
	_data_->_result__length1 = 0;
	_data_->__result__size_ = _data_->_result__length1;
	_data_->_tmp9_ = _data_->previous_results;
	_data_->_tmp9__length1 = _data_->previous_results_length1;
	{
		_data_->str_collection_length1 = 0;
		_data_->_str_collection_size_ = 0;
		_data_->str_collection = _data_->_tmp9_;
		_data_->str_collection_length1 = _data_->_tmp9__length1;
		for (_data_->str_it = 0; _data_->str_it < _data_->_tmp9__length1; _data_->str_it = _data_->str_it + 1) {
			_data_->_tmp10_ = g_strdup (_data_->str_collection[_data_->str_it]);
			_data_->str = _data_->_tmp10_;
			{
				_data_->_tmp11_ = _data_->str;
				_data_->_tmp12_ = clocks_search_provider_deserialize_location (_data_->self, _data_->_tmp11_);
				_data_->location = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->location;
				if (_data_->_tmp14_ != NULL) {
					_data_->_tmp15_ = _data_->location;
					_data_->_tmp16_ = _data_->normalized_terms;
					_data_->_tmp16__length1 = _data_->normalized_terms_length1;
					_data_->_tmp17_ = clocks_search_provider_location_matches (_data_->self, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp16__length1);
					_data_->_tmp13_ = _data_->_tmp17_;
				} else {
					_data_->_tmp13_ = FALSE;
				}
				if (_data_->_tmp13_) {
					_data_->_tmp18_ = _data_->_result_;
					_data_->_tmp18__length1 = _data_->_result__length1;
					_data_->_tmp19_ = _data_->str;
					_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
					_vala_array_add4 (&_data_->_result_, &_data_->_result__length1, &_data_->__result__size_, _data_->_tmp20_);
				}
				_gweather_location_unref0 (_data_->location);
				_g_free0 (_data_->str);
			}
		}
	}
	_data_->_tmp21_ = _data_->_result_;
	_data_->_tmp21__length1 = _data_->_result__length1;
	_data_->result_length1 = _data_->_tmp21__length1;
	_data_->result = _data_->_tmp21_;
	_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant* _variant_new1 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new2 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static GHashTable** _vala_array_dup5 (GHashTable** self, int length) {
	GHashTable** result;
	int i;
	result = g_new0 (GHashTable*, length + 1);
	for (i = 0; i < length; i++) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GHashTable** clocks_search_provider_get_result_metas (ClocksSearchProvider* self, gchar** results, int results_length1, int* result_length1) {
	GHashTable** result = NULL;
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp0_;
	gint count = 0;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GPtrArray* _tmp44_;
	gpointer* _tmp45_;
	gint _tmp45__length1;
	GHashTable** _tmp46_;
	gint _tmp46__length1;
	GHashTable** _tmp47_;
	gint _tmp47__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_result_ = _tmp0_;
	count = 0;
	_tmp1_ = results;
	_tmp1__length1 = results_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp1_;
		str_collection_length1 = _tmp1__length1;
		for (str_it = 0; str_it < _tmp1__length1; str_it = str_it + 1) {
			gchar* _tmp2_;
			gchar* str = NULL;
			_tmp2_ = g_strdup (str_collection[str_it]);
			str = _tmp2_;
			{
				GWeatherLocation* location = NULL;
				const gchar* _tmp3_;
				GWeatherLocation* _tmp4_;
				GWeatherLocation* _tmp5_;
				GHashTable* meta = NULL;
				GHashFunc _tmp6_;
				GEqualFunc _tmp7_;
				GHashTable* _tmp8_;
				ClocksWorldItem* item = NULL;
				GWeatherLocation* _tmp9_;
				ClocksWorldItem* _tmp10_;
				gchar* time_label = NULL;
				ClocksWorldItem* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* day = NULL;
				ClocksWorldItem* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp24_;
				GHashTable* _tmp25_;
				gchar* _tmp26_;
				gint _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				GVariant* _tmp30_;
				GHashTable* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				GVariant* _tmp34_;
				GHashTable* _tmp35_;
				gchar* _tmp36_;
				ClocksWorldItem* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				GVariant* _tmp40_;
				GPtrArray* _tmp41_;
				GHashTable* _tmp42_;
				GHashTable* _tmp43_;
				_tmp3_ = str;
				_tmp4_ = clocks_search_provider_deserialize_location (self, _tmp3_);
				location = _tmp4_;
				_tmp5_ = location;
				if (_tmp5_ == NULL) {
					_gweather_location_unref0 (location);
					_g_free0 (str);
					continue;
				}
				_tmp6_ = g_str_hash;
				_tmp7_ = g_str_equal;
				_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_variant_unref0_);
				meta = _tmp8_;
				_tmp9_ = location;
				_tmp10_ = clocks_world_item_new (_tmp9_);
				item = _tmp10_;
				_tmp11_ = item;
				_tmp12_ = clocks_world_item_get_time_label (_tmp11_);
				_tmp13_ = _tmp12_;
				time_label = _tmp13_;
				_tmp14_ = item;
				_tmp15_ = clocks_world_item_get_day_label (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup (_tmp16_);
				day = _tmp17_;
				_tmp18_ = day;
				if (_tmp18_ != NULL) {
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp19_ = time_label;
					_tmp20_ = day;
					_tmp21_ = g_strconcat (" ", _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
					_g_free0 (time_label);
					time_label = _tmp23_;
					_g_free0 (_tmp22_);
				}
				_tmp24_ = count;
				count = _tmp24_ + 1;
				_tmp25_ = meta;
				_tmp26_ = g_strdup ("id");
				_tmp27_ = count;
				_tmp28_ = g_strdup_printf ("%i", _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _variant_new1 (_tmp29_);
				g_hash_table_insert (_tmp25_, _tmp26_, _tmp30_);
				_g_free0 (_tmp29_);
				_tmp31_ = meta;
				_tmp32_ = g_strdup ("name");
				_tmp33_ = time_label;
				_tmp34_ = _variant_new2 (_tmp33_);
				g_hash_table_insert (_tmp31_, _tmp32_, _tmp34_);
				_tmp35_ = meta;
				_tmp36_ = g_strdup ("description");
				_tmp37_ = item;
				_tmp38_ = clocks_content_item_get_name ((ClocksContentItem*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = _variant_new3 (_tmp39_);
				g_hash_table_insert (_tmp35_, _tmp36_, _tmp40_);
				_tmp41_ = _result_;
				_tmp42_ = meta;
				_tmp43_ = _g_hash_table_ref0 (_tmp42_);
				g_ptr_array_add (_tmp41_, _tmp43_);
				_g_free0 (day);
				_g_free0 (time_label);
				_g_object_unref0 (item);
				_g_hash_table_unref0 (meta);
				_gweather_location_unref0 (location);
				_g_free0 (str);
			}
		}
	}
	_tmp44_ = _result_;
	_tmp45_ = _tmp44_->pdata;
	_tmp45__length1 = (gint) _tmp44_->len;
	_tmp46_ = (_tmp45_ != NULL) ? _vala_array_dup5 (_tmp45_, _tmp45__length1) : ((gpointer) _tmp45_);
	_tmp46__length1 = _tmp45__length1;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = _tmp46__length1;
	if (result_length1) {
		*result_length1 = _tmp47__length1;
	}
	result = _tmp47_;
	_g_ptr_array_unref0 (_result_);
	return result;
}


void clocks_search_provider_activate_result (ClocksSearchProvider* self, const gchar* _result_, gchar** terms, int terms_length1, guint32 timestamp) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = timestamp;
	g_signal_emit (self, clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL], 0, _tmp0_);
}


void clocks_search_provider_launch_search (ClocksSearchProvider* self, gchar** terms, int terms_length1, guint32 timestamp) {
	g_return_if_fail (self != NULL);
}


ClocksSearchProvider* clocks_search_provider_construct (GType object_type) {
	ClocksSearchProvider * self = NULL;
	self = (ClocksSearchProvider*) g_object_new (object_type, NULL);
	return self;
}


ClocksSearchProvider* clocks_search_provider_new (void) {
	return clocks_search_provider_construct (CLOCKS_TYPE_SEARCH_PROVIDER);
}


static void clocks_search_provider_class_init (ClocksSearchProviderClass * klass) {
	clocks_search_provider_parent_class = g_type_class_peek_parent (klass);
	clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL] = g_signal_new ("activate", CLOCKS_TYPE_SEARCH_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void clocks_search_provider_instance_init (ClocksSearchProvider * self) {
}


GType clocks_search_provider_get_type (void) {
	static volatile gsize clocks_search_provider_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_search_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksSearchProvider), 0, (GInstanceInitFunc) clocks_search_provider_instance_init, NULL };
		GType clocks_search_provider_type_id;
		clocks_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksSearchProvider", &g_define_type_info, 0);
		g_type_set_qdata (clocks_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) clocks_search_provider_register_object);
		g_once_init_leave (&clocks_search_provider_type_id__volatile, clocks_search_provider_type_id);
	}
	return clocks_search_provider_type_id__volatile;
}


static void _dbus_clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	terms = _tmp1_;
	g_variant_unref (_tmp0_);
	clocks_search_provider_get_initial_result_set (self, terms, terms_length1, (GAsyncReadyCallback) _dbus_clocks_search_provider_get_initial_result_set_ready, invocation);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_clocks_search_provider_get_initial_result_set_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	int _tmp6_;
	invocation = _user_data_;
	result = clocks_search_provider_get_initial_result_set_finish ((ClocksSearchProvider*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** previous_results = NULL;
	int previous_results_length1 = 0;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	int _tmp8__length;
	int _tmp8__size;
	int _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	int _tmp12__length;
	int _tmp12__size;
	int _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	terms = _tmp12_;
	g_variant_unref (_tmp11_);
	clocks_search_provider_get_subsearch_result_set (self, previous_results, previous_results_length1, terms, terms_length1, (GAsyncReadyCallback) _dbus_clocks_search_provider_get_subsearch_result_set_ready, invocation);
	previous_results = (_vala_array_free (previous_results, previous_results_length1, (GDestroyNotify) g_free), NULL);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_clocks_search_provider_get_subsearch_result_set_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	int _tmp17_;
	invocation = _user_data_;
	result = clocks_search_provider_get_subsearch_result_set_finish ((ClocksSearchProvider*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_clocks_search_provider_get_result_metas (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** results = NULL;
	int results_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	int _tmp19__length;
	int _tmp19__size;
	int _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	int result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	results = _tmp19_;
	g_variant_unref (_tmp18_);
	result = clocks_search_provider_get_result_metas (self, results, results_length1, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_clocks_search_provider_activate_result (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* _result_ = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	int _tmp31__length;
	int _tmp31__size;
	int _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_result_ = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	clocks_search_provider_activate_result (self, _result_, terms, terms_length1, timestamp);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (_result_);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_clocks_search_provider_launch_search (ClocksSearchProvider* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	int _tmp36__length;
	int _tmp36__size;
	int _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	clocks_search_provider_launch_search (self, terms, terms_length1, timestamp);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void clocks_search_provider_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_clocks_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_clocks_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_clocks_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_clocks_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_clocks_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* clocks_search_provider_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean clocks_search_provider_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint clocks_search_provider_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_clocks_search_provider_dbus_interface_info), &_clocks_search_provider_dbus_interface_vtable, data, _clocks_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _clocks_search_provider_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



