/* grilo-0.2.vapi generated by vapigen-0.30, do not modify. */

[CCode (cprefix = "Grl", gir_namespace = "Grl", gir_version = "0.2", lower_case_cprefix = "grl_")]
namespace Grl {
	[CCode (cheader_filename = "grilo.h", type_id = "grl_caps_get_type ()")]
	public class Caps : GLib.Object {
		[CCode (has_construct_function = false)]
		public Caps ();
		public unowned GLib.List<Grl.KeyID> get_key_filter ();
		public unowned GLib.List<Grl.KeyID> get_key_range_filter ();
		public Grl.TypeFilter get_type_filter ();
		public bool is_key_filter (Grl.KeyID key);
		public bool is_key_range_filter (Grl.KeyID key);
		public void set_key_filter (GLib.List<Grl.KeyID> keys);
		public void set_key_range_filter (GLib.List<Grl.KeyID> keys);
		public void set_type_filter (Grl.TypeFilter filter);
		public bool test_option (string key, GLib.Value value);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_config_get_type ()")]
	public class Config : GLib.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak void*[] _grl_reserved;
		[CCode (has_construct_function = false)]
		public Config (string plugin, string? source);
		public string get_api_key ();
		public uint8 get_api_key_blob (size_t size);
		public string get_api_secret ();
		public string get_api_token ();
		public string get_api_token_secret ();
		public uint8 get_binary (string param, size_t? size);
		public bool get_boolean (string param);
		public float get_float (string param);
		public int get_int (string param);
		public string get_password ();
		public string get_plugin ();
		public string get_source ();
		public string get_string (string param);
		public string get_username ();
		public bool has_param (string param);
		public void @set (string param, GLib.Value value);
		public void set_api_key (string key);
		public void set_api_key_blob (uint8 blob, size_t size);
		public void set_api_secret (string secret);
		public void set_api_token (string token);
		public void set_api_token_secret (string secret);
		public void set_binary (string param, uint8 blob, size_t size);
		public void set_boolean (string param, bool value);
		public void set_float (string param, float value);
		public void set_int (string param, int value);
		public void set_password (string password);
		public void set_plugin (string plugin);
		public void set_source (string source);
		public void set_string (string param, string value);
		public void set_username (string username);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_data_get_type ()")]
	public class Data : GLib.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak void*[] _grl_reserved;
		[CCode (has_construct_function = false)]
		public Data ();
		public void add_binary (Grl.KeyID key, uint8 buf, size_t size);
		public void add_boxed (Grl.KeyID key, void* boxed);
		public void add_float (Grl.KeyID key, float floatvalue);
		public void add_int (Grl.KeyID key, int intvalue);
		public void add_int64 (Grl.KeyID key, int64 intvalue);
		public void add_related_keys (Grl.RelatedKeys relkeys);
		public void add_string (Grl.KeyID key, string strvalue);
		public Grl.Data dup ();
		public unowned GLib.Value? @get (Grl.KeyID key);
		public uint8 get_binary (Grl.KeyID key, out size_t size);
		public bool get_boolean (Grl.KeyID key);
		public void* get_boxed (Grl.KeyID key);
		public float get_float (Grl.KeyID key);
		public int get_int (Grl.KeyID key);
		public int64 get_int64 (Grl.KeyID key);
		public GLib.List<weak Grl.KeyID> get_keys ();
		public unowned Grl.RelatedKeys get_related_keys (Grl.KeyID key, uint index);
		public GLib.List<weak GLib.Value?> get_single_values_for_key (Grl.KeyID key);
		public GLib.List<weak string> get_single_values_for_key_string (Grl.KeyID key);
		public unowned string get_string (Grl.KeyID key);
		public bool has_key (Grl.KeyID key);
		public uint length (Grl.KeyID key);
		public void remove (Grl.KeyID key);
		public void remove_nth (Grl.KeyID key, uint index);
		public void @set (Grl.KeyID key, GLib.Value value);
		public void set_binary (Grl.KeyID key, uint8 buf, size_t size);
		public void set_boolean (Grl.KeyID key, bool boolvalue);
		public void set_boxed (Grl.KeyID key, void* boxed);
		public void set_float (Grl.KeyID key, float floatvalue);
		public void set_int (Grl.KeyID key, int intvalue);
		public void set_int64 (Grl.KeyID key, int64 intvalue);
		public void set_related_keys (Grl.RelatedKeys relkeys, uint index);
		public void set_string (Grl.KeyID key, string strvalue);
	}
	[CCode (cheader_filename = "grilo.h")]
	[Compact]
	public class LogDomain {
		public void free ();
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_media_get_type ()")]
	public class Media : Grl.Data {
		[CCode (has_construct_function = false)]
		public Media ();
		public void add_author (string author);
		public void add_external_player (string player);
		public void add_external_url (string url);
		public void add_keyword (string keyword);
		public void add_region_data (string region, GLib.DateTime publication_date, string certificate);
		public void add_thumbnail (string thumbnail);
		public void add_thumbnail_binary (uint8 thumbnail, size_t size);
		public void add_url_data (string url, string mime);
		public unowned string get_author ();
		public unowned string get_author_nth (uint index);
		public unowned string get_certificate ();
		public unowned GLib.DateTime get_creation_date ();
		public unowned string get_description ();
		public int get_duration ();
		public unowned string get_external_url ();
		public unowned string get_external_url_nth (uint index);
		public bool get_favourite ();
		public unowned string get_id ();
		public unowned string get_keyword ();
		public unowned string get_keyword_nth (uint index);
		public unowned string get_last_played ();
		public int get_last_position ();
		public unowned string get_license ();
		public unowned string get_mime ();
		public unowned GLib.DateTime get_modification_date ();
		public int get_play_count ();
		public unowned string get_player ();
		public unowned string get_player_nth (uint index);
		public unowned GLib.DateTime get_publication_date ();
		public float get_rating ();
		public unowned string get_region ();
		public unowned string get_region_data (out unowned GLib.DateTime publication_date, out unowned string certificate);
		public unowned string get_region_data_nth (uint index, out unowned GLib.DateTime publication_date, out unowned string certificate);
		public unowned string get_site ();
		public int64 get_size ();
		public unowned string get_source ();
		public float get_start_time ();
		public unowned string get_studio ();
		public unowned string get_thumbnail ();
		public uint8 get_thumbnail_binary (size_t size);
		public uint8 get_thumbnail_binary_nth (size_t size, uint index);
		public unowned string get_thumbnail_nth (uint index);
		public unowned string get_title ();
		public unowned string get_url ();
		public unowned string get_url_data (out unowned string mime);
		public unowned string get_url_data_nth (uint index, out unowned string mime);
		public string serialize ();
		public void set_author (string author);
		public void set_certificate (string certificate);
		public void set_creation_date (GLib.DateTime creation_date);
		public void set_description (string description);
		public void set_duration (int duration);
		public void set_external_player (string player);
		public void set_external_url (string url);
		public void set_favourite (bool favourite);
		public void set_id (string id);
		public void set_keyword (string keyword);
		public void set_last_played (string last_played);
		public void set_last_position (int last_position);
		public void set_license (string license);
		public void set_mime (string mime);
		public void set_modification_date (GLib.DateTime modification_date);
		public void set_play_count (int play_count);
		public void set_publication_date (GLib.DateTime date);
		public void set_rating (float rating, float max);
		public void set_region (string region);
		public void set_region_data (string region, GLib.DateTime publication_date, string certificate);
		public void set_site (string site);
		public void set_size (int64 size);
		public void set_source (string source);
		public void set_studio (string studio);
		public void set_thumbnail (string thumbnail);
		public void set_thumbnail_binary (uint8 thumbnail, size_t size);
		public void set_title (string title);
		public void set_url (string url);
		public void set_url_data (string url, string mime);
		public static Grl.Media unserialize (string serial);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_media_audio_get_type ()")]
	public class MediaAudio : Grl.Media {
		[CCode (has_construct_function = false, type = "GrlMedia*")]
		public MediaAudio ();
		public void add_artist (string artist);
		public void add_genre (string genre);
		public void add_lyrics (string lyrics);
		public void add_mb_artist_id (string mb_artist_id);
		public void add_url_data (string url, string mime, int bitrate);
		public unowned string get_album ();
		public unowned string get_artist ();
		public unowned string get_artist_nth (uint index);
		public int get_bitrate ();
		public unowned string get_genre ();
		public unowned string get_genre_nth (uint index);
		public unowned string get_lyrics ();
		public unowned string get_lyrics_nth (uint index);
		public unowned string get_mb_album_id ();
		public unowned string get_mb_artist_id ();
		public unowned string get_mb_artist_id_nth (uint index);
		public unowned string get_mb_recording_id ();
		public unowned string get_mb_track_id ();
		public int get_track_number ();
		public unowned string get_url_data (out unowned string mime, out int bitrate);
		public unowned string get_url_data_nth (uint index, out unowned string mime, out int bitrate);
		public void set_album (string album);
		public void set_artist (string artist);
		public void set_bitrate (int bitrate);
		public void set_genre (string genre);
		public void set_lyrics (string lyrics);
		public void set_mb_album_id (string mb_album_id);
		public void set_mb_artist_id (string mb_artist_id);
		public void set_mb_recording_id (string mb_recording_id);
		public void set_mb_track_id (string mb_track_id);
		public void set_track_number (int track_number);
		public void set_url_data (string url, string mime, int bitrate);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_media_box_get_type ()")]
	public class MediaBox : Grl.Media {
		[CCode (has_construct_function = false, type = "GrlMedia*")]
		public MediaBox ();
		public int get_childcount ();
		public void set_childcount (int childcount);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_media_image_get_type ()")]
	public class MediaImage : Grl.Media {
		[CCode (has_construct_function = false, type = "GrlMedia*")]
		public MediaImage ();
		public void add_url_data (string url, string mime, int width, int height);
		public unowned string get_camera_model ();
		public float get_exposure_time ();
		public unowned string get_flash_used ();
		public int get_height ();
		public float get_iso_speed ();
		public int get_orientation ();
		public unowned string get_url_data (out unowned string mime, int width, int height);
		public unowned string get_url_data_nth (uint index, out unowned string mime, int width, int height);
		public int get_width ();
		public void set_camera_model (string camera_model);
		public void set_exposure_time (float exposure_time);
		public void set_flash_used (string flash_used);
		public void set_height (int height);
		public void set_iso_speed (float iso_speed);
		public void set_orientation (int orientation);
		public void set_size (int width, int height);
		public void set_url_data (string url, string mime, int width, int height);
		public void set_width (int width);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_media_video_get_type ()")]
	public class MediaVideo : Grl.Media {
		[CCode (has_construct_function = false, type = "GrlMedia*")]
		public MediaVideo ();
		public void add_director (string director);
		public void add_performer (string performer);
		public void add_producer (string producer);
		public void add_url_data (string url, string mime, float framerate, int width, int height);
		public unowned string get_director ();
		public unowned string get_director_nth (uint index);
		public int get_episode ();
		public unowned string get_episode_title ();
		public float get_framerate ();
		public int get_height ();
		public unowned string get_original_title ();
		public unowned string get_performer ();
		public unowned string get_performer_nth (uint index);
		public unowned string get_producer ();
		public unowned string get_producer_nth (uint index);
		public int get_season ();
		public unowned string get_show ();
		public unowned string get_url_data (out unowned string mime, float framerate, int width, int height);
		public unowned string get_url_data_nth (uint index, out unowned string mime, float framerate, int width, int height);
		public int get_width ();
		public void set_director (string director);
		public void set_episode (int episode);
		public void set_episode_title (string episode_title);
		public void set_framerate (float framerate);
		public void set_height (int height);
		public void set_original_title (string original_title);
		public void set_performer (string performer);
		public void set_producer (string producer);
		public void set_season (int season);
		public void set_show (string show);
		public void set_size (int width, int height);
		public void set_url_data (string url, string mime, float framerate, int width, int height);
		public void set_width (int width);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_operation_options_get_type ()")]
	public class OperationOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public OperationOptions (Grl.Caps? caps);
		public Grl.OperationOptions copy ();
		public int get_count ();
		[Deprecated (since = "0.2.12")]
		public Grl.ResolutionFlags get_flags ();
		public unowned GLib.Value? get_key_filter (Grl.KeyID key);
		public GLib.List<weak Grl.KeyID> get_key_filter_list ();
		public void get_key_range_filter (Grl.KeyID key, out GLib.Value min_value, out GLib.Value max_value);
		public GLib.List<weak Grl.KeyID> get_key_range_filter_list ();
		public Grl.ResolutionFlags get_resolution_flags ();
		public uint get_skip ();
		public Grl.TypeFilter get_type_filter ();
		public bool key_is_set (string key);
		public bool obey_caps (Grl.Caps caps, out Grl.OperationOptions supported_options, out Grl.OperationOptions unsupported_options);
		public bool set_count (int count);
		[Deprecated (since = "0.2.12")]
		public bool set_flags (Grl.ResolutionFlags flags);
		public bool set_key_filter_dictionary (GLib.HashTable<Grl.KeyID,GLib.Value?> filters);
		public bool set_key_filter_value (Grl.KeyID key, GLib.Value value);
		public bool set_key_range_filter_value (Grl.KeyID key, GLib.Value? min_value, GLib.Value? max_value);
		public bool set_resolution_flags (Grl.ResolutionFlags flags);
		public bool set_skip (uint skip);
		public bool set_type_filter (Grl.TypeFilter filter);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_plugin_get_type ()")]
	public class Plugin : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Plugin ();
		public unowned string get_author ();
		public unowned string get_description ();
		public unowned string get_filename ();
		public unowned string get_id ();
		public unowned string get_info (string key);
		public GLib.List<weak string> get_info_keys ();
		public unowned string get_license ();
		public unowned string get_name ();
		public unowned string get_site ();
		public GLib.List<weak Grl.Source> get_sources ();
		public unowned string get_version ();
		public bool load (GLib.List<Grl.Config> configurations);
		public void register_keys ();
		public void set_filename (string filename);
		public void set_id (string id);
		public void set_info (string key, string value);
		public void set_load_func (void* load_function);
		public void set_module (GLib.Module module);
		public void set_optional_info (GLib.HashTable<void*,void*> info);
		public void set_register_keys_func (void* register_keys_function);
		public void set_unload_func (void* unload_function);
		public void unload ();
		[NoAccessorMethod]
		public bool loaded { get; }
	}
	[CCode (cheader_filename = "grilo.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "grl_range_value_get_type ()")]
	[Compact]
	public class RangeValue {
		public GLib.Value max;
		public GLib.Value min;
		[CCode (has_construct_function = false)]
		public RangeValue (GLib.Value min, GLib.Value max);
		public Grl.RangeValue dup ();
		public void free ();
		public static void hashtable_insert (GLib.HashTable<void*,void*> hash_table, void* key, GLib.Value min, GLib.Value max);
		public static GLib.HashTable<void*,Grl.RangeValue> hashtable_new ();
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_registry_get_type ()")]
	public class Registry : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Registry ();
		public bool add_config (owned Grl.Config config) throws GLib.Error;
		public bool add_config_from_file (string config_file) throws GLib.Error;
		public bool add_config_from_resource (string resource_path) throws GLib.Error;
		public void add_directory (string path);
		public static unowned Grl.Registry get_default ();
		public GLib.List<weak Grl.KeyID> get_metadata_keys ();
		public GLib.List<weak Grl.Plugin> get_plugins (bool only_loaded);
		public GLib.List<weak Grl.Source> get_sources (bool ranked);
		public GLib.List<weak Grl.Source> get_sources_by_operations (Grl.SupportedOps ops, bool ranked);
		public bool load_all_plugins () throws GLib.Error;
		public bool load_plugin (string library_filename) throws GLib.Error;
		public bool load_plugin_by_id (string plugin_id) throws GLib.Error;
		public bool load_plugin_directory (string path) throws GLib.Error;
		public Grl.KeyID lookup_metadata_key (string key_name);
		public unowned string lookup_metadata_key_desc (Grl.KeyID key);
		public unowned string lookup_metadata_key_name (Grl.KeyID key);
		public unowned GLib.List<Grl.KeyID> lookup_metadata_key_relation (Grl.KeyID key);
		public GLib.Type lookup_metadata_key_type (Grl.KeyID key);
		public unowned Grl.Plugin lookup_plugin (string plugin_id);
		public unowned Grl.Source lookup_source (string source_id);
		public bool metadata_key_validate (Grl.KeyID key, GLib.Value value);
		public Grl.KeyID register_metadata_key (owned GLib.ParamSpec param_spec) throws GLib.Error;
		public void register_metadata_key_relation (Grl.KeyID key1, Grl.KeyID key2);
		public Grl.KeyID register_metadata_key_system (GLib.ParamSpec param_spec, Grl.KeyID key) throws GLib.Error;
		public bool register_source (Grl.Plugin plugin, owned Grl.Source source) throws GLib.Error;
		public void restrict_plugins (string plugins);
		public void shutdown ();
		public bool unload_plugin (string plugin_id) throws GLib.Error;
		public bool unregister_source (Grl.Source source) throws GLib.Error;
		public signal void metadata_key_added (string key);
		public signal void source_added (Grl.Source source);
		public signal void source_removed (Grl.Source source);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_related_keys_get_type ()")]
	public class RelatedKeys : GLib.Object {
		[CCode (has_construct_function = false)]
		public RelatedKeys ();
		public Grl.RelatedKeys dup ();
		public unowned GLib.Value? @get (Grl.KeyID key);
		public uint8 get_binary (Grl.KeyID key, out size_t size);
		public bool get_boolean (Grl.KeyID key);
		public void* get_boxed (Grl.KeyID key);
		public float get_float (Grl.KeyID key);
		public int get_int (Grl.KeyID key);
		public int64 get_int64 (Grl.KeyID key);
		public GLib.List<weak Grl.KeyID> get_keys ();
		public unowned string get_string (Grl.KeyID key);
		public bool has_key (Grl.KeyID key);
		public void remove (Grl.KeyID key);
		public void @set (Grl.KeyID key, GLib.Value value);
		public void set_binary (Grl.KeyID key, uint8 buf, size_t size);
		public void set_boolean (Grl.KeyID key, bool booleanvalue);
		public void set_boxed (Grl.KeyID key, void* boxed);
		public void set_float (Grl.KeyID key, float floatvalue);
		public void set_int (Grl.KeyID key, int intvalue);
		public void set_int64 (Grl.KeyID key, int64 intvalue);
		public void set_string (Grl.KeyID key, string strvalue);
	}
	[CCode (cheader_filename = "grilo.h", type_id = "grl_source_get_type ()")]
	public abstract class Source : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Source ();
		[NoWrapper]
		public virtual void browse (Grl.SourceBrowseSpec bs);
		public GLib.List<Grl.Media> browse_sync (Grl.Media? container, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
		[NoWrapper]
		public virtual void cancel (uint operation_id);
		[CCode (cname = "grl_source_browse")]
		public uint do_browse (Grl.Media? container, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResultCb callback);
		[CCode (cname = "grl_source_query")]
		public uint do_query (string query, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResultCb callback);
		[CCode (cname = "grl_source_remove")]
		public void do_remove (Grl.Media media, Grl.SourceRemoveCb callback);
		[CCode (cname = "grl_source_resolve")]
		public uint do_resolve (Grl.Media? media, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResolveCb callback);
		[CCode (cname = "grl_source_search")]
		public uint do_search (string text, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResultCb callback);
		[CCode (cname = "grl_source_store")]
		public void do_store (Grl.MediaBox? parent, Grl.Media media, Grl.WriteFlags flags, Grl.SourceStoreCb callback);
		[CCode (cname = "grl_source_store_metadata")]
		public void do_store_metadata (Grl.Media media, GLib.List<Grl.KeyID>? keys, Grl.WriteFlags flags, Grl.SourceStoreCb callback);
		public uint get_auto_split_threshold ();
		public virtual unowned Grl.Caps get_caps (Grl.SupportedOps operation);
		public unowned string get_description ();
		public unowned GLib.Icon get_icon ();
		public unowned string get_id ();
		public uint get_media_from_uri (string uri, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResolveCb callback);
		public Grl.Media get_media_from_uri_sync (string uri, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
		public unowned string get_name ();
		public unowned Grl.Plugin get_plugin ();
		public int get_rank ();
		public Grl.MediaType get_supported_media ();
		[CCode (cname = "grl_source_supported_operations")]
		public uint get_supported_operations ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_tags ();
		public virtual bool may_resolve (Grl.Media media, Grl.KeyID key_id, GLib.List<Grl.KeyID> missing_keys);
		[NoWrapper]
		public virtual void media_from_uri (Grl.SourceMediaFromUriSpec mfus);
		public void notify_change (Grl.Media? media, Grl.SourceChangeType change_type, bool location_unknown);
		public void notify_change_list (owned GLib.GenericArray<Grl.Media> changed_medias, Grl.SourceChangeType change_type, bool location_unknown);
		public virtual bool notify_change_start () throws GLib.Error;
		public virtual bool notify_change_stop () throws GLib.Error;
		[NoWrapper]
		public virtual void query (Grl.SourceQuerySpec qs);
		public GLib.List<Grl.Media> query_sync (string query, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
		[NoWrapper]
		public virtual void remove (Grl.SourceRemoveSpec rs);
		public void remove_sync (Grl.Media media) throws GLib.Error;
		[NoWrapper]
		public virtual void resolve (Grl.SourceResolveSpec ms);
		public Grl.Media resolve_sync (Grl.Media? media, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
		[NoWrapper]
		public virtual void search (Grl.SourceSearchSpec ss);
		public GLib.List<Grl.Media> search_sync (string text, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
		public void set_auto_split_threshold (uint threshold);
		public virtual unowned GLib.List<Grl.KeyID> slow_keys ();
		[NoWrapper]
		public virtual void store (Grl.SourceStoreSpec ss);
		[NoWrapper]
		public virtual void store_metadata (Grl.SourceStoreMetadataSpec sms);
		public GLib.List<weak Grl.KeyID> store_metadata_sync (Grl.Media media, GLib.List<Grl.KeyID>? keys, Grl.WriteFlags flags) throws GLib.Error;
		public void store_sync (Grl.MediaBox? parent, Grl.Media media, Grl.WriteFlags flags) throws GLib.Error;
		public virtual unowned GLib.List<Grl.KeyID> supported_keys ();
		[NoWrapper]
		public virtual Grl.SupportedOps supported_operations ();
		public virtual bool test_media_from_uri (string uri);
		public virtual unowned GLib.List<Grl.KeyID> writable_keys ();
		public uint auto_split_threshold { get; set; }
		[NoAccessorMethod]
		public Grl.Plugin plugin { owned get; set construct; }
		[NoAccessorMethod]
		public int rank { get; set construct; }
		[NoAccessorMethod]
		public string source_desc { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Icon source_icon { owned get; set construct; }
		[NoAccessorMethod]
		public string source_id { owned get; set construct; }
		[NoAccessorMethod]
		public string source_name { owned get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] source_tags { owned get; set construct; }
		[NoAccessorMethod]
		public Grl.MediaType supported_media { get; set construct; }
		public signal void content_changed (GLib.GenericArray<Grl.Media> changed_medias, Grl.SourceChangeType change_type, bool location_unknown);
	}
	[CCode (cheader_filename = "grilo.h")]
	[SimpleType]
	public struct KeyID : uint32 {
	}
	[CCode (cheader_filename = "grilo.h")]
	public struct MetadataKey {
		[CCode (cname = "GRL_METADATA_KEY_INVALID")]
		public static Grl.KeyID INVALID;
		[CCode (cname = "GRL_METADATA_KEY_ALBUM")]
		public static Grl.KeyID ALBUM;
		[CCode (cname = "GRL_METADATA_KEY_ARTIST")]
		public static Grl.KeyID ARTIST;
		[CCode (cname = "GRL_METADATA_KEY_AUTHOR")]
		public static Grl.KeyID AUTHOR;
		[CCode (cname = "GRL_METADATA_KEY_BITRATE")]
		public static Grl.KeyID BITRATE;
		[CCode (cname = "GRL_METADATA_KEY_CERTIFICATE")]
		public static Grl.KeyID CERTIFICATE;
		[CCode (cname = "GRL_METADATA_KEY_CHILDCOUNT")]
		public static Grl.KeyID CHILDCOUNT;
		[CCode (cname = "GRL_METADATA_KEY_PUBLICATION_DATE")]
		public static Grl.KeyID PUBLICATION_DATE;
		[CCode (cname = "GRL_METADATA_KEY_DESCRIPTION")]
		public static Grl.KeyID DESCRIPTION;
		[CCode (cname = "GRL_METADATA_KEY_DURATION")]
		public static Grl.KeyID DURATION;
		[CCode (cname = "GRL_METADATA_KEY_EXTERNAL_PLAYER")]
		public static Grl.KeyID EXTERNAL_PLAYER;
		[CCode (cname = "GRL_METADATA_KEY_EXTERNAL_URL")]
		public static Grl.KeyID EXTERNAL_URL;
		[CCode (cname = "GRL_METADATA_KEY_FRAMERATE")]
		public static Grl.KeyID FRAMERATE;
		[CCode (cname = "GRL_METADATA_KEY_GENRE")]
		public static Grl.KeyID GENRE;
		[CCode (cname = "GRL_METADATA_KEY_HEIGHT")]
		public static Grl.KeyID HEIGHT;
		[CCode (cname = "GRL_METADATA_KEY_ID")]
		public static Grl.KeyID ID;
		[CCode (cname = "GRL_METADATA_KEY_LAST_PLAYED")]
		public static Grl.KeyID LAST_PLAYED;
		[CCode (cname = "GRL_METADATA_KEY_LAST_POSITION")]
		public static Grl.KeyID LAST_POSITION;
		[CCode (cname = "GRL_METADATA_KEY_LICENSE")]
		public static Grl.KeyID LICENSE;
		[CCode (cname = "GRL_METADATA_KEY_LYRICS")]
		public static Grl.KeyID LYRICS;
		[CCode (cname = "GRL_METADATA_KEY_MIME")]
		public static Grl.KeyID MIME;
		[CCode (cname = "GRL_METADATA_KEY_PLAY_COUNT")]
		public static Grl.KeyID PLAY_COUNT;
		[CCode (cname = "GRL_METADATA_KEY_RATING")]
		public static Grl.KeyID RATING;
		[CCode (cname = "GRL_METADATA_KEY_REGION")]
		public static Grl.KeyID REGION;
		[CCode (cname = "GRL_METADATA_KEY_SITE")]
		public static Grl.KeyID SITE;
		[CCode (cname = "GRL_METADATA_KEY_SOURCE")]
		public static Grl.KeyID SOURCE;
		[CCode (cname = "GRL_METADATA_KEY_STUDIO")]
		public static Grl.KeyID STUDIO;
		[CCode (cname = "GRL_METADATA_KEY_THUMBNAIL")]
		public static Grl.KeyID THUMBNAIL;
		[CCode (cname = "GRL_METADATA_KEY_THUMBNAIL_BINARY")]
		public static Grl.KeyID THUMBNAIL_BINARY;
		[CCode (cname = "GRL_METADATA_KEY_TITLE")]
		public static Grl.KeyID TITLE;
		[CCode (cname = "GRL_METADATA_KEY_URL")]
		public static Grl.KeyID URL;
		[CCode (cname = "GRL_METADATA_KEY_WIDTH")]
		public static Grl.KeyID WIDTH;
		[CCode (cname = "GRL_METADATA_KEY_SEASON")]
		public static Grl.KeyID SEASON;
		[CCode (cname = "GRL_METADATA_KEY_EPISODE")]
		public static Grl.KeyID EPISODE;
		[CCode (cname = "GRL_METADATA_KEY_EPISODE_TITLE")]
		public static Grl.KeyID EPISODE_TITLE;
		[CCode (cname = "GRL_METADATA_KEY_SHOW")]
		public static Grl.KeyID SHOW;
		[CCode (cname = "GRL_METADATA_KEY_CREATION_DATE")]
		public static Grl.KeyID CREATION_DATE;
		[CCode (cname = "GRL_METADATA_KEY_CAMERA_MODEL")]
		public static Grl.KeyID CAMERA_MODEL;
		[CCode (cname = "GRL_METADATA_KEY_ORIENTATION")]
		public static Grl.KeyID ORIENTATION;
		[CCode (cname = "GRL_METADATA_KEY_FLASH_USED")]
		public static Grl.KeyID FLASH_USED;
		[CCode (cname = "GRL_METADATA_KEY_EXPOSURE_TIME")]
		public static Grl.KeyID EXPOSURE_TIME;
		[CCode (cname = "GRL_METADATA_KEY_ISO_SPEED")]
		public static Grl.KeyID ISO_SPEED;
		[CCode (cname = "GRL_METADATA_KEY_TRACK_NUMBER")]
		public static Grl.KeyID TRACK_NUMBER;
		[CCode (cname = "GRL_METADATA_KEY_MODIFICATION_DATE")]
		public static Grl.KeyID MODIFICATION_DATE;
		[CCode (cname = "GRL_METADATA_KEY_START_TIME")]
		public static Grl.KeyID START_TIME;
		[CCode (cname = "GRL_METADATA_KEY_KEYWORD")]
		public static Grl.KeyID KEYWORD;
		[CCode (cname = "GRL_METADATA_KEY_PERFORMER")]
		public static Grl.KeyID PERFORMER;
		[CCode (cname = "GRL_METADATA_KEY_PRODUCER")]
		public static Grl.KeyID PRODUCER;
		[CCode (cname = "GRL_METADATA_KEY_DIRECTOR")]
		public static Grl.KeyID DIRECTOR;
		[CCode (cname = "GRL_METADATA_KEY_ORIGINAL_TITLE")]
		public static Grl.KeyID ORIGINAL_TITLE;
		[CCode (cname = "GRL_METADATA_KEY_MB_ALBUM_ID")]
		public static Grl.KeyID MB_ALBUM_ID;
		[CCode (cname = "GRL_METADATA_KEY_MB_TRACK_ID")]
		public static Grl.KeyID MB_TRACK_ID;
		[CCode (cname = "GRL_METADATA_KEY_MB_ARTIST_ID")]
		public static Grl.KeyID MB_ARTIST_ID;
		[CCode (cname = "GRL_METADATA_KEY_MB_RECORDING_ID")]
		public static Grl.KeyID MB_RECORDING_ID;
		[CCode (cname = "GRL_METADATA_KEY_AUDIO_TRACK")]
		public static Grl.KeyID AUDIO_TRACK;
		[CCode (cname = "GRL_METADATA_KEY_CHILDCOUNT_UNKNOWN")]
		public static uint CHILDCOUNT_UNKNOWN;
		[CCode (cname = "GRL_SOURCE_REMAINING_UNKNOWN")]
		public static uint REMAINING_UNKNOWN;
		public static GLib.List list_new (Grl.KeyID p, ...);
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceBrowseSpec {
		public weak Grl.Source source;
		public uint operation_id;
		public weak Grl.Media container;
		public weak GLib.List<void*> keys;
		public weak Grl.OperationOptions options;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceResultCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceMediaFromUriSpec {
		public weak Grl.Source source;
		public uint operation_id;
		public weak string uri;
		public weak GLib.List<void*> keys;
		public weak Grl.OperationOptions options;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceResolveCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceQuerySpec {
		public weak Grl.Source source;
		public uint operation_id;
		public weak string query;
		public weak GLib.List<void*> keys;
		public weak Grl.OperationOptions options;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceResultCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceRemoveSpec {
		public weak Grl.Source source;
		public weak string media_id;
		public weak Grl.Media media;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceRemoveCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceResolveSpec {
		public weak Grl.Source source;
		public uint operation_id;
		public weak Grl.Media media;
		public weak GLib.List<void*> keys;
		public weak Grl.OperationOptions options;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceResolveCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceSearchSpec {
		public weak Grl.Source source;
		public uint operation_id;
		public weak string text;
		public weak GLib.List<void*> keys;
		public weak Grl.OperationOptions options;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceResultCb callback;
		public void* user_data;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceStoreMetadataSpec {
		public weak Grl.Source source;
		public weak Grl.Media media;
		public weak GLib.List<void*> keys;
		public Grl.WriteFlags flags;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceStoreCb callback;
		public void* user_data;
		public weak GLib.List<void*> failed_keys;
	}
	[CCode (cheader_filename = "grilo.h", has_type_id = false)]
	public struct SourceStoreSpec {
		public weak Grl.Source source;
		public weak Grl.MediaBox parent;
		public weak Grl.Media media;
		[CCode (delegate_target_cname = "user_data")]
		public weak Grl.SourceStoreCb callback;
		public string user_data;
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_CORE_ERROR_", has_type_id = false)]
	public enum CoreError {
		BROWSE_FAILED,
		SEARCH_FAILED,
		SEARCH_NULL_UNSUPPORTED,
		QUERY_FAILED,
		RESOLVE_FAILED,
		MEDIA_NOT_FOUND,
		STORE_FAILED,
		STORE_METADATA_FAILED,
		REMOVE_FAILED,
		MEDIA_FROM_URI_FAILED,
		CONFIG_LOAD_FAILED,
		CONFIG_FAILED,
		UNREGISTER_SOURCE_FAILED,
		LOAD_PLUGIN_FAILED,
		UNLOAD_PLUGIN_FAILED,
		REGISTER_METADATA_KEY_FAILED,
		NOTIFY_CHANGED_FAILED,
		OPERATION_CANCELLED,
		AUTHENTICATION_TOKEN
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_LOG_LEVEL_", has_type_id = false)]
	public enum LogLevel {
		NONE,
		ERROR,
		WARNING,
		MESSAGE,
		INFO,
		DEBUG,
		LAST
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_MEDIA_SERIALIZE_", type_id = "grl_media_serialize_type_get_type ()")]
	public enum MediaSerializeType {
		BASIC,
		PARTIAL,
		FULL
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_MEDIA_TYPE_", type_id = "grl_media_type_get_type ()")]
	[Flags]
	public enum MediaType {
		NONE,
		AUDIO,
		VIDEO,
		IMAGE,
		ALL
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_RANK_", has_type_id = false)]
	public enum Rank {
		LOWEST,
		LOW,
		DEFAULT,
		HIGH,
		HIGHEST
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_RESOLVE_", type_id = "grl_resolution_flags_get_type ()")]
	[Flags]
	public enum ResolutionFlags {
		NORMAL,
		FULL,
		IDLE_RELAY,
		FAST_ONLY
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_CONTENT_", type_id = "grl_source_change_type_get_type ()")]
	public enum SourceChangeType {
		CHANGED,
		ADDED,
		REMOVED
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_OP_", type_id = "grl_supported_ops_get_type ()")]
	[Flags]
	public enum SupportedOps {
		NONE,
		RESOLVE,
		BROWSE,
		SEARCH,
		QUERY,
		STORE,
		STORE_PARENT,
		STORE_METADATA,
		REMOVE,
		MEDIA_FROM_URI,
		NOTIFY_CHANGE
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_TYPE_FILTER_", type_id = "grl_type_filter_get_type ()")]
	[Flags]
	public enum TypeFilter {
		NONE,
		AUDIO,
		VIDEO,
		IMAGE,
		ALL
	}
	[CCode (cheader_filename = "grilo.h", cprefix = "GRL_WRITE_", type_id = "grl_write_flags_get_type ()")]
	[Flags]
	public enum WriteFlags {
		NORMAL,
		FULL
	}
	[CCode (cheader_filename = "grilo.h", has_target = false)]
	public delegate void OperationCancelCb (void* data);
	[CCode (cheader_filename = "grilo.h", instance_pos = 2.9)]
	public delegate void SourceRemoveCb (Grl.Source source, owned Grl.Media media, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 3.9)]
	public delegate void SourceResolveCb (Grl.Source source, uint operation_id, owned Grl.Media media, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 4.9)]
	public delegate void SourceResultCb (Grl.Source source, uint operation_id, owned Grl.Media? media, uint remaining, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", instance_pos = 3.9)]
	public delegate void SourceStoreCb (Grl.Source source, owned Grl.Media media, GLib.List<Grl.KeyID> failed_keys, GLib.Error? error);
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_APIKEY")]
	public const string CONFIG_KEY_APIKEY;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_APIKEY_BLOB")]
	public const string CONFIG_KEY_APIKEY_BLOB;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_APISECRET")]
	public const string CONFIG_KEY_APISECRET;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_APITOKEN")]
	public const string CONFIG_KEY_APITOKEN;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_APITOKEN_SECRET")]
	public const string CONFIG_KEY_APITOKEN_SECRET;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_PASSWORD")]
	public const string CONFIG_KEY_PASSWORD;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_PLUGIN")]
	public const string CONFIG_KEY_PLUGIN;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_SOURCE")]
	public const string CONFIG_KEY_SOURCE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_CONFIG_KEY_USERNAME")]
	public const string CONFIG_KEY_USERNAME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_COUNT_INFINITY")]
	public const int COUNT_INFINITY;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_KEYID_FORMAT")]
	public const string KEYID_FORMAT;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ALBUM")]
	public const int METADATA_KEY_ALBUM;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ARTIST")]
	public const int METADATA_KEY_ARTIST;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_AUDIO_TRACK")]
	public const int METADATA_KEY_AUDIO_TRACK;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_AUTHOR")]
	public const int METADATA_KEY_AUTHOR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_BITRATE")]
	public const int METADATA_KEY_BITRATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_CAMERA_MODEL")]
	public const int METADATA_KEY_CAMERA_MODEL;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_CERTIFICATE")]
	public const int METADATA_KEY_CERTIFICATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_CHILDCOUNT")]
	public const int METADATA_KEY_CHILDCOUNT;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_CHILDCOUNT_UNKNOWN")]
	public const int METADATA_KEY_CHILDCOUNT_UNKNOWN;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_CREATION_DATE")]
	public const int METADATA_KEY_CREATION_DATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_DESCRIPTION")]
	public const int METADATA_KEY_DESCRIPTION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_DIRECTOR")]
	public const int METADATA_KEY_DIRECTOR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_DURATION")]
	public const int METADATA_KEY_DURATION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_EPISODE")]
	public const int METADATA_KEY_EPISODE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_EPISODE_TITLE")]
	public const int METADATA_KEY_EPISODE_TITLE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_EXPOSURE_TIME")]
	public const int METADATA_KEY_EXPOSURE_TIME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_EXTERNAL_PLAYER")]
	public const int METADATA_KEY_EXTERNAL_PLAYER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_EXTERNAL_URL")]
	public const int METADATA_KEY_EXTERNAL_URL;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_FAVOURITE")]
	public const int METADATA_KEY_FAVOURITE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_FLASH_USED")]
	public const int METADATA_KEY_FLASH_USED;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_FRAMERATE")]
	public const int METADATA_KEY_FRAMERATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_GENRE")]
	public const int METADATA_KEY_GENRE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_HEIGHT")]
	public const int METADATA_KEY_HEIGHT;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ID")]
	public const int METADATA_KEY_ID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_INVALID")]
	public const int METADATA_KEY_INVALID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ISO_SPEED")]
	public const int METADATA_KEY_ISO_SPEED;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_KEYWORD")]
	public const int METADATA_KEY_KEYWORD;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_LAST_PLAYED")]
	public const int METADATA_KEY_LAST_PLAYED;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_LAST_POSITION")]
	public const int METADATA_KEY_LAST_POSITION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_LICENSE")]
	public const int METADATA_KEY_LICENSE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_LYRICS")]
	public const int METADATA_KEY_LYRICS;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MB_ALBUM_ID")]
	public const int METADATA_KEY_MB_ALBUM_ID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MB_ARTIST_ID")]
	public const int METADATA_KEY_MB_ARTIST_ID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MB_RECORDING_ID")]
	public const int METADATA_KEY_MB_RECORDING_ID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MB_TRACK_ID")]
	public const int METADATA_KEY_MB_TRACK_ID;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MIME")]
	public const int METADATA_KEY_MIME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_MODIFICATION_DATE")]
	public const int METADATA_KEY_MODIFICATION_DATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ORIENTATION")]
	public const int METADATA_KEY_ORIENTATION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_ORIGINAL_TITLE")]
	public const int METADATA_KEY_ORIGINAL_TITLE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_PERFORMER")]
	public const int METADATA_KEY_PERFORMER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_PLAY_COUNT")]
	public const int METADATA_KEY_PLAY_COUNT;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_PRODUCER")]
	public const int METADATA_KEY_PRODUCER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_PUBLICATION_DATE")]
	public const int METADATA_KEY_PUBLICATION_DATE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_RATING")]
	public const int METADATA_KEY_RATING;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_REGION")]
	public const int METADATA_KEY_REGION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_SEASON")]
	public const int METADATA_KEY_SEASON;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_SHOW")]
	public const int METADATA_KEY_SHOW;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_SITE")]
	public const int METADATA_KEY_SITE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_SIZE")]
	public const int METADATA_KEY_SIZE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_SOURCE")]
	public const int METADATA_KEY_SOURCE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_START_TIME")]
	public const int METADATA_KEY_START_TIME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_STUDIO")]
	public const int METADATA_KEY_STUDIO;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_THUMBNAIL")]
	public const int METADATA_KEY_THUMBNAIL;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_THUMBNAIL_BINARY")]
	public const int METADATA_KEY_THUMBNAIL_BINARY;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_TITLE")]
	public const int METADATA_KEY_TITLE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_TITLE_FROM_FILENAME")]
	public const int METADATA_KEY_TITLE_FROM_FILENAME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_TRACK_NUMBER")]
	public const int METADATA_KEY_TRACK_NUMBER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_URL")]
	public const int METADATA_KEY_URL;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_METADATA_KEY_WIDTH")]
	public const int METADATA_KEY_WIDTH;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_COUNT")]
	public const string OPERATION_OPTION_COUNT;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_KEY_EQUAL_FILTER")]
	public const string OPERATION_OPTION_KEY_EQUAL_FILTER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_KEY_RANGE_FILTER")]
	public const string OPERATION_OPTION_KEY_RANGE_FILTER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_RESOLUTION_FLAGS")]
	public const string OPERATION_OPTION_RESOLUTION_FLAGS;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_SKIP")]
	public const string OPERATION_OPTION_SKIP;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_OPERATION_OPTION_TYPE_FILTER")]
	public const string OPERATION_OPTION_TYPE_FILTER;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PADDING")]
	public const int PADDING;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PADDING_SMALL")]
	public const int PADDING_SMALL;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_AUTHOR")]
	public const string PLUGIN_AUTHOR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_DESCRIPTION")]
	public const string PLUGIN_DESCRIPTION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_LICENSE")]
	public const string PLUGIN_LICENSE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_LIST_VAR")]
	public const string PLUGIN_LIST_VAR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_NAME")]
	public const string PLUGIN_NAME;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_PATH_VAR")]
	public const string PLUGIN_PATH_VAR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_RANKS_VAR")]
	public const string PLUGIN_RANKS_VAR;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_SITE")]
	public const string PLUGIN_SITE;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_PLUGIN_VERSION")]
	public const string PLUGIN_VERSION;
	[CCode (cheader_filename = "grilo.h", cname = "GRL_SOURCE_REMAINING_UNKNOWN")]
	public const int SOURCE_REMAINING_UNKNOWN;
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.DateTime date_time_from_iso8601 (string date);
	[CCode (cheader_filename = "grilo.h")]
	public static void deinit ();
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.Value? g_value_dup (GLib.Value value);
	[CCode (cheader_filename = "grilo.h")]
	public static void g_value_free (GLib.Value value);
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.HashTable<string,GLib.Value?> g_value_hashtable_new ();
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.HashTable<void*,GLib.Value?> g_value_hashtable_new_direct ();
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.Value? g_value_new (GLib.Type g_type);
	[CCode (cheader_filename = "grilo.h")]
	public static void init ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv);
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.OptionGroup init_get_option_group ();
	[CCode (cheader_filename = "grilo.h")]
	public static void log_configure (string config);
	[CCode (cheader_filename = "grilo.h")]
	public static void marshal_VOID__BOXED_ENUM_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned string metadata_key_get_desc (Grl.KeyID key);
	[CCode (cheader_filename = "grilo.h")]
	public static unowned string metadata_key_get_name (Grl.KeyID key);
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.Type metadata_key_get_type (Grl.KeyID key);
	[CCode (cheader_filename = "grilo.h")]
	public static void metadata_key_setup_system_keys (Grl.Registry registry);
	[CCode (cheader_filename = "grilo.h")]
	public static void multiple_get_media_from_uri (string uri, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResolveCb callback);
	[CCode (cheader_filename = "grilo.h")]
	public static uint multiple_search (GLib.List<Grl.Source>? sources, string text, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options, Grl.SourceResultCb callback);
	[CCode (cheader_filename = "grilo.h")]
	public static GLib.List<Grl.Media> multiple_search_sync (GLib.List<Grl.Source>? sources, string text, GLib.List<Grl.KeyID> keys, Grl.OperationOptions options) throws GLib.Error;
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_cancel (uint operation_id);
	[CCode (cheader_filename = "grilo.h")]
	public static uint operation_generate_id ();
	[CCode (cheader_filename = "grilo.h")]
	public static void* operation_get_data (uint operation_id);
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_init ();
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_remove (uint operation_id);
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_set_data (uint operation_id, void* user_data);
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_set_data_full (uint operation_id, void* user_data, GLib.DestroyNotify? destroy_func);
	[CCode (cheader_filename = "grilo.h")]
	public static void operation_set_private_data (uint operation_id, void* private_data, [CCode (destroy_notify_pos = 3.1)] owned Grl.OperationCancelCb cancel_cb);
	[CCode (cheader_filename = "grilo.h")]
	public static void paging_translate (uint skip, uint count, uint max_page_size, uint page_size, uint page_number, uint internal_offset);
}
