; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIF,RV32IF %s
; RUN: llc -mtriple=riscv64 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIF,RV64IF %s
; RUN: llc -mtriple=riscv32 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZFINX,RV32IZFINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zfinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZFINX,RV64IZFINX %s

define signext i32 @test_floor_si32(float %x) {
; CHECKIF-LABEL: test_floor_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rdn
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_floor_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.floor.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_floor_si64(float %x) nounwind {
; RV32IF-LABEL: test_floor_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB1_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rdn
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rdn
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB1_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB1_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB1_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI1_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI1_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB1_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB1_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_floor_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rdn
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_floor_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB1_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rdn
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rdn
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB1_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB1_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB1_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB1_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB1_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_floor_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rdn
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.floor.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_floor_ui32(float %x) {
; CHECKIF-LABEL: test_floor_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rdn
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_floor_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0, rdn
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.floor.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_floor_ui64(float %x) nounwind {
; RV32IF-LABEL: test_floor_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB3_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rdn
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rdn
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB3_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI3_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI3_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_floor_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rdn
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_floor_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB3_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rdn
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rdn
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB3_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_floor_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rdn
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.floor.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_ceil_si32(float %x) {
; CHECKIF-LABEL: test_ceil_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rup
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_ceil_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.ceil.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_ceil_si64(float %x) nounwind {
; RV32IF-LABEL: test_ceil_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB5_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rup
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rup
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB5_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB5_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB5_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI5_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI5_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB5_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB5_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_ceil_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rup
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_ceil_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB5_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rup
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rup
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB5_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB5_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB5_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB5_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB5_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_ceil_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rup
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.ceil.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_ceil_ui32(float %x) {
; CHECKIF-LABEL: test_ceil_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rup
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_ceil_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0, rup
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.ceil.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_ceil_ui64(float %x) nounwind {
; RV32IF-LABEL: test_ceil_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB7_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rup
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rup
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB7_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI7_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI7_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_ceil_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rup
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_ceil_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB7_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rup
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rup
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB7_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_ceil_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rup
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.ceil.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_trunc_si32(float %x) {
; CHECKIF-LABEL: test_trunc_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_trunc_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.trunc.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_trunc_si64(float %x) nounwind {
; RV32IF-LABEL: test_trunc_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB9_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rtz
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rtz
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB9_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB9_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB9_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI9_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI9_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB9_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB9_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_trunc_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_trunc_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB9_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rtz
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rtz
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB9_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB9_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB9_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB9_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB9_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_trunc_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.trunc.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_trunc_ui32(float %x) {
; CHECKIF-LABEL: test_trunc_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rtz
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_trunc_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0, rtz
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.trunc.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_trunc_ui64(float %x) nounwind {
; RV32IF-LABEL: test_trunc_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB11_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rtz
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rtz
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB11_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI11_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI11_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_trunc_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rtz
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_trunc_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB11_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rtz
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rtz
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB11_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_trunc_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rtz
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.trunc.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_round_si32(float %x) {
; CHECKIF-LABEL: test_round_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rmm
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_round_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.round.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_round_si64(float %x) nounwind {
; RV32IF-LABEL: test_round_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB13_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rmm
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rmm
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB13_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB13_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB13_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI13_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI13_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB13_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB13_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_round_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rmm
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_round_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB13_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rmm
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rmm
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB13_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB13_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB13_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB13_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB13_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_round_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rmm
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.round.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_round_ui32(float %x) {
; CHECKIF-LABEL: test_round_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rmm
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_round_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0, rmm
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.round.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_round_ui64(float %x) nounwind {
; RV32IF-LABEL: test_round_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB15_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rmm
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rmm
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB15_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI15_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI15_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_round_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rmm
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_round_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB15_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rmm
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rmm
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB15_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_round_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rmm
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.round.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_roundeven_si32(float %x) {
; CHECKIF-LABEL: test_roundeven_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0, rne
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_roundeven_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.roundeven.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_roundeven_si64(float %x) nounwind {
; RV32IF-LABEL: test_roundeven_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB17_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rne
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rne
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB17_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB17_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB17_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI17_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI17_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB17_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB17_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_roundeven_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0, rne
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_roundeven_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB17_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rne
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rne
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB17_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB17_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB17_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB17_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB17_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_roundeven_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0, rne
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.roundeven.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_roundeven_ui32(float %x) {
; CHECKIF-LABEL: test_roundeven_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0, rne
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_roundeven_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0, rne
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.roundeven.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_roundeven_ui64(float %x) nounwind {
; RV32IF-LABEL: test_roundeven_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB19_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0, rne
; RV32IF-NEXT:    fcvt.s.w fa5, a0, rne
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB19_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI19_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI19_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_roundeven_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0, rne
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_roundeven_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB19_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0, rne
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0, rne
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB19_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_roundeven_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0, rne
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.roundeven.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_rint_si32(float %x) {
; CHECKIF-LABEL: test_rint_si32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.w.s a0, fa0
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_rint_si32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.w.s a1, a0
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.rint.f32(float %x)
  %b = call i32 @llvm.fptosi.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_rint_si64(float %x) nounwind {
; RV32IF-LABEL: test_rint_si64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB21_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0
; RV32IF-NEXT:    fcvt.s.w fa5, a0
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB21_2:
; RV32IF-NEXT:    lui a0, 913408
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fle.s s0, fa5, fs0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixsfdi
; RV32IF-NEXT:    lui a3, 524288
; RV32IF-NEXT:    lui a2, 524288
; RV32IF-NEXT:    beqz s0, .LBB21_4
; RV32IF-NEXT:  # %bb.3:
; RV32IF-NEXT:    mv a2, a1
; RV32IF-NEXT:  .LBB21_4:
; RV32IF-NEXT:    lui a1, %hi(.LCPI21_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI21_0)(a1)
; RV32IF-NEXT:    flt.s a1, fa5, fs0
; RV32IF-NEXT:    beqz a1, .LBB21_6
; RV32IF-NEXT:  # %bb.5:
; RV32IF-NEXT:    addi a2, a3, -1
; RV32IF-NEXT:  .LBB21_6:
; RV32IF-NEXT:    feq.s a3, fs0, fs0
; RV32IF-NEXT:    neg a4, s0
; RV32IF-NEXT:    neg a5, a1
; RV32IF-NEXT:    neg a3, a3
; RV32IF-NEXT:    and a0, a4, a0
; RV32IF-NEXT:    and a1, a3, a2
; RV32IF-NEXT:    or a0, a5, a0
; RV32IF-NEXT:    and a0, a3, a0
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_rint_si64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.l.s a0, fa0
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_rint_si64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB21_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB21_2:
; RV32IZFINX-NEXT:    lui a0, 913408
; RV32IZFINX-NEXT:    fle.s s1, a0, s0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixsfdi
; RV32IZFINX-NEXT:    lui a3, 524288
; RV32IZFINX-NEXT:    lui a2, 524288
; RV32IZFINX-NEXT:    beqz s1, .LBB21_4
; RV32IZFINX-NEXT:  # %bb.3:
; RV32IZFINX-NEXT:    mv a2, a1
; RV32IZFINX-NEXT:  .LBB21_4:
; RV32IZFINX-NEXT:    lui a1, 389120
; RV32IZFINX-NEXT:    addi a1, a1, -1
; RV32IZFINX-NEXT:    flt.s a1, a1, s0
; RV32IZFINX-NEXT:    beqz a1, .LBB21_6
; RV32IZFINX-NEXT:  # %bb.5:
; RV32IZFINX-NEXT:    addi a2, a3, -1
; RV32IZFINX-NEXT:  .LBB21_6:
; RV32IZFINX-NEXT:    feq.s a3, s0, s0
; RV32IZFINX-NEXT:    neg a4, s1
; RV32IZFINX-NEXT:    neg a5, a1
; RV32IZFINX-NEXT:    neg a3, a3
; RV32IZFINX-NEXT:    and a0, a4, a0
; RV32IZFINX-NEXT:    and a1, a3, a2
; RV32IZFINX-NEXT:    or a0, a5, a0
; RV32IZFINX-NEXT:    and a0, a3, a0
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_rint_si64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.l.s a1, a0
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.rint.f32(float %x)
  %b = call i64 @llvm.fptosi.sat.i64.f32(float %a)
  ret i64 %b
}

define signext i32 @test_rint_ui32(float %x) {
; CHECKIF-LABEL: test_rint_ui32:
; CHECKIF:       # %bb.0:
; CHECKIF-NEXT:    fcvt.wu.s a0, fa0
; CHECKIF-NEXT:    feq.s a1, fa0, fa0
; CHECKIF-NEXT:    seqz a1, a1
; CHECKIF-NEXT:    addi a1, a1, -1
; CHECKIF-NEXT:    and a0, a1, a0
; CHECKIF-NEXT:    ret
;
; CHECKIZFINX-LABEL: test_rint_ui32:
; CHECKIZFINX:       # %bb.0:
; CHECKIZFINX-NEXT:    fcvt.wu.s a1, a0
; CHECKIZFINX-NEXT:    feq.s a0, a0, a0
; CHECKIZFINX-NEXT:    seqz a0, a0
; CHECKIZFINX-NEXT:    addi a0, a0, -1
; CHECKIZFINX-NEXT:    and a0, a0, a1
; CHECKIZFINX-NEXT:    ret
  %a = call float @llvm.rint.f32(float %x)
  %b = call i32 @llvm.fptoui.sat.i32.f32(float %a)
  ret i32 %b
}

define i64 @test_rint_ui64(float %x) nounwind {
; RV32IF-LABEL: test_rint_ui64:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    lui a0, 307200
; RV32IF-NEXT:    fmv.w.x fa5, a0
; RV32IF-NEXT:    fabs.s fa4, fa0
; RV32IF-NEXT:    flt.s a0, fa4, fa5
; RV32IF-NEXT:    beqz a0, .LBB23_2
; RV32IF-NEXT:  # %bb.1:
; RV32IF-NEXT:    fcvt.w.s a0, fs0
; RV32IF-NEXT:    fcvt.s.w fa5, a0
; RV32IF-NEXT:    fsgnj.s fs0, fa5, fs0
; RV32IF-NEXT:  .LBB23_2:
; RV32IF-NEXT:    fmv.w.x fa5, zero
; RV32IF-NEXT:    fle.s a0, fa5, fs0
; RV32IF-NEXT:    neg s0, a0
; RV32IF-NEXT:    fmv.s fa0, fs0
; RV32IF-NEXT:    call __fixunssfdi
; RV32IF-NEXT:    lui a2, %hi(.LCPI23_0)
; RV32IF-NEXT:    flw fa5, %lo(.LCPI23_0)(a2)
; RV32IF-NEXT:    and a0, s0, a0
; RV32IF-NEXT:    and a1, s0, a1
; RV32IF-NEXT:    flt.s a2, fa5, fs0
; RV32IF-NEXT:    neg a2, a2
; RV32IF-NEXT:    or a0, a2, a0
; RV32IF-NEXT:    or a1, a2, a1
; RV32IF-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: test_rint_ui64:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fcvt.lu.s a0, fa0
; RV64IF-NEXT:    feq.s a1, fa0, fa0
; RV64IF-NEXT:    seqz a1, a1
; RV64IF-NEXT:    addi a1, a1, -1
; RV64IF-NEXT:    and a0, a1, a0
; RV64IF-NEXT:    ret
;
; RV32IZFINX-LABEL: test_rint_ui64:
; RV32IZFINX:       # %bb.0:
; RV32IZFINX-NEXT:    addi sp, sp, -16
; RV32IZFINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINX-NEXT:    mv s0, a0
; RV32IZFINX-NEXT:    lui a0, 307200
; RV32IZFINX-NEXT:    fabs.s a1, s0
; RV32IZFINX-NEXT:    flt.s a0, a1, a0
; RV32IZFINX-NEXT:    beqz a0, .LBB23_2
; RV32IZFINX-NEXT:  # %bb.1:
; RV32IZFINX-NEXT:    fcvt.w.s a0, s0
; RV32IZFINX-NEXT:    fcvt.s.w a0, a0
; RV32IZFINX-NEXT:    fsgnj.s s0, a0, s0
; RV32IZFINX-NEXT:  .LBB23_2:
; RV32IZFINX-NEXT:    fle.s a0, zero, s0
; RV32IZFINX-NEXT:    neg s1, a0
; RV32IZFINX-NEXT:    mv a0, s0
; RV32IZFINX-NEXT:    call __fixunssfdi
; RV32IZFINX-NEXT:    and a0, s1, a0
; RV32IZFINX-NEXT:    lui a2, 391168
; RV32IZFINX-NEXT:    and a1, s1, a1
; RV32IZFINX-NEXT:    addi a2, a2, -1
; RV32IZFINX-NEXT:    flt.s a2, a2, s0
; RV32IZFINX-NEXT:    neg a2, a2
; RV32IZFINX-NEXT:    or a0, a2, a0
; RV32IZFINX-NEXT:    or a1, a2, a1
; RV32IZFINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINX-NEXT:    addi sp, sp, 16
; RV32IZFINX-NEXT:    ret
;
; RV64IZFINX-LABEL: test_rint_ui64:
; RV64IZFINX:       # %bb.0:
; RV64IZFINX-NEXT:    fcvt.lu.s a1, a0
; RV64IZFINX-NEXT:    feq.s a0, a0, a0
; RV64IZFINX-NEXT:    seqz a0, a0
; RV64IZFINX-NEXT:    addi a0, a0, -1
; RV64IZFINX-NEXT:    and a0, a0, a1
; RV64IZFINX-NEXT:    ret
  %a = call float @llvm.rint.f32(float %x)
  %b = call i64 @llvm.fptoui.sat.i64.f32(float %a)
  ret i64 %b
}

declare float @llvm.floor.f32(float)
declare float @llvm.ceil.f32(float)
declare float @llvm.trunc.f32(float)
declare float @llvm.round.f32(float)
declare float @llvm.roundeven.f32(float)
declare float @llvm.rint.f32(float)
declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i64 @llvm.fptosi.sat.i64.f32(float)
declare i32 @llvm.fptoui.sat.i32.f32(float)
declare i64 @llvm.fptoui.sat.i64.f32(float)
