; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instsimplify -march=nvptx64 --mcpu=sm_86 --mattr=+ptx72 -S | FileCheck %s --check-prefixes CHECK,FOLDING_ENABLED
; RUN: opt < %s -disable-fp-call-folding -passes=instsimplify -march=nvptx64 --mcpu=sm_86 --mattr=+ptx72 -S | FileCheck %s --check-prefixes CHECK,FOLDING_DISABLED

; Check that we can disable folding of intrinsic calls via both the -disable-fp-call-folding flag and the strictfp attribute.

; Should be folded by default unless -disable-fp-call-folding is set
define float @test_fmax_ftz_nan_xorsign_abs_f() {
; FOLDING_ENABLED-LABEL: define float @test_fmax_ftz_nan_xorsign_abs_f() {
; FOLDING_ENABLED-NEXT:    ret float -2.000000e+00
;
; FOLDING_DISABLED-LABEL: define float @test_fmax_ftz_nan_xorsign_abs_f() {
; FOLDING_DISABLED-NEXT:    [[RES:%.*]] = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 1.250000e+00, float -2.000000e+00)
; FOLDING_DISABLED-NEXT:    ret float [[RES]]
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

; Check that -disable-fp-call-folding triggers for LLVM instrincis, not just NVPTX target-specific ones.
define float @test_llvm_sin() {
; FOLDING_ENABLED-LABEL: define float @test_llvm_sin() {
; FOLDING_ENABLED-NEXT:    ret float 0x3FDEAEE880000000
;
; FOLDING_DISABLED-LABEL: define float @test_llvm_sin() {
; FOLDING_DISABLED-NEXT:    [[RES:%.*]] = call float @llvm.sin.f32(float 5.000000e-01)
; FOLDING_DISABLED-NEXT:    ret float [[RES]]
;
  %res = call float @llvm.sin.f32(float 0.5)
  ret float %res
}

; Should not be folded, even when -disable-fp-call-folding is not set, as it is marked as strictfp.
define float @test_fmax_ftz_nan_f_strictfp() {
; CHECK-LABEL: define float @test_fmax_ftz_nan_f_strictfp() {
; CHECK-NEXT:    [[RES:%.*]] = call float @llvm.nvvm.fmax.ftz.nan.f(float 1.250000e+00, float -2.000000e+00) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    ret float [[RES]]
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 1.25, float -2.0) #1
  ret float %res
}

; Check that strictfp disables folding for LLVM math intrinsics like sin.f32
; even when -disable-fp-call-folding is not set.
define float @test_llvm_sin_strictfp() {
; CHECK-LABEL: define float @test_llvm_sin_strictfp() {
; CHECK-NEXT:    [[RES:%.*]] = call float @llvm.sin.f32(float 5.000000e-01) #[[ATTR1]]
; CHECK-NEXT:    ret float [[RES]]
;
  %res = call float @llvm.sin.f32(float 0.5) #1
  ret float %res
}

attributes #1 = { strictfp }
