# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p870 -iterations=1 -instruction-tables=full < %s | FileCheck %s

vsetvli zero, zero, e32, m1, ta, ma

vmslt.vv v0, v4, v20
vmsle.vv v8, v4, v20
vmsgt.vv v8, v20, v4
vmsge.vv v8, v20, v4
vmseq.vv v8, v4, v20
vmsne.vv v8, v4, v20
vmsltu.vv v8, v4, v20
vmsleu.vv v8, v4, v20
vmsgtu.vv v8, v20, v4
vmsgeu.vv v8, v20, v4

vmflt.vv v0, v4, v20
vmfle.vv v8, v4, v20
vmfgt.vv v8, v20, v4
vmfge.vv v8, v20, v4
vmfeq.vv v8, v4, v20
vmfne.vv v8, v4, v20

vmadc.vv v8, v4, v20
vmsbc.vv v8, v4, v20

vfirst.m a2, v4
vpopc.m a2, v4

viota.m v8, v4

vmsbf.m v8, v4
vmsif.m v8, v4
vmsof.m v8, v4

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Branch:2 SiFiveP800IEXQ4, SiFiveP800IEXQ5
# CHECK-NEXT: [1]   - SiFiveP800Div:1
# CHECK-NEXT: [2]   - SiFiveP800FEXQ0:1
# CHECK-NEXT: [3]   - SiFiveP800FEXQ1:1
# CHECK-NEXT: [4]   - SiFiveP800FloatArith:2 SiFiveP800FEXQ0, SiFiveP800FEXQ1
# CHECK-NEXT: [5]   - SiFiveP800FloatDiv:1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ0:1
# CHECK-NEXT: [7]   - SiFiveP800IEXQ1:1
# CHECK-NEXT: [8]   - SiFiveP800IEXQ2:1
# CHECK-NEXT: [9]   - SiFiveP800IEXQ3:1
# CHECK-NEXT: [10]  - SiFiveP800IEXQ4:1
# CHECK-NEXT: [11]  - SiFiveP800IEXQ5:1
# CHECK-NEXT: [12]  - SiFiveP800IntArith:4 SiFiveP800IEXQ0, SiFiveP800IEXQ1, SiFiveP800IEXQ2, SiFiveP800IEXQ3
# CHECK-NEXT: [13]  - SiFiveP800LD:1
# CHECK-NEXT: [14]  - SiFiveP800LDST:2
# CHECK-NEXT: [15]  - SiFiveP800Load:3 SiFiveP800LDST, SiFiveP800LDST, SiFiveP800LD
# CHECK-NEXT: [16]  - SiFiveP800Mul:2 SiFiveP800IEXQ1, SiFiveP800IEXQ3
# CHECK-NEXT: [17]  - SiFiveP800VDiv:1
# CHECK-NEXT: [18]  - SiFiveP800VEXQ0:1
# CHECK-NEXT: [19]  - SiFiveP800VEXQ1:1
# CHECK-NEXT: [20]  - SiFiveP800VFloatDiv:1
# CHECK-NEXT: [21]  - SiFiveP800VLD:1
# CHECK-NEXT: [22]  - SiFiveP800VST:1
# CHECK-NEXT: [23]  - SiFiveP800VectorArith:2 SiFiveP800VEXQ0, SiFiveP800VEXQ1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      1     1.00                  U      1     SiFiveP800IEXQ1,SiFiveP800IntArith,SiFiveP800Mul VSETVLI              vsetvli	zero, zero, e32, m1, ta, ma
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLT_VV                   vmslt.vv	v0, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLE_VV                   vmsle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLT_VV                   vmslt.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLE_VV                   vmsle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSEQ_VV                   vmseq.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSNE_VV                   vmsne.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLTU_VV                  vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLEU_VV                  vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLTU_VV                  vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSLEU_VV                  vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFLT_VV                   vmflt.vv	v0, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFLE_VV                   vmfle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFLT_VV                   vmflt.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFLE_VV                   vmfle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFEQ_VV                   vmfeq.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMFNE_VV                   vmfne.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMADC_VV                   vmadc.vv	v8, v4, v20
# CHECK-NEXT:  1      2     0.50                         2     SiFiveP800VectorArith                      VMSBC_VV                   vmsbc.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VFIRST_M                   vfirst.m	a2, v4
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VCPOP_M                    vcpop.m	a2, v4
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VIOTA_M                    viota.m	v8, v4
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VMSBF_M                    vmsbf.m	v8, v4
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VMSIF_M                    vmsif.m	v8, v4
# CHECK-NEXT:  1      2     1.00                         2     SiFiveP800VEXQ0,SiFiveP800VectorArith      VMSOF_M                    vmsof.m	v8, v4

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP800Div
# CHECK-NEXT: [1]   - SiFiveP800FEXQ0
# CHECK-NEXT: [2]   - SiFiveP800FEXQ1
# CHECK-NEXT: [3]   - SiFiveP800FloatDiv
# CHECK-NEXT: [4]   - SiFiveP800IEXQ0
# CHECK-NEXT: [5]   - SiFiveP800IEXQ1
# CHECK-NEXT: [6]   - SiFiveP800IEXQ2
# CHECK-NEXT: [7]   - SiFiveP800IEXQ3
# CHECK-NEXT: [8]   - SiFiveP800IEXQ4
# CHECK-NEXT: [9]   - SiFiveP800IEXQ5
# CHECK-NEXT: [10]  - SiFiveP800LD
# CHECK-NEXT: [11.0] - SiFiveP800LDST
# CHECK-NEXT: [11.1] - SiFiveP800LDST
# CHECK-NEXT: [12]  - SiFiveP800VDiv
# CHECK-NEXT: [13]  - SiFiveP800VEXQ0
# CHECK-NEXT: [14]  - SiFiveP800VEXQ1
# CHECK-NEXT: [15]  - SiFiveP800VFloatDiv
# CHECK-NEXT: [16]  - SiFiveP800VLD
# CHECK-NEXT: [17]  - SiFiveP800VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -     15.00  9.00    -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11.0] [11.1] [12]   [13]   [14]   [15]   [16]   [17]   Instructions:
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, ta, ma
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmslt.vv	v0, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmslt.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmseq.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsne.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmflt.vv	v0, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmfle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmflt.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmfle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmfeq.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmfne.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmadc.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -      -     vmsbc.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vfirst.m	a2, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vcpop.m	a2, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     viota.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsbf.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsif.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsof.m	v8, v4
