#include <octave/oct.h>

#include "Cost_fcn.h"
#include "Cool_fcn.h"
#include "runner.h"

bool runner (double imp_b4_w8, double &cmin, Cost_fcn &cost_f, Cool_fcn &cool_f,
             octave_idx_type &last_time, octave_idx_type maxtime,
             Matrix &output)
{



  bool end = false;

  if (! error_state)
    {
      octave_idx_type current_time = last_time;
      // randomize.f
      while (end == false && current_time < last_time + maxtime)
        {
          current_time += 1;
    //printf ("i'm here, cost: %e\n", cost_f.get_cost ()); fflush (stdout);
          double cmax; // max acceptable cost
          cmax = cost_f.get_cost () - cool_f.get_temp () 
                 * log ((double)rand() / (double)RAND_MAX);
          bool accept;
          cost_f.cost_update (cmax, accept);
          double tnew  = cool_f.cool (cost_f.get_cost (), accept, end);
          if (tnew != cool_f.get_temp ()
              || cost_f.get_cost () < cmin * imp_b4_w8)
            {
              double cc = cost_f.get_cost ();
              cost_f.cost_full ();
              printf ("cost function mismatch: %e\n",
                      fabs ((cc - cost_f.get_cost()) / cost_f.get_cost()));
            }

          cool_f.set_temp (tnew);
          if (cost_f.get_cost () < cmin * imp_b4_w8)
            {
              printf ("after %d steps at T=%f cost: %f\n", current_time,
                      cool_f.get_temp (), cost_f.get_cost ());
              cmin = cost_f.get_cost ();

              output = cost_f.cost_inverse ();
              printf ("Normally wrote to file, cost: %f\n",
                      cost_f.get_cost ());
            }
          fflush (stdout);
        }
//      double cost_tmp = cost_f.get_cost ();
//      cost_f.cost_full ();
//      printf ("cost - cost_full = %e\n", cost_tmp - cost_f.get_cost ());
//      cost_tmp = cost_f.get_cost ();
//      cost_f.cost_full ();
//      printf ("cost - cost_full = %e\n", cost_tmp - cost_f.get_cost ());
      output = cost_f.cost_inverse ();
      last_time = current_time;
    }

  return end;
}
