
#include <cgreen/cgreen.h>

#include <octave/oct.h>
#include <iomanip>
#include <iostream>

namespace cgreen
{

  void assert_matrix_equal_with_tol_ (const Matrix &a, const char* name_a,
                                      const Matrix &b, const char* name_b,
                                      double tol)
  {

    std::ostringstream err_msg;
    bool flag_not_equal = false;
    if (a.rows () != b.rows () || a.columns () != b.columns ())
      {
        flag_not_equal = true;
        err_msg << "\tDimension mismatch:\n";
        err_msg << "\tObserved: (" << a.rows () << "x" << a.columns () << ")\n";
        err_msg << "\tExpected: (" << b.rows () << "x" << b.columns () << ")\n";
      }
    else
      {
        for (octave_idx_type i = 0; i < a.rows (); i++)
          for (octave_idx_type j = 0; j < a.columns (); j++)
            if (fabs (a(i,j) - b(i,j)) > tol)
              {
                // add "header" only in first line
                if (flag_not_equal == false)
                  err_msg << "  Location  |  Observed  |  Expected  |  Reason\n";

                flag_not_equal = true;

                // Location
                err_msg << std::setw(5) << "(" << i << "," << j << ")";
                // Observed
                err_msg << std::setw (13) << a(i,j);
                // Expected
                err_msg << std::setw (13) << b(i,j);
                // Reason
                err_msg << std::setw (13) << "Abs err " << fabs (a(i,j) - b(i,j));
                err_msg << " exceeds " << tol << "\n";
              }
      }

    assert_false_with_message (flag_not_equal,"matrix [%s] is not equal to [%s]"
                                              "\n\n%s", name_a, name_b,
                               err_msg.str ().c_str ());
  }

}
