#include "_gen/svc.h"

static const DBusGObjectInfo _gabble_svc_channel_type_filetransfer_future_object_info;

struct _GabbleSvcChannelTypeFileTransferFutureClass {
    GTypeInterface parent_class;
};

static void gabble_svc_channel_type_filetransfer_future_base_init (gpointer klass);

GType
gabble_svc_channel_type_filetransfer_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelTypeFileTransferFutureClass),
        gabble_svc_channel_type_filetransfer_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelTypeFileTransferFuture", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_channel_type_filetransfer_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* FileCollection */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_type_filetransfer_future_get_type (),
      &_gabble_svc_channel_type_filetransfer_future_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Type.FileTransfer.FUTURE");
  properties[0].name = g_quark_from_static_string ("FileCollection");
  properties[0].type = G_TYPE_STRING;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE, &interface);

}
static void
gabble_svc_channel_type_filetransfer_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_type_filetransfer_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_type_filetransfer_future_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_channel_type_filetransfer_future_object_info = {
  0,
  _gabble_svc_channel_type_filetransfer_future_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_future_object_info;

struct _GabbleSvcConnectionFUTUREClass {
    GTypeInterface parent_class;
    gabble_svc_connection_future_ensure_sidecar_impl ensure_sidecar_cb;
};

static void gabble_svc_connection_future_base_init (gpointer klass);

GType
gabble_svc_connection_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionFUTUREClass),
        gabble_svc_connection_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionFUTURE", &info, 0);
    }

  return type;
}

static void
gabble_svc_connection_future_ensure_sidecar (GabbleSvcConnectionFUTURE *self,
    const gchar *in_Main_Interface,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_future_ensure_sidecar_impl impl = (GABBLE_SVC_CONNECTION_FUTURE_GET_CLASS (self)->ensure_sidecar_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Main_Interface,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_connection_future_implement_ensure_sidecar (GabbleSvcConnectionFUTUREClass *klass, gabble_svc_connection_future_ensure_sidecar_impl impl)
{
  klass->ensure_sidecar_cb = impl;
}

static inline void
gabble_svc_connection_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_connection_future_get_type (),
      &_gabble_svc_connection_future_object_info);

}
static void
gabble_svc_connection_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_future_methods[] = {
  { (GCallback) gabble_svc_connection_future_ensure_sidecar, g_cclosure_marshal_generic, 0 },
};

static const DBusGObjectInfo _gabble_svc_connection_future_object_info = {
  0,
  _gabble_svc_connection_future_methods,
  1,
"org.freedesktop.Telepathy.Connection.FUTURE\0EnsureSidecar\0A\0Main_Interface\0I\0s\0Path\0O\0F\0N\0o\0Properties\0O\0F\0N\0a{sv}\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_interface_addressing_object_info;

struct _GabbleSvcConnectionInterfaceAddressingClass {
    GTypeInterface parent_class;
    gabble_svc_connection_interface_addressing_get_contacts_by_vcard_field_impl get_contacts_by_vcard_field_cb;
    gabble_svc_connection_interface_addressing_get_contacts_by_uri_impl get_contacts_by_uri_cb;
};

static void gabble_svc_connection_interface_addressing_base_init (gpointer klass);

GType
gabble_svc_connection_interface_addressing_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionInterfaceAddressingClass),
        gabble_svc_connection_interface_addressing_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionInterfaceAddressing", &info, 0);
    }

  return type;
}

static void
gabble_svc_connection_interface_addressing_get_contacts_by_vcard_field (GabbleSvcConnectionInterfaceAddressing *self,
    const gchar *in_Field,
    const gchar **in_Addresses,
    const gchar **in_Interfaces,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_addressing_get_contacts_by_vcard_field_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_ADDRESSING_GET_CLASS (self)->get_contacts_by_vcard_field_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Field,
        in_Addresses,
        in_Interfaces,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_connection_interface_addressing_implement_get_contacts_by_vcard_field (GabbleSvcConnectionInterfaceAddressingClass *klass, gabble_svc_connection_interface_addressing_get_contacts_by_vcard_field_impl impl)
{
  klass->get_contacts_by_vcard_field_cb = impl;
}

static void
gabble_svc_connection_interface_addressing_get_contacts_by_uri (GabbleSvcConnectionInterfaceAddressing *self,
    const gchar **in_URIs,
    const gchar **in_Interfaces,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_addressing_get_contacts_by_uri_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_ADDRESSING_GET_CLASS (self)->get_contacts_by_uri_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_URIs,
        in_Interfaces,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_connection_interface_addressing_implement_get_contacts_by_uri (GabbleSvcConnectionInterfaceAddressingClass *klass, gabble_svc_connection_interface_addressing_get_contacts_by_uri_impl impl)
{
  klass->get_contacts_by_uri_cb = impl;
}

static inline void
gabble_svc_connection_interface_addressing_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_connection_interface_addressing_get_type (),
      &_gabble_svc_connection_interface_addressing_object_info);

}
static void
gabble_svc_connection_interface_addressing_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_interface_addressing_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_interface_addressing_methods[] = {
  { (GCallback) gabble_svc_connection_interface_addressing_get_contacts_by_vcard_field, g_cclosure_marshal_generic, 0 },
  { (GCallback) gabble_svc_connection_interface_addressing_get_contacts_by_uri, g_cclosure_marshal_generic, 176 },
};

static const DBusGObjectInfo _gabble_svc_connection_interface_addressing_object_info = {
  0,
  _gabble_svc_connection_interface_addressing_methods,
  2,
"org.freedesktop.Telepathy.Connection.Interface.Addressing1\0GetContactsByVCardField\0A\0Field\0I\0s\0Addresses\0I\0as\0Interfaces\0I\0as\0Requested\0O\0F\0N\0a{su}\0Attributes\0O\0F\0N\0a{ua{sv}}\0\0org.freedesktop.Telepathy.Connection.Interface.Addressing1\0GetContactsByURI\0A\0URIs\0I\0as\0Interfaces\0I\0as\0Requested\0O\0F\0N\0a{su}\0Attributes\0O\0F\0N\0a{ua{sv}}\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_interface_gabble_decloak_object_info;

struct _GabbleSvcConnectionInterfaceGabbleDecloakClass {
    GTypeInterface parent_class;
    gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl send_directed_presence_cb;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested,
    N_CONNECTION_INTERFACE_GABBLE_DECLOAK_SIGNALS
};
static guint connection_interface_gabble_decloak_signals[N_CONNECTION_INTERFACE_GABBLE_DECLOAK_SIGNALS] = {0};

static void gabble_svc_connection_interface_gabble_decloak_base_init (gpointer klass);

GType
gabble_svc_connection_interface_gabble_decloak_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionInterfaceGabbleDecloakClass),
        gabble_svc_connection_interface_gabble_decloak_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionInterfaceGabbleDecloak", &info, 0);
    }

  return type;
}

static void
gabble_svc_connection_interface_gabble_decloak_send_directed_presence (GabbleSvcConnectionInterfaceGabbleDecloak *self,
    guint in_Contact,
    gboolean in_Full,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK_GET_CLASS (self)->send_directed_presence_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact,
        in_Full,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_connection_interface_gabble_decloak_implement_send_directed_presence (GabbleSvcConnectionInterfaceGabbleDecloakClass *klass, gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl impl)
{
  klass->send_directed_presence_cb = impl;
}

void
gabble_svc_connection_interface_gabble_decloak_emit_decloak_requested (gpointer instance,
    guint arg_Contact,
    const gchar *arg_Reason,
    gboolean arg_Decloaked)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK));
  g_signal_emit (instance,
      connection_interface_gabble_decloak_signals[SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested],
      0,
      arg_Contact,
      arg_Reason,
      arg_Decloaked);
}

static inline void
gabble_svc_connection_interface_gabble_decloak_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ | TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE, "b", 0, NULL, NULL }, /* DecloakAutomatically */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_connection_interface_gabble_decloak_get_type (),
      &_gabble_svc_connection_interface_gabble_decloak_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak");
  properties[0].name = g_quark_from_static_string ("DecloakAutomatically");
  properties[0].type = G_TYPE_BOOLEAN;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK, &interface);

  connection_interface_gabble_decloak_signals[SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested] =
  g_signal_new ("decloak-requested",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_BOOLEAN);

}
static void
gabble_svc_connection_interface_gabble_decloak_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_interface_gabble_decloak_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_interface_gabble_decloak_methods[] = {
  { (GCallback) gabble_svc_connection_interface_gabble_decloak_send_directed_presence, g_cclosure_marshal_generic, 0 },
};

static const DBusGObjectInfo _gabble_svc_connection_interface_gabble_decloak_object_info = {
  0,
  _gabble_svc_connection_interface_gabble_decloak_methods,
  1,
"org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak\0SendDirectedPresence\0A\0Contact\0I\0u\0Full\0I\0b\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak\0DecloakRequested\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_console_object_info;

struct _GabbleSvcGabblePluginConsoleClass {
    GTypeInterface parent_class;
    gabble_svc_gabble_plugin_console_send_iq_impl send_iq_cb;
    gabble_svc_gabble_plugin_console_send_stanza_impl send_stanza_cb;
};

enum {
    SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaSent,
    SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaReceived,
    N_GABBLE_PLUGIN_CONSOLE_SIGNALS
};
static guint gabble_plugin_console_signals[N_GABBLE_PLUGIN_CONSOLE_SIGNALS] = {0};

static void gabble_svc_gabble_plugin_console_base_init (gpointer klass);

GType
gabble_svc_gabble_plugin_console_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcGabblePluginConsoleClass),
        gabble_svc_gabble_plugin_console_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcGabblePluginConsole", &info, 0);
    }

  return type;
}

static void
gabble_svc_gabble_plugin_console_send_iq (GabbleSvcGabblePluginConsole *self,
    const gchar *in_Type,
    const gchar *in_To,
    const gchar *in_Body,
    DBusGMethodInvocation *context)
{
  gabble_svc_gabble_plugin_console_send_iq_impl impl = (GABBLE_SVC_GABBLE_PLUGIN_CONSOLE_GET_CLASS (self)->send_iq_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Type,
        in_To,
        in_Body,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_gabble_plugin_console_implement_send_iq (GabbleSvcGabblePluginConsoleClass *klass, gabble_svc_gabble_plugin_console_send_iq_impl impl)
{
  klass->send_iq_cb = impl;
}

static void
gabble_svc_gabble_plugin_console_send_stanza (GabbleSvcGabblePluginConsole *self,
    const gchar *in_Stanza,
    DBusGMethodInvocation *context)
{
  gabble_svc_gabble_plugin_console_send_stanza_impl impl = (GABBLE_SVC_GABBLE_PLUGIN_CONSOLE_GET_CLASS (self)->send_stanza_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Stanza,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_gabble_plugin_console_implement_send_stanza (GabbleSvcGabblePluginConsoleClass *klass, gabble_svc_gabble_plugin_console_send_stanza_impl impl)
{
  klass->send_stanza_cb = impl;
}

void
gabble_svc_gabble_plugin_console_emit_stanza_sent (gpointer instance,
    const gchar *arg_Stanza)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_GABBLE_PLUGIN_CONSOLE));
  g_signal_emit (instance,
      gabble_plugin_console_signals[SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaSent],
      0,
      arg_Stanza);
}

void
gabble_svc_gabble_plugin_console_emit_stanza_received (gpointer instance,
    const gchar *arg_Stanza)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_GABBLE_PLUGIN_CONSOLE));
  g_signal_emit (instance,
      gabble_plugin_console_signals[SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaReceived],
      0,
      arg_Stanza);
}

static inline void
gabble_svc_gabble_plugin_console_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ | TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE | TP_DBUS_PROPERTIES_MIXIN_FLAG_EMITS_CHANGED, "b", 0, NULL, NULL }, /* SpewStanzas */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_gabble_plugin_console_get_type (),
      &_gabble_svc_gabble_plugin_console_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Gabble.Plugin.Console");
  properties[0].name = g_quark_from_static_string ("SpewStanzas");
  properties[0].type = G_TYPE_BOOLEAN;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_GABBLE_PLUGIN_CONSOLE, &interface);

  gabble_plugin_console_signals[SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaSent] =
  g_signal_new ("stanza-sent",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      1,
      G_TYPE_STRING);

  gabble_plugin_console_signals[SIGNAL_GABBLE_PLUGIN_CONSOLE_StanzaReceived] =
  g_signal_new ("stanza-received",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      1,
      G_TYPE_STRING);

}
static void
gabble_svc_gabble_plugin_console_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_gabble_plugin_console_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_gabble_plugin_console_methods[] = {
  { (GCallback) gabble_svc_gabble_plugin_console_send_iq, g_cclosure_marshal_generic, 0 },
  { (GCallback) gabble_svc_gabble_plugin_console_send_stanza, g_cclosure_marshal_generic, 115 },
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_console_object_info = {
  0,
  _gabble_svc_gabble_plugin_console_methods,
  2,
"org.freedesktop.Telepathy.Gabble.Plugin.Console\0SendIQ\0A\0Type\0I\0s\0To\0I\0s\0Body\0I\0s\0Reply_Type\0O\0F\0N\0s\0Body\0O\0F\0N\0s\0\0org.freedesktop.Telepathy.Gabble.Plugin.Console\0SendStanza\0A\0Stanza\0I\0s\0\0\0",
"org.freedesktop.Telepathy.Gabble.Plugin.Console\0StanzaSent\0org.freedesktop.Telepathy.Gabble.Plugin.Console\0StanzaReceived\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_gateways_object_info;

struct _GabbleSvcGabblePluginGatewaysClass {
    GTypeInterface parent_class;
    gabble_svc_gabble_plugin_gateways_register_impl register_cb;
};

static void gabble_svc_gabble_plugin_gateways_base_init (gpointer klass);

GType
gabble_svc_gabble_plugin_gateways_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcGabblePluginGatewaysClass),
        gabble_svc_gabble_plugin_gateways_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcGabblePluginGateways", &info, 0);
    }

  return type;
}

static void
gabble_svc_gabble_plugin_gateways_register (GabbleSvcGabblePluginGateways *self,
    const gchar *in_Gateway,
    const gchar *in_Username,
    const gchar *in_Password,
    DBusGMethodInvocation *context)
{
  gabble_svc_gabble_plugin_gateways_register_impl impl = (GABBLE_SVC_GABBLE_PLUGIN_GATEWAYS_GET_CLASS (self)->register_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Gateway,
        in_Username,
        in_Password,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_gabble_plugin_gateways_implement_register (GabbleSvcGabblePluginGatewaysClass *klass, gabble_svc_gabble_plugin_gateways_register_impl impl)
{
  klass->register_cb = impl;
}

static inline void
gabble_svc_gabble_plugin_gateways_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_gabble_plugin_gateways_get_type (),
      &_gabble_svc_gabble_plugin_gateways_object_info);

}
static void
gabble_svc_gabble_plugin_gateways_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_gabble_plugin_gateways_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_gabble_plugin_gateways_methods[] = {
  { (GCallback) gabble_svc_gabble_plugin_gateways_register, g_cclosure_marshal_generic, 0 },
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_gateways_object_info = {
  0,
  _gabble_svc_gabble_plugin_gateways_methods,
  1,
"org.freedesktop.Telepathy.Gabble.Plugin.Gateways\0Register\0A\0Gateway\0I\0s\0Username\0I\0s\0Password\0I\0s\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_test_object_info;

struct _GabbleSvcGabblePluginTestClass {
    GTypeInterface parent_class;
};

static void gabble_svc_gabble_plugin_test_base_init (gpointer klass);

GType
gabble_svc_gabble_plugin_test_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcGabblePluginTestClass),
        gabble_svc_gabble_plugin_test_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcGabblePluginTest", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_gabble_plugin_test_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_gabble_plugin_test_get_type (),
      &_gabble_svc_gabble_plugin_test_object_info);

}
static void
gabble_svc_gabble_plugin_test_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_gabble_plugin_test_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_gabble_plugin_test_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_test_object_info = {
  0,
  _gabble_svc_gabble_plugin_test_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_olpc_activity_properties_object_info;

struct _GabbleSvcOLPCActivityPropertiesClass {
    GTypeInterface parent_class;
    gabble_svc_olpc_activity_properties_set_properties_impl set_properties_cb;
    gabble_svc_olpc_activity_properties_get_properties_impl get_properties_cb;
    gabble_svc_olpc_activity_properties_get_activity_impl get_activity_cb;
};

enum {
    SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged,
    N_OLPC_ACTIVITY_PROPERTIES_SIGNALS
};
static guint olpc_activity_properties_signals[N_OLPC_ACTIVITY_PROPERTIES_SIGNALS] = {0};

static void gabble_svc_olpc_activity_properties_base_init (gpointer klass);

GType
gabble_svc_olpc_activity_properties_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcOLPCActivityPropertiesClass),
        gabble_svc_olpc_activity_properties_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcOLPCActivityProperties", &info, 0);
    }

  return type;
}

static void
gabble_svc_olpc_activity_properties_set_properties (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    GHashTable *in_properties,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_set_properties_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->set_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_room,
        in_properties,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_activity_properties_implement_set_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_set_properties_impl impl)
{
  klass->set_properties_cb = impl;
}

static void
gabble_svc_olpc_activity_properties_get_properties (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_get_properties_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->get_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_room,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_activity_properties_implement_get_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_properties_impl impl)
{
  klass->get_properties_cb = impl;
}

static void
gabble_svc_olpc_activity_properties_get_activity (GabbleSvcOLPCActivityProperties *self,
    const gchar *in_activity_id,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_get_activity_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->get_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activity_id,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_activity_properties_implement_get_activity (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_activity_impl impl)
{
  klass->get_activity_cb = impl;
}

void
gabble_svc_olpc_activity_properties_emit_activity_properties_changed (gpointer instance,
    guint arg_room,
    GHashTable *arg_properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES));
  g_signal_emit (instance,
      olpc_activity_properties_signals[SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged],
      0,
      arg_room,
      arg_properties);
}

static inline void
gabble_svc_olpc_activity_properties_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_olpc_activity_properties_get_type (),
      &_gabble_svc_olpc_activity_properties_object_info);

  olpc_activity_properties_signals[SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged] =
  g_signal_new ("activity-properties-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

}
static void
gabble_svc_olpc_activity_properties_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_olpc_activity_properties_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_olpc_activity_properties_methods[] = {
  { (GCallback) gabble_svc_olpc_activity_properties_set_properties, g_cclosure_marshal_generic, 0 },
  { (GCallback) gabble_svc_olpc_activity_properties_get_properties, g_cclosure_marshal_generic, 85 },
  { (GCallback) gabble_svc_olpc_activity_properties_get_activity, g_cclosure_marshal_generic, 174 },
};

static const DBusGObjectInfo _gabble_svc_olpc_activity_properties_object_info = {
  0,
  _gabble_svc_olpc_activity_properties_methods,
  3,
"org.laptop.Telepathy.ActivityProperties\0SetProperties\0A\0room\0I\0u\0properties\0I\0a{sv}\0\0org.laptop.Telepathy.ActivityProperties\0GetProperties\0A\0room\0I\0u\0properties\0O\0F\0N\0a{sv}\0\0org.laptop.Telepathy.ActivityProperties\0GetActivity\0A\0activity_id\0I\0s\0room\0O\0F\0N\0u\0\0\0",
"org.laptop.Telepathy.ActivityProperties\0ActivityPropertiesChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_olpc_buddy_info_object_info;

struct _GabbleSvcOLPCBuddyInfoClass {
    GTypeInterface parent_class;
    gabble_svc_olpc_buddy_info_set_properties_impl set_properties_cb;
    gabble_svc_olpc_buddy_info_get_properties_impl get_properties_cb;
    gabble_svc_olpc_buddy_info_set_activities_impl set_activities_cb;
    gabble_svc_olpc_buddy_info_add_activity_impl add_activity_cb;
    gabble_svc_olpc_buddy_info_get_activities_impl get_activities_cb;
    gabble_svc_olpc_buddy_info_set_current_activity_impl set_current_activity_cb;
    gabble_svc_olpc_buddy_info_get_current_activity_impl get_current_activity_cb;
};

enum {
    SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged,
    SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged,
    SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged,
    N_OLPC_BUDDY_INFO_SIGNALS
};
static guint olpc_buddy_info_signals[N_OLPC_BUDDY_INFO_SIGNALS] = {0};

static void gabble_svc_olpc_buddy_info_base_init (gpointer klass);

GType
gabble_svc_olpc_buddy_info_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcOLPCBuddyInfoClass),
        gabble_svc_olpc_buddy_info_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcOLPCBuddyInfo", &info, 0);
    }

  return type;
}

static void
gabble_svc_olpc_buddy_info_set_properties (GabbleSvcOLPCBuddyInfo *self,
    GHashTable *in_properties,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_properties_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_properties,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_set_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_properties_impl impl)
{
  klass->set_properties_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_get_properties (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_properties_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_get_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_properties_impl impl)
{
  klass->get_properties_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_set_activities (GabbleSvcOLPCBuddyInfo *self,
    const GPtrArray *in_activities,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_activities_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_activities_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activities,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_set_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_activities_impl impl)
{
  klass->set_activities_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_add_activity (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_id,
    guint in_handle,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_add_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->add_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_id,
        in_handle,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_add_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_add_activity_impl impl)
{
  klass->add_activity_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_get_activities (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_activities_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_activities_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_get_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_activities_impl impl)
{
  klass->get_activities_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_set_current_activity (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_activity,
    guint in_channel,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_current_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_current_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activity,
        in_channel,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_set_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_current_activity_impl impl)
{
  klass->set_current_activity_cb = impl;
}

static void
gabble_svc_olpc_buddy_info_get_current_activity (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_current_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_current_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
gabble_svc_olpc_buddy_info_implement_get_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_current_activity_impl impl)
{
  klass->get_current_activity_cb = impl;
}

void
gabble_svc_olpc_buddy_info_emit_properties_changed (gpointer instance,
    guint arg_contact,
    GHashTable *arg_properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged],
      0,
      arg_contact,
      arg_properties);
}

void
gabble_svc_olpc_buddy_info_emit_activities_changed (gpointer instance,
    guint arg_contact,
    const GPtrArray *arg_activities)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged],
      0,
      arg_contact,
      arg_activities);
}

void
gabble_svc_olpc_buddy_info_emit_current_activity_changed (gpointer instance,
    guint arg_contact,
    const gchar *arg_activity,
    guint arg_channel)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged],
      0,
      arg_contact,
      arg_activity,
      arg_channel);
}

static inline void
gabble_svc_olpc_buddy_info_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_olpc_buddy_info_get_type (),
      &_gabble_svc_olpc_buddy_info_object_info);

  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged] =
  g_signal_new ("properties-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged] =
  g_signal_new ("activities-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))));

  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged] =
  g_signal_new ("current-activity-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_UINT);

}
static void
gabble_svc_olpc_buddy_info_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_olpc_buddy_info_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_olpc_buddy_info_methods[] = {
  { (GCallback) gabble_svc_olpc_buddy_info_set_properties, g_cclosure_marshal_generic, 0 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_properties, g_cclosure_marshal_generic, 67 },
  { (GCallback) gabble_svc_olpc_buddy_info_set_activities, g_cclosure_marshal_generic, 150 },
  { (GCallback) gabble_svc_olpc_buddy_info_add_activity, g_cclosure_marshal_generic, 217 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_activities, g_cclosure_marshal_generic, 281 },
  { (GCallback) gabble_svc_olpc_buddy_info_set_current_activity, g_cclosure_marshal_generic, 364 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_current_activity, g_cclosure_marshal_generic, 442 },
};

static const DBusGObjectInfo _gabble_svc_olpc_buddy_info_object_info = {
  0,
  _gabble_svc_olpc_buddy_info_methods,
  7,
"org.laptop.Telepathy.BuddyInfo\0SetProperties\0A\0properties\0I\0a{sv}\0\0org.laptop.Telepathy.BuddyInfo\0GetProperties\0A\0contact\0I\0u\0properties\0O\0F\0N\0a{sv}\0\0org.laptop.Telepathy.BuddyInfo\0SetActivities\0A\0activities\0I\0a(su)\0\0org.laptop.Telepathy.BuddyInfo\0AddActivity\0A\0id\0I\0s\0handle\0I\0u\0\0org.laptop.Telepathy.BuddyInfo\0GetActivities\0A\0contact\0I\0u\0activities\0O\0F\0N\0a(su)\0\0org.laptop.Telepathy.BuddyInfo\0SetCurrentActivity\0A\0activity\0I\0s\0channel\0I\0u\0\0org.laptop.Telepathy.BuddyInfo\0GetCurrentActivity\0A\0contact\0I\0u\0activity\0O\0F\0N\0s\0channel\0O\0F\0N\0u\0\0\0",
"org.laptop.Telepathy.BuddyInfo\0PropertiesChanged\0org.laptop.Telepathy.BuddyInfo\0ActivitiesChanged\0org.laptop.Telepathy.BuddyInfo\0CurrentActivityChanged\0\0",
"\0\0",
};


