/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   KeySym *
 *   XGetKeyboardMapping(display, first_keycode, keycode_count, keysyms_per_keycode_return)
 *   Display	*display;
 *   KeyCode	first_keycode;
 *   int 	keycode_count;
 *   int 	*keysyms_per_keycode_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetKeyboardMapping	1
char    *TestName = "XGetKeyboardMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetKeyboardMapping function
 */
static Display	*display;
static KeyCode	first_keycode;
static int 	keycode_count;
static int 	*keysyms_per_keycode_return;



#define	MAXKPK	5	/* Maximum keysyms_per_keyocde we will use */
#define	MAXCODES 255	/* Max number of keycodes we will use */

static	KeyCode	First;
static	int 	ncodes;
static	int 	kpk;	/* Keysyms per keycode */
static	int 	oldkpk;	/* old Keysyms per keycode */
static	KeySym	*oldkeym;

/*
 * Can't really assume that there are any particular keysym names defined so
 * we use our own arbitrary values.
 */
#define	XT_KSYM1	0x5678
#define	XT_KSYM2	0x9228
#define	XT_KSYM3	0x4425
#define	XT_KSYM4	0x5326

static	KeySym	Keys[MAXKPK*MAXCODES];

/*
 * Set startup and cleanup functions to save and restore
 * the original keyboard map.
 */
static void
savekeymap()
{
int	tmp;
int 	last;
int 	i;

	startup();

	if (Dsp==NULL)
		return;

	XDisplayKeycodes(Dsp, &tmp, &last);
	ncodes = last-tmp;
	First = (KeyCode)tmp;

	debug(2, "First keycode  :%d", First);
	debug(2, "Last keycode   :%d", last);
	debug(2, "Number of codes:%d", ncodes);

	oldkeym = XGetKeyboardMapping(Dsp, First, ncodes, &oldkpk);

	/*
	 * Initialise the keysym table.
	 */
	for (i = 0; i < MAXKPK*MAXCODES-4; i += 4) {
		Keys[i] = XT_KSYM1;
		Keys[i+1] = XT_KSYM2;
		Keys[i+2] = XT_KSYM3;
		Keys[i+3] = XT_KSYM4;
	}
}

static void
cleankeymap()
{
	if (Dsp) {
		XChangeKeyboardMapping(Dsp, First, oldkpk, oldkeym, ncodes);
		XFree((char*) oldkeym);
	}

	cleanup();
}



int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	first_keycode = First;
	keycode_count = ncodes;
	keysyms_per_keycode_return = &kpk;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	i, j;
int 	syms_per_code;
KeySym	*newmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetKeyboardMapping-1.(A)");
	report_assertion("A call to XGetKeyboardMapping returns an array, that can be");
	report_assertion("freed with XFree, of KeySyms associated with the specified");
	report_assertion("number, keycode_count, of KeyCodes starting with");
	report_assertion("first_keycode.");

	report_strategy("Set some KeySyms with XChangeKeyboardMapping.");
	report_strategy("Call XGetKeyboardMapping to get KeySyms.");
	report_strategy("Verify they are as set.");
	report_strategy("Free returned array with XFree.");

	tpstartup();
	setargs();
	first_keycode = First+3;
	syms_per_code = 3;
	keycode_count = 9;

	XChangeKeyboardMapping(display, first_keycode, syms_per_code, Keys, keycode_count);
	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	newmap = XGetKeyboardMapping(display, first_keycode, keycode_count, keysyms_per_keycode_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 0; i < keycode_count; i++) {
		for (j = 0; j < syms_per_code; j++) {
			if (Keys[i*syms_per_code+j] ==
				  newmap[i*keysyms_per_keycode_return[0]+j])
				CHECK;
			else {
				report("Keysym for keycode %d was 0x%x, expecting 0x%x",
					first_keycode+i,
					newmap[i*keysyms_per_keycode_return[0]+j],
					Keys[i*syms_per_code+j]
					);
				FAIL;
				break;	/* probably pointless to continue */
			}
		}
	}

	XFree((char*)newmap);

	CHECKPASS(syms_per_code*keycode_count);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XGetKeyboardMapping-2.(-)");
	report_assertion("On a call to XGetKeyboardMapping the returned KeySyms list");
	report_assertion("contains keycode_count*keysyms_per_keycode_return");
	report_assertion("elements.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

int 	syms_per_code = 6;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetKeyboardMapping-3.(A)");
	report_assertion("On a call to XGetKeyboardMapping keysyms_per_keycode_return");
	report_assertion("is set to a value that is large enough to report all of the");
	report_assertion("KeySyms for any of the requested KeyCodes.");

	report_strategy("Set KeySyms with XChangeKeyboardMapping.");
	report_strategy("Call XGetKeyboardMapping to get new value of this parameter.");
	report_strategy("Verify that it is at least as large as set.");

	tpstartup();
	setargs();
	/*
	 * I don't know a really good test for this.
	 */
	XChangeKeyboardMapping(display, first_keycode, syms_per_code, Keys, keycode_count);
	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XGetKeyboardMapping(display, first_keycode, keycode_count, keysyms_per_keycode_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (keysyms_per_keycode_return[0] >= syms_per_code)
		CHECK;
	else {
		report("keysyms_per_keycode_return was unexpected");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XGetKeyboardMapping-4.(-)");
	report_assertion("When an element for a particular KeyCode is unused, then a");
	report_assertion("KeySym value of NoSymbol is used in the returned array.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetKeyboardMapping-5.(A)");
	report_assertion("When the value specified in first_keycode is less than the");
	report_assertion("minimum keycode as returned by XDisplayKeycodes, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set first_keycode to less than the minimum keycode.");
	report_strategy("Call XGetKeyboardMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	first_keycode = First-1;

	startcall(display);
	if (isdeleted())
		return;
	XGetKeyboardMapping(display, first_keycode, keycode_count, keysyms_per_keycode_return);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGetKeyboardMapping-6.(A)");
	report_assertion("When the expression first_keycode+keycode_count-1 is");
	report_assertion("greater than the maximum keycode as returned by");
	report_assertion("XDisplayKeycodes, then a BadValue error occurs.");

	report_strategy("Set first keycode to greater than the maximum keycode.");
	report_strategy("Call XGetKeyboardMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	first_keycode = First+ncodes;

	startcall(display);
	if (isdeleted())
		return;
	XGetKeyboardMapping(display, first_keycode, keycode_count, keysyms_per_keycode_return);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savekeymap;
void	(*tet_cleanup)() = cleankeymap;
